/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceLocatorDiscovery;

import com.zeroc.Ice.BlobjectAsync;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointInfo;
import com.zeroc.Ice.IPEndpointInfo;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.Locator;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.LocatorRegistryPrx;
import com.zeroc.Ice.NoEndpointException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectAdapterDeactivatedException;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.RequestFailedException;
import com.zeroc.Ice.UDPEndpointInfo;
import com.zeroc.Ice.UnknownException;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.Time;
import com.zeroc.IceInternal.Util;
import com.zeroc.IceLocatorDiscovery.LookupPrx;
import com.zeroc.IceLocatorDiscovery.LookupReply;
import com.zeroc.IceLocatorDiscovery.LookupReplyPrx;
import com.zeroc.IceLocatorDiscovery.Plugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class PluginI
implements Plugin {
    private String _name;
    private Communicator _communicator;
    private ObjectAdapter _locatorAdapter;
    private ObjectAdapter _replyAdapter;
    private LocatorI _locator;
    private LocatorPrx _locatorPrx;
    private LocatorPrx _defaultLocator;

    public PluginI(String name, Communicator communicator) {
        this._name = name;
        this._communicator = communicator;
    }

    @Override
    public void initialize() {
        Properties properties = this._communicator.getProperties();
        boolean ipv4 = properties.getPropertyAsIntWithDefault("Ice.IPv4", 1) > 0;
        boolean preferIPv6 = properties.getPropertyAsInt("Ice.PreferIPv6Address") > 0;
        String address = ipv4 && !preferIPv6 ? properties.getPropertyWithDefault(this._name + ".Address", "239.255.0.1") : properties.getPropertyWithDefault(this._name + ".Address", "ff15::1");
        int port = properties.getPropertyAsIntWithDefault(this._name + ".Port", 4061);
        String intf = properties.getProperty(this._name + ".Interface");
        String lookupEndpoints = properties.getProperty(this._name + ".Lookup");
        if (lookupEndpoints.isEmpty()) {
            int protocol = ipv4 && !preferIPv6 ? 0 : 1;
            List<String> interfaces = Network.getInterfacesForMulticast(intf, protocol);
            for (String p : interfaces) {
                if (p != interfaces.get(0)) {
                    lookupEndpoints = lookupEndpoints + ":";
                }
                lookupEndpoints = lookupEndpoints + "udp -h \"" + address + "\" -p " + port + " --interface \"" + p + "\"";
            }
        }
        if (properties.getProperty(this._name + ".Reply.Endpoints").isEmpty()) {
            properties.setProperty(this._name + ".Reply.Endpoints", "udp -h " + (intf.isEmpty() ? "*" : "\"" + intf + "\""));
        }
        if (properties.getProperty(this._name + ".Locator.Endpoints").isEmpty()) {
            properties.setProperty(this._name + ".Locator.AdapterId", UUID.randomUUID().toString());
        }
        this._replyAdapter = this._communicator.createObjectAdapter(this._name + ".Reply");
        this._locatorAdapter = this._communicator.createObjectAdapter(this._name + ".Locator");
        this._replyAdapter.setLocator(null);
        this._locatorAdapter.setLocator(null);
        ObjectPrx lookupPrx = this._communicator.stringToProxy("IceLocatorDiscovery/Lookup -d:" + lookupEndpoints);
        lookupPrx = lookupPrx.ice_collocationOptimized(false).ice_router(null);
        LocatorPrx voidLoc = LocatorPrx.uncheckedCast(this._locatorAdapter.addWithUUID(new VoidLocatorI()));
        String instanceName = properties.getProperty(this._name + ".InstanceName");
        Identity id = new Identity();
        id.name = "Locator";
        id.category = !instanceName.isEmpty() ? instanceName : UUID.randomUUID().toString();
        this._locator = new LocatorI(this._name, LookupPrx.uncheckedCast(lookupPrx), properties, instanceName, voidLoc);
        this._defaultLocator = this._communicator.getDefaultLocator();
        this._locatorPrx = LocatorPrx.uncheckedCast(this._locatorAdapter.addWithUUID(this._locator));
        this._communicator.setDefaultLocator(this._locatorPrx);
        ObjectPrx lookupReply = this._replyAdapter.addWithUUID(new LookupReplyI(this._locator)).ice_datagram();
        this._locator.setLookupReply(LookupReplyPrx.uncheckedCast(lookupReply));
        this._replyAdapter.activate();
        this._locatorAdapter.activate();
    }

    @Override
    public void destroy() {
        if (this._replyAdapter != null) {
            this._replyAdapter.destroy();
        }
        if (this._locatorAdapter != null) {
            this._locatorAdapter.destroy();
        }
        if (this._communicator.getDefaultLocator().equals(this._locatorPrx)) {
            this._communicator.setDefaultLocator(this._defaultLocator);
        }
    }

    @Override
    public List<LocatorPrx> getLocators(String instanceName, int waitTime) {
        return this._locator.getLocators(instanceName, waitTime);
    }

    private static class VoidLocatorI
    implements Locator {
        private VoidLocatorI() {
        }

        @Override
        public CompletionStage<ObjectPrx> findObjectByIdAsync(Identity id, Current current) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage<ObjectPrx> findAdapterByIdAsync(String id, Current current) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public LocatorRegistryPrx getRegistry(Current current) {
            return null;
        }
    }

    private static class LocatorI
    implements BlobjectAsync {
        private Runnable _retryTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocatorI locatorI = this;
                synchronized (locatorI) {
                    if (!_pending) {
                        assert (_pendingRequests.isEmpty());
                        return;
                    }
                    if (_pendingRetryCount > 0) {
                        --_pendingRetryCount;
                        try {
                            if (_traceLevel > 1) {
                                StringBuilder s = new StringBuilder("retrying locator lookup:\nlookup = ");
                                s.append(_lookup);
                                s.append("\nretry count = ").append(_retryCount);
                                if (!_instanceName.isEmpty()) {
                                    s.append("\ninstance name = ").append(_instanceName);
                                }
                                _lookup.ice_getCommunicator().getLogger().trace("Lookup", s.toString());
                            }
                            _failureCount = 0;
                            for (Map.Entry entry : _lookups.entrySet()) {
                                ((LookupPrx)entry.getKey()).findLocatorAsync(_instanceName, (LookupReplyPrx)entry.getValue()).whenCompleteAsync((v, ex) -> {
                                    if (ex != null) {
                                        this.exception((Throwable)ex);
                                    }
                                }, ((LookupPrx)entry.getKey()).ice_executor());
                            }
                            _future = _timer.schedule(_retryTask, (long)_timeout, TimeUnit.MILLISECONDS);
                            return;
                        }
                        catch (LocalException s) {
                            _pendingRetryCount = 0;
                        }
                    }
                    assert (_pendingRetryCount == 0);
                    _pending = false;
                    if (_traceLevel > 0) {
                        StringBuilder s = new StringBuilder("locator lookup timed out:\nlookup = ");
                        s.append(_lookup);
                        if (!_instanceName.isEmpty()) {
                            s.append("\ninstance name = ").append(_instanceName);
                        }
                        _lookup.ice_getCommunicator().getLogger().trace("Lookup", s.toString());
                    }
                    if (_pendingRequests.isEmpty()) {
                        this.notify();
                    } else {
                        for (Request request : _pendingRequests) {
                            request.invoke(_voidLocator);
                        }
                        _pendingRequests.clear();
                    }
                    _nextRetry = Time.currentMonotonicTimeMillis() + (long)_retryDelay;
                }
            }
        };
        private final LookupPrx _lookup;
        private final Map<LookupPrx, LookupReplyPrx> _lookups = new HashMap<LookupPrx, LookupReplyPrx>();
        private int _timeout;
        private Future<?> _future;
        private final ScheduledExecutorService _timer;
        private final int _traceLevel;
        private int _retryCount;
        private int _retryDelay;
        private String _instanceName;
        private boolean _warned;
        private LocatorPrx _locator;
        private LocatorPrx _voidLocator;
        private Map<String, LocatorPrx> _locators = new HashMap<String, LocatorPrx>();
        private boolean _pending;
        private int _pendingRetryCount;
        private int _failureCount;
        private boolean _warnOnce;
        private List<Request> _pendingRequests = new ArrayList<Request>();
        private long _nextRetry;

        LocatorI(String name, LookupPrx lookup, Properties properties, String instanceName, LocatorPrx voidLocator) {
            this._lookup = lookup;
            this._timeout = properties.getPropertyAsIntWithDefault(name + ".Timeout", 300);
            if (this._timeout < 0) {
                this._timeout = 300;
            }
            this._retryCount = properties.getPropertyAsIntWithDefault(name + ".RetryCount", 3);
            if (this._retryCount < 0) {
                this._retryCount = 0;
            }
            this._retryDelay = properties.getPropertyAsIntWithDefault(name + ".RetryDelay", 2000);
            if (this._retryDelay < 0) {
                this._retryDelay = 0;
            }
            this._timer = Util.getInstance(lookup.ice_getCommunicator()).timer();
            this._traceLevel = properties.getPropertyAsInt(name + ".Trace.Lookup");
            this._instanceName = instanceName;
            this._warned = false;
            this._locator = lookup.ice_getCommunicator().getDefaultLocator();
            this._voidLocator = voidLocator;
            this._pendingRetryCount = 0;
            this._pending = false;
            this._failureCount = 0;
            this._warnOnce = true;
            Endpoint[] single = new Endpoint[1];
            Endpoint[] endpointArray = lookup.ice_getEndpoints();
            int n = endpointArray.length;
            for (int i = 0; i < n; ++i) {
                Endpoint endpt;
                single[0] = endpt = endpointArray[i];
                this._lookups.put(lookup.ice_endpoints(single), null);
            }
            assert (!this._lookups.isEmpty());
        }

        public void setLookupReply(LookupReplyPrx lookupReply) {
            Endpoint[] single = new Endpoint[1];
            for (Map.Entry<LookupPrx, LookupReplyPrx> entry : this._lookups.entrySet()) {
                UDPEndpointInfo info = (UDPEndpointInfo)entry.getKey().ice_getEndpoints()[0].getInfo();
                if (!info.mcastInterface.isEmpty()) {
                    for (Endpoint q : lookupReply.ice_getEndpoints()) {
                        EndpointInfo r = q.getInfo();
                        if (!(r instanceof IPEndpointInfo) || !((IPEndpointInfo)r).host.equals(info.mcastInterface)) continue;
                        single[0] = q;
                        entry.setValue(lookupReply.ice_endpoints(single));
                    }
                }
                if (entry.getValue() != null) continue;
                entry.setValue(lookupReply);
            }
        }

        @Override
        public CompletionStage<Object.Ice_invokeResult> ice_invokeAsync(byte[] inParams, Current current) {
            CompletableFuture<Object.Ice_invokeResult> f = new CompletableFuture<Object.Ice_invokeResult>();
            this.invoke(null, new Request(this, current.operation, current.mode, inParams, current.ctx, f));
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<LocatorPrx> getLocators(String instanceName, int waitTime) {
            LocatorI locatorI;
            block13: {
                locatorI = this;
                synchronized (locatorI) {
                    this._locators.clear();
                }
                this.invoke(null, null);
                try {
                    if (instanceName.isEmpty()) {
                        Thread.sleep(waitTime);
                        break block13;
                    }
                    locatorI = this;
                    synchronized (locatorI) {
                        while (!this._locators.containsKey(instanceName) && this._pending) {
                            this.wait(waitTime);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException();
                }
            }
            locatorI = this;
            synchronized (locatorI) {
                return new ArrayList<LocatorPrx>(this._locators.values());
            }
        }

        public synchronized void foundLocator(LocatorPrx locator) {
            LocatorPrx l;
            if (locator == null) {
                if (this._traceLevel > 2) {
                    this._lookup.ice_getCommunicator().getLogger().trace("Lookup", "ignoring locator reply: (null locator)");
                }
                return;
            }
            if (!this._instanceName.isEmpty() && !locator.ice_getIdentity().category.equals(this._instanceName)) {
                if (this._traceLevel > 2) {
                    StringBuffer s = new StringBuffer("ignoring locator reply: instance name doesn't match\n");
                    s.append("expected = ").append(this._instanceName);
                    s.append("received = ").append(locator.ice_getIdentity().category);
                    this._lookup.ice_getCommunicator().getLogger().trace("Lookup", s.toString());
                }
                return;
            }
            if (!this._pendingRequests.isEmpty() && this._locator != null && !locator.ice_getIdentity().category.equals(this._locator.ice_getIdentity().category)) {
                if (!this._warned) {
                    this._warned = true;
                    locator.ice_getCommunicator().getLogger().warning("received Ice locator with different instance name:\nusing = `" + this._locator.ice_getIdentity().category + "'\nreceived = `" + locator.ice_getIdentity().category + "'\nThis is typically the case if multiple Ice locators with different instance names are deployed and the property `IceLocatorDiscovery.InstanceName'is not set.");
                }
                return;
            }
            if (this._pending) {
                this._future.cancel(false);
                this._future = null;
                this._pendingRetryCount = 0;
                this._pending = false;
            }
            if (this._traceLevel > 0) {
                StringBuffer s = new StringBuffer("locator lookup succeeded:\nlocator = ");
                s.append(locator);
                if (!this._instanceName.isEmpty()) {
                    s.append("\ninstance name = ").append(this._instanceName);
                }
                this._lookup.ice_getCommunicator().getLogger().trace("Lookup", s.toString());
            }
            LocatorPrx locatorPrx = l = this._pendingRequests.isEmpty() ? this._locators.get(locator.ice_getIdentity().category) : this._locator;
            if (l != null) {
                ArrayList<Endpoint> newEndpoints = new ArrayList<Endpoint>(Arrays.asList(l.ice_getEndpoints()));
                for (Endpoint p : locator.ice_getEndpoints()) {
                    boolean found = false;
                    for (Endpoint q : newEndpoints) {
                        if (!p.equals(q)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    newEndpoints.add(p);
                }
                l = l.ice_endpoints(newEndpoints.toArray(new Endpoint[newEndpoints.size()]));
            } else {
                l = locator;
            }
            if (this._pendingRequests.isEmpty()) {
                this._locators.put(locator.ice_getIdentity().category, l);
                this.notify();
            } else {
                this._locator = l;
                if (this._instanceName.isEmpty()) {
                    this._instanceName = this._locator.ice_getIdentity().category;
                }
                for (Request req : this._pendingRequests) {
                    req.invoke(this._locator);
                }
                this._pendingRequests.clear();
            }
        }

        public synchronized void invoke(LocatorPrx locator, Request request) {
            if (request != null && this._locator != null && this._locator != locator) {
                request.invoke(this._locator);
            } else if (request != null && Time.currentMonotonicTimeMillis() < this._nextRetry) {
                request.invoke(this._voidLocator);
            } else {
                this._locator = null;
                if (request != null) {
                    this._pendingRequests.add(request);
                }
                if (!this._pending) {
                    this._pending = true;
                    this._pendingRetryCount = this._retryCount;
                    this._failureCount = 0;
                    try {
                        if (this._traceLevel > 1) {
                            StringBuilder s = new StringBuilder("looking up locator:\nlookup = ");
                            s.append(this._lookup);
                            if (!this._instanceName.isEmpty()) {
                                s.append("\ninstance name = ").append(this._instanceName);
                            }
                            this._lookup.ice_getCommunicator().getLogger().trace("Lookup", s.toString());
                        }
                        for (Map.Entry entry : this._lookups.entrySet()) {
                            ((LookupPrx)entry.getKey()).findLocatorAsync(this._instanceName, (LookupReplyPrx)entry.getValue()).whenCompleteAsync((v, ex) -> {
                                if (ex != null) {
                                    this.exception((Throwable)ex);
                                }
                            }, ((LookupPrx)entry.getKey()).ice_executor());
                        }
                        this._future = this._timer.schedule(this._retryTask, (long)this._timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (LocalException ex2) {
                        if (this._traceLevel > 0) {
                            StringBuilder stringBuilder = new StringBuilder("locator lookup failed:\nlookup = ");
                            stringBuilder.append(this._lookup);
                            if (!this._instanceName.isEmpty()) {
                                stringBuilder.append("\ninstance name = ").append(this._instanceName);
                            }
                            stringBuilder.append("\n").append(ex2);
                            this._lookup.ice_getCommunicator().getLogger().trace("Lookup", stringBuilder.toString());
                        }
                        for (Request req : this._pendingRequests) {
                            req.invoke(this._voidLocator);
                        }
                        this._pendingRequests.clear();
                        this._pending = false;
                        this._pendingRetryCount = 0;
                    }
                }
            }
        }

        synchronized void exception(Throwable ex) {
            if (++this._failureCount == this._lookups.size() && this._pending) {
                this._future.cancel(false);
                this._future = null;
                this._pendingRetryCount = 0;
                this._pending = false;
                if (this._warnOnce) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("failed to lookup locator with lookup proxy `");
                    builder.append(this._lookup);
                    builder.append("':\n");
                    builder.append(ex);
                    this._lookup.ice_getCommunicator().getLogger().warning(builder.toString());
                    this._warnOnce = false;
                }
                if (this._traceLevel > 0) {
                    StringBuilder s = new StringBuilder("locator lookup failed:\nlookup = ");
                    s.append(this._lookup);
                    if (!this._instanceName.isEmpty()) {
                        s.append("\ninstance name = ").append(this._instanceName);
                    }
                    s.append("\n").append(ex);
                    this._lookup.ice_getCommunicator().getLogger().trace("Lookup", s.toString());
                }
                if (this._pendingRequests.isEmpty()) {
                    this.notify();
                } else {
                    for (Request req : this._pendingRequests) {
                        req.invoke(this._voidLocator);
                    }
                    this._pendingRequests.clear();
                }
            }
        }
    }

    private class LookupReplyI
    implements LookupReply {
        private final LocatorI _locator;

        LookupReplyI(LocatorI locator) {
            this._locator = locator;
        }

        @Override
        public void foundLocator(LocatorPrx locator, Current curr) {
            this._locator.foundLocator(locator);
        }
    }

    private static class Request {
        private final LocatorI _locator;
        private LocalException _exception = null;
        private final String _operation;
        private final OperationMode _mode;
        private final Map<String, String> _context;
        private final byte[] _inParams;
        private final CompletableFuture<Object.Ice_invokeResult> _future;
        private LocatorPrx _locatorPrx;

        Request(LocatorI locator, String operation, OperationMode mode, byte[] inParams, Map<String, String> context, CompletableFuture<Object.Ice_invokeResult> f) {
            this._locator = locator;
            this._operation = operation;
            this._mode = mode;
            this._inParams = inParams;
            this._context = context;
            this._future = f;
        }

        void invoke(LocatorPrx l) {
            if (this._locatorPrx == null || !this._locatorPrx.equals(l)) {
                this._locatorPrx = l;
                try {
                    CompletableFuture<Object.Ice_invokeResult> f = l.ice_invokeAsync(this._operation, this._mode, this._inParams, this._context);
                    f.whenComplete((result, ex) -> {
                        if (ex != null) {
                            this.exception((LocalException)ex);
                        } else {
                            this._future.complete((Object.Ice_invokeResult)result);
                        }
                    });
                }
                catch (LocalException ex2) {
                    this.exception(ex2);
                }
            } else {
                assert (this._exception != null);
                this.exception(this._exception);
            }
        }

        private void exception(LocalException ex) {
            try {
                throw ex;
            }
            catch (RequestFailedException exc) {
                this._future.completeExceptionally(ex);
            }
            catch (UnknownException exc) {
                this._future.completeExceptionally(ex);
            }
            catch (NoEndpointException exc) {
                this._future.completeExceptionally(new ObjectNotExistException());
            }
            catch (ObjectAdapterDeactivatedException exc) {
                this._future.completeExceptionally(new ObjectNotExistException());
            }
            catch (CommunicatorDestroyedException exc) {
                this._future.completeExceptionally(new ObjectNotExistException());
            }
            catch (LocalException exc) {
                this._exception = exc;
                this._locator.invoke(this._locatorPrx, this);
            }
        }
    }
}

