//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.4
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Glacier2;

/**
 * The Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 *
 * @see Router
 **/
public interface PermissionsVerifier extends com.zeroc.Ice.Object
{
    /**
     * Holds the result of operation checkPermissions.
     **/
    public static class CheckPermissionsResult
    {
        /**
         * Default constructor.
         **/
        public CheckPermissionsResult()
        {
        }

        /**
         * This constructor makes shallow copies of the results for operation CheckPermissions.
         * @param returnValue True if access is granted, or false otherwise.
         * @param reason The reason why access was denied.
         **/
        public CheckPermissionsResult(boolean returnValue, String reason)
        {
            this.returnValue = returnValue;
            this.reason = reason;
        }

        /**
         * True if access is granted, or false otherwise.
         **/
        public boolean returnValue;
        /**
         * The reason why access was denied.
         **/
        public String reason;

        public void write(com.zeroc.Ice.OutputStream ostr)
        {
            ostr.writeString(this.reason);
            ostr.writeBool(returnValue);
        }

        public void read(com.zeroc.Ice.InputStream istr)
        {
            this.reason = istr.readString();
            returnValue = istr.readBool();
        }
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param current The Current object for the invocation.
     * @return An instance of PermissionsVerifier.CheckPermissionsResult.
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     **/
    PermissionsVerifier.CheckPermissionsResult checkPermissions(String userId, String password, com.zeroc.Ice.Current current)
        throws PermissionDeniedException;

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Glacier2::PermissionsVerifier",
        "::Ice::Object"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Glacier2::PermissionsVerifier";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_checkPermissions(PermissionsVerifier obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_userId;
        String iceP_password;
        iceP_userId = istr.readString();
        iceP_password = istr.readString();
        inS.endReadParams();
        inS.setFormat(com.zeroc.Ice.FormatType.SlicedFormat);
        PermissionsVerifier.CheckPermissionsResult ret = obj.checkPermissions(iceP_userId, iceP_password, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "checkPermissions",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_checkPermissions(this, in, current);
            }
            case 1:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
