//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.4
//
// <auto-generated>
//
// Generated from file `Process.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * An administrative interface for process management. Managed servers must
 * implement this interface.
 *
 * <p class="Note">A servant implementing this interface is a potential target
 * for denial-of-service attacks, therefore proper security precautions
 * should be taken. For example, the servant can use a UUID to make its
 * identity harder to guess, and be registered in an object adapter with
 * a secured endpoint.
 **/
public interface Process extends Object
{
    /**
     * Initiate a graceful shut-down.
     * @param current The Current object for the invocation.
     *
     * @see Communicator#shutdown
     **/
    void shutdown(Current current);

    /**
     * Write a message on the process' stdout or stderr.
     * @param message The message.
     * @param fd 1 for stdout, 2 for stderr.
     * @param current The Current object for the invocation.
     **/
    void writeMessage(String message, int fd, Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::Ice::Process"
    };

    @Override
    default String[] ice_ids(Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::Process";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_shutdown(Process obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.shutdown(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_writeMessage(Process obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_message;
        int iceP_fd;
        iceP_message = istr.readString();
        iceP_fd = istr.readInt();
        inS.endReadParams();
        obj.writeMessage(iceP_message, iceP_fd, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "shutdown",
        "writeMessage"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, Current current)
        throws UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return Object._iceD_ice_id(this, in, current);
            }
            case 1:
            {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 2:
            {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 3:
            {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 4:
            {
                return _iceD_shutdown(this, in, current);
            }
            case 5:
            {
                return _iceD_writeMessage(this, in, current);
            }
        }

        assert(false);
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }
}
