//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.4
//
// <auto-generated>
//
// Generated from file `PropertiesAdmin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The PropertiesAdmin interface provides remote access to the properties
 * of a communicator.
 **/
public interface PropertiesAdminPrx extends ObjectPrx
{
    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @return The property value.
     **/
    default String getProperty(String key)
    {
        return getProperty(key, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @return The property value.
     **/
    default String getProperty(String key, java.util.Map<String, String> context)
    {
        return _iceI_getPropertyAsync(key, context, true).waitForResponse();
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @return The property value.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getPropertyAsync(String key)
    {
        return _iceI_getPropertyAsync(key, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @return The property value.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getPropertyAsync(String key, java.util.Map<String, String> context)
    {
        return _iceI_getPropertyAsync(key, context, false);
    }

    /**
     * @hidden
     * @param iceP_key -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.String> _iceI_getPropertyAsync(String iceP_key, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.String> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getProperty", null, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_key);
                 }, istr -> {
                     String ret;
                     ret = istr.readString();
                     return ret;
                 });
        return f;
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @return The matching property set.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getPropertiesForPrefix(String prefix)
    {
        return getPropertiesForPrefix(prefix, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @return The matching property set.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getPropertiesForPrefix(String prefix, java.util.Map<String, String> context)
    {
        return _iceI_getPropertiesForPrefixAsync(prefix, context, true).waitForResponse();
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @return The matching property set.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getPropertiesForPrefixAsync(String prefix)
    {
        return _iceI_getPropertiesForPrefixAsync(prefix, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @return The matching property set.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getPropertiesForPrefixAsync(String prefix, java.util.Map<String, String> context)
    {
        return _iceI_getPropertiesForPrefixAsync(prefix, context, false);
    }

    /**
     * @hidden
     * @param iceP_prefix -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> _iceI_getPropertiesForPrefixAsync(String iceP_prefix, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getPropertiesForPrefix", null, sync, null);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_prefix);
                 }, istr -> {
                     java.util.Map<java.lang.String, java.lang.String> ret;
                     ret = new java.util.TreeMap<String, String>();
                     int sz0 = istr.readSize();
                     for(int i0 = 0; i0 < sz0; i0++)
                     {
                         String key;
                         key = istr.readString();
                         String value;
                         value = istr.readString();
                         ret.put(key, value);
                     }
                     return ret;
                 });
        return f;
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     **/
    default void setProperties(java.util.Map<java.lang.String, java.lang.String> newProperties)
    {
        setProperties(newProperties, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     **/
    default void setProperties(java.util.Map<java.lang.String, java.lang.String> newProperties, java.util.Map<String, String> context)
    {
        _iceI_setPropertiesAsync(newProperties, context, true).waitForResponse();
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setPropertiesAsync(java.util.Map<java.lang.String, java.lang.String> newProperties)
    {
        return _iceI_setPropertiesAsync(newProperties, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setPropertiesAsync(java.util.Map<java.lang.String, java.lang.String> newProperties, java.util.Map<String, String> context)
    {
        return _iceI_setPropertiesAsync(newProperties, context, false);
    }

    /**
     * @hidden
     * @param iceP_newProperties -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_setPropertiesAsync(java.util.Map<java.lang.String, java.lang.String> iceP_newProperties, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "setProperties", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     PropertyDictHelper.write(ostr, iceP_newProperties);
                 }, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PropertiesAdminPrx checkedCast(ObjectPrx obj)
    {
        return ObjectPrx._checkedCast(obj, ice_staticId(), PropertiesAdminPrx.class, _PropertiesAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PropertiesAdminPrx checkedCast(ObjectPrx obj, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, context, ice_staticId(), PropertiesAdminPrx.class, _PropertiesAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PropertiesAdminPrx checkedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._checkedCast(obj, facet, ice_staticId(), PropertiesAdminPrx.class, _PropertiesAdminPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PropertiesAdminPrx checkedCast(ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), PropertiesAdminPrx.class, _PropertiesAdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static PropertiesAdminPrx uncheckedCast(ObjectPrx obj)
    {
        return ObjectPrx._uncheckedCast(obj, PropertiesAdminPrx.class, _PropertiesAdminPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static PropertiesAdminPrx uncheckedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._uncheckedCast(obj, facet, PropertiesAdminPrx.class, _PropertiesAdminPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default PropertiesAdminPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (PropertiesAdminPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default PropertiesAdminPrx ice_adapterId(String newAdapterId)
    {
        return (PropertiesAdminPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default PropertiesAdminPrx ice_endpoints(Endpoint[] newEndpoints)
    {
        return (PropertiesAdminPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default PropertiesAdminPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (PropertiesAdminPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default PropertiesAdminPrx ice_invocationTimeout(int newTimeout)
    {
        return (PropertiesAdminPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default PropertiesAdminPrx ice_connectionCached(boolean newCache)
    {
        return (PropertiesAdminPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default PropertiesAdminPrx ice_endpointSelection(EndpointSelectionType newType)
    {
        return (PropertiesAdminPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default PropertiesAdminPrx ice_secure(boolean b)
    {
        return (PropertiesAdminPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default PropertiesAdminPrx ice_encodingVersion(EncodingVersion e)
    {
        return (PropertiesAdminPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default PropertiesAdminPrx ice_preferSecure(boolean b)
    {
        return (PropertiesAdminPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default PropertiesAdminPrx ice_router(RouterPrx router)
    {
        return (PropertiesAdminPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default PropertiesAdminPrx ice_locator(LocatorPrx locator)
    {
        return (PropertiesAdminPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default PropertiesAdminPrx ice_collocationOptimized(boolean b)
    {
        return (PropertiesAdminPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default PropertiesAdminPrx ice_twoway()
    {
        return (PropertiesAdminPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default PropertiesAdminPrx ice_oneway()
    {
        return (PropertiesAdminPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default PropertiesAdminPrx ice_batchOneway()
    {
        return (PropertiesAdminPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default PropertiesAdminPrx ice_datagram()
    {
        return (PropertiesAdminPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default PropertiesAdminPrx ice_batchDatagram()
    {
        return (PropertiesAdminPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default PropertiesAdminPrx ice_compress(boolean co)
    {
        return (PropertiesAdminPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default PropertiesAdminPrx ice_timeout(int t)
    {
        return (PropertiesAdminPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default PropertiesAdminPrx ice_connectionId(String connectionId)
    {
        return (PropertiesAdminPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default PropertiesAdminPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (PropertiesAdminPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::Ice::PropertiesAdmin";
    }
}
