//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.4
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <code>ice_router</code> on specific
 * proxies.
 **/
public interface Router extends Object
{
    /**
     * Holds the result of operation getClientProxy.
     **/
    public static class GetClientProxyResult
    {
        /**
         * Default constructor.
         **/
        public GetClientProxyResult()
        {
        }

        /**
         * This constructor makes shallow copies of the results for operation GetClientProxy.
         * @param returnValue The router's client proxy.
         * @param hasRoutingTable Indicates whether or not the router supports a routing
         * table. If it is supported, the Ice runtime will call addProxies to populate the
         * routing table. This out parameter is only supported starting with Ice 3.7.
         * The Ice runtime assumes the router has a routing table if the optional is not
         * set.
         **/
        public GetClientProxyResult(ObjectPrx returnValue, java.util.Optional<java.lang.Boolean> hasRoutingTable)
        {
            this.returnValue = returnValue;
            this.hasRoutingTable = hasRoutingTable;
        }

        /**
         * This constructor makes shallow copies of the results for operation GetClientProxy (overload without Optional parameters).
         * @param returnValue The router's client proxy.
         * @param hasRoutingTable Indicates whether or not the router supports a routing
         * table. If it is supported, the Ice runtime will call addProxies to populate the
         * routing table. This out parameter is only supported starting with Ice 3.7.
         * The Ice runtime assumes the router has a routing table if the optional is not
         * set.
         **/
        public GetClientProxyResult(ObjectPrx returnValue, boolean hasRoutingTable)
        {
            this.returnValue = returnValue;
            this.hasRoutingTable = java.util.Optional.of(hasRoutingTable);
        }

        /**
         * The router's client proxy.
         **/
        public ObjectPrx returnValue;
        /**
         * Indicates whether or not the router supports a routing
         * table. If it is supported, the Ice runtime will call addProxies to populate the
         * routing table. This out parameter is only supported starting with Ice 3.7.
         * The Ice runtime assumes the router has a routing table if the optional is not
         * set.
         **/
        public java.util.Optional<java.lang.Boolean> hasRoutingTable;

        public void write(OutputStream ostr)
        {
            ostr.writeProxy(returnValue);
            ostr.writeBool(1, this.hasRoutingTable);
        }

        public void read(InputStream istr)
        {
            returnValue = istr.readProxy();
            this.hasRoutingTable = istr.readBool(1);
        }
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param current The Current object for the invocation.
     * @return An instance of Router.GetClientProxyResult.
     **/
    Router.GetClientProxyResult getClientProxy(Current current);

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param current The Current object for the invocation.
     * @return The router's server proxy.
     **/
    ObjectPrx getServerProxy(Current current);

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param current The Current object for the invocation.
     * @return Proxies discarded by the router.
     **/
    ObjectPrx[] addProxies(ObjectPrx[] proxies, Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::Ice::Router"
    };

    @Override
    default String[] ice_ids(Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::Router";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_getClientProxy(Router obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        Router.GetClientProxyResult ret = obj.getClientProxy(current);
        OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_getServerProxy(Router obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ObjectPrx ret = obj.getServerProxy(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<OutputStream> _iceD_addProxies(Router obj, final com.zeroc.IceInternal.Incoming inS, Current current)
    {
        Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx[] iceP_proxies;
        iceP_proxies = ObjectProxySeqHelper.read(istr);
        inS.endReadParams();
        ObjectPrx[] ret = obj.addProxies(iceP_proxies, current);
        OutputStream ostr = inS.startWriteParams();
        ObjectProxySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "addProxies",
        "getClientProxy",
        "getServerProxy",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, Current current)
        throws UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_addProxies(this, in, current);
            }
            case 1:
            {
                return _iceD_getClientProxy(this, in, current);
            }
            case 2:
            {
                return _iceD_getServerProxy(this, in, current);
            }
            case 3:
            {
                return Object._iceD_ice_id(this, in, current);
            }
            case 4:
            {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 5:
            {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 6:
            {
                return Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }
}
