// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

// +build go1.13,!go1.14

package runenames

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "11.0.0"

type entry uint64

func (e entry) startRune() int32 {
	return int32((e >> 43) & 0x1fffff)
}

func (e entry) numRunes() int {
	return int((e >> 27) & 0xffff)
}

func (e entry) index() int {
	return int((e >> 11) & 0xffff)
}

func (e entry) base() int {
	return int((e >> 5) & 0x3f)
}

func (e entry) direct() bool {
	const bit = 1 << 4
	return e&bit == bit
}

var entries = []entry{ // 679 elements
	// Entry 0 - 1F
	0x00000001000ac130, 0x00010002f8000000, 0x0003f801080ac130, 0x00050016c002f800,
	0x001bd0003019b800, 0x001c20003819e800, 0x001c6000081a2000, 0x001c7000a01a2800,
	0x001d180c681ac800, 0x0029880130273000, 0x002ac80190286000, 0x002c68001829f000,
	0x002c8801b82a0800, 0x002e8000d82bc000, 0x002f7800302c9800, 0x00300000e82cc800,
	0x0030f007802db000, 0x00387801e0353000, 0x003a680328371000, 0x003e0001d83a3800,
	0x003fe801883c1000, 0x00418000783d9800, 0x00420000e03e1000, 0x0042f000083ef000,
	0x00430000583ef800, 0x00450000a83f5000, 0x0045b000403ff800, 0x0046980588403800,
	0x004c28004045c000, 0x004c780010460000, 0x004c9800b0461000, 0x004d50003846c000,
	// Entry 20 - 3F
	0x004d90000846f800, 0x004db00020470000, 0x004de00048472000, 0x004e380010476800,
	0x004e580020477800, 0x004eb80008479800, 0x004ee0001047a000, 0x004ef8002847b000,
	0x004f3000c847d800, 0x005008001848a000, 0x005028003048b800, 0x005078001048e800,
	0x00509800b048f800, 0x005150003849a800, 0x005190001049e000, 0x0051a8001049f000,
	0x0051c000104a0000, 0x0051e000084a1000, 0x0051f000284a1800, 0x00523800104a4000,
	0x00525800184a5000, 0x00528800084a6800, 0x0052c800204a7000, 0x0052f000084a9000,
	0x00533000884a9800, 0x00540800184b2000, 0x00542800484b3800, 0x00547800084b8000,
	0x00548000104b8820, 0x00549800b04b9820, 0x00555000384c4820, 0x00559000104c8020,
	// Entry 40 - 5F
	0x0055a800284c9020, 0x0055e000504cb820, 0x00563800184d0820, 0x00565800184d2020,
	0x00568000084d3820, 0x00570000204d4020, 0x00573000604d6020, 0x0057c800384dc020,
	0x00580800184df820, 0x00582800404e1020, 0x00587800104e5020, 0x00589800b04e6020,
	0x00595000384f1020, 0x00599000104f4820, 0x0059a800284f5820, 0x0059e000484f8020,
	0x005a3800104fc820, 0x005a5800184fd820, 0x005ab000104ff020, 0x005ae00010500020,
	0x005af80028501020, 0x005b300090503820, 0x005c10001050c820, 0x005c28003050d820,
	0x005c700018510820, 0x005c900020512020, 0x005cc80010514020, 0x005ce00008515020,
	0x005cf00010515820, 0x005d180010516820, 0x005d400018517820, 0x005d700060519020,
	// Entry 60 - 7F
	0x005df0002851f020, 0x005e300018521820, 0x005e500020523020, 0x005e800008525020,
	0x005eb80008525820, 0x005f3000a8526020, 0x0060000068530820, 0x0060700018537020,
	0x00609000b8538820, 0x0061500080544020, 0x0061e8004054c020, 0x0062300018550020,
	0x0062500020551820, 0x0062a80010553820, 0x0062c00018554820, 0x0063000020556020,
	0x0063300050558020, 0x0063c000a855d020, 0x0064700018567820, 0x00649000b8569020,
	0x0065500050574820, 0x0065a80028579820, 0x0065e0004857c020, 0x0066300018580820,
	0x0066500020582020, 0x0066a80010584020, 0x0066f00008585020, 0x0067000020585820,
	0x0067300050587820, 0x006788001058c820, 0x006800002058d820, 0x006828004058f820,
	// Entry 80 - 9F
	0x0068700018593820, 0x0068900198595020, 0x006a3000185ae820, 0x006a5000305b0020,
	0x006aa000805b3020, 0x006b3000d05bb020, 0x006c1000105c8020, 0x006c2800905c9020,
	0x006cd000c05d2020, 0x006d9800485de020, 0x006de800085e2820, 0x006e0000385e3020,
	0x006e5000085e6820, 0x006e7800305e7020, 0x006eb000085ea020, 0x006ec000405ea820,
	0x006f3000505ee820, 0x006f9000185f3820, 0x00700801d05f5020, 0x0071f800e8612020,
	0x0074080010620820, 0x0074200008621820, 0x0074380010622020, 0x0074500008623020,
	0x0074680008623820, 0x0074a00020624020, 0x0074c80038626020, 0x0075080018629820,
	0x007528000862b020, 0x007538000862b820, 0x007550001062c020, 0x007568006862d020,
	// Entry A0 - BF
	0x0075d80018633820, 0x0076000028635020, 0x0076300008637820, 0x0076400030638020,
	0x007680005063b020, 0x0076e00020640020, 0x0078000240642020, 0x007a480120666020,
	0x007b880138678020, 0x007cc8012068b820, 0x007df0007869d820, 0x007e7000686a5020,
	0x00800006306ab820, 0x008638000870e820, 0x008668000870f020, 0x0086800bc870f820,
	0x00925000207cc020, 0x00928000387ce020, 0x0092c000087d1820, 0x0092d000207d2020,
	0x00930001487d4020, 0x00945000207e8820, 0x00948001087ea820, 0x00959000207fb020,
	0x0095c000387fd020, 0x0096000008800820, 0x0096100020801020, 0x0096400078803020,
	0x0096c001c880a820, 0x0098900020827020, 0x0098c00218829020, 0x009ae8010084a820,
	// Entry C0 - DF
	0x009c0000d085a820, 0x009d0002b0867820, 0x009fc00030892820, 0x00a00014e8895820,
	0x00b50002c89e4020, 0x00b8000068a10820, 0x00b8700038a17020, 0x00b90000b8a1a820,
	0x00ba0000a0a26020, 0x00bb000068a30020, 0x00bb700018a36820, 0x00bb900010a38020,
	0x00bc000010a39020, 0x00bc1002e0a3a040, 0x00bf000050a68040, 0x00bf800050a6d040,
	0x00c0000078a72040, 0x00c0800050a79840, 0x00c10002c8a7e840, 0x00c4000158aab040,
	0x00c5800230ac0840, 0x00c80000f8ae3840, 0x00c9000060af3040, 0x00c9800060af9040,
	0x00ca000008aff040, 0x00ca200150aff840, 0x00cb800028b14840, 0x00cc000160b17040,
	0x00cd8000d0b2d040, 0x00ce800058b3a040, 0x00cef001f0b3f840, 0x00d0f00208b5e840,
	// Entry E0 - FF
	0x00d30000e8b7f040, 0x00d3f80058b8d840, 0x00d4800050b93040, 0x00d5000070b98040,
	0x00d5800078b9f040, 0x00d8000260ba6840, 0x00da800168bcc840, 0x00dc0003a0be3040,
	0x00dfe001e0c1d040, 0x00e1d80078c3b040, 0x00e26801e0c42840, 0x00e4800158c60840,
	0x00e5e80058c76040, 0x00e6800150c7b840, 0x00e80007d0c90840, 0x00efd808d8d0d840,
	0x00f8c00030d9b040, 0x00f9000130d9e040, 0x00fa400030db1040, 0x00fa800040db4040,
	0x00fac80008db8040, 0x00fad80008db8840, 0x00fae80008db9040, 0x00faf800f8db9840,
	0x00fc0001a8dc9040, 0x00fdb00078de3840, 0x00fe300070deb040, 0x00feb00030df2040,
	0x00fee80098df5040, 0x00ff900018dfe840, 0x00ffb00048e00040, 0x0100000328e04840,
	// Entry 100 - 11F
	0x0103300060e37040, 0x0103a000d8e3d040, 0x0104800068e4a840, 0x0105000100e51040,
	0x0106800108e61040, 0x0108000460e71840, 0x010c800180eb7840, 0x010e001338ecf860,
	0x0122000059003060, 0x01230038a1008860, 0x015bb00059392860, 0x015c0800a9398080,
	0x015cc001893a2880, 0x015e5001a93bb080, 0x01600001793d5880, 0x01618001793ed080,
	0x01630004a1404880, 0x0167c8016944e880, 0x0169380009465080, 0x0169680009465880,
	0x01698001c1466080, 0x016b780011482080, 0x016bf800c1483080, 0x016d00003948f080,
	0x016d400039492880, 0x016d800039496080, 0x016dc00039499880, 0x016e00003949d080,
	0x016e4000394a0880, 0x016e8000394a4080, 0x016ec000394a7880, 0x016f0003794ab080,
	// Entry 120 - 13F
	0x01740000d14e2880, 0x0174d802c94ef880, 0x01780006b151c080, 0x017f800061587080,
	0x018000020158d080, 0x01820802b15ad080, 0x0184c803395d8080, 0x018828015960b880,
	0x01898802f1621080, 0x018c800159650080, 0x018e000121665880, 0x018f800179677880,
	0x01910006f968f080, 0x01980008016fe880, 0x01a000cdb0000370, 0x026e00020177e880,
	0x0270028f800511f0, 0x05000022a979e880, 0x0522a801c19c90a0, 0x05248001b99e50a0,
	0x0526800ae1a008a0, 0x05320005c1aae8a0, 0x05380005d1b0a8a0, 0x053fb801a9b678a0,
	0x0541800051b820a0, 0x05420001c1b870a0, 0x0544000231ba30a0, 0x0546700061bc60a0,
	0x05470003a1bcc0a0, 0x054af800f1c060a0, 0x054c000271c150a0, 0x054e780059c3c0a0,
	// Entry 140 - 15F
	0x054ef00109c418a0, 0x05500001b9c520a0, 0x0552000071c6d8a0, 0x0552800051c748a0,
	0x0552e00339c798a0, 0x0556d800e1cad0a0, 0x0558080031cbb0a0, 0x0558480031cbe0a0,
	0x0558880031cc10a0, 0x0559000039cc40a0, 0x0559400039cc78a0, 0x05598001b1ccb0a0,
	0x055b8003f1ce60a0, 0x055f800051d250a0, 0x0560015d20058a30, 0x06bd8000b9d2a0a0,
	0x06be580189d358a0, 0x06c0001c00068c10, 0x06dc00040008eb90, 0x06e00020000611f0,
	0x070000c80009c9b0, 0x07c8000b71d4e0a0, 0x07d3800351e050a0, 0x07d8000039e3a0a0,
	0x07d8980029e3d8a0, 0x07d8e800d1e400a0, 0x07d9c00029e4d0a0, 0x07d9f00009e4f8a0,
	0x07da000011e500a0, 0x07da180011e510a0, 0x07da3003e1e520a0, 0x07de9802f1e900a0,
	// Entry 160 - 17F
	0x07e1880879ebf0c0, 0x07ea800201f468c0, 0x07ec9001b1f668c0, 0x07ef800071f818c0,
	0x07f00000d1f888c0, 0x07f1000199f958c0, 0x07f2a00099faf0c0, 0x07f3400021fb88c0,
	0x07f3800029fba8c0, 0x07f3b00439fbd0c0, 0x07f7f8000a0008c0, 0x07f80805f20010c0,
	0x07fe1000320600c0, 0x07fe5000320630c0, 0x07fe9000320660c0, 0x07fed0001a0690c0,
	0x07ff00003a06a8c0, 0x07ff40003a06e0c0, 0x07ffc8002a0718c0, 0x08000000620740c0,
	0x08006800d207a0c0, 0x080140009a0870c0, 0x0801e000120908c0, 0x0801f8007a0918c0,
	0x08028000720990c0, 0x08040003da0a00c0, 0x080800001a0dd8c0, 0x080838016a0df0c0,
	0x0809b802c20f58c0, 0x080c8000621218c0, 0x080d00000a1278c0, 0x080e8001721280c0,
	// Entry 180 - 19F
	0x08140000ea13f0c0, 0x081500018a14d8c0, 0x08170000e21660c0, 0x08180001221740c0,
	0x08196800f21860c0, 0x081a80015a1950c0, 0x081c0000f21aa8c0, 0x081cf8012a1b98c0,
	0x081e4000721cc0c0, 0x08200004f21d30c0, 0x08250000522220c0, 0x08258001222270c0,
	0x0826c001222390c0, 0x082800014224b0c0, 0x08298001a225f0c0, 0x082b78000a2790c0,
	0x08300009ba2798c0, 0x083a0000b23150c0, 0x083b0000423200c0, 0x08400000323240c0,
	0x084040000a3270c0, 0x08405001623278c0, 0x0841b8001233d8c0, 0x0841e0000a33e8c0,
	0x0841f800ba33f0c0, 0x0842b800fa34a8c0, 0x0843b0014a35a0e0, 0x084538004a36e8e0,
	0x084700009a3730e0, 0x0847a0001237c8e0, 0x0847d8010a37d8e0, 0x0848f800da38e0e0,
	// Entry 1A0 - 1BF
	0x0849f8000a39b8e0, 0x084c0001c239c0e0, 0x084de000a23b80e0, 0x084e9001923c20e0,
	0x08502800123db0e0, 0x08506000423dc0e0, 0x0850a8001a3e00e0, 0x0850c800ea3e18e0,
	0x0851c0001a3f00e0, 0x0851f800523f18e0, 0x085280004a3f68e0, 0x08530002023fb0e0,
	0x085600013a41b0e0, 0x085758006242e8e0, 0x08580001b24348e0, 0x0859c800ea44f8e0,
	0x085ac000da45e0e0, 0x085bc000d246b8e0, 0x085cc800224788e0, 0x085d48003a47a8e0,
	0x086000024a47e0e0, 0x086400019a4a28e0, 0x086600019a4bc0e0, 0x0867d001724d58e0,
	0x08698000524ec8e0, 0x08730000fa4f18e0, 0x08780001425010e0, 0x08798001525150e0,
	0x088000027252a0e0, 0x08829000f25510e0, 0x0883f8021a5600e0, 0x088668000a5818e0,
	// Entry 1C0 - 1DF
	0x08868000ca5820e0, 0x088780005258e8e0, 0x08880001aa5938e0, 0x0889b0008a5ae0e0,
	0x088a80013a5b68e0, 0x088c0002725ca0e0, 0x088e8000825f10e0, 0x088f0800a25f90e0,
	0x08900000926030e0, 0x089098016260c0e0, 0x089400003a6220e0, 0x089440000a6258e0,
	0x08945000226260e0, 0x089478007a6280e0, 0x0894f8005a62f8e0, 0x08958001da6350e0,
	0x08978000526528e0, 0x08980000226578e0, 0x08982800426598e0, 0x089878001265d8e0,
	0x08989800b265e8e0, 0x089950003a6698e0, 0x089990001266d0e0, 0x0899a8002a66e0e0,
	0x0899d800526708e0, 0x089a3800126758e0, 0x089a58001a6768e0, 0x089a80000a6780e0,
	0x089ab8000a6788e0, 0x089ae8003a6790e0, 0x089b30003a67c8e0, 0x089b80002a6800e0,
	// Entry 1E0 - 1FF
	0x08a00002d26828e0, 0x08a2d8000a6af8e0, 0x08a2e800126b00e0, 0x08a40002426b10e0,
	0x08a68000526d50e0, 0x08ac0001b26da0e0, 0x08adc001326f50e0, 0x08b000022a7080e0,
	0x08b280005272a8e0, 0x08b300006a72f8e0, 0x08b40001c27360e0, 0x08b60000527520e0,
	0x08b80000da7570e0, 0x08b8e8007a7648e0, 0x08b980008276c0e0, 0x08c00001e27740e0,
	0x08c500029a7920e0, 0x08c7f8000a7bb8e0, 0x08d00002427bc0e0, 0x08d28001a27e00e0,
	0x08d43000ea7fa0e0, 0x08d60001ca8088e0, 0x08e000004a8250e0, 0x08e050016a8298e0,
	0x08e1c000728400e0, 0x08e28000ea8470e0, 0x08e38001028558e0, 0x08e49000b28658e0,
	0x08e54800728708e0, 0x08e800003a8778e0, 0x08e840001287b0e0, 0x08e858016287c0e0,
	// Entry 200 - 21F
	0x08e9d0000a8920e0, 0x08e9e000128928e0, 0x08e9f8004a8938e0, 0x08ea8000528980e0,
	0x08eb00003289d0e0, 0x08eb3800128a00e0, 0x08eb50012a8a10e0, 0x08ec8000128b38e0,
	0x08ec9800328b48e0, 0x08ed0000528b78e0, 0x08f70000ca8bc8e0, 0x09000002f28c90e0,
	0x0902f019e28f8100, 0x092000037aa96100, 0x092380002aacd900, 0x0924000622ad0100,
	0x098000217ab32100, 0x0a200008aad49900, 0x0a28a80992dd4120, 0x0b400011cae6d120,
	0x0b520000faf89920, 0x0b53000052f99120, 0x0b53700012f9e120, 0x0b568000f2f9f120,
	0x0b57800032fae120, 0x0b58000232fb1120, 0x0b5a800052fd4120, 0x0b5ad8003afd9120,
	0x0b5b1800aafdc920, 0x0b5be8009afe7120, 0x0b720002daff0920, 0x0b7800022b01e120,
	// Entry 220 - 23F
	0x0b7a80017b040920, 0x0b7c78008b058120, 0x0b7f000013060920, 0x0b8000bf900a3250,
	0x0c4000179b061920, 0x0d800008fb1db120, 0x0d8b800c6326a920, 0x0de000035b330920,
	0x0de380006b366120, 0x0de400004b36c920, 0x0de4800053371120, 0x0de4e00043376120,
	0x0e8000005b37a120, 0x0e8058075b37f940, 0x0e8800013b3f5140, 0x0e89480603408940,
	0x0e90000233468940, 0x0e970000a348b940, 0x0e980002bb495940, 0x0e9b0000cb4c1140,
	0x0ea00002ab4cd940, 0x0ea2b0023b4f8140, 0x0ea4f0001351b940, 0x0ea510000b51c940,
	0x0ea528001351d140, 0x0ea548002351e140, 0x0ea5700063520140, 0x0ea5d8000b526140,
	0x0ea5e8003b526940, 0x0ea628020b52a140, 0x0ea838002354a940, 0x0ea868004354c940,
	// Entry 240 - 25F
	0x0ea8b0003b550940, 0x0ea8f000e3554140, 0x0ea9d80023562140, 0x0eaa00002b564140,
	0x0eaa30000b566940, 0x0eaa50003b567140, 0x0eaa900aa356a940, 0x0eb5400923614940,
	0x0ebe7008a36a6940, 0x0ec7100d53730960, 0x0ed4d8002b805960, 0x0ed508007b808160,
	0x0f0000003b80f960, 0x0f0040008b813160, 0x0f00d8003b81b960, 0x0f0118001381f160,
	0x0f0130002b820160, 0x0f4000062b822960, 0x0f46380083885160, 0x0f4800025b88d160,
	0x0f4a8000538b2960, 0x0f4af000138b7960, 0x0f638802238b8960, 0x0f700000238da960,
	0x0f702800db8dc960, 0x0f710800138ea160, 0x0f7120000b8eb160, 0x0f7138000b8eb960,
	0x0f714800538ec160, 0x0f71a000238f1160, 0x0f71c8000b8f3160, 0x0f71d8000b8f3960,
	// Entry 260 - 27F
	0x0f7210000b8f4160, 0x0f7238000b8f4960, 0x0f7248000b8f5160, 0x0f7258000b8f5960,
	0x0f7268001b8f6160, 0x0f728800138f7960, 0x0f72a0000b8f8960, 0x0f72b8000b8f9160,
	0x0f72c8000b8f9960, 0x0f72d8000b8fa160, 0x0f72e8000b8fa960, 0x0f72f8000b8fb160,
	0x0f730800138fb960, 0x0f7320000b8fc960, 0x0f733800238fd160, 0x0f7360003b8ff160,
	0x0f73a00023902960, 0x0f73c80023904960, 0x0f73f0000b906960, 0x0f74000053907160,
	0x0f7458008b90c160, 0x0f7508001b914960, 0x0f7528002b916160, 0x0f7558008b918960,
	0x0f77800013921160, 0x0f80000163922160, 0x0f81800323938160, 0x0f8500007b96a160,
	0x0f8588007b971960, 0x0f8608007b979160, 0x0f8688012b980960, 0x0f8800006b993160,
	// Entry 280 - 29F
	0x0f888002e3999960, 0x0f8b8001eb9c7960, 0x0f8f3000eb9e6160, 0x0f908001639f4960,
	0x0f9200004ba0a960, 0x0f92800013a0f160, 0x0f93000033a10160, 0x0f98001eaba13160,
	0x0fb700006bbfd960, 0x0fb7800053c04160, 0x0fb80000e3c09160, 0x0fb8e002c3c17180,
	0x0fbc0002cbc43180, 0x0fc0000063c6f980, 0x0fc08001c3c75980, 0x0fc2800053c91980,
	0x0fc3000143c96980, 0x0fc48000f3caa980, 0x0fc8000063cb9980, 0x0fc880017bcbf980,
	0x0fca00018bcd7180, 0x0fcb980023cef980, 0x0fcbd0000bcf1980, 0x0fcbe0013bcf2180,
	0x0fcd800053d05980, 0x0fce00001bd0a980, 0x0fce800183d0c180, 0x0fd3000073d24180,
	0x10000536b800db70, 0x15380081a801b370, 0x15ba0006f0028b70, 0x15c100b410036370,
	// Entry 2A0 - 2BF
	0x167580e988043b70, 0x17c00010f3d2b180, 0x700008000be3a180, 0x7001000303e3a980,
	0x7008000783e6a980, 0x780007fff0078ad0, 0x800007fff0083ad0,
} // Size: 5456 bytes

var index = []uint16{ // 32198 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x0015, 0x0023, 0x002e, 0x0039, 0x0045, 0x004e,
	0x0058, 0x0068, 0x0079, 0x0081, 0x008a, 0x008f, 0x009b, 0x00a4,
	0x00ab, 0x00b5, 0x00be, 0x00c7, 0x00d2, 0x00dc, 0x00e6, 0x00ef,
	0x00fa, 0x0105, 0x010f, 0x0114, 0x011d, 0x012b, 0x0136, 0x0147,
	0x0154, 0x0161, 0x0177, 0x018d, 0x01a3, 0x01b9, 0x01cf, 0x01e5,
	0x01fb, 0x0211, 0x0227, 0x023d, 0x0253, 0x0269, 0x027f, 0x0295,
	0x02ab, 0x02c1, 0x02d7, 0x02ed, 0x0303, 0x0319, 0x032f, 0x0345,
	0x035b, 0x0371, 0x0387, 0x039d, 0x03b0, 0x03bf, 0x03d3, 0x03e4,
	// Entry 40 - 7F
	0x03ec, 0x03f8, 0x040c, 0x0420, 0x0434, 0x0448, 0x045c, 0x0470,
	0x0484, 0x0498, 0x04ac, 0x04c0, 0x04d4, 0x04e8, 0x04fc, 0x0510,
	0x0524, 0x0538, 0x054c, 0x0560, 0x0574, 0x0588, 0x059c, 0x05b0,
	0x05c4, 0x05d8, 0x05ec, 0x0600, 0x0612, 0x061f, 0x0632, 0x0637,
	0x0645, 0x065e, 0x0667, 0x0671, 0x067e, 0x0686, 0x0690, 0x069c,
	0x06a5, 0x06b3, 0x06cd, 0x06f6, 0x06fe, 0x0709, 0x0718, 0x071e,
	0x0729, 0x0738, 0x0747, 0x0758, 0x0764, 0x076e, 0x077a, 0x0784,
	0x078b, 0x079a, 0x07b5, 0x07df, 0x07fa, 0x0812, 0x0830, 0x0846,
	// Entry 80 - BF
	0x0867, 0x0888, 0x08ae, 0x08cf, 0x08f4, 0x091a, 0x0931, 0x0954,
	0x0975, 0x0996, 0x09bc, 0x09e1, 0x0a02, 0x0a23, 0x0a49, 0x0a6e,
	0x0a86, 0x0aa7, 0x0ac8, 0x0ae9, 0x0b0f, 0x0b30, 0x0b55, 0x0b68,
	0x0b8a, 0x0bab, 0x0bcc, 0x0bf2, 0x0c17, 0x0c38, 0x0c52, 0x0c6c,
	0x0c8b, 0x0caa, 0x0cce, 0x0ced, 0x0d10, 0x0d34, 0x0d49, 0x0d6a,
	0x0d89, 0x0da8, 0x0dcc, 0x0def, 0x0e0e, 0x0e2d, 0x0e51, 0x0e74,
	0x0e8a, 0x0ea9, 0x0ec8, 0x0ee7, 0x0f0b, 0x0f2a, 0x0f4d, 0x0f5a,
	0x0f7a, 0x0f99, 0x0fb8, 0x0fdc, 0x0fff, 0x101e, 0x1036, 0x1059,
	// Entry C0 - FF
	0x107b, 0x109b, 0x10bc, 0x10db, 0x10fd, 0x111d, 0x113e, 0x115d,
	0x1183, 0x11a7, 0x11cc, 0x11ef, 0x1210, 0x122f, 0x1250, 0x126f,
	0x1291, 0x12b1, 0x12d3, 0x12f3, 0x1314, 0x1333, 0x1358, 0x137b,
	0x139d, 0x13bd, 0x13de, 0x13fd, 0x1423, 0x1447, 0x1468, 0x1487,
	0x14ac, 0x14cf, 0x14f2, 0x1513, 0x1539, 0x155d, 0x157f, 0x159f,
	0x15c0, 0x15df, 0x1601, 0x1621, 0x1642, 0x1661, 0x1683, 0x16a3,
	0x16c8, 0x16e4, 0x16fd, 0x1714, 0x173a, 0x175e, 0x1781, 0x17a2,
	0x17b8, 0x17d9, 0x17f8, 0x181b, 0x183c, 0x185d, 0x187c, 0x18a2,
	// Entry 100 - 13F
	0x18c6, 0x18e8, 0x1908, 0x1929, 0x1948, 0x196b, 0x198c, 0x19ad,
	0x19cc, 0x19f7, 0x1a0f, 0x1a25, 0x1a47, 0x1a67, 0x1a88, 0x1aa7,
	0x1acf, 0x1af5, 0x1b0e, 0x1b25, 0x1b46, 0x1b65, 0x1b88, 0x1ba9,
	0x1bca, 0x1be9, 0x1c0a, 0x1c29, 0x1c4f, 0x1c73, 0x1c96, 0x1cb7,
	0x1cd8, 0x1cf7, 0x1d1a, 0x1d3b, 0x1d5c, 0x1d7b, 0x1d9d, 0x1dbd,
	0x1dde, 0x1dfd, 0x1e1f, 0x1e3f, 0x1e60, 0x1e7f, 0x1ea5, 0x1ec9,
	0x1ef1, 0x1f17, 0x1f39, 0x1f59, 0x1f7f, 0x1fa3, 0x1fc9, 0x1fed,
	0x2012, 0x2033, 0x2052, 0x2077, 0x209a, 0x20bb, 0x20da, 0x20f3,
	// Entry 140 - 17F
	0x2113, 0x2133, 0x2155, 0x2175, 0x2192, 0x21ad, 0x21c8, 0x21e8,
	0x2206, 0x2224, 0x2244, 0x2266, 0x2286, 0x22a5, 0x22c4, 0x22de,
	0x22f9, 0x2319, 0x2337, 0x2357, 0x2371, 0x2386, 0x239f, 0x23c1,
	0x23e1, 0x23ff, 0x241c, 0x2441, 0x245e, 0x2483, 0x24ab, 0x24d3,
	0x24f3, 0x2511, 0x2528, 0x253d, 0x255d, 0x257b, 0x258a, 0x25a7,
	0x25c2, 0x25da, 0x25f8, 0x261e, 0x263e, 0x265c, 0x2686, 0x26a6,
	0x26c4, 0x26e0, 0x2700, 0x2720, 0x273e, 0x2760, 0x2780, 0x2798,
	0x27b9, 0x27d8, 0x27f8, 0x2814, 0x2832, 0x284e, 0x287c, 0x288d,
	// Entry 180 - 1BF
	0x28a6, 0x28c0, 0x28db, 0x28f7, 0x2919, 0x294e, 0x296e, 0x2985,
	0x29af, 0x29c4, 0x29db, 0x2a05, 0x2a1a, 0x2a3b, 0x2a5a, 0x2a7b,
	0x2a9a, 0x2abb, 0x2ada, 0x2afb, 0x2b1a, 0x2b4a, 0x2b78, 0x2ba7,
	0x2bd4, 0x2c03, 0x2c30, 0x2c5f, 0x2c8c, 0x2ca7, 0x2cd7, 0x2d05,
	0x2d35, 0x2d63, 0x2d86, 0x2da7, 0x2dc9, 0x2de9, 0x2e0a, 0x2e29,
	0x2e4a, 0x2e69, 0x2e8b, 0x2eab, 0x2ed8, 0x2f03, 0x2f26, 0x2f47,
	0x2f66, 0x2f7d, 0x2fa7, 0x2fbc, 0x2fdd, 0x2ffc, 0x3016, 0x302f,
	0x3050, 0x306f, 0x309f, 0x30cd, 0x30ef, 0x310f, 0x313b, 0x3165,
	// Entry 1C0 - 1FF
	0x318d, 0x31b3, 0x31dd, 0x3205, 0x322d, 0x3253, 0x327d, 0x32a5,
	0x32cd, 0x32f3, 0x331d, 0x3345, 0x336d, 0x3393, 0x33bd, 0x33e5,
	0x340d, 0x3433, 0x345d, 0x3485, 0x34ad, 0x34d3, 0x34fd, 0x3525,
	0x354c, 0x3571, 0x3598, 0x35bd, 0x35d6, 0x35ed, 0x360e, 0x362d,
	0x3657, 0x3675, 0x368c, 0x36a1, 0x36c1, 0x36df, 0x3704, 0x3727,
	0x374a, 0x376b, 0x379b, 0x37c9, 0x37f5, 0x381f, 0x3844, 0x3867,
	0x3897, 0x38c5, 0x38e7, 0x3907, 0x3925, 0x3943, 0x3961, 0x397d,
	0x399a, 0x39b7, 0x39d9, 0x39fb, 0x3a1b, 0x3a3a, 0x3a65, 0x3a89,
	// Entry 200 - 23F
	0x3aad, 0x3ace, 0x3aed, 0x3b0f, 0x3b29, 0x3b46, 0x3b68, 0x3b88,
	0x3baa, 0x3bca, 0x3bf5, 0x3c18, 0x3c3a, 0x3c5a, 0x3c7c, 0x3c9c,
	0x3cb7, 0x3ccf, 0x3cee, 0x3d0c, 0x3d25, 0x3d43, 0x3d61, 0x3d7f,
	0x3d9c, 0x3db4, 0x3dd6, 0x3def, 0x3e11, 0x3e3d, 0x3e66, 0x3e8e,
	0x3eac, 0x3ec7, 0x3ee3, 0x3efb, 0x3f17, 0x3f32, 0x3f50, 0x3f71,
	0x3f91, 0x3fa8, 0x3fc4, 0x3fea, 0x4008, 0x4030, 0x4047, 0x4062,
	0x408b, 0x40a9, 0x40cc, 0x40f4, 0x4110, 0x412b, 0x4148, 0x4167,
	0x417d, 0x4198, 0x41c1, 0x41e6, 0x4208, 0x4226, 0x4248, 0x4273,
	// Entry 240 - 27F
	0x428f, 0x42b4, 0x42d2, 0x42e8, 0x4319, 0x433e, 0x435e, 0x4379,
	0x43a1, 0x43b9, 0x43d3, 0x43f1, 0x440c, 0x4427, 0x4442, 0x445e,
	0x4486, 0x44a4, 0x44ba, 0x44da, 0x44f3, 0x451b, 0x453d, 0x4555,
	0x4570, 0x458c, 0x45ac, 0x45d2, 0x45ee, 0x4614, 0x462f, 0x464b,
	0x4669, 0x468e, 0x46bc, 0x46d9, 0x46f8, 0x471f, 0x473c, 0x475b,
	0x4782, 0x47a1, 0x47be, 0x47db, 0x47fb, 0x481b, 0x4844, 0x4876,
	0x488d, 0x48ae, 0x48c5, 0x48dc, 0x48fa, 0x4922, 0x494a, 0x4961,
	0x4978, 0x498d, 0x49a9, 0x49c5, 0x49df, 0x49fd, 0x4a1c, 0x4a3a,
	// Entry 280 - 2BF
	0x4a56, 0x4a7b, 0x4a99, 0x4ab8, 0x4ad4, 0x4af2, 0x4b13, 0x4b18,
	0x4b35, 0x4b4b, 0x4b67, 0x4b83, 0x4ba4, 0x4bbe, 0x4bde, 0x4bfe,
	0x4c1e, 0x4c43, 0x4c6a, 0x4c90, 0x4ca7, 0x4cc0, 0x4cd9, 0x4cf3,
	0x4cf8, 0x4d01, 0x4d0b, 0x4d11, 0x4d1c, 0x4d2f, 0x4d4a, 0x4d66,
	0x4d81, 0x4d98, 0x4daf, 0x4dc6, 0x4df1, 0x4e14, 0x4e31, 0x4e4d,
	0x4e69, 0x4e8b, 0x4eb2, 0x4eda, 0x4ef1, 0x4f0c, 0x4f2d, 0x4f4f,
	0x4f6f, 0x4f91, 0x4fb4, 0x4fcc, 0x4fef, 0x5019, 0x5043, 0x505c,
	0x5078, 0x5097, 0x50b4, 0x50d2, 0x50ee, 0x5103, 0x511d, 0x513b,
	// Entry 2C0 - 2FF
	0x5151, 0x5167, 0x5182, 0x5191, 0x51a1, 0x51b3, 0x51c2, 0x51d5,
	0x51e8, 0x51fc, 0x5210, 0x522d, 0x523c, 0x5259, 0x527d, 0x529a,
	0x52af, 0x52c7, 0x52e3, 0x52f8, 0x5316, 0x5331, 0x534d, 0x5369,
	0x5382, 0x539c, 0x53b6, 0x53c4, 0x53e2, 0x53f9, 0x5412, 0x542b,
	0x5445, 0x5465, 0x5483, 0x5496, 0x54af, 0x54c3, 0x54d8, 0x54e9,
	0x54f9, 0x5516, 0x552c, 0x5550, 0x5565, 0x5586, 0x559b, 0x55b9,
	0x55ce, 0x55e4, 0x55f6, 0x560f, 0x5626, 0x5644, 0x5661, 0x5680,
	0x569e, 0x56bd, 0x56dc, 0x56f2, 0x5709, 0x571a, 0x5732, 0x574b,
	// Entry 300 - 33F
	0x5764, 0x577d, 0x5798, 0x57af, 0x57ce, 0x57eb, 0x5801, 0x581c,
	0x5840, 0x585a, 0x5873, 0x588d, 0x58ac, 0x58cc, 0x58e9, 0x5902,
	0x5921, 0x593f, 0x5950, 0x5961, 0x597f, 0x599e, 0x59ce, 0x59ed,
	0x5a06, 0x5a1e, 0x5a39, 0x5a4f, 0x5a6b, 0x5a81, 0x5a98, 0x5ab5,
	0x5acb, 0x5aea, 0x5b11, 0x5b2f, 0x5b4d, 0x5b6b, 0x5b89, 0x5ba7,
	0x5bc5, 0x5be3, 0x5c01, 0x5c1f, 0x5c3d, 0x5c5b, 0x5c79, 0x5c97,
	0x5cb0, 0x5cc7, 0x5ce9, 0x5d09, 0x5d1b, 0x5d33, 0x5d5a, 0x5d7f,
	0x5d92, 0x5dba, 0x5de0, 0x5e0f, 0x5e22, 0x5e3a, 0x5e45, 0x5e5a,
	// Entry 340 - 37F
	0x5e7f, 0x5e8f, 0x5eb6, 0x5ed9, 0x5efd, 0x5f24, 0x5f4b, 0x5f70,
	0x5fa0, 0x5fba, 0x5fd3, 0x5fed, 0x6007, 0x6023, 0x603c, 0x6054,
	0x606e, 0x6087, 0x60a1, 0x60bb, 0x60d2, 0x60e9, 0x6100, 0x611c,
	0x6133, 0x614b, 0x6165, 0x617d, 0x6199, 0x61b1, 0x61c9, 0x61e1,
	0x61fb, 0x6223, 0x624e, 0x6271, 0x6296, 0x62b7, 0x62d9, 0x630c,
	0x6324, 0x633b, 0x6353, 0x636b, 0x6385, 0x639c, 0x63b2, 0x63ca,
	0x63e1, 0x63f9, 0x6411, 0x6426, 0x643b, 0x6450, 0x646a, 0x647f,
	0x6495, 0x64b3, 0x64cb, 0x64e1, 0x64fb, 0x6511, 0x6527, 0x653d,
	// Entry 380 - 3BF
	0x6555, 0x657b, 0x65a4, 0x65c9, 0x65ee, 0x6611, 0x6629, 0x663a,
	0x664c, 0x666a, 0x6692, 0x66be, 0x66ce, 0x66dd, 0x66ed, 0x6707,
	0x6727, 0x673a, 0x6753, 0x6767, 0x6781, 0x6793, 0x67ab, 0x67bd,
	0x67d5, 0x67ef, 0x6807, 0x6820, 0x6837, 0x6851, 0x6869, 0x6883,
	0x689b, 0x68b7, 0x68d1, 0x68ec, 0x6905, 0x691e, 0x6935, 0x6947,
	0x6957, 0x6970, 0x6980, 0x699a, 0x69b5, 0x69d9, 0x69f1, 0x6a07,
	0x6a28, 0x6a40, 0x6a56, 0x6a72, 0x6a9c, 0x6ac4, 0x6af5, 0x6b1a,
	0x6b34, 0x6b4f, 0x6b6a, 0x6b8e, 0x6ba9, 0x6bd9, 0x6bf3, 0x6c0d,
	// Entry 3C0 - 3FF
	0x6c28, 0x6c43, 0x6c5f, 0x6c7a, 0x6c9e, 0x6cbd, 0x6cd9, 0x6cf2,
	0x6d0c, 0x6d26, 0x6d41, 0x6d5b, 0x6d75, 0x6d90, 0x6daa, 0x6dc3,
	0x6de2, 0x6dfc, 0x6e16, 0x6e30, 0x6e4a, 0x6e63, 0x6e7d, 0x6e97,
	0x6eb1, 0x6ecb, 0x6ee4, 0x6efe, 0x6f18, 0x6f33, 0x6f4e, 0x6f69,
	0x6f86, 0x6fa7, 0x6fc3, 0x6fe4, 0x6ffd, 0x7017, 0x7031, 0x7048,
	0x7060, 0x7078, 0x7091, 0x70a9, 0x70c1, 0x70da, 0x70f2, 0x7109,
	0x7126, 0x713e, 0x7156, 0x716e, 0x7186, 0x719d, 0x71b5, 0x71cd,
	0x71e5, 0x71fd, 0x7214, 0x722c, 0x7244, 0x725d, 0x7276, 0x728f,
	// Entry 400 - 43F
	0x72aa, 0x72c9, 0x72e3, 0x7302, 0x7319, 0x7331, 0x7349, 0x736c,
	0x7384, 0x739d, 0x73b6, 0x73d8, 0x73f1, 0x741f, 0x7437, 0x744f,
	0x7468, 0x7481, 0x749b, 0x74b4, 0x74d6, 0x74f3, 0x750d, 0x752a,
	0x7545, 0x7560, 0x7579, 0x759b, 0x75bb, 0x75dd, 0x75fd, 0x7628,
	0x7651, 0x7670, 0x768d, 0x76b5, 0x76db, 0x76f6, 0x770f, 0x772a,
	0x7743, 0x775f, 0x7779, 0x7798, 0x77b5, 0x77ed, 0x7823, 0x783d,
	0x7855, 0x7878, 0x7899, 0x78c1, 0x78e7, 0x7901, 0x7919, 0x7936,
	0x7951, 0x7968, 0x7980, 0x79a1, 0x79c2, 0x79e3, 0x79fe, 0x7a27,
	// Entry 440 - 47F
	0x7a47, 0x7a70, 0x7a97, 0x7abc, 0x7adf, 0x7b03, 0x7b25, 0x7b4c,
	0x7b71, 0x7b98, 0x7bbd, 0x7be9, 0x7c13, 0x7c3d, 0x7c65, 0x7c8e,
	0x7cb5, 0x7cde, 0x7d05, 0x7d34, 0x7d61, 0x7d87, 0x7dab, 0x7dcd,
	0x7ded, 0x7e16, 0x7e3d, 0x7e5d, 0x7e7b, 0x7ea6, 0x7ecf, 0x7ef3,
	0x7f15, 0x7f3e, 0x7f65, 0x7f8e, 0x7fb5, 0x7fd7, 0x7ff7, 0x8025,
	0x8051, 0x807a, 0x80a1, 0x80c1, 0x80df, 0x8109, 0x8131, 0x8161,
	0x818f, 0x81ab, 0x81c5, 0x81ea, 0x820d, 0x8241, 0x8273, 0x828b,
	0x82b1, 0x82d5, 0x82f9, 0x831b, 0x833f, 0x8361, 0x8385, 0x83a7,
	// Entry 480 - 4BF
	0x83cb, 0x83ed, 0x8413, 0x8437, 0x845b, 0x847d, 0x849b, 0x84bf,
	0x84e1, 0x8509, 0x852f, 0x854d, 0x8569, 0x858e, 0x85b1, 0x85ce,
	0x85e9, 0x8615, 0x863f, 0x8669, 0x8691, 0x86ba, 0x86e1, 0x8706,
	0x8729, 0x874e, 0x8771, 0x8799, 0x87bf, 0x87e7, 0x880d, 0x882d,
	0x884b, 0x887a, 0x88a7, 0x88cf, 0x88f5, 0x891a, 0x893d, 0x8965,
	0x898b, 0x89b6, 0x89df, 0x8a09, 0x8a31, 0x8a5b, 0x8a83, 0x8aae,
	0x8ad7, 0x8b07, 0x8b35, 0x8b59, 0x8b7b, 0x8ba1, 0x8bc5, 0x8be4,
	0x8c01, 0x8c21, 0x8c3f, 0x8c5f, 0x8c7d, 0x8c9e, 0x8cbd, 0x8cdd,
	// Entry 4C0 - 4FF
	0x8cfb, 0x8d1b, 0x8d39, 0x8d59, 0x8d77, 0x8d97, 0x8db5, 0x8dd8,
	0x8df9, 0x8e1d, 0x8e3f, 0x8e5a, 0x8e73, 0x8e8e, 0x8ea7, 0x8ec2,
	0x8edb, 0x8ef5, 0x8f0d, 0x8f27, 0x8f3f, 0x8f5f, 0x8f7d, 0x8fa8,
	0x8fd1, 0x8ffc, 0x9025, 0x904e, 0x9075, 0x90a0, 0x90c9, 0x90f2,
	0x9119, 0x9136, 0x9151, 0x916d, 0x9187, 0x91b0, 0x91d7, 0x91f2,
	0x920d, 0x9228, 0x9242, 0x925d, 0x9277, 0x9291, 0x92ab, 0x92c5,
	0x92e0, 0x92fb, 0x9317, 0x9332, 0x934c, 0x9367, 0x9381, 0x939b,
	0x93b7, 0x93d3, 0x93ee, 0x9408, 0x9423, 0x943e, 0x9458, 0x9473,
	// Entry 500 - 53F
	0x948e, 0x94aa, 0x94c4, 0x94df, 0x94fa, 0x9516, 0x9531, 0x954b,
	0x9567, 0x9583, 0x959e, 0x95b8, 0x95d3, 0x95fa, 0x960d, 0x9623,
	0x963c, 0x964a, 0x9660, 0x967a, 0x969a, 0x96b3, 0x96cc, 0x96e5,
	0x96fd, 0x9716, 0x972e, 0x9746, 0x975e, 0x9776, 0x978f, 0x97a8,
	0x97c2, 0x97db, 0x97f3, 0x980c, 0x9824, 0x983c, 0x9856, 0x9870,
	0x9889, 0x98a1, 0x98ba, 0x98d3, 0x98eb, 0x9904, 0x991d, 0x9937,
	0x994f, 0x9968, 0x9981, 0x999b, 0x99b4, 0x99cc, 0x99e6, 0x9a00,
	0x9a19, 0x9a31, 0x9a4a, 0x9a6a, 0x9a8e, 0x9aa0, 0x9aaf, 0x9ad2,
	// Entry 540 - 57F
	0x9af4, 0x9b06, 0x9b1b, 0x9b2e, 0x9b46, 0x9b5f, 0x9b78, 0x9b8c,
	0x9b9f, 0x9bb2, 0x9bc6, 0x9bd9, 0x9bec, 0x9c00, 0x9c1b, 0x9c32,
	0x9c4b, 0x9c67, 0x9c7a, 0x9c94, 0x9ca7, 0x9cbd, 0x9cd1, 0x9cec,
	0x9cff, 0x9d12, 0x9d2e, 0x9d4a, 0x9d5b, 0x9d6d, 0x9d7f, 0x9d92,
	0x9dab, 0x9dbd, 0x9dd5, 0x9ded, 0x9e06, 0x9e18, 0x9e2a, 0x9e3c,
	0x9e4e, 0x9e61, 0x9e73, 0x9e93, 0x9ea6, 0x9ec2, 0x9ed4, 0x9eec,
	0x9efd, 0x9f15, 0x9f2a, 0x9f3e, 0x9f5a, 0x9f6f, 0x9f84, 0x9fa2,
	0x9fbb, 0x9fcd, 0x9fde, 0x9ff1, 0xa004, 0xa014, 0xa025, 0xa038,
	// Entry 580 - 5BF
	0xa049, 0xa05a, 0xa06b, 0xa082, 0xa093, 0xa0a6, 0xa0bd, 0xa0ce,
	0xa0e5, 0xa0f6, 0xa10a, 0xa11c, 0xa132, 0xa142, 0xa15b, 0xa16e,
	0xa17f, 0xa191, 0xa1a3, 0xa1b4, 0xa1c7, 0xa1e9, 0xa208, 0xa22a,
	0xa243, 0xa25f, 0xa271, 0xa282, 0xa298, 0xa2a9, 0xa2bb, 0xa2d3,
	0xa2e9, 0xa301, 0xa30b, 0xa326, 0xa348, 0xa354, 0xa360, 0xa375,
	0xa38d, 0xa39e, 0xa3c6, 0xa3e1, 0xa3ff, 0xa41c, 0xa431, 0xa446,
	0xa477, 0xa48d, 0xa49f, 0xa4b1, 0xa4c3, 0xa4d3, 0xa4e5, 0xa507,
	0xa51b, 0xa535, 0xa548, 0xa56b, 0xa58e, 0xa5b0, 0xa5d3, 0xa5f5,
	// Entry 5C0 - 5FF
	0xa607, 0xa618, 0xa631, 0xa642, 0xa654, 0xa666, 0xa677, 0xa689,
	0xa69a, 0xa6ac, 0xa6bd, 0xa6cf, 0xa6e1, 0xa6f4, 0xa705, 0xa716,
	0xa727, 0xa738, 0xa749, 0xa75c, 0xa783, 0xa7ac, 0xa7d3, 0xa7fe,
	0xa82b, 0xa839, 0xa84a, 0xa85b, 0xa86c, 0xa87d, 0xa88f, 0xa8a1,
	0xa8b2, 0xa8c3, 0xa8dd, 0xa8ee, 0xa8fd, 0xa90c, 0xa91b, 0xa927,
	0xa933, 0xa93f, 0xa94c, 0xa958, 0xa96b, 0xa97d, 0xa98f, 0xa9a4,
	0xa9b9, 0xa9d0, 0xa9df, 0xa9fe, 0xaa26, 0xaa41, 0xaa56, 0xaa70,
	0xaa87, 0xaa9e, 0xaab4, 0xaaca, 0xaae2, 0xaaf9, 0xab10, 0xab26,
	// Entry 600 - 63F
	0xab3e, 0xab56, 0xab6d, 0xab80, 0xab98, 0xabb2, 0xabca, 0xabe3,
	0xabfc, 0xac1a, 0xac32, 0xac5a, 0xac82, 0xac9a, 0xacb7, 0xacd3,
	0xacf3, 0xad0f, 0xad21, 0xad35, 0xad47, 0xad62, 0xad93, 0xada4,
	0xadb7, 0xadca, 0xadec, 0xae1a, 0xae2c, 0xae3e, 0xae65, 0xae78,
	0xae8d, 0xae9f, 0xaeba, 0xaeda, 0xaf08, 0xaf1b, 0xaf2f, 0xaf40,
	0xaf71, 0xaf97, 0xafa9, 0xafc7, 0xafe2, 0xb002, 0xb026, 0xb054,
	0xb079, 0xb08a, 0xb0b0, 0xb0df, 0xb107, 0xb144, 0xb169, 0xb190,
	0xb1b7, 0xb1de, 0xb1f7, 0xb21d, 0xb23d, 0xb24e, 0xb275, 0xb288,
	// Entry 640 - 67F
	0xb2a8, 0xb2cf, 0xb2e2, 0xb2f9, 0xb314, 0xb334, 0xb344, 0xb36b,
	0xb37c, 0xb397, 0xb3aa, 0xb3cf, 0xb3e1, 0xb408, 0xb426, 0xb446,
	0xb46d, 0xb494, 0xb4b5, 0xb4ce, 0xb4e1, 0xb4fd, 0xb525, 0xb542,
	0xb564, 0xb584, 0xb59a, 0xb5c1, 0xb5df, 0xb5fa, 0xb612, 0xb622,
	0xb631, 0xb641, 0xb659, 0xb67e, 0xb68e, 0xb6a5, 0xb6c0, 0xb6de,
	0xb6fe, 0xb70d, 0xb734, 0xb74c, 0xb775, 0xb785, 0xb795, 0xb7ce,
	0xb807, 0xb82a, 0xb844, 0xb85a, 0xb876, 0xb88c, 0xb89e, 0xb8b9,
	0xb8d7, 0xb901, 0xb927, 0xb94b, 0xb960, 0xb977, 0xb987, 0xb997,
	// Entry 680 - 6BF
	0xb9ac, 0xb9c2, 0xb9d8, 0xb9f4, 0xba11, 0xba3c, 0xba51, 0xba72,
	0xba93, 0xbab3, 0xbad2, 0xbaf1, 0xbb12, 0xbb32, 0xbb52, 0xbb71,
	0xbb92, 0xbbb3, 0xbbd3, 0xbbf5, 0xbc15, 0xbc37, 0xbc53, 0xbc76,
	0xbc97, 0xbcae, 0xbcca, 0xbce4, 0xbcfc, 0xbd12, 0xbd29, 0xbd41,
	0xbd5a, 0xbd7e, 0xbda1, 0xbdb3, 0xbdc9, 0xbde2, 0xbdfc, 0xbe14,
	0xbe27, 0xbe46, 0xbe58, 0xbe6b, 0xbe87, 0xbe9b, 0xbebc, 0xbecc,
	0xbedd, 0xbeef, 0xbf01, 0xbf13, 0xbf2e, 0xbf40, 0xbf55, 0xbf67,
	0xbf7b, 0xbf8c, 0xbf9d, 0xbfb2, 0xbfcd, 0xbfdc, 0xbfec, 0xc005,
	// Entry 6C0 - 6FF
	0xc018, 0xc02a, 0xc03c, 0xc04e, 0xc05f, 0xc07a, 0xc096, 0xc0b3,
	0xc0c6, 0xc0d9, 0xc0ed, 0xc100, 0xc113, 0xc127, 0xc139, 0xc14b,
	0xc169, 0xc184, 0xc196, 0xc1a8, 0xc1c1, 0xc1d3, 0xc1e5, 0xc1f1,
	0xc204, 0xc214, 0xc223, 0xc241, 0xc25f, 0xc276, 0xc28d, 0xc2a6,
	0xc2bf, 0xc2cb, 0xc2d9, 0xc2f4, 0xc30f, 0xc327, 0xc35b, 0xc390,
	0xc3c8, 0xc413, 0xc446, 0xc473, 0xc491, 0xc4b6, 0xc4ee, 0xc52c,
	0xc559, 0xc576, 0xc59d, 0xc5c2, 0xc5fc, 0xc62c, 0xc651, 0xc689,
	0xc6ab, 0xc6d4, 0xc70e, 0xc72f, 0xc750, 0xc776, 0xc797, 0xc7b6,
	// Entry 700 - 73F
	0xc7d0, 0xc800, 0xc822, 0xc853, 0xc887, 0xc8c2, 0xc8fe, 0xc939,
	0xc96d, 0xc9aa, 0xc9e9, 0xca2b, 0xca6f, 0xcab2, 0xcaee, 0xcb2c,
	0xcb6f, 0xcbb4, 0xcbf1, 0xcc2f, 0xcc51, 0xcc76, 0xcc87, 0xcc9e,
	0xccb1, 0xccc2, 0xccd3, 0xccea, 0xccfd, 0xcd10, 0xcd23, 0xcd36,
	0xcd49, 0xcd5d, 0xcd6f, 0xcd82, 0xcd95, 0xcdac, 0xcdbf, 0xcdd5,
	0xcdeb, 0xce01, 0xce12, 0xce28, 0xce3e, 0xce55, 0xce67, 0xce79,
	0xce8b, 0xce9f, 0xceb0, 0xcec4, 0xced8, 0xceec, 0xcefc, 0xcf0c,
	0xcf1e, 0xcf32, 0xcf45, 0xcf58, 0xcf66, 0xcf76, 0xcf84, 0xcf94,
	// Entry 740 - 77F
	0xcfa2, 0xcfb2, 0xcfc0, 0xcfd0, 0xcfde, 0xcfee, 0xcffa, 0xd00b,
	0xd019, 0xd026, 0xd033, 0xd042, 0xd050, 0xd05e, 0xd06b, 0xd07a,
	0xd089, 0xd097, 0xd0a3, 0xd0b0, 0xd0bc, 0xd0c8, 0xd0d4, 0xd0e1,
	0xd0ed, 0xd102, 0xd10e, 0xd11b, 0xd128, 0xd135, 0xd142, 0xd150,
	0xd15d, 0xd16a, 0xd178, 0xd185, 0xd193, 0xd1a0, 0xd1ad, 0xd1ba,
	0xd1ce, 0xd1db, 0xd1e9, 0xd1f6, 0xd203, 0xd210, 0xd21d, 0xd232,
	0xd244, 0xd257, 0xd269, 0xd286, 0xd2a2, 0xd2c1, 0xd2e3, 0xd2ff,
	0xd31a, 0xd338, 0xd357, 0xd375, 0xd38d, 0xd3a4, 0xd3b8, 0xd3cd,
	// Entry 780 - 7BF
	0xd3d6, 0xd3ea, 0xd3f8, 0xd406, 0xd415, 0xd423, 0xd438, 0xd44c,
	0xd462, 0xd478, 0xd48b, 0xd49f, 0xd4b3, 0xd4c6, 0xd4da, 0xd4ee,
	0xd503, 0xd519, 0xd52d, 0xd541, 0xd559, 0xd56c, 0xd57f, 0xd597,
	0xd5ab, 0xd5c0, 0xd5d5, 0xd5ea, 0xd5fb, 0xd611, 0xd629, 0xd63e,
	0xd666, 0xd683, 0xd69e, 0xd6b4, 0xd6d4, 0xd6f0, 0xd707, 0xd726,
	0xd741, 0xd757, 0xd778, 0xd794, 0xd7af, 0xd7c5, 0xd7e0, 0xd7fb,
	0xd811, 0xd827, 0xd841, 0xd857, 0xd874, 0xd890, 0xd8ab, 0xd8c4,
	0xd8e0, 0xd900, 0xd91b, 0xd93e, 0xd959, 0xd974, 0xd98e, 0xd9a8,
	// Entry 7C0 - 7FF
	0xd9c5, 0xd9e7, 0xda03, 0xda17, 0xda28, 0xda39, 0xda4a, 0xda5b,
	0xda71, 0xda82, 0xda93, 0xdaa5, 0xdab8, 0xdac9, 0xdada, 0xdaeb,
	0xdafc, 0xdb0d, 0xdb1e, 0xdb2f, 0xdb41, 0xdb52, 0xdb63, 0xdb75,
	0xdb86, 0xdb9d, 0xdbaf, 0xdbc1, 0xdbd9, 0xdbf2, 0xdc09, 0xdc1c,
	0xdc37, 0xdc51, 0xdc6c, 0xdc87, 0xdca2, 0xdcbe, 0xdcd9, 0xdcf3,
	0xdd0e, 0xdd2a, 0xdd45, 0xdd69, 0xdd8b, 0xddb1, 0xddd6, 0xde0b,
	0xde2b, 0xde4c, 0xde74, 0xdea9, 0xdedc, 0xdef7, 0xdf18, 0xdf32,
	0xdf48, 0xdf6f, 0xdf96, 0xdfbc, 0xdfd6, 0xdffe, 0xe025, 0xe045,
	// Entry 800 - 83F
	0xe06c, 0xe093, 0xe0b9, 0xe0e0, 0xe11a, 0xe133, 0xe14c, 0xe166,
	0xe17a, 0xe197, 0xe1ac, 0xe1c1, 0xe1d6, 0xe1f7, 0xe217, 0xe23a,
	0xe259, 0xe277, 0xe293, 0xe2ad, 0xe2c9, 0xe2ea, 0xe306, 0xe321,
	0xe33a, 0xe34c, 0xe35e, 0xe370, 0xe385, 0xe39a, 0xe3af, 0xe3c8,
	0xe3e2, 0xe3f8, 0xe411, 0xe42b, 0xe441, 0xe455, 0xe469, 0xe47d,
	0xe492, 0xe4a8, 0xe4c3, 0xe4de, 0xe4f9, 0xe515, 0xe530, 0xe54c,
	0xe56f, 0xe59b, 0xe5c0, 0xe5d5, 0xe5f5, 0xe619, 0xe634, 0xe64c,
	0xe663, 0xe67c, 0xe68f, 0xe6a3, 0xe6b6, 0xe6ca, 0xe6dd, 0xe6f1,
	// Entry 840 - 87F
	0xe70c, 0xe727, 0xe741, 0xe75a, 0xe76d, 0xe781, 0xe79b, 0xe7b4,
	0xe7c7, 0xe7db, 0xe7ef, 0xe804, 0xe818, 0xe82d, 0xe842, 0xe856,
	0xe86b, 0xe87f, 0xe894, 0xe8a9, 0xe8be, 0xe8d4, 0xe8e9, 0xe8ff,
	0xe914, 0xe928, 0xe93d, 0xe951, 0xe966, 0xe97a, 0xe990, 0xe9a4,
	0xe9b9, 0xe9cd, 0xe9e2, 0xe9f6, 0xea0a, 0xea1e, 0xea33, 0xea47,
	0xea5c, 0xea72, 0xea86, 0xea9b, 0xeab0, 0xeac4, 0xead8, 0xeaf0,
	0xeb09, 0xeb1e, 0xeb36, 0xeb4e, 0xeb65, 0xeb7d, 0xeb94, 0xebac,
	0xebcb, 0xebeb, 0xec09, 0xec26, 0xec3d, 0xec55, 0xec73, 0xec90,
	// Entry 880 - 8BF
	0xeca7, 0xecbf, 0xecd5, 0xecfa, 0xed12, 0xed1f, 0xed3c, 0xed5b,
	0xed72, 0xed89, 0xedac, 0xedc4, 0xeddd, 0xedf1, 0xee07, 0xee1d,
	0xee31, 0xee48, 0xee5d, 0xee71, 0xee86, 0xeea2, 0xeebe, 0xeedd,
	0xeefd, 0xef0d, 0xef24, 0xef39, 0xef4d, 0xef61, 0xef77, 0xef8c,
	0xefa1, 0xefb5, 0xefcb, 0xefe1, 0xeff6, 0xf012, 0xf032, 0xf04c,
	0xf060, 0xf075, 0xf089, 0xf09d, 0xf0b2, 0xf0cf, 0xf0e4, 0xf0fe,
	0xf113, 0xf128, 0xf146, 0xf15c, 0xf171, 0xf17d, 0xf195, 0xf1aa,
	0xf1be, 0xf1ce, 0xf1df, 0xf1ef, 0xf200, 0xf210, 0xf221, 0xf239,
	// Entry 8C0 - 8FF
	0xf251, 0xf261, 0xf272, 0xf282, 0xf293, 0xf2a4, 0xf2b6, 0xf2c7,
	0xf2d9, 0xf2eb, 0xf2fc, 0xf30e, 0xf31f, 0xf331, 0xf343, 0xf355,
	0xf368, 0xf37a, 0xf38d, 0xf39f, 0xf3b0, 0xf3c2, 0xf3d3, 0xf3e5,
	0xf3f6, 0xf407, 0xf419, 0xf42a, 0xf43c, 0xf44d, 0xf45e, 0xf46f,
	0xf480, 0xf492, 0xf4a4, 0xf4b5, 0xf4c6, 0xf4d8, 0xf4ed, 0xf502,
	0xf516, 0xf52b, 0xf53f, 0xf554, 0xf570, 0xf58d, 0xf5a1, 0xf5b6,
	0xf5ca, 0xf5df, 0xf5f2, 0xf60a, 0xf620, 0xf632, 0xf644, 0xf656,
	0xf66f, 0xf688, 0xf6a4, 0xf6c1, 0xf6d3, 0xf6e4, 0xf6f5, 0xf708,
	// Entry 900 - 93F
	0xf71a, 0xf72c, 0xf73d, 0xf750, 0xf763, 0xf775, 0xf79b, 0xf7c0,
	0xf7d2, 0xf7e4, 0xf802, 0xf820, 0xf840, 0xf85f, 0xf897, 0xf8bb,
	0xf8c9, 0xf8db, 0xf8f8, 0xf911, 0xf924, 0xf93c, 0xf94f, 0xf964,
	0xf975, 0xf987, 0xf998, 0xf9aa, 0xf9bb, 0xf9cd, 0xf9df, 0xf9f1,
	0xfa03, 0xfa15, 0xfa27, 0xfa3a, 0xfa4c, 0xfa5f, 0xfa72, 0xfa84,
	0xfa97, 0xfaa9, 0xfabc, 0xfacf, 0xfae2, 0xfaf6, 0xfb09, 0xfb1d,
	0xfb30, 0xfb42, 0xfb55, 0xfb67, 0xfb7a, 0xfb8c, 0xfb9e, 0xfbb1,
	0xfbc3, 0xfbd6, 0xfbe8, 0xfbfa, 0xfc0c, 0xfc1e, 0xfc31, 0xfc43,
	// Entry 940 - 97F
	0xfc56, 0xfc68, 0xfc7a, 0xfc8d, 0xfca3, 0xfcb8, 0xfcce, 0xfce3,
	0xfcf9, 0xfd0f, 0xfd25, 0xfd3b, 0xfd51, 0xfd65, 0xfd78, 0xfd8c,
	0xfda0, 0xfdb2, 0xfdc5, 0xfdd7, 0xfdea, 0xfdfc, 0xfe0e, 0xfe22,
	0xfe35, 0xfe48, 0xfe5a, 0xfe6e, 0xfe82, 0xfe95, 0xfea3, 0xfeb1,
	0xfebd, 0xfec9, 0xfeda, 0xfeee, 0xff08, 0xff21, 0xff37, 0xff4c,
	0xff5d, 0xff6f, 0xff80, 0xff92, 0xffa3, 0xffb5, 0xffce, 0xffe7,
	0xfffe, 0x000f, 0x0021, 0x0038, 0x0049, 0x005b, 0x006d, 0x0080,
	0x0092, 0x00a5, 0x00b8, 0x00ca, 0x00dd, 0x00ef, 0x0102, 0x0115,
	// Entry 980 - 9BF
	0x0128, 0x013c, 0x014f, 0x0163, 0x0176, 0x0188, 0x019b, 0x01ad,
	0x01c0, 0x01d2, 0x01e4, 0x01f7, 0x0209, 0x021c, 0x022e, 0x0240,
	0x0252, 0x0264, 0x0277, 0x0289, 0x029c, 0x02af, 0x02c1, 0x02d3,
	0x02e6, 0x02fc, 0x0312, 0x0327, 0x033d, 0x0352, 0x0368, 0x0385,
	0x03a3, 0x03bf, 0x03d4, 0x03ea, 0x0406, 0x041b, 0x0431, 0x0445,
	0x0450, 0x046a, 0x0484, 0x04a1, 0x04bf, 0x04d2, 0x04e4, 0x04f6,
	0x050a, 0x051d, 0x0530, 0x0542, 0x0556, 0x056a, 0x057d, 0x0597,
	0x05aa, 0x05bd, 0x05d0, 0x05e4, 0x05f8, 0x061b, 0x063b, 0x065f,
	// Entry 9C0 - 9FF
	0x0675, 0x0688, 0x069a, 0x06a8, 0x06b7, 0x06c5, 0x06d4, 0x06e2,
	0x06f1, 0x0707, 0x071d, 0x072b, 0x073a, 0x0748, 0x0757, 0x0766,
	0x0776, 0x0785, 0x0795, 0x07a5, 0x07b4, 0x07c4, 0x07d3, 0x07e3,
	0x07f3, 0x0803, 0x0814, 0x0824, 0x0835, 0x0845, 0x0854, 0x0864,
	0x0873, 0x0883, 0x0892, 0x08a1, 0x08b1, 0x08c0, 0x08d0, 0x08df,
	0x08ee, 0x08fd, 0x090c, 0x091c, 0x092b, 0x093b, 0x094b, 0x095a,
	0x0969, 0x0979, 0x098c, 0x099f, 0x09b1, 0x09c4, 0x09d6, 0x09e9,
	0x0a03, 0x0a1e, 0x0a30, 0x0a43, 0x0a55, 0x0a68, 0x0a79, 0x0a8d,
	// Entry A00 - A3F
	0x0aa1, 0x0ab1, 0x0ac1, 0x0ad1, 0x0ae8, 0x0aff, 0x0b19, 0x0b34,
	0x0b44, 0x0b53, 0x0b62, 0x0b73, 0x0b83, 0x0b93, 0x0ba2, 0x0bb3,
	0x0bc4, 0x0bd4, 0x0be0, 0x0bef, 0x0c09, 0x0c20, 0x0c3d, 0x0c59,
	0x0c72, 0x0c91, 0x0ca4, 0x0cb6, 0x0cc4, 0x0cd3, 0x0ce1, 0x0cf0,
	0x0cfe, 0x0d0d, 0x0d1b, 0x0d2a, 0x0d39, 0x0d47, 0x0d56, 0x0d65,
	0x0d74, 0x0d84, 0x0d93, 0x0da2, 0x0db2, 0x0dc2, 0x0dd2, 0x0de1,
	0x0df0, 0x0e01, 0x0e10, 0x0e1f, 0x0e2e, 0x0e3d, 0x0e4d, 0x0e5c,
	0x0e6c, 0x0e7d, 0x0e8c, 0x0e9c, 0x0eac, 0x0ebb, 0x0eca, 0x0edd,
	// Entry A40 - A7F
	0x0eef, 0x0f02, 0x0f14, 0x0f27, 0x0f39, 0x0f4c, 0x0f5f, 0x0f71,
	0x0f84, 0x0f97, 0x0fa8, 0x0fb0, 0x0fc4, 0x0fd4, 0x0fe3, 0x0ff2,
	0x1003, 0x1013, 0x1023, 0x1032, 0x1043, 0x1054, 0x1064, 0x1074,
	0x108c, 0x10a5, 0x10b3, 0x10c3, 0x10d2, 0x10e2, 0x10f3, 0x1106,
	0x1116, 0x1127, 0x114e, 0x1165, 0x1179, 0x118c, 0x11b0, 0x11bf,
	0x11cf, 0x11de, 0x11ee, 0x11fd, 0x120d, 0x1224, 0x123b, 0x124a,
	0x125a, 0x126a, 0x1279, 0x1289, 0x1299, 0x12a9, 0x12ba, 0x12ca,
	0x12db, 0x12ec, 0x12fc, 0x130d, 0x131d, 0x132e, 0x133f, 0x1350,
	// Entry A80 - ABF
	0x1362, 0x1373, 0x1385, 0x1396, 0x13a6, 0x13b7, 0x13c7, 0x13d8,
	0x13e8, 0x13f8, 0x1409, 0x1419, 0x142a, 0x143a, 0x144a, 0x145a,
	0x146b, 0x147b, 0x148c, 0x149e, 0x14ae, 0x14bf, 0x14d0, 0x14e0,
	0x14f0, 0x1504, 0x1518, 0x152b, 0x153f, 0x1552, 0x1566, 0x1581,
	0x159d, 0x15b0, 0x15c4, 0x15d8, 0x15eb, 0x15ff, 0x1613, 0x1625,
	0x1637, 0x164c, 0x165d, 0x166e, 0x1680, 0x1698, 0x16b0, 0x16cb,
	0x16e7, 0x16f8, 0x1708, 0x1718, 0x172a, 0x173b, 0x174c, 0x175c,
	0x176e, 0x1780, 0x1791, 0x17c2, 0x17f2, 0x1822, 0x1854, 0x1885,
	// Entry AC0 - AFF
	0x18b6, 0x18e9, 0x18fa, 0x191a, 0x1932, 0x1947, 0x195b, 0x196f,
	0x197f, 0x1990, 0x19a0, 0x19b1, 0x19c1, 0x19d2, 0x19ea, 0x1a02,
	0x1a12, 0x1a23, 0x1a34, 0x1a44, 0x1a55, 0x1a66, 0x1a77, 0x1a89,
	0x1a9a, 0x1aac, 0x1abe, 0x1acf, 0x1ae1, 0x1af2, 0x1b04, 0x1b16,
	0x1b28, 0x1b3b, 0x1b4d, 0x1b60, 0x1b72, 0x1b83, 0x1b95, 0x1ba6,
	0x1bb8, 0x1bc9, 0x1bda, 0x1bec, 0x1bfd, 0x1c0f, 0x1c20, 0x1c31,
	0x1c42, 0x1c54, 0x1c65, 0x1c77, 0x1c88, 0x1c9a, 0x1cac, 0x1cbd,
	0x1cce, 0x1ce0, 0x1cf5, 0x1d0a, 0x1d1e, 0x1d33, 0x1d47, 0x1d5c,
	// Entry B00 - B3F
	0x1d78, 0x1d95, 0x1da9, 0x1dbe, 0x1dd3, 0x1de7, 0x1dfc, 0x1e11,
	0x1e24, 0x1e37, 0x1e4d, 0x1e5e, 0x1e77, 0x1e90, 0x1eac, 0x1ec9,
	0x1edb, 0x1eec, 0x1efd, 0x1f10, 0x1f22, 0x1f34, 0x1f45, 0x1f58,
	0x1f6b, 0x1f7d, 0x1f95, 0x1fad, 0x1fd4, 0x1fee, 0x2005, 0x201b,
	0x202d, 0x2040, 0x2052, 0x2065, 0x2077, 0x208a, 0x20a4, 0x20be,
	0x20d0, 0x20e3, 0x20f6, 0x2108, 0x211b, 0x212e, 0x2141, 0x2155,
	0x2168, 0x217c, 0x2190, 0x21a3, 0x21b7, 0x21ca, 0x21de, 0x21f2,
	0x2206, 0x221b, 0x222f, 0x2244, 0x2258, 0x226b, 0x227f, 0x2292,
	// Entry B40 - B7F
	0x22a6, 0x22b9, 0x22ce, 0x22e1, 0x22f5, 0x2308, 0x231c, 0x232f,
	0x2342, 0x2355, 0x2369, 0x237c, 0x2390, 0x23a5, 0x23b8, 0x23cc,
	0x23e0, 0x23f3, 0x2406, 0x241b, 0x243d, 0x245b, 0x2472, 0x2489,
	0x249f, 0x24b6, 0x24cc, 0x24e3, 0x2501, 0x2520, 0x2536, 0x254d,
	0x2564, 0x257a, 0x2591, 0x25a8, 0x25bd, 0x25d6, 0x25e9, 0x2602,
	0x261b, 0x2636, 0x264e, 0x267d, 0x269c, 0x26bf, 0x26df, 0x26fb,
	0x271e, 0x273a, 0x2755, 0x2770, 0x278b, 0x27a9, 0x27c8, 0x27dc,
	0x27ef, 0x2802, 0x2817, 0x282b, 0x283f, 0x2852, 0x2867, 0x287c,
	// Entry B80 - BBF
	0x2890, 0x28a4, 0x28c0, 0x28dd, 0x28fb, 0x2916, 0x2937, 0x2957,
	0x2974, 0x2997, 0x29aa, 0x29c4, 0x29dd, 0x29f7, 0x2a10, 0x2a2a,
	0x2a43, 0x2a5a, 0x2a70, 0x2a85, 0x2a9b, 0x2ab1, 0x2ac8, 0x2add,
	0x2af3, 0x2b08, 0x2b1e, 0x2b35, 0x2b4d, 0x2b64, 0x2b7c, 0x2b91,
	0x2ba7, 0x2bbd, 0x2bd2, 0x2be8, 0x2bfe, 0x2c1f, 0x2c41, 0x2c62,
	0x2c84, 0x2ca5, 0x2cc3, 0x2ce4, 0x2d06, 0x2d27, 0x2d49, 0x2d6a,
	0x2d95, 0x2db3, 0x2dd5, 0x2df8, 0x2e1a, 0x2e3d, 0x2e5d, 0x2e7c,
	0x2e9d, 0x2ebf, 0x2ee0, 0x2f02, 0x2f20, 0x2f3e, 0x2f5f, 0x2f81,
	// Entry BC0 - BFF
	0x2fa2, 0x2fc4, 0x2fda, 0x2ff5, 0x300b, 0x3021, 0x303f, 0x3055,
	0x3073, 0x3093, 0x30b1, 0x30c7, 0x30e7, 0x30fd, 0x3113, 0x3130,
	0x3153, 0x3175, 0x3196, 0x31b6, 0x31d8, 0x31f9, 0x3218, 0x3232,
	0x3251, 0x326e, 0x3297, 0x32c5, 0x32ef, 0x330d, 0x3324, 0x333a,
	0x3350, 0x3368, 0x337f, 0x3396, 0x33ac, 0x33c4, 0x33dc, 0x33f3,
	0x3417, 0x343a, 0x3458, 0x346d, 0x3484, 0x349c, 0x34b4, 0x34cb,
	0x34e5, 0x34fb, 0x3512, 0x352a, 0x3542, 0x3556, 0x356d, 0x3583,
	0x359a, 0x35b1, 0x35c8, 0x35e5, 0x35ff, 0x3614, 0x3629, 0x363e,
	// Entry C00 - C3F
	0x3656, 0x366f, 0x3687, 0x369b, 0x36b3, 0x36c8, 0x36e0, 0x36f4,
	0x370b, 0x3720, 0x373a, 0x374e, 0x3763, 0x3778, 0x3789, 0x379f,
	0x37b0, 0x37c6, 0x37dc, 0x37f2, 0x3807, 0x381c, 0x3833, 0x3847,
	0x385f, 0x3877, 0x388c, 0x38a7, 0x38bd, 0x38d3, 0x38e8, 0x38fe,
	0x3914, 0x392b, 0x3940, 0x3956, 0x396c, 0x3985, 0x399a, 0x39b0,
	0x39c5, 0x39e3, 0x3a02, 0x3a1c, 0x3a33, 0x3a4b, 0x3a60, 0x3a76,
	0x3a8c, 0x3aa7, 0x3ac1, 0x3ad8, 0x3aef, 0x3b05, 0x3b14, 0x3b22,
	0x3b30, 0x3b40, 0x3b4f, 0x3b5e, 0x3b6c, 0x3b7c, 0x3b8c, 0x3b9b,
	// Entry C40 - C7F
	0x3bb4, 0x3bc9, 0x3bd6, 0x3be9, 0x3bfb, 0x3c09, 0x3c16, 0x3c27,
	0x3c35, 0x3c42, 0x3c4f, 0x3c62, 0x3c74, 0x3c81, 0x3c8e, 0x3c9b,
	0x3cae, 0x3cbf, 0x3cd1, 0x3ce3, 0x3cf0, 0x3cfd, 0x3d0f, 0x3d21,
	0x3d2e, 0x3d40, 0x3d52, 0x3d5e, 0x3d6f, 0x3d7b, 0x3d8b, 0x3da1,
	0x3db2, 0x3dc3, 0x3dd3, 0x3de4, 0x3df4, 0x3e05, 0x3e15, 0x3e26,
	0x3e3c, 0x3e51, 0x3e67, 0x3e77, 0x3e88, 0x3e98, 0x3ea9, 0x3eba,
	0x3ec3, 0x3ed2, 0x3ee2, 0x3ef1, 0x3f04, 0x3f19, 0x3f26, 0x3f34,
	0x3f41, 0x3f4e, 0x3f5d, 0x3f6b, 0x3f79, 0x3f86, 0x3f95, 0x3fa4,
	// Entry C80 - CBF
	0x3fb2, 0x3fbb, 0x3fc4, 0x3fd6, 0x3fe9, 0x3ffc, 0x4021, 0x404b,
	0x4076, 0x409a, 0x40be, 0x40e5, 0x4107, 0x411e, 0x4138, 0x4156,
	0x4176, 0x4198, 0x41a9, 0x41bf, 0x41d6, 0x41f2, 0x4213, 0x422e,
	0x4258, 0x426f, 0x428f, 0x42af, 0x42de, 0x4301, 0x4327, 0x4342,
	0x435e, 0x4379, 0x4393, 0x43ae, 0x43cd, 0x43df, 0x43f0, 0x4401,
	0x4414, 0x4426, 0x4438, 0x4449, 0x445c, 0x446f, 0x4481, 0x4497,
	0x44ad, 0x44c5, 0x44dc, 0x44f3, 0x4509, 0x4521, 0x4539, 0x4550,
	0x4567, 0x457f, 0x459e, 0x45c9, 0x45eb, 0x45ff, 0x4615, 0x4630,
	// Entry CC0 - CFF
	0x464b, 0x4666, 0x4681, 0x4697, 0x46ad, 0x46be, 0x46d0, 0x46e1,
	0x46f3, 0x4705, 0x4716, 0x4728, 0x4739, 0x474b, 0x475d, 0x4770,
	0x4782, 0x4795, 0x47a7, 0x47b8, 0x47ca, 0x47db, 0x47ed, 0x47fe,
	0x480f, 0x4821, 0x4832, 0x4844, 0x4855, 0x4867, 0x487a, 0x488c,
	0x489f, 0x48b0, 0x48c2, 0x48d3, 0x48e4, 0x48f5, 0x4906, 0x4917,
	0x4929, 0x493b, 0x494c, 0x495d, 0x496d, 0x4980, 0x499c, 0x49ae,
	0x49c0, 0x49d5, 0x49e9, 0x49fe, 0x4a12, 0x4a27, 0x4a43, 0x4a60,
	0x4a7c, 0x4a99, 0x4aad, 0x4ac2, 0x4ad6, 0x4aeb, 0x4b06, 0x4b1c,
	// Entry D00 - D3F
	0x4b39, 0x4b57, 0x4b72, 0x4b87, 0x4b9b, 0x4bae, 0x4bc4, 0x4bdb,
	0x4bf3, 0x4c08, 0x4c24, 0x4c40, 0x4c5e, 0x4c80, 0x4c9f, 0x4cc7,
	0x4ce2, 0x4cfe, 0x4d19, 0x4d35, 0x4d51, 0x4d6c, 0x4d88, 0x4da3,
	0x4dbf, 0x4ddb, 0x4df8, 0x4e14, 0x4e31, 0x4e4d, 0x4e68, 0x4e84,
	0x4e9f, 0x4ebb, 0x4ed6, 0x4ef1, 0x4f0d, 0x4f28, 0x4f44, 0x4f5f,
	0x4f7b, 0x4f98, 0x4fb4, 0x4fd1, 0x4fec, 0x5008, 0x5023, 0x503e,
	0x5059, 0x5074, 0x508f, 0x50ab, 0x50c7, 0x50e2, 0x50fd, 0x5117,
	0x5134, 0x515a, 0x5180, 0x51a6, 0x51b7, 0x51d5, 0x51f9, 0x521d,
	// Entry D40 - D7F
	0x5240, 0x5264, 0x527a, 0x5290, 0x52a9, 0x52c9, 0x52df, 0x52f4,
	0x5315, 0x5336, 0x5357, 0x5376, 0x5390, 0x53b4, 0x53d7, 0x53ee,
	0x541e, 0x544e, 0x5466, 0x547d, 0x549f, 0x54c0, 0x54e0, 0x5501,
	0x5512, 0x5524, 0x5535, 0x5547, 0x5559, 0x556a, 0x557c, 0x558d,
	0x559f, 0x55b1, 0x55c4, 0x55d6, 0x55e9, 0x55fb, 0x560e, 0x5620,
	0x5631, 0x5643, 0x5654, 0x5666, 0x5677, 0x5688, 0x569a, 0x56ab,
	0x56bd, 0x56ce, 0x56df, 0x56f0, 0x5701, 0x5712, 0x5723, 0x5734,
	0x5746, 0x5756, 0x576b, 0x577b, 0x578c, 0x579c, 0x57ad, 0x57bd,
	// Entry D80 - DBF
	0x57d1, 0x57e1, 0x57f2, 0x580c, 0x5821, 0x5835, 0x584a, 0x585e,
	0x5873, 0x5887, 0x589c, 0x58b5, 0x58cd, 0x58e7, 0x58fc, 0x5912,
	0x5926, 0x5939, 0x594a, 0x596a, 0x598a, 0x59aa, 0x59ca, 0x59e1,
	0x59f3, 0x5a04, 0x5a15, 0x5a28, 0x5a3a, 0x5a4c, 0x5a5d, 0x5a70,
	0x5a83, 0x5a95, 0x5ab0, 0x5ac4, 0x5adb, 0x5af3, 0x5b10, 0x5b27,
	0x5b39, 0x5b4b, 0x5b63, 0x5b7c, 0x5b94, 0x5bad, 0x5bc9, 0x5be6,
	0x5c02, 0x5c1f, 0x5c35, 0x5c4b, 0x5c61, 0x5c77, 0x5c9b, 0x5cbf,
	0x5ce3, 0x5d00, 0x5d20, 0x5d42, 0x5d65, 0x5d89, 0x5dad, 0x5dd4,
	// Entry DC0 - DFF
	0x5dfb, 0x5e20, 0x5e45, 0x5e6a, 0x5e8f, 0x5eb4, 0x5ed8, 0x5efc,
	0x5f21, 0x5f40, 0x5f5b, 0x5f75, 0x5f90, 0x5fa6, 0x5fbd, 0x5fd3,
	0x5fe9, 0x5fff, 0x6016, 0x602c, 0x6042, 0x6059, 0x606f, 0x6085,
	0x609c, 0x60b2, 0x60d7, 0x60f1, 0x610a, 0x6129, 0x6148, 0x6160,
	0x6178, 0x6190, 0x61a8, 0x61c8, 0x61e8, 0x620f, 0x622e, 0x624f,
	0x6266, 0x627c, 0x6292, 0x62aa, 0x62c1, 0x62d8, 0x62ee, 0x6306,
	0x631e, 0x6335, 0x634f, 0x6369, 0x6383, 0x639e, 0x63b5, 0x63d4,
	0x63ee, 0x6409, 0x6424, 0x643f, 0x6459, 0x6474, 0x648f, 0x64aa,
	// Entry E00 - E3F
	0x64c4, 0x64df, 0x64fa, 0x6515, 0x6530, 0x654a, 0x6565, 0x6581,
	0x659c, 0x65b7, 0x65d2, 0x65ec, 0x6608, 0x6624, 0x6640, 0x665b,
	0x6677, 0x6693, 0x66ae, 0x66c9, 0x66e4, 0x6700, 0x671b, 0x6737,
	0x6752, 0x676c, 0x6787, 0x67a1, 0x67bc, 0x67d7, 0x67f1, 0x680c,
	0x681e, 0x6831, 0x6844, 0x6857, 0x6869, 0x687c, 0x688f, 0x68a2,
	0x68b4, 0x68c7, 0x68da, 0x68ed, 0x6900, 0x6912, 0x6925, 0x6939,
	0x694c, 0x695f, 0x6972, 0x6984, 0x6998, 0x69ac, 0x69c0, 0x69d3,
	0x69e7, 0x69fb, 0x6a0e, 0x6a21, 0x6a34, 0x6a48, 0x6a5b, 0x6a6f,
	// Entry E40 - E7F
	0x6a82, 0x6a94, 0x6aa7, 0x6ab9, 0x6acc, 0x6adf, 0x6af1, 0x6b03,
	0x6b18, 0x6b32, 0x6b45, 0x6b61, 0x6b7d, 0x6b90, 0x6ba9, 0x6bc4,
	0x6bda, 0x6bf5, 0x6c0a, 0x6c20, 0x6c3b, 0x6c50, 0x6c65, 0x6c7a,
	0x6c94, 0x6ca8, 0x6cc1, 0x6cd6, 0x6ceb, 0x6d05, 0x6d1c, 0x6d33,
	0x6d4a, 0x6d61, 0x6d76, 0x6d92, 0x6dac, 0x6dc8, 0x6de3, 0x6e00,
	0x6e1b, 0x6e35, 0x6e50, 0x6e6d, 0x6e88, 0x6ea5, 0x6ec1, 0x6edc,
	0x6ef8, 0x6f12, 0x6f33, 0x6f54, 0x6f74, 0x6f93, 0x6fb3, 0x6fce,
	0x6feb, 0x7008, 0x7025, 0x7042, 0x7064, 0x707f, 0x7099, 0x70b4,
	// Entry E80 - EBF
	0x70ce, 0x70e8, 0x7102, 0x7123, 0x7141, 0x715b, 0x7175, 0x7191,
	0x71ad, 0x71c9, 0x71e5, 0x71ff, 0x721b, 0x723c, 0x725b, 0x727f,
	0x7296, 0x72b2, 0x72ce, 0x72e9, 0x7304, 0x731e, 0x733b, 0x7355,
	0x7370, 0x738d, 0x73aa, 0x73c7, 0x73df, 0x73fa, 0x7417, 0x7439,
	0x7459, 0x747e, 0x749d, 0x74ba, 0x74d9, 0x74fb, 0x7518, 0x7537,
	0x7551, 0x756c, 0x7589, 0x75a3, 0x75be, 0x75d9, 0x75f5, 0x760b,
	0x7622, 0x7634, 0x7647, 0x765a, 0x766e, 0x7681, 0x7693, 0x76a7,
	0x76ba, 0x76cc, 0x76df, 0x76f3, 0x7706, 0x7719, 0x772b, 0x773f,
	// Entry EC0 - EFF
	0x7752, 0x7765, 0x7778, 0x778b, 0x779e, 0x77b0, 0x77c4, 0x77d8,
	0x77ed, 0x7803, 0x7818, 0x782d, 0x7843, 0x7859, 0x786f, 0x7884,
	0x7898, 0x78ad, 0x78c1, 0x78d5, 0x78eb, 0x7902, 0x7919, 0x792e,
	0x7943, 0x7957, 0x796c, 0x7984, 0x7999, 0x79ad, 0x79c2, 0x79d8,
	0x79ed, 0x7a04, 0x7a1a, 0x7a2f, 0x7a44, 0x7a59, 0x7a6f, 0x7a84,
	0x7a98, 0x7aad, 0x7ac1, 0x7ad5, 0x7aea, 0x7b02, 0x7b18, 0x7b31,
	0x7b49, 0x7b61, 0x7b7c, 0x7b91, 0x7ba6, 0x7bbd, 0x7bd2, 0x7be8,
	0x7bff, 0x7c1b, 0x7c37, 0x7c4d, 0x7c69, 0x7c85, 0x7c9c, 0x7cb2,
	// Entry F00 - F3F
	0x7ccf, 0x7ceb, 0x7d07, 0x7d22, 0x7d40, 0x7d5e, 0x7d7a, 0x7d90,
	0x7da6, 0x7dc1, 0x7dd6, 0x7df0, 0x7e06, 0x7e1c, 0x7e34, 0x7e4c,
	0x7e64, 0x7e7c, 0x7e92, 0x7eaf, 0x7ed2, 0x7eef, 0x7f0c, 0x7f27,
	0x7f45, 0x7f63, 0x7f81, 0x7f9e, 0x7fc0, 0x7fdc, 0x7ff9, 0x801c,
	0x8037, 0x805a, 0x807b, 0x809c, 0x80be, 0x80e2, 0x8102, 0x8120,
	0x813e, 0x8160, 0x817d, 0x8199, 0x81b5, 0x81d0, 0x81f0, 0x820e,
	0x822c, 0x8248, 0x8266, 0x8282, 0x82a0, 0x82bc, 0x82da, 0x82f6,
	0x8312, 0x832d, 0x8348, 0x8360, 0x837d, 0x839f, 0x83ba, 0x83d8,
	// Entry F40 - F7F
	0x83f1, 0x840f, 0x8430, 0x844e, 0x846e, 0x848a, 0x84a6, 0x84c2,
	0x84de, 0x84fa, 0x8517, 0x8534, 0x8553, 0x8572, 0x858f, 0x85aa,
	0x85be, 0x85d2, 0x85e6, 0x85fb, 0x8610, 0x8624, 0x8638, 0x864d,
	0x8661, 0x8675, 0x8689, 0x869e, 0x86b3, 0x86c7, 0x86db, 0x86f0,
	0x8705, 0x871a, 0x872f, 0x8745, 0x875b, 0x8770, 0x8785, 0x879b,
	0x87af, 0x87c3, 0x87d7, 0x87ec, 0x8801, 0x8815, 0x8829, 0x883e,
	0x8853, 0x8868, 0x887d, 0x8893, 0x88a9, 0x88be, 0x88d3, 0x88e9,
	0x88fd, 0x8911, 0x8925, 0x893a, 0x894f, 0x8963, 0x8977, 0x898c,
	// Entry F80 - FBF
	0x89a0, 0x89b4, 0x89c8, 0x89dd, 0x89f2, 0x8a06, 0x8a1a, 0x8a2f,
	0x8a44, 0x8a59, 0x8a6e, 0x8a84, 0x8a9a, 0x8aaf, 0x8ac4, 0x8ada,
	0x8aee, 0x8b02, 0x8b16, 0x8b2b, 0x8b40, 0x8b54, 0x8b68, 0x8b7d,
	0x8b92, 0x8ba7, 0x8bbd, 0x8bd3, 0x8be8, 0x8bfd, 0x8c12, 0x8c27,
	0x8c3d, 0x8c53, 0x8c68, 0x8c7d, 0x8c93, 0x8ca9, 0x8cc0, 0x8cd7,
	0x8ced, 0x8d01, 0x8d15, 0x8d29, 0x8d3e, 0x8d53, 0x8d67, 0x8d7b,
	0x8d90, 0x8da4, 0x8db8, 0x8dcc, 0x8de1, 0x8df6, 0x8e0a, 0x8e1e,
	0x8e33, 0x8e47, 0x8e5b, 0x8e6f, 0x8e84, 0x8e99, 0x8ead, 0x8ec1,
	// Entry FC0 - FFF
	0x8ed6, 0x8eea, 0x8efe, 0x8f12, 0x8f27, 0x8f3c, 0x8f50, 0x8f64,
	0x8f79, 0x8f8d, 0x8fa1, 0x8fb5, 0x8fca, 0x8fdf, 0x8ff3, 0x9007,
	0x901c, 0x9031, 0x9046, 0x905c, 0x9072, 0x9087, 0x909b, 0x90af,
	0x90c3, 0x90d8, 0x90ed, 0x9101, 0x9115, 0x912a, 0x913f, 0x9154,
	0x9169, 0x917f, 0x9195, 0x91aa, 0x91bf, 0x91d5, 0x91f0, 0x920b,
	0x9226, 0x9242, 0x925e, 0x9279, 0x9294, 0x92b0, 0x92c4, 0x92d8,
	0x92ec, 0x9301, 0x9316, 0x932a, 0x933e, 0x9353, 0x9368, 0x937d,
	0x9393, 0x93a9, 0x93be, 0x93d3, 0x93e8, 0x93fd, 0x9413, 0x9429,
	// Entry 1000 - 103F
	0x943e, 0x9453, 0x9469, 0x947f, 0x9496, 0x94ad, 0x94c3, 0x94d7,
	0x94eb, 0x94ff, 0x9514, 0x9529, 0x953d, 0x9551, 0x9566, 0x9584,
	0x95a2, 0x95c0, 0x95df, 0x95fe, 0x961c, 0x963a, 0x964e, 0x9662,
	0x9676, 0x968b, 0x96a0, 0x96b4, 0x96c8, 0x96dd, 0x96f2, 0x9707,
	0x971c, 0x9732, 0x9748, 0x975d, 0x9772, 0x9788, 0x979c, 0x97b0,
	0x97c4, 0x97d9, 0x97ee, 0x9802, 0x9816, 0x982b, 0x983f, 0x9853,
	0x9867, 0x987c, 0x9891, 0x98a5, 0x98b9, 0x98ce, 0x98e3, 0x98f8,
	0x990d, 0x9923, 0x9939, 0x994e, 0x9963, 0x9979, 0x998d, 0x99a1,
	// Entry 1040 - 107F
	0x99b5, 0x99ca, 0x99df, 0x99f3, 0x9a07, 0x9a1c, 0x9a30, 0x9a44,
	0x9a58, 0x9a6d, 0x9a82, 0x9a96, 0x9aaa, 0x9abf, 0x9ad4, 0x9ae9,
	0x9aff, 0x9b15, 0x9b2a, 0x9b3f, 0x9b54, 0x9b69, 0x9b7f, 0x9b95,
	0x9baa, 0x9bbf, 0x9bd6, 0x9beb, 0x9c00, 0x9c15, 0x9c2b, 0x9c41,
	0x9c56, 0x9c6b, 0x9c81, 0x9c96, 0x9cab, 0x9cc0, 0x9cd6, 0x9cec,
	0x9d01, 0x9d16, 0x9d2c, 0x9d41, 0x9d56, 0x9d6b, 0x9d81, 0x9d97,
	0x9dac, 0x9dc1, 0x9dd7, 0x9dec, 0x9e01, 0x9e16, 0x9e2c, 0x9e42,
	0x9e57, 0x9e6c, 0x9e82, 0x9e97, 0x9eac, 0x9ec1, 0x9ed7, 0x9eed,
	// Entry 1080 - 10BF
	0x9f02, 0x9f17, 0x9f2d, 0x9f41, 0x9f55, 0x9f69, 0x9f7e, 0x9f93,
	0x9fa7, 0x9fbb, 0x9fd0, 0x9fe4, 0x9ff8, 0xa00c, 0xa021, 0xa036,
	0xa04a, 0xa05e, 0xa073, 0xa088, 0xa09d, 0xa0b2, 0xa0e5, 0xa109,
	0xa12b, 0xa140, 0xa152, 0xa164, 0xa172, 0xa184, 0xa192, 0xa1a8,
	0xa1be, 0xa1da, 0xa1ec, 0xa1fe, 0xa212, 0xa225, 0xa238, 0xa24a,
	0xa25e, 0xa272, 0xa285, 0xa298, 0xa2ae, 0xa2c4, 0xa2d9, 0xa2ee,
	0xa303, 0xa31a, 0xa330, 0xa346, 0xa35d, 0xa379, 0xa398, 0xa3ad,
	0xa3c3, 0xa3d8, 0xa3f7, 0xa40c, 0xa422, 0xa437, 0xa456, 0xa46b,
	// Entry 10C0 - 10FF
	0xa481, 0xa496, 0xa4b5, 0xa4ca, 0xa4e0, 0xa4f5, 0xa50e, 0xa527,
	0xa541, 0xa561, 0xa57a, 0xa593, 0xa5ad, 0xa5c6, 0xa5e5, 0xa5fd,
	0xa60e, 0xa61f, 0xa630, 0xa641, 0xa652, 0xa663, 0xa675, 0xa687,
	0xa699, 0xa6ab, 0xa6bd, 0xa6cf, 0xa6e1, 0xa6f3, 0xa705, 0xa717,
	0xa729, 0xa73b, 0xa74d, 0xa75f, 0xa771, 0xa783, 0xa795, 0xa7a7,
	0xa7b9, 0xa7cb, 0xa7dd, 0xa7ef, 0xa801, 0xa813, 0xa825, 0xa838,
	0xa84b, 0xa85d, 0xa86f, 0xa881, 0xa893, 0xa8a5, 0xa8b8, 0xa8cb,
	0xa8de, 0xa8f1, 0xa904, 0xa917, 0xa929, 0xa93a, 0xa94c, 0xa95e,
	// Entry 1100 - 113F
	0xa970, 0xa982, 0xa994, 0xa9a6, 0xa9b8, 0xa9ca, 0xa9dc, 0xa9ee,
	0xaa00, 0xaa12, 0xaa24, 0xaa36, 0xaa49, 0xaa5c, 0xaa6f, 0xaa82,
	0xaa95, 0xaaa8, 0xaabb, 0xaace, 0xaae1, 0xaaf4, 0xab07, 0xab1a,
	0xab2d, 0xab3f, 0xab51, 0xab63, 0xab75, 0xab87, 0xab99, 0xabab,
	0xabbd, 0xabcf, 0xabe1, 0xabf3, 0xac05, 0xac17, 0xac2f, 0xac47,
	0xac5f, 0xac77, 0xac8f, 0xaca7, 0xacc0, 0xacd4, 0xacea, 0xacfe,
	0xad13, 0xad27, 0xad3c, 0xad58, 0xad75, 0xad91, 0xada5, 0xadba,
	0xadcf, 0xadee, 0xae03, 0xae22, 0xae38, 0xae58, 0xae6d, 0xae8c,
	// Entry 1140 - 117F
	0xaea2, 0xaec2, 0xaee0, 0xaef5, 0xaf14, 0xaf2a, 0xaf4a, 0xaf68,
	0xaf7d, 0xaf98, 0xafb7, 0xafd5, 0xaff3, 0xb01c, 0xb042, 0xb06a,
	0xb087, 0xb0ac, 0xb0e2, 0xb105, 0xb135, 0xb152, 0xb174, 0xb189,
	0xb19e, 0xb1b3, 0xb1c8, 0xb1dd, 0xb1f4, 0xb209, 0xb21f, 0xb234,
	0xb24a, 0xb267, 0xb285, 0xb2a2, 0xb2b7, 0xb2cd, 0xb2e3, 0xb303,
	0xb319, 0xb339, 0xb350, 0xb371, 0xb387, 0xb3a7, 0xb3be, 0xb3df,
	0xb3f5, 0xb415, 0xb42c, 0xb44d, 0xb46b, 0xb47f, 0xb49d, 0xb4b9,
	0xb4ce, 0xb4e5, 0xb4fa, 0xb510, 0xb525, 0xb53b, 0xb558, 0xb576,
	// Entry 1180 - 11BF
	0xb593, 0xb5a8, 0xb5be, 0xb5d4, 0xb5f4, 0xb60a, 0xb62a, 0xb641,
	0xb662, 0xb678, 0xb698, 0xb6af, 0xb6d0, 0xb6e6, 0xb706, 0xb71d,
	0xb73e, 0xb75d, 0xb771, 0xb787, 0xb79d, 0xb7b3, 0xb7c9, 0xb7de,
	0xb7f5, 0xb80a, 0xb820, 0xb835, 0xb84b, 0xb868, 0xb87d, 0xb893,
	0xb8a9, 0xb8c9, 0xb8df, 0xb8ff, 0xb916, 0xb937, 0xb94d, 0xb96d,
	0xb984, 0xb9a5, 0xb9bb, 0xb9db, 0xb9f2, 0xba13, 0xba32, 0xba46,
	0xba5b, 0xba7e, 0xbaa1, 0xbac4, 0xbae7, 0xbafc, 0xbb13, 0xbb28,
	0xbb3e, 0xbb53, 0xbb69, 0xbb86, 0xbb9b, 0xbbb1, 0xbbc7, 0xbbe7,
	// Entry 11C0 - 11FF
	0xbbfd, 0xbc1d, 0xbc34, 0xbc55, 0xbc6b, 0xbc8b, 0xbca2, 0xbcc3,
	0xbcd9, 0xbcf9, 0xbd10, 0xbd31, 0xbd50, 0xbd64, 0xbd80, 0xbd95,
	0xbdac, 0xbdc1, 0xbdd7, 0xbdec, 0xbe02, 0xbe1f, 0xbe34, 0xbe4a,
	0xbe60, 0xbe80, 0xbe96, 0xbeb6, 0xbecd, 0xbeee, 0xbf04, 0xbf24,
	0xbf3b, 0xbf5c, 0xbf72, 0xbf92, 0xbfa9, 0xbfca, 0xbfe9, 0xbffd,
	0xc01b, 0xc030, 0xc04f, 0xc06a, 0xc07f, 0xc096, 0xc0ab, 0xc0c1,
	0xc0d6, 0xc0ec, 0xc109, 0xc11e, 0xc134, 0xc14a, 0xc16a, 0xc180,
	0xc1a0, 0xc1b7, 0xc1d8, 0xc1f7, 0xc20b, 0xc228, 0xc23d, 0xc252,
	// Entry 1200 - 123F
	0xc269, 0xc27e, 0xc294, 0xc2a9, 0xc2bf, 0xc2dc, 0xc2f1, 0xc307,
	0xc31d, 0xc33d, 0xc353, 0xc373, 0xc38a, 0xc3ab, 0xc3c1, 0xc3e1,
	0xc3f8, 0xc419, 0xc42f, 0xc44f, 0xc466, 0xc487, 0xc49b, 0xc4b9,
	0xc4d4, 0xc4e9, 0xc500, 0xc515, 0xc52b, 0xc540, 0xc556, 0xc573,
	0xc588, 0xc59e, 0xc5b4, 0xc5d4, 0xc5ea, 0xc60a, 0xc621, 0xc642,
	0xc658, 0xc678, 0xc68f, 0xc6b0, 0xc6c6, 0xc6e6, 0xc6fd, 0xc71e,
	0xc73d, 0xc751, 0xc770, 0xc785, 0xc7a3, 0xc7c3, 0xc7e1, 0xc7ff,
	0xc81e, 0xc83d, 0xc85c, 0xc87b, 0xc891, 0xc8a7, 0xc8be, 0xc8d4,
	// Entry 1240 - 127F
	0xc8eb, 0xc901, 0xc918, 0xc92f, 0xc950, 0xc967, 0xc988, 0xc9a0,
	0xc9c2, 0xc9d9, 0xc9fa, 0xca12, 0xca34, 0xca4b, 0xca6c, 0xca84,
	0xcaa6, 0xcabb, 0xcad0, 0xcae7, 0xcafc, 0xcb12, 0xcb27, 0xcb3d,
	0xcb5a, 0xcb6f, 0xcb85, 0xcb9b, 0xcbbb, 0xcbd1, 0xcbf1, 0xcc08,
	0xcc29, 0xcc3f, 0xcc5f, 0xcc76, 0xcc97, 0xccad, 0xcccd, 0xcce4,
	0xcd05, 0xcd24, 0xcd38, 0xcd57, 0xcd75, 0xcd91, 0xcda6, 0xcdc2,
	0xcde1, 0xcdf8, 0xce0d, 0xce23, 0xce38, 0xce4e, 0xce6d, 0xce82,
	0xce98, 0xceb7, 0xcece, 0xceef, 0xcf03, 0xcf21, 0xcf3c, 0xcf51,
	// Entry 1280 - 12BF
	0xcf68, 0xcf7d, 0xcf93, 0xcfa8, 0xcfbe, 0xcfd3, 0xcfe9, 0xd000,
	0xd021, 0xd035, 0xd04b, 0xd068, 0xd07e, 0xd09b, 0xd0b2, 0xd0d0,
	0xd0e6, 0xd0fd, 0xd113, 0xd12a, 0xd142, 0xd164, 0xd179, 0xd190,
	0xd1a7, 0xd1be, 0xd1d5, 0xd1eb, 0xd201, 0xd217, 0xd22d, 0xd243,
	0xd260, 0xd27d, 0xd29b, 0xd2b8, 0xd2d6, 0xd2f3, 0xd311, 0xd32d,
	0xd349, 0xd35e, 0xd375, 0xd38a, 0xd3a0, 0xd3b5, 0xd3cb, 0xd3e0,
	0xd3f6, 0xd40a, 0xd421, 0xd438, 0xd44f, 0xd466, 0xd485, 0xd4a4,
	0xd4c3, 0xd4e2, 0xd4fa, 0xd510, 0xd527, 0xd53d, 0xd554, 0xd56a,
	// Entry 12C0 - 12FF
	0xd581, 0xd596, 0xd5ac, 0xd5c9, 0xd5e6, 0xd603, 0xd620, 0xd641,
	0xd662, 0xd683, 0xd6a4, 0xd6c4, 0xd6da, 0xd6f1, 0xd707, 0xd71e,
	0xd734, 0xd74b, 0xd760, 0xd77e, 0xd79c, 0xd7bb, 0xd7d9, 0xd7f8,
	0xd816, 0xd835, 0xd852, 0xd86e, 0xd88c, 0xd8aa, 0xd8c8, 0xd8e6,
	0xd905, 0xd924, 0xd943, 0xd962, 0xd981, 0xd9a0, 0xd9bf, 0xd9de,
	0xd9fd, 0xda1c, 0xda3b, 0xda5a, 0xda76, 0xda92, 0xdaae, 0xdaca,
	0xdae8, 0xdb06, 0xdb24, 0xdb43, 0xdb61, 0xdb7f, 0xdb9c, 0xdbb9,
	0xdbd6, 0xdbf4, 0xdc11, 0xdc2e, 0xdc4b, 0xdc68, 0xdc85, 0xdca3,
	// Entry 1300 - 133F
	0xdcc0, 0xdcdd, 0xdcfb, 0xdd19, 0xdd37, 0xdd56, 0xdd74, 0xdd92,
	0xddb0, 0xddce, 0xddec, 0xde0b, 0xde29, 0xde47, 0xde65, 0xde83,
	0xdea1, 0xdec0, 0xdede, 0xdefc, 0xdf19, 0xdf36, 0xdf53, 0xdf71,
	0xdf8e, 0xdfab, 0xdfc7, 0xdfe4, 0xe001, 0xe01e, 0xe03c, 0xe059,
	0xe076, 0xe094, 0xe0b2, 0xe0d0, 0xe0ef, 0xe10d, 0xe12b, 0xe149,
	0xe167, 0xe185, 0xe1a4, 0xe1c2, 0xe1e0, 0xe1fd, 0xe21a, 0xe237,
	0xe254, 0xe272, 0xe28f, 0xe2ac, 0xe2c9, 0xe2e6, 0xe303, 0xe321,
	0xe33e, 0xe35b, 0xe378, 0xe395, 0xe3b2, 0xe3d0, 0xe3ed, 0xe40a,
	// Entry 1340 - 137F
	0xe427, 0xe443, 0xe460, 0xe47d, 0xe49b, 0xe4b8, 0xe4d4, 0xe4f1,
	0xe50f, 0xe52d, 0xe54b, 0xe56a, 0xe588, 0xe5a6, 0xe5c3, 0xe5e0,
	0xe5fd, 0xe61b, 0xe638, 0xe655, 0xe673, 0xe691, 0xe6af, 0xe6ce,
	0xe6ec, 0xe70a, 0xe728, 0xe746, 0xe764, 0xe783, 0xe7a1, 0xe7bf,
	0xe7de, 0xe7fd, 0xe81c, 0xe83c, 0xe85b, 0xe87a, 0xe898, 0xe8b6,
	0xe8d4, 0xe8f3, 0xe911, 0xe92f, 0xe94c, 0xe969, 0xe986, 0xe9a4,
	0xe9c1, 0xe9de, 0xe9fa, 0xea1e, 0xea3c, 0xea5a, 0xea78, 0xea97,
	0xeab5, 0xead3, 0xeaf0, 0xeb0d, 0xeb2a, 0xeb48, 0xeb65, 0xeb82,
	// Entry 1380 - 13BF
	0xeba0, 0xebbe, 0xebdc, 0xebfb, 0xec19, 0xec37, 0xec54, 0xec72,
	0xec90, 0xecae, 0xeccd, 0xeceb, 0xed09, 0xed27, 0xed45, 0xed63,
	0xed82, 0xeda0, 0xedbe, 0xeddd, 0xedfc, 0xee1b, 0xee3b, 0xee5a,
	0xee79, 0xee94, 0xeeb0, 0xeec6, 0xeedd, 0xeef4, 0xef0c, 0xef23,
	0xef3b, 0xef52, 0xef6a, 0xef8d, 0xefaf, 0xefd2, 0xeff4, 0xf017,
	0xf039, 0xf05c, 0xf082, 0xf0a0, 0xf0b0, 0xf0c2, 0xf0d3, 0xf0e5,
	0xf0f6, 0xf107, 0xf118, 0xf129, 0xf13b, 0xf14c, 0xf15e, 0xf16f,
	0xf180, 0xf194, 0xf1a7, 0xf1b8, 0xf1c9, 0xf1d9, 0xf1e8, 0xf1fc,
	// Entry 13C0 - 13FF
	0xf210, 0xf224, 0xf233, 0xf248, 0xf259, 0xf271, 0xf283, 0xf295,
	0xf2b0, 0xf2cb, 0xf2d9, 0xf2ef, 0xf2fe, 0xf30c, 0xf31a, 0xf33b,
	0xf34b, 0xf35f, 0xf370, 0xf381, 0xf392, 0xf3b0, 0xf3cd, 0xf3db,
	0xf3ea, 0xf3f9, 0xf416, 0xf428, 0xf438, 0xf44b, 0xf459, 0xf469,
	0xf481, 0xf491, 0xf4aa, 0xf4bf, 0xf4d3, 0xf4f4, 0xf514, 0xf532,
	0xf550, 0xf565, 0xf57f, 0xf58d, 0xf5a1, 0xf5b1, 0xf5cf, 0xf5eb,
	0xf600, 0xf61c, 0xf634, 0xf649, 0xf66d, 0xf68a, 0xf698, 0xf6a6,
	0xf6c2, 0xf6df, 0xf6ed, 0xf712, 0xf733, 0xf748, 0xf75b, 0xf772,
	// Entry 1400 - 143F
	0xf78b, 0xf7aa, 0xf7c8, 0xf7e7, 0xf7fc, 0xf80f, 0xf81f, 0xf838,
	0xf854, 0xf864, 0xf874, 0xf888, 0xf899, 0xf8ab, 0xf8bc, 0xf8d7,
	0xf8f1, 0xf90a, 0xf918, 0xf926, 0xf93e, 0xf958, 0xf96f, 0xf982,
	0xf997, 0xf9ac, 0xf9ba, 0xf9c9, 0xf9d8, 0xf9f5, 0xfa12, 0xfa2f,
	0xfa4c, 0xfa6b, 0xfa7b, 0xfa8b, 0xfa9b, 0xfaac, 0xfabd, 0xfacf,
	0xfae0, 0xfaf1, 0xfb02, 0xfb13, 0xfb24, 0xfb35, 0xfb46, 0xfb57,
	0xfb68, 0xfb79, 0xfb8a, 0xfb9e, 0xfbb2, 0xfbc5, 0xfbd5, 0xfbe5,
	0xfbf5, 0xfc06, 0xfc17, 0xfc29, 0xfc3a, 0xfc4b, 0xfc5c, 0xfc6d,
	// Entry 1440 - 147F
	0xfc7e, 0xfc8f, 0xfca0, 0xfcb1, 0xfcc2, 0xfcd3, 0xfce4, 0xfcf5,
	0xfd09, 0xfd1d, 0xfd32, 0xfd4f, 0xfd6c, 0xfd7a, 0xfd88, 0xfd96,
	0xfda5, 0xfdb4, 0xfdc4, 0xfdd3, 0xfde2, 0xfdf1, 0xfe00, 0xfe0f,
	0xfe1e, 0xfe2d, 0xfe3c, 0xfe4b, 0xfe5a, 0xfe69, 0xfe78, 0xfe8a,
	0xfe9c, 0xfead, 0xfebe, 0xfecf, 0xfee1, 0xfef3, 0xff06, 0xff18,
	0xff2a, 0xff3c, 0xff4e, 0xff60, 0xff72, 0xff84, 0xff96, 0xffa8,
	0xffba, 0xffcf, 0xffe4, 0xfff3, 0x0003, 0x0012, 0x0022, 0x0032,
	0x0041, 0x0051, 0x0060, 0x0070, 0x0080, 0x008f, 0x00a0, 0x00af,
	// Entry 1480 - 14BF
	0x00c0, 0x00d0, 0x00df, 0x00ef, 0x00fe, 0x010e, 0x011d, 0x012c,
	0x013c, 0x014b, 0x015b, 0x016a, 0x0179, 0x0188, 0x0197, 0x01a6,
	0x01b6, 0x01c6, 0x01d5, 0x01e4, 0x01f3, 0x0202, 0x021d, 0x0238,
	0x0252, 0x026d, 0x0287, 0x02a2, 0x02bd, 0x02d9, 0x02f3, 0x030e,
	0x0328, 0x0343, 0x035d, 0x0378, 0x039c, 0x03c0, 0x03db, 0x03f2,
	0x0409, 0x041c, 0x042e, 0x0441, 0x0453, 0x0466, 0x0478, 0x048b,
	0x049e, 0x04b1, 0x04c4, 0x04d7, 0x04e9, 0x04fc, 0x050f, 0x0522,
	0x0535, 0x0547, 0x0559, 0x0571, 0x0587, 0x0599, 0x05aa, 0x05ba,
	// Entry 14C0 - 14FF
	0x05d0, 0x05e2, 0x05f2, 0x060a, 0x061b, 0x062b, 0x0640, 0x064f,
	0x0664, 0x067e, 0x0690, 0x06a1, 0x06b7, 0x06c9, 0x06e3, 0x06fb,
	0x070e, 0x071e, 0x072d, 0x073c, 0x074d, 0x075d, 0x076d, 0x077c,
	0x078d, 0x079e, 0x07ae, 0x07c8, 0x07e3, 0x07fd, 0x0817, 0x0832,
	0x084d, 0x086d, 0x088c, 0x08ab, 0x08cb, 0x08da, 0x08ec, 0x08fb,
	0x090e, 0x091d, 0x0930, 0x094a, 0x0971, 0x0987, 0x09a1, 0x09b1,
	0x09d6, 0x09fb, 0x0a22, 0x0a3b, 0x0a4f, 0x0a62, 0x0a75, 0x0a8a,
	0x0a9e, 0x0ab2, 0x0ac5, 0x0ada, 0x0aef, 0x0b03, 0x0b15, 0x0b27,
	// Entry 1500 - 153F
	0x0b39, 0x0b4b, 0x0b5d, 0x0b70, 0x0b83, 0x0b96, 0x0ba9, 0x0bbd,
	0x0bd0, 0x0be3, 0x0bf6, 0x0c09, 0x0c1c, 0x0c2f, 0x0c42, 0x0c56,
	0x0c69, 0x0c7c, 0x0c90, 0x0ca3, 0x0cb6, 0x0cc9, 0x0cdc, 0x0cef,
	0x0d02, 0x0d16, 0x0d2a, 0x0d3d, 0x0d51, 0x0d65, 0x0d79, 0x0d8d,
	0x0da1, 0x0dc6, 0x0ddd, 0x0df4, 0x0e0b, 0x0e22, 0x0e3a, 0x0e52,
	0x0e6b, 0x0e83, 0x0e9b, 0x0eb3, 0x0ecb, 0x0ee3, 0x0efb, 0x0f13,
	0x0f2c, 0x0f44, 0x0f5d, 0x0f75, 0x0f8d, 0x0fa5, 0x0fbe, 0x0fd7,
	0x0ff0, 0x1009, 0x1022, 0x1039, 0x1050, 0x1068, 0x1080, 0x1097,
	// Entry 1540 - 157F
	0x10b0, 0x10c8, 0x10e0, 0x10f8, 0x1110, 0x1129, 0x1141, 0x1159,
	0x1171, 0x1189, 0x11a2, 0x11bb, 0x11d4, 0x11ec, 0x1205, 0x121e,
	0x1237, 0x1250, 0x126a, 0x1284, 0x129e, 0x12b9, 0x12db, 0x1301,
	0x1326, 0x1346, 0x1367, 0x1391, 0x13b1, 0x13d7, 0x13f2, 0x140d,
	0x1429, 0x1446, 0x1462, 0x147f, 0x149d, 0x14ba, 0x14d7, 0x14f3,
	0x150f, 0x152b, 0x1548, 0x1565, 0x1582, 0x159e, 0x15ba, 0x15db,
	0x15fd, 0x1621, 0x1645, 0x1668, 0x168c, 0x16b0, 0x16d5, 0x16f8,
	0x171c, 0x1740, 0x1764, 0x1788, 0x17ab, 0x17cb, 0x17ec, 0x1810,
	// Entry 1580 - 15BF
	0x1831, 0x1855, 0x186a, 0x187f, 0x1895, 0x18ab, 0x18c1, 0x18d7,
	0x18ee, 0x1904, 0x191a, 0x1931, 0x1947, 0x195d, 0x1973, 0x1989,
	0x199f, 0x19b5, 0x19cc, 0x19e3, 0x19fb, 0x1a11, 0x1a27, 0x1a3d,
	0x1a53, 0x1a71, 0x1a88, 0x1aa7, 0x1abd, 0x1adb, 0x1af2, 0x1b11,
	0x1b28, 0x1b3e, 0x1b55, 0x1b6b, 0x1b82, 0x1b98, 0x1bb4, 0x1bd0,
	0x1bec, 0x1c08, 0x1c24, 0x1c40, 0x1c5c, 0x1c79, 0x1c95, 0x1cb1,
	0x1cd4, 0x1cf7, 0x1d14, 0x1d34, 0x1d54, 0x1d6b, 0x1d82, 0x1d9a,
	0x1db2, 0x1dca, 0x1de2, 0x1dfa, 0x1e18, 0x1e36, 0x1e53, 0x1e71,
	// Entry 15C0 - 15FF
	0x1e94, 0x1eb2, 0x1ed0, 0x1eed, 0x1f0b, 0x1f2b, 0x1f4b, 0x1f6e,
	0x1f88, 0x1f97, 0x1fa7, 0x1fb6, 0x1fc6, 0x1fd6, 0x1fe5, 0x1ff5,
	0x2004, 0x2014, 0x2024, 0x2033, 0x2043, 0x2052, 0x2062, 0x2071,
	0x2080, 0x2090, 0x209f, 0x20af, 0x20be, 0x20cd, 0x20dc, 0x20eb,
	0x20fa, 0x210a, 0x211a, 0x2129, 0x2138, 0x2149, 0x2159, 0x216b,
	0x217d, 0x218f, 0x21a2, 0x21b5, 0x21c8, 0x21db, 0x21ed, 0x21ff,
	0x2218, 0x2231, 0x224a, 0x225f, 0x2275, 0x2290, 0x22a5, 0x22ba,
	0x22cf, 0x22e4, 0x22f9, 0x230e, 0x2322, 0x2336, 0x2345, 0x2353,
	// Entry 1600 - 163F
	0x2369, 0x237c, 0x238c, 0x239b, 0x23aa, 0x23bb, 0x23cb, 0x23db,
	0x23ea, 0x23fb, 0x240c, 0x241c, 0x242c, 0x243c, 0x244d, 0x245e,
	0x246e, 0x247e, 0x248e, 0x249f, 0x24af, 0x24bf, 0x24d0, 0x24e0,
	0x24f0, 0x2500, 0x2510, 0x2520, 0x2531, 0x2543, 0x2553, 0x2562,
	0x2571, 0x2581, 0x2591, 0x25a0, 0x25b0, 0x25bf, 0x25cf, 0x25de,
	0x25ef, 0x25ff, 0x2613, 0x2627, 0x263b, 0x264f, 0x2663, 0x267d,
	0x2696, 0x26b0, 0x26ca, 0x26e5, 0x26fe, 0x2717, 0x2731, 0x274c,
	0x2766, 0x2780, 0x279a, 0x27b3, 0x27cc, 0x27e6, 0x2801, 0x281b,
	// Entry 1640 - 167F
	0x2834, 0x284e, 0x2867, 0x2881, 0x289c, 0x28b6, 0x28cf, 0x28e9,
	0x2902, 0x291c, 0x2936, 0x2950, 0x2969, 0x2982, 0x299b, 0x29b5,
	0x29cf, 0x29e9, 0x2a02, 0x2a1b, 0x2a34, 0x2a4f, 0x2a6a, 0x2a84,
	0x2a9e, 0x2ab9, 0x2ad3, 0x2af9, 0x2b12, 0x2b2b, 0x2b43, 0x2b5c,
	0x2b74, 0x2b8d, 0x2ba5, 0x2bbe, 0x2bd7, 0x2bf0, 0x2c0a, 0x2c23,
	0x2c3c, 0x2c56, 0x2c70, 0x2c89, 0x2ca3, 0x2cbe, 0x2cd8, 0x2cf2,
	0x2d0c, 0x2d26, 0x2d40, 0x2d57, 0x2d6e, 0x2d84, 0x2d99, 0x2dae,
	0x2dc5, 0x2ddb, 0x2df1, 0x2e06, 0x2e1d, 0x2e34, 0x2e4a, 0x2e64,
	// Entry 1680 - 16BF
	0x2e78, 0x2e8d, 0x2ea4, 0x2eba, 0x2ecf, 0x2ee4, 0x2efa, 0x2f10,
	0x2f2b, 0x2f45, 0x2f5f, 0x2f7a, 0x2f8f, 0x2fa9, 0x2fc2, 0x2fdb,
	0x2ff5, 0x300f, 0x3025, 0x303a, 0x304e, 0x3062, 0x3077, 0x308c,
	0x30a6, 0x30bf, 0x30d8, 0x30f2, 0x3106, 0x311f, 0x3137, 0x314f,
	0x3168, 0x3181, 0x3193, 0x31a5, 0x31b8, 0x31cc, 0x31de, 0x31f0,
	0x3202, 0x3215, 0x3227, 0x3239, 0x324b, 0x325e, 0x3270, 0x3282,
	0x3295, 0x32a9, 0x32bb, 0x32cd, 0x32df, 0x32f1, 0x3303, 0x3314,
	0x3326, 0x333b, 0x3350, 0x3365, 0x337a, 0x3390, 0x33a0, 0x33b7,
	// Entry 16C0 - 16FF
	0x33ce, 0x33e6, 0x33fe, 0x3414, 0x342b, 0x3442, 0x3455, 0x346c,
	0x3484, 0x349a, 0x34b0, 0x34c7, 0x34da, 0x34ee, 0x3508, 0x351a,
	0x3533, 0x3547, 0x355e, 0x3576, 0x358c, 0x35a3, 0x35b5, 0x35c7,
	0x35de, 0x35f6, 0x360d, 0x3623, 0x3639, 0x3650, 0x3662, 0x3678,
	0x368f, 0x36a1, 0x36b4, 0x36c6, 0x36d9, 0x36eb, 0x3703, 0x371b,
	0x3732, 0x3749, 0x375c, 0x376d, 0x3783, 0x3794, 0x37a6, 0x37b7,
	0x37c9, 0x37db, 0x37ed, 0x3800, 0x3818, 0x3839, 0x385a, 0x387d,
	0x3897, 0x38b8, 0x38d6, 0x3902, 0x391c, 0x3936, 0x3950, 0x3963,
	// Entry 1700 - 173F
	0x3978, 0x3993, 0x39a9, 0x39c4, 0x39d9, 0x39ef, 0x3a05, 0x3a1c,
	0x3a31, 0x3a47, 0x3a5c, 0x3a78, 0x3a8e, 0x3aa3, 0x3ab9, 0x3acf,
	0x3ae5, 0x3b00, 0x3b1c, 0x3b32, 0x3b46, 0x3b5a, 0x3b74, 0x3b8e,
	0x3ba8, 0x3bbd, 0x3bd2, 0x3bef, 0x3c13, 0x3c2b, 0x3c42, 0x3c59,
	0x3c72, 0x3c8a, 0x3ca2, 0x3cb9, 0x3cd2, 0x3ceb, 0x3d03, 0x3d1b,
	0x3d32, 0x3d49, 0x3d62, 0x3d7a, 0x3d92, 0x3da9, 0x3dc2, 0x3ddb,
	0x3df3, 0x3e06, 0x3e1d, 0x3e30, 0x3e42, 0x3e53, 0x3e67, 0x3e8a,
	0x3ea1, 0x3eb3, 0x3ec8, 0x3edd, 0x3ef5, 0x3f07, 0x3f1a, 0x3f3d,
	// Entry 1740 - 177F
	0x3f55, 0x3f67, 0x3f80, 0x3f94, 0x3fa7, 0x3fc2, 0x3fdb, 0x3ffb,
	0x4026, 0x4052, 0x406d, 0x408f, 0x40aa, 0x40c7, 0x40de, 0x40f6,
	0x4109, 0x411d, 0x4130, 0x4145, 0x4161, 0x4176, 0x4192, 0x41a7,
	0x41c3, 0x41da, 0x41f8, 0x4210, 0x422f, 0x4244, 0x425a, 0x426f,
	0x428b, 0x429d, 0x42b9, 0x42cb, 0x42e2, 0x42f5, 0x4307, 0x431e,
	0x4330, 0x4347, 0x435a, 0x4372, 0x4394, 0x43b6, 0x43d8, 0x43f1,
	0x4403, 0x441a, 0x442c, 0x4443, 0x4455, 0x4467, 0x447f, 0x4491,
	0x44ab, 0x44bd, 0x44cf, 0x44e1, 0x44f3, 0x4505, 0x451c, 0x4533,
	// Entry 1780 - 17BF
	0x4545, 0x4557, 0x456c, 0x4586, 0x459d, 0x45b9, 0x45d1, 0x45ee,
	0x4609, 0x462b, 0x4647, 0x466a, 0x4684, 0x46a3, 0x46c4, 0x46ea,
	0x4703, 0x4723, 0x4735, 0x474e, 0x4768, 0x4782, 0x479a, 0x47b2,
	0x47cb, 0x47e7, 0x47fa, 0x480c, 0x481e, 0x4832, 0x4845, 0x4858,
	0x486a, 0x487e, 0x4892, 0x48a5, 0x48b3, 0x48c2, 0x48d0, 0x48e8,
	0x48fb, 0x4911, 0x4922, 0x493e, 0x495a, 0x4976, 0x4992, 0x49b5,
	0x49d1, 0x49ee, 0x4a0b, 0x4a28, 0x4a49, 0x4a70, 0x4a97, 0x4abf,
	0x4ae7, 0x4b10, 0x4b45, 0x4b7a, 0x4ba1, 0x4bc7, 0x4bf2, 0x4c1d,
	// Entry 17C0 - 17FF
	0x4c4a, 0x4c77, 0x4ca2, 0x4ccd, 0x4cfa, 0x4d27, 0x4d52, 0x4d69,
	0x4d81, 0x4d99, 0x4dab, 0x4dbd, 0x4dcf, 0x4de2, 0x4df4, 0x4e06,
	0x4e19, 0x4e2c, 0x4e3f, 0x4e52, 0x4e66, 0x4e79, 0x4e8c, 0x4e9f,
	0x4eb3, 0x4ec6, 0x4ed9, 0x4eec, 0x4eff, 0x4f12, 0x4f25, 0x4f38,
	0x4f4b, 0x4f5e, 0x4f71, 0x4f84, 0x4f97, 0x4faa, 0x4fbd, 0x4fd0,
	0x4ff2, 0x5013, 0x5033, 0x5050, 0x506c, 0x508b, 0x50a8, 0x50c4,
	0x50e3, 0x50f9, 0x510e, 0x5132, 0x5156, 0x516a, 0x517e, 0x5192,
	0x51a5, 0x51b8, 0x51cd, 0x51e1, 0x51f5, 0x5208, 0x521d, 0x5232,
	// Entry 1800 - 183F
	0x5246, 0x5258, 0x526c, 0x5280, 0x5294, 0x52ac, 0x52c4, 0x52d2,
	0x52eb, 0x52fa, 0x5314, 0x532e, 0x533d, 0x5351, 0x5360, 0x537a,
	0x5389, 0x53a3, 0x53b2, 0x53cc, 0x53e2, 0x53f1, 0x540b, 0x541a,
	0x5429, 0x5438, 0x5452, 0x5461, 0x547b, 0x5493, 0x54ab, 0x54ba,
	0x54d4, 0x54ee, 0x54fd, 0x5517, 0x5527, 0x5536, 0x5550, 0x5560,
	0x556f, 0x557f, 0x558f, 0x559d, 0x55ab, 0x55bb, 0x55cd, 0x55e6,
	0x55f9, 0x560b, 0x5622, 0x5634, 0x564b, 0x565d, 0x5681, 0x5698,
	0x56ae, 0x56bc, 0x56cc, 0x56e7, 0x5704, 0x571c, 0x5737, 0x5747,
	// Entry 1840 - 187F
	0x5758, 0x5769, 0x5779, 0x578a, 0x579b, 0x57ab, 0x57bc, 0x57cc,
	0x57dd, 0x57ed, 0x57fe, 0x580e, 0x581e, 0x582e, 0x583f, 0x5850,
	0x5860, 0x5871, 0x5881, 0x5892, 0x58a2, 0x58b3, 0x58c4, 0x58d6,
	0x58e7, 0x58f7, 0x5907, 0x5917, 0x5927, 0x5938, 0x5948, 0x5958,
	0x5969, 0x5979, 0x5988, 0x59a2, 0x59bc, 0x59d0, 0x59e3, 0x59f6,
	0x5a0a, 0x5a1d, 0x5a31, 0x5a44, 0x5a5b, 0x5a72, 0x5a89, 0x5aa0,
	0x5ab7, 0x5ace, 0x5ae5, 0x5b02, 0x5b1c, 0x5b2b, 0x5b3c, 0x5b55,
	0x5b7a, 0x5b93, 0x5bb3, 0x5bcc, 0x5bdd, 0x5bed, 0x5bfd, 0x5c0f,
	// Entry 1880 - 18BF
	0x5c20, 0x5c31, 0x5c41, 0x5c53, 0x5c65, 0x5c76, 0x5c87, 0x5c99,
	0x5caa, 0x5cbd, 0x5ccf, 0x5ce1, 0x5cf5, 0x5d08, 0x5d1b, 0x5d2d,
	0x5d41, 0x5d55, 0x5d68, 0x5d7a, 0x5d8c, 0x5d9e, 0x5db1, 0x5dc3,
	0x5dd6, 0x5de9, 0x5dfc, 0x5e0f, 0x5e22, 0x5e34, 0x5e46, 0x5e58,
	0x5e6b, 0x5e7d, 0x5e8f, 0x5ea1, 0x5eb3, 0x5ec6, 0x5ed8, 0x5eea,
	0x5efc, 0x5f0f, 0x5f21, 0x5f34, 0x5f46, 0x5f59, 0x5f6b, 0x5f7d,
	0x5f8f, 0x5fa2, 0x5fbb, 0x5fd7, 0x5fe5, 0x5ff6, 0x6003, 0x601e,
	0x6040, 0x6060, 0x6084, 0x60a2, 0x60bf, 0x60dc, 0x6101, 0x6125,
	// Entry 18C0 - 18FF
	0x6143, 0x6165, 0x6188, 0x61ac, 0x61d0, 0x61f4, 0x6217, 0x623b,
	0x625f, 0x6283, 0x62a6, 0x62ca, 0x62ee, 0x6312, 0x6336, 0x6359,
	0x637d, 0x63a2, 0x63c6, 0x63ea, 0x640e, 0x6431, 0x6456, 0x647b,
	0x64a0, 0x64c4, 0x64e9, 0x650e, 0x6532, 0x6556, 0x657a, 0x659f,
	0x65c3, 0x65e8, 0x660c, 0x662f, 0x6653, 0x6676, 0x669a, 0x66be,
	0x66e1, 0x6704, 0x672a, 0x6755, 0x6779, 0x679d, 0x67c7, 0x67f3,
	0x6814, 0x6838, 0x685b, 0x687c, 0x68a3, 0x68c9, 0x68ef, 0x6915,
	0x6928, 0x6938, 0x694a, 0x695e, 0x6983, 0x69b7, 0x69e0, 0x6a11,
	// Entry 1900 - 193F
	0x6a28, 0x6a63, 0x6a7c, 0x6a95, 0x6ab0, 0x6ac4, 0x6add, 0x6af8,
	0x6b28, 0x6b53, 0x6b6d, 0x6b86, 0x6ba8, 0x6bc3, 0x6be7, 0x6c0a,
	0x6c2f, 0x6c4f, 0x6c6f, 0x6c8e, 0x6cb7, 0x6cc8, 0x6ce9, 0x6d01,
	0x6d20, 0x6d42, 0x6d59, 0x6d78, 0x6d8f, 0x6da5, 0x6dbb, 0x6dce,
	0x6de3, 0x6dff, 0x6e1b, 0x6e38, 0x6e54, 0x6e77, 0x6e93, 0x6eaf,
	0x6ecd, 0x6ee9, 0x6f09, 0x6f24, 0x6f40, 0x6f5c, 0x6f84, 0x6fa0,
	0x6fc5, 0x6fe1, 0x7002, 0x701f, 0x7041, 0x706a, 0x7086, 0x70a3,
	0x70c0, 0x70e0, 0x70fc, 0x7121, 0x7144, 0x7160, 0x717c, 0x7199,
	// Entry 1940 - 197F
	0x71c2, 0x71e6, 0x7202, 0x721e, 0x723a, 0x7258, 0x727d, 0x728d,
	0x72ad, 0x72cd, 0x72ea, 0x7308, 0x7326, 0x7346, 0x735f, 0x7379,
	0x7392, 0x73b2, 0x73cb, 0x73e4, 0x7406, 0x741f, 0x7438, 0x7451,
	0x746a, 0x7483, 0x749c, 0x74b5, 0x74ce, 0x74f0, 0x7509, 0x7523,
	0x753c, 0x7555, 0x756e, 0x7587, 0x75a0, 0x75b7, 0x75d5, 0x75f0,
	0x760f, 0x7626, 0x763d, 0x7654, 0x766f, 0x768b, 0x76ae, 0x76c5,
	0x76e3, 0x76fa, 0x7711, 0x772a, 0x7741, 0x775d, 0x777d, 0x77a0,
	0x77b7, 0x77ce, 0x77e5, 0x7805, 0x7823, 0x783a, 0x7853, 0x786d,
	// Entry 1980 - 19BF
	0x788e, 0x78a9, 0x78c8, 0x78e1, 0x78ff, 0x791d, 0x793b, 0x7959,
	0x797a, 0x799c, 0x79bc, 0x79dc, 0x79fc, 0x7a11, 0x7a37, 0x7a5d,
	0x7a83, 0x7aa9, 0x7acf, 0x7af5, 0x7b1b, 0x7b4e, 0x7b74, 0x7b9a,
	0x7bc0, 0x7bdb, 0x7bf6, 0x7c12, 0x7c3a, 0x7c62, 0x7c85, 0x7ca5,
	0x7ccd, 0x7cf3, 0x7d19, 0x7d3f, 0x7d65, 0x7d8b, 0x7db1, 0x7dd7,
	0x7dfd, 0x7e23, 0x7e49, 0x7e6f, 0x7e95, 0x7ebd, 0x7ee3, 0x7f09,
	0x7f2f, 0x7f57, 0x7f83, 0x7faa, 0x7fd2, 0x7fff, 0x8035, 0x8061,
	0x8089, 0x80b6, 0x80e0, 0x8108, 0x8132, 0x8154, 0x816b, 0x818c,
	// Entry 19C0 - 19FF
	0x81a5, 0x81ca, 0x81e1, 0x820c, 0x822a, 0x8248, 0x826b, 0x8285,
	0x82a4, 0x82cf, 0x82f8, 0x8323, 0x834c, 0x836b, 0x838c, 0x83b8,
	0x83de, 0x8409, 0x8428, 0x8446, 0x845f, 0x8480, 0x8499, 0x84c2,
	0x84dd, 0x84fa, 0x8519, 0x853a, 0x8558, 0x856f, 0x859a, 0x85bb,
	0x85d4, 0x85ef, 0x860c, 0x8629, 0x863e, 0x8657, 0x866d, 0x8683,
	0x8699, 0x86af, 0x86ca, 0x86e5, 0x8709, 0x871f, 0x8735, 0x8756,
	0x876c, 0x8782, 0x8794, 0x87a6, 0x87b8, 0x87eb, 0x880a, 0x8829,
	0x8848, 0x886e, 0x8894, 0x88b4, 0x88d2, 0x88f8, 0x8916, 0x8934,
	// Entry 1A00 - 1A3F
	0x895a, 0x8980, 0x899e, 0x89c4, 0x89ea, 0x8a10, 0x8a2e, 0x8a51,
	0x8a6f, 0x8a91, 0x8aaf, 0x8ad0, 0x8af2, 0x8b10, 0x8b47, 0x8b86,
	0x8ba4, 0x8bc4, 0x8c03, 0x8c21, 0x8c4e, 0x8c7b, 0x8ca8, 0x8cbf,
	0x8cdb, 0x8cf6, 0x8d0e, 0x8d32, 0x8d49, 0x8d6e, 0x8d8d, 0x8dab,
	0x8ddd, 0x8e03, 0x8e27, 0x8e4c, 0x8e6f, 0x8e94, 0x8eb7, 0x8edd,
	0x8f01, 0x8f2e, 0x8f59, 0x8f7e, 0x8fa1, 0x8fc6, 0x8fe9, 0x900f,
	0x9033, 0x9056, 0x9077, 0x90a3, 0x90cd, 0x90f9, 0x9123, 0x914f,
	0x9179, 0x91a5, 0x91cf, 0x91f6, 0x921b, 0x9248, 0x9273, 0x9298,
	// Entry 1A40 - 1A7F
	0x92bb, 0x92dd, 0x92fd, 0x9322, 0x9345, 0x936a, 0x938d, 0x93b2,
	0x93d5, 0x93f8, 0x9419, 0x9440, 0x9465, 0x948c, 0x94b1, 0x94e0,
	0x950d, 0x952e, 0x954d, 0x9572, 0x9595, 0x95bb, 0x95df, 0x9604,
	0x9627, 0x9657, 0x9685, 0x96ab, 0x96cf, 0x96fb, 0x9725, 0x9746,
	0x9765, 0x978a, 0x97ad, 0x97d2, 0x97f5, 0x981a, 0x983d, 0x9862,
	0x9885, 0x98ab, 0x98cf, 0x98fb, 0x9925, 0x9950, 0x9979, 0x99a8,
	0x99d5, 0x9a01, 0x9a2b, 0x9a57, 0x9a81, 0x9aa2, 0x9ac1, 0x9ae6,
	0x9b09, 0x9b2e, 0x9b51, 0x9b76, 0x9b99, 0x9bc9, 0x9bf7, 0x9c1d,
	// Entry 1A80 - 1ABF
	0x9c41, 0x9c66, 0x9c89, 0x9cae, 0x9cd1, 0x9d00, 0x9d2d, 0x9d5c,
	0x9d89, 0x9dbc, 0x9ded, 0x9e12, 0x9e35, 0x9e5a, 0x9e7d, 0x9ea3,
	0x9ec7, 0x9ef3, 0x9f1d, 0x9f48, 0x9f71, 0x9f98, 0x9fbd, 0x9fe9,
	0xa013, 0xa03e, 0xa067, 0xa097, 0xa0c5, 0xa0e6, 0xa105, 0xa12a,
	0xa14d, 0xa16e, 0xa18d, 0xa1ae, 0xa1cd, 0xa1f2, 0xa215, 0xa23a,
	0xa25d, 0xa282, 0xa2a5, 0xa2ca, 0xa2ed, 0xa312, 0xa335, 0xa35a,
	0xa37d, 0xa3a3, 0xa3c7, 0xa3ec, 0xa40f, 0xa435, 0xa459, 0xa47d,
	0xa4a0, 0xa4c4, 0xa4e8, 0xa511, 0xa539, 0xa567, 0xa591, 0xa5ad,
	// Entry 1AC0 - 1AFF
	0xa5c5, 0xa5ea, 0xa60d, 0xa633, 0xa657, 0xa687, 0xa6b5, 0xa6e5,
	0xa713, 0xa748, 0xa77b, 0xa7ab, 0xa7d9, 0xa80d, 0xa83f, 0xa86a,
	0xa893, 0xa8be, 0xa8e7, 0xa917, 0xa945, 0xa970, 0xa999, 0xa9c8,
	0xa9f5, 0xaa1a, 0xaa3d, 0xaa63, 0xaa87, 0xaaa8, 0xaac7, 0xaaf7,
	0xab25, 0xab55, 0xab83, 0xabb8, 0xabeb, 0xac1b, 0xac49, 0xac7d,
	0xacaf, 0xacd5, 0xacf9, 0xad1e, 0xad41, 0xad66, 0xad89, 0xadaf,
	0xadd3, 0xae03, 0xae31, 0xae61, 0xae8f, 0xaec4, 0xaef7, 0xaf27,
	0xaf55, 0xaf89, 0xafbb, 0xafe5, 0xb00d, 0xb037, 0xb05f, 0xb08e,
	// Entry 1B00 - 1B3F
	0xb0bb, 0xb0e5, 0xb10d, 0xb13b, 0xb167, 0xb18c, 0xb1af, 0xb1d5,
	0xb1f9, 0xb223, 0xb24b, 0xb275, 0xb29d, 0xb2cc, 0xb2f9, 0xb323,
	0xb34b, 0xb379, 0xb3a5, 0xb3c6, 0xb3e5, 0xb40a, 0xb42d, 0xb453,
	0xb477, 0xb498, 0xb4b7, 0xb4db, 0xb4fd, 0xb520, 0xb541, 0xb561,
	0xb57f, 0xb5a2, 0xb5c5, 0xb5f2, 0xb61f, 0xb64b, 0xb677, 0xb6aa,
	0xb6dd, 0xb702, 0xb727, 0xb756, 0xb785, 0xb7b3, 0xb7e1, 0xb816,
	0xb84b, 0xb870, 0xb895, 0xb8c4, 0xb8f3, 0xb921, 0xb94f, 0xb976,
	0xb99d, 0xb9ce, 0xb9ff, 0xba2f, 0xba5f, 0xba80, 0xbaa1, 0xbacc,
	// Entry 1B40 - 1B7F
	0xbaf7, 0xbb21, 0xbb4b, 0xbb7c, 0xbbad, 0xbbd0, 0xbbf3, 0xbc20,
	0xbc4d, 0xbc79, 0xbca5, 0xbcd8, 0xbd0b, 0xbd2d, 0xbd4f, 0xbd7b,
	0xbda7, 0xbdd2, 0xbdfd, 0xbe2f, 0xbe61, 0xbe85, 0xbea9, 0xbed7,
	0xbf05, 0xbf32, 0xbf5f, 0xbf93, 0xbfc7, 0xbfec, 0xc011, 0xc040,
	0xc06f, 0xc09d, 0xc0cb, 0xc0f2, 0xc119, 0xc14a, 0xc17b, 0xc1ab,
	0xc1db, 0xc200, 0xc225, 0xc254, 0xc283, 0xc2b1, 0xc2df, 0xc314,
	0xc349, 0xc370, 0xc3a1, 0xc3d1, 0xc408, 0xc42b, 0xc44e, 0xc47b,
	0xc4a8, 0xc4d4, 0xc500, 0xc533, 0xc566, 0xc58b, 0xc5b0, 0xc5df,
	// Entry 1B80 - 1BBF
	0xc60e, 0xc63c, 0xc66a, 0xc69f, 0xc6d4, 0xc6f7, 0xc719, 0xc73e,
	0xc762, 0xc783, 0xc7a3, 0xc7c5, 0xc7e6, 0xc80b, 0xc82f, 0xc854,
	0xc878, 0xc89b, 0xc8bd, 0xc8f2, 0xc927, 0xc966, 0xc9a5, 0xc9e3,
	0xca21, 0xca66, 0xcaab, 0xcae3, 0xcb1b, 0xcb5d, 0xcb9f, 0xcbe0,
	0xcc21, 0xcc69, 0xccb1, 0xcce4, 0xcd17, 0xcd54, 0xcd91, 0xcdcd,
	0xce09, 0xce4c, 0xce8f, 0xcec5, 0xcefb, 0xcf3b, 0xcf7b, 0xcfba,
	0xcff9, 0xd03f, 0xd085, 0xd0ba, 0xd0ef, 0xd12e, 0xd16d, 0xd1ab,
	0xd1e9, 0xd22e, 0xd273, 0xd2ab, 0xd2e3, 0xd325, 0xd367, 0xd3a8,
	// Entry 1BC0 - 1BFF
	0xd3e9, 0xd431, 0xd479, 0xd49d, 0xd4c1, 0xd4f6, 0xd521, 0xd555,
	0xd57e, 0xd5b9, 0xd5df, 0xd605, 0xd62a, 0xd64e, 0xd67c, 0xd689,
	0xd69d, 0xd6a8, 0xd6b9, 0xd6d8, 0xd70b, 0xd734, 0xd766, 0xd78d,
	0xd7c6, 0xd7ed, 0xd813, 0xd836, 0xd858, 0xd884, 0xd899, 0xd8ad,
	0xd8c8, 0xd8eb, 0xd90e, 0xd93e, 0xd96d, 0xd995, 0xd9cb, 0xd9f0,
	0xda15, 0xda39, 0xda5c, 0xda71, 0xda85, 0xdaa0, 0xdac6, 0xdaec,
	0xdb1f, 0xdb51, 0xdb72, 0xdb93, 0xdbbe, 0xdbf7, 0xdc1f, 0xdc47,
	0xdc6e, 0xdc94, 0xdcb7, 0xdcd0, 0xdce8, 0xdcf3, 0xdd28, 0xdd53,
	// Entry 1C00 - 1C3F
	0xdd87, 0xddb0, 0xddeb, 0xde12, 0xde38, 0xde5d, 0xde81, 0xdeaf,
	0xdeb9, 0xdec4, 0xdecb, 0xded2, 0xdeda, 0xdee2, 0xdef4, 0xdf05,
	0xdf15, 0xdf21, 0xdf32, 0xdf3c, 0xdf46, 0xdf56, 0xdf6b, 0xdf7c,
	0xdf8e, 0xdfa0, 0xdfa6, 0xdfb9, 0xdfc4, 0xdfcb, 0xdfd2, 0xdfe0,
	0xdff4, 0xe003, 0xe01d, 0xe038, 0xe053, 0xe078, 0xe092, 0xe0ad,
	0xe0c8, 0xe0ed, 0xe0f3, 0xe100, 0xe106, 0xe117, 0xe125, 0xe133,
	0xe146, 0xe157, 0xe165, 0xe178, 0xe18f, 0xe1a6, 0xe1c0, 0xe1d6,
	0xe1ec, 0xe201, 0xe20f, 0xe224, 0xe229, 0xe235, 0xe241, 0xe24f,
	// Entry 1C40 - 1C7F
	0xe264, 0xe279, 0xe27e, 0xe2a7, 0xe2d1, 0xe2df, 0xe2f6, 0xe301,
	0xe309, 0xe311, 0xe31e, 0xe333, 0xe33b, 0xe348, 0xe356, 0xe374,
	0xe393, 0xe3a7, 0xe3c0, 0xe3d9, 0xe3e9, 0xe3fe, 0xe414, 0xe42b,
	0xe437, 0xe449, 0xe451, 0xe471, 0xe486, 0xe490, 0xe4a1, 0xe4b8,
	0xe4cd, 0xe4dc, 0xe4f0, 0xe504, 0xe517, 0xe524, 0xe530, 0xe538,
	0xe54a, 0xe563, 0xe56e, 0xe582, 0xe591, 0xe5a4, 0xe5b2, 0xe5c7,
	0xe5dc, 0xe5f0, 0xe607, 0xe621, 0xe63c, 0xe657, 0xe673, 0xe688,
	0xe69c, 0xe6ac, 0xe6cc, 0xe6dc, 0xe6ec, 0xe6fb, 0xe70c, 0xe71d,
	// Entry 1C80 - 1CBF
	0xe72d, 0xe742, 0xe753, 0xe76a, 0xe786, 0xe7a3, 0xe7c3, 0xe7d1,
	0xe7de, 0xe7eb, 0xe7fa, 0xe808, 0xe816, 0xe823, 0xe832, 0xe841,
	0xe84f, 0xe862, 0xe871, 0xe886, 0xe8a0, 0xe8bb, 0xe8d9, 0xe8f7,
	0xe915, 0xe933, 0xe955, 0xe973, 0xe991, 0xe9af, 0xe9cd, 0xe9eb,
	0xea09, 0xea27, 0xea45, 0xea57, 0xea61, 0xea6e, 0xea7f, 0xea88,
	0xea91, 0xea9b, 0xeaa6, 0xeab0, 0xeab8, 0xeac7, 0xead0, 0xead9,
	0xeae1, 0xeaec, 0xeaf8, 0xeb09, 0xeb12, 0xeb1e, 0xeb2a, 0xeb36,
	0xeb3f, 0xeb52, 0xeb5f, 0xeb69, 0xeb7a, 0xeb8b, 0xeb9b, 0xeba5,
	// Entry 1CC0 - 1CFF
	0xebaf, 0xebb8, 0xebc4, 0xebe0, 0xebfd, 0xec21, 0xec46, 0xec69,
	0xec88, 0xeca2, 0xecbd, 0xecd3, 0xecf3, 0xed17, 0xed31, 0xed4a,
	0xed64, 0xed7e, 0xed99, 0xedbd, 0xeddd, 0xedf7, 0xee11, 0xee3d,
	0xee5e, 0xee86, 0xee9e, 0xeeb7, 0xeed2, 0xeef3, 0xef18, 0xef48,
	0xef77, 0xef91, 0xefac, 0xefc4, 0xefce, 0xefe6, 0xeffd, 0xf00b,
	0xf01d, 0xf024, 0xf02c, 0xf03a, 0xf041, 0xf052, 0xf060, 0xf070,
	0xf086, 0xf09d, 0xf0ac, 0xf0c7, 0xf0d7, 0xf0ed, 0xf0fd, 0xf10b,
	0xf119, 0xf130, 0xf13b, 0xf154, 0xf164, 0xf17b, 0xf192, 0xf1a2,
	// Entry 1D00 - 1D3F
	0xf1b8, 0xf1cf, 0xf1e0, 0xf1e8, 0xf1f4, 0xf202, 0xf211, 0xf219,
	0xf230, 0xf23a, 0xf242, 0xf253, 0xf269, 0xf287, 0xf292, 0xf29f,
	0xf2af, 0xf2c5, 0xf2d5, 0xf2e3, 0xf2f3, 0xf303, 0xf313, 0xf323,
	0xf331, 0xf33c, 0xf346, 0xf352, 0xf35e, 0xf370, 0xf381, 0xf38f,
	0xf3a5, 0xf3be, 0xf3d9, 0xf3f1, 0xf40e, 0xf429, 0xf444, 0xf461,
	0xf47c, 0xf49a, 0xf4b6, 0xf4d2, 0xf4ee, 0xf50a, 0xf517, 0xf527,
	0xf52f, 0xf53b, 0xf549, 0xf564, 0xf57f, 0xf598, 0xf5b1, 0xf5ca,
	0xf5e4, 0xf5fd, 0xf617, 0xf633, 0xf64e, 0xf667, 0xf682, 0xf69c,
	// Entry 1D40 - 1D7F
	0xf6b9, 0xf6d5, 0xf6f2, 0xf708, 0xf719, 0xf72a, 0xf73d, 0xf74f,
	0xf761, 0xf772, 0xf785, 0xf798, 0xf7aa, 0xf7bb, 0xf7cf, 0xf7e3,
	0xf7f6, 0xf80f, 0xf829, 0xf843, 0xf85a, 0xf871, 0xf88a, 0xf8a2,
	0xf8ba, 0xf8d1, 0xf8ea, 0xf903, 0xf91b, 0xf932, 0xf94c, 0xf966,
	0xf97f, 0xf99e, 0xf9be, 0xf9de, 0xf9fc, 0xfa17, 0xfa31, 0xfa53,
	0xfa70, 0xfa8b, 0xfaa9, 0xfac5, 0xfae7, 0xfb02, 0xfb12, 0xfb24,
	0xfb33, 0xfb40, 0xfb50, 0xfb5f, 0xfb6f, 0xfb7c, 0xfb8c, 0xfb9c,
	0xfbac, 0xfbbc, 0xfbd7, 0xfbf3, 0xfc07, 0xfc1c, 0xfc36, 0xfc4e,
	// Entry 1D80 - 1DBF
	0xfc69, 0xfc83, 0xfc9c, 0xfcb6, 0xfcce, 0xfce4, 0xfcfd, 0xfd15,
	0xfd2c, 0xfd45, 0xfd5f, 0xfd78, 0xfd92, 0xfda7, 0xfdc3, 0xfdd9,
	0xfdf9, 0xfe1a, 0xfe3c, 0xfe5f, 0xfe85, 0xfeaa, 0xfecc, 0xfeea,
	0xff06, 0xff39, 0xff58, 0xff73, 0xff96, 0xffbb, 0xffdf, 0x0002,
	0x0026, 0x004c, 0x0072, 0x0097, 0x00bc, 0x00e6, 0x010b, 0x0122,
	0x0137, 0x014f, 0x0166, 0x018f, 0x01b8, 0x01da, 0x01fd, 0x0220,
	0x0236, 0x024a, 0x0261, 0x0277, 0x028e, 0x02a2, 0x02b9, 0x02d0,
	0x02e7, 0x02fe, 0x0314, 0x032b, 0x0343, 0x035c, 0x037c, 0x039e,
	// Entry 1DC0 - 1DFF
	0x03b4, 0x03c8, 0x03df, 0x03f5, 0x040b, 0x0422, 0x0437, 0x044a,
	0x0460, 0x0475, 0x0491, 0x04b0, 0x04e3, 0x0514, 0x052e, 0x0554,
	0x0574, 0x058e, 0x05a8, 0x05bb, 0x05d8, 0x0602, 0x0619, 0x063d,
	0x0662, 0x0687, 0x06b2, 0x06de, 0x070a, 0x0725, 0x0741, 0x075d,
	0x0764, 0x076e, 0x0782, 0x078e, 0x07a2, 0x07ab, 0x07b4, 0x07b9,
	0x07c3, 0x07d4, 0x07e4, 0x07f6, 0x0810, 0x0828, 0x0834, 0x0841,
	0x0850, 0x085f, 0x0869, 0x087b, 0x0883, 0x0891, 0x089a, 0x08ab,
	0x08b8, 0x08c7, 0x08d2, 0x08db, 0x08e6, 0x08f5, 0x08fd, 0x0908,
	// Entry 1E00 - 1E3F
	0x090d, 0x091b, 0x092a, 0x0931, 0x0940, 0x094b, 0x095a, 0x0965,
	0x096f, 0x097b, 0x0980, 0x0988, 0x0997, 0x09a6, 0x09b6, 0x09c6,
	0x09d5, 0x09e7, 0x0a01, 0x0a1f, 0x0a28, 0x0a2f, 0x0a34, 0x0a3e,
	0x0a47, 0x0a4d, 0x0a61, 0x0a6b, 0x0a79, 0x0a87, 0x0a96, 0x0a9f,
	0x0aad, 0x0ab6, 0x0ac1, 0x0ad8, 0x0af3, 0x0b09, 0x0b30, 0x0b5b,
	0x0b6a, 0x0b7d, 0x0b95, 0x0ba1, 0x0bad, 0x0bba, 0x0bd5, 0x0be7,
	0x0bfb, 0x0c11, 0x0c37, 0x0c59, 0x0c65, 0x0c71, 0x0c81, 0x0c8e,
	0x0c9c, 0x0ca5, 0x0cb3, 0x0cbe, 0x0ccc, 0x0ce2, 0x0ced, 0x0d00,
	// Entry 1E40 - 1E7F
	0x0d0c, 0x0d18, 0x0d28, 0x0d3e, 0x0d53, 0x0d6b, 0x0d82, 0x0d9c,
	0x0db6, 0x0dd3, 0x0de1, 0x0df2, 0x0df9, 0x0e0a, 0x0e17, 0x0e27,
	0x0e45, 0x0e66, 0x0e80, 0x0e9d, 0x0ec0, 0x0ee6, 0x0eff, 0x0f18,
	0x0f3a, 0x0f5c, 0x0f64, 0x0f6c, 0x0f80, 0x0f94, 0x0fad, 0x0fc6,
	0x0fd6, 0x0fe6, 0x0fef, 0x0ffa, 0x1009, 0x101a, 0x102f, 0x1046,
	0x1066, 0x1088, 0x10a3, 0x10c0, 0x10c8, 0x10df, 0x10ed, 0x10fc,
	0x110e, 0x1129, 0x1147, 0x1151, 0x115b, 0x1167, 0x1174, 0x1181,
	0x1197, 0x11ab, 0x11c0, 0x11d9, 0x11e7, 0x11f3, 0x11ff, 0x120c,
	// Entry 1E80 - 1EBF
	0x1219, 0x122d, 0x1237, 0x1240, 0x1249, 0x1250, 0x1259, 0x125f,
	0x1263, 0x1269, 0x128c, 0x12b6, 0x12c4, 0x12cc, 0x12da, 0x130c,
	0x1323, 0x133a, 0x134c, 0x1367, 0x1385, 0x13ac, 0x13b7, 0x13bf,
	0x13c7, 0x13e1, 0x13ec, 0x13ef, 0x13f3, 0x13f6, 0x140a, 0x1418,
	0x1429, 0x1439, 0x144b, 0x1456, 0x1466, 0x1472, 0x147f, 0x148d,
	0x1493, 0x14b8, 0x14de, 0x14f5, 0x150d, 0x1522, 0x1532, 0x1543,
	0x1550, 0x155f, 0x1572, 0x157e, 0x1587, 0x159c, 0x15ae, 0x15c3,
	0x15d6, 0x15ec, 0x160e, 0x1630, 0x1645, 0x165d, 0x1671, 0x1685,
	// Entry 1EC0 - 1EFF
	0x169e, 0x16b7, 0x16d6, 0x16f8, 0x1717, 0x1739, 0x1758, 0x177a,
	0x1798, 0x17b6, 0x17cc, 0x17ef, 0x1811, 0x183d, 0x184e, 0x1869,
	0x1883, 0x189f, 0x18c5, 0x18fd, 0x193b, 0x1954, 0x196b, 0x1988,
	0x19a0, 0x19c6, 0x19ea, 0x1a20, 0x1a5c, 0x1a71, 0x1a8c, 0x1aa5,
	0x1ab2, 0x1ac0, 0x1ac5, 0x1ad1, 0x1adf, 0x1ae9, 0x1af4, 0x1afd,
	0x1b09, 0x1b16, 0x1b20, 0x1b2b, 0x1b3c, 0x1b4c, 0x1b5a, 0x1b67,
	0x1b78, 0x1b86, 0x1b89, 0x1b90, 0x1b96, 0x1ba8, 0x1bba, 0x1bc9,
	0x1bdf, 0x1bee, 0x1bf3, 0x1bfc, 0x1c0b, 0x1c1b, 0x1c2d, 0x1c40,
	// Entry 1F00 - 1F3F
	0x1c51, 0x1c65, 0x1c6a, 0x1c6f, 0x1c97, 0x1ca1, 0x1cb3, 0x1cc7,
	0x1ccf, 0x1cea, 0x1d06, 0x1d17, 0x1d23, 0x1d2f, 0x1d41, 0x1d49,
	0x1d55, 0x1d65, 0x1d72, 0x1d77, 0x1d82, 0x1d8d, 0x1da9, 0x1dca,
	0x1dea, 0x1e0b, 0x1e2d, 0x1e4b, 0x1e6c, 0x1e8e, 0x1eae, 0x1ecd,
	0x1ef0, 0x1f10, 0x1f34, 0x1f58, 0x1f7f, 0x1fa3, 0x1fc8, 0x1ff2,
	0x201d, 0x2043, 0x206b, 0x208c, 0x20b1, 0x20d1, 0x20f4, 0x2116,
	0x213e, 0x2163, 0x2182, 0x21a5, 0x21c3, 0x21e4, 0x2208, 0x2232,
	0x2256, 0x227a, 0x22a0, 0x22c2, 0x22e7, 0x2308, 0x2328, 0x2349,
	// Entry 1F40 - 1F7F
	0x2369, 0x2390, 0x23b3, 0x23d7, 0x23fa, 0x2420, 0x2445, 0x246a,
	0x248f, 0x24bb, 0x24da, 0x24f9, 0x2514, 0x2535, 0x255d, 0x2581,
	0x25a4, 0x25ca, 0x25ee, 0x2608, 0x2621, 0x263c, 0x2660, 0x2686,
	0x26a9, 0x26cd, 0x26e8, 0x26f6, 0x271d, 0x2730, 0x273b, 0x2758,
	0x2768, 0x2783, 0x27a1, 0x27b0, 0x27c2, 0x27e8, 0x27f4, 0x280a,
	0x2815, 0x2836, 0x284b, 0x286d, 0x2878, 0x2889, 0x289a, 0x28bb,
	0x28dc, 0x28fb, 0x2918, 0x2936, 0x294e, 0x2968, 0x2984, 0x2991,
	0x299a, 0x29ad, 0x29c0, 0x29db, 0x29f5, 0x2a10, 0x2a2c, 0x2a47,
	// Entry 1F80 - 1FBF
	0x2a63, 0x2a83, 0x2aa0, 0x2ac0, 0x2ae1, 0x2aff, 0x2b20, 0x2b3d,
	0x2b5c, 0x2b79, 0x2b90, 0x2bae, 0x2bce, 0x2bec, 0x2bfe, 0x2c17,
	0x2c46, 0x2c75, 0x2c82, 0x2c92, 0x2ca4, 0x2cb9, 0x2ce6, 0x2cfb,
	0x2d11, 0x2d28, 0x2d3e, 0x2d54, 0x2d6a, 0x2d80, 0x2dad, 0x2ddd,
	0x2e08, 0x2e3e, 0x2e72, 0x2e9f, 0x2ed7, 0x2f0d, 0x2f35, 0x2f69,
	0x2f9b, 0x2fc5, 0x2fed, 0x3019, 0x3048, 0x3053, 0x3060, 0x306c,
	0x3083, 0x3091, 0x30a9, 0x30c1, 0x30de, 0x30fb, 0x3115, 0x3125,
	0x3137, 0x3149, 0x3155, 0x3159, 0x3168, 0x317a, 0x318b, 0x319f,
	// Entry 1FC0 - 1FFF
	0x31b9, 0x31d6, 0x31e5, 0x31fd, 0x3209, 0x3211, 0x321b, 0x3232,
	0x3249, 0x326d, 0x3290, 0x32b1, 0x32d4, 0x330a, 0x333f, 0x3375,
	0x3380, 0x3389, 0x3394, 0x33af, 0x33d2, 0x33f6, 0x3417, 0x343a,
	0x344d, 0x3462, 0x3479, 0x3485, 0x3498, 0x34a7, 0x34b9, 0x34cc,
	0x34db, 0x34f6, 0x350e, 0x3524, 0x3542, 0x3554, 0x356a, 0x3579,
	0x358d, 0x35ad, 0x35c1, 0x35df, 0x35f3, 0x360d, 0x3621, 0x3634,
	0x364f, 0x366c, 0x3689, 0x36a8, 0x36c6, 0x36e5, 0x3700, 0x3724,
	0x3735, 0x374d, 0x3762, 0x3773, 0x378c, 0x37a6, 0x37c1, 0x37da,
	// Entry 2000 - 203F
	0x37ea, 0x37fb, 0x3807, 0x380f, 0x3821, 0x383b, 0x3859, 0x3861,
	0x386a, 0x3872, 0x3883, 0x3892, 0x389d, 0x38bb, 0x38ce, 0x38d6,
	0x38f1, 0x3905, 0x3916, 0x3927, 0x393a, 0x394c, 0x395e, 0x396f,
	0x3982, 0x3995, 0x39a7, 0x39b9, 0x39ce, 0x39e3, 0x39fa, 0x3a11,
	0x3a27, 0x3a3d, 0x3a55, 0x3a6c, 0x3a83, 0x3a98, 0x3aaf, 0x3ac6,
	0x3adf, 0x3af7, 0x3b0f, 0x3b26, 0x3b3f, 0x3b58, 0x3b70, 0x3b88,
	0x3ba3, 0x3bbe, 0x3bdb, 0x3bf8, 0x3c14, 0x3c30, 0x3c4e, 0x3c6b,
	0x3c88, 0x3ca3, 0x3cb6, 0x3cc9, 0x3cde, 0x3cf2, 0x3d06, 0x3d19,
	// Entry 2040 - 207F
	0x3d2e, 0x3d43, 0x3d57, 0x3d6b, 0x3d82, 0x3d99, 0x3db2, 0x3dcb,
	0x3de3, 0x3dfb, 0x3e15, 0x3e2e, 0x3e47, 0x3e5e, 0x3e80, 0x3ea2,
	0x3ec4, 0x3ee6, 0x3f08, 0x3f2a, 0x3f4c, 0x3f6e, 0x3f90, 0x3fb2,
	0x3fd4, 0x3ff6, 0x4018, 0x403a, 0x405c, 0x407e, 0x40a0, 0x40c2,
	0x40e4, 0x4106, 0x4128, 0x414a, 0x416c, 0x418e, 0x41b0, 0x41d2,
	0x41f0, 0x420e, 0x422c, 0x424a, 0x4268, 0x4286, 0x42a4, 0x42c2,
	0x42e0, 0x42fe, 0x431c, 0x433a, 0x4358, 0x4376, 0x4394, 0x43b2,
	0x43d0, 0x43ee, 0x440c, 0x442a, 0x4448, 0x4466, 0x4484, 0x44a2,
	// Entry 2080 - 20BF
	0x44c0, 0x44de, 0x44fa, 0x4516, 0x4532, 0x454e, 0x456a, 0x4586,
	0x45a2, 0x45be, 0x45da, 0x45f6, 0x4612, 0x462e, 0x464a, 0x4666,
	0x4682, 0x469e, 0x46ba, 0x46d6, 0x46f2, 0x470e, 0x472a, 0x4746,
	0x4762, 0x477e, 0x479a, 0x47b6, 0x47c8, 0x47e6, 0x4804, 0x4824,
	0x4844, 0x4863, 0x4882, 0x48a3, 0x48c3, 0x48e3, 0x4901, 0x4919,
	0x4931, 0x494b, 0x4964, 0x497d, 0x4995, 0x49af, 0x49c9, 0x49e2,
	0x49fb, 0x4a16, 0x4a33, 0x4a50, 0x4a6b, 0x4a86, 0x4aaf, 0x4ad8,
	0x4aff, 0x4b26, 0x4b52, 0x4b7e, 0x4ba8, 0x4bd2, 0x4bf3, 0x4c1a,
	// Entry 20C0 - 20FF
	0x4c41, 0x4c62, 0x4c82, 0x4ca8, 0x4cce, 0x4cee, 0x4d0d, 0x4d32,
	0x4d57, 0x4d76, 0x4d94, 0x4db8, 0x4ddc, 0x4dfa, 0x4e1f, 0x4e4a,
	0x4e74, 0x4e9e, 0x4ec9, 0x4ef3, 0x4f1d, 0x4f42, 0x4f66, 0x4f90,
	0x4fb9, 0x4fe2, 0x500c, 0x5035, 0x505e, 0x5082, 0x50a8, 0x50d4,
	0x5100, 0x512c, 0x5158, 0x5184, 0x51b0, 0x51d6, 0x51fa, 0x5224,
	0x524e, 0x5278, 0x52a2, 0x52cc, 0x52f6, 0x531a, 0x5344, 0x5374,
	0x53a4, 0x53d4, 0x5403, 0x5432, 0x5462, 0x5491, 0x54c0, 0x54ef,
	0x551e, 0x554d, 0x557c, 0x55ac, 0x55dc, 0x5606, 0x562f, 0x5658,
	// Entry 2100 - 213F
	0x567f, 0x56a6, 0x56c4, 0x56e0, 0x5709, 0x5732, 0x5754, 0x577c,
	0x57a4, 0x57c5, 0x57ec, 0x5813, 0x5833, 0x5859, 0x587f, 0x589e,
	0x58cb, 0x58f8, 0x591e, 0x594a, 0x5976, 0x599b, 0x59c9, 0x59f7,
	0x5a1e, 0x5a4a, 0x5a76, 0x5a9b, 0x5acd, 0x5aff, 0x5b2a, 0x5b4f,
	0x5b73, 0x5b95, 0x5bb8, 0x5bed, 0x5c22, 0x5c43, 0x5c5a, 0x5c6f,
	0x5c87, 0x5c9e, 0x5cb5, 0x5cca, 0x5ce2, 0x5cf9, 0x5d20, 0x5d44,
	0x5d6b, 0x5d8f, 0x5d9f, 0x5db5, 0x5dcc, 0x5de5, 0x5df5, 0x5e0d,
	0x5e27, 0x5e40, 0x5e4a, 0x5e62, 0x5e7b, 0x5e92, 0x5ea1, 0x5eb9,
	// Entry 2140 - 217F
	0x5ecf, 0x5ee4, 0x5ef4, 0x5eff, 0x5f0b, 0x5f15, 0x5f2b, 0x5f41,
	0x5f54, 0x5f68, 0x5f7b, 0x5fad, 0x5fd0, 0x6002, 0x6035, 0x6049,
	0x606c, 0x609f, 0x60ab, 0x60b7, 0x60d8, 0x6102, 0x611d, 0x6136,
	0x615c, 0x6186, 0x61b0, 0x61d4, 0x61e6, 0x61f8, 0x6207, 0x6216,
	0x622e, 0x6246, 0x6259, 0x626c, 0x6286, 0x62a0, 0x62c0, 0x62e0,
	0x62fd, 0x631a, 0x633d, 0x6360, 0x637c, 0x6398, 0x63b4, 0x63d0,
	0x63f2, 0x6414, 0x6430, 0x644c, 0x646e, 0x6490, 0x64ab, 0x64c6,
	0x64d3, 0x64e0, 0x650c, 0x6513, 0x651a, 0x6526, 0x6533, 0x654c,
	// Entry 2180 - 21BF
	0x6554, 0x6560, 0x657b, 0x6597, 0x65b3, 0x65cf, 0x65f5, 0x6622,
	0x6638, 0x664f, 0x665d, 0x6671, 0x6690, 0x66af, 0x66cf, 0x66f0,
	0x6711, 0x6731, 0x6742, 0x6753, 0x676d, 0x6786, 0x679f, 0x67b9,
	0x67c5, 0x67e0, 0x67fc, 0x6826, 0x6851, 0x687a, 0x689d, 0x68c6,
	0x68f0, 0x68fc, 0x6921, 0x6946, 0x696c, 0x6992, 0x69b7, 0x69dc,
	0x6a02, 0x6a28, 0x6a3b, 0x6a4f, 0x6a62, 0x6a75, 0x6a88, 0x6aa1,
	0x6aba, 0x6ace, 0x6ae1, 0x6ae6, 0x6aee, 0x6af5, 0x6afa, 0x6b04,
	0x6b0e, 0x6b17, 0x6b23, 0x6b26, 0x6b34, 0x6b43, 0x6b4e, 0x6b58,
	// Entry 21C0 - 21FF
	0x6b67, 0x6b76, 0x6b80, 0x6b95, 0x6ba6, 0x6bad, 0x6bc5, 0x6bd1,
	0x6be2, 0x6bf3, 0x6bfb, 0x6c1f, 0x6c38, 0x6c52, 0x6c6b, 0x6c82,
	0x6c9c, 0x6cb5, 0x6cc9, 0x6cd5, 0x6ce5, 0x6cf3, 0x6cfb, 0x6cff,
	0x6d0d, 0x6d14, 0x6d25, 0x6d37, 0x6d48, 0x6d54, 0x6d5e, 0x6d6f,
	0x6d7b, 0x6d83, 0x6d95, 0x6da5, 0x6db5, 0x6dc8, 0x6dd8, 0x6de9,
	0x6dfd, 0x6e0e, 0x6e1d, 0x6e30, 0x6e42, 0x6e54, 0x6e67, 0x6e79,
	0x6e8a, 0x6e91, 0x6e9c, 0x6ea1, 0x6eaa, 0x6eb1, 0x6eb7, 0x6ebd,
	0x6ec4, 0x6ec9, 0x6ece, 0x6ed4, 0x6eda, 0x6ee0, 0x6ee3, 0x6ee8,
	// Entry 2200 - 223F
	0x6eed, 0x6ef5, 0x6f00, 0x6f09, 0x6f11, 0x6f17, 0x6f27, 0x6f38,
	0x6f48, 0x6f5a, 0x6f6c, 0x6f7c, 0x6f8c, 0x6f9d, 0x6fad, 0x6fbf,
	0x6fd1, 0x6fe1, 0x6ff1, 0x7001, 0x7013, 0x7022, 0x7032, 0x7042,
	0x7054, 0x7063, 0x706e, 0x707a, 0x7085, 0x7098, 0x70ae, 0x70bd,
	0x70cf, 0x70df, 0x70f0, 0x7101, 0x711b, 0x713f, 0x7163, 0x7187,
	0x71ab, 0x71cf, 0x71f3, 0x7217, 0x723d, 0x725d, 0x7272, 0x7291,
	0x72a5, 0x72b6, 0x72c0, 0x72ca, 0x72d4, 0x72de, 0x72e8, 0x72f2,
	0x730d, 0x7327, 0x7348, 0x7368, 0x7379, 0x7389, 0x73a0, 0x73b5,
	// Entry 2240 - 227F
	0x73cb, 0x73e1, 0x73eb, 0x73f5, 0x7404, 0x740a, 0x7418, 0x742c,
	0x7432, 0x7439, 0x743f, 0x7443, 0x7452, 0x745d, 0x7469, 0x747c,
	0x7498, 0x74b3, 0x74bf, 0x74d0, 0x74e3, 0x74f4, 0x7514, 0x7528,
	0x753d, 0x7566, 0x7584, 0x75a4, 0x75b7, 0x75ca, 0x75e3, 0x75f2,
	0x7600, 0x761c, 0x7622, 0x762d, 0x7633, 0x7638, 0x763e, 0x7642,
	0x7647, 0x764d, 0x765e, 0x7665, 0x7670, 0x7678, 0x7686, 0x7691,
	0x7699, 0x76a4, 0x76b6, 0x76c9, 0x76db, 0x76ee, 0x7702, 0x7712,
	0x7716, 0x7723, 0x7739, 0x7751, 0x7769, 0x7780, 0x778e, 0x779a,
	// Entry 2280 - 22BF
	0x77a3, 0x77a7, 0x77b2, 0x77c9, 0x77df, 0x77e5, 0x77ed, 0x780f,
	0x782d, 0x784b, 0x7860, 0x7875, 0x7884, 0x78a6, 0x78b7, 0x78c6,
	0x78f6, 0x7901, 0x7918, 0x792f, 0x794d, 0x7978, 0x7981, 0x79a2,
	0x79c2, 0x79d4, 0x79e9, 0x79f6, 0x79fc, 0x7a02, 0x7a0f, 0x7a1f,
	0x7a30, 0x7a49, 0x7a51, 0x7a63, 0x7a6b, 0x7a77, 0x7a7c, 0x7a84,
	0x7a97, 0x7a9c, 0x7aa5, 0x7ab5, 0x7ab9, 0x7acd, 0x7ae7, 0x7af0,
	0x7b03, 0x7b31, 0x7b46, 0x7b5a, 0x7b68, 0x7b7c, 0x7b8a, 0x7ba0,
	0x7bb7, 0x7bc1, 0x7bc9, 0x7bd1, 0x7bdc, 0x7be7, 0x7bf3, 0x7bff,
	// Entry 22C0 - 22FF
	0x7c11, 0x7c17, 0x7c29, 0x7c32, 0x7c3b, 0x7c45, 0x7c55, 0x7c65,
	0x7c7b, 0x7c83, 0x7c91, 0x7ca5, 0x7cb6, 0x7cc7, 0x7cde, 0x7ce9,
	0x7d03, 0x7d17, 0x7d24, 0x7d31, 0x7d4e, 0x7d6a, 0x7d8c, 0x7da5,
	0x7dbc, 0x7dd3, 0x7ddb, 0x7df5, 0x7e07, 0x7e1d, 0x7e34, 0x7e47,
	0x7e60, 0x7e6d, 0x7e80, 0x7e8e, 0x7ea2, 0x7eb7, 0x7ecf, 0x7eea,
	0x7f00, 0x7f24, 0x7f4e, 0x7f67, 0x7f7f, 0x7f97, 0x7fbb, 0x7fd9,
	0x7ffe, 0x800c, 0x801a, 0x8040, 0x8066, 0x808d, 0x8096, 0x80b0,
	0x80c7, 0x80ce, 0x80db, 0x80f2, 0x811a, 0x8148, 0x8152, 0x8167,
	// Entry 2300 - 233F
	0x8182, 0x81a8, 0x81ce, 0x81ef, 0x8210, 0x822c, 0x8248, 0x8267,
	0x8282, 0x829f, 0x82b1, 0x82c4, 0x82d6, 0x8307, 0x8331, 0x8362,
	0x838c, 0x83ba, 0x83e8, 0x840b, 0x842a, 0x844f, 0x8460, 0x8480,
	0x848c, 0x84a7, 0x84c7, 0x84e8, 0x8512, 0x853d, 0x8568, 0x8594,
	0x85c5, 0x85f7, 0x8621, 0x864c, 0x8676, 0x86a1, 0x86c3, 0x86e6,
	0x8708, 0x872a, 0x874e, 0x8771, 0x8794, 0x87b6, 0x87da, 0x87fe,
	0x8821, 0x8844, 0x8868, 0x888c, 0x88b2, 0x88d7, 0x88fc, 0x8920,
	0x8946, 0x896c, 0x8991, 0x89b6, 0x89e3, 0x8a10, 0x8a3f, 0x8a6d,
	// Entry 2340 - 237F
	0x8a9b, 0x8ac8, 0x8af7, 0x8b26, 0x8b54, 0x8b82, 0x8ba4, 0x8bb3,
	0x8bc3, 0x8bd6, 0x8bec, 0x8c02, 0x8c18, 0x8c37, 0x8c5a, 0x8c7a,
	0x8ca0, 0x8cc7, 0x8cf4, 0x8d0a, 0x8d32, 0x8d5d, 0x8d77, 0x8da8,
	0x8dd7, 0x8df3, 0x8e1f, 0x8e42, 0x8e64, 0x8e8f, 0x8ebb, 0x8eec,
	0x8f1d, 0x8f50, 0x8f5a, 0x8f8d, 0x8fb1, 0x8fd1, 0x8ff1, 0x9011,
	0x9031, 0x9057, 0x907d, 0x90a3, 0x90c3, 0x90ea, 0x9107, 0x912a,
	0x9148, 0x9159, 0x9170, 0x919e, 0x91ab, 0x91b6, 0x91c3, 0x91de,
	0x91fa, 0x920c, 0x922c, 0x9246, 0x9269, 0x9285, 0x9292, 0x92af,
	// Entry 2380 - 23BF
	0x92c2, 0x92d4, 0x92f2, 0x92fe, 0x9318, 0x9333, 0x934d, 0x935c,
	0x936c, 0x937b, 0x9388, 0x9397, 0x93b6, 0x93c9, 0x93d6, 0x93e5,
	0x93f3, 0x940c, 0x942e, 0x9449, 0x9478, 0x94a8, 0x94c8, 0x94e9,
	0x950f, 0x9536, 0x9555, 0x9575, 0x959b, 0x95c2, 0x95f0, 0x961f,
	0x9646, 0x966e, 0x9685, 0x969e, 0x96bf, 0x96dc, 0x96f9, 0x970d,
	0x9722, 0x9737, 0x9752, 0x976e, 0x978a, 0x97a7, 0x97c5, 0x97e9,
	0x980e, 0x982c, 0x9841, 0x9857, 0x986d, 0x9884, 0x989a, 0x98b1,
	0x98c8, 0x98e0, 0x98f6, 0x990d, 0x9924, 0x993c, 0x9953, 0x996b,
	// Entry 23C0 - 23FF
	0x9983, 0x999c, 0x99b2, 0x99c9, 0x99e0, 0x99f8, 0x9a0f, 0x9a27,
	0x9a3f, 0x9a58, 0x9a6f, 0x9a87, 0x9a9f, 0x9ab8, 0x9ad0, 0x9ae9,
	0x9b02, 0x9b1c, 0x9b32, 0x9b49, 0x9b60, 0x9b78, 0x9b8f, 0x9ba7,
	0x9bbf, 0x9bd8, 0x9bef, 0x9c07, 0x9c1f, 0x9c38, 0x9c50, 0x9c69,
	0x9c82, 0x9c9c, 0x9cb3, 0x9ccb, 0x9ce3, 0x9cfc, 0x9d14, 0x9d2d,
	0x9d46, 0x9d60, 0x9d78, 0x9d91, 0x9daa, 0x9dc4, 0x9ddd, 0x9df7,
	0x9e11, 0x9e2c, 0x9e42, 0x9e59, 0x9e70, 0x9e88, 0x9e9f, 0x9eb7,
	0x9ecf, 0x9ee8, 0x9eff, 0x9f17, 0x9f2f, 0x9f48, 0x9f60, 0x9f79,
	// Entry 2400 - 243F
	0x9f92, 0x9fac, 0x9fc3, 0x9fdb, 0x9ff3, 0xa00c, 0xa024, 0xa03d,
	0xa056, 0xa070, 0xa088, 0xa0a1, 0xa0ba, 0xa0d4, 0xa0ed, 0xa107,
	0xa121, 0xa13c, 0xa153, 0xa16b, 0xa183, 0xa19c, 0xa1b4, 0xa1cd,
	0xa1e6, 0xa200, 0xa218, 0xa231, 0xa24a, 0xa264, 0xa27d, 0xa297,
	0xa2b1, 0xa2cc, 0xa2e4, 0xa2fd, 0xa316, 0xa330, 0xa349, 0xa363,
	0xa37d, 0xa398, 0xa3b1, 0xa3cb, 0xa3e5, 0xa400, 0xa41a, 0xa435,
	0xa450, 0xa46c, 0xa482, 0xa499, 0xa4b0, 0xa4c8, 0xa4df, 0xa4f7,
	0xa50f, 0xa528, 0xa53f, 0xa557, 0xa56f, 0xa588, 0xa5a0, 0xa5b9,
	// Entry 2440 - 247F
	0xa5d2, 0xa5ec, 0xa603, 0xa61b, 0xa633, 0xa64c, 0xa664, 0xa67d,
	0xa696, 0xa6b0, 0xa6c8, 0xa6e1, 0xa6fa, 0xa714, 0xa72d, 0xa747,
	0xa761, 0xa77c, 0xa793, 0xa7ab, 0xa7c3, 0xa7dc, 0xa7f4, 0xa80d,
	0xa826, 0xa840, 0xa858, 0xa871, 0xa88a, 0xa8a4, 0xa8bd, 0xa8d7,
	0xa8f1, 0xa90c, 0xa924, 0xa93d, 0xa956, 0xa970, 0xa989, 0xa9a3,
	0xa9bd, 0xa9d8, 0xa9f1, 0xaa0b, 0xaa25, 0xaa40, 0xaa5a, 0xaa75,
	0xaa90, 0xaaac, 0xaac3, 0xaadb, 0xaaf3, 0xab0c, 0xab24, 0xab3d,
	0xab56, 0xab70, 0xab88, 0xaba1, 0xabba, 0xabd4, 0xabed, 0xac07,
	// Entry 2480 - 24BF
	0xac21, 0xac3c, 0xac54, 0xac6d, 0xac86, 0xaca0, 0xacb9, 0xacd3,
	0xaced, 0xad08, 0xad21, 0xad3b, 0xad55, 0xad70, 0xad8a, 0xada5,
	0xadc0, 0xaddc, 0xadf4, 0xae0d, 0xae26, 0xae40, 0xae59, 0xae73,
	0xae8d, 0xaea8, 0xaec1, 0xaedb, 0xaef5, 0xaf10, 0xaf2a, 0xaf45,
	0xaf60, 0xaf7c, 0xaf95, 0xafaf, 0xafc9, 0xafe4, 0xaffe, 0xb019,
	0xb034, 0xb050, 0xb06a, 0xb085, 0xb0a0, 0xb0bc, 0xb0d7, 0xb0f3,
	0xb10f, 0xb12c, 0xb15c, 0xb193, 0xb1be, 0xb1ea, 0xb216, 0xb23a,
	0xb259, 0xb279, 0xb29f, 0xb2c3, 0xb2d7, 0xb2ed, 0xb308, 0xb324,
	// Entry 24C0 - 24FF
	0xb33f, 0xb35b, 0xb382, 0xb3a3, 0xb3b7, 0xb3cd, 0xb3fc, 0xb432,
	0xb457, 0xb491, 0xb4d2, 0xb4e6, 0xb4fb, 0xb516, 0xb532, 0xb552,
	0xb573, 0xb59c, 0xb5c6, 0xb5e5, 0xb604, 0xb61e, 0xb638, 0xb652,
	0xb66c, 0xb691, 0xb6b6, 0xb6db, 0xb700, 0xb729, 0xb752, 0xb77c,
	0xb7a6, 0xb7d0, 0xb7f9, 0xb823, 0xb84d, 0xb86f, 0xb89d, 0xb8cd,
	0xb8fc, 0xb92c, 0xb94a, 0xb96b, 0xb986, 0xb9a4, 0xb9c6, 0xb9eb,
	0xba13, 0xba3e, 0xba5f, 0xba7c, 0xbaa8, 0xbad4, 0xbb00, 0xbb20,
	0xbb3f, 0xbb59, 0xbb7e, 0xbba8, 0xbbcc, 0xbbf0, 0xbc14, 0xbc38,
	// Entry 2500 - 253F
	0xbc5a, 0xbc7f, 0xbca5, 0xbcc8, 0xbced, 0xbd13, 0xbd39, 0xbd61,
	0xbd88, 0xbdb0, 0xbdd5, 0xbdfc, 0xbe23, 0xbe4b, 0xbe73, 0xbe9d,
	0xbec6, 0xbef0, 0xbf17, 0xbf40, 0xbf85, 0xbfca, 0xc011, 0xc05a,
	0xc09e, 0xc0e6, 0xc12a, 0xc172, 0xc1a0, 0xc1d0, 0xc1ff, 0xc230,
	0xc277, 0xc2be, 0xc2e2, 0xc304, 0xc329, 0xc34d, 0xc372, 0xc398,
	0xc3b7, 0xc3d8, 0xc3fb, 0xc418, 0xc436, 0xc454, 0xc462, 0xc471,
	0xc47d, 0xc48b, 0xc4a8, 0xc4b7, 0xc4cc, 0xc4e4, 0xc4fd, 0xc513,
	0xc52a, 0xc547, 0xc565, 0xc584, 0xc5a4, 0xc5c5, 0xc5e7, 0xc612,
	// Entry 2540 - 257F
	0xc641, 0xc66f, 0xc69b, 0xc6b6, 0xc6d2, 0xc6ec, 0xc70a, 0xc72e,
	0xc750, 0xc771, 0xc793, 0xc79f, 0xc7b3, 0xc7ce, 0xc7ed, 0xc80a,
	0xc81d, 0xc828, 0xc844, 0xc85e, 0xc86a, 0xc878, 0xc88b, 0xc8a7,
	0xc8bf, 0xc8d9, 0xc91b, 0xc95c, 0xc9a0, 0xc9e3, 0xca25, 0xca66,
	0xcaaa, 0xcaed, 0xcaff, 0xcb15, 0xcb36, 0xcb56, 0xcb75, 0xcb8f,
	0xcba3, 0xcbb3, 0xcbca, 0xcbdf, 0xcc24, 0xcc3e, 0xcc69, 0xcc80,
	0xcc94, 0xcca2, 0xccb3, 0xccc7, 0xccec, 0xcd1b, 0xcd38, 0xcd56,
	0xcd66, 0xcd7a, 0xcd88, 0xcd9a, 0xcdb1, 0xcdc7, 0xcdd4, 0xcdf2,
	// Entry 2580 - 25BF
	0xce14, 0xce35, 0xce57, 0xce72, 0xce8e, 0xce9a, 0xceb4, 0xcecf,
	0xcede, 0xceed, 0xcefe, 0xcf10, 0xcf28, 0xcf41, 0xcf54, 0xcf65,
	0xcf87, 0xcf9c, 0xcfb9, 0xcfc5, 0xcfd4, 0xcff4, 0xd025, 0xd046,
	0xd052, 0xd05f, 0xd08a, 0xd0b6, 0xd0d3, 0xd0e0, 0xd0fc, 0xd118,
	0xd131, 0xd14a, 0xd164, 0xd17e, 0xd197, 0xd1b0, 0xd1bc, 0xd1d4,
	0xd1e8, 0xd20e, 0xd219, 0xd22c, 0xd237, 0xd242, 0xd264, 0xd287,
	0xd28b, 0xd28f, 0xd2a9, 0xd2c4, 0xd2e0, 0xd2fd, 0xd31b, 0xd33d,
	0xd358, 0xd370, 0xd387, 0xd39b, 0xd3a9, 0xd3c0, 0xd3db, 0xd3ef,
	// Entry 25C0 - 25FF
	0xd40a, 0xd425, 0xd439, 0xd452, 0xd484, 0xd4b7, 0xd4de, 0xd4fe,
	0xd51a, 0xd541, 0xd559, 0xd573, 0xd586, 0xd59b, 0xd5b1, 0xd5b5,
	0xd5d1, 0xd5ee, 0xd606, 0xd622, 0xd643, 0xd669, 0xd683, 0xd69b,
	0xd6b5, 0xd6d1, 0xd6ee, 0xd709, 0xd722, 0xd73e, 0xd759, 0xd776,
	0xd794, 0xd7ab, 0xd7cd, 0xd7ee, 0xd813, 0xd820, 0xd847, 0xd86f,
	0xd8a1, 0xd8c5, 0xd8da, 0xd8ef, 0xd905, 0xd924, 0xd934, 0xd94e,
	0xd96f, 0xd988, 0xd99d, 0xd9b2, 0xd9c4, 0xd9dd, 0xd9fa, 0xda0f,
	0xda27, 0xda3f, 0xda61, 0xda83, 0xdaa5, 0xdad5, 0xdaed, 0xdb0c,
	// Entry 2600 - 263F
	0xdb26, 0xdb39, 0xdb63, 0xdb7d, 0xdb96, 0xdba8, 0xdbb9, 0xdbd5,
	0xdbf0, 0xdc00, 0xdc11, 0xdc33, 0xdc4f, 0xdc6a, 0xdc8a, 0xdca9,
	0xdcc8, 0xdce1, 0xdd01, 0xdd18, 0xdd36, 0xdd55, 0xdd76, 0xdd96,
	0xddb0, 0xddc8, 0xddf9, 0xde2a, 0xde47, 0xde66, 0xde7b, 0xde93,
	0xdea7, 0xdecd, 0xdeec, 0xdf07, 0xdf22, 0xdf42, 0xdf54, 0xdf70,
	0xdf8e, 0xdfc0, 0xdfdf, 0xdffb, 0xe01a, 0xe03c, 0xe061, 0xe07e,
	0xe09e, 0xe0cb, 0xe0fb, 0xe127, 0xe156, 0xe188, 0xe1bc, 0xe1d4,
	0xe1ef, 0xe215, 0xe23e, 0xe25b, 0xe27b, 0xe2af, 0xe2e3, 0xe303,
	// Entry 2640 - 267F
	0xe326, 0xe350, 0xe37a, 0xe3ae, 0xe3e2, 0xe426, 0xe46a, 0xe487,
	0xe4a7, 0xe4d4, 0xe504, 0xe525, 0xe549, 0xe572, 0xe59e, 0xe5b2,
	0xe5c9, 0xe5f2, 0xe61e, 0xe635, 0xe64f, 0xe674, 0xe696, 0xe6b3,
	0xe6cc, 0xe6e8, 0xe715, 0xe745, 0xe751, 0xe75c, 0xe774, 0xe78b,
	0xe7a7, 0xe7cd, 0xe7f3, 0xe81a, 0xe841, 0xe85b, 0xe875, 0xe890,
	0xe8ab, 0xe8c9, 0xe8e7, 0xe909, 0xe92b, 0xe93a, 0xe949, 0xe958,
	0xe969, 0xe984, 0xe9a1, 0xe9c6, 0xe9ed, 0xea11, 0xea37, 0xea52,
	0xea6f, 0xea8d, 0xeaad, 0xeacc, 0xeaed, 0xeb09, 0xeb27, 0xeb44,
	// Entry 2680 - 26BF
	0xeb62, 0xeb6f, 0xeb7e, 0xeb97, 0xebb2, 0xebc7, 0xebdc, 0xebef,
	0xec06, 0xec1c, 0xec4a, 0xec66, 0xec7c, 0xec94, 0xec9b, 0xeca5,
	0xecb4, 0xecc3, 0xecd0, 0xece4, 0xed07, 0xed29, 0xed4b, 0xed74,
	0xeda1, 0xedbd, 0xedd8, 0xedfb, 0xee0b, 0xee19, 0xee2f, 0xee4e,
	0xee7a, 0xee99, 0xeeb8, 0xeed3, 0xeef2, 0xef0e, 0xef31, 0xef5b,
	0xef70, 0xef87, 0xefa1, 0xefca, 0xeff6, 0xf014, 0xf036, 0xf04d,
	0xf05f, 0xf077, 0xf08d, 0xf0a3, 0xf0b9, 0xf0cf, 0xf0e5, 0xf0fa,
	0xf10d, 0xf122, 0xf138, 0xf14e, 0xf164, 0xf17a, 0xf190, 0xf1a3,
	// Entry 26C0 - 26FF
	0xf1c6, 0xf1e7, 0xf209, 0xf229, 0xf243, 0xf260, 0xf28b, 0xf2b5,
	0xf2d1, 0xf2ee, 0xf309, 0xf327, 0xf334, 0xf346, 0xf358, 0xf36f,
	0xf386, 0xf394, 0xf3a2, 0xf3af, 0xf3bc, 0xf3d4, 0xf3e6, 0xf3fa,
	0xf40e, 0xf422, 0xf436, 0xf449, 0xf45c, 0xf46f, 0xf487, 0xf49f,
	0xf4b5, 0xf4cb, 0xf4e7, 0xf4fd, 0xf519, 0xf536, 0xf565, 0xf59b,
	0xf5be, 0xf5e4, 0xf604, 0xf632, 0xf667, 0xf68b, 0xf6c4, 0xf704,
	0xf71d, 0xf73e, 0xf75f, 0xf78b, 0xf7b8, 0xf7dd, 0xf7fe, 0xf817,
	0xf831, 0xf85e, 0xf88c, 0xf8b0, 0xf8d5, 0xf901, 0xf92e, 0xf954,
	// Entry 2700 - 273F
	0xf96d, 0xf98a, 0xf99b, 0xf9ab, 0xf9bb, 0xf9d8, 0xf9f5, 0xfa07,
	0xfa22, 0xfa41, 0xfa4d, 0xfa62, 0xfa86, 0xfaae, 0xfad6, 0xfb02,
	0xfb2f, 0xfb62, 0xfb81, 0xfb9e, 0xfbbe, 0xfbdd, 0xfbfd, 0xfc1a,
	0xfc3a, 0xfc5a, 0xfc7a, 0xfc9a, 0xfcc0, 0xfce4, 0xfd0b, 0xfd31,
	0xfd5c, 0xfd8b, 0xfdb1, 0xfdd5, 0xfdfc, 0xfe22, 0xfe49, 0xfe70,
	0xfe97, 0xfebe, 0xfefb, 0xff36, 0xff74, 0xffb1, 0xffc3, 0xffd3,
	0x0018, 0x0062, 0x00a7, 0x00f1, 0x0118, 0x013d, 0x0165, 0x018c,
	0x01af, 0x01d0, 0x01f4, 0x0217, 0x0249, 0x027c, 0x02ad, 0x02dd,
	// Entry 2740 - 277F
	0x02e8, 0x02f4, 0x0300, 0x030d, 0x0336, 0x034c, 0x037f, 0x03b2,
	0x03e6, 0x041a, 0x043f, 0x0462, 0x0488, 0x04ad, 0x04e4, 0x051c,
	0x0551, 0x0587, 0x05bc, 0x05f2, 0x0629, 0x0661, 0x068b, 0x06b6,
	0x06de, 0x0707, 0x072f, 0x0758, 0x0782, 0x07ad, 0x07c3, 0x07da,
	0x07ee, 0x0803, 0x0817, 0x082c, 0x0842, 0x0859, 0x0889, 0x08a8,
	0x08c1, 0x08e4, 0x08fd, 0x0914, 0x091d, 0x092b, 0x093f, 0x0954,
	0x0969, 0x0981, 0x098e, 0x09b7, 0x09e2, 0x0a0d, 0x0a39, 0x0a4e,
	0x0a66, 0x0a83, 0x0aa8, 0x0abf, 0x0ade, 0x0af7, 0x0b07, 0x0b11,
	// Entry 2780 - 27BF
	0x0b1f, 0x0b2f, 0x0b3e, 0x0b4d, 0x0b57, 0x0b61, 0x0b68, 0x0b6e,
	0x0b74, 0x0b7a, 0x0b8b, 0x0ba1, 0x0bb5, 0x0bbb, 0x0bc0, 0x0bc4,
	0x0bca, 0x0bd1, 0x0bd8, 0x0be0, 0x0be8, 0x0bfc, 0x0c11, 0x0c2a,
	0x0c44, 0x0c77, 0x0ca8, 0x0cdc, 0x0d0f, 0x0d1c, 0x0d29, 0x0d2e,
	0x0d53, 0x0d75, 0x0d99, 0x0dbd, 0x0de1, 0x0e06, 0x0e25, 0x0e32,
	0x0e42, 0x0e50, 0x0e5d, 0x0e71, 0x0e8e, 0x0eac, 0x0eca, 0x0eeb,
	0x0f0a, 0x0f29, 0x0f4a, 0x0f69, 0x0f89, 0x0fa7, 0x0fcd, 0x0fe8,
	0x1008, 0x1026, 0x1047, 0x1068, 0x1087, 0x10a4, 0x10c4, 0x10e3,
	// Entry 27C0 - 27FF
	0x1102, 0x1122, 0x113f, 0x115e, 0x117c, 0x1199, 0x11b5, 0x11d3,
	0x11f0, 0x1210, 0x122d, 0x124b, 0x1269, 0x1287, 0x12ab, 0x12c7,
	0x12ea, 0x1317, 0x1333, 0x135e, 0x137f, 0x13a8, 0x13c6, 0x13e7,
	0x1408, 0x142e, 0x1458, 0x1473, 0x148f, 0x14ab, 0x14ca, 0x14e7,
	0x1504, 0x1523, 0x1540, 0x155e, 0x157a, 0x159e, 0x15b7, 0x15d5,
	0x15f1, 0x1610, 0x162f, 0x164c, 0x1667, 0x1685, 0x16a2, 0x16bf,
	0x16dd, 0x16f8, 0x1715, 0x1731, 0x174c, 0x1766, 0x1782, 0x179d,
	0x17bb, 0x17d6, 0x17f2, 0x180e, 0x182a, 0x184c, 0x1866, 0x1887,
	// Entry 2800 - 283F
	0x18b2, 0x18cc, 0x18f5, 0x1914, 0x193b, 0x1957, 0x1976, 0x1995,
	0x19b9, 0x19e1, 0x1a07, 0x1a2b, 0x1a53, 0x1a75, 0x1a95, 0x1ab5,
	0x1ade, 0x1b03, 0x1b26, 0x1b4b, 0x1b6e, 0x1b93, 0x1bb6, 0x1bd0,
	0x1bf0, 0x1c0d, 0x1c2e, 0x1c52, 0x1c72, 0x1c90, 0x1cae, 0x1cc9,
	0x1ce2, 0x1d01, 0x1d20, 0x1d45, 0x1d6e, 0x1d91, 0x1daf, 0x1dc8,
	0x1dee, 0x1e14, 0x1e2e, 0x1e46, 0x1e60, 0x1e78, 0x1e93, 0x1eac,
	0x1ec7, 0x1ee0, 0x1ef9, 0x1f10, 0x1f29, 0x1f40, 0x1f5a, 0x1f72,
	0x1f8c, 0x1fa4, 0x1fc0, 0x1fda, 0x1ff5, 0x200e, 0x2028, 0x2040,
	// Entry 2840 - 287F
	0x205b, 0x2074, 0x208c, 0x20a2, 0x20ba, 0x20d0, 0x20e9, 0x2100,
	0x2117, 0x212c, 0x2144, 0x215a, 0x2172, 0x2188, 0x21a2, 0x21ba,
	0x21d3, 0x21ea, 0x2202, 0x2218, 0x2230, 0x2246, 0x225f, 0x2276,
	0x228f, 0x22a6, 0x22bf, 0x22d6, 0x22fa, 0x231c, 0x2340, 0x2362,
	0x2389, 0x23ae, 0x23d2, 0x23f4, 0x2416, 0x2436, 0x245c, 0x2480,
	0x24a4, 0x24c6, 0x24e1, 0x24fa, 0x251c, 0x253c, 0x2561, 0x2584,
	0x25a8, 0x25ca, 0x25ed, 0x260e, 0x2632, 0x2654, 0x2679, 0x269c,
	0x26bf, 0x26e0, 0x2701, 0x2720, 0x2744, 0x2766, 0x278a, 0x27ac,
	// Entry 2880 - 28BF
	0x27d3, 0x27f8, 0x281c, 0x283e, 0x2864, 0x2888, 0x28ae, 0x28d2,
	0x28f6, 0x2918, 0x293c, 0x295e, 0x2982, 0x29a4, 0x29b5, 0x29c8,
	0x29db, 0x29f0, 0x2a04, 0x2a18, 0x2a30, 0x2a58, 0x2a7e, 0x2aa8,
	0x2ad0, 0x2ae9, 0x2b08, 0x2b27, 0x2b4a, 0x2b6b, 0x2b86, 0x2bac,
	0x2bd4, 0x2bf3, 0x2c0b, 0x2c1b, 0x2c37, 0x2c4f, 0x2c68, 0x2c81,
	0x2c9a, 0x2cb2, 0x2ccb, 0x2ce4, 0x2cfd, 0x2d15, 0x2d2e, 0x2d47,
	0x2d60, 0x2d79, 0x2d91, 0x2daa, 0x2dc4, 0x2ddd, 0x2df6, 0x2e0f,
	0x2e27, 0x2e41, 0x2e5b, 0x2e75, 0x2e8e, 0x2ea8, 0x2ec2, 0x2edb,
	// Entry 28C0 - 28FF
	0x2ef4, 0x2f0d, 0x2f27, 0x2f40, 0x2f5a, 0x2f73, 0x2f8b, 0x2fa4,
	0x2fbc, 0x2fd5, 0x2fee, 0x3006, 0x301f, 0x3031, 0x3044, 0x3058,
	0x306b, 0x3080, 0x30a2, 0x30b5, 0x30c8, 0x30dc, 0x30f0, 0x3105,
	0x3118, 0x312b, 0x313e, 0x3158, 0x316d, 0x3180, 0x31a2, 0x31bc,
	0x31d0, 0x31e3, 0x31f7, 0x3212, 0x3225, 0x323f, 0x3251, 0x3265,
	0x3281, 0x329c, 0x32af, 0x32c2, 0x32d5, 0x32f0, 0x330b, 0x331e,
	0x3330, 0x3343, 0x3357, 0x336b, 0x3386, 0x339f, 0x33b2, 0x33c6,
	0x33da, 0x33ed, 0x3401, 0x3415, 0x3429, 0x343c, 0x344f, 0x3462,
	// Entry 2900 - 293F
	0x3475, 0x3493, 0x34a7, 0x34b9, 0x34cb, 0x34f6, 0x350d, 0x3526,
	0x353b, 0x3550, 0x3565, 0x357a, 0x3590, 0x35a5, 0x35ba, 0x35cf,
	0x35e4, 0x35fa, 0x3616, 0x362b, 0x3640, 0x3656, 0x366b, 0x3681,
	0x3697, 0x36ad, 0x36c2, 0x36d8, 0x36ee, 0x3705, 0x371b, 0x3730,
	0x3745, 0x375a, 0x3770, 0x3786, 0x379b, 0x37b0, 0x37c5, 0x37da,
	0x37ef, 0x3805, 0x381b, 0x3830, 0x3845, 0x385a, 0x386f, 0x3884,
	0x389a, 0x38b0, 0x38c5, 0x38da, 0x38f0, 0x3906, 0x391c, 0x3933,
	0x394a, 0x3960, 0x3976, 0x398b, 0x39a0, 0x39b5, 0x39cb, 0x39e1,
	// Entry 2940 - 297F
	0x39f6, 0x3a0b, 0x3a20, 0x3a35, 0x3a4a, 0x3a60, 0x3a76, 0x3a8b,
	0x3aa0, 0x3ab5, 0x3aca, 0x3adf, 0x3af5, 0x3b0b, 0x3b20, 0x3b35,
	0x3b4a, 0x3b5f, 0x3b74, 0x3b8a, 0x3ba0, 0x3bb5, 0x3bca, 0x3be6,
	0x3c02, 0x3c1f, 0x3c3b, 0x3c58, 0x3c74, 0x3c90, 0x3cac, 0x3cc8,
	0x3ce4, 0x3cff, 0x3d1b, 0x3d37, 0x3d53, 0x3d6f, 0x3d8b, 0x3da8,
	0x3dc5, 0x3de2, 0x3e01, 0x3e1f, 0x3e3e, 0x3e59, 0x3e75, 0x3e94,
	0x3eba, 0x3ed7, 0x3ef3, 0x3f17, 0x3f3b, 0x3f5c, 0x3f86, 0x3fa5,
	0x3fcb, 0x3fe4, 0x3ffe, 0x401e, 0x403f, 0x405a, 0x407c, 0x4097,
	// Entry 2980 - 29BF
	0x40b1, 0x40cc, 0x40d9, 0x40f5, 0x4112, 0x4123, 0x412e, 0x4140,
	0x415b, 0x4167, 0x4174, 0x4184, 0x4192, 0x41ad, 0x41c2, 0x41d6,
	0x41e1, 0x41f6, 0x420b, 0x4226, 0x4242, 0x4256, 0x426a, 0x4286,
	0x42a3, 0x42b8, 0x42ce, 0x42e6, 0x42ff, 0x4316, 0x432e, 0x4345,
	0x435d, 0x437e, 0x439f, 0x43bb, 0x43c8, 0x43de, 0x43ec, 0x43f6,
	0x440f, 0x441b, 0x4425, 0x4431, 0x4441, 0x4457, 0x446e, 0x447b,
	0x4490, 0x449b, 0x44a8, 0x44be, 0x44cf, 0x44e3, 0x44ec, 0x44f9,
	0x4507, 0x452b, 0x4540, 0x4556, 0x4569, 0x458e, 0x4598, 0x45ab,
	// Entry 29C0 - 29FF
	0x45bf, 0x45cd, 0x45da, 0x45e8, 0x45f8, 0x460d, 0x461f, 0x4630,
	0x4646, 0x465c, 0x4674, 0x4686, 0x4695, 0x46a6, 0x46bb, 0x46d0,
	0x46e6, 0x46f6, 0x470b, 0x4720, 0x4734, 0x4748, 0x475e, 0x4773,
	0x4784, 0x4796, 0x47ab, 0x47c0, 0x47d5, 0x47ea, 0x47fa, 0x4809,
	0x481a, 0x4829, 0x4839, 0x484a, 0x485c, 0x4870, 0x4885, 0x489a,
	0x48aa, 0x48bd, 0x48d0, 0x48f6, 0x4905, 0x4914, 0x4924, 0x493d,
	0x494c, 0x4962, 0x4978, 0x498a, 0x499a, 0x49b7, 0x49ca, 0x49dd,
	0x49f2, 0x4a06, 0x4a16, 0x4a27, 0x4a36, 0x4a45, 0x4a54, 0x4a69,
	// Entry 2A00 - 2A3F
	0x4a7e, 0x4a8e, 0x4aa0, 0x4ab5, 0x4aca, 0x4ae1, 0x4af2, 0x4b05,
	0x4b19, 0x4b2d, 0x4b49, 0x4b64, 0x4b74, 0x4b93, 0x4bb1, 0x4bc1,
	0x4bde, 0x4bf9, 0x4c0d, 0x4c21, 0x4c31, 0x4c4e, 0x4c62, 0x4c76,
	0x4c93, 0x4cb0, 0x4cc5, 0x4cda, 0x4cea, 0x4cfa, 0x4d21, 0x4d3e,
	0x4d5b, 0x4d77, 0x4d8a, 0x4d9d, 0x4db2, 0x4dce, 0x4dde, 0x4dfc,
	0x4e0c, 0x4e1d, 0x4e3a, 0x4e57, 0x4e74, 0x4e90, 0x4ead, 0x4eca,
	0x4ee7, 0x4f04, 0x4f22, 0x4f40, 0x4f5f, 0x4f7e, 0x4f90, 0x4faf,
	0x4fce, 0x4fe0, 0x4ff3, 0x5005, 0x5019, 0x502e, 0x5041, 0x5053,
	// Entry 2A40 - 2A7F
	0x5065, 0x5077, 0x508a, 0x509e, 0x50b2, 0x50c9, 0x50dd, 0x50ef,
	0x5103, 0x511a, 0x512e, 0x5142, 0x5155, 0x5169, 0x5186, 0x51a5,
	0x51b7, 0x51d0, 0x51e3, 0x51f7, 0x520d, 0x5221, 0x5235, 0x524d,
	0x5261, 0x5277, 0x5288, 0x52a0, 0x52b6, 0x52c8, 0x52dc, 0x52f0,
	0x5303, 0x5316, 0x532a, 0x533d, 0x5352, 0x5367, 0x537e, 0x5392,
	0x53a5, 0x53bb, 0x53d0, 0x53e2, 0x53fd, 0x5418, 0x5432, 0x544a,
	0x545e, 0x5470, 0x5484, 0x549a, 0x54ad, 0x54c1, 0x54d7, 0x54ea,
	0x54fd, 0x5512, 0x5524, 0x5539, 0x554e, 0x5560, 0x5575, 0x5587,
	// Entry 2A80 - 2ABF
	0x5599, 0x55ab, 0x55be, 0x55d1, 0x55e4, 0x55f7, 0x560b, 0x5620,
	0x5635, 0x564b, 0x565d, 0x5670, 0x5684, 0x5698, 0x56ab, 0x56be,
	0x56d3, 0x56ea, 0x5708, 0x571c, 0x572f, 0x5741, 0x5753, 0x576a,
	0x577d, 0x5791, 0x57a4, 0x57b8, 0x57cb, 0x57dd, 0x57f1, 0x580d,
	0x5824, 0x583e, 0x5852, 0x5865, 0x5878, 0x588a, 0x589e, 0x58b2,
	0x58c6, 0x58db, 0x58ef, 0x5903, 0x5916, 0x592a, 0x593f, 0x5952,
	0x5965, 0x5977, 0x5989, 0x599d, 0x59b3, 0x59c5, 0x59d7, 0x59ea,
	0x59fc, 0x5a10, 0x5a23, 0x5a3a, 0x5a4d, 0x5a62, 0x5a77, 0x5a8c,
	// Entry 2AC0 - 2AFF
	0x5aa1, 0x5ab4, 0x5acb, 0x5adf, 0x5af3, 0x5b07, 0x5b1c, 0x5b30,
	0x5b4d, 0x5b63, 0x5b76, 0x5b88, 0x5b9b, 0x5bb0, 0x5bc5, 0x5bd8,
	0x5bea, 0x5bff, 0x5c13, 0x5c25, 0x5c37, 0x5c4a, 0x5c5d, 0x5c70,
	0x5c85, 0x5c9b, 0x5cae, 0x5cc1, 0x5cd4, 0x5cee, 0x5d04, 0x5d17,
	0x5d2a, 0x5d3d, 0x5d51, 0x5d65, 0x5d85, 0x5d98, 0x5dab, 0x5dbf,
	0x5dd2, 0x5de8, 0x5e05, 0x5e18, 0x5e2c, 0x5e3f, 0x5e52, 0x5e64,
	0x5e76, 0x5e89, 0x5ea0, 0x5eb4, 0x5ec7, 0x5eda, 0x5eed, 0x5f01,
	0x5f20, 0x5f37, 0x5f4b, 0x5f5e, 0x5f71, 0x5f84, 0x5f97, 0x5fab,
	// Entry 2B00 - 2B3F
	0x5fbe, 0x5fd3, 0x5fe8, 0x5ffc, 0x6015, 0x6028, 0x603d, 0x6050,
	0x6062, 0x6075, 0x6088, 0x609c, 0x60b1, 0x60c6, 0x60da, 0x6109,
	0x6139, 0x6173, 0x61ae, 0x61dd, 0x6212, 0x6247, 0x627b, 0x62b5,
	0x62f0, 0x632a, 0x6354, 0x6365, 0x6376, 0x638b, 0x6395, 0x63b8,
	0x63d2, 0x63ea, 0x6401, 0x6413, 0x6426, 0x643f, 0x6459, 0x646c,
	0x6480, 0x6499, 0x64b3, 0x64d0, 0x64ee, 0x64f9, 0x6502, 0x651d,
	0x6539, 0x6556, 0x6574, 0x6595, 0x65b7, 0x65d0, 0x65ea, 0x65f3,
	0x6617, 0x6632, 0x6651, 0x6661, 0x6675, 0x6689, 0x669f, 0x66b4,
	// Entry 2B40 - 2B7F
	0x66c9, 0x66dd, 0x66f3, 0x6709, 0x671e, 0x6739, 0x6755, 0x6774,
	0x6792, 0x67ad, 0x67c8, 0x67d1, 0x67ea, 0x6815, 0x6839, 0x686f,
	0x6893, 0x68a6, 0x68d6, 0x68ea, 0x6901, 0x6918, 0x693b, 0x6944,
	0x6959, 0x6978, 0x6993, 0x69aa, 0x69bb, 0x69d2, 0x69e3, 0x69fa,
	0x6a0b, 0x6a22, 0x6a33, 0x6a4a, 0x6a5b, 0x6a6d, 0x6a7f, 0x6a91,
	0x6aa3, 0x6ab5, 0x6ac7, 0x6ad9, 0x6aeb, 0x6afd, 0x6b0f, 0x6b21,
	0x6b33, 0x6b45, 0x6b57, 0x6b69, 0x6b7b, 0x6b8d, 0x6b9f, 0x6bb1,
	0x6bc3, 0x6bd5, 0x6be7, 0x6bf9, 0x6c0b, 0x6c23, 0x6c35, 0x6c47,
	// Entry 2B80 - 2BBF
	0x6c59, 0x6c6b, 0x6c7d, 0x6c8f, 0x6ca1, 0x6cb3, 0x6cc5, 0x6cd7,
	0x6ce9, 0x6cfb, 0x6d0d, 0x6d1f, 0x6d31, 0x6d43, 0x6d55, 0x6d67,
	0x6d79, 0x6d8b, 0x6d9d, 0x6daf, 0x6dc1, 0x6dd3, 0x6de5, 0x6df7,
	0x6e09, 0x6e1b, 0x6e2d, 0x6e3f, 0x6e51, 0x6e69, 0x6e7b, 0x6e93,
	0x6ea5, 0x6ebd, 0x6ecf, 0x6ee1, 0x6ef3, 0x6f05, 0x6f17, 0x6f29,
	0x6f41, 0x6f53, 0x6f65, 0x6f77, 0x6f89, 0x6f9a, 0x6fac, 0x6fc4,
	0x6fdc, 0x7009, 0x703b, 0x705e, 0x7086, 0x709d, 0x70bb, 0x70d0,
	0x70ef, 0x7106, 0x7117, 0x712e, 0x713f, 0x7156, 0x7167, 0x717e,
	// Entry 2BC0 - 2BFF
	0x718f, 0x71a6, 0x71b7, 0x71c9, 0x71db, 0x71ed, 0x71ff, 0x7211,
	0x7223, 0x7235, 0x7247, 0x7259, 0x726b, 0x727d, 0x728f, 0x72a1,
	0x72b3, 0x72c5, 0x72d7, 0x72e9, 0x72fb, 0x730d, 0x731f, 0x7331,
	0x7343, 0x7355, 0x7367, 0x737f, 0x7391, 0x73a3, 0x73b5, 0x73c7,
	0x73d9, 0x73eb, 0x73fd, 0x740f, 0x7421, 0x7433, 0x7445, 0x7457,
	0x7469, 0x747b, 0x748d, 0x749f, 0x74b1, 0x74c3, 0x74d5, 0x74e7,
	0x74f9, 0x750b, 0x751d, 0x752f, 0x7541, 0x7553, 0x7565, 0x7577,
	0x7589, 0x759b, 0x75ad, 0x75c5, 0x75d7, 0x75ef, 0x7601, 0x7619,
	// Entry 2C00 - 2C3F
	0x762b, 0x763d, 0x764f, 0x7661, 0x7673, 0x7685, 0x769d, 0x76af,
	0x76c1, 0x76d3, 0x76e5, 0x76f6, 0x7708, 0x7720, 0x7738, 0x774a,
	0x775c, 0x776e, 0x7780, 0x7793, 0x77b9, 0x77d0, 0x77ee, 0x7803,
	0x7814, 0x7825, 0x7836, 0x7847, 0x7858, 0x7869, 0x787a, 0x788b,
	0x789c, 0x78ad, 0x78be, 0x78cf, 0x78e0, 0x78f1, 0x7903, 0x7915,
	0x7927, 0x7938, 0x7949, 0x795a, 0x796b, 0x797c, 0x798d, 0x799e,
	0x79b0, 0x79c2, 0x79d4, 0x79e6, 0x79f8, 0x7a0a, 0x7a1c, 0x7a2f,
	0x7a42, 0x7a54, 0x7a65, 0x7a76, 0x7a88, 0x7a99, 0x7aab, 0x7abd,
	// Entry 2C40 - 2C7F
	0x7acf, 0x7aef, 0x7b01, 0x7b15, 0x7b2e, 0x7b47, 0x7b5a, 0x7b73,
	0x7b8c, 0x7ba0, 0x7bb9, 0x7bcc, 0x7be6, 0x7bff, 0x7c18, 0x7c30,
	0x7c4b, 0x7c66, 0x7c7f, 0x7c92, 0x7ca5, 0x7cbd, 0x7cd5, 0x7ce7,
	0x7cfe, 0x7d11, 0x7d24, 0x7d3c, 0x7d51, 0x7d66, 0x7d7b, 0x7d90,
	0x7da3, 0x7db2, 0x7dc2, 0x7dd2, 0x7de3, 0x7df3, 0x7e02, 0x7e13,
	0x7e23, 0x7e32, 0x7e42, 0x7e53, 0x7e63, 0x7e73, 0x7e82, 0x7e93,
	0x7ea3, 0x7eb3, 0x7ec3, 0x7ed3, 0x7ee3, 0x7ef2, 0x7eff, 0x7f17,
	0x7f31, 0x7f49, 0x7f64, 0x7f83, 0x7f9d, 0x7fbb, 0x7fd6, 0x7ff5,
	// Entry 2C80 - 2CBF
	0x800e, 0x8026, 0x8041, 0x805c, 0x8076, 0x8090, 0x80af, 0x80ce,
	0x80e7, 0x8102, 0x811d, 0x813d, 0x8156, 0x816e, 0x8187, 0x819f,
	0x81b7, 0x81cc, 0x81e4, 0x81fa, 0x8215, 0x8233, 0x8250, 0x8268,
	0x8281, 0x8294, 0x82a8, 0x82ba, 0x82ce, 0x82e1, 0x82f3, 0x8306,
	0x831a, 0x833d, 0x8360, 0x837f, 0x839e, 0x83bf, 0x83df, 0x83fe,
	0x8420, 0x8442, 0x8463, 0x8485, 0x84a6, 0x84c8, 0x84ea, 0x850b,
	0x852a, 0x853c, 0x854e, 0x8560, 0x8572, 0x8584, 0x8597, 0x85a9,
	0x85bc, 0x85ce, 0x85e1, 0x85f4, 0x8607, 0x8619, 0x862c, 0x8640,
	// Entry 2CC0 - 2CFF
	0x8654, 0x8666, 0x8678, 0x868b, 0x869f, 0x86b6, 0x86cd, 0x86e4,
	0x86fb, 0x870d, 0x871f, 0x8731, 0x873d, 0x874a, 0x8757, 0x8765,
	0x8772, 0x8780, 0x878e, 0x879b, 0x87aa, 0x87b9, 0x87c7, 0x87d6,
	0x87e5, 0x87f3, 0x8802, 0x880e, 0x881a, 0x8826, 0x8832, 0x883f,
	0x884b, 0x8858, 0x8865, 0x8872, 0x8880, 0x888d, 0x889a, 0x88a7,
	0x88b4, 0x88c1, 0x88cf, 0x88dd, 0x88ec, 0x88fc, 0x8909, 0x8915,
	0x892d, 0x8945, 0x895d, 0x8975, 0x898d, 0x89a5, 0x89bd, 0x89d5,
	0x89ed, 0x8a05, 0x8a1d, 0x8a35, 0x8a4d, 0x8a65, 0x8a7d, 0x8a95,
	// Entry 2D00 - 2D3F
	0x8ab0, 0x8aca, 0x8ae5, 0x8aff, 0x8b19, 0x8b33, 0x8b4c, 0x8b66,
	0x8b80, 0x8b9c, 0x8bb8, 0x8bd4, 0x8bf0, 0x8c0a, 0x8c27, 0x8c43,
	0x8c60, 0x8c7c, 0x8c98, 0x8cb4, 0x8ccf, 0x8ceb, 0x8d07, 0x8d25,
	0x8d43, 0x8d61, 0x8d7f, 0x8d9b, 0x8db7, 0x8ddb, 0x8dfe, 0x8e19,
	0x8e34, 0x8e51, 0x8e6d, 0x8e89, 0x8ea4, 0x8ec1, 0x8ede, 0x8efa,
	0x8f15, 0x8f31, 0x8f4d, 0x8f6a, 0x8f86, 0x8fa3, 0x8fc0, 0x8fdb,
	0x8ff8, 0x9014, 0x9033, 0x904f, 0x906e, 0x908f, 0x90b5, 0x90d2,
	0x90f3, 0x910f, 0x912c, 0x914d, 0x916f, 0x918f, 0x91af, 0x91cf,
	// Entry 2D40 - 2D7F
	0x91eb, 0x9207, 0x9224, 0x923e, 0x925c, 0x9274, 0x928a, 0x92ac,
	0x92d1, 0x92f6, 0x931a, 0x933e, 0x9362, 0x9388, 0x93ad, 0x93bd,
	0x93d6, 0x93ef, 0x940a, 0x9424, 0x943e, 0x9457, 0x9472, 0x948d,
	0x94a7, 0x94bc, 0x94d5, 0x94ee, 0x9509, 0x9523, 0x953d, 0x9552,
	0x9566, 0x957b, 0x958f, 0x95a3, 0x95b7, 0x95ca, 0x95de, 0x95f2,
	0x9608, 0x961e, 0x9634, 0x964a, 0x965e, 0x9675, 0x968b, 0x96a2,
	0x96b8, 0x96ce, 0x96e4, 0x96f9, 0x970f, 0x9725, 0x973d, 0x9755,
	0x976d, 0x9785, 0x979b, 0x97ba, 0x97d8, 0x97ee, 0x9804, 0x9819,
	// Entry 2D80 - 2DBF
	0x982e, 0x9845, 0x985b, 0x9871, 0x9886, 0x989d, 0x98b4, 0x98ca,
	0x98df, 0x98f5, 0x990b, 0x9922, 0x9938, 0x994f, 0x9966, 0x997b,
	0x9992, 0x99a8, 0x99c1, 0x99d7, 0x99f0, 0x9a0b, 0x9a2b, 0x9a42,
	0x9a5a, 0x9a70, 0x9a88, 0x9aa2, 0x9abd, 0x9ad4, 0x9aef, 0x9b05,
	0x9b1b, 0x9b31, 0x9b4a, 0x9b60, 0x9b78, 0x9b8d, 0x9ba3, 0x9bba,
	0x9bd4, 0x9bee, 0x9c05, 0x9c20, 0x9c3c, 0x9c56, 0x9c70, 0x9c87,
	0x9ca0, 0x9cbb, 0x9cd6, 0x9cf0, 0x9d04, 0x9d1c, 0x9d34, 0x9d4e,
	0x9d67, 0x9d80, 0x9d98, 0x9db2, 0x9dcc, 0x9de5, 0x9df9, 0x9e21,
	// Entry 2DC0 - 2DFF
	0x9e4a, 0x9e70, 0x9e96, 0x9eba, 0x9edf, 0x9f04, 0x9f2b, 0x9f55,
	0x9f7d, 0x9fa6, 0x9fcf, 0x9fd8, 0x9fe2, 0x9feb, 0xa001, 0xa013,
	0xa025, 0xa037, 0xa049, 0xa05b, 0xa06e, 0xa081, 0xa094, 0xa0a7,
	0xa0ba, 0xa0cd, 0xa0e0, 0xa0f3, 0xa106, 0xa119, 0xa12c, 0xa13f,
	0xa152, 0xa165, 0xa178, 0xa18b, 0xa19e, 0xa1b1, 0xa1c4, 0xa1d7,
	0xa1ea, 0xa1fd, 0xa210, 0xa223, 0xa236, 0xa249, 0xa25c, 0xa26f,
	0xa282, 0xa295, 0xa2a8, 0xa2bb, 0xa2ce, 0xa2e1, 0xa2f4, 0xa307,
	0xa31a, 0xa32d, 0xa340, 0xa353, 0xa366, 0xa379, 0xa386, 0xa393,
	// Entry 2E00 - 2E3F
	0xa39f, 0xa3aa, 0xa3b7, 0xa3c2, 0xa3cc, 0xa3db, 0xa3e7, 0xa3f2,
	0xa3fd, 0xa409, 0xa417, 0xa425, 0xa431, 0xa43d, 0xa448, 0xa454,
	0xa461, 0xa46f, 0xa47a, 0xa48b, 0xa49d, 0xa4ad, 0xa4ba, 0xa4ca,
	0xa4da, 0xa4e8, 0xa4f4, 0xa501, 0xa50d, 0xa51b, 0xa52a, 0xa538,
	0xa544, 0xa550, 0xa55c, 0xa567, 0xa572, 0xa57c, 0xa587, 0xa593,
	0xa59f, 0xa5ae, 0xa5ba, 0xa5c8, 0xa5d8, 0xa5e5, 0xa5f0, 0xa5fb,
	0xa60a, 0xa617, 0xa626, 0xa632, 0xa642, 0xa64d, 0xa65a, 0xa667,
	0xa673, 0xa67f, 0xa68b, 0xa698, 0xa6a5, 0xa6af, 0xa6bb, 0xa6c7,
	// Entry 2E40 - 2E7F
	0xa6d2, 0xa6e0, 0xa6ec, 0xa6f8, 0xa705, 0xa713, 0xa721, 0xa72c,
	0xa73c, 0xa747, 0xa755, 0xa763, 0xa76f, 0xa77b, 0xa786, 0xa794,
	0xa79f, 0xa7ab, 0xa7b9, 0xa7c4, 0xa7d3, 0xa7df, 0xa809, 0xa832,
	0xa85b, 0xa886, 0xa8b0, 0xa8da, 0xa903, 0xa92e, 0xa959, 0xa983,
	0xa9ac, 0xa9d8, 0xaa04, 0xaa32, 0xaa60, 0xaa8d, 0xaaba, 0xaae9,
	0xab17, 0xab45, 0xab71, 0xaba1, 0xabd1, 0xac03, 0xac34, 0xac3e,
	0xac47, 0xac50, 0xac5a, 0xac63, 0xac6c, 0xac75, 0xac86, 0xac95,
	0xac9e, 0xacb4, 0xacca, 0xace1, 0xacf6, 0xad08, 0xad16, 0xad1f,
	// Entry 2E80 - 2EBF
	0xad2a, 0xad33, 0xad3c, 0xad45, 0xad4e, 0xad57, 0xad61, 0xad6c,
	0xad75, 0xad7e, 0xad89, 0xad94, 0xad9d, 0xada6, 0xadaf, 0xadb9,
	0xadc3, 0xadcd, 0xadd7, 0xade2, 0xadeb, 0xadf4, 0xadfd, 0xae06,
	0xae0f, 0xae1a, 0xae23, 0xae2c, 0xae35, 0xae46, 0xae57, 0xae67,
	0xae78, 0xae87, 0xae96, 0xaea4, 0xaeb3, 0xaec2, 0xaed9, 0xaee2,
	0xaeec, 0xaef6, 0xaf00, 0xaf0a, 0xaf1b, 0xaf34, 0xaf3d, 0xaf46,
	0xaf51, 0xaf5a, 0xaf63, 0xaf6c, 0xaf77, 0xaf80, 0xaf89, 0xaf97,
	0xafa0, 0xafa9, 0xafb4, 0xafbd, 0xafc6, 0xafd4, 0xafe0, 0xafec,
	// Entry 2EC0 - 2EFF
	0xaff5, 0xaffe, 0xb007, 0xb010, 0xb020, 0xb029, 0xb032, 0xb03b,
	0xb044, 0xb04d, 0xb056, 0xb05f, 0xb070, 0xb079, 0xb082, 0xb08b,
	0xb095, 0xb09e, 0xb0ad, 0xb0b7, 0xb0c1, 0xb0ca, 0xb0d3, 0xb0dd,
	0xb0e6, 0xb0ef, 0xb0f8, 0xb101, 0xb110, 0xb11f, 0xb147, 0xb16f,
	0xb199, 0xb1c2, 0xb1eb, 0xb213, 0xb23d, 0xb267, 0xb290, 0xb2b8,
	0xb2e3, 0xb30e, 0xb33b, 0xb368, 0xb394, 0xb3c0, 0xb3ee, 0xb41b,
	0xb448, 0xb473, 0xb4a2, 0xb4d1, 0xb502, 0xb532, 0xb562, 0xb591,
	0xb5c2, 0xb5f3, 0xb623, 0xb64e, 0xb67d, 0xb687, 0xb6a7, 0xb6c7,
	// Entry 2F00 - 2F3F
	0xb6ef, 0xb70a, 0xb71e, 0xb733, 0xb748, 0xb765, 0xb77e, 0xb793,
	0xb7a5, 0xb7bc, 0xb7d3, 0xb7f0, 0xb804, 0xb81b, 0xb831, 0xb851,
	0xb866, 0xb880, 0xb89b, 0xb8ad, 0xb8c9, 0xb8dc, 0xb8f2, 0xb90b,
	0xb925, 0xb945, 0xb963, 0xb981, 0xb997, 0xb9ac, 0xb9c0, 0xb9d8,
	0xb9ed, 0xba10, 0xba27, 0xba3e, 0xba56, 0xba6e, 0xba83, 0xba98,
	0xbab1, 0xbacc, 0xbaeb, 0xbb06, 0xbb1d, 0xbb32, 0xbb49, 0xbb62,
	0xbb83, 0xbbaa, 0xbbc2, 0xbbe2, 0xbbf8, 0xbc11, 0xbc2d, 0xbc49,
	0xbc60, 0xbc77, 0xbc8f, 0xbcaf, 0xbccc, 0xbcea, 0xbcf8, 0xbd06,
	// Entry 2F40 - 2F7F
	0xbd13, 0xbd21, 0xbd30, 0xbd3f, 0xbd4d, 0xbd5c, 0xbd6a, 0xbd78,
	0xbd85, 0xbd93, 0xbda2, 0xbdb0, 0xbdbf, 0xbdcd, 0xbddb, 0xbde8,
	0xbdf6, 0xbe04, 0xbe11, 0xbe1f, 0xbe2e, 0xbe3d, 0xbe4b, 0xbe5a,
	0xbe6a, 0xbe7a, 0xbe89, 0xbe99, 0xbea8, 0xbeb7, 0xbec5, 0xbed4,
	0xbee4, 0xbef3, 0xbf03, 0xbf12, 0xbf21, 0xbf2f, 0xbf3e, 0xbf4d,
	0xbf5b, 0xbf6a, 0xbf79, 0xbf88, 0xbf96, 0xbfa5, 0xbfb5, 0xbfc4,
	0xbfd3, 0xbfe2, 0xbff0, 0xbfff, 0xc00f, 0xc01e, 0xc02d, 0xc03c,
	0xc04a, 0xc059, 0xc069, 0xc078, 0xc088, 0xc097, 0xc0a6, 0xc0b4,
	// Entry 2F80 - 2FBF
	0xc0c3, 0xc0d3, 0xc0e2, 0xc0f2, 0xc101, 0xc110, 0xc11e, 0xc12d,
	0xc13c, 0xc14b, 0xc159, 0xc168, 0xc178, 0xc187, 0xc196, 0xc1a5,
	0xc1b3, 0xc1c2, 0xc1d2, 0xc1e1, 0xc1f1, 0xc201, 0xc210, 0xc220,
	0xc231, 0xc242, 0xc252, 0xc263, 0xc273, 0xc283, 0xc292, 0xc2a2,
	0xc2b3, 0xc2c3, 0xc2d4, 0xc2e4, 0xc2f4, 0xc303, 0xc313, 0xc323,
	0xc332, 0xc342, 0xc352, 0xc362, 0xc371, 0xc381, 0xc392, 0xc3a2,
	0xc3b2, 0xc3c2, 0xc3d1, 0xc3e1, 0xc3f1, 0xc401, 0xc410, 0xc420,
	0xc431, 0xc441, 0xc452, 0xc462, 0xc472, 0xc481, 0xc491, 0xc4a1,
	// Entry 2FC0 - 2FFF
	0xc4b1, 0xc4c0, 0xc4d0, 0xc4e0, 0xc4f0, 0xc4ff, 0xc50f, 0xc520,
	0xc530, 0xc540, 0xc550, 0xc55f, 0xc56f, 0xc580, 0xc590, 0xc5a0,
	0xc5b0, 0xc5bf, 0xc5cf, 0xc5e0, 0xc5f0, 0xc601, 0xc611, 0xc621,
	0xc630, 0xc640, 0xc651, 0xc661, 0xc672, 0xc682, 0xc692, 0xc6a1,
	0xc6b1, 0xc6c1, 0xc6d1, 0xc6e0, 0xc6f0, 0xc701, 0xc711, 0xc721,
	0xc730, 0xc740, 0xc751, 0xc761, 0xc770, 0xc77f, 0xc78d, 0xc79c,
	0xc7ac, 0xc7bb, 0xc7cb, 0xc7da, 0xc7e9, 0xc7f7, 0xc806, 0xc816,
	0xc826, 0xc835, 0xc845, 0xc854, 0xc863, 0xc871, 0xc880, 0xc88f,
	// Entry 3000 - 303F
	0xc89d, 0xc8ac, 0xc8bb, 0xc8c9, 0xc8d8, 0xc8e8, 0xc8f7, 0xc906,
	0xc915, 0xc923, 0xc932, 0xc941, 0xc950, 0xc95e, 0xc96d, 0xc97c,
	0xc98b, 0xc999, 0xc9a8, 0xc9b7, 0xc9c5, 0xc9d4, 0xc9e3, 0xc9f2,
	0xca00, 0xca0f, 0xca1f, 0xca2e, 0xca3d, 0xca4c, 0xca5a, 0xca69,
	0xca78, 0xca87, 0xca95, 0xcaa4, 0xcab4, 0xcac4, 0xcad3, 0xcae3,
	0xcaf2, 0xcb01, 0xcb0f, 0xcb1e, 0xcb2d, 0xcb3c, 0xcb4a, 0xcb59,
	0xcb68, 0xcb77, 0xcb86, 0xcb95, 0xcba3, 0xcbb2, 0xcbc2, 0xcbd1,
	0xcbe0, 0xcbef, 0xcbfd, 0xcc0c, 0xcc1c, 0xcc2b, 0xcc3a, 0xcc49,
	// Entry 3040 - 307F
	0xcc57, 0xcc66, 0xcc76, 0xcc85, 0xcc95, 0xcca4, 0xccb3, 0xccc1,
	0xccd0, 0xcce0, 0xccef, 0xccfe, 0xcd0d, 0xcd1b, 0xcd2a, 0xcd39,
	0xcd47, 0xcd56, 0xcd65, 0xcd74, 0xcd82, 0xcd91, 0xcda1, 0xcdb0,
	0xcdbf, 0xcdce, 0xcddc, 0xcdeb, 0xcdfb, 0xce0a, 0xce1a, 0xce29,
	0xce38, 0xce46, 0xce55, 0xce65, 0xce75, 0xce84, 0xce94, 0xcea3,
	0xceb2, 0xcec0, 0xcecf, 0xcede, 0xceec, 0xcefb, 0xcf0a, 0xcf19,
	0xcf27, 0xcf36, 0xcf46, 0xcf55, 0xcf65, 0xcf75, 0xcf84, 0xcf94,
	0xcfa5, 0xcfb5, 0xcfc6, 0xcfd6, 0xcfe6, 0xcff5, 0xd005, 0xd016,
	// Entry 3080 - 30BF
	0xd026, 0xd037, 0xd047, 0xd057, 0xd066, 0xd076, 0xd086, 0xd095,
	0xd0a5, 0xd0b5, 0xd0c5, 0xd0d4, 0xd0e4, 0xd0f5, 0xd105, 0xd115,
	0xd125, 0xd134, 0xd144, 0xd155, 0xd165, 0xd175, 0xd185, 0xd194,
	0xd1a4, 0xd1b4, 0xd1c4, 0xd1d3, 0xd1e3, 0xd1f3, 0xd202, 0xd212,
	0xd222, 0xd232, 0xd241, 0xd251, 0xd262, 0xd272, 0xd282, 0xd292,
	0xd2a1, 0xd2b1, 0xd2c2, 0xd2d3, 0xd2e3, 0xd2f4, 0xd304, 0xd314,
	0xd323, 0xd333, 0xd344, 0xd354, 0xd364, 0xd374, 0xd384, 0xd394,
	0xd3a3, 0xd3b3, 0xd3c3, 0xd3d2, 0xd3e1, 0xd3ef, 0xd3fe, 0xd40e,
	// Entry 30C0 - 30FF
	0xd41d, 0xd42d, 0xd43c, 0xd44a, 0xd459, 0xd469, 0xd478, 0xd488,
	0xd497, 0xd4a6, 0xd4b4, 0xd4c3, 0xd4d2, 0xd4e0, 0xd4ef, 0xd4fe,
	0xd50d, 0xd51b, 0xd52a, 0xd53a, 0xd549, 0xd559, 0xd569, 0xd578,
	0xd588, 0xd599, 0xd5a9, 0xd5ba, 0xd5ca, 0xd5da, 0xd5e9, 0xd5f9,
	0xd60a, 0xd61a, 0xd62b, 0xd63b, 0xd64a, 0xd65a, 0xd66a, 0xd679,
	0xd689, 0xd699, 0xd6a9, 0xd6b8, 0xd6c8, 0xd6d9, 0xd6e9, 0xd6f9,
	0xd709, 0xd718, 0xd728, 0xd739, 0xd749, 0xd758, 0xd767, 0xd775,
	0xd784, 0xd794, 0xd7a4, 0xd7b3, 0xd7c3, 0xd7d2, 0xd7e1, 0xd7ef,
	// Entry 3100 - 313F
	0xd7fe, 0xd80e, 0xd81e, 0xd82d, 0xd83d, 0xd84c, 0xd85b, 0xd869,
	0xd878, 0xd887, 0xd895, 0xd8a4, 0xd8b3, 0xd8c2, 0xd8d0, 0xd8df,
	0xd8ef, 0xd8fe, 0xd90d, 0xd91c, 0xd92a, 0xd939, 0xd949, 0xd958,
	0xd967, 0xd976, 0xd984, 0xd993, 0xd9a3, 0xd9b3, 0xd9c2, 0xd9d2,
	0xd9e1, 0xd9f0, 0xd9fe, 0xda0d, 0xda1d, 0xda2d, 0xda3c, 0xda4c,
	0xda5b, 0xda6a, 0xda78, 0xda87, 0xda96, 0xdaa5, 0xdab3, 0xdac2,
	0xdad1, 0xdae0, 0xdaee, 0xdafd, 0xdb0d, 0xdb1c, 0xdb2b, 0xdb3a,
	0xdb48, 0xdb57, 0xdb67, 0xdb76, 0xdb86, 0xdb95, 0xdba4, 0xdbb2,
	// Entry 3140 - 317F
	0xdbc1, 0xdbd1, 0xdbe0, 0xdbf0, 0xdbff, 0xdc0e, 0xdc1c, 0xdc2b,
	0xdc3a, 0xdc49, 0xdc57, 0xdc66, 0xdc75, 0xdc84, 0xdc92, 0xdca1,
	0xdcb1, 0xdcc0, 0xdcd0, 0xdce0, 0xdcef, 0xdd00, 0xdd10, 0xdd21,
	0xdd31, 0xdd41, 0xdd50, 0xdd60, 0xdd71, 0xdd82, 0xdd92, 0xdda3,
	0xddb3, 0xddc3, 0xddd2, 0xdde2, 0xddf2, 0xde02, 0xde11, 0xde21,
	0xde31, 0xde41, 0xde50, 0xde60, 0xde71, 0xde81, 0xde92, 0xdea2,
	0xdeb2, 0xdec2, 0xded1, 0xdee1, 0xdef2, 0xdf02, 0xdf13, 0xdf23,
	0xdf33, 0xdf42, 0xdf52, 0xdf62, 0xdf71, 0xdf81, 0xdf91, 0xdfa1,
	// Entry 3180 - 31BF
	0xdfb0, 0xdfc0, 0xdfd1, 0xdfe1, 0xdff1, 0xe001, 0xe010, 0xe020,
	0xe031, 0xe042, 0xe052, 0xe063, 0xe073, 0xe083, 0xe092, 0xe0a2,
	0xe0b3, 0xe0c4, 0xe0d4, 0xe0e5, 0xe0f5, 0xe105, 0xe114, 0xe124,
	0xe134, 0xe143, 0xe153, 0xe164, 0xe174, 0xe185, 0xe195, 0xe1a5,
	0xe1b4, 0xe1c4, 0xe1d5, 0xe1e6, 0xe1f6, 0xe206, 0xe216, 0xe225,
	0xe235, 0xe245, 0xe254, 0xe264, 0xe273, 0xe283, 0xe292, 0xe2a1,
	0xe2b0, 0xe2be, 0xe2cd, 0xe2dd, 0xe2ed, 0xe2fc, 0xe30c, 0xe31b,
	0xe32a, 0xe338, 0xe347, 0xe356, 0xe364, 0xe373, 0xe382, 0xe391,
	// Entry 31C0 - 31FF
	0xe39f, 0xe3ae, 0xe3be, 0xe3cd, 0xe3dd, 0xe3ec, 0xe3fa, 0xe409,
	0xe418, 0xe426, 0xe435, 0xe444, 0xe453, 0xe461, 0xe470, 0xe480,
	0xe48f, 0xe49f, 0xe4ae, 0xe4bd, 0xe4cb, 0xe4da, 0xe4ea, 0xe4f9,
	0xe509, 0xe518, 0xe527, 0xe535, 0xe544, 0xe553, 0xe561, 0xe570,
	0xe57f, 0xe58e, 0xe59c, 0xe5ab, 0xe5bb, 0xe5ca, 0xe5d9, 0xe5e8,
	0xe5f6, 0xe605, 0xe615, 0xe624, 0xe633, 0xe642, 0xe650, 0xe65f,
	0xe66f, 0xe67f, 0xe68e, 0xe69e, 0xe6ad, 0xe6bc, 0xe6ca, 0xe6d9,
	0xe6e9, 0xe6f8, 0xe708, 0xe717, 0xe726, 0xe734, 0xe743, 0xe752,
	// Entry 3200 - 323F
	0xe760, 0xe76f, 0xe77e, 0xe78d, 0xe79b, 0xe7aa, 0xe7ba, 0xe7c9,
	0xe7d8, 0xe7e7, 0xe7f5, 0xe804, 0xe814, 0xe823, 0xe833, 0xe843,
	0xe852, 0xe862, 0xe873, 0xe884, 0xe894, 0xe8a5, 0xe8b5, 0xe8c5,
	0xe8d4, 0xe8e4, 0xe8f4, 0xe903, 0xe913, 0xe923, 0xe932, 0xe942,
	0xe952, 0xe961, 0xe971, 0xe982, 0xe992, 0xe9a2, 0xe9b2, 0xe9c1,
	0xe9d1, 0xe9e2, 0xe9f2, 0xea02, 0xea12, 0xea21, 0xea31, 0xea42,
	0xea52, 0xea63, 0xea73, 0xea83, 0xea92, 0xeaa2, 0xeab3, 0xeac3,
	0xead3, 0xeae3, 0xeaf3, 0xeb02, 0xeb12, 0xeb21, 0xeb31, 0xeb42,
	// Entry 3240 - 327F
	0xeb52, 0xeb62, 0xeb72, 0xeb81, 0xeb91, 0xeba2, 0xebb2, 0xebc1,
	0xebd0, 0xebde, 0xebed, 0xebfd, 0xec0c, 0xec1c, 0xec2b, 0xec3a,
	0xec48, 0xec57, 0xec67, 0xec76, 0xec86, 0xec95, 0xeca4, 0xecb2,
	0xecc1, 0xecd0, 0xecde, 0xeced, 0xecfc, 0xed0b, 0xed19, 0xed28,
	0xed38, 0xed47, 0xed56, 0xed65, 0xed73, 0xed82, 0xed92, 0xeda1,
	0xedb1, 0xedc1, 0xedd0, 0xede0, 0xedf1, 0xee01, 0xee12, 0xee22,
	0xee32, 0xee41, 0xee51, 0xee61, 0xee71, 0xee80, 0xee90, 0xeea0,
	0xeeaf, 0xeebf, 0xeecf, 0xeedf, 0xeeee, 0xeefe, 0xef0e, 0xef1e,
	// Entry 3280 - 32BF
	0xef2d, 0xef3d, 0xef4e, 0xef5e, 0xef6e, 0xef7e, 0xef8d, 0xef9d,
	0xefae, 0xefbe, 0xefcf, 0xefdf, 0xefef, 0xeffe, 0xf00e, 0xf01e,
	0xf02e, 0xf03d, 0xf04d, 0xf05d, 0xf06d, 0xf07c, 0xf08c, 0xf09d,
	0xf0ad, 0xf0bd, 0xf0cd, 0xf0dc, 0xf0ec, 0xf0fd, 0xf10d, 0xf11d,
	0xf12d, 0xf13c, 0xf14c, 0xf15d, 0xf16e, 0xf17e, 0xf18f, 0xf19f,
	0xf1af, 0xf1be, 0xf1ce, 0xf1de, 0xf1ee, 0xf1fd, 0xf20d, 0xf21d,
	0xf22c, 0xf23c, 0xf24d, 0xf25d, 0xf26d, 0xf27d, 0xf28c, 0xf29c,
	0xf2ad, 0xf2bd, 0xf2cd, 0xf2dc, 0xf2ed, 0xf2fd, 0xf30d, 0xf31d,
	// Entry 32C0 - 32FF
	0xf32c, 0xf33c, 0xf34c, 0xf35c, 0xf36b, 0xf37b, 0xf38b, 0xf39b,
	0xf3aa, 0xf3ba, 0xf3cb, 0xf3db, 0xf3eb, 0xf3fb, 0xf40a, 0xf41a,
	0xf42b, 0xf43b, 0xf44b, 0xf45b, 0xf46a, 0xf47a, 0xf48a, 0xf499,
	0xf4a9, 0xf4b9, 0xf4c9, 0xf4d8, 0xf4e8, 0xf4f8, 0xf508, 0xf517,
	0xf527, 0xf538, 0xf548, 0xf558, 0xf568, 0xf577, 0xf587, 0xf598,
	0xf5a8, 0xf5b8, 0xf5c8, 0xf5d7, 0xf5e7, 0xf5f8, 0xf608, 0xf619,
	0xf629, 0xf639, 0xf648, 0xf658, 0xf668, 0xf678, 0xf687, 0xf697,
	0xf6a7, 0xf6b7, 0xf6c6, 0xf6d6, 0xf6e7, 0xf6f7, 0xf707, 0xf717,
	// Entry 3300 - 333F
	0xf726, 0xf736, 0xf747, 0xf757, 0xf766, 0xf775, 0xf783, 0xf792,
	0xf7a2, 0xf7b1, 0xf7c1, 0xf7d0, 0xf7df, 0xf7ed, 0xf7fc, 0xf80b,
	0xf819, 0xf828, 0xf837, 0xf846, 0xf854, 0xf863, 0xf873, 0xf882,
	0xf891, 0xf8a0, 0xf8ae, 0xf8bd, 0xf8cd, 0xf8dc, 0xf8eb, 0xf8fa,
	0xf908, 0xf917, 0xf927, 0xf937, 0xf946, 0xf956, 0xf966, 0xf976,
	0xf985, 0xf995, 0xf9a4, 0xf9b3, 0xf9c1, 0xf9d0, 0xf9df, 0xf9ee,
	0xf9fc, 0xfa0b, 0xfa1b, 0xfa2a, 0xfa39, 0xfa48, 0xfa56, 0xfa65,
	0xfa75, 0xfa84, 0xfa93, 0xfaa2, 0xfab0, 0xfabf, 0xfacf, 0xfadf,
	// Entry 3340 - 337F
	0xfaee, 0xfafe, 0xfb0e, 0xfb1e, 0xfb2d, 0xfb3d, 0xfb4c, 0xfb5b,
	0xfb69, 0xfb78, 0xfb87, 0xfb96, 0xfba4, 0xfbb3, 0xfbc3, 0xfbd2,
	0xfbe1, 0xfbf0, 0xfbfe, 0xfc0d, 0xfc1d, 0xfc2c, 0xfc3c, 0xfc4c,
	0xfc5b, 0xfc6b, 0xfc7c, 0xfc8d, 0xfc9d, 0xfcae, 0xfcbf, 0xfccf,
	0xfce0, 0xfcf0, 0xfd00, 0xfd0f, 0xfd1f, 0xfd2f, 0xfd3f, 0xfd4e,
	0xfd5e, 0xfd6f, 0xfd7f, 0xfd8f, 0xfd9f, 0xfdae, 0xfdbe, 0xfdce,
	0xfdde, 0xfded, 0xfdfd, 0xfe0e, 0xfe1f, 0xfe2f, 0xfe40, 0xfe51,
	0xfe61, 0xfe71, 0xfe81, 0xfe90, 0xfea0, 0xfeb0, 0xfebf, 0xfecf,
	// Entry 3380 - 33BF
	0xfee0, 0xfef0, 0xff00, 0xff10, 0xff1f, 0xff2f, 0xff40, 0xff50,
	0xff60, 0xff70, 0xff7f, 0xff8f, 0xffa0, 0xffb1, 0xffc1, 0xffd2,
	0xffe3, 0xfff3, 0x0004, 0x0014, 0x0024, 0x0033, 0x0043, 0x0053,
	0x0063, 0x0072, 0x0082, 0x0091, 0x00a0, 0x00ae, 0x00bd, 0x00cd,
	0x00dd, 0x00ec, 0x00fc, 0x010c, 0x011b, 0x012a, 0x0139, 0x0147,
	0x0156, 0x0165, 0x0174, 0x0182, 0x0191, 0x01a1, 0x01b0, 0x01bf,
	0x01ce, 0x01dc, 0x01eb, 0x01fb, 0x020b, 0x021a, 0x022a, 0x023a,
	0x024a, 0x0259, 0x0269, 0x0278, 0x0287, 0x0295, 0x02a4, 0x02b3,
	// Entry 33C0 - 33FF
	0x02c2, 0x02d0, 0x02df, 0x02ef, 0x02fe, 0x030d, 0x031c, 0x032a,
	0x0339, 0x0349, 0x0358, 0x0366, 0x0373, 0x0381, 0x0390, 0x039e,
	0x03ac, 0x03bb, 0x03c9, 0x03d6, 0x03e5, 0x03f3, 0x0402, 0x0410,
	0x041d, 0x042b, 0x043a, 0x0448, 0x0455, 0x0463, 0x0471, 0x0480,
	0x048e, 0x049d, 0x04ac, 0x04b9, 0x04c6, 0x04d5, 0x04e3, 0x04f1,
	0x04ff, 0x050d, 0x051b, 0x0529, 0x0537, 0x0544, 0x0551, 0x0560,
	0x056e, 0x057c, 0x058b, 0x0598, 0x05a5, 0x05b4, 0x05c2, 0x05cf,
	0x05de, 0x05ec, 0x05fb, 0x060a, 0x0618, 0x0627, 0x0635, 0x0645,
	// Entry 3400 - 343F
	0x0654, 0x0661, 0x066f, 0x067d, 0x068c, 0x069a, 0x06a8, 0x06b7,
	0x06c5, 0x06d3, 0x06e2, 0x06f0, 0x06fe, 0x070d, 0x071c, 0x072b,
	0x073b, 0x0749, 0x0757, 0x0765, 0x0773, 0x0782, 0x0790, 0x079f,
	0x07ad, 0x07bb, 0x07ca, 0x07d8, 0x07e6, 0x07f5, 0x0803, 0x0812,
	0x081f, 0x082d, 0x083a, 0x0848, 0x0855, 0x0862, 0x086f, 0x087d,
	0x088b, 0x0899, 0x08b0, 0x08c6, 0x08de, 0x08f5, 0x090c, 0x0924,
	0x093a, 0x0954, 0x0963, 0x0973, 0x0983, 0x0993, 0x09a4, 0x09b4,
	0x09c5, 0x09d5, 0x09e6, 0x09f7, 0x0a09, 0x0a1a, 0x0a2a, 0x0a3a,
	// Entry 3440 - 347F
	0x0a4a, 0x0a5b, 0x0a6c, 0x0a7e, 0x0a8e, 0x0a9e, 0x0aae, 0x0abf,
	0x0acf, 0x0ae0, 0x0af0, 0x0b01, 0x0b11, 0x0b21, 0x0b32, 0x0b42,
	0x0b52, 0x0b64, 0x0b74, 0x0b84, 0x0b94, 0x0ba5, 0x0bb3, 0x0bc2,
	0x0bd1, 0x0be1, 0x0bf0, 0x0c00, 0x0c0f, 0x0c1f, 0x0c2e, 0x0c3e,
	0x0c4e, 0x0c5f, 0x0c6f, 0x0c7e, 0x0c8d, 0x0c9c, 0x0cac, 0x0cbc,
	0x0ccd, 0x0cdc, 0x0ceb, 0x0cfa, 0x0d0a, 0x0d19, 0x0d29, 0x0d38,
	0x0d48, 0x0d57, 0x0d66, 0x0d76, 0x0d85, 0x0d94, 0x0da5, 0x0db4,
	0x0dc3, 0x0dd2, 0x0de2, 0x0df0, 0x0dff, 0x0e10, 0x0e1f, 0x0e2f,
	// Entry 3480 - 34BF
	0x0e3e, 0x0e4e, 0x0e5d, 0x0e6d, 0x0e7c, 0x0e8c, 0x0e9c, 0x0ead,
	0x0ebe, 0x0ece, 0x0edd, 0x0eec, 0x0efb, 0x0f0b, 0x0f1b, 0x0f2c,
	0x0f3b, 0x0f4a, 0x0f59, 0x0f69, 0x0f78, 0x0f88, 0x0f97, 0x0fa7,
	0x0fb6, 0x0fc5, 0x0fd5, 0x0fe4, 0x0ff3, 0x1003, 0x1014, 0x1023,
	0x1032, 0x1041, 0x1051, 0x1060, 0x1070, 0x1080, 0x1090, 0x10a1,
	0x10b1, 0x10c2, 0x10d2, 0x10e3, 0x10f4, 0x1106, 0x1117, 0x1127,
	0x1137, 0x1147, 0x1158, 0x1169, 0x117b, 0x118b, 0x119b, 0x11ab,
	0x11bc, 0x11cc, 0x11dd, 0x11ed, 0x11fe, 0x120e, 0x121e, 0x122f,
	// Entry 34C0 - 34FF
	0x123f, 0x124f, 0x1261, 0x1271, 0x1281, 0x1291, 0x12a2, 0x12b0,
	0x12bf, 0x12ce, 0x12de, 0x12ed, 0x12fd, 0x130c, 0x131c, 0x132b,
	0x133b, 0x134b, 0x135c, 0x136c, 0x137b, 0x138a, 0x1399, 0x13a9,
	0x13b9, 0x13ca, 0x13d9, 0x13e8, 0x13f7, 0x1407, 0x1416, 0x1426,
	0x1435, 0x1445, 0x1454, 0x1463, 0x1473, 0x1482, 0x1491, 0x14a2,
	0x14b1, 0x14c0, 0x14cf, 0x14df, 0x14ed, 0x14fc, 0x150d, 0x151c,
	0x152c, 0x153b, 0x154b, 0x155a, 0x156a, 0x1579, 0x1589, 0x1599,
	0x15aa, 0x15ba, 0x15cb, 0x15da, 0x15e9, 0x15f8, 0x1608, 0x1618,
	// Entry 3500 - 353F
	0x1629, 0x1638, 0x1647, 0x1656, 0x1666, 0x1675, 0x1685, 0x1694,
	0x16a4, 0x16b3, 0x16c2, 0x16d2, 0x16e1, 0x16f0, 0x1701, 0x1710,
	0x171f, 0x172e, 0x173e, 0x174c, 0x175b, 0x176c, 0x177b, 0x178b,
	0x179a, 0x17aa, 0x17b9, 0x17c9, 0x17d8, 0x17e8, 0x17f8, 0x1809,
	0x181a, 0x182a, 0x183b, 0x184a, 0x1859, 0x1868, 0x1878, 0x1888,
	0x1899, 0x18a8, 0x18b7, 0x18c6, 0x18d6, 0x18e5, 0x18f5, 0x1904,
	0x1914, 0x1923, 0x1932, 0x1942, 0x1951, 0x1960, 0x1971, 0x1983,
	0x1992, 0x19a2, 0x19b1, 0x19c0, 0x19d0, 0x19df, 0x19f6, 0x19ff,
	// Entry 3540 - 357F
	0x1a0c, 0x1a1d, 0x1a32, 0x1a47, 0x1a5d, 0x1a6d, 0x1a7d, 0x1a8c,
	0x1a9a, 0x1aa9, 0x1ab7, 0x1ac5, 0x1ad4, 0x1ae4, 0x1af3, 0x1b02,
	0x1b11, 0x1b20, 0x1b2e, 0x1b3b, 0x1b48, 0x1b57, 0x1b65, 0x1b73,
	0x1b80, 0x1b8f, 0x1b9e, 0x1bac, 0x1bc1, 0x1bd6, 0x1bf4, 0x1c10,
	0x1c2d, 0x1c48, 0x1c6c, 0x1c8e, 0x1caa, 0x1cc4, 0x1ce1, 0x1cfc,
	0x1d20, 0x1d42, 0x1d65, 0x1d86, 0x1da9, 0x1dca, 0x1df4, 0x1e1c,
	0x1e40, 0x1e62, 0x1e85, 0x1ea6, 0x1ec8, 0x1ee8, 0x1f11, 0x1f38,
	0x1f5b, 0x1f7c, 0x1fae, 0x1fde, 0x1ff8, 0x2010, 0x2034, 0x2056,
	// Entry 3580 - 35BF
	0x2075, 0x2092, 0x20b1, 0x20ce, 0x20ed, 0x210a, 0x212d, 0x214e,
	0x2171, 0x2192, 0x21bc, 0x21e4, 0x2201, 0x2219, 0x223d, 0x2265,
	0x228e, 0x229f, 0x22c5, 0x22e0, 0x22fc, 0x2317, 0x233a, 0x2358,
	0x237b, 0x239a, 0x23b3, 0x23cd, 0x23dc, 0x23ec, 0x2407, 0x2420,
	0x243c, 0x2456, 0x2472, 0x248c, 0x24a8, 0x24c2, 0x24de, 0x24f8,
	0x2523, 0x254c, 0x2567, 0x2580, 0x259c, 0x25b6, 0x25d2, 0x25ec,
	0x2608, 0x2622, 0x263d, 0x2656, 0x2672, 0x268c, 0x26ac, 0x26ca,
	0x26eb, 0x270a, 0x272c, 0x274e, 0x276a, 0x278e, 0x279c, 0x27ab,
	// Entry 35C0 - 35FF
	0x27b9, 0x27c8, 0x27d7, 0x27e7, 0x27f7, 0x2805, 0x2815, 0x2823,
	0x2832, 0x2841, 0x2851, 0x2862, 0x2874, 0x2886, 0x2896, 0x28a7,
	0x28b9, 0x28c7, 0x28d7, 0x28e6, 0x28f7, 0x2906, 0x2918, 0x2929,
	0x293a, 0x294a, 0x295b, 0x296a, 0x297c, 0x298c, 0x299c, 0x29ac,
	0x29bb, 0x29cc, 0x29dd, 0x29ee, 0x29ff, 0x2a10, 0x2a20, 0x2a30,
	0x2a40, 0x2a50, 0x2a5f, 0x2a6e, 0x2a7d, 0x2a8c, 0x2a9d, 0x2aad,
	0x2abd, 0x2ad1, 0x2ae2, 0x2af2, 0x2b02, 0x2b13, 0x2b22, 0x2b32,
	0x2b41, 0x2b50, 0x2b5f, 0x2b6e, 0x2b7e, 0x2b8d, 0x2b9e, 0x2bae,
	// Entry 3600 - 363F
	0x2bbe, 0x2bcd, 0x2bdc, 0x2beb, 0x2bfa, 0x2c0b, 0x2c1b, 0x2c2b,
	0x2c3b, 0x2c4c, 0x2c5e, 0x2c71, 0x2c83, 0x2c96, 0x2cb2, 0x2cd0,
	0x2cdd, 0x2cec, 0x2cf7, 0x2d02, 0x2d11, 0x2d24, 0x2d49, 0x2d6f,
	0x2d95, 0x2dbc, 0x2ddf, 0x2e03, 0x2e26, 0x2e4a, 0x2e74, 0x2e98,
	0x2ebb, 0x2ede, 0x2f07, 0x2f3b, 0x2f69, 0x2f96, 0x2fc3, 0x2ff6,
	0x3023, 0x304a, 0x3070, 0x3096, 0x30c2, 0x30e2, 0x30fb, 0x311d,
	0x3145, 0x3164, 0x3185, 0x31ac, 0x31dc, 0x3209, 0x322d, 0x3250,
	0x3277, 0x329c, 0x32c2, 0x32e6, 0x32ff, 0x3316, 0x332d, 0x3342,
	// Entry 3640 - 367F
	0x335f, 0x337a, 0x3398, 0x33b4, 0x33dd, 0x3404, 0x3420, 0x343c,
	0x3453, 0x3468, 0x347f, 0x3494, 0x34ab, 0x34c0, 0x34d7, 0x34ec,
	0x3517, 0x3540, 0x3557, 0x356c, 0x3594, 0x35ba, 0x35dc, 0x35fc,
	0x3627, 0x3650, 0x3686, 0x36ba, 0x36d7, 0x36f2, 0x3719, 0x373e,
	0x376d, 0x379a, 0x37ba, 0x37d8, 0x37ef, 0x3804, 0x3838, 0x386a,
	0x388e, 0x38b0, 0x38d9, 0x3900, 0x3934, 0x3966, 0x3991, 0x39ba,
	0x39d8, 0x39f4, 0x3a14, 0x3a32, 0x3a5d, 0x3a86, 0x3a9d, 0x3ab2,
	0x3ad3, 0x3af2, 0x3b18, 0x3b3c, 0x3b74, 0x3baa, 0x3bc3, 0x3bda,
	// Entry 3680 - 36BF
	0x3bf1, 0x3c06, 0x3c1d, 0x3c32, 0x3c4a, 0x3c60, 0x3c72, 0x3c88,
	0x3c9e, 0x3cb4, 0x3cca, 0x3ce0, 0x3cfe, 0x3d14, 0x3d29, 0x3d47,
	0x3d63, 0x3d81, 0x3d9d, 0x3dbb, 0x3de0, 0x3e03, 0x3e20, 0x3e3b,
	0x3e59, 0x3e75, 0x3e93, 0x3eaf, 0x3ecd, 0x3ee9, 0x3f0e, 0x3f23,
	0x3f44, 0x3f61, 0x3f7c, 0x3f99, 0x3fca, 0x3fe6, 0x400b, 0x402e,
	0x404d, 0x406a, 0x4090, 0x40b6, 0x40da, 0x40fc, 0x411e, 0x413e,
	0x415d, 0x417a, 0x4199, 0x41b6, 0x41d5, 0x41f2, 0x421c, 0x4244,
	0x426e, 0x4296, 0x42c0, 0x42e8, 0x4312, 0x433a, 0x4364, 0x438c,
	// Entry 36C0 - 36FF
	0x43ac, 0x43d0, 0x43ed, 0x440d, 0x4431, 0x444d, 0x446a, 0x4487,
	0x44af, 0x44c7, 0x44e0, 0x44f7, 0x4511, 0x4529, 0x454b, 0x456b,
	0x458d, 0x45b2, 0x45d3, 0x45f6, 0x4618, 0x463a, 0x465c, 0x467b,
	0x469c, 0x46b1, 0x46c6, 0x46e0, 0x46f5, 0x470a, 0x471f, 0x4738,
	0x474e, 0x4765, 0x477b, 0x4792, 0x47ac, 0x47c2, 0x47d9, 0x47ef,
	0x4806, 0x481d, 0x4835, 0x484c, 0x4864, 0x487a, 0x4891, 0x48a7,
	0x48be, 0x48d4, 0x48ea, 0x4901, 0x4917, 0x492e, 0x4944, 0x495a,
	0x4970, 0x4987, 0x499d, 0x49b3, 0x49cc, 0x49e5, 0x49fe, 0x4a17,
	// Entry 3700 - 373F
	0x4a31, 0x4a4b, 0x4a65, 0x4a7f, 0x4a99, 0x4ab9, 0x4ad6, 0x4af9,
	0x4b1b, 0x4b3a, 0x4b5f, 0x4b77, 0x4b93, 0x4ba9, 0x4bc2, 0x4bd4,
	0x4be7, 0x4bf9, 0x4c0c, 0x4c1e, 0x4c31, 0x4c43, 0x4c56, 0x4c68,
	0x4c7b, 0x4c8d, 0x4c9f, 0x4cb1, 0x4cc4, 0x4cd6, 0x4ce8, 0x4cfb,
	0x4d0f, 0x4d22, 0x4d34, 0x4d47, 0x4d59, 0x4d70, 0x4d82, 0x4d94,
	0x4da6, 0x4db9, 0x4dcb, 0x4ddd, 0x4dee, 0x4dff, 0x4e10, 0x4e21,
	0x4e32, 0x4e44, 0x4e56, 0x4e68, 0x4e7b, 0x4e8d, 0x4ea9, 0x4ec5,
	0x4ed8, 0x4eec, 0x4eff, 0x4f12, 0x4f2e, 0x4f4b, 0x4f64, 0x4f80,
	// Entry 3740 - 377F
	0x4f9c, 0x4fb9, 0x4fd4, 0x4fed, 0x5006, 0x5018, 0x5031, 0x5049,
	0x5060, 0x5073, 0x5087, 0x509a, 0x50ae, 0x50c1, 0x50d5, 0x50f0,
	0x510c, 0x5127, 0x5143, 0x5156, 0x516a, 0x517e, 0x5191, 0x51a5,
	0x51b9, 0x51cd, 0x51e2, 0x51f6, 0x520b, 0x5220, 0x5234, 0x5249,
	0x525d, 0x5272, 0x5287, 0x529c, 0x52b2, 0x52c7, 0x52dd, 0x52f2,
	0x5306, 0x531b, 0x532f, 0x5344, 0x5358, 0x536c, 0x5381, 0x5395,
	0x53aa, 0x53be, 0x53d2, 0x53e6, 0x53fa, 0x540e, 0x5423, 0x5438,
	0x544c, 0x5460, 0x5475, 0x5494, 0x54ac, 0x54c3, 0x54db, 0x54f2,
	// Entry 3780 - 37BF
	0x550a, 0x5529, 0x5549, 0x5568, 0x5588, 0x559f, 0x55b7, 0x55cf,
	0x55e6, 0x55fe, 0x5616, 0x562c, 0x5647, 0x5657, 0x566e, 0x5683,
	0x5697, 0x56ab, 0x56c1, 0x56d6, 0x56eb, 0x56ff, 0x5715, 0x572b,
	0x5740, 0x575f, 0x577d, 0x579b, 0x57bb, 0x57da, 0x57f9, 0x5817,
	0x5837, 0x5857, 0x5876, 0x5893, 0x58b0, 0x58ce, 0x58ec, 0x590a,
	0x5928, 0x5946, 0x5968, 0x598b, 0x59ad, 0x59d6, 0x59f5, 0x5a16,
	0x5a3a, 0x5a52, 0x5a67, 0x5a77, 0x5a8c, 0x5aa3, 0x5ab5, 0x5ac9,
	0x5ae1, 0x5af4, 0x5b06, 0x5b18, 0x5b2c, 0x5b3f, 0x5b52, 0x5b64,
	// Entry 37C0 - 37FF
	0x5b78, 0x5b8c, 0x5b9f, 0x5bb1, 0x5bc4, 0x5bd6, 0x5be9, 0x5bfb,
	0x5c0e, 0x5c20, 0x5c33, 0x5c45, 0x5c58, 0x5c6a, 0x5c7c, 0x5c8f,
	0x5ca1, 0x5cb3, 0x5cc5, 0x5cd7, 0x5ce9, 0x5cfb, 0x5d0d, 0x5d20,
	0x5d32, 0x5d44, 0x5d56, 0x5d67, 0x5d79, 0x5d8a, 0x5d9c, 0x5dad,
	0x5dbd, 0x5dcd, 0x5dde, 0x5dee, 0x5e02, 0x5e15, 0x5e2f, 0x5e40,
	0x5e52, 0x5e62, 0x5e72, 0x5e83, 0x5e93, 0x5ea3, 0x5eb3, 0x5ec3,
	0x5ed3, 0x5ee3, 0x5ef3, 0x5f03, 0x5f14, 0x5f24, 0x5f34, 0x5f44,
	0x5f54, 0x5f64, 0x5f74, 0x5f85, 0x5f97, 0x5fa8, 0x5fba, 0x5fc9,
	// Entry 3800 - 383F
	0x5fdc, 0x5fef, 0x6002, 0x6016, 0x6029, 0x603d, 0x6051, 0x6065,
	0x607d, 0x6094, 0x60ab, 0x60c2, 0x60cf, 0x60e2, 0x60fe, 0x611a,
	0x6135, 0x6151, 0x616d, 0x618e, 0x61aa, 0x61cb, 0x61e6, 0x6201,
	0x6221, 0x6244, 0x625e, 0x6279, 0x6296, 0x62b2, 0x62ce, 0x62e8,
	0x630a, 0x6327, 0x6342, 0x6361, 0x637c, 0x6397, 0x63b7, 0x63d3,
	0x63f0, 0x640a, 0x642a, 0x6441, 0x6454, 0x6467, 0x647c, 0x648d,
	0x64a3, 0x64b4, 0x64c6, 0x64d7, 0x64ef, 0x6508, 0x6529, 0x653a,
	0x654c, 0x655d, 0x656f, 0x6587, 0x659f, 0x65b1, 0x65c9, 0x65dc,
	// Entry 3840 - 387F
	0x65ee, 0x6606, 0x6618, 0x6631, 0x664d, 0x6660, 0x6673, 0x6690,
	0x66a3, 0x66c0, 0x66d8, 0x66ea, 0x6702, 0x6714, 0x6730, 0x6742,
	0x6754, 0x676c, 0x677e, 0x6796, 0x67a8, 0x67ba, 0x67cc, 0x67e4,
	0x67f6, 0x6808, 0x6820, 0x683c, 0x684e, 0x6860, 0x6878, 0x6892,
	0x68ac, 0x68c4, 0x68e2, 0x68fa, 0x6919, 0x6933, 0x6951, 0x696a,
	0x6987, 0x69a6, 0x69c3, 0x69d3, 0x69ea, 0x6a02, 0x6a15, 0x6a28,
	0x6a3b, 0x6a4e, 0x6a63, 0x6a77, 0x6a8b, 0x6a9d, 0x6ab4, 0x6ac9,
	0x6ae5, 0x6af9, 0x6b0c, 0x6b1e, 0x6b30, 0x6b44, 0x6b57, 0x6b6a,
	// Entry 3880 - 38BF
	0x6b7c, 0x6b90, 0x6ba4, 0x6bb7, 0x6bd2, 0x6be9, 0x6c00, 0x6c17,
	0x6c2e, 0x6c45, 0x6c5c, 0x6c71, 0x6c9b, 0x6cb7, 0x6cd2, 0x6ced,
	0x6d09, 0x6d24, 0x6d40, 0x6d5c, 0x6d79, 0x6d95, 0x6db1, 0x6dcc,
	0x6de7, 0x6e04, 0x6e20, 0x6e3c, 0x6e57, 0x6e74, 0x6e91, 0x6ead,
	0x6ec9, 0x6ee4, 0x6f00, 0x6f1b, 0x6f37, 0x6f44, 0x6f51, 0x6f5e,
	0x6f6b, 0x6f79, 0x6f86, 0x6f94, 0x6fa3, 0x6fb1, 0x6fc0, 0x6fd0,
	0x6fdf, 0x6fee, 0x6ffe, 0x700c, 0x701b, 0x702b, 0x703a, 0x704a,
	0x7058, 0x7067, 0x7075, 0x7084, 0x7093, 0x70a1, 0x70b0, 0x70be,
	// Entry 38C0 - 38FF
	0x70cd, 0x70dc, 0x70ea, 0x70f9, 0x7108, 0x7116, 0x7125, 0x7133,
	0x7141, 0x714f, 0x715d, 0x716c, 0x717a, 0x7188, 0x719a, 0x71ab,
	0x71bd, 0x71cf, 0x71e0, 0x71f2, 0x7203, 0x7215, 0x7227, 0x7239,
	0x724f, 0x7265, 0x727b, 0x7291, 0x72a4, 0x72b7, 0x72cb, 0x72e7,
	0x72fb, 0x730e, 0x7321, 0x7334, 0x7347, 0x735a, 0x736d, 0x7381,
	0x739c, 0x73b7, 0x73c6, 0x73d4, 0x73e2, 0x73f2, 0x7401, 0x7410,
	0x741e, 0x742e, 0x743e, 0x744d, 0x7464, 0x747a, 0x7497, 0x74b4,
	0x74cc, 0x74e4, 0x74fd, 0x7515, 0x752e, 0x7547, 0x7560, 0x757a,
	// Entry 3900 - 393F
	0x7593, 0x75ad, 0x75c6, 0x75de, 0x75f6, 0x760e, 0x7627, 0x763f,
	0x766b, 0x7683, 0x769b, 0x76b3, 0x76ce, 0x76e8, 0x7702, 0x7722,
	0x773a, 0x7752, 0x7769, 0x7784, 0x77a1, 0x77be, 0x77dd, 0x77fc,
	0x7812, 0x7829, 0x7840, 0x7858, 0x7870, 0x7889, 0x789f, 0x78b6,
	0x78cd, 0x78e5, 0x78fb, 0x7912, 0x7929, 0x7941, 0x7957, 0x796e,
	0x7985, 0x799d, 0x79b3, 0x79ca, 0x79e0, 0x79f7, 0x7a0e, 0x7a26,
	0x7a3c, 0x7a53, 0x7a69, 0x7a80, 0x7a96, 0x7aad, 0x7ac4, 0x7adc,
	0x7af2, 0x7b09, 0x7b1f, 0x7b36, 0x7b4c, 0x7b63, 0x7b79, 0x7b90,
	// Entry 3940 - 397F
	0x7ba6, 0x7bbd, 0x7bd3, 0x7bea, 0x7c00, 0x7c17, 0x7c2c, 0x7c42,
	0x7c53, 0x7c64, 0x7c74, 0x7c85, 0x7c95, 0x7ca5, 0x7cb5, 0x7cc6,
	0x7cd7, 0x7ce9, 0x7cfa, 0x7d0c, 0x7d1d, 0x7d2e, 0x7d3f, 0x7d53,
	0x7d6a, 0x7d7f, 0x7d95, 0x7da8, 0x7dbd, 0x7dd0, 0x7de6, 0x7dfd,
	0x7e12, 0x7e27, 0x7e3e, 0x7e55, 0x7e6c, 0x7e84, 0x7e9b, 0x7eb3,
	0x7eca, 0x7ee1, 0x7ef8, 0x7f12, 0x7f2c, 0x7f47, 0x7f61, 0x7f7c,
	0x7f91, 0x7faa, 0x7fbb, 0x7fe0, 0x8001, 0x8020, 0x8033, 0x8049,
	0x805f, 0x8076, 0x808d, 0x80a3, 0x80b9, 0x80cf, 0x80e5, 0x80fc,
	// Entry 3980 - 39BF
	0x8113, 0x8129, 0x813f, 0x8154, 0x8169, 0x817f, 0x8195, 0x81aa,
	0x81bf, 0x81d6, 0x81ed, 0x8204, 0x821c, 0x8234, 0x824b, 0x8262,
	0x8277, 0x828c, 0x82a1, 0x82b7, 0x82cd, 0x82e2, 0x82f7, 0x8316,
	0x8339, 0x8359, 0x8374, 0x8396, 0x83b0, 0x83dd, 0x8406, 0x8433,
	0x8458, 0x847e, 0x84a4, 0x84cc, 0x84ec, 0x8518, 0x853d, 0x855b,
	0x8583, 0x85b6, 0x85d8, 0x8606, 0x8622, 0x864d, 0x8670, 0x868b,
	0x86b1, 0x86de, 0x86f9, 0x871e, 0x873d, 0x8766, 0x8793, 0x87a8,
	0x87c4, 0x87e7, 0x87fd, 0x8827, 0x8851, 0x8879, 0x88a0, 0x88da,
	// Entry 39C0 - 39FF
	0x890c, 0x8935, 0x8957, 0x8971, 0x899d, 0x89c6, 0x89ec, 0x8a08,
	0x8a25, 0x8a3f, 0x8a54, 0x8a75, 0x8a95, 0x8aac, 0x8ac3, 0x8ada,
	0x8af1, 0x8b08, 0x8b1f, 0x8b37, 0x8b4f, 0x8b67, 0x8b7f, 0x8b97,
	0x8baf, 0x8bc7, 0x8bdf, 0x8bf7, 0x8c0f, 0x8c27, 0x8c3f, 0x8c57,
	0x8c6f, 0x8c87, 0x8c9f, 0x8cb7, 0x8ccf, 0x8ce7, 0x8cff, 0x8d17,
	0x8d2f, 0x8d47, 0x8d5f, 0x8d77, 0x8d90, 0x8da9, 0x8dc1, 0x8dd9,
	0x8df1, 0x8e09, 0x8e21, 0x8e3a, 0x8e53, 0x8e6c, 0x8e85, 0x8e9e,
	0x8eb7, 0x8ecf, 0x8ee6, 0x8efe, 0x8f16, 0x8f2e, 0x8f46, 0x8f5e,
	// Entry 3A00 - 3A3F
	0x8f76, 0x8f8e, 0x8fa6, 0x8fbe, 0x8fd6, 0x8fee, 0x9006, 0x901e,
	0x9036, 0x904f, 0x9068, 0x9081, 0x909a, 0x90b3, 0x90cc, 0x90e5,
	0x90fe, 0x9117, 0x9130, 0x9149, 0x9162, 0x917b, 0x9193, 0x91ab,
	0x91c3, 0x91db, 0x91f3, 0x920b, 0x9223, 0x923a, 0x9251, 0x9268,
	0x927f, 0x9295, 0x92ab, 0x92c3, 0x92da, 0x92f2, 0x930a, 0x9322,
	0x9339, 0x9351, 0x9368, 0x937e, 0x9393, 0x93ab, 0x93c4, 0x93db,
	0x93f3, 0x940a, 0x9420, 0x9437, 0x944e, 0x9466, 0x947e, 0x9496,
	0x94b4, 0x94d2, 0x94f0, 0x950d, 0x952a, 0x9548, 0x9567, 0x9583,
	// Entry 3A40 - 3A7F
	0x959f, 0x95bb, 0x95d7, 0x95f4, 0x9612, 0x962e, 0x964d, 0x9669,
	0x967e, 0x9693, 0x96a9, 0x96c0, 0x96d6, 0x96ec, 0x9704, 0x971b,
	0x9732, 0x9748, 0x9760, 0x9778, 0x978f, 0x97a5, 0x97bb, 0x97d0,
	0x97e6, 0x97fc, 0x9812, 0x9828, 0x983e, 0x9853, 0x9868, 0x987e,
	0x9893, 0x98a8, 0x98bf, 0x98d5, 0x98eb, 0x9900, 0x9916, 0x992b,
	0x9940, 0x9954, 0x996c, 0x9984, 0x99a0, 0x99be, 0x99da, 0x99fc,
	0x9a19, 0x9a35, 0x9a58, 0x9a75, 0x9a94, 0x9ab3, 0x9ad5, 0x9af8,
	0x9b1b, 0x9b3d, 0x9b60, 0x9b84, 0x9ba3, 0x9bcb, 0x9be9, 0x9c05,
	// Entry 3A80 - 3ABF
	0x9c26, 0x9c41, 0x9c62, 0x9c7e, 0x9c9b, 0x9cbf, 0x9cdb, 0x9cf6,
	0x9d18, 0x9d34, 0x9d52, 0x9d6d, 0x9d90, 0x9db1, 0x9dd2, 0x9def,
	0x9e0a, 0x9e27, 0x9e44, 0x9e5f, 0x9e7d, 0x9ea3, 0x9ec2, 0x9ee1,
	0x9efd, 0x9f1e, 0x9f39, 0x9f56, 0x9f76, 0x9f96, 0x9fb6, 0x9fd6,
	0x9ff6, 0xa016, 0xa036, 0xa056, 0xa076, 0xa096, 0xa0b6, 0xa0d6,
	0xa0f6, 0xa116, 0xa136, 0xa156, 0xa176, 0xa196, 0xa1b6, 0xa1d6,
	0xa1f6, 0xa216, 0xa236, 0xa256, 0xa276, 0xa296, 0xa2b6, 0xa2d6,
	0xa2f6, 0xa316, 0xa336, 0xa356, 0xa376, 0xa396, 0xa3b6, 0xa3d6,
	// Entry 3AC0 - 3AFF
	0xa3f6, 0xa416, 0xa436, 0xa456, 0xa476, 0xa496, 0xa4b6, 0xa4d6,
	0xa4f6, 0xa516, 0xa536, 0xa556, 0xa576, 0xa596, 0xa5b6, 0xa5d6,
	0xa5f6, 0xa616, 0xa636, 0xa656, 0xa676, 0xa696, 0xa6b6, 0xa6d6,
	0xa6f6, 0xa716, 0xa736, 0xa756, 0xa776, 0xa796, 0xa7b6, 0xa7d6,
	0xa7f6, 0xa816, 0xa836, 0xa856, 0xa876, 0xa896, 0xa8b6, 0xa8d6,
	0xa8f6, 0xa916, 0xa936, 0xa956, 0xa976, 0xa996, 0xa9b6, 0xa9d6,
	0xa9f6, 0xaa16, 0xaa36, 0xaa56, 0xaa76, 0xaa96, 0xaab6, 0xaad6,
	0xaaf6, 0xab16, 0xab36, 0xab56, 0xab76, 0xab96, 0xabb6, 0xabd6,
	// Entry 3B00 - 3B3F
	0xabf6, 0xac16, 0xac36, 0xac56, 0xac76, 0xac96, 0xacb6, 0xacd6,
	0xacf6, 0xad16, 0xad36, 0xad56, 0xad76, 0xad96, 0xadb6, 0xadd6,
	0xadf6, 0xae16, 0xae36, 0xae56, 0xae76, 0xae96, 0xaeb6, 0xaed6,
	0xaef6, 0xaf16, 0xaf36, 0xaf56, 0xaf76, 0xaf96, 0xafb6, 0xafd6,
	0xaff6, 0xb016, 0xb036, 0xb056, 0xb076, 0xb096, 0xb0b6, 0xb0d6,
	0xb0f6, 0xb116, 0xb136, 0xb156, 0xb176, 0xb196, 0xb1b6, 0xb1d6,
	0xb1f6, 0xb216, 0xb236, 0xb256, 0xb276, 0xb296, 0xb2b6, 0xb2d6,
	0xb2f6, 0xb316, 0xb336, 0xb356, 0xb376, 0xb396, 0xb3b6, 0xb3d6,
	// Entry 3B40 - 3B7F
	0xb3f6, 0xb416, 0xb436, 0xb456, 0xb476, 0xb496, 0xb4b6, 0xb4d6,
	0xb4f6, 0xb516, 0xb536, 0xb556, 0xb576, 0xb596, 0xb5b6, 0xb5d6,
	0xb5f6, 0xb616, 0xb636, 0xb656, 0xb676, 0xb696, 0xb6b6, 0xb6d6,
	0xb6f6, 0xb716, 0xb736, 0xb756, 0xb776, 0xb796, 0xb7b6, 0xb7d6,
	0xb7f6, 0xb816, 0xb836, 0xb856, 0xb876, 0xb896, 0xb8b6, 0xb8d6,
	0xb8f6, 0xb916, 0xb936, 0xb956, 0xb976, 0xb996, 0xb9b6, 0xb9d6,
	0xb9f6, 0xba16, 0xba36, 0xba56, 0xba76, 0xba96, 0xbab6, 0xbad6,
	0xbaf6, 0xbb16, 0xbb36, 0xbb56, 0xbb76, 0xbb96, 0xbbb6, 0xbbd6,
	// Entry 3B80 - 3BBF
	0xbbf6, 0xbc16, 0xbc36, 0xbc56, 0xbc76, 0xbc96, 0xbcb6, 0xbcd6,
	0xbcf6, 0xbd16, 0xbd36, 0xbd56, 0xbd76, 0xbd96, 0xbdb6, 0xbdd6,
	0xbdf6, 0xbe16, 0xbe36, 0xbe56, 0xbe76, 0xbe96, 0xbeb6, 0xbed6,
	0xbef6, 0xbf16, 0xbf36, 0xbf56, 0xbf76, 0xbf96, 0xbfb6, 0xbfd6,
	0xbff6, 0xc016, 0xc036, 0xc056, 0xc076, 0xc096, 0xc0b6, 0xc0d6,
	0xc0f6, 0xc116, 0xc136, 0xc156, 0xc176, 0xc196, 0xc1b6, 0xc1d6,
	0xc1f6, 0xc216, 0xc236, 0xc256, 0xc276, 0xc296, 0xc2b6, 0xc2d6,
	0xc2f6, 0xc316, 0xc336, 0xc356, 0xc376, 0xc396, 0xc3b6, 0xc3d6,
	// Entry 3BC0 - 3BFF
	0xc3f6, 0xc416, 0xc436, 0xc456, 0xc476, 0xc496, 0xc4b6, 0xc4d6,
	0xc4f6, 0xc516, 0xc536, 0xc556, 0xc576, 0xc596, 0xc5b6, 0xc5d6,
	0xc5f6, 0xc616, 0xc636, 0xc656, 0xc676, 0xc696, 0xc6b6, 0xc6d6,
	0xc6f6, 0xc716, 0xc736, 0xc756, 0xc776, 0xc796, 0xc7b6, 0xc7d6,
	0xc7f6, 0xc816, 0xc836, 0xc856, 0xc876, 0xc896, 0xc8b6, 0xc8d6,
	0xc8f6, 0xc916, 0xc936, 0xc956, 0xc976, 0xc996, 0xc9b6, 0xc9d6,
	0xc9f6, 0xca16, 0xca36, 0xca56, 0xca76, 0xca96, 0xcab6, 0xcad6,
	0xcaf6, 0xcb16, 0xcb36, 0xcb56, 0xcb76, 0xcb96, 0xcbb6, 0xcbd6,
	// Entry 3C00 - 3C3F
	0xcbf6, 0xcc16, 0xcc36, 0xcc56, 0xcc76, 0xcc96, 0xccb6, 0xccd6,
	0xccf6, 0xcd16, 0xcd36, 0xcd56, 0xcd76, 0xcd96, 0xcdb6, 0xcdd6,
	0xcdf6, 0xce16, 0xce36, 0xce56, 0xce76, 0xce96, 0xceb6, 0xced6,
	0xcef6, 0xcf16, 0xcf36, 0xcf56, 0xcf76, 0xcf96, 0xcfb6, 0xcfd6,
	0xcff6, 0xd016, 0xd036, 0xd056, 0xd076, 0xd096, 0xd0b6, 0xd0d6,
	0xd0f6, 0xd116, 0xd136, 0xd156, 0xd176, 0xd196, 0xd1b6, 0xd1d6,
	0xd1f6, 0xd216, 0xd236, 0xd256, 0xd276, 0xd296, 0xd2b6, 0xd2d6,
	0xd2f6, 0xd316, 0xd336, 0xd356, 0xd376, 0xd396, 0xd3b6, 0xd3d6,
	// Entry 3C40 - 3C7F
	0xd3f6, 0xd416, 0xd436, 0xd456, 0xd476, 0xd496, 0xd4b6, 0xd4d6,
	0xd4f6, 0xd516, 0xd536, 0xd556, 0xd576, 0xd596, 0xd5b6, 0xd5d6,
	0xd5f6, 0xd616, 0xd636, 0xd656, 0xd676, 0xd696, 0xd6b6, 0xd6d6,
	0xd6f6, 0xd716, 0xd736, 0xd756, 0xd776, 0xd796, 0xd7b6, 0xd7d6,
	0xd7f6, 0xd816, 0xd836, 0xd856, 0xd876, 0xd896, 0xd8b6, 0xd8d6,
	0xd8f6, 0xd916, 0xd936, 0xd956, 0xd976, 0xd996, 0xd9b6, 0xd9d6,
	0xd9f6, 0xda16, 0xda36, 0xda56, 0xda76, 0xda8d, 0xdaa4, 0xdabb,
	0xdad3, 0xdaeb, 0xdb08, 0xdb1f, 0xdb3e, 0xdb5d, 0xdb7c, 0xdb9b,
	// Entry 3C80 - 3CBF
	0xdbba, 0xdbd6, 0xdbf7, 0xdc1c, 0xdc3a, 0xdc51, 0xdc69, 0xdc7e,
	0xdc94, 0xdcac, 0xdcc8, 0xdcdf, 0xdcf5, 0xdd18, 0xdd38, 0xdd57,
	0xdd82, 0xddac, 0xddc9, 0xdde7, 0xde04, 0xde21, 0xde40, 0xde5f,
	0xde7a, 0xde97, 0xdeb6, 0xded3, 0xdef0, 0xdf13, 0xdf30, 0xdf4f,
	0xdf6c, 0xdf89, 0xdfa9, 0xdfcb, 0xdfe7, 0xe006, 0xe023, 0xe041,
	0xe05f, 0xe07c, 0xe098, 0xe0b3, 0xe0ce, 0xe0e8, 0xe102, 0xe128,
	0xe14b, 0xe16b, 0xe188, 0xe1a7, 0xe1c5, 0xe1e4, 0xe200, 0xe21e,
	0xe23b, 0xe25c, 0xe27a, 0xe29a, 0xe2b9, 0xe2db, 0xe2fa, 0xe31b,
	// Entry 3CC0 - 3CFF
	0xe33b, 0xe35c, 0xe37a, 0xe39a, 0xe3b9, 0xe3d9, 0xe3f6, 0xe415,
	0xe433, 0xe452, 0xe46e, 0xe48c, 0xe4a9, 0xe4ca, 0xe4e8, 0xe508,
	0xe527, 0xe547, 0xe564, 0xe583, 0xe5a1, 0xe5c1, 0xe5de, 0xe5fd,
	0xe61b, 0xe63c, 0xe65a, 0xe67a, 0xe699, 0xe6bc, 0xe6dc, 0xe6fe,
	0xe71f, 0xe741, 0xe760, 0xe781, 0xe79f, 0xe7be, 0xe7da, 0xe7fa,
	0xe817, 0xe836, 0xe852, 0xe872, 0xe88f, 0xe8b0, 0xe8ce, 0xe8ee,
	0xe90d, 0xe92c, 0xe948, 0xe966, 0xe983, 0xe9a3, 0xe9c0, 0xe9df,
	0xe9fd, 0xea1e, 0xea3c, 0xea5c, 0xea7b, 0xeaa2, 0xeac6, 0xeae7,
	// Entry 3D00 - 3D3F
	0xeb05, 0xeb25, 0xeb44, 0xeb72, 0xeb9d, 0xebc1, 0xebe2, 0xec05,
	0xec27, 0xec52, 0xec7a, 0xeca4, 0xeccd, 0xecf3, 0xed16, 0xed4d,
	0xed81, 0xed98, 0xedaf, 0xedcb, 0xede7, 0xee05, 0xee23, 0xee54,
	0xee85, 0xeea2, 0xeebf, 0xeee6, 0xef0d, 0xef34, 0xef46, 0xef63,
	0xef80, 0xef9e, 0xefb9, 0xefd6, 0xeff2, 0xf00f, 0xf029, 0xf047,
	0xf062, 0xf080, 0xf09b, 0xf0c9, 0xf0e7, 0xf102, 0xf128, 0xf14b,
	0xf171, 0xf194, 0xf1b1, 0xf1cb, 0xf1e7, 0xf202, 0xf23f, 0xf27b,
	0xf2b7, 0xf2f0, 0xf32a, 0xf361, 0xf39c, 0xf3d4, 0xf40d, 0xf443,
	// Entry 3D40 - 3D7F
	0xf47d, 0xf4b4, 0xf4ee, 0xf525, 0xf55e, 0xf594, 0xf5cc, 0xf61f,
	0xf66f, 0xf6c1, 0xf6e6, 0xf708, 0xf72c, 0xf74f, 0xf78b, 0xf7c6,
	0xf802, 0xf846, 0xf881, 0xf8ac, 0xf8d6, 0xf901, 0xf92c, 0xf95f,
	0xf989, 0xf9b4, 0xf9de, 0xfa09, 0xfa34, 0xfa67, 0xfa91, 0xfabd,
	0xfae9, 0xfb1d, 0xfb48, 0xfb73, 0xfb9f, 0xfbca, 0xfbf5, 0xfc21,
	0xfc4c, 0xfc78, 0xfca4, 0xfccf, 0xfcfb, 0xfd27, 0xfd51, 0xfd7c,
	0xfda7, 0xfdd1, 0xfdfc, 0xfe27, 0xfe51, 0xfe7c, 0xfea7, 0xfed2,
	0xfefd, 0xff2a, 0xff57, 0xff82, 0xffac, 0xffd7, 0x0002, 0x0035,
	// Entry 3D80 - 3DBF
	0x005f, 0x0089, 0x00b4, 0x00e7, 0x0111, 0x013c, 0x0167, 0x0191,
	0x01bc, 0x01e6, 0x0211, 0x0244, 0x026e, 0x0299, 0x02c3, 0x02ee,
	0x0319, 0x034c, 0x0376, 0x03a2, 0x03cd, 0x03f9, 0x0425, 0x0459,
	0x0484, 0x04b0, 0x04db, 0x0507, 0x0533, 0x0567, 0x0592, 0x05bd,
	0x05e8, 0x061b, 0x0645, 0x0670, 0x069a, 0x06c5, 0x06f0, 0x0723,
	0x074d, 0x0785, 0x07bc, 0x07fc, 0x082e, 0x0860, 0x088f, 0x08be,
	0x08ed, 0x0927, 0x095f, 0x0998, 0x09d1, 0x0a0a, 0x0a4b, 0x0a83,
	0x0aaa, 0x0ad2, 0x0afa, 0x0b22, 0x0b52, 0x0b79, 0x0ba0, 0x0bc8,
	// Entry 3DC0 - 3DFF
	0x0bf0, 0x0c18, 0x0c48, 0x0c6f, 0x0c97, 0x0cc0, 0x0ce9, 0x0d12,
	0x0d43, 0x0d6b, 0x0d9b, 0x0dc2, 0x0df2, 0x0e19, 0x0e41, 0x0e68,
	0x0e90, 0x0ec0, 0x0ee7, 0x0f0f, 0x0f3f, 0x0f66, 0x0f8f, 0x0fb8,
	0x0fe0, 0x1009, 0x1032, 0x105b, 0x108c, 0x10b4, 0x10f1, 0x1118,
	0x1140, 0x1168, 0x1190, 0x11c0, 0x11e7, 0x1222, 0x125c, 0x1297,
	0x12d2, 0x130c, 0x1336, 0x135f, 0x1389, 0x13b3, 0x13dc, 0x1406,
	0x142f, 0x1459, 0x1483, 0x14ac, 0x14d7, 0x1501, 0x152c, 0x1556,
	0x1580, 0x15ab, 0x15d6, 0x1601, 0x162b, 0x1656, 0x1681, 0x16aa,
	// Entry 3E00 - 3E3F
	0x16d4, 0x16fe, 0x1728, 0x1751, 0x177b, 0x17a5, 0x17ce, 0x17f8,
	0x1822, 0x184c, 0x1878, 0x18a4, 0x18ce, 0x18f7, 0x1921, 0x194b,
	0x1974, 0x199e, 0x19c8, 0x19f1, 0x1a1b, 0x1a44, 0x1a6e, 0x1a98,
	0x1ac1, 0x1aeb, 0x1b15, 0x1b3e, 0x1b69, 0x1b93, 0x1bbe, 0x1be9,
	0x1c14, 0x1c3e, 0x1c69, 0x1c94, 0x1cbe, 0x1ce8, 0x1d12, 0x1d48,
	0x1d72, 0x1d9b, 0x1dc5, 0x1def, 0x1e18, 0x1e52, 0x1e8b, 0x1eb4,
	0x1edc, 0x1f05, 0x1f2d, 0x1f57, 0x1f80, 0x1faa, 0x1fd3, 0x1ffe,
	0x2028, 0x2050, 0x2079, 0x20a2, 0x20cc, 0x20f5, 0x211e, 0x2146,
	// Entry 3E40 - 3E7F
	0x2173, 0x21a0, 0x21cd, 0x2200, 0x222a, 0x225d, 0x2287, 0x22bc,
	0x22e8, 0x231c, 0x2347, 0x237c, 0x23a8, 0x23db, 0x2405, 0x2439,
	0x2464, 0x2498, 0x24c3, 0x24f6, 0x2520, 0x2553, 0x257d, 0x25aa,
	0x25d6, 0x2603, 0x2630, 0x265c, 0x2687, 0x26b1, 0x26db, 0x270b,
	0x2732, 0x2762, 0x2789, 0x27bb, 0x27e4, 0x2815, 0x283d, 0x286f,
	0x2898, 0x28c8, 0x28ef, 0x2920, 0x2948, 0x2979, 0x29a1, 0x29d1,
	0x29f8, 0x2a28, 0x2a4f, 0x2a79, 0x2aa2, 0x2acc, 0x2af6, 0x2b1f,
	0x2b47, 0x2b6e, 0x2b95, 0x2bc1, 0x2bec, 0x2c18, 0x2c44, 0x2c6e,
	// Entry 3E80 - 3EBF
	0x2c99, 0x2cc3, 0x2ced, 0x2d16, 0x2d40, 0x2d6b, 0x2d95, 0x2dc0,
	0x2de9, 0x2e12, 0x2e3f, 0x2e6f, 0x2e86, 0x2e9e, 0x2ed2, 0x2f03,
	0x2f36, 0x2f69, 0x2f9d, 0x2fd1, 0x3004, 0x3038, 0x306a, 0x309e,
	0x30cf, 0x3109, 0x313d, 0x3171, 0x31ac, 0x31de, 0x3212, 0x3247,
	0x327a, 0x32af, 0x32df, 0x3311, 0x3343, 0x3376, 0x33ab, 0x33de,
	0x3412, 0x3448, 0x347c, 0x34b2, 0x34eb, 0x351d, 0x3551, 0x3582,
	0x35b5, 0x35e9, 0x361a, 0x364c, 0x367e, 0x36b2, 0x36ec, 0x3720,
	0x3753, 0x378f, 0x37c1, 0x37f5, 0x3826, 0x3858, 0x3889, 0x38b9,
	// Entry 3EC0 - 3EFF
	0x38f2, 0x3926, 0x3958, 0x398a, 0x39be, 0x39ef, 0x3a22, 0x3a56,
	0x3a8a, 0x3abb, 0x3aef, 0x3b24, 0x3b59, 0x3b8e, 0x3bc3, 0x3bf7,
	0x3c2b, 0x3c5f, 0x3c99, 0x3ccc, 0x3d01, 0x3d3c, 0x3d6e, 0x3da9,
	0x3ddb, 0x3e0f, 0x3e40, 0x3e71, 0x3eab, 0x3edc, 0x3f16, 0x3f47,
	0x3f81, 0x3fb3, 0x3fed, 0x4028, 0x4063, 0x4093, 0x40c5, 0x40f5,
	0x4126, 0x4157, 0x4187, 0x41b8, 0x41e9, 0x421b, 0x424c, 0x427d,
	0x42b0, 0x42e3, 0x4314, 0x4345, 0x4379, 0x43ab, 0x43df, 0x4411,
	0x4443, 0x4475, 0x44a6, 0x44d7, 0x4509, 0x453a, 0x456a, 0x459e,
	// Entry 3F00 - 3F3F
	0x45d2, 0x4606, 0x4638, 0x466a, 0x46a7, 0x46e3, 0x4706, 0x4729,
	0x474f, 0x4772, 0x4796, 0x47ba, 0x47e0, 0x4803, 0x482e, 0x484d,
	0x4856, 0x4883, 0x4897, 0x48ab, 0x48bf, 0x48d3, 0x48e7, 0x48fb,
	0x490f, 0x4923, 0x4937, 0x494c, 0x4961, 0x4976, 0x498b, 0x49a0,
	0x49b5, 0x49ca, 0x49ee, 0x4a1e, 0x4a52, 0x4a76, 0x4a9e, 0x4acd,
	0x4af9, 0x4b35, 0x4b72, 0x4ba4, 0x4bc0, 0x4bdd, 0x4bfd, 0x4c1e,
	0x4c38, 0x4c53, 0x4c6e, 0x4c90, 0x4cb3, 0x4cd2, 0x4cf2, 0x4d12,
	0x4d33, 0x4d54, 0x4d76, 0x4d99, 0x4dc6, 0x4dec, 0x4e12, 0x4e39,
	// Entry 3F40 - 3F7F
	0x4e65, 0x4e94, 0x4ec4, 0x4ef5, 0x4f27, 0x4f61, 0x4f9c, 0x4fd8,
	0x5015, 0x504d, 0x5086, 0x50b7, 0x50e9, 0x511b, 0x514e, 0x5186,
	0x51bf, 0x51c9, 0x51d9, 0x520b, 0x523e, 0x524d, 0x5260, 0x526d,
	0x5281, 0x5290, 0x52a3, 0x52b0, 0x52bb, 0x52d2, 0x52e1, 0x52f0,
	0x52fb, 0x530e, 0x5324, 0x5331, 0x5347, 0x535e, 0x5376, 0x538f,
	0x53b0, 0x53d2, 0x53e3, 0x53f2, 0x5400, 0x540f, 0x5421, 0x5435,
	0x544c, 0x545d, 0x5472, 0x5483, 0x5495, 0x54a8, 0x54c5, 0x54e7,
	0x5504, 0x5518, 0x5535, 0x554f, 0x5567, 0x5581, 0x5599, 0x55b3,
	// Entry 3F80 - 3FBF
	0x55cb, 0x55e6, 0x55ff, 0x5619, 0x5631, 0x5652, 0x5683, 0x56b1,
	0x56e2, 0x5710, 0x5740, 0x576d, 0x579e, 0x57cc, 0x57fc, 0x5829,
	0x5858, 0x5886, 0x58a6, 0x58c3, 0x58e2, 0x58fe, 0x591c, 0x5939,
	0x5960, 0x5984, 0x59a3, 0x59bf, 0x59dd, 0x59fa, 0x5a1a, 0x5a37,
	0x5a56, 0x5a74, 0x5a94, 0x5ab1, 0x5ad0, 0x5aee, 0x5b0d, 0x5b29,
	0x5b47, 0x5b64, 0x5b84, 0x5ba1, 0x5bc0, 0x5bde, 0x5bfd, 0x5c19,
	0x5c39, 0x5c56, 0x5c75, 0x5c91, 0x5cb1, 0x5cce, 0x5cee, 0x5d0b,
	0x5d2a, 0x5d48, 0x5d69, 0x5d87, 0x5da7, 0x5dc6, 0x5de5, 0x5e01,
	// Entry 3FC0 - 3FFF
	0x5e1f, 0x5e3c, 0x5e5b, 0x5e77, 0x5e95, 0x5eb2, 0x5ed1, 0x5eed,
	0x5f0b, 0x5f28, 0x5f47, 0x5f63, 0x5f81, 0x5f9e, 0x5fbd, 0x5fd9,
	0x5ff7, 0x6014, 0x6035, 0x6053, 0x6073, 0x6092, 0x60b1, 0x60cd,
	0x60eb, 0x6108, 0x6127, 0x6143, 0x6161, 0x617e, 0x619d, 0x61b9,
	0x61d7, 0x61f4, 0x6213, 0x622f, 0x624d, 0x626a, 0x628a, 0x62a7,
	0x62c6, 0x62e4, 0x6304, 0x6321, 0x6340, 0x635e, 0x637d, 0x6399,
	0x63b7, 0x63d4, 0x63f3, 0x640f, 0x6437, 0x645c, 0x647b, 0x6497,
	0x64b5, 0x64d2, 0x650e, 0x6547, 0x6583, 0x65bc, 0x65f8, 0x6631,
	// Entry 4000 - 403F
	0x665c, 0x6684, 0x669d, 0x66b7, 0x66cf, 0x66e4, 0x66f9, 0x670f,
	0x6722, 0x6736, 0x6750, 0x676b, 0x677d, 0x6790, 0x679f, 0x67b5,
	0x67c8, 0x67d9, 0x67ed, 0x6800, 0x6813, 0x6828, 0x683c, 0x6850,
	0x6863, 0x6878, 0x688d, 0x68a1, 0x68b0, 0x68c3, 0x68db, 0x68f0,
	0x690b, 0x6922, 0x6939, 0x6959, 0x6979, 0x6999, 0x69b9, 0x69d9,
	0x69f9, 0x6a19, 0x6a39, 0x6a59, 0x6a79, 0x6a99, 0x6ab9, 0x6ad9,
	0x6af9, 0x6b19, 0x6b39, 0x6b59, 0x6b79, 0x6b99, 0x6bb9, 0x6bd9,
	0x6bf9, 0x6c19, 0x6c39, 0x6c59, 0x6c79, 0x6c96, 0x6caf, 0x6ccd,
	// Entry 4040 - 407F
	0x6ce8, 0x6cfa, 0x6d10, 0x6d2e, 0x6d4c, 0x6d6a, 0x6d88, 0x6da6,
	0x6dc4, 0x6de2, 0x6e00, 0x6e1e, 0x6e3c, 0x6e5a, 0x6e78, 0x6e96,
	0x6eb4, 0x6ed2, 0x6ef0, 0x6f0e, 0x6f2c, 0x6f4a, 0x6f68, 0x6f86,
	0x6fa4, 0x6fc2, 0x6fe0, 0x6ffe, 0x701c, 0x7038, 0x704f, 0x706c,
	0x707b, 0x709b, 0x70bc, 0x70db, 0x70f8, 0x7116, 0x7131, 0x714e,
	0x716a, 0x718b, 0x71ac, 0x71cd, 0x71ee, 0x720f, 0x7231, 0x7253,
	0x7275, 0x7297, 0x72c7, 0x72e2, 0x72fd, 0x7318, 0x7333, 0x734e,
	0x736a, 0x7386, 0x73a2, 0x73be, 0x73da, 0x73f6, 0x7412, 0x742e,
	// Entry 4080 - 40BF
	0x744a, 0x7466, 0x7482, 0x749e, 0x74ba, 0x74d6, 0x74f2, 0x750e,
	0x752a, 0x7546, 0x7562, 0x757e, 0x759a, 0x75b6, 0x75d2, 0x75ee,
	0x760a, 0x7626, 0x7642, 0x765e, 0x767a, 0x7696, 0x76b2, 0x76ce,
	0x76ea, 0x7706, 0x7722, 0x773e, 0x775a, 0x7776, 0x7792, 0x77ad,
	0x77d1, 0x77fa, 0x7811, 0x782f, 0x7852, 0x7875, 0x7892, 0x78b5,
	0x78d8, 0x78f6, 0x7919, 0x7936, 0x795a, 0x797d, 0x79a0, 0x79c2,
	0x79e7, 0x7a0c, 0x7a2f, 0x7a4c, 0x7a69, 0x7a8b, 0x7aad, 0x7ac9,
	0x7aea, 0x7b07, 0x7b24, 0x7b46, 0x7b65, 0x7b84, 0x7ba3, 0x7bc2,
	// Entry 40C0 - 40FF
	0x7bdf, 0x7bf8, 0x7c12, 0x7c2c, 0x7c47, 0x7c61, 0x7c7a, 0x7c95,
	0x7caf, 0x7cc8, 0x7ce2, 0x7cfd, 0x7d17, 0x7d31, 0x7d4a, 0x7d65,
	0x7d7f, 0x7d99, 0x7db3, 0x7dcd, 0x7de7, 0x7e00, 0x7e13, 0x7e27,
	0x7e39, 0x7e49, 0x7e5d, 0x7e6f, 0x7e81, 0x7e9f, 0x7eb8, 0x7ecf,
	0x7ee9, 0x7f02, 0x7f18, 0x7f2e, 0x7f4b, 0x7f6b, 0x7f8c, 0x7fa8,
	0x7fbd, 0x7fd5, 0x7fed, 0x8005, 0x801d, 0x8035, 0x804e, 0x8067,
	0x8080, 0x8099, 0x80b2, 0x80cb, 0x80e4, 0x80fd, 0x8116, 0x812f,
	0x8148, 0x8161, 0x817a, 0x8193, 0x81ac, 0x81c5, 0x81de, 0x81f7,
	// Entry 4100 - 413F
	0x8210, 0x8229, 0x8242, 0x825b, 0x8274, 0x828d, 0x82a6, 0x82bf,
	0x82d8, 0x82f1, 0x830a, 0x8323, 0x833c, 0x8355, 0x836e, 0x8387,
	0x83a0, 0x83b9, 0x83d2, 0x83eb, 0x8404, 0x841d, 0x8436, 0x844f,
	0x8468, 0x8481, 0x849a, 0x84b3, 0x84cc, 0x84e5, 0x84fe, 0x8517,
	0x8530, 0x8549, 0x8562, 0x857b, 0x8594, 0x85ad, 0x85c6, 0x85df,
	0x85f9, 0x8613, 0x862d, 0x8647, 0x8661, 0x867b, 0x8695, 0x86af,
	0x86c9, 0x86e3, 0x86fd, 0x8711, 0x8725, 0x8739, 0x874d, 0x8761,
	0x8775, 0x8789, 0x879d, 0x87b1, 0x87c5, 0x87d9, 0x87ed, 0x8801,
	// Entry 4140 - 417F
	0x8815, 0x882f, 0x884b, 0x8866, 0x8882, 0x889e, 0x88be, 0x88d9,
	0x88f4, 0x8914, 0x8933, 0x894e, 0x896a, 0x8985, 0x89a1, 0x89bd,
	0x89da, 0x89f6, 0x8a12, 0x8a30, 0x8a4b, 0x8a68, 0x8a82, 0x8a9d,
	0x8ab3, 0x8acf, 0x8aea, 0x8b07, 0x8b22, 0x8b38, 0x8b53, 0x8b69,
	0x8b7f, 0x8b9a, 0x8bb0, 0x8bc6, 0x8bdc, 0x8bf8, 0x8c0e, 0x8c24,
	0x8c40, 0x8c56, 0x8c6c, 0x8c8a, 0x8ca7, 0x8cbd, 0x8cd3, 0x8ce9,
	0x8cff, 0x8d15, 0x8d2b, 0x8d41, 0x8d57, 0x8d6d, 0x8d89, 0x8d9f,
	0x8dba, 0x8dd0, 0x8de6, 0x8dfc, 0x8e12, 0x8e28, 0x8e3e, 0x8e54,
	// Entry 4180 - 41BF
	0x8e6a, 0x8e80, 0x8e96, 0x8eac, 0x8ec9, 0x8ee9, 0x8f07, 0x8f23,
	0x8f3f, 0x8f55, 0x8f71, 0x8f87, 0x8f9d, 0x8fc3, 0x8fe1, 0x9005,
	0x9021, 0x9037, 0x904d, 0x9069, 0x907f, 0x9095, 0x90ab, 0x90c1,
	0x90d7, 0x90f2, 0x9108, 0x911e, 0x9134, 0x914a, 0x9160, 0x917d,
	0x919a, 0x91b7, 0x91d4, 0x91f1, 0x920e, 0x922b, 0x9248, 0x9265,
	0x9282, 0x929f, 0x92bc, 0x92d9, 0x92f6, 0x9313, 0x9330, 0x934d,
	0x936a, 0x9387, 0x93a4, 0x93c1, 0x93de, 0x93fb, 0x9418, 0x9435,
	0x9452, 0x946f, 0x948c, 0x94a9, 0x94c3, 0x94dc, 0x94ed, 0x94fe,
	// Entry 41C0 - 41FF
	0x950f, 0x9522, 0x9534, 0x9546, 0x9557, 0x956a, 0x957d, 0x958f,
	0x95a0, 0x95b4, 0x95c8, 0x95db, 0x95ee, 0x9601, 0x9616, 0x962a,
	0x963e, 0x9657, 0x9670, 0x968b, 0x96a5, 0x96bf, 0x96d8, 0x96f3,
	0x970e, 0x9728, 0x9742, 0x975c, 0x9778, 0x9793, 0x97ae, 0x97c8,
	0x97e4, 0x9800, 0x981b, 0x9835, 0x9852, 0x986f, 0x988b, 0x98a7,
	0x98c3, 0x98e1, 0x98fe, 0x991b, 0x9932, 0x994d, 0x9969, 0x9984,
	0x99a0, 0x99c0, 0x99e3, 0x9a00, 0x9a1c, 0x9a3e, 0x9a5d, 0x9a7f,
	0x9a9a, 0x9ab6, 0x9ad9, 0x9afd, 0x9b22, 0x9b45, 0x9b67, 0x9b8b,
	// Entry 4200 - 423F
	0x9bb5, 0x9be0, 0x9c0b, 0x9c37, 0x9c5a, 0x9c7c, 0x9ca0, 0x9cca,
	0x9cf5, 0x9d20, 0x9d4b, 0x9d78, 0x9d97, 0x9dbc, 0x9dd9, 0x9df8,
	0x9e17, 0x9e34, 0x9e5a, 0x9e82, 0x9ea2, 0x9ec1, 0x9eef, 0x9f0e,
	0x9f2c, 0x9f49, 0x9f69, 0x9f8a, 0x9fba, 0x9fdb, 0x9ffa, 0xa01f,
	0xa046, 0xa06e, 0xa096, 0xa0bc, 0xa0e3, 0xa107, 0xa12d, 0xa154,
	0xa176, 0xa19a, 0xa1ad, 0xa1cf, 0xa1e4, 0xa1fd, 0xa20c, 0xa21d,
	0xa22f, 0xa23e, 0xa252, 0xa268, 0xa27d, 0xa292, 0xa2a5, 0xa2bc,
	0xa2cc, 0xa2dd, 0xa2ee, 0xa2ff, 0xa310, 0xa321, 0xa339, 0xa348,
	// Entry 4240 - 427F
	0xa35e, 0xa371, 0xa385, 0xa391, 0xa3a3, 0xa3b3, 0xa3c6, 0xa3d8,
	0xa3f2, 0xa404, 0xa417, 0xa42b, 0xa440, 0xa454, 0xa461, 0xa475,
	0xa489, 0xa4a6, 0xa4c4, 0xa4e4, 0xa4fe, 0xa516, 0xa52e, 0xa547,
	0xa562, 0xa57a, 0xa592, 0xa5a8, 0xa5c1, 0xa5d8, 0xa5f3, 0xa60d,
	0xa623, 0xa639, 0xa655, 0xa677, 0xa690, 0xa6a7, 0xa6bf, 0xa6d8,
	0xa6f2, 0xa709, 0xa720, 0xa737, 0xa753, 0xa769, 0xa77f, 0xa797,
	0xa7ae, 0xa7c6, 0xa7dc, 0xa7f9, 0xa810, 0xa82a, 0xa844, 0xa85b,
	0xa875, 0xa88d, 0xa8a6, 0xa8c1, 0xa8dd, 0xa8f9, 0xa924, 0xa933,
	// Entry 4280 - 42BF
	0xa942, 0xa951, 0xa961, 0xa970, 0xa97f, 0xa98e, 0xa99d, 0xa9ac,
	0xa9bc, 0xa9cb, 0xa9da, 0xa9e9, 0xa9f8, 0xaa07, 0xaa16, 0xaa26,
	0xaa36, 0xaa45, 0xaa54, 0xaa64, 0xaa73, 0xaa82, 0xaa91, 0xaaa1,
	0xaab1, 0xaac1, 0xaad0, 0xaadf, 0xaaee, 0xaafe, 0xab0d, 0xab1c,
	0xab2d, 0xab3c, 0xab4c, 0xab5c, 0xab6b, 0xab7a, 0xab89, 0xab98,
	0xaba8, 0xabb7, 0xabc7, 0xabd8, 0xabe7, 0xabf9, 0xac08, 0xac18,
	0xac27, 0xac36, 0xac47, 0xac56, 0xac66, 0xac75, 0xac84, 0xac96,
	0xaca5, 0xacb5, 0xacc5, 0xacd5, 0xace4, 0xacf4, 0xad04, 0xad15,
	// Entry 42C0 - 42FF
	0xad25, 0xad35, 0xad47, 0xad57, 0xad69, 0xad79, 0xad89, 0xad9a,
	0xadab, 0xadbc, 0xadcd, 0xaddd, 0xadef, 0xae0a, 0xae20, 0xae36,
	0xae4e, 0xae65, 0xae7c, 0xae92, 0xaeaa, 0xaec2, 0xaed9, 0xaef0,
	0xaf0a, 0xaf24, 0xaf3d, 0xaf56, 0xaf6f, 0xaf8a, 0xafa4, 0xafbe,
	0xafdd, 0xaffc, 0xb01d, 0xb03d, 0xb05d, 0xb07c, 0xb09d, 0xb0be,
	0xb0de, 0xb0f1, 0xb105, 0xb119, 0xb12d, 0xb140, 0xb154, 0xb168,
	0xb17c, 0xb191, 0xb1a4, 0xb1b8, 0xb1cc, 0xb1e0, 0xb1f4, 0xb209,
	0xb21c, 0xb230, 0xb245, 0xb259, 0xb26d, 0xb281, 0xb295, 0xb2a8,
	// Entry 4300 - 433F
	0xb2bd, 0xb2d2, 0xb2e7, 0xb2fb, 0xb310, 0xb325, 0xb339, 0xb34d,
	0xb362, 0xb378, 0xb38f, 0xb3a5, 0xb3bd, 0xb3d1, 0xb3ef, 0xb40d,
	0xb41f, 0xb434, 0xb446, 0xb458, 0xb46c, 0xb482, 0xb494, 0xb4a6,
	0xb4ba, 0xb4cb, 0xb4de, 0xb4f1, 0xb504, 0xb518, 0xb529, 0xb53b,
	0xb551, 0xb565, 0xb578, 0xb58b, 0xb59e, 0xb5b1, 0xb5c4, 0xb5d7,
	0xb5ea, 0xb5fd, 0xb617, 0xb62b, 0xb640, 0xb655, 0xb66a, 0xb67d,
	0xb693, 0xb6aa, 0xb6c0, 0xb6d7, 0xb6ea, 0xb700, 0xb715, 0xb72c,
	0xb743, 0xb759, 0xb76f, 0xb784, 0xb799, 0xb7ae, 0xb7c1, 0xb7d8,
	// Entry 4340 - 437F
	0xb7ef, 0xb808, 0xb81d, 0xb833, 0xb846, 0xb85a, 0xb86e, 0xb882,
	0xb898, 0xb8ad, 0xb8c2, 0xb8d8, 0xb8ed, 0xb901, 0xb915, 0xb929,
	0xb93d, 0xb95b, 0xb97a, 0xb99a, 0xb9bb, 0xb9da, 0xb9ee, 0xba02,
	0xba17, 0xba2a, 0xba3f, 0xba51, 0xba63, 0xba77, 0xba8b, 0xba9e,
	0xbab1, 0xbac4, 0xbad8, 0xbaed, 0xbb00, 0xbb14, 0xbb27, 0xbb39,
	0xbb4e, 0xbb61, 0xbb73, 0xbb87, 0xbb9b, 0xbbb0, 0xbbc6, 0xbbdb,
	0xbbed, 0xbbfe, 0xbc0f, 0xbc22, 0xbc37, 0xbc49, 0xbc5b, 0xbc6d,
	0xbc80, 0xbc93, 0xbca6, 0xbcb9, 0xbccc, 0xbcdf, 0xbcf2, 0xbd05,
	// Entry 4380 - 43BF
	0xbd18, 0xbd2b, 0xbd3e, 0xbd51, 0xbd64, 0xbd78, 0xbd8b, 0xbd9e,
	0xbdb1, 0xbdc4, 0xbdd7, 0xbdea, 0xbdfd, 0xbe10, 0xbe23, 0xbe36,
	0xbe49, 0xbe5c, 0xbe6f, 0xbe82, 0xbe95, 0xbea8, 0xbebc, 0xbed0,
	0xbee3, 0xbefe, 0xbf1b, 0xbf38, 0xbf55, 0xbf6f, 0xbf8b, 0xbfa0,
	0xbfb8, 0xbfd0, 0xbfe6, 0xbffc, 0xc012, 0xc02b, 0xc045, 0xc062,
	0xc07f, 0xc09c, 0xc0ba, 0xc0d7, 0xc0f5, 0xc113, 0xc131, 0xc14f,
	0xc16e, 0xc18c, 0xc1ab, 0xc1c4, 0xc1dd, 0xc1f6, 0xc210, 0xc228,
	0xc242, 0xc25c, 0xc276, 0xc290, 0xc2ab, 0xc2c5, 0xc2df, 0xc2f9,
	// Entry 43C0 - 43FF
	0xc312, 0xc32c, 0xc346, 0xc361, 0xc37a, 0xc394, 0xc3ae, 0xc3c9,
	0xc3e2, 0xc3fb, 0xc414, 0xc42d, 0xc447, 0xc460, 0xc479, 0xc494,
	0xc4af, 0xc4ca, 0xc4e6, 0xc501, 0xc51d, 0xc539, 0xc555, 0xc571,
	0xc58e, 0xc5aa, 0xc5c7, 0xc5de, 0xc5f5, 0xc60c, 0xc624, 0xc63a,
	0xc652, 0xc66a, 0xc682, 0xc69a, 0xc6b3, 0xc6cb, 0xc6e3, 0xc6fb,
	0xc712, 0xc72a, 0xc742, 0xc75b, 0xc772, 0xc78a, 0xc7a2, 0xc7bb,
	0xc7d2, 0xc7e9, 0xc800, 0xc817, 0xc82f, 0xc846, 0xc85d, 0xc870,
	0xc882, 0xc895, 0xc8a7, 0xc8bb, 0xc8cc, 0xc8df, 0xc8f4, 0xc906,
	// Entry 4400 - 443F
	0xc919, 0xc92b, 0xc93e, 0xc950, 0xc962, 0xc975, 0xc987, 0xc99d,
	0xc9b1, 0xc9c3, 0xc9d7, 0xc9ea, 0xc9fd, 0xca0e, 0xca20, 0xca32,
	0xca44, 0xca55, 0xca68, 0xca7a, 0xca8b, 0xca9e, 0xcab0, 0xcac2,
	0xcad4, 0xcae6, 0xcaf7, 0xcb09, 0xcb1c, 0xcb2e, 0xcb40, 0xcb52,
	0xcb63, 0xcb75, 0xcb87, 0xcb9b, 0xcbad, 0xcbbf, 0xcbd1, 0xcbe4,
	0xcbf5, 0xcc06, 0xcc17, 0xcc28, 0xcc3a, 0xcc4d, 0xcc5e, 0xcc6f,
	0xcc83, 0xcc95, 0xcca8, 0xccb9, 0xccca, 0xccdd, 0xccf0, 0xcd03,
	0xcd16, 0xcd29, 0xcd3b, 0xcd4c, 0xcd5d, 0xcd6d, 0xcd7d, 0xcd8d,
	// Entry 4440 - 447F
	0xcd9d, 0xcdad, 0xcdbe, 0xcdcf, 0xcde0, 0xcdf2, 0xce03, 0xce14,
	0xce27, 0xce39, 0xce4b, 0xce5c, 0xce6f, 0xce82, 0xce94, 0xceaa,
	0xcec1, 0xced9, 0xcef0, 0xcf08, 0xcf20, 0xcf3a, 0xcf50, 0xcf68,
	0xcf7f, 0xcf97, 0xcfad, 0xcfc4, 0xcfdd, 0xcff5, 0xd00c, 0xd023,
	0xd03a, 0xd050, 0xd068, 0xd07f, 0xd098, 0xd0af, 0xd0c7, 0xd0de,
	0xd0f7, 0xd10f, 0xd129, 0xd142, 0xd15a, 0xd170, 0xd187, 0xd19f,
	0xd1b7, 0xd1ce, 0xd1e6, 0xd1fa, 0xd20f, 0xd225, 0xd23a, 0xd250,
	0xd266, 0xd27e, 0xd292, 0xd2a8, 0xd2bd, 0xd2d3, 0xd2e7, 0xd2fc,
	// Entry 4480 - 44BF
	0xd313, 0xd329, 0xd33e, 0xd353, 0xd368, 0xd37c, 0xd392, 0xd3a7,
	0xd3be, 0xd3d3, 0xd3e9, 0xd3fe, 0xd415, 0xd42b, 0xd443, 0xd45a,
	0xd470, 0xd484, 0xd499, 0xd4af, 0xd4c5, 0xd4da, 0xd4f0, 0xd500,
	0xd511, 0xd522, 0xd534, 0xd545, 0xd557, 0xd569, 0xd57a, 0xd58a,
	0xd59b, 0xd5ac, 0xd5be, 0xd5cf, 0xd5df, 0xd5f0, 0xd601, 0xd612,
	0xd624, 0xd635, 0xd646, 0xd657, 0xd669, 0xd679, 0xd68a, 0xd69b,
	0xd6ac, 0xd6be, 0xd6cf, 0xd6e1, 0xd6f2, 0xd704, 0xd714, 0xd725,
	0xd736, 0xd746, 0xd757, 0xd769, 0xd77b, 0xd790, 0xd7a2, 0xd7bf,
	// Entry 44C0 - 44FF
	0xd7dc, 0xd7f9, 0xd816, 0xd832, 0xd850, 0xd86d, 0xd88b, 0xd8a8,
	0xd8c5, 0xd8e3, 0xd900, 0xd91d, 0xd93a, 0xd957, 0xd975, 0xd993,
	0xd9b1, 0xd9ce, 0xd9ec, 0xda09, 0xda27, 0xda45, 0xda62, 0xda7f,
	0xda9d, 0xdaba, 0xdad8, 0xdaf5, 0xdb12, 0xdb30, 0xdb4f, 0xdb6d,
	0xdb8b, 0xdba7, 0xdbc5, 0xdbe2, 0xdc00, 0xdc1e, 0xdc3b, 0xdc5a,
	0xdc77, 0xdc95, 0xdcb3, 0xdcd1, 0xdcef, 0xdd0c, 0xdd2a, 0xdd48,
	0xdd66, 0xdd84, 0xdda1, 0xddc1, 0xddd4, 0xdde7, 0xddfa, 0xde0d,
	0xde20, 0xde33, 0xde46, 0xde59, 0xde6c, 0xde7f, 0xde92, 0xdea5,
	// Entry 4500 - 453F
	0xdeb8, 0xdecb, 0xdede, 0xdef1, 0xdf05, 0xdf19, 0xdf2c, 0xdf40,
	0xdf54, 0xdf67, 0xdf7b, 0xdf8e, 0xdfa1, 0xdfb4, 0xdfc7, 0xdfda,
	0xdfed, 0xe000, 0xe013, 0xe026, 0xe039, 0xe04c, 0xe05f, 0xe072,
	0xe085, 0xe098, 0xe0ab, 0xe0be, 0xe0d1, 0xe0e4, 0xe0f7, 0xe10a,
	0xe11d, 0xe130, 0xe143, 0xe156, 0xe169, 0xe17c, 0xe18f, 0xe1a2,
	0xe1b5, 0xe1c8, 0xe1db, 0xe1ee, 0xe201, 0xe214, 0xe227, 0xe23a,
	0xe24d, 0xe260, 0xe273, 0xe286, 0xe299, 0xe2ac, 0xe2bf, 0xe2d2,
	0xe2e5, 0xe2f8, 0xe30b, 0xe321, 0xe334, 0xe347, 0xe35a, 0xe36d,
	// Entry 4540 - 457F
	0xe380, 0xe394, 0xe3a8, 0xe3bb, 0xe3ce, 0xe3e1, 0xe3f4, 0xe407,
	0xe41a, 0xe42c, 0xe43e, 0xe450, 0xe462, 0xe474, 0xe486, 0xe498,
	0xe4aa, 0xe4bd, 0xe4d0, 0xe4e3, 0xe4f5, 0xe507, 0xe519, 0xe52c,
	0xe53f, 0xe552, 0xe564, 0xe576, 0xe588, 0xe59a, 0xe5ac, 0xe5be,
	0xe5d0, 0xe5e2, 0xe5f4, 0xe606, 0xe618, 0xe62a, 0xe63c, 0xe64e,
	0xe660, 0xe672, 0xe684, 0xe696, 0xe6a8, 0xe6ba, 0xe6cc, 0xe6de,
	0xe6f0, 0xe702, 0xe714, 0xe726, 0xe738, 0xe74a, 0xe75c, 0xe76e,
	0xe780, 0xe792, 0xe7a4, 0xe7b6, 0xe7c8, 0xe7da, 0xe7ec, 0xe7fe,
	// Entry 4580 - 45BF
	0xe810, 0xe822, 0xe834, 0xe846, 0xe858, 0xe86a, 0xe87c, 0xe88e,
	0xe8a0, 0xe8b2, 0xe8c4, 0xe8d6, 0xe8e8, 0xe8fa, 0xe90c, 0xe91e,
	0xe930, 0xe942, 0xe954, 0xe966, 0xe97c, 0xe992, 0xe9a8, 0xe9be,
	0xe9d4, 0xe9ea, 0xea00, 0xea16, 0xea2c, 0xea42, 0xea58, 0xea6e,
	0xea84, 0xea9a, 0xeab0, 0xeac6, 0xeadc, 0xeaf2, 0xeb08, 0xeb1a,
	0xeb2c, 0xeb3e, 0xeb50, 0xeb62, 0xeb74, 0xeb86, 0xeb98, 0xebaa,
	0xebbc, 0xebce, 0xebe0, 0xebf2, 0xec04, 0xec16, 0xec28, 0xec3a,
	0xec4c, 0xec5e, 0xec70, 0xec82, 0xec94, 0xeca6, 0xecb8, 0xecca,
	// Entry 45C0 - 45FF
	0xecdc, 0xecee, 0xed00, 0xed12, 0xed24, 0xed36, 0xed48, 0xed5a,
	0xed6c, 0xed7e, 0xed90, 0xeda2, 0xedb4, 0xedc6, 0xedd8, 0xedea,
	0xedfc, 0xee0e, 0xee20, 0xee32, 0xee44, 0xee56, 0xee68, 0xee7a,
	0xee8c, 0xee9e, 0xeeb0, 0xeec2, 0xeed4, 0xeee6, 0xeef8, 0xef0a,
	0xef1c, 0xef2e, 0xef40, 0xef52, 0xef64, 0xef76, 0xef88, 0xef9a,
	0xefac, 0xefbe, 0xefd0, 0xefe2, 0xeff4, 0xf006, 0xf018, 0xf02a,
	0xf03c, 0xf04e, 0xf060, 0xf072, 0xf084, 0xf096, 0xf0a8, 0xf0ba,
	0xf0cc, 0xf0de, 0xf0f0, 0xf102, 0xf114, 0xf126, 0xf138, 0xf14a,
	// Entry 4600 - 463F
	0xf15c, 0xf16e, 0xf180, 0xf192, 0xf1a4, 0xf1b6, 0xf1c8, 0xf1da,
	0xf1ec, 0xf1fe, 0xf210, 0xf222, 0xf234, 0xf246, 0xf258, 0xf26a,
	0xf27c, 0xf28e, 0xf2a0, 0xf2b2, 0xf2c4, 0xf2d6, 0xf2e8, 0xf2fa,
	0xf30c, 0xf31e, 0xf330, 0xf342, 0xf354, 0xf366, 0xf378, 0xf38a,
	0xf39c, 0xf3ae, 0xf3c0, 0xf3d2, 0xf3e4, 0xf3f6, 0xf408, 0xf41a,
	0xf42c, 0xf43e, 0xf450, 0xf464, 0xf478, 0xf48c, 0xf4a0, 0xf4b4,
	0xf4c8, 0xf4dc, 0xf4f0, 0xf504, 0xf51b, 0xf532, 0xf549, 0xf560,
	0xf574, 0xf588, 0xf59c, 0xf5b4, 0xf5ca, 0xf5df, 0xf5f4, 0xf60b,
	// Entry 4640 - 467F
	0xf620, 0xf632, 0xf644, 0xf656, 0xf668, 0xf67a, 0xf68c, 0xf69e,
	0xf6b0, 0xf6c2, 0xf6d4, 0xf6e6, 0xf6f8, 0xf70a, 0xf71d, 0xf730,
	0xf743, 0xf756, 0xf769, 0xf77c, 0xf78f, 0xf7a2, 0xf7b5, 0xf7c8,
	0xf7db, 0xf7ee, 0xf801, 0xf814, 0xf827, 0xf83a, 0xf84d, 0xf860,
	0xf873, 0xf886, 0xf899, 0xf8ac, 0xf8bf, 0xf8d2, 0xf8e5, 0xf8f8,
	0xf90b, 0xf91e, 0xf931, 0xf944, 0xf957, 0xf96a, 0xf97d, 0xf990,
	0xf9a3, 0xf9b6, 0xf9c9, 0xf9dc, 0xf9ef, 0xfa02, 0xfa15, 0xfa28,
	0xfa3b, 0xfa4e, 0xfa61, 0xfa74, 0xfa87, 0xfa9a, 0xfaad, 0xfac0,
	// Entry 4680 - 46BF
	0xfadd, 0xfaf9, 0xfb16, 0xfb34, 0xfb4e, 0xfb69, 0xfb86, 0xfba2,
	0xfbbe, 0xfbda, 0xfbf6, 0xfc14, 0xfc2f, 0xfc4a, 0xfc68, 0xfc84,
	0xfc9e, 0xfcbb, 0xfcd7, 0xfcf3, 0xfd0f, 0xfd2a, 0xfd47, 0xfd62,
	0xfd7d, 0xfd9a, 0xfdb5, 0xfdd3, 0xfdf6, 0xfe1a, 0xfe3e, 0xfe54,
	0xfe69, 0xfe7f, 0xfe96, 0xfea9, 0xfebd, 0xfed3, 0xfee8, 0xfefd,
	0xff12, 0xff27, 0xff3e, 0xff52, 0xff6c, 0xff80, 0xff97, 0xffac,
	0xffbf, 0xffd5, 0xffea, 0xffff, 0x0014, 0x0028, 0x0047, 0x0067,
	0x007b, 0x008f, 0x00a5, 0x00ba, 0x00cf, 0x00e3, 0x00fa, 0x0116,
	// Entry 46C0 - 46FF
	0x012c, 0x0147, 0x015c, 0x0172, 0x0189, 0x01a2, 0x01b5, 0x01c9,
	0x01df, 0x01f4, 0x0209, 0x0224, 0x0239, 0x0254, 0x0269, 0x0286,
	0x029d, 0x02b7, 0x02cb, 0x02e5, 0x02f9, 0x0310, 0x0325, 0x0338,
	0x034e, 0x0363, 0x0378, 0x0393, 0x03a8, 0x03bc, 0x03d0, 0x03e4,
	0x03fa, 0x040f, 0x042e, 0x0443, 0x0457, 0x046e, 0x048a, 0x049d,
	0x04af, 0x04c2, 0x04db, 0x04eb, 0x04fc, 0x050e, 0x0520, 0x0532,
	0x0544, 0x0556, 0x056a, 0x057b, 0x058c, 0x05a0, 0x05b1, 0x05c1,
	0x05d4, 0x05e6, 0x05f8, 0x0609, 0x061a, 0x062c, 0x063d, 0x0651,
	// Entry 4700 - 473F
	0x066a, 0x067f, 0x0694, 0x06aa, 0x06c0, 0x06d4, 0x06e9, 0x06fe,
	0x0713, 0x0728, 0x073d, 0x0752, 0x0768, 0x077d, 0x0792, 0x07a8,
	0x07bd, 0x07d1, 0x07e7, 0x07fc, 0x0812, 0x0828, 0x083d, 0x0852,
	0x0867, 0x087f, 0x089c, 0x08b1, 0x08c8, 0x08e1, 0x08f0, 0x08ff,
	0x090e, 0x091d, 0x092c, 0x093b, 0x094a, 0x0959, 0x0968, 0x0977,
	0x0986, 0x0995, 0x09a4, 0x09b3, 0x09c3, 0x09d2, 0x09e1, 0x09f0,
	0x09ff, 0x0a0e, 0x0a1e, 0x0a2e, 0x0a3e, 0x0a4e, 0x0a5e, 0x0a6d,
	0x0a83, 0x0aa1, 0x0abf, 0x0add, 0x0afb, 0x0b1a, 0x0b39, 0x0b58,
	// Entry 4740 - 477F
	0x0b79, 0x0b98, 0x0bb7, 0x0bd6, 0x0bf7, 0x0c16, 0x0c37, 0x0c56,
	0x0c77, 0x0c96, 0x0cb6, 0x0cd6, 0x0cf5, 0x0d16, 0x0d35, 0x0d54,
	0x0d73, 0x0d92, 0x0db3, 0x0dd2, 0x0df3, 0x0e12, 0x0e31, 0x0e52,
	0x0e75, 0x0e8e, 0x0ea7, 0x0ec0, 0x0ed9, 0x0ef3, 0x0f0d, 0x0f27,
	0x0f41, 0x0f5b, 0x0f75, 0x0f8f, 0x0fa9, 0x0fc3, 0x0fde, 0x0ff9,
	0x1013, 0x1035, 0x104f, 0x1069, 0x1083, 0x109d, 0x10b7, 0x10d1,
	0x10eb, 0x1114, 0x1136, 0x1153, 0x1170, 0x118b, 0x11a6, 0x11c3,
	0x11df, 0x11fb, 0x1216, 0x1233, 0x1250, 0x126c, 0x1287, 0x12a5,
	// Entry 4780 - 47BF
	0x12c3, 0x12e0, 0x12fd, 0x131a, 0x1339, 0x135c, 0x137f, 0x13a4,
	0x13c8, 0x13ec, 0x140f, 0x1434, 0x1459, 0x147d, 0x14a1, 0x14c5,
	0x14eb, 0x1510, 0x1535, 0x1559, 0x157f, 0x15a5, 0x15ca, 0x15ee,
	0x1615, 0x163c, 0x1662, 0x1688, 0x16ae, 0x16d6, 0x16fd, 0x1724,
	0x1750, 0x177c, 0x17aa, 0x17d7, 0x1804, 0x1830, 0x185e, 0x188c,
	0x18b9, 0x18de, 0x1904, 0x192c, 0x1953, 0x197a, 0x19a0, 0x19c8,
	0x19f0, 0x1a17, 0x1a3d, 0x1a50, 0x1a67, 0x1a7e, 0x1a9d, 0x1ab4,
	0x1acb, 0x1ae7, 0x1b08, 0x1b20, 0x1b37, 0x1b4b, 0x1b60, 0x1b74,
	// Entry 47C0 - 47FF
	0x1b89, 0x1b9d, 0x1bb2, 0x1bc6, 0x1bdb, 0x1bf0, 0x1c06, 0x1c1b,
	0x1c31, 0x1c46, 0x1c5a, 0x1c6f, 0x1c83, 0x1c98, 0x1cac, 0x1cc0,
	0x1cd5, 0x1ce9, 0x1cfe, 0x1d12, 0x1d26, 0x1d3a, 0x1d4e, 0x1d62,
	0x1d77, 0x1d8c, 0x1da0, 0x1db4, 0x1dc8, 0x1ddd, 0x1df4, 0x1e0a,
	0x1e1f, 0x1e38, 0x1e4d, 0x1e66, 0x1e77, 0x1e8b, 0x1e9f, 0x1eb5,
	0x1eca, 0x1edf, 0x1ef7, 0x1f14, 0x1f32, 0x1f4e, 0x1f68, 0x1f8b,
	0x1fa8, 0x1fcb, 0x1fea, 0x2006, 0x2022, 0x2045, 0x2061, 0x207c,
	0x209b, 0x20b8, 0x20d4, 0x20f1, 0x210d, 0x212a, 0x2147, 0x2164,
	// Entry 4800 - 483F
	0x2180, 0x219c, 0x21b9, 0x21d5, 0x21f3, 0x2211, 0x2230, 0x224b,
	0x2268, 0x2284, 0x22a3, 0x22c1, 0x22e0, 0x22fe, 0x231b, 0x2338,
	0x2358, 0x2375, 0x2392, 0x23b0, 0x23cc, 0x23ea, 0x240d, 0x2429,
	0x2445, 0x2461, 0x247e, 0x249a, 0x24b6, 0x24d3, 0x24ef, 0x250b,
	0x2527, 0x2544, 0x2560, 0x257d, 0x259a, 0x25b6, 0x25d3, 0x25ef,
	0x260c, 0x2628, 0x2644, 0x2661, 0x267d, 0x269b, 0x26b7, 0x26d4,
	0x26f1, 0x270d, 0x272a, 0x2746, 0x2762, 0x277e, 0x279d, 0x27b4,
	0x27ca, 0x27e1, 0x27f8, 0x2810, 0x2828, 0x283c, 0x2851, 0x2863,
	// Entry 4840 - 487F
	0x287a, 0x2892, 0x28a9, 0x28c1, 0x28d7, 0x28ed, 0x2903, 0x2919,
	0x292f, 0x2946, 0x295e, 0x2977, 0x2990, 0x29a5, 0x29ba, 0x29d2,
	0x29e8, 0x29ff, 0x2a13, 0x2a27, 0x2a3e, 0x2a54, 0x2a6a, 0x2a81,
	0x2a97, 0x2aad, 0x2ac4, 0x2ad9, 0x2afb, 0x2b1d, 0x2b32, 0x2b48,
	0x2b5d, 0x2b75, 0x2b92, 0x2bad, 0x2bcb, 0x2bf7, 0x2c1c, 0x2c36,
	0x2c55, 0x2c77, 0x2c87, 0x2c98, 0x2ca9, 0x2cbb, 0x2ccc, 0x2cde,
	0x2cef, 0x2d01, 0x2d11, 0x2d22, 0x2d32, 0x2d43, 0x2d53, 0x2d64,
	0x2d74, 0x2d85, 0x2d96, 0x2da7, 0x2db9, 0x2dcb, 0x2ddc, 0x2dee,
	// Entry 4880 - 48BF
	0x2e00, 0x2e11, 0x2e22, 0x2e33, 0x2e45, 0x2e56, 0x2e68, 0x2e7a,
	0x2e8b, 0x2e9c, 0x2ead, 0x2ebf, 0x2ed1, 0x2ee4, 0x2ef7, 0x2f08,
	0x2f1a, 0x2f2c, 0x2f3d, 0x2f4f, 0x2f61, 0x2f72, 0x2f83, 0x2f94,
	0x2fa5, 0x2fb6, 0x2fc7, 0x2fd9, 0x2feb, 0x2ffe, 0x3011, 0x3022,
	0x303b, 0x3061, 0x3088, 0x30af, 0x30d6, 0x30ff, 0x3128, 0x314b,
	0x316d, 0x3190, 0x31b4, 0x31d4, 0x31f5, 0x3218, 0x323a, 0x325c,
	0x327e, 0x32a0, 0x32c4, 0x32e5, 0x3306, 0x332a, 0x334c, 0x336c,
	0x338f, 0x33b1, 0x33d3, 0x33f5, 0x3416, 0x3437, 0x3458, 0x347b,
	// Entry 48C0 - 48FF
	0x349d, 0x34be, 0x34e2, 0x350b, 0x3535, 0x3557, 0x3578, 0x359a,
	0x35bd, 0x35dc, 0x3606, 0x3628, 0x3649, 0x366a, 0x368b, 0x36ac,
	0x36cf, 0x36f4, 0x3714, 0x3737, 0x3756, 0x3778, 0x3799, 0x37b9,
	0x37d9, 0x37f9, 0x381b, 0x383c, 0x385c, 0x387f, 0x38a7, 0x38d0,
	0x38ec, 0x3907, 0x3923, 0x3940, 0x3959, 0x397d, 0x3999, 0x39b4,
	0x39cf, 0x39ea, 0x3a07, 0x3a26, 0x3a40, 0x3a5d, 0x3a76, 0x3a92,
	0x3aad, 0x3ac7, 0x3ae3, 0x3b06, 0x3b2a, 0x3b4c, 0x3b66, 0x3b80,
	0x3b9c, 0x3bb7, 0x3bd1, 0x3bee, 0x3c10, 0x3c2a, 0x3c45, 0x3c61,
	// Entry 4900 - 493F
	0x3c7b, 0x3c96, 0x3cb1, 0x3ccb, 0x3ce6, 0x3d02, 0x3d1d, 0x3d39,
	0x3d55, 0x3d72, 0x3d8d, 0x3da9, 0x3dc5, 0x3de2, 0x3dfd, 0x3e19,
	0x3e35, 0x3e50, 0x3e6c, 0x3e87, 0x3ea3, 0x3ebf, 0x3edc, 0x3ef8,
	0x3f15, 0x3f31, 0x3f4e, 0x3f69, 0x3f85, 0x3fa1, 0x3fbd, 0x3fd8,
	0x3ff3, 0x400f, 0x402c, 0x4048, 0x4065, 0x4081, 0x409e, 0x40ba,
	0x40d7, 0x40f4, 0x4110, 0x412e, 0x4149, 0x4164, 0x417f, 0x419a,
	0x41b6, 0x41d1, 0x41ed, 0x4208, 0x4224, 0x423f, 0x425b, 0x4276,
	0x4292, 0x42ae, 0x42c9, 0x42e5, 0x4301, 0x431e, 0x433a, 0x4357,
	// Entry 4940 - 497F
	0x4372, 0x438e, 0x43aa, 0x43c7, 0x43e2, 0x43ff, 0x441d, 0x443c,
	0x445b, 0x447b, 0x449a, 0x44ba, 0x44da, 0x44f9, 0x4519, 0x4537,
	0x455b, 0x457a, 0x4599, 0x45b8, 0x45d8, 0x45f7, 0x4615, 0x4634,
	0x4653, 0x4672, 0x4691, 0x46b1, 0x46d0, 0x46f0, 0x470f, 0x472e,
	0x474e, 0x476c, 0x478b, 0x47b5, 0x47de, 0x47fe, 0x481d, 0x483d,
	0x485c, 0x4881, 0x48a0, 0x48c0, 0x48df, 0x48ff, 0x491f, 0x493f,
	0x495d, 0x497c, 0x49a6, 0x49cf, 0x49ee, 0x4a0d, 0x4a2d, 0x4a59,
	0x4a78, 0x4a94, 0x4ab1, 0x4ace, 0x4aec, 0x4b09, 0x4b27, 0x4b45,
	// Entry 4980 - 49BF
	0x4b62, 0x4b80, 0x4b9c, 0x4bbe, 0x4bdb, 0x4bf8, 0x4c15, 0x4c33,
	0x4c50, 0x4c6c, 0x4c89, 0x4ca6, 0x4cc3, 0x4ce0, 0x4cfe, 0x4d1b,
	0x4d39, 0x4d56, 0x4d73, 0x4d91, 0x4dad, 0x4dca, 0x4df2, 0x4e19,
	0x4e37, 0x4e54, 0x4e72, 0x4e8f, 0x4eb2, 0x4ecf, 0x4eed, 0x4f0a,
	0x4f28, 0x4f46, 0x4f64, 0x4f80, 0x4f9d, 0x4fc5, 0x4fec, 0x5009,
	0x5026, 0x5044, 0x506e, 0x508b, 0x50a3, 0x50bc, 0x50d4, 0x50ee,
	0x510e, 0x512f, 0x5147, 0x5160, 0x5179, 0x5192, 0x51ac, 0x51c5,
	0x51de, 0x51f7, 0x5211, 0x522a, 0x5243, 0x525d, 0x5276, 0x5290,
	// Entry 49C0 - 49FF
	0x52a9, 0x52c2, 0x52dc, 0x52f5, 0x530e, 0x5327, 0x5340, 0x5359,
	0x5372, 0x5391, 0x53aa, 0x53c9, 0x53e3, 0x53fd, 0x5416, 0x542d,
	0x5444, 0x545b, 0x5472, 0x5489, 0x54a3, 0x54c1, 0x54de, 0x54f9,
	0x5512, 0x552c, 0x5546, 0x555f, 0x5578, 0x5593, 0x55ad, 0x55c7,
	0x55e0, 0x55fb, 0x5616, 0x5630, 0x563e, 0x564c, 0x565c, 0x566b,
	0x567a, 0x5688, 0x5698, 0x56a8, 0x56b7, 0x56c6, 0x56d8, 0x56ea,
	0x56fb, 0x570c, 0x571d, 0x5730, 0x5742, 0x5754, 0x576b, 0x5782,
	0x579b, 0x57b3, 0x57cb, 0x57e2, 0x57fb, 0x5814, 0x582c, 0x5842,
	// Entry 4A00 - 4A3F
	0x585b, 0x5872, 0x588a, 0x58a2, 0x58c0, 0x58d7, 0x58f4, 0x590c,
	0x5921, 0x593c, 0x5952, 0x596a, 0x5981, 0x5998, 0x59af, 0x59c8,
	0x59de, 0x59f4, 0x5a10, 0x5a3f, 0x5a58, 0x5a6f, 0x5a90, 0x5aa5,
	0x5abd, 0x5adb, 0x5b0c, 0x5b2f, 0x5b46, 0x5b5c, 0x5b78, 0x5ba7,
	0x5bbd, 0x5bd3, 0x5beb, 0x5c02, 0x5c19, 0x5c2f, 0x5c48, 0x5c61,
	0x5c7f, 0x5c9c, 0x5cbc, 0x5cd0, 0x5ce3, 0x5cf7, 0x5d08, 0x5d1a,
	0x5d2e, 0x5d41, 0x5d54, 0x5d67, 0x5d7c, 0x5d8e, 0x5da0, 0x5db5,
	0x5dc8, 0x5dd9, 0x5ded, 0x5e05, 0x5e18, 0x5e2a, 0x5e3d, 0x5e50,
	// Entry 4A40 - 4A7F
	0x5e68, 0x5e83, 0x5ea3, 0x5ebe, 0x5ede, 0x5efb, 0x5f18, 0x5f34,
	0x5f50, 0x5f71, 0x5f8d, 0x5fab, 0x5fbd, 0x5fcf, 0x5fe4, 0x5ffe,
	0x6023, 0x6052, 0x6075, 0x609e, 0x60c6, 0x60dd, 0x60f1, 0x6104,
	0x611b, 0x6132, 0x6141, 0x6151, 0x6160, 0x6170, 0x617f, 0x618f,
	0x61a6, 0x61be, 0x61d5, 0x61ed, 0x61fc, 0x620c, 0x621b, 0x622b,
	0x623b, 0x624c, 0x625c, 0x626d, 0x627e, 0x628e, 0x629f, 0x62af,
	0x62c0, 0x62d1, 0x62e2, 0x62f4, 0x6305, 0x6317, 0x6328, 0x6338,
	0x6349, 0x6359, 0x636a, 0x637a, 0x638a, 0x639b, 0x63ab, 0x63bc,
	// Entry 4A80 - 4ABF
	0x63cc, 0x63dc, 0x63ec, 0x63fc, 0x640c, 0x641d, 0x642e, 0x643e,
	0x644e, 0x645f, 0x647b, 0x6496, 0x64b2, 0x64c6, 0x64e6, 0x64f9,
	0x650d, 0x6520, 0x6534, 0x654f, 0x656b, 0x6586, 0x65a2, 0x65b5,
	0x65c9, 0x65dc, 0x65f0, 0x65fd, 0x6609, 0x661c, 0x6632, 0x664f,
	0x6666, 0x6685, 0x669d, 0x66ae, 0x66bf, 0x66d2, 0x66e4, 0x66f6,
	0x6707, 0x671a, 0x672d, 0x673f, 0x6750, 0x6764, 0x6778, 0x678b,
	0x679e, 0x67b1, 0x67c6, 0x67da, 0x67ee, 0x6807, 0x6821, 0x6832,
	0x6842, 0x6852, 0x6864, 0x6875, 0x6886, 0x6896, 0x68a8, 0x68ba,
	// Entry 4AC0 - 4AFF
	0x68cb, 0x68df, 0x68f6, 0x690a, 0x691d, 0x692c, 0x693c, 0x694b,
	0x695b, 0x696a, 0x697a, 0x6989, 0x6999, 0x69a8, 0x69b8, 0x69c8,
	0x69d9, 0x69e9, 0x69fa, 0x6a0b, 0x6a1b, 0x6a2c, 0x6a3c, 0x6a4d,
	0x6a5e, 0x6a6f, 0x6a81, 0x6a92, 0x6aa5, 0x6ab7, 0x6ac8, 0x6ad9,
	0x6ae9, 0x6afa, 0x6b0a, 0x6b1b, 0x6b2b, 0x6b3b, 0x6b4c, 0x6b5c,
	0x6b6d, 0x6b7d, 0x6b8d, 0x6b9d, 0x6bad, 0x6bbd, 0x6bce, 0x6bdf,
	0x6bef, 0x6bff, 0x6c13, 0x6c26, 0x6c3a, 0x6c4d, 0x6c61, 0x6c74,
	0x6c88, 0x6c9b, 0x6caf, 0x6cc1, 0x6cd2, 0x6cea, 0x6d01, 0x6d13,
	// Entry 4B00 - 4B3F
	0x6d26, 0x6d40, 0x6d4c, 0x6d5f, 0x6d77, 0x6d8e, 0x6da5, 0x6dbc,
	0x6dd3, 0x6dea, 0x6e01, 0x6e18, 0x6e30, 0x6e47, 0x6e5e, 0x6e75,
	0x6e8c, 0x6ea3, 0x6eba, 0x6ed1, 0x6ee8, 0x6eff, 0x6f17, 0x6f2d,
	0x6f44, 0x6f5a, 0x6f70, 0x6f86, 0x6f9c, 0x6fb3, 0x6fca, 0x6fe0,
	0x6ff6, 0x700e, 0x7025, 0x703c, 0x7052, 0x706a, 0x7082, 0x7099,
	0x70b0, 0x70c4, 0x70d7, 0x70e7, 0x70f6, 0x7105, 0x7114, 0x7125,
	0x7137, 0x7148, 0x715a, 0x716c, 0x717d, 0x718f, 0x71a0, 0x71b2,
	0x71c4, 0x71d6, 0x71e9, 0x71fb, 0x720e, 0x7220, 0x7231, 0x7243,
	// Entry 4B40 - 4B7F
	0x7254, 0x7266, 0x7277, 0x7288, 0x729a, 0x72ab, 0x72bd, 0x72ce,
	0x72e0, 0x72f1, 0x7302, 0x7313, 0x7324, 0x7335, 0x7346, 0x7359,
	0x736c, 0x7380, 0x7393, 0x73a7, 0x73ba, 0x73ce, 0x73e1, 0x73f5,
	0x7409, 0x7416, 0x7424, 0x7431, 0x743f, 0x7450, 0x7460, 0x7470,
	0x7482, 0x7493, 0x74a4, 0x74b4, 0x74c6, 0x74d8, 0x74e9, 0x74fc,
	0x7508, 0x751b, 0x752f, 0x7541, 0x7555, 0x7569, 0x757a, 0x758b,
	0x759c, 0x75ad, 0x75be, 0x75d0, 0x75e3, 0x75f5, 0x7608, 0x761a,
	0x762d, 0x763f, 0x7652, 0x7665, 0x7678, 0x768c, 0x769f, 0x76b3,
	// Entry 4B80 - 4BBF
	0x76c6, 0x76d8, 0x76eb, 0x76fd, 0x7710, 0x7722, 0x7734, 0x7747,
	0x7759, 0x776c, 0x777e, 0x7790, 0x77a2, 0x77b4, 0x77c6, 0x77d8,
	0x77eb, 0x77fe, 0x7818, 0x782d, 0x7843, 0x785b, 0x7870, 0x7884,
	0x7894, 0x78a5, 0x78b5, 0x78c6, 0x78d6, 0x78e7, 0x78ff, 0x7918,
	0x7930, 0x7949, 0x7959, 0x796a, 0x797a, 0x798b, 0x799c, 0x79ae,
	0x79bf, 0x79d1, 0x79e3, 0x79f4, 0x7a06, 0x7a17, 0x7a29, 0x7a3b,
	0x7a4d, 0x7a60, 0x7a72, 0x7a85, 0x7a97, 0x7aa8, 0x7aba, 0x7acb,
	0x7add, 0x7aee, 0x7aff, 0x7b11, 0x7b22, 0x7b34, 0x7b45, 0x7b56,
	// Entry 4BC0 - 4BFF
	0x7b67, 0x7b78, 0x7b8a, 0x7b9b, 0x7bad, 0x7bbf, 0x7bd0, 0x7be1,
	0x7bf6, 0x7c0a, 0x7c1f, 0x7c33, 0x7c48, 0x7c64, 0x7c81, 0x7c9d,
	0x7cba, 0x7cce, 0x7ce3, 0x7cf7, 0x7d0c, 0x7d1f, 0x7d34, 0x7d4c,
	0x7d64, 0x7d6e, 0x7d7b, 0x7d8f, 0x7da8, 0x7db9, 0x7dcc, 0x7dde,
	0x7df9, 0x7e17, 0x7e29, 0x7e3b, 0x7e4c, 0x7e5d, 0x7e70, 0x7e82,
	0x7e94, 0x7ea5, 0x7eb8, 0x7ecb, 0x7edd, 0x7ee9, 0x7efd, 0x7f0f,
	0x7f28, 0x7f3e, 0x7f54, 0x7f6d, 0x7f86, 0x7fa1, 0x7fbb, 0x7fd5,
	0x7fee, 0x8009, 0x8024, 0x803e, 0x8058, 0x8075, 0x8092, 0x80ae,
	// Entry 4C00 - 4C3F
	0x80ca, 0x80e6, 0x8104, 0x8121, 0x813e, 0x8160, 0x8183, 0x8192,
	0x81a2, 0x81b1, 0x81c0, 0x81cf, 0x81df, 0x81ee, 0x81fe, 0x820e,
	0x821f, 0x822f, 0x8240, 0x8251, 0x8262, 0x8272, 0x8283, 0x8293,
	0x82a4, 0x82b5, 0x82c6, 0x82d8, 0x82e9, 0x82fb, 0x830c, 0x831c,
	0x832d, 0x833d, 0x834f, 0x8360, 0x8370, 0x8380, 0x8391, 0x83a1,
	0x83b2, 0x83c3, 0x83d3, 0x83e3, 0x83f3, 0x8403, 0x8413, 0x8423,
	0x8433, 0x8444, 0x8458, 0x846b, 0x847f, 0x8492, 0x84a5, 0x84b9,
	0x84cc, 0x84e0, 0x84f4, 0x8506, 0x8517, 0x8529, 0x8535, 0x8548,
	// Entry 4C40 - 4C7F
	0x855d, 0x8570, 0x858a, 0x85a2, 0x85b3, 0x85c3, 0x85d3, 0x85e3,
	0x85f3, 0x8604, 0x8616, 0x8627, 0x8639, 0x864a, 0x865c, 0x866d,
	0x867f, 0x8691, 0x86a3, 0x86b6, 0x86c8, 0x86db, 0x86ee, 0x8700,
	0x8711, 0x8723, 0x8734, 0x8746, 0x8757, 0x8768, 0x877a, 0x878b,
	0x879d, 0x87ae, 0x87bf, 0x87d0, 0x87e1, 0x87f2, 0x8803, 0x8814,
	0x8826, 0x8838, 0x884c, 0x885e, 0x8871, 0x8883, 0x8896, 0x88a8,
	0x88bb, 0x88cd, 0x88e0, 0x88f2, 0x8905, 0x8918, 0x892c, 0x893f,
	0x8953, 0x8967, 0x897b, 0x898e, 0x89a2, 0x89b5, 0x89c9, 0x89dd,
	// Entry 4C80 - 4CBF
	0x89f1, 0x8a05, 0x8a1a, 0x8a2e, 0x8a43, 0x8a57, 0x8a6c, 0x8a80,
	0x8a93, 0x8aa7, 0x8aba, 0x8ace, 0x8ae1, 0x8af4, 0x8b08, 0x8b1b,
	0x8b2f, 0x8b43, 0x8b56, 0x8b69, 0x8b7c, 0x8b8f, 0x8ba2, 0x8bb6,
	0x8bc9, 0x8bdc, 0x8bf3, 0x8c0a, 0x8c20, 0x8c37, 0x8c4d, 0x8c64,
	0x8c7a, 0x8c91, 0x8ca7, 0x8cbe, 0x8cd2, 0x8ce7, 0x8cfb, 0x8d0e,
	0x8d21, 0x8d36, 0x8d4a, 0x8d5e, 0x8d71, 0x8d86, 0x8d9b, 0x8daf,
	0x8dd4, 0x8dec, 0x8e01, 0x8e15, 0x8e25, 0x8e36, 0x8e46, 0x8e57,
	0x8e67, 0x8e78, 0x8e90, 0x8ea8, 0x8eb9, 0x8eca, 0x8edb, 0x8eec,
	// Entry 4CC0 - 4CFF
	0x8efd, 0x8f0f, 0x8f20, 0x8f32, 0x8f44, 0x8f55, 0x8f67, 0x8f78,
	0x8f8a, 0x8f9c, 0x8fae, 0x8fc1, 0x8fd3, 0x8fe6, 0x8ff8, 0x9009,
	0x901b, 0x902c, 0x903e, 0x904f, 0x9060, 0x9072, 0x9083, 0x9095,
	0x90a6, 0x90b7, 0x90c8, 0x90d9, 0x90eb, 0x90fc, 0x910e, 0x9120,
	0x9131, 0x9142, 0x9157, 0x9169, 0x917e, 0x9193, 0x91a7, 0x91bc,
	0x91d0, 0x91e5, 0x9201, 0x921e, 0x9233, 0x9248, 0x925d, 0x9272,
	0x9285, 0x928f, 0x92a5, 0x92b7, 0x92d4, 0x92f8, 0x9311, 0x932a,
	0x9346, 0x9363, 0x937f, 0x939a, 0x93b5, 0x93d2, 0x93ee, 0x940a,
	// Entry 4D00 - 4D3F
	0x9425, 0x943f, 0x945a, 0x9475, 0x9490, 0x94ab, 0x94b8, 0x94c6,
	0x94d3, 0x94e1, 0x94ee, 0x94fc, 0x9511, 0x9527, 0x953c, 0x9552,
	0x955f, 0x956d, 0x957a, 0x9588, 0x9596, 0x95a5, 0x95b3, 0x95c2,
	0x95d1, 0x95e1, 0x95ef, 0x95fe, 0x960c, 0x961b, 0x962a, 0x963a,
	0x9649, 0x9659, 0x9668, 0x9678, 0x9687, 0x9695, 0x96a4, 0x96b2,
	0x96c1, 0x96cf, 0x96de, 0x96ec, 0x96fb, 0x9709, 0x9718, 0x9726,
	0x9735, 0x9743, 0x9751, 0x9760, 0x976e, 0x977d, 0x978b, 0x979a,
	0x97a9, 0x97b7, 0x97c5, 0x97d7, 0x97e8, 0x97fa, 0x980b, 0x981d,
	// Entry 4D40 - 4D7F
	0x9836, 0x9850, 0x9869, 0x9883, 0x9894, 0x98a6, 0x98b7, 0x98c9,
	0x98d9, 0x98ee, 0x9900, 0x9911, 0x9920, 0x9932, 0x994a, 0x9951,
	0x995c, 0x9966, 0x9977, 0x9981, 0x9990, 0x99a6, 0x99b5, 0x99c3,
	0x99d1, 0x99e1, 0x99f0, 0x99ff, 0x9a0d, 0x9a1d, 0x9a2d, 0x9a3c,
	0x9a51, 0x9a64, 0x9a74, 0x9a80, 0x9a90, 0x9aa1, 0x9ab1, 0x9ac2,
	0x9ad2, 0x9ae3, 0x9afb, 0x9b14, 0x9b2c, 0x9b45, 0x9b55, 0x9b66,
	0x9b76, 0x9b87, 0x9b98, 0x9baa, 0x9bbb, 0x9bcd, 0x9bdf, 0x9bf0,
	0x9c02, 0x9c13, 0x9c25, 0x9c37, 0x9c49, 0x9c5c, 0x9c6e, 0x9c81,
	// Entry 4D80 - 4DBF
	0x9c93, 0x9ca4, 0x9cb6, 0x9cc7, 0x9cd9, 0x9cea, 0x9cfb, 0x9d0d,
	0x9d1e, 0x9d30, 0x9d41, 0x9d52, 0x9d63, 0x9d74, 0x9d85, 0x9d97,
	0x9da9, 0x9dba, 0x9dcb, 0x9de0, 0x9df4, 0x9e09, 0x9e1d, 0x9e32,
	0x9e4e, 0x9e6b, 0x9e87, 0x9ea4, 0x9eb8, 0x9ed2, 0x9ee7, 0x9efb,
	0x9f15, 0x9f2a, 0x9f42, 0x9f57, 0x9f6b, 0x9f7e, 0x9f90, 0x9fa5,
	0x9fb2, 0x9fcb, 0x9fd5, 0x9fe7, 0x9ff8, 0xa009, 0xa01c, 0xa02e,
	0xa040, 0xa051, 0xa064, 0xa077, 0xa089, 0xa099, 0xa0aa, 0xa0ba,
	0xa0cb, 0xa0db, 0xa0ec, 0xa104, 0xa11d, 0xa135, 0xa14e, 0xa15e,
	// Entry 4DC0 - 4DFF
	0xa16f, 0xa17f, 0xa190, 0xa1a1, 0xa1b3, 0xa1c4, 0xa1d6, 0xa1e8,
	0xa1f9, 0xa20b, 0xa21c, 0xa22e, 0xa240, 0xa252, 0xa265, 0xa277,
	0xa28a, 0xa29c, 0xa2ad, 0xa2bf, 0xa2d0, 0xa2e2, 0xa2f3, 0xa304,
	0xa316, 0xa327, 0xa339, 0xa34a, 0xa35b, 0xa36c, 0xa37d, 0xa38e,
	0xa3a0, 0xa3b2, 0xa3c3, 0xa3d4, 0xa3e9, 0xa3fd, 0xa412, 0xa426,
	0xa43b, 0xa457, 0xa474, 0xa488, 0xa49d, 0xa4b1, 0xa4c6, 0xa4de,
	0xa4f3, 0xa507, 0xa51a, 0xa52c, 0xa540, 0xa54d, 0xa561, 0xa576,
	0xa58b, 0xa5a4, 0xa5bd, 0xa5d6, 0xa5ee, 0xa626, 0xa65c, 0xa68f,
	// Entry 4E00 - 4E3F
	0xa6c9, 0xa703, 0xa723, 0xa74d, 0xa777, 0xa7a1, 0xa7ce, 0xa7fa,
	0xa824, 0xa858, 0xa88d, 0xa8b4, 0xa8d9, 0xa8ff, 0xa919, 0xa937,
	0xa956, 0xa963, 0xa971, 0xa97e, 0xa98c, 0xa999, 0xa9a7, 0xa9bc,
	0xa9d2, 0xa9e7, 0xa9fd, 0xaa0a, 0xaa18, 0xaa25, 0xaa33, 0xaa41,
	0xaa50, 0xaa5e, 0xaa6d, 0xaa7c, 0xaa8a, 0xaa99, 0xaaa7, 0xaab6,
	0xaac5, 0xaad4, 0xaae4, 0xaaf3, 0xab03, 0xab12, 0xab20, 0xab2f,
	0xab3d, 0xab4c, 0xab5a, 0xab68, 0xab77, 0xab85, 0xab94, 0xaba2,
	0xabb0, 0xabbe, 0xabcc, 0xabda, 0xabe9, 0xabf8, 0xac06, 0xac14,
	// Entry 4E40 - 4E7F
	0xac23, 0xac35, 0xac46, 0xac58, 0xac69, 0xac7b, 0xac94, 0xacae,
	0xacc7, 0xace1, 0xacf2, 0xad04, 0xad15, 0xad27, 0xad39, 0xad4a,
	0xad5a, 0xad6f, 0xad79, 0xad8a, 0xada0, 0xadae, 0xadbd, 0xadcb,
	0xadd9, 0xade9, 0xadf8, 0xae07, 0xae15, 0xae25, 0xae35, 0xae44,
	0xae61, 0xae78, 0xae9c, 0xaec0, 0xaee4, 0xaf09, 0xaf35, 0xaf4d,
	0xaf7a, 0xaf8f, 0xafb2, 0xafdc, 0xb00d, 0xb01b, 0xb02a, 0xb038,
	0xb047, 0xb055, 0xb064, 0xb072, 0xb081, 0xb08f, 0xb09e, 0xb0ad,
	0xb0bd, 0xb0cc, 0xb0dc, 0xb0ec, 0xb0fb, 0xb10b, 0xb11a, 0xb12a,
	// Entry 4E80 - 4EBF
	0xb13a, 0xb14a, 0xb15b, 0xb16b, 0xb17c, 0xb18c, 0xb19b, 0xb1ab,
	0xb1ba, 0xb1ca, 0xb1d9, 0xb1e8, 0xb1f8, 0xb207, 0xb217, 0xb226,
	0xb235, 0xb244, 0xb253, 0xb262, 0xb272, 0xb281, 0xb290, 0xb2a0,
	0xb2b3, 0xb2c5, 0xb2d8, 0xb2ea, 0xb2fd, 0xb30f, 0xb322, 0xb334,
	0xb347, 0xb359, 0xb36c, 0xb37d, 0xb38d, 0xb39d, 0xb3ac, 0xb3bb,
	0xb3cc, 0xb3dc, 0xb3ec, 0xb3fb, 0xb40c, 0xb41d, 0xb42d, 0xb43b,
	0xb44a, 0xb459, 0xb467, 0xb475, 0xb48d, 0xb49b, 0xb4aa, 0xb4b8,
	0xb4c6, 0xb4d4, 0xb4e3, 0xb4f2, 0xb500, 0xb50e, 0xb51c, 0xb52b,
	// Entry 4EC0 - 4EFF
	0xb539, 0xb546, 0xb554, 0xb563, 0xb571, 0xb589, 0xb598, 0xb5a7,
	0xb5b6, 0xb5ce, 0xb5eb, 0xb608, 0xb62e, 0xb63f, 0xb651, 0xb662,
	0xb674, 0xb685, 0xb697, 0xb6a8, 0xb6ba, 0xb6cb, 0xb6dd, 0xb6ef,
	0xb6ff, 0xb70e, 0xb71c, 0xb72a, 0xb73a, 0xb749, 0xb758, 0xb766,
	0xb776, 0xb786, 0xb795, 0xb7a4, 0xb7b6, 0xb7cd, 0xb7de, 0xb7ed,
	0xb7fb, 0xb809, 0xb818, 0xb826, 0xb835, 0xb843, 0xb852, 0xb860,
	0xb86f, 0xb87d, 0xb88c, 0xb89b, 0xb8ab, 0xb8ba, 0xb8ca, 0xb8da,
	0xb8e9, 0xb8f9, 0xb908, 0xb918, 0xb928, 0xb938, 0xb949, 0xb959,
	// Entry 4F00 - 4F3F
	0xb96a, 0xb97a, 0xb989, 0xb999, 0xb9a8, 0xb9b8, 0xb9c7, 0xb9d6,
	0xb9e6, 0xb9f5, 0xba05, 0xba14, 0xba23, 0xba32, 0xba41, 0xba50,
	0xba60, 0xba70, 0xba7f, 0xba8e, 0xba9e, 0xbab1, 0xbac3, 0xbad6,
	0xbae8, 0xbafb, 0xbb15, 0xbb30, 0xbb42, 0xbb55, 0xbb67, 0xbb7a,
	0xbb8d, 0xbb9f, 0xbbb0, 0xbbc0, 0xbbd7, 0xbbf6, 0xbc12, 0xbc2f,
	0xbc4c, 0xbc69, 0xbc86, 0xbca3, 0xbcc0, 0xbcdc, 0xbcf8, 0xbd16,
	0xbd33, 0xbd50, 0xbd6e, 0xbd8c, 0xbda9, 0xbdc7, 0xbde5, 0xbe03,
	0xbe22, 0xbe3f, 0xbe5c, 0xbe79, 0xbe96, 0xbeb3, 0xbed2, 0xbef1,
	// Entry 4F40 - 4F7F
	0xbf10, 0xbf2e, 0xbf4d, 0xbf6b, 0xbf8a, 0xbfa7, 0xbfc1, 0xbfdc,
	0xbff7, 0xc012, 0xc02d, 0xc048, 0xc063, 0xc07d, 0xc097, 0xc0b3,
	0xc0ce, 0xc0e9, 0xc105, 0xc121, 0xc13c, 0xc158, 0xc174, 0xc190,
	0xc1ad, 0xc1c8, 0xc1e3, 0xc1fe, 0xc219, 0xc234, 0xc251, 0xc26e,
	0xc28b, 0xc2a7, 0xc2c4, 0xc2e0, 0xc2fd, 0xc313, 0xc328, 0xc33d,
	0xc354, 0xc36a, 0xc380, 0xc395, 0xc3ac, 0xc3c3, 0xc3d9, 0xc3ef,
	0xc408, 0xc421, 0xc439, 0xc451, 0xc469, 0xc483, 0xc49c, 0xc4b5,
	0xc4c3, 0xc4dc, 0xc4f9, 0xc517, 0xc534, 0xc551, 0xc56f, 0xc58c,
	// Entry 4F80 - 4FBF
	0xc5aa, 0xc5c8, 0xc5ee, 0xc610, 0xc62a, 0xc645, 0xc65f, 0xc67a,
	0xc695, 0xc6af, 0xc6ca, 0xc6e4, 0xc6ff, 0xc71a, 0xc736, 0xc751,
	0xc76d, 0xc788, 0xc7a2, 0xc7bd, 0xc7d7, 0xc7f2, 0xc80c, 0xc826,
	0xc841, 0xc85b, 0xc876, 0xc890, 0xc8ab, 0xc8c7, 0xc8e2, 0xc8fe,
	0xc919, 0xc933, 0xc94d, 0xc967, 0xc981, 0xc99b, 0xc9b5, 0xc9d0,
	0xc9eb, 0xca05, 0xca1f, 0xca3b, 0xca60, 0xca7c, 0xca9d, 0xcacc,
	0xcaf6, 0xcb14, 0xcb31, 0xcb5b, 0xcb83, 0xcbab, 0xcbd3, 0xcbfb,
	0xcc1d, 0xcc3f, 0xcc5a, 0xcc74, 0xcc95, 0xccb5, 0xcce4, 0xcd13,
	// Entry 4FC0 - 4FFF
	0xcd2d, 0xcd3d, 0xcd51, 0xcd66, 0xcd7a, 0xcd8e, 0xcda2, 0xcdb7,
	0xcdcc, 0xcde1, 0xcdfd, 0xce19, 0xce32, 0xce43, 0xce55, 0xce66,
	0xce78, 0xce8a, 0xce9b, 0xcead, 0xcebe, 0xced0, 0xcee2, 0xcef4,
	0xcf07, 0xcf19, 0xcf2c, 0xcf3e, 0xcf4f, 0xcf61, 0xcf72, 0xcf84,
	0xcf95, 0xcfa6, 0xcfb8, 0xcfc9, 0xcfdb, 0xcfec, 0xcffe, 0xd011,
	0xd023, 0xd035, 0xd046, 0xd057, 0xd068, 0xd079, 0xd08a, 0xd09b,
	0xd0ad, 0xd0bf, 0xd0d0, 0xd0e1, 0xd0f4, 0xd115, 0xd136, 0xd158,
	0xd179, 0xd197, 0xd1b5, 0xd1d4, 0xd1f2, 0xd210, 0xd22e, 0xd24c,
	// Entry 5000 - 503F
	0xd26a, 0xd288, 0xd2a7, 0xd2c5, 0xd2e4, 0xd2f9, 0xd30d, 0xd324,
	0xd335, 0xd347, 0xd358, 0xd370, 0xd382, 0xd3b6, 0xd3e3, 0xd406,
	0xd41d, 0xd434, 0xd449, 0xd45e, 0xd473, 0xd488, 0xd49d, 0xd4b2,
	0xd4c7, 0xd4dd, 0xd4f2, 0xd507, 0xd51d, 0xd532, 0xd547, 0xd55c,
	0xd571, 0xd587, 0xd59c, 0xd5b2, 0xd5c7, 0xd5dc, 0xd5f2, 0xd606,
	0xd61a, 0xd62e, 0xd642, 0xd656, 0xd66b, 0xd680, 0xd69a, 0xd6b4,
	0xd6ce, 0xd6e8, 0xd702, 0xd71c, 0xd736, 0xd751, 0xd76b, 0xd787,
	0xd79e, 0xd7bd, 0xd7df, 0xd7fc, 0xd821, 0xd83d, 0xd854, 0xd876,
	// Entry 5040 - 507F
	0xd893, 0xd8ad, 0xd8cd, 0xd8f2, 0xd912, 0xd933, 0xd94f, 0xd967,
	0xd98e, 0xd9b0, 0xd9ce, 0xd9e0, 0xd9f3, 0xda05, 0xda18, 0xda2a,
	0xda3d, 0xda57, 0xda72, 0xda8c, 0xda9e, 0xdab1, 0xdac3, 0xdad6,
	0xdae9, 0xdafd, 0xdb10, 0xdb24, 0xdb38, 0xdb4b, 0xdb5f, 0xdb72,
	0xdb86, 0xdb9a, 0xdbae, 0xdbc3, 0xdbd7, 0xdbec, 0xdc00, 0xdc13,
	0xdc27, 0xdc3a, 0xdc4e, 0xdc61, 0xdc74, 0xdc88, 0xdc9b, 0xdcaf,
	0xdcc2, 0xdcd5, 0xdce8, 0xdcfb, 0xdd0e, 0xdd22, 0xdd36, 0xdd49,
	0xdd5c, 0xdd73, 0xdd89, 0xdda0, 0xddb6, 0xddcd, 0xddeb, 0xde0a,
	// Entry 5080 - 50BF
	0xde28, 0xde3e, 0xde55, 0xde6b, 0xde82, 0xde9c, 0xdeb3, 0xdec9,
	0xdede, 0xdef5, 0xdf04, 0xdf1a, 0xdf32, 0xdf48, 0xdf5e, 0xdf72,
	0xdf85, 0xdf98, 0xdfad, 0xdfc1, 0xdfd5, 0xdfe8, 0xdffd, 0xe012,
	0xe026, 0xe03a, 0xe04e, 0xe064, 0xe079, 0xe08e, 0xe0a2, 0xe0b8,
	0xe0ce, 0xe0e3, 0xe0f7, 0xe10e, 0xe125, 0xe13b, 0xe151, 0xe167,
	0xe17f, 0xe196, 0xe1ad, 0xe1c9, 0xe1da, 0xe1eb, 0xe1fc, 0xe20e,
	0xe21f, 0xe231, 0xe242, 0xe254, 0xe265, 0xe277, 0xe288, 0xe29a,
	0xe2ab, 0xe2bc, 0xe2cd, 0xe2df, 0xe2f0, 0xe301, 0xe313, 0xe326,
	// Entry 50C0 - 50FF
	0xe338, 0xe349, 0xe35b, 0xe36c, 0xe37d, 0xe38e, 0xe39f, 0xe3b0,
	0xe3c2, 0xe3d3, 0xe3e4, 0xe3f4, 0xe40f, 0xe42b, 0xe446, 0xe462,
	0xe47d, 0xe499, 0xe4b4, 0xe4d0, 0xe4eb, 0xe507, 0xe522, 0xe53d,
	0xe558, 0xe574, 0xe58f, 0xe5aa, 0xe5c6, 0xe5e3, 0xe5ff, 0xe61a,
	0xe636, 0xe651, 0xe66c, 0xe687, 0xe6a2, 0xe6be, 0xe6d9, 0xe6f4,
	0xe70e, 0xe723, 0xe737, 0xe74b, 0xe75f, 0xe773, 0xe788, 0xe7a0,
	0xe7b6, 0xe7cd, 0xe7e3, 0xe7fa, 0xe810, 0xe827, 0xe83d, 0xe854,
	0xe86a, 0xe881, 0xe898, 0xe8b0, 0xe8c7, 0xe8df, 0xe8f7, 0xe90e,
	// Entry 5100 - 513F
	0xe926, 0xe93d, 0xe955, 0xe96d, 0xe985, 0xe99e, 0xe9b6, 0xe9cf,
	0xe9e7, 0xe9fe, 0xea16, 0xea2d, 0xea45, 0xea5c, 0xea73, 0xea8b,
	0xeaa2, 0xeaba, 0xead1, 0xeae8, 0xeaff, 0xeb16, 0xeb2d, 0xeb45,
	0xeb5d, 0xeb74, 0xeb8b, 0xeba3, 0xebbc, 0xebd5, 0xebed, 0xec08,
	0xec22, 0xec3d, 0xec57, 0xec72, 0xec94, 0xecae, 0xecc9, 0xece3,
	0xecfe, 0xed19, 0xed33, 0xed4b, 0xed64, 0xed7e, 0xed92, 0xeda5,
	0xedba, 0xedd2, 0xede9, 0xee00, 0xee19, 0xee31, 0xee49, 0xee60,
	0xee79, 0xee92, 0xeeaa, 0xeec0, 0xeed7, 0xeeed, 0xef04, 0xef1a,
	// Entry 5140 - 517F
	0xef31, 0xef48, 0xef5f, 0xef76, 0xef8d, 0xefa4, 0xefbb, 0xefd2,
	0xefea, 0xf001, 0xf018, 0xf030, 0xf047, 0xf05f, 0xf076, 0xf08d,
	0xf0a5, 0xf0bc, 0xf0d4, 0xf0eb, 0xf102, 0xf11a, 0xf132, 0xf14b,
	0xf163, 0xf17a, 0xf192, 0xf1aa, 0xf1c3, 0xf1db, 0xf1f2, 0xf20a,
	0xf221, 0xf238, 0xf24f, 0xf26a, 0xf284, 0xf29f, 0xf2b9, 0xf2d4,
	0xf2ef, 0xf30a, 0xf325, 0xf340, 0xf35b, 0xf375, 0xf389, 0xf399,
	0xf3b1, 0xf3c8, 0xf3df, 0xf3f8, 0xf410, 0xf428, 0xf43f, 0xf458,
	0xf471, 0xf489, 0xf49a, 0xf4ab, 0xf4bd, 0xf4ce, 0xf4df, 0xf4f0,
	// Entry 5180 - 51BF
	0xf501, 0xf512, 0xf523, 0xf534, 0xf545, 0xf557, 0xf568, 0xf579,
	0xf58a, 0xf59b, 0xf5ac, 0xf5bc, 0xf5c9, 0xf5dd, 0xf5f1, 0xf605,
	0xf619, 0xf62b, 0xf641, 0xf651, 0xf669, 0xf683, 0xf6a3, 0xf6bc,
	0xf6d6, 0xf6f7, 0xf712, 0xf72c, 0xf73d, 0xf74e, 0xf76a, 0xf78b,
	0xf7a6, 0xf7c7, 0xf7e1, 0xf801, 0xf81d, 0xf83a, 0xf857, 0xf87e,
	0xf894, 0xf8a6, 0xf8c4, 0xf8e6, 0xf909, 0xf926, 0xf943, 0xf954,
	0xf965, 0xf982, 0xf9a9, 0xf9ba, 0xf9d4, 0xf9f0, 0xfa0c, 0xfa26,
	0xfa42, 0xfa5c, 0xfa77, 0xfa92, 0xfaa5, 0xfab9, 0xfacc, 0xfae9,
	// Entry 51C0 - 51FF
	0xfafa, 0xfb13, 0xfb30, 0xfb61, 0xfb84, 0xfb98, 0xfbab, 0xfbbe,
	0xfbdb, 0xfbef, 0xfc03, 0xfc15, 0xfc31, 0xfc4d, 0xfc8a, 0xfcae,
	0xfcf1, 0xfd04, 0xfd19, 0xfd2a, 0xfd3c, 0xfd4f, 0xfd64, 0xfd76,
	0xfd91, 0xfda5, 0xfdb7, 0xfdcb, 0xfddc, 0xfdf5, 0xfe10, 0xfe30,
	0xfe41, 0xfe5d, 0xfe79, 0xfe96, 0xfeaa, 0xfec9, 0xfedb, 0xfeee,
	0xfeff, 0xff11, 0xff3c, 0xff60, 0xff85, 0xffa7, 0xffc9, 0xfff5,
	0x0017, 0x003b, 0x005e, 0x0080, 0x00a2, 0x00cc, 0x00ef, 0x0111,
	0x0133, 0x0160, 0x0183, 0x01a5, 0x01d1, 0x01f3, 0x0217, 0x0243,
	// Entry 5200 - 523F
	0x0266, 0x0278, 0x028a, 0x029e, 0x02b2, 0x02c3, 0x02d5, 0x02e7,
	0x0303, 0x0316, 0x0328, 0x034d, 0x0360, 0x0371, 0x038a, 0x03a0,
	0x03b9, 0x03cb, 0x03e8, 0x03fb, 0x040d, 0x0421, 0x0433, 0x0445,
	0x0458, 0x0470, 0x048d, 0x04a0, 0x04b3, 0x04c3, 0x04dd, 0x0501,
	0x0512, 0x053b, 0x0556, 0x0570, 0x058b, 0x05a6, 0x05bf, 0x05d2,
	0x05e5, 0x05f6, 0x0607, 0x0623, 0x0644, 0x065e, 0x067b, 0x0698,
	0x06b1, 0x06c4, 0x06d8, 0x06eb, 0x06fe, 0x0719, 0x073d, 0x076b,
	0x0787, 0x07a4, 0x07c7, 0x07ef, 0x080b, 0x082c, 0x084e, 0x086e,
	// Entry 5240 - 527F
	0x0896, 0x08b3, 0x08cf, 0x08f6, 0x0912, 0x092e, 0x094a, 0x0966,
	0x0977, 0x098d, 0x099f, 0x09c9, 0x09eb, 0x0a0e, 0x0a38, 0x0a53,
	0x0a6f, 0x0a95, 0x0ab1, 0x0ad5, 0x0af1, 0x0b15, 0x0b30, 0x0b4b,
	0x0b71, 0x0b8d, 0x0ba8, 0x0bcb, 0x0be6, 0x0c11, 0x0c33, 0x0c4f,
	0x0c6a, 0x0c86, 0x0ca9, 0x0cce, 0x0cfb, 0x0d17, 0x0d3b, 0x0d5e,
	0x0d7b, 0x0d9c, 0x0dc9, 0x0de5, 0x0e04, 0x0e20, 0x0e45, 0x0e69,
	0x0e84, 0x0ea7, 0x0ec2, 0x0ede, 0x0f03, 0x0f1e, 0x0f3a, 0x0f56,
	0x0f72, 0x0f97, 0x0fb4, 0x0fd0, 0x0fed, 0x1007, 0x1022, 0x1045,
	// Entry 5280 - 52BF
	0x1060, 0x1073, 0x1094, 0x10a6, 0x10ce, 0x10e0, 0x110c, 0x1120,
	0x1132, 0x1144, 0x1157, 0x116f, 0x118c, 0x11ad, 0x11bf, 0x11d2,
	0x11e7, 0x11fd, 0x121d, 0x122e, 0x1247, 0x1260, 0x127d, 0x128f,
	0x12aa, 0x12c9, 0x12dd, 0x12f0, 0x1308, 0x131b, 0x133f, 0x1362,
	0x137f, 0x13a4, 0x13c0, 0x13d4, 0x13e7, 0x1408, 0x1425, 0x1443,
	0x145b, 0x146c, 0x1489, 0x149b, 0x14b7, 0x14e2, 0x14fe, 0x1524,
	0x153b, 0x154d, 0x1570, 0x158c, 0x15ad, 0x15bf, 0x15d1, 0x15ed,
	0x15ff, 0x1612, 0x1626, 0x163b, 0x164c, 0x1662, 0x1678, 0x168a,
	// Entry 52C0 - 52FF
	0x169b, 0x16b6, 0x16d2, 0x16ed, 0x1709, 0x1724, 0x173f, 0x175a,
	0x1775, 0x178e, 0x179f, 0x17b2, 0x17ce, 0x17eb, 0x180b, 0x1829,
	0x1845, 0x1858, 0x1868, 0x187a, 0x188b, 0x189e, 0x18bf, 0x18e4,
	0x18f5, 0x1907, 0x191d, 0x1932, 0x1967, 0x197e, 0x198f, 0x19b0,
	0x19c2, 0x19d3, 0x19ef, 0x1a0c, 0x1a29, 0x1a42, 0x1a55, 0x1a66,
	0x1a77, 0x1a89, 0x1a9a, 0x1ab3, 0x1acd, 0x1af0, 0x1b0c, 0x1b27,
	0x1b44, 0x1b5f, 0x1b79, 0x1b96, 0x1bb2, 0x1bcc, 0x1be7, 0x1c08,
	0x1c23, 0x1c4f, 0x1c69, 0x1c85, 0x1caa, 0x1cd4, 0x1cee, 0x1d0a,
	// Entry 5300 - 533F
	0x1d25, 0x1d3f, 0x1d5a, 0x1d74, 0x1d8f, 0x1da9, 0x1dc3, 0x1ddd,
	0x1dff, 0x1e21, 0x1e43, 0x1e5d, 0x1e82, 0x1e9c, 0x1eb7, 0x1ed1,
	0x1eeb, 0x1f05, 0x1f20, 0x1f3b, 0x1f56, 0x1f72, 0x1f8d, 0x1fa8,
	0x1fc5, 0x1fe0, 0x1ff9, 0x2013, 0x202d, 0x2052, 0x206d, 0x2087,
	0x2099, 0x20b8, 0x20ca, 0x20dd, 0x20f0, 0x2103, 0x2116, 0x2133,
	0x2145, 0x2166, 0x2178, 0x2194, 0x21b3, 0x21c6, 0x21d9, 0x21ee,
	0x2224, 0x2266, 0x227a, 0x228b, 0x22a6, 0x22bf, 0x22d9, 0x22eb,
	0x22fd, 0x2311, 0x2324, 0x2339, 0x235a, 0x236b, 0x23a5, 0x23b7,
	// Entry 5340 - 537F
	0x23c9, 0x23e8, 0x23fa, 0x240c, 0x2423, 0x2435, 0x2447, 0x2466,
	0x247b, 0x2490, 0x24a1, 0x24b5, 0x24d1, 0x24fd, 0x2522, 0x2547,
	0x2564, 0x2581, 0x25a9, 0x25c7, 0x25e4, 0x2602, 0x261f, 0x263c,
	0x265a, 0x2678, 0x269f, 0x26bc, 0x26da, 0x2701, 0x2724, 0x2741,
	0x2766, 0x278b, 0x27a8, 0x27c6, 0x27e4, 0x2802, 0x282f, 0x284f,
	0x286e, 0x288b, 0x28a9, 0x28c6, 0x28eb, 0x290a, 0x2927, 0x294e,
	0x2983, 0x29b2, 0x29d1, 0x29fa, 0x2a18, 0x2a36, 0x2a55, 0x2a89,
	0x2aa5, 0x2ac8, 0x2af2, 0x2b18, 0x2b35, 0x2b53, 0x2b6f, 0x2b83,
	// Entry 5380 - 53BF
	0x2ba1, 0x2bc8, 0x2be1, 0x2c0e, 0x2c23, 0x2c35, 0x2c51, 0x2c63,
	0x2c7f, 0x2ca3, 0x2cb4, 0x2cc6, 0x2cdb, 0x2cee, 0x2cff, 0x2d1a,
	0x2d2c, 0x2d47, 0x2d63, 0x2d80, 0x2da2, 0x2dc4, 0x2de9, 0x2e04,
	0x2e21, 0x2e3e, 0x2e64, 0x2e7f, 0x2ea3, 0x2ec1, 0x2ee4, 0x2eff,
	0x2f1a, 0x2f3e, 0x2f63, 0x2f80, 0x2f97, 0x2fb6, 0x2fd5, 0x2fef,
	0x3009, 0x301b, 0x302f, 0x304e, 0x3071, 0x308d, 0x309f, 0x30b1,
	0x30c3, 0x30de, 0x3106, 0x3117, 0x3133, 0x3149, 0x315b, 0x316d,
	0x317f, 0x3192, 0x31a6, 0x31b7, 0x31c9, 0x31da, 0x31ec, 0x31fd,
	// Entry 53C0 - 53FF
	0x3216, 0x3228, 0x323f, 0x3254, 0x3269, 0x327c, 0x3297, 0x32b4,
	0x32d0, 0x32ed, 0x331a, 0x333b, 0x334f, 0x336b, 0x338f, 0x33ac,
	0x33c5, 0x33d6, 0x33e8, 0x33fb, 0x3417, 0x3439, 0x345a, 0x346e,
	0x3488, 0x349a, 0x34ad, 0x34be, 0x34d7, 0x34f1, 0x350a, 0x351b,
	0x3534, 0x3546, 0x3558, 0x357a, 0x35a5, 0x35ba, 0x35d8, 0x35f7,
	0x361f, 0x363e, 0x366b, 0x3689, 0x36a8, 0x36c7, 0x36f0, 0x3718,
	0x3749, 0x3770, 0x378f, 0x37a3, 0x37b4, 0x37c7, 0x37d9, 0x37fb,
	0x381e, 0x3840, 0x387b, 0x389d, 0x38b4, 0x38cf, 0x38ee, 0x391e,
	// Entry 5400 - 543F
	0x3932, 0x3957, 0x3978, 0x399a, 0x39bc, 0x39e3, 0x3a06, 0x3a27,
	0x3a48, 0x3a6c, 0x3a8d, 0x3ab1, 0x3ad7, 0x3ae8, 0x3afa, 0x3b0c,
	0x3b1e, 0x3b32, 0x3b43, 0x3b5c, 0x3b76, 0x3b90, 0x3baa, 0x3bc3,
	0x3bdc, 0x3bf6, 0x3c0f, 0x3c29, 0x3c46, 0x3c5a, 0x3c78, 0x3c95,
	0x3cb2, 0x3cd5, 0x3ce6, 0x3cf8, 0x3d09, 0x3d1a, 0x3d2b, 0x3d45,
	0x3d57, 0x3d71, 0x3d8c, 0x3da8, 0x3dc3, 0x3ddf, 0x3dfb, 0x3e17,
	0x3e32, 0x3e4e, 0x3e6a, 0x3e87, 0x3ea3, 0x3ebe, 0x3ed9, 0x3ef4,
	0x3f0f, 0x3f2b, 0x3f46, 0x3f5d, 0x3f6f, 0x3f92, 0x3fa7, 0x3fb9,
	// Entry 5440 - 547F
	0x3fcb, 0x3fde, 0x3ff9, 0x4016, 0x4034, 0x4050, 0x406e, 0x408b,
	0x40a6, 0x40c8, 0x40db, 0x40ef, 0x4103, 0x4115, 0x412a, 0x415f,
	0x4194, 0x41a8, 0x41bb, 0x41cf, 0x41e4, 0x41fb, 0x420e, 0x4229,
	0x4245, 0x4258, 0x4273, 0x4290, 0x42af, 0x42cc, 0x42e9, 0x4306,
	0x4328, 0x4348, 0x4365, 0x4382, 0x439f, 0x43b4, 0x43c7, 0x43df,
	0x4409, 0x441d, 0x442f, 0x4453, 0x4466, 0x447b, 0x448c, 0x44a2,
	0x44b4, 0x44c7, 0x44e9, 0x44fc, 0x4510, 0x4521, 0x453a, 0x454c,
	0x455f, 0x4573, 0x4585, 0x459a, 0x45ac, 0x45bf, 0x45d0, 0x45ea,
	// Entry 5480 - 54BF
	0x4604, 0x461e, 0x4634, 0x4646, 0x467b, 0x4695, 0x46a7, 0x46c2,
	0x46de, 0x46fa, 0x4716, 0x4733, 0x474e, 0x4761, 0x4773, 0x4784,
	0x479a, 0x47ab, 0x47c1, 0x47d3, 0x47e5, 0x4802, 0x481d, 0x4852,
	0x4863, 0x4876, 0x4888, 0x489a, 0x48ac, 0x48d2, 0x48e2, 0x48f6,
	0x490a, 0x4939, 0x495d, 0x498f, 0x49a0, 0x49b1, 0x49c2, 0x49da,
	0x49f5, 0x4a0f, 0x4a36, 0x4a62, 0x4a78, 0x4a91, 0x4ab4, 0x4ac7,
	0x4ad8, 0x4af5, 0x4b17, 0x4b33, 0x4b4c, 0x4b60, 0x4b73, 0x4b93,
	0x4baf, 0x4bc0, 0x4bd6, 0x4be7, 0x4c04, 0x4c1d, 0x4c2f, 0x4c51,
	// Entry 54C0 - 54FF
	0x4c73, 0x4c8e, 0x4ca9, 0x4cc5, 0x4ce0, 0x4d04, 0x4d27, 0x4d39,
	0x4d4b, 0x4d5e, 0x4d70, 0x4d8a, 0x4da9, 0x4dc5, 0x4de1, 0x4dfc,
	0x4e18, 0x4e3a, 0x4e56, 0x4e71, 0x4e8c, 0x4ea8, 0x4ec3, 0x4edf,
	0x4efa, 0x4f16, 0x4f32, 0x4f4d, 0x4f69, 0x4f86, 0x4fa1, 0x4fc4,
	0x4fdf, 0x4ffd, 0x5011, 0x502d, 0x503f, 0x5059, 0x5074, 0x5090,
	0x50ad, 0x50c0, 0x50d3, 0x50e8, 0x50fc, 0x510e, 0x512d, 0x513f,
	0x5150, 0x5166, 0x5189, 0x519b, 0x51ae, 0x51c0, 0x51d1, 0x51ea,
	0x51fc, 0x520e, 0x522a, 0x523c, 0x524f, 0x5260, 0x5272, 0x528c,
	// Entry 5500 - 553F
	0x52a0, 0x52b2, 0x52cc, 0x52e7, 0x5301, 0x531e, 0x534a, 0x535d,
	0x5379, 0x5395, 0x53b2, 0x53cf, 0x53fa, 0x5417, 0x542a, 0x543c,
	0x544f, 0x546c, 0x5488, 0x54a4, 0x54bf, 0x54e4, 0x54ff, 0x5519,
	0x5535, 0x554f, 0x556a, 0x5587, 0x55ab, 0x55d1, 0x55ed, 0x5600,
	0x561d, 0x562f, 0x5641, 0x5654, 0x5673, 0x5691, 0x56bb, 0x56d8,
	0x56eb, 0x570c, 0x571e, 0x5738, 0x574a, 0x5768, 0x5788, 0x57a7,
	0x57c6, 0x57e4, 0x5804, 0x5824, 0x5843, 0x5864, 0x5884, 0x58a4,
	0x58c3, 0x58e4, 0x5905, 0x5925, 0x5942, 0x595f, 0x597b, 0x5999,
	// Entry 5540 - 557F
	0x59b7, 0x59d4, 0x59f4, 0x5a14, 0x5a36, 0x5a57, 0x5a78, 0x5a98,
	0x5aba, 0x5adc, 0x5afd, 0x5b1d, 0x5b3d, 0x5b5f, 0x5b80, 0x5ba1,
	0x5bc1, 0x5be3, 0x5c12, 0x5c33, 0x5c54, 0x5c74, 0x5c96, 0x5cb8,
	0x5cd9, 0x5cf9, 0x5d19, 0x5d3b, 0x5d6a, 0x5d8b, 0x5dac, 0x5ddc,
	0x5e0b, 0x5e2a, 0x5e49, 0x5e6a, 0x5e98, 0x5eb8, 0x5ed8, 0x5f07,
	0x5f36, 0x5f64, 0x5f93, 0x5fc3, 0x5ff3, 0x601f, 0x604e, 0x607e,
	0x60ae, 0x60dc, 0x610b, 0x613a, 0x616a, 0x619a, 0x61cb, 0x61ee,
	0x6213, 0x6237, 0x625b, 0x627e, 0x629d, 0x62bc, 0x62dd, 0x62fd,
	// Entry 5580 - 55BF
	0x632a, 0x634a, 0x6377, 0x6397, 0x63b7, 0x63d7, 0x63f7, 0x641c,
	0x6442, 0x6469, 0x6498, 0x64c8, 0x64ed, 0x6513, 0x6540, 0x656f,
	0x6595, 0x65b8, 0x65e0, 0x6609, 0x662d, 0x6651, 0x667b, 0x66a5,
	0x66ce, 0x66f9, 0x6724, 0x674e, 0x6782, 0x67ab, 0x67d4, 0x6800,
	0x682d, 0x684d, 0x6869, 0x6885, 0x68a7, 0x68c6, 0x68e4, 0x6902,
	0x6925, 0x6941, 0x695d, 0x6979, 0x6997, 0x69b3, 0x69d1, 0x69ed,
	0x6a11, 0x6a2d, 0x6a49, 0x6a67, 0x6a82, 0x6a9d, 0x6abf, 0x6adc,
	0x6af7, 0x6b12, 0x6b33, 0x6b52, 0x6b6e, 0x6b8d, 0x6bb8, 0x6bd8,
	// Entry 55C0 - 55FF
	0x6bf4, 0x6c1a, 0x6c40, 0x6c5d, 0x6c79, 0x6c94, 0x6caf, 0x6cca,
	0x6ce6, 0x6d06, 0x6d21, 0x6d3c, 0x6d52, 0x6d73, 0x6d98, 0x6dbc,
	0x6de6, 0x6e0a, 0x6e2f, 0x6e53, 0x6e78, 0x6e9c, 0x6eb8, 0x6ed7,
	0x6ef8, 0x6f23, 0x6f4c, 0x6f69, 0x6f84, 0x6fa8, 0x6fcc, 0x6fee,
	0x7019, 0x7035, 0x705b, 0x7077, 0x7094, 0x70af, 0x70d2, 0x70f5,
	0x7112, 0x712f, 0x7159, 0x7177, 0x71a3, 0x71c4, 0x71eb, 0x7206,
	0x7233, 0x724d, 0x7267, 0x7284, 0x729e, 0x72c3, 0x72d9, 0x72ef,
	0x7305, 0x731b, 0x7331, 0x7347, 0x735d, 0x7385, 0x739b, 0x73be,
	// Entry 5600 - 563F
	0x73d4, 0x73ea, 0x7400, 0x7416, 0x742c, 0x7442, 0x7458, 0x746e,
	0x7484, 0x749a, 0x74b0, 0x74c6, 0x74dc, 0x74f2, 0x7508, 0x751e,
	0x7534, 0x754a, 0x7560, 0x757f, 0x759f, 0x75c8, 0x75fa, 0x7621,
	0x7637, 0x764d, 0x7663, 0x7679, 0x768f, 0x76a5, 0x76bb, 0x76d1,
	0x76e7, 0x76fd, 0x7713, 0x7733, 0x7753, 0x777e, 0x779e, 0x77bd,
	0x77dd, 0x77fc, 0x781b, 0x783a, 0x785c, 0x7872, 0x7888, 0x78a8,
	0x78c7, 0x78e7, 0x790c, 0x792b, 0x795d, 0x7987, 0x79a6, 0x79c8,
	0x79de, 0x79f4, 0x7a15, 0x7a32, 0x7a4e, 0x7a6a, 0x7a98, 0x7ab5,
	// Entry 5640 - 567F
	0x7acf, 0x7af5, 0x7b1c, 0x7b40, 0x7b60, 0x7b7f, 0x7b9d, 0x7bbe,
	0x7be1, 0x7c01, 0x7c29, 0x7c46, 0x7c6a, 0x7c8b, 0x7cab, 0x7cc6,
	0x7cea, 0x7d07, 0x7d1f, 0x7d3a, 0x7d56, 0x7d72, 0x7d8d, 0x7db2,
	0x7dd6, 0x7df2, 0x7e0e, 0x7e30, 0x7e53, 0x7e6e, 0x7e89, 0x7ea7,
	0x7ec7, 0x7ee3, 0x7ef5, 0x7f17, 0x7f3f, 0x7f57, 0x7f6f, 0x7f87,
	0x7f9f, 0x7fb7, 0x7fd0, 0x7fe8, 0x8001, 0x801a, 0x8032, 0x804a,
	0x8062, 0x807a, 0x8092, 0x80aa, 0x80c2, 0x80da, 0x80f3, 0x810b,
	0x8123, 0x813b, 0x8154, 0x816c, 0x8184, 0x819c, 0x81b4, 0x81cc,
	// Entry 5680 - 56BF
	0x81e4, 0x81fc, 0x8214, 0x822c, 0x8244, 0x825c, 0x8274, 0x828c,
	0x82a4, 0x82bc, 0x82d5, 0x82ed, 0x8305, 0x831d, 0x8335, 0x834d,
	0x8365, 0x837d, 0x8395, 0x83ae, 0x83c6, 0x83de, 0x83f7, 0x840f,
	0x8428, 0x8440, 0x8458, 0x8471, 0x8489, 0x84a1, 0x84b9, 0x84d1,
	0x84e9, 0x8501, 0x8519, 0x8531, 0x8549, 0x8561, 0x8579, 0x8591,
	0x85a9, 0x85c1, 0x85d9, 0x85f1, 0x8609, 0x8621, 0x8639, 0x8651,
	0x8669, 0x8681, 0x8699, 0x86b1, 0x86c9, 0x86e1, 0x86f9, 0x8711,
	0x8729, 0x8741, 0x875a, 0x8772, 0x878a, 0x87a2, 0x87ba, 0x87d2,
	// Entry 56C0 - 56FF
	0x87ea, 0x8803, 0x881c, 0x8835, 0x884d, 0x8865, 0x887d, 0x8895,
	0x88ad, 0x88c5, 0x88dd, 0x88f5, 0x890e, 0x8926, 0x893e, 0x8956,
	0x896e, 0x8986, 0x899e, 0x89b6, 0x89ce, 0x89e6, 0x89fe, 0x8a16,
	0x8a2e, 0x8a46, 0x8a5e, 0x8a76, 0x8a8e, 0x8aa6, 0x8abe, 0x8ad6,
	0x8aee, 0x8b06, 0x8b1e, 0x8b37, 0x8b4f, 0x8b67, 0x8b7f, 0x8b97,
	0x8baf, 0x8bc7, 0x8bdf, 0x8bf7, 0x8c0f, 0x8c27, 0x8c3f, 0x8c57,
	0x8c6f, 0x8c87, 0x8c9f, 0x8cb7, 0x8ccf, 0x8ce7, 0x8cff, 0x8d18,
	0x8d30, 0x8d48, 0x8d60, 0x8d78, 0x8d91, 0x8da9, 0x8dc1, 0x8dd9,
	// Entry 5700 - 573F
	0x8df2, 0x8e0a, 0x8e22, 0x8e3a, 0x8e52, 0x8e6a, 0x8e82, 0x8e9a,
	0x8eb2, 0x8eca, 0x8ee2, 0x8efa, 0x8f12, 0x8f2b, 0x8f43, 0x8f5b,
	0x8f74, 0x8f8c, 0x8fa4, 0x8fbd, 0x8fd6, 0x8fef, 0x9008, 0x9021,
	0x903a, 0x9053, 0x906c, 0x9085, 0x909d, 0x90b5, 0x90ce, 0x90e6,
	0x90fe, 0x9117, 0x912f, 0x9147, 0x915f, 0x9177, 0x918f, 0x91a7,
	0x91bf, 0x91d7, 0x91ef, 0x9207, 0x921f, 0x9237, 0x924f, 0x9268,
	0x9281, 0x929a, 0x92b3, 0x92cc, 0x92e5, 0x92fe, 0x9317, 0x932f,
	0x9347, 0x935f, 0x9377, 0x938f, 0x93a7, 0x93bf, 0x93d7, 0x93f0,
	// Entry 5740 - 577F
	0x9408, 0x9421, 0x9439, 0x9451, 0x9469, 0x9481, 0x9499, 0x94b1,
	0x94c9, 0x94e2, 0x94fa, 0x9513, 0x952b, 0x9543, 0x955b, 0x9574,
	0x958c, 0x95a4, 0x95bc, 0x95d4, 0x95ec, 0x9604, 0x961c, 0x9634,
	0x964d, 0x9665, 0x967d, 0x9695, 0x96ad, 0x96c5, 0x96dd, 0x96f6,
	0x970e, 0x9726, 0x973e, 0x9756, 0x976f, 0x9787, 0x979f, 0x97b7,
	0x97cf, 0x97e7, 0x97ff, 0x9817, 0x982f, 0x9847, 0x985f, 0x9877,
	0x988f, 0x98a8, 0x98c0, 0x98d8, 0x98f0, 0x9908, 0x9920, 0x9938,
	0x9950, 0x9968, 0x9981, 0x9999, 0x99b1, 0x99c9, 0x99e1, 0x99f9,
	// Entry 5780 - 57BF
	0x9a11, 0x9a29, 0x9a41, 0x9a59, 0x9a71, 0x9a8a, 0x9aa2, 0x9aba,
	0x9ad2, 0x9aea, 0x9b02, 0x9b1a, 0x9b33, 0x9b4b, 0x9b64, 0x9b7c,
	0x9b94, 0x9bac, 0x9bc4, 0x9bdc, 0x9bf4, 0x9c0c, 0x9c25, 0x9c3d,
	0x9c56, 0x9c6e, 0x9c87, 0x9c9f, 0x9cb7, 0x9ccf, 0x9ce7, 0x9d00,
	0x9d19, 0x9d32, 0x9d4a, 0x9d62, 0x9d7a, 0x9d92, 0x9daa, 0x9dc2,
	0x9dda, 0x9df2, 0x9e0b, 0x9e23, 0x9e3c, 0x9e55, 0x9e6d, 0x9e85,
	0x9e9d, 0x9eb5, 0x9ece, 0x9ee6, 0x9efe, 0x9f16, 0x9f2e, 0x9f46,
	0x9f5e, 0x9f76, 0x9f8e, 0x9fa6, 0x9fbf, 0x9fd7, 0x9fef, 0xa007,
	// Entry 57C0 - 57FF
	0xa01f, 0xa037, 0xa04f, 0xa068, 0xa080, 0xa098, 0xa0b0, 0xa0c8,
	0xa0e0, 0xa0f8, 0xa110, 0xa128, 0xa140, 0xa158, 0xa171, 0xa189,
	0xa1a2, 0xa1ba, 0xa1d2, 0xa1ea, 0xa202, 0xa21a, 0xa232, 0xa24b,
	0xa263, 0xa27b, 0xa294, 0xa2ac, 0xa2c4, 0xa2dc, 0xa2f4, 0xa30c,
	0xa324, 0xa33c, 0xa354, 0xa36c, 0xa384, 0xa39c, 0xa3b4, 0xa3cc,
	0xa3e4, 0xa3fc, 0xa415, 0xa42d, 0xa445, 0xa45d, 0xa475, 0xa48d,
	0xa4a5, 0xa4bd, 0xa4d6, 0xa4ee, 0xa506, 0xa51e, 0xa536, 0xa54f,
	0xa567, 0xa580, 0xa598, 0xa5b1, 0xa5c9, 0xa5e1, 0xa5f9, 0xa611,
	// Entry 5800 - 583F
	0xa629, 0xa641, 0xa659, 0xa671, 0xa689, 0xa6a1, 0xa6b9, 0xa6d1,
	0xa6e9, 0xa701, 0xa71a, 0xa732, 0xa74a, 0xa762, 0xa77a, 0xa793,
	0xa7ab, 0xa7c3, 0xa7db, 0xa7f4, 0xa80d, 0xa825, 0xa83d, 0xa856,
	0xa86e, 0xa886, 0xa89e, 0xa8b6, 0xa8ce, 0xa8e6, 0xa8fe, 0xa917,
	0xa92f, 0xa947, 0xa960, 0xa979, 0xa992, 0xa9ab, 0xa9c4, 0xa9dd,
	0xa9f6, 0xaa0f, 0xaa27, 0xaa3f, 0xaa57, 0xaa70, 0xaa88, 0xaaa1,
	0xaab9, 0xaad2, 0xaaea, 0xab02, 0xab1a, 0xab32, 0xab4a, 0xab63,
	0xab7b, 0xab93, 0xabac, 0xabc4, 0xabdc, 0xabf4, 0xac0c, 0xac25,
	// Entry 5840 - 587F
	0xac3d, 0xac55, 0xac6d, 0xac86, 0xac9e, 0xacb6, 0xaccf, 0xace8,
	0xad00, 0xad18, 0xad30, 0xad48, 0xad60, 0xad78, 0xad90, 0xada9,
	0xadc1, 0xadd9, 0xadf1, 0xae09, 0xae21, 0xae39, 0xae51, 0xae69,
	0xae81, 0xae99, 0xaeb1, 0xaec9, 0xaee1, 0xaef9, 0xaf11, 0xaf29,
	0xaf41, 0xaf59, 0xaf71, 0xaf89, 0xafa1, 0xafb9, 0xafd2, 0xafeb,
	0xb003, 0xb01b, 0xb033, 0xb04b, 0xb063, 0xb07b, 0xb093, 0xb0ac,
	0xb0c4, 0xb0dc, 0xb0f4, 0xb10c, 0xb124, 0xb13c, 0xb154, 0xb16c,
	0xb185, 0xb19d, 0xb1b6, 0xb1ce, 0xb1e7, 0xb1ff, 0xb217, 0xb230,
	// Entry 5880 - 58BF
	0xb248, 0xb260, 0xb278, 0xb290, 0xb2a8, 0xb2c1, 0xb2da, 0xb2f3,
	0xb30c, 0xb325, 0xb33f, 0xb358, 0xb371, 0xb38a, 0xb3a3, 0xb3bc,
	0xb3d5, 0xb3ee, 0xb407, 0xb420, 0xb439, 0xb452, 0xb46b, 0xb485,
	0xb49e, 0xb4b7, 0xb4d0, 0xb4e9, 0xb502, 0xb51b, 0xb534, 0xb54d,
	0xb566, 0xb57f, 0xb598, 0xb5b1, 0xb5ca, 0xb5e4, 0xb5fd, 0xb617,
	0xb630, 0xb649, 0xb662, 0xb67b, 0xb694, 0xb6ad, 0xb6c6, 0xb6e0,
	0xb6f9, 0xb712, 0xb72b, 0xb744, 0xb75e, 0xb776, 0xb78f, 0xb7a7,
	0xb7bf, 0xb7d7, 0xb7ef, 0xb808, 0xb820, 0xb839, 0xb852, 0xb86b,
	// Entry 58C0 - 58FF
	0xb884, 0xb89d, 0xb8b6, 0xb8ce, 0xb8e6, 0xb8fe, 0xb916, 0xb92f,
	0xb948, 0xb961, 0xb979, 0xb991, 0xb9a9, 0xb9c1, 0xb9d9, 0xb9f1,
	0xba09, 0xba21, 0xba39, 0xba52, 0xba6a, 0xba83, 0xba9b, 0xbab3,
	0xbacb, 0xbae3, 0xbafc, 0xbb14, 0xbb2d, 0xbb45, 0xbb5d, 0xbb75,
	0xbb8d, 0xbba6, 0xbbbe, 0xbbd7, 0xbbef, 0xbc07, 0xbc1f, 0xbc38,
	0xbc50, 0xbc68, 0xbc80, 0xbc99, 0xbcb2, 0xbccb, 0xbce4, 0xbcfc,
	0xbd14, 0xbd2c, 0xbd44, 0xbd5c, 0xbd74, 0xbd8c, 0xbda4, 0xbdbc,
	0xbdd4, 0xbdec, 0xbe04, 0xbe1c, 0xbe34, 0xbe4d, 0xbe66, 0xbe7e,
	// Entry 5900 - 593F
	0xbe96, 0xbeaf, 0xbec7, 0xbedf, 0xbef8, 0xbf10, 0xbf28, 0xbf40,
	0xbf58, 0xbf70, 0xbf88, 0xbfa0, 0xbfb8, 0xbfd0, 0xbfe8, 0xc000,
	0xc018, 0xc030, 0xc048, 0xc060, 0xc078, 0xc090, 0xc0a9, 0xc0c1,
	0xc0da, 0xc0f3, 0xc10b, 0xc123, 0xc13b, 0xc153, 0xc16b, 0xc183,
	0xc19b, 0xc1b4, 0xc1cc, 0xc1e4, 0xc1fc, 0xc214, 0xc22c, 0xc244,
	0xc25d, 0xc275, 0xc28d, 0xc2a5, 0xc2bd, 0xc2d5, 0xc2ed, 0xc305,
	0xc31d, 0xc335, 0xc34d, 0xc365, 0xc37d, 0xc395, 0xc3ad, 0xc3c5,
	0xc3de, 0xc3f6, 0xc40e, 0xc426, 0xc43e, 0xc457, 0xc46f, 0xc487,
	// Entry 5940 - 597F
	0xc49f, 0xc4b7, 0xc4cf, 0xc4e7, 0xc4ff, 0xc517, 0xc530, 0xc549,
	0xc561, 0xc579, 0xc591, 0xc5aa, 0xc5c2, 0xc5da, 0xc5f2, 0xc60a,
	0xc622, 0xc63a, 0xc652, 0xc66a, 0xc682, 0xc69b, 0xc6b4, 0xc6cc,
	0xc6e4, 0xc6fc, 0xc714, 0xc72c, 0xc744, 0xc75c, 0xc774, 0xc78c,
	0xc7a5, 0xc7bd, 0xc7d5, 0xc7ed, 0xc805, 0xc81d, 0xc835, 0xc84d,
	0xc865, 0xc87d, 0xc895, 0xc8ad, 0xc8c5, 0xc8dd, 0xc8f5, 0xc90e,
	0xc926, 0xc93e, 0xc956, 0xc96e, 0xc987, 0xc99f, 0xc9b8, 0xc9d0,
	0xc9e9, 0xca01, 0xca19, 0xca32, 0xca4a, 0xca62, 0xca7a, 0xca92,
	// Entry 5980 - 59BF
	0xcaaa, 0xcac3, 0xcadb, 0xcaf3, 0xcb0b, 0xcb23, 0xcb3b, 0xcb53,
	0xcb6b, 0xcb83, 0xcb9b, 0xcbb3, 0xcbcb, 0xcbe3, 0xcbfb, 0xcc13,
	0xcc2b, 0xcc43, 0xcc5c, 0xcc74, 0xcc8d, 0xcca5, 0xccbd, 0xccd5,
	0xcced, 0xcd05, 0xcd1d, 0xcd35, 0xcd4d, 0xcd65, 0xcd7e, 0xcd97,
	0xcdaf, 0xcdc7, 0xcddf, 0xcdf7, 0xce0f, 0xce27, 0xce3f, 0xce57,
	0xce6f, 0xce87, 0xce9f, 0xceb7, 0xcecf, 0xcee7, 0xceff, 0xcf17,
	0xcf2f, 0xcf48, 0xcf60, 0xcf78, 0xcf90, 0xcfa8, 0xcfc0, 0xcfd8,
	0xcff1, 0xd009, 0xd021, 0xd039, 0xd052, 0xd06a, 0xd082, 0xd09a,
	// Entry 59C0 - 59FF
	0xd0b2, 0xd0ca, 0xd0e2, 0xd0fa, 0xd112, 0xd12a, 0xd142, 0xd15a,
	0xd173, 0xd18c, 0xd1a5, 0xd1be, 0xd1d7, 0xd1f0, 0xd209, 0xd222,
	0xd23b, 0xd253, 0xd26c, 0xd284, 0xd29c, 0xd2b4, 0xd2cc, 0xd2e4,
	0xd2fd, 0xd316, 0xd32e, 0xd346, 0xd35e, 0xd376, 0xd38f, 0xd3a8,
	0xd3c1, 0xd3d9, 0xd3f2, 0xd40b, 0xd423, 0xd43b, 0xd453, 0xd46b,
	0xd483, 0xd49b, 0xd4b3, 0xd4cb, 0xd4e4, 0xd4fd, 0xd516, 0xd52f,
	0xd548, 0xd561, 0xd57a, 0xd593, 0xd5ac, 0xd5c5, 0xd5de, 0xd5f7,
	0xd60f, 0xd627, 0xd63f, 0xd658, 0xd670, 0xd688, 0xd6a0, 0xd6b8,
	// Entry 5A00 - 5A3F
	0xd6d0, 0xd6e9, 0xd701, 0xd71a, 0xd732, 0xd74b, 0xd763, 0xd77c,
	0xd794, 0xd7ac, 0xd7c5, 0xd7dd, 0xd7f5, 0xd80d, 0xd825, 0xd83e,
	0xd856, 0xd86e, 0xd886, 0xd89f, 0xd8b7, 0xd8cf, 0xd8e7, 0xd900,
	0xd918, 0xd930, 0xd948, 0xd960, 0xd978, 0xd990, 0xd9a9, 0xd9c1,
	0xd9da, 0xd9f2, 0xda0a, 0xda22, 0xda3a, 0xda53, 0xda6b, 0xda83,
	0xda9b, 0xdab4, 0xdacc, 0xdae5, 0xdafd, 0xdb15, 0xdb2d, 0xdb45,
	0xdb5d, 0xdb75, 0xdb8e, 0xdba6, 0xdbbe, 0xdbd6, 0xdbee, 0xdc06,
	0xdc1f, 0xdc38, 0xdc50, 0xdc68, 0xdc81, 0xdc99, 0xdcb1, 0xdcca,
	// Entry 5A40 - 5A7F
	0xdce2, 0xdcfb, 0xdd13, 0xdd2b, 0xdd43, 0xdd5b, 0xdd73, 0xdd8b,
	0xdda3, 0xddbb, 0xddd3, 0xddec, 0xde05, 0xde1e, 0xde37, 0xde4f,
	0xde68, 0xde81, 0xde99, 0xdeb2, 0xdeca, 0xdee3, 0xdefb, 0xdf13,
	0xdf2b, 0xdf43, 0xdf5b, 0xdf73, 0xdf8b, 0xdfa3, 0xdfbb, 0xdfd3,
	0xdfec, 0xe005, 0xe01e, 0xe037, 0xe050, 0xe069, 0xe082, 0xe09b,
	0xe0b4, 0xe0cc, 0xe0e5, 0xe0fe, 0xe117, 0xe130, 0xe149, 0xe162,
	0xe17b, 0xe194, 0xe1ad, 0xe1c6, 0xe1df, 0xe1f8, 0xe211, 0xe22a,
	0xe243, 0xe25d, 0xe277, 0xe290, 0xe2a9, 0xe2c2, 0xe2db, 0xe2f4,
	// Entry 5A80 - 5ABF
	0xe30d, 0xe326, 0xe33f, 0xe358, 0xe371, 0xe38a, 0xe3a3, 0xe3bc,
	0xe3d5, 0xe3ee, 0xe407, 0xe420, 0xe439, 0xe452, 0xe46b, 0xe484,
	0xe49d, 0xe4b6, 0xe4cf, 0xe4e8, 0xe501, 0xe51a, 0xe533, 0xe54c,
	0xe565, 0xe57e, 0xe597, 0xe5b0, 0xe5c9, 0xe5e2, 0xe5fc, 0xe615,
	0xe62e, 0xe647, 0xe660, 0xe679, 0xe692, 0xe6ab, 0xe6c4, 0xe6dd,
	0xe6f6, 0xe70f, 0xe728, 0xe741, 0xe75a, 0xe773, 0xe78c, 0xe7a6,
	0xe7bf, 0xe7d8, 0xe7f1, 0xe80a, 0xe823, 0xe83c, 0xe855, 0xe86e,
	0xe887, 0xe8a0, 0xe8b9, 0xe8d2, 0xe8eb, 0xe905, 0xe91e, 0xe937,
	// Entry 5AC0 - 5AFF
	0xe951, 0xe96a, 0xe983, 0xe99c, 0xe9b5, 0xe9cf, 0xe9e8, 0xea02,
	0xea1c, 0xea35, 0xea4e, 0xea67, 0xea80, 0xea99, 0xeab2, 0xeacb,
	0xeae4, 0xeafd, 0xeb16, 0xeb2f, 0xeb48, 0xeb61, 0xeb7a, 0xeb93,
	0xebac, 0xebc5, 0xebde, 0xebf7, 0xec10, 0xec2a, 0xec44, 0xec5e,
	0xec77, 0xec90, 0xeca9, 0xecc2, 0xecdb, 0xecf4, 0xed0d, 0xed26,
	0xed3f, 0xed58, 0xed71, 0xed8a, 0xeda3, 0xedbc, 0xedd5, 0xedee,
	0xee07, 0xee20, 0xee39, 0xee52, 0xee6b, 0xee84, 0xee9d, 0xeeb6,
	0xeecf, 0xeee8, 0xef01, 0xef1a, 0xef33, 0xef4c, 0xef65, 0xef7f,
	// Entry 5B00 - 5B3F
	0xef98, 0xefb2, 0xefcb, 0xefe4, 0xeffe, 0xf017, 0xf031, 0xf04a,
	0xf064, 0xf07d, 0xf096, 0xf0b0, 0xf0ca, 0xf0e4, 0xf0fd, 0xf117,
	0xf131, 0xf14a, 0xf163, 0xf17d, 0xf197, 0xf1b1, 0xf1ca, 0xf1e3,
	0xf1fc, 0xf216, 0xf230, 0xf249, 0xf262, 0xf27b, 0xf294, 0xf2ad,
	0xf2c7, 0xf2e0, 0xf2f9, 0xf312, 0xf32b, 0xf344, 0xf35d, 0xf376,
	0xf38f, 0xf3a8, 0xf3c1, 0xf3db, 0xf3f4, 0xf40d, 0xf426, 0xf43f,
	0xf458, 0xf471, 0xf48a, 0xf4a3, 0xf4bc, 0xf4d5, 0xf4ef, 0xf508,
	0xf521, 0xf53a, 0xf553, 0xf56c, 0xf585, 0xf59e, 0xf5b7, 0xf5d0,
	// Entry 5B40 - 5B7F
	0xf5e9, 0xf602, 0xf61b, 0xf634, 0xf64d, 0xf666, 0xf67f, 0xf698,
	0xf6b1, 0xf6ca, 0xf6e3, 0xf6fc, 0xf715, 0xf72e, 0xf747, 0xf760,
	0xf779, 0xf792, 0xf7ab, 0xf7c4, 0xf7dd, 0xf7f6, 0xf80f, 0xf828,
	0xf841, 0xf85a, 0xf873, 0xf88c, 0xf8a5, 0xf8be, 0xf8d7, 0xf8f0,
	0xf909, 0xf922, 0xf93b, 0xf954, 0xf96d, 0xf986, 0xf99f, 0xf9b8,
	0xf9d1, 0xf9ea, 0xfa03, 0xfa1c, 0xfa35, 0xfa4e, 0xfa67, 0xfa80,
	0xfa99, 0xfab2, 0xfacb, 0xfae4, 0xfafd, 0xfb16, 0xfb2f, 0xfb48,
	0xfb61, 0xfb7a, 0xfb94, 0xfbae, 0xfbc7, 0xfbe0, 0xfbf9, 0xfc12,
	// Entry 5B80 - 5BBF
	0xfc2b, 0xfc45, 0xfc5e, 0xfc77, 0xfc91, 0xfcaa, 0xfcc3, 0xfcdc,
	0xfcf5, 0xfd0e, 0xfd27, 0xfd41, 0xfd5a, 0xfd74, 0xfd8d, 0xfda6,
	0xfdbf, 0xfdd8, 0xfdf1, 0xfe0a, 0xfe23, 0xfe3c, 0xfe55, 0xfe6e,
	0xfe87, 0xfea1, 0xfeba, 0xfed3, 0xfeec, 0xff05, 0xff1e, 0xff37,
	0xff50, 0xff69, 0xff82, 0xff9b, 0xffb4, 0xffcd, 0xffe6, 0xffff,
	0x0018, 0x0031, 0x004a, 0x0063, 0x007c, 0x0095, 0x00ae, 0x00c7,
	0x00e0, 0x00f9, 0x0112, 0x012b, 0x0144, 0x015d, 0x0176, 0x018f,
	0x01a8, 0x01c1, 0x01da, 0x01f3, 0x020c, 0x0225, 0x023e, 0x0257,
	// Entry 5BC0 - 5BFF
	0x0270, 0x0289, 0x02a3, 0x02bc, 0x02d5, 0x02ee, 0x0307, 0x0320,
	0x0339, 0x0352, 0x036b, 0x0384, 0x039d, 0x03b6, 0x03cf, 0x03e8,
	0x0401, 0x041a, 0x0433, 0x044c, 0x0465, 0x047e, 0x0497, 0x04b0,
	0x04c9, 0x04e3, 0x04fc, 0x0515, 0x052e, 0x0547, 0x0560, 0x057a,
	0x0593, 0x05ac, 0x05c5, 0x05de, 0x05f7, 0x0611, 0x062a, 0x0643,
	0x065c, 0x0675, 0x068e, 0x06a7, 0x06c0, 0x06d9, 0x06f2, 0x070b,
	0x0725, 0x073e, 0x0757, 0x0770, 0x0789, 0x07a2, 0x07bb, 0x07d4,
	0x07ed, 0x0806, 0x081f, 0x0838, 0x0851, 0x086a, 0x0883, 0x089c,
	// Entry 5C00 - 5C3F
	0x08b5, 0x08ce, 0x08e7, 0x0900, 0x0919, 0x0933, 0x094c, 0x0965,
	0x097f, 0x0999, 0x09b3, 0x09cc, 0x09e5, 0x09fe, 0x0a17, 0x0a31,
	0x0a4b, 0x0a65, 0x0a7e, 0x0a97, 0x0ab0, 0x0ac9, 0x0ae2, 0x0afb,
	0x0b14, 0x0b2d, 0x0b46, 0x0b5f, 0x0b78, 0x0b91, 0x0baa, 0x0bc3,
	0x0bdc, 0x0bf5, 0x0c0e, 0x0c27, 0x0c40, 0x0c59, 0x0c72, 0x0c8b,
	0x0ca4, 0x0cbe, 0x0cd7, 0x0cf0, 0x0d09, 0x0d22, 0x0d3b, 0x0d55,
	0x0d6e, 0x0d87, 0x0da0, 0x0db9, 0x0dd3, 0x0dec, 0x0e05, 0x0e1e,
	0x0e38, 0x0e51, 0x0e6a, 0x0e83, 0x0e9c, 0x0eb5, 0x0ece, 0x0ee7,
	// Entry 5C40 - 5C7F
	0x0f00, 0x0f19, 0x0f32, 0x0f4c, 0x0f65, 0x0f87, 0x0fa1, 0x0fba,
	0x0fd3, 0x0fec, 0x1006, 0x101f, 0x1038, 0x1051, 0x106a, 0x1083,
	0x109c, 0x10bb, 0x10d4, 0x10ed, 0x1106, 0x111f, 0x1138, 0x1151,
	0x116a, 0x1183, 0x119c, 0x11b5, 0x11ce, 0x11e7, 0x1200, 0x1219,
	0x1232, 0x124b, 0x1278, 0x12a4, 0x12bd, 0x12d6, 0x12ef, 0x1308,
	0x1321, 0x133a, 0x1353, 0x136c, 0x1385, 0x139e, 0x13b7, 0x13d0,
	0x13e9, 0x1402, 0x141b, 0x1434, 0x144d, 0x1466, 0x147f, 0x1498,
	0x14b1, 0x14ca, 0x14e3, 0x14fc, 0x1515, 0x152e, 0x1547, 0x1560,
	// Entry 5C80 - 5CBF
	0x1579, 0x1592, 0x15ab, 0x15c4, 0x15dd, 0x15f6, 0x160f, 0x1628,
	0x1641, 0x165a, 0x1673, 0x168c, 0x16a6, 0x16bf, 0x16d8, 0x16f1,
	0x170a, 0x1723, 0x173c, 0x1755, 0x176f, 0x1788, 0x17a1, 0x17ba,
	0x17d3, 0x17ec, 0x1805, 0x181e, 0x1837, 0x1850, 0x1869, 0x1882,
	0x189b, 0x18b4, 0x18cd, 0x18e6, 0x18ff, 0x1918, 0x1931, 0x194a,
	0x1963, 0x197c, 0x1995, 0x19ae, 0x19c7, 0x19e0, 0x19f9, 0x1a12,
	0x1a2b, 0x1a44, 0x1a5d, 0x1a76, 0x1a8f, 0x1aa8, 0x1ac1, 0x1ada,
	0x1af3, 0x1b0c, 0x1b25, 0x1b3e, 0x1b57, 0x1b70, 0x1b89, 0x1ba2,
	// Entry 5CC0 - 5CFF
	0x1bbb, 0x1bd4, 0x1bed, 0x1c06, 0x1c1f, 0x1c38, 0x1c51, 0x1c6a,
	0x1c83, 0x1c9c, 0x1cb5, 0x1cce, 0x1ce7, 0x1d00, 0x1d19, 0x1d32,
	0x1d4b, 0x1d64, 0x1d7d, 0x1d96, 0x1daf, 0x1dc8, 0x1de1, 0x1dfa,
	0x1e13, 0x1e2c, 0x1e45, 0x1e64, 0x1e82, 0x1eab, 0x1ed1, 0x1eee,
	0x1f0d, 0x1f2b, 0x1f48, 0x1f6a, 0x1f95, 0x1fbd, 0x1fdc, 0x1ffa,
	0x2015, 0x2032, 0x204e, 0x206d, 0x2089, 0x20a5, 0x20c4, 0x20df,
	0x20f7, 0x2116, 0x2130, 0x214c, 0x216a, 0x2186, 0x21a1, 0x21bf,
	0x21db, 0x21fc, 0x221a, 0x2238, 0x2259, 0x2277, 0x2290, 0x22ab,
	// Entry 5D00 - 5D3F
	0x22cc, 0x22e8, 0x2301, 0x2321, 0x2342, 0x235a, 0x2377, 0x2390,
	0x23a8, 0x23c2, 0x23dc, 0x23f7, 0x2415, 0x2430, 0x2448, 0x2469,
	0x2482, 0x249e, 0x24b7, 0x24d2, 0x24eb, 0x2503, 0x251c, 0x2534,
	0x2552, 0x256d, 0x2586, 0x25a9, 0x25cd, 0x25e8, 0x2604, 0x2620,
	0x263a, 0x2654, 0x266d, 0x2688, 0x26a1, 0x26bc, 0x26d4, 0x26ed,
	0x2708, 0x2721, 0x2739, 0x2751, 0x276a, 0x2782, 0x2799, 0x27b1,
	0x27c9, 0x27e2, 0x27fd, 0x281e, 0x2837, 0x2852, 0x2870, 0x288f,
	0x28a9, 0x28c4, 0x28e0, 0x28f8, 0x2913, 0x2935, 0x2958, 0x2979,
	// Entry 5D40 - 5D7F
	0x2996, 0x29b6, 0x29ce, 0x29eb, 0x2a09, 0x2a27, 0x2a47, 0x2a68,
	0x2a86, 0x2aa1, 0x2abe, 0x2ada, 0x2af5, 0x2b0f, 0x2b28, 0x2b49,
	0x2b67, 0x2b81, 0x2b9d, 0x2bb6, 0x2bcf, 0x2bea, 0x2c0b, 0x2c26,
	0x2c3e, 0x2c59, 0x2c76, 0x2c92, 0x2cae, 0x2cce, 0x2ce7, 0x2d01,
	0x2d19, 0x2d34, 0x2d54, 0x2d71, 0x2d89, 0x2da4, 0x2dbd, 0x2dd4,
	0x2dec, 0x2e05, 0x2e26, 0x2e3e, 0x2e56, 0x2e73, 0x2e8d, 0x2eab,
	0x2ec5, 0x2ee0, 0x2efd, 0x2f17, 0x2f3d, 0x2f5a, 0x2f74, 0x2f90,
	0x2fab, 0x2fd1, 0x2ff0, 0x3009, 0x3024, 0x3042, 0x305c, 0x3075,
	// Entry 5D80 - 5DBF
	0x3091, 0x30aa, 0x30c3, 0x30de, 0x30f6, 0x310f, 0x3129, 0x3145,
	0x315f, 0x317c, 0x3196, 0x31b7, 0x31d0, 0x31ed, 0x320c, 0x3225,
	0x3240, 0x3258, 0x3275, 0x3291, 0x32ae, 0x32ca, 0x32e4, 0x32fc,
	0x3316, 0x332e, 0x3348, 0x3361, 0x337e, 0x3399, 0x33b0, 0x33ca,
	0x33e2, 0x33fe, 0x341d, 0x3438, 0x3450, 0x3469, 0x3483, 0x349e,
	0x34b5, 0x34cd, 0x34e6, 0x34ff, 0x3517, 0x3533, 0x354c, 0x3565,
	0x3586, 0x359f, 0x35b8, 0x35d5, 0x35ed, 0x3606, 0x3620, 0x363b,
	0x3653, 0x366e, 0x3689, 0x36a5, 0x36bf, 0x36d8, 0x36f8, 0x3712,
	// Entry 5DC0 - 5DFF
	0x372c, 0x3745, 0x375e, 0x3777, 0x3793, 0x37b3, 0x37cc, 0x37e4,
	0x37fc, 0x3814, 0x382c, 0x3844, 0x385d, 0x3875, 0x388d, 0x38a6,
	0x38c0, 0x38d9, 0x38f3, 0x390d, 0x392a, 0x3943, 0x395d, 0x3977,
	0x3990, 0x39aa, 0x39c9, 0x39e2, 0x39fd, 0x3a16, 0x3a2e, 0x3a46,
	0x3a62, 0x3a7b, 0x3a93, 0x3aad, 0x3ac7, 0x3ae3, 0x3afc, 0x3b17,
	0x3b2f, 0x3b4b, 0x3b6b, 0x3b87, 0x3b9e, 0x3bb7, 0x3bd2, 0x3bf0,
	0x3c09, 0x3c25, 0x3c40, 0x3c59, 0x3c72, 0x3c8d, 0x3ca6, 0x3cc1,
	0x3cd9, 0x3cf1, 0x3d0c, 0x3d25, 0x3d3f, 0x3d58, 0x3d73, 0x3d8b,
	// Entry 5E00 - 5E3F
	0x3da5, 0x3dbe, 0x3dd7, 0x3df1, 0x3e0e, 0x3e29, 0x3e44, 0x3e5d,
	0x3e75, 0x3e90, 0x3ea9, 0x3ec1, 0x3edc, 0x3ef6, 0x3f12, 0x3f2b,
	0x3f43, 0x3f5c, 0x3f75, 0x3f8f, 0x3fa8, 0x3fc0, 0x3fdb, 0x3ff6,
	0x400f, 0x4028, 0x4040, 0x4059, 0x4072, 0x408e, 0x40a8, 0x40c1,
	0x40dc, 0x40f6, 0x4110, 0x412b, 0x4142, 0x415e, 0x4176, 0x418e,
	0x41a6, 0x41be, 0x41d8, 0x41f2, 0x4208, 0x4220, 0x4237, 0x4250,
	0x426a, 0x4283, 0x429a, 0x42b2, 0x42cb, 0x42e3, 0x42fa, 0x4313,
	0x432b, 0x4344, 0x435c, 0x4379, 0x4390, 0x43a9, 0x43c8, 0x43e0,
	// Entry 5E40 - 5E7F
	0x43f8, 0x4411, 0x442a, 0x4444, 0x445c, 0x4474, 0x448d, 0x44a5,
	0x44bd, 0x44d5, 0x44f0, 0x4509, 0x4522, 0x453a, 0x4553, 0x456d,
	0x4585, 0x459d, 0x45ba, 0x45d3, 0x45eb, 0x4604, 0x461c, 0x4637,
	0x4650, 0x4669, 0x4684, 0x469d, 0x46b7, 0x46d2, 0x46ec, 0x4705,
	0x471d, 0x4739, 0x4752, 0x476c, 0x4789, 0x47a5, 0x47bd, 0x47d6,
	0x47f2, 0x480b, 0x482a, 0x4842, 0x485a, 0x487c, 0x48a0, 0x48b9,
	0x48d3, 0x48ec, 0x4906, 0x491d, 0x4937, 0x4951, 0x496b, 0x4986,
	0x49a0, 0x49b9, 0x49d2, 0x49e9, 0x4a02, 0x4a1e, 0x4a3b, 0x4a57,
	// Entry 5E80 - 5EBF
	0x4a71, 0x4a8a, 0x4aa3, 0x4abc, 0x4ad5, 0x4aed, 0x4b06, 0x4b1e,
	0x4b3e, 0x4b56, 0x4b70, 0x4b8a, 0x4ba4, 0x4bbd, 0x4bd8, 0x4bf0,
	0x4c0a, 0x4c24, 0x4c3c, 0x4c54, 0x4c70, 0x4c89, 0x4ca0, 0x4cb9,
	0x4cd2, 0x4ceb, 0x4d07, 0x4d27, 0x4d40, 0x4d59, 0x4d72, 0x4d8b,
	0x4da3, 0x4dbc, 0x4dd7, 0x4df0, 0x4e08, 0x4e21, 0x4e3b, 0x4e53,
	0x4e6c, 0x4e85, 0x4ea0, 0x4eba, 0x4ed8, 0x4ef4, 0x4f0c, 0x4f25,
	0x4f3b, 0x4f53, 0x4f69, 0x4f7f, 0x4f97, 0x4fb5, 0x4fcd, 0x4fe5,
	0x5007, 0x5020, 0x5039, 0x5053, 0x506d, 0x508e, 0x50ac, 0x50c4,
	// Entry 5EC0 - 5EFF
	0x50dc, 0x50f5, 0x510e, 0x512d, 0x5145, 0x515d, 0x5175, 0x518d,
	0x51a4, 0x51bb, 0x51d4, 0x51ec, 0x5207, 0x521f, 0x5237, 0x5250,
	0x526e, 0x5285, 0x529c, 0x52b4, 0x52cb, 0x52e3, 0x52fa, 0x5312,
	0x532a, 0x5341, 0x5359, 0x5371, 0x5389, 0x53a2, 0x53b9, 0x53cf,
	0x53e6, 0x53fd, 0x5415, 0x542d, 0x5445, 0x545c, 0x5474, 0x548d,
	0x54a7, 0x54bf, 0x54d8, 0x54f2, 0x5508, 0x5520, 0x5539, 0x5550,
	0x5569, 0x5582, 0x559a, 0x55b3, 0x55ca, 0x55e4, 0x55fc, 0x5614,
	0x562b, 0x5644, 0x565d, 0x5676, 0x568e, 0x56a6, 0x56bd, 0x56d4,
	// Entry 5F00 - 5F3F
	0x56ed, 0x5705, 0x5721, 0x573a, 0x5752, 0x576b, 0x5783, 0x579a,
	0x57b1, 0x57c9, 0x57e0, 0x57f9, 0x5811, 0x5828, 0x583f, 0x5858,
	0x5870, 0x5888, 0x58a2, 0x58bb, 0x58c8, 0x58d6, 0x58e3, 0x58f1,
	0x58fe, 0x590b, 0x5917, 0x5925, 0x5934, 0x5942, 0x5950, 0x595e,
	0x596e, 0x597b, 0x598a, 0x5998, 0x59a5, 0x59b2, 0x59be, 0x59cb,
	0x59d9, 0x59e8, 0x59f5, 0x5a02, 0x5a0e, 0x5a1b, 0x5a29, 0x5a36,
	0x5a44, 0x5a51, 0x5a5f, 0x5a6d, 0x5a7a, 0x5a87, 0x5a96, 0x5aa4,
	0x5ab2, 0x5abf, 0x5ace, 0x5add, 0x5aeb, 0x5af4, 0x5b04, 0x5b19,
	// Entry 5F40 - 5F7F
	0x5b2c, 0x5b3f, 0x5b52, 0x5b66, 0x5b7a, 0x5b8e, 0x5ba3, 0x5bb8,
	0x5bcb, 0x5be0, 0x5bf3, 0x5c06, 0x5c1a, 0x5c2d, 0x5c40, 0x5c54,
	0x5c67, 0x5c7a, 0x5c8d, 0x5ca2, 0x5cb5, 0x5ccb, 0x5cdd, 0x5cef,
	0x5d02, 0x5d14, 0x5d27, 0x5d39, 0x5d4b, 0x5d68, 0x5d84, 0x5da0,
	0x5dc0, 0x5de1, 0x5df4, 0x5e0b, 0x5e22, 0x5e38, 0x5e4e, 0x5e65,
	0x5e7c, 0x5e92, 0x5ea8, 0x5ebe, 0x5ed4, 0x5eeb, 0x5f02, 0x5f19,
	0x5f30, 0x5f47, 0x5f5e, 0x5f75, 0x5f8c, 0x5fa2, 0x5fb8, 0x5fcf,
	0x5fe6, 0x5ffc, 0x6012, 0x6028, 0x603e, 0x6055, 0x606c, 0x6086,
	// Entry 5F80 - 5FBF
	0x60a2, 0x60bc, 0x60d6, 0x60f1, 0x610b, 0x6126, 0x6141, 0x615b,
	0x6176, 0x6190, 0x61ab, 0x61c7, 0x61e2, 0x61fe, 0x621a, 0x6234,
	0x624d, 0x6267, 0x6281, 0x629a, 0x62b2, 0x62cb, 0x62e5, 0x62ff,
	0x6318, 0x6332, 0x634c, 0x636c, 0x6387, 0x63a2, 0x63bc, 0x63d9,
	0x63f4, 0x640f, 0x642b, 0x6445, 0x6460, 0x647a, 0x6492, 0x64a8,
	0x64c6, 0x64dd, 0x64f3, 0x6509, 0x6521, 0x6538, 0x654f, 0x6565,
	0x657d, 0x6595, 0x65ac, 0x65c4, 0x65e0, 0x6601, 0x661d, 0x6641,
	0x6661, 0x667e, 0x6697, 0x66ad, 0x66c2, 0x66e3, 0x66fd, 0x6713,
	// Entry 5FC0 - 5FFF
	0x6729, 0x673f, 0x6755, 0x6769, 0x6786, 0x67a2, 0x67b7, 0x67cc,
	0x67e1, 0x6809, 0x682a, 0x6844, 0x6863, 0x6881, 0x689f, 0x68bc,
	0x68d7, 0x68f1, 0x690c, 0x6928, 0x6942, 0x695d, 0x6978, 0x6993,
	0x69ae, 0x69c9, 0x69e4, 0x69fe, 0x6a18, 0x6a32, 0x6a4c, 0x6a67,
	0x6a81, 0x6a9b, 0x6ab7, 0x6ad3, 0x6aef, 0x6b0b, 0x6b2a, 0x6b46,
	0x6b63, 0x6b7f, 0x6b9b, 0x6bb7, 0x6bd3, 0x6bef, 0x6c0b, 0x6c27,
	0x6c43, 0x6c5f, 0x6c7b, 0x6c97, 0x6cb3, 0x6cd0, 0x6cec, 0x6d08,
	0x6d25, 0x6d42, 0x6d5e, 0x6d7a, 0x6d97, 0x6db3, 0x6dcf, 0x6deb,
	// Entry 6000 - 603F
	0x6e08, 0x6e24, 0x6e3e, 0x6e58, 0x6e72, 0x6e8c, 0x6ea9, 0x6ec3,
	0x6ede, 0x6ef8, 0x6f12, 0x6f2c, 0x6f46, 0x6f60, 0x6f7a, 0x6f94,
	0x6fae, 0x6fc8, 0x6fe2, 0x6ffc, 0x7016, 0x7031, 0x704b, 0x7065,
	0x7080, 0x709b, 0x70b5, 0x70cf, 0x70ea, 0x7104, 0x711e, 0x7138,
	0x7153, 0x716d, 0x7183, 0x7198, 0x71ad, 0x71c4, 0x71da, 0x71f0,
	0x7205, 0x721c, 0x7233, 0x7249, 0x725f, 0x7278, 0x7291, 0x72ac,
	0x72c7, 0x72e1, 0x72fb, 0x7317, 0x7332, 0x734d, 0x7371, 0x7395,
	0x73bb, 0x73cc, 0x73e1, 0x73f8, 0x7412, 0x7420, 0x742e, 0x743f,
	// Entry 6040 - 607F
	0x744e, 0x745c, 0x746b, 0x7481, 0x748f, 0x749d, 0x74ac, 0x74ba,
	0x74c8, 0x74da, 0x74eb, 0x74fa, 0x7509, 0x7517, 0x7526, 0x7538,
	0x754e, 0x755d, 0x756d, 0x757b, 0x758a, 0x7599, 0x75a9, 0x75b9,
	0x75c9, 0x75da, 0x75eb, 0x75f9, 0x7607, 0x7618, 0x7626, 0x7635,
	0x7644, 0x7654, 0x766b, 0x7679, 0x7687, 0x7696, 0x76a6, 0x76b6,
	0x76c6, 0x76d5, 0x76e5, 0x76f5, 0x7705, 0x7718, 0x772b, 0x7744,
	0x7753, 0x7762, 0x7771, 0x7781, 0x7790, 0x779f, 0x77b1, 0x77bf,
	0x77cd, 0x77dc, 0x77eb, 0x77fb, 0x7812, 0x7822, 0x7833, 0x7841,
	// Entry 6080 - 60BF
	0x784f, 0x785e, 0x7876, 0x788a, 0x78a4, 0x78c1, 0x78d2, 0x78e4,
	0x78f7, 0x7909, 0x791c, 0x792d, 0x793f, 0x7951, 0x7962, 0x7973,
	0x7985, 0x7998, 0x79ab, 0x79bc, 0x79ce, 0x79e1, 0x79f5, 0x7a07,
	0x7a19, 0x7a2b, 0x7a3d, 0x7a50, 0x7a61, 0x7a73, 0x7a86, 0x7a9a,
	0x7aac, 0x7abf, 0x7ad2, 0x7ae3, 0x7af5, 0x7b07, 0x7b1a, 0x7b2d,
	0x7b48, 0x7b5a, 0x7b74, 0x7b86, 0x7b98, 0x7baa, 0x7bbc, 0x7bcd,
	0x7bdf, 0x7bee, 0x7c01, 0x7c10, 0x7c1f, 0x7c31, 0x7c43, 0x7c55,
	0x7c67, 0x7c79, 0x7c8b, 0x7c9d, 0x7cb8, 0x7cd3, 0x7cee, 0x7d09,
	// Entry 60C0 - 60FF
	0x7d24, 0x7d3f, 0x7d54, 0x7d68, 0x7d7c, 0x7d90, 0x7da4, 0x7db8,
	0x7dcc, 0x7de0, 0x7df4, 0x7e08, 0x7e1c, 0x7e30, 0x7e44, 0x7e58,
	0x7e6c, 0x7e80, 0x7e94, 0x7ea8, 0x7ebc, 0x7ed0, 0x7ee4, 0x7ef8,
	0x7f0c, 0x7f20, 0x7f34, 0x7f48, 0x7f5c, 0x7f70, 0x7f84, 0x7f98,
	0x7fac, 0x7fc0, 0x7fd4, 0x7fe8, 0x7ffc, 0x8010, 0x8024, 0x8038,
	0x804c, 0x8060, 0x8074, 0x8088, 0x809c, 0x80b0, 0x80c4, 0x80d8,
	0x80ec, 0x8100, 0x8114, 0x8128, 0x813c, 0x8150, 0x8164, 0x8178,
	0x818c, 0x81a0, 0x81b4, 0x81c8, 0x81dc, 0x81f0, 0x8204, 0x8218,
	// Entry 6100 - 613F
	0x822c, 0x8240, 0x8254, 0x8268, 0x827c, 0x8290, 0x82a4, 0x82b8,
	0x82cc, 0x82e0, 0x82f4, 0x8308, 0x831c, 0x8330, 0x8344, 0x8358,
	0x836c, 0x8380, 0x8394, 0x83a8, 0x83bc, 0x83d0, 0x83e4, 0x83f8,
	0x840c, 0x8420, 0x8434, 0x8448, 0x845c, 0x8470, 0x8484, 0x8498,
	0x84ac, 0x84c0, 0x84d4, 0x84e8, 0x84fc, 0x8510, 0x8524, 0x8538,
	0x854c, 0x8560, 0x8574, 0x8588, 0x859c, 0x85b0, 0x85c4, 0x85d8,
	0x85ec, 0x8600, 0x8614, 0x8628, 0x863c, 0x8650, 0x8664, 0x8678,
	0x868c, 0x86a0, 0x86b4, 0x86c8, 0x86dc, 0x86f0, 0x8704, 0x8718,
	// Entry 6140 - 617F
	0x872c, 0x8740, 0x8754, 0x8768, 0x877c, 0x8790, 0x87a4, 0x87b8,
	0x87cc, 0x87e0, 0x87f4, 0x8808, 0x881c, 0x8830, 0x8844, 0x8858,
	0x886c, 0x8880, 0x8894, 0x88a8, 0x88bc, 0x88d0, 0x88e4, 0x88f8,
	0x890c, 0x8920, 0x8934, 0x8948, 0x895c, 0x8970, 0x8984, 0x8998,
	0x89ac, 0x89c0, 0x89d4, 0x89e8, 0x89fc, 0x8a10, 0x8a24, 0x8a38,
	0x8a4c, 0x8a60, 0x8a74, 0x8a88, 0x8a9c, 0x8ab0, 0x8ac4, 0x8ad8,
	0x8aec, 0x8b00, 0x8b14, 0x8b28, 0x8b3c, 0x8b50, 0x8b64, 0x8b78,
	0x8b8c, 0x8ba0, 0x8bb4, 0x8bc8, 0x8bdc, 0x8bf0, 0x8c04, 0x8c18,
	// Entry 6180 - 61BF
	0x8c2c, 0x8c40, 0x8c54, 0x8c68, 0x8c7c, 0x8c90, 0x8ca4, 0x8cb8,
	0x8ccc, 0x8ce0, 0x8cf4, 0x8d08, 0x8d1c, 0x8d30, 0x8d44, 0x8d58,
	0x8d6c, 0x8d80, 0x8d94, 0x8da8, 0x8dbc, 0x8dd0, 0x8de4, 0x8df8,
	0x8e0c, 0x8e20, 0x8e34, 0x8e48, 0x8e5c, 0x8e70, 0x8e84, 0x8e98,
	0x8eac, 0x8ec0, 0x8ed4, 0x8ee8, 0x8efc, 0x8f10, 0x8f24, 0x8f38,
	0x8f4c, 0x8f60, 0x8f74, 0x8f88, 0x8f9c, 0x8fb0, 0x8fc4, 0x8fd8,
	0x8fec, 0x9000, 0x9014, 0x9028, 0x903c, 0x9050, 0x9064, 0x9078,
	0x908c, 0x90a0, 0x90b4, 0x90c8, 0x90dc, 0x90f0, 0x9104, 0x9118,
	// Entry 61C0 - 61FF
	0x912c, 0x9140, 0x9154, 0x9168, 0x917c, 0x9190, 0x91a4, 0x91b8,
	0x91cc, 0x91e0, 0x91f4, 0x9208, 0x921c, 0x9230, 0x9244, 0x9258,
	0x926c, 0x9280, 0x9294, 0x92a8, 0x92bc, 0x92d0, 0x92e4, 0x92f8,
	0x930c, 0x9320, 0x9334, 0x9348, 0x935c, 0x9370, 0x9384, 0x9398,
	0x93ac, 0x93c0, 0x93d4, 0x93e8, 0x93fc, 0x9410, 0x9424, 0x9438,
	0x944c, 0x9460, 0x9474, 0x9488, 0x949c, 0x94b0, 0x94c4, 0x94d8,
	0x94ec, 0x9500, 0x9514, 0x9528, 0x953c, 0x9550, 0x9564, 0x9578,
	0x958c, 0x95a0, 0x95b4, 0x95c8, 0x95dc, 0x95f0, 0x9604, 0x9618,
	// Entry 6200 - 623F
	0x962c, 0x9640, 0x9654, 0x9668, 0x967c, 0x9690, 0x96a4, 0x96b8,
	0x96cc, 0x96e0, 0x96f4, 0x9708, 0x971c, 0x9730, 0x9744, 0x9758,
	0x976c, 0x9780, 0x9794, 0x97a8, 0x97bc, 0x97d0, 0x97e4, 0x97f8,
	0x980c, 0x9820, 0x9834, 0x9848, 0x985c, 0x9870, 0x9884, 0x9898,
	0x98ac, 0x98c0, 0x98d4, 0x98e8, 0x98fc, 0x9910, 0x9924, 0x9938,
	0x994c, 0x9960, 0x9974, 0x9988, 0x999c, 0x99b0, 0x99c4, 0x99d8,
	0x99ec, 0x9a00, 0x9a14, 0x9a28, 0x9a3c, 0x9a50, 0x9a64, 0x9a78,
	0x9a8c, 0x9aa0, 0x9ab4, 0x9ac8, 0x9adc, 0x9af0, 0x9b04, 0x9b18,
	// Entry 6240 - 627F
	0x9b2c, 0x9b40, 0x9b54, 0x9b68, 0x9b7c, 0x9b90, 0x9ba4, 0x9bb8,
	0x9bcc, 0x9be0, 0x9bf4, 0x9c08, 0x9c1c, 0x9c30, 0x9c44, 0x9c58,
	0x9c6c, 0x9c80, 0x9c94, 0x9ca8, 0x9cbc, 0x9cd0, 0x9ce4, 0x9cf8,
	0x9d0c, 0x9d20, 0x9d34, 0x9d48, 0x9d5c, 0x9d70, 0x9d84, 0x9d98,
	0x9dac, 0x9dc0, 0x9dd4, 0x9de8, 0x9dfc, 0x9e10, 0x9e24, 0x9e38,
	0x9e4c, 0x9e60, 0x9e74, 0x9e88, 0x9e9c, 0x9eb0, 0x9ec4, 0x9ed8,
	0x9eec, 0x9f00, 0x9f14, 0x9f28, 0x9f3c, 0x9f50, 0x9f64, 0x9f78,
	0x9f8c, 0x9fa0, 0x9fb4, 0x9fc8, 0x9fdc, 0x9ff0, 0xa004, 0xa018,
	// Entry 6280 - 62BF
	0xa02c, 0xa040, 0xa054, 0xa068, 0xa07c, 0xa090, 0xa0a4, 0xa0b8,
	0xa0cc, 0xa0e0, 0xa0f4, 0xa108, 0xa11c, 0xa130, 0xa144, 0xa158,
	0xa16c, 0xa180, 0xa194, 0xa1a8, 0xa1bc, 0xa1d0, 0xa1e4, 0xa1f8,
	0xa20c, 0xa220, 0xa234, 0xa248, 0xa25c, 0xa270, 0xa284, 0xa298,
	0xa2ac, 0xa2c0, 0xa2d4, 0xa2e8, 0xa2fc, 0xa310, 0xa324, 0xa338,
	0xa34c, 0xa360, 0xa374, 0xa388, 0xa39c, 0xa3b0, 0xa3c4, 0xa3d8,
	0xa3ec, 0xa400, 0xa414, 0xa428, 0xa43c, 0xa450, 0xa464, 0xa478,
	0xa48c, 0xa4a0, 0xa4b4, 0xa4c8, 0xa4dc, 0xa4f0, 0xa504, 0xa518,
	// Entry 62C0 - 62FF
	0xa52c, 0xa540, 0xa554, 0xa568, 0xa57c, 0xa590, 0xa5a4, 0xa5b8,
	0xa5cc, 0xa5e0, 0xa5f4, 0xa608, 0xa61c, 0xa630, 0xa644, 0xa658,
	0xa66c, 0xa680, 0xa694, 0xa6a8, 0xa6bc, 0xa6d0, 0xa6e4, 0xa6f8,
	0xa70c, 0xa720, 0xa734, 0xa748, 0xa75c, 0xa770, 0xa784, 0xa798,
	0xa7ac, 0xa7c0, 0xa7d4, 0xa7e8, 0xa7fc, 0xa810, 0xa824, 0xa838,
	0xa84c, 0xa860, 0xa874, 0xa888, 0xa89c, 0xa8b0, 0xa8c4, 0xa8d8,
	0xa8ec, 0xa900, 0xa914, 0xa928, 0xa93c, 0xa950, 0xa964, 0xa978,
	0xa98c, 0xa9a0, 0xa9b4, 0xa9c8, 0xa9dc, 0xa9f0, 0xaa04, 0xaa18,
	// Entry 6300 - 633F
	0xaa2c, 0xaa40, 0xaa54, 0xaa68, 0xaa7c, 0xaa90, 0xaaa4, 0xaab8,
	0xaacc, 0xaae0, 0xaaf4, 0xab08, 0xab1c, 0xab30, 0xab44, 0xab58,
	0xab6c, 0xab80, 0xab94, 0xaba8, 0xabbc, 0xabd0, 0xabe4, 0xabf8,
	0xac0c, 0xac20, 0xac34, 0xac48, 0xac5c, 0xac70, 0xac84, 0xac98,
	0xacac, 0xacc0, 0xacd4, 0xace8, 0xacfc, 0xad10, 0xad24, 0xad38,
	0xad4c, 0xad60, 0xad74, 0xad88, 0xad9c, 0xadb0, 0xadc4, 0xadd8,
	0xadec, 0xae00, 0xae14, 0xae28, 0xae3c, 0xae50, 0xae64, 0xae78,
	0xae8c, 0xaea0, 0xaeb4, 0xaec8, 0xaedc, 0xaef0, 0xaf04, 0xaf18,
	// Entry 6340 - 637F
	0xaf2c, 0xaf40, 0xaf54, 0xaf68, 0xaf7c, 0xaf90, 0xafa4, 0xafb8,
	0xafcc, 0xafe0, 0xaff4, 0xb008, 0xb01c, 0xb030, 0xb044, 0xb058,
	0xb06c, 0xb080, 0xb094, 0xb0a8, 0xb0bc, 0xb0d0, 0xb0e4, 0xb0f8,
	0xb10c, 0xb120, 0xb134, 0xb148, 0xb15c, 0xb170, 0xb184, 0xb198,
	0xb1ac, 0xb1c0, 0xb1d4, 0xb1e8, 0xb1fc, 0xb210, 0xb224, 0xb238,
	0xb24c, 0xb260, 0xb274, 0xb288, 0xb29c, 0xb2b0, 0xb2c4, 0xb2d8,
	0xb2ec, 0xb300, 0xb314, 0xb328, 0xb33c, 0xb350, 0xb364, 0xb378,
	0xb38c, 0xb3a0, 0xb3b4, 0xb3c8, 0xb3dc, 0xb3f0, 0xb404, 0xb418,
	// Entry 6380 - 63BF
	0xb42c, 0xb440, 0xb454, 0xb468, 0xb47c, 0xb490, 0xb4a4, 0xb4b8,
	0xb4cc, 0xb4e0, 0xb4f4, 0xb508, 0xb51c, 0xb530, 0xb544, 0xb558,
	0xb56c, 0xb580, 0xb594, 0xb5a8, 0xb5bc, 0xb5d0, 0xb5e4, 0xb5f8,
	0xb60c, 0xb620, 0xb634, 0xb648, 0xb65c, 0xb670, 0xb684, 0xb698,
	0xb6ac, 0xb6c0, 0xb6d4, 0xb6e8, 0xb6fc, 0xb710, 0xb724, 0xb738,
	0xb74c, 0xb760, 0xb774, 0xb788, 0xb79c, 0xb7b0, 0xb7c4, 0xb7d8,
	0xb7ec, 0xb800, 0xb814, 0xb828, 0xb83c, 0xb850, 0xb864, 0xb87d,
	0xb897, 0xb8ac, 0xb8c1, 0xb8d6, 0xb8ec, 0xb901, 0xb916, 0xb92b,
	// Entry 63C0 - 63FF
	0xb940, 0xb955, 0xb96a, 0xb97f, 0xb994, 0xb9a9, 0xb9be, 0xb9d3,
	0xb9e8, 0xb9fd, 0xba12, 0xba27, 0xba3c, 0xba51, 0xba67, 0xba7d,
	0xba93, 0xbaa9, 0xbabf, 0xbad5, 0xbaeb, 0xbb01, 0xbb17, 0xbb2e,
	0xbb45, 0xbb5c, 0xbb72, 0xbb88, 0xbb9e, 0xbbb4, 0xbbca, 0xbbe0,
	0xbbf6, 0xbc0c, 0xbc22, 0xbc38, 0xbc4e, 0xbc64, 0xbc7a, 0xbc90,
	0xbca6, 0xbcbc, 0xbcd2, 0xbce8, 0xbcfe, 0xbd14, 0xbd2a, 0xbd40,
	0xbd56, 0xbd6c, 0xbd83, 0xbd99, 0xbdaf, 0xbdc5, 0xbddb, 0xbdf1,
	0xbe07, 0xbe1d, 0xbe33, 0xbe49, 0xbe5f, 0xbe75, 0xbe8b, 0xbea1,
	// Entry 6400 - 643F
	0xbeb7, 0xbecd, 0xbee3, 0xbef9, 0xbf0f, 0xbf25, 0xbf3b, 0xbf51,
	0xbf67, 0xbf7d, 0xbf93, 0xbfa9, 0xbfbf, 0xbfd5, 0xbfeb, 0xc001,
	0xc017, 0xc02d, 0xc043, 0xc059, 0xc06f, 0xc085, 0xc09b, 0xc0b1,
	0xc0c7, 0xc0dd, 0xc0f3, 0xc109, 0xc11f, 0xc135, 0xc14b, 0xc161,
	0xc177, 0xc18d, 0xc1a3, 0xc1b9, 0xc1d0, 0xc1e6, 0xc1fc, 0xc212,
	0xc228, 0xc23e, 0xc254, 0xc26a, 0xc280, 0xc296, 0xc2ac, 0xc2c2,
	0xc2d8, 0xc2ee, 0xc304, 0xc31a, 0xc331, 0xc347, 0xc35d, 0xc373,
	0xc389, 0xc39f, 0xc3b5, 0xc3cb, 0xc3e1, 0xc3f7, 0xc40d, 0xc423,
	// Entry 6440 - 647F
	0xc439, 0xc44f, 0xc465, 0xc47b, 0xc491, 0xc4a8, 0xc4be, 0xc4d4,
	0xc4ea, 0xc500, 0xc516, 0xc52c, 0xc542, 0xc558, 0xc56e, 0xc585,
	0xc59b, 0xc5b1, 0xc5c7, 0xc5dd, 0xc5f3, 0xc609, 0xc61f, 0xc635,
	0xc64b, 0xc661, 0xc677, 0xc68d, 0xc6a3, 0xc6b9, 0xc6d0, 0xc6e7,
	0xc6fd, 0xc713, 0xc729, 0xc73f, 0xc755, 0xc76b, 0xc781, 0xc797,
	0xc7ad, 0xc7c3, 0xc7d9, 0xc7ef, 0xc805, 0xc81b, 0xc831, 0xc847,
	0xc85d, 0xc873, 0xc889, 0xc89f, 0xc8b5, 0xc8cb, 0xc8e1, 0xc8f7,
	0xc90d, 0xc923, 0xc939, 0xc94f, 0xc965, 0xc97b, 0xc991, 0xc9a7,
	// Entry 6480 - 64BF
	0xc9bd, 0xc9d3, 0xc9e9, 0xc9ff, 0xca15, 0xca2b, 0xca41, 0xca57,
	0xca6d, 0xca83, 0xca99, 0xcaaf, 0xcac5, 0xcadc, 0xcaf2, 0xcb08,
	0xcb1e, 0xcb34, 0xcb4a, 0xcb60, 0xcb76, 0xcb8c, 0xcba2, 0xcbb8,
	0xcbce, 0xcbe5, 0xcbfb, 0xcc11, 0xcc27, 0xcc3d, 0xcc53, 0xcc69,
	0xcc7f, 0xcc95, 0xccab, 0xccc1, 0xccd7, 0xcced, 0xcd03, 0xcd19,
	0xcd2f, 0xcd45, 0xcd5b, 0xcd71, 0xcd87, 0xcd9d, 0xcdb3, 0xcdc9,
	0xcddf, 0xcdf5, 0xce0b, 0xce21, 0xce37, 0xce4d, 0xce63, 0xce79,
	0xce8f, 0xcea5, 0xcebb, 0xced1, 0xcee7, 0xcefd, 0xcf13, 0xcf29,
	// Entry 64C0 - 64FF
	0xcf3f, 0xcf55, 0xcf6b, 0xcf81, 0xcf97, 0xcfad, 0xcfc3, 0xcfd9,
	0xcfef, 0xd005, 0xd01b, 0xd031, 0xd047, 0xd05d, 0xd073, 0xd089,
	0xd09f, 0xd0b5, 0xd0cb, 0xd0e1, 0xd0fc, 0xd117, 0xd12c, 0xd141,
	0xd156, 0xd16b, 0xd180, 0xd195, 0xd1aa, 0xd1bf, 0xd1d4, 0xd1e9,
	0xd1fe, 0xd213, 0xd228, 0xd23d, 0xd252, 0xd267, 0xd27c, 0xd291,
	0xd2a6, 0xd2bb, 0xd2d0, 0xd2e5, 0xd2fa, 0xd30f, 0xd324, 0xd339,
	0xd34e, 0xd363, 0xd378, 0xd38d, 0xd3a2, 0xd3b7, 0xd3cc, 0xd3e1,
	0xd3f6, 0xd40b, 0xd420, 0xd435, 0xd44a, 0xd45f, 0xd474, 0xd489,
	// Entry 6500 - 653F
	0xd49e, 0xd4b3, 0xd4c8, 0xd4dd, 0xd4f2, 0xd507, 0xd51c, 0xd531,
	0xd546, 0xd55b, 0xd570, 0xd585, 0xd59a, 0xd5af, 0xd5c4, 0xd5d9,
	0xd5ee, 0xd603, 0xd618, 0xd62d, 0xd642, 0xd657, 0xd66c, 0xd681,
	0xd696, 0xd6ab, 0xd6c0, 0xd6d5, 0xd6ea, 0xd6ff, 0xd714, 0xd729,
	0xd73e, 0xd753, 0xd768, 0xd77d, 0xd792, 0xd7a7, 0xd7bc, 0xd7d1,
	0xd7e6, 0xd7fb, 0xd810, 0xd825, 0xd83a, 0xd84f, 0xd864, 0xd879,
	0xd88e, 0xd8a3, 0xd8b8, 0xd8cd, 0xd8e2, 0xd8f7, 0xd90c, 0xd921,
	0xd936, 0xd94b, 0xd960, 0xd975, 0xd98a, 0xd99f, 0xd9b4, 0xd9c9,
	// Entry 6540 - 657F
	0xd9de, 0xd9f3, 0xda08, 0xda1d, 0xda32, 0xda47, 0xda5c, 0xda71,
	0xda86, 0xda9b, 0xdab0, 0xdac5, 0xdada, 0xdaef, 0xdb04, 0xdb19,
	0xdb2e, 0xdb43, 0xdb58, 0xdb6d, 0xdb82, 0xdb97, 0xdbac, 0xdbc1,
	0xdbd6, 0xdbeb, 0xdc00, 0xdc15, 0xdc2a, 0xdc3f, 0xdc54, 0xdc69,
	0xdc7e, 0xdc93, 0xdca8, 0xdcbd, 0xdcd2, 0xdce7, 0xdcfc, 0xdd11,
	0xdd26, 0xdd3b, 0xdd50, 0xdd65, 0xdd7a, 0xdd8f, 0xdda4, 0xddb9,
	0xddce, 0xdde3, 0xddf8, 0xde0d, 0xde22, 0xde37, 0xde4c, 0xde61,
	0xde76, 0xde8b, 0xdea0, 0xdeb5, 0xdeca, 0xdedf, 0xdef4, 0xdf09,
	// Entry 6580 - 65BF
	0xdf1e, 0xdf33, 0xdf48, 0xdf5d, 0xdf72, 0xdf87, 0xdf9c, 0xdfb1,
	0xdfc6, 0xdfdb, 0xdff0, 0xe005, 0xe01a, 0xe02f, 0xe044, 0xe059,
	0xe06e, 0xe083, 0xe098, 0xe0ad, 0xe0c2, 0xe0d7, 0xe0ec, 0xe101,
	0xe116, 0xe12b, 0xe140, 0xe155, 0xe16a, 0xe17f, 0xe194, 0xe1a9,
	0xe1be, 0xe1d3, 0xe1e8, 0xe1fd, 0xe212, 0xe227, 0xe23c, 0xe251,
	0xe266, 0xe27b, 0xe290, 0xe2a5, 0xe2ba, 0xe2cf, 0xe2e4, 0xe2f9,
	0xe30e, 0xe323, 0xe338, 0xe34d, 0xe362, 0xe377, 0xe38c, 0xe3a1,
	0xe3b6, 0xe3cb, 0xe3e0, 0xe3f5, 0xe40a, 0xe41f, 0xe434, 0xe449,
	// Entry 65C0 - 65FF
	0xe45e, 0xe473, 0xe488, 0xe49d, 0xe4b2, 0xe4c7, 0xe4dc, 0xe4f1,
	0xe506, 0xe51b, 0xe530, 0xe545, 0xe55a, 0xe56f, 0xe584, 0xe599,
	0xe5ae, 0xe5c3, 0xe5d8, 0xe5ed, 0xe602, 0xe617, 0xe62c, 0xe641,
	0xe656, 0xe66b, 0xe680, 0xe695, 0xe6aa, 0xe6bf, 0xe6d4, 0xe6e9,
	0xe6fe, 0xe713, 0xe728, 0xe73d, 0xe752, 0xe767, 0xe77c, 0xe791,
	0xe7a6, 0xe7bb, 0xe7d0, 0xe7e5, 0xe7fa, 0xe80f, 0xe824, 0xe839,
	0xe84e, 0xe863, 0xe878, 0xe88d, 0xe8a2, 0xe8b7, 0xe8cc, 0xe8e1,
	0xe8f6, 0xe90b, 0xe920, 0xe935, 0xe94a, 0xe95f, 0xe974, 0xe989,
	// Entry 6600 - 663F
	0xe99e, 0xe9b3, 0xe9c8, 0xe9dd, 0xe9f2, 0xea07, 0xea1c, 0xea31,
	0xea46, 0xea5b, 0xea70, 0xea85, 0xea9a, 0xeaaf, 0xeac4, 0xead9,
	0xeaee, 0xeb03, 0xeb18, 0xeb2d, 0xeb42, 0xeb57, 0xeb6c, 0xeb81,
	0xeb96, 0xebab, 0xebc0, 0xebd5, 0xebea, 0xebff, 0xec14, 0xec29,
	0xec3e, 0xec53, 0xec68, 0xec7d, 0xec92, 0xeca7, 0xecbc, 0xecd1,
	0xece6, 0xecfb, 0xed10, 0xed25, 0xed3a, 0xed4f, 0xed64, 0xed79,
	0xed8e, 0xeda3, 0xedb8, 0xedcd, 0xede2, 0xedf7, 0xee0c, 0xee21,
	0xee36, 0xee4b, 0xee60, 0xee75, 0xee8a, 0xee9f, 0xeeb4, 0xeec9,
	// Entry 6640 - 667F
	0xeede, 0xeef3, 0xef08, 0xef1d, 0xef32, 0xef47, 0xef5c, 0xef71,
	0xef86, 0xef9b, 0xefb0, 0xefc5, 0xefda, 0xefef, 0xf004, 0xf019,
	0xf02e, 0xf043, 0xf058, 0xf06d, 0xf082, 0xf097, 0xf0ac, 0xf0c1,
	0xf0d6, 0xf0eb, 0xf100, 0xf115, 0xf12a, 0xf13f, 0xf154, 0xf169,
	0xf17e, 0xf193, 0xf1a4, 0xf1b5, 0xf1c6, 0xf1d7, 0xf1e8, 0xf1f9,
	0xf20a, 0xf21b, 0xf22c, 0xf23d, 0xf24e, 0xf25f, 0xf272, 0xf285,
	0xf298, 0xf2ab, 0xf2be, 0xf2d0, 0xf2e8, 0xf2fa, 0xf30c, 0xf323,
	0xf335, 0xf347, 0xf359, 0xf36a, 0xf37b, 0xf38c, 0xf39d, 0xf3b0,
	// Entry 6680 - 66BF
	0xf3c3, 0xf3d6, 0xf3e9, 0xf403, 0xf41d, 0xf437, 0xf463, 0xf47d,
	0xf49d, 0xf4b0, 0xf4c3, 0xf4d6, 0xf4e9, 0xf4fe, 0xf513, 0xf528,
	0xf53d, 0xf559, 0xf56c, 0xf581, 0xf594, 0xf5a9, 0xf5bc, 0xf5d1,
	0xf5e4, 0xf5f9, 0xf60a, 0xf61c, 0xf62f, 0xf642, 0xf655, 0xf66a,
	0xf67f, 0xf692, 0xf6a7, 0xf6b8, 0xf6d0, 0xf6e2, 0xf6f3, 0xf706,
	0xf717, 0xf728, 0xf73a, 0xf751, 0xf763, 0xf775, 0xf78d, 0xf7a7,
	0xf7bf, 0xf7d5, 0xf7e7, 0xf7f8, 0xf80a, 0xf81c, 0xf82f, 0xf845,
	0xf85f, 0xf871, 0xf888, 0xf89b, 0xf8ad, 0xf8bf, 0xf8d1, 0xf8e3,
	// Entry 66C0 - 66FF
	0xf8f5, 0xf908, 0xf91b, 0xf932, 0xf949, 0xf960, 0xf977, 0xf990,
	0xf9a9, 0xf9c1, 0xf9d9, 0xf9f1, 0xfa0a, 0xfa2f, 0xfa53, 0xfa79,
	0xfa9b, 0xfabd, 0xfae0, 0xfafe, 0xfb2a, 0xfb49, 0xfb65, 0xfb83,
	0xfba1, 0xfbc5, 0xfbde, 0xfbfd, 0xfc16, 0xfc34, 0xfc4b, 0xfc65,
	0xfc7d, 0xfc95, 0xfcb1, 0xfcc9, 0xfce7, 0xfcff, 0xfd1c, 0xfd32,
	0xfd4b, 0xfd62, 0xfd79, 0xfd94, 0xfdac, 0xfdc6, 0xfde4, 0xfdf8,
	0xfe1e, 0xfe3d, 0xfe60, 0xfe7a, 0xfe92, 0xfeb0, 0xfecf, 0xfef3,
	0xff1d, 0xff41, 0xff6c, 0xff91, 0xffb2, 0xffd4, 0xfff8, 0x001a,
	// Entry 6700 - 673F
	0x0042, 0x0063, 0x008d, 0x00b5, 0x00d4, 0x00f6, 0x0119, 0x0142,
	0x0162, 0x0180, 0x01a8, 0x01d0, 0x01ef, 0x0210, 0x022e, 0x0254,
	0x027d, 0x02a8, 0x02c9, 0x02ea, 0x0313, 0x033b, 0x0364, 0x038e,
	0x03af, 0x03ce, 0x03ec, 0x0414, 0x0434, 0x0459, 0x0478, 0x04a1,
	0x04ce, 0x04f9, 0x0517, 0x0535, 0x0551, 0x056e, 0x058e, 0x05b0,
	0x05d6, 0x05fe, 0x0620, 0x064a, 0x0672, 0x0693, 0x06b5, 0x06d6,
	0x0700, 0x0720, 0x074d, 0x077a, 0x079a, 0x07b7, 0x07d7, 0x07fd,
	0x0823, 0x0848, 0x086d, 0x088e, 0x08b1, 0x08d3, 0x08f3, 0x0914,
	// Entry 6740 - 677F
	0x093c, 0x0964, 0x0989, 0x09b3, 0x09db, 0x09fa, 0x0a21, 0x0a52,
	0x0a72, 0x0a9a, 0x0aba, 0x0ada, 0x0afe, 0x0b21, 0x0b44, 0x0b6a,
	0x0b89, 0x0bac, 0x0bcc, 0x0bf4, 0x0c1c, 0x0c47, 0x0c67, 0x0c8f,
	0x0cb4, 0x0cd7, 0x0cfb, 0x0d19, 0x0d3e, 0x0d5f, 0x0d82, 0x0da7,
	0x0dd0, 0x0df8, 0x0e1f, 0x0e4a, 0x0e76, 0x0e9d, 0x0ec5, 0x0eec,
	0x0f12, 0x0f3f, 0x0f65, 0x0f8d, 0x0fb5, 0x0fda, 0x1003, 0x1025,
	0x1047, 0x1069, 0x108a, 0x10aa, 0x10cd, 0x10f4, 0x111d, 0x1142,
	0x1166, 0x118b, 0x11a8, 0x11c6, 0x11e5, 0x1206, 0x1226, 0x1252,
	// Entry 6780 - 67BF
	0x127d, 0x12aa, 0x12da, 0x1309, 0x1330, 0x1366, 0x1399, 0x13ba,
	0x13f7, 0x1433, 0x1468, 0x148a, 0x14a8, 0x14cb, 0x14eb, 0x1513,
	0x153a, 0x155d, 0x1582, 0x15a5, 0x15c9, 0x15f1, 0x161a, 0x1648,
	0x167b, 0x16ab, 0x16e0, 0x170e, 0x1739, 0x1769, 0x17a1, 0x17d0,
	0x17ff, 0x182f, 0x1863, 0x1891, 0x18be, 0x18e9, 0x1916, 0x1948,
	0x1980, 0x19ac, 0x19d9, 0x1a08, 0x1a29, 0x1a4c, 0x1a83, 0x1aaf,
	0x1add, 0x1b07, 0x1b33, 0x1b66, 0x1b92, 0x1bbe, 0x1bef, 0x1c1f,
	0x1c56, 0x1c8f, 0x1cc3, 0x1cf8, 0x1d1e, 0x1d42, 0x1d67, 0x1d8c,
	// Entry 67C0 - 67FF
	0x1dc2, 0x1df6, 0x1e21, 0x1e4c, 0x1e79, 0x1eaa, 0x1ee6, 0x1f1b,
	0x1f53, 0x1f84, 0x1fc0, 0x1ff5, 0x202d, 0x2053, 0x2079, 0x20a5,
	0x20d2, 0x20f9, 0x2122, 0x214b, 0x217c, 0x21ae, 0x21e2, 0x220a,
	0x223a, 0x226b, 0x229e, 0x22c2, 0x22e7, 0x2306, 0x2329, 0x234d,
	0x2370, 0x2393, 0x23b6, 0x23d9, 0x23fc, 0x2427, 0x2450, 0x247b,
	0x24a4, 0x24c8, 0x24f0, 0x250d, 0x252a, 0x2546, 0x256a, 0x2587,
	0x25a3, 0x25c2, 0x25e2, 0x25fc, 0x2614, 0x262a, 0x263e, 0x2651,
	0x2671, 0x2691, 0x26b1, 0x26c7, 0x26e3, 0x26fd, 0x2713, 0x2727,
	// Entry 6800 - 683F
	0x273d, 0x275a, 0x2777, 0x2796, 0x27b4, 0x27d2, 0x27ef, 0x2812,
	0x2836, 0x284b, 0x286c, 0x288e, 0x28a3, 0x28b8, 0x28d9, 0x28fb,
	0x2915, 0x292f, 0x2953, 0x296e, 0x2988, 0x299e, 0x29b6, 0x29cf,
	0x29ea, 0x2a01, 0x2a1a, 0x2a3b, 0x2a5b, 0x2a75, 0x2a8c, 0x2aa6,
	0x2ac1, 0x2ae1, 0x2b02, 0x2b1b, 0x2b34, 0x2b4c, 0x2b67, 0x2b81,
	0x2b9e, 0x2bbf, 0x2bdf, 0x2c0c, 0x2c25, 0x2c41, 0x2c61, 0x2c85,
	0x2ca9, 0x2cd2, 0x2cfb, 0x2d26, 0x2d51, 0x2d7d, 0x2da9, 0x2dd4,
	0x2dff, 0x2e2e, 0x2e5d, 0x2e7f, 0x2ea1, 0x2ed2, 0x2f03, 0x2f26,
	// Entry 6840 - 687F
	0x2f42, 0x2f5f, 0x2f7b, 0x2fa0, 0x2fc5, 0x2fd9, 0x2ff2, 0x300a,
	0x3025, 0x303f, 0x305c, 0x307d, 0x309d, 0x30ca, 0x30e7, 0x3111,
	0x3133, 0x3155, 0x3177, 0x3198, 0x31b9, 0x31da, 0x3203, 0x3222,
	0x3241, 0x3260, 0x327f, 0x329e, 0x32b7, 0x32ce, 0x32e6, 0x32fc,
	0x3315, 0x332c, 0x3347, 0x3360, 0x337f, 0x33a0, 0x33bf, 0x33e5,
	0x3405, 0x342e, 0x3456, 0x3474, 0x3490, 0x34ae, 0x34cb, 0x34e7,
	0x3504, 0x3522, 0x353f, 0x3565, 0x358b, 0x35a5, 0x35ba, 0x35ca,
	0x35de, 0x35f2, 0x3606, 0x361e, 0x3638, 0x3657, 0x3679, 0x368a,
	// Entry 6880 - 68BF
	0x369d, 0x36b9, 0x36d2, 0x36e8, 0x3708, 0x3728, 0x3748, 0x3768,
	0x3788, 0x37a8, 0x37c8, 0x37e8, 0x3808, 0x3829, 0x384a, 0x3864,
	0x387e, 0x389a, 0x38b5, 0x38d6, 0x38f5, 0x3916, 0x393d, 0x3956,
	0x3972, 0x3990, 0x39ab, 0x39c8, 0x39e7, 0x39fa, 0x3a11, 0x3a26,
	0x3a3a, 0x3a4f, 0x3a6e, 0x3a8d, 0x3aa2, 0x3abd, 0x3adc, 0x3afb,
	0x3b14, 0x3b2d, 0x3b4f, 0x3b73, 0x3b8d, 0x3bab, 0x3bc5, 0x3be3,
	0x3c1a, 0x3c53, 0x3c97, 0x3cd0, 0x3d0b, 0x3d53, 0x3d9b, 0x3de3,
	0x3df7, 0x3e16, 0x3e35, 0x3e4c, 0x3e60, 0x3e76, 0x3e8b, 0x3ea3,
	// Entry 68C0 - 68FF
	0x3eba, 0x3ed1, 0x3ee9, 0x3f08, 0x3f27, 0x3f48, 0x3f65, 0x3f81,
	0x3fa3, 0x3fc3, 0x3fe8, 0x4008, 0x4027, 0x4053, 0x407d, 0x40a8,
	0x40d1, 0x40f0, 0x410d, 0x412a, 0x4147, 0x4164, 0x4181, 0x419e,
	0x41bb, 0x41d8, 0x41f5, 0x4213, 0x4231, 0x424f, 0x426d, 0x428b,
	0x42a9, 0x42c7, 0x42e5, 0x4303, 0x4321, 0x433f, 0x435d, 0x437b,
	0x4399, 0x43b7, 0x43d5, 0x43f3, 0x4411, 0x442f, 0x444d, 0x4471,
	0x4495, 0x44b9, 0x44dd, 0x4501, 0x4525, 0x454a, 0x456f, 0x4594,
	0x45b9, 0x45de, 0x4603, 0x4628, 0x464d, 0x4672, 0x4697, 0x46bc,
	// Entry 6900 - 693F
	0x46e1, 0x4706, 0x472b, 0x4750, 0x4775, 0x479a, 0x47bf, 0x47e4,
	0x4809, 0x482e, 0x4853, 0x4878, 0x489d, 0x48c2, 0x48e7, 0x490c,
	0x4931, 0x4956, 0x497b, 0x49a0, 0x49bf, 0x49e0, 0x4a01, 0x4a15,
	0x4a27, 0x4a38, 0x4a49, 0x4a5c, 0x4a6e, 0x4a80, 0x4a91, 0x4aa4,
	0x4ab7, 0x4ac9, 0x4ada, 0x4aee, 0x4b02, 0x4b18, 0x4b2e, 0x4b43,
	0x4b58, 0x4b6f, 0x4b85, 0x4b9b, 0x4bad, 0x4bc6, 0x4bdc, 0x4bf5,
	0x4c0d, 0x4c1d, 0x4c31, 0x4c4a, 0x4c5d, 0x4c72, 0x4c8d, 0x4ca6,
	0x4cba, 0x4cd2, 0x4ced, 0x4d16, 0x4d2e, 0x4d48, 0x4d5e, 0x4d77,
	// Entry 6940 - 697F
	0x4d8a, 0x4d9f, 0x4db9, 0x4dce, 0x4de5, 0x4dfa, 0x4e0f, 0x4e27,
	0x4e39, 0x4e4a, 0x4e62, 0x4e79, 0x4e8d, 0x4ea1, 0x4ebb, 0x4ed8,
	0x4eed, 0x4f01, 0x4f18, 0x4f2d, 0x4f44, 0x4f5a, 0x4f6e, 0x4f84,
	0x4f9b, 0x4fb5, 0x4fcb, 0x4fe6, 0x4ffe, 0x5011, 0x5028, 0x5041,
	0x5056, 0x506a, 0x507e, 0x509f, 0x50b6, 0x50cb, 0x50e1, 0x50f4,
	0x510e, 0x5128, 0x5141, 0x515b, 0x5170, 0x518a, 0x51a5, 0x51b8,
	0x51cb, 0x51e0, 0x51f3, 0x520a, 0x5221, 0x5236, 0x524e, 0x5265,
	0x527b, 0x5291, 0x52a9, 0x52be, 0x52d3, 0x52ec, 0x5304, 0x531e,
	// Entry 6980 - 69BF
	0x5338, 0x534f, 0x5366, 0x5381, 0x539c, 0x53b9, 0x53d5, 0x53f1,
	0x540c, 0x5429, 0x5446, 0x5462, 0x547d, 0x5498, 0x54b5, 0x54d1,
	0x54ed, 0x5508, 0x5525, 0x5542, 0x555e, 0x5578, 0x5592, 0x55ae,
	0x55c9, 0x55e4, 0x55f2, 0x5601, 0x561c, 0x5637, 0x5652, 0x566d,
	0x5688, 0x56a3, 0x56be, 0x56d9, 0x56f4, 0x570f, 0x572a, 0x5745,
	0x5760, 0x577b, 0x5796, 0x57b1, 0x57cc, 0x57e7, 0x5802, 0x581d,
	0x5838, 0x5853, 0x586e, 0x5889, 0x58a4, 0x58bf, 0x58d8, 0x58f1,
	0x590a, 0x5923, 0x593c, 0x5955, 0x596e, 0x5987, 0x59a0, 0x59b9,
	// Entry 69C0 - 69FF
	0x59d2, 0x59eb, 0x5a04, 0x5a1d, 0x5a36, 0x5a4f, 0x5a68, 0x5a81,
	0x5a9a, 0x5ab3, 0x5acc, 0x5ae5, 0x5afe, 0x5b17, 0x5b30, 0x5b49,
	0x5b66, 0x5b83, 0x5ba0, 0x5bbd, 0x5bda, 0x5bf7, 0x5c14, 0x5c31,
	0x5c4e, 0x5c6b, 0x5c88, 0x5ca5, 0x5cc2, 0x5cdf, 0x5cfc, 0x5d19,
	0x5d36, 0x5d53, 0x5d70, 0x5d8d, 0x5daa, 0x5dc7, 0x5de4, 0x5e01,
	0x5e1e, 0x5e3b, 0x5e56, 0x5e71, 0x5e8c, 0x5ea7, 0x5ec2, 0x5edd,
	0x5ef8, 0x5f13, 0x5f2e, 0x5f49, 0x5f64, 0x5f7f, 0x5f9a, 0x5fb5,
	0x5fd0, 0x5feb, 0x6006, 0x6021, 0x603c, 0x6057, 0x6072, 0x608d,
	// Entry 6A00 - 6A3F
	0x60a8, 0x60c3, 0x60de, 0x6100, 0x6122, 0x6144, 0x6166, 0x6188,
	0x61aa, 0x61cc, 0x61ee, 0x6210, 0x6232, 0x6254, 0x6276, 0x6298,
	0x62ba, 0x62dc, 0x62fe, 0x6320, 0x6342, 0x6364, 0x6386, 0x63a8,
	0x63ca, 0x63ec, 0x640e, 0x6430, 0x6452, 0x6472, 0x6492, 0x64b2,
	0x64d2, 0x64f2, 0x6512, 0x6532, 0x6552, 0x6572, 0x6592, 0x65b2,
	0x65d2, 0x65f2, 0x6612, 0x6632, 0x6652, 0x6672, 0x6692, 0x66b2,
	0x66d2, 0x66f2, 0x6712, 0x6732, 0x6752, 0x6772, 0x6792, 0x67af,
	0x67cc, 0x67e9, 0x6806, 0x6823, 0x6840, 0x685d, 0x687a, 0x6897,
	// Entry 6A40 - 6A7F
	0x68b4, 0x68d1, 0x68ee, 0x690b, 0x6928, 0x6945, 0x6962, 0x697f,
	0x699c, 0x69b7, 0x69d2, 0x69ed, 0x6a08, 0x6a23, 0x6a3e, 0x6a59,
	0x6a74, 0x6a8f, 0x6aaa, 0x6ac5, 0x6ae0, 0x6afb, 0x6b16, 0x6b31,
	0x6b4c, 0x6b67, 0x6b82, 0x6b9d, 0x6bb8, 0x6bd3, 0x6bee, 0x6c09,
	0x6c2b, 0x6c4d, 0x6c6f, 0x6c91, 0x6cb3, 0x6cd5, 0x6cf7, 0x6d19,
	0x6d3b, 0x6d5d, 0x6d7f, 0x6da1, 0x6dc3, 0x6de5, 0x6e07, 0x6e29,
	0x6e4b, 0x6e6d, 0x6e8f, 0x6eb1, 0x6ed3, 0x6ef5, 0x6f17, 0x6f39,
	0x6f5b, 0x6f7d, 0x6f9d, 0x6fbd, 0x6fdd, 0x6ffd, 0x701d, 0x703d,
	// Entry 6A80 - 6ABF
	0x705d, 0x707d, 0x709d, 0x70bd, 0x70dd, 0x70fd, 0x711d, 0x713d,
	0x715d, 0x717d, 0x719d, 0x71bd, 0x71dd, 0x71fd, 0x721d, 0x723d,
	0x725d, 0x727d, 0x729d, 0x72bd, 0x72db, 0x72f9, 0x7317, 0x7335,
	0x7353, 0x7371, 0x738f, 0x73ad, 0x73cb, 0x73e9, 0x7407, 0x7425,
	0x7443, 0x7461, 0x747f, 0x749d, 0x74bb, 0x74d9, 0x74f7, 0x7515,
	0x7533, 0x754f, 0x756b, 0x7587, 0x75a3, 0x75bf, 0x75db, 0x75f7,
	0x7613, 0x762f, 0x764b, 0x7667, 0x7683, 0x769f, 0x76bb, 0x76d7,
	0x76f3, 0x770f, 0x772b, 0x7747, 0x7763, 0x777f, 0x779b, 0x77b7,
	// Entry 6AC0 - 6AFF
	0x77d3, 0x77ef, 0x780b, 0x782f, 0x7853, 0x7877, 0x789b, 0x78bf,
	0x78e3, 0x7907, 0x792b, 0x794f, 0x7973, 0x7997, 0x79bb, 0x79df,
	0x7a03, 0x7a27, 0x7a4b, 0x7a6f, 0x7a93, 0x7ab7, 0x7ad9, 0x7afb,
	0x7b1d, 0x7b3f, 0x7b61, 0x7b83, 0x7ba5, 0x7bc7, 0x7be9, 0x7c0b,
	0x7c2d, 0x7c4f, 0x7c71, 0x7c93, 0x7cb5, 0x7cd7, 0x7cf9, 0x7d1b,
	0x7d3d, 0x7d5f, 0x7d81, 0x7da3, 0x7dc5, 0x7de7, 0x7e09, 0x7e2b,
	0x7e4e, 0x7e71, 0x7e94, 0x7eb7, 0x7eda, 0x7efd, 0x7f20, 0x7f43,
	0x7f66, 0x7f89, 0x7fac, 0x7fcf, 0x7ff2, 0x8015, 0x8038, 0x805b,
	// Entry 6B00 - 6B3F
	0x807e, 0x80a1, 0x80c4, 0x80e7, 0x810a, 0x812d, 0x8150, 0x8173,
	0x8196, 0x81b9, 0x81da, 0x81fb, 0x821c, 0x823d, 0x825e, 0x827f,
	0x82a0, 0x82c1, 0x82e2, 0x8303, 0x8324, 0x8345, 0x8366, 0x8387,
	0x83a8, 0x83c9, 0x83ea, 0x840b, 0x842c, 0x844d, 0x846e, 0x848f,
	0x84b0, 0x84d1, 0x84f2, 0x8513, 0x8534, 0x8555, 0x8576, 0x8597,
	0x85b8, 0x85d9, 0x85fa, 0x861b, 0x863c, 0x865d, 0x867e, 0x869f,
	0x86c0, 0x86e1, 0x8702, 0x8723, 0x8744, 0x8765, 0x8786, 0x87a7,
	0x87c8, 0x87e9, 0x880a, 0x882b, 0x884c, 0x886d, 0x888c, 0x88ab,
	// Entry 6B40 - 6B7F
	0x88ca, 0x88e9, 0x8908, 0x8927, 0x8946, 0x8965, 0x8984, 0x89a3,
	0x89c2, 0x89e1, 0x8a00, 0x8a1f, 0x8a3e, 0x8a5d, 0x8a7c, 0x8a9b,
	0x8aba, 0x8ad9, 0x8af8, 0x8b17, 0x8b36, 0x8b55, 0x8b74, 0x8b93,
	0x8bb9, 0x8bdf, 0x8c05, 0x8c2b, 0x8c51, 0x8c77, 0x8c9d, 0x8cc3,
	0x8ce9, 0x8d0f, 0x8d35, 0x8d5b, 0x8d81, 0x8da7, 0x8dcd, 0x8df3,
	0x8e19, 0x8e3f, 0x8e65, 0x8e8b, 0x8eb1, 0x8ed7, 0x8efd, 0x8f23,
	0x8f49, 0x8f6f, 0x8f93, 0x8fb7, 0x8fdb, 0x8fff, 0x9023, 0x9047,
	0x906b, 0x908f, 0x90b3, 0x90d7, 0x90fb, 0x911f, 0x9143, 0x9167,
	// Entry 6B80 - 6BBF
	0x918b, 0x91af, 0x91d3, 0x91f7, 0x921b, 0x923f, 0x9263, 0x9287,
	0x92ab, 0x92cf, 0x92f3, 0x9317, 0x933f, 0x9367, 0x938f, 0x93b7,
	0x93df, 0x9407, 0x942f, 0x9457, 0x947f, 0x94a7, 0x94cf, 0x94f7,
	0x951f, 0x9547, 0x956f, 0x9597, 0x95bf, 0x95e7, 0x960f, 0x9637,
	0x965f, 0x9687, 0x96af, 0x96d7, 0x96ff, 0x9727, 0x974d, 0x9773,
	0x9799, 0x97bf, 0x97e5, 0x980b, 0x9831, 0x9857, 0x987d, 0x98a3,
	0x98c9, 0x98ef, 0x9915, 0x993b, 0x9961, 0x9987, 0x99ad, 0x99d3,
	0x99f9, 0x9a1f, 0x9a45, 0x9a6b, 0x9a91, 0x9ab7, 0x9add, 0x9b03,
	// Entry 6BC0 - 6BFF
	0x9b30, 0x9b5d, 0x9b8a, 0x9bb7, 0x9be4, 0x9c11, 0x9c3e, 0x9c6b,
	0x9c98, 0x9cc5, 0x9cf2, 0x9d1f, 0x9d4c, 0x9d79, 0x9da6, 0x9dd3,
	0x9e00, 0x9e2d, 0x9e5a, 0x9e87, 0x9eb4, 0x9ee1, 0x9f0e, 0x9f3b,
	0x9f68, 0x9f95, 0x9fc0, 0x9feb, 0xa016, 0xa041, 0xa06c, 0xa097,
	0xa0c2, 0xa0ed, 0xa118, 0xa143, 0xa16e, 0xa199, 0xa1c4, 0xa1ef,
	0xa21a, 0xa245, 0xa270, 0xa29b, 0xa2c6, 0xa2f1, 0xa31c, 0xa347,
	0xa372, 0xa39d, 0xa3c8, 0xa3f3, 0xa413, 0xa433, 0xa453, 0xa473,
	0xa493, 0xa4b3, 0xa4d3, 0xa4f3, 0xa513, 0xa533, 0xa553, 0xa573,
	// Entry 6C00 - 6C3F
	0xa593, 0xa5b3, 0xa5d3, 0xa5f3, 0xa613, 0xa633, 0xa653, 0xa673,
	0xa693, 0xa6b3, 0xa6d3, 0xa6f3, 0xa713, 0xa733, 0xa751, 0xa76f,
	0xa78d, 0xa7ab, 0xa7c9, 0xa7e7, 0xa805, 0xa823, 0xa841, 0xa85f,
	0xa87d, 0xa89b, 0xa8b9, 0xa8d7, 0xa8f5, 0xa913, 0xa931, 0xa94f,
	0xa96d, 0xa98b, 0xa9a9, 0xa9c7, 0xa9e5, 0xaa03, 0xaa21, 0xaa3f,
	0xaa62, 0xaa85, 0xaaa4, 0xaac2, 0xaae1, 0xab00, 0xab21, 0xab3f,
	0xab5c, 0xab7b, 0xab99, 0xabb8, 0xabd7, 0xabf3, 0xac0f, 0xac2b,
	0xac4c, 0xac68, 0xac85, 0xacab, 0xacca, 0xace7, 0xad08, 0xad25,
	// Entry 6C40 - 6C7F
	0xad42, 0xad5f, 0xad7e, 0xad95, 0xadb2, 0xadce, 0xadeb, 0xae08,
	0xae27, 0xae43, 0xae5e, 0xae7b, 0xae97, 0xaeb4, 0xaed1, 0xaeeb,
	0xaf05, 0xaf1f, 0xaf3e, 0xaf58, 0xaf73, 0xaf96, 0xafb3, 0xafce,
	0xafed, 0xb008, 0xb023, 0xb03e, 0xb05b, 0xb081, 0xb0a1, 0xb0bf,
	0xb0dd, 0xb0f9, 0xb115, 0xb130, 0xb151, 0xb171, 0xb192, 0xb1b3,
	0xb1d6, 0xb1f6, 0xb215, 0xb236, 0xb256, 0xb277, 0xb298, 0xb2b6,
	0xb2d4, 0xb2f2, 0xb315, 0xb333, 0xb352, 0xb37a, 0xb39b, 0xb3ba,
	0xb3dd, 0xb3fc, 0xb41b, 0xb43a, 0xb45b, 0xb474, 0xb493, 0xb4b1,
	// Entry 6C80 - 6CBF
	0xb4d0, 0xb4ef, 0xb510, 0xb52e, 0xb54b, 0xb56a, 0xb588, 0xb5a7,
	0xb5c6, 0xb5e2, 0xb5fe, 0xb61a, 0xb63b, 0xb657, 0xb674, 0xb699,
	0xb6b8, 0xb6d5, 0xb6f6, 0xb713, 0xb730, 0xb74d, 0xb76c, 0xb794,
	0xb7b6, 0xb7d6, 0xb7f6, 0xb814, 0xb832, 0xb84f, 0xb875, 0xb89a,
	0xb8c0, 0xb8e6, 0xb90e, 0xb933, 0xb957, 0xb97d, 0xb9a2, 0xb9c8,
	0xb9ee, 0xba11, 0xba34, 0xba57, 0xba7f, 0xbaa2, 0xbac6, 0xbaf3,
	0xbb19, 0xbb3d, 0xbb65, 0xbb89, 0xbbad, 0xbbd1, 0xbbf7, 0xbc15,
	0xbc39, 0xbc5c, 0xbc80, 0xbca4, 0xbcca, 0xbced, 0xbd0f, 0xbd33,
	// Entry 6CC0 - 6CFF
	0xbd56, 0xbd7a, 0xbd9e, 0xbdbf, 0xbde0, 0xbe01, 0xbe27, 0xbe48,
	0xbe6a, 0xbe94, 0xbeb8, 0xbeda, 0xbf00, 0xbf22, 0xbf44, 0xbf66,
	0xbf8a, 0xbfb7, 0xbfde, 0xc003, 0xc028, 0xc04b, 0xc06e, 0xc090,
	0xc0ba, 0xc0e3, 0xc10d, 0xc137, 0xc163, 0xc18c, 0xc1b4, 0xc1de,
	0xc207, 0xc231, 0xc25b, 0xc282, 0xc2a9, 0xc2d0, 0xc2fc, 0xc323,
	0xc34b, 0xc37c, 0xc3a6, 0xc3ce, 0xc3fa, 0xc422, 0xc44a, 0xc472,
	0xc49c, 0xc4be, 0xc4e6, 0xc50d, 0xc535, 0xc55d, 0xc587, 0xc5ae,
	0xc5d4, 0xc5fc, 0xc623, 0xc64b, 0xc673, 0xc698, 0xc6bd, 0xc6e2,
	// Entry 6D00 - 6D3F
	0xc70c, 0xc731, 0xc757, 0xc785, 0xc7ad, 0xc7d3, 0xc7fd, 0xc823,
	0xc849, 0xc86f, 0xc897, 0xc8c8, 0xc8f3, 0xc91c, 0xc945, 0xc96c,
	0xc993, 0xc9b9, 0xc9ea, 0xca1a, 0xca4b, 0xca7c, 0xcaaf, 0xcadf,
	0xcb0e, 0xcb3f, 0xcb6f, 0xcba0, 0xcbd1, 0xcbff, 0xcc2d, 0xcc5b,
	0xcc8e, 0xccbc, 0xcceb, 0xcd23, 0xcd54, 0xcd83, 0xcdb6, 0xcde5,
	0xce14, 0xce43, 0xce74, 0xce9d, 0xcecc, 0xcefa, 0xcf29, 0xcf58,
	0xcf89, 0xcfb7, 0xcfe4, 0xd013, 0xd041, 0xd070, 0xd09f, 0xd0cb,
	0xd0f7, 0xd123, 0xd154, 0xd180, 0xd1ad, 0xd1e2, 0xd211, 0xd23e,
	// Entry 6D40 - 6D7F
	0xd26f, 0xd29c, 0xd2c9, 0xd2f6, 0xd325, 0xd35d, 0xd38f, 0xd3bf,
	0xd3ef, 0xd41d, 0xd44b, 0xd478, 0xd499, 0xd4b8, 0xd4d4, 0xd4ef,
	0xd50a, 0xd527, 0xd543, 0xd55f, 0xd57a, 0xd597, 0xd5b4, 0xd5d0,
	0xd5f5, 0xd619, 0xd63d, 0xd663, 0xd688, 0xd6ad, 0xd6d1, 0xd6f7,
	0xd71d, 0xd742, 0xd764, 0xd785, 0xd7a6, 0xd7c9, 0xd7eb, 0xd80d,
	0xd82e, 0xd851, 0xd874, 0xd896, 0xd8bd, 0xd8e3, 0xd909, 0xd931,
	0xd958, 0xd97f, 0xd9a5, 0xd9cd, 0xd9f5, 0xda1c, 0xda3d, 0xda5d,
	0xda7d, 0xda9f, 0xdac0, 0xdae1, 0xdb01, 0xdb23, 0xdb45, 0xdb66,
	// Entry 6D80 - 6DBF
	0xdb81, 0xdb9e, 0xdbb8, 0xdbd3, 0xdbef, 0xdc0b, 0xdc2b, 0xdc4d,
	0xdc79, 0xdca3, 0xdcc5, 0xdce7, 0xdd0d, 0xdd30, 0xdd52, 0xdd76,
	0xdd9d, 0xddcf, 0xddf8, 0xde24, 0xde50, 0xde7c, 0xdeb3, 0xdeeb,
	0xdf1e, 0xdf51, 0xdf7b, 0xdfa7, 0xdfd3, 0xdfff, 0xe027, 0xe051,
	0xe087, 0xe0bd, 0xe0ea, 0xe125, 0xe15c, 0xe198, 0xe1cf, 0xe209,
	0xe238, 0xe268, 0xe297, 0xe2c6, 0xe2ff, 0xe336, 0xe377, 0xe3b3,
	0xe3e5, 0xe417, 0xe455, 0xe48a, 0xe4c4, 0xe505, 0xe537, 0xe569,
	0xe59c, 0xe5d3, 0xe609, 0xe63e, 0xe671, 0xe6aa, 0xe6dd, 0xe70c,
	// Entry 6DC0 - 6DFF
	0xe742, 0xe77d, 0xe7af, 0xe7e5, 0xe807, 0xe82e, 0xe857, 0xe883,
	0xe8b5, 0xe8e1, 0xe912, 0xe93f, 0xe968, 0xe996, 0xe9c9, 0xea01,
	0xea2f, 0xea62, 0xea99, 0xeac1, 0xeaee, 0xeb1d, 0xeb46, 0xeb76,
	0xebb1, 0xebea, 0xebff, 0xec29, 0xec43, 0xec63, 0xec88, 0xeca8,
	0xeccb, 0xecf7, 0xed19, 0xed46, 0xed78, 0xed9a, 0xedaf, 0xedcf,
	0xeded, 0xee10, 0xee2e, 0xee43, 0xee5c, 0xee70, 0xee94, 0xeeb3,
	0xeed5, 0xeef2, 0xef19, 0xef3b, 0xef59, 0xef72, 0xef89, 0xef9e,
	0xefbe, 0xefdc, 0xefff, 0xf01a, 0xf043, 0xf059, 0xf075, 0xf09b,
	// Entry 6E00 - 6E3F
	0xf0bc, 0xf0e0, 0xf0ff, 0xf12f, 0xf15f, 0xf175, 0xf19c, 0xf1c5,
	0xf1ed, 0xf215, 0xf232, 0xf25e, 0xf28f, 0xf2c1, 0xf2e2, 0xf313,
	0xf342, 0xf372, 0xf391, 0xf3bc, 0xf3dd, 0xf3fc, 0xf41c, 0xf447,
	0xf468, 0xf492, 0xf4b4, 0xf4d7, 0xf4ff, 0xf528, 0xf561, 0xf596,
	0xf5b8, 0xf5dc, 0xf5ff, 0xf622, 0xf64b, 0xf676, 0xf6a0, 0xf6bb,
	0xf6e5, 0xf714, 0xf745, 0xf764, 0xf79c, 0xf7d5, 0xf7f2, 0xf81b,
	0xf83c, 0xf85f, 0xf880, 0xf8a2, 0xf8c3, 0xf8ee, 0xf91f, 0xf93f,
	0xf95f, 0xf97f, 0xf9a6, 0xf9cf, 0xf9fd, 0xfa28, 0xfa52, 0xfa7f,
	// Entry 6E40 - 6E7F
	0xfaa5, 0xfacd, 0xfaf9, 0xfb21, 0xfb42, 0xfb5f, 0xfb7e, 0xfb9f,
	0xfbca, 0xfbf4, 0xfc16, 0xfc3f, 0xfc62, 0xfc8a, 0xfcb4, 0xfce3,
	0xfd0a, 0xfd33, 0xfd60, 0xfd8c, 0xfdb5, 0xfde4, 0xfe16, 0xfe4d,
	0xfe83, 0xfeb8, 0xfeea, 0xff0d, 0xff33, 0xff5a, 0xff8f, 0xffc5,
	0xfff6, 0x0027, 0x0057, 0x0089, 0x00c1, 0x00f5, 0x011b, 0x0145,
	0x0179, 0x01ad, 0x01e0, 0x0208, 0x0228, 0x024d, 0x0274, 0x029c,
	0x02be, 0x02e6, 0x030c, 0x0331, 0x0353, 0x036e, 0x038e, 0x03b7,
	0x03e1, 0x0406, 0x0429, 0x0459, 0x0488, 0x04b7, 0x04e4, 0x0510,
	// Entry 6E80 - 6EBF
	0x053f, 0x056d, 0x05a2, 0x05b7, 0x05d1, 0x05e9, 0x0603, 0x061c,
	0x0634, 0x064e, 0x0667, 0x0680, 0x069b, 0x06b5, 0x06cd, 0x06e7,
	0x0700, 0x0716, 0x072e, 0x0745, 0x0760, 0x077b, 0x079b, 0x07bb,
	0x07dd, 0x07ff, 0x081d, 0x083b, 0x0859, 0x0879, 0x0899, 0x08b5,
	0x08da, 0x0902, 0x092a, 0x0952, 0x097c, 0x09b0, 0x09e4, 0x0a14,
	0x0a41, 0x0a6f, 0x0aa3, 0x0ad8, 0x0b0c, 0x0b42, 0x0b72, 0x0ba0,
	0x0bd0, 0x0c01, 0x0c3d, 0x0c61, 0x0c98, 0x0cc8, 0x0cf9, 0x0d35,
	0x0d5e, 0x0d88, 0x0db1, 0x0ddc, 0x0e08, 0x0e33, 0x0e61, 0x0e8b,
	// Entry 6EC0 - 6EFF
	0x0eb6, 0x0ee0, 0x0f08, 0x0f31, 0x0f59, 0x0f84, 0x0fb0, 0x0fdb,
	0x1005, 0x1030, 0x105a, 0x1090, 0x10c6, 0x1101, 0x1138, 0x116f,
	0x11ab, 0x11cf, 0x11fd, 0x122b, 0x1259, 0x1281, 0x12aa, 0x12d2,
	0x12fc, 0x1327, 0x1353, 0x137e, 0x13ab, 0x13db, 0x140c, 0x143c,
	0x146e, 0x14a1, 0x14d5, 0x1508, 0x153d, 0x1572, 0x15a8, 0x15dd,
	0x1614, 0x1645, 0x1674, 0x16a5, 0x16d7, 0x1714, 0x1739, 0x1771,
	0x17a2, 0x17dd, 0x181a, 0x183e, 0x186a, 0x1897, 0x18c3, 0x18e8,
	0x1911, 0x193b, 0x1964, 0x1990, 0x19bd, 0x19e9, 0x1a14, 0x1a40,
	// Entry 6F00 - 6F3F
	0x1a6b, 0x1aa3, 0x1adb, 0x1b18, 0x1b4f, 0x1b86, 0x1bc2, 0x1be7,
	0x1c19, 0x1c4c, 0x1c7e, 0x1cb2, 0x1ce8, 0x1d1f, 0x1d55, 0x1d8d,
	0x1dcc, 0x1e0c, 0x1e35, 0x1e5f, 0x1e88, 0x1eb1, 0x1edb, 0x1f04,
	0x1f34, 0x1f6a, 0x1fa1, 0x1fd7, 0x200d, 0x2044, 0x207a, 0x20ac,
	0x20dd, 0x210f, 0x2134, 0x2159, 0x2181, 0x21a7, 0x21de, 0x2214,
	0x224a, 0x2280, 0x22b8, 0x22f0, 0x232d, 0x235f, 0x2390, 0x23c1,
	0x23f2, 0x2425, 0x2458, 0x2490, 0x24c7, 0x24ff, 0x2536, 0x2571,
	0x25ac, 0x25ed, 0x262e, 0x266f, 0x26b0, 0x26f1, 0x2732, 0x2773,
	// Entry 6F40 - 6F7F
	0x27b4, 0x27ee, 0x2828, 0x285e, 0x2894, 0x28cf, 0x2908, 0x2941,
	0x2980, 0x29bf, 0x2a05, 0x2a4b, 0x2a8a, 0x2ac9, 0x2b08, 0x2b47,
	0x2b7f, 0x2bb7, 0x2beb, 0x2c1f, 0x2c58, 0x2c83, 0x2caf, 0x2cda,
	0x2d07, 0x2d35, 0x2d5f, 0x2d89, 0x2db3, 0x2ddd, 0x2e07, 0x2e2d,
	0x2e53, 0x2e7e, 0x2eae, 0x2ee4, 0x2f1b, 0x2f51, 0x2f88, 0x2fcc,
	0x3011, 0x3055, 0x3099, 0x30de, 0x3122, 0x315a, 0x3192, 0x31d2,
	0x3212, 0x3246, 0x327a, 0x32bc, 0x32fe, 0x3321, 0x3344, 0x335c,
	0x3374, 0x338d, 0x33a8, 0x33c8, 0x33f4, 0x3418, 0x3433, 0x3443,
	// Entry 6F80 - 6FBF
	0x3457, 0x3483, 0x34ab, 0x34d8, 0x3501, 0x352b, 0x354b, 0x3583,
	0x35b6, 0x35f1, 0x3611, 0x3636, 0x3658, 0x3680, 0x36a8, 0x36ce,
	0x36f4, 0x3710, 0x372c, 0x3749, 0x375e, 0x3777, 0x378e, 0x37aa,
	0x37c8, 0x37e2, 0x37fc, 0x3818, 0x383a, 0x384e, 0x3866, 0x3880,
	0x38a0, 0x38c6, 0x38f3, 0x3925, 0x394c, 0x397a, 0x39ad, 0x39d1,
	0x39f6, 0x3a1c, 0x3a35, 0x3a4f, 0x3a68, 0x3a85, 0x3aa4, 0x3ac0,
	0x3ad0, 0x3ae8, 0x3b00, 0x3b19, 0x3b31, 0x3b4c, 0x3b66, 0x3b8a,
	0x3bae, 0x3bc7, 0x3be0, 0x3c00, 0x3c20, 0x3c40, 0x3c57, 0x3c77,
	// Entry 6FC0 - 6FFF
	0x3c93, 0x3caa, 0x3cca, 0x3ce6, 0x3d03, 0x3d21, 0x3d40, 0x3d5b,
	0x3d7f, 0x3d9f, 0x3dbf, 0x3de8, 0x3e0d, 0x3e23, 0x3e41, 0x3e60,
	0x3e77, 0x3e96, 0x3eb4, 0x3ed5, 0x3ef5, 0x3f15, 0x3f2e, 0x3f4f,
	0x3f70, 0x3f93, 0x3fb2, 0x3fd5, 0x4001, 0x4028, 0x404e, 0x4074,
	0x409a, 0x40ab, 0x40c5, 0x40e0, 0x4104, 0x411d, 0x413f, 0x415a,
	0x417c, 0x419f, 0x41af, 0x41bf, 0x41d5, 0x41f3, 0x4215, 0x423c,
	0x4264, 0x428b, 0x42b7, 0x42de, 0x4303, 0x4331, 0x434d, 0x4366,
	0x437f, 0x4398, 0x43b1, 0x43ca, 0x43e3, 0x43fc, 0x440e, 0x4432,
	// Entry 7000 - 703F
	0x4457, 0x4472, 0x448c, 0x44a6, 0x44c4, 0x44de, 0x44ff, 0x4510,
	0x4525, 0x453a, 0x454b, 0x4562, 0x457d, 0x4598, 0x45b3, 0x45ce,
	0x45e9, 0x4608, 0x4627, 0x4646, 0x4665, 0x4684, 0x46a3, 0x46c2,
	0x46e1, 0x4701, 0x4721, 0x4741, 0x4761, 0x4781, 0x47a1, 0x47c1,
	0x47e0, 0x4800, 0x4820, 0x4843, 0x4864, 0x4885, 0x48a8, 0x48ca,
	0x48ea, 0x4912, 0x492f, 0x4951, 0x4971, 0x4994, 0x49b7, 0x49d8,
	0x49f7, 0x4a19, 0x4a3a, 0x4a5b, 0x4a7d, 0x4a9c, 0x4abd, 0x4add,
	0x4afd, 0x4b1c, 0x4b3e, 0x4b5d, 0x4b7d, 0x4b9d, 0x4bbd, 0x4bdb,
	// Entry 7040 - 707F
	0x4c00, 0x4c1e, 0x4c4b, 0x4c6e, 0x4c99, 0x4cb9, 0x4cd7, 0x4cf5,
	0x4d13, 0x4d32, 0x4d50, 0x4d6f, 0x4d8d, 0x4dac, 0x4dca, 0x4de8,
	0x4e06, 0x4e25, 0x4e43, 0x4e62, 0x4e80, 0x4e9f, 0x4ebe, 0x4edd,
	0x4efc, 0x4f1b, 0x4f3a, 0x4f59, 0x4f78, 0x4f97, 0x4fb6, 0x4fd6,
	0x4ff6, 0x5014, 0x5032, 0x5050, 0x506f, 0x508d, 0x50ac, 0x50ca,
	0x50e7, 0x5104, 0x5121, 0x513f, 0x515c, 0x517a, 0x5197, 0x51b5,
	0x51d3, 0x51f1, 0x520f, 0x522d, 0x524b, 0x5269, 0x5287, 0x52a6,
	0x52c4, 0x52e3, 0x5301, 0x5320, 0x533e, 0x535c, 0x537a, 0x5399,
	// Entry 7080 - 70BF
	0x53b7, 0x53d6, 0x53f4, 0x5417, 0x5435, 0x5453, 0x5471, 0x5490,
	0x54af, 0x54cd, 0x54eb, 0x5509, 0x5527, 0x5546, 0x5564, 0x5583,
	0x55a1, 0x55bf, 0x55dd, 0x55fb, 0x561a, 0x5638, 0x5657, 0x5675,
	0x5698, 0x56b6, 0x56d4, 0x56f2, 0x5711, 0x572f, 0x574e, 0x576c,
	0x578a, 0x57a8, 0x57c6, 0x57e5, 0x5803, 0x5822, 0x5840, 0x585f,
	0x587e, 0x589d, 0x58bc, 0x58db, 0x58fa, 0x5919, 0x5937, 0x5955,
	0x5973, 0x5992, 0x59b0, 0x59cf, 0x59ed, 0x5a0d, 0x5a2d, 0x5a4c,
	0x5a6b, 0x5a8a, 0x5aa9, 0x5ac8, 0x5ae8, 0x5b08, 0x5b28, 0x5b48,
	// Entry 70C0 - 70FF
	0x5b69, 0x5b89, 0x5baa, 0x5bca, 0x5beb, 0x5c0c, 0x5c31, 0x5c57,
	0x5c7c, 0x5c9a, 0x5cb8, 0x5cd6, 0x5cf5, 0x5d15, 0x5d35, 0x5d55,
	0x5d75, 0x5d96, 0x5db4, 0x5dd2, 0x5df0, 0x5e0f, 0x5e2d, 0x5e4c,
	0x5e6a, 0x5e89, 0x5ea8, 0x5ec7, 0x5ee7, 0x5f07, 0x5f26, 0x5f46,
	0x5f65, 0x5f85, 0x5fa9, 0x5fce, 0x5ff2, 0x6011, 0x6030, 0x604f,
	0x606f, 0x608e, 0x60ae, 0x60cd, 0x60ec, 0x610b, 0x612a, 0x614a,
	0x6169, 0x6189, 0x61a8, 0x61c6, 0x61e5, 0x6204, 0x6223, 0x6243,
	0x6262, 0x6282, 0x62a1, 0x62c0, 0x62df, 0x62ff, 0x631f, 0x633d,
	// Entry 7100 - 713F
	0x635b, 0x6379, 0x6398, 0x63b6, 0x63d5, 0x63f3, 0x6413, 0x6433,
	0x6453, 0x6473, 0x6493, 0x64aa, 0x64c1, 0x64da, 0x64f2, 0x650a,
	0x6521, 0x653a, 0x6553, 0x656b, 0x658f, 0x65b2, 0x65d9, 0x6601,
	0x662d, 0x665d, 0x6684, 0x669d, 0x66b7, 0x66d0, 0x66e9, 0x6700,
	0x671f, 0x6736, 0x674e, 0x6765, 0x677b, 0x6792, 0x67a8, 0x67be,
	0x67d6, 0x67ee, 0x6806, 0x681e, 0x6836, 0x684d, 0x6863, 0x687c,
	0x6894, 0x68ab, 0x68c4, 0x68db, 0x68f3, 0x690a, 0x6922, 0x6939,
	0x6951, 0x6969, 0x6981, 0x6999, 0x69b1, 0x69c8, 0x69e0, 0x69f7,
	// Entry 7140 - 717F
	0x6a0e, 0x6a23, 0x6a40, 0x6a55, 0x6a6b, 0x6a80, 0x6a94, 0x6aa9,
	0x6abd, 0x6ad1, 0x6ae7, 0x6afd, 0x6b13, 0x6b29, 0x6b3f, 0x6b54,
	0x6b68, 0x6b7f, 0x6b95, 0x6baa, 0x6bc1, 0x6bd6, 0x6bec, 0x6c01,
	0x6c17, 0x6c2c, 0x6c42, 0x6c58, 0x6c6e, 0x6c84, 0x6c9a, 0x6caf,
	0x6cc5, 0x6cda, 0x6ce5, 0x6cfd, 0x6d1e, 0x6d29, 0x6d39, 0x6d48,
	0x6d57, 0x6d68, 0x6d78, 0x6d88, 0x6d97, 0x6da8, 0x6db9, 0x6dc9,
	0x6de7, 0x6e02, 0x6e18, 0x6e2e, 0x6e46, 0x6e5d, 0x6e74, 0x6e8a,
	0x6ea2, 0x6eba, 0x6ed1, 0x6ee7, 0x6f00, 0x6f19, 0x6f31, 0x6f49,
	// Entry 7180 - 71BF
	0x6f61, 0x6f7b, 0x6f94, 0x6fad, 0x6fcb, 0x6fe9, 0x7009, 0x7028,
	0x7047, 0x7065, 0x7085, 0x70a5, 0x70c4, 0x70e3, 0x7102, 0x7123,
	0x7143, 0x7163, 0x7182, 0x71a3, 0x71c4, 0x71e4, 0x7203, 0x7225,
	0x7247, 0x7268, 0x7289, 0x72aa, 0x72cd, 0x72ef, 0x7311, 0x7328,
	0x7341, 0x7356, 0x736e, 0x7388, 0x73a7, 0x73c6, 0x73e7, 0x7407,
	0x7427, 0x7446, 0x7467, 0x7488, 0x74a8, 0x74bf, 0x74df, 0x74fc,
	0x751f, 0x7535, 0x7555, 0x7575, 0x759e, 0x75bd, 0x75d5, 0x75ec,
	0x7604, 0x761b, 0x7632, 0x764a, 0x7661, 0x7678, 0x768f, 0x76a6,
	// Entry 71C0 - 71FF
	0x76bd, 0x76d5, 0x76ed, 0x7705, 0x771c, 0x7733, 0x774a, 0x7761,
	0x7778, 0x7791, 0x77a8, 0x77c0, 0x77d8, 0x77f0, 0x7807, 0x781e,
	0x7837, 0x7856, 0x7876, 0x7895, 0x78b4, 0x78d3, 0x78f3, 0x7912,
	0x7931, 0x7950, 0x796f, 0x798e, 0x79ae, 0x79ce, 0x79ee, 0x7a0d,
	0x7a2c, 0x7a4b, 0x7a6a, 0x7a8b, 0x7aaa, 0x7aca, 0x7aea, 0x7b09,
	0x7b2a, 0x7b49, 0x7b67, 0x7b85, 0x7ba3, 0x7bc2, 0x7be1, 0x7bff,
	0x7c1d, 0x7c3b, 0x7c5b, 0x7c7a, 0x7c98, 0x7cb8, 0x7cdf, 0x7d05,
	0x7d26, 0x7d48, 0x7d69, 0x7d8a, 0x7dab, 0x7dcc, 0x7ded, 0x7e0f,
	// Entry 7200 - 723F
	0x7e31, 0x7e53, 0x7e74, 0x7e95, 0x7eb6, 0x7ed7, 0x7efa, 0x7f1b,
	0x7f3d, 0x7f5f, 0x7f80, 0x7fa1, 0x7fc4, 0x7fed, 0x8016, 0x8035,
	0x8053, 0x8072, 0x8090, 0x80ae, 0x80cc, 0x80eb, 0x8109, 0x8127,
	0x8145, 0x8163, 0x8182, 0x81a1, 0x81c0, 0x81de, 0x81fc, 0x821a,
	0x8238, 0x8256, 0x8276, 0x8294, 0x82b3, 0x82d2, 0x82f1, 0x830f,
	0x832d, 0x834d, 0x8372, 0x8398, 0x83bd, 0x83e2, 0x8408, 0x842d,
	0x8452, 0x8477, 0x849c, 0x84c2, 0x84e8, 0x850e, 0x8533, 0x8558,
	0x857d, 0x85a2, 0x85c7, 0x85ee, 0x8613, 0x8639, 0x865f, 0x8685,
	// Entry 7240 - 727F
	0x86aa, 0x86cf, 0x86f6, 0x872d, 0x8756, 0x876c, 0x8783, 0x8799,
	0x87b0, 0x87c7, 0x87e0, 0x87f9, 0x8817, 0x8835, 0x8855, 0x8874,
	0x8893, 0x88b1, 0x88d1, 0x88f1, 0x8910, 0x892b, 0x8946, 0x8963,
	0x897f, 0x899b, 0x89b6, 0x89d3, 0x89f0, 0x8a0c, 0x8a27, 0x8a42,
	0x8a5f, 0x8a7b, 0x8a97, 0x8ab2, 0x8acf, 0x8aec, 0x8b08, 0x8b19,
	0x8b2c, 0x8b3f, 0x8b59, 0x8b6c, 0x8b7f, 0x8b92, 0x8ba5, 0x8bb7,
	0x8bc8, 0x8be3, 0x8bff, 0x8c1b, 0x8c37, 0x8c53, 0x8c6f, 0x8c8b,
	0x8ca7, 0x8cc3, 0x8cdf, 0x8cfb, 0x8d17, 0x8d33, 0x8d4f, 0x8d6b,
	// Entry 7280 - 72BF
	0x8d87, 0x8da3, 0x8dbf, 0x8ddb, 0x8df7, 0x8e13, 0x8e2f, 0x8e4b,
	0x8e67, 0x8e83, 0x8e9f, 0x8ebb, 0x8ed7, 0x8ef3, 0x8f0f, 0x8f2b,
	0x8f47, 0x8f63, 0x8f7f, 0x8f9b, 0x8fb7, 0x8fd3, 0x8fef, 0x900b,
	0x9027, 0x9043, 0x905f, 0x907b, 0x9097, 0x90b3, 0x90cf, 0x90eb,
	0x9107, 0x9123, 0x913f, 0x9158, 0x9172, 0x918c, 0x91a6, 0x91c0,
	0x91da, 0x91f4, 0x920e, 0x9228, 0x9242, 0x925c, 0x9276, 0x9290,
	0x92aa, 0x92c4, 0x92de, 0x92f8, 0x9312, 0x932c, 0x9346, 0x9360,
	0x937a, 0x9394, 0x93ae, 0x93c8, 0x93e2, 0x93fc, 0x9416, 0x9430,
	// Entry 72C0 - 72FF
	0x944a, 0x9464, 0x947e, 0x9498, 0x94b2, 0x94cc, 0x94e6, 0x9500,
	0x951a, 0x9534, 0x954e, 0x9568, 0x9582, 0x959c, 0x95b6, 0x95d0,
	0x95ea, 0x9604, 0x961e, 0x9638, 0x9652, 0x9663, 0x967d, 0x9697,
	0x96b3, 0x96ce, 0x96e9, 0x9703, 0x971f, 0x973b, 0x9756, 0x9770,
	0x978b, 0x97a8, 0x97c4, 0x97df, 0x97f9, 0x9813, 0x982f, 0x984a,
	0x9865, 0x987f, 0x989b, 0x98b7, 0x98d2, 0x98ec, 0x9907, 0x9924,
	0x9940, 0x995b, 0x9971, 0x998d, 0x99a9, 0x99c7, 0x99e4, 0x9a01,
	0x9a1d, 0x9a3b, 0x9a59, 0x9a76, 0x9a92, 0x9aaf, 0x9ace, 0x9aec,
	// Entry 7300 - 733F
	0x9b09, 0x9b21, 0x9b3a, 0x9b53, 0x9b6e, 0x9b88, 0x9ba2, 0x9bbb,
	0x9bd6, 0x9bf1, 0x9c0b, 0x9c24, 0x9c3e, 0x9c5a, 0x9c75, 0x9c8f,
	0x9ca7, 0x9cb8, 0x9ccc, 0x9ce0, 0x9cf4, 0x9d08, 0x9d1c, 0x9d30,
	0x9d44, 0x9d58, 0x9d6c, 0x9d81, 0x9d96, 0x9dab, 0x9dc0, 0x9dd5,
	0x9dea, 0x9dff, 0x9e14, 0x9e29, 0x9e3e, 0x9e53, 0x9e68, 0x9e7c,
	0x9e8c, 0x9e9b, 0x9eaa, 0x9ebb, 0x9ecb, 0x9edb, 0x9eea, 0x9efb,
	0x9f0c, 0x9f1c, 0x9f41, 0x9f6f, 0x9f93, 0x9fb7, 0x9fdb, 0x9fff,
	0xa023, 0xa047, 0xa06b, 0xa08f, 0xa0b3, 0xa0d7, 0xa0fb, 0xa11f,
	// Entry 7340 - 737F
	0xa143, 0xa167, 0xa18b, 0xa1af, 0xa1d3, 0xa1f7, 0xa21b, 0xa23f,
	0xa263, 0xa287, 0xa2ab, 0xa2cf, 0xa2f3, 0xa317, 0xa346, 0xa36b,
	0xa390, 0xa39a, 0xa3a4, 0xa3b3, 0xa3d1, 0xa3ef, 0xa40d, 0xa42b,
	0xa449, 0xa467, 0xa485, 0xa4a3, 0xa4c1, 0xa4df, 0xa4fd, 0xa51b,
	0xa539, 0xa557, 0xa575, 0xa593, 0xa5b1, 0xa5cf, 0xa5ed, 0xa60b,
	0xa629, 0xa647, 0xa665, 0xa683, 0xa6a1, 0xa6bf, 0xa6c9, 0xa6d3,
	0xa6dd, 0xa6e7, 0xa6f2, 0xa6fc, 0xa723, 0xa74a, 0xa771, 0xa798,
	0xa7bf, 0xa7e6, 0xa80d, 0xa834, 0xa85b, 0xa882, 0xa8a9, 0xa8d0,
	// Entry 7380 - 73BF
	0xa8f7, 0xa91e, 0xa945, 0xa96c, 0xa993, 0xa9ba, 0xa9e1, 0xaa08,
	0xaa2f, 0xaa56, 0xaa7d, 0xaaa4, 0xaacb, 0xaaf2, 0xab00, 0xab0e,
	0xab35, 0xab5c, 0xab83, 0xabaa, 0xabd1, 0xabf8, 0xac1f, 0xac46,
	0xac6d, 0xac94, 0xacbb, 0xace2, 0xad09, 0xad30, 0xad57, 0xad7e,
	0xada5, 0xadcc, 0xadf3, 0xae1a, 0xae41, 0xae68, 0xae8f, 0xaeb6,
	0xaedd, 0xaf04, 0xaf33, 0xaf46, 0xaf59, 0xaf6c, 0xaf7f, 0xaf92,
	0xaf9b, 0xafa5, 0xafb1, 0xafbd, 0xafc7, 0xafd2, 0xafdc, 0xafe6,
	0xaff1, 0xb011, 0xb01b, 0xb02a, 0xb03f, 0xb04c, 0xb05a, 0xb069,
	// Entry 73C0 - 73FF
	0xb07f, 0xb096, 0xb0b2, 0xb0c1, 0xb0dd, 0xb0f9, 0xb103, 0xb10e,
	0xb11c, 0xb12c, 0xb137, 0xb142, 0xb14d, 0xb16f, 0xb191, 0xb1b3,
	0xb1d5, 0xb1f7, 0xb219, 0xb23b, 0xb25d, 0xb27f, 0xb2a1, 0xb2c3,
	0xb2e5, 0xb307, 0xb329, 0xb34b, 0xb36d, 0xb38f, 0xb3b1, 0xb3d3,
	0xb3f5, 0xb417, 0xb439, 0xb45b, 0xb47d, 0xb49f, 0xb4c1, 0xb4d5,
	0xb4ea, 0xb4fd, 0xb51f, 0xb541, 0xb563, 0xb576, 0xb598, 0xb5ba,
	0xb5dc, 0xb5fe, 0xb620, 0xb642, 0xb664, 0xb686, 0xb6a8, 0xb6ca,
	0xb6ec, 0xb70e, 0xb730, 0xb752, 0xb774, 0xb796, 0xb7b8, 0xb7da,
	// Entry 7400 - 743F
	0xb7fc, 0xb81e, 0xb840, 0xb862, 0xb884, 0xb8a6, 0xb8c8, 0xb8ea,
	0xb90c, 0xb92e, 0xb950, 0xb972, 0xb994, 0xb9b6, 0xb9d8, 0xb9fa,
	0xba1c, 0xba3e, 0xba60, 0xba82, 0xbaa4, 0xbac6, 0xbaf9, 0xbb2c,
	0xbb5f, 0xbb92, 0xbbc5, 0xbbf8, 0xbc2b, 0xbc5e, 0xbc91, 0xbcac,
	0xbcc4, 0xbcd9, 0xbcee, 0xbd05, 0xbd1a, 0xbd35, 0xbd4b, 0xbd52,
	0xbd57, 0xbd66, 0xbd76, 0xbd8c, 0xbd93, 0xbda4, 0xbdb9, 0xbdc0,
	0xbdcf, 0xbdd9, 0xbde0, 0xbde9, 0xbe02, 0xbe16, 0xbe30, 0xbe44,
	0xbe53, 0xbe6e, 0xbe87, 0xbea1, 0xbeb1, 0xbecb, 0xbee3, 0xbefe,
	// Entry 7440 - 747F
	0xbf0b, 0xbf1d, 0xbf39, 0xbf54, 0xbf67, 0xbf74, 0xbf80, 0xbf8d,
	0xbf98, 0xbfa5, 0xbfae, 0xbfc8, 0xbfde, 0xbffe, 0xc00d, 0xc01c,
	0xc030, 0xc042, 0xc045, 0xc056, 0xc05d, 0xc061, 0xc068, 0xc070,
	0xc078, 0xc086, 0xc094, 0xc09d, 0xc0a3, 0xc0ad, 0xc0b2, 0xc0c0,
	0xc0c4, 0xc0cc, 0xc0d5, 0xc0dc, 0xc0e8, 0xc0f3, 0xc0f7, 0xc107,
	0xc111, 0xc11c, 0xc133, 0xc13b, 0xc141, 0xc14a, 0xc150, 0xc155,
	0xc15f, 0xc168, 0xc16d, 0xc173, 0xc17c, 0xc185, 0xc190, 0xc194,
	0xc199, 0xc1a1, 0xc1ab, 0xc1b4, 0xc1c2, 0xc1ce, 0xc1d9, 0xc1e5,
	// Entry 7480 - 74BF
	0xc1ee, 0xc1f9, 0xc207, 0xc214, 0xc21d, 0xc222, 0xc22e, 0xc242,
	0xc247, 0xc24b, 0xc250, 0xc25c, 0xc277, 0xc285, 0xc28f, 0xc298,
	0xc2a0, 0xc2a6, 0xc2b3, 0xc2b8, 0xc2c0, 0xc2c7, 0xc2d0, 0xc2d9,
	0xc2e2, 0xc2ed, 0xc2f4, 0xc302, 0xc317, 0xc32a, 0xc334, 0xc342,
	0xc350, 0xc358, 0xc36a, 0xc375, 0xc38e, 0xc3a6, 0xc3ad, 0xc3b3,
	0xc3c2, 0xc3cf, 0xc3dd, 0xc3eb, 0xc3fb, 0xc404, 0xc415, 0xc41c,
	0xc428, 0xc435, 0xc442, 0xc44f, 0xc45e, 0xc46c, 0xc479, 0xc483,
	0xc498, 0xc4a6, 0xc4b4, 0xc4ce, 0xc4e0, 0xc4ee, 0xc4fd, 0xc518,
	// Entry 74C0 - 74FF
	0xc529, 0xc535, 0xc542, 0xc560, 0xc57f, 0xc58a, 0xc59b, 0xc5a9,
	0xc5b5, 0xc5c3, 0xc5d8, 0xc5e2, 0xc5ee, 0xc5f4, 0xc5fd, 0xc60b,
	0xc612, 0xc61d, 0xc623, 0xc630, 0xc63f, 0xc649, 0xc653, 0xc65f,
	0xc668, 0xc670, 0xc677, 0xc68b, 0xc697, 0xc6ad, 0xc6b6, 0xc6bc,
	0xc6cc, 0xc6d3, 0xc6d9, 0xc6e6, 0xc6fd, 0xc714, 0xc724, 0xc737,
	0xc745, 0xc750, 0xc756, 0xc75c, 0xc768, 0xc76e, 0xc77a, 0xc78b,
	0xc799, 0xc7a0, 0xc7ad, 0xc7b3, 0xc7c4, 0xc7ce, 0xc7e2, 0xc7ec,
	0xc807, 0xc820, 0xc83c, 0xc850, 0xc857, 0xc86a, 0xc87f, 0xc88e,
	// Entry 7500 - 753F
	0xc897, 0xc8ae, 0xc8c0, 0xc8c6, 0xc8d3, 0xc8e0, 0xc8e7, 0xc8f5,
	0xc906, 0xc915, 0xc929, 0xc93d, 0xc945, 0xc949, 0xc961, 0xc966,
	0xc970, 0xc981, 0xc987, 0xc997, 0xc99e, 0xc9ad, 0xc9bc, 0xc9cb,
	0xc9d8, 0xc9e5, 0xc9f6, 0xca07, 0xca0e, 0xca1b, 0xca20, 0xca41,
	0xca4e, 0xca55, 0xca78, 0xca99, 0xcaba, 0xcadb, 0xcafc, 0xcaff,
	0xcb04, 0xcb06, 0xcb13, 0xcb16, 0xcb1b, 0xcb22, 0xcb28, 0xcb2b,
	0xcb31, 0xcb3a, 0xcb3f, 0xcb44, 0xcb49, 0xcb4e, 0xcb51, 0xcb55,
	0xcb5a, 0xcb60, 0xcb67, 0xcb6e, 0xcb71, 0xcb74, 0xcb78, 0xcb80,
	// Entry 7540 - 757F
	0xcb87, 0xcb93, 0xcb96, 0xcb99, 0xcba1, 0xcbac, 0xcbb0, 0xcbbd,
	0xcbc5, 0xcbcb, 0xcbd9, 0xcbe3, 0xcbfa, 0xcbfe, 0xcc05, 0xcc0a,
	0xcc10, 0xcc1f, 0xcc2d, 0xcc34, 0xcc3e, 0xcc46, 0xcc50, 0xcc5b,
	0xcc63, 0xcc6e, 0xcc7c, 0xcc86, 0xcc91, 0xcc99, 0xcca1, 0xccaa,
	0xccb6, 0xccbf, 0xccc8, 0xccd2, 0xccda, 0xcce4, 0xccec, 0xccf0,
	0xccf3, 0xccf6, 0xccfa, 0xccff, 0xcd05, 0xcd25, 0xcd47, 0xcd69,
	0xcd8c, 0xcd9c, 0xcdac, 0xcdb8, 0xcdc6, 0xcdd6, 0xcde9, 0xcdf8,
	0xcdfd, 0xce07, 0xce11, 0xce18, 0xce1f, 0xce24, 0xce29, 0xce2f,
	// Entry 7580 - 75BF
	0xce35, 0xce43, 0xce48, 0xce4f, 0xce54, 0xce5d, 0xce6a, 0xce7a,
	0xce87, 0xce93, 0xce9d, 0xceaf, 0xcec2, 0xcec5, 0xcec9, 0xcecc,
	0xced1, 0xced7, 0xcef2, 0xcf07, 0xcf1e, 0xcf2c, 0xcf41, 0xcf50,
	0xcf66, 0xcf79, 0xcf88, 0xcf91, 0xcf9c, 0xcfa0, 0xcfb3, 0xcfbb,
	0xcfc8, 0xcfd7, 0xcfdc, 0xcfe6, 0xcffc, 0xd009, 0xd00c, 0xd011,
	0xd028, 0xd031, 0xd037, 0xd03f, 0xd04a, 0xd056, 0xd05d, 0xd068,
	0xd06f, 0xd073, 0xd07c, 0xd087, 0xd08b, 0xd094, 0xd098, 0xd09f,
	0xd0b0, 0xd0b7, 0xd0c4, 0xd0d0, 0xd0da, 0xd0e9, 0xd0f6, 0xd106,
	// Entry 75C0 - 75FF
	0xd110, 0xd11b, 0xd127, 0xd133, 0xd144, 0xd154, 0xd164, 0xd183,
	0xd196, 0xd1a2, 0xd1a6, 0xd1b5, 0xd1c5, 0xd1db, 0xd1e2, 0xd1ed,
	0xd1f8, 0xd205, 0xd211, 0xd21f, 0xd22e, 0xd23a, 0xd24f, 0xd258,
	0xd269, 0xd27a, 0xd285, 0xd29b, 0xd2b4, 0xd2cb, 0xd2e3, 0xd2f3,
	0xd318, 0xd31c, 0xd32d, 0xd336, 0xd33e, 0xd349, 0xd355, 0xd358,
	0xd363, 0xd373, 0xd381, 0xd38f, 0xd397, 0xd3a8, 0xd3b2, 0xd3ca,
	0xd3e4, 0xd3ed, 0xd3f6, 0xd3fd, 0xd40a, 0xd413, 0xd421, 0xd431,
	0xd43e, 0xd444, 0xd44c, 0xd46a, 0xd475, 0xd47e, 0xd488, 0xd491,
	// Entry 7600 - 763F
	0xd49c, 0xd4a1, 0xd4ab, 0xd4b1, 0xd4b5, 0xd4c7, 0xd4cc, 0xd4d7,
	0xd4e8, 0xd502, 0xd514, 0xd51f, 0xd529, 0xd530, 0xd53d, 0xd54e,
	0xd571, 0xd591, 0xd5b0, 0xd5cd, 0xd5eb, 0xd5f2, 0xd5fd, 0xd606,
	0xd612, 0xd63c, 0xd64a, 0xd65a, 0xd66a, 0xd67b, 0xd681, 0xd692,
	0xd69e, 0xd6a8, 0xd6ad, 0xd6ba, 0xd6c8, 0xd6d7, 0xd6e3, 0xd6fc,
	0xd731, 0xd77f, 0xd7b1, 0xd7e7, 0xd7fc, 0xd812, 0xd832, 0xd839,
	0xd854, 0xd872, 0xd879, 0xd886, 0xd8a4, 0xd8c3, 0xd8d4, 0xd8e8,
	0xd8eb, 0xd8ef, 0xd8f8, 0xd8fc, 0xd919, 0xd921, 0xd92c, 0xd938,
	// Entry 7640 - 767F
	0xd957, 0xd975, 0xd9a9, 0xd9c9, 0xd9e5, 0xda01, 0xda0b, 0xda31,
	0xda55, 0xda6d, 0xda85, 0xdaa3, 0xdaa7, 0xdab5, 0xdabb, 0xdac1,
	0xdacd, 0xdad2, 0xdad8, 0xdae2, 0xdaeb, 0xdaf7, 0xdb17, 0xdb33,
	0xdb41, 0xdb54, 0xdb67, 0xdb77, 0xdb88, 0xdb9c, 0xdbae, 0xdbc2,
	0xdbd4, 0xdbec, 0xdc06, 0xdc24, 0xdc44, 0xdc65, 0xdc86, 0xdc9a,
	0xdcbd, 0xdcc9, 0xdcf0, 0xdd18, 0xdd30, 0xdd41, 0xdd52, 0xdd5e,
	0xdd67, 0xdd74, 0xdd79, 0xdd7f, 0xdd88, 0xdda2, 0xddb1, 0xddc6,
	0xdddb, 0xddf2, 0xde08, 0xde1e, 0xde33, 0xde4a, 0xde61, 0xde77,
	// Entry 7680 - 76BF
	0xde8c, 0xdea4, 0xdebc, 0xded1, 0xdee6, 0xdefd, 0xdf13, 0xdf29,
	0xdf3e, 0xdf55, 0xdf6c, 0xdf82, 0xdf97, 0xdfaf, 0xdfc7, 0xdfd4,
	0xdff5, 0xe019, 0xe021, 0xe03a, 0xe046, 0xe04a, 0xe050, 0xe061,
	0xe07b, 0xe084, 0xe088, 0xe0a7, 0xe0b4, 0xe0c3, 0xe0c9, 0xe0d3,
	0xe0db, 0xe0e6, 0xe102, 0xe11e, 0xe13b, 0xe154, 0xe16d, 0xe186,
	0xe19c, 0xe1ac, 0xe1bc, 0xe1d3, 0xe1e2, 0xe1fb, 0xe20c, 0xe219,
	0xe22a, 0xe242, 0xe259, 0xe26e, 0xe27f, 0xe290, 0xe2a3, 0xe2c3,
	0xe2ec, 0xe303, 0xe31c, 0xe331, 0xe35a, 0xe38f, 0xe3b2, 0xe3d4,
	// Entry 76C0 - 76FF
	0xe3f7, 0xe419, 0xe43c, 0xe45e, 0xe481, 0xe4a1, 0xe4c3, 0xe4e3,
	0xe505, 0xe525, 0xe547, 0xe552, 0xe562, 0xe574, 0xe58d, 0xe594,
	0xe5a5, 0xe5c1, 0xe5dd, 0xe5f3, 0xe601, 0xe60f, 0xe61f, 0xe62f,
	0xe641, 0xe64a, 0xe65f, 0xe668, 0xe66e, 0xe67a, 0xe682, 0xe693,
	0xe6a5, 0xe6c3, 0xe6d8, 0xe6ea, 0xe6fa, 0xe709, 0xe715, 0xe71b,
	0xe726, 0xe739, 0xe746, 0xe752, 0xe75c, 0xe76b, 0xe779, 0xe77d,
	0xe786, 0xe78e, 0xe79c, 0xe7a6, 0xe7b1, 0xe7b9, 0xe7bd, 0xe7c2,
	0xe7cd, 0xe7dc, 0xe7ef, 0xe7fd, 0xe805, 0xe80d, 0xe814, 0xe83e,
	// Entry 7700 - 773F
	0xe84c, 0xe865, 0xe87e, 0xe889, 0xe890, 0xe8a3, 0xe8b9, 0xe8c4,
	0xe8d0, 0xe8d4, 0xe8ef, 0xe8ff, 0xe90f, 0xe91e, 0xe92e, 0xe940,
	0xe953, 0xe965, 0xe979, 0xe98c, 0xe9a0, 0xe9b1, 0xe9c3, 0xe9ce,
	0xe9e3, 0xe9f1, 0xea07, 0xea16, 0xea2e, 0xea42, 0xea5f, 0xea6f,
	0xea89, 0xea92, 0xea9c, 0xeaa7, 0xeab8, 0xeacb, 0xead0, 0xeadd,
	0xeafc, 0xeb12, 0xeb2e, 0xeb5b, 0xeb86, 0xebba, 0xebd0, 0xebe7,
	0xebf3, 0xec11, 0xec2e, 0xec3b, 0xec5e, 0xec7a, 0xec87, 0xec93,
	0xeca6, 0xecb3, 0xecc7, 0xecd3, 0xece0, 0xecef, 0xecfb, 0xed0f,
	// Entry 7740 - 777F
	0xed2d, 0xed4a, 0xed64, 0xed8e, 0xedc0, 0xedd1, 0xeddd, 0xede7,
	0xedf3, 0xedfe, 0xee0e, 0xee27, 0xee45, 0xee62, 0xee70, 0xee7c,
	0xee86, 0xee91, 0xee9b, 0xeea9, 0xeebb, 0xeecf, 0xeeda, 0xeefd,
	0xef13, 0xef22, 0xef2e, 0xef3b, 0xef45, 0xef57, 0xef6d, 0xef90,
	0xefaa, 0xefca, 0xeff1, 0xf008, 0xf029, 0xf039, 0xf048, 0xf056,
	0xf06c, 0xf081, 0xf091, 0xf0a7, 0xf0c0, 0xf0d4, 0xf0e8, 0xf0fa,
	0xf10d, 0xf121, 0xf13e, 0xf166, 0xf175, 0xf18d, 0xf1a5, 0xf1bd,
	0xf1d5, 0xf1ed, 0xf205, 0xf224, 0xf243, 0xf262, 0xf281, 0xf29e,
	// Entry 7780 - 77BF
	0xf2bb, 0xf2d8, 0xf2f5, 0xf318, 0xf33b, 0xf35e, 0xf381, 0xf398,
	0xf3af, 0xf3c6, 0xf3dd, 0xf3fa, 0xf417, 0xf434, 0xf451, 0xf46d,
	0xf499, 0xf4b4, 0xf4df, 0xf4ef, 0xf4fd, 0xf50e, 0xf51e, 0xf539,
	0xf55a, 0xf573, 0xf592, 0xf5aa, 0xf5c2, 0xf5fe, 0xf633, 0xf66c,
	0xf686, 0xf6a5, 0xf6ca, 0xf6dc, 0xf6f6, 0xf703, 0xf718, 0xf71e,
	0xf728, 0xf738, 0xf743, 0xf753, 0xf774, 0xf779, 0xf77e, 0xf788,
	0xf78f, 0xf793, 0xf79b, 0xf79e, 0xf7aa, 0xf7b4, 0xf7bc, 0xf7c3,
	0xf7cc, 0xf7d7, 0xf7e1, 0xf7f4, 0xf7f8, 0xf805, 0xf80f, 0xf822,
	// Entry 77C0 - 77FF
	0xf836, 0xf844, 0xf855, 0xf85c, 0xf864, 0xf874, 0xf886, 0xf897,
	0xf8a5, 0xf8a9, 0xf8b0, 0xf8b9, 0xf8d1, 0xf8e7, 0xf8f8, 0xf913,
	0xf92a, 0xf92e, 0xf93b, 0xf949, 0xf95a, 0xf978, 0xf98c, 0xf9a0,
	0xf9b8, 0xf9bf, 0xf9ca, 0xf9d3, 0xf9e5, 0xf9ef, 0xf9fd, 0xfa0e,
	0xfa19, 0xfa26, 0xfa2e, 0xfa39, 0xfa3f, 0xfa4b, 0xfa51, 0xfa55,
	0xfa5c, 0xfa6c, 0xfa73, 0xfa80, 0xfa8c, 0xfaa9, 0xfab8, 0xfad2,
	0xfadd, 0xfae9, 0xfaf7, 0xfb0d, 0xfb1a, 0xfb26, 0xfb29, 0xfb39,
	0xfb47, 0xfb57, 0xfb5c, 0xfb62, 0xfb73, 0xfb79, 0xfb81, 0xfb89,
	// Entry 7800 - 783F
	0xfb96, 0xfba0, 0xfbbd, 0xfbd1, 0xfbeb, 0xfbf9, 0xfc14, 0xfc26,
	0xfc37, 0xfc40, 0xfc54, 0xfc65, 0xfc73, 0xfc7a, 0xfc87, 0xfc8c,
	0xfc90, 0xfc9d, 0xfca7, 0xfcc9, 0xfce2, 0xfcfc, 0xfd17, 0xfd32,
	0xfd52, 0xfd72, 0xfd94, 0xfdb4, 0xfdd6, 0xfdf3, 0xfe12, 0xfe31,
	0xfe4d, 0xfe76, 0xfe98, 0xfebf, 0xfee8, 0xff11, 0xff2f, 0xff49,
	0xff64, 0xff81, 0xffa0, 0xffbf, 0xffe0, 0xfffa, 0x0016, 0x0034,
	0x0054, 0x0078, 0x009d, 0x00bd, 0x00e2, 0x010b, 0x0131, 0x0159,
	0x0181, 0x01b1, 0x01e2, 0x0201, 0x021e, 0x023c, 0x025e, 0x0289,
	// Entry 7840 - 787F
	0x02af, 0x02e2, 0x030b, 0x0334, 0x035f, 0x037c, 0x039b, 0x03ba,
	0x03d9, 0x03f5, 0x0413, 0x0432, 0x0454, 0x0471, 0x048e, 0x04ad,
	0x04ce, 0x04ef, 0x050b, 0x0529, 0x0549, 0x0564, 0x0581, 0x059e,
	0x05b8, 0x05d1, 0x05ed, 0x060b, 0x0624, 0x063d, 0x0659, 0x0673,
	0x068e, 0x06b1, 0x06d6, 0x06f4, 0x0711, 0x0736, 0x0755, 0x076f,
	0x078a, 0x07aa, 0x07c5, 0x07e4, 0x07ff, 0x0823, 0x0840, 0x086b,
	0x0898, 0x08b9, 0x08da, 0x08f7, 0x0915, 0x0935, 0x0951, 0x0973,
	0x0991, 0x09b1, 0x09d1, 0x09f1, 0x0a11, 0x0a2e, 0x0a50, 0x0a75,
	// Entry 7880 - 78BF
	0x0a91, 0x0aab, 0x0ac6, 0x0ae5, 0x0b00, 0x0b1f, 0x0b3f, 0x0b6b,
	0x0b95, 0x0bc2, 0x0bee, 0x0c09, 0x0c21, 0x0c32, 0x0c44, 0x0c5b,
	0x0c77, 0x0ca1, 0x0cad, 0x0cbe, 0x0cd9, 0x0ceb, 0x0cfe, 0x0d0f,
	0x0d21, 0x0d38, 0x0d54, 0x0d83, 0x0dae, 0x0dbb, 0x0dcd, 0x0de5,
	0x0dff, 0x0e30, 0x0e5d, 0x0e6b, 0x0e7d, 0x0e95, 0x0eaf, 0x0edb,
	0x0eeb, 0x0efc, 0x0f0e, 0x0f1e, 0x0f33, 0x0f49, 0x0f64, 0x0f70,
	0x0f7d, 0x0f8b, 0x0f97, 0x0fa4, 0x0fb6, 0x0fcd, 0x0fe7, 0x1002,
	0x101b, 0x1035, 0x1054, 0x1078, 0x1091, 0x10ab, 0x10c3, 0x10dc,
	// Entry 78C0 - 78FF
	0x10fa, 0x111d, 0x1138, 0x1154, 0x116e, 0x1189, 0x11a9, 0x11c7,
	0x11e6, 0x11fe, 0x1220, 0x123d, 0x125b, 0x1272, 0x1293, 0x12bb,
	0x12d8, 0x12f5, 0x1312, 0x132e, 0x1347, 0x1366, 0x1384, 0x13a7,
	0x13c8, 0x13e7, 0x1406, 0x1428, 0x1438, 0x1451, 0x145f, 0x1476,
	0x14a3, 0x14ce, 0x14fc, 0x1529, 0x1557, 0x1583, 0x15b2, 0x15e0,
	0x160d, 0x1638, 0x1666, 0x1693, 0x16c3, 0x16f1, 0x1722, 0x1752,
	0x177c, 0x17a4, 0x17cf, 0x17f9, 0x1829, 0x1857, 0x1888, 0x18b8,
	0x18ee, 0x1922, 0x1959, 0x198f, 0x19c0, 0x19ef, 0x1a21, 0x1a52,
	// Entry 7900 - 793F
	0x1a83, 0x1ab2, 0x1ae4, 0x1b15, 0x1b44, 0x1b71, 0x1ba1, 0x1bd0,
	0x1c00, 0x1c2e, 0x1c5f, 0x1c8f, 0x1cc4, 0x1cf7, 0x1d2d, 0x1d62,
	0x1d7d, 0x1d96, 0x1db2, 0x1dcd, 0x1de4, 0x1df9, 0x1e11, 0x1e28,
	0x1e42, 0x1e5a, 0x1e75, 0x1e8f, 0x1eaf, 0x1ecd, 0x1eee, 0x1f0e,
	0x1f23, 0x1f36, 0x1f4c, 0x1f61, 0x1f7b, 0x1f93, 0x1fae, 0x1fc8,
	0x1fe3, 0x1ffe, 0x2019, 0x2034, 0x204f, 0x2067, 0x208d, 0x20b1,
	0x20d8, 0x20fe, 0x2125, 0x214c, 0x2173, 0x219a, 0x21ba, 0x21d8,
	0x21f9, 0x2219, 0x223a, 0x225b, 0x227c, 0x229d, 0x22c4, 0x22e9,
	// Entry 7940 - 797F
	0x2311, 0x2338, 0x2360, 0x2388, 0x23b0, 0x23d8, 0x23fe, 0x2422,
	0x2449, 0x246f, 0x2496, 0x24bd, 0x24e4, 0x250b, 0x2536, 0x255f,
	0x258b, 0x25b6, 0x25e2, 0x260e, 0x263a, 0x2666, 0x2682, 0x269c,
	0x26b9, 0x26d5, 0x2704, 0x2731, 0x2761, 0x2790, 0x27b1, 0x27d0,
	0x27f2, 0x2813, 0x282e, 0x2850, 0x2870, 0x2891, 0x28b4, 0x28d8,
	0x28f8, 0x2919, 0x293a, 0x295d, 0x297f, 0x29a1, 0x29cb, 0x29f6,
	0x2a21, 0x2a4d, 0x2a68, 0x2a8a, 0x2aad, 0x2acf, 0x2ae3, 0x2b02,
	0x2b22, 0x2b40, 0x2b59, 0x2b69, 0x2b7d, 0x2b99, 0x2bb6, 0x2bdb,
	// Entry 7980 - 79BF
	0x2bec, 0x2bfc, 0x2c11, 0x2c1a, 0x2c27, 0x2c3d, 0x2c47, 0x2c53,
	0x2c64, 0x2c70, 0x2c83, 0x2c93, 0x2ca4, 0x2cad, 0x2cd7, 0x2ceb,
	0x2cff, 0x2d09, 0x2d17, 0x2d34, 0x2d41, 0x2d4b, 0x2d54, 0x2d61,
	0x2d7d, 0x2d99, 0x2dc7, 0x2dec, 0x2e14, 0x2e4a, 0x2e67, 0x2e87,
	0x2e95, 0x2ea3, 0x2eb4, 0x2eba, 0x2ec0, 0x2ecd, 0x2edd, 0x2ee2,
	0x2ef8, 0x2f00, 0x2f06, 0x2f17, 0x2f20, 0x2f2a, 0x2f32, 0x2f3f,
	0x2f53, 0x2f63, 0x2f70, 0x2f75, 0x2f7d, 0x2f82, 0x2f93, 0x2fa5,
	0x2fb6, 0x2fc2, 0x2fd6, 0x2fe3, 0x2ffa, 0x3002, 0x300d, 0x3016,
	// Entry 79C0 - 79FF
	0x301d, 0x3025, 0x302a, 0x3030, 0x3036, 0x3044, 0x304f, 0x3062,
	0x3073, 0x3076, 0x3083, 0x308a, 0x3093, 0x309b, 0x30a3, 0x30b1,
	0x30bc, 0x30c6, 0x30d5, 0x30e3, 0x30ea, 0x30f2, 0x30f5, 0x30fc,
	0x3107, 0x310f, 0x311a, 0x3125, 0x312a, 0x3133, 0x3138, 0x3167,
	0x3189, 0x31ad, 0x31bc, 0x31c9, 0x31e0, 0x31e8, 0x31ef, 0x31fa,
	0x3203, 0x3207, 0x3210, 0x3218, 0x321e, 0x322a, 0x322f, 0x3233,
	0x3236, 0x323b, 0x323e, 0x3246, 0x324f, 0x3253, 0x325a, 0x3260,
	0x326a, 0x3270, 0x3275, 0x3281, 0x328b, 0x3293, 0x329b, 0x32a0,
	// Entry 7A00 - 7A3F
	0x32a7, 0x32af, 0x32b4, 0x32bb, 0x32c7, 0x32cd, 0x32d4, 0x32db,
	0x32e3, 0x32ea, 0x32f0, 0x32f4, 0x330c, 0x3326, 0x333a, 0x3354,
	0x3358, 0x335b, 0x335f, 0x3364, 0x336d, 0x3379, 0x3385, 0x338c,
	0x3397, 0x33a8, 0x33ad, 0x33b2, 0x33bd, 0x33cb, 0x33e0, 0x33f5,
	0x3404, 0x341c, 0x3420, 0x3425, 0x342c, 0x3435, 0x3438, 0x343d,
	0x3443, 0x3448, 0x3454, 0x345e, 0x3463, 0x3469, 0x346d, 0x3472,
	0x3483, 0x348e, 0x34a1, 0x34aa, 0x34b4, 0x34c4, 0x34cb, 0x34d1,
	0x34e2, 0x34e9, 0x34ee, 0x34f4, 0x34fb, 0x3508, 0x3517, 0x3523,
	// Entry 7A40 - 7A7F
	0x352d, 0x3537, 0x353c, 0x3542, 0x354f, 0x355a, 0x3560, 0x3567,
	0x3573, 0x3586, 0x359a, 0x35ae, 0x35bf, 0x35d2, 0x35e4, 0x35f7,
	0x360c, 0x3622, 0x3638, 0x364b, 0x3660, 0x3674, 0x3689, 0x36aa,
	0x36cb, 0x36ec, 0x370d, 0x372e, 0x374f, 0x3770, 0x3791, 0x37b2,
	0x37d3, 0x37f4, 0x3815, 0x3836, 0x3857, 0x3878, 0x3899, 0x38ba,
	0x38db, 0x38fc, 0x391d, 0x393e, 0x395f, 0x3980, 0x39a1, 0x39c2,
	0x39e3, 0x3a04, 0x3a25, 0x3a46, 0x3a67, 0x3a88, 0x3aa9, 0x3aca,
	0x3aeb, 0x3b0c, 0x3b2d, 0x3b4e, 0x3b6f, 0x3b90, 0x3bb1, 0x3bd2,
	// Entry 7A80 - 7ABF
	0x3bf3, 0x3c14, 0x3c35, 0x3c56, 0x3c77, 0x3c98, 0x3cb9, 0x3cda,
	0x3cfb, 0x3d1c, 0x3d3d, 0x3d5e, 0x3d7f, 0x3da0, 0x3dc1, 0x3de2,
	0x3e03, 0x3e24, 0x3e45, 0x3e66, 0x3e87, 0x3ea8, 0x3ec9, 0x3eea,
	0x3f0b, 0x3f2c, 0x3f4d, 0x3f6e, 0x3f8f, 0x3fb0, 0x3fd1, 0x3ff2,
	0x4013, 0x4034, 0x4055, 0x4076, 0x4097, 0x40b8, 0x40d9, 0x40fa,
	0x411b, 0x413c, 0x415d, 0x417e, 0x419f, 0x41c0, 0x41e1, 0x4202,
	0x4223, 0x4244, 0x4265, 0x4286, 0x42a7, 0x42c8, 0x42e9, 0x430a,
	0x432b, 0x434c, 0x436d, 0x438e, 0x43af, 0x43d0, 0x43f1, 0x4412,
	// Entry 7AC0 - 7AFF
	0x4433, 0x4454, 0x4475, 0x4496, 0x44b7, 0x44d8, 0x44f9, 0x451a,
	0x453b, 0x455c, 0x457d, 0x459e, 0x45bf, 0x45e0, 0x4601, 0x4622,
	0x4643, 0x4664, 0x4685, 0x46a6, 0x46c7, 0x46e8, 0x4709, 0x472a,
	0x474b, 0x476c, 0x478d, 0x47ae, 0x47cf, 0x47f0, 0x4811, 0x4832,
	0x4853, 0x4874, 0x4895, 0x48b6, 0x48d7, 0x48f8, 0x4919, 0x493a,
	0x495b, 0x497c, 0x499d, 0x49be, 0x49df, 0x4a00, 0x4a21, 0x4a42,
	0x4a63, 0x4a84, 0x4aa5, 0x4ac6, 0x4ae7, 0x4b08, 0x4b29, 0x4b4a,
	0x4b6b, 0x4b8c, 0x4bad, 0x4bce, 0x4bef, 0x4c10, 0x4c31, 0x4c52,
	// Entry 7B00 - 7B3F
	0x4c73, 0x4c94, 0x4cb5, 0x4cd6, 0x4cf7, 0x4d18, 0x4d39, 0x4d5a,
	0x4d7b, 0x4d9c, 0x4dbd, 0x4dde, 0x4dff, 0x4e20, 0x4e41, 0x4e62,
	0x4e83, 0x4ea4, 0x4ec5, 0x4ee6, 0x4f07, 0x4f28, 0x4f49, 0x4f6a,
	0x4f8b, 0x4fac, 0x4fcd, 0x4fee, 0x500f, 0x5030, 0x5051, 0x5072,
	0x5093, 0x50b4, 0x50d5, 0x50f6, 0x5117, 0x5138, 0x5159, 0x517a,
	0x519b, 0x51bc, 0x51dd, 0x51fe, 0x521f, 0x5240, 0x5261, 0x5282,
	0x52a3, 0x52c4, 0x52e5, 0x5306, 0x5327, 0x5348, 0x5369, 0x538a,
	0x53ab, 0x53cc, 0x53ed, 0x540e, 0x542f, 0x5450, 0x5471, 0x5492,
	// Entry 7B40 - 7B7F
	0x54b3, 0x54d4, 0x54f5, 0x5516, 0x5537, 0x5558, 0x5579, 0x559a,
	0x55bb, 0x55dc, 0x55fd, 0x561e, 0x563f, 0x5660, 0x5681, 0x56a2,
	0x56c3, 0x56e4, 0x5705, 0x5726, 0x5747, 0x5768, 0x5789, 0x57aa,
	0x57cb, 0x57ec, 0x580d, 0x582e, 0x584f, 0x5870, 0x5891, 0x58b2,
	0x58d3, 0x58f4, 0x5915, 0x5936, 0x5957, 0x5978, 0x5999, 0x59ba,
	0x59db, 0x59fc, 0x5a1d, 0x5a3e, 0x5a5f, 0x5a80, 0x5aa1, 0x5ac2,
	0x5ae3, 0x5b04, 0x5b25, 0x5b46, 0x5b67, 0x5b88, 0x5ba9, 0x5bca,
	0x5beb, 0x5c0c, 0x5c2d, 0x5c4e, 0x5c6f, 0x5c90, 0x5cb1, 0x5cd2,
	// Entry 7B80 - 7BBF
	0x5cf3, 0x5d14, 0x5d35, 0x5d56, 0x5d77, 0x5d98, 0x5db9, 0x5dda,
	0x5dfb, 0x5e1c, 0x5e3d, 0x5e5e, 0x5e7f, 0x5ea0, 0x5ec1, 0x5ee2,
	0x5f03, 0x5f24, 0x5f45, 0x5f66, 0x5f87, 0x5fa8, 0x5fc9, 0x5fea,
	0x600b, 0x602c, 0x604d, 0x606e, 0x608f, 0x60b0, 0x60d1, 0x60f2,
	0x6113, 0x6134, 0x6155, 0x6176, 0x6197, 0x61b8, 0x61d9, 0x61fa,
	0x621b, 0x623c, 0x625d, 0x627e, 0x629f, 0x62c0, 0x62e1, 0x6302,
	0x6323, 0x6344, 0x6365, 0x6386, 0x63a7, 0x63c8, 0x63e9, 0x640a,
	0x642b, 0x644c, 0x646d, 0x648e, 0x64af, 0x64d0, 0x64f1, 0x6512,
	// Entry 7BC0 - 7BFF
	0x6533, 0x6554, 0x6575, 0x6596, 0x65b7, 0x65d8, 0x65f9, 0x661a,
	0x663b, 0x665c, 0x667d, 0x669e, 0x66bf, 0x66e0, 0x6701, 0x6722,
	0x6743, 0x6764, 0x6785, 0x67a6, 0x67c7, 0x67e8, 0x6809, 0x682a,
	0x684b, 0x686c, 0x688d, 0x68ae, 0x68cf, 0x68f0, 0x6911, 0x6932,
	0x6953, 0x6974, 0x6995, 0x69b6, 0x69d7, 0x69f8, 0x6a19, 0x6a3a,
	0x6a5b, 0x6a7c, 0x6a9d, 0x6abe, 0x6adf, 0x6b00, 0x6b21, 0x6b42,
	0x6b63, 0x6b84, 0x6ba5, 0x6bc6, 0x6be7, 0x6c08, 0x6c29, 0x6c4a,
	0x6c6b, 0x6c8c, 0x6cad, 0x6cce, 0x6cef, 0x6d10, 0x6d31, 0x6d52,
	// Entry 7C00 - 7C3F
	0x6d73, 0x6d94, 0x6db5, 0x6dd6, 0x6df7, 0x6e18, 0x6e39, 0x6e5a,
	0x6e7b, 0x6e9c, 0x6ebd, 0x6ede, 0x6eff, 0x6f20, 0x6f41, 0x6f62,
	0x6f83, 0x6fa4, 0x6fc5, 0x6fe6, 0x7007, 0x7028, 0x7049, 0x706a,
	0x708b, 0x70ac, 0x70cd, 0x70ee, 0x710f, 0x7130, 0x7151, 0x7172,
	0x7193, 0x71b4, 0x71d5, 0x71f6, 0x7217, 0x7238, 0x7259, 0x727a,
	0x729b, 0x72bc, 0x72dd, 0x72fe, 0x731f, 0x7340, 0x7361, 0x7382,
	0x73a3, 0x73c4, 0x73e5, 0x7406, 0x7427, 0x7448, 0x7469, 0x748a,
	0x74ab, 0x74cc, 0x74ed, 0x750e, 0x752f, 0x7550, 0x7571, 0x7592,
	// Entry 7C40 - 7C7F
	0x75b3, 0x75d4, 0x75f5, 0x7616, 0x7637, 0x7658, 0x7679, 0x769a,
	0x76bb, 0x76dc, 0x76fd, 0x771e, 0x773f, 0x7760, 0x7781, 0x77a2,
	0x77c3, 0x77e4, 0x7805, 0x7826, 0x7847, 0x7868, 0x7889, 0x78aa,
	0x78cb, 0x78ec, 0x790d, 0x792e, 0x794f, 0x7970, 0x7991, 0x79b2,
	0x79d3, 0x79f4, 0x7a15, 0x7a36, 0x7a57, 0x7a78, 0x7a99, 0x7aba,
	0x7adb, 0x7afc, 0x7b1d, 0x7b3e, 0x7b5f, 0x7b80, 0x7ba1, 0x7bc2,
	0x7be3, 0x7c04, 0x7c25, 0x7c46, 0x7c67, 0x7c73, 0x7c7c, 0x7c90,
	0x7ca2, 0x7cb1, 0x7cc0, 0x7cd0, 0x7cdd, 0x7ceb, 0x7cff, 0x7d14,
	// Entry 7C80 - 7CBF
	0x7d20, 0x7d2d, 0x7d36, 0x7d46, 0x7d53, 0x7d5e, 0x7d6c, 0x7d79,
	0x7d86, 0x7d95, 0x7da3, 0x7db1, 0x7dbe, 0x7dcd, 0x7ddc, 0x7dea,
	0x7df3, 0x7e00, 0x7e12, 0x7e21, 0x7e36, 0x7e47, 0x7e58, 0x7e72,
	0x7e8c, 0x7ea6, 0x7ec0, 0x7eda, 0x7ef4, 0x7f0e, 0x7f28, 0x7f42,
	0x7f5c, 0x7f76, 0x7f90, 0x7faa, 0x7fc4, 0x7fde, 0x7ff8, 0x8012,
	0x802c, 0x8046, 0x8060, 0x807a, 0x8094, 0x80ae, 0x80c8, 0x80e2,
	0x80fc, 0x8113, 0x8126, 0x813e, 0x8153, 0x815f, 0x816f, 0x8187,
	0x819f, 0x81b7, 0x81cf, 0x81e7, 0x81ff, 0x8217, 0x822f, 0x8247,
	// Entry 7CC0 - 7CFF
	0x825f, 0x8277, 0x828f, 0x82a7, 0x82bf, 0x82d7, 0x82ef, 0x8307,
	0x831f, 0x8337, 0x834f, 0x8367, 0x837f, 0x8397, 0x83af, 0x83c7,
	0x83df, 0x83f5, 0x8406, 0x841d, 0x8426, 0x8430, 0x8445, 0x845a,
	0x846f, 0x8484, 0x8499, 0x84ae, 0x84c3, 0x84d8, 0x84ed, 0x8502,
	0x8517, 0x852c, 0x8541, 0x8556, 0x856b, 0x8580, 0x8595, 0x85aa,
	0x85bf, 0x85d4, 0x85e9, 0x85fe, 0x8613, 0x8628, 0x863d, 0x8652,
	0x8667, 0x867c, 0x8691, 0x86a6, 0x86bb, 0x86d0, 0x86e5, 0x86fa,
	0x870f, 0x8724, 0x8739, 0x874e, 0x8763, 0x8778, 0x878d, 0x87a2,
	// Entry 7D00 - 7D3F
	0x87b7, 0x87cc, 0x87e1, 0x87f6, 0x880b, 0x8820, 0x8835, 0x884a,
	0x885f, 0x8874, 0x8889, 0x889e, 0x88b3, 0x88c8, 0x88dd, 0x88f2,
	0x8907, 0x891c, 0x8931, 0x8946, 0x895b, 0x8970, 0x8985, 0x899a,
	0x89af, 0x89c4, 0x89d9, 0x89ee, 0x8a03, 0x8a18, 0x8a2d, 0x8a42,
	0x8a57, 0x8a6c, 0x8a81, 0x8a96, 0x8aab, 0x8ac0, 0x8ad5, 0x8aea,
	0x8aff, 0x8b15, 0x8b2b, 0x8b41, 0x8b57, 0x8b6d, 0x8b83, 0x8b99,
	0x8baf, 0x8bc5, 0x8bdb, 0x8bf1, 0x8c07, 0x8c1d, 0x8c33, 0x8c49,
	0x8c5f, 0x8c75, 0x8c8b, 0x8ca1, 0x8cb7, 0x8ccd, 0x8ce3, 0x8cf9,
	// Entry 7D40 - 7D7F
	0x8d0f, 0x8d25, 0x8d3b, 0x8d51, 0x8d67, 0x8d7d, 0x8d93, 0x8da9,
	0x8dbf, 0x8dd5, 0x8deb, 0x8e01, 0x8e17, 0x8e2d, 0x8e43, 0x8e59,
	0x8e6f, 0x8e85, 0x8e9b, 0x8eb1, 0x8ec7, 0x8edd, 0x8ef3, 0x8f09,
	0x8f1f, 0x8f35, 0x8f4b, 0x8f61, 0x8f77, 0x8f8d, 0x8fa3, 0x8fb9,
	0x8fcf, 0x8fe5, 0x8ffb, 0x9011, 0x9027, 0x903d, 0x9053, 0x9069,
	0x907f, 0x9095, 0x90ab, 0x90c1, 0x90d7, 0x90ed, 0x9103, 0x9119,
	0x912f, 0x9145, 0x915b, 0x9171, 0x9187, 0x919d, 0x91b3, 0x91c9,
	0x91df, 0x91f5, 0x920b, 0x9221, 0x9237, 0x924d, 0x9263, 0x9279,
	// Entry 7D80 - 7DBF
	0x928f, 0x92a5, 0x92bb, 0x92d1, 0x92e7, 0x92fd, 0x9313, 0x9329,
	0x933f, 0x9355, 0x936b, 0x9381, 0x9397, 0x93ad, 0x93c3, 0x93d9,
	0x93ef, 0x9405, 0x941b, 0x9431, 0x9447, 0x945d, 0x9473, 0x9489,
	0x949f, 0x94b5, 0x94cb, 0x94e1, 0x94f7, 0x950d, 0x9523, 0x9539,
	0x954f, 0x9565, 0x957b, 0x9591, 0x95a7, 0x95bd, 0x95d3, 0x95e9,
	0x95ff, 0x9615, 0x962b, 0x9641, 0x9657, 0x966d, 0x9683, 0x9699,
	0x96af, 0x96c5, 0x96db, 0x96f1, 0x9707, 0x971d, 0x9733, 0x9749,
	0x975f, 0x9775, 0x978b, 0x97a1, 0x97b7, 0x97cd, 0x97e3, 0x97f9,
	// Entry 7DC0 - 7DFF
	0x980f, 0x9825, 0x983b, 0x9851, 0x9867, 0x987d,
} // Size: 64420 bytes

const directData string = "" + // Size: 353 bytes
	"<CJK Ideograph Extension A><CJK Ideograph Extension B><CJK Ideograph Ext" +
	"ension C><CJK Ideograph Extension D><CJK Ideograph Extension E><CJK Ideo" +
	"graph Extension F><CJK Ideograph><Hangul Syllable><Low Surrogate><Non Pr" +
	"ivate Use High Surrogate><Plane 15 Private Use><Plane 16 Private Use><Pr" +
	"ivate Use High Surrogate><Private Use><Tangut Ideograph><control>"

const singleData string = ("" + // Size: 825469 bytes; the redundant, explicit parens are for https://golang.org/issue/18078
	"SPACEEXCLAMATION MARKQUOTATION MARKNUMBER SIGNDOLLAR SIGNPERCENT SIGNAMP" +
	"ERSANDAPOSTROPHELEFT PARENTHESISRIGHT PARENTHESISASTERISKPLUS SIGNCOMMAH" +
	"YPHEN-MINUSFULL STOPSOLIDUSDIGIT ZERODIGIT ONEDIGIT TWODIGIT THREEDIGIT " +
	"FOURDIGIT FIVEDIGIT SIXDIGIT SEVENDIGIT EIGHTDIGIT NINECOLONSEMICOLONLES" +
	"S-THAN SIGNEQUALS SIGNGREATER-THAN SIGNQUESTION MARKCOMMERCIAL ATLATIN C" +
	"APITAL LETTER ALATIN CAPITAL LETTER BLATIN CAPITAL LETTER CLATIN CAPITAL" +
	" LETTER DLATIN CAPITAL LETTER ELATIN CAPITAL LETTER FLATIN CAPITAL LETTE" +
	"R GLATIN CAPITAL LETTER HLATIN CAPITAL LETTER ILATIN CAPITAL LETTER JLAT" +
	"IN CAPITAL LETTER KLATIN CAPITAL LETTER LLATIN CAPITAL LETTER MLATIN CAP" +
	"ITAL LETTER NLATIN CAPITAL LETTER OLATIN CAPITAL LETTER PLATIN CAPITAL L" +
	"ETTER QLATIN CAPITAL LETTER RLATIN CAPITAL LETTER SLATIN CAPITAL LETTER " +
	"TLATIN CAPITAL LETTER ULATIN CAPITAL LETTER VLATIN CAPITAL LETTER WLATIN" +
	" CAPITAL LETTER XLATIN CAPITAL LETTER YLATIN CAPITAL LETTER ZLEFT SQUARE" +
	" BRACKETREVERSE SOLIDUSRIGHT SQUARE BRACKETCIRCUMFLEX ACCENTLOW LINEGRAV" +
	"E ACCENTLATIN SMALL LETTER ALATIN SMALL LETTER BLATIN SMALL LETTER CLATI" +
	"N SMALL LETTER DLATIN SMALL LETTER ELATIN SMALL LETTER FLATIN SMALL LETT" +
	"ER GLATIN SMALL LETTER HLATIN SMALL LETTER ILATIN SMALL LETTER JLATIN SM" +
	"ALL LETTER KLATIN SMALL LETTER LLATIN SMALL LETTER MLATIN SMALL LETTER N" +
	"LATIN SMALL LETTER OLATIN SMALL LETTER PLATIN SMALL LETTER QLATIN SMALL " +
	"LETTER RLATIN SMALL LETTER SLATIN SMALL LETTER TLATIN SMALL LETTER ULATI" +
	"N SMALL LETTER VLATIN SMALL LETTER WLATIN SMALL LETTER XLATIN SMALL LETT" +
	"ER YLATIN SMALL LETTER ZLEFT CURLY BRACKETVERTICAL LINERIGHT CURLY BRACK" +
	"ETTILDENO-BREAK SPACEINVERTED EXCLAMATION MARKCENT SIGNPOUND SIGNCURRENC" +
	"Y SIGNYEN SIGNBROKEN BARSECTION SIGNDIAERESISCOPYRIGHT SIGNFEMININE ORDI" +
	"NAL INDICATORLEFT-POINTING DOUBLE ANGLE QUOTATION MARKNOT SIGNSOFT HYPHE" +
	"NREGISTERED SIGNMACRONDEGREE SIGNPLUS-MINUS SIGNSUPERSCRIPT TWOSUPERSCRI" +
	"PT THREEACUTE ACCENTMICRO SIGNPILCROW SIGNMIDDLE DOTCEDILLASUPERSCRIPT O" +
	"NEMASCULINE ORDINAL INDICATORRIGHT-POINTING DOUBLE ANGLE QUOTATION MARKV" +
	"ULGAR FRACTION ONE QUARTERVULGAR FRACTION ONE HALFVULGAR FRACTION THREE " +
	"QUARTERSINVERTED QUESTION MARKLATIN CAPITAL LETTER A WITH GRAVELATIN CAP" +
	"ITAL LETTER A WITH ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEXLATIN CAPI" +
	"TAL LETTER A WITH TILDELATIN CAPITAL LETTER A WITH DIAERESISLATIN CAPITA" +
	"L LETTER A WITH RING ABOVELATIN CAPITAL LETTER AELATIN CAPITAL LETTER C " +
	"WITH CEDILLALATIN CAPITAL LETTER E WITH GRAVELATIN CAPITAL LETTER E WITH" +
	" ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEXLATIN CAPITAL LETTER E WITH " +
	"DIAERESISLATIN CAPITAL LETTER I WITH GRAVELATIN CAPITAL LETTER I WITH AC" +
	"UTELATIN CAPITAL LETTER I WITH CIRCUMFLEXLATIN CAPITAL LETTER I WITH DIA" +
	"ERESISLATIN CAPITAL LETTER ETHLATIN CAPITAL LETTER N WITH TILDELATIN CAP" +
	"ITAL LETTER O WITH GRAVELATIN CAPITAL LETTER O WITH ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEXLATIN CAPITAL LETTER O WITH TILDELATIN CAPITAL LE" +
	"TTER O WITH DIAERESISMULTIPLICATION SIGNLATIN CAPITAL LETTER O WITH STRO" +
	"KELATIN CAPITAL LETTER U WITH GRAVELATIN CAPITAL LETTER U WITH ACUTELATI" +
	"N CAPITAL LETTER U WITH CIRCUMFLEXLATIN CAPITAL LETTER U WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH ACUTELATIN CAPITAL LETTER THORNLATIN SMALL LE" +
	"TTER SHARP SLATIN SMALL LETTER A WITH GRAVELATIN SMALL LETTER A WITH ACU" +
	"TELATIN SMALL LETTER A WITH CIRCUMFLEXLATIN SMALL LETTER A WITH TILDELAT" +
	"IN SMALL LETTER A WITH DIAERESISLATIN SMALL LETTER A WITH RING ABOVELATI" +
	"N SMALL LETTER AELATIN SMALL LETTER C WITH CEDILLALATIN SMALL LETTER E W" +
	"ITH GRAVELATIN SMALL LETTER E WITH ACUTELATIN SMALL LETTER E WITH CIRCUM" +
	"FLEXLATIN SMALL LETTER E WITH DIAERESISLATIN SMALL LETTER I WITH GRAVELA" +
	"TIN SMALL LETTER I WITH ACUTELATIN SMALL LETTER I WITH CIRCUMFLEXLATIN S" +
	"MALL LETTER I WITH DIAERESISLATIN SMALL LETTER ETHLATIN SMALL LETTER N W" +
	"ITH TILDELATIN SMALL LETTER O WITH GRAVELATIN SMALL LETTER O WITH ACUTEL" +
	"ATIN SMALL LETTER O WITH CIRCUMFLEXLATIN SMALL LETTER O WITH TILDELATIN " +
	"SMALL LETTER O WITH DIAERESISDIVISION SIGNLATIN SMALL LETTER O WITH STRO" +
	"KELATIN SMALL LETTER U WITH GRAVELATIN SMALL LETTER U WITH ACUTELATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEXLATIN SMALL LETTER U WITH DIAERESISLATIN SMA" +
	"LL LETTER Y WITH ACUTELATIN SMALL LETTER THORNLATIN SMALL LETTER Y WITH " +
	"DIAERESISLATIN CAPITAL LETTER A WITH MACRONLATIN SMALL LETTER A WITH MAC" +
	"RONLATIN CAPITAL LETTER A WITH BREVELATIN SMALL LETTER A WITH BREVELATIN" +
	" CAPITAL LETTER A WITH OGONEKLATIN SMALL LETTER A WITH OGONEKLATIN CAPIT" +
	"AL LETTER C WITH ACUTELATIN SMALL LETTER C WITH ACUTELATIN CAPITAL LETTE" +
	"R C WITH CIRCUMFLEXLATIN SMALL LETTER C WITH CIRCUMFLEXLATIN CAPITAL LET") + ("" +
	"TER C WITH DOT ABOVELATIN SMALL LETTER C WITH DOT ABOVELATIN CAPITAL LET" +
	"TER C WITH CARONLATIN SMALL LETTER C WITH CARONLATIN CAPITAL LETTER D WI" +
	"TH CARONLATIN SMALL LETTER D WITH CARONLATIN CAPITAL LETTER D WITH STROK" +
	"ELATIN SMALL LETTER D WITH STROKELATIN CAPITAL LETTER E WITH MACRONLATIN" +
	" SMALL LETTER E WITH MACRONLATIN CAPITAL LETTER E WITH BREVELATIN SMALL " +
	"LETTER E WITH BREVELATIN CAPITAL LETTER E WITH DOT ABOVELATIN SMALL LETT" +
	"ER E WITH DOT ABOVELATIN CAPITAL LETTER E WITH OGONEKLATIN SMALL LETTER " +
	"E WITH OGONEKLATIN CAPITAL LETTER E WITH CARONLATIN SMALL LETTER E WITH " +
	"CARONLATIN CAPITAL LETTER G WITH CIRCUMFLEXLATIN SMALL LETTER G WITH CIR" +
	"CUMFLEXLATIN CAPITAL LETTER G WITH BREVELATIN SMALL LETTER G WITH BREVEL" +
	"ATIN CAPITAL LETTER G WITH DOT ABOVELATIN SMALL LETTER G WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER G WITH CEDILLALATIN SMALL LETTER G WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH CIRCUMFLEXLATIN SMALL LETTER H WITH CIRCUMFLEXLAT" +
	"IN CAPITAL LETTER H WITH STROKELATIN SMALL LETTER H WITH STROKELATIN CAP" +
	"ITAL LETTER I WITH TILDELATIN SMALL LETTER I WITH TILDELATIN CAPITAL LET" +
	"TER I WITH MACRONLATIN SMALL LETTER I WITH MACRONLATIN CAPITAL LETTER I " +
	"WITH BREVELATIN SMALL LETTER I WITH BREVELATIN CAPITAL LETTER I WITH OGO" +
	"NEKLATIN SMALL LETTER I WITH OGONEKLATIN CAPITAL LETTER I WITH DOT ABOVE" +
	"LATIN SMALL LETTER DOTLESS ILATIN CAPITAL LIGATURE IJLATIN SMALL LIGATUR" +
	"E IJLATIN CAPITAL LETTER J WITH CIRCUMFLEXLATIN SMALL LETTER J WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER K WITH CEDILLALATIN SMALL LETTER K WITH CEDIL" +
	"LALATIN SMALL LETTER KRALATIN CAPITAL LETTER L WITH ACUTELATIN SMALL LET" +
	"TER L WITH ACUTELATIN CAPITAL LETTER L WITH CEDILLALATIN SMALL LETTER L " +
	"WITH CEDILLALATIN CAPITAL LETTER L WITH CARONLATIN SMALL LETTER L WITH C" +
	"ARONLATIN CAPITAL LETTER L WITH MIDDLE DOTLATIN SMALL LETTER L WITH MIDD" +
	"LE DOTLATIN CAPITAL LETTER L WITH STROKELATIN SMALL LETTER L WITH STROKE" +
	"LATIN CAPITAL LETTER N WITH ACUTELATIN SMALL LETTER N WITH ACUTELATIN CA" +
	"PITAL LETTER N WITH CEDILLALATIN SMALL LETTER N WITH CEDILLALATIN CAPITA" +
	"L LETTER N WITH CARONLATIN SMALL LETTER N WITH CARONLATIN SMALL LETTER N" +
	" PRECEDED BY APOSTROPHELATIN CAPITAL LETTER ENGLATIN SMALL LETTER ENGLAT" +
	"IN CAPITAL LETTER O WITH MACRONLATIN SMALL LETTER O WITH MACRONLATIN CAP" +
	"ITAL LETTER O WITH BREVELATIN SMALL LETTER O WITH BREVELATIN CAPITAL LET" +
	"TER O WITH DOUBLE ACUTELATIN SMALL LETTER O WITH DOUBLE ACUTELATIN CAPIT" +
	"AL LIGATURE OELATIN SMALL LIGATURE OELATIN CAPITAL LETTER R WITH ACUTELA" +
	"TIN SMALL LETTER R WITH ACUTELATIN CAPITAL LETTER R WITH CEDILLALATIN SM" +
	"ALL LETTER R WITH CEDILLALATIN CAPITAL LETTER R WITH CARONLATIN SMALL LE" +
	"TTER R WITH CARONLATIN CAPITAL LETTER S WITH ACUTELATIN SMALL LETTER S W" +
	"ITH ACUTELATIN CAPITAL LETTER S WITH CIRCUMFLEXLATIN SMALL LETTER S WITH" +
	" CIRCUMFLEXLATIN CAPITAL LETTER S WITH CEDILLALATIN SMALL LETTER S WITH " +
	"CEDILLALATIN CAPITAL LETTER S WITH CARONLATIN SMALL LETTER S WITH CARONL" +
	"ATIN CAPITAL LETTER T WITH CEDILLALATIN SMALL LETTER T WITH CEDILLALATIN" +
	" CAPITAL LETTER T WITH CARONLATIN SMALL LETTER T WITH CARONLATIN CAPITAL" +
	" LETTER T WITH STROKELATIN SMALL LETTER T WITH STROKELATIN CAPITAL LETTE" +
	"R U WITH TILDELATIN SMALL LETTER U WITH TILDELATIN CAPITAL LETTER U WITH" +
	" MACRONLATIN SMALL LETTER U WITH MACRONLATIN CAPITAL LETTER U WITH BREVE" +
	"LATIN SMALL LETTER U WITH BREVELATIN CAPITAL LETTER U WITH RING ABOVELAT" +
	"IN SMALL LETTER U WITH RING ABOVELATIN CAPITAL LETTER U WITH DOUBLE ACUT" +
	"ELATIN SMALL LETTER U WITH DOUBLE ACUTELATIN CAPITAL LETTER U WITH OGONE" +
	"KLATIN SMALL LETTER U WITH OGONEKLATIN CAPITAL LETTER W WITH CIRCUMFLEXL" +
	"ATIN SMALL LETTER W WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH CIRCUMFLE" +
	"XLATIN SMALL LETTER Y WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH DIAERES" +
	"ISLATIN CAPITAL LETTER Z WITH ACUTELATIN SMALL LETTER Z WITH ACUTELATIN " +
	"CAPITAL LETTER Z WITH DOT ABOVELATIN SMALL LETTER Z WITH DOT ABOVELATIN " +
	"CAPITAL LETTER Z WITH CARONLATIN SMALL LETTER Z WITH CARONLATIN SMALL LE" +
	"TTER LONG SLATIN SMALL LETTER B WITH STROKELATIN CAPITAL LETTER B WITH H" +
	"OOKLATIN CAPITAL LETTER B WITH TOPBARLATIN SMALL LETTER B WITH TOPBARLAT" +
	"IN CAPITAL LETTER TONE SIXLATIN SMALL LETTER TONE SIXLATIN CAPITAL LETTE" +
	"R OPEN OLATIN CAPITAL LETTER C WITH HOOKLATIN SMALL LETTER C WITH HOOKLA" +
	"TIN CAPITAL LETTER AFRICAN DLATIN CAPITAL LETTER D WITH HOOKLATIN CAPITA" +
	"L LETTER D WITH TOPBARLATIN SMALL LETTER D WITH TOPBARLATIN SMALL LETTER" +
	" TURNED DELTALATIN CAPITAL LETTER REVERSED ELATIN CAPITAL LETTER SCHWALA" +
	"TIN CAPITAL LETTER OPEN ELATIN CAPITAL LETTER F WITH HOOKLATIN SMALL LET" +
	"TER F WITH HOOKLATIN CAPITAL LETTER G WITH HOOKLATIN CAPITAL LETTER GAMM" +
	"ALATIN SMALL LETTER HVLATIN CAPITAL LETTER IOTALATIN CAPITAL LETTER I WI") + ("" +
	"TH STROKELATIN CAPITAL LETTER K WITH HOOKLATIN SMALL LETTER K WITH HOOKL" +
	"ATIN SMALL LETTER L WITH BARLATIN SMALL LETTER LAMBDA WITH STROKELATIN C" +
	"APITAL LETTER TURNED MLATIN CAPITAL LETTER N WITH LEFT HOOKLATIN SMALL L" +
	"ETTER N WITH LONG RIGHT LEGLATIN CAPITAL LETTER O WITH MIDDLE TILDELATIN" +
	" CAPITAL LETTER O WITH HORNLATIN SMALL LETTER O WITH HORNLATIN CAPITAL L" +
	"ETTER OILATIN SMALL LETTER OILATIN CAPITAL LETTER P WITH HOOKLATIN SMALL" +
	" LETTER P WITH HOOKLATIN LETTER YRLATIN CAPITAL LETTER TONE TWOLATIN SMA" +
	"LL LETTER TONE TWOLATIN CAPITAL LETTER ESHLATIN LETTER REVERSED ESH LOOP" +
	"LATIN SMALL LETTER T WITH PALATAL HOOKLATIN CAPITAL LETTER T WITH HOOKLA" +
	"TIN SMALL LETTER T WITH HOOKLATIN CAPITAL LETTER T WITH RETROFLEX HOOKLA" +
	"TIN CAPITAL LETTER U WITH HORNLATIN SMALL LETTER U WITH HORNLATIN CAPITA" +
	"L LETTER UPSILONLATIN CAPITAL LETTER V WITH HOOKLATIN CAPITAL LETTER Y W" +
	"ITH HOOKLATIN SMALL LETTER Y WITH HOOKLATIN CAPITAL LETTER Z WITH STROKE" +
	"LATIN SMALL LETTER Z WITH STROKELATIN CAPITAL LETTER EZHLATIN CAPITAL LE" +
	"TTER EZH REVERSEDLATIN SMALL LETTER EZH REVERSEDLATIN SMALL LETTER EZH W" +
	"ITH TAILLATIN LETTER TWO WITH STROKELATIN CAPITAL LETTER TONE FIVELATIN " +
	"SMALL LETTER TONE FIVELATIN LETTER INVERTED GLOTTAL STOP WITH STROKELATI" +
	"N LETTER WYNNLATIN LETTER DENTAL CLICKLATIN LETTER LATERAL CLICKLATIN LE" +
	"TTER ALVEOLAR CLICKLATIN LETTER RETROFLEX CLICKLATIN CAPITAL LETTER DZ W" +
	"ITH CARONLATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARONLATIN SMAL" +
	"L LETTER DZ WITH CARONLATIN CAPITAL LETTER LJLATIN CAPITAL LETTER L WITH" +
	" SMALL LETTER JLATIN SMALL LETTER LJLATIN CAPITAL LETTER NJLATIN CAPITAL" +
	" LETTER N WITH SMALL LETTER JLATIN SMALL LETTER NJLATIN CAPITAL LETTER A" +
	" WITH CARONLATIN SMALL LETTER A WITH CARONLATIN CAPITAL LETTER I WITH CA" +
	"RONLATIN SMALL LETTER I WITH CARONLATIN CAPITAL LETTER O WITH CARONLATIN" +
	" SMALL LETTER O WITH CARONLATIN CAPITAL LETTER U WITH CARONLATIN SMALL L" +
	"ETTER U WITH CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND MACRONLATIN " +
	"SMALL LETTER U WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER U WITH DIAE" +
	"RESIS AND ACUTELATIN SMALL LETTER U WITH DIAERESIS AND ACUTELATIN CAPITA" +
	"L LETTER U WITH DIAERESIS AND CARONLATIN SMALL LETTER U WITH DIAERESIS A" +
	"ND CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVELATIN SMALL LETTE" +
	"R U WITH DIAERESIS AND GRAVELATIN SMALL LETTER TURNED ELATIN CAPITAL LET" +
	"TER A WITH DIAERESIS AND MACRONLATIN SMALL LETTER A WITH DIAERESIS AND M" +
	"ACRONLATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRONLATIN SMALL LETTER " +
	"A WITH DOT ABOVE AND MACRONLATIN CAPITAL LETTER AE WITH MACRONLATIN SMAL" +
	"L LETTER AE WITH MACRONLATIN CAPITAL LETTER G WITH STROKELATIN SMALL LET" +
	"TER G WITH STROKELATIN CAPITAL LETTER G WITH CARONLATIN SMALL LETTER G W" +
	"ITH CARONLATIN CAPITAL LETTER K WITH CARONLATIN SMALL LETTER K WITH CARO" +
	"NLATIN CAPITAL LETTER O WITH OGONEKLATIN SMALL LETTER O WITH OGONEKLATIN" +
	" CAPITAL LETTER O WITH OGONEK AND MACRONLATIN SMALL LETTER O WITH OGONEK" +
	" AND MACRONLATIN CAPITAL LETTER EZH WITH CARONLATIN SMALL LETTER EZH WIT" +
	"H CARONLATIN SMALL LETTER J WITH CARONLATIN CAPITAL LETTER DZLATIN CAPIT" +
	"AL LETTER D WITH SMALL LETTER ZLATIN SMALL LETTER DZLATIN CAPITAL LETTER" +
	" G WITH ACUTELATIN SMALL LETTER G WITH ACUTELATIN CAPITAL LETTER HWAIRLA" +
	"TIN CAPITAL LETTER WYNNLATIN CAPITAL LETTER N WITH GRAVELATIN SMALL LETT" +
	"ER N WITH GRAVELATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTELATIN SMA" +
	"LL LETTER A WITH RING ABOVE AND ACUTELATIN CAPITAL LETTER AE WITH ACUTEL" +
	"ATIN SMALL LETTER AE WITH ACUTELATIN CAPITAL LETTER O WITH STROKE AND AC" +
	"UTELATIN SMALL LETTER O WITH STROKE AND ACUTELATIN CAPITAL LETTER A WITH" +
	" DOUBLE GRAVELATIN SMALL LETTER A WITH DOUBLE GRAVELATIN CAPITAL LETTER " +
	"A WITH INVERTED BREVELATIN SMALL LETTER A WITH INVERTED BREVELATIN CAPIT" +
	"AL LETTER E WITH DOUBLE GRAVELATIN SMALL LETTER E WITH DOUBLE GRAVELATIN" +
	" CAPITAL LETTER E WITH INVERTED BREVELATIN SMALL LETTER E WITH INVERTED " +
	"BREVELATIN CAPITAL LETTER I WITH DOUBLE GRAVELATIN SMALL LETTER I WITH D" +
	"OUBLE GRAVELATIN CAPITAL LETTER I WITH INVERTED BREVELATIN SMALL LETTER " +
	"I WITH INVERTED BREVELATIN CAPITAL LETTER O WITH DOUBLE GRAVELATIN SMALL" +
	" LETTER O WITH DOUBLE GRAVELATIN CAPITAL LETTER O WITH INVERTED BREVELAT" +
	"IN SMALL LETTER O WITH INVERTED BREVELATIN CAPITAL LETTER R WITH DOUBLE " +
	"GRAVELATIN SMALL LETTER R WITH DOUBLE GRAVELATIN CAPITAL LETTER R WITH I" +
	"NVERTED BREVELATIN SMALL LETTER R WITH INVERTED BREVELATIN CAPITAL LETTE" +
	"R U WITH DOUBLE GRAVELATIN SMALL LETTER U WITH DOUBLE GRAVELATIN CAPITAL" +
	" LETTER U WITH INVERTED BREVELATIN SMALL LETTER U WITH INVERTED BREVELAT" +
	"IN CAPITAL LETTER S WITH COMMA BELOWLATIN SMALL LETTER S WITH COMMA BELO" +
	"WLATIN CAPITAL LETTER T WITH COMMA BELOWLATIN SMALL LETTER T WITH COMMA ") + ("" +
	"BELOWLATIN CAPITAL LETTER YOGHLATIN SMALL LETTER YOGHLATIN CAPITAL LETTE" +
	"R H WITH CARONLATIN SMALL LETTER H WITH CARONLATIN CAPITAL LETTER N WITH" +
	" LONG RIGHT LEGLATIN SMALL LETTER D WITH CURLLATIN CAPITAL LETTER OULATI" +
	"N SMALL LETTER OULATIN CAPITAL LETTER Z WITH HOOKLATIN SMALL LETTER Z WI" +
	"TH HOOKLATIN CAPITAL LETTER A WITH DOT ABOVELATIN SMALL LETTER A WITH DO" +
	"T ABOVELATIN CAPITAL LETTER E WITH CEDILLALATIN SMALL LETTER E WITH CEDI" +
	"LLALATIN CAPITAL LETTER O WITH DIAERESIS AND MACRONLATIN SMALL LETTER O " +
	"WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER O WITH TILDE AND MACRONLAT" +
	"IN SMALL LETTER O WITH TILDE AND MACRONLATIN CAPITAL LETTER O WITH DOT A" +
	"BOVELATIN SMALL LETTER O WITH DOT ABOVELATIN CAPITAL LETTER O WITH DOT A" +
	"BOVE AND MACRONLATIN SMALL LETTER O WITH DOT ABOVE AND MACRONLATIN CAPIT" +
	"AL LETTER Y WITH MACRONLATIN SMALL LETTER Y WITH MACRONLATIN SMALL LETTE" +
	"R L WITH CURLLATIN SMALL LETTER N WITH CURLLATIN SMALL LETTER T WITH CUR" +
	"LLATIN SMALL LETTER DOTLESS JLATIN SMALL LETTER DB DIGRAPHLATIN SMALL LE" +
	"TTER QP DIGRAPHLATIN CAPITAL LETTER A WITH STROKELATIN CAPITAL LETTER C " +
	"WITH STROKELATIN SMALL LETTER C WITH STROKELATIN CAPITAL LETTER L WITH B" +
	"ARLATIN CAPITAL LETTER T WITH DIAGONAL STROKELATIN SMALL LETTER S WITH S" +
	"WASH TAILLATIN SMALL LETTER Z WITH SWASH TAILLATIN CAPITAL LETTER GLOTTA" +
	"L STOPLATIN SMALL LETTER GLOTTAL STOPLATIN CAPITAL LETTER B WITH STROKEL" +
	"ATIN CAPITAL LETTER U BARLATIN CAPITAL LETTER TURNED VLATIN CAPITAL LETT" +
	"ER E WITH STROKELATIN SMALL LETTER E WITH STROKELATIN CAPITAL LETTER J W" +
	"ITH STROKELATIN SMALL LETTER J WITH STROKELATIN CAPITAL LETTER SMALL Q W" +
	"ITH HOOK TAILLATIN SMALL LETTER Q WITH HOOK TAILLATIN CAPITAL LETTER R W" +
	"ITH STROKELATIN SMALL LETTER R WITH STROKELATIN CAPITAL LETTER Y WITH ST" +
	"ROKELATIN SMALL LETTER Y WITH STROKELATIN SMALL LETTER TURNED ALATIN SMA" +
	"LL LETTER ALPHALATIN SMALL LETTER TURNED ALPHALATIN SMALL LETTER B WITH " +
	"HOOKLATIN SMALL LETTER OPEN OLATIN SMALL LETTER C WITH CURLLATIN SMALL L" +
	"ETTER D WITH TAILLATIN SMALL LETTER D WITH HOOKLATIN SMALL LETTER REVERS" +
	"ED ELATIN SMALL LETTER SCHWALATIN SMALL LETTER SCHWA WITH HOOKLATIN SMAL" +
	"L LETTER OPEN ELATIN SMALL LETTER REVERSED OPEN ELATIN SMALL LETTER REVE" +
	"RSED OPEN E WITH HOOKLATIN SMALL LETTER CLOSED REVERSED OPEN ELATIN SMAL" +
	"L LETTER DOTLESS J WITH STROKELATIN SMALL LETTER G WITH HOOKLATIN SMALL " +
	"LETTER SCRIPT GLATIN LETTER SMALL CAPITAL GLATIN SMALL LETTER GAMMALATIN" +
	" SMALL LETTER RAMS HORNLATIN SMALL LETTER TURNED HLATIN SMALL LETTER H W" +
	"ITH HOOKLATIN SMALL LETTER HENG WITH HOOKLATIN SMALL LETTER I WITH STROK" +
	"ELATIN SMALL LETTER IOTALATIN LETTER SMALL CAPITAL ILATIN SMALL LETTER L" +
	" WITH MIDDLE TILDELATIN SMALL LETTER L WITH BELTLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER LEZHLATIN SMALL LETTER TURNED MLATIN " +
	"SMALL LETTER TURNED M WITH LONG LEGLATIN SMALL LETTER M WITH HOOKLATIN S" +
	"MALL LETTER N WITH LEFT HOOKLATIN SMALL LETTER N WITH RETROFLEX HOOKLATI" +
	"N LETTER SMALL CAPITAL NLATIN SMALL LETTER BARRED OLATIN LETTER SMALL CA" +
	"PITAL OELATIN SMALL LETTER CLOSED OMEGALATIN SMALL LETTER PHILATIN SMALL" +
	" LETTER TURNED RLATIN SMALL LETTER TURNED R WITH LONG LEGLATIN SMALL LET" +
	"TER TURNED R WITH HOOKLATIN SMALL LETTER R WITH LONG LEGLATIN SMALL LETT" +
	"ER R WITH TAILLATIN SMALL LETTER R WITH FISHHOOKLATIN SMALL LETTER REVER" +
	"SED R WITH FISHHOOKLATIN LETTER SMALL CAPITAL RLATIN LETTER SMALL CAPITA" +
	"L INVERTED RLATIN SMALL LETTER S WITH HOOKLATIN SMALL LETTER ESHLATIN SM" +
	"ALL LETTER DOTLESS J WITH STROKE AND HOOKLATIN SMALL LETTER SQUAT REVERS" +
	"ED ESHLATIN SMALL LETTER ESH WITH CURLLATIN SMALL LETTER TURNED TLATIN S" +
	"MALL LETTER T WITH RETROFLEX HOOKLATIN SMALL LETTER U BARLATIN SMALL LET" +
	"TER UPSILONLATIN SMALL LETTER V WITH HOOKLATIN SMALL LETTER TURNED VLATI" +
	"N SMALL LETTER TURNED WLATIN SMALL LETTER TURNED YLATIN LETTER SMALL CAP" +
	"ITAL YLATIN SMALL LETTER Z WITH RETROFLEX HOOKLATIN SMALL LETTER Z WITH " +
	"CURLLATIN SMALL LETTER EZHLATIN SMALL LETTER EZH WITH CURLLATIN LETTER G" +
	"LOTTAL STOPLATIN LETTER PHARYNGEAL VOICED FRICATIVELATIN LETTER INVERTED" +
	" GLOTTAL STOPLATIN LETTER STRETCHED CLATIN LETTER BILABIAL CLICKLATIN LE" +
	"TTER SMALL CAPITAL BLATIN SMALL LETTER CLOSED OPEN ELATIN LETTER SMALL C" +
	"APITAL G WITH HOOKLATIN LETTER SMALL CAPITAL HLATIN SMALL LETTER J WITH " +
	"CROSSED-TAILLATIN SMALL LETTER TURNED KLATIN LETTER SMALL CAPITAL LLATIN" +
	" SMALL LETTER Q WITH HOOKLATIN LETTER GLOTTAL STOP WITH STROKELATIN LETT" +
	"ER REVERSED GLOTTAL STOP WITH STROKELATIN SMALL LETTER DZ DIGRAPHLATIN S" +
	"MALL LETTER DEZH DIGRAPHLATIN SMALL LETTER DZ DIGRAPH WITH CURLLATIN SMA" +
	"LL LETTER TS DIGRAPHLATIN SMALL LETTER TESH DIGRAPHLATIN SMALL LETTER TC" +
	" DIGRAPH WITH CURLLATIN SMALL LETTER FENG DIGRAPHLATIN SMALL LETTER LS D") + ("" +
	"IGRAPHLATIN SMALL LETTER LZ DIGRAPHLATIN LETTER BILABIAL PERCUSSIVELATIN" +
	" LETTER BIDENTAL PERCUSSIVELATIN SMALL LETTER TURNED H WITH FISHHOOKLATI" +
	"N SMALL LETTER TURNED H WITH FISHHOOK AND TAILMODIFIER LETTER SMALL HMOD" +
	"IFIER LETTER SMALL H WITH HOOKMODIFIER LETTER SMALL JMODIFIER LETTER SMA" +
	"LL RMODIFIER LETTER SMALL TURNED RMODIFIER LETTER SMALL TURNED R WITH HO" +
	"OKMODIFIER LETTER SMALL CAPITAL INVERTED RMODIFIER LETTER SMALL WMODIFIE" +
	"R LETTER SMALL YMODIFIER LETTER PRIMEMODIFIER LETTER DOUBLE PRIMEMODIFIE" +
	"R LETTER TURNED COMMAMODIFIER LETTER APOSTROPHEMODIFIER LETTER REVERSED " +
	"COMMAMODIFIER LETTER RIGHT HALF RINGMODIFIER LETTER LEFT HALF RINGMODIFI" +
	"ER LETTER GLOTTAL STOPMODIFIER LETTER REVERSED GLOTTAL STOPMODIFIER LETT" +
	"ER LEFT ARROWHEADMODIFIER LETTER RIGHT ARROWHEADMODIFIER LETTER UP ARROW" +
	"HEADMODIFIER LETTER DOWN ARROWHEADMODIFIER LETTER CIRCUMFLEX ACCENTCARON" +
	"MODIFIER LETTER VERTICAL LINEMODIFIER LETTER MACRONMODIFIER LETTER ACUTE" +
	" ACCENTMODIFIER LETTER GRAVE ACCENTMODIFIER LETTER LOW VERTICAL LINEMODI" +
	"FIER LETTER LOW MACRONMODIFIER LETTER LOW GRAVE ACCENTMODIFIER LETTER LO" +
	"W ACUTE ACCENTMODIFIER LETTER TRIANGULAR COLONMODIFIER LETTER HALF TRIAN" +
	"GULAR COLONMODIFIER LETTER CENTRED RIGHT HALF RINGMODIFIER LETTER CENTRE" +
	"D LEFT HALF RINGMODIFIER LETTER UP TACKMODIFIER LETTER DOWN TACKMODIFIER" +
	" LETTER PLUS SIGNMODIFIER LETTER MINUS SIGNBREVEDOT ABOVERING ABOVEOGONE" +
	"KSMALL TILDEDOUBLE ACUTE ACCENTMODIFIER LETTER RHOTIC HOOKMODIFIER LETTE" +
	"R CROSS ACCENTMODIFIER LETTER SMALL GAMMAMODIFIER LETTER SMALL LMODIFIER" +
	" LETTER SMALL SMODIFIER LETTER SMALL XMODIFIER LETTER SMALL REVERSED GLO" +
	"TTAL STOPMODIFIER LETTER EXTRA-HIGH TONE BARMODIFIER LETTER HIGH TONE BA" +
	"RMODIFIER LETTER MID TONE BARMODIFIER LETTER LOW TONE BARMODIFIER LETTER" +
	" EXTRA-LOW TONE BARMODIFIER LETTER YIN DEPARTING TONE MARKMODIFIER LETTE" +
	"R YANG DEPARTING TONE MARKMODIFIER LETTER VOICINGMODIFIER LETTER UNASPIR" +
	"ATEDMODIFIER LETTER DOUBLE APOSTROPHEMODIFIER LETTER LOW DOWN ARROWHEADM" +
	"ODIFIER LETTER LOW UP ARROWHEADMODIFIER LETTER LOW LEFT ARROWHEADMODIFIE" +
	"R LETTER LOW RIGHT ARROWHEADMODIFIER LETTER LOW RINGMODIFIER LETTER MIDD" +
	"LE GRAVE ACCENTMODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENTMODIFIER LETTER" +
	" MIDDLE DOUBLE ACUTE ACCENTMODIFIER LETTER LOW TILDEMODIFIER LETTER RAIS" +
	"ED COLONMODIFIER LETTER BEGIN HIGH TONEMODIFIER LETTER END HIGH TONEMODI" +
	"FIER LETTER BEGIN LOW TONEMODIFIER LETTER END LOW TONEMODIFIER LETTER SH" +
	"ELFMODIFIER LETTER OPEN SHELFMODIFIER LETTER LOW LEFT ARROWCOMBINING GRA" +
	"VE ACCENTCOMBINING ACUTE ACCENTCOMBINING CIRCUMFLEX ACCENTCOMBINING TILD" +
	"ECOMBINING MACRONCOMBINING OVERLINECOMBINING BREVECOMBINING DOT ABOVECOM" +
	"BINING DIAERESISCOMBINING HOOK ABOVECOMBINING RING ABOVECOMBINING DOUBLE" +
	" ACUTE ACCENTCOMBINING CARONCOMBINING VERTICAL LINE ABOVECOMBINING DOUBL" +
	"E VERTICAL LINE ABOVECOMBINING DOUBLE GRAVE ACCENTCOMBINING CANDRABINDUC" +
	"OMBINING INVERTED BREVECOMBINING TURNED COMMA ABOVECOMBINING COMMA ABOVE" +
	"COMBINING REVERSED COMMA ABOVECOMBINING COMMA ABOVE RIGHTCOMBINING GRAVE" +
	" ACCENT BELOWCOMBINING ACUTE ACCENT BELOWCOMBINING LEFT TACK BELOWCOMBIN" +
	"ING RIGHT TACK BELOWCOMBINING LEFT ANGLE ABOVECOMBINING HORNCOMBINING LE" +
	"FT HALF RING BELOWCOMBINING UP TACK BELOWCOMBINING DOWN TACK BELOWCOMBIN" +
	"ING PLUS SIGN BELOWCOMBINING MINUS SIGN BELOWCOMBINING PALATALIZED HOOK " +
	"BELOWCOMBINING RETROFLEX HOOK BELOWCOMBINING DOT BELOWCOMBINING DIAERESI" +
	"S BELOWCOMBINING RING BELOWCOMBINING COMMA BELOWCOMBINING CEDILLACOMBINI" +
	"NG OGONEKCOMBINING VERTICAL LINE BELOWCOMBINING BRIDGE BELOWCOMBINING IN" +
	"VERTED DOUBLE ARCH BELOWCOMBINING CARON BELOWCOMBINING CIRCUMFLEX ACCENT" +
	" BELOWCOMBINING BREVE BELOWCOMBINING INVERTED BREVE BELOWCOMBINING TILDE" +
	" BELOWCOMBINING MACRON BELOWCOMBINING LOW LINECOMBINING DOUBLE LOW LINEC" +
	"OMBINING TILDE OVERLAYCOMBINING SHORT STROKE OVERLAYCOMBINING LONG STROK" +
	"E OVERLAYCOMBINING SHORT SOLIDUS OVERLAYCOMBINING LONG SOLIDUS OVERLAYCO" +
	"MBINING RIGHT HALF RING BELOWCOMBINING INVERTED BRIDGE BELOWCOMBINING SQ" +
	"UARE BELOWCOMBINING SEAGULL BELOWCOMBINING X ABOVECOMBINING VERTICAL TIL" +
	"DECOMBINING DOUBLE OVERLINECOMBINING GRAVE TONE MARKCOMBINING ACUTE TONE" +
	" MARKCOMBINING GREEK PERISPOMENICOMBINING GREEK KORONISCOMBINING GREEK D" +
	"IALYTIKA TONOSCOMBINING GREEK YPOGEGRAMMENICOMBINING BRIDGE ABOVECOMBINI" +
	"NG EQUALS SIGN BELOWCOMBINING DOUBLE VERTICAL LINE BELOWCOMBINING LEFT A" +
	"NGLE BELOWCOMBINING NOT TILDE ABOVECOMBINING HOMOTHETIC ABOVECOMBINING A" +
	"LMOST EQUAL TO ABOVECOMBINING LEFT RIGHT ARROW BELOWCOMBINING UPWARDS AR" +
	"ROW BELOWCOMBINING GRAPHEME JOINERCOMBINING RIGHT ARROWHEAD ABOVECOMBINI" +
	"NG LEFT HALF RING ABOVECOMBINING FERMATACOMBINING X BELOWCOMBINING LEFT " +
	"ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD ") + ("" +
	"AND UP ARROWHEAD BELOWCOMBINING RIGHT HALF RING ABOVECOMBINING DOT ABOVE" +
	" RIGHTCOMBINING ASTERISK BELOWCOMBINING DOUBLE RING BELOWCOMBINING ZIGZA" +
	"G ABOVECOMBINING DOUBLE BREVE BELOWCOMBINING DOUBLE BREVECOMBINING DOUBL" +
	"E MACRONCOMBINING DOUBLE MACRON BELOWCOMBINING DOUBLE TILDECOMBINING DOU" +
	"BLE INVERTED BREVECOMBINING DOUBLE RIGHTWARDS ARROW BELOWCOMBINING LATIN" +
	" SMALL LETTER ACOMBINING LATIN SMALL LETTER ECOMBINING LATIN SMALL LETTE" +
	"R ICOMBINING LATIN SMALL LETTER OCOMBINING LATIN SMALL LETTER UCOMBINING" +
	" LATIN SMALL LETTER CCOMBINING LATIN SMALL LETTER DCOMBINING LATIN SMALL" +
	" LETTER HCOMBINING LATIN SMALL LETTER MCOMBINING LATIN SMALL LETTER RCOM" +
	"BINING LATIN SMALL LETTER TCOMBINING LATIN SMALL LETTER VCOMBINING LATIN" +
	" SMALL LETTER XGREEK CAPITAL LETTER HETAGREEK SMALL LETTER HETAGREEK CAP" +
	"ITAL LETTER ARCHAIC SAMPIGREEK SMALL LETTER ARCHAIC SAMPIGREEK NUMERAL S" +
	"IGNGREEK LOWER NUMERAL SIGNGREEK CAPITAL LETTER PAMPHYLIAN DIGAMMAGREEK " +
	"SMALL LETTER PAMPHYLIAN DIGAMMAGREEK YPOGEGRAMMENIGREEK SMALL REVERSED L" +
	"UNATE SIGMA SYMBOLGREEK SMALL DOTTED LUNATE SIGMA SYMBOLGREEK SMALL REVE" +
	"RSED DOTTED LUNATE SIGMA SYMBOLGREEK QUESTION MARKGREEK CAPITAL LETTER Y" +
	"OTGREEK TONOSGREEK DIALYTIKA TONOSGREEK CAPITAL LETTER ALPHA WITH TONOSG" +
	"REEK ANO TELEIAGREEK CAPITAL LETTER EPSILON WITH TONOSGREEK CAPITAL LETT" +
	"ER ETA WITH TONOSGREEK CAPITAL LETTER IOTA WITH TONOSGREEK CAPITAL LETTE" +
	"R OMICRON WITH TONOSGREEK CAPITAL LETTER UPSILON WITH TONOSGREEK CAPITAL" +
	" LETTER OMEGA WITH TONOSGREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" +
	"GREEK CAPITAL LETTER ALPHAGREEK CAPITAL LETTER BETAGREEK CAPITAL LETTER " +
	"GAMMAGREEK CAPITAL LETTER DELTAGREEK CAPITAL LETTER EPSILONGREEK CAPITAL" +
	" LETTER ZETAGREEK CAPITAL LETTER ETAGREEK CAPITAL LETTER THETAGREEK CAPI" +
	"TAL LETTER IOTAGREEK CAPITAL LETTER KAPPAGREEK CAPITAL LETTER LAMDAGREEK" +
	" CAPITAL LETTER MUGREEK CAPITAL LETTER NUGREEK CAPITAL LETTER XIGREEK CA" +
	"PITAL LETTER OMICRONGREEK CAPITAL LETTER PIGREEK CAPITAL LETTER RHOGREEK" +
	" CAPITAL LETTER SIGMAGREEK CAPITAL LETTER TAUGREEK CAPITAL LETTER UPSILO" +
	"NGREEK CAPITAL LETTER PHIGREEK CAPITAL LETTER CHIGREEK CAPITAL LETTER PS" +
	"IGREEK CAPITAL LETTER OMEGAGREEK CAPITAL LETTER IOTA WITH DIALYTIKAGREEK" +
	" CAPITAL LETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER ALPHA WITH TONO" +
	"SGREEK SMALL LETTER EPSILON WITH TONOSGREEK SMALL LETTER ETA WITH TONOSG" +
	"REEK SMALL LETTER IOTA WITH TONOSGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND TONOSGREEK SMALL LETTER ALPHAGREEK SMALL LETTER BETAGREEK SMALL L" +
	"ETTER GAMMAGREEK SMALL LETTER DELTAGREEK SMALL LETTER EPSILONGREEK SMALL" +
	" LETTER ZETAGREEK SMALL LETTER ETAGREEK SMALL LETTER THETAGREEK SMALL LE" +
	"TTER IOTAGREEK SMALL LETTER KAPPAGREEK SMALL LETTER LAMDAGREEK SMALL LET" +
	"TER MUGREEK SMALL LETTER NUGREEK SMALL LETTER XIGREEK SMALL LETTER OMICR" +
	"ONGREEK SMALL LETTER PIGREEK SMALL LETTER RHOGREEK SMALL LETTER FINAL SI" +
	"GMAGREEK SMALL LETTER SIGMAGREEK SMALL LETTER TAUGREEK SMALL LETTER UPSI" +
	"LONGREEK SMALL LETTER PHIGREEK SMALL LETTER CHIGREEK SMALL LETTER PSIGRE" +
	"EK SMALL LETTER OMEGAGREEK SMALL LETTER IOTA WITH DIALYTIKAGREEK SMALL L" +
	"ETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER OMICRON WITH TONOSGREEK S" +
	"MALL LETTER UPSILON WITH TONOSGREEK SMALL LETTER OMEGA WITH TONOSGREEK C" +
	"APITAL KAI SYMBOLGREEK BETA SYMBOLGREEK THETA SYMBOLGREEK UPSILON WITH H" +
	"OOK SYMBOLGREEK UPSILON WITH ACUTE AND HOOK SYMBOLGREEK UPSILON WITH DIA" +
	"ERESIS AND HOOK SYMBOLGREEK PHI SYMBOLGREEK PI SYMBOLGREEK KAI SYMBOLGRE" +
	"EK LETTER ARCHAIC KOPPAGREEK SMALL LETTER ARCHAIC KOPPAGREEK LETTER STIG" +
	"MAGREEK SMALL LETTER STIGMAGREEK LETTER DIGAMMAGREEK SMALL LETTER DIGAMM" +
	"AGREEK LETTER KOPPAGREEK SMALL LETTER KOPPAGREEK LETTER SAMPIGREEK SMALL" +
	" LETTER SAMPICOPTIC CAPITAL LETTER SHEICOPTIC SMALL LETTER SHEICOPTIC CA" +
	"PITAL LETTER FEICOPTIC SMALL LETTER FEICOPTIC CAPITAL LETTER KHEICOPTIC " +
	"SMALL LETTER KHEICOPTIC CAPITAL LETTER HORICOPTIC SMALL LETTER HORICOPTI" +
	"C CAPITAL LETTER GANGIACOPTIC SMALL LETTER GANGIACOPTIC CAPITAL LETTER S" +
	"HIMACOPTIC SMALL LETTER SHIMACOPTIC CAPITAL LETTER DEICOPTIC SMALL LETTE" +
	"R DEIGREEK KAPPA SYMBOLGREEK RHO SYMBOLGREEK LUNATE SIGMA SYMBOLGREEK LE" +
	"TTER YOTGREEK CAPITAL THETA SYMBOLGREEK LUNATE EPSILON SYMBOLGREEK REVER" +
	"SED LUNATE EPSILON SYMBOLGREEK CAPITAL LETTER SHOGREEK SMALL LETTER SHOG" +
	"REEK CAPITAL LUNATE SIGMA SYMBOLGREEK CAPITAL LETTER SANGREEK SMALL LETT" +
	"ER SANGREEK RHO WITH STROKE SYMBOLGREEK CAPITAL REVERSED LUNATE SIGMA SY" +
	"MBOLGREEK CAPITAL DOTTED LUNATE SIGMA SYMBOLGREEK CAPITAL REVERSED DOTTE" +
	"D LUNATE SIGMA SYMBOLCYRILLIC CAPITAL LETTER IE WITH GRAVECYRILLIC CAPIT" +
	"AL LETTER IOCYRILLIC CAPITAL LETTER DJECYRILLIC CAPITAL LETTER GJECYRILL" +
	"IC CAPITAL LETTER UKRAINIAN IECYRILLIC CAPITAL LETTER DZECYRILLIC CAPITA") + ("" +
	"L LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC CAPITAL LETTER YICYRILLIC CAPI" +
	"TAL LETTER JECYRILLIC CAPITAL LETTER LJECYRILLIC CAPITAL LETTER NJECYRIL" +
	"LIC CAPITAL LETTER TSHECYRILLIC CAPITAL LETTER KJECYRILLIC CAPITAL LETTE" +
	"R I WITH GRAVECYRILLIC CAPITAL LETTER SHORT UCYRILLIC CAPITAL LETTER DZH" +
	"ECYRILLIC CAPITAL LETTER ACYRILLIC CAPITAL LETTER BECYRILLIC CAPITAL LET" +
	"TER VECYRILLIC CAPITAL LETTER GHECYRILLIC CAPITAL LETTER DECYRILLIC CAPI" +
	"TAL LETTER IECYRILLIC CAPITAL LETTER ZHECYRILLIC CAPITAL LETTER ZECYRILL" +
	"IC CAPITAL LETTER ICYRILLIC CAPITAL LETTER SHORT ICYRILLIC CAPITAL LETTE" +
	"R KACYRILLIC CAPITAL LETTER ELCYRILLIC CAPITAL LETTER EMCYRILLIC CAPITAL" +
	" LETTER ENCYRILLIC CAPITAL LETTER OCYRILLIC CAPITAL LETTER PECYRILLIC CA" +
	"PITAL LETTER ERCYRILLIC CAPITAL LETTER ESCYRILLIC CAPITAL LETTER TECYRIL" +
	"LIC CAPITAL LETTER UCYRILLIC CAPITAL LETTER EFCYRILLIC CAPITAL LETTER HA" +
	"CYRILLIC CAPITAL LETTER TSECYRILLIC CAPITAL LETTER CHECYRILLIC CAPITAL L" +
	"ETTER SHACYRILLIC CAPITAL LETTER SHCHACYRILLIC CAPITAL LETTER HARD SIGNC" +
	"YRILLIC CAPITAL LETTER YERUCYRILLIC CAPITAL LETTER SOFT SIGNCYRILLIC CAP" +
	"ITAL LETTER ECYRILLIC CAPITAL LETTER YUCYRILLIC CAPITAL LETTER YACYRILLI" +
	"C SMALL LETTER ACYRILLIC SMALL LETTER BECYRILLIC SMALL LETTER VECYRILLIC" +
	" SMALL LETTER GHECYRILLIC SMALL LETTER DECYRILLIC SMALL LETTER IECYRILLI" +
	"C SMALL LETTER ZHECYRILLIC SMALL LETTER ZECYRILLIC SMALL LETTER ICYRILLI" +
	"C SMALL LETTER SHORT ICYRILLIC SMALL LETTER KACYRILLIC SMALL LETTER ELCY" +
	"RILLIC SMALL LETTER EMCYRILLIC SMALL LETTER ENCYRILLIC SMALL LETTER OCYR" +
	"ILLIC SMALL LETTER PECYRILLIC SMALL LETTER ERCYRILLIC SMALL LETTER ESCYR" +
	"ILLIC SMALL LETTER TECYRILLIC SMALL LETTER UCYRILLIC SMALL LETTER EFCYRI" +
	"LLIC SMALL LETTER HACYRILLIC SMALL LETTER TSECYRILLIC SMALL LETTER CHECY" +
	"RILLIC SMALL LETTER SHACYRILLIC SMALL LETTER SHCHACYRILLIC SMALL LETTER " +
	"HARD SIGNCYRILLIC SMALL LETTER YERUCYRILLIC SMALL LETTER SOFT SIGNCYRILL" +
	"IC SMALL LETTER ECYRILLIC SMALL LETTER YUCYRILLIC SMALL LETTER YACYRILLI" +
	"C SMALL LETTER IE WITH GRAVECYRILLIC SMALL LETTER IOCYRILLIC SMALL LETTE" +
	"R DJECYRILLIC SMALL LETTER GJECYRILLIC SMALL LETTER UKRAINIAN IECYRILLIC" +
	" SMALL LETTER DZECYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC " +
	"SMALL LETTER YICYRILLIC SMALL LETTER JECYRILLIC SMALL LETTER LJECYRILLIC" +
	" SMALL LETTER NJECYRILLIC SMALL LETTER TSHECYRILLIC SMALL LETTER KJECYRI" +
	"LLIC SMALL LETTER I WITH GRAVECYRILLIC SMALL LETTER SHORT UCYRILLIC SMAL" +
	"L LETTER DZHECYRILLIC CAPITAL LETTER OMEGACYRILLIC SMALL LETTER OMEGACYR" +
	"ILLIC CAPITAL LETTER YATCYRILLIC SMALL LETTER YATCYRILLIC CAPITAL LETTER" +
	" IOTIFIED ECYRILLIC SMALL LETTER IOTIFIED ECYRILLIC CAPITAL LETTER LITTL" +
	"E YUSCYRILLIC SMALL LETTER LITTLE YUSCYRILLIC CAPITAL LETTER IOTIFIED LI" +
	"TTLE YUSCYRILLIC SMALL LETTER IOTIFIED LITTLE YUSCYRILLIC CAPITAL LETTER" +
	" BIG YUSCYRILLIC SMALL LETTER BIG YUSCYRILLIC CAPITAL LETTER IOTIFIED BI" +
	"G YUSCYRILLIC SMALL LETTER IOTIFIED BIG YUSCYRILLIC CAPITAL LETTER KSICY" +
	"RILLIC SMALL LETTER KSICYRILLIC CAPITAL LETTER PSICYRILLIC SMALL LETTER " +
	"PSICYRILLIC CAPITAL LETTER FITACYRILLIC SMALL LETTER FITACYRILLIC CAPITA" +
	"L LETTER IZHITSACYRILLIC SMALL LETTER IZHITSACYRILLIC CAPITAL LETTER IZH" +
	"ITSA WITH DOUBLE GRAVE ACCENTCYRILLIC SMALL LETTER IZHITSA WITH DOUBLE G" +
	"RAVE ACCENTCYRILLIC CAPITAL LETTER UKCYRILLIC SMALL LETTER UKCYRILLIC CA" +
	"PITAL LETTER ROUND OMEGACYRILLIC SMALL LETTER ROUND OMEGACYRILLIC CAPITA" +
	"L LETTER OMEGA WITH TITLOCYRILLIC SMALL LETTER OMEGA WITH TITLOCYRILLIC " +
	"CAPITAL LETTER OTCYRILLIC SMALL LETTER OTCYRILLIC CAPITAL LETTER KOPPACY" +
	"RILLIC SMALL LETTER KOPPACYRILLIC THOUSANDS SIGNCOMBINING CYRILLIC TITLO" +
	"COMBINING CYRILLIC PALATALIZATIONCOMBINING CYRILLIC DASIA PNEUMATACOMBIN" +
	"ING CYRILLIC PSILI PNEUMATACOMBINING CYRILLIC POKRYTIECOMBINING CYRILLIC" +
	" HUNDRED THOUSANDS SIGNCOMBINING CYRILLIC MILLIONS SIGNCYRILLIC CAPITAL " +
	"LETTER SHORT I WITH TAILCYRILLIC SMALL LETTER SHORT I WITH TAILCYRILLIC " +
	"CAPITAL LETTER SEMISOFT SIGNCYRILLIC SMALL LETTER SEMISOFT SIGNCYRILLIC " +
	"CAPITAL LETTER ER WITH TICKCYRILLIC SMALL LETTER ER WITH TICKCYRILLIC CA" +
	"PITAL LETTER GHE WITH UPTURNCYRILLIC SMALL LETTER GHE WITH UPTURNCYRILLI" +
	"C CAPITAL LETTER GHE WITH STROKECYRILLIC SMALL LETTER GHE WITH STROKECYR" +
	"ILLIC CAPITAL LETTER GHE WITH MIDDLE HOOKCYRILLIC SMALL LETTER GHE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER ZHE WITH DESCENDERCYRILLIC SMALL LETT" +
	"ER ZHE WITH DESCENDERCYRILLIC CAPITAL LETTER ZE WITH DESCENDERCYRILLIC S" +
	"MALL LETTER ZE WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH DESCENDERCY" +
	"RILLIC SMALL LETTER KA WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH VER" +
	"TICAL STROKECYRILLIC SMALL LETTER KA WITH VERTICAL STROKECYRILLIC CAPITA" +
	"L LETTER KA WITH STROKECYRILLIC SMALL LETTER KA WITH STROKECYRILLIC CAPI") + ("" +
	"TAL LETTER BASHKIR KACYRILLIC SMALL LETTER BASHKIR KACYRILLIC CAPITAL LE" +
	"TTER EN WITH DESCENDERCYRILLIC SMALL LETTER EN WITH DESCENDERCYRILLIC CA" +
	"PITAL LIGATURE EN GHECYRILLIC SMALL LIGATURE EN GHECYRILLIC CAPITAL LETT" +
	"ER PE WITH MIDDLE HOOKCYRILLIC SMALL LETTER PE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER ABKHASIAN HACYRILLIC SMALL LETTER ABKHASIAN HACYRILLIC CA" +
	"PITAL LETTER ES WITH DESCENDERCYRILLIC SMALL LETTER ES WITH DESCENDERCYR" +
	"ILLIC CAPITAL LETTER TE WITH DESCENDERCYRILLIC SMALL LETTER TE WITH DESC" +
	"ENDERCYRILLIC CAPITAL LETTER STRAIGHT UCYRILLIC SMALL LETTER STRAIGHT UC" +
	"YRILLIC CAPITAL LETTER STRAIGHT U WITH STROKECYRILLIC SMALL LETTER STRAI" +
	"GHT U WITH STROKECYRILLIC CAPITAL LETTER HA WITH DESCENDERCYRILLIC SMALL" +
	" LETTER HA WITH DESCENDERCYRILLIC CAPITAL LIGATURE TE TSECYRILLIC SMALL " +
	"LIGATURE TE TSECYRILLIC CAPITAL LETTER CHE WITH DESCENDERCYRILLIC SMALL " +
	"LETTER CHE WITH DESCENDERCYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROK" +
	"ECYRILLIC SMALL LETTER CHE WITH VERTICAL STROKECYRILLIC CAPITAL LETTER S" +
	"HHACYRILLIC SMALL LETTER SHHACYRILLIC CAPITAL LETTER ABKHASIAN CHECYRILL" +
	"IC SMALL LETTER ABKHASIAN CHECYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH " +
	"DESCENDERCYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDERCYRILLIC LETT" +
	"ER PALOCHKACYRILLIC CAPITAL LETTER ZHE WITH BREVECYRILLIC SMALL LETTER Z" +
	"HE WITH BREVECYRILLIC CAPITAL LETTER KA WITH HOOKCYRILLIC SMALL LETTER K" +
	"A WITH HOOKCYRILLIC CAPITAL LETTER EL WITH TAILCYRILLIC SMALL LETTER EL " +
	"WITH TAILCYRILLIC CAPITAL LETTER EN WITH HOOKCYRILLIC SMALL LETTER EN WI" +
	"TH HOOKCYRILLIC CAPITAL LETTER EN WITH TAILCYRILLIC SMALL LETTER EN WITH" +
	" TAILCYRILLIC CAPITAL LETTER KHAKASSIAN CHECYRILLIC SMALL LETTER KHAKASS" +
	"IAN CHECYRILLIC CAPITAL LETTER EM WITH TAILCYRILLIC SMALL LETTER EM WITH" +
	" TAILCYRILLIC SMALL LETTER PALOCHKACYRILLIC CAPITAL LETTER A WITH BREVEC" +
	"YRILLIC SMALL LETTER A WITH BREVECYRILLIC CAPITAL LETTER A WITH DIAERESI" +
	"SCYRILLIC SMALL LETTER A WITH DIAERESISCYRILLIC CAPITAL LIGATURE A IECYR" +
	"ILLIC SMALL LIGATURE A IECYRILLIC CAPITAL LETTER IE WITH BREVECYRILLIC S" +
	"MALL LETTER IE WITH BREVECYRILLIC CAPITAL LETTER SCHWACYRILLIC SMALL LET" +
	"TER SCHWACYRILLIC CAPITAL LETTER SCHWA WITH DIAERESISCYRILLIC SMALL LETT" +
	"ER SCHWA WITH DIAERESISCYRILLIC CAPITAL LETTER ZHE WITH DIAERESISCYRILLI" +
	"C SMALL LETTER ZHE WITH DIAERESISCYRILLIC CAPITAL LETTER ZE WITH DIAERES" +
	"ISCYRILLIC SMALL LETTER ZE WITH DIAERESISCYRILLIC CAPITAL LETTER ABKHASI" +
	"AN DZECYRILLIC SMALL LETTER ABKHASIAN DZECYRILLIC CAPITAL LETTER I WITH " +
	"MACRONCYRILLIC SMALL LETTER I WITH MACRONCYRILLIC CAPITAL LETTER I WITH " +
	"DIAERESISCYRILLIC SMALL LETTER I WITH DIAERESISCYRILLIC CAPITAL LETTER O" +
	" WITH DIAERESISCYRILLIC SMALL LETTER O WITH DIAERESISCYRILLIC CAPITAL LE" +
	"TTER BARRED OCYRILLIC SMALL LETTER BARRED OCYRILLIC CAPITAL LETTER BARRE" +
	"D O WITH DIAERESISCYRILLIC SMALL LETTER BARRED O WITH DIAERESISCYRILLIC " +
	"CAPITAL LETTER E WITH DIAERESISCYRILLIC SMALL LETTER E WITH DIAERESISCYR" +
	"ILLIC CAPITAL LETTER U WITH MACRONCYRILLIC SMALL LETTER U WITH MACRONCYR" +
	"ILLIC CAPITAL LETTER U WITH DIAERESISCYRILLIC SMALL LETTER U WITH DIAERE" +
	"SISCYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTECYRILLIC SMALL LETTER U WI" +
	"TH DOUBLE ACUTECYRILLIC CAPITAL LETTER CHE WITH DIAERESISCYRILLIC SMALL " +
	"LETTER CHE WITH DIAERESISCYRILLIC CAPITAL LETTER GHE WITH DESCENDERCYRIL" +
	"LIC SMALL LETTER GHE WITH DESCENDERCYRILLIC CAPITAL LETTER YERU WITH DIA" +
	"ERESISCYRILLIC SMALL LETTER YERU WITH DIAERESISCYRILLIC CAPITAL LETTER G" +
	"HE WITH STROKE AND HOOKCYRILLIC SMALL LETTER GHE WITH STROKE AND HOOKCYR" +
	"ILLIC CAPITAL LETTER HA WITH HOOKCYRILLIC SMALL LETTER HA WITH HOOKCYRIL" +
	"LIC CAPITAL LETTER HA WITH STROKECYRILLIC SMALL LETTER HA WITH STROKECYR" +
	"ILLIC CAPITAL LETTER KOMI DECYRILLIC SMALL LETTER KOMI DECYRILLIC CAPITA" +
	"L LETTER KOMI DJECYRILLIC SMALL LETTER KOMI DJECYRILLIC CAPITAL LETTER K" +
	"OMI ZJECYRILLIC SMALL LETTER KOMI ZJECYRILLIC CAPITAL LETTER KOMI DZJECY" +
	"RILLIC SMALL LETTER KOMI DZJECYRILLIC CAPITAL LETTER KOMI LJECYRILLIC SM" +
	"ALL LETTER KOMI LJECYRILLIC CAPITAL LETTER KOMI NJECYRILLIC SMALL LETTER" +
	" KOMI NJECYRILLIC CAPITAL LETTER KOMI SJECYRILLIC SMALL LETTER KOMI SJEC" +
	"YRILLIC CAPITAL LETTER KOMI TJECYRILLIC SMALL LETTER KOMI TJECYRILLIC CA" +
	"PITAL LETTER REVERSED ZECYRILLIC SMALL LETTER REVERSED ZECYRILLIC CAPITA" +
	"L LETTER EL WITH HOOKCYRILLIC SMALL LETTER EL WITH HOOKCYRILLIC CAPITAL " +
	"LETTER LHACYRILLIC SMALL LETTER LHACYRILLIC CAPITAL LETTER RHACYRILLIC S" +
	"MALL LETTER RHACYRILLIC CAPITAL LETTER YAECYRILLIC SMALL LETTER YAECYRIL" +
	"LIC CAPITAL LETTER QACYRILLIC SMALL LETTER QACYRILLIC CAPITAL LETTER WEC" +
	"YRILLIC SMALL LETTER WECYRILLIC CAPITAL LETTER ALEUT KACYRILLIC SMALL LE" +
	"TTER ALEUT KACYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOKCYRILLIC SMALL L") + ("" +
	"ETTER EL WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER EN WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER PE WITH DES" +
	"CENDERCYRILLIC SMALL LETTER PE WITH DESCENDERCYRILLIC CAPITAL LETTER SHH" +
	"A WITH DESCENDERCYRILLIC SMALL LETTER SHHA WITH DESCENDERCYRILLIC CAPITA" +
	"L LETTER EN WITH LEFT HOOKCYRILLIC SMALL LETTER EN WITH LEFT HOOKCYRILLI" +
	"C CAPITAL LETTER DZZHECYRILLIC SMALL LETTER DZZHECYRILLIC CAPITAL LETTER" +
	" DCHECYRILLIC SMALL LETTER DCHECYRILLIC CAPITAL LETTER EL WITH DESCENDER" +
	"CYRILLIC SMALL LETTER EL WITH DESCENDERARMENIAN CAPITAL LETTER AYBARMENI" +
	"AN CAPITAL LETTER BENARMENIAN CAPITAL LETTER GIMARMENIAN CAPITAL LETTER " +
	"DAARMENIAN CAPITAL LETTER ECHARMENIAN CAPITAL LETTER ZAARMENIAN CAPITAL " +
	"LETTER EHARMENIAN CAPITAL LETTER ETARMENIAN CAPITAL LETTER TOARMENIAN CA" +
	"PITAL LETTER ZHEARMENIAN CAPITAL LETTER INIARMENIAN CAPITAL LETTER LIWNA" +
	"RMENIAN CAPITAL LETTER XEHARMENIAN CAPITAL LETTER CAARMENIAN CAPITAL LET" +
	"TER KENARMENIAN CAPITAL LETTER HOARMENIAN CAPITAL LETTER JAARMENIAN CAPI" +
	"TAL LETTER GHADARMENIAN CAPITAL LETTER CHEHARMENIAN CAPITAL LETTER MENAR" +
	"MENIAN CAPITAL LETTER YIARMENIAN CAPITAL LETTER NOWARMENIAN CAPITAL LETT" +
	"ER SHAARMENIAN CAPITAL LETTER VOARMENIAN CAPITAL LETTER CHAARMENIAN CAPI" +
	"TAL LETTER PEHARMENIAN CAPITAL LETTER JHEHARMENIAN CAPITAL LETTER RAARME" +
	"NIAN CAPITAL LETTER SEHARMENIAN CAPITAL LETTER VEWARMENIAN CAPITAL LETTE" +
	"R TIWNARMENIAN CAPITAL LETTER REHARMENIAN CAPITAL LETTER COARMENIAN CAPI" +
	"TAL LETTER YIWNARMENIAN CAPITAL LETTER PIWRARMENIAN CAPITAL LETTER KEHAR" +
	"MENIAN CAPITAL LETTER OHARMENIAN CAPITAL LETTER FEHARMENIAN MODIFIER LET" +
	"TER LEFT HALF RINGARMENIAN APOSTROPHEARMENIAN EMPHASIS MARKARMENIAN EXCL" +
	"AMATION MARKARMENIAN COMMAARMENIAN QUESTION MARKARMENIAN ABBREVIATION MA" +
	"RKARMENIAN SMALL LETTER TURNED AYBARMENIAN SMALL LETTER AYBARMENIAN SMAL" +
	"L LETTER BENARMENIAN SMALL LETTER GIMARMENIAN SMALL LETTER DAARMENIAN SM" +
	"ALL LETTER ECHARMENIAN SMALL LETTER ZAARMENIAN SMALL LETTER EHARMENIAN S" +
	"MALL LETTER ETARMENIAN SMALL LETTER TOARMENIAN SMALL LETTER ZHEARMENIAN " +
	"SMALL LETTER INIARMENIAN SMALL LETTER LIWNARMENIAN SMALL LETTER XEHARMEN" +
	"IAN SMALL LETTER CAARMENIAN SMALL LETTER KENARMENIAN SMALL LETTER HOARME" +
	"NIAN SMALL LETTER JAARMENIAN SMALL LETTER GHADARMENIAN SMALL LETTER CHEH" +
	"ARMENIAN SMALL LETTER MENARMENIAN SMALL LETTER YIARMENIAN SMALL LETTER N" +
	"OWARMENIAN SMALL LETTER SHAARMENIAN SMALL LETTER VOARMENIAN SMALL LETTER" +
	" CHAARMENIAN SMALL LETTER PEHARMENIAN SMALL LETTER JHEHARMENIAN SMALL LE" +
	"TTER RAARMENIAN SMALL LETTER SEHARMENIAN SMALL LETTER VEWARMENIAN SMALL " +
	"LETTER TIWNARMENIAN SMALL LETTER REHARMENIAN SMALL LETTER COARMENIAN SMA" +
	"LL LETTER YIWNARMENIAN SMALL LETTER PIWRARMENIAN SMALL LETTER KEHARMENIA" +
	"N SMALL LETTER OHARMENIAN SMALL LETTER FEHARMENIAN SMALL LIGATURE ECH YI" +
	"WNARMENIAN SMALL LETTER YI WITH STROKEARMENIAN FULL STOPARMENIAN HYPHENR" +
	"IGHT-FACING ARMENIAN ETERNITY SIGNLEFT-FACING ARMENIAN ETERNITY SIGNARME" +
	"NIAN DRAM SIGNHEBREW ACCENT ETNAHTAHEBREW ACCENT SEGOLHEBREW ACCENT SHAL" +
	"SHELETHEBREW ACCENT ZAQEF QATANHEBREW ACCENT ZAQEF GADOLHEBREW ACCENT TI" +
	"PEHAHEBREW ACCENT REVIAHEBREW ACCENT ZARQAHEBREW ACCENT PASHTAHEBREW ACC" +
	"ENT YETIVHEBREW ACCENT TEVIRHEBREW ACCENT GERESHHEBREW ACCENT GERESH MUQ" +
	"DAMHEBREW ACCENT GERSHAYIMHEBREW ACCENT QARNEY PARAHEBREW ACCENT TELISHA" +
	" GEDOLAHEBREW ACCENT PAZERHEBREW ACCENT ATNAH HAFUKHHEBREW ACCENT MUNAHH" +
	"EBREW ACCENT MAHAPAKHHEBREW ACCENT MERKHAHEBREW ACCENT MERKHA KEFULAHEBR" +
	"EW ACCENT DARGAHEBREW ACCENT QADMAHEBREW ACCENT TELISHA QETANAHEBREW ACC" +
	"ENT YERAH BEN YOMOHEBREW ACCENT OLEHEBREW ACCENT ILUYHEBREW ACCENT DEHIH" +
	"EBREW ACCENT ZINORHEBREW MARK MASORA CIRCLEHEBREW POINT SHEVAHEBREW POIN" +
	"T HATAF SEGOLHEBREW POINT HATAF PATAHHEBREW POINT HATAF QAMATSHEBREW POI" +
	"NT HIRIQHEBREW POINT TSEREHEBREW POINT SEGOLHEBREW POINT PATAHHEBREW POI" +
	"NT QAMATSHEBREW POINT HOLAMHEBREW POINT HOLAM HASER FOR VAVHEBREW POINT " +
	"QUBUTSHEBREW POINT DAGESH OR MAPIQHEBREW POINT METEGHEBREW PUNCTUATION M" +
	"AQAFHEBREW POINT RAFEHEBREW PUNCTUATION PASEQHEBREW POINT SHIN DOTHEBREW" +
	" POINT SIN DOTHEBREW PUNCTUATION SOF PASUQHEBREW MARK UPPER DOTHEBREW MA" +
	"RK LOWER DOTHEBREW PUNCTUATION NUN HAFUKHAHEBREW POINT QAMATS QATANHEBRE" +
	"W LETTER ALEFHEBREW LETTER BETHEBREW LETTER GIMELHEBREW LETTER DALETHEBR" +
	"EW LETTER HEHEBREW LETTER VAVHEBREW LETTER ZAYINHEBREW LETTER HETHEBREW " +
	"LETTER TETHEBREW LETTER YODHEBREW LETTER FINAL KAFHEBREW LETTER KAFHEBRE" +
	"W LETTER LAMEDHEBREW LETTER FINAL MEMHEBREW LETTER MEMHEBREW LETTER FINA" +
	"L NUNHEBREW LETTER NUNHEBREW LETTER SAMEKHHEBREW LETTER AYINHEBREW LETTE" +
	"R FINAL PEHEBREW LETTER PEHEBREW LETTER FINAL TSADIHEBREW LETTER TSADIHE" +
	"BREW LETTER QOFHEBREW LETTER RESHHEBREW LETTER SHINHEBREW LETTER TAVHEBR") + ("" +
	"EW YOD TRIANGLEHEBREW LIGATURE YIDDISH DOUBLE VAVHEBREW LIGATURE YIDDISH" +
	" VAV YODHEBREW LIGATURE YIDDISH DOUBLE YODHEBREW PUNCTUATION GERESHHEBRE" +
	"W PUNCTUATION GERSHAYIMARABIC NUMBER SIGNARABIC SIGN SANAHARABIC FOOTNOT" +
	"E MARKERARABIC SIGN SAFHAARABIC SIGN SAMVATARABIC NUMBER MARK ABOVEARABI" +
	"C-INDIC CUBE ROOTARABIC-INDIC FOURTH ROOTARABIC RAYARABIC-INDIC PER MILL" +
	"E SIGNARABIC-INDIC PER TEN THOUSAND SIGNAFGHANI SIGNARABIC COMMAARABIC D" +
	"ATE SEPARATORARABIC POETIC VERSE SIGNARABIC SIGN MISRAARABIC SIGN SALLAL" +
	"LAHOU ALAYHE WASSALLAMARABIC SIGN ALAYHE ASSALLAMARABIC SIGN RAHMATULLAH" +
	" ALAYHEARABIC SIGN RADI ALLAHOU ANHUARABIC SIGN TAKHALLUSARABIC SMALL HI" +
	"GH TAHARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEHARABIC SMALL HIGH" +
	" ZAINARABIC SMALL FATHAARABIC SMALL DAMMAARABIC SMALL KASRAARABIC SEMICO" +
	"LONARABIC LETTER MARKARABIC TRIPLE DOT PUNCTUATION MARKARABIC QUESTION M" +
	"ARKARABIC LETTER KASHMIRI YEHARABIC LETTER HAMZAARABIC LETTER ALEF WITH " +
	"MADDA ABOVEARABIC LETTER ALEF WITH HAMZA ABOVEARABIC LETTER WAW WITH HAM" +
	"ZA ABOVEARABIC LETTER ALEF WITH HAMZA BELOWARABIC LETTER YEH WITH HAMZA " +
	"ABOVEARABIC LETTER ALEFARABIC LETTER BEHARABIC LETTER TEH MARBUTAARABIC " +
	"LETTER TEHARABIC LETTER THEHARABIC LETTER JEEMARABIC LETTER HAHARABIC LE" +
	"TTER KHAHARABIC LETTER DALARABIC LETTER THALARABIC LETTER REHARABIC LETT" +
	"ER ZAINARABIC LETTER SEENARABIC LETTER SHEENARABIC LETTER SADARABIC LETT" +
	"ER DADARABIC LETTER TAHARABIC LETTER ZAHARABIC LETTER AINARABIC LETTER G" +
	"HAINARABIC LETTER KEHEH WITH TWO DOTS ABOVEARABIC LETTER KEHEH WITH THRE" +
	"E DOTS BELOWARABIC LETTER FARSI YEH WITH INVERTED VARABIC LETTER FARSI Y" +
	"EH WITH TWO DOTS ABOVEARABIC LETTER FARSI YEH WITH THREE DOTS ABOVEARABI" +
	"C TATWEELARABIC LETTER FEHARABIC LETTER QAFARABIC LETTER KAFARABIC LETTE" +
	"R LAMARABIC LETTER MEEMARABIC LETTER NOONARABIC LETTER HEHARABIC LETTER " +
	"WAWARABIC LETTER ALEF MAKSURAARABIC LETTER YEHARABIC FATHATANARABIC DAMM" +
	"ATANARABIC KASRATANARABIC FATHAARABIC DAMMAARABIC KASRAARABIC SHADDAARAB" +
	"IC SUKUNARABIC MADDAH ABOVEARABIC HAMZA ABOVEARABIC HAMZA BELOWARABIC SU" +
	"BSCRIPT ALEFARABIC INVERTED DAMMAARABIC MARK NOON GHUNNAARABIC ZWARAKAYA" +
	"RABIC VOWEL SIGN SMALL V ABOVEARABIC VOWEL SIGN INVERTED SMALL V ABOVEAR" +
	"ABIC VOWEL SIGN DOT BELOWARABIC REVERSED DAMMAARABIC FATHA WITH TWO DOTS" +
	"ARABIC WAVY HAMZA BELOWARABIC-INDIC DIGIT ZEROARABIC-INDIC DIGIT ONEARAB" +
	"IC-INDIC DIGIT TWOARABIC-INDIC DIGIT THREEARABIC-INDIC DIGIT FOURARABIC-" +
	"INDIC DIGIT FIVEARABIC-INDIC DIGIT SIXARABIC-INDIC DIGIT SEVENARABIC-IND" +
	"IC DIGIT EIGHTARABIC-INDIC DIGIT NINEARABIC PERCENT SIGNARABIC DECIMAL S" +
	"EPARATORARABIC THOUSANDS SEPARATORARABIC FIVE POINTED STARARABIC LETTER " +
	"DOTLESS BEHARABIC LETTER DOTLESS QAFARABIC LETTER SUPERSCRIPT ALEFARABIC" +
	" LETTER ALEF WASLAARABIC LETTER ALEF WITH WAVY HAMZA ABOVEARABIC LETTER " +
	"ALEF WITH WAVY HAMZA BELOWARABIC LETTER HIGH HAMZAARABIC LETTER HIGH HAM" +
	"ZA ALEFARABIC LETTER HIGH HAMZA WAWARABIC LETTER U WITH HAMZA ABOVEARABI" +
	"C LETTER HIGH HAMZA YEHARABIC LETTER TTEHARABIC LETTER TTEHEHARABIC LETT" +
	"ER BEEHARABIC LETTER TEH WITH RINGARABIC LETTER TEH WITH THREE DOTS ABOV" +
	"E DOWNWARDSARABIC LETTER PEHARABIC LETTER TEHEHARABIC LETTER BEHEHARABIC" +
	" LETTER HAH WITH HAMZA ABOVEARABIC LETTER HAH WITH TWO DOTS VERTICAL ABO" +
	"VEARABIC LETTER NYEHARABIC LETTER DYEHARABIC LETTER HAH WITH THREE DOTS " +
	"ABOVEARABIC LETTER TCHEHARABIC LETTER TCHEHEHARABIC LETTER DDALARABIC LE" +
	"TTER DAL WITH RINGARABIC LETTER DAL WITH DOT BELOWARABIC LETTER DAL WITH" +
	" DOT BELOW AND SMALL TAHARABIC LETTER DAHALARABIC LETTER DDAHALARABIC LE" +
	"TTER DULARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDSARABIC LETTER D" +
	"AL WITH FOUR DOTS ABOVEARABIC LETTER RREHARABIC LETTER REH WITH SMALL VA" +
	"RABIC LETTER REH WITH RINGARABIC LETTER REH WITH DOT BELOWARABIC LETTER " +
	"REH WITH SMALL V BELOWARABIC LETTER REH WITH DOT BELOW AND DOT ABOVEARAB" +
	"IC LETTER REH WITH TWO DOTS ABOVEARABIC LETTER JEHARABIC LETTER REH WITH" +
	" FOUR DOTS ABOVEARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVEARABIC LE" +
	"TTER SEEN WITH THREE DOTS BELOWARABIC LETTER SEEN WITH THREE DOTS BELOW " +
	"AND THREE DOTS ABOVEARABIC LETTER SAD WITH TWO DOTS BELOWARABIC LETTER S" +
	"AD WITH THREE DOTS ABOVEARABIC LETTER TAH WITH THREE DOTS ABOVEARABIC LE" +
	"TTER AIN WITH THREE DOTS ABOVEARABIC LETTER DOTLESS FEHARABIC LETTER FEH" +
	" WITH DOT MOVED BELOWARABIC LETTER FEH WITH DOT BELOWARABIC LETTER VEHAR" +
	"ABIC LETTER FEH WITH THREE DOTS BELOWARABIC LETTER PEHEHARABIC LETTER QA" +
	"F WITH DOT ABOVEARABIC LETTER QAF WITH THREE DOTS ABOVEARABIC LETTER KEH" +
	"EHARABIC LETTER SWASH KAFARABIC LETTER KAF WITH RINGARABIC LETTER KAF WI" +
	"TH DOT ABOVEARABIC LETTER NGARABIC LETTER KAF WITH THREE DOTS BELOWARABI" +
	"C LETTER GAFARABIC LETTER GAF WITH RINGARABIC LETTER NGOEHARABIC LETTER ") + ("" +
	"GAF WITH TWO DOTS BELOWARABIC LETTER GUEHARABIC LETTER GAF WITH THREE DO" +
	"TS ABOVEARABIC LETTER LAM WITH SMALL VARABIC LETTER LAM WITH DOT ABOVEAR" +
	"ABIC LETTER LAM WITH THREE DOTS ABOVEARABIC LETTER LAM WITH THREE DOTS B" +
	"ELOWARABIC LETTER NOON WITH DOT BELOWARABIC LETTER NOON GHUNNAARABIC LET" +
	"TER RNOONARABIC LETTER NOON WITH RINGARABIC LETTER NOON WITH THREE DOTS " +
	"ABOVEARABIC LETTER HEH DOACHASHMEEARABIC LETTER TCHEH WITH DOT ABOVEARAB" +
	"IC LETTER HEH WITH YEH ABOVEARABIC LETTER HEH GOALARABIC LETTER HEH GOAL" +
	" WITH HAMZA ABOVEARABIC LETTER TEH MARBUTA GOALARABIC LETTER WAW WITH RI" +
	"NGARABIC LETTER KIRGHIZ OEARABIC LETTER OEARABIC LETTER UARABIC LETTER Y" +
	"UARABIC LETTER KIRGHIZ YUARABIC LETTER WAW WITH TWO DOTS ABOVEARABIC LET" +
	"TER VEARABIC LETTER FARSI YEHARABIC LETTER YEH WITH TAILARABIC LETTER YE" +
	"H WITH SMALL VARABIC LETTER WAW WITH DOT ABOVEARABIC LETTER EARABIC LETT" +
	"ER YEH WITH THREE DOTS BELOWARABIC LETTER YEH BARREEARABIC LETTER YEH BA" +
	"RREE WITH HAMZA ABOVEARABIC FULL STOPARABIC LETTER AEARABIC SMALL HIGH L" +
	"IGATURE SAD WITH LAM WITH ALEF MAKSURAARABIC SMALL HIGH LIGATURE QAF WIT" +
	"H LAM WITH ALEF MAKSURAARABIC SMALL HIGH MEEM INITIAL FORMARABIC SMALL H" +
	"IGH LAM ALEFARABIC SMALL HIGH JEEMARABIC SMALL HIGH THREE DOTSARABIC SMA" +
	"LL HIGH SEENARABIC END OF AYAHARABIC START OF RUB EL HIZBARABIC SMALL HI" +
	"GH ROUNDED ZEROARABIC SMALL HIGH UPRIGHT RECTANGULAR ZEROARABIC SMALL HI" +
	"GH DOTLESS HEAD OF KHAHARABIC SMALL HIGH MEEM ISOLATED FORMARABIC SMALL " +
	"LOW SEENARABIC SMALL HIGH MADDAARABIC SMALL WAWARABIC SMALL YEHARABIC SM" +
	"ALL HIGH YEHARABIC SMALL HIGH NOONARABIC PLACE OF SAJDAHARABIC EMPTY CEN" +
	"TRE LOW STOPARABIC EMPTY CENTRE HIGH STOPARABIC ROUNDED HIGH STOP WITH F" +
	"ILLED CENTREARABIC SMALL LOW MEEMARABIC LETTER DAL WITH INVERTED VARABIC" +
	" LETTER REH WITH INVERTED VEXTENDED ARABIC-INDIC DIGIT ZEROEXTENDED ARAB" +
	"IC-INDIC DIGIT ONEEXTENDED ARABIC-INDIC DIGIT TWOEXTENDED ARABIC-INDIC D" +
	"IGIT THREEEXTENDED ARABIC-INDIC DIGIT FOUREXTENDED ARABIC-INDIC DIGIT FI" +
	"VEEXTENDED ARABIC-INDIC DIGIT SIXEXTENDED ARABIC-INDIC DIGIT SEVENEXTEND" +
	"ED ARABIC-INDIC DIGIT EIGHTEXTENDED ARABIC-INDIC DIGIT NINEARABIC LETTER" +
	" SHEEN WITH DOT BELOWARABIC LETTER DAD WITH DOT BELOWARABIC LETTER GHAIN" +
	" WITH DOT BELOWARABIC SIGN SINDHI AMPERSANDARABIC SIGN SINDHI POSTPOSITI" +
	"ON MENARABIC LETTER HEH WITH INVERTED VSYRIAC END OF PARAGRAPHSYRIAC SUP" +
	"RALINEAR FULL STOPSYRIAC SUBLINEAR FULL STOPSYRIAC SUPRALINEAR COLONSYRI" +
	"AC SUBLINEAR COLONSYRIAC HORIZONTAL COLONSYRIAC COLON SKEWED LEFTSYRIAC " +
	"COLON SKEWED RIGHTSYRIAC SUPRALINEAR COLON SKEWED LEFTSYRIAC SUBLINEAR C" +
	"OLON SKEWED RIGHTSYRIAC CONTRACTIONSYRIAC HARKLEAN OBELUSSYRIAC HARKLEAN" +
	" METOBELUSSYRIAC HARKLEAN ASTERISCUSSYRIAC ABBREVIATION MARKSYRIAC LETTE" +
	"R ALAPHSYRIAC LETTER SUPERSCRIPT ALAPHSYRIAC LETTER BETHSYRIAC LETTER GA" +
	"MALSYRIAC LETTER GAMAL GARSHUNISYRIAC LETTER DALATHSYRIAC LETTER DOTLESS" +
	" DALATH RISHSYRIAC LETTER HESYRIAC LETTER WAWSYRIAC LETTER ZAINSYRIAC LE" +
	"TTER HETHSYRIAC LETTER TETHSYRIAC LETTER TETH GARSHUNISYRIAC LETTER YUDH" +
	"SYRIAC LETTER YUDH HESYRIAC LETTER KAPHSYRIAC LETTER LAMADHSYRIAC LETTER" +
	" MIMSYRIAC LETTER NUNSYRIAC LETTER SEMKATHSYRIAC LETTER FINAL SEMKATHSYR" +
	"IAC LETTER ESYRIAC LETTER PESYRIAC LETTER REVERSED PESYRIAC LETTER SADHE" +
	"SYRIAC LETTER QAPHSYRIAC LETTER RISHSYRIAC LETTER SHINSYRIAC LETTER TAWS" +
	"YRIAC LETTER PERSIAN BHETHSYRIAC LETTER PERSIAN GHAMALSYRIAC LETTER PERS" +
	"IAN DHALATHSYRIAC PTHAHA ABOVESYRIAC PTHAHA BELOWSYRIAC PTHAHA DOTTEDSYR" +
	"IAC ZQAPHA ABOVESYRIAC ZQAPHA BELOWSYRIAC ZQAPHA DOTTEDSYRIAC RBASA ABOV" +
	"ESYRIAC RBASA BELOWSYRIAC DOTTED ZLAMA HORIZONTALSYRIAC DOTTED ZLAMA ANG" +
	"ULARSYRIAC HBASA ABOVESYRIAC HBASA BELOWSYRIAC HBASA-ESASA DOTTEDSYRIAC " +
	"ESASA ABOVESYRIAC ESASA BELOWSYRIAC RWAHASYRIAC FEMININE DOTSYRIAC QUSHS" +
	"HAYASYRIAC RUKKAKHASYRIAC TWO VERTICAL DOTS ABOVESYRIAC TWO VERTICAL DOT" +
	"S BELOWSYRIAC THREE DOTS ABOVESYRIAC THREE DOTS BELOWSYRIAC OBLIQUE LINE" +
	" ABOVESYRIAC OBLIQUE LINE BELOWSYRIAC MUSICSYRIAC BARREKHSYRIAC LETTER S" +
	"OGDIAN ZHAINSYRIAC LETTER SOGDIAN KHAPHSYRIAC LETTER SOGDIAN FEARABIC LE" +
	"TTER BEH WITH THREE DOTS HORIZONTALLY BELOWARABIC LETTER BEH WITH DOT BE" +
	"LOW AND THREE DOTS ABOVEARABIC LETTER BEH WITH THREE DOTS POINTING UPWAR" +
	"DS BELOWARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO" +
	" DOTS ABOVEARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVEARABIC LET" +
	"TER BEH WITH INVERTED SMALL V BELOWARABIC LETTER BEH WITH SMALL VARABIC " +
	"LETTER HAH WITH TWO DOTS ABOVEARABIC LETTER HAH WITH THREE DOTS POINTING" +
	" UPWARDS BELOWARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL" +
	" TAHARABIC LETTER DAL WITH INVERTED SMALL V BELOWARABIC LETTER REH WITH " +
	"STROKEARABIC LETTER SEEN WITH FOUR DOTS ABOVEARABIC LETTER AIN WITH TWO ") + ("" +
	"DOTS ABOVEARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVEARAB" +
	"IC LETTER AIN WITH TWO DOTS VERTICALLY ABOVEARABIC LETTER FEH WITH TWO D" +
	"OTS BELOWARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC " +
	"LETTER KEHEH WITH DOT ABOVEARABIC LETTER KEHEH WITH THREE DOTS ABOVEARAB" +
	"IC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER MEEM" +
	" WITH DOT ABOVEARABIC LETTER MEEM WITH DOT BELOWARABIC LETTER NOON WITH " +
	"TWO DOTS BELOWARABIC LETTER NOON WITH SMALL TAHARABIC LETTER NOON WITH S" +
	"MALL VARABIC LETTER LAM WITH BARARABIC LETTER REH WITH TWO DOTS VERTICAL" +
	"LY ABOVEARABIC LETTER REH WITH HAMZA ABOVEARABIC LETTER SEEN WITH TWO DO" +
	"TS VERTICALLY ABOVEARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOWA" +
	"RABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER " +
	"SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER REH WITH SMA" +
	"LL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER HAH WITH SMALL ARABIC LET" +
	"TER TAH ABOVEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABO" +
	"VEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC " +
	"LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER" +
	" FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER FAR" +
	"SI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOWARABIC LETTER WAW WITH" +
	" EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER WAW WITH EXTENDED AR" +
	"ABIC-INDIC DIGIT THREE ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABI" +
	"C-INDIC DIGIT TWO ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-IND" +
	"IC DIGIT THREE ABOVEARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT F" +
	"OUR BELOWARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVEA" +
	"RABIC LETTER SEEN WITH INVERTED VARABIC LETTER KAF WITH TWO DOTS ABOVETH" +
	"AANA LETTER HAATHAANA LETTER SHAVIYANITHAANA LETTER NOONUTHAANA LETTER R" +
	"AATHAANA LETTER BAATHAANA LETTER LHAVIYANITHAANA LETTER KAAFUTHAANA LETT" +
	"ER ALIFUTHAANA LETTER VAAVUTHAANA LETTER MEEMUTHAANA LETTER FAAFUTHAANA " +
	"LETTER DHAALUTHAANA LETTER THAATHAANA LETTER LAAMUTHAANA LETTER GAAFUTHA" +
	"ANA LETTER GNAVIYANITHAANA LETTER SEENUTHAANA LETTER DAVIYANITHAANA LETT" +
	"ER ZAVIYANITHAANA LETTER TAVIYANITHAANA LETTER YAATHAANA LETTER PAVIYANI" +
	"THAANA LETTER JAVIYANITHAANA LETTER CHAVIYANITHAANA LETTER TTAATHAANA LE" +
	"TTER HHAATHAANA LETTER KHAATHAANA LETTER THAALUTHAANA LETTER ZAATHAANA L" +
	"ETTER SHEENUTHAANA LETTER SAADHUTHAANA LETTER DAADHUTHAANA LETTER TOTHAA" +
	"NA LETTER ZOTHAANA LETTER AINUTHAANA LETTER GHAINUTHAANA LETTER QAAFUTHA" +
	"ANA LETTER WAAVUTHAANA ABAFILITHAANA AABAAFILITHAANA IBIFILITHAANA EEBEE" +
	"FILITHAANA UBUFILITHAANA OOBOOFILITHAANA EBEFILITHAANA EYBEYFILITHAANA O" +
	"BOFILITHAANA OABOAFILITHAANA SUKUNTHAANA LETTER NAANKO DIGIT ZERONKO DIG" +
	"IT ONENKO DIGIT TWONKO DIGIT THREENKO DIGIT FOURNKO DIGIT FIVENKO DIGIT " +
	"SIXNKO DIGIT SEVENNKO DIGIT EIGHTNKO DIGIT NINENKO LETTER ANKO LETTER EE" +
	"NKO LETTER INKO LETTER ENKO LETTER UNKO LETTER OONKO LETTER ONKO LETTER " +
	"DAGBASINNANKO LETTER NNKO LETTER BANKO LETTER PANKO LETTER TANKO LETTER " +
	"JANKO LETTER CHANKO LETTER DANKO LETTER RANKO LETTER RRANKO LETTER SANKO" +
	" LETTER GBANKO LETTER FANKO LETTER KANKO LETTER LANKO LETTER NA WOLOSONK" +
	"O LETTER MANKO LETTER NYANKO LETTER NANKO LETTER HANKO LETTER WANKO LETT" +
	"ER YANKO LETTER NYA WOLOSONKO LETTER JONA JANKO LETTER JONA CHANKO LETTE" +
	"R JONA RANKO COMBINING SHORT HIGH TONENKO COMBINING SHORT LOW TONENKO CO" +
	"MBINING SHORT RISING TONENKO COMBINING LONG DESCENDING TONENKO COMBINING" +
	" LONG HIGH TONENKO COMBINING LONG LOW TONENKO COMBINING LONG RISING TONE" +
	"NKO COMBINING NASALIZATION MARKNKO COMBINING DOUBLE DOT ABOVENKO HIGH TO" +
	"NE APOSTROPHENKO LOW TONE APOSTROPHENKO SYMBOL OO DENNENNKO SYMBOL GBAKU" +
	"RUNENNKO COMMANKO EXCLAMATION MARKNKO LAJANYALANNKO DANTAYALANNKO DOROME" +
	" SIGNNKO TAMAN SIGNSAMARITAN LETTER ALAFSAMARITAN LETTER BITSAMARITAN LE" +
	"TTER GAMANSAMARITAN LETTER DALATSAMARITAN LETTER IYSAMARITAN LETTER BAAS" +
	"AMARITAN LETTER ZENSAMARITAN LETTER ITSAMARITAN LETTER TITSAMARITAN LETT" +
	"ER YUTSAMARITAN LETTER KAAFSAMARITAN LETTER LABATSAMARITAN LETTER MIMSAM" +
	"ARITAN LETTER NUNSAMARITAN LETTER SINGAATSAMARITAN LETTER INSAMARITAN LE" +
	"TTER FISAMARITAN LETTER TSAADIYSAMARITAN LETTER QUFSAMARITAN LETTER RISH" +
	"SAMARITAN LETTER SHANSAMARITAN LETTER TAAFSAMARITAN MARK INSAMARITAN MAR" +
	"K IN-ALAFSAMARITAN MARK OCCLUSIONSAMARITAN MARK DAGESHSAMARITAN MODIFIER" +
	" LETTER EPENTHETIC YUTSAMARITAN MARK EPENTHETIC YUTSAMARITAN VOWEL SIGN " +
	"LONG ESAMARITAN VOWEL SIGN ESAMARITAN VOWEL SIGN OVERLONG AASAMARITAN VO" +
	"WEL SIGN LONG AASAMARITAN VOWEL SIGN AASAMARITAN VOWEL SIGN OVERLONG ASA" +
	"MARITAN VOWEL SIGN LONG ASAMARITAN VOWEL SIGN ASAMARITAN MODIFIER LETTER" +
	" SHORT ASAMARITAN VOWEL SIGN SHORT ASAMARITAN VOWEL SIGN LONG USAMARITAN") + ("" +
	" VOWEL SIGN USAMARITAN MODIFIER LETTER ISAMARITAN VOWEL SIGN LONG ISAMAR" +
	"ITAN VOWEL SIGN ISAMARITAN VOWEL SIGN OSAMARITAN VOWEL SIGN SUKUNSAMARIT" +
	"AN MARK NEQUDAASAMARITAN PUNCTUATION NEQUDAASAMARITAN PUNCTUATION AFSAAQ" +
	"SAMARITAN PUNCTUATION ANGEDSAMARITAN PUNCTUATION BAUSAMARITAN PUNCTUATIO" +
	"N ATMAAUSAMARITAN PUNCTUATION SHIYYAALAASAMARITAN ABBREVIATION MARKSAMAR" +
	"ITAN PUNCTUATION MELODIC QITSASAMARITAN PUNCTUATION ZIQAASAMARITAN PUNCT" +
	"UATION QITSASAMARITAN PUNCTUATION ZAEFSAMARITAN PUNCTUATION TURUSAMARITA" +
	"N PUNCTUATION ARKAANUSAMARITAN PUNCTUATION SOF MASHFAATSAMARITAN PUNCTUA" +
	"TION ANNAAUMANDAIC LETTER HALQAMANDAIC LETTER ABMANDAIC LETTER AGMANDAIC" +
	" LETTER ADMANDAIC LETTER AHMANDAIC LETTER USHENNAMANDAIC LETTER AZMANDAI" +
	"C LETTER ITMANDAIC LETTER ATTMANDAIC LETTER AKSAMANDAIC LETTER AKMANDAIC" +
	" LETTER ALMANDAIC LETTER AMMANDAIC LETTER ANMANDAIC LETTER ASMANDAIC LET" +
	"TER INMANDAIC LETTER APMANDAIC LETTER ASZMANDAIC LETTER AQMANDAIC LETTER" +
	" ARMANDAIC LETTER ASHMANDAIC LETTER ATMANDAIC LETTER DUSHENNAMANDAIC LET" +
	"TER KADMANDAIC LETTER AINMANDAIC AFFRICATION MARKMANDAIC VOCALIZATION MA" +
	"RKMANDAIC GEMINATION MARKMANDAIC PUNCTUATIONSYRIAC LETTER MALAYALAM NGAS" +
	"YRIAC LETTER MALAYALAM JASYRIAC LETTER MALAYALAM NYASYRIAC LETTER MALAYA" +
	"LAM TTASYRIAC LETTER MALAYALAM NNASYRIAC LETTER MALAYALAM NNNASYRIAC LET" +
	"TER MALAYALAM BHASYRIAC LETTER MALAYALAM RASYRIAC LETTER MALAYALAM LLASY" +
	"RIAC LETTER MALAYALAM LLLASYRIAC LETTER MALAYALAM SSAARABIC LETTER BEH W" +
	"ITH SMALL V BELOWARABIC LETTER BEH WITH HAMZA ABOVEARABIC LETTER JEEM WI" +
	"TH TWO DOTS ABOVEARABIC LETTER TAH WITH TWO DOTS ABOVEARABIC LETTER FEH " +
	"WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER QAF WITH DOT BELOWARABI" +
	"C LETTER LAM WITH DOUBLE BARARABIC LETTER MEEM WITH THREE DOTS ABOVEARAB" +
	"IC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVEARABIC LETTER YEH WITH " +
	"TWO DOTS BELOW AND DOT ABOVEARABIC LETTER REH WITH LOOPARABIC LETTER WAW" +
	" WITH DOT WITHINARABIC LETTER ROHINGYA YEHARABIC LETTER LOW ALEFARABIC L" +
	"ETTER DAL WITH THREE DOTS BELOWARABIC LETTER SAD WITH THREE DOTS BELOWAR" +
	"ABIC LETTER GAF WITH INVERTED STROKEARABIC LETTER STRAIGHT WAWARABIC LET" +
	"TER ZAIN WITH INVERTED V ABOVEARABIC LETTER AIN WITH THREE DOTS BELOWARA" +
	"BIC LETTER KAF WITH DOT BELOWARABIC LETTER BEH WITH SMALL MEEM ABOVEARAB" +
	"IC LETTER PEH WITH SMALL MEEM ABOVEARABIC LETTER TEH WITH SMALL TEH ABOV" +
	"EARABIC LETTER REH WITH SMALL NOON ABOVEARABIC LETTER YEH WITH TWO DOTS " +
	"BELOW AND SMALL NOON ABOVEARABIC LETTER AFRICAN FEHARABIC LETTER AFRICAN" +
	" QAFARABIC LETTER AFRICAN NOONARABIC SMALL LOW WAWARABIC SMALL HIGH WORD" +
	" AR-RUBARABIC SMALL HIGH SADARABIC SMALL HIGH AINARABIC SMALL HIGH QAFAR" +
	"ABIC SMALL HIGH NOON WITH KASRAARABIC SMALL LOW NOON WITH KASRAARABIC SM" +
	"ALL HIGH WORD ATH-THALATHAARABIC SMALL HIGH WORD AS-SAJDAARABIC SMALL HI" +
	"GH WORD AN-NISFARABIC SMALL HIGH WORD SAKTAARABIC SMALL HIGH WORD QIFARA" +
	"BIC SMALL HIGH WORD WAQFAARABIC SMALL HIGH FOOTNOTE MARKERARABIC SMALL H" +
	"IGH SIGN SAFHAARABIC DISPUTED END OF AYAHARABIC TURNED DAMMA BELOWARABIC" +
	" CURLY FATHAARABIC CURLY DAMMAARABIC CURLY KASRAARABIC CURLY FATHATANARA" +
	"BIC CURLY DAMMATANARABIC CURLY KASRATANARABIC TONE ONE DOT ABOVEARABIC T" +
	"ONE TWO DOTS ABOVEARABIC TONE LOOP ABOVEARABIC TONE ONE DOT BELOWARABIC " +
	"TONE TWO DOTS BELOWARABIC TONE LOOP BELOWARABIC OPEN FATHATANARABIC OPEN" +
	" DAMMATANARABIC OPEN KASRATANARABIC SMALL HIGH WAWARABIC FATHA WITH RING" +
	"ARABIC FATHA WITH DOT ABOVEARABIC KASRA WITH DOT BELOWARABIC LEFT ARROWH" +
	"EAD ABOVEARABIC RIGHT ARROWHEAD ABOVEARABIC LEFT ARROWHEAD BELOWARABIC R" +
	"IGHT ARROWHEAD BELOWARABIC DOUBLE RIGHT ARROWHEAD ABOVEARABIC DOUBLE RIG" +
	"HT ARROWHEAD ABOVE WITH DOTARABIC RIGHT ARROWHEAD ABOVE WITH DOTARABIC D" +
	"AMMA WITH DOTARABIC MARK SIDEWAYS NOON GHUNNADEVANAGARI SIGN INVERTED CA" +
	"NDRABINDUDEVANAGARI SIGN CANDRABINDUDEVANAGARI SIGN ANUSVARADEVANAGARI S" +
	"IGN VISARGADEVANAGARI LETTER SHORT ADEVANAGARI LETTER ADEVANAGARI LETTER" +
	" AADEVANAGARI LETTER IDEVANAGARI LETTER IIDEVANAGARI LETTER UDEVANAGARI " +
	"LETTER UUDEVANAGARI LETTER VOCALIC RDEVANAGARI LETTER VOCALIC LDEVANAGAR" +
	"I LETTER CANDRA EDEVANAGARI LETTER SHORT EDEVANAGARI LETTER EDEVANAGARI " +
	"LETTER AIDEVANAGARI LETTER CANDRA ODEVANAGARI LETTER SHORT ODEVANAGARI L" +
	"ETTER ODEVANAGARI LETTER AUDEVANAGARI LETTER KADEVANAGARI LETTER KHADEVA" +
	"NAGARI LETTER GADEVANAGARI LETTER GHADEVANAGARI LETTER NGADEVANAGARI LET" +
	"TER CADEVANAGARI LETTER CHADEVANAGARI LETTER JADEVANAGARI LETTER JHADEVA" +
	"NAGARI LETTER NYADEVANAGARI LETTER TTADEVANAGARI LETTER TTHADEVANAGARI L" +
	"ETTER DDADEVANAGARI LETTER DDHADEVANAGARI LETTER NNADEVANAGARI LETTER TA" +
	"DEVANAGARI LETTER THADEVANAGARI LETTER DADEVANAGARI LETTER DHADEVANAGARI" +
	" LETTER NADEVANAGARI LETTER NNNADEVANAGARI LETTER PADEVANAGARI LETTER PH") + ("" +
	"ADEVANAGARI LETTER BADEVANAGARI LETTER BHADEVANAGARI LETTER MADEVANAGARI" +
	" LETTER YADEVANAGARI LETTER RADEVANAGARI LETTER RRADEVANAGARI LETTER LAD" +
	"EVANAGARI LETTER LLADEVANAGARI LETTER LLLADEVANAGARI LETTER VADEVANAGARI" +
	" LETTER SHADEVANAGARI LETTER SSADEVANAGARI LETTER SADEVANAGARI LETTER HA" +
	"DEVANAGARI VOWEL SIGN OEDEVANAGARI VOWEL SIGN OOEDEVANAGARI SIGN NUKTADE" +
	"VANAGARI SIGN AVAGRAHADEVANAGARI VOWEL SIGN AADEVANAGARI VOWEL SIGN IDEV" +
	"ANAGARI VOWEL SIGN IIDEVANAGARI VOWEL SIGN UDEVANAGARI VOWEL SIGN UUDEVA" +
	"NAGARI VOWEL SIGN VOCALIC RDEVANAGARI VOWEL SIGN VOCALIC RRDEVANAGARI VO" +
	"WEL SIGN CANDRA EDEVANAGARI VOWEL SIGN SHORT EDEVANAGARI VOWEL SIGN EDEV" +
	"ANAGARI VOWEL SIGN AIDEVANAGARI VOWEL SIGN CANDRA ODEVANAGARI VOWEL SIGN" +
	" SHORT ODEVANAGARI VOWEL SIGN ODEVANAGARI VOWEL SIGN AUDEVANAGARI SIGN V" +
	"IRAMADEVANAGARI VOWEL SIGN PRISHTHAMATRA EDEVANAGARI VOWEL SIGN AWDEVANA" +
	"GARI OMDEVANAGARI STRESS SIGN UDATTADEVANAGARI STRESS SIGN ANUDATTADEVAN" +
	"AGARI GRAVE ACCENTDEVANAGARI ACUTE ACCENTDEVANAGARI VOWEL SIGN CANDRA LO" +
	"NG EDEVANAGARI VOWEL SIGN UEDEVANAGARI VOWEL SIGN UUEDEVANAGARI LETTER Q" +
	"ADEVANAGARI LETTER KHHADEVANAGARI LETTER GHHADEVANAGARI LETTER ZADEVANAG" +
	"ARI LETTER DDDHADEVANAGARI LETTER RHADEVANAGARI LETTER FADEVANAGARI LETT" +
	"ER YYADEVANAGARI LETTER VOCALIC RRDEVANAGARI LETTER VOCALIC LLDEVANAGARI" +
	" VOWEL SIGN VOCALIC LDEVANAGARI VOWEL SIGN VOCALIC LLDEVANAGARI DANDADEV" +
	"ANAGARI DOUBLE DANDADEVANAGARI DIGIT ZERODEVANAGARI DIGIT ONEDEVANAGARI " +
	"DIGIT TWODEVANAGARI DIGIT THREEDEVANAGARI DIGIT FOURDEVANAGARI DIGIT FIV" +
	"EDEVANAGARI DIGIT SIXDEVANAGARI DIGIT SEVENDEVANAGARI DIGIT EIGHTDEVANAG" +
	"ARI DIGIT NINEDEVANAGARI ABBREVIATION SIGNDEVANAGARI SIGN HIGH SPACING D" +
	"OTDEVANAGARI LETTER CANDRA ADEVANAGARI LETTER OEDEVANAGARI LETTER OOEDEV" +
	"ANAGARI LETTER AWDEVANAGARI LETTER UEDEVANAGARI LETTER UUEDEVANAGARI LET" +
	"TER MARWARI DDADEVANAGARI LETTER ZHADEVANAGARI LETTER HEAVY YADEVANAGARI" +
	" LETTER GGADEVANAGARI LETTER JJADEVANAGARI LETTER GLOTTAL STOPDEVANAGARI" +
	" LETTER DDDADEVANAGARI LETTER BBABENGALI ANJIBENGALI SIGN CANDRABINDUBEN" +
	"GALI SIGN ANUSVARABENGALI SIGN VISARGABENGALI LETTER ABENGALI LETTER AAB" +
	"ENGALI LETTER IBENGALI LETTER IIBENGALI LETTER UBENGALI LETTER UUBENGALI" +
	" LETTER VOCALIC RBENGALI LETTER VOCALIC LBENGALI LETTER EBENGALI LETTER " +
	"AIBENGALI LETTER OBENGALI LETTER AUBENGALI LETTER KABENGALI LETTER KHABE" +
	"NGALI LETTER GABENGALI LETTER GHABENGALI LETTER NGABENGALI LETTER CABENG" +
	"ALI LETTER CHABENGALI LETTER JABENGALI LETTER JHABENGALI LETTER NYABENGA" +
	"LI LETTER TTABENGALI LETTER TTHABENGALI LETTER DDABENGALI LETTER DDHABEN" +
	"GALI LETTER NNABENGALI LETTER TABENGALI LETTER THABENGALI LETTER DABENGA" +
	"LI LETTER DHABENGALI LETTER NABENGALI LETTER PABENGALI LETTER PHABENGALI" +
	" LETTER BABENGALI LETTER BHABENGALI LETTER MABENGALI LETTER YABENGALI LE" +
	"TTER RABENGALI LETTER LABENGALI LETTER SHABENGALI LETTER SSABENGALI LETT" +
	"ER SABENGALI LETTER HABENGALI SIGN NUKTABENGALI SIGN AVAGRAHABENGALI VOW" +
	"EL SIGN AABENGALI VOWEL SIGN IBENGALI VOWEL SIGN IIBENGALI VOWEL SIGN UB" +
	"ENGALI VOWEL SIGN UUBENGALI VOWEL SIGN VOCALIC RBENGALI VOWEL SIGN VOCAL" +
	"IC RRBENGALI VOWEL SIGN EBENGALI VOWEL SIGN AIBENGALI VOWEL SIGN OBENGAL" +
	"I VOWEL SIGN AUBENGALI SIGN VIRAMABENGALI LETTER KHANDA TABENGALI AU LEN" +
	"GTH MARKBENGALI LETTER RRABENGALI LETTER RHABENGALI LETTER YYABENGALI LE" +
	"TTER VOCALIC RRBENGALI LETTER VOCALIC LLBENGALI VOWEL SIGN VOCALIC LBENG" +
	"ALI VOWEL SIGN VOCALIC LLBENGALI DIGIT ZEROBENGALI DIGIT ONEBENGALI DIGI" +
	"T TWOBENGALI DIGIT THREEBENGALI DIGIT FOURBENGALI DIGIT FIVEBENGALI DIGI" +
	"T SIXBENGALI DIGIT SEVENBENGALI DIGIT EIGHTBENGALI DIGIT NINEBENGALI LET" +
	"TER RA WITH MIDDLE DIAGONALBENGALI LETTER RA WITH LOWER DIAGONALBENGALI " +
	"RUPEE MARKBENGALI RUPEE SIGNBENGALI CURRENCY NUMERATOR ONEBENGALI CURREN" +
	"CY NUMERATOR TWOBENGALI CURRENCY NUMERATOR THREEBENGALI CURRENCY NUMERAT" +
	"OR FOURBENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATORBENGALI C" +
	"URRENCY DENOMINATOR SIXTEENBENGALI ISSHARBENGALI GANDA MARKBENGALI LETTE" +
	"R VEDIC ANUSVARABENGALI ABBREVIATION SIGNBENGALI SANDHI MARKGURMUKHI SIG" +
	"N ADAK BINDIGURMUKHI SIGN BINDIGURMUKHI SIGN VISARGAGURMUKHI LETTER AGUR" +
	"MUKHI LETTER AAGURMUKHI LETTER IGURMUKHI LETTER IIGURMUKHI LETTER UGURMU" +
	"KHI LETTER UUGURMUKHI LETTER EEGURMUKHI LETTER AIGURMUKHI LETTER OOGURMU" +
	"KHI LETTER AUGURMUKHI LETTER KAGURMUKHI LETTER KHAGURMUKHI LETTER GAGURM" +
	"UKHI LETTER GHAGURMUKHI LETTER NGAGURMUKHI LETTER CAGURMUKHI LETTER CHAG" +
	"URMUKHI LETTER JAGURMUKHI LETTER JHAGURMUKHI LETTER NYAGURMUKHI LETTER T" +
	"TAGURMUKHI LETTER TTHAGURMUKHI LETTER DDAGURMUKHI LETTER DDHAGURMUKHI LE" +
	"TTER NNAGURMUKHI LETTER TAGURMUKHI LETTER THAGURMUKHI LETTER DAGURMUKHI " +
	"LETTER DHAGURMUKHI LETTER NAGURMUKHI LETTER PAGURMUKHI LETTER PHAGURMUKH") + ("" +
	"I LETTER BAGURMUKHI LETTER BHAGURMUKHI LETTER MAGURMUKHI LETTER YAGURMUK" +
	"HI LETTER RAGURMUKHI LETTER LAGURMUKHI LETTER LLAGURMUKHI LETTER VAGURMU" +
	"KHI LETTER SHAGURMUKHI LETTER SAGURMUKHI LETTER HAGURMUKHI SIGN NUKTAGUR" +
	"MUKHI VOWEL SIGN AAGURMUKHI VOWEL SIGN IGURMUKHI VOWEL SIGN IIGURMUKHI V" +
	"OWEL SIGN UGURMUKHI VOWEL SIGN UUGURMUKHI VOWEL SIGN EEGURMUKHI VOWEL SI" +
	"GN AIGURMUKHI VOWEL SIGN OOGURMUKHI VOWEL SIGN AUGURMUKHI SIGN VIRAMAGUR" +
	"MUKHI SIGN UDAATGURMUKHI LETTER KHHAGURMUKHI LETTER GHHAGURMUKHI LETTER " +
	"ZAGURMUKHI LETTER RRAGURMUKHI LETTER FAGURMUKHI DIGIT ZEROGURMUKHI DIGIT" +
	" ONEGURMUKHI DIGIT TWOGURMUKHI DIGIT THREEGURMUKHI DIGIT FOURGURMUKHI DI" +
	"GIT FIVEGURMUKHI DIGIT SIXGURMUKHI DIGIT SEVENGURMUKHI DIGIT EIGHTGURMUK" +
	"HI DIGIT NINEGURMUKHI TIPPIGURMUKHI ADDAKGURMUKHI IRIGURMUKHI URAGURMUKH" +
	"I EK ONKARGURMUKHI SIGN YAKASHGURMUKHI ABBREVIATION SIGNGUJARATI SIGN CA" +
	"NDRABINDUGUJARATI SIGN ANUSVARAGUJARATI SIGN VISARGAGUJARATI LETTER AGUJ" +
	"ARATI LETTER AAGUJARATI LETTER IGUJARATI LETTER IIGUJARATI LETTER UGUJAR" +
	"ATI LETTER UUGUJARATI LETTER VOCALIC RGUJARATI LETTER VOCALIC LGUJARATI " +
	"VOWEL CANDRA EGUJARATI LETTER EGUJARATI LETTER AIGUJARATI VOWEL CANDRA O" +
	"GUJARATI LETTER OGUJARATI LETTER AUGUJARATI LETTER KAGUJARATI LETTER KHA" +
	"GUJARATI LETTER GAGUJARATI LETTER GHAGUJARATI LETTER NGAGUJARATI LETTER " +
	"CAGUJARATI LETTER CHAGUJARATI LETTER JAGUJARATI LETTER JHAGUJARATI LETTE" +
	"R NYAGUJARATI LETTER TTAGUJARATI LETTER TTHAGUJARATI LETTER DDAGUJARATI " +
	"LETTER DDHAGUJARATI LETTER NNAGUJARATI LETTER TAGUJARATI LETTER THAGUJAR" +
	"ATI LETTER DAGUJARATI LETTER DHAGUJARATI LETTER NAGUJARATI LETTER PAGUJA" +
	"RATI LETTER PHAGUJARATI LETTER BAGUJARATI LETTER BHAGUJARATI LETTER MAGU" +
	"JARATI LETTER YAGUJARATI LETTER RAGUJARATI LETTER LAGUJARATI LETTER LLAG" +
	"UJARATI LETTER VAGUJARATI LETTER SHAGUJARATI LETTER SSAGUJARATI LETTER S" +
	"AGUJARATI LETTER HAGUJARATI SIGN NUKTAGUJARATI SIGN AVAGRAHAGUJARATI VOW" +
	"EL SIGN AAGUJARATI VOWEL SIGN IGUJARATI VOWEL SIGN IIGUJARATI VOWEL SIGN" +
	" UGUJARATI VOWEL SIGN UUGUJARATI VOWEL SIGN VOCALIC RGUJARATI VOWEL SIGN" +
	" VOCALIC RRGUJARATI VOWEL SIGN CANDRA EGUJARATI VOWEL SIGN EGUJARATI VOW" +
	"EL SIGN AIGUJARATI VOWEL SIGN CANDRA OGUJARATI VOWEL SIGN OGUJARATI VOWE" +
	"L SIGN AUGUJARATI SIGN VIRAMAGUJARATI OMGUJARATI LETTER VOCALIC RRGUJARA" +
	"TI LETTER VOCALIC LLGUJARATI VOWEL SIGN VOCALIC LGUJARATI VOWEL SIGN VOC" +
	"ALIC LLGUJARATI DIGIT ZEROGUJARATI DIGIT ONEGUJARATI DIGIT TWOGUJARATI D" +
	"IGIT THREEGUJARATI DIGIT FOURGUJARATI DIGIT FIVEGUJARATI DIGIT SIXGUJARA" +
	"TI DIGIT SEVENGUJARATI DIGIT EIGHTGUJARATI DIGIT NINEGUJARATI ABBREVIATI" +
	"ON SIGNGUJARATI RUPEE SIGNGUJARATI LETTER ZHAGUJARATI SIGN SUKUNGUJARATI" +
	" SIGN SHADDAGUJARATI SIGN MADDAHGUJARATI SIGN THREE-DOT NUKTA ABOVEGUJAR" +
	"ATI SIGN CIRCLE NUKTA ABOVEGUJARATI SIGN TWO-CIRCLE NUKTA ABOVEORIYA SIG" +
	"N CANDRABINDUORIYA SIGN ANUSVARAORIYA SIGN VISARGAORIYA LETTER AORIYA LE" +
	"TTER AAORIYA LETTER IORIYA LETTER IIORIYA LETTER UORIYA LETTER UUORIYA L" +
	"ETTER VOCALIC RORIYA LETTER VOCALIC LORIYA LETTER EORIYA LETTER AIORIYA " +
	"LETTER OORIYA LETTER AUORIYA LETTER KAORIYA LETTER KHAORIYA LETTER GAORI" +
	"YA LETTER GHAORIYA LETTER NGAORIYA LETTER CAORIYA LETTER CHAORIYA LETTER" +
	" JAORIYA LETTER JHAORIYA LETTER NYAORIYA LETTER TTAORIYA LETTER TTHAORIY" +
	"A LETTER DDAORIYA LETTER DDHAORIYA LETTER NNAORIYA LETTER TAORIYA LETTER" +
	" THAORIYA LETTER DAORIYA LETTER DHAORIYA LETTER NAORIYA LETTER PAORIYA L" +
	"ETTER PHAORIYA LETTER BAORIYA LETTER BHAORIYA LETTER MAORIYA LETTER YAOR" +
	"IYA LETTER RAORIYA LETTER LAORIYA LETTER LLAORIYA LETTER VAORIYA LETTER " +
	"SHAORIYA LETTER SSAORIYA LETTER SAORIYA LETTER HAORIYA SIGN NUKTAORIYA S" +
	"IGN AVAGRAHAORIYA VOWEL SIGN AAORIYA VOWEL SIGN IORIYA VOWEL SIGN IIORIY" +
	"A VOWEL SIGN UORIYA VOWEL SIGN UUORIYA VOWEL SIGN VOCALIC RORIYA VOWEL S" +
	"IGN VOCALIC RRORIYA VOWEL SIGN EORIYA VOWEL SIGN AIORIYA VOWEL SIGN OORI" +
	"YA VOWEL SIGN AUORIYA SIGN VIRAMAORIYA AI LENGTH MARKORIYA AU LENGTH MAR" +
	"KORIYA LETTER RRAORIYA LETTER RHAORIYA LETTER YYAORIYA LETTER VOCALIC RR" +
	"ORIYA LETTER VOCALIC LLORIYA VOWEL SIGN VOCALIC LORIYA VOWEL SIGN VOCALI" +
	"C LLORIYA DIGIT ZEROORIYA DIGIT ONEORIYA DIGIT TWOORIYA DIGIT THREEORIYA" +
	" DIGIT FOURORIYA DIGIT FIVEORIYA DIGIT SIXORIYA DIGIT SEVENORIYA DIGIT E" +
	"IGHTORIYA DIGIT NINEORIYA ISSHARORIYA LETTER WAORIYA FRACTION ONE QUARTE" +
	"RORIYA FRACTION ONE HALFORIYA FRACTION THREE QUARTERSORIYA FRACTION ONE " +
	"SIXTEENTHORIYA FRACTION ONE EIGHTHORIYA FRACTION THREE SIXTEENTHSTAMIL S" +
	"IGN ANUSVARATAMIL SIGN VISARGATAMIL LETTER ATAMIL LETTER AATAMIL LETTER " +
	"ITAMIL LETTER IITAMIL LETTER UTAMIL LETTER UUTAMIL LETTER ETAMIL LETTER " +
	"EETAMIL LETTER AITAMIL LETTER OTAMIL LETTER OOTAMIL LETTER AUTAMIL LETTE" +
	"R KATAMIL LETTER NGATAMIL LETTER CATAMIL LETTER JATAMIL LETTER NYATAMIL ") + ("" +
	"LETTER TTATAMIL LETTER NNATAMIL LETTER TATAMIL LETTER NATAMIL LETTER NNN" +
	"ATAMIL LETTER PATAMIL LETTER MATAMIL LETTER YATAMIL LETTER RATAMIL LETTE" +
	"R RRATAMIL LETTER LATAMIL LETTER LLATAMIL LETTER LLLATAMIL LETTER VATAMI" +
	"L LETTER SHATAMIL LETTER SSATAMIL LETTER SATAMIL LETTER HATAMIL VOWEL SI" +
	"GN AATAMIL VOWEL SIGN ITAMIL VOWEL SIGN IITAMIL VOWEL SIGN UTAMIL VOWEL " +
	"SIGN UUTAMIL VOWEL SIGN ETAMIL VOWEL SIGN EETAMIL VOWEL SIGN AITAMIL VOW" +
	"EL SIGN OTAMIL VOWEL SIGN OOTAMIL VOWEL SIGN AUTAMIL SIGN VIRAMATAMIL OM" +
	"TAMIL AU LENGTH MARKTAMIL DIGIT ZEROTAMIL DIGIT ONETAMIL DIGIT TWOTAMIL " +
	"DIGIT THREETAMIL DIGIT FOURTAMIL DIGIT FIVETAMIL DIGIT SIXTAMIL DIGIT SE" +
	"VENTAMIL DIGIT EIGHTTAMIL DIGIT NINETAMIL NUMBER TENTAMIL NUMBER ONE HUN" +
	"DREDTAMIL NUMBER ONE THOUSANDTAMIL DAY SIGNTAMIL MONTH SIGNTAMIL YEAR SI" +
	"GNTAMIL DEBIT SIGNTAMIL CREDIT SIGNTAMIL AS ABOVE SIGNTAMIL RUPEE SIGNTA" +
	"MIL NUMBER SIGNTELUGU SIGN COMBINING CANDRABINDU ABOVETELUGU SIGN CANDRA" +
	"BINDUTELUGU SIGN ANUSVARATELUGU SIGN VISARGATELUGU SIGN COMBINING ANUSVA" +
	"RA ABOVETELUGU LETTER ATELUGU LETTER AATELUGU LETTER ITELUGU LETTER IITE" +
	"LUGU LETTER UTELUGU LETTER UUTELUGU LETTER VOCALIC RTELUGU LETTER VOCALI" +
	"C LTELUGU LETTER ETELUGU LETTER EETELUGU LETTER AITELUGU LETTER OTELUGU " +
	"LETTER OOTELUGU LETTER AUTELUGU LETTER KATELUGU LETTER KHATELUGU LETTER " +
	"GATELUGU LETTER GHATELUGU LETTER NGATELUGU LETTER CATELUGU LETTER CHATEL" +
	"UGU LETTER JATELUGU LETTER JHATELUGU LETTER NYATELUGU LETTER TTATELUGU L" +
	"ETTER TTHATELUGU LETTER DDATELUGU LETTER DDHATELUGU LETTER NNATELUGU LET" +
	"TER TATELUGU LETTER THATELUGU LETTER DATELUGU LETTER DHATELUGU LETTER NA" +
	"TELUGU LETTER PATELUGU LETTER PHATELUGU LETTER BATELUGU LETTER BHATELUGU" +
	" LETTER MATELUGU LETTER YATELUGU LETTER RATELUGU LETTER RRATELUGU LETTER" +
	" LATELUGU LETTER LLATELUGU LETTER LLLATELUGU LETTER VATELUGU LETTER SHAT" +
	"ELUGU LETTER SSATELUGU LETTER SATELUGU LETTER HATELUGU SIGN AVAGRAHATELU" +
	"GU VOWEL SIGN AATELUGU VOWEL SIGN ITELUGU VOWEL SIGN IITELUGU VOWEL SIGN" +
	" UTELUGU VOWEL SIGN UUTELUGU VOWEL SIGN VOCALIC RTELUGU VOWEL SIGN VOCAL" +
	"IC RRTELUGU VOWEL SIGN ETELUGU VOWEL SIGN EETELUGU VOWEL SIGN AITELUGU V" +
	"OWEL SIGN OTELUGU VOWEL SIGN OOTELUGU VOWEL SIGN AUTELUGU SIGN VIRAMATEL" +
	"UGU LENGTH MARKTELUGU AI LENGTH MARKTELUGU LETTER TSATELUGU LETTER DZATE" +
	"LUGU LETTER RRRATELUGU LETTER VOCALIC RRTELUGU LETTER VOCALIC LLTELUGU V" +
	"OWEL SIGN VOCALIC LTELUGU VOWEL SIGN VOCALIC LLTELUGU DIGIT ZEROTELUGU D" +
	"IGIT ONETELUGU DIGIT TWOTELUGU DIGIT THREETELUGU DIGIT FOURTELUGU DIGIT " +
	"FIVETELUGU DIGIT SIXTELUGU DIGIT SEVENTELUGU DIGIT EIGHTTELUGU DIGIT NIN" +
	"ETELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT " +
	"ONE FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FO" +
	"URTELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOURTELUGU FRACTION DIGI" +
	"T ONE FOR EVEN POWERS OF FOURTELUGU FRACTION DIGIT TWO FOR EVEN POWERS O" +
	"F FOURTELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOURTELUGU SIGN TUU" +
	"MUKANNADA SIGN SPACING CANDRABINDUKANNADA SIGN CANDRABINDUKANNADA SIGN A" +
	"NUSVARAKANNADA SIGN VISARGAKANNADA SIGN SIDDHAMKANNADA LETTER AKANNADA L" +
	"ETTER AAKANNADA LETTER IKANNADA LETTER IIKANNADA LETTER UKANNADA LETTER " +
	"UUKANNADA LETTER VOCALIC RKANNADA LETTER VOCALIC LKANNADA LETTER EKANNAD" +
	"A LETTER EEKANNADA LETTER AIKANNADA LETTER OKANNADA LETTER OOKANNADA LET" +
	"TER AUKANNADA LETTER KAKANNADA LETTER KHAKANNADA LETTER GAKANNADA LETTER" +
	" GHAKANNADA LETTER NGAKANNADA LETTER CAKANNADA LETTER CHAKANNADA LETTER " +
	"JAKANNADA LETTER JHAKANNADA LETTER NYAKANNADA LETTER TTAKANNADA LETTER T" +
	"THAKANNADA LETTER DDAKANNADA LETTER DDHAKANNADA LETTER NNAKANNADA LETTER" +
	" TAKANNADA LETTER THAKANNADA LETTER DAKANNADA LETTER DHAKANNADA LETTER N" +
	"AKANNADA LETTER PAKANNADA LETTER PHAKANNADA LETTER BAKANNADA LETTER BHAK" +
	"ANNADA LETTER MAKANNADA LETTER YAKANNADA LETTER RAKANNADA LETTER RRAKANN" +
	"ADA LETTER LAKANNADA LETTER LLAKANNADA LETTER VAKANNADA LETTER SHAKANNAD" +
	"A LETTER SSAKANNADA LETTER SAKANNADA LETTER HAKANNADA SIGN NUKTAKANNADA " +
	"SIGN AVAGRAHAKANNADA VOWEL SIGN AAKANNADA VOWEL SIGN IKANNADA VOWEL SIGN" +
	" IIKANNADA VOWEL SIGN UKANNADA VOWEL SIGN UUKANNADA VOWEL SIGN VOCALIC R" +
	"KANNADA VOWEL SIGN VOCALIC RRKANNADA VOWEL SIGN EKANNADA VOWEL SIGN EEKA" +
	"NNADA VOWEL SIGN AIKANNADA VOWEL SIGN OKANNADA VOWEL SIGN OOKANNADA VOWE" +
	"L SIGN AUKANNADA SIGN VIRAMAKANNADA LENGTH MARKKANNADA AI LENGTH MARKKAN" +
	"NADA LETTER FAKANNADA LETTER VOCALIC RRKANNADA LETTER VOCALIC LLKANNADA " +
	"VOWEL SIGN VOCALIC LKANNADA VOWEL SIGN VOCALIC LLKANNADA DIGIT ZEROKANNA" +
	"DA DIGIT ONEKANNADA DIGIT TWOKANNADA DIGIT THREEKANNADA DIGIT FOURKANNAD" +
	"A DIGIT FIVEKANNADA DIGIT SIXKANNADA DIGIT SEVENKANNADA DIGIT EIGHTKANNA" +
	"DA DIGIT NINEKANNADA SIGN JIHVAMULIYAKANNADA SIGN UPADHMANIYAMALAYALAM S") + ("" +
	"IGN COMBINING ANUSVARA ABOVEMALAYALAM SIGN CANDRABINDUMALAYALAM SIGN ANU" +
	"SVARAMALAYALAM SIGN VISARGAMALAYALAM LETTER AMALAYALAM LETTER AAMALAYALA" +
	"M LETTER IMALAYALAM LETTER IIMALAYALAM LETTER UMALAYALAM LETTER UUMALAYA" +
	"LAM LETTER VOCALIC RMALAYALAM LETTER VOCALIC LMALAYALAM LETTER EMALAYALA" +
	"M LETTER EEMALAYALAM LETTER AIMALAYALAM LETTER OMALAYALAM LETTER OOMALAY" +
	"ALAM LETTER AUMALAYALAM LETTER KAMALAYALAM LETTER KHAMALAYALAM LETTER GA" +
	"MALAYALAM LETTER GHAMALAYALAM LETTER NGAMALAYALAM LETTER CAMALAYALAM LET" +
	"TER CHAMALAYALAM LETTER JAMALAYALAM LETTER JHAMALAYALAM LETTER NYAMALAYA" +
	"LAM LETTER TTAMALAYALAM LETTER TTHAMALAYALAM LETTER DDAMALAYALAM LETTER " +
	"DDHAMALAYALAM LETTER NNAMALAYALAM LETTER TAMALAYALAM LETTER THAMALAYALAM" +
	" LETTER DAMALAYALAM LETTER DHAMALAYALAM LETTER NAMALAYALAM LETTER NNNAMA" +
	"LAYALAM LETTER PAMALAYALAM LETTER PHAMALAYALAM LETTER BAMALAYALAM LETTER" +
	" BHAMALAYALAM LETTER MAMALAYALAM LETTER YAMALAYALAM LETTER RAMALAYALAM L" +
	"ETTER RRAMALAYALAM LETTER LAMALAYALAM LETTER LLAMALAYALAM LETTER LLLAMAL" +
	"AYALAM LETTER VAMALAYALAM LETTER SHAMALAYALAM LETTER SSAMALAYALAM LETTER" +
	" SAMALAYALAM LETTER HAMALAYALAM LETTER TTTAMALAYALAM SIGN VERTICAL BAR V" +
	"IRAMAMALAYALAM SIGN CIRCULAR VIRAMAMALAYALAM SIGN AVAGRAHAMALAYALAM VOWE" +
	"L SIGN AAMALAYALAM VOWEL SIGN IMALAYALAM VOWEL SIGN IIMALAYALAM VOWEL SI" +
	"GN UMALAYALAM VOWEL SIGN UUMALAYALAM VOWEL SIGN VOCALIC RMALAYALAM VOWEL" +
	" SIGN VOCALIC RRMALAYALAM VOWEL SIGN EMALAYALAM VOWEL SIGN EEMALAYALAM V" +
	"OWEL SIGN AIMALAYALAM VOWEL SIGN OMALAYALAM VOWEL SIGN OOMALAYALAM VOWEL" +
	" SIGN AUMALAYALAM SIGN VIRAMAMALAYALAM LETTER DOT REPHMALAYALAM SIGN PAR" +
	"AMALAYALAM LETTER CHILLU MMALAYALAM LETTER CHILLU YMALAYALAM LETTER CHIL" +
	"LU LLLMALAYALAM AU LENGTH MARKMALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIX" +
	"TIETHMALAYALAM FRACTION ONE FORTIETHMALAYALAM FRACTION THREE EIGHTIETHSM" +
	"ALAYALAM FRACTION ONE TWENTIETHMALAYALAM FRACTION ONE TENTHMALAYALAM FRA" +
	"CTION THREE TWENTIETHSMALAYALAM FRACTION ONE FIFTHMALAYALAM LETTER ARCHA" +
	"IC IIMALAYALAM LETTER VOCALIC RRMALAYALAM LETTER VOCALIC LLMALAYALAM VOW" +
	"EL SIGN VOCALIC LMALAYALAM VOWEL SIGN VOCALIC LLMALAYALAM DIGIT ZEROMALA" +
	"YALAM DIGIT ONEMALAYALAM DIGIT TWOMALAYALAM DIGIT THREEMALAYALAM DIGIT F" +
	"OURMALAYALAM DIGIT FIVEMALAYALAM DIGIT SIXMALAYALAM DIGIT SEVENMALAYALAM" +
	" DIGIT EIGHTMALAYALAM DIGIT NINEMALAYALAM NUMBER TENMALAYALAM NUMBER ONE" +
	" HUNDREDMALAYALAM NUMBER ONE THOUSANDMALAYALAM FRACTION ONE QUARTERMALAY" +
	"ALAM FRACTION ONE HALFMALAYALAM FRACTION THREE QUARTERSMALAYALAM FRACTIO" +
	"N ONE SIXTEENTHMALAYALAM FRACTION ONE EIGHTHMALAYALAM FRACTION THREE SIX" +
	"TEENTHSMALAYALAM DATE MARKMALAYALAM LETTER CHILLU NNMALAYALAM LETTER CHI" +
	"LLU NMALAYALAM LETTER CHILLU RRMALAYALAM LETTER CHILLU LMALAYALAM LETTER" +
	" CHILLU LLMALAYALAM LETTER CHILLU KSINHALA SIGN ANUSVARAYASINHALA SIGN V" +
	"ISARGAYASINHALA LETTER AYANNASINHALA LETTER AAYANNASINHALA LETTER AEYANN" +
	"ASINHALA LETTER AEEYANNASINHALA LETTER IYANNASINHALA LETTER IIYANNASINHA" +
	"LA LETTER UYANNASINHALA LETTER UUYANNASINHALA LETTER IRUYANNASINHALA LET" +
	"TER IRUUYANNASINHALA LETTER ILUYANNASINHALA LETTER ILUUYANNASINHALA LETT" +
	"ER EYANNASINHALA LETTER EEYANNASINHALA LETTER AIYANNASINHALA LETTER OYAN" +
	"NASINHALA LETTER OOYANNASINHALA LETTER AUYANNASINHALA LETTER ALPAPRAANA " +
	"KAYANNASINHALA LETTER MAHAAPRAANA KAYANNASINHALA LETTER ALPAPRAANA GAYAN" +
	"NASINHALA LETTER MAHAAPRAANA GAYANNASINHALA LETTER KANTAJA NAASIKYAYASIN" +
	"HALA LETTER SANYAKA GAYANNASINHALA LETTER ALPAPRAANA CAYANNASINHALA LETT" +
	"ER MAHAAPRAANA CAYANNASINHALA LETTER ALPAPRAANA JAYANNASINHALA LETTER MA" +
	"HAAPRAANA JAYANNASINHALA LETTER TAALUJA NAASIKYAYASINHALA LETTER TAALUJA" +
	" SANYOOGA NAAKSIKYAYASINHALA LETTER SANYAKA JAYANNASINHALA LETTER ALPAPR" +
	"AANA TTAYANNASINHALA LETTER MAHAAPRAANA TTAYANNASINHALA LETTER ALPAPRAAN" +
	"A DDAYANNASINHALA LETTER MAHAAPRAANA DDAYANNASINHALA LETTER MUURDHAJA NA" +
	"YANNASINHALA LETTER SANYAKA DDAYANNASINHALA LETTER ALPAPRAANA TAYANNASIN" +
	"HALA LETTER MAHAAPRAANA TAYANNASINHALA LETTER ALPAPRAANA DAYANNASINHALA " +
	"LETTER MAHAAPRAANA DAYANNASINHALA LETTER DANTAJA NAYANNASINHALA LETTER S" +
	"ANYAKA DAYANNASINHALA LETTER ALPAPRAANA PAYANNASINHALA LETTER MAHAAPRAAN" +
	"A PAYANNASINHALA LETTER ALPAPRAANA BAYANNASINHALA LETTER MAHAAPRAANA BAY" +
	"ANNASINHALA LETTER MAYANNASINHALA LETTER AMBA BAYANNASINHALA LETTER YAYA" +
	"NNASINHALA LETTER RAYANNASINHALA LETTER DANTAJA LAYANNASINHALA LETTER VA" +
	"YANNASINHALA LETTER TAALUJA SAYANNASINHALA LETTER MUURDHAJA SAYANNASINHA" +
	"LA LETTER DANTAJA SAYANNASINHALA LETTER HAYANNASINHALA LETTER MUURDHAJA " +
	"LAYANNASINHALA LETTER FAYANNASINHALA SIGN AL-LAKUNASINHALA VOWEL SIGN AE" +
	"LA-PILLASINHALA VOWEL SIGN KETTI AEDA-PILLASINHALA VOWEL SIGN DIGA AEDA-" +
	"PILLASINHALA VOWEL SIGN KETTI IS-PILLASINHALA VOWEL SIGN DIGA IS-PILLASI") + ("" +
	"NHALA VOWEL SIGN KETTI PAA-PILLASINHALA VOWEL SIGN DIGA PAA-PILLASINHALA" +
	" VOWEL SIGN GAETTA-PILLASINHALA VOWEL SIGN KOMBUVASINHALA VOWEL SIGN DIG" +
	"A KOMBUVASINHALA VOWEL SIGN KOMBU DEKASINHALA VOWEL SIGN KOMBUVA HAA AEL" +
	"A-PILLASINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLASINHALA VOWEL SIGN " +
	"KOMBUVA HAA GAYANUKITTASINHALA VOWEL SIGN GAYANUKITTASINHALA LITH DIGIT " +
	"ZEROSINHALA LITH DIGIT ONESINHALA LITH DIGIT TWOSINHALA LITH DIGIT THREE" +
	"SINHALA LITH DIGIT FOURSINHALA LITH DIGIT FIVESINHALA LITH DIGIT SIXSINH" +
	"ALA LITH DIGIT SEVENSINHALA LITH DIGIT EIGHTSINHALA LITH DIGIT NINESINHA" +
	"LA VOWEL SIGN DIGA GAETTA-PILLASINHALA VOWEL SIGN DIGA GAYANUKITTASINHAL" +
	"A PUNCTUATION KUNDDALIYATHAI CHARACTER KO KAITHAI CHARACTER KHO KHAITHAI" +
	" CHARACTER KHO KHUATTHAI CHARACTER KHO KHWAITHAI CHARACTER KHO KHONTHAI " +
	"CHARACTER KHO RAKHANGTHAI CHARACTER NGO NGUTHAI CHARACTER CHO CHANTHAI C" +
	"HARACTER CHO CHINGTHAI CHARACTER CHO CHANGTHAI CHARACTER SO SOTHAI CHARA" +
	"CTER CHO CHOETHAI CHARACTER YO YINGTHAI CHARACTER DO CHADATHAI CHARACTER" +
	" TO PATAKTHAI CHARACTER THO THANTHAI CHARACTER THO NANGMONTHOTHAI CHARAC" +
	"TER THO PHUTHAOTHAI CHARACTER NO NENTHAI CHARACTER DO DEKTHAI CHARACTER " +
	"TO TAOTHAI CHARACTER THO THUNGTHAI CHARACTER THO THAHANTHAI CHARACTER TH" +
	"O THONGTHAI CHARACTER NO NUTHAI CHARACTER BO BAIMAITHAI CHARACTER PO PLA" +
	"THAI CHARACTER PHO PHUNGTHAI CHARACTER FO FATHAI CHARACTER PHO PHANTHAI " +
	"CHARACTER FO FANTHAI CHARACTER PHO SAMPHAOTHAI CHARACTER MO MATHAI CHARA" +
	"CTER YO YAKTHAI CHARACTER RO RUATHAI CHARACTER RUTHAI CHARACTER LO LINGT" +
	"HAI CHARACTER LUTHAI CHARACTER WO WAENTHAI CHARACTER SO SALATHAI CHARACT" +
	"ER SO RUSITHAI CHARACTER SO SUATHAI CHARACTER HO HIPTHAI CHARACTER LO CH" +
	"ULATHAI CHARACTER O ANGTHAI CHARACTER HO NOKHUKTHAI CHARACTER PAIYANNOIT" +
	"HAI CHARACTER SARA ATHAI CHARACTER MAI HAN-AKATTHAI CHARACTER SARA AATHA" +
	"I CHARACTER SARA AMTHAI CHARACTER SARA ITHAI CHARACTER SARA IITHAI CHARA" +
	"CTER SARA UETHAI CHARACTER SARA UEETHAI CHARACTER SARA UTHAI CHARACTER S" +
	"ARA UUTHAI CHARACTER PHINTHUTHAI CURRENCY SYMBOL BAHTTHAI CHARACTER SARA" +
	" ETHAI CHARACTER SARA AETHAI CHARACTER SARA OTHAI CHARACTER SARA AI MAIM" +
	"UANTHAI CHARACTER SARA AI MAIMALAITHAI CHARACTER LAKKHANGYAOTHAI CHARACT" +
	"ER MAIYAMOKTHAI CHARACTER MAITAIKHUTHAI CHARACTER MAI EKTHAI CHARACTER M" +
	"AI THOTHAI CHARACTER MAI TRITHAI CHARACTER MAI CHATTAWATHAI CHARACTER TH" +
	"ANTHAKHATTHAI CHARACTER NIKHAHITTHAI CHARACTER YAMAKKANTHAI CHARACTER FO" +
	"NGMANTHAI DIGIT ZEROTHAI DIGIT ONETHAI DIGIT TWOTHAI DIGIT THREETHAI DIG" +
	"IT FOURTHAI DIGIT FIVETHAI DIGIT SIXTHAI DIGIT SEVENTHAI DIGIT EIGHTTHAI" +
	" DIGIT NINETHAI CHARACTER ANGKHANKHUTHAI CHARACTER KHOMUTLAO LETTER KOLA" +
	"O LETTER KHO SUNGLAO LETTER KHO TAMLAO LETTER NGOLAO LETTER COLAO LETTER" +
	" SO TAMLAO LETTER NYOLAO LETTER DOLAO LETTER TOLAO LETTER THO SUNGLAO LE" +
	"TTER THO TAMLAO LETTER NOLAO LETTER BOLAO LETTER POLAO LETTER PHO SUNGLA" +
	"O LETTER FO TAMLAO LETTER PHO TAMLAO LETTER FO SUNGLAO LETTER MOLAO LETT" +
	"ER YOLAO LETTER LO LINGLAO LETTER LO LOOTLAO LETTER WOLAO LETTER SO SUNG" +
	"LAO LETTER HO SUNGLAO LETTER OLAO LETTER HO TAMLAO ELLIPSISLAO VOWEL SIG" +
	"N ALAO VOWEL SIGN MAI KANLAO VOWEL SIGN AALAO VOWEL SIGN AMLAO VOWEL SIG" +
	"N ILAO VOWEL SIGN IILAO VOWEL SIGN YLAO VOWEL SIGN YYLAO VOWEL SIGN ULAO" +
	" VOWEL SIGN UULAO VOWEL SIGN MAI KONLAO SEMIVOWEL SIGN LOLAO SEMIVOWEL S" +
	"IGN NYOLAO VOWEL SIGN ELAO VOWEL SIGN EILAO VOWEL SIGN OLAO VOWEL SIGN A" +
	"YLAO VOWEL SIGN AILAO KO LALAO TONE MAI EKLAO TONE MAI THOLAO TONE MAI T" +
	"ILAO TONE MAI CATAWALAO CANCELLATION MARKLAO NIGGAHITALAO DIGIT ZEROLAO " +
	"DIGIT ONELAO DIGIT TWOLAO DIGIT THREELAO DIGIT FOURLAO DIGIT FIVELAO DIG" +
	"IT SIXLAO DIGIT SEVENLAO DIGIT EIGHTLAO DIGIT NINELAO HO NOLAO HO MOLAO " +
	"LETTER KHMU GOLAO LETTER KHMU NYOTIBETAN SYLLABLE OMTIBETAN MARK GTER YI" +
	"G MGO TRUNCATED ATIBETAN MARK GTER YIG MGO -UM RNAM BCAD MATIBETAN MARK " +
	"GTER YIG MGO -UM GTER TSHEG MATIBETAN MARK INITIAL YIG MGO MDUN MATIBETA" +
	"N MARK CLOSING YIG MGO SGAB MATIBETAN MARK CARET YIG MGO PHUR SHAD MATIB" +
	"ETAN MARK YIG MGO TSHEG SHAD MATIBETAN MARK SBRUL SHADTIBETAN MARK BSKUR" +
	" YIG MGOTIBETAN MARK BKA- SHOG YIG MGOTIBETAN MARK INTERSYLLABIC TSHEGTI" +
	"BETAN MARK DELIMITER TSHEG BSTARTIBETAN MARK SHADTIBETAN MARK NYIS SHADT" +
	"IBETAN MARK TSHEG SHADTIBETAN MARK NYIS TSHEG SHADTIBETAN MARK RIN CHEN " +
	"SPUNGS SHADTIBETAN MARK RGYA GRAM SHADTIBETAN MARK CARET -DZUD RTAGS ME " +
	"LONG CANTIBETAN MARK GTER TSHEGTIBETAN LOGOTYPE SIGN CHAD RTAGSTIBETAN L" +
	"OGOTYPE SIGN LHAG RTAGSTIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGSTI" +
	"BETAN ASTROLOGICAL SIGN -KHYUD PATIBETAN ASTROLOGICAL SIGN SDONG TSHUGST" +
	"IBETAN SIGN RDEL DKAR GCIGTIBETAN SIGN RDEL DKAR GNYISTIBETAN SIGN RDEL " +
	"DKAR GSUMTIBETAN SIGN RDEL NAG GCIGTIBETAN SIGN RDEL NAG GNYISTIBETAN SI") + ("" +
	"GN RDEL DKAR RDEL NAGTIBETAN DIGIT ZEROTIBETAN DIGIT ONETIBETAN DIGIT TW" +
	"OTIBETAN DIGIT THREETIBETAN DIGIT FOURTIBETAN DIGIT FIVETIBETAN DIGIT SI" +
	"XTIBETAN DIGIT SEVENTIBETAN DIGIT EIGHTTIBETAN DIGIT NINETIBETAN DIGIT H" +
	"ALF ONETIBETAN DIGIT HALF TWOTIBETAN DIGIT HALF THREETIBETAN DIGIT HALF " +
	"FOURTIBETAN DIGIT HALF FIVETIBETAN DIGIT HALF SIXTIBETAN DIGIT HALF SEVE" +
	"NTIBETAN DIGIT HALF EIGHTTIBETAN DIGIT HALF NINETIBETAN DIGIT HALF ZEROT" +
	"IBETAN MARK BSDUS RTAGSTIBETAN MARK NGAS BZUNG NYI ZLATIBETAN MARK CARET" +
	" -DZUD RTAGS BZHI MIG CANTIBETAN MARK NGAS BZUNG SGOR RTAGSTIBETAN MARK " +
	"CHE MGOTIBETAN MARK TSA -PHRUTIBETAN MARK GUG RTAGS GYONTIBETAN MARK GUG" +
	" RTAGS GYASTIBETAN MARK ANG KHANG GYONTIBETAN MARK ANG KHANG GYASTIBETAN" +
	" SIGN YAR TSHESTIBETAN SIGN MAR TSHESTIBETAN LETTER KATIBETAN LETTER KHA" +
	"TIBETAN LETTER GATIBETAN LETTER GHATIBETAN LETTER NGATIBETAN LETTER CATI" +
	"BETAN LETTER CHATIBETAN LETTER JATIBETAN LETTER NYATIBETAN LETTER TTATIB" +
	"ETAN LETTER TTHATIBETAN LETTER DDATIBETAN LETTER DDHATIBETAN LETTER NNAT" +
	"IBETAN LETTER TATIBETAN LETTER THATIBETAN LETTER DATIBETAN LETTER DHATIB" +
	"ETAN LETTER NATIBETAN LETTER PATIBETAN LETTER PHATIBETAN LETTER BATIBETA" +
	"N LETTER BHATIBETAN LETTER MATIBETAN LETTER TSATIBETAN LETTER TSHATIBETA" +
	"N LETTER DZATIBETAN LETTER DZHATIBETAN LETTER WATIBETAN LETTER ZHATIBETA" +
	"N LETTER ZATIBETAN LETTER -ATIBETAN LETTER YATIBETAN LETTER RATIBETAN LE" +
	"TTER LATIBETAN LETTER SHATIBETAN LETTER SSATIBETAN LETTER SATIBETAN LETT" +
	"ER HATIBETAN LETTER ATIBETAN LETTER KSSATIBETAN LETTER FIXED-FORM RATIBE" +
	"TAN LETTER KKATIBETAN LETTER RRATIBETAN VOWEL SIGN AATIBETAN VOWEL SIGN " +
	"ITIBETAN VOWEL SIGN IITIBETAN VOWEL SIGN UTIBETAN VOWEL SIGN UUTIBETAN V" +
	"OWEL SIGN VOCALIC RTIBETAN VOWEL SIGN VOCALIC RRTIBETAN VOWEL SIGN VOCAL" +
	"IC LTIBETAN VOWEL SIGN VOCALIC LLTIBETAN VOWEL SIGN ETIBETAN VOWEL SIGN " +
	"EETIBETAN VOWEL SIGN OTIBETAN VOWEL SIGN OOTIBETAN SIGN RJES SU NGA ROTI" +
	"BETAN SIGN RNAM BCADTIBETAN VOWEL SIGN REVERSED ITIBETAN VOWEL SIGN REVE" +
	"RSED IITIBETAN SIGN NYI ZLA NAA DATIBETAN SIGN SNA LDANTIBETAN MARK HALA" +
	"NTATIBETAN MARK PALUTATIBETAN SIGN LCI RTAGSTIBETAN SIGN YANG RTAGSTIBET" +
	"AN SIGN LCE TSA CANTIBETAN SIGN MCHU CANTIBETAN SIGN GRU CAN RGYINGSTIBE" +
	"TAN SIGN GRU MED RGYINGSTIBETAN SIGN INVERTED MCHU CANTIBETAN SUBJOINED " +
	"SIGN LCE TSA CANTIBETAN SUBJOINED SIGN MCHU CANTIBETAN SUBJOINED SIGN IN" +
	"VERTED MCHU CANTIBETAN SUBJOINED LETTER KATIBETAN SUBJOINED LETTER KHATI" +
	"BETAN SUBJOINED LETTER GATIBETAN SUBJOINED LETTER GHATIBETAN SUBJOINED L" +
	"ETTER NGATIBETAN SUBJOINED LETTER CATIBETAN SUBJOINED LETTER CHATIBETAN " +
	"SUBJOINED LETTER JATIBETAN SUBJOINED LETTER NYATIBETAN SUBJOINED LETTER " +
	"TTATIBETAN SUBJOINED LETTER TTHATIBETAN SUBJOINED LETTER DDATIBETAN SUBJ" +
	"OINED LETTER DDHATIBETAN SUBJOINED LETTER NNATIBETAN SUBJOINED LETTER TA" +
	"TIBETAN SUBJOINED LETTER THATIBETAN SUBJOINED LETTER DATIBETAN SUBJOINED" +
	" LETTER DHATIBETAN SUBJOINED LETTER NATIBETAN SUBJOINED LETTER PATIBETAN" +
	" SUBJOINED LETTER PHATIBETAN SUBJOINED LETTER BATIBETAN SUBJOINED LETTER" +
	" BHATIBETAN SUBJOINED LETTER MATIBETAN SUBJOINED LETTER TSATIBETAN SUBJO" +
	"INED LETTER TSHATIBETAN SUBJOINED LETTER DZATIBETAN SUBJOINED LETTER DZH" +
	"ATIBETAN SUBJOINED LETTER WATIBETAN SUBJOINED LETTER ZHATIBETAN SUBJOINE" +
	"D LETTER ZATIBETAN SUBJOINED LETTER -ATIBETAN SUBJOINED LETTER YATIBETAN" +
	" SUBJOINED LETTER RATIBETAN SUBJOINED LETTER LATIBETAN SUBJOINED LETTER " +
	"SHATIBETAN SUBJOINED LETTER SSATIBETAN SUBJOINED LETTER SATIBETAN SUBJOI" +
	"NED LETTER HATIBETAN SUBJOINED LETTER ATIBETAN SUBJOINED LETTER KSSATIBE" +
	"TAN SUBJOINED LETTER FIXED-FORM WATIBETAN SUBJOINED LETTER FIXED-FORM YA" +
	"TIBETAN SUBJOINED LETTER FIXED-FORM RATIBETAN KU RU KHATIBETAN KU RU KHA" +
	" BZHI MIG CANTIBETAN CANTILLATION SIGN HEAVY BEATTIBETAN CANTILLATION SI" +
	"GN LIGHT BEATTIBETAN CANTILLATION SIGN CANG TE-UTIBETAN CANTILLATION SIG" +
	"N SBUB -CHALTIBETAN SYMBOL DRIL BUTIBETAN SYMBOL RDO RJETIBETAN SYMBOL P" +
	"ADMA GDANTIBETAN SYMBOL RDO RJE RGYA GRAMTIBETAN SYMBOL PHUR PATIBETAN S" +
	"YMBOL NOR BUTIBETAN SYMBOL NOR BU NYIS -KHYILTIBETAN SYMBOL NOR BU GSUM " +
	"-KHYILTIBETAN SYMBOL NOR BU BZHI -KHYILTIBETAN SIGN RDEL NAG RDEL DKARTI" +
	"BETAN SIGN RDEL NAG GSUMTIBETAN MARK BSKA- SHOG GI MGO RGYANTIBETAN MARK" +
	" MNYAM YIG GI MGO RGYANTIBETAN MARK NYIS TSHEGTIBETAN MARK INITIAL BRDA " +
	"RNYING YIG MGO MDUN MATIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MARI" +
	"GHT-FACING SVASTI SIGNLEFT-FACING SVASTI SIGNRIGHT-FACING SVASTI SIGN WI" +
	"TH DOTSLEFT-FACING SVASTI SIGN WITH DOTSTIBETAN MARK LEADING MCHAN RTAGS" +
	"TIBETAN MARK TRAILING MCHAN RTAGSMYANMAR LETTER KAMYANMAR LETTER KHAMYAN" +
	"MAR LETTER GAMYANMAR LETTER GHAMYANMAR LETTER NGAMYANMAR LETTER CAMYANMA" +
	"R LETTER CHAMYANMAR LETTER JAMYANMAR LETTER JHAMYANMAR LETTER NYAMYANMAR") + ("" +
	" LETTER NNYAMYANMAR LETTER TTAMYANMAR LETTER TTHAMYANMAR LETTER DDAMYANM" +
	"AR LETTER DDHAMYANMAR LETTER NNAMYANMAR LETTER TAMYANMAR LETTER THAMYANM" +
	"AR LETTER DAMYANMAR LETTER DHAMYANMAR LETTER NAMYANMAR LETTER PAMYANMAR " +
	"LETTER PHAMYANMAR LETTER BAMYANMAR LETTER BHAMYANMAR LETTER MAMYANMAR LE" +
	"TTER YAMYANMAR LETTER RAMYANMAR LETTER LAMYANMAR LETTER WAMYANMAR LETTER" +
	" SAMYANMAR LETTER HAMYANMAR LETTER LLAMYANMAR LETTER AMYANMAR LETTER SHA" +
	"N AMYANMAR LETTER IMYANMAR LETTER IIMYANMAR LETTER UMYANMAR LETTER UUMYA" +
	"NMAR LETTER EMYANMAR LETTER MON EMYANMAR LETTER OMYANMAR LETTER AUMYANMA" +
	"R VOWEL SIGN TALL AAMYANMAR VOWEL SIGN AAMYANMAR VOWEL SIGN IMYANMAR VOW" +
	"EL SIGN IIMYANMAR VOWEL SIGN UMYANMAR VOWEL SIGN UUMYANMAR VOWEL SIGN EM" +
	"YANMAR VOWEL SIGN AIMYANMAR VOWEL SIGN MON IIMYANMAR VOWEL SIGN MON OMYA" +
	"NMAR VOWEL SIGN E ABOVEMYANMAR SIGN ANUSVARAMYANMAR SIGN DOT BELOWMYANMA" +
	"R SIGN VISARGAMYANMAR SIGN VIRAMAMYANMAR SIGN ASATMYANMAR CONSONANT SIGN" +
	" MEDIAL YAMYANMAR CONSONANT SIGN MEDIAL RAMYANMAR CONSONANT SIGN MEDIAL " +
	"WAMYANMAR CONSONANT SIGN MEDIAL HAMYANMAR LETTER GREAT SAMYANMAR DIGIT Z" +
	"EROMYANMAR DIGIT ONEMYANMAR DIGIT TWOMYANMAR DIGIT THREEMYANMAR DIGIT FO" +
	"URMYANMAR DIGIT FIVEMYANMAR DIGIT SIXMYANMAR DIGIT SEVENMYANMAR DIGIT EI" +
	"GHTMYANMAR DIGIT NINEMYANMAR SIGN LITTLE SECTIONMYANMAR SIGN SECTIONMYAN" +
	"MAR SYMBOL LOCATIVEMYANMAR SYMBOL COMPLETEDMYANMAR SYMBOL AFOREMENTIONED" +
	"MYANMAR SYMBOL GENITIVEMYANMAR LETTER SHAMYANMAR LETTER SSAMYANMAR LETTE" +
	"R VOCALIC RMYANMAR LETTER VOCALIC RRMYANMAR LETTER VOCALIC LMYANMAR LETT" +
	"ER VOCALIC LLMYANMAR VOWEL SIGN VOCALIC RMYANMAR VOWEL SIGN VOCALIC RRMY" +
	"ANMAR VOWEL SIGN VOCALIC LMYANMAR VOWEL SIGN VOCALIC LLMYANMAR LETTER MO" +
	"N NGAMYANMAR LETTER MON JHAMYANMAR LETTER MON BBAMYANMAR LETTER MON BBEM" +
	"YANMAR CONSONANT SIGN MON MEDIAL NAMYANMAR CONSONANT SIGN MON MEDIAL MAM" +
	"YANMAR CONSONANT SIGN MON MEDIAL LAMYANMAR LETTER SGAW KAREN SHAMYANMAR " +
	"VOWEL SIGN SGAW KAREN EUMYANMAR TONE MARK SGAW KAREN HATHIMYANMAR TONE M" +
	"ARK SGAW KAREN KE PHOMYANMAR LETTER WESTERN PWO KAREN THAMYANMAR LETTER " +
	"WESTERN PWO KAREN PWAMYANMAR VOWEL SIGN WESTERN PWO KAREN EUMYANMAR VOWE" +
	"L SIGN WESTERN PWO KAREN UEMYANMAR SIGN WESTERN PWO KAREN TONE-1MYANMAR " +
	"SIGN WESTERN PWO KAREN TONE-2MYANMAR SIGN WESTERN PWO KAREN TONE-3MYANMA" +
	"R SIGN WESTERN PWO KAREN TONE-4MYANMAR SIGN WESTERN PWO KAREN TONE-5MYAN" +
	"MAR LETTER EASTERN PWO KAREN NNAMYANMAR LETTER EASTERN PWO KAREN YWAMYAN" +
	"MAR LETTER EASTERN PWO KAREN GHWAMYANMAR VOWEL SIGN GEBA KAREN IMYANMAR " +
	"VOWEL SIGN KAYAH OEMYANMAR VOWEL SIGN KAYAH UMYANMAR VOWEL SIGN KAYAH EE" +
	"MYANMAR LETTER SHAN KAMYANMAR LETTER SHAN KHAMYANMAR LETTER SHAN GAMYANM" +
	"AR LETTER SHAN CAMYANMAR LETTER SHAN ZAMYANMAR LETTER SHAN NYAMYANMAR LE" +
	"TTER SHAN DAMYANMAR LETTER SHAN NAMYANMAR LETTER SHAN PHAMYANMAR LETTER " +
	"SHAN FAMYANMAR LETTER SHAN BAMYANMAR LETTER SHAN THAMYANMAR LETTER SHAN " +
	"HAMYANMAR CONSONANT SIGN SHAN MEDIAL WAMYANMAR VOWEL SIGN SHAN AAMYANMAR" +
	" VOWEL SIGN SHAN EMYANMAR VOWEL SIGN SHAN E ABOVEMYANMAR VOWEL SIGN SHAN" +
	" FINAL YMYANMAR SIGN SHAN TONE-2MYANMAR SIGN SHAN TONE-3MYANMAR SIGN SHA" +
	"N TONE-5MYANMAR SIGN SHAN TONE-6MYANMAR SIGN SHAN COUNCIL TONE-2MYANMAR " +
	"SIGN SHAN COUNCIL TONE-3MYANMAR SIGN SHAN COUNCIL EMPHATIC TONEMYANMAR L" +
	"ETTER RUMAI PALAUNG FAMYANMAR SIGN RUMAI PALAUNG TONE-5MYANMAR SHAN DIGI" +
	"T ZEROMYANMAR SHAN DIGIT ONEMYANMAR SHAN DIGIT TWOMYANMAR SHAN DIGIT THR" +
	"EEMYANMAR SHAN DIGIT FOURMYANMAR SHAN DIGIT FIVEMYANMAR SHAN DIGIT SIXMY" +
	"ANMAR SHAN DIGIT SEVENMYANMAR SHAN DIGIT EIGHTMYANMAR SHAN DIGIT NINEMYA" +
	"NMAR SIGN KHAMTI TONE-1MYANMAR SIGN KHAMTI TONE-3MYANMAR VOWEL SIGN AITO" +
	"N AMYANMAR VOWEL SIGN AITON AIMYANMAR SYMBOL SHAN ONEMYANMAR SYMBOL SHAN" +
	" EXCLAMATIONGEORGIAN CAPITAL LETTER ANGEORGIAN CAPITAL LETTER BANGEORGIA" +
	"N CAPITAL LETTER GANGEORGIAN CAPITAL LETTER DONGEORGIAN CAPITAL LETTER E" +
	"NGEORGIAN CAPITAL LETTER VINGEORGIAN CAPITAL LETTER ZENGEORGIAN CAPITAL " +
	"LETTER TANGEORGIAN CAPITAL LETTER INGEORGIAN CAPITAL LETTER KANGEORGIAN " +
	"CAPITAL LETTER LASGEORGIAN CAPITAL LETTER MANGEORGIAN CAPITAL LETTER NAR" +
	"GEORGIAN CAPITAL LETTER ONGEORGIAN CAPITAL LETTER PARGEORGIAN CAPITAL LE" +
	"TTER ZHARGEORGIAN CAPITAL LETTER RAEGEORGIAN CAPITAL LETTER SANGEORGIAN " +
	"CAPITAL LETTER TARGEORGIAN CAPITAL LETTER UNGEORGIAN CAPITAL LETTER PHAR" +
	"GEORGIAN CAPITAL LETTER KHARGEORGIAN CAPITAL LETTER GHANGEORGIAN CAPITAL" +
	" LETTER QARGEORGIAN CAPITAL LETTER SHINGEORGIAN CAPITAL LETTER CHINGEORG" +
	"IAN CAPITAL LETTER CANGEORGIAN CAPITAL LETTER JILGEORGIAN CAPITAL LETTER" +
	" CILGEORGIAN CAPITAL LETTER CHARGEORGIAN CAPITAL LETTER XANGEORGIAN CAPI" +
	"TAL LETTER JHANGEORGIAN CAPITAL LETTER HAEGEORGIAN CAPITAL LETTER HEGEOR" +
	"GIAN CAPITAL LETTER HIEGEORGIAN CAPITAL LETTER WEGEORGIAN CAPITAL LETTER") + ("" +
	" HARGEORGIAN CAPITAL LETTER HOEGEORGIAN CAPITAL LETTER YNGEORGIAN CAPITA" +
	"L LETTER AENGEORGIAN LETTER ANGEORGIAN LETTER BANGEORGIAN LETTER GANGEOR" +
	"GIAN LETTER DONGEORGIAN LETTER ENGEORGIAN LETTER VINGEORGIAN LETTER ZENG" +
	"EORGIAN LETTER TANGEORGIAN LETTER INGEORGIAN LETTER KANGEORGIAN LETTER L" +
	"ASGEORGIAN LETTER MANGEORGIAN LETTER NARGEORGIAN LETTER ONGEORGIAN LETTE" +
	"R PARGEORGIAN LETTER ZHARGEORGIAN LETTER RAEGEORGIAN LETTER SANGEORGIAN " +
	"LETTER TARGEORGIAN LETTER UNGEORGIAN LETTER PHARGEORGIAN LETTER KHARGEOR" +
	"GIAN LETTER GHANGEORGIAN LETTER QARGEORGIAN LETTER SHINGEORGIAN LETTER C" +
	"HINGEORGIAN LETTER CANGEORGIAN LETTER JILGEORGIAN LETTER CILGEORGIAN LET" +
	"TER CHARGEORGIAN LETTER XANGEORGIAN LETTER JHANGEORGIAN LETTER HAEGEORGI" +
	"AN LETTER HEGEORGIAN LETTER HIEGEORGIAN LETTER WEGEORGIAN LETTER HARGEOR" +
	"GIAN LETTER HOEGEORGIAN LETTER FIGEORGIAN LETTER YNGEORGIAN LETTER ELIFI" +
	"GEORGIAN LETTER TURNED GANGEORGIAN LETTER AINGEORGIAN PARAGRAPH SEPARATO" +
	"RMODIFIER LETTER GEORGIAN NARGEORGIAN LETTER AENGEORGIAN LETTER HARD SIG" +
	"NGEORGIAN LETTER LABIAL SIGNHANGUL CHOSEONG KIYEOKHANGUL CHOSEONG SSANGK" +
	"IYEOKHANGUL CHOSEONG NIEUNHANGUL CHOSEONG TIKEUTHANGUL CHOSEONG SSANGTIK" +
	"EUTHANGUL CHOSEONG RIEULHANGUL CHOSEONG MIEUMHANGUL CHOSEONG PIEUPHANGUL" +
	" CHOSEONG SSANGPIEUPHANGUL CHOSEONG SIOSHANGUL CHOSEONG SSANGSIOSHANGUL " +
	"CHOSEONG IEUNGHANGUL CHOSEONG CIEUCHANGUL CHOSEONG SSANGCIEUCHANGUL CHOS" +
	"EONG CHIEUCHHANGUL CHOSEONG KHIEUKHHANGUL CHOSEONG THIEUTHHANGUL CHOSEON" +
	"G PHIEUPHHANGUL CHOSEONG HIEUHHANGUL CHOSEONG NIEUN-KIYEOKHANGUL CHOSEON" +
	"G SSANGNIEUNHANGUL CHOSEONG NIEUN-TIKEUTHANGUL CHOSEONG NIEUN-PIEUPHANGU" +
	"L CHOSEONG TIKEUT-KIYEOKHANGUL CHOSEONG RIEUL-NIEUNHANGUL CHOSEONG SSANG" +
	"RIEULHANGUL CHOSEONG RIEUL-HIEUHHANGUL CHOSEONG KAPYEOUNRIEULHANGUL CHOS" +
	"EONG MIEUM-PIEUPHANGUL CHOSEONG KAPYEOUNMIEUMHANGUL CHOSEONG PIEUP-KIYEO" +
	"KHANGUL CHOSEONG PIEUP-NIEUNHANGUL CHOSEONG PIEUP-TIKEUTHANGUL CHOSEONG " +
	"PIEUP-SIOSHANGUL CHOSEONG PIEUP-SIOS-KIYEOKHANGUL CHOSEONG PIEUP-SIOS-TI" +
	"KEUTHANGUL CHOSEONG PIEUP-SIOS-PIEUPHANGUL CHOSEONG PIEUP-SSANGSIOSHANGU" +
	"L CHOSEONG PIEUP-SIOS-CIEUCHANGUL CHOSEONG PIEUP-CIEUCHANGUL CHOSEONG PI" +
	"EUP-CHIEUCHHANGUL CHOSEONG PIEUP-THIEUTHHANGUL CHOSEONG PIEUP-PHIEUPHHAN" +
	"GUL CHOSEONG KAPYEOUNPIEUPHANGUL CHOSEONG KAPYEOUNSSANGPIEUPHANGUL CHOSE" +
	"ONG SIOS-KIYEOKHANGUL CHOSEONG SIOS-NIEUNHANGUL CHOSEONG SIOS-TIKEUTHANG" +
	"UL CHOSEONG SIOS-RIEULHANGUL CHOSEONG SIOS-MIEUMHANGUL CHOSEONG SIOS-PIE" +
	"UPHANGUL CHOSEONG SIOS-PIEUP-KIYEOKHANGUL CHOSEONG SIOS-SSANGSIOSHANGUL " +
	"CHOSEONG SIOS-IEUNGHANGUL CHOSEONG SIOS-CIEUCHANGUL CHOSEONG SIOS-CHIEUC" +
	"HHANGUL CHOSEONG SIOS-KHIEUKHHANGUL CHOSEONG SIOS-THIEUTHHANGUL CHOSEONG" +
	" SIOS-PHIEUPHHANGUL CHOSEONG SIOS-HIEUHHANGUL CHOSEONG CHITUEUMSIOSHANGU" +
	"L CHOSEONG CHITUEUMSSANGSIOSHANGUL CHOSEONG CEONGCHIEUMSIOSHANGUL CHOSEO" +
	"NG CEONGCHIEUMSSANGSIOSHANGUL CHOSEONG PANSIOSHANGUL CHOSEONG IEUNG-KIYE" +
	"OKHANGUL CHOSEONG IEUNG-TIKEUTHANGUL CHOSEONG IEUNG-MIEUMHANGUL CHOSEONG" +
	" IEUNG-PIEUPHANGUL CHOSEONG IEUNG-SIOSHANGUL CHOSEONG IEUNG-PANSIOSHANGU" +
	"L CHOSEONG SSANGIEUNGHANGUL CHOSEONG IEUNG-CIEUCHANGUL CHOSEONG IEUNG-CH" +
	"IEUCHHANGUL CHOSEONG IEUNG-THIEUTHHANGUL CHOSEONG IEUNG-PHIEUPHHANGUL CH" +
	"OSEONG YESIEUNGHANGUL CHOSEONG CIEUC-IEUNGHANGUL CHOSEONG CHITUEUMCIEUCH" +
	"ANGUL CHOSEONG CHITUEUMSSANGCIEUCHANGUL CHOSEONG CEONGCHIEUMCIEUCHANGUL " +
	"CHOSEONG CEONGCHIEUMSSANGCIEUCHANGUL CHOSEONG CHIEUCH-KHIEUKHHANGUL CHOS" +
	"EONG CHIEUCH-HIEUHHANGUL CHOSEONG CHITUEUMCHIEUCHHANGUL CHOSEONG CEONGCH" +
	"IEUMCHIEUCHHANGUL CHOSEONG PHIEUPH-PIEUPHANGUL CHOSEONG KAPYEOUNPHIEUPHH" +
	"ANGUL CHOSEONG SSANGHIEUHHANGUL CHOSEONG YEORINHIEUHHANGUL CHOSEONG KIYE" +
	"OK-TIKEUTHANGUL CHOSEONG NIEUN-SIOSHANGUL CHOSEONG NIEUN-CIEUCHANGUL CHO" +
	"SEONG NIEUN-HIEUHHANGUL CHOSEONG TIKEUT-RIEULHANGUL CHOSEONG FILLERHANGU" +
	"L JUNGSEONG FILLERHANGUL JUNGSEONG AHANGUL JUNGSEONG AEHANGUL JUNGSEONG " +
	"YAHANGUL JUNGSEONG YAEHANGUL JUNGSEONG EOHANGUL JUNGSEONG EHANGUL JUNGSE" +
	"ONG YEOHANGUL JUNGSEONG YEHANGUL JUNGSEONG OHANGUL JUNGSEONG WAHANGUL JU" +
	"NGSEONG WAEHANGUL JUNGSEONG OEHANGUL JUNGSEONG YOHANGUL JUNGSEONG UHANGU" +
	"L JUNGSEONG WEOHANGUL JUNGSEONG WEHANGUL JUNGSEONG WIHANGUL JUNGSEONG YU" +
	"HANGUL JUNGSEONG EUHANGUL JUNGSEONG YIHANGUL JUNGSEONG IHANGUL JUNGSEONG" +
	" A-OHANGUL JUNGSEONG A-UHANGUL JUNGSEONG YA-OHANGUL JUNGSEONG YA-YOHANGU" +
	"L JUNGSEONG EO-OHANGUL JUNGSEONG EO-UHANGUL JUNGSEONG EO-EUHANGUL JUNGSE" +
	"ONG YEO-OHANGUL JUNGSEONG YEO-UHANGUL JUNGSEONG O-EOHANGUL JUNGSEONG O-E" +
	"HANGUL JUNGSEONG O-YEHANGUL JUNGSEONG O-OHANGUL JUNGSEONG O-UHANGUL JUNG" +
	"SEONG YO-YAHANGUL JUNGSEONG YO-YAEHANGUL JUNGSEONG YO-YEOHANGUL JUNGSEON" +
	"G YO-OHANGUL JUNGSEONG YO-IHANGUL JUNGSEONG U-AHANGUL JUNGSEONG U-AEHANG" +
	"UL JUNGSEONG U-EO-EUHANGUL JUNGSEONG U-YEHANGUL JUNGSEONG U-UHANGUL JUNG") + ("" +
	"SEONG YU-AHANGUL JUNGSEONG YU-EOHANGUL JUNGSEONG YU-EHANGUL JUNGSEONG YU" +
	"-YEOHANGUL JUNGSEONG YU-YEHANGUL JUNGSEONG YU-UHANGUL JUNGSEONG YU-IHANG" +
	"UL JUNGSEONG EU-UHANGUL JUNGSEONG EU-EUHANGUL JUNGSEONG YI-UHANGUL JUNGS" +
	"EONG I-AHANGUL JUNGSEONG I-YAHANGUL JUNGSEONG I-OHANGUL JUNGSEONG I-UHAN" +
	"GUL JUNGSEONG I-EUHANGUL JUNGSEONG I-ARAEAHANGUL JUNGSEONG ARAEAHANGUL J" +
	"UNGSEONG ARAEA-EOHANGUL JUNGSEONG ARAEA-UHANGUL JUNGSEONG ARAEA-IHANGUL " +
	"JUNGSEONG SSANGARAEAHANGUL JUNGSEONG A-EUHANGUL JUNGSEONG YA-UHANGUL JUN" +
	"GSEONG YEO-YAHANGUL JUNGSEONG O-YAHANGUL JUNGSEONG O-YAEHANGUL JONGSEONG" +
	" KIYEOKHANGUL JONGSEONG SSANGKIYEOKHANGUL JONGSEONG KIYEOK-SIOSHANGUL JO" +
	"NGSEONG NIEUNHANGUL JONGSEONG NIEUN-CIEUCHANGUL JONGSEONG NIEUN-HIEUHHAN" +
	"GUL JONGSEONG TIKEUTHANGUL JONGSEONG RIEULHANGUL JONGSEONG RIEUL-KIYEOKH" +
	"ANGUL JONGSEONG RIEUL-MIEUMHANGUL JONGSEONG RIEUL-PIEUPHANGUL JONGSEONG " +
	"RIEUL-SIOSHANGUL JONGSEONG RIEUL-THIEUTHHANGUL JONGSEONG RIEUL-PHIEUPHHA" +
	"NGUL JONGSEONG RIEUL-HIEUHHANGUL JONGSEONG MIEUMHANGUL JONGSEONG PIEUPHA" +
	"NGUL JONGSEONG PIEUP-SIOSHANGUL JONGSEONG SIOSHANGUL JONGSEONG SSANGSIOS" +
	"HANGUL JONGSEONG IEUNGHANGUL JONGSEONG CIEUCHANGUL JONGSEONG CHIEUCHHANG" +
	"UL JONGSEONG KHIEUKHHANGUL JONGSEONG THIEUTHHANGUL JONGSEONG PHIEUPHHANG" +
	"UL JONGSEONG HIEUHHANGUL JONGSEONG KIYEOK-RIEULHANGUL JONGSEONG KIYEOK-S" +
	"IOS-KIYEOKHANGUL JONGSEONG NIEUN-KIYEOKHANGUL JONGSEONG NIEUN-TIKEUTHANG" +
	"UL JONGSEONG NIEUN-SIOSHANGUL JONGSEONG NIEUN-PANSIOSHANGUL JONGSEONG NI" +
	"EUN-THIEUTHHANGUL JONGSEONG TIKEUT-KIYEOKHANGUL JONGSEONG TIKEUT-RIEULHA" +
	"NGUL JONGSEONG RIEUL-KIYEOK-SIOSHANGUL JONGSEONG RIEUL-NIEUNHANGUL JONGS" +
	"EONG RIEUL-TIKEUTHANGUL JONGSEONG RIEUL-TIKEUT-HIEUHHANGUL JONGSEONG SSA" +
	"NGRIEULHANGUL JONGSEONG RIEUL-MIEUM-KIYEOKHANGUL JONGSEONG RIEUL-MIEUM-S" +
	"IOSHANGUL JONGSEONG RIEUL-PIEUP-SIOSHANGUL JONGSEONG RIEUL-PIEUP-HIEUHHA" +
	"NGUL JONGSEONG RIEUL-KAPYEOUNPIEUPHANGUL JONGSEONG RIEUL-SSANGSIOSHANGUL" +
	" JONGSEONG RIEUL-PANSIOSHANGUL JONGSEONG RIEUL-KHIEUKHHANGUL JONGSEONG R" +
	"IEUL-YEORINHIEUHHANGUL JONGSEONG MIEUM-KIYEOKHANGUL JONGSEONG MIEUM-RIEU" +
	"LHANGUL JONGSEONG MIEUM-PIEUPHANGUL JONGSEONG MIEUM-SIOSHANGUL JONGSEONG" +
	" MIEUM-SSANGSIOSHANGUL JONGSEONG MIEUM-PANSIOSHANGUL JONGSEONG MIEUM-CHI" +
	"EUCHHANGUL JONGSEONG MIEUM-HIEUHHANGUL JONGSEONG KAPYEOUNMIEUMHANGUL JON" +
	"GSEONG PIEUP-RIEULHANGUL JONGSEONG PIEUP-PHIEUPHHANGUL JONGSEONG PIEUP-H" +
	"IEUHHANGUL JONGSEONG KAPYEOUNPIEUPHANGUL JONGSEONG SIOS-KIYEOKHANGUL JON" +
	"GSEONG SIOS-TIKEUTHANGUL JONGSEONG SIOS-RIEULHANGUL JONGSEONG SIOS-PIEUP" +
	"HANGUL JONGSEONG PANSIOSHANGUL JONGSEONG IEUNG-KIYEOKHANGUL JONGSEONG IE" +
	"UNG-SSANGKIYEOKHANGUL JONGSEONG SSANGIEUNGHANGUL JONGSEONG IEUNG-KHIEUKH" +
	"HANGUL JONGSEONG YESIEUNGHANGUL JONGSEONG YESIEUNG-SIOSHANGUL JONGSEONG " +
	"YESIEUNG-PANSIOSHANGUL JONGSEONG PHIEUPH-PIEUPHANGUL JONGSEONG KAPYEOUNP" +
	"HIEUPHHANGUL JONGSEONG HIEUH-NIEUNHANGUL JONGSEONG HIEUH-RIEULHANGUL JON" +
	"GSEONG HIEUH-MIEUMHANGUL JONGSEONG HIEUH-PIEUPHANGUL JONGSEONG YEORINHIE" +
	"UHHANGUL JONGSEONG KIYEOK-NIEUNHANGUL JONGSEONG KIYEOK-PIEUPHANGUL JONGS" +
	"EONG KIYEOK-CHIEUCHHANGUL JONGSEONG KIYEOK-KHIEUKHHANGUL JONGSEONG KIYEO" +
	"K-HIEUHHANGUL JONGSEONG SSANGNIEUNETHIOPIC SYLLABLE HAETHIOPIC SYLLABLE " +
	"HUETHIOPIC SYLLABLE HIETHIOPIC SYLLABLE HAAETHIOPIC SYLLABLE HEEETHIOPIC" +
	" SYLLABLE HEETHIOPIC SYLLABLE HOETHIOPIC SYLLABLE HOAETHIOPIC SYLLABLE L" +
	"AETHIOPIC SYLLABLE LUETHIOPIC SYLLABLE LIETHIOPIC SYLLABLE LAAETHIOPIC S" +
	"YLLABLE LEEETHIOPIC SYLLABLE LEETHIOPIC SYLLABLE LOETHIOPIC SYLLABLE LWA" +
	"ETHIOPIC SYLLABLE HHAETHIOPIC SYLLABLE HHUETHIOPIC SYLLABLE HHIETHIOPIC " +
	"SYLLABLE HHAAETHIOPIC SYLLABLE HHEEETHIOPIC SYLLABLE HHEETHIOPIC SYLLABL" +
	"E HHOETHIOPIC SYLLABLE HHWAETHIOPIC SYLLABLE MAETHIOPIC SYLLABLE MUETHIO" +
	"PIC SYLLABLE MIETHIOPIC SYLLABLE MAAETHIOPIC SYLLABLE MEEETHIOPIC SYLLAB" +
	"LE MEETHIOPIC SYLLABLE MOETHIOPIC SYLLABLE MWAETHIOPIC SYLLABLE SZAETHIO" +
	"PIC SYLLABLE SZUETHIOPIC SYLLABLE SZIETHIOPIC SYLLABLE SZAAETHIOPIC SYLL" +
	"ABLE SZEEETHIOPIC SYLLABLE SZEETHIOPIC SYLLABLE SZOETHIOPIC SYLLABLE SZW" +
	"AETHIOPIC SYLLABLE RAETHIOPIC SYLLABLE RUETHIOPIC SYLLABLE RIETHIOPIC SY" +
	"LLABLE RAAETHIOPIC SYLLABLE REEETHIOPIC SYLLABLE REETHIOPIC SYLLABLE ROE" +
	"THIOPIC SYLLABLE RWAETHIOPIC SYLLABLE SAETHIOPIC SYLLABLE SUETHIOPIC SYL" +
	"LABLE SIETHIOPIC SYLLABLE SAAETHIOPIC SYLLABLE SEEETHIOPIC SYLLABLE SEET" +
	"HIOPIC SYLLABLE SOETHIOPIC SYLLABLE SWAETHIOPIC SYLLABLE SHAETHIOPIC SYL" +
	"LABLE SHUETHIOPIC SYLLABLE SHIETHIOPIC SYLLABLE SHAAETHIOPIC SYLLABLE SH" +
	"EEETHIOPIC SYLLABLE SHEETHIOPIC SYLLABLE SHOETHIOPIC SYLLABLE SHWAETHIOP" +
	"IC SYLLABLE QAETHIOPIC SYLLABLE QUETHIOPIC SYLLABLE QIETHIOPIC SYLLABLE " +
	"QAAETHIOPIC SYLLABLE QEEETHIOPIC SYLLABLE QEETHIOPIC SYLLABLE QOETHIOPIC" +
	" SYLLABLE QOAETHIOPIC SYLLABLE QWAETHIOPIC SYLLABLE QWIETHIOPIC SYLLABLE") + ("" +
	" QWAAETHIOPIC SYLLABLE QWEEETHIOPIC SYLLABLE QWEETHIOPIC SYLLABLE QHAETH" +
	"IOPIC SYLLABLE QHUETHIOPIC SYLLABLE QHIETHIOPIC SYLLABLE QHAAETHIOPIC SY" +
	"LLABLE QHEEETHIOPIC SYLLABLE QHEETHIOPIC SYLLABLE QHOETHIOPIC SYLLABLE Q" +
	"HWAETHIOPIC SYLLABLE QHWIETHIOPIC SYLLABLE QHWAAETHIOPIC SYLLABLE QHWEEE" +
	"THIOPIC SYLLABLE QHWEETHIOPIC SYLLABLE BAETHIOPIC SYLLABLE BUETHIOPIC SY" +
	"LLABLE BIETHIOPIC SYLLABLE BAAETHIOPIC SYLLABLE BEEETHIOPIC SYLLABLE BEE" +
	"THIOPIC SYLLABLE BOETHIOPIC SYLLABLE BWAETHIOPIC SYLLABLE VAETHIOPIC SYL" +
	"LABLE VUETHIOPIC SYLLABLE VIETHIOPIC SYLLABLE VAAETHIOPIC SYLLABLE VEEET" +
	"HIOPIC SYLLABLE VEETHIOPIC SYLLABLE VOETHIOPIC SYLLABLE VWAETHIOPIC SYLL" +
	"ABLE TAETHIOPIC SYLLABLE TUETHIOPIC SYLLABLE TIETHIOPIC SYLLABLE TAAETHI" +
	"OPIC SYLLABLE TEEETHIOPIC SYLLABLE TEETHIOPIC SYLLABLE TOETHIOPIC SYLLAB" +
	"LE TWAETHIOPIC SYLLABLE CAETHIOPIC SYLLABLE CUETHIOPIC SYLLABLE CIETHIOP" +
	"IC SYLLABLE CAAETHIOPIC SYLLABLE CEEETHIOPIC SYLLABLE CEETHIOPIC SYLLABL" +
	"E COETHIOPIC SYLLABLE CWAETHIOPIC SYLLABLE XAETHIOPIC SYLLABLE XUETHIOPI" +
	"C SYLLABLE XIETHIOPIC SYLLABLE XAAETHIOPIC SYLLABLE XEEETHIOPIC SYLLABLE" +
	" XEETHIOPIC SYLLABLE XOETHIOPIC SYLLABLE XOAETHIOPIC SYLLABLE XWAETHIOPI" +
	"C SYLLABLE XWIETHIOPIC SYLLABLE XWAAETHIOPIC SYLLABLE XWEEETHIOPIC SYLLA" +
	"BLE XWEETHIOPIC SYLLABLE NAETHIOPIC SYLLABLE NUETHIOPIC SYLLABLE NIETHIO" +
	"PIC SYLLABLE NAAETHIOPIC SYLLABLE NEEETHIOPIC SYLLABLE NEETHIOPIC SYLLAB" +
	"LE NOETHIOPIC SYLLABLE NWAETHIOPIC SYLLABLE NYAETHIOPIC SYLLABLE NYUETHI" +
	"OPIC SYLLABLE NYIETHIOPIC SYLLABLE NYAAETHIOPIC SYLLABLE NYEEETHIOPIC SY" +
	"LLABLE NYEETHIOPIC SYLLABLE NYOETHIOPIC SYLLABLE NYWAETHIOPIC SYLLABLE G" +
	"LOTTAL AETHIOPIC SYLLABLE GLOTTAL UETHIOPIC SYLLABLE GLOTTAL IETHIOPIC S" +
	"YLLABLE GLOTTAL AAETHIOPIC SYLLABLE GLOTTAL EEETHIOPIC SYLLABLE GLOTTAL " +
	"EETHIOPIC SYLLABLE GLOTTAL OETHIOPIC SYLLABLE GLOTTAL WAETHIOPIC SYLLABL" +
	"E KAETHIOPIC SYLLABLE KUETHIOPIC SYLLABLE KIETHIOPIC SYLLABLE KAAETHIOPI" +
	"C SYLLABLE KEEETHIOPIC SYLLABLE KEETHIOPIC SYLLABLE KOETHIOPIC SYLLABLE " +
	"KOAETHIOPIC SYLLABLE KWAETHIOPIC SYLLABLE KWIETHIOPIC SYLLABLE KWAAETHIO" +
	"PIC SYLLABLE KWEEETHIOPIC SYLLABLE KWEETHIOPIC SYLLABLE KXAETHIOPIC SYLL" +
	"ABLE KXUETHIOPIC SYLLABLE KXIETHIOPIC SYLLABLE KXAAETHIOPIC SYLLABLE KXE" +
	"EETHIOPIC SYLLABLE KXEETHIOPIC SYLLABLE KXOETHIOPIC SYLLABLE KXWAETHIOPI" +
	"C SYLLABLE KXWIETHIOPIC SYLLABLE KXWAAETHIOPIC SYLLABLE KXWEEETHIOPIC SY" +
	"LLABLE KXWEETHIOPIC SYLLABLE WAETHIOPIC SYLLABLE WUETHIOPIC SYLLABLE WIE" +
	"THIOPIC SYLLABLE WAAETHIOPIC SYLLABLE WEEETHIOPIC SYLLABLE WEETHIOPIC SY" +
	"LLABLE WOETHIOPIC SYLLABLE WOAETHIOPIC SYLLABLE PHARYNGEAL AETHIOPIC SYL" +
	"LABLE PHARYNGEAL UETHIOPIC SYLLABLE PHARYNGEAL IETHIOPIC SYLLABLE PHARYN" +
	"GEAL AAETHIOPIC SYLLABLE PHARYNGEAL EEETHIOPIC SYLLABLE PHARYNGEAL EETHI" +
	"OPIC SYLLABLE PHARYNGEAL OETHIOPIC SYLLABLE ZAETHIOPIC SYLLABLE ZUETHIOP" +
	"IC SYLLABLE ZIETHIOPIC SYLLABLE ZAAETHIOPIC SYLLABLE ZEEETHIOPIC SYLLABL" +
	"E ZEETHIOPIC SYLLABLE ZOETHIOPIC SYLLABLE ZWAETHIOPIC SYLLABLE ZHAETHIOP" +
	"IC SYLLABLE ZHUETHIOPIC SYLLABLE ZHIETHIOPIC SYLLABLE ZHAAETHIOPIC SYLLA" +
	"BLE ZHEEETHIOPIC SYLLABLE ZHEETHIOPIC SYLLABLE ZHOETHIOPIC SYLLABLE ZHWA" +
	"ETHIOPIC SYLLABLE YAETHIOPIC SYLLABLE YUETHIOPIC SYLLABLE YIETHIOPIC SYL" +
	"LABLE YAAETHIOPIC SYLLABLE YEEETHIOPIC SYLLABLE YEETHIOPIC SYLLABLE YOET" +
	"HIOPIC SYLLABLE YOAETHIOPIC SYLLABLE DAETHIOPIC SYLLABLE DUETHIOPIC SYLL" +
	"ABLE DIETHIOPIC SYLLABLE DAAETHIOPIC SYLLABLE DEEETHIOPIC SYLLABLE DEETH" +
	"IOPIC SYLLABLE DOETHIOPIC SYLLABLE DWAETHIOPIC SYLLABLE DDAETHIOPIC SYLL" +
	"ABLE DDUETHIOPIC SYLLABLE DDIETHIOPIC SYLLABLE DDAAETHIOPIC SYLLABLE DDE" +
	"EETHIOPIC SYLLABLE DDEETHIOPIC SYLLABLE DDOETHIOPIC SYLLABLE DDWAETHIOPI" +
	"C SYLLABLE JAETHIOPIC SYLLABLE JUETHIOPIC SYLLABLE JIETHIOPIC SYLLABLE J" +
	"AAETHIOPIC SYLLABLE JEEETHIOPIC SYLLABLE JEETHIOPIC SYLLABLE JOETHIOPIC " +
	"SYLLABLE JWAETHIOPIC SYLLABLE GAETHIOPIC SYLLABLE GUETHIOPIC SYLLABLE GI" +
	"ETHIOPIC SYLLABLE GAAETHIOPIC SYLLABLE GEEETHIOPIC SYLLABLE GEETHIOPIC S" +
	"YLLABLE GOETHIOPIC SYLLABLE GOAETHIOPIC SYLLABLE GWAETHIOPIC SYLLABLE GW" +
	"IETHIOPIC SYLLABLE GWAAETHIOPIC SYLLABLE GWEEETHIOPIC SYLLABLE GWEETHIOP" +
	"IC SYLLABLE GGAETHIOPIC SYLLABLE GGUETHIOPIC SYLLABLE GGIETHIOPIC SYLLAB" +
	"LE GGAAETHIOPIC SYLLABLE GGEEETHIOPIC SYLLABLE GGEETHIOPIC SYLLABLE GGOE" +
	"THIOPIC SYLLABLE GGWAAETHIOPIC SYLLABLE THAETHIOPIC SYLLABLE THUETHIOPIC" +
	" SYLLABLE THIETHIOPIC SYLLABLE THAAETHIOPIC SYLLABLE THEEETHIOPIC SYLLAB" +
	"LE THEETHIOPIC SYLLABLE THOETHIOPIC SYLLABLE THWAETHIOPIC SYLLABLE CHAET" +
	"HIOPIC SYLLABLE CHUETHIOPIC SYLLABLE CHIETHIOPIC SYLLABLE CHAAETHIOPIC S" +
	"YLLABLE CHEEETHIOPIC SYLLABLE CHEETHIOPIC SYLLABLE CHOETHIOPIC SYLLABLE " +
	"CHWAETHIOPIC SYLLABLE PHAETHIOPIC SYLLABLE PHUETHIOPIC SYLLABLE PHIETHIO" +
	"PIC SYLLABLE PHAAETHIOPIC SYLLABLE PHEEETHIOPIC SYLLABLE PHEETHIOPIC SYL") + ("" +
	"LABLE PHOETHIOPIC SYLLABLE PHWAETHIOPIC SYLLABLE TSAETHIOPIC SYLLABLE TS" +
	"UETHIOPIC SYLLABLE TSIETHIOPIC SYLLABLE TSAAETHIOPIC SYLLABLE TSEEETHIOP" +
	"IC SYLLABLE TSEETHIOPIC SYLLABLE TSOETHIOPIC SYLLABLE TSWAETHIOPIC SYLLA" +
	"BLE TZAETHIOPIC SYLLABLE TZUETHIOPIC SYLLABLE TZIETHIOPIC SYLLABLE TZAAE" +
	"THIOPIC SYLLABLE TZEEETHIOPIC SYLLABLE TZEETHIOPIC SYLLABLE TZOETHIOPIC " +
	"SYLLABLE TZOAETHIOPIC SYLLABLE FAETHIOPIC SYLLABLE FUETHIOPIC SYLLABLE F" +
	"IETHIOPIC SYLLABLE FAAETHIOPIC SYLLABLE FEEETHIOPIC SYLLABLE FEETHIOPIC " +
	"SYLLABLE FOETHIOPIC SYLLABLE FWAETHIOPIC SYLLABLE PAETHIOPIC SYLLABLE PU" +
	"ETHIOPIC SYLLABLE PIETHIOPIC SYLLABLE PAAETHIOPIC SYLLABLE PEEETHIOPIC S" +
	"YLLABLE PEETHIOPIC SYLLABLE POETHIOPIC SYLLABLE PWAETHIOPIC SYLLABLE RYA" +
	"ETHIOPIC SYLLABLE MYAETHIOPIC SYLLABLE FYAETHIOPIC COMBINING GEMINATION " +
	"AND VOWEL LENGTH MARKETHIOPIC COMBINING VOWEL LENGTH MARKETHIOPIC COMBIN" +
	"ING GEMINATION MARKETHIOPIC SECTION MARKETHIOPIC WORDSPACEETHIOPIC FULL " +
	"STOPETHIOPIC COMMAETHIOPIC SEMICOLONETHIOPIC COLONETHIOPIC PREFACE COLON" +
	"ETHIOPIC QUESTION MARKETHIOPIC PARAGRAPH SEPARATORETHIOPIC DIGIT ONEETHI" +
	"OPIC DIGIT TWOETHIOPIC DIGIT THREEETHIOPIC DIGIT FOURETHIOPIC DIGIT FIVE" +
	"ETHIOPIC DIGIT SIXETHIOPIC DIGIT SEVENETHIOPIC DIGIT EIGHTETHIOPIC DIGIT" +
	" NINEETHIOPIC NUMBER TENETHIOPIC NUMBER TWENTYETHIOPIC NUMBER THIRTYETHI" +
	"OPIC NUMBER FORTYETHIOPIC NUMBER FIFTYETHIOPIC NUMBER SIXTYETHIOPIC NUMB" +
	"ER SEVENTYETHIOPIC NUMBER EIGHTYETHIOPIC NUMBER NINETYETHIOPIC NUMBER HU" +
	"NDREDETHIOPIC NUMBER TEN THOUSANDETHIOPIC SYLLABLE SEBATBEIT MWAETHIOPIC" +
	" SYLLABLE MWIETHIOPIC SYLLABLE MWEEETHIOPIC SYLLABLE MWEETHIOPIC SYLLABL" +
	"E SEBATBEIT BWAETHIOPIC SYLLABLE BWIETHIOPIC SYLLABLE BWEEETHIOPIC SYLLA" +
	"BLE BWEETHIOPIC SYLLABLE SEBATBEIT FWAETHIOPIC SYLLABLE FWIETHIOPIC SYLL" +
	"ABLE FWEEETHIOPIC SYLLABLE FWEETHIOPIC SYLLABLE SEBATBEIT PWAETHIOPIC SY" +
	"LLABLE PWIETHIOPIC SYLLABLE PWEEETHIOPIC SYLLABLE PWEETHIOPIC TONAL MARK" +
	" YIZETETHIOPIC TONAL MARK DERETETHIOPIC TONAL MARK RIKRIKETHIOPIC TONAL " +
	"MARK SHORT RIKRIKETHIOPIC TONAL MARK DIFATETHIOPIC TONAL MARK KENATETHIO" +
	"PIC TONAL MARK CHIRETETHIOPIC TONAL MARK HIDETETHIOPIC TONAL MARK DERET-" +
	"HIDETETHIOPIC TONAL MARK KURTCHEROKEE LETTER ACHEROKEE LETTER ECHEROKEE " +
	"LETTER ICHEROKEE LETTER OCHEROKEE LETTER UCHEROKEE LETTER VCHEROKEE LETT" +
	"ER GACHEROKEE LETTER KACHEROKEE LETTER GECHEROKEE LETTER GICHEROKEE LETT" +
	"ER GOCHEROKEE LETTER GUCHEROKEE LETTER GVCHEROKEE LETTER HACHEROKEE LETT" +
	"ER HECHEROKEE LETTER HICHEROKEE LETTER HOCHEROKEE LETTER HUCHEROKEE LETT" +
	"ER HVCHEROKEE LETTER LACHEROKEE LETTER LECHEROKEE LETTER LICHEROKEE LETT" +
	"ER LOCHEROKEE LETTER LUCHEROKEE LETTER LVCHEROKEE LETTER MACHEROKEE LETT" +
	"ER MECHEROKEE LETTER MICHEROKEE LETTER MOCHEROKEE LETTER MUCHEROKEE LETT" +
	"ER NACHEROKEE LETTER HNACHEROKEE LETTER NAHCHEROKEE LETTER NECHEROKEE LE" +
	"TTER NICHEROKEE LETTER NOCHEROKEE LETTER NUCHEROKEE LETTER NVCHEROKEE LE" +
	"TTER QUACHEROKEE LETTER QUECHEROKEE LETTER QUICHEROKEE LETTER QUOCHEROKE" +
	"E LETTER QUUCHEROKEE LETTER QUVCHEROKEE LETTER SACHEROKEE LETTER SCHEROK" +
	"EE LETTER SECHEROKEE LETTER SICHEROKEE LETTER SOCHEROKEE LETTER SUCHEROK" +
	"EE LETTER SVCHEROKEE LETTER DACHEROKEE LETTER TACHEROKEE LETTER DECHEROK" +
	"EE LETTER TECHEROKEE LETTER DICHEROKEE LETTER TICHEROKEE LETTER DOCHEROK" +
	"EE LETTER DUCHEROKEE LETTER DVCHEROKEE LETTER DLACHEROKEE LETTER TLACHER" +
	"OKEE LETTER TLECHEROKEE LETTER TLICHEROKEE LETTER TLOCHEROKEE LETTER TLU" +
	"CHEROKEE LETTER TLVCHEROKEE LETTER TSACHEROKEE LETTER TSECHEROKEE LETTER" +
	" TSICHEROKEE LETTER TSOCHEROKEE LETTER TSUCHEROKEE LETTER TSVCHEROKEE LE" +
	"TTER WACHEROKEE LETTER WECHEROKEE LETTER WICHEROKEE LETTER WOCHEROKEE LE" +
	"TTER WUCHEROKEE LETTER WVCHEROKEE LETTER YACHEROKEE LETTER YECHEROKEE LE" +
	"TTER YICHEROKEE LETTER YOCHEROKEE LETTER YUCHEROKEE LETTER YVCHEROKEE LE" +
	"TTER MVCHEROKEE SMALL LETTER YECHEROKEE SMALL LETTER YICHEROKEE SMALL LE" +
	"TTER YOCHEROKEE SMALL LETTER YUCHEROKEE SMALL LETTER YVCHEROKEE SMALL LE" +
	"TTER MVCANADIAN SYLLABICS HYPHENCANADIAN SYLLABICS ECANADIAN SYLLABICS A" +
	"AICANADIAN SYLLABICS ICANADIAN SYLLABICS IICANADIAN SYLLABICS OCANADIAN " +
	"SYLLABICS OOCANADIAN SYLLABICS Y-CREE OOCANADIAN SYLLABICS CARRIER EECAN" +
	"ADIAN SYLLABICS CARRIER ICANADIAN SYLLABICS ACANADIAN SYLLABICS AACANADI" +
	"AN SYLLABICS WECANADIAN SYLLABICS WEST-CREE WECANADIAN SYLLABICS WICANAD" +
	"IAN SYLLABICS WEST-CREE WICANADIAN SYLLABICS WIICANADIAN SYLLABICS WEST-" +
	"CREE WIICANADIAN SYLLABICS WOCANADIAN SYLLABICS WEST-CREE WOCANADIAN SYL" +
	"LABICS WOOCANADIAN SYLLABICS WEST-CREE WOOCANADIAN SYLLABICS NASKAPI WOO" +
	"CANADIAN SYLLABICS WACANADIAN SYLLABICS WEST-CREE WACANADIAN SYLLABICS W" +
	"AACANADIAN SYLLABICS WEST-CREE WAACANADIAN SYLLABICS NASKAPI WAACANADIAN" +
	" SYLLABICS AICANADIAN SYLLABICS Y-CREE WCANADIAN SYLLABICS GLOTTAL STOPC") + ("" +
	"ANADIAN SYLLABICS FINAL ACUTECANADIAN SYLLABICS FINAL GRAVECANADIAN SYLL" +
	"ABICS FINAL BOTTOM HALF RINGCANADIAN SYLLABICS FINAL TOP HALF RINGCANADI" +
	"AN SYLLABICS FINAL RIGHT HALF RINGCANADIAN SYLLABICS FINAL RINGCANADIAN " +
	"SYLLABICS FINAL DOUBLE ACUTECANADIAN SYLLABICS FINAL DOUBLE SHORT VERTIC" +
	"AL STROKESCANADIAN SYLLABICS FINAL MIDDLE DOTCANADIAN SYLLABICS FINAL SH" +
	"ORT HORIZONTAL STROKECANADIAN SYLLABICS FINAL PLUSCANADIAN SYLLABICS FIN" +
	"AL DOWN TACKCANADIAN SYLLABICS ENCANADIAN SYLLABICS INCANADIAN SYLLABICS" +
	" ONCANADIAN SYLLABICS ANCANADIAN SYLLABICS PECANADIAN SYLLABICS PAAICANA" +
	"DIAN SYLLABICS PICANADIAN SYLLABICS PIICANADIAN SYLLABICS POCANADIAN SYL" +
	"LABICS POOCANADIAN SYLLABICS Y-CREE POOCANADIAN SYLLABICS CARRIER HEECAN" +
	"ADIAN SYLLABICS CARRIER HICANADIAN SYLLABICS PACANADIAN SYLLABICS PAACAN" +
	"ADIAN SYLLABICS PWECANADIAN SYLLABICS WEST-CREE PWECANADIAN SYLLABICS PW" +
	"ICANADIAN SYLLABICS WEST-CREE PWICANADIAN SYLLABICS PWIICANADIAN SYLLABI" +
	"CS WEST-CREE PWIICANADIAN SYLLABICS PWOCANADIAN SYLLABICS WEST-CREE PWOC" +
	"ANADIAN SYLLABICS PWOOCANADIAN SYLLABICS WEST-CREE PWOOCANADIAN SYLLABIC" +
	"S PWACANADIAN SYLLABICS WEST-CREE PWACANADIAN SYLLABICS PWAACANADIAN SYL" +
	"LABICS WEST-CREE PWAACANADIAN SYLLABICS Y-CREE PWAACANADIAN SYLLABICS PC" +
	"ANADIAN SYLLABICS WEST-CREE PCANADIAN SYLLABICS CARRIER HCANADIAN SYLLAB" +
	"ICS TECANADIAN SYLLABICS TAAICANADIAN SYLLABICS TICANADIAN SYLLABICS TII" +
	"CANADIAN SYLLABICS TOCANADIAN SYLLABICS TOOCANADIAN SYLLABICS Y-CREE TOO" +
	"CANADIAN SYLLABICS CARRIER DEECANADIAN SYLLABICS CARRIER DICANADIAN SYLL" +
	"ABICS TACANADIAN SYLLABICS TAACANADIAN SYLLABICS TWECANADIAN SYLLABICS W" +
	"EST-CREE TWECANADIAN SYLLABICS TWICANADIAN SYLLABICS WEST-CREE TWICANADI" +
	"AN SYLLABICS TWIICANADIAN SYLLABICS WEST-CREE TWIICANADIAN SYLLABICS TWO" +
	"CANADIAN SYLLABICS WEST-CREE TWOCANADIAN SYLLABICS TWOOCANADIAN SYLLABIC" +
	"S WEST-CREE TWOOCANADIAN SYLLABICS TWACANADIAN SYLLABICS WEST-CREE TWACA" +
	"NADIAN SYLLABICS TWAACANADIAN SYLLABICS WEST-CREE TWAACANADIAN SYLLABICS" +
	" NASKAPI TWAACANADIAN SYLLABICS TCANADIAN SYLLABICS TTECANADIAN SYLLABIC" +
	"S TTICANADIAN SYLLABICS TTOCANADIAN SYLLABICS TTACANADIAN SYLLABICS KECA" +
	"NADIAN SYLLABICS KAAICANADIAN SYLLABICS KICANADIAN SYLLABICS KIICANADIAN" +
	" SYLLABICS KOCANADIAN SYLLABICS KOOCANADIAN SYLLABICS Y-CREE KOOCANADIAN" +
	" SYLLABICS KACANADIAN SYLLABICS KAACANADIAN SYLLABICS KWECANADIAN SYLLAB" +
	"ICS WEST-CREE KWECANADIAN SYLLABICS KWICANADIAN SYLLABICS WEST-CREE KWIC" +
	"ANADIAN SYLLABICS KWIICANADIAN SYLLABICS WEST-CREE KWIICANADIAN SYLLABIC" +
	"S KWOCANADIAN SYLLABICS WEST-CREE KWOCANADIAN SYLLABICS KWOOCANADIAN SYL" +
	"LABICS WEST-CREE KWOOCANADIAN SYLLABICS KWACANADIAN SYLLABICS WEST-CREE " +
	"KWACANADIAN SYLLABICS KWAACANADIAN SYLLABICS WEST-CREE KWAACANADIAN SYLL" +
	"ABICS NASKAPI KWAACANADIAN SYLLABICS KCANADIAN SYLLABICS KWCANADIAN SYLL" +
	"ABICS SOUTH-SLAVEY KEHCANADIAN SYLLABICS SOUTH-SLAVEY KIHCANADIAN SYLLAB" +
	"ICS SOUTH-SLAVEY KOHCANADIAN SYLLABICS SOUTH-SLAVEY KAHCANADIAN SYLLABIC" +
	"S CECANADIAN SYLLABICS CAAICANADIAN SYLLABICS CICANADIAN SYLLABICS CIICA" +
	"NADIAN SYLLABICS COCANADIAN SYLLABICS COOCANADIAN SYLLABICS Y-CREE COOCA" +
	"NADIAN SYLLABICS CACANADIAN SYLLABICS CAACANADIAN SYLLABICS CWECANADIAN " +
	"SYLLABICS WEST-CREE CWECANADIAN SYLLABICS CWICANADIAN SYLLABICS WEST-CRE" +
	"E CWICANADIAN SYLLABICS CWIICANADIAN SYLLABICS WEST-CREE CWIICANADIAN SY" +
	"LLABICS CWOCANADIAN SYLLABICS WEST-CREE CWOCANADIAN SYLLABICS CWOOCANADI" +
	"AN SYLLABICS WEST-CREE CWOOCANADIAN SYLLABICS CWACANADIAN SYLLABICS WEST" +
	"-CREE CWACANADIAN SYLLABICS CWAACANADIAN SYLLABICS WEST-CREE CWAACANADIA" +
	"N SYLLABICS NASKAPI CWAACANADIAN SYLLABICS CCANADIAN SYLLABICS SAYISI TH" +
	"CANADIAN SYLLABICS MECANADIAN SYLLABICS MAAICANADIAN SYLLABICS MICANADIA" +
	"N SYLLABICS MIICANADIAN SYLLABICS MOCANADIAN SYLLABICS MOOCANADIAN SYLLA" +
	"BICS Y-CREE MOOCANADIAN SYLLABICS MACANADIAN SYLLABICS MAACANADIAN SYLLA" +
	"BICS MWECANADIAN SYLLABICS WEST-CREE MWECANADIAN SYLLABICS MWICANADIAN S" +
	"YLLABICS WEST-CREE MWICANADIAN SYLLABICS MWIICANADIAN SYLLABICS WEST-CRE" +
	"E MWIICANADIAN SYLLABICS MWOCANADIAN SYLLABICS WEST-CREE MWOCANADIAN SYL" +
	"LABICS MWOOCANADIAN SYLLABICS WEST-CREE MWOOCANADIAN SYLLABICS MWACANADI" +
	"AN SYLLABICS WEST-CREE MWACANADIAN SYLLABICS MWAACANADIAN SYLLABICS WEST" +
	"-CREE MWAACANADIAN SYLLABICS NASKAPI MWAACANADIAN SYLLABICS MCANADIAN SY" +
	"LLABICS WEST-CREE MCANADIAN SYLLABICS MHCANADIAN SYLLABICS ATHAPASCAN MC" +
	"ANADIAN SYLLABICS SAYISI MCANADIAN SYLLABICS NECANADIAN SYLLABICS NAAICA" +
	"NADIAN SYLLABICS NICANADIAN SYLLABICS NIICANADIAN SYLLABICS NOCANADIAN S" +
	"YLLABICS NOOCANADIAN SYLLABICS Y-CREE NOOCANADIAN SYLLABICS NACANADIAN S" +
	"YLLABICS NAACANADIAN SYLLABICS NWECANADIAN SYLLABICS WEST-CREE NWECANADI" +
	"AN SYLLABICS NWACANADIAN SYLLABICS WEST-CREE NWACANADIAN SYLLABICS NWAAC") + ("" +
	"ANADIAN SYLLABICS WEST-CREE NWAACANADIAN SYLLABICS NASKAPI NWAACANADIAN " +
	"SYLLABICS NCANADIAN SYLLABICS CARRIER NGCANADIAN SYLLABICS NHCANADIAN SY" +
	"LLABICS LECANADIAN SYLLABICS LAAICANADIAN SYLLABICS LICANADIAN SYLLABICS" +
	" LIICANADIAN SYLLABICS LOCANADIAN SYLLABICS LOOCANADIAN SYLLABICS Y-CREE" +
	" LOOCANADIAN SYLLABICS LACANADIAN SYLLABICS LAACANADIAN SYLLABICS LWECAN" +
	"ADIAN SYLLABICS WEST-CREE LWECANADIAN SYLLABICS LWICANADIAN SYLLABICS WE" +
	"ST-CREE LWICANADIAN SYLLABICS LWIICANADIAN SYLLABICS WEST-CREE LWIICANAD" +
	"IAN SYLLABICS LWOCANADIAN SYLLABICS WEST-CREE LWOCANADIAN SYLLABICS LWOO" +
	"CANADIAN SYLLABICS WEST-CREE LWOOCANADIAN SYLLABICS LWACANADIAN SYLLABIC" +
	"S WEST-CREE LWACANADIAN SYLLABICS LWAACANADIAN SYLLABICS WEST-CREE LWAAC" +
	"ANADIAN SYLLABICS LCANADIAN SYLLABICS WEST-CREE LCANADIAN SYLLABICS MEDI" +
	"AL LCANADIAN SYLLABICS SECANADIAN SYLLABICS SAAICANADIAN SYLLABICS SICAN" +
	"ADIAN SYLLABICS SIICANADIAN SYLLABICS SOCANADIAN SYLLABICS SOOCANADIAN S" +
	"YLLABICS Y-CREE SOOCANADIAN SYLLABICS SACANADIAN SYLLABICS SAACANADIAN S" +
	"YLLABICS SWECANADIAN SYLLABICS WEST-CREE SWECANADIAN SYLLABICS SWICANADI" +
	"AN SYLLABICS WEST-CREE SWICANADIAN SYLLABICS SWIICANADIAN SYLLABICS WEST" +
	"-CREE SWIICANADIAN SYLLABICS SWOCANADIAN SYLLABICS WEST-CREE SWOCANADIAN" +
	" SYLLABICS SWOOCANADIAN SYLLABICS WEST-CREE SWOOCANADIAN SYLLABICS SWACA" +
	"NADIAN SYLLABICS WEST-CREE SWACANADIAN SYLLABICS SWAACANADIAN SYLLABICS " +
	"WEST-CREE SWAACANADIAN SYLLABICS NASKAPI SWAACANADIAN SYLLABICS SCANADIA" +
	"N SYLLABICS ATHAPASCAN SCANADIAN SYLLABICS SWCANADIAN SYLLABICS BLACKFOO" +
	"T SCANADIAN SYLLABICS MOOSE-CREE SKCANADIAN SYLLABICS NASKAPI SKWCANADIA" +
	"N SYLLABICS NASKAPI S-WCANADIAN SYLLABICS NASKAPI SPWACANADIAN SYLLABICS" +
	" NASKAPI STWACANADIAN SYLLABICS NASKAPI SKWACANADIAN SYLLABICS NASKAPI S" +
	"CWACANADIAN SYLLABICS SHECANADIAN SYLLABICS SHICANADIAN SYLLABICS SHIICA" +
	"NADIAN SYLLABICS SHOCANADIAN SYLLABICS SHOOCANADIAN SYLLABICS SHACANADIA" +
	"N SYLLABICS SHAACANADIAN SYLLABICS SHWECANADIAN SYLLABICS WEST-CREE SHWE" +
	"CANADIAN SYLLABICS SHWICANADIAN SYLLABICS WEST-CREE SHWICANADIAN SYLLABI" +
	"CS SHWIICANADIAN SYLLABICS WEST-CREE SHWIICANADIAN SYLLABICS SHWOCANADIA" +
	"N SYLLABICS WEST-CREE SHWOCANADIAN SYLLABICS SHWOOCANADIAN SYLLABICS WES" +
	"T-CREE SHWOOCANADIAN SYLLABICS SHWACANADIAN SYLLABICS WEST-CREE SHWACANA" +
	"DIAN SYLLABICS SHWAACANADIAN SYLLABICS WEST-CREE SHWAACANADIAN SYLLABICS" +
	" SHCANADIAN SYLLABICS YECANADIAN SYLLABICS YAAICANADIAN SYLLABICS YICANA" +
	"DIAN SYLLABICS YIICANADIAN SYLLABICS YOCANADIAN SYLLABICS YOOCANADIAN SY" +
	"LLABICS Y-CREE YOOCANADIAN SYLLABICS YACANADIAN SYLLABICS YAACANADIAN SY" +
	"LLABICS YWECANADIAN SYLLABICS WEST-CREE YWECANADIAN SYLLABICS YWICANADIA" +
	"N SYLLABICS WEST-CREE YWICANADIAN SYLLABICS YWIICANADIAN SYLLABICS WEST-" +
	"CREE YWIICANADIAN SYLLABICS YWOCANADIAN SYLLABICS WEST-CREE YWOCANADIAN " +
	"SYLLABICS YWOOCANADIAN SYLLABICS WEST-CREE YWOOCANADIAN SYLLABICS YWACAN" +
	"ADIAN SYLLABICS WEST-CREE YWACANADIAN SYLLABICS YWAACANADIAN SYLLABICS W" +
	"EST-CREE YWAACANADIAN SYLLABICS NASKAPI YWAACANADIAN SYLLABICS YCANADIAN" +
	" SYLLABICS BIBLE-CREE YCANADIAN SYLLABICS WEST-CREE YCANADIAN SYLLABICS " +
	"SAYISI YICANADIAN SYLLABICS RECANADIAN SYLLABICS R-CREE RECANADIAN SYLLA" +
	"BICS WEST-CREE LECANADIAN SYLLABICS RAAICANADIAN SYLLABICS RICANADIAN SY" +
	"LLABICS RIICANADIAN SYLLABICS ROCANADIAN SYLLABICS ROOCANADIAN SYLLABICS" +
	" WEST-CREE LOCANADIAN SYLLABICS RACANADIAN SYLLABICS RAACANADIAN SYLLABI" +
	"CS WEST-CREE LACANADIAN SYLLABICS RWAACANADIAN SYLLABICS WEST-CREE RWAAC" +
	"ANADIAN SYLLABICS RCANADIAN SYLLABICS WEST-CREE RCANADIAN SYLLABICS MEDI" +
	"AL RCANADIAN SYLLABICS FECANADIAN SYLLABICS FAAICANADIAN SYLLABICS FICAN" +
	"ADIAN SYLLABICS FIICANADIAN SYLLABICS FOCANADIAN SYLLABICS FOOCANADIAN S" +
	"YLLABICS FACANADIAN SYLLABICS FAACANADIAN SYLLABICS FWAACANADIAN SYLLABI" +
	"CS WEST-CREE FWAACANADIAN SYLLABICS FCANADIAN SYLLABICS THECANADIAN SYLL" +
	"ABICS N-CREE THECANADIAN SYLLABICS THICANADIAN SYLLABICS N-CREE THICANAD" +
	"IAN SYLLABICS THIICANADIAN SYLLABICS N-CREE THIICANADIAN SYLLABICS THOCA" +
	"NADIAN SYLLABICS THOOCANADIAN SYLLABICS THACANADIAN SYLLABICS THAACANADI" +
	"AN SYLLABICS THWAACANADIAN SYLLABICS WEST-CREE THWAACANADIAN SYLLABICS T" +
	"HCANADIAN SYLLABICS TTHECANADIAN SYLLABICS TTHICANADIAN SYLLABICS TTHOCA" +
	"NADIAN SYLLABICS TTHACANADIAN SYLLABICS TTHCANADIAN SYLLABICS TYECANADIA" +
	"N SYLLABICS TYICANADIAN SYLLABICS TYOCANADIAN SYLLABICS TYACANADIAN SYLL" +
	"ABICS NUNAVIK HECANADIAN SYLLABICS NUNAVIK HICANADIAN SYLLABICS NUNAVIK " +
	"HIICANADIAN SYLLABICS NUNAVIK HOCANADIAN SYLLABICS NUNAVIK HOOCANADIAN S" +
	"YLLABICS NUNAVIK HACANADIAN SYLLABICS NUNAVIK HAACANADIAN SYLLABICS NUNA" +
	"VIK HCANADIAN SYLLABICS NUNAVUT HCANADIAN SYLLABICS HKCANADIAN SYLLABICS" +
	" QAAICANADIAN SYLLABICS QICANADIAN SYLLABICS QIICANADIAN SYLLABICS QOCAN") + ("" +
	"ADIAN SYLLABICS QOOCANADIAN SYLLABICS QACANADIAN SYLLABICS QAACANADIAN S" +
	"YLLABICS QCANADIAN SYLLABICS TLHECANADIAN SYLLABICS TLHICANADIAN SYLLABI" +
	"CS TLHOCANADIAN SYLLABICS TLHACANADIAN SYLLABICS WEST-CREE RECANADIAN SY" +
	"LLABICS WEST-CREE RICANADIAN SYLLABICS WEST-CREE ROCANADIAN SYLLABICS WE" +
	"ST-CREE RACANADIAN SYLLABICS NGAAICANADIAN SYLLABICS NGICANADIAN SYLLABI" +
	"CS NGIICANADIAN SYLLABICS NGOCANADIAN SYLLABICS NGOOCANADIAN SYLLABICS N" +
	"GACANADIAN SYLLABICS NGAACANADIAN SYLLABICS NGCANADIAN SYLLABICS NNGCANA" +
	"DIAN SYLLABICS SAYISI SHECANADIAN SYLLABICS SAYISI SHICANADIAN SYLLABICS" +
	" SAYISI SHOCANADIAN SYLLABICS SAYISI SHACANADIAN SYLLABICS WOODS-CREE TH" +
	"ECANADIAN SYLLABICS WOODS-CREE THICANADIAN SYLLABICS WOODS-CREE THOCANAD" +
	"IAN SYLLABICS WOODS-CREE THACANADIAN SYLLABICS WOODS-CREE THCANADIAN SYL" +
	"LABICS LHICANADIAN SYLLABICS LHIICANADIAN SYLLABICS LHOCANADIAN SYLLABIC" +
	"S LHOOCANADIAN SYLLABICS LHACANADIAN SYLLABICS LHAACANADIAN SYLLABICS LH" +
	"CANADIAN SYLLABICS TH-CREE THECANADIAN SYLLABICS TH-CREE THICANADIAN SYL" +
	"LABICS TH-CREE THIICANADIAN SYLLABICS TH-CREE THOCANADIAN SYLLABICS TH-C" +
	"REE THOOCANADIAN SYLLABICS TH-CREE THACANADIAN SYLLABICS TH-CREE THAACAN" +
	"ADIAN SYLLABICS TH-CREE THCANADIAN SYLLABICS AIVILIK BCANADIAN SYLLABICS" +
	" BLACKFOOT ECANADIAN SYLLABICS BLACKFOOT ICANADIAN SYLLABICS BLACKFOOT O" +
	"CANADIAN SYLLABICS BLACKFOOT ACANADIAN SYLLABICS BLACKFOOT WECANADIAN SY" +
	"LLABICS BLACKFOOT WICANADIAN SYLLABICS BLACKFOOT WOCANADIAN SYLLABICS BL" +
	"ACKFOOT WACANADIAN SYLLABICS BLACKFOOT NECANADIAN SYLLABICS BLACKFOOT NI" +
	"CANADIAN SYLLABICS BLACKFOOT NOCANADIAN SYLLABICS BLACKFOOT NACANADIAN S" +
	"YLLABICS BLACKFOOT KECANADIAN SYLLABICS BLACKFOOT KICANADIAN SYLLABICS B" +
	"LACKFOOT KOCANADIAN SYLLABICS BLACKFOOT KACANADIAN SYLLABICS SAYISI HECA" +
	"NADIAN SYLLABICS SAYISI HICANADIAN SYLLABICS SAYISI HOCANADIAN SYLLABICS" +
	" SAYISI HACANADIAN SYLLABICS CARRIER GHUCANADIAN SYLLABICS CARRIER GHOCA" +
	"NADIAN SYLLABICS CARRIER GHECANADIAN SYLLABICS CARRIER GHEECANADIAN SYLL" +
	"ABICS CARRIER GHICANADIAN SYLLABICS CARRIER GHACANADIAN SYLLABICS CARRIE" +
	"R RUCANADIAN SYLLABICS CARRIER ROCANADIAN SYLLABICS CARRIER RECANADIAN S" +
	"YLLABICS CARRIER REECANADIAN SYLLABICS CARRIER RICANADIAN SYLLABICS CARR" +
	"IER RACANADIAN SYLLABICS CARRIER WUCANADIAN SYLLABICS CARRIER WOCANADIAN" +
	" SYLLABICS CARRIER WECANADIAN SYLLABICS CARRIER WEECANADIAN SYLLABICS CA" +
	"RRIER WICANADIAN SYLLABICS CARRIER WACANADIAN SYLLABICS CARRIER HWUCANAD" +
	"IAN SYLLABICS CARRIER HWOCANADIAN SYLLABICS CARRIER HWECANADIAN SYLLABIC" +
	"S CARRIER HWEECANADIAN SYLLABICS CARRIER HWICANADIAN SYLLABICS CARRIER H" +
	"WACANADIAN SYLLABICS CARRIER THUCANADIAN SYLLABICS CARRIER THOCANADIAN S" +
	"YLLABICS CARRIER THECANADIAN SYLLABICS CARRIER THEECANADIAN SYLLABICS CA" +
	"RRIER THICANADIAN SYLLABICS CARRIER THACANADIAN SYLLABICS CARRIER TTUCAN" +
	"ADIAN SYLLABICS CARRIER TTOCANADIAN SYLLABICS CARRIER TTECANADIAN SYLLAB" +
	"ICS CARRIER TTEECANADIAN SYLLABICS CARRIER TTICANADIAN SYLLABICS CARRIER" +
	" TTACANADIAN SYLLABICS CARRIER PUCANADIAN SYLLABICS CARRIER POCANADIAN S" +
	"YLLABICS CARRIER PECANADIAN SYLLABICS CARRIER PEECANADIAN SYLLABICS CARR" +
	"IER PICANADIAN SYLLABICS CARRIER PACANADIAN SYLLABICS CARRIER PCANADIAN " +
	"SYLLABICS CARRIER GUCANADIAN SYLLABICS CARRIER GOCANADIAN SYLLABICS CARR" +
	"IER GECANADIAN SYLLABICS CARRIER GEECANADIAN SYLLABICS CARRIER GICANADIA" +
	"N SYLLABICS CARRIER GACANADIAN SYLLABICS CARRIER KHUCANADIAN SYLLABICS C" +
	"ARRIER KHOCANADIAN SYLLABICS CARRIER KHECANADIAN SYLLABICS CARRIER KHEEC" +
	"ANADIAN SYLLABICS CARRIER KHICANADIAN SYLLABICS CARRIER KHACANADIAN SYLL" +
	"ABICS CARRIER KKUCANADIAN SYLLABICS CARRIER KKOCANADIAN SYLLABICS CARRIE" +
	"R KKECANADIAN SYLLABICS CARRIER KKEECANADIAN SYLLABICS CARRIER KKICANADI" +
	"AN SYLLABICS CARRIER KKACANADIAN SYLLABICS CARRIER KKCANADIAN SYLLABICS " +
	"CARRIER NUCANADIAN SYLLABICS CARRIER NOCANADIAN SYLLABICS CARRIER NECANA" +
	"DIAN SYLLABICS CARRIER NEECANADIAN SYLLABICS CARRIER NICANADIAN SYLLABIC" +
	"S CARRIER NACANADIAN SYLLABICS CARRIER MUCANADIAN SYLLABICS CARRIER MOCA" +
	"NADIAN SYLLABICS CARRIER MECANADIAN SYLLABICS CARRIER MEECANADIAN SYLLAB" +
	"ICS CARRIER MICANADIAN SYLLABICS CARRIER MACANADIAN SYLLABICS CARRIER YU" +
	"CANADIAN SYLLABICS CARRIER YOCANADIAN SYLLABICS CARRIER YECANADIAN SYLLA" +
	"BICS CARRIER YEECANADIAN SYLLABICS CARRIER YICANADIAN SYLLABICS CARRIER " +
	"YACANADIAN SYLLABICS CARRIER JUCANADIAN SYLLABICS SAYISI JUCANADIAN SYLL" +
	"ABICS CARRIER JOCANADIAN SYLLABICS CARRIER JECANADIAN SYLLABICS CARRIER " +
	"JEECANADIAN SYLLABICS CARRIER JICANADIAN SYLLABICS SAYISI JICANADIAN SYL" +
	"LABICS CARRIER JACANADIAN SYLLABICS CARRIER JJUCANADIAN SYLLABICS CARRIE" +
	"R JJOCANADIAN SYLLABICS CARRIER JJECANADIAN SYLLABICS CARRIER JJEECANADI" +
	"AN SYLLABICS CARRIER JJICANADIAN SYLLABICS CARRIER JJACANADIAN SYLLABICS") + ("" +
	" CARRIER LUCANADIAN SYLLABICS CARRIER LOCANADIAN SYLLABICS CARRIER LECAN" +
	"ADIAN SYLLABICS CARRIER LEECANADIAN SYLLABICS CARRIER LICANADIAN SYLLABI" +
	"CS CARRIER LACANADIAN SYLLABICS CARRIER DLUCANADIAN SYLLABICS CARRIER DL" +
	"OCANADIAN SYLLABICS CARRIER DLECANADIAN SYLLABICS CARRIER DLEECANADIAN S" +
	"YLLABICS CARRIER DLICANADIAN SYLLABICS CARRIER DLACANADIAN SYLLABICS CAR" +
	"RIER LHUCANADIAN SYLLABICS CARRIER LHOCANADIAN SYLLABICS CARRIER LHECANA" +
	"DIAN SYLLABICS CARRIER LHEECANADIAN SYLLABICS CARRIER LHICANADIAN SYLLAB" +
	"ICS CARRIER LHACANADIAN SYLLABICS CARRIER TLHUCANADIAN SYLLABICS CARRIER" +
	" TLHOCANADIAN SYLLABICS CARRIER TLHECANADIAN SYLLABICS CARRIER TLHEECANA" +
	"DIAN SYLLABICS CARRIER TLHICANADIAN SYLLABICS CARRIER TLHACANADIAN SYLLA" +
	"BICS CARRIER TLUCANADIAN SYLLABICS CARRIER TLOCANADIAN SYLLABICS CARRIER" +
	" TLECANADIAN SYLLABICS CARRIER TLEECANADIAN SYLLABICS CARRIER TLICANADIA" +
	"N SYLLABICS CARRIER TLACANADIAN SYLLABICS CARRIER ZUCANADIAN SYLLABICS C" +
	"ARRIER ZOCANADIAN SYLLABICS CARRIER ZECANADIAN SYLLABICS CARRIER ZEECANA" +
	"DIAN SYLLABICS CARRIER ZICANADIAN SYLLABICS CARRIER ZACANADIAN SYLLABICS" +
	" CARRIER ZCANADIAN SYLLABICS CARRIER INITIAL ZCANADIAN SYLLABICS CARRIER" +
	" DZUCANADIAN SYLLABICS CARRIER DZOCANADIAN SYLLABICS CARRIER DZECANADIAN" +
	" SYLLABICS CARRIER DZEECANADIAN SYLLABICS CARRIER DZICANADIAN SYLLABICS " +
	"CARRIER DZACANADIAN SYLLABICS CARRIER SUCANADIAN SYLLABICS CARRIER SOCAN" +
	"ADIAN SYLLABICS CARRIER SECANADIAN SYLLABICS CARRIER SEECANADIAN SYLLABI" +
	"CS CARRIER SICANADIAN SYLLABICS CARRIER SACANADIAN SYLLABICS CARRIER SHU" +
	"CANADIAN SYLLABICS CARRIER SHOCANADIAN SYLLABICS CARRIER SHECANADIAN SYL" +
	"LABICS CARRIER SHEECANADIAN SYLLABICS CARRIER SHICANADIAN SYLLABICS CARR" +
	"IER SHACANADIAN SYLLABICS CARRIER SHCANADIAN SYLLABICS CARRIER TSUCANADI" +
	"AN SYLLABICS CARRIER TSOCANADIAN SYLLABICS CARRIER TSECANADIAN SYLLABICS" +
	" CARRIER TSEECANADIAN SYLLABICS CARRIER TSICANADIAN SYLLABICS CARRIER TS" +
	"ACANADIAN SYLLABICS CARRIER CHUCANADIAN SYLLABICS CARRIER CHOCANADIAN SY" +
	"LLABICS CARRIER CHECANADIAN SYLLABICS CARRIER CHEECANADIAN SYLLABICS CAR" +
	"RIER CHICANADIAN SYLLABICS CARRIER CHACANADIAN SYLLABICS CARRIER TTSUCAN" +
	"ADIAN SYLLABICS CARRIER TTSOCANADIAN SYLLABICS CARRIER TTSECANADIAN SYLL" +
	"ABICS CARRIER TTSEECANADIAN SYLLABICS CARRIER TTSICANADIAN SYLLABICS CAR" +
	"RIER TTSACANADIAN SYLLABICS CHI SIGNCANADIAN SYLLABICS FULL STOPCANADIAN" +
	" SYLLABICS QAICANADIAN SYLLABICS NGAICANADIAN SYLLABICS NNGICANADIAN SYL" +
	"LABICS NNGIICANADIAN SYLLABICS NNGOCANADIAN SYLLABICS NNGOOCANADIAN SYLL" +
	"ABICS NNGACANADIAN SYLLABICS NNGAACANADIAN SYLLABICS WOODS-CREE THWEECAN" +
	"ADIAN SYLLABICS WOODS-CREE THWICANADIAN SYLLABICS WOODS-CREE THWIICANADI" +
	"AN SYLLABICS WOODS-CREE THWOCANADIAN SYLLABICS WOODS-CREE THWOOCANADIAN " +
	"SYLLABICS WOODS-CREE THWACANADIAN SYLLABICS WOODS-CREE THWAACANADIAN SYL" +
	"LABICS WOODS-CREE FINAL THCANADIAN SYLLABICS BLACKFOOT WOGHAM SPACE MARK" +
	"OGHAM LETTER BEITHOGHAM LETTER LUISOGHAM LETTER FEARNOGHAM LETTER SAILOG" +
	"HAM LETTER NIONOGHAM LETTER UATHOGHAM LETTER DAIROGHAM LETTER TINNEOGHAM" +
	" LETTER COLLOGHAM LETTER CEIRTOGHAM LETTER MUINOGHAM LETTER GORTOGHAM LE" +
	"TTER NGEADALOGHAM LETTER STRAIFOGHAM LETTER RUISOGHAM LETTER AILMOGHAM L" +
	"ETTER ONNOGHAM LETTER UROGHAM LETTER EADHADHOGHAM LETTER IODHADHOGHAM LE" +
	"TTER EABHADHOGHAM LETTER OROGHAM LETTER UILLEANNOGHAM LETTER IFINOGHAM L" +
	"ETTER EAMHANCHOLLOGHAM LETTER PEITHOGHAM FEATHER MARKOGHAM REVERSED FEAT" +
	"HER MARKRUNIC LETTER FEHU FEOH FE FRUNIC LETTER VRUNIC LETTER URUZ UR UR" +
	"UNIC LETTER YRRUNIC LETTER YRUNIC LETTER WRUNIC LETTER THURISAZ THURS TH" +
	"ORNRUNIC LETTER ETHRUNIC LETTER ANSUZ ARUNIC LETTER OS ORUNIC LETTER AC " +
	"ARUNIC LETTER AESCRUNIC LETTER LONG-BRANCH-OSS ORUNIC LETTER SHORT-TWIG-" +
	"OSS ORUNIC LETTER ORUNIC LETTER OERUNIC LETTER ONRUNIC LETTER RAIDO RAD " +
	"REID RRUNIC LETTER KAUNARUNIC LETTER CENRUNIC LETTER KAUN KRUNIC LETTER " +
	"GRUNIC LETTER ENGRUNIC LETTER GEBO GYFU GRUNIC LETTER GARRUNIC LETTER WU" +
	"NJO WYNN WRUNIC LETTER HAGLAZ HRUNIC LETTER HAEGL HRUNIC LETTER LONG-BRA" +
	"NCH-HAGALL HRUNIC LETTER SHORT-TWIG-HAGALL HRUNIC LETTER NAUDIZ NYD NAUD" +
	" NRUNIC LETTER SHORT-TWIG-NAUD NRUNIC LETTER DOTTED-NRUNIC LETTER ISAZ I" +
	"S ISS IRUNIC LETTER ERUNIC LETTER JERAN JRUNIC LETTER GERRUNIC LETTER LO" +
	"NG-BRANCH-AR AERUNIC LETTER SHORT-TWIG-AR ARUNIC LETTER IWAZ EOHRUNIC LE" +
	"TTER PERTHO PEORTH PRUNIC LETTER ALGIZ EOLHXRUNIC LETTER SOWILO SRUNIC L" +
	"ETTER SIGEL LONG-BRANCH-SOL SRUNIC LETTER SHORT-TWIG-SOL SRUNIC LETTER C" +
	"RUNIC LETTER ZRUNIC LETTER TIWAZ TIR TYR TRUNIC LETTER SHORT-TWIG-TYR TR" +
	"UNIC LETTER DRUNIC LETTER BERKANAN BEORC BJARKAN BRUNIC LETTER SHORT-TWI" +
	"G-BJARKAN BRUNIC LETTER DOTTED-PRUNIC LETTER OPEN-PRUNIC LETTER EHWAZ EH" +
	" ERUNIC LETTER MANNAZ MAN MRUNIC LETTER LONG-BRANCH-MADR MRUNIC LETTER S") + ("" +
	"HORT-TWIG-MADR MRUNIC LETTER LAUKAZ LAGU LOGR LRUNIC LETTER DOTTED-LRUNI" +
	"C LETTER INGWAZRUNIC LETTER INGRUNIC LETTER DAGAZ DAEG DRUNIC LETTER OTH" +
	"ALAN ETHEL ORUNIC LETTER EARRUNIC LETTER IORRUNIC LETTER CWEORTHRUNIC LE" +
	"TTER CALCRUNIC LETTER CEALCRUNIC LETTER STANRUNIC LETTER LONG-BRANCH-YRR" +
	"UNIC LETTER SHORT-TWIG-YRRUNIC LETTER ICELANDIC-YRRUNIC LETTER QRUNIC LE" +
	"TTER XRUNIC SINGLE PUNCTUATIONRUNIC MULTIPLE PUNCTUATIONRUNIC CROSS PUNC" +
	"TUATIONRUNIC ARLAUG SYMBOLRUNIC TVIMADUR SYMBOLRUNIC BELGTHOR SYMBOLRUNI" +
	"C LETTER KRUNIC LETTER SHRUNIC LETTER OORUNIC LETTER FRANKS CASKET OSRUN" +
	"IC LETTER FRANKS CASKET ISRUNIC LETTER FRANKS CASKET EHRUNIC LETTER FRAN" +
	"KS CASKET ACRUNIC LETTER FRANKS CASKET AESCTAGALOG LETTER ATAGALOG LETTE" +
	"R ITAGALOG LETTER UTAGALOG LETTER KATAGALOG LETTER GATAGALOG LETTER NGAT" +
	"AGALOG LETTER TATAGALOG LETTER DATAGALOG LETTER NATAGALOG LETTER PATAGAL" +
	"OG LETTER BATAGALOG LETTER MATAGALOG LETTER YATAGALOG LETTER LATAGALOG L" +
	"ETTER WATAGALOG LETTER SATAGALOG LETTER HATAGALOG VOWEL SIGN ITAGALOG VO" +
	"WEL SIGN UTAGALOG SIGN VIRAMAHANUNOO LETTER AHANUNOO LETTER IHANUNOO LET" +
	"TER UHANUNOO LETTER KAHANUNOO LETTER GAHANUNOO LETTER NGAHANUNOO LETTER " +
	"TAHANUNOO LETTER DAHANUNOO LETTER NAHANUNOO LETTER PAHANUNOO LETTER BAHA" +
	"NUNOO LETTER MAHANUNOO LETTER YAHANUNOO LETTER RAHANUNOO LETTER LAHANUNO" +
	"O LETTER WAHANUNOO LETTER SAHANUNOO LETTER HAHANUNOO VOWEL SIGN IHANUNOO" +
	" VOWEL SIGN UHANUNOO SIGN PAMUDPODPHILIPPINE SINGLE PUNCTUATIONPHILIPPIN" +
	"E DOUBLE PUNCTUATIONBUHID LETTER ABUHID LETTER IBUHID LETTER UBUHID LETT" +
	"ER KABUHID LETTER GABUHID LETTER NGABUHID LETTER TABUHID LETTER DABUHID " +
	"LETTER NABUHID LETTER PABUHID LETTER BABUHID LETTER MABUHID LETTER YABUH" +
	"ID LETTER RABUHID LETTER LABUHID LETTER WABUHID LETTER SABUHID LETTER HA" +
	"BUHID VOWEL SIGN IBUHID VOWEL SIGN UTAGBANWA LETTER ATAGBANWA LETTER ITA" +
	"GBANWA LETTER UTAGBANWA LETTER KATAGBANWA LETTER GATAGBANWA LETTER NGATA" +
	"GBANWA LETTER TATAGBANWA LETTER DATAGBANWA LETTER NATAGBANWA LETTER PATA" +
	"GBANWA LETTER BATAGBANWA LETTER MATAGBANWA LETTER YATAGBANWA LETTER LATA" +
	"GBANWA LETTER WATAGBANWA LETTER SATAGBANWA VOWEL SIGN ITAGBANWA VOWEL SI" +
	"GN UKHMER LETTER KAKHMER LETTER KHAKHMER LETTER KOKHMER LETTER KHOKHMER " +
	"LETTER NGOKHMER LETTER CAKHMER LETTER CHAKHMER LETTER COKHMER LETTER CHO" +
	"KHMER LETTER NYOKHMER LETTER DAKHMER LETTER TTHAKHMER LETTER DOKHMER LET" +
	"TER TTHOKHMER LETTER NNOKHMER LETTER TAKHMER LETTER THAKHMER LETTER TOKH" +
	"MER LETTER THOKHMER LETTER NOKHMER LETTER BAKHMER LETTER PHAKHMER LETTER" +
	" POKHMER LETTER PHOKHMER LETTER MOKHMER LETTER YOKHMER LETTER ROKHMER LE" +
	"TTER LOKHMER LETTER VOKHMER LETTER SHAKHMER LETTER SSOKHMER LETTER SAKHM" +
	"ER LETTER HAKHMER LETTER LAKHMER LETTER QAKHMER INDEPENDENT VOWEL QAQKHM" +
	"ER INDEPENDENT VOWEL QAAKHMER INDEPENDENT VOWEL QIKHMER INDEPENDENT VOWE" +
	"L QIIKHMER INDEPENDENT VOWEL QUKHMER INDEPENDENT VOWEL QUKKHMER INDEPEND" +
	"ENT VOWEL QUUKHMER INDEPENDENT VOWEL QUUVKHMER INDEPENDENT VOWEL RYKHMER" +
	" INDEPENDENT VOWEL RYYKHMER INDEPENDENT VOWEL LYKHMER INDEPENDENT VOWEL " +
	"LYYKHMER INDEPENDENT VOWEL QEKHMER INDEPENDENT VOWEL QAIKHMER INDEPENDEN" +
	"T VOWEL QOO TYPE ONEKHMER INDEPENDENT VOWEL QOO TYPE TWOKHMER INDEPENDEN" +
	"T VOWEL QAUKHMER VOWEL INHERENT AQKHMER VOWEL INHERENT AAKHMER VOWEL SIG" +
	"N AAKHMER VOWEL SIGN IKHMER VOWEL SIGN IIKHMER VOWEL SIGN YKHMER VOWEL S" +
	"IGN YYKHMER VOWEL SIGN UKHMER VOWEL SIGN UUKHMER VOWEL SIGN UAKHMER VOWE" +
	"L SIGN OEKHMER VOWEL SIGN YAKHMER VOWEL SIGN IEKHMER VOWEL SIGN EKHMER V" +
	"OWEL SIGN AEKHMER VOWEL SIGN AIKHMER VOWEL SIGN OOKHMER VOWEL SIGN AUKHM" +
	"ER SIGN NIKAHITKHMER SIGN REAHMUKKHMER SIGN YUUKALEAPINTUKHMER SIGN MUUS" +
	"IKATOANKHMER SIGN TRIISAPKHMER SIGN BANTOCKHMER SIGN ROBATKHMER SIGN TOA" +
	"NDAKHIATKHMER SIGN KAKABATKHMER SIGN AHSDAKHMER SIGN SAMYOK SANNYAKHMER " +
	"SIGN VIRIAMKHMER SIGN COENGKHMER SIGN BATHAMASATKHMER SIGN KHANKHMER SIG" +
	"N BARIYOOSANKHMER SIGN CAMNUC PII KUUHKHMER SIGN LEK TOOKHMER SIGN BEYYA" +
	"LKHMER SIGN PHNAEK MUANKHMER SIGN KOOMUUTKHMER CURRENCY SYMBOL RIELKHMER" +
	" SIGN AVAKRAHASANYAKHMER SIGN ATTHACANKHMER DIGIT ZEROKHMER DIGIT ONEKHM" +
	"ER DIGIT TWOKHMER DIGIT THREEKHMER DIGIT FOURKHMER DIGIT FIVEKHMER DIGIT" +
	" SIXKHMER DIGIT SEVENKHMER DIGIT EIGHTKHMER DIGIT NINEKHMER SYMBOL LEK A" +
	"TTAK SONKHMER SYMBOL LEK ATTAK MUOYKHMER SYMBOL LEK ATTAK PIIKHMER SYMBO" +
	"L LEK ATTAK BEIKHMER SYMBOL LEK ATTAK BUONKHMER SYMBOL LEK ATTAK PRAMKHM" +
	"ER SYMBOL LEK ATTAK PRAM-MUOYKHMER SYMBOL LEK ATTAK PRAM-PIIKHMER SYMBOL" +
	" LEK ATTAK PRAM-BEIKHMER SYMBOL LEK ATTAK PRAM-BUONMONGOLIAN BIRGAMONGOL" +
	"IAN ELLIPSISMONGOLIAN COMMAMONGOLIAN FULL STOPMONGOLIAN COLONMONGOLIAN F" +
	"OUR DOTSMONGOLIAN TODO SOFT HYPHENMONGOLIAN SIBE SYLLABLE BOUNDARY MARKE" +
	"RMONGOLIAN MANCHU COMMAMONGOLIAN MANCHU FULL STOPMONGOLIAN NIRUGUMONGOLI") + ("" +
	"AN FREE VARIATION SELECTOR ONEMONGOLIAN FREE VARIATION SELECTOR TWOMONGO" +
	"LIAN FREE VARIATION SELECTOR THREEMONGOLIAN VOWEL SEPARATORMONGOLIAN DIG" +
	"IT ZEROMONGOLIAN DIGIT ONEMONGOLIAN DIGIT TWOMONGOLIAN DIGIT THREEMONGOL" +
	"IAN DIGIT FOURMONGOLIAN DIGIT FIVEMONGOLIAN DIGIT SIXMONGOLIAN DIGIT SEV" +
	"ENMONGOLIAN DIGIT EIGHTMONGOLIAN DIGIT NINEMONGOLIAN LETTER AMONGOLIAN L" +
	"ETTER EMONGOLIAN LETTER IMONGOLIAN LETTER OMONGOLIAN LETTER UMONGOLIAN L" +
	"ETTER OEMONGOLIAN LETTER UEMONGOLIAN LETTER EEMONGOLIAN LETTER NAMONGOLI" +
	"AN LETTER ANGMONGOLIAN LETTER BAMONGOLIAN LETTER PAMONGOLIAN LETTER QAMO" +
	"NGOLIAN LETTER GAMONGOLIAN LETTER MAMONGOLIAN LETTER LAMONGOLIAN LETTER " +
	"SAMONGOLIAN LETTER SHAMONGOLIAN LETTER TAMONGOLIAN LETTER DAMONGOLIAN LE" +
	"TTER CHAMONGOLIAN LETTER JAMONGOLIAN LETTER YAMONGOLIAN LETTER RAMONGOLI" +
	"AN LETTER WAMONGOLIAN LETTER FAMONGOLIAN LETTER KAMONGOLIAN LETTER KHAMO" +
	"NGOLIAN LETTER TSAMONGOLIAN LETTER ZAMONGOLIAN LETTER HAAMONGOLIAN LETTE" +
	"R ZRAMONGOLIAN LETTER LHAMONGOLIAN LETTER ZHIMONGOLIAN LETTER CHIMONGOLI" +
	"AN LETTER TODO LONG VOWEL SIGNMONGOLIAN LETTER TODO EMONGOLIAN LETTER TO" +
	"DO IMONGOLIAN LETTER TODO OMONGOLIAN LETTER TODO UMONGOLIAN LETTER TODO " +
	"OEMONGOLIAN LETTER TODO UEMONGOLIAN LETTER TODO ANGMONGOLIAN LETTER TODO" +
	" BAMONGOLIAN LETTER TODO PAMONGOLIAN LETTER TODO QAMONGOLIAN LETTER TODO" +
	" GAMONGOLIAN LETTER TODO MAMONGOLIAN LETTER TODO TAMONGOLIAN LETTER TODO" +
	" DAMONGOLIAN LETTER TODO CHAMONGOLIAN LETTER TODO JAMONGOLIAN LETTER TOD" +
	"O TSAMONGOLIAN LETTER TODO YAMONGOLIAN LETTER TODO WAMONGOLIAN LETTER TO" +
	"DO KAMONGOLIAN LETTER TODO GAAMONGOLIAN LETTER TODO HAAMONGOLIAN LETTER " +
	"TODO JIAMONGOLIAN LETTER TODO NIAMONGOLIAN LETTER TODO DZAMONGOLIAN LETT" +
	"ER SIBE EMONGOLIAN LETTER SIBE IMONGOLIAN LETTER SIBE IYMONGOLIAN LETTER" +
	" SIBE UEMONGOLIAN LETTER SIBE UMONGOLIAN LETTER SIBE ANGMONGOLIAN LETTER" +
	" SIBE KAMONGOLIAN LETTER SIBE GAMONGOLIAN LETTER SIBE HAMONGOLIAN LETTER" +
	" SIBE PAMONGOLIAN LETTER SIBE SHAMONGOLIAN LETTER SIBE TAMONGOLIAN LETTE" +
	"R SIBE DAMONGOLIAN LETTER SIBE JAMONGOLIAN LETTER SIBE FAMONGOLIAN LETTE" +
	"R SIBE GAAMONGOLIAN LETTER SIBE HAAMONGOLIAN LETTER SIBE TSAMONGOLIAN LE" +
	"TTER SIBE ZAMONGOLIAN LETTER SIBE RAAMONGOLIAN LETTER SIBE CHAMONGOLIAN " +
	"LETTER SIBE ZHAMONGOLIAN LETTER MANCHU IMONGOLIAN LETTER MANCHU KAMONGOL" +
	"IAN LETTER MANCHU RAMONGOLIAN LETTER MANCHU FAMONGOLIAN LETTER MANCHU ZH" +
	"AMONGOLIAN LETTER CHA WITH TWO DOTSMONGOLIAN LETTER ALI GALI ANUSVARA ON" +
	"EMONGOLIAN LETTER ALI GALI VISARGA ONEMONGOLIAN LETTER ALI GALI DAMARUMO" +
	"NGOLIAN LETTER ALI GALI UBADAMAMONGOLIAN LETTER ALI GALI INVERTED UBADAM" +
	"AMONGOLIAN LETTER ALI GALI BALUDAMONGOLIAN LETTER ALI GALI THREE BALUDAM" +
	"ONGOLIAN LETTER ALI GALI AMONGOLIAN LETTER ALI GALI IMONGOLIAN LETTER AL" +
	"I GALI KAMONGOLIAN LETTER ALI GALI NGAMONGOLIAN LETTER ALI GALI CAMONGOL" +
	"IAN LETTER ALI GALI TTAMONGOLIAN LETTER ALI GALI TTHAMONGOLIAN LETTER AL" +
	"I GALI DDAMONGOLIAN LETTER ALI GALI NNAMONGOLIAN LETTER ALI GALI TAMONGO" +
	"LIAN LETTER ALI GALI DAMONGOLIAN LETTER ALI GALI PAMONGOLIAN LETTER ALI " +
	"GALI PHAMONGOLIAN LETTER ALI GALI SSAMONGOLIAN LETTER ALI GALI ZHAMONGOL" +
	"IAN LETTER ALI GALI ZAMONGOLIAN LETTER ALI GALI AHMONGOLIAN LETTER TODO " +
	"ALI GALI TAMONGOLIAN LETTER TODO ALI GALI ZHAMONGOLIAN LETTER MANCHU ALI" +
	" GALI GHAMONGOLIAN LETTER MANCHU ALI GALI NGAMONGOLIAN LETTER MANCHU ALI" +
	" GALI CAMONGOLIAN LETTER MANCHU ALI GALI JHAMONGOLIAN LETTER MANCHU ALI " +
	"GALI TTAMONGOLIAN LETTER MANCHU ALI GALI DDHAMONGOLIAN LETTER MANCHU ALI" +
	" GALI TAMONGOLIAN LETTER MANCHU ALI GALI DHAMONGOLIAN LETTER MANCHU ALI " +
	"GALI SSAMONGOLIAN LETTER MANCHU ALI GALI CYAMONGOLIAN LETTER MANCHU ALI " +
	"GALI ZHAMONGOLIAN LETTER MANCHU ALI GALI ZAMONGOLIAN LETTER ALI GALI HAL" +
	"F UMONGOLIAN LETTER ALI GALI HALF YAMONGOLIAN LETTER MANCHU ALI GALI BHA" +
	"MONGOLIAN LETTER ALI GALI DAGALGAMONGOLIAN LETTER MANCHU ALI GALI LHACAN" +
	"ADIAN SYLLABICS OYCANADIAN SYLLABICS AYCANADIAN SYLLABICS AAYCANADIAN SY" +
	"LLABICS WAYCANADIAN SYLLABICS POYCANADIAN SYLLABICS PAYCANADIAN SYLLABIC" +
	"S PWOYCANADIAN SYLLABICS TAYCANADIAN SYLLABICS KAYCANADIAN SYLLABICS KWA" +
	"YCANADIAN SYLLABICS MAYCANADIAN SYLLABICS NOYCANADIAN SYLLABICS NAYCANAD" +
	"IAN SYLLABICS LAYCANADIAN SYLLABICS SOYCANADIAN SYLLABICS SAYCANADIAN SY" +
	"LLABICS SHOYCANADIAN SYLLABICS SHAYCANADIAN SYLLABICS SHWOYCANADIAN SYLL" +
	"ABICS YOYCANADIAN SYLLABICS YAYCANADIAN SYLLABICS RAYCANADIAN SYLLABICS " +
	"NWICANADIAN SYLLABICS OJIBWAY NWICANADIAN SYLLABICS NWIICANADIAN SYLLABI" +
	"CS OJIBWAY NWIICANADIAN SYLLABICS NWOCANADIAN SYLLABICS OJIBWAY NWOCANAD" +
	"IAN SYLLABICS NWOOCANADIAN SYLLABICS OJIBWAY NWOOCANADIAN SYLLABICS RWEE" +
	"CANADIAN SYLLABICS RWICANADIAN SYLLABICS RWIICANADIAN SYLLABICS RWOCANAD" +
	"IAN SYLLABICS RWOOCANADIAN SYLLABICS RWACANADIAN SYLLABICS OJIBWAY PCANA") + ("" +
	"DIAN SYLLABICS OJIBWAY TCANADIAN SYLLABICS OJIBWAY KCANADIAN SYLLABICS O" +
	"JIBWAY CCANADIAN SYLLABICS OJIBWAY MCANADIAN SYLLABICS OJIBWAY NCANADIAN" +
	" SYLLABICS OJIBWAY SCANADIAN SYLLABICS OJIBWAY SHCANADIAN SYLLABICS EAST" +
	"ERN WCANADIAN SYLLABICS WESTERN WCANADIAN SYLLABICS FINAL SMALL RINGCANA" +
	"DIAN SYLLABICS FINAL RAISED DOTCANADIAN SYLLABICS R-CREE RWECANADIAN SYL" +
	"LABICS WEST-CREE LOOCANADIAN SYLLABICS WEST-CREE LAACANADIAN SYLLABICS T" +
	"HWECANADIAN SYLLABICS THWACANADIAN SYLLABICS TTHWECANADIAN SYLLABICS TTH" +
	"OOCANADIAN SYLLABICS TTHAACANADIAN SYLLABICS TLHWECANADIAN SYLLABICS TLH" +
	"OOCANADIAN SYLLABICS SAYISI SHWECANADIAN SYLLABICS SAYISI SHOOCANADIAN S" +
	"YLLABICS SAYISI HOOCANADIAN SYLLABICS CARRIER GWUCANADIAN SYLLABICS CARR" +
	"IER DENE GEECANADIAN SYLLABICS CARRIER GAACANADIAN SYLLABICS CARRIER GWA" +
	"CANADIAN SYLLABICS SAYISI JUUCANADIAN SYLLABICS CARRIER JWACANADIAN SYLL" +
	"ABICS BEAVER DENE LCANADIAN SYLLABICS BEAVER DENE RCANADIAN SYLLABICS CA" +
	"RRIER DENTAL SLIMBU VOWEL-CARRIER LETTERLIMBU LETTER KALIMBU LETTER KHAL" +
	"IMBU LETTER GALIMBU LETTER GHALIMBU LETTER NGALIMBU LETTER CALIMBU LETTE" +
	"R CHALIMBU LETTER JALIMBU LETTER JHALIMBU LETTER YANLIMBU LETTER TALIMBU" +
	" LETTER THALIMBU LETTER DALIMBU LETTER DHALIMBU LETTER NALIMBU LETTER PA" +
	"LIMBU LETTER PHALIMBU LETTER BALIMBU LETTER BHALIMBU LETTER MALIMBU LETT" +
	"ER YALIMBU LETTER RALIMBU LETTER LALIMBU LETTER WALIMBU LETTER SHALIMBU " +
	"LETTER SSALIMBU LETTER SALIMBU LETTER HALIMBU LETTER GYANLIMBU LETTER TR" +
	"ALIMBU VOWEL SIGN ALIMBU VOWEL SIGN ILIMBU VOWEL SIGN ULIMBU VOWEL SIGN " +
	"EELIMBU VOWEL SIGN AILIMBU VOWEL SIGN OOLIMBU VOWEL SIGN AULIMBU VOWEL S" +
	"IGN ELIMBU VOWEL SIGN OLIMBU SUBJOINED LETTER YALIMBU SUBJOINED LETTER R" +
	"ALIMBU SUBJOINED LETTER WALIMBU SMALL LETTER KALIMBU SMALL LETTER NGALIM" +
	"BU SMALL LETTER ANUSVARALIMBU SMALL LETTER TALIMBU SMALL LETTER NALIMBU " +
	"SMALL LETTER PALIMBU SMALL LETTER MALIMBU SMALL LETTER RALIMBU SMALL LET" +
	"TER LALIMBU SIGN MUKPHRENGLIMBU SIGN KEMPHRENGLIMBU SIGN SA-ILIMBU SIGN " +
	"LOOLIMBU EXCLAMATION MARKLIMBU QUESTION MARKLIMBU DIGIT ZEROLIMBU DIGIT " +
	"ONELIMBU DIGIT TWOLIMBU DIGIT THREELIMBU DIGIT FOURLIMBU DIGIT FIVELIMBU" +
	" DIGIT SIXLIMBU DIGIT SEVENLIMBU DIGIT EIGHTLIMBU DIGIT NINETAI LE LETTE" +
	"R KATAI LE LETTER XATAI LE LETTER NGATAI LE LETTER TSATAI LE LETTER SATA" +
	"I LE LETTER YATAI LE LETTER TATAI LE LETTER THATAI LE LETTER LATAI LE LE" +
	"TTER PATAI LE LETTER PHATAI LE LETTER MATAI LE LETTER FATAI LE LETTER VA" +
	"TAI LE LETTER HATAI LE LETTER QATAI LE LETTER KHATAI LE LETTER TSHATAI L" +
	"E LETTER NATAI LE LETTER ATAI LE LETTER ITAI LE LETTER EETAI LE LETTER E" +
	"HTAI LE LETTER UTAI LE LETTER OOTAI LE LETTER OTAI LE LETTER UETAI LE LE" +
	"TTER ETAI LE LETTER AUETAI LE LETTER AITAI LE LETTER TONE-2TAI LE LETTER" +
	" TONE-3TAI LE LETTER TONE-4TAI LE LETTER TONE-5TAI LE LETTER TONE-6NEW T" +
	"AI LUE LETTER HIGH QANEW TAI LUE LETTER LOW QANEW TAI LUE LETTER HIGH KA" +
	"NEW TAI LUE LETTER HIGH XANEW TAI LUE LETTER HIGH NGANEW TAI LUE LETTER " +
	"LOW KANEW TAI LUE LETTER LOW XANEW TAI LUE LETTER LOW NGANEW TAI LUE LET" +
	"TER HIGH TSANEW TAI LUE LETTER HIGH SANEW TAI LUE LETTER HIGH YANEW TAI " +
	"LUE LETTER LOW TSANEW TAI LUE LETTER LOW SANEW TAI LUE LETTER LOW YANEW " +
	"TAI LUE LETTER HIGH TANEW TAI LUE LETTER HIGH THANEW TAI LUE LETTER HIGH" +
	" NANEW TAI LUE LETTER LOW TANEW TAI LUE LETTER LOW THANEW TAI LUE LETTER" +
	" LOW NANEW TAI LUE LETTER HIGH PANEW TAI LUE LETTER HIGH PHANEW TAI LUE " +
	"LETTER HIGH MANEW TAI LUE LETTER LOW PANEW TAI LUE LETTER LOW PHANEW TAI" +
	" LUE LETTER LOW MANEW TAI LUE LETTER HIGH FANEW TAI LUE LETTER HIGH VANE" +
	"W TAI LUE LETTER HIGH LANEW TAI LUE LETTER LOW FANEW TAI LUE LETTER LOW " +
	"VANEW TAI LUE LETTER LOW LANEW TAI LUE LETTER HIGH HANEW TAI LUE LETTER " +
	"HIGH DANEW TAI LUE LETTER HIGH BANEW TAI LUE LETTER LOW HANEW TAI LUE LE" +
	"TTER LOW DANEW TAI LUE LETTER LOW BANEW TAI LUE LETTER HIGH KVANEW TAI L" +
	"UE LETTER HIGH XVANEW TAI LUE LETTER LOW KVANEW TAI LUE LETTER LOW XVANE" +
	"W TAI LUE LETTER HIGH SUANEW TAI LUE LETTER LOW SUANEW TAI LUE VOWEL SIG" +
	"N VOWEL SHORTENERNEW TAI LUE VOWEL SIGN AANEW TAI LUE VOWEL SIGN IINEW T" +
	"AI LUE VOWEL SIGN UNEW TAI LUE VOWEL SIGN UUNEW TAI LUE VOWEL SIGN ENEW " +
	"TAI LUE VOWEL SIGN AENEW TAI LUE VOWEL SIGN ONEW TAI LUE VOWEL SIGN OANE" +
	"W TAI LUE VOWEL SIGN UENEW TAI LUE VOWEL SIGN AYNEW TAI LUE VOWEL SIGN A" +
	"AYNEW TAI LUE VOWEL SIGN UYNEW TAI LUE VOWEL SIGN OYNEW TAI LUE VOWEL SI" +
	"GN OAYNEW TAI LUE VOWEL SIGN UEYNEW TAI LUE VOWEL SIGN IYNEW TAI LUE LET" +
	"TER FINAL VNEW TAI LUE LETTER FINAL NGNEW TAI LUE LETTER FINAL NNEW TAI " +
	"LUE LETTER FINAL MNEW TAI LUE LETTER FINAL KNEW TAI LUE LETTER FINAL DNE" +
	"W TAI LUE LETTER FINAL BNEW TAI LUE TONE MARK-1NEW TAI LUE TONE MARK-2NE" +
	"W TAI LUE DIGIT ZERONEW TAI LUE DIGIT ONENEW TAI LUE DIGIT TWONEW TAI LU") + ("" +
	"E DIGIT THREENEW TAI LUE DIGIT FOURNEW TAI LUE DIGIT FIVENEW TAI LUE DIG" +
	"IT SIXNEW TAI LUE DIGIT SEVENNEW TAI LUE DIGIT EIGHTNEW TAI LUE DIGIT NI" +
	"NENEW TAI LUE THAM DIGIT ONENEW TAI LUE SIGN LAENEW TAI LUE SIGN LAEVKHM" +
	"ER SYMBOL PATHAMASATKHMER SYMBOL MUOY KOETKHMER SYMBOL PII KOETKHMER SYM" +
	"BOL BEI KOETKHMER SYMBOL BUON KOETKHMER SYMBOL PRAM KOETKHMER SYMBOL PRA" +
	"M-MUOY KOETKHMER SYMBOL PRAM-PII KOETKHMER SYMBOL PRAM-BEI KOETKHMER SYM" +
	"BOL PRAM-BUON KOETKHMER SYMBOL DAP KOETKHMER SYMBOL DAP-MUOY KOETKHMER S" +
	"YMBOL DAP-PII KOETKHMER SYMBOL DAP-BEI KOETKHMER SYMBOL DAP-BUON KOETKHM" +
	"ER SYMBOL DAP-PRAM KOETKHMER SYMBOL TUTEYASATKHMER SYMBOL MUOY ROCKHMER " +
	"SYMBOL PII ROCKHMER SYMBOL BEI ROCKHMER SYMBOL BUON ROCKHMER SYMBOL PRAM" +
	" ROCKHMER SYMBOL PRAM-MUOY ROCKHMER SYMBOL PRAM-PII ROCKHMER SYMBOL PRAM" +
	"-BEI ROCKHMER SYMBOL PRAM-BUON ROCKHMER SYMBOL DAP ROCKHMER SYMBOL DAP-M" +
	"UOY ROCKHMER SYMBOL DAP-PII ROCKHMER SYMBOL DAP-BEI ROCKHMER SYMBOL DAP-" +
	"BUON ROCKHMER SYMBOL DAP-PRAM ROCBUGINESE LETTER KABUGINESE LETTER GABUG" +
	"INESE LETTER NGABUGINESE LETTER NGKABUGINESE LETTER PABUGINESE LETTER BA" +
	"BUGINESE LETTER MABUGINESE LETTER MPABUGINESE LETTER TABUGINESE LETTER D" +
	"ABUGINESE LETTER NABUGINESE LETTER NRABUGINESE LETTER CABUGINESE LETTER " +
	"JABUGINESE LETTER NYABUGINESE LETTER NYCABUGINESE LETTER YABUGINESE LETT" +
	"ER RABUGINESE LETTER LABUGINESE LETTER VABUGINESE LETTER SABUGINESE LETT" +
	"ER ABUGINESE LETTER HABUGINESE VOWEL SIGN IBUGINESE VOWEL SIGN UBUGINESE" +
	" VOWEL SIGN EBUGINESE VOWEL SIGN OBUGINESE VOWEL SIGN AEBUGINESE PALLAWA" +
	"BUGINESE END OF SECTIONTAI THAM LETTER HIGH KATAI THAM LETTER HIGH KHATA" +
	"I THAM LETTER HIGH KXATAI THAM LETTER LOW KATAI THAM LETTER LOW KXATAI T" +
	"HAM LETTER LOW KHATAI THAM LETTER NGATAI THAM LETTER HIGH CATAI THAM LET" +
	"TER HIGH CHATAI THAM LETTER LOW CATAI THAM LETTER LOW SATAI THAM LETTER " +
	"LOW CHATAI THAM LETTER NYATAI THAM LETTER RATATAI THAM LETTER HIGH RATHA" +
	"TAI THAM LETTER DATAI THAM LETTER LOW RATHATAI THAM LETTER RANATAI THAM " +
	"LETTER HIGH TATAI THAM LETTER HIGH THATAI THAM LETTER LOW TATAI THAM LET" +
	"TER LOW THATAI THAM LETTER NATAI THAM LETTER BATAI THAM LETTER HIGH PATA" +
	"I THAM LETTER HIGH PHATAI THAM LETTER HIGH FATAI THAM LETTER LOW PATAI T" +
	"HAM LETTER LOW FATAI THAM LETTER LOW PHATAI THAM LETTER MATAI THAM LETTE" +
	"R LOW YATAI THAM LETTER HIGH YATAI THAM LETTER RATAI THAM LETTER RUETAI " +
	"THAM LETTER LATAI THAM LETTER LUETAI THAM LETTER WATAI THAM LETTER HIGH " +
	"SHATAI THAM LETTER HIGH SSATAI THAM LETTER HIGH SATAI THAM LETTER HIGH H" +
	"ATAI THAM LETTER LLATAI THAM LETTER ATAI THAM LETTER LOW HATAI THAM LETT" +
	"ER ITAI THAM LETTER IITAI THAM LETTER UTAI THAM LETTER UUTAI THAM LETTER" +
	" EETAI THAM LETTER OOTAI THAM LETTER LAETAI THAM LETTER GREAT SATAI THAM" +
	" CONSONANT SIGN MEDIAL RATAI THAM CONSONANT SIGN MEDIAL LATAI THAM CONSO" +
	"NANT SIGN LA TANG LAITAI THAM SIGN MAI KANG LAITAI THAM CONSONANT SIGN F" +
	"INAL NGATAI THAM CONSONANT SIGN LOW PATAI THAM CONSONANT SIGN HIGH RATHA" +
	" OR LOW PATAI THAM CONSONANT SIGN MATAI THAM CONSONANT SIGN BATAI THAM C" +
	"ONSONANT SIGN SATAI THAM SIGN SAKOTTAI THAM VOWEL SIGN ATAI THAM VOWEL S" +
	"IGN MAI SATTAI THAM VOWEL SIGN AATAI THAM VOWEL SIGN TALL AATAI THAM VOW" +
	"EL SIGN ITAI THAM VOWEL SIGN IITAI THAM VOWEL SIGN UETAI THAM VOWEL SIGN" +
	" UUETAI THAM VOWEL SIGN UTAI THAM VOWEL SIGN UUTAI THAM VOWEL SIGN OTAI " +
	"THAM VOWEL SIGN OA BELOWTAI THAM VOWEL SIGN OYTAI THAM VOWEL SIGN ETAI T" +
	"HAM VOWEL SIGN AETAI THAM VOWEL SIGN OOTAI THAM VOWEL SIGN AITAI THAM VO" +
	"WEL SIGN THAM AITAI THAM VOWEL SIGN OA ABOVETAI THAM SIGN MAI KANGTAI TH" +
	"AM SIGN TONE-1TAI THAM SIGN TONE-2TAI THAM SIGN KHUEN TONE-3TAI THAM SIG" +
	"N KHUEN TONE-4TAI THAM SIGN KHUEN TONE-5TAI THAM SIGN RA HAAMTAI THAM SI" +
	"GN MAI SAMTAI THAM SIGN KHUEN-LUE KARANTAI THAM COMBINING CRYPTOGRAMMIC " +
	"DOTTAI THAM HORA DIGIT ZEROTAI THAM HORA DIGIT ONETAI THAM HORA DIGIT TW" +
	"OTAI THAM HORA DIGIT THREETAI THAM HORA DIGIT FOURTAI THAM HORA DIGIT FI" +
	"VETAI THAM HORA DIGIT SIXTAI THAM HORA DIGIT SEVENTAI THAM HORA DIGIT EI" +
	"GHTTAI THAM HORA DIGIT NINETAI THAM THAM DIGIT ZEROTAI THAM THAM DIGIT O" +
	"NETAI THAM THAM DIGIT TWOTAI THAM THAM DIGIT THREETAI THAM THAM DIGIT FO" +
	"URTAI THAM THAM DIGIT FIVETAI THAM THAM DIGIT SIXTAI THAM THAM DIGIT SEV" +
	"ENTAI THAM THAM DIGIT EIGHTTAI THAM THAM DIGIT NINETAI THAM SIGN WIANGTA" +
	"I THAM SIGN WIANGWAAKTAI THAM SIGN SAWANTAI THAM SIGN KEOWTAI THAM SIGN " +
	"HOYTAI THAM SIGN DOKMAITAI THAM SIGN REVERSED ROTATED RANATAI THAM SIGN " +
	"MAI YAMOKTAI THAM SIGN KAANTAI THAM SIGN KAANKUUTAI THAM SIGN SATKAANTAI" +
	" THAM SIGN SATKAANKUUTAI THAM SIGN HANGTAI THAM SIGN CAANGCOMBINING DOUB" +
	"LED CIRCUMFLEX ACCENTCOMBINING DIAERESIS-RINGCOMBINING INFINITYCOMBINING" +
	" DOWNWARDS ARROWCOMBINING TRIPLE DOTCOMBINING X-X BELOWCOMBINING WIGGLY ") + ("" +
	"LINE BELOWCOMBINING OPEN MARK BELOWCOMBINING DOUBLE OPEN MARK BELOWCOMBI" +
	"NING LIGHT CENTRALIZATION STROKE BELOWCOMBINING STRONG CENTRALIZATION ST" +
	"ROKE BELOWCOMBINING PARENTHESES ABOVECOMBINING DOUBLE PARENTHESES ABOVEC" +
	"OMBINING PARENTHESES BELOWCOMBINING PARENTHESES OVERLAYBALINESE SIGN ULU" +
	" RICEMBALINESE SIGN ULU CANDRABALINESE SIGN CECEKBALINESE SIGN SURANGBAL" +
	"INESE SIGN BISAHBALINESE LETTER AKARABALINESE LETTER AKARA TEDUNGBALINES" +
	"E LETTER IKARABALINESE LETTER IKARA TEDUNGBALINESE LETTER UKARABALINESE " +
	"LETTER UKARA TEDUNGBALINESE LETTER RA REPABALINESE LETTER RA REPA TEDUNG" +
	"BALINESE LETTER LA LENGABALINESE LETTER LA LENGA TEDUNGBALINESE LETTER E" +
	"KARABALINESE LETTER AIKARABALINESE LETTER OKARABALINESE LETTER OKARA TED" +
	"UNGBALINESE LETTER KABALINESE LETTER KA MAHAPRANABALINESE LETTER GABALIN" +
	"ESE LETTER GA GORABALINESE LETTER NGABALINESE LETTER CABALINESE LETTER C" +
	"A LACABALINESE LETTER JABALINESE LETTER JA JERABALINESE LETTER NYABALINE" +
	"SE LETTER TA LATIKBALINESE LETTER TA MURDA MAHAPRANABALINESE LETTER DA M" +
	"URDA ALPAPRANABALINESE LETTER DA MURDA MAHAPRANABALINESE LETTER NA RAMBA" +
	"TBALINESE LETTER TABALINESE LETTER TA TAWABALINESE LETTER DABALINESE LET" +
	"TER DA MADUBALINESE LETTER NABALINESE LETTER PABALINESE LETTER PA KAPALB" +
	"ALINESE LETTER BABALINESE LETTER BA KEMBANGBALINESE LETTER MABALINESE LE" +
	"TTER YABALINESE LETTER RABALINESE LETTER LABALINESE LETTER WABALINESE LE" +
	"TTER SA SAGABALINESE LETTER SA SAPABALINESE LETTER SABALINESE LETTER HAB" +
	"ALINESE SIGN REREKANBALINESE VOWEL SIGN TEDUNGBALINESE VOWEL SIGN ULUBAL" +
	"INESE VOWEL SIGN ULU SARIBALINESE VOWEL SIGN SUKUBALINESE VOWEL SIGN SUK" +
	"U ILUTBALINESE VOWEL SIGN RA REPABALINESE VOWEL SIGN RA REPA TEDUNGBALIN" +
	"ESE VOWEL SIGN LA LENGABALINESE VOWEL SIGN LA LENGA TEDUNGBALINESE VOWEL" +
	" SIGN TALINGBALINESE VOWEL SIGN TALING REPABALINESE VOWEL SIGN TALING TE" +
	"DUNGBALINESE VOWEL SIGN TALING REPA TEDUNGBALINESE VOWEL SIGN PEPETBALIN" +
	"ESE VOWEL SIGN PEPET TEDUNGBALINESE ADEG ADEGBALINESE LETTER KAF SASAKBA" +
	"LINESE LETTER KHOT SASAKBALINESE LETTER TZIR SASAKBALINESE LETTER EF SAS" +
	"AKBALINESE LETTER VE SASAKBALINESE LETTER ZAL SASAKBALINESE LETTER ASYUR" +
	"A SASAKBALINESE DIGIT ZEROBALINESE DIGIT ONEBALINESE DIGIT TWOBALINESE D" +
	"IGIT THREEBALINESE DIGIT FOURBALINESE DIGIT FIVEBALINESE DIGIT SIXBALINE" +
	"SE DIGIT SEVENBALINESE DIGIT EIGHTBALINESE DIGIT NINEBALINESE PANTIBALIN" +
	"ESE PAMADABALINESE WINDUBALINESE CARIK PAMUNGKAHBALINESE CARIK SIKIBALIN" +
	"ESE CARIK PARERENBALINESE PAMENENGBALINESE MUSICAL SYMBOL DONGBALINESE M" +
	"USICAL SYMBOL DENGBALINESE MUSICAL SYMBOL DUNGBALINESE MUSICAL SYMBOL DA" +
	"NGBALINESE MUSICAL SYMBOL DANG SURANGBALINESE MUSICAL SYMBOL DINGBALINES" +
	"E MUSICAL SYMBOL DAENGBALINESE MUSICAL SYMBOL DEUNGBALINESE MUSICAL SYMB" +
	"OL DAINGBALINESE MUSICAL SYMBOL DANG GEDEBALINESE MUSICAL SYMBOL COMBINI" +
	"NG TEGEHBALINESE MUSICAL SYMBOL COMBINING ENDEPBALINESE MUSICAL SYMBOL C" +
	"OMBINING KEMPULBALINESE MUSICAL SYMBOL COMBINING KEMPLIBALINESE MUSICAL " +
	"SYMBOL COMBINING JEGOGANBALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JE" +
	"GOGANBALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGANBALINESE MUSIC" +
	"AL SYMBOL COMBINING BENDEBALINESE MUSICAL SYMBOL COMBINING GONGBALINESE " +
	"MUSICAL SYMBOL RIGHT-HAND OPEN DUGBALINESE MUSICAL SYMBOL RIGHT-HAND OPE" +
	"N DAGBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUKBALINESE MUSICAL SYMBO" +
	"L RIGHT-HAND CLOSED TAKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANGBALINE" +
	"SE MUSICAL SYMBOL LEFT-HAND OPEN PUNGBALINESE MUSICAL SYMBOL LEFT-HAND C" +
	"LOSED PLAKBALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUKBALINESE MUSICAL " +
	"SYMBOL LEFT-HAND OPEN PINGSUNDANESE SIGN PANYECEKSUNDANESE SIGN PANGLAYA" +
	"RSUNDANESE SIGN PANGWISADSUNDANESE LETTER ASUNDANESE LETTER ISUNDANESE L" +
	"ETTER USUNDANESE LETTER AESUNDANESE LETTER OSUNDANESE LETTER ESUNDANESE " +
	"LETTER EUSUNDANESE LETTER KASUNDANESE LETTER QASUNDANESE LETTER GASUNDAN" +
	"ESE LETTER NGASUNDANESE LETTER CASUNDANESE LETTER JASUNDANESE LETTER ZAS" +
	"UNDANESE LETTER NYASUNDANESE LETTER TASUNDANESE LETTER DASUNDANESE LETTE" +
	"R NASUNDANESE LETTER PASUNDANESE LETTER FASUNDANESE LETTER VASUNDANESE L" +
	"ETTER BASUNDANESE LETTER MASUNDANESE LETTER YASUNDANESE LETTER RASUNDANE" +
	"SE LETTER LASUNDANESE LETTER WASUNDANESE LETTER SASUNDANESE LETTER XASUN" +
	"DANESE LETTER HASUNDANESE CONSONANT SIGN PAMINGKALSUNDANESE CONSONANT SI" +
	"GN PANYAKRASUNDANESE CONSONANT SIGN PANYIKUSUNDANESE VOWEL SIGN PANGHULU" +
	"SUNDANESE VOWEL SIGN PANYUKUSUNDANESE VOWEL SIGN PANAELAENGSUNDANESE VOW" +
	"EL SIGN PANOLONGSUNDANESE VOWEL SIGN PAMEPETSUNDANESE VOWEL SIGN PANEULE" +
	"UNGSUNDANESE SIGN PAMAAEHSUNDANESE SIGN VIRAMASUNDANESE CONSONANT SIGN P" +
	"ASANGAN MASUNDANESE CONSONANT SIGN PASANGAN WASUNDANESE LETTER KHASUNDAN" +
	"ESE LETTER SYASUNDANESE DIGIT ZEROSUNDANESE DIGIT ONESUNDANESE DIGIT TWO") + ("" +
	"SUNDANESE DIGIT THREESUNDANESE DIGIT FOURSUNDANESE DIGIT FIVESUNDANESE D" +
	"IGIT SIXSUNDANESE DIGIT SEVENSUNDANESE DIGIT EIGHTSUNDANESE DIGIT NINESU" +
	"NDANESE AVAGRAHASUNDANESE LETTER REUSUNDANESE LETTER LEUSUNDANESE LETTER" +
	" BHASUNDANESE LETTER FINAL KSUNDANESE LETTER FINAL MBATAK LETTER ABATAK " +
	"LETTER SIMALUNGUN ABATAK LETTER HABATAK LETTER SIMALUNGUN HABATAK LETTER" +
	" MANDAILING HABATAK LETTER BABATAK LETTER KARO BABATAK LETTER PABATAK LE" +
	"TTER SIMALUNGUN PABATAK LETTER NABATAK LETTER MANDAILING NABATAK LETTER " +
	"WABATAK LETTER SIMALUNGUN WABATAK LETTER PAKPAK WABATAK LETTER GABATAK L" +
	"ETTER SIMALUNGUN GABATAK LETTER JABATAK LETTER DABATAK LETTER RABATAK LE" +
	"TTER SIMALUNGUN RABATAK LETTER MABATAK LETTER SIMALUNGUN MABATAK LETTER " +
	"SOUTHERN TABATAK LETTER NORTHERN TABATAK LETTER SABATAK LETTER SIMALUNGU" +
	"N SABATAK LETTER MANDAILING SABATAK LETTER YABATAK LETTER SIMALUNGUN YAB" +
	"ATAK LETTER NGABATAK LETTER LABATAK LETTER SIMALUNGUN LABATAK LETTER NYA" +
	"BATAK LETTER CABATAK LETTER NDABATAK LETTER MBABATAK LETTER IBATAK LETTE" +
	"R UBATAK SIGN TOMPIBATAK VOWEL SIGN EBATAK VOWEL SIGN PAKPAK EBATAK VOWE" +
	"L SIGN EEBATAK VOWEL SIGN IBATAK VOWEL SIGN KARO IBATAK VOWEL SIGN OBATA" +
	"K VOWEL SIGN KARO OBATAK VOWEL SIGN UBATAK VOWEL SIGN U FOR SIMALUNGUN S" +
	"ABATAK CONSONANT SIGN NGBATAK CONSONANT SIGN HBATAK PANGOLATBATAK PANONG" +
	"ONANBATAK SYMBOL BINDU NA METEKBATAK SYMBOL BINDU PINARBORASBATAK SYMBOL" +
	" BINDU JUDULBATAK SYMBOL BINDU PANGOLATLEPCHA LETTER KALEPCHA LETTER KLA" +
	"LEPCHA LETTER KHALEPCHA LETTER GALEPCHA LETTER GLALEPCHA LETTER NGALEPCH" +
	"A LETTER CALEPCHA LETTER CHALEPCHA LETTER JALEPCHA LETTER NYALEPCHA LETT" +
	"ER TALEPCHA LETTER THALEPCHA LETTER DALEPCHA LETTER NALEPCHA LETTER PALE" +
	"PCHA LETTER PLALEPCHA LETTER PHALEPCHA LETTER FALEPCHA LETTER FLALEPCHA " +
	"LETTER BALEPCHA LETTER BLALEPCHA LETTER MALEPCHA LETTER MLALEPCHA LETTER" +
	" TSALEPCHA LETTER TSHALEPCHA LETTER DZALEPCHA LETTER YALEPCHA LETTER RAL" +
	"EPCHA LETTER LALEPCHA LETTER HALEPCHA LETTER HLALEPCHA LETTER VALEPCHA L" +
	"ETTER SALEPCHA LETTER SHALEPCHA LETTER WALEPCHA LETTER ALEPCHA SUBJOINED" +
	" LETTER YALEPCHA SUBJOINED LETTER RALEPCHA VOWEL SIGN AALEPCHA VOWEL SIG" +
	"N ILEPCHA VOWEL SIGN OLEPCHA VOWEL SIGN OOLEPCHA VOWEL SIGN ULEPCHA VOWE" +
	"L SIGN UULEPCHA VOWEL SIGN ELEPCHA CONSONANT SIGN KLEPCHA CONSONANT SIGN" +
	" MLEPCHA CONSONANT SIGN LLEPCHA CONSONANT SIGN NLEPCHA CONSONANT SIGN PL" +
	"EPCHA CONSONANT SIGN RLEPCHA CONSONANT SIGN TLEPCHA CONSONANT SIGN NYIN-" +
	"DOLEPCHA CONSONANT SIGN KANGLEPCHA SIGN RANLEPCHA SIGN NUKTALEPCHA PUNCT" +
	"UATION TA-ROLLEPCHA PUNCTUATION NYET THYOOM TA-ROLLEPCHA PUNCTUATION CER" +
	"-WALEPCHA PUNCTUATION TSHOOK CER-WALEPCHA PUNCTUATION TSHOOKLEPCHA DIGIT" +
	" ZEROLEPCHA DIGIT ONELEPCHA DIGIT TWOLEPCHA DIGIT THREELEPCHA DIGIT FOUR" +
	"LEPCHA DIGIT FIVELEPCHA DIGIT SIXLEPCHA DIGIT SEVENLEPCHA DIGIT EIGHTLEP" +
	"CHA DIGIT NINELEPCHA LETTER TTALEPCHA LETTER TTHALEPCHA LETTER DDAOL CHI" +
	"KI DIGIT ZEROOL CHIKI DIGIT ONEOL CHIKI DIGIT TWOOL CHIKI DIGIT THREEOL " +
	"CHIKI DIGIT FOUROL CHIKI DIGIT FIVEOL CHIKI DIGIT SIXOL CHIKI DIGIT SEVE" +
	"NOL CHIKI DIGIT EIGHTOL CHIKI DIGIT NINEOL CHIKI LETTER LAOL CHIKI LETTE" +
	"R ATOL CHIKI LETTER AGOL CHIKI LETTER ANGOL CHIKI LETTER ALOL CHIKI LETT" +
	"ER LAAOL CHIKI LETTER AAKOL CHIKI LETTER AAJOL CHIKI LETTER AAMOL CHIKI " +
	"LETTER AAWOL CHIKI LETTER LIOL CHIKI LETTER ISOL CHIKI LETTER IHOL CHIKI" +
	" LETTER INYOL CHIKI LETTER IROL CHIKI LETTER LUOL CHIKI LETTER UCOL CHIK" +
	"I LETTER UDOL CHIKI LETTER UNNOL CHIKI LETTER UYOL CHIKI LETTER LEOL CHI" +
	"KI LETTER EPOL CHIKI LETTER EDDOL CHIKI LETTER ENOL CHIKI LETTER ERROL C" +
	"HIKI LETTER LOOL CHIKI LETTER OTTOL CHIKI LETTER OBOL CHIKI LETTER OVOL " +
	"CHIKI LETTER OHOL CHIKI MU TTUDDAGOL CHIKI GAAHLAA TTUDDAAGOL CHIKI MU-G" +
	"AAHLAA TTUDDAAGOL CHIKI RELAAOL CHIKI PHAARKAAOL CHIKI AHADOL CHIKI PUNC" +
	"TUATION MUCAADOL CHIKI PUNCTUATION DOUBLE MUCAADCYRILLIC SMALL LETTER RO" +
	"UNDED VECYRILLIC SMALL LETTER LONG-LEGGED DECYRILLIC SMALL LETTER NARROW" +
	" OCYRILLIC SMALL LETTER WIDE ESCYRILLIC SMALL LETTER TALL TECYRILLIC SMA" +
	"LL LETTER THREE-LEGGED TECYRILLIC SMALL LETTER TALL HARD SIGNCYRILLIC SM" +
	"ALL LETTER TALL YATCYRILLIC SMALL LETTER UNBLENDED UKGEORGIAN MTAVRULI C" +
	"APITAL LETTER ANGEORGIAN MTAVRULI CAPITAL LETTER BANGEORGIAN MTAVRULI CA" +
	"PITAL LETTER GANGEORGIAN MTAVRULI CAPITAL LETTER DONGEORGIAN MTAVRULI CA" +
	"PITAL LETTER ENGEORGIAN MTAVRULI CAPITAL LETTER VINGEORGIAN MTAVRULI CAP" +
	"ITAL LETTER ZENGEORGIAN MTAVRULI CAPITAL LETTER TANGEORGIAN MTAVRULI CAP" +
	"ITAL LETTER INGEORGIAN MTAVRULI CAPITAL LETTER KANGEORGIAN MTAVRULI CAPI" +
	"TAL LETTER LASGEORGIAN MTAVRULI CAPITAL LETTER MANGEORGIAN MTAVRULI CAPI" +
	"TAL LETTER NARGEORGIAN MTAVRULI CAPITAL LETTER ONGEORGIAN MTAVRULI CAPIT" +
	"AL LETTER PARGEORGIAN MTAVRULI CAPITAL LETTER ZHARGEORGIAN MTAVRULI CAPI") + ("" +
	"TAL LETTER RAEGEORGIAN MTAVRULI CAPITAL LETTER SANGEORGIAN MTAVRULI CAPI" +
	"TAL LETTER TARGEORGIAN MTAVRULI CAPITAL LETTER UNGEORGIAN MTAVRULI CAPIT" +
	"AL LETTER PHARGEORGIAN MTAVRULI CAPITAL LETTER KHARGEORGIAN MTAVRULI CAP" +
	"ITAL LETTER GHANGEORGIAN MTAVRULI CAPITAL LETTER QARGEORGIAN MTAVRULI CA" +
	"PITAL LETTER SHINGEORGIAN MTAVRULI CAPITAL LETTER CHINGEORGIAN MTAVRULI " +
	"CAPITAL LETTER CANGEORGIAN MTAVRULI CAPITAL LETTER JILGEORGIAN MTAVRULI " +
	"CAPITAL LETTER CILGEORGIAN MTAVRULI CAPITAL LETTER CHARGEORGIAN MTAVRULI" +
	" CAPITAL LETTER XANGEORGIAN MTAVRULI CAPITAL LETTER JHANGEORGIAN MTAVRUL" +
	"I CAPITAL LETTER HAEGEORGIAN MTAVRULI CAPITAL LETTER HEGEORGIAN MTAVRULI" +
	" CAPITAL LETTER HIEGEORGIAN MTAVRULI CAPITAL LETTER WEGEORGIAN MTAVRULI " +
	"CAPITAL LETTER HARGEORGIAN MTAVRULI CAPITAL LETTER HOEGEORGIAN MTAVRULI " +
	"CAPITAL LETTER FIGEORGIAN MTAVRULI CAPITAL LETTER YNGEORGIAN MTAVRULI CA" +
	"PITAL LETTER ELIFIGEORGIAN MTAVRULI CAPITAL LETTER TURNED GANGEORGIAN MT" +
	"AVRULI CAPITAL LETTER AINGEORGIAN MTAVRULI CAPITAL LETTER AENGEORGIAN MT" +
	"AVRULI CAPITAL LETTER HARD SIGNGEORGIAN MTAVRULI CAPITAL LETTER LABIAL S" +
	"IGNSUNDANESE PUNCTUATION BINDU SURYASUNDANESE PUNCTUATION BINDU PANGLONG" +
	"SUNDANESE PUNCTUATION BINDU PURNAMASUNDANESE PUNCTUATION BINDU CAKRASUND" +
	"ANESE PUNCTUATION BINDU LEU SATANGASUNDANESE PUNCTUATION BINDU KA SATANG" +
	"ASUNDANESE PUNCTUATION BINDU DA SATANGASUNDANESE PUNCTUATION BINDU BA SA" +
	"TANGAVEDIC TONE KARSHANAVEDIC TONE SHARAVEDIC TONE PRENKHAVEDIC SIGN NIH" +
	"SHVASAVEDIC SIGN YAJURVEDIC MIDLINE SVARITAVEDIC TONE YAJURVEDIC AGGRAVA" +
	"TED INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC INDEPENDENT SVARITAVEDIC TO" +
	"NE YAJURVEDIC KATHAKA INDEPENDENT SVARITAVEDIC TONE CANDRA BELOWVEDIC TO" +
	"NE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDERVEDIC TONE DOUBLE SVA" +
	"RITAVEDIC TONE TRIPLE SVARITAVEDIC TONE KATHAKA ANUDATTAVEDIC TONE DOT B" +
	"ELOWVEDIC TONE TWO DOTS BELOWVEDIC TONE THREE DOTS BELOWVEDIC TONE RIGVE" +
	"DIC KASHMIRI INDEPENDENT SVARITAVEDIC TONE ATHARVAVEDIC INDEPENDENT SVAR" +
	"ITAVEDIC SIGN VISARGA SVARITAVEDIC SIGN VISARGA UDATTAVEDIC SIGN REVERSE" +
	"D VISARGA UDATTAVEDIC SIGN VISARGA ANUDATTAVEDIC SIGN REVERSED VISARGA A" +
	"NUDATTAVEDIC SIGN VISARGA UDATTA WITH TAILVEDIC SIGN VISARGA ANUDATTA WI" +
	"TH TAILVEDIC SIGN ANUSVARA ANTARGOMUKHAVEDIC SIGN ANUSVARA BAHIRGOMUKHAV" +
	"EDIC SIGN ANUSVARA VAMAGOMUKHAVEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAILV" +
	"EDIC SIGN TIRYAKVEDIC SIGN HEXIFORM LONG ANUSVARAVEDIC SIGN LONG ANUSVAR" +
	"AVEDIC SIGN RTHANG LONG ANUSVARAVEDIC SIGN ANUSVARA UBHAYATO MUKHAVEDIC " +
	"SIGN ARDHAVISARGAVEDIC SIGN ROTATED ARDHAVISARGAVEDIC TONE CANDRA ABOVEV" +
	"EDIC SIGN JIHVAMULIYAVEDIC SIGN UPADHMANIYAVEDIC SIGN ATIKRAMAVEDIC TONE" +
	" RING ABOVEVEDIC TONE DOUBLE RING ABOVELATIN LETTER SMALL CAPITAL ALATIN" +
	" LETTER SMALL CAPITAL AELATIN SMALL LETTER TURNED AELATIN LETTER SMALL C" +
	"APITAL BARRED BLATIN LETTER SMALL CAPITAL CLATIN LETTER SMALL CAPITAL DL" +
	"ATIN LETTER SMALL CAPITAL ETHLATIN LETTER SMALL CAPITAL ELATIN SMALL LET" +
	"TER TURNED OPEN ELATIN SMALL LETTER TURNED ILATIN LETTER SMALL CAPITAL J" +
	"LATIN LETTER SMALL CAPITAL KLATIN LETTER SMALL CAPITAL L WITH STROKELATI" +
	"N LETTER SMALL CAPITAL MLATIN LETTER SMALL CAPITAL REVERSED NLATIN LETTE" +
	"R SMALL CAPITAL OLATIN LETTER SMALL CAPITAL OPEN OLATIN SMALL LETTER SID" +
	"EWAYS OLATIN SMALL LETTER SIDEWAYS OPEN OLATIN SMALL LETTER SIDEWAYS O W" +
	"ITH STROKELATIN SMALL LETTER TURNED OELATIN LETTER SMALL CAPITAL OULATIN" +
	" SMALL LETTER TOP HALF OLATIN SMALL LETTER BOTTOM HALF OLATIN LETTER SMA" +
	"LL CAPITAL PLATIN LETTER SMALL CAPITAL REVERSED RLATIN LETTER SMALL CAPI" +
	"TAL TURNED RLATIN LETTER SMALL CAPITAL TLATIN LETTER SMALL CAPITAL ULATI" +
	"N SMALL LETTER SIDEWAYS ULATIN SMALL LETTER SIDEWAYS DIAERESIZED ULATIN " +
	"SMALL LETTER SIDEWAYS TURNED MLATIN LETTER SMALL CAPITAL VLATIN LETTER S" +
	"MALL CAPITAL WLATIN LETTER SMALL CAPITAL ZLATIN LETTER SMALL CAPITAL EZH" +
	"LATIN LETTER VOICED LARYNGEAL SPIRANTLATIN LETTER AINGREEK LETTER SMALL " +
	"CAPITAL GAMMAGREEK LETTER SMALL CAPITAL LAMDAGREEK LETTER SMALL CAPITAL " +
	"PIGREEK LETTER SMALL CAPITAL RHOGREEK LETTER SMALL CAPITAL PSICYRILLIC L" +
	"ETTER SMALL CAPITAL ELMODIFIER LETTER CAPITAL AMODIFIER LETTER CAPITAL A" +
	"EMODIFIER LETTER CAPITAL BMODIFIER LETTER CAPITAL BARRED BMODIFIER LETTE" +
	"R CAPITAL DMODIFIER LETTER CAPITAL EMODIFIER LETTER CAPITAL REVERSED EMO" +
	"DIFIER LETTER CAPITAL GMODIFIER LETTER CAPITAL HMODIFIER LETTER CAPITAL " +
	"IMODIFIER LETTER CAPITAL JMODIFIER LETTER CAPITAL KMODIFIER LETTER CAPIT" +
	"AL LMODIFIER LETTER CAPITAL MMODIFIER LETTER CAPITAL NMODIFIER LETTER CA" +
	"PITAL REVERSED NMODIFIER LETTER CAPITAL OMODIFIER LETTER CAPITAL OUMODIF" +
	"IER LETTER CAPITAL PMODIFIER LETTER CAPITAL RMODIFIER LETTER CAPITAL TMO" +
	"DIFIER LETTER CAPITAL UMODIFIER LETTER CAPITAL WMODIFIER LETTER SMALL AM") + ("" +
	"ODIFIER LETTER SMALL TURNED AMODIFIER LETTER SMALL ALPHAMODIFIER LETTER " +
	"SMALL TURNED AEMODIFIER LETTER SMALL BMODIFIER LETTER SMALL DMODIFIER LE" +
	"TTER SMALL EMODIFIER LETTER SMALL SCHWAMODIFIER LETTER SMALL OPEN EMODIF" +
	"IER LETTER SMALL TURNED OPEN EMODIFIER LETTER SMALL GMODIFIER LETTER SMA" +
	"LL TURNED IMODIFIER LETTER SMALL KMODIFIER LETTER SMALL MMODIFIER LETTER" +
	" SMALL ENGMODIFIER LETTER SMALL OMODIFIER LETTER SMALL OPEN OMODIFIER LE" +
	"TTER SMALL TOP HALF OMODIFIER LETTER SMALL BOTTOM HALF OMODIFIER LETTER " +
	"SMALL PMODIFIER LETTER SMALL TMODIFIER LETTER SMALL UMODIFIER LETTER SMA" +
	"LL SIDEWAYS UMODIFIER LETTER SMALL TURNED MMODIFIER LETTER SMALL VMODIFI" +
	"ER LETTER SMALL AINMODIFIER LETTER SMALL BETAMODIFIER LETTER SMALL GREEK" +
	" GAMMAMODIFIER LETTER SMALL DELTAMODIFIER LETTER SMALL GREEK PHIMODIFIER" +
	" LETTER SMALL CHILATIN SUBSCRIPT SMALL LETTER ILATIN SUBSCRIPT SMALL LET" +
	"TER RLATIN SUBSCRIPT SMALL LETTER ULATIN SUBSCRIPT SMALL LETTER VGREEK S" +
	"UBSCRIPT SMALL LETTER BETAGREEK SUBSCRIPT SMALL LETTER GAMMAGREEK SUBSCR" +
	"IPT SMALL LETTER RHOGREEK SUBSCRIPT SMALL LETTER PHIGREEK SUBSCRIPT SMAL" +
	"L LETTER CHILATIN SMALL LETTER UELATIN SMALL LETTER B WITH MIDDLE TILDEL" +
	"ATIN SMALL LETTER D WITH MIDDLE TILDELATIN SMALL LETTER F WITH MIDDLE TI" +
	"LDELATIN SMALL LETTER M WITH MIDDLE TILDELATIN SMALL LETTER N WITH MIDDL" +
	"E TILDELATIN SMALL LETTER P WITH MIDDLE TILDELATIN SMALL LETTER R WITH M" +
	"IDDLE TILDELATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDELATIN SMAL" +
	"L LETTER S WITH MIDDLE TILDELATIN SMALL LETTER T WITH MIDDLE TILDELATIN " +
	"SMALL LETTER Z WITH MIDDLE TILDELATIN SMALL LETTER TURNED GMODIFIER LETT" +
	"ER CYRILLIC ENLATIN SMALL LETTER INSULAR GLATIN SMALL LETTER TH WITH STR" +
	"IKETHROUGHLATIN SMALL CAPITAL LETTER I WITH STROKELATIN SMALL LETTER IOT" +
	"A WITH STROKELATIN SMALL LETTER P WITH STROKELATIN SMALL CAPITAL LETTER " +
	"U WITH STROKELATIN SMALL LETTER UPSILON WITH STROKELATIN SMALL LETTER B " +
	"WITH PALATAL HOOKLATIN SMALL LETTER D WITH PALATAL HOOKLATIN SMALL LETTE" +
	"R F WITH PALATAL HOOKLATIN SMALL LETTER G WITH PALATAL HOOKLATIN SMALL L" +
	"ETTER K WITH PALATAL HOOKLATIN SMALL LETTER L WITH PALATAL HOOKLATIN SMA" +
	"LL LETTER M WITH PALATAL HOOKLATIN SMALL LETTER N WITH PALATAL HOOKLATIN" +
	" SMALL LETTER P WITH PALATAL HOOKLATIN SMALL LETTER R WITH PALATAL HOOKL" +
	"ATIN SMALL LETTER S WITH PALATAL HOOKLATIN SMALL LETTER ESH WITH PALATAL" +
	" HOOKLATIN SMALL LETTER V WITH PALATAL HOOKLATIN SMALL LETTER X WITH PAL" +
	"ATAL HOOKLATIN SMALL LETTER Z WITH PALATAL HOOKLATIN SMALL LETTER A WITH" +
	" RETROFLEX HOOKLATIN SMALL LETTER ALPHA WITH RETROFLEX HOOKLATIN SMALL L" +
	"ETTER D WITH HOOK AND TAILLATIN SMALL LETTER E WITH RETROFLEX HOOKLATIN " +
	"SMALL LETTER OPEN E WITH RETROFLEX HOOKLATIN SMALL LETTER REVERSED OPEN " +
	"E WITH RETROFLEX HOOKLATIN SMALL LETTER SCHWA WITH RETROFLEX HOOKLATIN S" +
	"MALL LETTER I WITH RETROFLEX HOOKLATIN SMALL LETTER OPEN O WITH RETROFLE" +
	"X HOOKLATIN SMALL LETTER ESH WITH RETROFLEX HOOKLATIN SMALL LETTER U WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER EZH WITH RETROFLEX HOOKMODIFIER LETTE" +
	"R SMALL TURNED ALPHAMODIFIER LETTER SMALL CMODIFIER LETTER SMALL C WITH " +
	"CURLMODIFIER LETTER SMALL ETHMODIFIER LETTER SMALL REVERSED OPEN EMODIFI" +
	"ER LETTER SMALL FMODIFIER LETTER SMALL DOTLESS J WITH STROKEMODIFIER LET" +
	"TER SMALL SCRIPT GMODIFIER LETTER SMALL TURNED HMODIFIER LETTER SMALL I " +
	"WITH STROKEMODIFIER LETTER SMALL IOTAMODIFIER LETTER SMALL CAPITAL IMODI" +
	"FIER LETTER SMALL CAPITAL I WITH STROKEMODIFIER LETTER SMALL J WITH CROS" +
	"SED-TAILMODIFIER LETTER SMALL L WITH RETROFLEX HOOKMODIFIER LETTER SMALL" +
	" L WITH PALATAL HOOKMODIFIER LETTER SMALL CAPITAL LMODIFIER LETTER SMALL" +
	" M WITH HOOKMODIFIER LETTER SMALL TURNED M WITH LONG LEGMODIFIER LETTER " +
	"SMALL N WITH LEFT HOOKMODIFIER LETTER SMALL N WITH RETROFLEX HOOKMODIFIE" +
	"R LETTER SMALL CAPITAL NMODIFIER LETTER SMALL BARRED OMODIFIER LETTER SM" +
	"ALL PHIMODIFIER LETTER SMALL S WITH HOOKMODIFIER LETTER SMALL ESHMODIFIE" +
	"R LETTER SMALL T WITH PALATAL HOOKMODIFIER LETTER SMALL U BARMODIFIER LE" +
	"TTER SMALL UPSILONMODIFIER LETTER SMALL CAPITAL UMODIFIER LETTER SMALL V" +
	" WITH HOOKMODIFIER LETTER SMALL TURNED VMODIFIER LETTER SMALL ZMODIFIER " +
	"LETTER SMALL Z WITH RETROFLEX HOOKMODIFIER LETTER SMALL Z WITH CURLMODIF" +
	"IER LETTER SMALL EZHMODIFIER LETTER SMALL THETACOMBINING DOTTED GRAVE AC" +
	"CENTCOMBINING DOTTED ACUTE ACCENTCOMBINING SNAKE BELOWCOMBINING SUSPENSI" +
	"ON MARKCOMBINING MACRON-ACUTECOMBINING GRAVE-MACRONCOMBINING MACRON-GRAV" +
	"ECOMBINING ACUTE-MACRONCOMBINING GRAVE-ACUTE-GRAVECOMBINING ACUTE-GRAVE-" +
	"ACUTECOMBINING LATIN SMALL LETTER R BELOWCOMBINING BREVE-MACRONCOMBINING" +
	" MACRON-BREVECOMBINING DOUBLE CIRCUMFLEX ABOVECOMBINING OGONEK ABOVECOMB" +
	"INING ZIGZAG BELOWCOMBINING IS BELOWCOMBINING UR ABOVECOMBINING US ABOVE") + ("" +
	"COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVECOMBINING LATIN SMALL" +
	" LETTER AECOMBINING LATIN SMALL LETTER AOCOMBINING LATIN SMALL LETTER AV" +
	"COMBINING LATIN SMALL LETTER C CEDILLACOMBINING LATIN SMALL LETTER INSUL" +
	"AR DCOMBINING LATIN SMALL LETTER ETHCOMBINING LATIN SMALL LETTER GCOMBIN" +
	"ING LATIN LETTER SMALL CAPITAL GCOMBINING LATIN SMALL LETTER KCOMBINING " +
	"LATIN SMALL LETTER LCOMBINING LATIN LETTER SMALL CAPITAL LCOMBINING LATI" +
	"N LETTER SMALL CAPITAL MCOMBINING LATIN SMALL LETTER NCOMBINING LATIN LE" +
	"TTER SMALL CAPITAL NCOMBINING LATIN LETTER SMALL CAPITAL RCOMBINING LATI" +
	"N SMALL LETTER R ROTUNDACOMBINING LATIN SMALL LETTER SCOMBINING LATIN SM" +
	"ALL LETTER LONG SCOMBINING LATIN SMALL LETTER ZCOMBINING LATIN SMALL LET" +
	"TER ALPHACOMBINING LATIN SMALL LETTER BCOMBINING LATIN SMALL LETTER BETA" +
	"COMBINING LATIN SMALL LETTER SCHWACOMBINING LATIN SMALL LETTER FCOMBININ" +
	"G LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDECOMBINING LATIN SMALL LET" +
	"TER O WITH LIGHT CENTRALIZATION STROKECOMBINING LATIN SMALL LETTER PCOMB" +
	"INING LATIN SMALL LETTER ESHCOMBINING LATIN SMALL LETTER U WITH LIGHT CE" +
	"NTRALIZATION STROKECOMBINING LATIN SMALL LETTER WCOMBINING LATIN SMALL L" +
	"ETTER A WITH DIAERESISCOMBINING LATIN SMALL LETTER O WITH DIAERESISCOMBI" +
	"NING LATIN SMALL LETTER U WITH DIAERESISCOMBINING UP TACK ABOVECOMBINING" +
	" KAVYKA ABOVE RIGHTCOMBINING KAVYKA ABOVE LEFTCOMBINING DOT ABOVE LEFTCO" +
	"MBINING WIDE INVERTED BRIDGE BELOWCOMBINING DELETION MARKCOMBINING DOUBL" +
	"E INVERTED BREVE BELOWCOMBINING ALMOST EQUAL TO BELOWCOMBINING LEFT ARRO" +
	"WHEAD ABOVECOMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOWLATIN CAPIT" +
	"AL LETTER A WITH RING BELOWLATIN SMALL LETTER A WITH RING BELOWLATIN CAP" +
	"ITAL LETTER B WITH DOT ABOVELATIN SMALL LETTER B WITH DOT ABOVELATIN CAP" +
	"ITAL LETTER B WITH DOT BELOWLATIN SMALL LETTER B WITH DOT BELOWLATIN CAP" +
	"ITAL LETTER B WITH LINE BELOWLATIN SMALL LETTER B WITH LINE BELOWLATIN C" +
	"APITAL LETTER C WITH CEDILLA AND ACUTELATIN SMALL LETTER C WITH CEDILLA " +
	"AND ACUTELATIN CAPITAL LETTER D WITH DOT ABOVELATIN SMALL LETTER D WITH " +
	"DOT ABOVELATIN CAPITAL LETTER D WITH DOT BELOWLATIN SMALL LETTER D WITH " +
	"DOT BELOWLATIN CAPITAL LETTER D WITH LINE BELOWLATIN SMALL LETTER D WITH" +
	" LINE BELOWLATIN CAPITAL LETTER D WITH CEDILLALATIN SMALL LETTER D WITH " +
	"CEDILLALATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOWLATIN SMALL LETTER D " +
	"WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER E WITH MACRON AND GRAVELATIN S" +
	"MALL LETTER E WITH MACRON AND GRAVELATIN CAPITAL LETTER E WITH MACRON AN" +
	"D ACUTELATIN SMALL LETTER E WITH MACRON AND ACUTELATIN CAPITAL LETTER E " +
	"WITH CIRCUMFLEX BELOWLATIN SMALL LETTER E WITH CIRCUMFLEX BELOWLATIN CAP" +
	"ITAL LETTER E WITH TILDE BELOWLATIN SMALL LETTER E WITH TILDE BELOWLATIN" +
	" CAPITAL LETTER E WITH CEDILLA AND BREVELATIN SMALL LETTER E WITH CEDILL" +
	"A AND BREVELATIN CAPITAL LETTER F WITH DOT ABOVELATIN SMALL LETTER F WIT" +
	"H DOT ABOVELATIN CAPITAL LETTER G WITH MACRONLATIN SMALL LETTER G WITH M" +
	"ACRONLATIN CAPITAL LETTER H WITH DOT ABOVELATIN SMALL LETTER H WITH DOT " +
	"ABOVELATIN CAPITAL LETTER H WITH DOT BELOWLATIN SMALL LETTER H WITH DOT " +
	"BELOWLATIN CAPITAL LETTER H WITH DIAERESISLATIN SMALL LETTER H WITH DIAE" +
	"RESISLATIN CAPITAL LETTER H WITH CEDILLALATIN SMALL LETTER H WITH CEDILL" +
	"ALATIN CAPITAL LETTER H WITH BREVE BELOWLATIN SMALL LETTER H WITH BREVE " +
	"BELOWLATIN CAPITAL LETTER I WITH TILDE BELOWLATIN SMALL LETTER I WITH TI" +
	"LDE BELOWLATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTELATIN SMALL LETT" +
	"ER I WITH DIAERESIS AND ACUTELATIN CAPITAL LETTER K WITH ACUTELATIN SMAL" +
	"L LETTER K WITH ACUTELATIN CAPITAL LETTER K WITH DOT BELOWLATIN SMALL LE" +
	"TTER K WITH DOT BELOWLATIN CAPITAL LETTER K WITH LINE BELOWLATIN SMALL L" +
	"ETTER K WITH LINE BELOWLATIN CAPITAL LETTER L WITH DOT BELOWLATIN SMALL " +
	"LETTER L WITH DOT BELOWLATIN CAPITAL LETTER L WITH DOT BELOW AND MACRONL" +
	"ATIN SMALL LETTER L WITH DOT BELOW AND MACRONLATIN CAPITAL LETTER L WITH" +
	" LINE BELOWLATIN SMALL LETTER L WITH LINE BELOWLATIN CAPITAL LETTER L WI" +
	"TH CIRCUMFLEX BELOWLATIN SMALL LETTER L WITH CIRCUMFLEX BELOWLATIN CAPIT" +
	"AL LETTER M WITH ACUTELATIN SMALL LETTER M WITH ACUTELATIN CAPITAL LETTE" +
	"R M WITH DOT ABOVELATIN SMALL LETTER M WITH DOT ABOVELATIN CAPITAL LETTE" +
	"R M WITH DOT BELOWLATIN SMALL LETTER M WITH DOT BELOWLATIN CAPITAL LETTE" +
	"R N WITH DOT ABOVELATIN SMALL LETTER N WITH DOT ABOVELATIN CAPITAL LETTE" +
	"R N WITH DOT BELOWLATIN SMALL LETTER N WITH DOT BELOWLATIN CAPITAL LETTE" +
	"R N WITH LINE BELOWLATIN SMALL LETTER N WITH LINE BELOWLATIN CAPITAL LET" +
	"TER N WITH CIRCUMFLEX BELOWLATIN SMALL LETTER N WITH CIRCUMFLEX BELOWLAT" +
	"IN CAPITAL LETTER O WITH TILDE AND ACUTELATIN SMALL LETTER O WITH TILDE " +
	"AND ACUTELATIN CAPITAL LETTER O WITH TILDE AND DIAERESISLATIN SMALL LETT") + ("" +
	"ER O WITH TILDE AND DIAERESISLATIN CAPITAL LETTER O WITH MACRON AND GRAV" +
	"ELATIN SMALL LETTER O WITH MACRON AND GRAVELATIN CAPITAL LETTER O WITH M" +
	"ACRON AND ACUTELATIN SMALL LETTER O WITH MACRON AND ACUTELATIN CAPITAL L" +
	"ETTER P WITH ACUTELATIN SMALL LETTER P WITH ACUTELATIN CAPITAL LETTER P " +
	"WITH DOT ABOVELATIN SMALL LETTER P WITH DOT ABOVELATIN CAPITAL LETTER R " +
	"WITH DOT ABOVELATIN SMALL LETTER R WITH DOT ABOVELATIN CAPITAL LETTER R " +
	"WITH DOT BELOWLATIN SMALL LETTER R WITH DOT BELOWLATIN CAPITAL LETTER R " +
	"WITH DOT BELOW AND MACRONLATIN SMALL LETTER R WITH DOT BELOW AND MACRONL" +
	"ATIN CAPITAL LETTER R WITH LINE BELOWLATIN SMALL LETTER R WITH LINE BELO" +
	"WLATIN CAPITAL LETTER S WITH DOT ABOVELATIN SMALL LETTER S WITH DOT ABOV" +
	"ELATIN CAPITAL LETTER S WITH DOT BELOWLATIN SMALL LETTER S WITH DOT BELO" +
	"WLATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVELATIN SMALL LETTER S WIT" +
	"H ACUTE AND DOT ABOVELATIN CAPITAL LETTER S WITH CARON AND DOT ABOVELATI" +
	"N SMALL LETTER S WITH CARON AND DOT ABOVELATIN CAPITAL LETTER S WITH DOT" +
	" BELOW AND DOT ABOVELATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVELAT" +
	"IN CAPITAL LETTER T WITH DOT ABOVELATIN SMALL LETTER T WITH DOT ABOVELAT" +
	"IN CAPITAL LETTER T WITH DOT BELOWLATIN SMALL LETTER T WITH DOT BELOWLAT" +
	"IN CAPITAL LETTER T WITH LINE BELOWLATIN SMALL LETTER T WITH LINE BELOWL" +
	"ATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOWLATIN SMALL LETTER T WITH CIR" +
	"CUMFLEX BELOWLATIN CAPITAL LETTER U WITH DIAERESIS BELOWLATIN SMALL LETT" +
	"ER U WITH DIAERESIS BELOWLATIN CAPITAL LETTER U WITH TILDE BELOWLATIN SM" +
	"ALL LETTER U WITH TILDE BELOWLATIN CAPITAL LETTER U WITH CIRCUMFLEX BELO" +
	"WLATIN SMALL LETTER U WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER U WITH T" +
	"ILDE AND ACUTELATIN SMALL LETTER U WITH TILDE AND ACUTELATIN CAPITAL LET" +
	"TER U WITH MACRON AND DIAERESISLATIN SMALL LETTER U WITH MACRON AND DIAE" +
	"RESISLATIN CAPITAL LETTER V WITH TILDELATIN SMALL LETTER V WITH TILDELAT" +
	"IN CAPITAL LETTER V WITH DOT BELOWLATIN SMALL LETTER V WITH DOT BELOWLAT" +
	"IN CAPITAL LETTER W WITH GRAVELATIN SMALL LETTER W WITH GRAVELATIN CAPIT" +
	"AL LETTER W WITH ACUTELATIN SMALL LETTER W WITH ACUTELATIN CAPITAL LETTE" +
	"R W WITH DIAERESISLATIN SMALL LETTER W WITH DIAERESISLATIN CAPITAL LETTE" +
	"R W WITH DOT ABOVELATIN SMALL LETTER W WITH DOT ABOVELATIN CAPITAL LETTE" +
	"R W WITH DOT BELOWLATIN SMALL LETTER W WITH DOT BELOWLATIN CAPITAL LETTE" +
	"R X WITH DOT ABOVELATIN SMALL LETTER X WITH DOT ABOVELATIN CAPITAL LETTE" +
	"R X WITH DIAERESISLATIN SMALL LETTER X WITH DIAERESISLATIN CAPITAL LETTE" +
	"R Y WITH DOT ABOVELATIN SMALL LETTER Y WITH DOT ABOVELATIN CAPITAL LETTE" +
	"R Z WITH CIRCUMFLEXLATIN SMALL LETTER Z WITH CIRCUMFLEXLATIN CAPITAL LET" +
	"TER Z WITH DOT BELOWLATIN SMALL LETTER Z WITH DOT BELOWLATIN CAPITAL LET" +
	"TER Z WITH LINE BELOWLATIN SMALL LETTER Z WITH LINE BELOWLATIN SMALL LET" +
	"TER H WITH LINE BELOWLATIN SMALL LETTER T WITH DIAERESISLATIN SMALL LETT" +
	"ER W WITH RING ABOVELATIN SMALL LETTER Y WITH RING ABOVELATIN SMALL LETT" +
	"ER A WITH RIGHT HALF RINGLATIN SMALL LETTER LONG S WITH DOT ABOVELATIN S" +
	"MALL LETTER LONG S WITH DIAGONAL STROKELATIN SMALL LETTER LONG S WITH HI" +
	"GH STROKELATIN CAPITAL LETTER SHARP SLATIN SMALL LETTER DELTALATIN CAPIT" +
	"AL LETTER A WITH DOT BELOWLATIN SMALL LETTER A WITH DOT BELOWLATIN CAPIT" +
	"AL LETTER A WITH HOOK ABOVELATIN SMALL LETTER A WITH HOOK ABOVELATIN CAP" +
	"ITAL LETTER A WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER A WITH CIRCUMF" +
	"LEX AND ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVELATIN SMALL" +
	" LETTER A WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER A WITH CIRCUMFLE" +
	"X AND HOOK ABOVELATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVELATIN" +
	" CAPITAL LETTER A WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER A WITH CIR" +
	"CUMFLEX AND TILDELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOWLAT" +
	"IN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER A WI" +
	"TH BREVE AND ACUTELATIN SMALL LETTER A WITH BREVE AND ACUTELATIN CAPITAL" +
	" LETTER A WITH BREVE AND GRAVELATIN SMALL LETTER A WITH BREVE AND GRAVEL" +
	"ATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVELATIN SMALL LETTER A WITH" +
	" BREVE AND HOOK ABOVELATIN CAPITAL LETTER A WITH BREVE AND TILDELATIN SM" +
	"ALL LETTER A WITH BREVE AND TILDELATIN CAPITAL LETTER A WITH BREVE AND D" +
	"OT BELOWLATIN SMALL LETTER A WITH BREVE AND DOT BELOWLATIN CAPITAL LETTE" +
	"R E WITH DOT BELOWLATIN SMALL LETTER E WITH DOT BELOWLATIN CAPITAL LETTE" +
	"R E WITH HOOK ABOVELATIN SMALL LETTER E WITH HOOK ABOVELATIN CAPITAL LET" +
	"TER E WITH TILDELATIN SMALL LETTER E WITH TILDELATIN CAPITAL LETTER E WI" +
	"TH CIRCUMFLEX AND ACUTELATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTELAT" +
	"IN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER E WITH C" +
	"IRCUMFLEX AND GRAVELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE") + ("" +
	"LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER " +
	"E WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER E WITH CIRCUMFLEX AND TILD" +
	"ELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER " +
	"E WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER I WITH HOOK ABOVELAT" +
	"IN SMALL LETTER I WITH HOOK ABOVELATIN CAPITAL LETTER I WITH DOT BELOWLA" +
	"TIN SMALL LETTER I WITH DOT BELOWLATIN CAPITAL LETTER O WITH DOT BELOWLA" +
	"TIN SMALL LETTER O WITH DOT BELOWLATIN CAPITAL LETTER O WITH HOOK ABOVEL" +
	"ATIN SMALL LETTER O WITH HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCUMFLE" +
	"X AND ACUTELATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER O WITH CIRCUMFLEX AN" +
	"D GRAVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL " +
	"LETTER O WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCU" +
	"MFLEX AND TILDELATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDELATIN CAPIT" +
	"AL LETTER O WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER O WITH CIRCU" +
	"MFLEX AND DOT BELOWLATIN CAPITAL LETTER O WITH HORN AND ACUTELATIN SMALL" +
	" LETTER O WITH HORN AND ACUTELATIN CAPITAL LETTER O WITH HORN AND GRAVEL" +
	"ATIN SMALL LETTER O WITH HORN AND GRAVELATIN CAPITAL LETTER O WITH HORN " +
	"AND HOOK ABOVELATIN SMALL LETTER O WITH HORN AND HOOK ABOVELATIN CAPITAL" +
	" LETTER O WITH HORN AND TILDELATIN SMALL LETTER O WITH HORN AND TILDELAT" +
	"IN CAPITAL LETTER O WITH HORN AND DOT BELOWLATIN SMALL LETTER O WITH HOR" +
	"N AND DOT BELOWLATIN CAPITAL LETTER U WITH DOT BELOWLATIN SMALL LETTER U" +
	" WITH DOT BELOWLATIN CAPITAL LETTER U WITH HOOK ABOVELATIN SMALL LETTER " +
	"U WITH HOOK ABOVELATIN CAPITAL LETTER U WITH HORN AND ACUTELATIN SMALL L" +
	"ETTER U WITH HORN AND ACUTELATIN CAPITAL LETTER U WITH HORN AND GRAVELAT" +
	"IN SMALL LETTER U WITH HORN AND GRAVELATIN CAPITAL LETTER U WITH HORN AN" +
	"D HOOK ABOVELATIN SMALL LETTER U WITH HORN AND HOOK ABOVELATIN CAPITAL L" +
	"ETTER U WITH HORN AND TILDELATIN SMALL LETTER U WITH HORN AND TILDELATIN" +
	" CAPITAL LETTER U WITH HORN AND DOT BELOWLATIN SMALL LETTER U WITH HORN " +
	"AND DOT BELOWLATIN CAPITAL LETTER Y WITH GRAVELATIN SMALL LETTER Y WITH " +
	"GRAVELATIN CAPITAL LETTER Y WITH DOT BELOWLATIN SMALL LETTER Y WITH DOT " +
	"BELOWLATIN CAPITAL LETTER Y WITH HOOK ABOVELATIN SMALL LETTER Y WITH HOO" +
	"K ABOVELATIN CAPITAL LETTER Y WITH TILDELATIN SMALL LETTER Y WITH TILDEL" +
	"ATIN CAPITAL LETTER MIDDLE-WELSH LLLATIN SMALL LETTER MIDDLE-WELSH LLLAT" +
	"IN CAPITAL LETTER MIDDLE-WELSH VLATIN SMALL LETTER MIDDLE-WELSH VLATIN C" +
	"APITAL LETTER Y WITH LOOPLATIN SMALL LETTER Y WITH LOOPGREEK SMALL LETTE" +
	"R ALPHA WITH PSILIGREEK SMALL LETTER ALPHA WITH DASIAGREEK SMALL LETTER " +
	"ALPHA WITH PSILI AND VARIAGREEK SMALL LETTER ALPHA WITH DASIA AND VARIAG" +
	"REEK SMALL LETTER ALPHA WITH PSILI AND OXIAGREEK SMALL LETTER ALPHA WITH" +
	" DASIA AND OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENIGREEK " +
	"SMALL LETTER ALPHA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER ALPHA " +
	"WITH PSILIGREEK CAPITAL LETTER ALPHA WITH DASIAGREEK CAPITAL LETTER ALPH" +
	"A WITH PSILI AND VARIAGREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIAGRE" +
	"EK CAPITAL LETTER ALPHA WITH PSILI AND OXIAGREEK CAPITAL LETTER ALPHA WI" +
	"TH DASIA AND OXIAGREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENIGR" +
	"EEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER EP" +
	"SILON WITH PSILIGREEK SMALL LETTER EPSILON WITH DASIAGREEK SMALL LETTER " +
	"EPSILON WITH PSILI AND VARIAGREEK SMALL LETTER EPSILON WITH DASIA AND VA" +
	"RIAGREEK SMALL LETTER EPSILON WITH PSILI AND OXIAGREEK SMALL LETTER EPSI" +
	"LON WITH DASIA AND OXIAGREEK CAPITAL LETTER EPSILON WITH PSILIGREEK CAPI" +
	"TAL LETTER EPSILON WITH DASIAGREEK CAPITAL LETTER EPSILON WITH PSILI AND" +
	" VARIAGREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIAGREEK CAPITAL LET" +
	"TER EPSILON WITH PSILI AND OXIAGREEK CAPITAL LETTER EPSILON WITH DASIA A" +
	"ND OXIAGREEK SMALL LETTER ETA WITH PSILIGREEK SMALL LETTER ETA WITH DASI" +
	"AGREEK SMALL LETTER ETA WITH PSILI AND VARIAGREEK SMALL LETTER ETA WITH " +
	"DASIA AND VARIAGREEK SMALL LETTER ETA WITH PSILI AND OXIAGREEK SMALL LET" +
	"TER ETA WITH DASIA AND OXIAGREEK SMALL LETTER ETA WITH PSILI AND PERISPO" +
	"MENIGREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTE" +
	"R ETA WITH PSILIGREEK CAPITAL LETTER ETA WITH DASIAGREEK CAPITAL LETTER " +
	"ETA WITH PSILI AND VARIAGREEK CAPITAL LETTER ETA WITH DASIA AND VARIAGRE" +
	"EK CAPITAL LETTER ETA WITH PSILI AND OXIAGREEK CAPITAL LETTER ETA WITH D" +
	"ASIA AND OXIAGREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENIGREEK CA" +
	"PITAL LETTER ETA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER IOTA WITH " +
	"PSILIGREEK SMALL LETTER IOTA WITH DASIAGREEK SMALL LETTER IOTA WITH PSIL" +
	"I AND VARIAGREEK SMALL LETTER IOTA WITH DASIA AND VARIAGREEK SMALL LETTE") + ("" +
	"R IOTA WITH PSILI AND OXIAGREEK SMALL LETTER IOTA WITH DASIA AND OXIAGRE" +
	"EK SMALL LETTER IOTA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER IOTA W" +
	"ITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH PSILIGREEK CAPIT" +
	"AL LETTER IOTA WITH DASIAGREEK CAPITAL LETTER IOTA WITH PSILI AND VARIAG" +
	"REEK CAPITAL LETTER IOTA WITH DASIA AND VARIAGREEK CAPITAL LETTER IOTA W" +
	"ITH PSILI AND OXIAGREEK CAPITAL LETTER IOTA WITH DASIA AND OXIAGREEK CAP" +
	"ITAL LETTER IOTA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER IOTA WIT" +
	"H DASIA AND PERISPOMENIGREEK SMALL LETTER OMICRON WITH PSILIGREEK SMALL " +
	"LETTER OMICRON WITH DASIAGREEK SMALL LETTER OMICRON WITH PSILI AND VARIA" +
	"GREEK SMALL LETTER OMICRON WITH DASIA AND VARIAGREEK SMALL LETTER OMICRO" +
	"N WITH PSILI AND OXIAGREEK SMALL LETTER OMICRON WITH DASIA AND OXIAGREEK" +
	" CAPITAL LETTER OMICRON WITH PSILIGREEK CAPITAL LETTER OMICRON WITH DASI" +
	"AGREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIAGREEK CAPITAL LETTER O" +
	"MICRON WITH DASIA AND VARIAGREEK CAPITAL LETTER OMICRON WITH PSILI AND O" +
	"XIAGREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIAGREEK SMALL LETTER UP" +
	"SILON WITH PSILIGREEK SMALL LETTER UPSILON WITH DASIAGREEK SMALL LETTER " +
	"UPSILON WITH PSILI AND VARIAGREEK SMALL LETTER UPSILON WITH DASIA AND VA" +
	"RIAGREEK SMALL LETTER UPSILON WITH PSILI AND OXIAGREEK SMALL LETTER UPSI" +
	"LON WITH DASIA AND OXIAGREEK SMALL LETTER UPSILON WITH PSILI AND PERISPO" +
	"MENIGREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENIGREEK CAPITAL L" +
	"ETTER UPSILON WITH DASIAGREEK CAPITAL LETTER UPSILON WITH DASIA AND VARI" +
	"AGREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIAGREEK CAPITAL LETTER UP" +
	"SILON WITH DASIA AND PERISPOMENIGREEK SMALL LETTER OMEGA WITH PSILIGREEK" +
	" SMALL LETTER OMEGA WITH DASIAGREEK SMALL LETTER OMEGA WITH PSILI AND VA" +
	"RIAGREEK SMALL LETTER OMEGA WITH DASIA AND VARIAGREEK SMALL LETTER OMEGA" +
	" WITH PSILI AND OXIAGREEK SMALL LETTER OMEGA WITH DASIA AND OXIAGREEK SM" +
	"ALL LETTER OMEGA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER OMEGA WITH" +
	" DASIA AND PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH PSILIGREEK CAPITAL" +
	" LETTER OMEGA WITH DASIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIAG" +
	"REEK CAPITAL LETTER OMEGA WITH DASIA AND VARIAGREEK CAPITAL LETTER OMEGA" +
	" WITH PSILI AND OXIAGREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIAGREEK " +
	"CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER OMEG" +
	"A WITH DASIA AND PERISPOMENIGREEK SMALL LETTER ALPHA WITH VARIAGREEK SMA" +
	"LL LETTER ALPHA WITH OXIAGREEK SMALL LETTER EPSILON WITH VARIAGREEK SMAL" +
	"L LETTER EPSILON WITH OXIAGREEK SMALL LETTER ETA WITH VARIAGREEK SMALL L" +
	"ETTER ETA WITH OXIAGREEK SMALL LETTER IOTA WITH VARIAGREEK SMALL LETTER " +
	"IOTA WITH OXIAGREEK SMALL LETTER OMICRON WITH VARIAGREEK SMALL LETTER OM" +
	"ICRON WITH OXIAGREEK SMALL LETTER UPSILON WITH VARIAGREEK SMALL LETTER U" +
	"PSILON WITH OXIAGREEK SMALL LETTER OMEGA WITH VARIAGREEK SMALL LETTER OM" +
	"EGA WITH OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENIGREEK " +
	"SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA " +
	"WITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASI" +
	"A AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND OXI" +
	"A AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOG" +
	"EGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGR" +
	"AMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMM" +
	"ENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL" +
	" LETTER ALPHA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WI" +
	"TH PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DAS" +
	"IA AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND" +
	" OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA A" +
	"ND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI A" +
	"ND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI A" +
	"ND PROSGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENIGREE" +
	"K SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WI" +
	"TH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AN" +
	"D VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND OXIA AND " +
	"YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMEN" +
	"IGREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREE" +
	"K SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAP" +
	"ITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WI" +
	"TH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND VARIA" +
	" AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PRO" +
	"SGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMME") + ("" +
	"NIGREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK C" +
	"APITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAP" +
	"ITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL" +
	" LETTER OMEGA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH " +
	"DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND" +
	" YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRA" +
	"MMENIGREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK" +
	" SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LET" +
	"TER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER" +
	" OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER " +
	"OMEGA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA" +
	" AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND P" +
	"ROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEG" +
	"RAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI" +
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK C" +
	"APITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK C" +
	"APITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK S" +
	"MALL LETTER ALPHA WITH VRACHYGREEK SMALL LETTER ALPHA WITH MACRONGREEK S" +
	"MALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA W" +
	"ITH YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENIGRE" +
	"EK SMALL LETTER ALPHA WITH PERISPOMENIGREEK SMALL LETTER ALPHA WITH PERI" +
	"SPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH VRACHYGREEK CAP" +
	"ITAL LETTER ALPHA WITH MACRONGREEK CAPITAL LETTER ALPHA WITH VARIAGREEK " +
	"CAPITAL LETTER ALPHA WITH OXIAGREEK CAPITAL LETTER ALPHA WITH PROSGEGRAM" +
	"MENIGREEK KORONISGREEK PROSGEGRAMMENIGREEK PSILIGREEK PERISPOMENIGREEK D" +
	"IALYTIKA AND PERISPOMENIGREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMM" +
	"ENIGREEK SMALL LETTER ETA WITH YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH " +
	"OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PERISPOMENIGREEK SMALL" +
	" LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER EPSIL" +
	"ON WITH VARIAGREEK CAPITAL LETTER EPSILON WITH OXIAGREEK CAPITAL LETTER " +
	"ETA WITH VARIAGREEK CAPITAL LETTER ETA WITH OXIAGREEK CAPITAL LETTER ETA" +
	" WITH PROSGEGRAMMENIGREEK PSILI AND VARIAGREEK PSILI AND OXIAGREEK PSILI" +
	" AND PERISPOMENIGREEK SMALL LETTER IOTA WITH VRACHYGREEK SMALL LETTER IO" +
	"TA WITH MACRONGREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIAGREEK SMAL" +
	"L LETTER IOTA WITH DIALYTIKA AND OXIAGREEK SMALL LETTER IOTA WITH PERISP" +
	"OMENIGREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL" +
	" LETTER IOTA WITH VRACHYGREEK CAPITAL LETTER IOTA WITH MACRONGREEK CAPIT" +
	"AL LETTER IOTA WITH VARIAGREEK CAPITAL LETTER IOTA WITH OXIAGREEK DASIA " +
	"AND VARIAGREEK DASIA AND OXIAGREEK DASIA AND PERISPOMENIGREEK SMALL LETT" +
	"ER UPSILON WITH VRACHYGREEK SMALL LETTER UPSILON WITH MACRONGREEK SMALL " +
	"LETTER UPSILON WITH DIALYTIKA AND VARIAGREEK SMALL LETTER UPSILON WITH D" +
	"IALYTIKA AND OXIAGREEK SMALL LETTER RHO WITH PSILIGREEK SMALL LETTER RHO" +
	" WITH DASIAGREEK SMALL LETTER UPSILON WITH PERISPOMENIGREEK SMALL LETTER" +
	" UPSILON WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL LETTER UPSILON WITH" +
	" VRACHYGREEK CAPITAL LETTER UPSILON WITH MACRONGREEK CAPITAL LETTER UPSI" +
	"LON WITH VARIAGREEK CAPITAL LETTER UPSILON WITH OXIAGREEK CAPITAL LETTER" +
	" RHO WITH DASIAGREEK DIALYTIKA AND VARIAGREEK DIALYTIKA AND OXIAGREEK VA" +
	"RIAGREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETT" +
	"ER OMEGA WITH YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEG" +
	"RAMMENIGREEK SMALL LETTER OMEGA WITH PERISPOMENIGREEK SMALL LETTER OMEGA" +
	" WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER OMICRON WITH VAR" +
	"IAGREEK CAPITAL LETTER OMICRON WITH OXIAGREEK CAPITAL LETTER OMEGA WITH " +
	"VARIAGREEK CAPITAL LETTER OMEGA WITH OXIAGREEK CAPITAL LETTER OMEGA WITH" +
	" PROSGEGRAMMENIGREEK OXIAGREEK DASIAEN QUADEM QUADEN SPACEEM SPACETHREE-" +
	"PER-EM SPACEFOUR-PER-EM SPACESIX-PER-EM SPACEFIGURE SPACEPUNCTUATION SPA" +
	"CETHIN SPACEHAIR SPACEZERO WIDTH SPACEZERO WIDTH NON-JOINERZERO WIDTH JO" +
	"INERLEFT-TO-RIGHT MARKRIGHT-TO-LEFT MARKHYPHENNON-BREAKING HYPHENFIGURE " +
	"DASHEN DASHEM DASHHORIZONTAL BARDOUBLE VERTICAL LINEDOUBLE LOW LINELEFT " +
	"SINGLE QUOTATION MARKRIGHT SINGLE QUOTATION MARKSINGLE LOW-9 QUOTATION M" +
	"ARKSINGLE HIGH-REVERSED-9 QUOTATION MARKLEFT DOUBLE QUOTATION MARKRIGHT " +
	"DOUBLE QUOTATION MARKDOUBLE LOW-9 QUOTATION MARKDOUBLE HIGH-REVERSED-9 Q" +
	"UOTATION MARKDAGGERDOUBLE DAGGERBULLETTRIANGULAR BULLETONE DOT LEADERTWO" +
	" DOT LEADERHORIZONTAL ELLIPSISHYPHENATION POINTLINE SEPARATORPARAGRAPH S" +
	"EPARATORLEFT-TO-RIGHT EMBEDDINGRIGHT-TO-LEFT EMBEDDINGPOP DIRECTIONAL FO") + ("" +
	"RMATTINGLEFT-TO-RIGHT OVERRIDERIGHT-TO-LEFT OVERRIDENARROW NO-BREAK SPAC" +
	"EPER MILLE SIGNPER TEN THOUSAND SIGNPRIMEDOUBLE PRIMETRIPLE PRIMEREVERSE" +
	"D PRIMEREVERSED DOUBLE PRIMEREVERSED TRIPLE PRIMECARETSINGLE LEFT-POINTI" +
	"NG ANGLE QUOTATION MARKSINGLE RIGHT-POINTING ANGLE QUOTATION MARKREFEREN" +
	"CE MARKDOUBLE EXCLAMATION MARKINTERROBANGOVERLINEUNDERTIECHARACTER TIECA" +
	"RET INSERTION POINTASTERISMHYPHEN BULLETFRACTION SLASHLEFT SQUARE BRACKE" +
	"T WITH QUILLRIGHT SQUARE BRACKET WITH QUILLDOUBLE QUESTION MARKQUESTION " +
	"EXCLAMATION MARKEXCLAMATION QUESTION MARKTIRONIAN SIGN ETREVERSED PILCRO" +
	"W SIGNBLACK LEFTWARDS BULLETBLACK RIGHTWARDS BULLETLOW ASTERISKREVERSED " +
	"SEMICOLONCLOSE UPTWO ASTERISKS ALIGNED VERTICALLYCOMMERCIAL MINUS SIGNSW" +
	"UNG DASHINVERTED UNDERTIEFLOWER PUNCTUATION MARKTHREE DOT PUNCTUATIONQUA" +
	"DRUPLE PRIMEFOUR DOT PUNCTUATIONFIVE DOT PUNCTUATIONTWO DOT PUNCTUATIONF" +
	"OUR DOT MARKDOTTED CROSSTRICOLONVERTICAL FOUR DOTSMEDIUM MATHEMATICAL SP" +
	"ACEWORD JOINERFUNCTION APPLICATIONINVISIBLE TIMESINVISIBLE SEPARATORINVI" +
	"SIBLE PLUSLEFT-TO-RIGHT ISOLATERIGHT-TO-LEFT ISOLATEFIRST STRONG ISOLATE" +
	"POP DIRECTIONAL ISOLATEINHIBIT SYMMETRIC SWAPPINGACTIVATE SYMMETRIC SWAP" +
	"PINGINHIBIT ARABIC FORM SHAPINGACTIVATE ARABIC FORM SHAPINGNATIONAL DIGI" +
	"T SHAPESNOMINAL DIGIT SHAPESSUPERSCRIPT ZEROSUPERSCRIPT LATIN SMALL LETT" +
	"ER ISUPERSCRIPT FOURSUPERSCRIPT FIVESUPERSCRIPT SIXSUPERSCRIPT SEVENSUPE" +
	"RSCRIPT EIGHTSUPERSCRIPT NINESUPERSCRIPT PLUS SIGNSUPERSCRIPT MINUSSUPER" +
	"SCRIPT EQUALS SIGNSUPERSCRIPT LEFT PARENTHESISSUPERSCRIPT RIGHT PARENTHE" +
	"SISSUPERSCRIPT LATIN SMALL LETTER NSUBSCRIPT ZEROSUBSCRIPT ONESUBSCRIPT " +
	"TWOSUBSCRIPT THREESUBSCRIPT FOURSUBSCRIPT FIVESUBSCRIPT SIXSUBSCRIPT SEV" +
	"ENSUBSCRIPT EIGHTSUBSCRIPT NINESUBSCRIPT PLUS SIGNSUBSCRIPT MINUSSUBSCRI" +
	"PT EQUALS SIGNSUBSCRIPT LEFT PARENTHESISSUBSCRIPT RIGHT PARENTHESISLATIN" +
	" SUBSCRIPT SMALL LETTER ALATIN SUBSCRIPT SMALL LETTER ELATIN SUBSCRIPT S" +
	"MALL LETTER OLATIN SUBSCRIPT SMALL LETTER XLATIN SUBSCRIPT SMALL LETTER " +
	"SCHWALATIN SUBSCRIPT SMALL LETTER HLATIN SUBSCRIPT SMALL LETTER KLATIN S" +
	"UBSCRIPT SMALL LETTER LLATIN SUBSCRIPT SMALL LETTER MLATIN SUBSCRIPT SMA" +
	"LL LETTER NLATIN SUBSCRIPT SMALL LETTER PLATIN SUBSCRIPT SMALL LETTER SL" +
	"ATIN SUBSCRIPT SMALL LETTER TEURO-CURRENCY SIGNCOLON SIGNCRUZEIRO SIGNFR" +
	"ENCH FRANC SIGNLIRA SIGNMILL SIGNNAIRA SIGNPESETA SIGNRUPEE SIGNWON SIGN" +
	"NEW SHEQEL SIGNDONG SIGNEURO SIGNKIP SIGNTUGRIK SIGNDRACHMA SIGNGERMAN P" +
	"ENNY SIGNPESO SIGNGUARANI SIGNAUSTRAL SIGNHRYVNIA SIGNCEDI SIGNLIVRE TOU" +
	"RNOIS SIGNSPESMILO SIGNTENGE SIGNINDIAN RUPEE SIGNTURKISH LIRA SIGNNORDI" +
	"C MARK SIGNMANAT SIGNRUBLE SIGNLARI SIGNBITCOIN SIGNCOMBINING LEFT HARPO" +
	"ON ABOVECOMBINING RIGHT HARPOON ABOVECOMBINING LONG VERTICAL LINE OVERLA" +
	"YCOMBINING SHORT VERTICAL LINE OVERLAYCOMBINING ANTICLOCKWISE ARROW ABOV" +
	"ECOMBINING CLOCKWISE ARROW ABOVECOMBINING LEFT ARROW ABOVECOMBINING RIGH" +
	"T ARROW ABOVECOMBINING RING OVERLAYCOMBINING CLOCKWISE RING OVERLAYCOMBI" +
	"NING ANTICLOCKWISE RING OVERLAYCOMBINING THREE DOTS ABOVECOMBINING FOUR " +
	"DOTS ABOVECOMBINING ENCLOSING CIRCLECOMBINING ENCLOSING SQUARECOMBINING " +
	"ENCLOSING DIAMONDCOMBINING ENCLOSING CIRCLE BACKSLASHCOMBINING LEFT RIGH" +
	"T ARROW ABOVECOMBINING ENCLOSING SCREENCOMBINING ENCLOSING KEYCAPCOMBINI" +
	"NG ENCLOSING UPWARD POINTING TRIANGLECOMBINING REVERSE SOLIDUS OVERLAYCO" +
	"MBINING DOUBLE VERTICAL STROKE OVERLAYCOMBINING ANNUITY SYMBOLCOMBINING " +
	"TRIPLE UNDERDOTCOMBINING WIDE BRIDGE ABOVECOMBINING LEFTWARDS ARROW OVER" +
	"LAYCOMBINING LONG DOUBLE SOLIDUS OVERLAYCOMBINING RIGHTWARDS HARPOON WIT" +
	"H BARB DOWNWARDSCOMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDSCOMBINING" +
	" LEFT ARROW BELOWCOMBINING RIGHT ARROW BELOWCOMBINING ASTERISK ABOVEACCO" +
	"UNT OFADDRESSED TO THE SUBJECTDOUBLE-STRUCK CAPITAL CDEGREE CELSIUSCENTR" +
	"E LINE SYMBOLCARE OFCADA UNAEULER CONSTANTSCRUPLEDEGREE FAHRENHEITSCRIPT" +
	" SMALL GSCRIPT CAPITAL HBLACK-LETTER CAPITAL HDOUBLE-STRUCK CAPITAL HPLA" +
	"NCK CONSTANTPLANCK CONSTANT OVER TWO PISCRIPT CAPITAL IBLACK-LETTER CAPI" +
	"TAL ISCRIPT CAPITAL LSCRIPT SMALL LL B BAR SYMBOLDOUBLE-STRUCK CAPITAL N" +
	"NUMERO SIGNSOUND RECORDING COPYRIGHTSCRIPT CAPITAL PDOUBLE-STRUCK CAPITA" +
	"L PDOUBLE-STRUCK CAPITAL QSCRIPT CAPITAL RBLACK-LETTER CAPITAL RDOUBLE-S" +
	"TRUCK CAPITAL RPRESCRIPTION TAKERESPONSESERVICE MARKTELEPHONE SIGNTRADE " +
	"MARK SIGNVERSICLEDOUBLE-STRUCK CAPITAL ZOUNCE SIGNOHM SIGNINVERTED OHM S" +
	"IGNBLACK-LETTER CAPITAL ZTURNED GREEK SMALL LETTER IOTAKELVIN SIGNANGSTR" +
	"OM SIGNSCRIPT CAPITAL BBLACK-LETTER CAPITAL CESTIMATED SYMBOLSCRIPT SMAL" +
	"L ESCRIPT CAPITAL ESCRIPT CAPITAL FTURNED CAPITAL FSCRIPT CAPITAL MSCRIP" +
	"T SMALL OALEF SYMBOLBET SYMBOLGIMEL SYMBOLDALET SYMBOLINFORMATION SOURCE" +
	"ROTATED CAPITAL QFACSIMILE SIGNDOUBLE-STRUCK SMALL PIDOUBLE-STRUCK SMALL") + ("" +
	" GAMMADOUBLE-STRUCK CAPITAL GAMMADOUBLE-STRUCK CAPITAL PIDOUBLE-STRUCK N" +
	"-ARY SUMMATIONTURNED SANS-SERIF CAPITAL GTURNED SANS-SERIF CAPITAL LREVE" +
	"RSED SANS-SERIF CAPITAL LTURNED SANS-SERIF CAPITAL YDOUBLE-STRUCK ITALIC" +
	" CAPITAL DDOUBLE-STRUCK ITALIC SMALL DDOUBLE-STRUCK ITALIC SMALL EDOUBLE" +
	"-STRUCK ITALIC SMALL IDOUBLE-STRUCK ITALIC SMALL JPROPERTY LINETURNED AM" +
	"PERSANDPER SIGNAKTIESELSKABTURNED SMALL FSYMBOL FOR SAMARITAN SOURCEVULG" +
	"AR FRACTION ONE SEVENTHVULGAR FRACTION ONE NINTHVULGAR FRACTION ONE TENT" +
	"HVULGAR FRACTION ONE THIRDVULGAR FRACTION TWO THIRDSVULGAR FRACTION ONE " +
	"FIFTHVULGAR FRACTION TWO FIFTHSVULGAR FRACTION THREE FIFTHSVULGAR FRACTI" +
	"ON FOUR FIFTHSVULGAR FRACTION ONE SIXTHVULGAR FRACTION FIVE SIXTHSVULGAR" +
	" FRACTION ONE EIGHTHVULGAR FRACTION THREE EIGHTHSVULGAR FRACTION FIVE EI" +
	"GHTHSVULGAR FRACTION SEVEN EIGHTHSFRACTION NUMERATOR ONEROMAN NUMERAL ON" +
	"EROMAN NUMERAL TWOROMAN NUMERAL THREEROMAN NUMERAL FOURROMAN NUMERAL FIV" +
	"EROMAN NUMERAL SIXROMAN NUMERAL SEVENROMAN NUMERAL EIGHTROMAN NUMERAL NI" +
	"NEROMAN NUMERAL TENROMAN NUMERAL ELEVENROMAN NUMERAL TWELVEROMAN NUMERAL" +
	" FIFTYROMAN NUMERAL ONE HUNDREDROMAN NUMERAL FIVE HUNDREDROMAN NUMERAL O" +
	"NE THOUSANDSMALL ROMAN NUMERAL ONESMALL ROMAN NUMERAL TWOSMALL ROMAN NUM" +
	"ERAL THREESMALL ROMAN NUMERAL FOURSMALL ROMAN NUMERAL FIVESMALL ROMAN NU" +
	"MERAL SIXSMALL ROMAN NUMERAL SEVENSMALL ROMAN NUMERAL EIGHTSMALL ROMAN N" +
	"UMERAL NINESMALL ROMAN NUMERAL TENSMALL ROMAN NUMERAL ELEVENSMALL ROMAN " +
	"NUMERAL TWELVESMALL ROMAN NUMERAL FIFTYSMALL ROMAN NUMERAL ONE HUNDREDSM" +
	"ALL ROMAN NUMERAL FIVE HUNDREDSMALL ROMAN NUMERAL ONE THOUSANDROMAN NUME" +
	"RAL ONE THOUSAND C DROMAN NUMERAL FIVE THOUSANDROMAN NUMERAL TEN THOUSAN" +
	"DROMAN NUMERAL REVERSED ONE HUNDREDLATIN SMALL LETTER REVERSED CROMAN NU" +
	"MERAL SIX LATE FORMROMAN NUMERAL FIFTY EARLY FORMROMAN NUMERAL FIFTY THO" +
	"USANDROMAN NUMERAL ONE HUNDRED THOUSANDVULGAR FRACTION ZERO THIRDSTURNED" +
	" DIGIT TWOTURNED DIGIT THREELEFTWARDS ARROWUPWARDS ARROWRIGHTWARDS ARROW" +
	"DOWNWARDS ARROWLEFT RIGHT ARROWUP DOWN ARROWNORTH WEST ARROWNORTH EAST A" +
	"RROWSOUTH EAST ARROWSOUTH WEST ARROWLEFTWARDS ARROW WITH STROKERIGHTWARD" +
	"S ARROW WITH STROKELEFTWARDS WAVE ARROWRIGHTWARDS WAVE ARROWLEFTWARDS TW" +
	"O HEADED ARROWUPWARDS TWO HEADED ARROWRIGHTWARDS TWO HEADED ARROWDOWNWAR" +
	"DS TWO HEADED ARROWLEFTWARDS ARROW WITH TAILRIGHTWARDS ARROW WITH TAILLE" +
	"FTWARDS ARROW FROM BARUPWARDS ARROW FROM BARRIGHTWARDS ARROW FROM BARDOW" +
	"NWARDS ARROW FROM BARUP DOWN ARROW WITH BASELEFTWARDS ARROW WITH HOOKRIG" +
	"HTWARDS ARROW WITH HOOKLEFTWARDS ARROW WITH LOOPRIGHTWARDS ARROW WITH LO" +
	"OPLEFT RIGHT WAVE ARROWLEFT RIGHT ARROW WITH STROKEDOWNWARDS ZIGZAG ARRO" +
	"WUPWARDS ARROW WITH TIP LEFTWARDSUPWARDS ARROW WITH TIP RIGHTWARDSDOWNWA" +
	"RDS ARROW WITH TIP LEFTWARDSDOWNWARDS ARROW WITH TIP RIGHTWARDSRIGHTWARD" +
	"S ARROW WITH CORNER DOWNWARDSDOWNWARDS ARROW WITH CORNER LEFTWARDSANTICL" +
	"OCKWISE TOP SEMICIRCLE ARROWCLOCKWISE TOP SEMICIRCLE ARROWNORTH WEST ARR" +
	"OW TO LONG BARLEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BARANTICLO" +
	"CKWISE OPEN CIRCLE ARROWCLOCKWISE OPEN CIRCLE ARROWLEFTWARDS HARPOON WIT" +
	"H BARB UPWARDSLEFTWARDS HARPOON WITH BARB DOWNWARDSUPWARDS HARPOON WITH " +
	"BARB RIGHTWARDSUPWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS HARPOON WIT" +
	"H BARB UPWARDSRIGHTWARDS HARPOON WITH BARB DOWNWARDSDOWNWARDS HARPOON WI" +
	"TH BARB RIGHTWARDSDOWNWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS ARROW " +
	"OVER LEFTWARDS ARROWUPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROWLEFTWARDS " +
	"ARROW OVER RIGHTWARDS ARROWLEFTWARDS PAIRED ARROWSUPWARDS PAIRED ARROWSR" +
	"IGHTWARDS PAIRED ARROWSDOWNWARDS PAIRED ARROWSLEFTWARDS HARPOON OVER RIG" +
	"HTWARDS HARPOONRIGHTWARDS HARPOON OVER LEFTWARDS HARPOONLEFTWARDS DOUBLE" +
	" ARROW WITH STROKELEFT RIGHT DOUBLE ARROW WITH STROKERIGHTWARDS DOUBLE A" +
	"RROW WITH STROKELEFTWARDS DOUBLE ARROWUPWARDS DOUBLE ARROWRIGHTWARDS DOU" +
	"BLE ARROWDOWNWARDS DOUBLE ARROWLEFT RIGHT DOUBLE ARROWUP DOWN DOUBLE ARR" +
	"OWNORTH WEST DOUBLE ARROWNORTH EAST DOUBLE ARROWSOUTH EAST DOUBLE ARROWS" +
	"OUTH WEST DOUBLE ARROWLEFTWARDS TRIPLE ARROWRIGHTWARDS TRIPLE ARROWLEFTW" +
	"ARDS SQUIGGLE ARROWRIGHTWARDS SQUIGGLE ARROWUPWARDS ARROW WITH DOUBLE ST" +
	"ROKEDOWNWARDS ARROW WITH DOUBLE STROKELEFTWARDS DASHED ARROWUPWARDS DASH" +
	"ED ARROWRIGHTWARDS DASHED ARROWDOWNWARDS DASHED ARROWLEFTWARDS ARROW TO " +
	"BARRIGHTWARDS ARROW TO BARLEFTWARDS WHITE ARROWUPWARDS WHITE ARROWRIGHTW" +
	"ARDS WHITE ARROWDOWNWARDS WHITE ARROWUPWARDS WHITE ARROW FROM BARUPWARDS" +
	" WHITE ARROW ON PEDESTALUPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL " +
	"BARUPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BARUPWARDS WHITE DOUBLE" +
	" ARROWUPWARDS WHITE DOUBLE ARROW ON PEDESTALRIGHTWARDS WHITE ARROW FROM " +
	"WALLNORTH WEST ARROW TO CORNERSOUTH EAST ARROW TO CORNERUP DOWN WHITE AR") + ("" +
	"ROWRIGHT ARROW WITH SMALL CIRCLEDOWNWARDS ARROW LEFTWARDS OF UPWARDS ARR" +
	"OWTHREE RIGHTWARDS ARROWSLEFTWARDS ARROW WITH VERTICAL STROKERIGHTWARDS " +
	"ARROW WITH VERTICAL STROKELEFT RIGHT ARROW WITH VERTICAL STROKELEFTWARDS" +
	" ARROW WITH DOUBLE VERTICAL STROKERIGHTWARDS ARROW WITH DOUBLE VERTICAL " +
	"STROKELEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS OPEN-HEADED " +
	"ARROWRIGHTWARDS OPEN-HEADED ARROWLEFT RIGHT OPEN-HEADED ARROWFOR ALLCOMP" +
	"LEMENTPARTIAL DIFFERENTIALTHERE EXISTSTHERE DOES NOT EXISTEMPTY SETINCRE" +
	"MENTNABLAELEMENT OFNOT AN ELEMENT OFSMALL ELEMENT OFCONTAINS AS MEMBERDO" +
	"ES NOT CONTAIN AS MEMBERSMALL CONTAINS AS MEMBEREND OF PROOFN-ARY PRODUC" +
	"TN-ARY COPRODUCTN-ARY SUMMATIONMINUS SIGNMINUS-OR-PLUS SIGNDOT PLUSDIVIS" +
	"ION SLASHSET MINUSASTERISK OPERATORRING OPERATORBULLET OPERATORSQUARE RO" +
	"OTCUBE ROOTFOURTH ROOTPROPORTIONAL TOINFINITYRIGHT ANGLEANGLEMEASURED AN" +
	"GLESPHERICAL ANGLEDIVIDESDOES NOT DIVIDEPARALLEL TONOT PARALLEL TOLOGICA" +
	"L ANDLOGICAL ORINTERSECTIONUNIONINTEGRALDOUBLE INTEGRALTRIPLE INTEGRALCO" +
	"NTOUR INTEGRALSURFACE INTEGRALVOLUME INTEGRALCLOCKWISE INTEGRALCLOCKWISE" +
	" CONTOUR INTEGRALANTICLOCKWISE CONTOUR INTEGRALTHEREFOREBECAUSERATIOPROP" +
	"ORTIONDOT MINUSEXCESSGEOMETRIC PROPORTIONHOMOTHETICTILDE OPERATORREVERSE" +
	"D TILDEINVERTED LAZY SSINE WAVEWREATH PRODUCTNOT TILDEMINUS TILDEASYMPTO" +
	"TICALLY EQUAL TONOT ASYMPTOTICALLY EQUAL TOAPPROXIMATELY EQUAL TOAPPROXI" +
	"MATELY BUT NOT ACTUALLY EQUAL TONEITHER APPROXIMATELY NOR ACTUALLY EQUAL" +
	" TOALMOST EQUAL TONOT ALMOST EQUAL TOALMOST EQUAL OR EQUAL TOTRIPLE TILD" +
	"EALL EQUAL TOEQUIVALENT TOGEOMETRICALLY EQUIVALENT TODIFFERENCE BETWEENA" +
	"PPROACHES THE LIMITGEOMETRICALLY EQUAL TOAPPROXIMATELY EQUAL TO OR THE I" +
	"MAGE OFIMAGE OF OR APPROXIMATELY EQUAL TOCOLON EQUALSEQUALS COLONRING IN" +
	" EQUAL TORING EQUAL TOCORRESPONDS TOESTIMATESEQUIANGULAR TOSTAR EQUALSDE" +
	"LTA EQUAL TOEQUAL TO BY DEFINITIONMEASURED BYQUESTIONED EQUAL TONOT EQUA" +
	"L TOIDENTICAL TONOT IDENTICAL TOSTRICTLY EQUIVALENT TOLESS-THAN OR EQUAL" +
	" TOGREATER-THAN OR EQUAL TOLESS-THAN OVER EQUAL TOGREATER-THAN OVER EQUA" +
	"L TOLESS-THAN BUT NOT EQUAL TOGREATER-THAN BUT NOT EQUAL TOMUCH LESS-THA" +
	"NMUCH GREATER-THANBETWEENNOT EQUIVALENT TONOT LESS-THANNOT GREATER-THANN" +
	"EITHER LESS-THAN NOR EQUAL TONEITHER GREATER-THAN NOR EQUAL TOLESS-THAN " +
	"OR EQUIVALENT TOGREATER-THAN OR EQUIVALENT TONEITHER LESS-THAN NOR EQUIV" +
	"ALENT TONEITHER GREATER-THAN NOR EQUIVALENT TOLESS-THAN OR GREATER-THANG" +
	"REATER-THAN OR LESS-THANNEITHER LESS-THAN NOR GREATER-THANNEITHER GREATE" +
	"R-THAN NOR LESS-THANPRECEDESSUCCEEDSPRECEDES OR EQUAL TOSUCCEEDS OR EQUA" +
	"L TOPRECEDES OR EQUIVALENT TOSUCCEEDS OR EQUIVALENT TODOES NOT PRECEDEDO" +
	"ES NOT SUCCEEDSUBSET OFSUPERSET OFNOT A SUBSET OFNOT A SUPERSET OFSUBSET" +
	" OF OR EQUAL TOSUPERSET OF OR EQUAL TONEITHER A SUBSET OF NOR EQUAL TONE" +
	"ITHER A SUPERSET OF NOR EQUAL TOSUBSET OF WITH NOT EQUAL TOSUPERSET OF W" +
	"ITH NOT EQUAL TOMULTISETMULTISET MULTIPLICATIONMULTISET UNIONSQUARE IMAG" +
	"E OFSQUARE ORIGINAL OFSQUARE IMAGE OF OR EQUAL TOSQUARE ORIGINAL OF OR E" +
	"QUAL TOSQUARE CAPSQUARE CUPCIRCLED PLUSCIRCLED MINUSCIRCLED TIMESCIRCLED" +
	" DIVISION SLASHCIRCLED DOT OPERATORCIRCLED RING OPERATORCIRCLED ASTERISK" +
	" OPERATORCIRCLED EQUALSCIRCLED DASHSQUARED PLUSSQUARED MINUSSQUARED TIME" +
	"SSQUARED DOT OPERATORRIGHT TACKLEFT TACKDOWN TACKUP TACKASSERTIONMODELST" +
	"RUEFORCESTRIPLE VERTICAL BAR RIGHT TURNSTILEDOUBLE VERTICAL BAR DOUBLE R" +
	"IGHT TURNSTILEDOES NOT PROVENOT TRUEDOES NOT FORCENEGATED DOUBLE VERTICA" +
	"L BAR DOUBLE RIGHT TURNSTILEPRECEDES UNDER RELATIONSUCCEEDS UNDER RELATI" +
	"ONNORMAL SUBGROUP OFCONTAINS AS NORMAL SUBGROUPNORMAL SUBGROUP OF OR EQU" +
	"AL TOCONTAINS AS NORMAL SUBGROUP OR EQUAL TOORIGINAL OFIMAGE OFMULTIMAPH" +
	"ERMITIAN CONJUGATE MATRIXINTERCALATEXORNANDNORRIGHT ANGLE WITH ARCRIGHT " +
	"TRIANGLEN-ARY LOGICAL ANDN-ARY LOGICAL ORN-ARY INTERSECTIONN-ARY UNIONDI" +
	"AMOND OPERATORDOT OPERATORSTAR OPERATORDIVISION TIMESBOWTIELEFT NORMAL F" +
	"ACTOR SEMIDIRECT PRODUCTRIGHT NORMAL FACTOR SEMIDIRECT PRODUCTLEFT SEMID" +
	"IRECT PRODUCTRIGHT SEMIDIRECT PRODUCTREVERSED TILDE EQUALSCURLY LOGICAL " +
	"ORCURLY LOGICAL ANDDOUBLE SUBSETDOUBLE SUPERSETDOUBLE INTERSECTIONDOUBLE" +
	" UNIONPITCHFORKEQUAL AND PARALLEL TOLESS-THAN WITH DOTGREATER-THAN WITH " +
	"DOTVERY MUCH LESS-THANVERY MUCH GREATER-THANLESS-THAN EQUAL TO OR GREATE" +
	"R-THANGREATER-THAN EQUAL TO OR LESS-THANEQUAL TO OR LESS-THANEQUAL TO OR" +
	" GREATER-THANEQUAL TO OR PRECEDESEQUAL TO OR SUCCEEDSDOES NOT PRECEDE OR" +
	" EQUALDOES NOT SUCCEED OR EQUALNOT SQUARE IMAGE OF OR EQUAL TONOT SQUARE" +
	" ORIGINAL OF OR EQUAL TOSQUARE IMAGE OF OR NOT EQUAL TOSQUARE ORIGINAL O" +
	"F OR NOT EQUAL TOLESS-THAN BUT NOT EQUIVALENT TOGREATER-THAN BUT NOT EQU" +
	"IVALENT TOPRECEDES BUT NOT EQUIVALENT TOSUCCEEDS BUT NOT EQUIVALENT TONO") + ("" +
	"T NORMAL SUBGROUP OFDOES NOT CONTAIN AS NORMAL SUBGROUPNOT NORMAL SUBGRO" +
	"UP OF OR EQUAL TODOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUALVERTICAL EL" +
	"LIPSISMIDLINE HORIZONTAL ELLIPSISUP RIGHT DIAGONAL ELLIPSISDOWN RIGHT DI" +
	"AGONAL ELLIPSISELEMENT OF WITH LONG HORIZONTAL STROKEELEMENT OF WITH VER" +
	"TICAL BAR AT END OF HORIZONTAL STROKESMALL ELEMENT OF WITH VERTICAL BAR " +
	"AT END OF HORIZONTAL STROKEELEMENT OF WITH DOT ABOVEELEMENT OF WITH OVER" +
	"BARSMALL ELEMENT OF WITH OVERBARELEMENT OF WITH UNDERBARELEMENT OF WITH " +
	"TWO HORIZONTAL STROKESCONTAINS WITH LONG HORIZONTAL STROKECONTAINS WITH " +
	"VERTICAL BAR AT END OF HORIZONTAL STROKESMALL CONTAINS WITH VERTICAL BAR" +
	" AT END OF HORIZONTAL STROKECONTAINS WITH OVERBARSMALL CONTAINS WITH OVE" +
	"RBARZ NOTATION BAG MEMBERSHIPDIAMETER SIGNELECTRIC ARROWHOUSEUP ARROWHEA" +
	"DDOWN ARROWHEADPROJECTIVEPERSPECTIVEWAVY LINELEFT CEILINGRIGHT CEILINGLE" +
	"FT FLOORRIGHT FLOORBOTTOM RIGHT CROPBOTTOM LEFT CROPTOP RIGHT CROPTOP LE" +
	"FT CROPREVERSED NOT SIGNSQUARE LOZENGEARCSEGMENTSECTORTELEPHONE RECORDER" +
	"POSITION INDICATORVIEWDATA SQUAREPLACE OF INTEREST SIGNTURNED NOT SIGNWA" +
	"TCHHOURGLASSTOP LEFT CORNERTOP RIGHT CORNERBOTTOM LEFT CORNERBOTTOM RIGH" +
	"T CORNERTOP HALF INTEGRALBOTTOM HALF INTEGRALFROWNSMILEUP ARROWHEAD BETW" +
	"EEN TWO HORIZONTAL BARSOPTION KEYERASE TO THE RIGHTX IN A RECTANGLE BOXK" +
	"EYBOARDLEFT-POINTING ANGLE BRACKETRIGHT-POINTING ANGLE BRACKETERASE TO T" +
	"HE LEFTBENZENE RINGCYLINDRICITYALL AROUND-PROFILESYMMETRYTOTAL RUNOUTDIM" +
	"ENSION ORIGINCONICAL TAPERSLOPECOUNTERBORECOUNTERSINKAPL FUNCTIONAL SYMB" +
	"OL I-BEAMAPL FUNCTIONAL SYMBOL SQUISH QUADAPL FUNCTIONAL SYMBOL QUAD EQU" +
	"ALAPL FUNCTIONAL SYMBOL QUAD DIVIDEAPL FUNCTIONAL SYMBOL QUAD DIAMONDAPL" +
	" FUNCTIONAL SYMBOL QUAD JOTAPL FUNCTIONAL SYMBOL QUAD CIRCLEAPL FUNCTION" +
	"AL SYMBOL CIRCLE STILEAPL FUNCTIONAL SYMBOL CIRCLE JOTAPL FUNCTIONAL SYM" +
	"BOL SLASH BARAPL FUNCTIONAL SYMBOL BACKSLASH BARAPL FUNCTIONAL SYMBOL QU" +
	"AD SLASHAPL FUNCTIONAL SYMBOL QUAD BACKSLASHAPL FUNCTIONAL SYMBOL QUAD L" +
	"ESS-THANAPL FUNCTIONAL SYMBOL QUAD GREATER-THANAPL FUNCTIONAL SYMBOL LEF" +
	"TWARDS VANEAPL FUNCTIONAL SYMBOL RIGHTWARDS VANEAPL FUNCTIONAL SYMBOL QU" +
	"AD LEFTWARDS ARROWAPL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROWAPL FUNCTIO" +
	"NAL SYMBOL CIRCLE BACKSLASHAPL FUNCTIONAL SYMBOL DOWN TACK UNDERBARAPL F" +
	"UNCTIONAL SYMBOL DELTA STILEAPL FUNCTIONAL SYMBOL QUAD DOWN CARETAPL FUN" +
	"CTIONAL SYMBOL QUAD DELTAAPL FUNCTIONAL SYMBOL DOWN TACK JOTAPL FUNCTION" +
	"AL SYMBOL UPWARDS VANEAPL FUNCTIONAL SYMBOL QUAD UPWARDS ARROWAPL FUNCTI" +
	"ONAL SYMBOL UP TACK OVERBARAPL FUNCTIONAL SYMBOL DEL STILEAPL FUNCTIONAL" +
	" SYMBOL QUAD UP CARETAPL FUNCTIONAL SYMBOL QUAD DELAPL FUNCTIONAL SYMBOL" +
	" UP TACK JOTAPL FUNCTIONAL SYMBOL DOWNWARDS VANEAPL FUNCTIONAL SYMBOL QU" +
	"AD DOWNWARDS ARROWAPL FUNCTIONAL SYMBOL QUOTE UNDERBARAPL FUNCTIONAL SYM" +
	"BOL DELTA UNDERBARAPL FUNCTIONAL SYMBOL DIAMOND UNDERBARAPL FUNCTIONAL S" +
	"YMBOL JOT UNDERBARAPL FUNCTIONAL SYMBOL CIRCLE UNDERBARAPL FUNCTIONAL SY" +
	"MBOL UP SHOE JOTAPL FUNCTIONAL SYMBOL QUOTE QUADAPL FUNCTIONAL SYMBOL CI" +
	"RCLE STARAPL FUNCTIONAL SYMBOL QUAD COLONAPL FUNCTIONAL SYMBOL UP TACK D" +
	"IAERESISAPL FUNCTIONAL SYMBOL DEL DIAERESISAPL FUNCTIONAL SYMBOL STAR DI" +
	"AERESISAPL FUNCTIONAL SYMBOL JOT DIAERESISAPL FUNCTIONAL SYMBOL CIRCLE D" +
	"IAERESISAPL FUNCTIONAL SYMBOL DOWN SHOE STILEAPL FUNCTIONAL SYMBOL LEFT " +
	"SHOE STILEAPL FUNCTIONAL SYMBOL TILDE DIAERESISAPL FUNCTIONAL SYMBOL GRE" +
	"ATER-THAN DIAERESISAPL FUNCTIONAL SYMBOL COMMA BARAPL FUNCTIONAL SYMBOL " +
	"DEL TILDEAPL FUNCTIONAL SYMBOL ZILDEAPL FUNCTIONAL SYMBOL STILE TILDEAPL" +
	" FUNCTIONAL SYMBOL SEMICOLON UNDERBARAPL FUNCTIONAL SYMBOL QUAD NOT EQUA" +
	"LAPL FUNCTIONAL SYMBOL QUAD QUESTIONAPL FUNCTIONAL SYMBOL DOWN CARET TIL" +
	"DEAPL FUNCTIONAL SYMBOL UP CARET TILDEAPL FUNCTIONAL SYMBOL IOTAAPL FUNC" +
	"TIONAL SYMBOL RHOAPL FUNCTIONAL SYMBOL OMEGAAPL FUNCTIONAL SYMBOL ALPHA " +
	"UNDERBARAPL FUNCTIONAL SYMBOL EPSILON UNDERBARAPL FUNCTIONAL SYMBOL IOTA" +
	" UNDERBARAPL FUNCTIONAL SYMBOL OMEGA UNDERBARAPL FUNCTIONAL SYMBOL ALPHA" +
	"NOT CHECK MARKRIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROWSHOULDERED OPEN BOX" +
	"BELL SYMBOLVERTICAL LINE WITH MIDDLE DOTINSERTION SYMBOLCONTINUOUS UNDER" +
	"LINE SYMBOLDISCONTINUOUS UNDERLINE SYMBOLEMPHASIS SYMBOLCOMPOSITION SYMB" +
	"OLWHITE SQUARE WITH CENTRE VERTICAL LINEENTER SYMBOLALTERNATIVE KEY SYMB" +
	"OLHELM SYMBOLCIRCLED HORIZONTAL BAR WITH NOTCHCIRCLED TRIANGLE DOWNBROKE" +
	"N CIRCLE WITH NORTHWEST ARROWUNDO SYMBOLMONOSTABLE SYMBOLHYSTERESIS SYMB" +
	"OLOPEN-CIRCUIT-OUTPUT H-TYPE SYMBOLOPEN-CIRCUIT-OUTPUT L-TYPE SYMBOLPASS" +
	"IVE-PULL-DOWN-OUTPUT SYMBOLPASSIVE-PULL-UP-OUTPUT SYMBOLDIRECT CURRENT S" +
	"YMBOL FORM TWOSOFTWARE-FUNCTION SYMBOLAPL FUNCTIONAL SYMBOL QUADDECIMAL " +
	"SEPARATOR KEY SYMBOLPREVIOUS PAGENEXT PAGEPRINT SCREEN SYMBOLCLEAR SCREE") + ("" +
	"N SYMBOLLEFT PARENTHESIS UPPER HOOKLEFT PARENTHESIS EXTENSIONLEFT PARENT" +
	"HESIS LOWER HOOKRIGHT PARENTHESIS UPPER HOOKRIGHT PARENTHESIS EXTENSIONR" +
	"IGHT PARENTHESIS LOWER HOOKLEFT SQUARE BRACKET UPPER CORNERLEFT SQUARE B" +
	"RACKET EXTENSIONLEFT SQUARE BRACKET LOWER CORNERRIGHT SQUARE BRACKET UPP" +
	"ER CORNERRIGHT SQUARE BRACKET EXTENSIONRIGHT SQUARE BRACKET LOWER CORNER" +
	"LEFT CURLY BRACKET UPPER HOOKLEFT CURLY BRACKET MIDDLE PIECELEFT CURLY B" +
	"RACKET LOWER HOOKCURLY BRACKET EXTENSIONRIGHT CURLY BRACKET UPPER HOOKRI" +
	"GHT CURLY BRACKET MIDDLE PIECERIGHT CURLY BRACKET LOWER HOOKINTEGRAL EXT" +
	"ENSIONHORIZONTAL LINE EXTENSIONUPPER LEFT OR LOWER RIGHT CURLY BRACKET S" +
	"ECTIONUPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTIONSUMMATION TOPSUMMAT" +
	"ION BOTTOMTOP SQUARE BRACKETBOTTOM SQUARE BRACKETBOTTOM SQUARE BRACKET O" +
	"VER TOP SQUARE BRACKETRADICAL SYMBOL BOTTOMLEFT VERTICAL BOX LINERIGHT V" +
	"ERTICAL BOX LINEHORIZONTAL SCAN LINE-1HORIZONTAL SCAN LINE-3HORIZONTAL S" +
	"CAN LINE-7HORIZONTAL SCAN LINE-9DENTISTRY SYMBOL LIGHT VERTICAL AND TOP " +
	"RIGHTDENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHTDENTISTRY SYMBOL LI" +
	"GHT VERTICAL WITH CIRCLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH " +
	"CIRCLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLEDENTISTRY SYMB" +
	"OL LIGHT VERTICAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTA" +
	"L WITH TRIANGLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLEDEN" +
	"TISTRY SYMBOL LIGHT VERTICAL AND WAVEDENTISTRY SYMBOL LIGHT DOWN AND HOR" +
	"IZONTAL WITH WAVEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVEDENTI" +
	"STRY SYMBOL LIGHT DOWN AND HORIZONTALDENTISTRY SYMBOL LIGHT UP AND HORIZ" +
	"ONTALDENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFTDENTISTRY SYMBOL LIGHT " +
	"VERTICAL AND BOTTOM LEFTSQUARE FOOTRETURN SYMBOLEJECT SYMBOLVERTICAL LIN" +
	"E EXTENSIONMETRICAL BREVEMETRICAL LONG OVER SHORTMETRICAL SHORT OVER LON" +
	"GMETRICAL LONG OVER TWO SHORTSMETRICAL TWO SHORTS OVER LONGMETRICAL TWO " +
	"SHORTS JOINEDMETRICAL TRISEMEMETRICAL TETRASEMEMETRICAL PENTASEMEEARTH G" +
	"ROUNDFUSETOP PARENTHESISBOTTOM PARENTHESISTOP CURLY BRACKETBOTTOM CURLY " +
	"BRACKETTOP TORTOISE SHELL BRACKETBOTTOM TORTOISE SHELL BRACKETWHITE TRAP" +
	"EZIUMBENZENE RING WITH CIRCLESTRAIGHTNESSFLATNESSAC CURRENTELECTRICAL IN" +
	"TERSECTIONDECIMAL EXPONENT SYMBOLBLACK RIGHT-POINTING DOUBLE TRIANGLEBLA" +
	"CK LEFT-POINTING DOUBLE TRIANGLEBLACK UP-POINTING DOUBLE TRIANGLEBLACK D" +
	"OWN-POINTING DOUBLE TRIANGLEBLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VE" +
	"RTICAL BARBLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BARBLACK RIG" +
	"HT-POINTING TRIANGLE WITH DOUBLE VERTICAL BARALARM CLOCKSTOPWATCHTIMER C" +
	"LOCKHOURGLASS WITH FLOWING SANDBLACK MEDIUM LEFT-POINTING TRIANGLEBLACK " +
	"MEDIUM RIGHT-POINTING TRIANGLEBLACK MEDIUM UP-POINTING TRIANGLEBLACK MED" +
	"IUM DOWN-POINTING TRIANGLEDOUBLE VERTICAL BARBLACK SQUARE FOR STOPBLACK " +
	"CIRCLE FOR RECORDPOWER SYMBOLPOWER ON-OFF SYMBOLPOWER ON SYMBOLPOWER SLE" +
	"EP SYMBOLOBSERVER EYE SYMBOLSYMBOL FOR NULLSYMBOL FOR START OF HEADINGSY" +
	"MBOL FOR START OF TEXTSYMBOL FOR END OF TEXTSYMBOL FOR END OF TRANSMISSI" +
	"ONSYMBOL FOR ENQUIRYSYMBOL FOR ACKNOWLEDGESYMBOL FOR BELLSYMBOL FOR BACK" +
	"SPACESYMBOL FOR HORIZONTAL TABULATIONSYMBOL FOR LINE FEEDSYMBOL FOR VERT" +
	"ICAL TABULATIONSYMBOL FOR FORM FEEDSYMBOL FOR CARRIAGE RETURNSYMBOL FOR " +
	"SHIFT OUTSYMBOL FOR SHIFT INSYMBOL FOR DATA LINK ESCAPESYMBOL FOR DEVICE" +
	" CONTROL ONESYMBOL FOR DEVICE CONTROL TWOSYMBOL FOR DEVICE CONTROL THREE" +
	"SYMBOL FOR DEVICE CONTROL FOURSYMBOL FOR NEGATIVE ACKNOWLEDGESYMBOL FOR " +
	"SYNCHRONOUS IDLESYMBOL FOR END OF TRANSMISSION BLOCKSYMBOL FOR CANCELSYM" +
	"BOL FOR END OF MEDIUMSYMBOL FOR SUBSTITUTESYMBOL FOR ESCAPESYMBOL FOR FI" +
	"LE SEPARATORSYMBOL FOR GROUP SEPARATORSYMBOL FOR RECORD SEPARATORSYMBOL " +
	"FOR UNIT SEPARATORSYMBOL FOR SPACESYMBOL FOR DELETEBLANK SYMBOLOPEN BOXS" +
	"YMBOL FOR NEWLINESYMBOL FOR DELETE FORM TWOSYMBOL FOR SUBSTITUTE FORM TW" +
	"OOCR HOOKOCR CHAIROCR FORKOCR INVERTED FORKOCR BELT BUCKLEOCR BOW TIEOCR" +
	" BRANCH BANK IDENTIFICATIONOCR AMOUNT OF CHECKOCR DASHOCR CUSTOMER ACCOU" +
	"NT NUMBEROCR DOUBLE BACKSLASHCIRCLED DIGIT ONECIRCLED DIGIT TWOCIRCLED D" +
	"IGIT THREECIRCLED DIGIT FOURCIRCLED DIGIT FIVECIRCLED DIGIT SIXCIRCLED D" +
	"IGIT SEVENCIRCLED DIGIT EIGHTCIRCLED DIGIT NINECIRCLED NUMBER TENCIRCLED" +
	" NUMBER ELEVENCIRCLED NUMBER TWELVECIRCLED NUMBER THIRTEENCIRCLED NUMBER" +
	" FOURTEENCIRCLED NUMBER FIFTEENCIRCLED NUMBER SIXTEENCIRCLED NUMBER SEVE" +
	"NTEENCIRCLED NUMBER EIGHTEENCIRCLED NUMBER NINETEENCIRCLED NUMBER TWENTY" +
	"PARENTHESIZED DIGIT ONEPARENTHESIZED DIGIT TWOPARENTHESIZED DIGIT THREEP" +
	"ARENTHESIZED DIGIT FOURPARENTHESIZED DIGIT FIVEPARENTHESIZED DIGIT SIXPA" +
	"RENTHESIZED DIGIT SEVENPARENTHESIZED DIGIT EIGHTPARENTHESIZED DIGIT NINE" +
	"PARENTHESIZED NUMBER TENPARENTHESIZED NUMBER ELEVENPARENTHESIZED NUMBER ") + ("" +
	"TWELVEPARENTHESIZED NUMBER THIRTEENPARENTHESIZED NUMBER FOURTEENPARENTHE" +
	"SIZED NUMBER FIFTEENPARENTHESIZED NUMBER SIXTEENPARENTHESIZED NUMBER SEV" +
	"ENTEENPARENTHESIZED NUMBER EIGHTEENPARENTHESIZED NUMBER NINETEENPARENTHE" +
	"SIZED NUMBER TWENTYDIGIT ONE FULL STOPDIGIT TWO FULL STOPDIGIT THREE FUL" +
	"L STOPDIGIT FOUR FULL STOPDIGIT FIVE FULL STOPDIGIT SIX FULL STOPDIGIT S" +
	"EVEN FULL STOPDIGIT EIGHT FULL STOPDIGIT NINE FULL STOPNUMBER TEN FULL S" +
	"TOPNUMBER ELEVEN FULL STOPNUMBER TWELVE FULL STOPNUMBER THIRTEEN FULL ST" +
	"OPNUMBER FOURTEEN FULL STOPNUMBER FIFTEEN FULL STOPNUMBER SIXTEEN FULL S" +
	"TOPNUMBER SEVENTEEN FULL STOPNUMBER EIGHTEEN FULL STOPNUMBER NINETEEN FU" +
	"LL STOPNUMBER TWENTY FULL STOPPARENTHESIZED LATIN SMALL LETTER APARENTHE" +
	"SIZED LATIN SMALL LETTER BPARENTHESIZED LATIN SMALL LETTER CPARENTHESIZE" +
	"D LATIN SMALL LETTER DPARENTHESIZED LATIN SMALL LETTER EPARENTHESIZED LA" +
	"TIN SMALL LETTER FPARENTHESIZED LATIN SMALL LETTER GPARENTHESIZED LATIN " +
	"SMALL LETTER HPARENTHESIZED LATIN SMALL LETTER IPARENTHESIZED LATIN SMAL" +
	"L LETTER JPARENTHESIZED LATIN SMALL LETTER KPARENTHESIZED LATIN SMALL LE" +
	"TTER LPARENTHESIZED LATIN SMALL LETTER MPARENTHESIZED LATIN SMALL LETTER" +
	" NPARENTHESIZED LATIN SMALL LETTER OPARENTHESIZED LATIN SMALL LETTER PPA" +
	"RENTHESIZED LATIN SMALL LETTER QPARENTHESIZED LATIN SMALL LETTER RPARENT" +
	"HESIZED LATIN SMALL LETTER SPARENTHESIZED LATIN SMALL LETTER TPARENTHESI" +
	"ZED LATIN SMALL LETTER UPARENTHESIZED LATIN SMALL LETTER VPARENTHESIZED " +
	"LATIN SMALL LETTER WPARENTHESIZED LATIN SMALL LETTER XPARENTHESIZED LATI" +
	"N SMALL LETTER YPARENTHESIZED LATIN SMALL LETTER ZCIRCLED LATIN CAPITAL " +
	"LETTER ACIRCLED LATIN CAPITAL LETTER BCIRCLED LATIN CAPITAL LETTER CCIRC" +
	"LED LATIN CAPITAL LETTER DCIRCLED LATIN CAPITAL LETTER ECIRCLED LATIN CA" +
	"PITAL LETTER FCIRCLED LATIN CAPITAL LETTER GCIRCLED LATIN CAPITAL LETTER" +
	" HCIRCLED LATIN CAPITAL LETTER ICIRCLED LATIN CAPITAL LETTER JCIRCLED LA" +
	"TIN CAPITAL LETTER KCIRCLED LATIN CAPITAL LETTER LCIRCLED LATIN CAPITAL " +
	"LETTER MCIRCLED LATIN CAPITAL LETTER NCIRCLED LATIN CAPITAL LETTER OCIRC" +
	"LED LATIN CAPITAL LETTER PCIRCLED LATIN CAPITAL LETTER QCIRCLED LATIN CA" +
	"PITAL LETTER RCIRCLED LATIN CAPITAL LETTER SCIRCLED LATIN CAPITAL LETTER" +
	" TCIRCLED LATIN CAPITAL LETTER UCIRCLED LATIN CAPITAL LETTER VCIRCLED LA" +
	"TIN CAPITAL LETTER WCIRCLED LATIN CAPITAL LETTER XCIRCLED LATIN CAPITAL " +
	"LETTER YCIRCLED LATIN CAPITAL LETTER ZCIRCLED LATIN SMALL LETTER ACIRCLE" +
	"D LATIN SMALL LETTER BCIRCLED LATIN SMALL LETTER CCIRCLED LATIN SMALL LE" +
	"TTER DCIRCLED LATIN SMALL LETTER ECIRCLED LATIN SMALL LETTER FCIRCLED LA" +
	"TIN SMALL LETTER GCIRCLED LATIN SMALL LETTER HCIRCLED LATIN SMALL LETTER" +
	" ICIRCLED LATIN SMALL LETTER JCIRCLED LATIN SMALL LETTER KCIRCLED LATIN " +
	"SMALL LETTER LCIRCLED LATIN SMALL LETTER MCIRCLED LATIN SMALL LETTER NCI" +
	"RCLED LATIN SMALL LETTER OCIRCLED LATIN SMALL LETTER PCIRCLED LATIN SMAL" +
	"L LETTER QCIRCLED LATIN SMALL LETTER RCIRCLED LATIN SMALL LETTER SCIRCLE" +
	"D LATIN SMALL LETTER TCIRCLED LATIN SMALL LETTER UCIRCLED LATIN SMALL LE" +
	"TTER VCIRCLED LATIN SMALL LETTER WCIRCLED LATIN SMALL LETTER XCIRCLED LA" +
	"TIN SMALL LETTER YCIRCLED LATIN SMALL LETTER ZCIRCLED DIGIT ZERONEGATIVE" +
	" CIRCLED NUMBER ELEVENNEGATIVE CIRCLED NUMBER TWELVENEGATIVE CIRCLED NUM" +
	"BER THIRTEENNEGATIVE CIRCLED NUMBER FOURTEENNEGATIVE CIRCLED NUMBER FIFT" +
	"EENNEGATIVE CIRCLED NUMBER SIXTEENNEGATIVE CIRCLED NUMBER SEVENTEENNEGAT" +
	"IVE CIRCLED NUMBER EIGHTEENNEGATIVE CIRCLED NUMBER NINETEENNEGATIVE CIRC" +
	"LED NUMBER TWENTYDOUBLE CIRCLED DIGIT ONEDOUBLE CIRCLED DIGIT TWODOUBLE " +
	"CIRCLED DIGIT THREEDOUBLE CIRCLED DIGIT FOURDOUBLE CIRCLED DIGIT FIVEDOU" +
	"BLE CIRCLED DIGIT SIXDOUBLE CIRCLED DIGIT SEVENDOUBLE CIRCLED DIGIT EIGH" +
	"TDOUBLE CIRCLED DIGIT NINEDOUBLE CIRCLED NUMBER TENNEGATIVE CIRCLED DIGI" +
	"T ZEROBOX DRAWINGS LIGHT HORIZONTALBOX DRAWINGS HEAVY HORIZONTALBOX DRAW" +
	"INGS LIGHT VERTICALBOX DRAWINGS HEAVY VERTICALBOX DRAWINGS LIGHT TRIPLE " +
	"DASH HORIZONTALBOX DRAWINGS HEAVY TRIPLE DASH HORIZONTALBOX DRAWINGS LIG" +
	"HT TRIPLE DASH VERTICALBOX DRAWINGS HEAVY TRIPLE DASH VERTICALBOX DRAWIN" +
	"GS LIGHT QUADRUPLE DASH HORIZONTALBOX DRAWINGS HEAVY QUADRUPLE DASH HORI" +
	"ZONTALBOX DRAWINGS LIGHT QUADRUPLE DASH VERTICALBOX DRAWINGS HEAVY QUADR" +
	"UPLE DASH VERTICALBOX DRAWINGS LIGHT DOWN AND RIGHTBOX DRAWINGS DOWN LIG" +
	"HT AND RIGHT HEAVYBOX DRAWINGS DOWN HEAVY AND RIGHT LIGHTBOX DRAWINGS HE" +
	"AVY DOWN AND RIGHTBOX DRAWINGS LIGHT DOWN AND LEFTBOX DRAWINGS DOWN LIGH" +
	"T AND LEFT HEAVYBOX DRAWINGS DOWN HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY" +
	" DOWN AND LEFTBOX DRAWINGS LIGHT UP AND RIGHTBOX DRAWINGS UP LIGHT AND R" +
	"IGHT HEAVYBOX DRAWINGS UP HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY UP AND" +
	" RIGHTBOX DRAWINGS LIGHT UP AND LEFTBOX DRAWINGS UP LIGHT AND LEFT HEAVY") + ("" +
	"BOX DRAWINGS UP HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY UP AND LEFTBOX DR" +
	"AWINGS LIGHT VERTICAL AND RIGHTBOX DRAWINGS VERTICAL LIGHT AND RIGHT HEA" +
	"VYBOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHTBOX DRAWINGS DOWN HEAVY AND " +
	"RIGHT UP LIGHTBOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHTBOX DRAWINGS DO" +
	"WN LIGHT AND RIGHT UP HEAVYBOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVYBOX" +
	" DRAWINGS HEAVY VERTICAL AND RIGHTBOX DRAWINGS LIGHT VERTICAL AND LEFTBO" +
	"X DRAWINGS VERTICAL LIGHT AND LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEFT D" +
	"OWN LIGHTBOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHTBOX DRAWINGS VERTICAL " +
	"HEAVY AND LEFT LIGHTBOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVYBOX DRAWING" +
	"S UP LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS HEAVY VERTICAL AND LEFTBOX DR" +
	"AWINGS LIGHT DOWN AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT DOWN L" +
	"IGHTBOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS DOWN LIGHT " +
	"AND HORIZONTAL HEAVYBOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHTBOX DRAW" +
	"INGS RIGHT LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT DO" +
	"WN HEAVYBOX DRAWINGS HEAVY DOWN AND HORIZONTALBOX DRAWINGS LIGHT UP AND " +
	"HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT H" +
	"EAVY AND LEFT UP LIGHTBOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVYBOX DRAW" +
	"INGS UP HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT UP H" +
	"EAVYBOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVYBOX DRAWINGS HEAVY UP AND " +
	"HORIZONTALBOX DRAWINGS LIGHT VERTICAL AND HORIZONTALBOX DRAWINGS LEFT HE" +
	"AVY AND RIGHT VERTICAL LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL L" +
	"IGHTBOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAV" +
	"Y AND DOWN HORIZONTAL LIGHTBOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIG" +
	"HTBOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS LEFT UP H" +
	"EAVY AND RIGHT DOWN LIGHTBOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT" +
	"BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT DOWN H" +
	"EAVY AND LEFT UP LIGHTBOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVYBOX" +
	" DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVYBOX DRAWINGS RIGHT LIGHT AND" +
	" LEFT VERTICAL HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVYBOX " +
	"DRAWINGS HEAVY VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH HOR" +
	"IZONTALBOX DRAWINGS HEAVY DOUBLE DASH HORIZONTALBOX DRAWINGS LIGHT DOUBL" +
	"E DASH VERTICALBOX DRAWINGS HEAVY DOUBLE DASH VERTICALBOX DRAWINGS DOUBL" +
	"E HORIZONTALBOX DRAWINGS DOUBLE VERTICALBOX DRAWINGS DOWN SINGLE AND RIG" +
	"HT DOUBLEBOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE DO" +
	"WN AND RIGHTBOX DRAWINGS DOWN SINGLE AND LEFT DOUBLEBOX DRAWINGS DOWN DO" +
	"UBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE DOWN AND LEFTBOX DRAWINGS UP SIN" +
	"GLE AND RIGHT DOUBLEBOX DRAWINGS UP DOUBLE AND RIGHT SINGLEBOX DRAWINGS " +
	"DOUBLE UP AND RIGHTBOX DRAWINGS UP SINGLE AND LEFT DOUBLEBOX DRAWINGS UP" +
	" DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE UP AND LEFTBOX DRAWINGS VERTI" +
	"CAL SINGLE AND RIGHT DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE" +
	"BOX DRAWINGS DOUBLE VERTICAL AND RIGHTBOX DRAWINGS VERTICAL SINGLE AND L" +
	"EFT DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBL" +
	"E VERTICAL AND LEFTBOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLEBOX DRA" +
	"WINGS DOWN DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE DOWN AND HORI" +
	"ZONTALBOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS UP DOUBLE" +
	" AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE UP AND HORIZONTALBOX DRAWINGS " +
	"VERTICAL SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND HO" +
	"RIZONTAL SINGLEBOX DRAWINGS DOUBLE VERTICAL AND HORIZONTALBOX DRAWINGS L" +
	"IGHT ARC DOWN AND RIGHTBOX DRAWINGS LIGHT ARC DOWN AND LEFTBOX DRAWINGS " +
	"LIGHT ARC UP AND LEFTBOX DRAWINGS LIGHT ARC UP AND RIGHTBOX DRAWINGS LIG" +
	"HT DIAGONAL UPPER RIGHT TO LOWER LEFTBOX DRAWINGS LIGHT DIAGONAL UPPER L" +
	"EFT TO LOWER RIGHTBOX DRAWINGS LIGHT DIAGONAL CROSSBOX DRAWINGS LIGHT LE" +
	"FTBOX DRAWINGS LIGHT UPBOX DRAWINGS LIGHT RIGHTBOX DRAWINGS LIGHT DOWNBO" +
	"X DRAWINGS HEAVY LEFTBOX DRAWINGS HEAVY UPBOX DRAWINGS HEAVY RIGHTBOX DR" +
	"AWINGS HEAVY DOWNBOX DRAWINGS LIGHT LEFT AND HEAVY RIGHTBOX DRAWINGS LIG" +
	"HT UP AND HEAVY DOWNBOX DRAWINGS HEAVY LEFT AND LIGHT RIGHTBOX DRAWINGS " +
	"HEAVY UP AND LIGHT DOWNUPPER HALF BLOCKLOWER ONE EIGHTH BLOCKLOWER ONE Q" +
	"UARTER BLOCKLOWER THREE EIGHTHS BLOCKLOWER HALF BLOCKLOWER FIVE EIGHTHS " +
	"BLOCKLOWER THREE QUARTERS BLOCKLOWER SEVEN EIGHTHS BLOCKFULL BLOCKLEFT S" +
	"EVEN EIGHTHS BLOCKLEFT THREE QUARTERS BLOCKLEFT FIVE EIGHTHS BLOCKLEFT H" +
	"ALF BLOCKLEFT THREE EIGHTHS BLOCKLEFT ONE QUARTER BLOCKLEFT ONE EIGHTH B" +
	"LOCKRIGHT HALF BLOCKLIGHT SHADEMEDIUM SHADEDARK SHADEUPPER ONE EIGHTH BL" +
	"OCKRIGHT ONE EIGHTH BLOCKQUADRANT LOWER LEFTQUADRANT LOWER RIGHTQUADRANT" +
	" UPPER LEFTQUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHTQUADRANT UP") + ("" +
	"PER LEFT AND LOWER RIGHTQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LE" +
	"FTQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHTQUADRANT UPPER RIGH" +
	"TQUADRANT UPPER RIGHT AND LOWER LEFTQUADRANT UPPER RIGHT AND LOWER LEFT " +
	"AND LOWER RIGHTBLACK SQUAREWHITE SQUAREWHITE SQUARE WITH ROUNDED CORNERS" +
	"WHITE SQUARE CONTAINING BLACK SMALL SQUARESQUARE WITH HORIZONTAL FILLSQU" +
	"ARE WITH VERTICAL FILLSQUARE WITH ORTHOGONAL CROSSHATCH FILLSQUARE WITH " +
	"UPPER LEFT TO LOWER RIGHT FILLSQUARE WITH UPPER RIGHT TO LOWER LEFT FILL" +
	"SQUARE WITH DIAGONAL CROSSHATCH FILLBLACK SMALL SQUAREWHITE SMALL SQUARE" +
	"BLACK RECTANGLEWHITE RECTANGLEBLACK VERTICAL RECTANGLEWHITE VERTICAL REC" +
	"TANGLEBLACK PARALLELOGRAMWHITE PARALLELOGRAMBLACK UP-POINTING TRIANGLEWH" +
	"ITE UP-POINTING TRIANGLEBLACK UP-POINTING SMALL TRIANGLEWHITE UP-POINTIN" +
	"G SMALL TRIANGLEBLACK RIGHT-POINTING TRIANGLEWHITE RIGHT-POINTING TRIANG" +
	"LEBLACK RIGHT-POINTING SMALL TRIANGLEWHITE RIGHT-POINTING SMALL TRIANGLE" +
	"BLACK RIGHT-POINTING POINTERWHITE RIGHT-POINTING POINTERBLACK DOWN-POINT" +
	"ING TRIANGLEWHITE DOWN-POINTING TRIANGLEBLACK DOWN-POINTING SMALL TRIANG" +
	"LEWHITE DOWN-POINTING SMALL TRIANGLEBLACK LEFT-POINTING TRIANGLEWHITE LE" +
	"FT-POINTING TRIANGLEBLACK LEFT-POINTING SMALL TRIANGLEWHITE LEFT-POINTIN" +
	"G SMALL TRIANGLEBLACK LEFT-POINTING POINTERWHITE LEFT-POINTING POINTERBL" +
	"ACK DIAMONDWHITE DIAMONDWHITE DIAMOND CONTAINING BLACK SMALL DIAMONDFISH" +
	"EYELOZENGEWHITE CIRCLEDOTTED CIRCLECIRCLE WITH VERTICAL FILLBULLSEYEBLAC" +
	"K CIRCLECIRCLE WITH LEFT HALF BLACKCIRCLE WITH RIGHT HALF BLACKCIRCLE WI" +
	"TH LOWER HALF BLACKCIRCLE WITH UPPER HALF BLACKCIRCLE WITH UPPER RIGHT Q" +
	"UADRANT BLACKCIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACKLEFT HALF BLAC" +
	"K CIRCLERIGHT HALF BLACK CIRCLEINVERSE BULLETINVERSE WHITE CIRCLEUPPER H" +
	"ALF INVERSE WHITE CIRCLELOWER HALF INVERSE WHITE CIRCLEUPPER LEFT QUADRA" +
	"NT CIRCULAR ARCUPPER RIGHT QUADRANT CIRCULAR ARCLOWER RIGHT QUADRANT CIR" +
	"CULAR ARCLOWER LEFT QUADRANT CIRCULAR ARCUPPER HALF CIRCLELOWER HALF CIR" +
	"CLEBLACK LOWER RIGHT TRIANGLEBLACK LOWER LEFT TRIANGLEBLACK UPPER LEFT T" +
	"RIANGLEBLACK UPPER RIGHT TRIANGLEWHITE BULLETSQUARE WITH LEFT HALF BLACK" +
	"SQUARE WITH RIGHT HALF BLACKSQUARE WITH UPPER LEFT DIAGONAL HALF BLACKSQ" +
	"UARE WITH LOWER RIGHT DIAGONAL HALF BLACKWHITE SQUARE WITH VERTICAL BISE" +
	"CTING LINEWHITE UP-POINTING TRIANGLE WITH DOTUP-POINTING TRIANGLE WITH L" +
	"EFT HALF BLACKUP-POINTING TRIANGLE WITH RIGHT HALF BLACKLARGE CIRCLEWHIT" +
	"E SQUARE WITH UPPER LEFT QUADRANTWHITE SQUARE WITH LOWER LEFT QUADRANTWH" +
	"ITE SQUARE WITH LOWER RIGHT QUADRANTWHITE SQUARE WITH UPPER RIGHT QUADRA" +
	"NTWHITE CIRCLE WITH UPPER LEFT QUADRANTWHITE CIRCLE WITH LOWER LEFT QUAD" +
	"RANTWHITE CIRCLE WITH LOWER RIGHT QUADRANTWHITE CIRCLE WITH UPPER RIGHT " +
	"QUADRANTUPPER LEFT TRIANGLEUPPER RIGHT TRIANGLELOWER LEFT TRIANGLEWHITE " +
	"MEDIUM SQUAREBLACK MEDIUM SQUAREWHITE MEDIUM SMALL SQUAREBLACK MEDIUM SM" +
	"ALL SQUARELOWER RIGHT TRIANGLEBLACK SUN WITH RAYSCLOUDUMBRELLASNOWMANCOM" +
	"ETBLACK STARWHITE STARLIGHTNINGTHUNDERSTORMSUNASCENDING NODEDESCENDING N" +
	"ODECONJUNCTIONOPPOSITIONBLACK TELEPHONEWHITE TELEPHONEBALLOT BOXBALLOT B" +
	"OX WITH CHECKBALLOT BOX WITH XSALTIREUMBRELLA WITH RAIN DROPSHOT BEVERAG" +
	"EWHITE SHOGI PIECEBLACK SHOGI PIECESHAMROCKREVERSED ROTATED FLORAL HEART" +
	" BULLETBLACK LEFT POINTING INDEXBLACK RIGHT POINTING INDEXWHITE LEFT POI" +
	"NTING INDEXWHITE UP POINTING INDEXWHITE RIGHT POINTING INDEXWHITE DOWN P" +
	"OINTING INDEXSKULL AND CROSSBONESCAUTION SIGNRADIOACTIVE SIGNBIOHAZARD S" +
	"IGNCADUCEUSANKHORTHODOX CROSSCHI RHOCROSS OF LORRAINECROSS OF JERUSALEMS" +
	"TAR AND CRESCENTFARSI SYMBOLADI SHAKTIHAMMER AND SICKLEPEACE SYMBOLYIN Y" +
	"ANGTRIGRAM FOR HEAVENTRIGRAM FOR LAKETRIGRAM FOR FIRETRIGRAM FOR THUNDER" +
	"TRIGRAM FOR WINDTRIGRAM FOR WATERTRIGRAM FOR MOUNTAINTRIGRAM FOR EARTHWH" +
	"EEL OF DHARMAWHITE FROWNING FACEWHITE SMILING FACEBLACK SMILING FACEWHIT" +
	"E SUN WITH RAYSFIRST QUARTER MOONLAST QUARTER MOONMERCURYFEMALE SIGNEART" +
	"HMALE SIGNJUPITERSATURNURANUSNEPTUNEPLUTOARIESTAURUSGEMINICANCERLEOVIRGO" +
	"LIBRASCORPIUSSAGITTARIUSCAPRICORNAQUARIUSPISCESWHITE CHESS KINGWHITE CHE" +
	"SS QUEENWHITE CHESS ROOKWHITE CHESS BISHOPWHITE CHESS KNIGHTWHITE CHESS " +
	"PAWNBLACK CHESS KINGBLACK CHESS QUEENBLACK CHESS ROOKBLACK CHESS BISHOPB" +
	"LACK CHESS KNIGHTBLACK CHESS PAWNBLACK SPADE SUITWHITE HEART SUITWHITE D" +
	"IAMOND SUITBLACK CLUB SUITWHITE SPADE SUITBLACK HEART SUITBLACK DIAMOND " +
	"SUITWHITE CLUB SUITHOT SPRINGSQUARTER NOTEEIGHTH NOTEBEAMED EIGHTH NOTES" +
	"BEAMED SIXTEENTH NOTESMUSIC FLAT SIGNMUSIC NATURAL SIGNMUSIC SHARP SIGNW" +
	"EST SYRIAC CROSSEAST SYRIAC CROSSUNIVERSAL RECYCLING SYMBOLRECYCLING SYM" +
	"BOL FOR TYPE-1 PLASTICSRECYCLING SYMBOL FOR TYPE-2 PLASTICSRECYCLING SYM" +
	"BOL FOR TYPE-3 PLASTICSRECYCLING SYMBOL FOR TYPE-4 PLASTICSRECYCLING SYM") + ("" +
	"BOL FOR TYPE-5 PLASTICSRECYCLING SYMBOL FOR TYPE-6 PLASTICSRECYCLING SYM" +
	"BOL FOR TYPE-7 PLASTICSRECYCLING SYMBOL FOR GENERIC MATERIALSBLACK UNIVE" +
	"RSAL RECYCLING SYMBOLRECYCLED PAPER SYMBOLPARTIALLY-RECYCLED PAPER SYMBO" +
	"LPERMANENT PAPER SIGNWHEELCHAIR SYMBOLDIE FACE-1DIE FACE-2DIE FACE-3DIE " +
	"FACE-4DIE FACE-5DIE FACE-6WHITE CIRCLE WITH DOT RIGHTWHITE CIRCLE WITH T" +
	"WO DOTSBLACK CIRCLE WITH WHITE DOT RIGHTBLACK CIRCLE WITH TWO WHITE DOTS" +
	"MONOGRAM FOR YANGMONOGRAM FOR YINDIGRAM FOR GREATER YANGDIGRAM FOR LESSE" +
	"R YINDIGRAM FOR LESSER YANGDIGRAM FOR GREATER YINWHITE FLAGBLACK FLAGHAM" +
	"MER AND PICKANCHORCROSSED SWORDSSTAFF OF AESCULAPIUSSCALESALEMBICFLOWERG" +
	"EARSTAFF OF HERMESATOM SYMBOLFLEUR-DE-LISOUTLINED WHITE STARTHREE LINES " +
	"CONVERGING RIGHTTHREE LINES CONVERGING LEFTWARNING SIGNHIGH VOLTAGE SIGN" +
	"DOUBLED FEMALE SIGNDOUBLED MALE SIGNINTERLOCKED FEMALE AND MALE SIGNMALE" +
	" AND FEMALE SIGNMALE WITH STROKE SIGNMALE WITH STROKE AND MALE AND FEMAL" +
	"E SIGNVERTICAL MALE WITH STROKE SIGNHORIZONTAL MALE WITH STROKE SIGNMEDI" +
	"UM WHITE CIRCLEMEDIUM BLACK CIRCLEMEDIUM SMALL WHITE CIRCLEMARRIAGE SYMB" +
	"OLDIVORCE SYMBOLUNMARRIED PARTNERSHIP SYMBOLCOFFINFUNERAL URNNEUTERCERES" +
	"PALLASJUNOVESTACHIRONBLACK MOON LILITHSEXTILESEMISEXTILEQUINCUNXSESQUIQU" +
	"ADRATESOCCER BALLBASEBALLSQUARED KEYWHITE DRAUGHTS MANWHITE DRAUGHTS KIN" +
	"GBLACK DRAUGHTS MANBLACK DRAUGHTS KINGSNOWMAN WITHOUT SNOWSUN BEHIND CLO" +
	"UDRAINBLACK SNOWMANTHUNDER CLOUD AND RAINTURNED WHITE SHOGI PIECETURNED " +
	"BLACK SHOGI PIECEWHITE DIAMOND IN SQUARECROSSING LANESDISABLED CAROPHIUC" +
	"HUSPICKCAR SLIDINGHELMET WITH WHITE CROSSCIRCLED CROSSING LANESCHAINSNO " +
	"ENTRYALTERNATE ONE-WAY LEFT WAY TRAFFICBLACK TWO-WAY LEFT WAY TRAFFICWHI" +
	"TE TWO-WAY LEFT WAY TRAFFICBLACK LEFT LANE MERGEWHITE LEFT LANE MERGEDRI" +
	"VE SLOW SIGNHEAVY WHITE DOWN-POINTING TRIANGLELEFT CLOSED ENTRYSQUARED S" +
	"ALTIREFALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUAREBLACK TRUCKRESTRIC" +
	"TED LEFT ENTRY-1RESTRICTED LEFT ENTRY-2ASTRONOMICAL SYMBOL FOR URANUSHEA" +
	"VY CIRCLE WITH STROKE AND TWO DOTS ABOVEPENTAGRAMRIGHT-HANDED INTERLACED" +
	" PENTAGRAMLEFT-HANDED INTERLACED PENTAGRAMINVERTED PENTAGRAMBLACK CROSS " +
	"ON SHIELDSHINTO SHRINECHURCHCASTLEHISTORIC SITEGEAR WITHOUT HUBGEAR WITH" +
	" HANDLESMAP SYMBOL FOR LIGHTHOUSEMOUNTAINUMBRELLA ON GROUNDFOUNTAINFLAG " +
	"IN HOLEFERRYSAILBOATSQUARE FOUR CORNERSSKIERICE SKATEPERSON WITH BALLTEN" +
	"TJAPANESE BANK SYMBOLHEADSTONE GRAVEYARD SYMBOLFUEL PUMPCUP ON BLACK SQU" +
	"AREWHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPEBLACK SAFETY SCISSORSUP" +
	"PER BLADE SCISSORSBLACK SCISSORSLOWER BLADE SCISSORSWHITE SCISSORSWHITE " +
	"HEAVY CHECK MARKTELEPHONE LOCATION SIGNTAPE DRIVEAIRPLANEENVELOPERAISED " +
	"FISTRAISED HANDVICTORY HANDWRITING HANDLOWER RIGHT PENCILPENCILUPPER RIG" +
	"HT PENCILWHITE NIBBLACK NIBCHECK MARKHEAVY CHECK MARKMULTIPLICATION XHEA" +
	"VY MULTIPLICATION XBALLOT XHEAVY BALLOT XOUTLINED GREEK CROSSHEAVY GREEK" +
	" CROSSOPEN CENTRE CROSSHEAVY OPEN CENTRE CROSSLATIN CROSSSHADOWED WHITE " +
	"LATIN CROSSOUTLINED LATIN CROSSMALTESE CROSSSTAR OF DAVIDFOUR TEARDROP-S" +
	"POKED ASTERISKFOUR BALLOON-SPOKED ASTERISKHEAVY FOUR BALLOON-SPOKED ASTE" +
	"RISKFOUR CLUB-SPOKED ASTERISKBLACK FOUR POINTED STARWHITE FOUR POINTED S" +
	"TARSPARKLESSTRESS OUTLINED WHITE STARCIRCLED WHITE STAROPEN CENTRE BLACK" +
	" STARBLACK CENTRE WHITE STAROUTLINED BLACK STARHEAVY OUTLINED BLACK STAR" +
	"PINWHEEL STARSHADOWED WHITE STARHEAVY ASTERISKOPEN CENTRE ASTERISKEIGHT " +
	"SPOKED ASTERISKEIGHT POINTED BLACK STAREIGHT POINTED PINWHEEL STARSIX PO" +
	"INTED BLACK STAREIGHT POINTED RECTILINEAR BLACK STARHEAVY EIGHT POINTED " +
	"RECTILINEAR BLACK STARTWELVE POINTED BLACK STARSIXTEEN POINTED ASTERISKT" +
	"EARDROP-SPOKED ASTERISKOPEN CENTRE TEARDROP-SPOKED ASTERISKHEAVY TEARDRO" +
	"P-SPOKED ASTERISKSIX PETALLED BLACK AND WHITE FLORETTEBLACK FLORETTEWHIT" +
	"E FLORETTEEIGHT PETALLED OUTLINED BLACK FLORETTECIRCLED OPEN CENTRE EIGH" +
	"T POINTED STARHEAVY TEARDROP-SPOKED PINWHEEL ASTERISKSNOWFLAKETIGHT TRIF" +
	"OLIATE SNOWFLAKEHEAVY CHEVRON SNOWFLAKESPARKLEHEAVY SPARKLEBALLOON-SPOKE" +
	"D ASTERISKEIGHT TEARDROP-SPOKED PROPELLER ASTERISKHEAVY EIGHT TEARDROP-S" +
	"POKED PROPELLER ASTERISKCROSS MARKSHADOWED WHITE CIRCLENEGATIVE SQUARED " +
	"CROSS MARKLOWER RIGHT DROP-SHADOWED WHITE SQUAREUPPER RIGHT DROP-SHADOWE" +
	"D WHITE SQUARELOWER RIGHT SHADOWED WHITE SQUAREUPPER RIGHT SHADOWED WHIT" +
	"E SQUAREBLACK QUESTION MARK ORNAMENTWHITE QUESTION MARK ORNAMENTWHITE EX" +
	"CLAMATION MARK ORNAMENTBLACK DIAMOND MINUS WHITE XHEAVY EXCLAMATION MARK" +
	" SYMBOLLIGHT VERTICAL BARMEDIUM VERTICAL BARHEAVY VERTICAL BARHEAVY SING" +
	"LE TURNED COMMA QUOTATION MARK ORNAMENTHEAVY SINGLE COMMA QUOTATION MARK" +
	" ORNAMENTHEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENTHEAVY DOUBLE C" +
	"OMMA QUOTATION MARK ORNAMENTHEAVY LOW SINGLE COMMA QUOTATION MARK ORNAME") + ("" +
	"NTHEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENTCURVED STEM PARAGRAPH SI" +
	"GN ORNAMENTHEAVY EXCLAMATION MARK ORNAMENTHEAVY HEART EXCLAMATION MARK O" +
	"RNAMENTHEAVY BLACK HEARTROTATED HEAVY BLACK HEART BULLETFLORAL HEARTROTA" +
	"TED FLORAL HEART BULLETMEDIUM LEFT PARENTHESIS ORNAMENTMEDIUM RIGHT PARE" +
	"NTHESIS ORNAMENTMEDIUM FLATTENED LEFT PARENTHESIS ORNAMENTMEDIUM FLATTEN" +
	"ED RIGHT PARENTHESIS ORNAMENTMEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT" +
	"MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENTHEAVY LEFT-POINTING ANGLE QU" +
	"OTATION MARK ORNAMENTHEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENTH" +
	"EAVY LEFT-POINTING ANGLE BRACKET ORNAMENTHEAVY RIGHT-POINTING ANGLE BRAC" +
	"KET ORNAMENTLIGHT LEFT TORTOISE SHELL BRACKET ORNAMENTLIGHT RIGHT TORTOI" +
	"SE SHELL BRACKET ORNAMENTMEDIUM LEFT CURLY BRACKET ORNAMENTMEDIUM RIGHT " +
	"CURLY BRACKET ORNAMENTDINGBAT NEGATIVE CIRCLED DIGIT ONEDINGBAT NEGATIVE" +
	" CIRCLED DIGIT TWODINGBAT NEGATIVE CIRCLED DIGIT THREEDINGBAT NEGATIVE C" +
	"IRCLED DIGIT FOURDINGBAT NEGATIVE CIRCLED DIGIT FIVEDINGBAT NEGATIVE CIR" +
	"CLED DIGIT SIXDINGBAT NEGATIVE CIRCLED DIGIT SEVENDINGBAT NEGATIVE CIRCL" +
	"ED DIGIT EIGHTDINGBAT NEGATIVE CIRCLED DIGIT NINEDINGBAT NEGATIVE CIRCLE" +
	"D NUMBER TENDINGBAT CIRCLED SANS-SERIF DIGIT ONEDINGBAT CIRCLED SANS-SER" +
	"IF DIGIT TWODINGBAT CIRCLED SANS-SERIF DIGIT THREEDINGBAT CIRCLED SANS-S" +
	"ERIF DIGIT FOURDINGBAT CIRCLED SANS-SERIF DIGIT FIVEDINGBAT CIRCLED SANS" +
	"-SERIF DIGIT SIXDINGBAT CIRCLED SANS-SERIF DIGIT SEVENDINGBAT CIRCLED SA" +
	"NS-SERIF DIGIT EIGHTDINGBAT CIRCLED SANS-SERIF DIGIT NINEDINGBAT CIRCLED" +
	" SANS-SERIF NUMBER TENDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONEDINGB" +
	"AT NEGATIVE CIRCLED SANS-SERIF DIGIT TWODINGBAT NEGATIVE CIRCLED SANS-SE" +
	"RIF DIGIT THREEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOURDINGBAT NEG" +
	"ATIVE CIRCLED SANS-SERIF DIGIT FIVEDINGBAT NEGATIVE CIRCLED SANS-SERIF D" +
	"IGIT SIXDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVENDINGBAT NEGATIVE " +
	"CIRCLED SANS-SERIF DIGIT EIGHTDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT " +
	"NINEDINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TENHEAVY WIDE-HEADED RIGH" +
	"TWARDS ARROWHEAVY PLUS SIGNHEAVY MINUS SIGNHEAVY DIVISION SIGNHEAVY SOUT" +
	"H EAST ARROWHEAVY RIGHTWARDS ARROWHEAVY NORTH EAST ARROWDRAFTING POINT R" +
	"IGHTWARDS ARROWHEAVY ROUND-TIPPED RIGHTWARDS ARROWTRIANGLE-HEADED RIGHTW" +
	"ARDS ARROWHEAVY TRIANGLE-HEADED RIGHTWARDS ARROWDASHED TRIANGLE-HEADED R" +
	"IGHTWARDS ARROWHEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROWBLACK RIGHTW" +
	"ARDS ARROWTHREE-D TOP-LIGHTED RIGHTWARDS ARROWHEADTHREE-D BOTTOM-LIGHTED" +
	" RIGHTWARDS ARROWHEADBLACK RIGHTWARDS ARROWHEADHEAVY BLACK CURVED DOWNWA" +
	"RDS AND RIGHTWARDS ARROWHEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROWS" +
	"QUAT BLACK RIGHTWARDS ARROWHEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROWR" +
	"IGHT-SHADED WHITE RIGHTWARDS ARROWLEFT-SHADED WHITE RIGHTWARDS ARROWBACK" +
	"-TILTED SHADOWED WHITE RIGHTWARDS ARROWFRONT-TILTED SHADOWED WHITE RIGHT" +
	"WARDS ARROWHEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWHEAVY UPPER " +
	"RIGHT-SHADOWED WHITE RIGHTWARDS ARROWNOTCHED LOWER RIGHT-SHADOWED WHITE " +
	"RIGHTWARDS ARROWCURLY LOOPNOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS " +
	"ARROWCIRCLED HEAVY WHITE RIGHTWARDS ARROWWHITE-FEATHERED RIGHTWARDS ARRO" +
	"WBLACK-FEATHERED SOUTH EAST ARROWBLACK-FEATHERED RIGHTWARDS ARROWBLACK-F" +
	"EATHERED NORTH EAST ARROWHEAVY BLACK-FEATHERED SOUTH EAST ARROWHEAVY BLA" +
	"CK-FEATHERED RIGHTWARDS ARROWHEAVY BLACK-FEATHERED NORTH EAST ARROWTEARD" +
	"ROP-BARBED RIGHTWARDS ARROWHEAVY TEARDROP-SHANKED RIGHTWARDS ARROWWEDGE-" +
	"TAILED RIGHTWARDS ARROWHEAVY WEDGE-TAILED RIGHTWARDS ARROWOPEN-OUTLINED " +
	"RIGHTWARDS ARROWDOUBLE CURLY LOOPTHREE DIMENSIONAL ANGLEWHITE TRIANGLE C" +
	"ONTAINING SMALL WHITE TRIANGLEPERPENDICULAROPEN SUBSETOPEN SUPERSETLEFT " +
	"S-SHAPED BAG DELIMITERRIGHT S-SHAPED BAG DELIMITEROR WITH DOT INSIDEREVE" +
	"RSE SOLIDUS PRECEDING SUBSETSUPERSET PRECEDING SOLIDUSVERTICAL BAR WITH " +
	"HORIZONTAL STROKEMATHEMATICAL RISING DIAGONALLONG DIVISIONMATHEMATICAL F" +
	"ALLING DIAGONALSQUARED LOGICAL ANDSQUARED LOGICAL ORWHITE DIAMOND WITH C" +
	"ENTRED DOTAND WITH DOTELEMENT OF OPENING UPWARDSLOWER RIGHT CORNER WITH " +
	"DOTUPPER LEFT CORNER WITH DOTLEFT OUTER JOINRIGHT OUTER JOINFULL OUTER J" +
	"OINLARGE UP TACKLARGE DOWN TACKLEFT AND RIGHT DOUBLE TURNSTILELEFT AND R" +
	"IGHT TACKLEFT MULTIMAPLONG RIGHT TACKLONG LEFT TACKUP TACK WITH CIRCLE A" +
	"BOVELOZENGE DIVIDED BY HORIZONTAL RULEWHITE CONCAVE-SIDED DIAMONDWHITE C" +
	"ONCAVE-SIDED DIAMOND WITH LEFTWARDS TICKWHITE CONCAVE-SIDED DIAMOND WITH" +
	" RIGHTWARDS TICKWHITE SQUARE WITH LEFTWARDS TICKWHITE SQUARE WITH RIGHTW" +
	"ARDS TICKMATHEMATICAL LEFT WHITE SQUARE BRACKETMATHEMATICAL RIGHT WHITE " +
	"SQUARE BRACKETMATHEMATICAL LEFT ANGLE BRACKETMATHEMATICAL RIGHT ANGLE BR" +
	"ACKETMATHEMATICAL LEFT DOUBLE ANGLE BRACKETMATHEMATICAL RIGHT DOUBLE ANG") + ("" +
	"LE BRACKETMATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKETMATHEMATICAL RIG" +
	"HT WHITE TORTOISE SHELL BRACKETMATHEMATICAL LEFT FLATTENED PARENTHESISMA" +
	"THEMATICAL RIGHT FLATTENED PARENTHESISUPWARDS QUADRUPLE ARROWDOWNWARDS Q" +
	"UADRUPLE ARROWANTICLOCKWISE GAPPED CIRCLE ARROWCLOCKWISE GAPPED CIRCLE A" +
	"RROWRIGHT ARROW WITH CIRCLED PLUSLONG LEFTWARDS ARROWLONG RIGHTWARDS ARR" +
	"OWLONG LEFT RIGHT ARROWLONG LEFTWARDS DOUBLE ARROWLONG RIGHTWARDS DOUBLE" +
	" ARROWLONG LEFT RIGHT DOUBLE ARROWLONG LEFTWARDS ARROW FROM BARLONG RIGH" +
	"TWARDS ARROW FROM BARLONG LEFTWARDS DOUBLE ARROW FROM BARLONG RIGHTWARDS" +
	" DOUBLE ARROW FROM BARLONG RIGHTWARDS SQUIGGLE ARROWBRAILLE PATTERN BLAN" +
	"KBRAILLE PATTERN DOTS-1BRAILLE PATTERN DOTS-2BRAILLE PATTERN DOTS-12BRAI" +
	"LLE PATTERN DOTS-3BRAILLE PATTERN DOTS-13BRAILLE PATTERN DOTS-23BRAILLE " +
	"PATTERN DOTS-123BRAILLE PATTERN DOTS-4BRAILLE PATTERN DOTS-14BRAILLE PAT" +
	"TERN DOTS-24BRAILLE PATTERN DOTS-124BRAILLE PATTERN DOTS-34BRAILLE PATTE" +
	"RN DOTS-134BRAILLE PATTERN DOTS-234BRAILLE PATTERN DOTS-1234BRAILLE PATT" +
	"ERN DOTS-5BRAILLE PATTERN DOTS-15BRAILLE PATTERN DOTS-25BRAILLE PATTERN " +
	"DOTS-125BRAILLE PATTERN DOTS-35BRAILLE PATTERN DOTS-135BRAILLE PATTERN D" +
	"OTS-235BRAILLE PATTERN DOTS-1235BRAILLE PATTERN DOTS-45BRAILLE PATTERN D" +
	"OTS-145BRAILLE PATTERN DOTS-245BRAILLE PATTERN DOTS-1245BRAILLE PATTERN " +
	"DOTS-345BRAILLE PATTERN DOTS-1345BRAILLE PATTERN DOTS-2345BRAILLE PATTER" +
	"N DOTS-12345BRAILLE PATTERN DOTS-6BRAILLE PATTERN DOTS-16BRAILLE PATTERN" +
	" DOTS-26BRAILLE PATTERN DOTS-126BRAILLE PATTERN DOTS-36BRAILLE PATTERN D" +
	"OTS-136BRAILLE PATTERN DOTS-236BRAILLE PATTERN DOTS-1236BRAILLE PATTERN " +
	"DOTS-46BRAILLE PATTERN DOTS-146BRAILLE PATTERN DOTS-246BRAILLE PATTERN D" +
	"OTS-1246BRAILLE PATTERN DOTS-346BRAILLE PATTERN DOTS-1346BRAILLE PATTERN" +
	" DOTS-2346BRAILLE PATTERN DOTS-12346BRAILLE PATTERN DOTS-56BRAILLE PATTE" +
	"RN DOTS-156BRAILLE PATTERN DOTS-256BRAILLE PATTERN DOTS-1256BRAILLE PATT" +
	"ERN DOTS-356BRAILLE PATTERN DOTS-1356BRAILLE PATTERN DOTS-2356BRAILLE PA" +
	"TTERN DOTS-12356BRAILLE PATTERN DOTS-456BRAILLE PATTERN DOTS-1456BRAILLE" +
	" PATTERN DOTS-2456BRAILLE PATTERN DOTS-12456BRAILLE PATTERN DOTS-3456BRA" +
	"ILLE PATTERN DOTS-13456BRAILLE PATTERN DOTS-23456BRAILLE PATTERN DOTS-12" +
	"3456BRAILLE PATTERN DOTS-7BRAILLE PATTERN DOTS-17BRAILLE PATTERN DOTS-27" +
	"BRAILLE PATTERN DOTS-127BRAILLE PATTERN DOTS-37BRAILLE PATTERN DOTS-137B" +
	"RAILLE PATTERN DOTS-237BRAILLE PATTERN DOTS-1237BRAILLE PATTERN DOTS-47B" +
	"RAILLE PATTERN DOTS-147BRAILLE PATTERN DOTS-247BRAILLE PATTERN DOTS-1247" +
	"BRAILLE PATTERN DOTS-347BRAILLE PATTERN DOTS-1347BRAILLE PATTERN DOTS-23" +
	"47BRAILLE PATTERN DOTS-12347BRAILLE PATTERN DOTS-57BRAILLE PATTERN DOTS-" +
	"157BRAILLE PATTERN DOTS-257BRAILLE PATTERN DOTS-1257BRAILLE PATTERN DOTS" +
	"-357BRAILLE PATTERN DOTS-1357BRAILLE PATTERN DOTS-2357BRAILLE PATTERN DO" +
	"TS-12357BRAILLE PATTERN DOTS-457BRAILLE PATTERN DOTS-1457BRAILLE PATTERN" +
	" DOTS-2457BRAILLE PATTERN DOTS-12457BRAILLE PATTERN DOTS-3457BRAILLE PAT" +
	"TERN DOTS-13457BRAILLE PATTERN DOTS-23457BRAILLE PATTERN DOTS-123457BRAI" +
	"LLE PATTERN DOTS-67BRAILLE PATTERN DOTS-167BRAILLE PATTERN DOTS-267BRAIL" +
	"LE PATTERN DOTS-1267BRAILLE PATTERN DOTS-367BRAILLE PATTERN DOTS-1367BRA" +
	"ILLE PATTERN DOTS-2367BRAILLE PATTERN DOTS-12367BRAILLE PATTERN DOTS-467" +
	"BRAILLE PATTERN DOTS-1467BRAILLE PATTERN DOTS-2467BRAILLE PATTERN DOTS-1" +
	"2467BRAILLE PATTERN DOTS-3467BRAILLE PATTERN DOTS-13467BRAILLE PATTERN D" +
	"OTS-23467BRAILLE PATTERN DOTS-123467BRAILLE PATTERN DOTS-567BRAILLE PATT" +
	"ERN DOTS-1567BRAILLE PATTERN DOTS-2567BRAILLE PATTERN DOTS-12567BRAILLE " +
	"PATTERN DOTS-3567BRAILLE PATTERN DOTS-13567BRAILLE PATTERN DOTS-23567BRA" +
	"ILLE PATTERN DOTS-123567BRAILLE PATTERN DOTS-4567BRAILLE PATTERN DOTS-14" +
	"567BRAILLE PATTERN DOTS-24567BRAILLE PATTERN DOTS-124567BRAILLE PATTERN " +
	"DOTS-34567BRAILLE PATTERN DOTS-134567BRAILLE PATTERN DOTS-234567BRAILLE " +
	"PATTERN DOTS-1234567BRAILLE PATTERN DOTS-8BRAILLE PATTERN DOTS-18BRAILLE" +
	" PATTERN DOTS-28BRAILLE PATTERN DOTS-128BRAILLE PATTERN DOTS-38BRAILLE P" +
	"ATTERN DOTS-138BRAILLE PATTERN DOTS-238BRAILLE PATTERN DOTS-1238BRAILLE " +
	"PATTERN DOTS-48BRAILLE PATTERN DOTS-148BRAILLE PATTERN DOTS-248BRAILLE P" +
	"ATTERN DOTS-1248BRAILLE PATTERN DOTS-348BRAILLE PATTERN DOTS-1348BRAILLE" +
	" PATTERN DOTS-2348BRAILLE PATTERN DOTS-12348BRAILLE PATTERN DOTS-58BRAIL" +
	"LE PATTERN DOTS-158BRAILLE PATTERN DOTS-258BRAILLE PATTERN DOTS-1258BRAI" +
	"LLE PATTERN DOTS-358BRAILLE PATTERN DOTS-1358BRAILLE PATTERN DOTS-2358BR" +
	"AILLE PATTERN DOTS-12358BRAILLE PATTERN DOTS-458BRAILLE PATTERN DOTS-145" +
	"8BRAILLE PATTERN DOTS-2458BRAILLE PATTERN DOTS-12458BRAILLE PATTERN DOTS" +
	"-3458BRAILLE PATTERN DOTS-13458BRAILLE PATTERN DOTS-23458BRAILLE PATTERN" +
	" DOTS-123458BRAILLE PATTERN DOTS-68BRAILLE PATTERN DOTS-168BRAILLE PATTE") + ("" +
	"RN DOTS-268BRAILLE PATTERN DOTS-1268BRAILLE PATTERN DOTS-368BRAILLE PATT" +
	"ERN DOTS-1368BRAILLE PATTERN DOTS-2368BRAILLE PATTERN DOTS-12368BRAILLE " +
	"PATTERN DOTS-468BRAILLE PATTERN DOTS-1468BRAILLE PATTERN DOTS-2468BRAILL" +
	"E PATTERN DOTS-12468BRAILLE PATTERN DOTS-3468BRAILLE PATTERN DOTS-13468B" +
	"RAILLE PATTERN DOTS-23468BRAILLE PATTERN DOTS-123468BRAILLE PATTERN DOTS" +
	"-568BRAILLE PATTERN DOTS-1568BRAILLE PATTERN DOTS-2568BRAILLE PATTERN DO" +
	"TS-12568BRAILLE PATTERN DOTS-3568BRAILLE PATTERN DOTS-13568BRAILLE PATTE" +
	"RN DOTS-23568BRAILLE PATTERN DOTS-123568BRAILLE PATTERN DOTS-4568BRAILLE" +
	" PATTERN DOTS-14568BRAILLE PATTERN DOTS-24568BRAILLE PATTERN DOTS-124568" +
	"BRAILLE PATTERN DOTS-34568BRAILLE PATTERN DOTS-134568BRAILLE PATTERN DOT" +
	"S-234568BRAILLE PATTERN DOTS-1234568BRAILLE PATTERN DOTS-78BRAILLE PATTE" +
	"RN DOTS-178BRAILLE PATTERN DOTS-278BRAILLE PATTERN DOTS-1278BRAILLE PATT" +
	"ERN DOTS-378BRAILLE PATTERN DOTS-1378BRAILLE PATTERN DOTS-2378BRAILLE PA" +
	"TTERN DOTS-12378BRAILLE PATTERN DOTS-478BRAILLE PATTERN DOTS-1478BRAILLE" +
	" PATTERN DOTS-2478BRAILLE PATTERN DOTS-12478BRAILLE PATTERN DOTS-3478BRA" +
	"ILLE PATTERN DOTS-13478BRAILLE PATTERN DOTS-23478BRAILLE PATTERN DOTS-12" +
	"3478BRAILLE PATTERN DOTS-578BRAILLE PATTERN DOTS-1578BRAILLE PATTERN DOT" +
	"S-2578BRAILLE PATTERN DOTS-12578BRAILLE PATTERN DOTS-3578BRAILLE PATTERN" +
	" DOTS-13578BRAILLE PATTERN DOTS-23578BRAILLE PATTERN DOTS-123578BRAILLE " +
	"PATTERN DOTS-4578BRAILLE PATTERN DOTS-14578BRAILLE PATTERN DOTS-24578BRA" +
	"ILLE PATTERN DOTS-124578BRAILLE PATTERN DOTS-34578BRAILLE PATTERN DOTS-1" +
	"34578BRAILLE PATTERN DOTS-234578BRAILLE PATTERN DOTS-1234578BRAILLE PATT" +
	"ERN DOTS-678BRAILLE PATTERN DOTS-1678BRAILLE PATTERN DOTS-2678BRAILLE PA" +
	"TTERN DOTS-12678BRAILLE PATTERN DOTS-3678BRAILLE PATTERN DOTS-13678BRAIL" +
	"LE PATTERN DOTS-23678BRAILLE PATTERN DOTS-123678BRAILLE PATTERN DOTS-467" +
	"8BRAILLE PATTERN DOTS-14678BRAILLE PATTERN DOTS-24678BRAILLE PATTERN DOT" +
	"S-124678BRAILLE PATTERN DOTS-34678BRAILLE PATTERN DOTS-134678BRAILLE PAT" +
	"TERN DOTS-234678BRAILLE PATTERN DOTS-1234678BRAILLE PATTERN DOTS-5678BRA" +
	"ILLE PATTERN DOTS-15678BRAILLE PATTERN DOTS-25678BRAILLE PATTERN DOTS-12" +
	"5678BRAILLE PATTERN DOTS-35678BRAILLE PATTERN DOTS-135678BRAILLE PATTERN" +
	" DOTS-235678BRAILLE PATTERN DOTS-1235678BRAILLE PATTERN DOTS-45678BRAILL" +
	"E PATTERN DOTS-145678BRAILLE PATTERN DOTS-245678BRAILLE PATTERN DOTS-124" +
	"5678BRAILLE PATTERN DOTS-345678BRAILLE PATTERN DOTS-1345678BRAILLE PATTE" +
	"RN DOTS-2345678BRAILLE PATTERN DOTS-12345678RIGHTWARDS TWO-HEADED ARROW " +
	"WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STR" +
	"OKELEFTWARDS DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS DOUBLE ARROW WI" +
	"TH VERTICAL STROKELEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS" +
	" TWO-HEADED ARROW FROM BARLEFTWARDS DOUBLE ARROW FROM BARRIGHTWARDS DOUB" +
	"LE ARROW FROM BARDOWNWARDS ARROW WITH HORIZONTAL STROKEUPWARDS ARROW WIT" +
	"H HORIZONTAL STROKEUPWARDS TRIPLE ARROWDOWNWARDS TRIPLE ARROWLEFTWARDS D" +
	"OUBLE DASH ARROWRIGHTWARDS DOUBLE DASH ARROWLEFTWARDS TRIPLE DASH ARROWR" +
	"IGHTWARDS TRIPLE DASH ARROWRIGHTWARDS TWO-HEADED TRIPLE DASH ARROWRIGHTW" +
	"ARDS ARROW WITH DOTTED STEMUPWARDS ARROW TO BARDOWNWARDS ARROW TO BARRIG" +
	"HTWARDS ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS ARROW WITH TAIL W" +
	"ITH DOUBLE VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH TAILRIGHTWARD" +
	"S TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS TWO-HEADED A" +
	"RROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS ARROW-TAILRIGHTWARDS" +
	" ARROW-TAILLEFTWARDS DOUBLE ARROW-TAILRIGHTWARDS DOUBLE ARROW-TAILLEFTWA" +
	"RDS ARROW TO BLACK DIAMONDRIGHTWARDS ARROW TO BLACK DIAMONDLEFTWARDS ARR" +
	"OW FROM BAR TO BLACK DIAMONDRIGHTWARDS ARROW FROM BAR TO BLACK DIAMONDNO" +
	"RTH WEST AND SOUTH EAST ARROWNORTH EAST AND SOUTH WEST ARROWNORTH WEST A" +
	"RROW WITH HOOKNORTH EAST ARROW WITH HOOKSOUTH EAST ARROW WITH HOOKSOUTH " +
	"WEST ARROW WITH HOOKNORTH WEST ARROW AND NORTH EAST ARROWNORTH EAST ARRO" +
	"W AND SOUTH EAST ARROWSOUTH EAST ARROW AND SOUTH WEST ARROWSOUTH WEST AR" +
	"ROW AND NORTH WEST ARROWRISING DIAGONAL CROSSING FALLING DIAGONALFALLING" +
	" DIAGONAL CROSSING RISING DIAGONALSOUTH EAST ARROW CROSSING NORTH EAST A" +
	"RROWNORTH EAST ARROW CROSSING SOUTH EAST ARROWFALLING DIAGONAL CROSSING " +
	"NORTH EAST ARROWRISING DIAGONAL CROSSING SOUTH EAST ARROWNORTH EAST ARRO" +
	"W CROSSING NORTH WEST ARROWNORTH WEST ARROW CROSSING NORTH EAST ARROWWAV" +
	"E ARROW POINTING DIRECTLY RIGHTARROW POINTING RIGHTWARDS THEN CURVING UP" +
	"WARDSARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDSARROW POINTING DOWN" +
	"WARDS THEN CURVING LEFTWARDSARROW POINTING DOWNWARDS THEN CURVING RIGHTW" +
	"ARDSRIGHT-SIDE ARC CLOCKWISE ARROWLEFT-SIDE ARC ANTICLOCKWISE ARROWTOP A" +
	"RC ANTICLOCKWISE ARROWBOTTOM ARC ANTICLOCKWISE ARROWTOP ARC CLOCKWISE AR") + ("" +
	"ROW WITH MINUSTOP ARC ANTICLOCKWISE ARROW WITH PLUSLOWER RIGHT SEMICIRCU" +
	"LAR CLOCKWISE ARROWLOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROWANTICLOCKW" +
	"ISE CLOSED CIRCLE ARROWCLOCKWISE CLOSED CIRCLE ARROWRIGHTWARDS ARROW ABO" +
	"VE SHORT LEFTWARDS ARROWLEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROWSHOR" +
	"T RIGHTWARDS ARROW ABOVE LEFTWARDS ARROWRIGHTWARDS ARROW WITH PLUS BELOW" +
	"LEFTWARDS ARROW WITH PLUS BELOWRIGHTWARDS ARROW THROUGH XLEFT RIGHT ARRO" +
	"W THROUGH SMALL CIRCLEUPWARDS TWO-HEADED ARROW FROM SMALL CIRCLELEFT BAR" +
	"B UP RIGHT BARB DOWN HARPOONLEFT BARB DOWN RIGHT BARB UP HARPOONUP BARB " +
	"RIGHT DOWN BARB LEFT HARPOONUP BARB LEFT DOWN BARB RIGHT HARPOONLEFT BAR" +
	"B UP RIGHT BARB UP HARPOONUP BARB RIGHT DOWN BARB RIGHT HARPOONLEFT BARB" +
	" DOWN RIGHT BARB DOWN HARPOONUP BARB LEFT DOWN BARB LEFT HARPOONLEFTWARD" +
	"S HARPOON WITH BARB UP TO BARRIGHTWARDS HARPOON WITH BARB UP TO BARUPWAR" +
	"DS HARPOON WITH BARB RIGHT TO BARDOWNWARDS HARPOON WITH BARB RIGHT TO BA" +
	"RLEFTWARDS HARPOON WITH BARB DOWN TO BARRIGHTWARDS HARPOON WITH BARB DOW" +
	"N TO BARUPWARDS HARPOON WITH BARB LEFT TO BARDOWNWARDS HARPOON WITH BARB" +
	" LEFT TO BARLEFTWARDS HARPOON WITH BARB UP FROM BARRIGHTWARDS HARPOON WI" +
	"TH BARB UP FROM BARUPWARDS HARPOON WITH BARB RIGHT FROM BARDOWNWARDS HAR" +
	"POON WITH BARB RIGHT FROM BARLEFTWARDS HARPOON WITH BARB DOWN FROM BARRI" +
	"GHTWARDS HARPOON WITH BARB DOWN FROM BARUPWARDS HARPOON WITH BARB LEFT F" +
	"ROM BARDOWNWARDS HARPOON WITH BARB LEFT FROM BARLEFTWARDS HARPOON WITH B" +
	"ARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWNUPWARDS HARPOON WITH BARB L" +
	"EFT BESIDE UPWARDS HARPOON WITH BARB RIGHTRIGHTWARDS HARPOON WITH BARB U" +
	"P ABOVE RIGHTWARDS HARPOON WITH BARB DOWNDOWNWARDS HARPOON WITH BARB LEF" +
	"T BESIDE DOWNWARDS HARPOON WITH BARB RIGHTLEFTWARDS HARPOON WITH BARB UP" +
	" ABOVE RIGHTWARDS HARPOON WITH BARB UPLEFTWARDS HARPOON WITH BARB DOWN A" +
	"BOVE RIGHTWARDS HARPOON WITH BARB DOWNRIGHTWARDS HARPOON WITH BARB UP AB" +
	"OVE LEFTWARDS HARPOON WITH BARB UPRIGHTWARDS HARPOON WITH BARB DOWN ABOV" +
	"E LEFTWARDS HARPOON WITH BARB DOWNLEFTWARDS HARPOON WITH BARB UP ABOVE L" +
	"ONG DASHLEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASHRIGHTWARDS HARPO" +
	"ON WITH BARB UP ABOVE LONG DASHRIGHTWARDS HARPOON WITH BARB DOWN BELOW L" +
	"ONG DASHUPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BAR" +
	"B RIGHTDOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB" +
	" RIGHTRIGHT DOUBLE ARROW WITH ROUNDED HEADEQUALS SIGN ABOVE RIGHTWARDS A" +
	"RROWTILDE OPERATOR ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW ABOVE TILDE OPE" +
	"RATORRIGHTWARDS ARROW ABOVE TILDE OPERATORRIGHTWARDS ARROW ABOVE ALMOST " +
	"EQUAL TOLESS-THAN ABOVE LEFTWARDS ARROWLEFTWARDS ARROW THROUGH LESS-THAN" +
	"GREATER-THAN ABOVE RIGHTWARDS ARROWSUBSET ABOVE RIGHTWARDS ARROWLEFTWARD" +
	"S ARROW THROUGH SUBSETSUPERSET ABOVE LEFTWARDS ARROWLEFT FISH TAILRIGHT " +
	"FISH TAILUP FISH TAILDOWN FISH TAILTRIPLE VERTICAL BAR DELIMITERZ NOTATI" +
	"ON SPOTZ NOTATION TYPE COLONLEFT WHITE CURLY BRACKETRIGHT WHITE CURLY BR" +
	"ACKETLEFT WHITE PARENTHESISRIGHT WHITE PARENTHESISZ NOTATION LEFT IMAGE " +
	"BRACKETZ NOTATION RIGHT IMAGE BRACKETZ NOTATION LEFT BINDING BRACKETZ NO" +
	"TATION RIGHT BINDING BRACKETLEFT SQUARE BRACKET WITH UNDERBARRIGHT SQUAR" +
	"E BRACKET WITH UNDERBARLEFT SQUARE BRACKET WITH TICK IN TOP CORNERRIGHT " +
	"SQUARE BRACKET WITH TICK IN BOTTOM CORNERLEFT SQUARE BRACKET WITH TICK I" +
	"N BOTTOM CORNERRIGHT SQUARE BRACKET WITH TICK IN TOP CORNERLEFT ANGLE BR" +
	"ACKET WITH DOTRIGHT ANGLE BRACKET WITH DOTLEFT ARC LESS-THAN BRACKETRIGH" +
	"T ARC GREATER-THAN BRACKETDOUBLE LEFT ARC GREATER-THAN BRACKETDOUBLE RIG" +
	"HT ARC LESS-THAN BRACKETLEFT BLACK TORTOISE SHELL BRACKETRIGHT BLACK TOR" +
	"TOISE SHELL BRACKETDOTTED FENCEVERTICAL ZIGZAG LINEMEASURED ANGLE OPENIN" +
	"G LEFTRIGHT ANGLE VARIANT WITH SQUAREMEASURED RIGHT ANGLE WITH DOTANGLE " +
	"WITH S INSIDEACUTE ANGLESPHERICAL ANGLE OPENING LEFTSPHERICAL ANGLE OPEN" +
	"ING UPTURNED ANGLEREVERSED ANGLEANGLE WITH UNDERBARREVERSED ANGLE WITH U" +
	"NDERBAROBLIQUE ANGLE OPENING UPOBLIQUE ANGLE OPENING DOWNMEASURED ANGLE " +
	"WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHTMEASURED ANGLE WITH O" +
	"PEN ARM ENDING IN ARROW POINTING UP AND LEFTMEASURED ANGLE WITH OPEN ARM" +
	" ENDING IN ARROW POINTING DOWN AND RIGHTMEASURED ANGLE WITH OPEN ARM END" +
	"ING IN ARROW POINTING DOWN AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING I" +
	"N ARROW POINTING RIGHT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARRO" +
	"W POINTING LEFT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINT" +
	"ING RIGHT AND DOWNMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING " +
	"LEFT AND DOWNREVERSED EMPTY SETEMPTY SET WITH OVERBAREMPTY SET WITH SMAL" +
	"L CIRCLE ABOVEEMPTY SET WITH RIGHT ARROW ABOVEEMPTY SET WITH LEFT ARROW " +
	"ABOVECIRCLE WITH HORIZONTAL BARCIRCLED VERTICAL BARCIRCLED PARALLELCIRCL") + ("" +
	"ED REVERSE SOLIDUSCIRCLED PERPENDICULARCIRCLE DIVIDED BY HORIZONTAL BAR " +
	"AND TOP HALF DIVIDED BY VERTICAL BARCIRCLE WITH SUPERIMPOSED XCIRCLED AN" +
	"TICLOCKWISE-ROTATED DIVISION SIGNUP ARROW THROUGH CIRCLECIRCLED WHITE BU" +
	"LLETCIRCLED BULLETCIRCLED LESS-THANCIRCLED GREATER-THANCIRCLE WITH SMALL" +
	" CIRCLE TO THE RIGHTCIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHTSQUAR" +
	"ED RISING DIAGONAL SLASHSQUARED FALLING DIAGONAL SLASHSQUARED ASTERISKSQ" +
	"UARED SMALL CIRCLESQUARED SQUARETWO JOINED SQUARESTRIANGLE WITH DOT ABOV" +
	"ETRIANGLE WITH UNDERBARS IN TRIANGLETRIANGLE WITH SERIFS AT BOTTOMRIGHT " +
	"TRIANGLE ABOVE LEFT TRIANGLELEFT TRIANGLE BESIDE VERTICAL BARVERTICAL BA" +
	"R BESIDE RIGHT TRIANGLEBOWTIE WITH LEFT HALF BLACKBOWTIE WITH RIGHT HALF" +
	" BLACKBLACK BOWTIETIMES WITH LEFT HALF BLACKTIMES WITH RIGHT HALF BLACKW" +
	"HITE HOURGLASSBLACK HOURGLASSLEFT WIGGLY FENCERIGHT WIGGLY FENCELEFT DOU" +
	"BLE WIGGLY FENCERIGHT DOUBLE WIGGLY FENCEINCOMPLETE INFINITYTIE OVER INF" +
	"INITYINFINITY NEGATED WITH VERTICAL BARDOUBLE-ENDED MULTIMAPSQUARE WITH " +
	"CONTOURED OUTLINEINCREASES ASSHUFFLE PRODUCTEQUALS SIGN AND SLANTED PARA" +
	"LLELEQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVEIDENTICAL TO AND SL" +
	"ANTED PARALLELGLEICH STARKTHERMODYNAMICDOWN-POINTING TRIANGLE WITH LEFT " +
	"HALF BLACKDOWN-POINTING TRIANGLE WITH RIGHT HALF BLACKBLACK DIAMOND WITH" +
	" DOWN ARROWBLACK LOZENGEWHITE CIRCLE WITH DOWN ARROWBLACK CIRCLE WITH DO" +
	"WN ARROWERROR-BARRED WHITE SQUAREERROR-BARRED BLACK SQUAREERROR-BARRED W" +
	"HITE DIAMONDERROR-BARRED BLACK DIAMONDERROR-BARRED WHITE CIRCLEERROR-BAR" +
	"RED BLACK CIRCLERULE-DELAYEDREVERSE SOLIDUS OPERATORSOLIDUS WITH OVERBAR" +
	"REVERSE SOLIDUS WITH HORIZONTAL STROKEBIG SOLIDUSBIG REVERSE SOLIDUSDOUB" +
	"LE PLUSTRIPLE PLUSLEFT-POINTING CURVED ANGLE BRACKETRIGHT-POINTING CURVE" +
	"D ANGLE BRACKETTINYMINYN-ARY CIRCLED DOT OPERATORN-ARY CIRCLED PLUS OPER" +
	"ATORN-ARY CIRCLED TIMES OPERATORN-ARY UNION OPERATOR WITH DOTN-ARY UNION" +
	" OPERATOR WITH PLUSN-ARY SQUARE INTERSECTION OPERATORN-ARY SQUARE UNION " +
	"OPERATORTWO LOGICAL AND OPERATORTWO LOGICAL OR OPERATORN-ARY TIMES OPERA" +
	"TORMODULO TWO SUMSUMMATION WITH INTEGRALQUADRUPLE INTEGRAL OPERATORFINIT" +
	"E PART INTEGRALINTEGRAL WITH DOUBLE STROKEINTEGRAL AVERAGE WITH SLASHCIR" +
	"CULATION FUNCTIONANTICLOCKWISE INTEGRATIONLINE INTEGRATION WITH RECTANGU" +
	"LAR PATH AROUND POLELINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLEL" +
	"INE INTEGRATION NOT INCLUDING THE POLEINTEGRAL AROUND A POINT OPERATORQU" +
	"ATERNION INTEGRAL OPERATORINTEGRAL WITH LEFTWARDS ARROW WITH HOOKINTEGRA" +
	"L WITH TIMES SIGNINTEGRAL WITH INTERSECTIONINTEGRAL WITH UNIONINTEGRAL W" +
	"ITH OVERBARINTEGRAL WITH UNDERBARJOINLARGE LEFT TRIANGLE OPERATORZ NOTAT" +
	"ION SCHEMA COMPOSITIONZ NOTATION SCHEMA PIPINGZ NOTATION SCHEMA PROJECTI" +
	"ONPLUS SIGN WITH SMALL CIRCLE ABOVEPLUS SIGN WITH CIRCUMFLEX ACCENT ABOV" +
	"EPLUS SIGN WITH TILDE ABOVEPLUS SIGN WITH DOT BELOWPLUS SIGN WITH TILDE " +
	"BELOWPLUS SIGN WITH SUBSCRIPT TWOPLUS SIGN WITH BLACK TRIANGLEMINUS SIGN" +
	" WITH COMMA ABOVEMINUS SIGN WITH DOT BELOWMINUS SIGN WITH FALLING DOTSMI" +
	"NUS SIGN WITH RISING DOTSPLUS SIGN IN LEFT HALF CIRCLEPLUS SIGN IN RIGHT" +
	" HALF CIRCLEVECTOR OR CROSS PRODUCTMULTIPLICATION SIGN WITH DOT ABOVEMUL" +
	"TIPLICATION SIGN WITH UNDERBARSEMIDIRECT PRODUCT WITH BOTTOM CLOSEDSMASH" +
	" PRODUCTMULTIPLICATION SIGN IN LEFT HALF CIRCLEMULTIPLICATION SIGN IN RI" +
	"GHT HALF CIRCLECIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENTMULTIPL" +
	"ICATION SIGN IN DOUBLE CIRCLECIRCLED DIVISION SIGNPLUS SIGN IN TRIANGLEM" +
	"INUS SIGN IN TRIANGLEMULTIPLICATION SIGN IN TRIANGLEINTERIOR PRODUCTRIGH" +
	"THAND INTERIOR PRODUCTZ NOTATION RELATIONAL COMPOSITIONAMALGAMATION OR C" +
	"OPRODUCTINTERSECTION WITH DOTUNION WITH MINUS SIGNUNION WITH OVERBARINTE" +
	"RSECTION WITH OVERBARINTERSECTION WITH LOGICAL ANDUNION WITH LOGICAL ORU" +
	"NION ABOVE INTERSECTIONINTERSECTION ABOVE UNIONUNION ABOVE BAR ABOVE INT" +
	"ERSECTIONINTERSECTION ABOVE BAR ABOVE UNIONUNION BESIDE AND JOINED WITH " +
	"UNIONINTERSECTION BESIDE AND JOINED WITH INTERSECTIONCLOSED UNION WITH S" +
	"ERIFSCLOSED INTERSECTION WITH SERIFSDOUBLE SQUARE INTERSECTIONDOUBLE SQU" +
	"ARE UNIONCLOSED UNION WITH SERIFS AND SMASH PRODUCTLOGICAL AND WITH DOT " +
	"ABOVELOGICAL OR WITH DOT ABOVEDOUBLE LOGICAL ANDDOUBLE LOGICAL ORTWO INT" +
	"ERSECTING LOGICAL ANDTWO INTERSECTING LOGICAL ORSLOPING LARGE ORSLOPING " +
	"LARGE ANDLOGICAL OR OVERLAPPING LOGICAL ANDLOGICAL AND WITH MIDDLE STEML" +
	"OGICAL OR WITH MIDDLE STEMLOGICAL AND WITH HORIZONTAL DASHLOGICAL OR WIT" +
	"H HORIZONTAL DASHLOGICAL AND WITH DOUBLE OVERBARLOGICAL AND WITH UNDERBA" +
	"RLOGICAL AND WITH DOUBLE UNDERBARSMALL VEE WITH UNDERBARLOGICAL OR WITH " +
	"DOUBLE OVERBARLOGICAL OR WITH DOUBLE UNDERBARZ NOTATION DOMAIN ANTIRESTR" +
	"ICTIONZ NOTATION RANGE ANTIRESTRICTIONEQUALS SIGN WITH DOT BELOWIDENTICA") + ("" +
	"L WITH DOT ABOVETRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKETRIPLE " +
	"HORIZONTAL BAR WITH TRIPLE VERTICAL STROKETILDE OPERATOR WITH DOT ABOVET" +
	"ILDE OPERATOR WITH RISING DOTSSIMILAR MINUS SIMILARCONGRUENT WITH DOT AB" +
	"OVEEQUALS WITH ASTERISKALMOST EQUAL TO WITH CIRCUMFLEX ACCENTAPPROXIMATE" +
	"LY EQUAL OR EQUAL TOEQUALS SIGN ABOVE PLUS SIGNPLUS SIGN ABOVE EQUALS SI" +
	"GNEQUALS SIGN ABOVE TILDE OPERATORDOUBLE COLON EQUALTWO CONSECUTIVE EQUA" +
	"LS SIGNSTHREE CONSECUTIVE EQUALS SIGNSEQUALS SIGN WITH TWO DOTS ABOVE AN" +
	"D TWO DOTS BELOWEQUIVALENT WITH FOUR DOTS ABOVELESS-THAN WITH CIRCLE INS" +
	"IDEGREATER-THAN WITH CIRCLE INSIDELESS-THAN WITH QUESTION MARK ABOVEGREA" +
	"TER-THAN WITH QUESTION MARK ABOVELESS-THAN OR SLANTED EQUAL TOGREATER-TH" +
	"AN OR SLANTED EQUAL TOLESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDEGREAT" +
	"ER-THAN OR SLANTED EQUAL TO WITH DOT INSIDELESS-THAN OR SLANTED EQUAL TO" +
	" WITH DOT ABOVEGREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVELESS-THAN " +
	"OR SLANTED EQUAL TO WITH DOT ABOVE RIGHTGREATER-THAN OR SLANTED EQUAL TO" +
	" WITH DOT ABOVE LEFTLESS-THAN OR APPROXIMATEGREATER-THAN OR APPROXIMATEL" +
	"ESS-THAN AND SINGLE-LINE NOT EQUAL TOGREATER-THAN AND SINGLE-LINE NOT EQ" +
	"UAL TOLESS-THAN AND NOT APPROXIMATEGREATER-THAN AND NOT APPROXIMATELESS-" +
	"THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THANGREATER-THAN ABOVE DOUBLE" +
	"-LINE EQUAL ABOVE LESS-THANLESS-THAN ABOVE SIMILAR OR EQUALGREATER-THAN " +
	"ABOVE SIMILAR OR EQUALLESS-THAN ABOVE SIMILAR ABOVE GREATER-THANGREATER-" +
	"THAN ABOVE SIMILAR ABOVE LESS-THANLESS-THAN ABOVE GREATER-THAN ABOVE DOU" +
	"BLE-LINE EQUALGREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUALLESS-T" +
	"HAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUALGREATER-TH" +
	"AN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUALSLANTED EQUAL " +
	"TO OR LESS-THANSLANTED EQUAL TO OR GREATER-THANSLANTED EQUAL TO OR LESS-" +
	"THAN WITH DOT INSIDESLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDEDOUB" +
	"LE-LINE EQUAL TO OR LESS-THANDOUBLE-LINE EQUAL TO OR GREATER-THANDOUBLE-" +
	"LINE SLANTED EQUAL TO OR LESS-THANDOUBLE-LINE SLANTED EQUAL TO OR GREATE" +
	"R-THANSIMILAR OR LESS-THANSIMILAR OR GREATER-THANSIMILAR ABOVE LESS-THAN" +
	" ABOVE EQUALS SIGNSIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGNDOUBLE NES" +
	"TED LESS-THANDOUBLE NESTED GREATER-THANDOUBLE NESTED LESS-THAN WITH UNDE" +
	"RBARGREATER-THAN OVERLAPPING LESS-THANGREATER-THAN BESIDE LESS-THANLESS-" +
	"THAN CLOSED BY CURVEGREATER-THAN CLOSED BY CURVELESS-THAN CLOSED BY CURV" +
	"E ABOVE SLANTED EQUALGREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUALSMA" +
	"LLER THANLARGER THANSMALLER THAN OR EQUAL TOLARGER THAN OR EQUAL TOEQUAL" +
	"S SIGN WITH BUMPY ABOVEPRECEDES ABOVE SINGLE-LINE EQUALS SIGNSUCCEEDS AB" +
	"OVE SINGLE-LINE EQUALS SIGNPRECEDES ABOVE SINGLE-LINE NOT EQUAL TOSUCCEE" +
	"DS ABOVE SINGLE-LINE NOT EQUAL TOPRECEDES ABOVE EQUALS SIGNSUCCEEDS ABOV" +
	"E EQUALS SIGNPRECEDES ABOVE NOT EQUAL TOSUCCEEDS ABOVE NOT EQUAL TOPRECE" +
	"DES ABOVE ALMOST EQUAL TOSUCCEEDS ABOVE ALMOST EQUAL TOPRECEDES ABOVE NO" +
	"T ALMOST EQUAL TOSUCCEEDS ABOVE NOT ALMOST EQUAL TODOUBLE PRECEDESDOUBLE" +
	" SUCCEEDSSUBSET WITH DOTSUPERSET WITH DOTSUBSET WITH PLUS SIGN BELOWSUPE" +
	"RSET WITH PLUS SIGN BELOWSUBSET WITH MULTIPLICATION SIGN BELOWSUPERSET W" +
	"ITH MULTIPLICATION SIGN BELOWSUBSET OF OR EQUAL TO WITH DOT ABOVESUPERSE" +
	"T OF OR EQUAL TO WITH DOT ABOVESUBSET OF ABOVE EQUALS SIGNSUPERSET OF AB" +
	"OVE EQUALS SIGNSUBSET OF ABOVE TILDE OPERATORSUPERSET OF ABOVE TILDE OPE" +
	"RATORSUBSET OF ABOVE ALMOST EQUAL TOSUPERSET OF ABOVE ALMOST EQUAL TOSUB" +
	"SET OF ABOVE NOT EQUAL TOSUPERSET OF ABOVE NOT EQUAL TOSQUARE LEFT OPEN " +
	"BOX OPERATORSQUARE RIGHT OPEN BOX OPERATORCLOSED SUBSETCLOSED SUPERSETCL" +
	"OSED SUBSET OR EQUAL TOCLOSED SUPERSET OR EQUAL TOSUBSET ABOVE SUPERSETS" +
	"UPERSET ABOVE SUBSETSUBSET ABOVE SUBSETSUPERSET ABOVE SUPERSETSUPERSET B" +
	"ESIDE SUBSETSUPERSET BESIDE AND JOINED BY DASH WITH SUBSETELEMENT OF OPE" +
	"NING DOWNWARDSPITCHFORK WITH TEE TOPTRANSVERSAL INTERSECTIONFORKINGNONFO" +
	"RKINGSHORT LEFT TACKSHORT DOWN TACKSHORT UP TACKPERPENDICULAR WITH SVERT" +
	"ICAL BAR TRIPLE RIGHT TURNSTILEDOUBLE VERTICAL BAR LEFT TURNSTILEVERTICA" +
	"L BAR DOUBLE LEFT TURNSTILEDOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILELONG" +
	" DASH FROM LEFT MEMBER OF DOUBLE VERTICALSHORT DOWN TACK WITH OVERBARSHO" +
	"RT UP TACK WITH UNDERBARSHORT UP TACK ABOVE SHORT DOWN TACKDOUBLE DOWN T" +
	"ACKDOUBLE UP TACKDOUBLE STROKE NOT SIGNREVERSED DOUBLE STROKE NOT SIGNDO" +
	"ES NOT DIVIDE WITH REVERSED NEGATION SLASHVERTICAL LINE WITH CIRCLE ABOV" +
	"EVERTICAL LINE WITH CIRCLE BELOWDOWN TACK WITH CIRCLE BELOWPARALLEL WITH" +
	" HORIZONTAL STROKEPARALLEL WITH TILDE OPERATORTRIPLE VERTICAL BAR BINARY" +
	" RELATIONTRIPLE VERTICAL BAR WITH HORIZONTAL STROKETRIPLE COLON OPERATOR" +
	"TRIPLE NESTED LESS-THANTRIPLE NESTED GREATER-THANDOUBLE-LINE SLANTED LES") + ("" +
	"S-THAN OR EQUAL TODOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TOTRIPLE SOL" +
	"IDUS BINARY RELATIONLARGE TRIPLE VERTICAL BAR OPERATORDOUBLE SOLIDUS OPE" +
	"RATORWHITE VERTICAL BARN-ARY WHITE VERTICAL BARNORTH EAST WHITE ARROWNOR" +
	"TH WEST WHITE ARROWSOUTH EAST WHITE ARROWSOUTH WEST WHITE ARROWLEFT RIGH" +
	"T WHITE ARROWLEFTWARDS BLACK ARROWUPWARDS BLACK ARROWDOWNWARDS BLACK ARR" +
	"OWNORTH EAST BLACK ARROWNORTH WEST BLACK ARROWSOUTH EAST BLACK ARROWSOUT" +
	"H WEST BLACK ARROWLEFT RIGHT BLACK ARROWUP DOWN BLACK ARROWRIGHTWARDS AR" +
	"ROW WITH TIP DOWNWARDSRIGHTWARDS ARROW WITH TIP UPWARDSLEFTWARDS ARROW W" +
	"ITH TIP DOWNWARDSLEFTWARDS ARROW WITH TIP UPWARDSSQUARE WITH TOP HALF BL" +
	"ACKSQUARE WITH BOTTOM HALF BLACKSQUARE WITH UPPER RIGHT DIAGONAL HALF BL" +
	"ACKSQUARE WITH LOWER LEFT DIAGONAL HALF BLACKDIAMOND WITH LEFT HALF BLAC" +
	"KDIAMOND WITH RIGHT HALF BLACKDIAMOND WITH TOP HALF BLACKDIAMOND WITH BO" +
	"TTOM HALF BLACKDOTTED SQUAREBLACK LARGE SQUAREWHITE LARGE SQUAREBLACK VE" +
	"RY SMALL SQUAREWHITE VERY SMALL SQUAREBLACK PENTAGONWHITE PENTAGONWHITE " +
	"HEXAGONBLACK HEXAGONHORIZONTAL BLACK HEXAGONBLACK LARGE CIRCLEBLACK MEDI" +
	"UM DIAMONDWHITE MEDIUM DIAMONDBLACK MEDIUM LOZENGEWHITE MEDIUM LOZENGEBL" +
	"ACK SMALL DIAMONDBLACK SMALL LOZENGEWHITE SMALL LOZENGEBLACK HORIZONTAL " +
	"ELLIPSEWHITE HORIZONTAL ELLIPSEBLACK VERTICAL ELLIPSEWHITE VERTICAL ELLI" +
	"PSELEFT ARROW WITH SMALL CIRCLETHREE LEFTWARDS ARROWSLEFT ARROW WITH CIR" +
	"CLED PLUSLONG LEFTWARDS SQUIGGLE ARROWLEFTWARDS TWO-HEADED ARROW WITH VE" +
	"RTICAL STROKELEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTW" +
	"ARDS TWO-HEADED ARROW FROM BARLEFTWARDS TWO-HEADED TRIPLE DASH ARROWLEFT" +
	"WARDS ARROW WITH DOTTED STEMLEFTWARDS ARROW WITH TAIL WITH VERTICAL STRO" +
	"KELEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEA" +
	"DED ARROW WITH TAILLEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL ST" +
	"ROKELEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFT" +
	"WARDS ARROW THROUGH XWAVE ARROW POINTING DIRECTLY LEFTEQUALS SIGN ABOVE " +
	"LEFTWARDS ARROWREVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARR" +
	"OW ABOVE REVERSE ALMOST EQUAL TORIGHTWARDS ARROW THROUGH GREATER-THANRIG" +
	"HTWARDS ARROW THROUGH SUPERSETLEFTWARDS QUADRUPLE ARROWRIGHTWARDS QUADRU" +
	"PLE ARROWREVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROWRIGHTWARDS ARROW A" +
	"BOVE REVERSE ALMOST EQUAL TOTILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARD" +
	"S ARROW ABOVE ALMOST EQUAL TOLEFTWARDS ARROW ABOVE REVERSE TILDE OPERATO" +
	"RRIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATORDOWNWARDS TRIANGLE-HEADED " +
	"ZIGZAG ARROWSHORT SLANTED NORTH ARROWSHORT BACKSLANTED SOUTH ARROWWHITE " +
	"MEDIUM STARBLACK SMALL STARWHITE SMALL STARBLACK RIGHT-POINTING PENTAGON" +
	"WHITE RIGHT-POINTING PENTAGONHEAVY LARGE CIRCLEHEAVY OVAL WITH OVAL INSI" +
	"DEHEAVY CIRCLE WITH CIRCLE INSIDEHEAVY CIRCLEHEAVY CIRCLED SALTIRESLANTE" +
	"D NORTH ARROW WITH HOOKED HEADBACKSLANTED SOUTH ARROW WITH HOOKED TAILSL" +
	"ANTED NORTH ARROW WITH HORIZONTAL TAILBACKSLANTED SOUTH ARROW WITH HORIZ" +
	"ONTAL TAILBENT ARROW POINTING DOWNWARDS THEN NORTH EASTSHORT BENT ARROW " +
	"POINTING DOWNWARDS THEN NORTH EASTLEFTWARDS TRIANGLE-HEADED ARROWUPWARDS" +
	" TRIANGLE-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROWDOWNWARDS TRIANGLE" +
	"-HEADED ARROWLEFT RIGHT TRIANGLE-HEADED ARROWUP DOWN TRIANGLE-HEADED ARR" +
	"OWNORTH WEST TRIANGLE-HEADED ARROWNORTH EAST TRIANGLE-HEADED ARROWSOUTH " +
	"EAST TRIANGLE-HEADED ARROWSOUTH WEST TRIANGLE-HEADED ARROWLEFTWARDS TRIA" +
	"NGLE-HEADED DASHED ARROWUPWARDS TRIANGLE-HEADED DASHED ARROWRIGHTWARDS T" +
	"RIANGLE-HEADED DASHED ARROWDOWNWARDS TRIANGLE-HEADED DASHED ARROWCLOCKWI" +
	"SE TRIANGLE-HEADED OPEN CIRCLE ARROWANTICLOCKWISE TRIANGLE-HEADED OPEN C" +
	"IRCLE ARROWLEFTWARDS TRIANGLE-HEADED ARROW TO BARUPWARDS TRIANGLE-HEADED" +
	" ARROW TO BARRIGHTWARDS TRIANGLE-HEADED ARROW TO BARDOWNWARDS TRIANGLE-H" +
	"EADED ARROW TO BARNORTH WEST TRIANGLE-HEADED ARROW TO BARNORTH EAST TRIA" +
	"NGLE-HEADED ARROW TO BARSOUTH EAST TRIANGLE-HEADED ARROW TO BARSOUTH WES" +
	"T TRIANGLE-HEADED ARROW TO BARLEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBL" +
	"E HORIZONTAL STROKEUPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL " +
	"STROKERIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEDOWN" +
	"WARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEHORIZONTAL TAB " +
	"KEYVERTICAL TAB KEYLEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIAN" +
	"GLE-HEADED ARROWUPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRI" +
	"ANGLE-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANG" +
	"LE-HEADED ARROWDOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIA" +
	"NGLE-HEADED ARROWLEFTWARDS TRIANGLE-HEADED PAIRED ARROWSUPWARDS TRIANGLE" +
	"-HEADED PAIRED ARROWSRIGHTWARDS TRIANGLE-HEADED PAIRED ARROWSDOWNWARDS T" +
	"RIANGLE-HEADED PAIRED ARROWSLEFTWARDS BLACK CIRCLED WHITE ARROWUPWARDS B") + ("" +
	"LACK CIRCLED WHITE ARROWRIGHTWARDS BLACK CIRCLED WHITE ARROWDOWNWARDS BL" +
	"ACK CIRCLED WHITE ARROWANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARRO" +
	"WANTICLOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROWANTICLOCKWISE TRIANG" +
	"LE-HEADED LEFT U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED " +
	"ARROWRETURN LEFTRETURN RIGHTNEWLINE LEFTNEWLINE RIGHTFOUR CORNER ARROWS " +
	"CIRCLING ANTICLOCKWISERIGHTWARDS BLACK ARROWTHREE-D TOP-LIGHTED LEFTWARD" +
	"S EQUILATERAL ARROWHEADTHREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHE" +
	"ADTHREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEADTHREE-D LEFT-LIGHT" +
	"ED DOWNWARDS EQUILATERAL ARROWHEADBLACK LEFTWARDS EQUILATERAL ARROWHEADB" +
	"LACK UPWARDS EQUILATERAL ARROWHEADBLACK RIGHTWARDS EQUILATERAL ARROWHEAD" +
	"BLACK DOWNWARDS EQUILATERAL ARROWHEADDOWNWARDS TRIANGLE-HEADED ARROW WIT" +
	"H LONG TIP LEFTWARDSDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTW" +
	"ARDSUPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDSUPWARDS TRIANGL" +
	"E-HEADED ARROW WITH LONG TIP RIGHTWARDSLEFTWARDS TRIANGLE-HEADED ARROW W" +
	"ITH LONG TIP UPWARDSRIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWAR" +
	"DSLEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDSRIGHTWARDS TRIA" +
	"NGLE-HEADED ARROW WITH LONG TIP DOWNWARDSBLACK CURVED DOWNWARDS AND LEFT" +
	"WARDS ARROWBLACK CURVED DOWNWARDS AND RIGHTWARDS ARROWBLACK CURVED UPWAR" +
	"DS AND LEFTWARDS ARROWBLACK CURVED UPWARDS AND RIGHTWARDS ARROWBLACK CUR" +
	"VED LEFTWARDS AND UPWARDS ARROWBLACK CURVED RIGHTWARDS AND UPWARDS ARROW" +
	"BLACK CURVED LEFTWARDS AND DOWNWARDS ARROWBLACK CURVED RIGHTWARDS AND DO" +
	"WNWARDS ARROWRIBBON ARROW DOWN LEFTRIBBON ARROW DOWN RIGHTRIBBON ARROW U" +
	"P LEFTRIBBON ARROW UP RIGHTRIBBON ARROW LEFT UPRIBBON ARROW RIGHT UPRIBB" +
	"ON ARROW LEFT DOWNRIBBON ARROW RIGHT DOWNUPWARDS WHITE ARROW FROM BAR WI" +
	"TH HORIZONTAL BARUP ARROWHEAD IN A RECTANGLE BOXOVERLAPPING WHITE SQUARE" +
	"SOVERLAPPING WHITE AND BLACK SQUARESOVERLAPPING BLACK SQUARESBALLOT BOX " +
	"WITH LIGHT XCIRCLED XCIRCLED BOLD XBLACK SQUARE CENTREDBLACK DIAMOND CEN" +
	"TREDTURNED BLACK PENTAGONHORIZONTAL BLACK OCTAGONBLACK OCTAGONBLACK MEDI" +
	"UM UP-POINTING TRIANGLE CENTREDBLACK MEDIUM DOWN-POINTING TRIANGLE CENTR" +
	"EDBLACK MEDIUM LEFT-POINTING TRIANGLE CENTREDBLACK MEDIUM RIGHT-POINTING" +
	" TRIANGLE CENTREDTOP HALF BLACK CIRCLEBOTTOM HALF BLACK CIRCLELIGHT FOUR" +
	" POINTED BLACK CUSPROTATED LIGHT FOUR POINTED BLACK CUSPWHITE FOUR POINT" +
	"ED CUSPROTATED WHITE FOUR POINTED CUSPSQUARE POSITION INDICATORUNCERTAIN" +
	"TY SIGNGROUP MARKPLUTO FORM TWOPLUTO FORM THREEPLUTO FORM FOURPLUTO FORM" +
	" FIVETRANSPLUTOPROSERPINAASTRAEAHYGIEAPHOLUSNESSUSWHITE MOON SELENABLACK" +
	" DIAMOND ON CROSSTRUE LIGHT MOON ARTACUPIDOHADESZEUSKRONOSAPOLLONADMETOS" +
	"VULCANUSPOSEIDONLEFT HALF BLACK STARRIGHT HALF BLACK STARSTAR WITH LEFT " +
	"HALF BLACKSTAR WITH RIGHT HALF BLACKLEFTWARDS TWO-HEADED ARROW WITH TRIA" +
	"NGLE ARROWHEADSUPWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSRIGHTWAR" +
	"DS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSDOWNWARDS TWO-HEADED ARROW W" +
	"ITH TRIANGLE ARROWHEADSERIS FORM ONEERIS FORM TWOSEDNARUSSIAN ASTROLOGIC" +
	"AL SYMBOL VIGINTILERUSSIAN ASTROLOGICAL SYMBOL NOVILERUSSIAN ASTROLOGICA" +
	"L SYMBOL QUINTILERUSSIAN ASTROLOGICAL SYMBOL BINOVILERUSSIAN ASTROLOGICA" +
	"L SYMBOL SENTAGONRUSSIAN ASTROLOGICAL SYMBOL TREDECILEEQUALS SIGN WITH I" +
	"NFINITY BELOWUNITED SYMBOLSEPARATED SYMBOLDOUBLED SYMBOLPASSED SYMBOLREV" +
	"ERSED RIGHT ANGLEGLAGOLITIC CAPITAL LETTER AZUGLAGOLITIC CAPITAL LETTER " +
	"BUKYGLAGOLITIC CAPITAL LETTER VEDEGLAGOLITIC CAPITAL LETTER GLAGOLIGLAGO" +
	"LITIC CAPITAL LETTER DOBROGLAGOLITIC CAPITAL LETTER YESTUGLAGOLITIC CAPI" +
	"TAL LETTER ZHIVETEGLAGOLITIC CAPITAL LETTER DZELOGLAGOLITIC CAPITAL LETT" +
	"ER ZEMLJAGLAGOLITIC CAPITAL LETTER IZHEGLAGOLITIC CAPITAL LETTER INITIAL" +
	" IZHEGLAGOLITIC CAPITAL LETTER IGLAGOLITIC CAPITAL LETTER DJERVIGLAGOLIT" +
	"IC CAPITAL LETTER KAKOGLAGOLITIC CAPITAL LETTER LJUDIJEGLAGOLITIC CAPITA" +
	"L LETTER MYSLITEGLAGOLITIC CAPITAL LETTER NASHIGLAGOLITIC CAPITAL LETTER" +
	" ONUGLAGOLITIC CAPITAL LETTER POKOJIGLAGOLITIC CAPITAL LETTER RITSIGLAGO" +
	"LITIC CAPITAL LETTER SLOVOGLAGOLITIC CAPITAL LETTER TVRIDOGLAGOLITIC CAP" +
	"ITAL LETTER UKUGLAGOLITIC CAPITAL LETTER FRITUGLAGOLITIC CAPITAL LETTER " +
	"HERUGLAGOLITIC CAPITAL LETTER OTUGLAGOLITIC CAPITAL LETTER PEGLAGOLITIC " +
	"CAPITAL LETTER SHTAGLAGOLITIC CAPITAL LETTER TSIGLAGOLITIC CAPITAL LETTE" +
	"R CHRIVIGLAGOLITIC CAPITAL LETTER SHAGLAGOLITIC CAPITAL LETTER YERUGLAGO" +
	"LITIC CAPITAL LETTER YERIGLAGOLITIC CAPITAL LETTER YATIGLAGOLITIC CAPITA" +
	"L LETTER SPIDERY HAGLAGOLITIC CAPITAL LETTER YUGLAGOLITIC CAPITAL LETTER" +
	" SMALL YUSGLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAILGLAGOLITIC CAPITA" +
	"L LETTER YOGLAGOLITIC CAPITAL LETTER IOTATED SMALL YUSGLAGOLITIC CAPITAL" +
	" LETTER BIG YUSGLAGOLITIC CAPITAL LETTER IOTATED BIG YUSGLAGOLITIC CAPIT") + ("" +
	"AL LETTER FITAGLAGOLITIC CAPITAL LETTER IZHITSAGLAGOLITIC CAPITAL LETTER" +
	" SHTAPICGLAGOLITIC CAPITAL LETTER TROKUTASTI AGLAGOLITIC CAPITAL LETTER " +
	"LATINATE MYSLITEGLAGOLITIC SMALL LETTER AZUGLAGOLITIC SMALL LETTER BUKYG" +
	"LAGOLITIC SMALL LETTER VEDEGLAGOLITIC SMALL LETTER GLAGOLIGLAGOLITIC SMA" +
	"LL LETTER DOBROGLAGOLITIC SMALL LETTER YESTUGLAGOLITIC SMALL LETTER ZHIV" +
	"ETEGLAGOLITIC SMALL LETTER DZELOGLAGOLITIC SMALL LETTER ZEMLJAGLAGOLITIC" +
	" SMALL LETTER IZHEGLAGOLITIC SMALL LETTER INITIAL IZHEGLAGOLITIC SMALL L" +
	"ETTER IGLAGOLITIC SMALL LETTER DJERVIGLAGOLITIC SMALL LETTER KAKOGLAGOLI" +
	"TIC SMALL LETTER LJUDIJEGLAGOLITIC SMALL LETTER MYSLITEGLAGOLITIC SMALL " +
	"LETTER NASHIGLAGOLITIC SMALL LETTER ONUGLAGOLITIC SMALL LETTER POKOJIGLA" +
	"GOLITIC SMALL LETTER RITSIGLAGOLITIC SMALL LETTER SLOVOGLAGOLITIC SMALL " +
	"LETTER TVRIDOGLAGOLITIC SMALL LETTER UKUGLAGOLITIC SMALL LETTER FRITUGLA" +
	"GOLITIC SMALL LETTER HERUGLAGOLITIC SMALL LETTER OTUGLAGOLITIC SMALL LET" +
	"TER PEGLAGOLITIC SMALL LETTER SHTAGLAGOLITIC SMALL LETTER TSIGLAGOLITIC " +
	"SMALL LETTER CHRIVIGLAGOLITIC SMALL LETTER SHAGLAGOLITIC SMALL LETTER YE" +
	"RUGLAGOLITIC SMALL LETTER YERIGLAGOLITIC SMALL LETTER YATIGLAGOLITIC SMA" +
	"LL LETTER SPIDERY HAGLAGOLITIC SMALL LETTER YUGLAGOLITIC SMALL LETTER SM" +
	"ALL YUSGLAGOLITIC SMALL LETTER SMALL YUS WITH TAILGLAGOLITIC SMALL LETTE" +
	"R YOGLAGOLITIC SMALL LETTER IOTATED SMALL YUSGLAGOLITIC SMALL LETTER BIG" +
	" YUSGLAGOLITIC SMALL LETTER IOTATED BIG YUSGLAGOLITIC SMALL LETTER FITAG" +
	"LAGOLITIC SMALL LETTER IZHITSAGLAGOLITIC SMALL LETTER SHTAPICGLAGOLITIC " +
	"SMALL LETTER TROKUTASTI AGLAGOLITIC SMALL LETTER LATINATE MYSLITELATIN C" +
	"APITAL LETTER L WITH DOUBLE BARLATIN SMALL LETTER L WITH DOUBLE BARLATIN" +
	" CAPITAL LETTER L WITH MIDDLE TILDELATIN CAPITAL LETTER P WITH STROKELAT" +
	"IN CAPITAL LETTER R WITH TAILLATIN SMALL LETTER A WITH STROKELATIN SMALL" +
	" LETTER T WITH DIAGONAL STROKELATIN CAPITAL LETTER H WITH DESCENDERLATIN" +
	" SMALL LETTER H WITH DESCENDERLATIN CAPITAL LETTER K WITH DESCENDERLATIN" +
	" SMALL LETTER K WITH DESCENDERLATIN CAPITAL LETTER Z WITH DESCENDERLATIN" +
	" SMALL LETTER Z WITH DESCENDERLATIN CAPITAL LETTER ALPHALATIN CAPITAL LE" +
	"TTER M WITH HOOKLATIN CAPITAL LETTER TURNED ALATIN CAPITAL LETTER TURNED" +
	" ALPHALATIN SMALL LETTER V WITH RIGHT HOOKLATIN CAPITAL LETTER W WITH HO" +
	"OKLATIN SMALL LETTER W WITH HOOKLATIN SMALL LETTER V WITH CURLLATIN CAPI" +
	"TAL LETTER HALF HLATIN SMALL LETTER HALF HLATIN SMALL LETTER TAILLESS PH" +
	"ILATIN SMALL LETTER E WITH NOTCHLATIN SMALL LETTER TURNED R WITH TAILLAT" +
	"IN SMALL LETTER O WITH LOW RING INSIDELATIN LETTER SMALL CAPITAL TURNED " +
	"ELATIN SUBSCRIPT SMALL LETTER JMODIFIER LETTER CAPITAL VLATIN CAPITAL LE" +
	"TTER S WITH SWASH TAILLATIN CAPITAL LETTER Z WITH SWASH TAILCOPTIC CAPIT" +
	"AL LETTER ALFACOPTIC SMALL LETTER ALFACOPTIC CAPITAL LETTER VIDACOPTIC S" +
	"MALL LETTER VIDACOPTIC CAPITAL LETTER GAMMACOPTIC SMALL LETTER GAMMACOPT" +
	"IC CAPITAL LETTER DALDACOPTIC SMALL LETTER DALDACOPTIC CAPITAL LETTER EI" +
	"ECOPTIC SMALL LETTER EIECOPTIC CAPITAL LETTER SOUCOPTIC SMALL LETTER SOU" +
	"COPTIC CAPITAL LETTER ZATACOPTIC SMALL LETTER ZATACOPTIC CAPITAL LETTER " +
	"HATECOPTIC SMALL LETTER HATECOPTIC CAPITAL LETTER THETHECOPTIC SMALL LET" +
	"TER THETHECOPTIC CAPITAL LETTER IAUDACOPTIC SMALL LETTER IAUDACOPTIC CAP" +
	"ITAL LETTER KAPACOPTIC SMALL LETTER KAPACOPTIC CAPITAL LETTER LAULACOPTI" +
	"C SMALL LETTER LAULACOPTIC CAPITAL LETTER MICOPTIC SMALL LETTER MICOPTIC" +
	" CAPITAL LETTER NICOPTIC SMALL LETTER NICOPTIC CAPITAL LETTER KSICOPTIC " +
	"SMALL LETTER KSICOPTIC CAPITAL LETTER OCOPTIC SMALL LETTER OCOPTIC CAPIT" +
	"AL LETTER PICOPTIC SMALL LETTER PICOPTIC CAPITAL LETTER ROCOPTIC SMALL L" +
	"ETTER ROCOPTIC CAPITAL LETTER SIMACOPTIC SMALL LETTER SIMACOPTIC CAPITAL" +
	" LETTER TAUCOPTIC SMALL LETTER TAUCOPTIC CAPITAL LETTER UACOPTIC SMALL L" +
	"ETTER UACOPTIC CAPITAL LETTER FICOPTIC SMALL LETTER FICOPTIC CAPITAL LET" +
	"TER KHICOPTIC SMALL LETTER KHICOPTIC CAPITAL LETTER PSICOPTIC SMALL LETT" +
	"ER PSICOPTIC CAPITAL LETTER OOUCOPTIC SMALL LETTER OOUCOPTIC CAPITAL LET" +
	"TER DIALECT-P ALEFCOPTIC SMALL LETTER DIALECT-P ALEFCOPTIC CAPITAL LETTE" +
	"R OLD COPTIC AINCOPTIC SMALL LETTER OLD COPTIC AINCOPTIC CAPITAL LETTER " +
	"CRYPTOGRAMMIC EIECOPTIC SMALL LETTER CRYPTOGRAMMIC EIECOPTIC CAPITAL LET" +
	"TER DIALECT-P KAPACOPTIC SMALL LETTER DIALECT-P KAPACOPTIC CAPITAL LETTE" +
	"R DIALECT-P NICOPTIC SMALL LETTER DIALECT-P NICOPTIC CAPITAL LETTER CRYP" +
	"TOGRAMMIC NICOPTIC SMALL LETTER CRYPTOGRAMMIC NICOPTIC CAPITAL LETTER OL" +
	"D COPTIC OOUCOPTIC SMALL LETTER OLD COPTIC OOUCOPTIC CAPITAL LETTER SAMP" +
	"ICOPTIC SMALL LETTER SAMPICOPTIC CAPITAL LETTER CROSSED SHEICOPTIC SMALL" +
	" LETTER CROSSED SHEICOPTIC CAPITAL LETTER OLD COPTIC SHEICOPTIC SMALL LE" +
	"TTER OLD COPTIC SHEICOPTIC CAPITAL LETTER OLD COPTIC ESHCOPTIC SMALL LET") + ("" +
	"TER OLD COPTIC ESHCOPTIC CAPITAL LETTER AKHMIMIC KHEICOPTIC SMALL LETTER" +
	" AKHMIMIC KHEICOPTIC CAPITAL LETTER DIALECT-P HORICOPTIC SMALL LETTER DI" +
	"ALECT-P HORICOPTIC CAPITAL LETTER OLD COPTIC HORICOPTIC SMALL LETTER OLD" +
	" COPTIC HORICOPTIC CAPITAL LETTER OLD COPTIC HACOPTIC SMALL LETTER OLD C" +
	"OPTIC HACOPTIC CAPITAL LETTER L-SHAPED HACOPTIC SMALL LETTER L-SHAPED HA" +
	"COPTIC CAPITAL LETTER OLD COPTIC HEICOPTIC SMALL LETTER OLD COPTIC HEICO" +
	"PTIC CAPITAL LETTER OLD COPTIC HATCOPTIC SMALL LETTER OLD COPTIC HATCOPT" +
	"IC CAPITAL LETTER OLD COPTIC GANGIACOPTIC SMALL LETTER OLD COPTIC GANGIA" +
	"COPTIC CAPITAL LETTER OLD COPTIC DJACOPTIC SMALL LETTER OLD COPTIC DJACO" +
	"PTIC CAPITAL LETTER OLD COPTIC SHIMACOPTIC SMALL LETTER OLD COPTIC SHIMA" +
	"COPTIC CAPITAL LETTER OLD NUBIAN SHIMACOPTIC SMALL LETTER OLD NUBIAN SHI" +
	"MACOPTIC CAPITAL LETTER OLD NUBIAN NGICOPTIC SMALL LETTER OLD NUBIAN NGI" +
	"COPTIC CAPITAL LETTER OLD NUBIAN NYICOPTIC SMALL LETTER OLD NUBIAN NYICO" +
	"PTIC CAPITAL LETTER OLD NUBIAN WAUCOPTIC SMALL LETTER OLD NUBIAN WAUCOPT" +
	"IC SYMBOL KAICOPTIC SYMBOL MI ROCOPTIC SYMBOL PI ROCOPTIC SYMBOL STAUROS" +
	"COPTIC SYMBOL TAU ROCOPTIC SYMBOL KHI ROCOPTIC SYMBOL SHIMA SIMACOPTIC C" +
	"APITAL LETTER CRYPTOGRAMMIC SHEICOPTIC SMALL LETTER CRYPTOGRAMMIC SHEICO" +
	"PTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIACOPTIC SMALL LETTER CRYPTOGRAMMI" +
	"C GANGIACOPTIC COMBINING NI ABOVECOPTIC COMBINING SPIRITUS ASPERCOPTIC C" +
	"OMBINING SPIRITUS LENISCOPTIC CAPITAL LETTER BOHAIRIC KHEICOPTIC SMALL L" +
	"ETTER BOHAIRIC KHEICOPTIC OLD NUBIAN FULL STOPCOPTIC OLD NUBIAN DIRECT Q" +
	"UESTION MARKCOPTIC OLD NUBIAN INDIRECT QUESTION MARKCOPTIC OLD NUBIAN VE" +
	"RSE DIVIDERCOPTIC FRACTION ONE HALFCOPTIC FULL STOPCOPTIC MORPHOLOGICAL " +
	"DIVIDERGEORGIAN SMALL LETTER ANGEORGIAN SMALL LETTER BANGEORGIAN SMALL L" +
	"ETTER GANGEORGIAN SMALL LETTER DONGEORGIAN SMALL LETTER ENGEORGIAN SMALL" +
	" LETTER VINGEORGIAN SMALL LETTER ZENGEORGIAN SMALL LETTER TANGEORGIAN SM" +
	"ALL LETTER INGEORGIAN SMALL LETTER KANGEORGIAN SMALL LETTER LASGEORGIAN " +
	"SMALL LETTER MANGEORGIAN SMALL LETTER NARGEORGIAN SMALL LETTER ONGEORGIA" +
	"N SMALL LETTER PARGEORGIAN SMALL LETTER ZHARGEORGIAN SMALL LETTER RAEGEO" +
	"RGIAN SMALL LETTER SANGEORGIAN SMALL LETTER TARGEORGIAN SMALL LETTER UNG" +
	"EORGIAN SMALL LETTER PHARGEORGIAN SMALL LETTER KHARGEORGIAN SMALL LETTER" +
	" GHANGEORGIAN SMALL LETTER QARGEORGIAN SMALL LETTER SHINGEORGIAN SMALL L" +
	"ETTER CHINGEORGIAN SMALL LETTER CANGEORGIAN SMALL LETTER JILGEORGIAN SMA" +
	"LL LETTER CILGEORGIAN SMALL LETTER CHARGEORGIAN SMALL LETTER XANGEORGIAN" +
	" SMALL LETTER JHANGEORGIAN SMALL LETTER HAEGEORGIAN SMALL LETTER HEGEORG" +
	"IAN SMALL LETTER HIEGEORGIAN SMALL LETTER WEGEORGIAN SMALL LETTER HARGEO" +
	"RGIAN SMALL LETTER HOEGEORGIAN SMALL LETTER YNGEORGIAN SMALL LETTER AENT" +
	"IFINAGH LETTER YATIFINAGH LETTER YABTIFINAGH LETTER YABHTIFINAGH LETTER " +
	"YAGTIFINAGH LETTER YAGHHTIFINAGH LETTER BERBER ACADEMY YAJTIFINAGH LETTE" +
	"R YAJTIFINAGH LETTER YADTIFINAGH LETTER YADHTIFINAGH LETTER YADDTIFINAGH" +
	" LETTER YADDHTIFINAGH LETTER YEYTIFINAGH LETTER YAFTIFINAGH LETTER YAKTI" +
	"FINAGH LETTER TUAREG YAKTIFINAGH LETTER YAKHHTIFINAGH LETTER YAHTIFINAGH" +
	" LETTER BERBER ACADEMY YAHTIFINAGH LETTER TUAREG YAHTIFINAGH LETTER YAHH" +
	"TIFINAGH LETTER YAATIFINAGH LETTER YAKHTIFINAGH LETTER TUAREG YAKHTIFINA" +
	"GH LETTER YAQTIFINAGH LETTER TUAREG YAQTIFINAGH LETTER YITIFINAGH LETTER" +
	" YAZHTIFINAGH LETTER AHAGGAR YAZHTIFINAGH LETTER TUAREG YAZHTIFINAGH LET" +
	"TER YALTIFINAGH LETTER YAMTIFINAGH LETTER YANTIFINAGH LETTER TUAREG YAGN" +
	"TIFINAGH LETTER TUAREG YANGTIFINAGH LETTER YAPTIFINAGH LETTER YUTIFINAGH" +
	" LETTER YARTIFINAGH LETTER YARRTIFINAGH LETTER YAGHTIFINAGH LETTER TUARE" +
	"G YAGHTIFINAGH LETTER AYER YAGHTIFINAGH LETTER YASTIFINAGH LETTER YASSTI" +
	"FINAGH LETTER YASHTIFINAGH LETTER YATTIFINAGH LETTER YATHTIFINAGH LETTER" +
	" YACHTIFINAGH LETTER YATTTIFINAGH LETTER YAVTIFINAGH LETTER YAWTIFINAGH " +
	"LETTER YAYTIFINAGH LETTER YAZTIFINAGH LETTER TAWELLEMET YAZTIFINAGH LETT" +
	"ER YAZZTIFINAGH LETTER YETIFINAGH LETTER YOTIFINAGH MODIFIER LETTER LABI" +
	"ALIZATION MARKTIFINAGH SEPARATOR MARKTIFINAGH CONSONANT JOINERETHIOPIC S" +
	"YLLABLE LOAETHIOPIC SYLLABLE MOAETHIOPIC SYLLABLE ROAETHIOPIC SYLLABLE S" +
	"OAETHIOPIC SYLLABLE SHOAETHIOPIC SYLLABLE BOAETHIOPIC SYLLABLE TOAETHIOP" +
	"IC SYLLABLE COAETHIOPIC SYLLABLE NOAETHIOPIC SYLLABLE NYOAETHIOPIC SYLLA" +
	"BLE GLOTTAL OAETHIOPIC SYLLABLE ZOAETHIOPIC SYLLABLE DOAETHIOPIC SYLLABL" +
	"E DDOAETHIOPIC SYLLABLE JOAETHIOPIC SYLLABLE THOAETHIOPIC SYLLABLE CHOAE" +
	"THIOPIC SYLLABLE PHOAETHIOPIC SYLLABLE POAETHIOPIC SYLLABLE GGWAETHIOPIC" +
	" SYLLABLE GGWIETHIOPIC SYLLABLE GGWEEETHIOPIC SYLLABLE GGWEETHIOPIC SYLL" +
	"ABLE SSAETHIOPIC SYLLABLE SSUETHIOPIC SYLLABLE SSIETHIOPIC SYLLABLE SSAA" +
	"ETHIOPIC SYLLABLE SSEEETHIOPIC SYLLABLE SSEETHIOPIC SYLLABLE SSOETHIOPIC") + ("" +
	" SYLLABLE CCAETHIOPIC SYLLABLE CCUETHIOPIC SYLLABLE CCIETHIOPIC SYLLABLE" +
	" CCAAETHIOPIC SYLLABLE CCEEETHIOPIC SYLLABLE CCEETHIOPIC SYLLABLE CCOETH" +
	"IOPIC SYLLABLE ZZAETHIOPIC SYLLABLE ZZUETHIOPIC SYLLABLE ZZIETHIOPIC SYL" +
	"LABLE ZZAAETHIOPIC SYLLABLE ZZEEETHIOPIC SYLLABLE ZZEETHIOPIC SYLLABLE Z" +
	"ZOETHIOPIC SYLLABLE CCHAETHIOPIC SYLLABLE CCHUETHIOPIC SYLLABLE CCHIETHI" +
	"OPIC SYLLABLE CCHAAETHIOPIC SYLLABLE CCHEEETHIOPIC SYLLABLE CCHEETHIOPIC" +
	" SYLLABLE CCHOETHIOPIC SYLLABLE QYAETHIOPIC SYLLABLE QYUETHIOPIC SYLLABL" +
	"E QYIETHIOPIC SYLLABLE QYAAETHIOPIC SYLLABLE QYEEETHIOPIC SYLLABLE QYEET" +
	"HIOPIC SYLLABLE QYOETHIOPIC SYLLABLE KYAETHIOPIC SYLLABLE KYUETHIOPIC SY" +
	"LLABLE KYIETHIOPIC SYLLABLE KYAAETHIOPIC SYLLABLE KYEEETHIOPIC SYLLABLE " +
	"KYEETHIOPIC SYLLABLE KYOETHIOPIC SYLLABLE XYAETHIOPIC SYLLABLE XYUETHIOP" +
	"IC SYLLABLE XYIETHIOPIC SYLLABLE XYAAETHIOPIC SYLLABLE XYEEETHIOPIC SYLL" +
	"ABLE XYEETHIOPIC SYLLABLE XYOETHIOPIC SYLLABLE GYAETHIOPIC SYLLABLE GYUE" +
	"THIOPIC SYLLABLE GYIETHIOPIC SYLLABLE GYAAETHIOPIC SYLLABLE GYEEETHIOPIC" +
	" SYLLABLE GYEETHIOPIC SYLLABLE GYOCOMBINING CYRILLIC LETTER BECOMBINING " +
	"CYRILLIC LETTER VECOMBINING CYRILLIC LETTER GHECOMBINING CYRILLIC LETTER" +
	" DECOMBINING CYRILLIC LETTER ZHECOMBINING CYRILLIC LETTER ZECOMBINING CY" +
	"RILLIC LETTER KACOMBINING CYRILLIC LETTER ELCOMBINING CYRILLIC LETTER EM" +
	"COMBINING CYRILLIC LETTER ENCOMBINING CYRILLIC LETTER OCOMBINING CYRILLI" +
	"C LETTER PECOMBINING CYRILLIC LETTER ERCOMBINING CYRILLIC LETTER ESCOMBI" +
	"NING CYRILLIC LETTER TECOMBINING CYRILLIC LETTER HACOMBINING CYRILLIC LE" +
	"TTER TSECOMBINING CYRILLIC LETTER CHECOMBINING CYRILLIC LETTER SHACOMBIN" +
	"ING CYRILLIC LETTER SHCHACOMBINING CYRILLIC LETTER FITACOMBINING CYRILLI" +
	"C LETTER ES-TECOMBINING CYRILLIC LETTER ACOMBINING CYRILLIC LETTER IECOM" +
	"BINING CYRILLIC LETTER DJERVCOMBINING CYRILLIC LETTER MONOGRAPH UKCOMBIN" +
	"ING CYRILLIC LETTER YATCOMBINING CYRILLIC LETTER YUCOMBINING CYRILLIC LE" +
	"TTER IOTIFIED ACOMBINING CYRILLIC LETTER LITTLE YUSCOMBINING CYRILLIC LE" +
	"TTER BIG YUSCOMBINING CYRILLIC LETTER IOTIFIED BIG YUSRIGHT ANGLE SUBSTI" +
	"TUTION MARKERRIGHT ANGLE DOTTED SUBSTITUTION MARKERLEFT SUBSTITUTION BRA" +
	"CKETRIGHT SUBSTITUTION BRACKETLEFT DOTTED SUBSTITUTION BRACKETRIGHT DOTT" +
	"ED SUBSTITUTION BRACKETRAISED INTERPOLATION MARKERRAISED DOTTED INTERPOL" +
	"ATION MARKERDOTTED TRANSPOSITION MARKERLEFT TRANSPOSITION BRACKETRIGHT T" +
	"RANSPOSITION BRACKETRAISED SQUARELEFT RAISED OMISSION BRACKETRIGHT RAISE" +
	"D OMISSION BRACKETEDITORIAL CORONISPARAGRAPHOSFORKED PARAGRAPHOSREVERSED" +
	" FORKED PARAGRAPHOSHYPODIASTOLEDOTTED OBELOSDOWNWARDS ANCORAUPWARDS ANCO" +
	"RADOTTED RIGHT-POINTING ANGLEDOUBLE OBLIQUE HYPHENINVERTED INTERROBANGPA" +
	"LM BRANCHHYPHEN WITH DIAERESISTILDE WITH RING ABOVELEFT LOW PARAPHRASE B" +
	"RACKETRIGHT LOW PARAPHRASE BRACKETTILDE WITH DOT ABOVETILDE WITH DOT BEL" +
	"OWLEFT VERTICAL BAR WITH QUILLRIGHT VERTICAL BAR WITH QUILLTOP LEFT HALF" +
	" BRACKETTOP RIGHT HALF BRACKETBOTTOM LEFT HALF BRACKETBOTTOM RIGHT HALF " +
	"BRACKETLEFT SIDEWAYS U BRACKETRIGHT SIDEWAYS U BRACKETLEFT DOUBLE PARENT" +
	"HESISRIGHT DOUBLE PARENTHESISTWO DOTS OVER ONE DOT PUNCTUATIONONE DOT OV" +
	"ER TWO DOTS PUNCTUATIONSQUARED FOUR DOT PUNCTUATIONFIVE DOT MARKREVERSED" +
	" QUESTION MARKVERTICAL TILDERING POINTWORD SEPARATOR MIDDLE DOTTURNED CO" +
	"MMARAISED DOTRAISED COMMATURNED SEMICOLONDAGGER WITH LEFT GUARDDAGGER WI" +
	"TH RIGHT GUARDTURNED DAGGERTOP HALF SECTION SIGNTWO-EM DASHTHREE-EM DASH" +
	"STENOGRAPHIC FULL STOPVERTICAL SIX DOTSWIGGLY VERTICAL LINECAPITULUMDOUB" +
	"LE HYPHENREVERSED COMMADOUBLE LOW-REVERSED-9 QUOTATION MARKDASH WITH LEF" +
	"T UPTURNDOUBLE SUSPENSION MARKINVERTED LOW KAVYKAINVERTED LOW KAVYKA WIT" +
	"H KAVYKA ABOVELOW KAVYKALOW KAVYKA WITH DOTDOUBLE STACKED COMMADOTTED SO" +
	"LIDUSTRIPLE DAGGERMEDIEVAL COMMAPARAGRAPHUS MARKPUNCTUS ELEVATUS MARKCJK" +
	" RADICAL REPEATCJK RADICAL CLIFFCJK RADICAL SECOND ONECJK RADICAL SECOND" +
	" TWOCJK RADICAL SECOND THREECJK RADICAL PERSONCJK RADICAL BOXCJK RADICAL" +
	" TABLECJK RADICAL KNIFE ONECJK RADICAL KNIFE TWOCJK RADICAL DIVINATIONCJ" +
	"K RADICAL SEALCJK RADICAL SMALL ONECJK RADICAL SMALL TWOCJK RADICAL LAME" +
	" ONECJK RADICAL LAME TWOCJK RADICAL LAME THREECJK RADICAL LAME FOURCJK R" +
	"ADICAL SNAKECJK RADICAL THREADCJK RADICAL SNOUT ONECJK RADICAL SNOUT TWO" +
	"CJK RADICAL HEART ONECJK RADICAL HEART TWOCJK RADICAL HANDCJK RADICAL RA" +
	"PCJK RADICAL CHOKECJK RADICAL SUNCJK RADICAL MOONCJK RADICAL DEATHCJK RA" +
	"DICAL MOTHERCJK RADICAL CIVILIANCJK RADICAL WATER ONECJK RADICAL WATER T" +
	"WOCJK RADICAL FIRECJK RADICAL PAW ONECJK RADICAL PAW TWOCJK RADICAL SIMP" +
	"LIFIED HALF TREE TRUNKCJK RADICAL COWCJK RADICAL DOGCJK RADICAL JADECJK " +
	"RADICAL BOLT OF CLOTHCJK RADICAL EYECJK RADICAL SPIRIT ONECJK RADICAL SP" +
	"IRIT TWOCJK RADICAL BAMBOOCJK RADICAL SILKCJK RADICAL C-SIMPLIFIED SILKC") + ("" +
	"JK RADICAL NET ONECJK RADICAL NET TWOCJK RADICAL NET THREECJK RADICAL NE" +
	"T FOURCJK RADICAL MESHCJK RADICAL SHEEPCJK RADICAL RAMCJK RADICAL EWECJK" +
	" RADICAL OLDCJK RADICAL BRUSH ONECJK RADICAL BRUSH TWOCJK RADICAL MEATCJ" +
	"K RADICAL MORTARCJK RADICAL GRASS ONECJK RADICAL GRASS TWOCJK RADICAL GR" +
	"ASS THREECJK RADICAL TIGERCJK RADICAL CLOTHESCJK RADICAL WEST ONECJK RAD" +
	"ICAL WEST TWOCJK RADICAL C-SIMPLIFIED SEECJK RADICAL SIMPLIFIED HORNCJK " +
	"RADICAL HORNCJK RADICAL C-SIMPLIFIED SPEECHCJK RADICAL C-SIMPLIFIED SHEL" +
	"LCJK RADICAL FOOTCJK RADICAL C-SIMPLIFIED CARTCJK RADICAL SIMPLIFIED WAL" +
	"KCJK RADICAL WALK ONECJK RADICAL WALK TWOCJK RADICAL CITYCJK RADICAL C-S" +
	"IMPLIFIED GOLDCJK RADICAL LONG ONECJK RADICAL LONG TWOCJK RADICAL C-SIMP" +
	"LIFIED LONGCJK RADICAL C-SIMPLIFIED GATECJK RADICAL MOUND ONECJK RADICAL" +
	" MOUND TWOCJK RADICAL RAINCJK RADICAL BLUECJK RADICAL C-SIMPLIFIED TANNE" +
	"D LEATHERCJK RADICAL C-SIMPLIFIED LEAFCJK RADICAL C-SIMPLIFIED WINDCJK R" +
	"ADICAL C-SIMPLIFIED FLYCJK RADICAL EAT ONECJK RADICAL EAT TWOCJK RADICAL" +
	" EAT THREECJK RADICAL C-SIMPLIFIED EATCJK RADICAL HEADCJK RADICAL C-SIMP" +
	"LIFIED HORSECJK RADICAL BONECJK RADICAL GHOSTCJK RADICAL C-SIMPLIFIED FI" +
	"SHCJK RADICAL C-SIMPLIFIED BIRDCJK RADICAL C-SIMPLIFIED SALTCJK RADICAL " +
	"SIMPLIFIED WHEATCJK RADICAL SIMPLIFIED YELLOWCJK RADICAL C-SIMPLIFIED FR" +
	"OGCJK RADICAL J-SIMPLIFIED EVENCJK RADICAL C-SIMPLIFIED EVENCJK RADICAL " +
	"J-SIMPLIFIED TOOTHCJK RADICAL C-SIMPLIFIED TOOTHCJK RADICAL J-SIMPLIFIED" +
	" DRAGONCJK RADICAL C-SIMPLIFIED DRAGONCJK RADICAL TURTLECJK RADICAL J-SI" +
	"MPLIFIED TURTLECJK RADICAL C-SIMPLIFIED TURTLEKANGXI RADICAL ONEKANGXI R" +
	"ADICAL LINEKANGXI RADICAL DOTKANGXI RADICAL SLASHKANGXI RADICAL SECONDKA" +
	"NGXI RADICAL HOOKKANGXI RADICAL TWOKANGXI RADICAL LIDKANGXI RADICAL MANK" +
	"ANGXI RADICAL LEGSKANGXI RADICAL ENTERKANGXI RADICAL EIGHTKANGXI RADICAL" +
	" DOWN BOXKANGXI RADICAL COVERKANGXI RADICAL ICEKANGXI RADICAL TABLEKANGX" +
	"I RADICAL OPEN BOXKANGXI RADICAL KNIFEKANGXI RADICAL POWERKANGXI RADICAL" +
	" WRAPKANGXI RADICAL SPOONKANGXI RADICAL RIGHT OPEN BOXKANGXI RADICAL HID" +
	"ING ENCLOSUREKANGXI RADICAL TENKANGXI RADICAL DIVINATIONKANGXI RADICAL S" +
	"EALKANGXI RADICAL CLIFFKANGXI RADICAL PRIVATEKANGXI RADICAL AGAINKANGXI " +
	"RADICAL MOUTHKANGXI RADICAL ENCLOSUREKANGXI RADICAL EARTHKANGXI RADICAL " +
	"SCHOLARKANGXI RADICAL GOKANGXI RADICAL GO SLOWLYKANGXI RADICAL EVENINGKA" +
	"NGXI RADICAL BIGKANGXI RADICAL WOMANKANGXI RADICAL CHILDKANGXI RADICAL R" +
	"OOFKANGXI RADICAL INCHKANGXI RADICAL SMALLKANGXI RADICAL LAMEKANGXI RADI" +
	"CAL CORPSEKANGXI RADICAL SPROUTKANGXI RADICAL MOUNTAINKANGXI RADICAL RIV" +
	"ERKANGXI RADICAL WORKKANGXI RADICAL ONESELFKANGXI RADICAL TURBANKANGXI R" +
	"ADICAL DRYKANGXI RADICAL SHORT THREADKANGXI RADICAL DOTTED CLIFFKANGXI R" +
	"ADICAL LONG STRIDEKANGXI RADICAL TWO HANDSKANGXI RADICAL SHOOTKANGXI RAD" +
	"ICAL BOWKANGXI RADICAL SNOUTKANGXI RADICAL BRISTLEKANGXI RADICAL STEPKAN" +
	"GXI RADICAL HEARTKANGXI RADICAL HALBERDKANGXI RADICAL DOORKANGXI RADICAL" +
	" HANDKANGXI RADICAL BRANCHKANGXI RADICAL RAPKANGXI RADICAL SCRIPTKANGXI " +
	"RADICAL DIPPERKANGXI RADICAL AXEKANGXI RADICAL SQUAREKANGXI RADICAL NOTK" +
	"ANGXI RADICAL SUNKANGXI RADICAL SAYKANGXI RADICAL MOONKANGXI RADICAL TRE" +
	"EKANGXI RADICAL LACKKANGXI RADICAL STOPKANGXI RADICAL DEATHKANGXI RADICA" +
	"L WEAPONKANGXI RADICAL DO NOTKANGXI RADICAL COMPAREKANGXI RADICAL FURKAN" +
	"GXI RADICAL CLANKANGXI RADICAL STEAMKANGXI RADICAL WATERKANGXI RADICAL F" +
	"IREKANGXI RADICAL CLAWKANGXI RADICAL FATHERKANGXI RADICAL DOUBLE XKANGXI" +
	" RADICAL HALF TREE TRUNKKANGXI RADICAL SLICEKANGXI RADICAL FANGKANGXI RA" +
	"DICAL COWKANGXI RADICAL DOGKANGXI RADICAL PROFOUNDKANGXI RADICAL JADEKAN" +
	"GXI RADICAL MELONKANGXI RADICAL TILEKANGXI RADICAL SWEETKANGXI RADICAL L" +
	"IFEKANGXI RADICAL USEKANGXI RADICAL FIELDKANGXI RADICAL BOLT OF CLOTHKAN" +
	"GXI RADICAL SICKNESSKANGXI RADICAL DOTTED TENTKANGXI RADICAL WHITEKANGXI" +
	" RADICAL SKINKANGXI RADICAL DISHKANGXI RADICAL EYEKANGXI RADICAL SPEARKA" +
	"NGXI RADICAL ARROWKANGXI RADICAL STONEKANGXI RADICAL SPIRITKANGXI RADICA" +
	"L TRACKKANGXI RADICAL GRAINKANGXI RADICAL CAVEKANGXI RADICAL STANDKANGXI" +
	" RADICAL BAMBOOKANGXI RADICAL RICEKANGXI RADICAL SILKKANGXI RADICAL JARK" +
	"ANGXI RADICAL NETKANGXI RADICAL SHEEPKANGXI RADICAL FEATHERKANGXI RADICA" +
	"L OLDKANGXI RADICAL ANDKANGXI RADICAL PLOWKANGXI RADICAL EARKANGXI RADIC" +
	"AL BRUSHKANGXI RADICAL MEATKANGXI RADICAL MINISTERKANGXI RADICAL SELFKAN" +
	"GXI RADICAL ARRIVEKANGXI RADICAL MORTARKANGXI RADICAL TONGUEKANGXI RADIC" +
	"AL OPPOSEKANGXI RADICAL BOATKANGXI RADICAL STOPPINGKANGXI RADICAL COLORK" +
	"ANGXI RADICAL GRASSKANGXI RADICAL TIGERKANGXI RADICAL INSECTKANGXI RADIC" +
	"AL BLOODKANGXI RADICAL WALK ENCLOSUREKANGXI RADICAL CLOTHESKANGXI RADICA" +
	"L WESTKANGXI RADICAL SEEKANGXI RADICAL HORNKANGXI RADICAL SPEECHKANGXI R") + ("" +
	"ADICAL VALLEYKANGXI RADICAL BEANKANGXI RADICAL PIGKANGXI RADICAL BADGERK" +
	"ANGXI RADICAL SHELLKANGXI RADICAL REDKANGXI RADICAL RUNKANGXI RADICAL FO" +
	"OTKANGXI RADICAL BODYKANGXI RADICAL CARTKANGXI RADICAL BITTERKANGXI RADI" +
	"CAL MORNINGKANGXI RADICAL WALKKANGXI RADICAL CITYKANGXI RADICAL WINEKANG" +
	"XI RADICAL DISTINGUISHKANGXI RADICAL VILLAGEKANGXI RADICAL GOLDKANGXI RA" +
	"DICAL LONGKANGXI RADICAL GATEKANGXI RADICAL MOUNDKANGXI RADICAL SLAVEKAN" +
	"GXI RADICAL SHORT TAILED BIRDKANGXI RADICAL RAINKANGXI RADICAL BLUEKANGX" +
	"I RADICAL WRONGKANGXI RADICAL FACEKANGXI RADICAL LEATHERKANGXI RADICAL T" +
	"ANNED LEATHERKANGXI RADICAL LEEKKANGXI RADICAL SOUNDKANGXI RADICAL LEAFK" +
	"ANGXI RADICAL WINDKANGXI RADICAL FLYKANGXI RADICAL EATKANGXI RADICAL HEA" +
	"DKANGXI RADICAL FRAGRANTKANGXI RADICAL HORSEKANGXI RADICAL BONEKANGXI RA" +
	"DICAL TALLKANGXI RADICAL HAIRKANGXI RADICAL FIGHTKANGXI RADICAL SACRIFIC" +
	"IAL WINEKANGXI RADICAL CAULDRONKANGXI RADICAL GHOSTKANGXI RADICAL FISHKA" +
	"NGXI RADICAL BIRDKANGXI RADICAL SALTKANGXI RADICAL DEERKANGXI RADICAL WH" +
	"EATKANGXI RADICAL HEMPKANGXI RADICAL YELLOWKANGXI RADICAL MILLETKANGXI R" +
	"ADICAL BLACKKANGXI RADICAL EMBROIDERYKANGXI RADICAL FROGKANGXI RADICAL T" +
	"RIPODKANGXI RADICAL DRUMKANGXI RADICAL RATKANGXI RADICAL NOSEKANGXI RADI" +
	"CAL EVENKANGXI RADICAL TOOTHKANGXI RADICAL DRAGONKANGXI RADICAL TURTLEKA" +
	"NGXI RADICAL FLUTEIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHTIDEOGRA" +
	"PHIC DESCRIPTION CHARACTER ABOVE TO BELOWIDEOGRAPHIC DESCRIPTION CHARACT" +
	"ER LEFT TO MIDDLE AND RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MI" +
	"DDLE AND BELOWIDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUNDIDEOGRAPHIC" +
	" DESCRIPTION CHARACTER SURROUND FROM ABOVEIDEOGRAPHIC DESCRIPTION CHARAC" +
	"TER SURROUND FROM BELOWIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM L" +
	"EFTIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFTIDEOGRAPHIC" +
	" DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHTIDEOGRAPHIC DESCRIPTION " +
	"CHARACTER SURROUND FROM LOWER LEFTIDEOGRAPHIC DESCRIPTION CHARACTER OVER" +
	"LAIDIDEOGRAPHIC SPACEIDEOGRAPHIC COMMAIDEOGRAPHIC FULL STOPDITTO MARKJAP" +
	"ANESE INDUSTRIAL STANDARD SYMBOLIDEOGRAPHIC ITERATION MARKIDEOGRAPHIC CL" +
	"OSING MARKIDEOGRAPHIC NUMBER ZEROLEFT ANGLE BRACKETRIGHT ANGLE BRACKETLE" +
	"FT DOUBLE ANGLE BRACKETRIGHT DOUBLE ANGLE BRACKETLEFT CORNER BRACKETRIGH" +
	"T CORNER BRACKETLEFT WHITE CORNER BRACKETRIGHT WHITE CORNER BRACKETLEFT " +
	"BLACK LENTICULAR BRACKETRIGHT BLACK LENTICULAR BRACKETPOSTAL MARKGETA MA" +
	"RKLEFT TORTOISE SHELL BRACKETRIGHT TORTOISE SHELL BRACKETLEFT WHITE LENT" +
	"ICULAR BRACKETRIGHT WHITE LENTICULAR BRACKETLEFT WHITE TORTOISE SHELL BR" +
	"ACKETRIGHT WHITE TORTOISE SHELL BRACKETLEFT WHITE SQUARE BRACKETRIGHT WH" +
	"ITE SQUARE BRACKETWAVE DASHREVERSED DOUBLE PRIME QUOTATION MARKDOUBLE PR" +
	"IME QUOTATION MARKLOW DOUBLE PRIME QUOTATION MARKPOSTAL MARK FACEHANGZHO" +
	"U NUMERAL ONEHANGZHOU NUMERAL TWOHANGZHOU NUMERAL THREEHANGZHOU NUMERAL " +
	"FOURHANGZHOU NUMERAL FIVEHANGZHOU NUMERAL SIXHANGZHOU NUMERAL SEVENHANGZ" +
	"HOU NUMERAL EIGHTHANGZHOU NUMERAL NINEIDEOGRAPHIC LEVEL TONE MARKIDEOGRA" +
	"PHIC RISING TONE MARKIDEOGRAPHIC DEPARTING TONE MARKIDEOGRAPHIC ENTERING" +
	" TONE MARKHANGUL SINGLE DOT TONE MARKHANGUL DOUBLE DOT TONE MARKWAVY DAS" +
	"HVERTICAL KANA REPEAT MARKVERTICAL KANA REPEAT WITH VOICED SOUND MARKVER" +
	"TICAL KANA REPEAT MARK UPPER HALFVERTICAL KANA REPEAT WITH VOICED SOUND " +
	"MARK UPPER HALFVERTICAL KANA REPEAT MARK LOWER HALFCIRCLED POSTAL MARKID" +
	"EOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOLHANGZHOU NUMERAL TENHANGZH" +
	"OU NUMERAL TWENTYHANGZHOU NUMERAL THIRTYVERTICAL IDEOGRAPHIC ITERATION M" +
	"ARKMASU MARKPART ALTERNATION MARKIDEOGRAPHIC VARIATION INDICATORIDEOGRAP" +
	"HIC HALF FILL SPACEHIRAGANA LETTER SMALL AHIRAGANA LETTER AHIRAGANA LETT" +
	"ER SMALL IHIRAGANA LETTER IHIRAGANA LETTER SMALL UHIRAGANA LETTER UHIRAG" +
	"ANA LETTER SMALL EHIRAGANA LETTER EHIRAGANA LETTER SMALL OHIRAGANA LETTE" +
	"R OHIRAGANA LETTER KAHIRAGANA LETTER GAHIRAGANA LETTER KIHIRAGANA LETTER" +
	" GIHIRAGANA LETTER KUHIRAGANA LETTER GUHIRAGANA LETTER KEHIRAGANA LETTER" +
	" GEHIRAGANA LETTER KOHIRAGANA LETTER GOHIRAGANA LETTER SAHIRAGANA LETTER" +
	" ZAHIRAGANA LETTER SIHIRAGANA LETTER ZIHIRAGANA LETTER SUHIRAGANA LETTER" +
	" ZUHIRAGANA LETTER SEHIRAGANA LETTER ZEHIRAGANA LETTER SOHIRAGANA LETTER" +
	" ZOHIRAGANA LETTER TAHIRAGANA LETTER DAHIRAGANA LETTER TIHIRAGANA LETTER" +
	" DIHIRAGANA LETTER SMALL TUHIRAGANA LETTER TUHIRAGANA LETTER DUHIRAGANA " +
	"LETTER TEHIRAGANA LETTER DEHIRAGANA LETTER TOHIRAGANA LETTER DOHIRAGANA " +
	"LETTER NAHIRAGANA LETTER NIHIRAGANA LETTER NUHIRAGANA LETTER NEHIRAGANA " +
	"LETTER NOHIRAGANA LETTER HAHIRAGANA LETTER BAHIRAGANA LETTER PAHIRAGANA " +
	"LETTER HIHIRAGANA LETTER BIHIRAGANA LETTER PIHIRAGANA LETTER HUHIRAGANA " +
	"LETTER BUHIRAGANA LETTER PUHIRAGANA LETTER HEHIRAGANA LETTER BEHIRAGANA ") + ("" +
	"LETTER PEHIRAGANA LETTER HOHIRAGANA LETTER BOHIRAGANA LETTER POHIRAGANA " +
	"LETTER MAHIRAGANA LETTER MIHIRAGANA LETTER MUHIRAGANA LETTER MEHIRAGANA " +
	"LETTER MOHIRAGANA LETTER SMALL YAHIRAGANA LETTER YAHIRAGANA LETTER SMALL" +
	" YUHIRAGANA LETTER YUHIRAGANA LETTER SMALL YOHIRAGANA LETTER YOHIRAGANA " +
	"LETTER RAHIRAGANA LETTER RIHIRAGANA LETTER RUHIRAGANA LETTER REHIRAGANA " +
	"LETTER ROHIRAGANA LETTER SMALL WAHIRAGANA LETTER WAHIRAGANA LETTER WIHIR" +
	"AGANA LETTER WEHIRAGANA LETTER WOHIRAGANA LETTER NHIRAGANA LETTER VUHIRA" +
	"GANA LETTER SMALL KAHIRAGANA LETTER SMALL KECOMBINING KATAKANA-HIRAGANA " +
	"VOICED SOUND MARKCOMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARKKATAK" +
	"ANA-HIRAGANA VOICED SOUND MARKKATAKANA-HIRAGANA SEMI-VOICED SOUND MARKHI" +
	"RAGANA ITERATION MARKHIRAGANA VOICED ITERATION MARKHIRAGANA DIGRAPH YORI" +
	"KATAKANA-HIRAGANA DOUBLE HYPHENKATAKANA LETTER SMALL AKATAKANA LETTER AK" +
	"ATAKANA LETTER SMALL IKATAKANA LETTER IKATAKANA LETTER SMALL UKATAKANA L" +
	"ETTER UKATAKANA LETTER SMALL EKATAKANA LETTER EKATAKANA LETTER SMALL OKA" +
	"TAKANA LETTER OKATAKANA LETTER KAKATAKANA LETTER GAKATAKANA LETTER KIKAT" +
	"AKANA LETTER GIKATAKANA LETTER KUKATAKANA LETTER GUKATAKANA LETTER KEKAT" +
	"AKANA LETTER GEKATAKANA LETTER KOKATAKANA LETTER GOKATAKANA LETTER SAKAT" +
	"AKANA LETTER ZAKATAKANA LETTER SIKATAKANA LETTER ZIKATAKANA LETTER SUKAT" +
	"AKANA LETTER ZUKATAKANA LETTER SEKATAKANA LETTER ZEKATAKANA LETTER SOKAT" +
	"AKANA LETTER ZOKATAKANA LETTER TAKATAKANA LETTER DAKATAKANA LETTER TIKAT" +
	"AKANA LETTER DIKATAKANA LETTER SMALL TUKATAKANA LETTER TUKATAKANA LETTER" +
	" DUKATAKANA LETTER TEKATAKANA LETTER DEKATAKANA LETTER TOKATAKANA LETTER" +
	" DOKATAKANA LETTER NAKATAKANA LETTER NIKATAKANA LETTER NUKATAKANA LETTER" +
	" NEKATAKANA LETTER NOKATAKANA LETTER HAKATAKANA LETTER BAKATAKANA LETTER" +
	" PAKATAKANA LETTER HIKATAKANA LETTER BIKATAKANA LETTER PIKATAKANA LETTER" +
	" HUKATAKANA LETTER BUKATAKANA LETTER PUKATAKANA LETTER HEKATAKANA LETTER" +
	" BEKATAKANA LETTER PEKATAKANA LETTER HOKATAKANA LETTER BOKATAKANA LETTER" +
	" POKATAKANA LETTER MAKATAKANA LETTER MIKATAKANA LETTER MUKATAKANA LETTER" +
	" MEKATAKANA LETTER MOKATAKANA LETTER SMALL YAKATAKANA LETTER YAKATAKANA " +
	"LETTER SMALL YUKATAKANA LETTER YUKATAKANA LETTER SMALL YOKATAKANA LETTER" +
	" YOKATAKANA LETTER RAKATAKANA LETTER RIKATAKANA LETTER RUKATAKANA LETTER" +
	" REKATAKANA LETTER ROKATAKANA LETTER SMALL WAKATAKANA LETTER WAKATAKANA " +
	"LETTER WIKATAKANA LETTER WEKATAKANA LETTER WOKATAKANA LETTER NKATAKANA L" +
	"ETTER VUKATAKANA LETTER SMALL KAKATAKANA LETTER SMALL KEKATAKANA LETTER " +
	"VAKATAKANA LETTER VIKATAKANA LETTER VEKATAKANA LETTER VOKATAKANA MIDDLE " +
	"DOTKATAKANA-HIRAGANA PROLONGED SOUND MARKKATAKANA ITERATION MARKKATAKANA" +
	" VOICED ITERATION MARKKATAKANA DIGRAPH KOTOBOPOMOFO LETTER BBOPOMOFO LET" +
	"TER PBOPOMOFO LETTER MBOPOMOFO LETTER FBOPOMOFO LETTER DBOPOMOFO LETTER " +
	"TBOPOMOFO LETTER NBOPOMOFO LETTER LBOPOMOFO LETTER GBOPOMOFO LETTER KBOP" +
	"OMOFO LETTER HBOPOMOFO LETTER JBOPOMOFO LETTER QBOPOMOFO LETTER XBOPOMOF" +
	"O LETTER ZHBOPOMOFO LETTER CHBOPOMOFO LETTER SHBOPOMOFO LETTER RBOPOMOFO" +
	" LETTER ZBOPOMOFO LETTER CBOPOMOFO LETTER SBOPOMOFO LETTER ABOPOMOFO LET" +
	"TER OBOPOMOFO LETTER EBOPOMOFO LETTER EHBOPOMOFO LETTER AIBOPOMOFO LETTE" +
	"R EIBOPOMOFO LETTER AUBOPOMOFO LETTER OUBOPOMOFO LETTER ANBOPOMOFO LETTE" +
	"R ENBOPOMOFO LETTER ANGBOPOMOFO LETTER ENGBOPOMOFO LETTER ERBOPOMOFO LET" +
	"TER IBOPOMOFO LETTER UBOPOMOFO LETTER IUBOPOMOFO LETTER VBOPOMOFO LETTER" +
	" NGBOPOMOFO LETTER GNBOPOMOFO LETTER IHBOPOMOFO LETTER O WITH DOT ABOVEB" +
	"OPOMOFO LETTER NNHANGUL LETTER KIYEOKHANGUL LETTER SSANGKIYEOKHANGUL LET" +
	"TER KIYEOK-SIOSHANGUL LETTER NIEUNHANGUL LETTER NIEUN-CIEUCHANGUL LETTER" +
	" NIEUN-HIEUHHANGUL LETTER TIKEUTHANGUL LETTER SSANGTIKEUTHANGUL LETTER R" +
	"IEULHANGUL LETTER RIEUL-KIYEOKHANGUL LETTER RIEUL-MIEUMHANGUL LETTER RIE" +
	"UL-PIEUPHANGUL LETTER RIEUL-SIOSHANGUL LETTER RIEUL-THIEUTHHANGUL LETTER" +
	" RIEUL-PHIEUPHHANGUL LETTER RIEUL-HIEUHHANGUL LETTER MIEUMHANGUL LETTER " +
	"PIEUPHANGUL LETTER SSANGPIEUPHANGUL LETTER PIEUP-SIOSHANGUL LETTER SIOSH" +
	"ANGUL LETTER SSANGSIOSHANGUL LETTER IEUNGHANGUL LETTER CIEUCHANGUL LETTE" +
	"R SSANGCIEUCHANGUL LETTER CHIEUCHHANGUL LETTER KHIEUKHHANGUL LETTER THIE" +
	"UTHHANGUL LETTER PHIEUPHHANGUL LETTER HIEUHHANGUL LETTER AHANGUL LETTER " +
	"AEHANGUL LETTER YAHANGUL LETTER YAEHANGUL LETTER EOHANGUL LETTER EHANGUL" +
	" LETTER YEOHANGUL LETTER YEHANGUL LETTER OHANGUL LETTER WAHANGUL LETTER " +
	"WAEHANGUL LETTER OEHANGUL LETTER YOHANGUL LETTER UHANGUL LETTER WEOHANGU" +
	"L LETTER WEHANGUL LETTER WIHANGUL LETTER YUHANGUL LETTER EUHANGUL LETTER" +
	" YIHANGUL LETTER IHANGUL FILLERHANGUL LETTER SSANGNIEUNHANGUL LETTER NIE" +
	"UN-TIKEUTHANGUL LETTER NIEUN-SIOSHANGUL LETTER NIEUN-PANSIOSHANGUL LETTE" +
	"R RIEUL-KIYEOK-SIOSHANGUL LETTER RIEUL-TIKEUTHANGUL LETTER RIEUL-PIEUP-S") + ("" +
	"IOSHANGUL LETTER RIEUL-PANSIOSHANGUL LETTER RIEUL-YEORINHIEUHHANGUL LETT" +
	"ER MIEUM-PIEUPHANGUL LETTER MIEUM-SIOSHANGUL LETTER MIEUM-PANSIOSHANGUL " +
	"LETTER KAPYEOUNMIEUMHANGUL LETTER PIEUP-KIYEOKHANGUL LETTER PIEUP-TIKEUT" +
	"HANGUL LETTER PIEUP-SIOS-KIYEOKHANGUL LETTER PIEUP-SIOS-TIKEUTHANGUL LET" +
	"TER PIEUP-CIEUCHANGUL LETTER PIEUP-THIEUTHHANGUL LETTER KAPYEOUNPIEUPHAN" +
	"GUL LETTER KAPYEOUNSSANGPIEUPHANGUL LETTER SIOS-KIYEOKHANGUL LETTER SIOS" +
	"-NIEUNHANGUL LETTER SIOS-TIKEUTHANGUL LETTER SIOS-PIEUPHANGUL LETTER SIO" +
	"S-CIEUCHANGUL LETTER PANSIOSHANGUL LETTER SSANGIEUNGHANGUL LETTER YESIEU" +
	"NGHANGUL LETTER YESIEUNG-SIOSHANGUL LETTER YESIEUNG-PANSIOSHANGUL LETTER" +
	" KAPYEOUNPHIEUPHHANGUL LETTER SSANGHIEUHHANGUL LETTER YEORINHIEUHHANGUL " +
	"LETTER YO-YAHANGUL LETTER YO-YAEHANGUL LETTER YO-IHANGUL LETTER YU-YEOHA" +
	"NGUL LETTER YU-YEHANGUL LETTER YU-IHANGUL LETTER ARAEAHANGUL LETTER ARAE" +
	"AEIDEOGRAPHIC ANNOTATION LINKING MARKIDEOGRAPHIC ANNOTATION REVERSE MARK" +
	"IDEOGRAPHIC ANNOTATION ONE MARKIDEOGRAPHIC ANNOTATION TWO MARKIDEOGRAPHI" +
	"C ANNOTATION THREE MARKIDEOGRAPHIC ANNOTATION FOUR MARKIDEOGRAPHIC ANNOT" +
	"ATION TOP MARKIDEOGRAPHIC ANNOTATION MIDDLE MARKIDEOGRAPHIC ANNOTATION B" +
	"OTTOM MARKIDEOGRAPHIC ANNOTATION FIRST MARKIDEOGRAPHIC ANNOTATION SECOND" +
	" MARKIDEOGRAPHIC ANNOTATION THIRD MARKIDEOGRAPHIC ANNOTATION FOURTH MARK" +
	"IDEOGRAPHIC ANNOTATION HEAVEN MARKIDEOGRAPHIC ANNOTATION EARTH MARKIDEOG" +
	"RAPHIC ANNOTATION MAN MARKBOPOMOFO LETTER BUBOPOMOFO LETTER ZIBOPOMOFO L" +
	"ETTER JIBOPOMOFO LETTER GUBOPOMOFO LETTER EEBOPOMOFO LETTER ENNBOPOMOFO " +
	"LETTER OOBOPOMOFO LETTER ONNBOPOMOFO LETTER IRBOPOMOFO LETTER ANNBOPOMOF" +
	"O LETTER INNBOPOMOFO LETTER UNNBOPOMOFO LETTER IMBOPOMOFO LETTER NGGBOPO" +
	"MOFO LETTER AINNBOPOMOFO LETTER AUNNBOPOMOFO LETTER AMBOPOMOFO LETTER OM" +
	"BOPOMOFO LETTER ONGBOPOMOFO LETTER INNNBOPOMOFO FINAL LETTER PBOPOMOFO F" +
	"INAL LETTER TBOPOMOFO FINAL LETTER KBOPOMOFO FINAL LETTER HBOPOMOFO LETT" +
	"ER GHBOPOMOFO LETTER LHBOPOMOFO LETTER ZYCJK STROKE TCJK STROKE WGCJK ST" +
	"ROKE XGCJK STROKE BXGCJK STROKE SWCJK STROKE HZZCJK STROKE HZGCJK STROKE" +
	" HPCJK STROKE HZWGCJK STROKE SZWGCJK STROKE HZTCJK STROKE HZZPCJK STROKE" +
	" HPWGCJK STROKE HZWCJK STROKE HZZZCJK STROKE NCJK STROKE HCJK STROKE SCJ" +
	"K STROKE PCJK STROKE SPCJK STROKE DCJK STROKE HZCJK STROKE HGCJK STROKE " +
	"SZCJK STROKE SWZCJK STROKE STCJK STROKE SGCJK STROKE PDCJK STROKE PZCJK " +
	"STROKE TNCJK STROKE SZZCJK STROKE SWGCJK STROKE HXWGCJK STROKE HZZZGCJK " +
	"STROKE PGCJK STROKE QKATAKANA LETTER SMALL KUKATAKANA LETTER SMALL SIKAT" +
	"AKANA LETTER SMALL SUKATAKANA LETTER SMALL TOKATAKANA LETTER SMALL NUKAT" +
	"AKANA LETTER SMALL HAKATAKANA LETTER SMALL HIKATAKANA LETTER SMALL HUKAT" +
	"AKANA LETTER SMALL HEKATAKANA LETTER SMALL HOKATAKANA LETTER SMALL MUKAT" +
	"AKANA LETTER SMALL RAKATAKANA LETTER SMALL RIKATAKANA LETTER SMALL RUKAT" +
	"AKANA LETTER SMALL REKATAKANA LETTER SMALL ROPARENTHESIZED HANGUL KIYEOK" +
	"PARENTHESIZED HANGUL NIEUNPARENTHESIZED HANGUL TIKEUTPARENTHESIZED HANGU" +
	"L RIEULPARENTHESIZED HANGUL MIEUMPARENTHESIZED HANGUL PIEUPPARENTHESIZED" +
	" HANGUL SIOSPARENTHESIZED HANGUL IEUNGPARENTHESIZED HANGUL CIEUCPARENTHE" +
	"SIZED HANGUL CHIEUCHPARENTHESIZED HANGUL KHIEUKHPARENTHESIZED HANGUL THI" +
	"EUTHPARENTHESIZED HANGUL PHIEUPHPARENTHESIZED HANGUL HIEUHPARENTHESIZED " +
	"HANGUL KIYEOK APARENTHESIZED HANGUL NIEUN APARENTHESIZED HANGUL TIKEUT A" +
	"PARENTHESIZED HANGUL RIEUL APARENTHESIZED HANGUL MIEUM APARENTHESIZED HA" +
	"NGUL PIEUP APARENTHESIZED HANGUL SIOS APARENTHESIZED HANGUL IEUNG APAREN" +
	"THESIZED HANGUL CIEUC APARENTHESIZED HANGUL CHIEUCH APARENTHESIZED HANGU" +
	"L KHIEUKH APARENTHESIZED HANGUL THIEUTH APARENTHESIZED HANGUL PHIEUPH AP" +
	"ARENTHESIZED HANGUL HIEUH APARENTHESIZED HANGUL CIEUC UPARENTHESIZED KOR" +
	"EAN CHARACTER OJEONPARENTHESIZED KOREAN CHARACTER O HUPARENTHESIZED IDEO" +
	"GRAPH ONEPARENTHESIZED IDEOGRAPH TWOPARENTHESIZED IDEOGRAPH THREEPARENTH" +
	"ESIZED IDEOGRAPH FOURPARENTHESIZED IDEOGRAPH FIVEPARENTHESIZED IDEOGRAPH" +
	" SIXPARENTHESIZED IDEOGRAPH SEVENPARENTHESIZED IDEOGRAPH EIGHTPARENTHESI" +
	"ZED IDEOGRAPH NINEPARENTHESIZED IDEOGRAPH TENPARENTHESIZED IDEOGRAPH MOO" +
	"NPARENTHESIZED IDEOGRAPH FIREPARENTHESIZED IDEOGRAPH WATERPARENTHESIZED " +
	"IDEOGRAPH WOODPARENTHESIZED IDEOGRAPH METALPARENTHESIZED IDEOGRAPH EARTH" +
	"PARENTHESIZED IDEOGRAPH SUNPARENTHESIZED IDEOGRAPH STOCKPARENTHESIZED ID" +
	"EOGRAPH HAVEPARENTHESIZED IDEOGRAPH SOCIETYPARENTHESIZED IDEOGRAPH NAMEP" +
	"ARENTHESIZED IDEOGRAPH SPECIALPARENTHESIZED IDEOGRAPH FINANCIALPARENTHES" +
	"IZED IDEOGRAPH CONGRATULATIONPARENTHESIZED IDEOGRAPH LABORPARENTHESIZED " +
	"IDEOGRAPH REPRESENTPARENTHESIZED IDEOGRAPH CALLPARENTHESIZED IDEOGRAPH S" +
	"TUDYPARENTHESIZED IDEOGRAPH SUPERVISEPARENTHESIZED IDEOGRAPH ENTERPRISEP" +
	"ARENTHESIZED IDEOGRAPH RESOURCEPARENTHESIZED IDEOGRAPH ALLIANCEPARENTHES") + ("" +
	"IZED IDEOGRAPH FESTIVALPARENTHESIZED IDEOGRAPH RESTPARENTHESIZED IDEOGRA" +
	"PH SELFPARENTHESIZED IDEOGRAPH REACHCIRCLED IDEOGRAPH QUESTIONCIRCLED ID" +
	"EOGRAPH KINDERGARTENCIRCLED IDEOGRAPH SCHOOLCIRCLED IDEOGRAPH KOTOCIRCLE" +
	"D NUMBER TEN ON BLACK SQUARECIRCLED NUMBER TWENTY ON BLACK SQUARECIRCLED" +
	" NUMBER THIRTY ON BLACK SQUARECIRCLED NUMBER FORTY ON BLACK SQUARECIRCLE" +
	"D NUMBER FIFTY ON BLACK SQUARECIRCLED NUMBER SIXTY ON BLACK SQUARECIRCLE" +
	"D NUMBER SEVENTY ON BLACK SQUARECIRCLED NUMBER EIGHTY ON BLACK SQUAREPAR" +
	"TNERSHIP SIGNCIRCLED NUMBER TWENTY ONECIRCLED NUMBER TWENTY TWOCIRCLED N" +
	"UMBER TWENTY THREECIRCLED NUMBER TWENTY FOURCIRCLED NUMBER TWENTY FIVECI" +
	"RCLED NUMBER TWENTY SIXCIRCLED NUMBER TWENTY SEVENCIRCLED NUMBER TWENTY " +
	"EIGHTCIRCLED NUMBER TWENTY NINECIRCLED NUMBER THIRTYCIRCLED NUMBER THIRT" +
	"Y ONECIRCLED NUMBER THIRTY TWOCIRCLED NUMBER THIRTY THREECIRCLED NUMBER " +
	"THIRTY FOURCIRCLED NUMBER THIRTY FIVECIRCLED HANGUL KIYEOKCIRCLED HANGUL" +
	" NIEUNCIRCLED HANGUL TIKEUTCIRCLED HANGUL RIEULCIRCLED HANGUL MIEUMCIRCL" +
	"ED HANGUL PIEUPCIRCLED HANGUL SIOSCIRCLED HANGUL IEUNGCIRCLED HANGUL CIE" +
	"UCCIRCLED HANGUL CHIEUCHCIRCLED HANGUL KHIEUKHCIRCLED HANGUL THIEUTHCIRC" +
	"LED HANGUL PHIEUPHCIRCLED HANGUL HIEUHCIRCLED HANGUL KIYEOK ACIRCLED HAN" +
	"GUL NIEUN ACIRCLED HANGUL TIKEUT ACIRCLED HANGUL RIEUL ACIRCLED HANGUL M" +
	"IEUM ACIRCLED HANGUL PIEUP ACIRCLED HANGUL SIOS ACIRCLED HANGUL IEUNG AC" +
	"IRCLED HANGUL CIEUC ACIRCLED HANGUL CHIEUCH ACIRCLED HANGUL KHIEUKH ACIR" +
	"CLED HANGUL THIEUTH ACIRCLED HANGUL PHIEUPH ACIRCLED HANGUL HIEUH ACIRCL" +
	"ED KOREAN CHARACTER CHAMKOCIRCLED KOREAN CHARACTER JUEUICIRCLED HANGUL I" +
	"EUNG UKOREAN STANDARD SYMBOLCIRCLED IDEOGRAPH ONECIRCLED IDEOGRAPH TWOCI" +
	"RCLED IDEOGRAPH THREECIRCLED IDEOGRAPH FOURCIRCLED IDEOGRAPH FIVECIRCLED" +
	" IDEOGRAPH SIXCIRCLED IDEOGRAPH SEVENCIRCLED IDEOGRAPH EIGHTCIRCLED IDEO" +
	"GRAPH NINECIRCLED IDEOGRAPH TENCIRCLED IDEOGRAPH MOONCIRCLED IDEOGRAPH F" +
	"IRECIRCLED IDEOGRAPH WATERCIRCLED IDEOGRAPH WOODCIRCLED IDEOGRAPH METALC" +
	"IRCLED IDEOGRAPH EARTHCIRCLED IDEOGRAPH SUNCIRCLED IDEOGRAPH STOCKCIRCLE" +
	"D IDEOGRAPH HAVECIRCLED IDEOGRAPH SOCIETYCIRCLED IDEOGRAPH NAMECIRCLED I" +
	"DEOGRAPH SPECIALCIRCLED IDEOGRAPH FINANCIALCIRCLED IDEOGRAPH CONGRATULAT" +
	"IONCIRCLED IDEOGRAPH LABORCIRCLED IDEOGRAPH SECRETCIRCLED IDEOGRAPH MALE" +
	"CIRCLED IDEOGRAPH FEMALECIRCLED IDEOGRAPH SUITABLECIRCLED IDEOGRAPH EXCE" +
	"LLENTCIRCLED IDEOGRAPH PRINTCIRCLED IDEOGRAPH ATTENTIONCIRCLED IDEOGRAPH" +
	" ITEMCIRCLED IDEOGRAPH RESTCIRCLED IDEOGRAPH COPYCIRCLED IDEOGRAPH CORRE" +
	"CTCIRCLED IDEOGRAPH HIGHCIRCLED IDEOGRAPH CENTRECIRCLED IDEOGRAPH LOWCIR" +
	"CLED IDEOGRAPH LEFTCIRCLED IDEOGRAPH RIGHTCIRCLED IDEOGRAPH MEDICINECIRC" +
	"LED IDEOGRAPH RELIGIONCIRCLED IDEOGRAPH STUDYCIRCLED IDEOGRAPH SUPERVISE" +
	"CIRCLED IDEOGRAPH ENTERPRISECIRCLED IDEOGRAPH RESOURCECIRCLED IDEOGRAPH " +
	"ALLIANCECIRCLED IDEOGRAPH NIGHTCIRCLED NUMBER THIRTY SIXCIRCLED NUMBER T" +
	"HIRTY SEVENCIRCLED NUMBER THIRTY EIGHTCIRCLED NUMBER THIRTY NINECIRCLED " +
	"NUMBER FORTYCIRCLED NUMBER FORTY ONECIRCLED NUMBER FORTY TWOCIRCLED NUMB" +
	"ER FORTY THREECIRCLED NUMBER FORTY FOURCIRCLED NUMBER FORTY FIVECIRCLED " +
	"NUMBER FORTY SIXCIRCLED NUMBER FORTY SEVENCIRCLED NUMBER FORTY EIGHTCIRC" +
	"LED NUMBER FORTY NINECIRCLED NUMBER FIFTYIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R JANUARYIDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARYIDEOGRAPHIC TELEGRAPH " +
	"SYMBOL FOR MARCHIDEOGRAPHIC TELEGRAPH SYMBOL FOR APRILIDEOGRAPHIC TELEGR" +
	"APH SYMBOL FOR MAYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNEIDEOGRAPHIC TELEG" +
	"RAPH SYMBOL FOR JULYIDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUSTIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR SEPTEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBERIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"ECEMBERSQUARE HGSQUARE ERGSQUARE EVLIMITED LIABILITY SIGNCIRCLED KATAKAN" +
	"A ACIRCLED KATAKANA ICIRCLED KATAKANA UCIRCLED KATAKANA ECIRCLED KATAKAN" +
	"A OCIRCLED KATAKANA KACIRCLED KATAKANA KICIRCLED KATAKANA KUCIRCLED KATA" +
	"KANA KECIRCLED KATAKANA KOCIRCLED KATAKANA SACIRCLED KATAKANA SICIRCLED " +
	"KATAKANA SUCIRCLED KATAKANA SECIRCLED KATAKANA SOCIRCLED KATAKANA TACIRC" +
	"LED KATAKANA TICIRCLED KATAKANA TUCIRCLED KATAKANA TECIRCLED KATAKANA TO" +
	"CIRCLED KATAKANA NACIRCLED KATAKANA NICIRCLED KATAKANA NUCIRCLED KATAKAN" +
	"A NECIRCLED KATAKANA NOCIRCLED KATAKANA HACIRCLED KATAKANA HICIRCLED KAT" +
	"AKANA HUCIRCLED KATAKANA HECIRCLED KATAKANA HOCIRCLED KATAKANA MACIRCLED" +
	" KATAKANA MICIRCLED KATAKANA MUCIRCLED KATAKANA MECIRCLED KATAKANA MOCIR" +
	"CLED KATAKANA YACIRCLED KATAKANA YUCIRCLED KATAKANA YOCIRCLED KATAKANA R" +
	"ACIRCLED KATAKANA RICIRCLED KATAKANA RUCIRCLED KATAKANA RECIRCLED KATAKA" +
	"NA ROCIRCLED KATAKANA WACIRCLED KATAKANA WICIRCLED KATAKANA WECIRCLED KA" +
	"TAKANA WOSQUARE APAATOSQUARE ARUHUASQUARE ANPEASQUARE AARUSQUARE ININGUS") + ("" +
	"QUARE INTISQUARE UONSQUARE ESUKUUDOSQUARE EEKAASQUARE ONSUSQUARE OOMUSQU" +
	"ARE KAIRISQUARE KARATTOSQUARE KARORIISQUARE GARONSQUARE GANMASQUARE GIGA" +
	"SQUARE GINIISQUARE KYURIISQUARE GIRUDAASQUARE KIROSQUARE KIROGURAMUSQUAR" +
	"E KIROMEETORUSQUARE KIROWATTOSQUARE GURAMUSQUARE GURAMUTONSQUARE KURUZEI" +
	"ROSQUARE KUROONESQUARE KEESUSQUARE KORUNASQUARE KOOPOSQUARE SAIKURUSQUAR" +
	"E SANTIIMUSQUARE SIRINGUSQUARE SENTISQUARE SENTOSQUARE DAASUSQUARE DESIS" +
	"QUARE DORUSQUARE TONSQUARE NANOSQUARE NOTTOSQUARE HAITUSQUARE PAASENTOSQ" +
	"UARE PAATUSQUARE BAARERUSQUARE PIASUTORUSQUARE PIKURUSQUARE PIKOSQUARE B" +
	"IRUSQUARE HUARADDOSQUARE HUIITOSQUARE BUSSYERUSQUARE HURANSQUARE HEKUTAA" +
	"RUSQUARE PESOSQUARE PENIHISQUARE HERUTUSQUARE PENSUSQUARE PEEZISQUARE BE" +
	"ETASQUARE POINTOSQUARE BORUTOSQUARE HONSQUARE PONDOSQUARE HOORUSQUARE HO" +
	"ONSQUARE MAIKUROSQUARE MAIRUSQUARE MAHHASQUARE MARUKUSQUARE MANSYONSQUAR" +
	"E MIKURONSQUARE MIRISQUARE MIRIBAARUSQUARE MEGASQUARE MEGATONSQUARE MEET" +
	"ORUSQUARE YAADOSQUARE YAARUSQUARE YUANSQUARE RITTORUSQUARE RIRASQUARE RU" +
	"PIISQUARE RUUBURUSQUARE REMUSQUARE RENTOGENSQUARE WATTOIDEOGRAPHIC TELEG" +
	"RAPH SYMBOL FOR HOUR ZEROIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR HOUR TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR" +
	" THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURIDEOGRAPHIC TELEGRAPH SY" +
	"MBOL FOR HOUR FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR HOUR SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGH" +
	"TIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINEIDEOGRAPHIC TELEGRAPH SYMBOL " +
	"FOR HOUR TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVENIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR HOUR TWELVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTE" +
	"ENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEENIDEOGRAPHIC TELEGRAPH SY" +
	"MBOL FOR HOUR FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEENIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEENIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R HOUR EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEENIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR HOUR TWENTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR T" +
	"WENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWOIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR HOUR TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR" +
	" TWENTY-FOURSQUARE HPASQUARE DASQUARE AUSQUARE BARSQUARE OVSQUARE PCSQUA" +
	"RE DMSQUARE DM SQUAREDSQUARE DM CUBEDSQUARE IUSQUARE ERA NAME HEISEISQUA" +
	"RE ERA NAME SYOUWASQUARE ERA NAME TAISYOUSQUARE ERA NAME MEIZISQUARE COR" +
	"PORATIONSQUARE PA AMPSSQUARE NASQUARE MU ASQUARE MASQUARE KASQUARE KBSQU" +
	"ARE MBSQUARE GBSQUARE CALSQUARE KCALSQUARE PFSQUARE NFSQUARE MU FSQUARE " +
	"MU GSQUARE MGSQUARE KGSQUARE HZSQUARE KHZSQUARE MHZSQUARE GHZSQUARE THZS" +
	"QUARE MU LSQUARE MLSQUARE DLSQUARE KLSQUARE FMSQUARE NMSQUARE MU MSQUARE" +
	" MMSQUARE CMSQUARE KMSQUARE MM SQUAREDSQUARE CM SQUAREDSQUARE M SQUAREDS" +
	"QUARE KM SQUAREDSQUARE MM CUBEDSQUARE CM CUBEDSQUARE M CUBEDSQUARE KM CU" +
	"BEDSQUARE M OVER SSQUARE M OVER S SQUAREDSQUARE PASQUARE KPASQUARE MPASQ" +
	"UARE GPASQUARE RADSQUARE RAD OVER SSQUARE RAD OVER S SQUAREDSQUARE PSSQU" +
	"ARE NSSQUARE MU SSQUARE MSSQUARE PVSQUARE NVSQUARE MU VSQUARE MVSQUARE K" +
	"VSQUARE MV MEGASQUARE PWSQUARE NWSQUARE MU WSQUARE MWSQUARE KWSQUARE MW " +
	"MEGASQUARE K OHMSQUARE M OHMSQUARE AMSQUARE BQSQUARE CCSQUARE CDSQUARE C" +
	" OVER KGSQUARE COSQUARE DBSQUARE GYSQUARE HASQUARE HPSQUARE INSQUARE KKS" +
	"QUARE KM CAPITALSQUARE KTSQUARE LMSQUARE LNSQUARE LOGSQUARE LXSQUARE MB " +
	"SMALLSQUARE MILSQUARE MOLSQUARE PHSQUARE PMSQUARE PPMSQUARE PRSQUARE SRS" +
	"QUARE SVSQUARE WBSQUARE V OVER MSQUARE A OVER MIDEOGRAPHIC TELEGRAPH SYM" +
	"BOL FOR DAY ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWOIDEOGRAPHIC TELEG" +
	"RAPH SYMBOL FOR DAY THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR DAY FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY " +
	"SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENIDEOGRAPHIC TELEGRAPH SYMBO" +
	"L FOR DAY EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINEIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR DAY TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVENIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR DAY TWELVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEENIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR DAY FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN" +
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEENIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR DAY EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEENIDEOGRAP" +
	"HIC TELEGRAPH SYMBOL FOR DAY TWENTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY " +
	"TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWOIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR DAY TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY T" +
	"WENTY-FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVEIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR DAY TWENTY-SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TW") + ("" +
	"ENTY-SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHTIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR DAY TWENTY-NINEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY " +
	"THIRTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONESQUARE GALHEXAGRAM " +
	"FOR THE CREATIVE HEAVENHEXAGRAM FOR THE RECEPTIVE EARTHHEXAGRAM FOR DIFF" +
	"ICULTY AT THE BEGINNINGHEXAGRAM FOR YOUTHFUL FOLLYHEXAGRAM FOR WAITINGHE" +
	"XAGRAM FOR CONFLICTHEXAGRAM FOR THE ARMYHEXAGRAM FOR HOLDING TOGETHERHEX" +
	"AGRAM FOR SMALL TAMINGHEXAGRAM FOR TREADINGHEXAGRAM FOR PEACEHEXAGRAM FO" +
	"R STANDSTILLHEXAGRAM FOR FELLOWSHIPHEXAGRAM FOR GREAT POSSESSIONHEXAGRAM" +
	" FOR MODESTYHEXAGRAM FOR ENTHUSIASMHEXAGRAM FOR FOLLOWINGHEXAGRAM FOR WO" +
	"RK ON THE DECAYEDHEXAGRAM FOR APPROACHHEXAGRAM FOR CONTEMPLATIONHEXAGRAM" +
	" FOR BITING THROUGHHEXAGRAM FOR GRACEHEXAGRAM FOR SPLITTING APARTHEXAGRA" +
	"M FOR RETURNHEXAGRAM FOR INNOCENCEHEXAGRAM FOR GREAT TAMINGHEXAGRAM FOR " +
	"MOUTH CORNERSHEXAGRAM FOR GREAT PREPONDERANCEHEXAGRAM FOR THE ABYSMAL WA" +
	"TERHEXAGRAM FOR THE CLINGING FIREHEXAGRAM FOR INFLUENCEHEXAGRAM FOR DURA" +
	"TIONHEXAGRAM FOR RETREATHEXAGRAM FOR GREAT POWERHEXAGRAM FOR PROGRESSHEX" +
	"AGRAM FOR DARKENING OF THE LIGHTHEXAGRAM FOR THE FAMILYHEXAGRAM FOR OPPO" +
	"SITIONHEXAGRAM FOR OBSTRUCTIONHEXAGRAM FOR DELIVERANCEHEXAGRAM FOR DECRE" +
	"ASEHEXAGRAM FOR INCREASEHEXAGRAM FOR BREAKTHROUGHHEXAGRAM FOR COMING TO " +
	"MEETHEXAGRAM FOR GATHERING TOGETHERHEXAGRAM FOR PUSHING UPWARDHEXAGRAM F" +
	"OR OPPRESSIONHEXAGRAM FOR THE WELLHEXAGRAM FOR REVOLUTIONHEXAGRAM FOR TH" +
	"E CAULDRONHEXAGRAM FOR THE AROUSING THUNDERHEXAGRAM FOR THE KEEPING STIL" +
	"L MOUNTAINHEXAGRAM FOR DEVELOPMENTHEXAGRAM FOR THE MARRYING MAIDENHEXAGR" +
	"AM FOR ABUNDANCEHEXAGRAM FOR THE WANDERERHEXAGRAM FOR THE GENTLE WINDHEX" +
	"AGRAM FOR THE JOYOUS LAKEHEXAGRAM FOR DISPERSIONHEXAGRAM FOR LIMITATIONH" +
	"EXAGRAM FOR INNER TRUTHHEXAGRAM FOR SMALL PREPONDERANCEHEXAGRAM FOR AFTE" +
	"R COMPLETIONHEXAGRAM FOR BEFORE COMPLETIONYI SYLLABLE ITYI SYLLABLE IXYI" +
	" SYLLABLE IYI SYLLABLE IPYI SYLLABLE IETYI SYLLABLE IEXYI SYLLABLE IEYI " +
	"SYLLABLE IEPYI SYLLABLE ATYI SYLLABLE AXYI SYLLABLE AYI SYLLABLE APYI SY" +
	"LLABLE UOXYI SYLLABLE UOYI SYLLABLE UOPYI SYLLABLE OTYI SYLLABLE OXYI SY" +
	"LLABLE OYI SYLLABLE OPYI SYLLABLE EXYI SYLLABLE EYI SYLLABLE WUYI SYLLAB" +
	"LE BITYI SYLLABLE BIXYI SYLLABLE BIYI SYLLABLE BIPYI SYLLABLE BIETYI SYL" +
	"LABLE BIEXYI SYLLABLE BIEYI SYLLABLE BIEPYI SYLLABLE BATYI SYLLABLE BAXY" +
	"I SYLLABLE BAYI SYLLABLE BAPYI SYLLABLE BUOXYI SYLLABLE BUOYI SYLLABLE B" +
	"UOPYI SYLLABLE BOTYI SYLLABLE BOXYI SYLLABLE BOYI SYLLABLE BOPYI SYLLABL" +
	"E BEXYI SYLLABLE BEYI SYLLABLE BEPYI SYLLABLE BUTYI SYLLABLE BUXYI SYLLA" +
	"BLE BUYI SYLLABLE BUPYI SYLLABLE BURXYI SYLLABLE BURYI SYLLABLE BYTYI SY" +
	"LLABLE BYXYI SYLLABLE BYYI SYLLABLE BYPYI SYLLABLE BYRXYI SYLLABLE BYRYI" +
	" SYLLABLE PITYI SYLLABLE PIXYI SYLLABLE PIYI SYLLABLE PIPYI SYLLABLE PIE" +
	"XYI SYLLABLE PIEYI SYLLABLE PIEPYI SYLLABLE PATYI SYLLABLE PAXYI SYLLABL" +
	"E PAYI SYLLABLE PAPYI SYLLABLE PUOXYI SYLLABLE PUOYI SYLLABLE PUOPYI SYL" +
	"LABLE POTYI SYLLABLE POXYI SYLLABLE POYI SYLLABLE POPYI SYLLABLE PUTYI S" +
	"YLLABLE PUXYI SYLLABLE PUYI SYLLABLE PUPYI SYLLABLE PURXYI SYLLABLE PURY" +
	"I SYLLABLE PYTYI SYLLABLE PYXYI SYLLABLE PYYI SYLLABLE PYPYI SYLLABLE PY" +
	"RXYI SYLLABLE PYRYI SYLLABLE BBITYI SYLLABLE BBIXYI SYLLABLE BBIYI SYLLA" +
	"BLE BBIPYI SYLLABLE BBIETYI SYLLABLE BBIEXYI SYLLABLE BBIEYI SYLLABLE BB" +
	"IEPYI SYLLABLE BBATYI SYLLABLE BBAXYI SYLLABLE BBAYI SYLLABLE BBAPYI SYL" +
	"LABLE BBUOXYI SYLLABLE BBUOYI SYLLABLE BBUOPYI SYLLABLE BBOTYI SYLLABLE " +
	"BBOXYI SYLLABLE BBOYI SYLLABLE BBOPYI SYLLABLE BBEXYI SYLLABLE BBEYI SYL" +
	"LABLE BBEPYI SYLLABLE BBUTYI SYLLABLE BBUXYI SYLLABLE BBUYI SYLLABLE BBU" +
	"PYI SYLLABLE BBURXYI SYLLABLE BBURYI SYLLABLE BBYTYI SYLLABLE BBYXYI SYL" +
	"LABLE BBYYI SYLLABLE BBYPYI SYLLABLE NBITYI SYLLABLE NBIXYI SYLLABLE NBI" +
	"YI SYLLABLE NBIPYI SYLLABLE NBIEXYI SYLLABLE NBIEYI SYLLABLE NBIEPYI SYL" +
	"LABLE NBATYI SYLLABLE NBAXYI SYLLABLE NBAYI SYLLABLE NBAPYI SYLLABLE NBO" +
	"TYI SYLLABLE NBOXYI SYLLABLE NBOYI SYLLABLE NBOPYI SYLLABLE NBUTYI SYLLA" +
	"BLE NBUXYI SYLLABLE NBUYI SYLLABLE NBUPYI SYLLABLE NBURXYI SYLLABLE NBUR" +
	"YI SYLLABLE NBYTYI SYLLABLE NBYXYI SYLLABLE NBYYI SYLLABLE NBYPYI SYLLAB" +
	"LE NBYRXYI SYLLABLE NBYRYI SYLLABLE HMITYI SYLLABLE HMIXYI SYLLABLE HMIY" +
	"I SYLLABLE HMIPYI SYLLABLE HMIEXYI SYLLABLE HMIEYI SYLLABLE HMIEPYI SYLL" +
	"ABLE HMATYI SYLLABLE HMAXYI SYLLABLE HMAYI SYLLABLE HMAPYI SYLLABLE HMUO" +
	"XYI SYLLABLE HMUOYI SYLLABLE HMUOPYI SYLLABLE HMOTYI SYLLABLE HMOXYI SYL" +
	"LABLE HMOYI SYLLABLE HMOPYI SYLLABLE HMUTYI SYLLABLE HMUXYI SYLLABLE HMU" +
	"YI SYLLABLE HMUPYI SYLLABLE HMURXYI SYLLABLE HMURYI SYLLABLE HMYXYI SYLL" +
	"ABLE HMYYI SYLLABLE HMYPYI SYLLABLE HMYRXYI SYLLABLE HMYRYI SYLLABLE MIT" +
	"YI SYLLABLE MIXYI SYLLABLE MIYI SYLLABLE MIPYI SYLLABLE MIEXYI SYLLABLE ") + ("" +
	"MIEYI SYLLABLE MIEPYI SYLLABLE MATYI SYLLABLE MAXYI SYLLABLE MAYI SYLLAB" +
	"LE MAPYI SYLLABLE MUOTYI SYLLABLE MUOXYI SYLLABLE MUOYI SYLLABLE MUOPYI " +
	"SYLLABLE MOTYI SYLLABLE MOXYI SYLLABLE MOYI SYLLABLE MOPYI SYLLABLE MEXY" +
	"I SYLLABLE MEYI SYLLABLE MUTYI SYLLABLE MUXYI SYLLABLE MUYI SYLLABLE MUP" +
	"YI SYLLABLE MURXYI SYLLABLE MURYI SYLLABLE MYTYI SYLLABLE MYXYI SYLLABLE" +
	" MYYI SYLLABLE MYPYI SYLLABLE FITYI SYLLABLE FIXYI SYLLABLE FIYI SYLLABL" +
	"E FIPYI SYLLABLE FATYI SYLLABLE FAXYI SYLLABLE FAYI SYLLABLE FAPYI SYLLA" +
	"BLE FOXYI SYLLABLE FOYI SYLLABLE FOPYI SYLLABLE FUTYI SYLLABLE FUXYI SYL" +
	"LABLE FUYI SYLLABLE FUPYI SYLLABLE FURXYI SYLLABLE FURYI SYLLABLE FYTYI " +
	"SYLLABLE FYXYI SYLLABLE FYYI SYLLABLE FYPYI SYLLABLE VITYI SYLLABLE VIXY" +
	"I SYLLABLE VIYI SYLLABLE VIPYI SYLLABLE VIETYI SYLLABLE VIEXYI SYLLABLE " +
	"VIEYI SYLLABLE VIEPYI SYLLABLE VATYI SYLLABLE VAXYI SYLLABLE VAYI SYLLAB" +
	"LE VAPYI SYLLABLE VOTYI SYLLABLE VOXYI SYLLABLE VOYI SYLLABLE VOPYI SYLL" +
	"ABLE VEXYI SYLLABLE VEPYI SYLLABLE VUTYI SYLLABLE VUXYI SYLLABLE VUYI SY" +
	"LLABLE VUPYI SYLLABLE VURXYI SYLLABLE VURYI SYLLABLE VYTYI SYLLABLE VYXY" +
	"I SYLLABLE VYYI SYLLABLE VYPYI SYLLABLE VYRXYI SYLLABLE VYRYI SYLLABLE D" +
	"ITYI SYLLABLE DIXYI SYLLABLE DIYI SYLLABLE DIPYI SYLLABLE DIEXYI SYLLABL" +
	"E DIEYI SYLLABLE DIEPYI SYLLABLE DATYI SYLLABLE DAXYI SYLLABLE DAYI SYLL" +
	"ABLE DAPYI SYLLABLE DUOXYI SYLLABLE DUOYI SYLLABLE DOTYI SYLLABLE DOXYI " +
	"SYLLABLE DOYI SYLLABLE DOPYI SYLLABLE DEXYI SYLLABLE DEYI SYLLABLE DEPYI" +
	" SYLLABLE DUTYI SYLLABLE DUXYI SYLLABLE DUYI SYLLABLE DUPYI SYLLABLE DUR" +
	"XYI SYLLABLE DURYI SYLLABLE TITYI SYLLABLE TIXYI SYLLABLE TIYI SYLLABLE " +
	"TIPYI SYLLABLE TIEXYI SYLLABLE TIEYI SYLLABLE TIEPYI SYLLABLE TATYI SYLL" +
	"ABLE TAXYI SYLLABLE TAYI SYLLABLE TAPYI SYLLABLE TUOTYI SYLLABLE TUOXYI " +
	"SYLLABLE TUOYI SYLLABLE TUOPYI SYLLABLE TOTYI SYLLABLE TOXYI SYLLABLE TO" +
	"YI SYLLABLE TOPYI SYLLABLE TEXYI SYLLABLE TEYI SYLLABLE TEPYI SYLLABLE T" +
	"UTYI SYLLABLE TUXYI SYLLABLE TUYI SYLLABLE TUPYI SYLLABLE TURXYI SYLLABL" +
	"E TURYI SYLLABLE DDITYI SYLLABLE DDIXYI SYLLABLE DDIYI SYLLABLE DDIPYI S" +
	"YLLABLE DDIEXYI SYLLABLE DDIEYI SYLLABLE DDIEPYI SYLLABLE DDATYI SYLLABL" +
	"E DDAXYI SYLLABLE DDAYI SYLLABLE DDAPYI SYLLABLE DDUOXYI SYLLABLE DDUOYI" +
	" SYLLABLE DDUOPYI SYLLABLE DDOTYI SYLLABLE DDOXYI SYLLABLE DDOYI SYLLABL" +
	"E DDOPYI SYLLABLE DDEXYI SYLLABLE DDEYI SYLLABLE DDEPYI SYLLABLE DDUTYI " +
	"SYLLABLE DDUXYI SYLLABLE DDUYI SYLLABLE DDUPYI SYLLABLE DDURXYI SYLLABLE" +
	" DDURYI SYLLABLE NDITYI SYLLABLE NDIXYI SYLLABLE NDIYI SYLLABLE NDIPYI S" +
	"YLLABLE NDIEXYI SYLLABLE NDIEYI SYLLABLE NDATYI SYLLABLE NDAXYI SYLLABLE" +
	" NDAYI SYLLABLE NDAPYI SYLLABLE NDOTYI SYLLABLE NDOXYI SYLLABLE NDOYI SY" +
	"LLABLE NDOPYI SYLLABLE NDEXYI SYLLABLE NDEYI SYLLABLE NDEPYI SYLLABLE ND" +
	"UTYI SYLLABLE NDUXYI SYLLABLE NDUYI SYLLABLE NDUPYI SYLLABLE NDURXYI SYL" +
	"LABLE NDURYI SYLLABLE HNITYI SYLLABLE HNIXYI SYLLABLE HNIYI SYLLABLE HNI" +
	"PYI SYLLABLE HNIETYI SYLLABLE HNIEXYI SYLLABLE HNIEYI SYLLABLE HNIEPYI S" +
	"YLLABLE HNATYI SYLLABLE HNAXYI SYLLABLE HNAYI SYLLABLE HNAPYI SYLLABLE H" +
	"NUOXYI SYLLABLE HNUOYI SYLLABLE HNOTYI SYLLABLE HNOXYI SYLLABLE HNOPYI S" +
	"YLLABLE HNEXYI SYLLABLE HNEYI SYLLABLE HNEPYI SYLLABLE HNUTYI SYLLABLE N" +
	"ITYI SYLLABLE NIXYI SYLLABLE NIYI SYLLABLE NIPYI SYLLABLE NIEXYI SYLLABL" +
	"E NIEYI SYLLABLE NIEPYI SYLLABLE NAXYI SYLLABLE NAYI SYLLABLE NAPYI SYLL" +
	"ABLE NUOXYI SYLLABLE NUOYI SYLLABLE NUOPYI SYLLABLE NOTYI SYLLABLE NOXYI" +
	" SYLLABLE NOYI SYLLABLE NOPYI SYLLABLE NEXYI SYLLABLE NEYI SYLLABLE NEPY" +
	"I SYLLABLE NUTYI SYLLABLE NUXYI SYLLABLE NUYI SYLLABLE NUPYI SYLLABLE NU" +
	"RXYI SYLLABLE NURYI SYLLABLE HLITYI SYLLABLE HLIXYI SYLLABLE HLIYI SYLLA" +
	"BLE HLIPYI SYLLABLE HLIEXYI SYLLABLE HLIEYI SYLLABLE HLIEPYI SYLLABLE HL" +
	"ATYI SYLLABLE HLAXYI SYLLABLE HLAYI SYLLABLE HLAPYI SYLLABLE HLUOXYI SYL" +
	"LABLE HLUOYI SYLLABLE HLUOPYI SYLLABLE HLOXYI SYLLABLE HLOYI SYLLABLE HL" +
	"OPYI SYLLABLE HLEXYI SYLLABLE HLEYI SYLLABLE HLEPYI SYLLABLE HLUTYI SYLL" +
	"ABLE HLUXYI SYLLABLE HLUYI SYLLABLE HLUPYI SYLLABLE HLURXYI SYLLABLE HLU" +
	"RYI SYLLABLE HLYTYI SYLLABLE HLYXYI SYLLABLE HLYYI SYLLABLE HLYPYI SYLLA" +
	"BLE HLYRXYI SYLLABLE HLYRYI SYLLABLE LITYI SYLLABLE LIXYI SYLLABLE LIYI " +
	"SYLLABLE LIPYI SYLLABLE LIETYI SYLLABLE LIEXYI SYLLABLE LIEYI SYLLABLE L" +
	"IEPYI SYLLABLE LATYI SYLLABLE LAXYI SYLLABLE LAYI SYLLABLE LAPYI SYLLABL" +
	"E LUOTYI SYLLABLE LUOXYI SYLLABLE LUOYI SYLLABLE LUOPYI SYLLABLE LOTYI S" +
	"YLLABLE LOXYI SYLLABLE LOYI SYLLABLE LOPYI SYLLABLE LEXYI SYLLABLE LEYI " +
	"SYLLABLE LEPYI SYLLABLE LUTYI SYLLABLE LUXYI SYLLABLE LUYI SYLLABLE LUPY" +
	"I SYLLABLE LURXYI SYLLABLE LURYI SYLLABLE LYTYI SYLLABLE LYXYI SYLLABLE " +
	"LYYI SYLLABLE LYPYI SYLLABLE LYRXYI SYLLABLE LYRYI SYLLABLE GITYI SYLLAB" +
	"LE GIXYI SYLLABLE GIYI SYLLABLE GIPYI SYLLABLE GIETYI SYLLABLE GIEXYI SY") + ("" +
	"LLABLE GIEYI SYLLABLE GIEPYI SYLLABLE GATYI SYLLABLE GAXYI SYLLABLE GAYI" +
	" SYLLABLE GAPYI SYLLABLE GUOTYI SYLLABLE GUOXYI SYLLABLE GUOYI SYLLABLE " +
	"GUOPYI SYLLABLE GOTYI SYLLABLE GOXYI SYLLABLE GOYI SYLLABLE GOPYI SYLLAB" +
	"LE GETYI SYLLABLE GEXYI SYLLABLE GEYI SYLLABLE GEPYI SYLLABLE GUTYI SYLL" +
	"ABLE GUXYI SYLLABLE GUYI SYLLABLE GUPYI SYLLABLE GURXYI SYLLABLE GURYI S" +
	"YLLABLE KITYI SYLLABLE KIXYI SYLLABLE KIYI SYLLABLE KIPYI SYLLABLE KIEXY" +
	"I SYLLABLE KIEYI SYLLABLE KIEPYI SYLLABLE KATYI SYLLABLE KAXYI SYLLABLE " +
	"KAYI SYLLABLE KAPYI SYLLABLE KUOXYI SYLLABLE KUOYI SYLLABLE KUOPYI SYLLA" +
	"BLE KOTYI SYLLABLE KOXYI SYLLABLE KOYI SYLLABLE KOPYI SYLLABLE KETYI SYL" +
	"LABLE KEXYI SYLLABLE KEYI SYLLABLE KEPYI SYLLABLE KUTYI SYLLABLE KUXYI S" +
	"YLLABLE KUYI SYLLABLE KUPYI SYLLABLE KURXYI SYLLABLE KURYI SYLLABLE GGIT" +
	"YI SYLLABLE GGIXYI SYLLABLE GGIYI SYLLABLE GGIEXYI SYLLABLE GGIEYI SYLLA" +
	"BLE GGIEPYI SYLLABLE GGATYI SYLLABLE GGAXYI SYLLABLE GGAYI SYLLABLE GGAP" +
	"YI SYLLABLE GGUOTYI SYLLABLE GGUOXYI SYLLABLE GGUOYI SYLLABLE GGUOPYI SY" +
	"LLABLE GGOTYI SYLLABLE GGOXYI SYLLABLE GGOYI SYLLABLE GGOPYI SYLLABLE GG" +
	"ETYI SYLLABLE GGEXYI SYLLABLE GGEYI SYLLABLE GGEPYI SYLLABLE GGUTYI SYLL" +
	"ABLE GGUXYI SYLLABLE GGUYI SYLLABLE GGUPYI SYLLABLE GGURXYI SYLLABLE GGU" +
	"RYI SYLLABLE MGIEXYI SYLLABLE MGIEYI SYLLABLE MGATYI SYLLABLE MGAXYI SYL" +
	"LABLE MGAYI SYLLABLE MGAPYI SYLLABLE MGUOXYI SYLLABLE MGUOYI SYLLABLE MG" +
	"UOPYI SYLLABLE MGOTYI SYLLABLE MGOXYI SYLLABLE MGOYI SYLLABLE MGOPYI SYL" +
	"LABLE MGEXYI SYLLABLE MGEYI SYLLABLE MGEPYI SYLLABLE MGUTYI SYLLABLE MGU" +
	"XYI SYLLABLE MGUYI SYLLABLE MGUPYI SYLLABLE MGURXYI SYLLABLE MGURYI SYLL" +
	"ABLE HXITYI SYLLABLE HXIXYI SYLLABLE HXIYI SYLLABLE HXIPYI SYLLABLE HXIE" +
	"TYI SYLLABLE HXIEXYI SYLLABLE HXIEYI SYLLABLE HXIEPYI SYLLABLE HXATYI SY" +
	"LLABLE HXAXYI SYLLABLE HXAYI SYLLABLE HXAPYI SYLLABLE HXUOTYI SYLLABLE H" +
	"XUOXYI SYLLABLE HXUOYI SYLLABLE HXUOPYI SYLLABLE HXOTYI SYLLABLE HXOXYI " +
	"SYLLABLE HXOYI SYLLABLE HXOPYI SYLLABLE HXEXYI SYLLABLE HXEYI SYLLABLE H" +
	"XEPYI SYLLABLE NGIEXYI SYLLABLE NGIEYI SYLLABLE NGIEPYI SYLLABLE NGATYI " +
	"SYLLABLE NGAXYI SYLLABLE NGAYI SYLLABLE NGAPYI SYLLABLE NGUOTYI SYLLABLE" +
	" NGUOXYI SYLLABLE NGUOYI SYLLABLE NGOTYI SYLLABLE NGOXYI SYLLABLE NGOYI " +
	"SYLLABLE NGOPYI SYLLABLE NGEXYI SYLLABLE NGEYI SYLLABLE NGEPYI SYLLABLE " +
	"HITYI SYLLABLE HIEXYI SYLLABLE HIEYI SYLLABLE HATYI SYLLABLE HAXYI SYLLA" +
	"BLE HAYI SYLLABLE HAPYI SYLLABLE HUOTYI SYLLABLE HUOXYI SYLLABLE HUOYI S" +
	"YLLABLE HUOPYI SYLLABLE HOTYI SYLLABLE HOXYI SYLLABLE HOYI SYLLABLE HOPY" +
	"I SYLLABLE HEXYI SYLLABLE HEYI SYLLABLE HEPYI SYLLABLE WATYI SYLLABLE WA" +
	"XYI SYLLABLE WAYI SYLLABLE WAPYI SYLLABLE WUOXYI SYLLABLE WUOYI SYLLABLE" +
	" WUOPYI SYLLABLE WOXYI SYLLABLE WOYI SYLLABLE WOPYI SYLLABLE WEXYI SYLLA" +
	"BLE WEYI SYLLABLE WEPYI SYLLABLE ZITYI SYLLABLE ZIXYI SYLLABLE ZIYI SYLL" +
	"ABLE ZIPYI SYLLABLE ZIEXYI SYLLABLE ZIEYI SYLLABLE ZIEPYI SYLLABLE ZATYI" +
	" SYLLABLE ZAXYI SYLLABLE ZAYI SYLLABLE ZAPYI SYLLABLE ZUOXYI SYLLABLE ZU" +
	"OYI SYLLABLE ZUOPYI SYLLABLE ZOTYI SYLLABLE ZOXYI SYLLABLE ZOYI SYLLABLE" +
	" ZOPYI SYLLABLE ZEXYI SYLLABLE ZEYI SYLLABLE ZEPYI SYLLABLE ZUTYI SYLLAB" +
	"LE ZUXYI SYLLABLE ZUYI SYLLABLE ZUPYI SYLLABLE ZURXYI SYLLABLE ZURYI SYL" +
	"LABLE ZYTYI SYLLABLE ZYXYI SYLLABLE ZYYI SYLLABLE ZYPYI SYLLABLE ZYRXYI " +
	"SYLLABLE ZYRYI SYLLABLE CITYI SYLLABLE CIXYI SYLLABLE CIYI SYLLABLE CIPY" +
	"I SYLLABLE CIETYI SYLLABLE CIEXYI SYLLABLE CIEYI SYLLABLE CIEPYI SYLLABL" +
	"E CATYI SYLLABLE CAXYI SYLLABLE CAYI SYLLABLE CAPYI SYLLABLE CUOXYI SYLL" +
	"ABLE CUOYI SYLLABLE CUOPYI SYLLABLE COTYI SYLLABLE COXYI SYLLABLE COYI S" +
	"YLLABLE COPYI SYLLABLE CEXYI SYLLABLE CEYI SYLLABLE CEPYI SYLLABLE CUTYI" +
	" SYLLABLE CUXYI SYLLABLE CUYI SYLLABLE CUPYI SYLLABLE CURXYI SYLLABLE CU" +
	"RYI SYLLABLE CYTYI SYLLABLE CYXYI SYLLABLE CYYI SYLLABLE CYPYI SYLLABLE " +
	"CYRXYI SYLLABLE CYRYI SYLLABLE ZZITYI SYLLABLE ZZIXYI SYLLABLE ZZIYI SYL" +
	"LABLE ZZIPYI SYLLABLE ZZIETYI SYLLABLE ZZIEXYI SYLLABLE ZZIEYI SYLLABLE " +
	"ZZIEPYI SYLLABLE ZZATYI SYLLABLE ZZAXYI SYLLABLE ZZAYI SYLLABLE ZZAPYI S" +
	"YLLABLE ZZOXYI SYLLABLE ZZOYI SYLLABLE ZZOPYI SYLLABLE ZZEXYI SYLLABLE Z" +
	"ZEYI SYLLABLE ZZEPYI SYLLABLE ZZUXYI SYLLABLE ZZUYI SYLLABLE ZZUPYI SYLL" +
	"ABLE ZZURXYI SYLLABLE ZZURYI SYLLABLE ZZYTYI SYLLABLE ZZYXYI SYLLABLE ZZ" +
	"YYI SYLLABLE ZZYPYI SYLLABLE ZZYRXYI SYLLABLE ZZYRYI SYLLABLE NZITYI SYL" +
	"LABLE NZIXYI SYLLABLE NZIYI SYLLABLE NZIPYI SYLLABLE NZIEXYI SYLLABLE NZ" +
	"IEYI SYLLABLE NZIEPYI SYLLABLE NZATYI SYLLABLE NZAXYI SYLLABLE NZAYI SYL" +
	"LABLE NZAPYI SYLLABLE NZUOXYI SYLLABLE NZUOYI SYLLABLE NZOXYI SYLLABLE N" +
	"ZOPYI SYLLABLE NZEXYI SYLLABLE NZEYI SYLLABLE NZUXYI SYLLABLE NZUYI SYLL" +
	"ABLE NZUPYI SYLLABLE NZURXYI SYLLABLE NZURYI SYLLABLE NZYTYI SYLLABLE NZ" +
	"YXYI SYLLABLE NZYYI SYLLABLE NZYPYI SYLLABLE NZYRXYI SYLLABLE NZYRYI SYL") + ("" +
	"LABLE SITYI SYLLABLE SIXYI SYLLABLE SIYI SYLLABLE SIPYI SYLLABLE SIEXYI " +
	"SYLLABLE SIEYI SYLLABLE SIEPYI SYLLABLE SATYI SYLLABLE SAXYI SYLLABLE SA" +
	"YI SYLLABLE SAPYI SYLLABLE SUOXYI SYLLABLE SUOYI SYLLABLE SUOPYI SYLLABL" +
	"E SOTYI SYLLABLE SOXYI SYLLABLE SOYI SYLLABLE SOPYI SYLLABLE SEXYI SYLLA" +
	"BLE SEYI SYLLABLE SEPYI SYLLABLE SUTYI SYLLABLE SUXYI SYLLABLE SUYI SYLL" +
	"ABLE SUPYI SYLLABLE SURXYI SYLLABLE SURYI SYLLABLE SYTYI SYLLABLE SYXYI " +
	"SYLLABLE SYYI SYLLABLE SYPYI SYLLABLE SYRXYI SYLLABLE SYRYI SYLLABLE SSI" +
	"TYI SYLLABLE SSIXYI SYLLABLE SSIYI SYLLABLE SSIPYI SYLLABLE SSIEXYI SYLL" +
	"ABLE SSIEYI SYLLABLE SSIEPYI SYLLABLE SSATYI SYLLABLE SSAXYI SYLLABLE SS" +
	"AYI SYLLABLE SSAPYI SYLLABLE SSOTYI SYLLABLE SSOXYI SYLLABLE SSOYI SYLLA" +
	"BLE SSOPYI SYLLABLE SSEXYI SYLLABLE SSEYI SYLLABLE SSEPYI SYLLABLE SSUTY" +
	"I SYLLABLE SSUXYI SYLLABLE SSUYI SYLLABLE SSUPYI SYLLABLE SSYTYI SYLLABL" +
	"E SSYXYI SYLLABLE SSYYI SYLLABLE SSYPYI SYLLABLE SSYRXYI SYLLABLE SSYRYI" +
	" SYLLABLE ZHATYI SYLLABLE ZHAXYI SYLLABLE ZHAYI SYLLABLE ZHAPYI SYLLABLE" +
	" ZHUOXYI SYLLABLE ZHUOYI SYLLABLE ZHUOPYI SYLLABLE ZHOTYI SYLLABLE ZHOXY" +
	"I SYLLABLE ZHOYI SYLLABLE ZHOPYI SYLLABLE ZHETYI SYLLABLE ZHEXYI SYLLABL" +
	"E ZHEYI SYLLABLE ZHEPYI SYLLABLE ZHUTYI SYLLABLE ZHUXYI SYLLABLE ZHUYI S" +
	"YLLABLE ZHUPYI SYLLABLE ZHURXYI SYLLABLE ZHURYI SYLLABLE ZHYTYI SYLLABLE" +
	" ZHYXYI SYLLABLE ZHYYI SYLLABLE ZHYPYI SYLLABLE ZHYRXYI SYLLABLE ZHYRYI " +
	"SYLLABLE CHATYI SYLLABLE CHAXYI SYLLABLE CHAYI SYLLABLE CHAPYI SYLLABLE " +
	"CHUOTYI SYLLABLE CHUOXYI SYLLABLE CHUOYI SYLLABLE CHUOPYI SYLLABLE CHOTY" +
	"I SYLLABLE CHOXYI SYLLABLE CHOYI SYLLABLE CHOPYI SYLLABLE CHETYI SYLLABL" +
	"E CHEXYI SYLLABLE CHEYI SYLLABLE CHEPYI SYLLABLE CHUXYI SYLLABLE CHUYI S" +
	"YLLABLE CHUPYI SYLLABLE CHURXYI SYLLABLE CHURYI SYLLABLE CHYTYI SYLLABLE" +
	" CHYXYI SYLLABLE CHYYI SYLLABLE CHYPYI SYLLABLE CHYRXYI SYLLABLE CHYRYI " +
	"SYLLABLE RRAXYI SYLLABLE RRAYI SYLLABLE RRUOXYI SYLLABLE RRUOYI SYLLABLE" +
	" RROTYI SYLLABLE RROXYI SYLLABLE RROYI SYLLABLE RROPYI SYLLABLE RRETYI S" +
	"YLLABLE RREXYI SYLLABLE RREYI SYLLABLE RREPYI SYLLABLE RRUTYI SYLLABLE R" +
	"RUXYI SYLLABLE RRUYI SYLLABLE RRUPYI SYLLABLE RRURXYI SYLLABLE RRURYI SY" +
	"LLABLE RRYTYI SYLLABLE RRYXYI SYLLABLE RRYYI SYLLABLE RRYPYI SYLLABLE RR" +
	"YRXYI SYLLABLE RRYRYI SYLLABLE NRATYI SYLLABLE NRAXYI SYLLABLE NRAYI SYL" +
	"LABLE NRAPYI SYLLABLE NROXYI SYLLABLE NROYI SYLLABLE NROPYI SYLLABLE NRE" +
	"TYI SYLLABLE NREXYI SYLLABLE NREYI SYLLABLE NREPYI SYLLABLE NRUTYI SYLLA" +
	"BLE NRUXYI SYLLABLE NRUYI SYLLABLE NRUPYI SYLLABLE NRURXYI SYLLABLE NRUR" +
	"YI SYLLABLE NRYTYI SYLLABLE NRYXYI SYLLABLE NRYYI SYLLABLE NRYPYI SYLLAB" +
	"LE NRYRXYI SYLLABLE NRYRYI SYLLABLE SHATYI SYLLABLE SHAXYI SYLLABLE SHAY" +
	"I SYLLABLE SHAPYI SYLLABLE SHUOXYI SYLLABLE SHUOYI SYLLABLE SHUOPYI SYLL" +
	"ABLE SHOTYI SYLLABLE SHOXYI SYLLABLE SHOYI SYLLABLE SHOPYI SYLLABLE SHET" +
	"YI SYLLABLE SHEXYI SYLLABLE SHEYI SYLLABLE SHEPYI SYLLABLE SHUTYI SYLLAB" +
	"LE SHUXYI SYLLABLE SHUYI SYLLABLE SHUPYI SYLLABLE SHURXYI SYLLABLE SHURY" +
	"I SYLLABLE SHYTYI SYLLABLE SHYXYI SYLLABLE SHYYI SYLLABLE SHYPYI SYLLABL" +
	"E SHYRXYI SYLLABLE SHYRYI SYLLABLE RATYI SYLLABLE RAXYI SYLLABLE RAYI SY" +
	"LLABLE RAPYI SYLLABLE RUOXYI SYLLABLE RUOYI SYLLABLE RUOPYI SYLLABLE ROT" +
	"YI SYLLABLE ROXYI SYLLABLE ROYI SYLLABLE ROPYI SYLLABLE REXYI SYLLABLE R" +
	"EYI SYLLABLE REPYI SYLLABLE RUTYI SYLLABLE RUXYI SYLLABLE RUYI SYLLABLE " +
	"RUPYI SYLLABLE RURXYI SYLLABLE RURYI SYLLABLE RYTYI SYLLABLE RYXYI SYLLA" +
	"BLE RYYI SYLLABLE RYPYI SYLLABLE RYRXYI SYLLABLE RYRYI SYLLABLE JITYI SY" +
	"LLABLE JIXYI SYLLABLE JIYI SYLLABLE JIPYI SYLLABLE JIETYI SYLLABLE JIEXY" +
	"I SYLLABLE JIEYI SYLLABLE JIEPYI SYLLABLE JUOTYI SYLLABLE JUOXYI SYLLABL" +
	"E JUOYI SYLLABLE JUOPYI SYLLABLE JOTYI SYLLABLE JOXYI SYLLABLE JOYI SYLL" +
	"ABLE JOPYI SYLLABLE JUTYI SYLLABLE JUXYI SYLLABLE JUYI SYLLABLE JUPYI SY" +
	"LLABLE JURXYI SYLLABLE JURYI SYLLABLE JYTYI SYLLABLE JYXYI SYLLABLE JYYI" +
	" SYLLABLE JYPYI SYLLABLE JYRXYI SYLLABLE JYRYI SYLLABLE QITYI SYLLABLE Q" +
	"IXYI SYLLABLE QIYI SYLLABLE QIPYI SYLLABLE QIETYI SYLLABLE QIEXYI SYLLAB" +
	"LE QIEYI SYLLABLE QIEPYI SYLLABLE QUOTYI SYLLABLE QUOXYI SYLLABLE QUOYI " +
	"SYLLABLE QUOPYI SYLLABLE QOTYI SYLLABLE QOXYI SYLLABLE QOYI SYLLABLE QOP" +
	"YI SYLLABLE QUTYI SYLLABLE QUXYI SYLLABLE QUYI SYLLABLE QUPYI SYLLABLE Q" +
	"URXYI SYLLABLE QURYI SYLLABLE QYTYI SYLLABLE QYXYI SYLLABLE QYYI SYLLABL" +
	"E QYPYI SYLLABLE QYRXYI SYLLABLE QYRYI SYLLABLE JJITYI SYLLABLE JJIXYI S" +
	"YLLABLE JJIYI SYLLABLE JJIPYI SYLLABLE JJIETYI SYLLABLE JJIEXYI SYLLABLE" +
	" JJIEYI SYLLABLE JJIEPYI SYLLABLE JJUOXYI SYLLABLE JJUOYI SYLLABLE JJUOP" +
	"YI SYLLABLE JJOTYI SYLLABLE JJOXYI SYLLABLE JJOYI SYLLABLE JJOPYI SYLLAB" +
	"LE JJUTYI SYLLABLE JJUXYI SYLLABLE JJUYI SYLLABLE JJUPYI SYLLABLE JJURXY" +
	"I SYLLABLE JJURYI SYLLABLE JJYTYI SYLLABLE JJYXYI SYLLABLE JJYYI SYLLABL") + ("" +
	"E JJYPYI SYLLABLE NJITYI SYLLABLE NJIXYI SYLLABLE NJIYI SYLLABLE NJIPYI " +
	"SYLLABLE NJIETYI SYLLABLE NJIEXYI SYLLABLE NJIEYI SYLLABLE NJIEPYI SYLLA" +
	"BLE NJUOXYI SYLLABLE NJUOYI SYLLABLE NJOTYI SYLLABLE NJOXYI SYLLABLE NJO" +
	"YI SYLLABLE NJOPYI SYLLABLE NJUXYI SYLLABLE NJUYI SYLLABLE NJUPYI SYLLAB" +
	"LE NJURXYI SYLLABLE NJURYI SYLLABLE NJYTYI SYLLABLE NJYXYI SYLLABLE NJYY" +
	"I SYLLABLE NJYPYI SYLLABLE NJYRXYI SYLLABLE NJYRYI SYLLABLE NYITYI SYLLA" +
	"BLE NYIXYI SYLLABLE NYIYI SYLLABLE NYIPYI SYLLABLE NYIETYI SYLLABLE NYIE" +
	"XYI SYLLABLE NYIEYI SYLLABLE NYIEPYI SYLLABLE NYUOXYI SYLLABLE NYUOYI SY" +
	"LLABLE NYUOPYI SYLLABLE NYOTYI SYLLABLE NYOXYI SYLLABLE NYOYI SYLLABLE N" +
	"YOPYI SYLLABLE NYUTYI SYLLABLE NYUXYI SYLLABLE NYUYI SYLLABLE NYUPYI SYL" +
	"LABLE XITYI SYLLABLE XIXYI SYLLABLE XIYI SYLLABLE XIPYI SYLLABLE XIETYI " +
	"SYLLABLE XIEXYI SYLLABLE XIEYI SYLLABLE XIEPYI SYLLABLE XUOXYI SYLLABLE " +
	"XUOYI SYLLABLE XOTYI SYLLABLE XOXYI SYLLABLE XOYI SYLLABLE XOPYI SYLLABL" +
	"E XYTYI SYLLABLE XYXYI SYLLABLE XYYI SYLLABLE XYPYI SYLLABLE XYRXYI SYLL" +
	"ABLE XYRYI SYLLABLE YITYI SYLLABLE YIXYI SYLLABLE YIYI SYLLABLE YIPYI SY" +
	"LLABLE YIETYI SYLLABLE YIEXYI SYLLABLE YIEYI SYLLABLE YIEPYI SYLLABLE YU" +
	"OTYI SYLLABLE YUOXYI SYLLABLE YUOYI SYLLABLE YUOPYI SYLLABLE YOTYI SYLLA" +
	"BLE YOXYI SYLLABLE YOYI SYLLABLE YOPYI SYLLABLE YUTYI SYLLABLE YUXYI SYL" +
	"LABLE YUYI SYLLABLE YUPYI SYLLABLE YURXYI SYLLABLE YURYI SYLLABLE YYTYI " +
	"SYLLABLE YYXYI SYLLABLE YYYI SYLLABLE YYPYI SYLLABLE YYRXYI SYLLABLE YYR" +
	"YI RADICAL QOTYI RADICAL LIYI RADICAL KITYI RADICAL NYIPYI RADICAL CYPYI" +
	" RADICAL SSIYI RADICAL GGOPYI RADICAL GEPYI RADICAL MIYI RADICAL HXITYI " +
	"RADICAL LYRYI RADICAL BBUTYI RADICAL MOPYI RADICAL YOYI RADICAL PUTYI RA" +
	"DICAL HXUOYI RADICAL TATYI RADICAL GAYI RADICAL ZUPYI RADICAL CYTYI RADI" +
	"CAL DDURYI RADICAL BURYI RADICAL GGUOYI RADICAL NYOPYI RADICAL TUYI RADI" +
	"CAL OPYI RADICAL JJUTYI RADICAL ZOTYI RADICAL PYTYI RADICAL HMOYI RADICA" +
	"L YITYI RADICAL VURYI RADICAL SHYYI RADICAL VEPYI RADICAL ZAYI RADICAL J" +
	"OYI RADICAL NZUPYI RADICAL JJYYI RADICAL GOTYI RADICAL JJIEYI RADICAL WO" +
	"YI RADICAL DUYI RADICAL SHURYI RADICAL LIEYI RADICAL CYYI RADICAL CUOPYI" +
	" RADICAL CIPYI RADICAL HXOPYI RADICAL SHATYI RADICAL ZURYI RADICAL SHOPY" +
	"I RADICAL CHEYI RADICAL ZZIETYI RADICAL NBIEYI RADICAL KELISU LETTER BAL" +
	"ISU LETTER PALISU LETTER PHALISU LETTER DALISU LETTER TALISU LETTER THAL" +
	"ISU LETTER GALISU LETTER KALISU LETTER KHALISU LETTER JALISU LETTER CALI" +
	"SU LETTER CHALISU LETTER DZALISU LETTER TSALISU LETTER TSHALISU LETTER M" +
	"ALISU LETTER NALISU LETTER LALISU LETTER SALISU LETTER ZHALISU LETTER ZA" +
	"LISU LETTER NGALISU LETTER HALISU LETTER XALISU LETTER HHALISU LETTER FA" +
	"LISU LETTER WALISU LETTER SHALISU LETTER YALISU LETTER GHALISU LETTER AL" +
	"ISU LETTER AELISU LETTER ELISU LETTER EULISU LETTER ILISU LETTER OLISU L" +
	"ETTER ULISU LETTER UELISU LETTER UHLISU LETTER OELISU LETTER TONE MYA TI" +
	"LISU LETTER TONE NA POLISU LETTER TONE MYA CYALISU LETTER TONE MYA BOLIS" +
	"U LETTER TONE MYA NALISU LETTER TONE MYA JEULISU PUNCTUATION COMMALISU P" +
	"UNCTUATION FULL STOPVAI SYLLABLE EEVAI SYLLABLE EENVAI SYLLABLE HEEVAI S" +
	"YLLABLE WEEVAI SYLLABLE WEENVAI SYLLABLE PEEVAI SYLLABLE BHEEVAI SYLLABL" +
	"E BEEVAI SYLLABLE MBEEVAI SYLLABLE KPEEVAI SYLLABLE MGBEEVAI SYLLABLE GB" +
	"EEVAI SYLLABLE FEEVAI SYLLABLE VEEVAI SYLLABLE TEEVAI SYLLABLE THEEVAI S" +
	"YLLABLE DHEEVAI SYLLABLE DHHEEVAI SYLLABLE LEEVAI SYLLABLE REEVAI SYLLAB" +
	"LE DEEVAI SYLLABLE NDEEVAI SYLLABLE SEEVAI SYLLABLE SHEEVAI SYLLABLE ZEE" +
	"VAI SYLLABLE ZHEEVAI SYLLABLE CEEVAI SYLLABLE JEEVAI SYLLABLE NJEEVAI SY" +
	"LLABLE YEEVAI SYLLABLE KEEVAI SYLLABLE NGGEEVAI SYLLABLE GEEVAI SYLLABLE" +
	" MEEVAI SYLLABLE NEEVAI SYLLABLE NYEEVAI SYLLABLE IVAI SYLLABLE INVAI SY" +
	"LLABLE HIVAI SYLLABLE HINVAI SYLLABLE WIVAI SYLLABLE WINVAI SYLLABLE PIV" +
	"AI SYLLABLE BHIVAI SYLLABLE BIVAI SYLLABLE MBIVAI SYLLABLE KPIVAI SYLLAB" +
	"LE MGBIVAI SYLLABLE GBIVAI SYLLABLE FIVAI SYLLABLE VIVAI SYLLABLE TIVAI " +
	"SYLLABLE THIVAI SYLLABLE DHIVAI SYLLABLE DHHIVAI SYLLABLE LIVAI SYLLABLE" +
	" RIVAI SYLLABLE DIVAI SYLLABLE NDIVAI SYLLABLE SIVAI SYLLABLE SHIVAI SYL" +
	"LABLE ZIVAI SYLLABLE ZHIVAI SYLLABLE CIVAI SYLLABLE JIVAI SYLLABLE NJIVA" +
	"I SYLLABLE YIVAI SYLLABLE KIVAI SYLLABLE NGGIVAI SYLLABLE GIVAI SYLLABLE" +
	" MIVAI SYLLABLE NIVAI SYLLABLE NYIVAI SYLLABLE AVAI SYLLABLE ANVAI SYLLA" +
	"BLE NGANVAI SYLLABLE HAVAI SYLLABLE HANVAI SYLLABLE WAVAI SYLLABLE WANVA" +
	"I SYLLABLE PAVAI SYLLABLE BHAVAI SYLLABLE BAVAI SYLLABLE MBAVAI SYLLABLE" +
	" KPAVAI SYLLABLE KPANVAI SYLLABLE MGBAVAI SYLLABLE GBAVAI SYLLABLE FAVAI" +
	" SYLLABLE VAVAI SYLLABLE TAVAI SYLLABLE THAVAI SYLLABLE DHAVAI SYLLABLE " +
	"DHHAVAI SYLLABLE LAVAI SYLLABLE RAVAI SYLLABLE DAVAI SYLLABLE NDAVAI SYL" +
	"LABLE SAVAI SYLLABLE SHAVAI SYLLABLE ZAVAI SYLLABLE ZHAVAI SYLLABLE CAVA") + ("" +
	"I SYLLABLE JAVAI SYLLABLE NJAVAI SYLLABLE YAVAI SYLLABLE KAVAI SYLLABLE " +
	"KANVAI SYLLABLE NGGAVAI SYLLABLE GAVAI SYLLABLE MAVAI SYLLABLE NAVAI SYL" +
	"LABLE NYAVAI SYLLABLE OOVAI SYLLABLE OONVAI SYLLABLE HOOVAI SYLLABLE WOO" +
	"VAI SYLLABLE WOONVAI SYLLABLE POOVAI SYLLABLE BHOOVAI SYLLABLE BOOVAI SY" +
	"LLABLE MBOOVAI SYLLABLE KPOOVAI SYLLABLE MGBOOVAI SYLLABLE GBOOVAI SYLLA" +
	"BLE FOOVAI SYLLABLE VOOVAI SYLLABLE TOOVAI SYLLABLE THOOVAI SYLLABLE DHO" +
	"OVAI SYLLABLE DHHOOVAI SYLLABLE LOOVAI SYLLABLE ROOVAI SYLLABLE DOOVAI S" +
	"YLLABLE NDOOVAI SYLLABLE SOOVAI SYLLABLE SHOOVAI SYLLABLE ZOOVAI SYLLABL" +
	"E ZHOOVAI SYLLABLE COOVAI SYLLABLE JOOVAI SYLLABLE NJOOVAI SYLLABLE YOOV" +
	"AI SYLLABLE KOOVAI SYLLABLE NGGOOVAI SYLLABLE GOOVAI SYLLABLE MOOVAI SYL" +
	"LABLE NOOVAI SYLLABLE NYOOVAI SYLLABLE UVAI SYLLABLE UNVAI SYLLABLE HUVA" +
	"I SYLLABLE HUNVAI SYLLABLE WUVAI SYLLABLE WUNVAI SYLLABLE PUVAI SYLLABLE" +
	" BHUVAI SYLLABLE BUVAI SYLLABLE MBUVAI SYLLABLE KPUVAI SYLLABLE MGBUVAI " +
	"SYLLABLE GBUVAI SYLLABLE FUVAI SYLLABLE VUVAI SYLLABLE TUVAI SYLLABLE TH" +
	"UVAI SYLLABLE DHUVAI SYLLABLE DHHUVAI SYLLABLE LUVAI SYLLABLE RUVAI SYLL" +
	"ABLE DUVAI SYLLABLE NDUVAI SYLLABLE SUVAI SYLLABLE SHUVAI SYLLABLE ZUVAI" +
	" SYLLABLE ZHUVAI SYLLABLE CUVAI SYLLABLE JUVAI SYLLABLE NJUVAI SYLLABLE " +
	"YUVAI SYLLABLE KUVAI SYLLABLE NGGUVAI SYLLABLE GUVAI SYLLABLE MUVAI SYLL" +
	"ABLE NUVAI SYLLABLE NYUVAI SYLLABLE OVAI SYLLABLE ONVAI SYLLABLE NGONVAI" +
	" SYLLABLE HOVAI SYLLABLE HONVAI SYLLABLE WOVAI SYLLABLE WONVAI SYLLABLE " +
	"POVAI SYLLABLE BHOVAI SYLLABLE BOVAI SYLLABLE MBOVAI SYLLABLE KPOVAI SYL" +
	"LABLE MGBOVAI SYLLABLE GBOVAI SYLLABLE GBONVAI SYLLABLE FOVAI SYLLABLE V" +
	"OVAI SYLLABLE TOVAI SYLLABLE THOVAI SYLLABLE DHOVAI SYLLABLE DHHOVAI SYL" +
	"LABLE LOVAI SYLLABLE ROVAI SYLLABLE DOVAI SYLLABLE NDOVAI SYLLABLE SOVAI" +
	" SYLLABLE SHOVAI SYLLABLE ZOVAI SYLLABLE ZHOVAI SYLLABLE COVAI SYLLABLE " +
	"JOVAI SYLLABLE NJOVAI SYLLABLE YOVAI SYLLABLE KOVAI SYLLABLE NGGOVAI SYL" +
	"LABLE GOVAI SYLLABLE MOVAI SYLLABLE NOVAI SYLLABLE NYOVAI SYLLABLE EVAI " +
	"SYLLABLE ENVAI SYLLABLE NGENVAI SYLLABLE HEVAI SYLLABLE HENVAI SYLLABLE " +
	"WEVAI SYLLABLE WENVAI SYLLABLE PEVAI SYLLABLE BHEVAI SYLLABLE BEVAI SYLL" +
	"ABLE MBEVAI SYLLABLE KPEVAI SYLLABLE KPENVAI SYLLABLE MGBEVAI SYLLABLE G" +
	"BEVAI SYLLABLE GBENVAI SYLLABLE FEVAI SYLLABLE VEVAI SYLLABLE TEVAI SYLL" +
	"ABLE THEVAI SYLLABLE DHEVAI SYLLABLE DHHEVAI SYLLABLE LEVAI SYLLABLE REV" +
	"AI SYLLABLE DEVAI SYLLABLE NDEVAI SYLLABLE SEVAI SYLLABLE SHEVAI SYLLABL" +
	"E ZEVAI SYLLABLE ZHEVAI SYLLABLE CEVAI SYLLABLE JEVAI SYLLABLE NJEVAI SY" +
	"LLABLE YEVAI SYLLABLE KEVAI SYLLABLE NGGEVAI SYLLABLE NGGENVAI SYLLABLE " +
	"GEVAI SYLLABLE GENVAI SYLLABLE MEVAI SYLLABLE NEVAI SYLLABLE NYEVAI SYLL" +
	"ABLE NGVAI SYLLABLE LENGTHENERVAI COMMAVAI FULL STOPVAI QUESTION MARKVAI" +
	" SYLLABLE NDOLE FAVAI SYLLABLE NDOLE KAVAI SYLLABLE NDOLE SOOVAI SYMBOL " +
	"FEENGVAI SYMBOL KEENGVAI SYMBOL TINGVAI SYMBOL NIIVAI SYMBOL BANGVAI SYM" +
	"BOL FAAVAI SYMBOL TAAVAI SYMBOL DANGVAI SYMBOL DOONGVAI SYMBOL KUNGVAI S" +
	"YMBOL TONGVAI SYMBOL DO-OVAI SYMBOL JONGVAI DIGIT ZEROVAI DIGIT ONEVAI D" +
	"IGIT TWOVAI DIGIT THREEVAI DIGIT FOURVAI DIGIT FIVEVAI DIGIT SIXVAI DIGI" +
	"T SEVENVAI DIGIT EIGHTVAI DIGIT NINEVAI SYLLABLE NDOLE MAVAI SYLLABLE ND" +
	"OLE DOCYRILLIC CAPITAL LETTER ZEMLYACYRILLIC SMALL LETTER ZEMLYACYRILLIC" +
	" CAPITAL LETTER DZELOCYRILLIC SMALL LETTER DZELOCYRILLIC CAPITAL LETTER " +
	"REVERSED DZECYRILLIC SMALL LETTER REVERSED DZECYRILLIC CAPITAL LETTER IO" +
	"TACYRILLIC SMALL LETTER IOTACYRILLIC CAPITAL LETTER DJERVCYRILLIC SMALL " +
	"LETTER DJERVCYRILLIC CAPITAL LETTER MONOGRAPH UKCYRILLIC SMALL LETTER MO" +
	"NOGRAPH UKCYRILLIC CAPITAL LETTER BROAD OMEGACYRILLIC SMALL LETTER BROAD" +
	" OMEGACYRILLIC CAPITAL LETTER NEUTRAL YERCYRILLIC SMALL LETTER NEUTRAL Y" +
	"ERCYRILLIC CAPITAL LETTER YERU WITH BACK YERCYRILLIC SMALL LETTER YERU W" +
	"ITH BACK YERCYRILLIC CAPITAL LETTER IOTIFIED YATCYRILLIC SMALL LETTER IO" +
	"TIFIED YATCYRILLIC CAPITAL LETTER REVERSED YUCYRILLIC SMALL LETTER REVER" +
	"SED YUCYRILLIC CAPITAL LETTER IOTIFIED ACYRILLIC SMALL LETTER IOTIFIED A" +
	"CYRILLIC CAPITAL LETTER CLOSED LITTLE YUSCYRILLIC SMALL LETTER CLOSED LI" +
	"TTLE YUSCYRILLIC CAPITAL LETTER BLENDED YUSCYRILLIC SMALL LETTER BLENDED" +
	" YUSCYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC SMALL LET" +
	"TER IOTIFIED CLOSED LITTLE YUSCYRILLIC CAPITAL LETTER YNCYRILLIC SMALL L" +
	"ETTER YNCYRILLIC CAPITAL LETTER REVERSED TSECYRILLIC SMALL LETTER REVERS" +
	"ED TSECYRILLIC CAPITAL LETTER SOFT DECYRILLIC SMALL LETTER SOFT DECYRILL" +
	"IC CAPITAL LETTER SOFT ELCYRILLIC SMALL LETTER SOFT ELCYRILLIC CAPITAL L" +
	"ETTER SOFT EMCYRILLIC SMALL LETTER SOFT EMCYRILLIC CAPITAL LETTER MONOCU" +
	"LAR OCYRILLIC SMALL LETTER MONOCULAR OCYRILLIC CAPITAL LETTER BINOCULAR " +
	"OCYRILLIC SMALL LETTER BINOCULAR OCYRILLIC CAPITAL LETTER DOUBLE MONOCUL") + ("" +
	"AR OCYRILLIC SMALL LETTER DOUBLE MONOCULAR OCYRILLIC LETTER MULTIOCULAR " +
	"OCOMBINING CYRILLIC VZMETCOMBINING CYRILLIC TEN MILLIONS SIGNCOMBINING C" +
	"YRILLIC HUNDRED MILLIONS SIGNCOMBINING CYRILLIC THOUSAND MILLIONS SIGNSL" +
	"AVONIC ASTERISKCOMBINING CYRILLIC LETTER UKRAINIAN IECOMBINING CYRILLIC " +
	"LETTER ICOMBINING CYRILLIC LETTER YICOMBINING CYRILLIC LETTER UCOMBINING" +
	" CYRILLIC LETTER HARD SIGNCOMBINING CYRILLIC LETTER YERUCOMBINING CYRILL" +
	"IC LETTER SOFT SIGNCOMBINING CYRILLIC LETTER OMEGACOMBINING CYRILLIC KAV" +
	"YKACOMBINING CYRILLIC PAYEROKCYRILLIC KAVYKACYRILLIC PAYEROKCYRILLIC CAP" +
	"ITAL LETTER DWECYRILLIC SMALL LETTER DWECYRILLIC CAPITAL LETTER DZWECYRI" +
	"LLIC SMALL LETTER DZWECYRILLIC CAPITAL LETTER ZHWECYRILLIC SMALL LETTER " +
	"ZHWECYRILLIC CAPITAL LETTER CCHECYRILLIC SMALL LETTER CCHECYRILLIC CAPIT" +
	"AL LETTER DZZECYRILLIC SMALL LETTER DZZECYRILLIC CAPITAL LETTER TE WITH " +
	"MIDDLE HOOKCYRILLIC SMALL LETTER TE WITH MIDDLE HOOKCYRILLIC CAPITAL LET" +
	"TER TWECYRILLIC SMALL LETTER TWECYRILLIC CAPITAL LETTER TSWECYRILLIC SMA" +
	"LL LETTER TSWECYRILLIC CAPITAL LETTER TSSECYRILLIC SMALL LETTER TSSECYRI" +
	"LLIC CAPITAL LETTER TCHECYRILLIC SMALL LETTER TCHECYRILLIC CAPITAL LETTE" +
	"R HWECYRILLIC SMALL LETTER HWECYRILLIC CAPITAL LETTER SHWECYRILLIC SMALL" +
	" LETTER SHWECYRILLIC CAPITAL LETTER DOUBLE OCYRILLIC SMALL LETTER DOUBLE" +
	" OCYRILLIC CAPITAL LETTER CROSSED OCYRILLIC SMALL LETTER CROSSED OMODIFI" +
	"ER LETTER CYRILLIC HARD SIGNMODIFIER LETTER CYRILLIC SOFT SIGNCOMBINING " +
	"CYRILLIC LETTER EFCOMBINING CYRILLIC LETTER IOTIFIED EBAMUM LETTER ABAMU" +
	"M LETTER KABAMUM LETTER UBAMUM LETTER KUBAMUM LETTER EEBAMUM LETTER REEB" +
	"AMUM LETTER TAEBAMUM LETTER OBAMUM LETTER NYIBAMUM LETTER IBAMUM LETTER " +
	"LABAMUM LETTER PABAMUM LETTER RIIBAMUM LETTER RIEEBAMUM LETTER LEEEEBAMU" +
	"M LETTER MEEEEBAMUM LETTER TAABAMUM LETTER NDAABAMUM LETTER NJAEMBAMUM L" +
	"ETTER MBAMUM LETTER SUUBAMUM LETTER MUBAMUM LETTER SHIIBAMUM LETTER SIBA" +
	"MUM LETTER SHEUXBAMUM LETTER SEUXBAMUM LETTER KYEEBAMUM LETTER KETBAMUM " +
	"LETTER NUAEBAMUM LETTER NUBAMUM LETTER NJUAEBAMUM LETTER YOQBAMUM LETTER" +
	" SHUBAMUM LETTER YUQBAMUM LETTER YABAMUM LETTER NSHABAMUM LETTER KEUXBAM" +
	"UM LETTER PEUXBAMUM LETTER NJEEBAMUM LETTER NTEEBAMUM LETTER PUEBAMUM LE" +
	"TTER WUEBAMUM LETTER PEEBAMUM LETTER FEEBAMUM LETTER RUBAMUM LETTER LUBA" +
	"MUM LETTER MIBAMUM LETTER NIBAMUM LETTER REUXBAMUM LETTER RAEBAMUM LETTE" +
	"R KENBAMUM LETTER NGKWAENBAMUM LETTER NGGABAMUM LETTER NGABAMUM LETTER S" +
	"HOBAMUM LETTER PUAEBAMUM LETTER FUBAMUM LETTER FOMBAMUM LETTER WABAMUM L" +
	"ETTER NABAMUM LETTER LIBAMUM LETTER PIBAMUM LETTER LOQBAMUM LETTER KOBAM" +
	"UM LETTER MBENBAMUM LETTER RENBAMUM LETTER MENBAMUM LETTER MABAMUM LETTE" +
	"R TIBAMUM LETTER KIBAMUM LETTER MOBAMUM LETTER MBAABAMUM LETTER TETBAMUM" +
	" LETTER KPABAMUM LETTER TENBAMUM LETTER NTUUBAMUM LETTER SAMBABAMUM LETT" +
	"ER FAAMAEBAMUM LETTER KOVUUBAMUM LETTER KOGHOMBAMUM COMBINING MARK KOQND" +
	"ONBAMUM COMBINING MARK TUKWENTISBAMUM NJAEMLIBAMUM FULL STOPBAMUM COLONB" +
	"AMUM COMMABAMUM SEMICOLONBAMUM QUESTION MARKMODIFIER LETTER CHINESE TONE" +
	" YIN PINGMODIFIER LETTER CHINESE TONE YANG PINGMODIFIER LETTER CHINESE T" +
	"ONE YIN SHANGMODIFIER LETTER CHINESE TONE YANG SHANGMODIFIER LETTER CHIN" +
	"ESE TONE YIN QUMODIFIER LETTER CHINESE TONE YANG QUMODIFIER LETTER CHINE" +
	"SE TONE YIN RUMODIFIER LETTER CHINESE TONE YANG RUMODIFIER LETTER EXTRA-" +
	"HIGH DOTTED TONE BARMODIFIER LETTER HIGH DOTTED TONE BARMODIFIER LETTER " +
	"MID DOTTED TONE BARMODIFIER LETTER LOW DOTTED TONE BARMODIFIER LETTER EX" +
	"TRA-LOW DOTTED TONE BARMODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE " +
	"BARMODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BARMODIFIER LETTER MID DOT" +
	"TED LEFT-STEM TONE BARMODIFIER LETTER LOW DOTTED LEFT-STEM TONE BARMODIF" +
	"IER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BARMODIFIER LETTER EXTRA-HIGH" +
	" LEFT-STEM TONE BARMODIFIER LETTER HIGH LEFT-STEM TONE BARMODIFIER LETTE" +
	"R MID LEFT-STEM TONE BARMODIFIER LETTER LOW LEFT-STEM TONE BARMODIFIER L" +
	"ETTER EXTRA-LOW LEFT-STEM TONE BARMODIFIER LETTER DOT VERTICAL BARMODIFI" +
	"ER LETTER DOT SLASHMODIFIER LETTER DOT HORIZONTAL BARMODIFIER LETTER LOW" +
	"ER RIGHT CORNER ANGLEMODIFIER LETTER RAISED UP ARROWMODIFIER LETTER RAIS" +
	"ED DOWN ARROWMODIFIER LETTER RAISED EXCLAMATION MARKMODIFIER LETTER RAIS" +
	"ED INVERTED EXCLAMATION MARKMODIFIER LETTER LOW INVERTED EXCLAMATION MAR" +
	"KMODIFIER LETTER STRESS AND HIGH TONEMODIFIER LETTER STRESS AND LOW TONE" +
	"LATIN CAPITAL LETTER EGYPTOLOGICAL ALEFLATIN SMALL LETTER EGYPTOLOGICAL " +
	"ALEFLATIN CAPITAL LETTER EGYPTOLOGICAL AINLATIN SMALL LETTER EGYPTOLOGIC" +
	"AL AINLATIN CAPITAL LETTER HENGLATIN SMALL LETTER HENGLATIN CAPITAL LETT" +
	"ER TZLATIN SMALL LETTER TZLATIN CAPITAL LETTER TRESILLOLATIN SMALL LETTE" +
	"R TRESILLOLATIN CAPITAL LETTER CUATRILLOLATIN SMALL LETTER CUATRILLOLATI") + ("" +
	"N CAPITAL LETTER CUATRILLO WITH COMMALATIN SMALL LETTER CUATRILLO WITH C" +
	"OMMALATIN LETTER SMALL CAPITAL FLATIN LETTER SMALL CAPITAL SLATIN CAPITA" +
	"L LETTER AALATIN SMALL LETTER AALATIN CAPITAL LETTER AOLATIN SMALL LETTE" +
	"R AOLATIN CAPITAL LETTER AULATIN SMALL LETTER AULATIN CAPITAL LETTER AVL" +
	"ATIN SMALL LETTER AVLATIN CAPITAL LETTER AV WITH HORIZONTAL BARLATIN SMA" +
	"LL LETTER AV WITH HORIZONTAL BARLATIN CAPITAL LETTER AYLATIN SMALL LETTE" +
	"R AYLATIN CAPITAL LETTER REVERSED C WITH DOTLATIN SMALL LETTER REVERSED " +
	"C WITH DOTLATIN CAPITAL LETTER K WITH STROKELATIN SMALL LETTER K WITH ST" +
	"ROKELATIN CAPITAL LETTER K WITH DIAGONAL STROKELATIN SMALL LETTER K WITH" +
	" DIAGONAL STROKELATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKELA" +
	"TIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKELATIN CAPITAL LETTER B" +
	"ROKEN LLATIN SMALL LETTER BROKEN LLATIN CAPITAL LETTER L WITH HIGH STROK" +
	"ELATIN SMALL LETTER L WITH HIGH STROKELATIN CAPITAL LETTER O WITH LONG S" +
	"TROKE OVERLAYLATIN SMALL LETTER O WITH LONG STROKE OVERLAYLATIN CAPITAL " +
	"LETTER O WITH LOOPLATIN SMALL LETTER O WITH LOOPLATIN CAPITAL LETTER OOL" +
	"ATIN SMALL LETTER OOLATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER" +
	"LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER P" +
	" WITH FLOURISHLATIN SMALL LETTER P WITH FLOURISHLATIN CAPITAL LETTER P W" +
	"ITH SQUIRREL TAILLATIN SMALL LETTER P WITH SQUIRREL TAILLATIN CAPITAL LE" +
	"TTER Q WITH STROKE THROUGH DESCENDERLATIN SMALL LETTER Q WITH STROKE THR" +
	"OUGH DESCENDERLATIN CAPITAL LETTER Q WITH DIAGONAL STROKELATIN SMALL LET" +
	"TER Q WITH DIAGONAL STROKELATIN CAPITAL LETTER R ROTUNDALATIN SMALL LETT" +
	"ER R ROTUNDALATIN CAPITAL LETTER RUM ROTUNDALATIN SMALL LETTER RUM ROTUN" +
	"DALATIN CAPITAL LETTER V WITH DIAGONAL STROKELATIN SMALL LETTER V WITH D" +
	"IAGONAL STROKELATIN CAPITAL LETTER VYLATIN SMALL LETTER VYLATIN CAPITAL " +
	"LETTER VISIGOTHIC ZLATIN SMALL LETTER VISIGOTHIC ZLATIN CAPITAL LETTER T" +
	"HORN WITH STROKELATIN SMALL LETTER THORN WITH STROKELATIN CAPITAL LETTER" +
	" THORN WITH STROKE THROUGH DESCENDERLATIN SMALL LETTER THORN WITH STROKE" +
	" THROUGH DESCENDERLATIN CAPITAL LETTER VENDLATIN SMALL LETTER VENDLATIN " +
	"CAPITAL LETTER ETLATIN SMALL LETTER ETLATIN CAPITAL LETTER ISLATIN SMALL" +
	" LETTER ISLATIN CAPITAL LETTER CONLATIN SMALL LETTER CONMODIFIER LETTER " +
	"USLATIN SMALL LETTER DUMLATIN SMALL LETTER LUMLATIN SMALL LETTER MUMLATI" +
	"N SMALL LETTER NUMLATIN SMALL LETTER RUMLATIN LETTER SMALL CAPITAL RUMLA" +
	"TIN SMALL LETTER TUMLATIN SMALL LETTER UMLATIN CAPITAL LETTER INSULAR DL" +
	"ATIN SMALL LETTER INSULAR DLATIN CAPITAL LETTER INSULAR FLATIN SMALL LET" +
	"TER INSULAR FLATIN CAPITAL LETTER INSULAR GLATIN CAPITAL LETTER TURNED I" +
	"NSULAR GLATIN SMALL LETTER TURNED INSULAR GLATIN CAPITAL LETTER TURNED L" +
	"LATIN SMALL LETTER TURNED LLATIN CAPITAL LETTER INSULAR RLATIN SMALL LET" +
	"TER INSULAR RLATIN CAPITAL LETTER INSULAR SLATIN SMALL LETTER INSULAR SL" +
	"ATIN CAPITAL LETTER INSULAR TLATIN SMALL LETTER INSULAR TMODIFIER LETTER" +
	" LOW CIRCUMFLEX ACCENTMODIFIER LETTER COLONMODIFIER LETTER SHORT EQUALS " +
	"SIGNLATIN CAPITAL LETTER SALTILLOLATIN SMALL LETTER SALTILLOLATIN CAPITA" +
	"L LETTER TURNED HLATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELTLATIN " +
	"LETTER SINOLOGICAL DOTLATIN CAPITAL LETTER N WITH DESCENDERLATIN SMALL L" +
	"ETTER N WITH DESCENDERLATIN CAPITAL LETTER C WITH BARLATIN SMALL LETTER " +
	"C WITH BARLATIN SMALL LETTER C WITH PALATAL HOOKLATIN SMALL LETTER H WIT" +
	"H PALATAL HOOKLATIN CAPITAL LETTER B WITH FLOURISHLATIN SMALL LETTER B W" +
	"ITH FLOURISHLATIN CAPITAL LETTER F WITH STROKELATIN SMALL LETTER F WITH " +
	"STROKELATIN CAPITAL LETTER VOLAPUK AELATIN SMALL LETTER VOLAPUK AELATIN " +
	"CAPITAL LETTER VOLAPUK OELATIN SMALL LETTER VOLAPUK OELATIN CAPITAL LETT" +
	"ER VOLAPUK UELATIN SMALL LETTER VOLAPUK UELATIN CAPITAL LETTER G WITH OB" +
	"LIQUE STROKELATIN SMALL LETTER G WITH OBLIQUE STROKELATIN CAPITAL LETTER" +
	" K WITH OBLIQUE STROKELATIN SMALL LETTER K WITH OBLIQUE STROKELATIN CAPI" +
	"TAL LETTER N WITH OBLIQUE STROKELATIN SMALL LETTER N WITH OBLIQUE STROKE" +
	"LATIN CAPITAL LETTER R WITH OBLIQUE STROKELATIN SMALL LETTER R WITH OBLI" +
	"QUE STROKELATIN CAPITAL LETTER S WITH OBLIQUE STROKELATIN SMALL LETTER S" +
	" WITH OBLIQUE STROKELATIN CAPITAL LETTER H WITH HOOKLATIN CAPITAL LETTER" +
	" REVERSED OPEN ELATIN CAPITAL LETTER SCRIPT GLATIN CAPITAL LETTER L WITH" +
	" BELTLATIN CAPITAL LETTER SMALL CAPITAL ILATIN LETTER SMALL CAPITAL QLAT" +
	"IN CAPITAL LETTER TURNED KLATIN CAPITAL LETTER TURNED TLATIN CAPITAL LET" +
	"TER J WITH CROSSED-TAILLATIN CAPITAL LETTER CHILATIN CAPITAL LETTER BETA" +
	"LATIN SMALL LETTER BETALATIN CAPITAL LETTER OMEGALATIN SMALL LETTER OMEG" +
	"ALATIN CAPITAL LETTER U WITH STROKELATIN SMALL LETTER U WITH STROKELATIN" +
	" EPIGRAPHIC LETTER SIDEWAYS IMODIFIER LETTER CAPITAL H WITH STROKEMODIFI") + ("" +
	"ER LETTER SMALL LIGATURE OELATIN LETTER SMALL CAPITAL TURNED MLATIN EPIG" +
	"RAPHIC LETTER REVERSED FLATIN EPIGRAPHIC LETTER REVERSED PLATIN EPIGRAPH" +
	"IC LETTER INVERTED MLATIN EPIGRAPHIC LETTER I LONGALATIN EPIGRAPHIC LETT" +
	"ER ARCHAIC MSYLOTI NAGRI LETTER ASYLOTI NAGRI LETTER ISYLOTI NAGRI SIGN " +
	"DVISVARASYLOTI NAGRI LETTER USYLOTI NAGRI LETTER ESYLOTI NAGRI LETTER OS" +
	"YLOTI NAGRI SIGN HASANTASYLOTI NAGRI LETTER KOSYLOTI NAGRI LETTER KHOSYL" +
	"OTI NAGRI LETTER GOSYLOTI NAGRI LETTER GHOSYLOTI NAGRI SIGN ANUSVARASYLO" +
	"TI NAGRI LETTER COSYLOTI NAGRI LETTER CHOSYLOTI NAGRI LETTER JOSYLOTI NA" +
	"GRI LETTER JHOSYLOTI NAGRI LETTER TTOSYLOTI NAGRI LETTER TTHOSYLOTI NAGR" +
	"I LETTER DDOSYLOTI NAGRI LETTER DDHOSYLOTI NAGRI LETTER TOSYLOTI NAGRI L" +
	"ETTER THOSYLOTI NAGRI LETTER DOSYLOTI NAGRI LETTER DHOSYLOTI NAGRI LETTE" +
	"R NOSYLOTI NAGRI LETTER POSYLOTI NAGRI LETTER PHOSYLOTI NAGRI LETTER BOS" +
	"YLOTI NAGRI LETTER BHOSYLOTI NAGRI LETTER MOSYLOTI NAGRI LETTER ROSYLOTI" +
	" NAGRI LETTER LOSYLOTI NAGRI LETTER RROSYLOTI NAGRI LETTER SOSYLOTI NAGR" +
	"I LETTER HOSYLOTI NAGRI VOWEL SIGN ASYLOTI NAGRI VOWEL SIGN ISYLOTI NAGR" +
	"I VOWEL SIGN USYLOTI NAGRI VOWEL SIGN ESYLOTI NAGRI VOWEL SIGN OOSYLOTI " +
	"NAGRI POETRY MARK-1SYLOTI NAGRI POETRY MARK-2SYLOTI NAGRI POETRY MARK-3S" +
	"YLOTI NAGRI POETRY MARK-4NORTH INDIC FRACTION ONE QUARTERNORTH INDIC FRA" +
	"CTION ONE HALFNORTH INDIC FRACTION THREE QUARTERSNORTH INDIC FRACTION ON" +
	"E SIXTEENTHNORTH INDIC FRACTION ONE EIGHTHNORTH INDIC FRACTION THREE SIX" +
	"TEENTHSNORTH INDIC QUARTER MARKNORTH INDIC PLACEHOLDER MARKNORTH INDIC R" +
	"UPEE MARKNORTH INDIC QUANTITY MARKPHAGS-PA LETTER KAPHAGS-PA LETTER KHAP" +
	"HAGS-PA LETTER GAPHAGS-PA LETTER NGAPHAGS-PA LETTER CAPHAGS-PA LETTER CH" +
	"APHAGS-PA LETTER JAPHAGS-PA LETTER NYAPHAGS-PA LETTER TAPHAGS-PA LETTER " +
	"THAPHAGS-PA LETTER DAPHAGS-PA LETTER NAPHAGS-PA LETTER PAPHAGS-PA LETTER" +
	" PHAPHAGS-PA LETTER BAPHAGS-PA LETTER MAPHAGS-PA LETTER TSAPHAGS-PA LETT" +
	"ER TSHAPHAGS-PA LETTER DZAPHAGS-PA LETTER WAPHAGS-PA LETTER ZHAPHAGS-PA " +
	"LETTER ZAPHAGS-PA LETTER SMALL APHAGS-PA LETTER YAPHAGS-PA LETTER RAPHAG" +
	"S-PA LETTER LAPHAGS-PA LETTER SHAPHAGS-PA LETTER SAPHAGS-PA LETTER HAPHA" +
	"GS-PA LETTER APHAGS-PA LETTER IPHAGS-PA LETTER UPHAGS-PA LETTER EPHAGS-P" +
	"A LETTER OPHAGS-PA LETTER QAPHAGS-PA LETTER XAPHAGS-PA LETTER FAPHAGS-PA" +
	" LETTER GGAPHAGS-PA LETTER EEPHAGS-PA SUBJOINED LETTER WAPHAGS-PA SUBJOI" +
	"NED LETTER YAPHAGS-PA LETTER TTAPHAGS-PA LETTER TTHAPHAGS-PA LETTER DDAP" +
	"HAGS-PA LETTER NNAPHAGS-PA LETTER ALTERNATE YAPHAGS-PA LETTER VOICELESS " +
	"SHAPHAGS-PA LETTER VOICED HAPHAGS-PA LETTER ASPIRATED FAPHAGS-PA SUBJOIN" +
	"ED LETTER RAPHAGS-PA SUPERFIXED LETTER RAPHAGS-PA LETTER CANDRABINDUPHAG" +
	"S-PA SINGLE HEAD MARKPHAGS-PA DOUBLE HEAD MARKPHAGS-PA MARK SHADPHAGS-PA" +
	" MARK DOUBLE SHADSAURASHTRA SIGN ANUSVARASAURASHTRA SIGN VISARGASAURASHT" +
	"RA LETTER ASAURASHTRA LETTER AASAURASHTRA LETTER ISAURASHTRA LETTER IISA" +
	"URASHTRA LETTER USAURASHTRA LETTER UUSAURASHTRA LETTER VOCALIC RSAURASHT" +
	"RA LETTER VOCALIC RRSAURASHTRA LETTER VOCALIC LSAURASHTRA LETTER VOCALIC" +
	" LLSAURASHTRA LETTER ESAURASHTRA LETTER EESAURASHTRA LETTER AISAURASHTRA" +
	" LETTER OSAURASHTRA LETTER OOSAURASHTRA LETTER AUSAURASHTRA LETTER KASAU" +
	"RASHTRA LETTER KHASAURASHTRA LETTER GASAURASHTRA LETTER GHASAURASHTRA LE" +
	"TTER NGASAURASHTRA LETTER CASAURASHTRA LETTER CHASAURASHTRA LETTER JASAU" +
	"RASHTRA LETTER JHASAURASHTRA LETTER NYASAURASHTRA LETTER TTASAURASHTRA L" +
	"ETTER TTHASAURASHTRA LETTER DDASAURASHTRA LETTER DDHASAURASHTRA LETTER N" +
	"NASAURASHTRA LETTER TASAURASHTRA LETTER THASAURASHTRA LETTER DASAURASHTR" +
	"A LETTER DHASAURASHTRA LETTER NASAURASHTRA LETTER PASAURASHTRA LETTER PH" +
	"ASAURASHTRA LETTER BASAURASHTRA LETTER BHASAURASHTRA LETTER MASAURASHTRA" +
	" LETTER YASAURASHTRA LETTER RASAURASHTRA LETTER LASAURASHTRA LETTER VASA" +
	"URASHTRA LETTER SHASAURASHTRA LETTER SSASAURASHTRA LETTER SASAURASHTRA L" +
	"ETTER HASAURASHTRA LETTER LLASAURASHTRA CONSONANT SIGN HAARUSAURASHTRA V" +
	"OWEL SIGN AASAURASHTRA VOWEL SIGN ISAURASHTRA VOWEL SIGN IISAURASHTRA VO" +
	"WEL SIGN USAURASHTRA VOWEL SIGN UUSAURASHTRA VOWEL SIGN VOCALIC RSAURASH" +
	"TRA VOWEL SIGN VOCALIC RRSAURASHTRA VOWEL SIGN VOCALIC LSAURASHTRA VOWEL" +
	" SIGN VOCALIC LLSAURASHTRA VOWEL SIGN ESAURASHTRA VOWEL SIGN EESAURASHTR" +
	"A VOWEL SIGN AISAURASHTRA VOWEL SIGN OSAURASHTRA VOWEL SIGN OOSAURASHTRA" +
	" VOWEL SIGN AUSAURASHTRA SIGN VIRAMASAURASHTRA SIGN CANDRABINDUSAURASHTR" +
	"A DANDASAURASHTRA DOUBLE DANDASAURASHTRA DIGIT ZEROSAURASHTRA DIGIT ONES" +
	"AURASHTRA DIGIT TWOSAURASHTRA DIGIT THREESAURASHTRA DIGIT FOURSAURASHTRA" +
	" DIGIT FIVESAURASHTRA DIGIT SIXSAURASHTRA DIGIT SEVENSAURASHTRA DIGIT EI" +
	"GHTSAURASHTRA DIGIT NINECOMBINING DEVANAGARI DIGIT ZEROCOMBINING DEVANAG" +
	"ARI DIGIT ONECOMBINING DEVANAGARI DIGIT TWOCOMBINING DEVANAGARI DIGIT TH") + ("" +
	"REECOMBINING DEVANAGARI DIGIT FOURCOMBINING DEVANAGARI DIGIT FIVECOMBINI" +
	"NG DEVANAGARI DIGIT SIXCOMBINING DEVANAGARI DIGIT SEVENCOMBINING DEVANAG" +
	"ARI DIGIT EIGHTCOMBINING DEVANAGARI DIGIT NINECOMBINING DEVANAGARI LETTE" +
	"R ACOMBINING DEVANAGARI LETTER UCOMBINING DEVANAGARI LETTER KACOMBINING " +
	"DEVANAGARI LETTER NACOMBINING DEVANAGARI LETTER PACOMBINING DEVANAGARI L" +
	"ETTER RACOMBINING DEVANAGARI LETTER VICOMBINING DEVANAGARI SIGN AVAGRAHA" +
	"DEVANAGARI SIGN SPACING CANDRABINDUDEVANAGARI SIGN CANDRABINDU VIRAMADEV" +
	"ANAGARI SIGN DOUBLE CANDRABINDU VIRAMADEVANAGARI SIGN CANDRABINDU TWODEV" +
	"ANAGARI SIGN CANDRABINDU THREEDEVANAGARI SIGN CANDRABINDU AVAGRAHADEVANA" +
	"GARI SIGN PUSHPIKADEVANAGARI GAP FILLERDEVANAGARI CARETDEVANAGARI HEADST" +
	"ROKEDEVANAGARI SIGN SIDDHAMDEVANAGARI JAIN OMDEVANAGARI LETTER AYDEVANAG" +
	"ARI VOWEL SIGN AYKAYAH LI DIGIT ZEROKAYAH LI DIGIT ONEKAYAH LI DIGIT TWO" +
	"KAYAH LI DIGIT THREEKAYAH LI DIGIT FOURKAYAH LI DIGIT FIVEKAYAH LI DIGIT" +
	" SIXKAYAH LI DIGIT SEVENKAYAH LI DIGIT EIGHTKAYAH LI DIGIT NINEKAYAH LI " +
	"LETTER KAKAYAH LI LETTER KHAKAYAH LI LETTER GAKAYAH LI LETTER NGAKAYAH L" +
	"I LETTER SAKAYAH LI LETTER SHAKAYAH LI LETTER ZAKAYAH LI LETTER NYAKAYAH" +
	" LI LETTER TAKAYAH LI LETTER HTAKAYAH LI LETTER NAKAYAH LI LETTER PAKAYA" +
	"H LI LETTER PHAKAYAH LI LETTER MAKAYAH LI LETTER DAKAYAH LI LETTER BAKAY" +
	"AH LI LETTER RAKAYAH LI LETTER YAKAYAH LI LETTER LAKAYAH LI LETTER WAKAY" +
	"AH LI LETTER THAKAYAH LI LETTER HAKAYAH LI LETTER VAKAYAH LI LETTER CAKA" +
	"YAH LI LETTER AKAYAH LI LETTER OEKAYAH LI LETTER IKAYAH LI LETTER OOKAYA" +
	"H LI VOWEL UEKAYAH LI VOWEL EKAYAH LI VOWEL UKAYAH LI VOWEL EEKAYAH LI V" +
	"OWEL OKAYAH LI TONE PLOPHUKAYAH LI TONE CALYAKAYAH LI TONE CALYA PLOPHUK" +
	"AYAH LI SIGN CWIKAYAH LI SIGN SHYAREJANG LETTER KAREJANG LETTER GAREJANG" +
	" LETTER NGAREJANG LETTER TAREJANG LETTER DAREJANG LETTER NAREJANG LETTER" +
	" PAREJANG LETTER BAREJANG LETTER MAREJANG LETTER CAREJANG LETTER JAREJAN" +
	"G LETTER NYAREJANG LETTER SAREJANG LETTER RAREJANG LETTER LAREJANG LETTE" +
	"R YAREJANG LETTER WAREJANG LETTER HAREJANG LETTER MBAREJANG LETTER NGGAR" +
	"EJANG LETTER NDAREJANG LETTER NYJAREJANG LETTER AREJANG VOWEL SIGN IREJA" +
	"NG VOWEL SIGN UREJANG VOWEL SIGN EREJANG VOWEL SIGN AIREJANG VOWEL SIGN " +
	"OREJANG VOWEL SIGN AUREJANG VOWEL SIGN EUREJANG VOWEL SIGN EAREJANG CONS" +
	"ONANT SIGN NGREJANG CONSONANT SIGN NREJANG CONSONANT SIGN RREJANG CONSON" +
	"ANT SIGN HREJANG VIRAMAREJANG SECTION MARKHANGUL CHOSEONG TIKEUT-MIEUMHA" +
	"NGUL CHOSEONG TIKEUT-PIEUPHANGUL CHOSEONG TIKEUT-SIOSHANGUL CHOSEONG TIK" +
	"EUT-CIEUCHANGUL CHOSEONG RIEUL-KIYEOKHANGUL CHOSEONG RIEUL-SSANGKIYEOKHA" +
	"NGUL CHOSEONG RIEUL-TIKEUTHANGUL CHOSEONG RIEUL-SSANGTIKEUTHANGUL CHOSEO" +
	"NG RIEUL-MIEUMHANGUL CHOSEONG RIEUL-PIEUPHANGUL CHOSEONG RIEUL-SSANGPIEU" +
	"PHANGUL CHOSEONG RIEUL-KAPYEOUNPIEUPHANGUL CHOSEONG RIEUL-SIOSHANGUL CHO" +
	"SEONG RIEUL-CIEUCHANGUL CHOSEONG RIEUL-KHIEUKHHANGUL CHOSEONG MIEUM-KIYE" +
	"OKHANGUL CHOSEONG MIEUM-TIKEUTHANGUL CHOSEONG MIEUM-SIOSHANGUL CHOSEONG " +
	"PIEUP-SIOS-THIEUTHHANGUL CHOSEONG PIEUP-KHIEUKHHANGUL CHOSEONG PIEUP-HIE" +
	"UHHANGUL CHOSEONG SSANGSIOS-PIEUPHANGUL CHOSEONG IEUNG-RIEULHANGUL CHOSE" +
	"ONG IEUNG-HIEUHHANGUL CHOSEONG SSANGCIEUC-HIEUHHANGUL CHOSEONG SSANGTHIE" +
	"UTHHANGUL CHOSEONG PHIEUPH-HIEUHHANGUL CHOSEONG HIEUH-SIOSHANGUL CHOSEON" +
	"G SSANGYEORINHIEUHJAVANESE SIGN PANYANGGAJAVANESE SIGN CECAKJAVANESE SIG" +
	"N LAYARJAVANESE SIGN WIGNYANJAVANESE LETTER AJAVANESE LETTER I KAWIJAVAN" +
	"ESE LETTER IJAVANESE LETTER IIJAVANESE LETTER UJAVANESE LETTER PA CEREKJ" +
	"AVANESE LETTER NGA LELETJAVANESE LETTER NGA LELET RASWADIJAVANESE LETTER" +
	" EJAVANESE LETTER AIJAVANESE LETTER OJAVANESE LETTER KAJAVANESE LETTER K" +
	"A SASAKJAVANESE LETTER KA MURDAJAVANESE LETTER GAJAVANESE LETTER GA MURD" +
	"AJAVANESE LETTER NGAJAVANESE LETTER CAJAVANESE LETTER CA MURDAJAVANESE L" +
	"ETTER JAJAVANESE LETTER NYA MURDAJAVANESE LETTER JA MAHAPRANAJAVANESE LE" +
	"TTER NYAJAVANESE LETTER TTAJAVANESE LETTER TTA MAHAPRANAJAVANESE LETTER " +
	"DDAJAVANESE LETTER DDA MAHAPRANAJAVANESE LETTER NA MURDAJAVANESE LETTER " +
	"TAJAVANESE LETTER TA MURDAJAVANESE LETTER DAJAVANESE LETTER DA MAHAPRANA" +
	"JAVANESE LETTER NAJAVANESE LETTER PAJAVANESE LETTER PA MURDAJAVANESE LET" +
	"TER BAJAVANESE LETTER BA MURDAJAVANESE LETTER MAJAVANESE LETTER YAJAVANE" +
	"SE LETTER RAJAVANESE LETTER RA AGUNGJAVANESE LETTER LAJAVANESE LETTER WA" +
	"JAVANESE LETTER SA MURDAJAVANESE LETTER SA MAHAPRANAJAVANESE LETTER SAJA" +
	"VANESE LETTER HAJAVANESE SIGN CECAK TELUJAVANESE VOWEL SIGN TARUNGJAVANE" +
	"SE VOWEL SIGN TOLONGJAVANESE VOWEL SIGN WULUJAVANESE VOWEL SIGN WULU MEL" +
	"IKJAVANESE VOWEL SIGN SUKUJAVANESE VOWEL SIGN SUKU MENDUTJAVANESE VOWEL " +
	"SIGN TALINGJAVANESE VOWEL SIGN DIRGA MUREJAVANESE VOWEL SIGN PEPETJAVANE" +
	"SE CONSONANT SIGN KERETJAVANESE CONSONANT SIGN PENGKALJAVANESE CONSONANT") + ("" +
	" SIGN CAKRAJAVANESE PANGKONJAVANESE LEFT RERENGGANJAVANESE RIGHT RERENGG" +
	"ANJAVANESE PADA ANDAPJAVANESE PADA MADYAJAVANESE PADA LUHURJAVANESE PADA" +
	" WINDUJAVANESE PADA PANGKATJAVANESE PADA LINGSAJAVANESE PADA LUNGSIJAVAN" +
	"ESE PADA ADEGJAVANESE PADA ADEG ADEGJAVANESE PADA PISELEHJAVANESE TURNED" +
	" PADA PISELEHJAVANESE PANGRANGKEPJAVANESE DIGIT ZEROJAVANESE DIGIT ONEJA" +
	"VANESE DIGIT TWOJAVANESE DIGIT THREEJAVANESE DIGIT FOURJAVANESE DIGIT FI" +
	"VEJAVANESE DIGIT SIXJAVANESE DIGIT SEVENJAVANESE DIGIT EIGHTJAVANESE DIG" +
	"IT NINEJAVANESE PADA TIRTA TUMETESJAVANESE PADA ISEN-ISENMYANMAR LETTER " +
	"SHAN GHAMYANMAR LETTER SHAN CHAMYANMAR LETTER SHAN JHAMYANMAR LETTER SHA" +
	"N NNAMYANMAR LETTER SHAN BHAMYANMAR SIGN SHAN SAWMYANMAR MODIFIER LETTER" +
	" SHAN REDUPLICATIONMYANMAR LETTER TAI LAING NYAMYANMAR LETTER TAI LAING " +
	"FAMYANMAR LETTER TAI LAING GAMYANMAR LETTER TAI LAING GHAMYANMAR LETTER " +
	"TAI LAING JAMYANMAR LETTER TAI LAING JHAMYANMAR LETTER TAI LAING DDAMYAN" +
	"MAR LETTER TAI LAING DDHAMYANMAR LETTER TAI LAING NNAMYANMAR TAI LAING D" +
	"IGIT ZEROMYANMAR TAI LAING DIGIT ONEMYANMAR TAI LAING DIGIT TWOMYANMAR T" +
	"AI LAING DIGIT THREEMYANMAR TAI LAING DIGIT FOURMYANMAR TAI LAING DIGIT " +
	"FIVEMYANMAR TAI LAING DIGIT SIXMYANMAR TAI LAING DIGIT SEVENMYANMAR TAI " +
	"LAING DIGIT EIGHTMYANMAR TAI LAING DIGIT NINEMYANMAR LETTER TAI LAING LL" +
	"AMYANMAR LETTER TAI LAING DAMYANMAR LETTER TAI LAING DHAMYANMAR LETTER T" +
	"AI LAING BAMYANMAR LETTER TAI LAING BHACHAM LETTER ACHAM LETTER ICHAM LE" +
	"TTER UCHAM LETTER ECHAM LETTER AICHAM LETTER OCHAM LETTER KACHAM LETTER " +
	"KHACHAM LETTER GACHAM LETTER GHACHAM LETTER NGUECHAM LETTER NGACHAM LETT" +
	"ER CHACHAM LETTER CHHACHAM LETTER JACHAM LETTER JHACHAM LETTER NHUECHAM " +
	"LETTER NHACHAM LETTER NHJACHAM LETTER TACHAM LETTER THACHAM LETTER DACHA" +
	"M LETTER DHACHAM LETTER NUECHAM LETTER NACHAM LETTER DDACHAM LETTER PACH" +
	"AM LETTER PPACHAM LETTER PHACHAM LETTER BACHAM LETTER BHACHAM LETTER MUE" +
	"CHAM LETTER MACHAM LETTER BBACHAM LETTER YACHAM LETTER RACHAM LETTER LAC" +
	"HAM LETTER VACHAM LETTER SSACHAM LETTER SACHAM LETTER HACHAM VOWEL SIGN " +
	"AACHAM VOWEL SIGN ICHAM VOWEL SIGN IICHAM VOWEL SIGN EICHAM VOWEL SIGN U" +
	"CHAM VOWEL SIGN OECHAM VOWEL SIGN OCHAM VOWEL SIGN AICHAM VOWEL SIGN AUC" +
	"HAM VOWEL SIGN UECHAM CONSONANT SIGN YACHAM CONSONANT SIGN RACHAM CONSON" +
	"ANT SIGN LACHAM CONSONANT SIGN WACHAM LETTER FINAL KCHAM LETTER FINAL GC" +
	"HAM LETTER FINAL NGCHAM CONSONANT SIGN FINAL NGCHAM LETTER FINAL CHCHAM " +
	"LETTER FINAL TCHAM LETTER FINAL NCHAM LETTER FINAL PCHAM LETTER FINAL YC" +
	"HAM LETTER FINAL RCHAM LETTER FINAL LCHAM LETTER FINAL SSCHAM CONSONANT " +
	"SIGN FINAL MCHAM CONSONANT SIGN FINAL HCHAM DIGIT ZEROCHAM DIGIT ONECHAM" +
	" DIGIT TWOCHAM DIGIT THREECHAM DIGIT FOURCHAM DIGIT FIVECHAM DIGIT SIXCH" +
	"AM DIGIT SEVENCHAM DIGIT EIGHTCHAM DIGIT NINECHAM PUNCTUATION SPIRALCHAM" +
	" PUNCTUATION DANDACHAM PUNCTUATION DOUBLE DANDACHAM PUNCTUATION TRIPLE D" +
	"ANDAMYANMAR LETTER KHAMTI GAMYANMAR LETTER KHAMTI CAMYANMAR LETTER KHAMT" +
	"I CHAMYANMAR LETTER KHAMTI JAMYANMAR LETTER KHAMTI JHAMYANMAR LETTER KHA" +
	"MTI NYAMYANMAR LETTER KHAMTI TTAMYANMAR LETTER KHAMTI TTHAMYANMAR LETTER" +
	" KHAMTI DDAMYANMAR LETTER KHAMTI DDHAMYANMAR LETTER KHAMTI DHAMYANMAR LE" +
	"TTER KHAMTI NAMYANMAR LETTER KHAMTI SAMYANMAR LETTER KHAMTI HAMYANMAR LE" +
	"TTER KHAMTI HHAMYANMAR LETTER KHAMTI FAMYANMAR MODIFIER LETTER KHAMTI RE" +
	"DUPLICATIONMYANMAR LETTER KHAMTI XAMYANMAR LETTER KHAMTI ZAMYANMAR LETTE" +
	"R KHAMTI RAMYANMAR LOGOGRAM KHAMTI OAYMYANMAR LOGOGRAM KHAMTI QNMYANMAR " +
	"LOGOGRAM KHAMTI HMMYANMAR SYMBOL AITON EXCLAMATIONMYANMAR SYMBOL AITON O" +
	"NEMYANMAR SYMBOL AITON TWOMYANMAR LETTER AITON RAMYANMAR SIGN PAO KAREN " +
	"TONEMYANMAR SIGN TAI LAING TONE-2MYANMAR SIGN TAI LAING TONE-5MYANMAR LE" +
	"TTER SHWE PALAUNG CHAMYANMAR LETTER SHWE PALAUNG SHATAI VIET LETTER LOW " +
	"KOTAI VIET LETTER HIGH KOTAI VIET LETTER LOW KHOTAI VIET LETTER HIGH KHO" +
	"TAI VIET LETTER LOW KHHOTAI VIET LETTER HIGH KHHOTAI VIET LETTER LOW GOT" +
	"AI VIET LETTER HIGH GOTAI VIET LETTER LOW NGOTAI VIET LETTER HIGH NGOTAI" +
	" VIET LETTER LOW COTAI VIET LETTER HIGH COTAI VIET LETTER LOW CHOTAI VIE" +
	"T LETTER HIGH CHOTAI VIET LETTER LOW SOTAI VIET LETTER HIGH SOTAI VIET L" +
	"ETTER LOW NYOTAI VIET LETTER HIGH NYOTAI VIET LETTER LOW DOTAI VIET LETT" +
	"ER HIGH DOTAI VIET LETTER LOW TOTAI VIET LETTER HIGH TOTAI VIET LETTER L" +
	"OW THOTAI VIET LETTER HIGH THOTAI VIET LETTER LOW NOTAI VIET LETTER HIGH" +
	" NOTAI VIET LETTER LOW BOTAI VIET LETTER HIGH BOTAI VIET LETTER LOW POTA" +
	"I VIET LETTER HIGH POTAI VIET LETTER LOW PHOTAI VIET LETTER HIGH PHOTAI " +
	"VIET LETTER LOW FOTAI VIET LETTER HIGH FOTAI VIET LETTER LOW MOTAI VIET " +
	"LETTER HIGH MOTAI VIET LETTER LOW YOTAI VIET LETTER HIGH YOTAI VIET LETT" +
	"ER LOW ROTAI VIET LETTER HIGH ROTAI VIET LETTER LOW LOTAI VIET LETTER HI") + ("" +
	"GH LOTAI VIET LETTER LOW VOTAI VIET LETTER HIGH VOTAI VIET LETTER LOW HO" +
	"TAI VIET LETTER HIGH HOTAI VIET LETTER LOW OTAI VIET LETTER HIGH OTAI VI" +
	"ET MAI KANGTAI VIET VOWEL AATAI VIET VOWEL ITAI VIET VOWEL UETAI VIET VO" +
	"WEL UTAI VIET VOWEL ETAI VIET VOWEL OTAI VIET MAI KHITTAI VIET VOWEL IAT" +
	"AI VIET VOWEL UEATAI VIET VOWEL UATAI VIET VOWEL AUETAI VIET VOWEL AYTAI" +
	" VIET VOWEL ANTAI VIET VOWEL AMTAI VIET TONE MAI EKTAI VIET TONE MAI NUE" +
	"NGTAI VIET TONE MAI THOTAI VIET TONE MAI SONGTAI VIET SYMBOL KONTAI VIET" +
	" SYMBOL NUENGTAI VIET SYMBOL SAMTAI VIET SYMBOL HO HOITAI VIET SYMBOL KO" +
	"I KOIMEETEI MAYEK LETTER EMEETEI MAYEK LETTER OMEETEI MAYEK LETTER CHAME" +
	"ETEI MAYEK LETTER NYAMEETEI MAYEK LETTER TTAMEETEI MAYEK LETTER TTHAMEET" +
	"EI MAYEK LETTER DDAMEETEI MAYEK LETTER DDHAMEETEI MAYEK LETTER NNAMEETEI" +
	" MAYEK LETTER SHAMEETEI MAYEK LETTER SSAMEETEI MAYEK VOWEL SIGN IIMEETEI" +
	" MAYEK VOWEL SIGN UUMEETEI MAYEK VOWEL SIGN AAIMEETEI MAYEK VOWEL SIGN A" +
	"UMEETEI MAYEK VOWEL SIGN AAUMEETEI MAYEK CHEIKHANMEETEI MAYEK AHANG KHUD" +
	"AMMEETEI MAYEK ANJIMEETEI MAYEK SYLLABLE REPETITION MARKMEETEI MAYEK WOR" +
	"D REPETITION MARKMEETEI MAYEK VOWEL SIGN VISARGAMEETEI MAYEK VIRAMAETHIO" +
	"PIC SYLLABLE TTHUETHIOPIC SYLLABLE TTHIETHIOPIC SYLLABLE TTHAAETHIOPIC S" +
	"YLLABLE TTHEEETHIOPIC SYLLABLE TTHEETHIOPIC SYLLABLE TTHOETHIOPIC SYLLAB" +
	"LE DDHUETHIOPIC SYLLABLE DDHIETHIOPIC SYLLABLE DDHAAETHIOPIC SYLLABLE DD" +
	"HEEETHIOPIC SYLLABLE DDHEETHIOPIC SYLLABLE DDHOETHIOPIC SYLLABLE DZUETHI" +
	"OPIC SYLLABLE DZIETHIOPIC SYLLABLE DZAAETHIOPIC SYLLABLE DZEEETHIOPIC SY" +
	"LLABLE DZEETHIOPIC SYLLABLE DZOETHIOPIC SYLLABLE CCHHAETHIOPIC SYLLABLE " +
	"CCHHUETHIOPIC SYLLABLE CCHHIETHIOPIC SYLLABLE CCHHAAETHIOPIC SYLLABLE CC" +
	"HHEEETHIOPIC SYLLABLE CCHHEETHIOPIC SYLLABLE CCHHOETHIOPIC SYLLABLE BBAE" +
	"THIOPIC SYLLABLE BBUETHIOPIC SYLLABLE BBIETHIOPIC SYLLABLE BBAAETHIOPIC " +
	"SYLLABLE BBEEETHIOPIC SYLLABLE BBEETHIOPIC SYLLABLE BBOLATIN SMALL LETTE" +
	"R BARRED ALPHALATIN SMALL LETTER A REVERSED-SCHWALATIN SMALL LETTER BLAC" +
	"KLETTER ELATIN SMALL LETTER BARRED ELATIN SMALL LETTER E WITH FLOURISHLA" +
	"TIN SMALL LETTER LENIS FLATIN SMALL LETTER SCRIPT G WITH CROSSED-TAILLAT" +
	"IN SMALL LETTER L WITH INVERTED LAZY SLATIN SMALL LETTER L WITH DOUBLE M" +
	"IDDLE TILDELATIN SMALL LETTER L WITH MIDDLE RINGLATIN SMALL LETTER M WIT" +
	"H CROSSED-TAILLATIN SMALL LETTER N WITH CROSSED-TAILLATIN SMALL LETTER E" +
	"NG WITH CROSSED-TAILLATIN SMALL LETTER BLACKLETTER OLATIN SMALL LETTER B" +
	"LACKLETTER O WITH STROKELATIN SMALL LETTER OPEN O WITH STROKELATIN SMALL" +
	" LETTER INVERTED OELATIN SMALL LETTER TURNED OE WITH STROKELATIN SMALL L" +
	"ETTER TURNED OE WITH HORIZONTAL STROKELATIN SMALL LETTER TURNED O OPEN-O" +
	"LATIN SMALL LETTER TURNED O OPEN-O WITH STROKELATIN SMALL LETTER STIRRUP" +
	" RLATIN LETTER SMALL CAPITAL R WITH RIGHT LEGLATIN SMALL LETTER R WITHOU" +
	"T HANDLELATIN SMALL LETTER DOUBLE RLATIN SMALL LETTER R WITH CROSSED-TAI" +
	"LLATIN SMALL LETTER DOUBLE R WITH CROSSED-TAILLATIN SMALL LETTER SCRIPT " +
	"RLATIN SMALL LETTER SCRIPT R WITH RINGLATIN SMALL LETTER BASELINE ESHLAT" +
	"IN SMALL LETTER U WITH SHORT RIGHT LEGLATIN SMALL LETTER U BAR WITH SHOR" +
	"T RIGHT LEGLATIN SMALL LETTER UILATIN SMALL LETTER TURNED UILATIN SMALL " +
	"LETTER U WITH LEFT HOOKLATIN SMALL LETTER CHILATIN SMALL LETTER CHI WITH" +
	" LOW RIGHT RINGLATIN SMALL LETTER CHI WITH LOW LEFT SERIFLATIN SMALL LET" +
	"TER X WITH LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG LEFT LEGLATIN SM" +
	"ALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RINGLATIN SMALL LETTER X W" +
	"ITH LONG LEFT LEG WITH SERIFLATIN SMALL LETTER Y WITH SHORT RIGHT LEGMOD" +
	"IFIER BREVE WITH INVERTED BREVEMODIFIER LETTER SMALL HENGMODIFIER LETTER" +
	" SMALL L WITH INVERTED LAZY SMODIFIER LETTER SMALL L WITH MIDDLE TILDEMO" +
	"DIFIER LETTER SMALL U WITH LEFT HOOKLATIN SMALL LETTER SAKHA YATLATIN SM" +
	"ALL LETTER IOTIFIED ELATIN SMALL LETTER OPEN OELATIN SMALL LETTER UOLATI" +
	"N SMALL LETTER INVERTED ALPHAGREEK LETTER SMALL CAPITAL OMEGACHEROKEE SM" +
	"ALL LETTER ACHEROKEE SMALL LETTER ECHEROKEE SMALL LETTER ICHEROKEE SMALL" +
	" LETTER OCHEROKEE SMALL LETTER UCHEROKEE SMALL LETTER VCHEROKEE SMALL LE" +
	"TTER GACHEROKEE SMALL LETTER KACHEROKEE SMALL LETTER GECHEROKEE SMALL LE" +
	"TTER GICHEROKEE SMALL LETTER GOCHEROKEE SMALL LETTER GUCHEROKEE SMALL LE" +
	"TTER GVCHEROKEE SMALL LETTER HACHEROKEE SMALL LETTER HECHEROKEE SMALL LE" +
	"TTER HICHEROKEE SMALL LETTER HOCHEROKEE SMALL LETTER HUCHEROKEE SMALL LE" +
	"TTER HVCHEROKEE SMALL LETTER LACHEROKEE SMALL LETTER LECHEROKEE SMALL LE" +
	"TTER LICHEROKEE SMALL LETTER LOCHEROKEE SMALL LETTER LUCHEROKEE SMALL LE" +
	"TTER LVCHEROKEE SMALL LETTER MACHEROKEE SMALL LETTER MECHEROKEE SMALL LE" +
	"TTER MICHEROKEE SMALL LETTER MOCHEROKEE SMALL LETTER MUCHEROKEE SMALL LE" +
	"TTER NACHEROKEE SMALL LETTER HNACHEROKEE SMALL LETTER NAHCHEROKEE SMALL ") + ("" +
	"LETTER NECHEROKEE SMALL LETTER NICHEROKEE SMALL LETTER NOCHEROKEE SMALL " +
	"LETTER NUCHEROKEE SMALL LETTER NVCHEROKEE SMALL LETTER QUACHEROKEE SMALL" +
	" LETTER QUECHEROKEE SMALL LETTER QUICHEROKEE SMALL LETTER QUOCHEROKEE SM" +
	"ALL LETTER QUUCHEROKEE SMALL LETTER QUVCHEROKEE SMALL LETTER SACHEROKEE " +
	"SMALL LETTER SCHEROKEE SMALL LETTER SECHEROKEE SMALL LETTER SICHEROKEE S" +
	"MALL LETTER SOCHEROKEE SMALL LETTER SUCHEROKEE SMALL LETTER SVCHEROKEE S" +
	"MALL LETTER DACHEROKEE SMALL LETTER TACHEROKEE SMALL LETTER DECHEROKEE S" +
	"MALL LETTER TECHEROKEE SMALL LETTER DICHEROKEE SMALL LETTER TICHEROKEE S" +
	"MALL LETTER DOCHEROKEE SMALL LETTER DUCHEROKEE SMALL LETTER DVCHEROKEE S" +
	"MALL LETTER DLACHEROKEE SMALL LETTER TLACHEROKEE SMALL LETTER TLECHEROKE" +
	"E SMALL LETTER TLICHEROKEE SMALL LETTER TLOCHEROKEE SMALL LETTER TLUCHER" +
	"OKEE SMALL LETTER TLVCHEROKEE SMALL LETTER TSACHEROKEE SMALL LETTER TSEC" +
	"HEROKEE SMALL LETTER TSICHEROKEE SMALL LETTER TSOCHEROKEE SMALL LETTER T" +
	"SUCHEROKEE SMALL LETTER TSVCHEROKEE SMALL LETTER WACHEROKEE SMALL LETTER" +
	" WECHEROKEE SMALL LETTER WICHEROKEE SMALL LETTER WOCHEROKEE SMALL LETTER" +
	" WUCHEROKEE SMALL LETTER WVCHEROKEE SMALL LETTER YAMEETEI MAYEK LETTER K" +
	"OKMEETEI MAYEK LETTER SAMMEETEI MAYEK LETTER LAIMEETEI MAYEK LETTER MITM" +
	"EETEI MAYEK LETTER PAMEETEI MAYEK LETTER NAMEETEI MAYEK LETTER CHILMEETE" +
	"I MAYEK LETTER TILMEETEI MAYEK LETTER KHOUMEETEI MAYEK LETTER NGOUMEETEI" +
	" MAYEK LETTER THOUMEETEI MAYEK LETTER WAIMEETEI MAYEK LETTER YANGMEETEI " +
	"MAYEK LETTER HUKMEETEI MAYEK LETTER UNMEETEI MAYEK LETTER IMEETEI MAYEK " +
	"LETTER PHAMMEETEI MAYEK LETTER ATIYAMEETEI MAYEK LETTER GOKMEETEI MAYEK " +
	"LETTER JHAMMEETEI MAYEK LETTER RAIMEETEI MAYEK LETTER BAMEETEI MAYEK LET" +
	"TER JILMEETEI MAYEK LETTER DILMEETEI MAYEK LETTER GHOUMEETEI MAYEK LETTE" +
	"R DHOUMEETEI MAYEK LETTER BHAMMEETEI MAYEK LETTER KOK LONSUMMEETEI MAYEK" +
	" LETTER LAI LONSUMMEETEI MAYEK LETTER MIT LONSUMMEETEI MAYEK LETTER PA L" +
	"ONSUMMEETEI MAYEK LETTER NA LONSUMMEETEI MAYEK LETTER TIL LONSUMMEETEI M" +
	"AYEK LETTER NGOU LONSUMMEETEI MAYEK LETTER I LONSUMMEETEI MAYEK VOWEL SI" +
	"GN ONAPMEETEI MAYEK VOWEL SIGN INAPMEETEI MAYEK VOWEL SIGN ANAPMEETEI MA" +
	"YEK VOWEL SIGN YENAPMEETEI MAYEK VOWEL SIGN SOUNAPMEETEI MAYEK VOWEL SIG" +
	"N UNAPMEETEI MAYEK VOWEL SIGN CHEINAPMEETEI MAYEK VOWEL SIGN NUNGMEETEI " +
	"MAYEK CHEIKHEIMEETEI MAYEK LUM IYEKMEETEI MAYEK APUN IYEKMEETEI MAYEK DI" +
	"GIT ZEROMEETEI MAYEK DIGIT ONEMEETEI MAYEK DIGIT TWOMEETEI MAYEK DIGIT T" +
	"HREEMEETEI MAYEK DIGIT FOURMEETEI MAYEK DIGIT FIVEMEETEI MAYEK DIGIT SIX" +
	"MEETEI MAYEK DIGIT SEVENMEETEI MAYEK DIGIT EIGHTMEETEI MAYEK DIGIT NINEH" +
	"ANGUL JUNGSEONG O-YEOHANGUL JUNGSEONG O-O-IHANGUL JUNGSEONG YO-AHANGUL J" +
	"UNGSEONG YO-AEHANGUL JUNGSEONG YO-EOHANGUL JUNGSEONG U-YEOHANGUL JUNGSEO" +
	"NG U-I-IHANGUL JUNGSEONG YU-AEHANGUL JUNGSEONG YU-OHANGUL JUNGSEONG EU-A" +
	"HANGUL JUNGSEONG EU-EOHANGUL JUNGSEONG EU-EHANGUL JUNGSEONG EU-OHANGUL J" +
	"UNGSEONG I-YA-OHANGUL JUNGSEONG I-YAEHANGUL JUNGSEONG I-YEOHANGUL JUNGSE" +
	"ONG I-YEHANGUL JUNGSEONG I-O-IHANGUL JUNGSEONG I-YOHANGUL JUNGSEONG I-YU" +
	"HANGUL JUNGSEONG I-IHANGUL JUNGSEONG ARAEA-AHANGUL JUNGSEONG ARAEA-EHANG" +
	"UL JONGSEONG NIEUN-RIEULHANGUL JONGSEONG NIEUN-CHIEUCHHANGUL JONGSEONG S" +
	"SANGTIKEUTHANGUL JONGSEONG SSANGTIKEUT-PIEUPHANGUL JONGSEONG TIKEUT-PIEU" +
	"PHANGUL JONGSEONG TIKEUT-SIOSHANGUL JONGSEONG TIKEUT-SIOS-KIYEOKHANGUL J" +
	"ONGSEONG TIKEUT-CIEUCHANGUL JONGSEONG TIKEUT-CHIEUCHHANGUL JONGSEONG TIK" +
	"EUT-THIEUTHHANGUL JONGSEONG RIEUL-SSANGKIYEOKHANGUL JONGSEONG RIEUL-KIYE" +
	"OK-HIEUHHANGUL JONGSEONG SSANGRIEUL-KHIEUKHHANGUL JONGSEONG RIEUL-MIEUM-" +
	"HIEUHHANGUL JONGSEONG RIEUL-PIEUP-TIKEUTHANGUL JONGSEONG RIEUL-PIEUP-PHI" +
	"EUPHHANGUL JONGSEONG RIEUL-YESIEUNGHANGUL JONGSEONG RIEUL-YEORINHIEUH-HI" +
	"EUHHANGUL JONGSEONG KAPYEOUNRIEULHANGUL JONGSEONG MIEUM-NIEUNHANGUL JONG" +
	"SEONG MIEUM-SSANGNIEUNHANGUL JONGSEONG SSANGMIEUMHANGUL JONGSEONG MIEUM-" +
	"PIEUP-SIOSHANGUL JONGSEONG MIEUM-CIEUCHANGUL JONGSEONG PIEUP-TIKEUTHANGU" +
	"L JONGSEONG PIEUP-RIEUL-PHIEUPHHANGUL JONGSEONG PIEUP-MIEUMHANGUL JONGSE" +
	"ONG SSANGPIEUPHANGUL JONGSEONG PIEUP-SIOS-TIKEUTHANGUL JONGSEONG PIEUP-C" +
	"IEUCHANGUL JONGSEONG PIEUP-CHIEUCHHANGUL JONGSEONG SIOS-MIEUMHANGUL JONG" +
	"SEONG SIOS-KAPYEOUNPIEUPHANGUL JONGSEONG SSANGSIOS-KIYEOKHANGUL JONGSEON" +
	"G SSANGSIOS-TIKEUTHANGUL JONGSEONG SIOS-PANSIOSHANGUL JONGSEONG SIOS-CIE" +
	"UCHANGUL JONGSEONG SIOS-CHIEUCHHANGUL JONGSEONG SIOS-THIEUTHHANGUL JONGS" +
	"EONG SIOS-HIEUHHANGUL JONGSEONG PANSIOS-PIEUPHANGUL JONGSEONG PANSIOS-KA" +
	"PYEOUNPIEUPHANGUL JONGSEONG YESIEUNG-MIEUMHANGUL JONGSEONG YESIEUNG-HIEU" +
	"HHANGUL JONGSEONG CIEUC-PIEUPHANGUL JONGSEONG CIEUC-SSANGPIEUPHANGUL JON" +
	"GSEONG SSANGCIEUCHANGUL JONGSEONG PHIEUPH-SIOSHANGUL JONGSEONG PHIEUPH-T" +
	"HIEUTHCJK COMPATIBILITY IDEOGRAPH-F900CJK COMPATIBILITY IDEOGRAPH-F901CJ") + ("" +
	"K COMPATIBILITY IDEOGRAPH-F902CJK COMPATIBILITY IDEOGRAPH-F903CJK COMPAT" +
	"IBILITY IDEOGRAPH-F904CJK COMPATIBILITY IDEOGRAPH-F905CJK COMPATIBILITY " +
	"IDEOGRAPH-F906CJK COMPATIBILITY IDEOGRAPH-F907CJK COMPATIBILITY IDEOGRAP" +
	"H-F908CJK COMPATIBILITY IDEOGRAPH-F909CJK COMPATIBILITY IDEOGRAPH-F90ACJ" +
	"K COMPATIBILITY IDEOGRAPH-F90BCJK COMPATIBILITY IDEOGRAPH-F90CCJK COMPAT" +
	"IBILITY IDEOGRAPH-F90DCJK COMPATIBILITY IDEOGRAPH-F90ECJK COMPATIBILITY " +
	"IDEOGRAPH-F90FCJK COMPATIBILITY IDEOGRAPH-F910CJK COMPATIBILITY IDEOGRAP" +
	"H-F911CJK COMPATIBILITY IDEOGRAPH-F912CJK COMPATIBILITY IDEOGRAPH-F913CJ" +
	"K COMPATIBILITY IDEOGRAPH-F914CJK COMPATIBILITY IDEOGRAPH-F915CJK COMPAT" +
	"IBILITY IDEOGRAPH-F916CJK COMPATIBILITY IDEOGRAPH-F917CJK COMPATIBILITY " +
	"IDEOGRAPH-F918CJK COMPATIBILITY IDEOGRAPH-F919CJK COMPATIBILITY IDEOGRAP" +
	"H-F91ACJK COMPATIBILITY IDEOGRAPH-F91BCJK COMPATIBILITY IDEOGRAPH-F91CCJ" +
	"K COMPATIBILITY IDEOGRAPH-F91DCJK COMPATIBILITY IDEOGRAPH-F91ECJK COMPAT" +
	"IBILITY IDEOGRAPH-F91FCJK COMPATIBILITY IDEOGRAPH-F920CJK COMPATIBILITY " +
	"IDEOGRAPH-F921CJK COMPATIBILITY IDEOGRAPH-F922CJK COMPATIBILITY IDEOGRAP" +
	"H-F923CJK COMPATIBILITY IDEOGRAPH-F924CJK COMPATIBILITY IDEOGRAPH-F925CJ" +
	"K COMPATIBILITY IDEOGRAPH-F926CJK COMPATIBILITY IDEOGRAPH-F927CJK COMPAT" +
	"IBILITY IDEOGRAPH-F928CJK COMPATIBILITY IDEOGRAPH-F929CJK COMPATIBILITY " +
	"IDEOGRAPH-F92ACJK COMPATIBILITY IDEOGRAPH-F92BCJK COMPATIBILITY IDEOGRAP" +
	"H-F92CCJK COMPATIBILITY IDEOGRAPH-F92DCJK COMPATIBILITY IDEOGRAPH-F92ECJ" +
	"K COMPATIBILITY IDEOGRAPH-F92FCJK COMPATIBILITY IDEOGRAPH-F930CJK COMPAT" +
	"IBILITY IDEOGRAPH-F931CJK COMPATIBILITY IDEOGRAPH-F932CJK COMPATIBILITY " +
	"IDEOGRAPH-F933CJK COMPATIBILITY IDEOGRAPH-F934CJK COMPATIBILITY IDEOGRAP" +
	"H-F935CJK COMPATIBILITY IDEOGRAPH-F936CJK COMPATIBILITY IDEOGRAPH-F937CJ" +
	"K COMPATIBILITY IDEOGRAPH-F938CJK COMPATIBILITY IDEOGRAPH-F939CJK COMPAT" +
	"IBILITY IDEOGRAPH-F93ACJK COMPATIBILITY IDEOGRAPH-F93BCJK COMPATIBILITY " +
	"IDEOGRAPH-F93CCJK COMPATIBILITY IDEOGRAPH-F93DCJK COMPATIBILITY IDEOGRAP" +
	"H-F93ECJK COMPATIBILITY IDEOGRAPH-F93FCJK COMPATIBILITY IDEOGRAPH-F940CJ" +
	"K COMPATIBILITY IDEOGRAPH-F941CJK COMPATIBILITY IDEOGRAPH-F942CJK COMPAT" +
	"IBILITY IDEOGRAPH-F943CJK COMPATIBILITY IDEOGRAPH-F944CJK COMPATIBILITY " +
	"IDEOGRAPH-F945CJK COMPATIBILITY IDEOGRAPH-F946CJK COMPATIBILITY IDEOGRAP" +
	"H-F947CJK COMPATIBILITY IDEOGRAPH-F948CJK COMPATIBILITY IDEOGRAPH-F949CJ" +
	"K COMPATIBILITY IDEOGRAPH-F94ACJK COMPATIBILITY IDEOGRAPH-F94BCJK COMPAT" +
	"IBILITY IDEOGRAPH-F94CCJK COMPATIBILITY IDEOGRAPH-F94DCJK COMPATIBILITY " +
	"IDEOGRAPH-F94ECJK COMPATIBILITY IDEOGRAPH-F94FCJK COMPATIBILITY IDEOGRAP" +
	"H-F950CJK COMPATIBILITY IDEOGRAPH-F951CJK COMPATIBILITY IDEOGRAPH-F952CJ" +
	"K COMPATIBILITY IDEOGRAPH-F953CJK COMPATIBILITY IDEOGRAPH-F954CJK COMPAT" +
	"IBILITY IDEOGRAPH-F955CJK COMPATIBILITY IDEOGRAPH-F956CJK COMPATIBILITY " +
	"IDEOGRAPH-F957CJK COMPATIBILITY IDEOGRAPH-F958CJK COMPATIBILITY IDEOGRAP" +
	"H-F959CJK COMPATIBILITY IDEOGRAPH-F95ACJK COMPATIBILITY IDEOGRAPH-F95BCJ" +
	"K COMPATIBILITY IDEOGRAPH-F95CCJK COMPATIBILITY IDEOGRAPH-F95DCJK COMPAT" +
	"IBILITY IDEOGRAPH-F95ECJK COMPATIBILITY IDEOGRAPH-F95FCJK COMPATIBILITY " +
	"IDEOGRAPH-F960CJK COMPATIBILITY IDEOGRAPH-F961CJK COMPATIBILITY IDEOGRAP" +
	"H-F962CJK COMPATIBILITY IDEOGRAPH-F963CJK COMPATIBILITY IDEOGRAPH-F964CJ" +
	"K COMPATIBILITY IDEOGRAPH-F965CJK COMPATIBILITY IDEOGRAPH-F966CJK COMPAT" +
	"IBILITY IDEOGRAPH-F967CJK COMPATIBILITY IDEOGRAPH-F968CJK COMPATIBILITY " +
	"IDEOGRAPH-F969CJK COMPATIBILITY IDEOGRAPH-F96ACJK COMPATIBILITY IDEOGRAP" +
	"H-F96BCJK COMPATIBILITY IDEOGRAPH-F96CCJK COMPATIBILITY IDEOGRAPH-F96DCJ" +
	"K COMPATIBILITY IDEOGRAPH-F96ECJK COMPATIBILITY IDEOGRAPH-F96FCJK COMPAT" +
	"IBILITY IDEOGRAPH-F970CJK COMPATIBILITY IDEOGRAPH-F971CJK COMPATIBILITY " +
	"IDEOGRAPH-F972CJK COMPATIBILITY IDEOGRAPH-F973CJK COMPATIBILITY IDEOGRAP" +
	"H-F974CJK COMPATIBILITY IDEOGRAPH-F975CJK COMPATIBILITY IDEOGRAPH-F976CJ" +
	"K COMPATIBILITY IDEOGRAPH-F977CJK COMPATIBILITY IDEOGRAPH-F978CJK COMPAT" +
	"IBILITY IDEOGRAPH-F979CJK COMPATIBILITY IDEOGRAPH-F97ACJK COMPATIBILITY " +
	"IDEOGRAPH-F97BCJK COMPATIBILITY IDEOGRAPH-F97CCJK COMPATIBILITY IDEOGRAP" +
	"H-F97DCJK COMPATIBILITY IDEOGRAPH-F97ECJK COMPATIBILITY IDEOGRAPH-F97FCJ" +
	"K COMPATIBILITY IDEOGRAPH-F980CJK COMPATIBILITY IDEOGRAPH-F981CJK COMPAT" +
	"IBILITY IDEOGRAPH-F982CJK COMPATIBILITY IDEOGRAPH-F983CJK COMPATIBILITY " +
	"IDEOGRAPH-F984CJK COMPATIBILITY IDEOGRAPH-F985CJK COMPATIBILITY IDEOGRAP" +
	"H-F986CJK COMPATIBILITY IDEOGRAPH-F987CJK COMPATIBILITY IDEOGRAPH-F988CJ" +
	"K COMPATIBILITY IDEOGRAPH-F989CJK COMPATIBILITY IDEOGRAPH-F98ACJK COMPAT" +
	"IBILITY IDEOGRAPH-F98BCJK COMPATIBILITY IDEOGRAPH-F98CCJK COMPATIBILITY " +
	"IDEOGRAPH-F98DCJK COMPATIBILITY IDEOGRAPH-F98ECJK COMPATIBILITY IDEOGRAP" +
	"H-F98FCJK COMPATIBILITY IDEOGRAPH-F990CJK COMPATIBILITY IDEOGRAPH-F991CJ") + ("" +
	"K COMPATIBILITY IDEOGRAPH-F992CJK COMPATIBILITY IDEOGRAPH-F993CJK COMPAT" +
	"IBILITY IDEOGRAPH-F994CJK COMPATIBILITY IDEOGRAPH-F995CJK COMPATIBILITY " +
	"IDEOGRAPH-F996CJK COMPATIBILITY IDEOGRAPH-F997CJK COMPATIBILITY IDEOGRAP" +
	"H-F998CJK COMPATIBILITY IDEOGRAPH-F999CJK COMPATIBILITY IDEOGRAPH-F99ACJ" +
	"K COMPATIBILITY IDEOGRAPH-F99BCJK COMPATIBILITY IDEOGRAPH-F99CCJK COMPAT" +
	"IBILITY IDEOGRAPH-F99DCJK COMPATIBILITY IDEOGRAPH-F99ECJK COMPATIBILITY " +
	"IDEOGRAPH-F99FCJK COMPATIBILITY IDEOGRAPH-F9A0CJK COMPATIBILITY IDEOGRAP" +
	"H-F9A1CJK COMPATIBILITY IDEOGRAPH-F9A2CJK COMPATIBILITY IDEOGRAPH-F9A3CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9A4CJK COMPATIBILITY IDEOGRAPH-F9A5CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9A6CJK COMPATIBILITY IDEOGRAPH-F9A7CJK COMPATIBILITY " +
	"IDEOGRAPH-F9A8CJK COMPATIBILITY IDEOGRAPH-F9A9CJK COMPATIBILITY IDEOGRAP" +
	"H-F9AACJK COMPATIBILITY IDEOGRAPH-F9ABCJK COMPATIBILITY IDEOGRAPH-F9ACCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9ADCJK COMPATIBILITY IDEOGRAPH-F9AECJK COMPAT" +
	"IBILITY IDEOGRAPH-F9AFCJK COMPATIBILITY IDEOGRAPH-F9B0CJK COMPATIBILITY " +
	"IDEOGRAPH-F9B1CJK COMPATIBILITY IDEOGRAPH-F9B2CJK COMPATIBILITY IDEOGRAP" +
	"H-F9B3CJK COMPATIBILITY IDEOGRAPH-F9B4CJK COMPATIBILITY IDEOGRAPH-F9B5CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9B6CJK COMPATIBILITY IDEOGRAPH-F9B7CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9B8CJK COMPATIBILITY IDEOGRAPH-F9B9CJK COMPATIBILITY " +
	"IDEOGRAPH-F9BACJK COMPATIBILITY IDEOGRAPH-F9BBCJK COMPATIBILITY IDEOGRAP" +
	"H-F9BCCJK COMPATIBILITY IDEOGRAPH-F9BDCJK COMPATIBILITY IDEOGRAPH-F9BECJ" +
	"K COMPATIBILITY IDEOGRAPH-F9BFCJK COMPATIBILITY IDEOGRAPH-F9C0CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9C1CJK COMPATIBILITY IDEOGRAPH-F9C2CJK COMPATIBILITY " +
	"IDEOGRAPH-F9C3CJK COMPATIBILITY IDEOGRAPH-F9C4CJK COMPATIBILITY IDEOGRAP" +
	"H-F9C5CJK COMPATIBILITY IDEOGRAPH-F9C6CJK COMPATIBILITY IDEOGRAPH-F9C7CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9C8CJK COMPATIBILITY IDEOGRAPH-F9C9CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9CACJK COMPATIBILITY IDEOGRAPH-F9CBCJK COMPATIBILITY " +
	"IDEOGRAPH-F9CCCJK COMPATIBILITY IDEOGRAPH-F9CDCJK COMPATIBILITY IDEOGRAP" +
	"H-F9CECJK COMPATIBILITY IDEOGRAPH-F9CFCJK COMPATIBILITY IDEOGRAPH-F9D0CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9D1CJK COMPATIBILITY IDEOGRAPH-F9D2CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9D3CJK COMPATIBILITY IDEOGRAPH-F9D4CJK COMPATIBILITY " +
	"IDEOGRAPH-F9D5CJK COMPATIBILITY IDEOGRAPH-F9D6CJK COMPATIBILITY IDEOGRAP" +
	"H-F9D7CJK COMPATIBILITY IDEOGRAPH-F9D8CJK COMPATIBILITY IDEOGRAPH-F9D9CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9DACJK COMPATIBILITY IDEOGRAPH-F9DBCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9DCCJK COMPATIBILITY IDEOGRAPH-F9DDCJK COMPATIBILITY " +
	"IDEOGRAPH-F9DECJK COMPATIBILITY IDEOGRAPH-F9DFCJK COMPATIBILITY IDEOGRAP" +
	"H-F9E0CJK COMPATIBILITY IDEOGRAPH-F9E1CJK COMPATIBILITY IDEOGRAPH-F9E2CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9E3CJK COMPATIBILITY IDEOGRAPH-F9E4CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9E5CJK COMPATIBILITY IDEOGRAPH-F9E6CJK COMPATIBILITY " +
	"IDEOGRAPH-F9E7CJK COMPATIBILITY IDEOGRAPH-F9E8CJK COMPATIBILITY IDEOGRAP" +
	"H-F9E9CJK COMPATIBILITY IDEOGRAPH-F9EACJK COMPATIBILITY IDEOGRAPH-F9EBCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9ECCJK COMPATIBILITY IDEOGRAPH-F9EDCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9EECJK COMPATIBILITY IDEOGRAPH-F9EFCJK COMPATIBILITY " +
	"IDEOGRAPH-F9F0CJK COMPATIBILITY IDEOGRAPH-F9F1CJK COMPATIBILITY IDEOGRAP" +
	"H-F9F2CJK COMPATIBILITY IDEOGRAPH-F9F3CJK COMPATIBILITY IDEOGRAPH-F9F4CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9F5CJK COMPATIBILITY IDEOGRAPH-F9F6CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9F7CJK COMPATIBILITY IDEOGRAPH-F9F8CJK COMPATIBILITY " +
	"IDEOGRAPH-F9F9CJK COMPATIBILITY IDEOGRAPH-F9FACJK COMPATIBILITY IDEOGRAP" +
	"H-F9FBCJK COMPATIBILITY IDEOGRAPH-F9FCCJK COMPATIBILITY IDEOGRAPH-F9FDCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9FECJK COMPATIBILITY IDEOGRAPH-F9FFCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA00CJK COMPATIBILITY IDEOGRAPH-FA01CJK COMPATIBILITY " +
	"IDEOGRAPH-FA02CJK COMPATIBILITY IDEOGRAPH-FA03CJK COMPATIBILITY IDEOGRAP" +
	"H-FA04CJK COMPATIBILITY IDEOGRAPH-FA05CJK COMPATIBILITY IDEOGRAPH-FA06CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA07CJK COMPATIBILITY IDEOGRAPH-FA08CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA09CJK COMPATIBILITY IDEOGRAPH-FA0ACJK COMPATIBILITY " +
	"IDEOGRAPH-FA0BCJK COMPATIBILITY IDEOGRAPH-FA0CCJK COMPATIBILITY IDEOGRAP" +
	"H-FA0DCJK COMPATIBILITY IDEOGRAPH-FA0ECJK COMPATIBILITY IDEOGRAPH-FA0FCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA10CJK COMPATIBILITY IDEOGRAPH-FA11CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA12CJK COMPATIBILITY IDEOGRAPH-FA13CJK COMPATIBILITY " +
	"IDEOGRAPH-FA14CJK COMPATIBILITY IDEOGRAPH-FA15CJK COMPATIBILITY IDEOGRAP" +
	"H-FA16CJK COMPATIBILITY IDEOGRAPH-FA17CJK COMPATIBILITY IDEOGRAPH-FA18CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA19CJK COMPATIBILITY IDEOGRAPH-FA1ACJK COMPAT" +
	"IBILITY IDEOGRAPH-FA1BCJK COMPATIBILITY IDEOGRAPH-FA1CCJK COMPATIBILITY " +
	"IDEOGRAPH-FA1DCJK COMPATIBILITY IDEOGRAPH-FA1ECJK COMPATIBILITY IDEOGRAP" +
	"H-FA1FCJK COMPATIBILITY IDEOGRAPH-FA20CJK COMPATIBILITY IDEOGRAPH-FA21CJ") + ("" +
	"K COMPATIBILITY IDEOGRAPH-FA22CJK COMPATIBILITY IDEOGRAPH-FA23CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA24CJK COMPATIBILITY IDEOGRAPH-FA25CJK COMPATIBILITY " +
	"IDEOGRAPH-FA26CJK COMPATIBILITY IDEOGRAPH-FA27CJK COMPATIBILITY IDEOGRAP" +
	"H-FA28CJK COMPATIBILITY IDEOGRAPH-FA29CJK COMPATIBILITY IDEOGRAPH-FA2ACJ" +
	"K COMPATIBILITY IDEOGRAPH-FA2BCJK COMPATIBILITY IDEOGRAPH-FA2CCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA2DCJK COMPATIBILITY IDEOGRAPH-FA2ECJK COMPATIBILITY " +
	"IDEOGRAPH-FA2FCJK COMPATIBILITY IDEOGRAPH-FA30CJK COMPATIBILITY IDEOGRAP" +
	"H-FA31CJK COMPATIBILITY IDEOGRAPH-FA32CJK COMPATIBILITY IDEOGRAPH-FA33CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA34CJK COMPATIBILITY IDEOGRAPH-FA35CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA36CJK COMPATIBILITY IDEOGRAPH-FA37CJK COMPATIBILITY " +
	"IDEOGRAPH-FA38CJK COMPATIBILITY IDEOGRAPH-FA39CJK COMPATIBILITY IDEOGRAP" +
	"H-FA3ACJK COMPATIBILITY IDEOGRAPH-FA3BCJK COMPATIBILITY IDEOGRAPH-FA3CCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA3DCJK COMPATIBILITY IDEOGRAPH-FA3ECJK COMPAT" +
	"IBILITY IDEOGRAPH-FA3FCJK COMPATIBILITY IDEOGRAPH-FA40CJK COMPATIBILITY " +
	"IDEOGRAPH-FA41CJK COMPATIBILITY IDEOGRAPH-FA42CJK COMPATIBILITY IDEOGRAP" +
	"H-FA43CJK COMPATIBILITY IDEOGRAPH-FA44CJK COMPATIBILITY IDEOGRAPH-FA45CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA46CJK COMPATIBILITY IDEOGRAPH-FA47CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA48CJK COMPATIBILITY IDEOGRAPH-FA49CJK COMPATIBILITY " +
	"IDEOGRAPH-FA4ACJK COMPATIBILITY IDEOGRAPH-FA4BCJK COMPATIBILITY IDEOGRAP" +
	"H-FA4CCJK COMPATIBILITY IDEOGRAPH-FA4DCJK COMPATIBILITY IDEOGRAPH-FA4ECJ" +
	"K COMPATIBILITY IDEOGRAPH-FA4FCJK COMPATIBILITY IDEOGRAPH-FA50CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA51CJK COMPATIBILITY IDEOGRAPH-FA52CJK COMPATIBILITY " +
	"IDEOGRAPH-FA53CJK COMPATIBILITY IDEOGRAPH-FA54CJK COMPATIBILITY IDEOGRAP" +
	"H-FA55CJK COMPATIBILITY IDEOGRAPH-FA56CJK COMPATIBILITY IDEOGRAPH-FA57CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA58CJK COMPATIBILITY IDEOGRAPH-FA59CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA5ACJK COMPATIBILITY IDEOGRAPH-FA5BCJK COMPATIBILITY " +
	"IDEOGRAPH-FA5CCJK COMPATIBILITY IDEOGRAPH-FA5DCJK COMPATIBILITY IDEOGRAP" +
	"H-FA5ECJK COMPATIBILITY IDEOGRAPH-FA5FCJK COMPATIBILITY IDEOGRAPH-FA60CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA61CJK COMPATIBILITY IDEOGRAPH-FA62CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA63CJK COMPATIBILITY IDEOGRAPH-FA64CJK COMPATIBILITY " +
	"IDEOGRAPH-FA65CJK COMPATIBILITY IDEOGRAPH-FA66CJK COMPATIBILITY IDEOGRAP" +
	"H-FA67CJK COMPATIBILITY IDEOGRAPH-FA68CJK COMPATIBILITY IDEOGRAPH-FA69CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA6ACJK COMPATIBILITY IDEOGRAPH-FA6BCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA6CCJK COMPATIBILITY IDEOGRAPH-FA6DCJK COMPATIBILITY " +
	"IDEOGRAPH-FA70CJK COMPATIBILITY IDEOGRAPH-FA71CJK COMPATIBILITY IDEOGRAP" +
	"H-FA72CJK COMPATIBILITY IDEOGRAPH-FA73CJK COMPATIBILITY IDEOGRAPH-FA74CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA75CJK COMPATIBILITY IDEOGRAPH-FA76CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA77CJK COMPATIBILITY IDEOGRAPH-FA78CJK COMPATIBILITY " +
	"IDEOGRAPH-FA79CJK COMPATIBILITY IDEOGRAPH-FA7ACJK COMPATIBILITY IDEOGRAP" +
	"H-FA7BCJK COMPATIBILITY IDEOGRAPH-FA7CCJK COMPATIBILITY IDEOGRAPH-FA7DCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA7ECJK COMPATIBILITY IDEOGRAPH-FA7FCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA80CJK COMPATIBILITY IDEOGRAPH-FA81CJK COMPATIBILITY " +
	"IDEOGRAPH-FA82CJK COMPATIBILITY IDEOGRAPH-FA83CJK COMPATIBILITY IDEOGRAP" +
	"H-FA84CJK COMPATIBILITY IDEOGRAPH-FA85CJK COMPATIBILITY IDEOGRAPH-FA86CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA87CJK COMPATIBILITY IDEOGRAPH-FA88CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA89CJK COMPATIBILITY IDEOGRAPH-FA8ACJK COMPATIBILITY " +
	"IDEOGRAPH-FA8BCJK COMPATIBILITY IDEOGRAPH-FA8CCJK COMPATIBILITY IDEOGRAP" +
	"H-FA8DCJK COMPATIBILITY IDEOGRAPH-FA8ECJK COMPATIBILITY IDEOGRAPH-FA8FCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA90CJK COMPATIBILITY IDEOGRAPH-FA91CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA92CJK COMPATIBILITY IDEOGRAPH-FA93CJK COMPATIBILITY " +
	"IDEOGRAPH-FA94CJK COMPATIBILITY IDEOGRAPH-FA95CJK COMPATIBILITY IDEOGRAP" +
	"H-FA96CJK COMPATIBILITY IDEOGRAPH-FA97CJK COMPATIBILITY IDEOGRAPH-FA98CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA99CJK COMPATIBILITY IDEOGRAPH-FA9ACJK COMPAT" +
	"IBILITY IDEOGRAPH-FA9BCJK COMPATIBILITY IDEOGRAPH-FA9CCJK COMPATIBILITY " +
	"IDEOGRAPH-FA9DCJK COMPATIBILITY IDEOGRAPH-FA9ECJK COMPATIBILITY IDEOGRAP" +
	"H-FA9FCJK COMPATIBILITY IDEOGRAPH-FAA0CJK COMPATIBILITY IDEOGRAPH-FAA1CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAA2CJK COMPATIBILITY IDEOGRAPH-FAA3CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAA4CJK COMPATIBILITY IDEOGRAPH-FAA5CJK COMPATIBILITY " +
	"IDEOGRAPH-FAA6CJK COMPATIBILITY IDEOGRAPH-FAA7CJK COMPATIBILITY IDEOGRAP" +
	"H-FAA8CJK COMPATIBILITY IDEOGRAPH-FAA9CJK COMPATIBILITY IDEOGRAPH-FAAACJ" +
	"K COMPATIBILITY IDEOGRAPH-FAABCJK COMPATIBILITY IDEOGRAPH-FAACCJK COMPAT" +
	"IBILITY IDEOGRAPH-FAADCJK COMPATIBILITY IDEOGRAPH-FAAECJK COMPATIBILITY " +
	"IDEOGRAPH-FAAFCJK COMPATIBILITY IDEOGRAPH-FAB0CJK COMPATIBILITY IDEOGRAP" +
	"H-FAB1CJK COMPATIBILITY IDEOGRAPH-FAB2CJK COMPATIBILITY IDEOGRAPH-FAB3CJ") + ("" +
	"K COMPATIBILITY IDEOGRAPH-FAB4CJK COMPATIBILITY IDEOGRAPH-FAB5CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAB6CJK COMPATIBILITY IDEOGRAPH-FAB7CJK COMPATIBILITY " +
	"IDEOGRAPH-FAB8CJK COMPATIBILITY IDEOGRAPH-FAB9CJK COMPATIBILITY IDEOGRAP" +
	"H-FABACJK COMPATIBILITY IDEOGRAPH-FABBCJK COMPATIBILITY IDEOGRAPH-FABCCJ" +
	"K COMPATIBILITY IDEOGRAPH-FABDCJK COMPATIBILITY IDEOGRAPH-FABECJK COMPAT" +
	"IBILITY IDEOGRAPH-FABFCJK COMPATIBILITY IDEOGRAPH-FAC0CJK COMPATIBILITY " +
	"IDEOGRAPH-FAC1CJK COMPATIBILITY IDEOGRAPH-FAC2CJK COMPATIBILITY IDEOGRAP" +
	"H-FAC3CJK COMPATIBILITY IDEOGRAPH-FAC4CJK COMPATIBILITY IDEOGRAPH-FAC5CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAC6CJK COMPATIBILITY IDEOGRAPH-FAC7CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAC8CJK COMPATIBILITY IDEOGRAPH-FAC9CJK COMPATIBILITY " +
	"IDEOGRAPH-FACACJK COMPATIBILITY IDEOGRAPH-FACBCJK COMPATIBILITY IDEOGRAP" +
	"H-FACCCJK COMPATIBILITY IDEOGRAPH-FACDCJK COMPATIBILITY IDEOGRAPH-FACECJ" +
	"K COMPATIBILITY IDEOGRAPH-FACFCJK COMPATIBILITY IDEOGRAPH-FAD0CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAD1CJK COMPATIBILITY IDEOGRAPH-FAD2CJK COMPATIBILITY " +
	"IDEOGRAPH-FAD3CJK COMPATIBILITY IDEOGRAPH-FAD4CJK COMPATIBILITY IDEOGRAP" +
	"H-FAD5CJK COMPATIBILITY IDEOGRAPH-FAD6CJK COMPATIBILITY IDEOGRAPH-FAD7CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAD8CJK COMPATIBILITY IDEOGRAPH-FAD9LATIN SMAL" +
	"L LIGATURE FFLATIN SMALL LIGATURE FILATIN SMALL LIGATURE FLLATIN SMALL L" +
	"IGATURE FFILATIN SMALL LIGATURE FFLLATIN SMALL LIGATURE LONG S TLATIN SM" +
	"ALL LIGATURE STARMENIAN SMALL LIGATURE MEN NOWARMENIAN SMALL LIGATURE ME" +
	"N ECHARMENIAN SMALL LIGATURE MEN INIARMENIAN SMALL LIGATURE VEW NOWARMEN" +
	"IAN SMALL LIGATURE MEN XEHHEBREW LETTER YOD WITH HIRIQHEBREW POINT JUDEO" +
	"-SPANISH VARIKAHEBREW LIGATURE YIDDISH YOD YOD PATAHHEBREW LETTER ALTERN" +
	"ATIVE AYINHEBREW LETTER WIDE ALEFHEBREW LETTER WIDE DALETHEBREW LETTER W" +
	"IDE HEHEBREW LETTER WIDE KAFHEBREW LETTER WIDE LAMEDHEBREW LETTER WIDE F" +
	"INAL MEMHEBREW LETTER WIDE RESHHEBREW LETTER WIDE TAVHEBREW LETTER ALTER" +
	"NATIVE PLUS SIGNHEBREW LETTER SHIN WITH SHIN DOTHEBREW LETTER SHIN WITH " +
	"SIN DOTHEBREW LETTER SHIN WITH DAGESH AND SHIN DOTHEBREW LETTER SHIN WIT" +
	"H DAGESH AND SIN DOTHEBREW LETTER ALEF WITH PATAHHEBREW LETTER ALEF WITH" +
	" QAMATSHEBREW LETTER ALEF WITH MAPIQHEBREW LETTER BET WITH DAGESHHEBREW " +
	"LETTER GIMEL WITH DAGESHHEBREW LETTER DALET WITH DAGESHHEBREW LETTER HE " +
	"WITH MAPIQHEBREW LETTER VAV WITH DAGESHHEBREW LETTER ZAYIN WITH DAGESHHE" +
	"BREW LETTER TET WITH DAGESHHEBREW LETTER YOD WITH DAGESHHEBREW LETTER FI" +
	"NAL KAF WITH DAGESHHEBREW LETTER KAF WITH DAGESHHEBREW LETTER LAMED WITH" +
	" DAGESHHEBREW LETTER MEM WITH DAGESHHEBREW LETTER NUN WITH DAGESHHEBREW " +
	"LETTER SAMEKH WITH DAGESHHEBREW LETTER FINAL PE WITH DAGESHHEBREW LETTER" +
	" PE WITH DAGESHHEBREW LETTER TSADI WITH DAGESHHEBREW LETTER QOF WITH DAG" +
	"ESHHEBREW LETTER RESH WITH DAGESHHEBREW LETTER SHIN WITH DAGESHHEBREW LE" +
	"TTER TAV WITH DAGESHHEBREW LETTER VAV WITH HOLAMHEBREW LETTER BET WITH R" +
	"AFEHEBREW LETTER KAF WITH RAFEHEBREW LETTER PE WITH RAFEHEBREW LIGATURE " +
	"ALEF LAMEDARABIC LETTER ALEF WASLA ISOLATED FORMARABIC LETTER ALEF WASLA" +
	" FINAL FORMARABIC LETTER BEEH ISOLATED FORMARABIC LETTER BEEH FINAL FORM" +
	"ARABIC LETTER BEEH INITIAL FORMARABIC LETTER BEEH MEDIAL FORMARABIC LETT" +
	"ER PEH ISOLATED FORMARABIC LETTER PEH FINAL FORMARABIC LETTER PEH INITIA" +
	"L FORMARABIC LETTER PEH MEDIAL FORMARABIC LETTER BEHEH ISOLATED FORMARAB" +
	"IC LETTER BEHEH FINAL FORMARABIC LETTER BEHEH INITIAL FORMARABIC LETTER " +
	"BEHEH MEDIAL FORMARABIC LETTER TTEHEH ISOLATED FORMARABIC LETTER TTEHEH " +
	"FINAL FORMARABIC LETTER TTEHEH INITIAL FORMARABIC LETTER TTEHEH MEDIAL F" +
	"ORMARABIC LETTER TEHEH ISOLATED FORMARABIC LETTER TEHEH FINAL FORMARABIC" +
	" LETTER TEHEH INITIAL FORMARABIC LETTER TEHEH MEDIAL FORMARABIC LETTER T" +
	"TEH ISOLATED FORMARABIC LETTER TTEH FINAL FORMARABIC LETTER TTEH INITIAL" +
	" FORMARABIC LETTER TTEH MEDIAL FORMARABIC LETTER VEH ISOLATED FORMARABIC" +
	" LETTER VEH FINAL FORMARABIC LETTER VEH INITIAL FORMARABIC LETTER VEH ME" +
	"DIAL FORMARABIC LETTER PEHEH ISOLATED FORMARABIC LETTER PEHEH FINAL FORM" +
	"ARABIC LETTER PEHEH INITIAL FORMARABIC LETTER PEHEH MEDIAL FORMARABIC LE" +
	"TTER DYEH ISOLATED FORMARABIC LETTER DYEH FINAL FORMARABIC LETTER DYEH I" +
	"NITIAL FORMARABIC LETTER DYEH MEDIAL FORMARABIC LETTER NYEH ISOLATED FOR" +
	"MARABIC LETTER NYEH FINAL FORMARABIC LETTER NYEH INITIAL FORMARABIC LETT" +
	"ER NYEH MEDIAL FORMARABIC LETTER TCHEH ISOLATED FORMARABIC LETTER TCHEH " +
	"FINAL FORMARABIC LETTER TCHEH INITIAL FORMARABIC LETTER TCHEH MEDIAL FOR" +
	"MARABIC LETTER TCHEHEH ISOLATED FORMARABIC LETTER TCHEHEH FINAL FORMARAB" +
	"IC LETTER TCHEHEH INITIAL FORMARABIC LETTER TCHEHEH MEDIAL FORMARABIC LE" +
	"TTER DDAHAL ISOLATED FORMARABIC LETTER DDAHAL FINAL FORMARABIC LETTER DA" +
	"HAL ISOLATED FORMARABIC LETTER DAHAL FINAL FORMARABIC LETTER DUL ISOLATE") + ("" +
	"D FORMARABIC LETTER DUL FINAL FORMARABIC LETTER DDAL ISOLATED FORMARABIC" +
	" LETTER DDAL FINAL FORMARABIC LETTER JEH ISOLATED FORMARABIC LETTER JEH " +
	"FINAL FORMARABIC LETTER RREH ISOLATED FORMARABIC LETTER RREH FINAL FORMA" +
	"RABIC LETTER KEHEH ISOLATED FORMARABIC LETTER KEHEH FINAL FORMARABIC LET" +
	"TER KEHEH INITIAL FORMARABIC LETTER KEHEH MEDIAL FORMARABIC LETTER GAF I" +
	"SOLATED FORMARABIC LETTER GAF FINAL FORMARABIC LETTER GAF INITIAL FORMAR" +
	"ABIC LETTER GAF MEDIAL FORMARABIC LETTER GUEH ISOLATED FORMARABIC LETTER" +
	" GUEH FINAL FORMARABIC LETTER GUEH INITIAL FORMARABIC LETTER GUEH MEDIAL" +
	" FORMARABIC LETTER NGOEH ISOLATED FORMARABIC LETTER NGOEH FINAL FORMARAB" +
	"IC LETTER NGOEH INITIAL FORMARABIC LETTER NGOEH MEDIAL FORMARABIC LETTER" +
	" NOON GHUNNA ISOLATED FORMARABIC LETTER NOON GHUNNA FINAL FORMARABIC LET" +
	"TER RNOON ISOLATED FORMARABIC LETTER RNOON FINAL FORMARABIC LETTER RNOON" +
	" INITIAL FORMARABIC LETTER RNOON MEDIAL FORMARABIC LETTER HEH WITH YEH A" +
	"BOVE ISOLATED FORMARABIC LETTER HEH WITH YEH ABOVE FINAL FORMARABIC LETT" +
	"ER HEH GOAL ISOLATED FORMARABIC LETTER HEH GOAL FINAL FORMARABIC LETTER " +
	"HEH GOAL INITIAL FORMARABIC LETTER HEH GOAL MEDIAL FORMARABIC LETTER HEH" +
	" DOACHASHMEE ISOLATED FORMARABIC LETTER HEH DOACHASHMEE FINAL FORMARABIC" +
	" LETTER HEH DOACHASHMEE INITIAL FORMARABIC LETTER HEH DOACHASHMEE MEDIAL" +
	" FORMARABIC LETTER YEH BARREE ISOLATED FORMARABIC LETTER YEH BARREE FINA" +
	"L FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORMARABIC LETT" +
	"ER YEH BARREE WITH HAMZA ABOVE FINAL FORMARABIC SYMBOL DOT ABOVEARABIC S" +
	"YMBOL DOT BELOWARABIC SYMBOL TWO DOTS ABOVEARABIC SYMBOL TWO DOTS BELOWA" +
	"RABIC SYMBOL THREE DOTS ABOVEARABIC SYMBOL THREE DOTS BELOWARABIC SYMBOL" +
	" THREE DOTS POINTING DOWNWARDS ABOVEARABIC SYMBOL THREE DOTS POINTING DO" +
	"WNWARDS BELOWARABIC SYMBOL FOUR DOTS ABOVEARABIC SYMBOL FOUR DOTS BELOWA" +
	"RABIC SYMBOL DOUBLE VERTICAL BAR BELOWARABIC SYMBOL TWO DOTS VERTICALLY " +
	"ABOVEARABIC SYMBOL TWO DOTS VERTICALLY BELOWARABIC SYMBOL RINGARABIC SYM" +
	"BOL SMALL TAH ABOVEARABIC SYMBOL SMALL TAH BELOWARABIC LETTER NG ISOLATE" +
	"D FORMARABIC LETTER NG FINAL FORMARABIC LETTER NG INITIAL FORMARABIC LET" +
	"TER NG MEDIAL FORMARABIC LETTER U ISOLATED FORMARABIC LETTER U FINAL FOR" +
	"MARABIC LETTER OE ISOLATED FORMARABIC LETTER OE FINAL FORMARABIC LETTER " +
	"YU ISOLATED FORMARABIC LETTER YU FINAL FORMARABIC LETTER U WITH HAMZA AB" +
	"OVE ISOLATED FORMARABIC LETTER VE ISOLATED FORMARABIC LETTER VE FINAL FO" +
	"RMARABIC LETTER KIRGHIZ OE ISOLATED FORMARABIC LETTER KIRGHIZ OE FINAL F" +
	"ORMARABIC LETTER KIRGHIZ YU ISOLATED FORMARABIC LETTER KIRGHIZ YU FINAL " +
	"FORMARABIC LETTER E ISOLATED FORMARABIC LETTER E FINAL FORMARABIC LETTER" +
	" E INITIAL FORMARABIC LETTER E MEDIAL FORMARABIC LETTER UIGHUR KAZAKH KI" +
	"RGHIZ ALEF MAKSURA INITIAL FORMARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF " +
	"MAKSURA MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLAT" +
	"ED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORMARABIC L" +
	"IGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORMARABIC LIGATURE YEH WI" +
	"TH HAMZA ABOVE WITH AE FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WI" +
	"TH WAW ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL " +
	"FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORMARABIC LIGA" +
	"TURE YEH WITH HAMZA ABOVE WITH U FINAL FORMARABIC LIGATURE YEH WITH HAMZ" +
	"A ABOVE WITH OE ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH O" +
	"E FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORMAR" +
	"ABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORMARABIC LIGATURE YEH" +
	" WITH HAMZA ABOVE WITH E ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABO" +
	"VE WITH E FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL " +
	"FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSUR" +
	"A ISOLATED FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH " +
	"ALEF MAKSURA FINAL FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABO" +
	"VE WITH ALEF MAKSURA INITIAL FORMARABIC LETTER FARSI YEH ISOLATED FORMAR" +
	"ABIC LETTER FARSI YEH FINAL FORMARABIC LETTER FARSI YEH INITIAL FORMARAB" +
	"IC LETTER FARSI YEH MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH" +
	" JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATE" +
	"D FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORMARABIC" +
	" LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORMARABIC LIG" +
	"ATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORMARABIC LIGATURE BEH WIT" +
	"H JEEM ISOLATED FORMARABIC LIGATURE BEH WITH HAH ISOLATED FORMARABIC LIG" +
	"ATURE BEH WITH KHAH ISOLATED FORMARABIC LIGATURE BEH WITH MEEM ISOLATED " +
	"FORMARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE B" +
	"EH WITH YEH ISOLATED FORMARABIC LIGATURE TEH WITH JEEM ISOLATED FORMARAB") + ("" +
	"IC LIGATURE TEH WITH HAH ISOLATED FORMARABIC LIGATURE TEH WITH KHAH ISOL" +
	"ATED FORMARABIC LIGATURE TEH WITH MEEM ISOLATED FORMARABIC LIGATURE TEH " +
	"WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TEH WITH YEH ISOLATED FOR" +
	"MARABIC LIGATURE THEH WITH JEEM ISOLATED FORMARABIC LIGATURE THEH WITH M" +
	"EEM ISOLATED FORMARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORMARA" +
	"BIC LIGATURE THEH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM WITH HAH IS" +
	"OLATED FORMARABIC LIGATURE JEEM WITH MEEM ISOLATED FORMARABIC LIGATURE H" +
	"AH WITH JEEM ISOLATED FORMARABIC LIGATURE HAH WITH MEEM ISOLATED FORMARA" +
	"BIC LIGATURE KHAH WITH JEEM ISOLATED FORMARABIC LIGATURE KHAH WITH HAH I" +
	"SOLATED FORMARABIC LIGATURE KHAH WITH MEEM ISOLATED FORMARABIC LIGATURE " +
	"SEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SEEN WITH HAH ISOLATED FORMA" +
	"RABIC LIGATURE SEEN WITH KHAH ISOLATED FORMARABIC LIGATURE SEEN WITH MEE" +
	"M ISOLATED FORMARABIC LIGATURE SAD WITH HAH ISOLATED FORMARABIC LIGATURE" +
	" SAD WITH MEEM ISOLATED FORMARABIC LIGATURE DAD WITH JEEM ISOLATED FORMA" +
	"RABIC LIGATURE DAD WITH HAH ISOLATED FORMARABIC LIGATURE DAD WITH KHAH I" +
	"SOLATED FORMARABIC LIGATURE DAD WITH MEEM ISOLATED FORMARABIC LIGATURE T" +
	"AH WITH HAH ISOLATED FORMARABIC LIGATURE TAH WITH MEEM ISOLATED FORMARAB" +
	"IC LIGATURE ZAH WITH MEEM ISOLATED FORMARABIC LIGATURE AIN WITH JEEM ISO" +
	"LATED FORMARABIC LIGATURE AIN WITH MEEM ISOLATED FORMARABIC LIGATURE GHA" +
	"IN WITH JEEM ISOLATED FORMARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORMA" +
	"RABIC LIGATURE FEH WITH JEEM ISOLATED FORMARABIC LIGATURE FEH WITH HAH I" +
	"SOLATED FORMARABIC LIGATURE FEH WITH KHAH ISOLATED FORMARABIC LIGATURE F" +
	"EH WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED" +
	" FORMARABIC LIGATURE FEH WITH YEH ISOLATED FORMARABIC LIGATURE QAF WITH " +
	"HAH ISOLATED FORMARABIC LIGATURE QAF WITH MEEM ISOLATED FORMARABIC LIGAT" +
	"URE QAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE QAF WITH YEH ISOL" +
	"ATED FORMARABIC LIGATURE KAF WITH ALEF ISOLATED FORMARABIC LIGATURE KAF " +
	"WITH JEEM ISOLATED FORMARABIC LIGATURE KAF WITH HAH ISOLATED FORMARABIC " +
	"LIGATURE KAF WITH KHAH ISOLATED FORMARABIC LIGATURE KAF WITH LAM ISOLATE" +
	"D FORMARABIC LIGATURE KAF WITH MEEM ISOLATED FORMARABIC LIGATURE KAF WIT" +
	"H ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KAF WITH YEH ISOLATED FORMAR" +
	"ABIC LIGATURE LAM WITH JEEM ISOLATED FORMARABIC LIGATURE LAM WITH HAH IS" +
	"OLATED FORMARABIC LIGATURE LAM WITH KHAH ISOLATED FORMARABIC LIGATURE LA" +
	"M WITH MEEM ISOLATED FORMARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED " +
	"FORMARABIC LIGATURE LAM WITH YEH ISOLATED FORMARABIC LIGATURE MEEM WITH " +
	"JEEM ISOLATED FORMARABIC LIGATURE MEEM WITH HAH ISOLATED FORMARABIC LIGA" +
	"TURE MEEM WITH KHAH ISOLATED FORMARABIC LIGATURE MEEM WITH MEEM ISOLATED" +
	" FORMARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE" +
	" MEEM WITH YEH ISOLATED FORMARABIC LIGATURE NOON WITH JEEM ISOLATED FORM" +
	"ARABIC LIGATURE NOON WITH HAH ISOLATED FORMARABIC LIGATURE NOON WITH KHA" +
	"H ISOLATED FORMARABIC LIGATURE NOON WITH MEEM ISOLATED FORMARABIC LIGATU" +
	"RE NOON WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE NOON WITH YEH ISO" +
	"LATED FORMARABIC LIGATURE HEH WITH JEEM ISOLATED FORMARABIC LIGATURE HEH" +
	" WITH MEEM ISOLATED FORMARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED F" +
	"ORMARABIC LIGATURE HEH WITH YEH ISOLATED FORMARABIC LIGATURE YEH WITH JE" +
	"EM ISOLATED FORMARABIC LIGATURE YEH WITH HAH ISOLATED FORMARABIC LIGATUR" +
	"E YEH WITH KHAH ISOLATED FORMARABIC LIGATURE YEH WITH MEEM ISOLATED FORM" +
	"ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE YEH W" +
	"ITH YEH ISOLATED FORMARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED" +
	" FORMARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LIGAT" +
	"URE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LIGATURE SHAD" +
	"DA WITH DAMMATAN ISOLATED FORMARABIC LIGATURE SHADDA WITH KASRATAN ISOLA" +
	"TED FORMARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORMARABIC LIGATURE S" +
	"HADDA WITH DAMMA ISOLATED FORMARABIC LIGATURE SHADDA WITH KASRA ISOLATED" +
	" FORMARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LI" +
	"GATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORMARABIC LIGATURE YEH WITH " +
	"HAMZA ABOVE WITH ZAIN FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WIT" +
	"H MEEM FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FO" +
	"RMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORMARABI" +
	"C LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORMARABIC LIGATURE BEH W" +
	"ITH REH FINAL FORMARABIC LIGATURE BEH WITH ZAIN FINAL FORMARABIC LIGATUR" +
	"E BEH WITH MEEM FINAL FORMARABIC LIGATURE BEH WITH NOON FINAL FORMARABIC" +
	" LIGATURE BEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE BEH WITH YEH F" +
	"INAL FORMARABIC LIGATURE TEH WITH REH FINAL FORMARABIC LIGATURE TEH WITH") + ("" +
	" ZAIN FINAL FORMARABIC LIGATURE TEH WITH MEEM FINAL FORMARABIC LIGATURE " +
	"TEH WITH NOON FINAL FORMARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM" +
	"ARABIC LIGATURE TEH WITH YEH FINAL FORMARABIC LIGATURE THEH WITH REH FIN" +
	"AL FORMARABIC LIGATURE THEH WITH ZAIN FINAL FORMARABIC LIGATURE THEH WIT" +
	"H MEEM FINAL FORMARABIC LIGATURE THEH WITH NOON FINAL FORMARABIC LIGATUR" +
	"E THEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE THEH WITH YEH FINAL F" +
	"ORMARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE FEH W" +
	"ITH YEH FINAL FORMARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE QAF WITH YEH FINAL FORMARABIC LIGATURE KAF WITH ALEF FINAL FOR" +
	"MARABIC LIGATURE KAF WITH LAM FINAL FORMARABIC LIGATURE KAF WITH MEEM FI" +
	"NAL FORMARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE " +
	"KAF WITH YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM FINAL FORMARABIC LI" +
	"GATURE LAM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE LAM WITH YEH FINA" +
	"L FORMARABIC LIGATURE MEEM WITH ALEF FINAL FORMARABIC LIGATURE MEEM WITH" +
	" MEEM FINAL FORMARABIC LIGATURE NOON WITH REH FINAL FORMARABIC LIGATURE " +
	"NOON WITH ZAIN FINAL FORMARABIC LIGATURE NOON WITH MEEM FINAL FORMARABIC" +
	" LIGATURE NOON WITH NOON FINAL FORMARABIC LIGATURE NOON WITH ALEF MAKSUR" +
	"A FINAL FORMARABIC LIGATURE NOON WITH YEH FINAL FORMARABIC LIGATURE ALEF" +
	" MAKSURA WITH SUPERSCRIPT ALEF FINAL FORMARABIC LIGATURE YEH WITH REH FI" +
	"NAL FORMARABIC LIGATURE YEH WITH ZAIN FINAL FORMARABIC LIGATURE YEH WITH" +
	" MEEM FINAL FORMARABIC LIGATURE YEH WITH NOON FINAL FORMARABIC LIGATURE " +
	"YEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WITH YEH FINAL FORMA" +
	"RABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORMARABIC LIGATUR" +
	"E YEH WITH HAMZA ABOVE WITH HAH INITIAL FORMARABIC LIGATURE YEH WITH HAM" +
	"ZA ABOVE WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH" +
	" MEEM INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL " +
	"FORMARABIC LIGATURE BEH WITH JEEM INITIAL FORMARABIC LIGATURE BEH WITH H" +
	"AH INITIAL FORMARABIC LIGATURE BEH WITH KHAH INITIAL FORMARABIC LIGATURE" +
	" BEH WITH MEEM INITIAL FORMARABIC LIGATURE BEH WITH HEH INITIAL FORMARAB" +
	"IC LIGATURE TEH WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH HAH INITI" +
	"AL FORMARABIC LIGATURE TEH WITH KHAH INITIAL FORMARABIC LIGATURE TEH WIT" +
	"H MEEM INITIAL FORMARABIC LIGATURE TEH WITH HEH INITIAL FORMARABIC LIGAT" +
	"URE THEH WITH MEEM INITIAL FORMARABIC LIGATURE JEEM WITH HAH INITIAL FOR" +
	"MARABIC LIGATURE JEEM WITH MEEM INITIAL FORMARABIC LIGATURE HAH WITH JEE" +
	"M INITIAL FORMARABIC LIGATURE HAH WITH MEEM INITIAL FORMARABIC LIGATURE " +
	"KHAH WITH JEEM INITIAL FORMARABIC LIGATURE KHAH WITH MEEM INITIAL FORMAR" +
	"ABIC LIGATURE SEEN WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH HAH I" +
	"NITIAL FORMARABIC LIGATURE SEEN WITH KHAH INITIAL FORMARABIC LIGATURE SE" +
	"EN WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH HAH INITIAL FORMARABIC" +
	" LIGATURE SAD WITH KHAH INITIAL FORMARABIC LIGATURE SAD WITH MEEM INITIA" +
	"L FORMARABIC LIGATURE DAD WITH JEEM INITIAL FORMARABIC LIGATURE DAD WITH" +
	" HAH INITIAL FORMARABIC LIGATURE DAD WITH KHAH INITIAL FORMARABIC LIGATU" +
	"RE DAD WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH HAH INITIAL FORMAR" +
	"ABIC LIGATURE ZAH WITH MEEM INITIAL FORMARABIC LIGATURE AIN WITH JEEM IN" +
	"ITIAL FORMARABIC LIGATURE AIN WITH MEEM INITIAL FORMARABIC LIGATURE GHAI" +
	"N WITH JEEM INITIAL FORMARABIC LIGATURE GHAIN WITH MEEM INITIAL FORMARAB" +
	"IC LIGATURE FEH WITH JEEM INITIAL FORMARABIC LIGATURE FEH WITH HAH INITI" +
	"AL FORMARABIC LIGATURE FEH WITH KHAH INITIAL FORMARABIC LIGATURE FEH WIT" +
	"H MEEM INITIAL FORMARABIC LIGATURE QAF WITH HAH INITIAL FORMARABIC LIGAT" +
	"URE QAF WITH MEEM INITIAL FORMARABIC LIGATURE KAF WITH JEEM INITIAL FORM" +
	"ARABIC LIGATURE KAF WITH HAH INITIAL FORMARABIC LIGATURE KAF WITH KHAH I" +
	"NITIAL FORMARABIC LIGATURE KAF WITH LAM INITIAL FORMARABIC LIGATURE KAF " +
	"WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH JEEM INITIAL FORMARABIC L" +
	"IGATURE LAM WITH HAH INITIAL FORMARABIC LIGATURE LAM WITH KHAH INITIAL F" +
	"ORMARABIC LIGATURE LAM WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH HE" +
	"H INITIAL FORMARABIC LIGATURE MEEM WITH JEEM INITIAL FORMARABIC LIGATURE" +
	" MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH INITIAL FORMAR" +
	"ABIC LIGATURE MEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM " +
	"INITIAL FORMARABIC LIGATURE NOON WITH HAH INITIAL FORMARABIC LIGATURE NO" +
	"ON WITH KHAH INITIAL FORMARABIC LIGATURE NOON WITH MEEM INITIAL FORMARAB" +
	"IC LIGATURE NOON WITH HEH INITIAL FORMARABIC LIGATURE HEH WITH JEEM INIT" +
	"IAL FORMARABIC LIGATURE HEH WITH MEEM INITIAL FORMARABIC LIGATURE HEH WI" +
	"TH SUPERSCRIPT ALEF INITIAL FORMARABIC LIGATURE YEH WITH JEEM INITIAL FO" +
	"RMARABIC LIGATURE YEH WITH HAH INITIAL FORMARABIC LIGATURE YEH WITH KHAH") + ("" +
	" INITIAL FORMARABIC LIGATURE YEH WITH MEEM INITIAL FORMARABIC LIGATURE Y" +
	"EH WITH HEH INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM M" +
	"EDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORMARABI" +
	"C LIGATURE BEH WITH MEEM MEDIAL FORMARABIC LIGATURE BEH WITH HEH MEDIAL " +
	"FORMARABIC LIGATURE TEH WITH MEEM MEDIAL FORMARABIC LIGATURE TEH WITH HE" +
	"H MEDIAL FORMARABIC LIGATURE THEH WITH MEEM MEDIAL FORMARABIC LIGATURE T" +
	"HEH WITH HEH MEDIAL FORMARABIC LIGATURE SEEN WITH MEEM MEDIAL FORMARABIC" +
	" LIGATURE SEEN WITH HEH MEDIAL FORMARABIC LIGATURE SHEEN WITH MEEM MEDIA" +
	"L FORMARABIC LIGATURE SHEEN WITH HEH MEDIAL FORMARABIC LIGATURE KAF WITH" +
	" LAM MEDIAL FORMARABIC LIGATURE KAF WITH MEEM MEDIAL FORMARABIC LIGATURE" +
	" LAM WITH MEEM MEDIAL FORMARABIC LIGATURE NOON WITH MEEM MEDIAL FORMARAB" +
	"IC LIGATURE NOON WITH HEH MEDIAL FORMARABIC LIGATURE YEH WITH MEEM MEDIA" +
	"L FORMARABIC LIGATURE YEH WITH HEH MEDIAL FORMARABIC LIGATURE SHADDA WIT" +
	"H FATHA MEDIAL FORMARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORMARABIC L" +
	"IGATURE SHADDA WITH KASRA MEDIAL FORMARABIC LIGATURE TAH WITH ALEF MAKSU" +
	"RA ISOLATED FORMARABIC LIGATURE TAH WITH YEH ISOLATED FORMARABIC LIGATUR" +
	"E AIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE AIN WITH YEH ISOLAT" +
	"ED FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGAT" +
	"URE GHAIN WITH YEH ISOLATED FORMARABIC LIGATURE SEEN WITH ALEF MAKSURA I" +
	"SOLATED FORMARABIC LIGATURE SEEN WITH YEH ISOLATED FORMARABIC LIGATURE S" +
	"HEEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SHEEN WITH YEH ISOLA" +
	"TED FORMARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATU" +
	"RE HAH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOL" +
	"ATED FORMARABIC LIGATURE JEEM WITH YEH ISOLATED FORMARABIC LIGATURE KHAH" +
	" WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KHAH WITH YEH ISOLATED F" +
	"ORMARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SA" +
	"D WITH YEH ISOLATED FORMARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED F" +
	"ORMARABIC LIGATURE DAD WITH YEH ISOLATED FORMARABIC LIGATURE SHEEN WITH " +
	"JEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH HAH ISOLATED FORMARABIC LIG" +
	"ATURE SHEEN WITH KHAH ISOLATED FORMARABIC LIGATURE SHEEN WITH MEEM ISOLA" +
	"TED FORMARABIC LIGATURE SHEEN WITH REH ISOLATED FORMARABIC LIGATURE SEEN" +
	" WITH REH ISOLATED FORMARABIC LIGATURE SAD WITH REH ISOLATED FORMARABIC " +
	"LIGATURE DAD WITH REH ISOLATED FORMARABIC LIGATURE TAH WITH ALEF MAKSURA" +
	" FINAL FORMARABIC LIGATURE TAH WITH YEH FINAL FORMARABIC LIGATURE AIN WI" +
	"TH ALEF MAKSURA FINAL FORMARABIC LIGATURE AIN WITH YEH FINAL FORMARABIC " +
	"LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE GHAIN WITH YE" +
	"H FINAL FORMARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORMARABIC LIGA" +
	"TURE SEEN WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH ALEF MAKSURA FIN" +
	"AL FORMARABIC LIGATURE SHEEN WITH YEH FINAL FORMARABIC LIGATURE HAH WITH" +
	" ALEF MAKSURA FINAL FORMARABIC LIGATURE HAH WITH YEH FINAL FORMARABIC LI" +
	"GATURE JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH YEH FI" +
	"NAL FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE" +
	" KHAH WITH YEH FINAL FORMARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FOR" +
	"MARABIC LIGATURE SAD WITH YEH FINAL FORMARABIC LIGATURE DAD WITH ALEF MA" +
	"KSURA FINAL FORMARABIC LIGATURE DAD WITH YEH FINAL FORMARABIC LIGATURE S" +
	"HEEN WITH JEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH FINAL FORMARABIC" +
	" LIGATURE SHEEN WITH KHAH FINAL FORMARABIC LIGATURE SHEEN WITH MEEM FINA" +
	"L FORMARABIC LIGATURE SHEEN WITH REH FINAL FORMARABIC LIGATURE SEEN WITH" +
	" REH FINAL FORMARABIC LIGATURE SAD WITH REH FINAL FORMARABIC LIGATURE DA" +
	"D WITH REH FINAL FORMARABIC LIGATURE SHEEN WITH JEEM INITIAL FORMARABIC " +
	"LIGATURE SHEEN WITH HAH INITIAL FORMARABIC LIGATURE SHEEN WITH KHAH INIT" +
	"IAL FORMARABIC LIGATURE SHEEN WITH MEEM INITIAL FORMARABIC LIGATURE SEEN" +
	" WITH HEH INITIAL FORMARABIC LIGATURE SHEEN WITH HEH INITIAL FORMARABIC " +
	"LIGATURE TAH WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM MEDIAL" +
	" FORMARABIC LIGATURE SEEN WITH HAH MEDIAL FORMARABIC LIGATURE SEEN WITH " +
	"KHAH MEDIAL FORMARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORMARABIC LIGATU" +
	"RE SHEEN WITH HAH MEDIAL FORMARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM" +
	"ARABIC LIGATURE TAH WITH MEEM MEDIAL FORMARABIC LIGATURE ZAH WITH MEEM M" +
	"EDIAL FORMARABIC LIGATURE ALEF WITH FATHATAN FINAL FORMARABIC LIGATURE A" +
	"LEF WITH FATHATAN ISOLATED FORMORNATE LEFT PARENTHESISORNATE RIGHT PAREN" +
	"THESISARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E TEH WITH HAH WITH JEEM FINAL FORMARABIC LIGATURE TEH WITH HAH WITH JEE" +
	"M INITIAL FORMARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORMARABIC " +
	"LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH ME") + ("" +
	"EM WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL " +
	"FORMARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORMARABIC LIGATURE " +
	"JEEM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE JEEM WITH MEEM WITH HA" +
	"H INITIAL FORMARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORMARABIC LI" +
	"GATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WI" +
	"TH HAH WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM WITH HAH INI" +
	"TIAL FORMARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORMARAB" +
	"IC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE SEEN WITH " +
	"MEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITI" +
	"AL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATUR" +
	"E SEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH HAH WITH" +
	" HAH FINAL FORMARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORMARABIC " +
	"LIGATURE SAD WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH HA" +
	"H WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL F" +
	"ORMARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE SH" +
	"EEN WITH MEEM WITH KHAH FINAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH K" +
	"HAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORMARAB" +
	"IC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE DAD WI" +
	"TH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH ME" +
	"EM FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORMARABIC " +
	"LIGATURE TAH WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE TAH WITH MEEM " +
	"WITH HAH INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FOR" +
	"MARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE AIN WI" +
	"TH JEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM FINA" +
	"L FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E AIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE GHAIN WITH M" +
	"EEM WITH MEEM FINAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL F" +
	"ORMARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LI" +
	"GATURE FEH WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE FEH WITH KHAH W" +
	"ITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORMAR" +
	"ABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH" +
	" HAH WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FOR" +
	"MARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATUR" +
	"E LAM WITH JEEM WITH JEEM INITIAL FORMARABIC LIGATURE LAM WITH JEEM WITH" +
	" JEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORMARABIC" +
	" LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH M" +
	"EEM WITH HAH FINAL FORMARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FO" +
	"RMARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE ME" +
	"EM WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH HAH WITH YEH" +
	" FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORMARABIC LI" +
	"GATURE MEEM WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH KH" +
	"AH WITH JEEM INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIA" +
	"L FORMARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORMARABIC LIGATU" +
	"RE HEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE HEH WITH MEEM WIT" +
	"H MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORMA" +
	"RABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE" +
	" NOON WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH " +
	"MEEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL " +
	"FORMARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NO" +
	"ON WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WITH MEEM W" +
	"ITH MEEM FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORMA" +
	"RABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORMARABIC LIGATURE TEH WITH" +
	" JEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA" +
	" FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORMARABIC LIGAT" +
	"URE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH M" +
	"EEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA F" +
	"INAL FORMARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORMARABIC LIGATU" +
	"RE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH M" +
	"EEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WITH KHAH WITH ALEF" +
	" MAKSURA FINAL FORMARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORMARABI" +
	"C LIGATURE SHEEN WITH HAH WITH YEH FINAL FORMARABIC LIGATURE DAD WITH HA" +
	"H WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORMAR" +
	"ABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE YEH WITH " +
	"HAH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM") + ("" +
	"ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE MEEM WI" +
	"TH MEEM WITH YEH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL " +
	"FORMARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORMARABIC LIGATURE QAF" +
	" WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE LAM WITH HAH WITH MEEM I" +
	"NITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORMARABIC LIGAT" +
	"URE KAF WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH" +
	" HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORMARABI" +
	"C LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE KAF WITH " +
	"MEEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL F" +
	"ORMARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORMARABIC LIGATURE JEE" +
	"M WITH HAH WITH YEH FINAL FORMARABIC LIGATURE HAH WITH JEEM WITH YEH FIN" +
	"AL FORMARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE" +
	" FEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE BEH WITH HAH WITH YEH " +
	"FINAL FORMARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORMARABIC LIG" +
	"ATURE AIN WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH MEEM " +
	"WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM" +
	"ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE SALLA " +
	"USED AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGATURE QALA USED AS KORA" +
	"NIC STOP SIGN ISOLATED FORMARABIC LIGATURE ALLAH ISOLATED FORMARABIC LIG" +
	"ATURE AKBAR ISOLATED FORMARABIC LIGATURE MOHAMMAD ISOLATED FORMARABIC LI" +
	"GATURE SALAM ISOLATED FORMARABIC LIGATURE RASOUL ISOLATED FORMARABIC LIG" +
	"ATURE ALAYHE ISOLATED FORMARABIC LIGATURE WASALLAM ISOLATED FORMARABIC L" +
	"IGATURE SALLA ISOLATED FORMARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAMAR" +
	"ABIC LIGATURE JALLAJALALOUHOURIAL SIGNARABIC LIGATURE BISMILLAH AR-RAHMA" +
	"N AR-RAHEEMVARIATION SELECTOR-1VARIATION SELECTOR-2VARIATION SELECTOR-3V" +
	"ARIATION SELECTOR-4VARIATION SELECTOR-5VARIATION SELECTOR-6VARIATION SEL" +
	"ECTOR-7VARIATION SELECTOR-8VARIATION SELECTOR-9VARIATION SELECTOR-10VARI" +
	"ATION SELECTOR-11VARIATION SELECTOR-12VARIATION SELECTOR-13VARIATION SEL" +
	"ECTOR-14VARIATION SELECTOR-15VARIATION SELECTOR-16PRESENTATION FORM FOR " +
	"VERTICAL COMMAPRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMAPRESENTATI" +
	"ON FORM FOR VERTICAL IDEOGRAPHIC FULL STOPPRESENTATION FORM FOR VERTICAL" +
	" COLONPRESENTATION FORM FOR VERTICAL SEMICOLONPRESENTATION FORM FOR VERT" +
	"ICAL EXCLAMATION MARKPRESENTATION FORM FOR VERTICAL QUESTION MARKPRESENT" +
	"ATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKETPRESENTATION FORM F" +
	"OR VERTICAL RIGHT WHITE LENTICULAR BRAKCETPRESENTATION FORM FOR VERTICAL" +
	" HORIZONTAL ELLIPSISCOMBINING LIGATURE LEFT HALFCOMBINING LIGATURE RIGHT" +
	" HALFCOMBINING DOUBLE TILDE LEFT HALFCOMBINING DOUBLE TILDE RIGHT HALFCO" +
	"MBINING MACRON LEFT HALFCOMBINING MACRON RIGHT HALFCOMBINING CONJOINING " +
	"MACRONCOMBINING LIGATURE LEFT HALF BELOWCOMBINING LIGATURE RIGHT HALF BE" +
	"LOWCOMBINING TILDE LEFT HALF BELOWCOMBINING TILDE RIGHT HALF BELOWCOMBIN" +
	"ING MACRON LEFT HALF BELOWCOMBINING MACRON RIGHT HALF BELOWCOMBINING CON" +
	"JOINING MACRON BELOWCOMBINING CYRILLIC TITLO LEFT HALFCOMBINING CYRILLIC" +
	" TITLO RIGHT HALFPRESENTATION FORM FOR VERTICAL TWO DOT LEADERPRESENTATI" +
	"ON FORM FOR VERTICAL EM DASHPRESENTATION FORM FOR VERTICAL EN DASHPRESEN" +
	"TATION FORM FOR VERTICAL LOW LINEPRESENTATION FORM FOR VERTICAL WAVY LOW" +
	" LINEPRESENTATION FORM FOR VERTICAL LEFT PARENTHESISPRESENTATION FORM FO" +
	"R VERTICAL RIGHT PARENTHESISPRESENTATION FORM FOR VERTICAL LEFT CURLY BR" +
	"ACKETPRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKETPRESENTATION FORM" +
	" FOR VERTICAL LEFT TORTOISE SHELL BRACKETPRESENTATION FORM FOR VERTICAL " +
	"RIGHT TORTOISE SHELL BRACKETPRESENTATION FORM FOR VERTICAL LEFT BLACK LE" +
	"NTICULAR BRACKETPRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BR" +
	"ACKETPRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKETPRESENTATIO" +
	"N FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKETPRESENTATION FORM FOR VERT" +
	"ICAL LEFT ANGLE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKE" +
	"TPRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKETPRESENTATION FORM FOR" +
	" VERTICAL RIGHT CORNER BRACKETPRESENTATION FORM FOR VERTICAL LEFT WHITE " +
	"CORNER BRACKETPRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKETS" +
	"ESAME DOTWHITE SESAME DOTPRESENTATION FORM FOR VERTICAL LEFT SQUARE BRAC" +
	"KETPRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKETDASHED OVERLINECEN" +
	"TRELINE OVERLINEWAVY OVERLINEDOUBLE WAVY OVERLINEDASHED LOW LINECENTRELI" +
	"NE LOW LINEWAVY LOW LINESMALL COMMASMALL IDEOGRAPHIC COMMASMALL FULL STO" +
	"PSMALL SEMICOLONSMALL COLONSMALL QUESTION MARKSMALL EXCLAMATION MARKSMAL" +
	"L EM DASHSMALL LEFT PARENTHESISSMALL RIGHT PARENTHESISSMALL LEFT CURLY B" +
	"RACKETSMALL RIGHT CURLY BRACKETSMALL LEFT TORTOISE SHELL BRACKETSMALL RI") + ("" +
	"GHT TORTOISE SHELL BRACKETSMALL NUMBER SIGNSMALL AMPERSANDSMALL ASTERISK" +
	"SMALL PLUS SIGNSMALL HYPHEN-MINUSSMALL LESS-THAN SIGNSMALL GREATER-THAN " +
	"SIGNSMALL EQUALS SIGNSMALL REVERSE SOLIDUSSMALL DOLLAR SIGNSMALL PERCENT" +
	" SIGNSMALL COMMERCIAL ATARABIC FATHATAN ISOLATED FORMARABIC TATWEEL WITH" +
	" FATHATAN ABOVEARABIC DAMMATAN ISOLATED FORMARABIC TAIL FRAGMENTARABIC K" +
	"ASRATAN ISOLATED FORMARABIC FATHA ISOLATED FORMARABIC FATHA MEDIAL FORMA" +
	"RABIC DAMMA ISOLATED FORMARABIC DAMMA MEDIAL FORMARABIC KASRA ISOLATED F" +
	"ORMARABIC KASRA MEDIAL FORMARABIC SHADDA ISOLATED FORMARABIC SHADDA MEDI" +
	"AL FORMARABIC SUKUN ISOLATED FORMARABIC SUKUN MEDIAL FORMARABIC LETTER H" +
	"AMZA ISOLATED FORMARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORMARABI" +
	"C LETTER ALEF WITH MADDA ABOVE FINAL FORMARABIC LETTER ALEF WITH HAMZA A" +
	"BOVE ISOLATED FORMARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORMARABIC L" +
	"ETTER WAW WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER WAW WITH HAMZA ABO" +
	"VE FINAL FORMARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORMARABIC LET" +
	"TER ALEF WITH HAMZA BELOW FINAL FORMARABIC LETTER YEH WITH HAMZA ABOVE I" +
	"SOLATED FORMARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORMARABIC LETTER Y" +
	"EH WITH HAMZA ABOVE INITIAL FORMARABIC LETTER YEH WITH HAMZA ABOVE MEDIA" +
	"L FORMARABIC LETTER ALEF ISOLATED FORMARABIC LETTER ALEF FINAL FORMARABI" +
	"C LETTER BEH ISOLATED FORMARABIC LETTER BEH FINAL FORMARABIC LETTER BEH " +
	"INITIAL FORMARABIC LETTER BEH MEDIAL FORMARABIC LETTER TEH MARBUTA ISOLA" +
	"TED FORMARABIC LETTER TEH MARBUTA FINAL FORMARABIC LETTER TEH ISOLATED F" +
	"ORMARABIC LETTER TEH FINAL FORMARABIC LETTER TEH INITIAL FORMARABIC LETT" +
	"ER TEH MEDIAL FORMARABIC LETTER THEH ISOLATED FORMARABIC LETTER THEH FIN" +
	"AL FORMARABIC LETTER THEH INITIAL FORMARABIC LETTER THEH MEDIAL FORMARAB" +
	"IC LETTER JEEM ISOLATED FORMARABIC LETTER JEEM FINAL FORMARABIC LETTER J" +
	"EEM INITIAL FORMARABIC LETTER JEEM MEDIAL FORMARABIC LETTER HAH ISOLATED" +
	" FORMARABIC LETTER HAH FINAL FORMARABIC LETTER HAH INITIAL FORMARABIC LE" +
	"TTER HAH MEDIAL FORMARABIC LETTER KHAH ISOLATED FORMARABIC LETTER KHAH F" +
	"INAL FORMARABIC LETTER KHAH INITIAL FORMARABIC LETTER KHAH MEDIAL FORMAR" +
	"ABIC LETTER DAL ISOLATED FORMARABIC LETTER DAL FINAL FORMARABIC LETTER T" +
	"HAL ISOLATED FORMARABIC LETTER THAL FINAL FORMARABIC LETTER REH ISOLATED" +
	" FORMARABIC LETTER REH FINAL FORMARABIC LETTER ZAIN ISOLATED FORMARABIC " +
	"LETTER ZAIN FINAL FORMARABIC LETTER SEEN ISOLATED FORMARABIC LETTER SEEN" +
	" FINAL FORMARABIC LETTER SEEN INITIAL FORMARABIC LETTER SEEN MEDIAL FORM" +
	"ARABIC LETTER SHEEN ISOLATED FORMARABIC LETTER SHEEN FINAL FORMARABIC LE" +
	"TTER SHEEN INITIAL FORMARABIC LETTER SHEEN MEDIAL FORMARABIC LETTER SAD " +
	"ISOLATED FORMARABIC LETTER SAD FINAL FORMARABIC LETTER SAD INITIAL FORMA" +
	"RABIC LETTER SAD MEDIAL FORMARABIC LETTER DAD ISOLATED FORMARABIC LETTER" +
	" DAD FINAL FORMARABIC LETTER DAD INITIAL FORMARABIC LETTER DAD MEDIAL FO" +
	"RMARABIC LETTER TAH ISOLATED FORMARABIC LETTER TAH FINAL FORMARABIC LETT" +
	"ER TAH INITIAL FORMARABIC LETTER TAH MEDIAL FORMARABIC LETTER ZAH ISOLAT" +
	"ED FORMARABIC LETTER ZAH FINAL FORMARABIC LETTER ZAH INITIAL FORMARABIC " +
	"LETTER ZAH MEDIAL FORMARABIC LETTER AIN ISOLATED FORMARABIC LETTER AIN F" +
	"INAL FORMARABIC LETTER AIN INITIAL FORMARABIC LETTER AIN MEDIAL FORMARAB" +
	"IC LETTER GHAIN ISOLATED FORMARABIC LETTER GHAIN FINAL FORMARABIC LETTER" +
	" GHAIN INITIAL FORMARABIC LETTER GHAIN MEDIAL FORMARABIC LETTER FEH ISOL" +
	"ATED FORMARABIC LETTER FEH FINAL FORMARABIC LETTER FEH INITIAL FORMARABI" +
	"C LETTER FEH MEDIAL FORMARABIC LETTER QAF ISOLATED FORMARABIC LETTER QAF" +
	" FINAL FORMARABIC LETTER QAF INITIAL FORMARABIC LETTER QAF MEDIAL FORMAR" +
	"ABIC LETTER KAF ISOLATED FORMARABIC LETTER KAF FINAL FORMARABIC LETTER K" +
	"AF INITIAL FORMARABIC LETTER KAF MEDIAL FORMARABIC LETTER LAM ISOLATED F" +
	"ORMARABIC LETTER LAM FINAL FORMARABIC LETTER LAM INITIAL FORMARABIC LETT" +
	"ER LAM MEDIAL FORMARABIC LETTER MEEM ISOLATED FORMARABIC LETTER MEEM FIN" +
	"AL FORMARABIC LETTER MEEM INITIAL FORMARABIC LETTER MEEM MEDIAL FORMARAB" +
	"IC LETTER NOON ISOLATED FORMARABIC LETTER NOON FINAL FORMARABIC LETTER N" +
	"OON INITIAL FORMARABIC LETTER NOON MEDIAL FORMARABIC LETTER HEH ISOLATED" +
	" FORMARABIC LETTER HEH FINAL FORMARABIC LETTER HEH INITIAL FORMARABIC LE" +
	"TTER HEH MEDIAL FORMARABIC LETTER WAW ISOLATED FORMARABIC LETTER WAW FIN" +
	"AL FORMARABIC LETTER ALEF MAKSURA ISOLATED FORMARABIC LETTER ALEF MAKSUR" +
	"A FINAL FORMARABIC LETTER YEH ISOLATED FORMARABIC LETTER YEH FINAL FORMA" +
	"RABIC LETTER YEH INITIAL FORMARABIC LETTER YEH MEDIAL FORMARABIC LIGATUR" +
	"E LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH A" +
	"LEF WITH MADDA ABOVE FINAL FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA " +
	"ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL ") + ("" +
	"FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORMARABIC L" +
	"IGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORMARABIC LIGATURE LAM WIT" +
	"H ALEF ISOLATED FORMARABIC LIGATURE LAM WITH ALEF FINAL FORMZERO WIDTH N" +
	"O-BREAK SPACEFULLWIDTH EXCLAMATION MARKFULLWIDTH QUOTATION MARKFULLWIDTH" +
	" NUMBER SIGNFULLWIDTH DOLLAR SIGNFULLWIDTH PERCENT SIGNFULLWIDTH AMPERSA" +
	"NDFULLWIDTH APOSTROPHEFULLWIDTH LEFT PARENTHESISFULLWIDTH RIGHT PARENTHE" +
	"SISFULLWIDTH ASTERISKFULLWIDTH PLUS SIGNFULLWIDTH COMMAFULLWIDTH HYPHEN-" +
	"MINUSFULLWIDTH FULL STOPFULLWIDTH SOLIDUSFULLWIDTH DIGIT ZEROFULLWIDTH D" +
	"IGIT ONEFULLWIDTH DIGIT TWOFULLWIDTH DIGIT THREEFULLWIDTH DIGIT FOURFULL" +
	"WIDTH DIGIT FIVEFULLWIDTH DIGIT SIXFULLWIDTH DIGIT SEVENFULLWIDTH DIGIT " +
	"EIGHTFULLWIDTH DIGIT NINEFULLWIDTH COLONFULLWIDTH SEMICOLONFULLWIDTH LES" +
	"S-THAN SIGNFULLWIDTH EQUALS SIGNFULLWIDTH GREATER-THAN SIGNFULLWIDTH QUE" +
	"STION MARKFULLWIDTH COMMERCIAL ATFULLWIDTH LATIN CAPITAL LETTER AFULLWID" +
	"TH LATIN CAPITAL LETTER BFULLWIDTH LATIN CAPITAL LETTER CFULLWIDTH LATIN" +
	" CAPITAL LETTER DFULLWIDTH LATIN CAPITAL LETTER EFULLWIDTH LATIN CAPITAL" +
	" LETTER FFULLWIDTH LATIN CAPITAL LETTER GFULLWIDTH LATIN CAPITAL LETTER " +
	"HFULLWIDTH LATIN CAPITAL LETTER IFULLWIDTH LATIN CAPITAL LETTER JFULLWID" +
	"TH LATIN CAPITAL LETTER KFULLWIDTH LATIN CAPITAL LETTER LFULLWIDTH LATIN" +
	" CAPITAL LETTER MFULLWIDTH LATIN CAPITAL LETTER NFULLWIDTH LATIN CAPITAL" +
	" LETTER OFULLWIDTH LATIN CAPITAL LETTER PFULLWIDTH LATIN CAPITAL LETTER " +
	"QFULLWIDTH LATIN CAPITAL LETTER RFULLWIDTH LATIN CAPITAL LETTER SFULLWID" +
	"TH LATIN CAPITAL LETTER TFULLWIDTH LATIN CAPITAL LETTER UFULLWIDTH LATIN" +
	" CAPITAL LETTER VFULLWIDTH LATIN CAPITAL LETTER WFULLWIDTH LATIN CAPITAL" +
	" LETTER XFULLWIDTH LATIN CAPITAL LETTER YFULLWIDTH LATIN CAPITAL LETTER " +
	"ZFULLWIDTH LEFT SQUARE BRACKETFULLWIDTH REVERSE SOLIDUSFULLWIDTH RIGHT S" +
	"QUARE BRACKETFULLWIDTH CIRCUMFLEX ACCENTFULLWIDTH LOW LINEFULLWIDTH GRAV" +
	"E ACCENTFULLWIDTH LATIN SMALL LETTER AFULLWIDTH LATIN SMALL LETTER BFULL" +
	"WIDTH LATIN SMALL LETTER CFULLWIDTH LATIN SMALL LETTER DFULLWIDTH LATIN " +
	"SMALL LETTER EFULLWIDTH LATIN SMALL LETTER FFULLWIDTH LATIN SMALL LETTER" +
	" GFULLWIDTH LATIN SMALL LETTER HFULLWIDTH LATIN SMALL LETTER IFULLWIDTH " +
	"LATIN SMALL LETTER JFULLWIDTH LATIN SMALL LETTER KFULLWIDTH LATIN SMALL " +
	"LETTER LFULLWIDTH LATIN SMALL LETTER MFULLWIDTH LATIN SMALL LETTER NFULL" +
	"WIDTH LATIN SMALL LETTER OFULLWIDTH LATIN SMALL LETTER PFULLWIDTH LATIN " +
	"SMALL LETTER QFULLWIDTH LATIN SMALL LETTER RFULLWIDTH LATIN SMALL LETTER" +
	" SFULLWIDTH LATIN SMALL LETTER TFULLWIDTH LATIN SMALL LETTER UFULLWIDTH " +
	"LATIN SMALL LETTER VFULLWIDTH LATIN SMALL LETTER WFULLWIDTH LATIN SMALL " +
	"LETTER XFULLWIDTH LATIN SMALL LETTER YFULLWIDTH LATIN SMALL LETTER ZFULL" +
	"WIDTH LEFT CURLY BRACKETFULLWIDTH VERTICAL LINEFULLWIDTH RIGHT CURLY BRA" +
	"CKETFULLWIDTH TILDEFULLWIDTH LEFT WHITE PARENTHESISFULLWIDTH RIGHT WHITE" +
	" PARENTHESISHALFWIDTH IDEOGRAPHIC FULL STOPHALFWIDTH LEFT CORNER BRACKET" +
	"HALFWIDTH RIGHT CORNER BRACKETHALFWIDTH IDEOGRAPHIC COMMAHALFWIDTH KATAK" +
	"ANA MIDDLE DOTHALFWIDTH KATAKANA LETTER WOHALFWIDTH KATAKANA LETTER SMAL" +
	"L AHALFWIDTH KATAKANA LETTER SMALL IHALFWIDTH KATAKANA LETTER SMALL UHAL" +
	"FWIDTH KATAKANA LETTER SMALL EHALFWIDTH KATAKANA LETTER SMALL OHALFWIDTH" +
	" KATAKANA LETTER SMALL YAHALFWIDTH KATAKANA LETTER SMALL YUHALFWIDTH KAT" +
	"AKANA LETTER SMALL YOHALFWIDTH KATAKANA LETTER SMALL TUHALFWIDTH KATAKAN" +
	"A-HIRAGANA PROLONGED SOUND MARKHALFWIDTH KATAKANA LETTER AHALFWIDTH KATA" +
	"KANA LETTER IHALFWIDTH KATAKANA LETTER UHALFWIDTH KATAKANA LETTER EHALFW" +
	"IDTH KATAKANA LETTER OHALFWIDTH KATAKANA LETTER KAHALFWIDTH KATAKANA LET" +
	"TER KIHALFWIDTH KATAKANA LETTER KUHALFWIDTH KATAKANA LETTER KEHALFWIDTH " +
	"KATAKANA LETTER KOHALFWIDTH KATAKANA LETTER SAHALFWIDTH KATAKANA LETTER " +
	"SIHALFWIDTH KATAKANA LETTER SUHALFWIDTH KATAKANA LETTER SEHALFWIDTH KATA" +
	"KANA LETTER SOHALFWIDTH KATAKANA LETTER TAHALFWIDTH KATAKANA LETTER TIHA" +
	"LFWIDTH KATAKANA LETTER TUHALFWIDTH KATAKANA LETTER TEHALFWIDTH KATAKANA" +
	" LETTER TOHALFWIDTH KATAKANA LETTER NAHALFWIDTH KATAKANA LETTER NIHALFWI" +
	"DTH KATAKANA LETTER NUHALFWIDTH KATAKANA LETTER NEHALFWIDTH KATAKANA LET" +
	"TER NOHALFWIDTH KATAKANA LETTER HAHALFWIDTH KATAKANA LETTER HIHALFWIDTH " +
	"KATAKANA LETTER HUHALFWIDTH KATAKANA LETTER HEHALFWIDTH KATAKANA LETTER " +
	"HOHALFWIDTH KATAKANA LETTER MAHALFWIDTH KATAKANA LETTER MIHALFWIDTH KATA" +
	"KANA LETTER MUHALFWIDTH KATAKANA LETTER MEHALFWIDTH KATAKANA LETTER MOHA" +
	"LFWIDTH KATAKANA LETTER YAHALFWIDTH KATAKANA LETTER YUHALFWIDTH KATAKANA" +
	" LETTER YOHALFWIDTH KATAKANA LETTER RAHALFWIDTH KATAKANA LETTER RIHALFWI" +
	"DTH KATAKANA LETTER RUHALFWIDTH KATAKANA LETTER REHALFWIDTH KATAKANA LET" +
	"TER ROHALFWIDTH KATAKANA LETTER WAHALFWIDTH KATAKANA LETTER NHALFWIDTH K") + ("" +
	"ATAKANA VOICED SOUND MARKHALFWIDTH KATAKANA SEMI-VOICED SOUND MARKHALFWI" +
	"DTH HANGUL FILLERHALFWIDTH HANGUL LETTER KIYEOKHALFWIDTH HANGUL LETTER S" +
	"SANGKIYEOKHALFWIDTH HANGUL LETTER KIYEOK-SIOSHALFWIDTH HANGUL LETTER NIE" +
	"UNHALFWIDTH HANGUL LETTER NIEUN-CIEUCHALFWIDTH HANGUL LETTER NIEUN-HIEUH" +
	"HALFWIDTH HANGUL LETTER TIKEUTHALFWIDTH HANGUL LETTER SSANGTIKEUTHALFWID" +
	"TH HANGUL LETTER RIEULHALFWIDTH HANGUL LETTER RIEUL-KIYEOKHALFWIDTH HANG" +
	"UL LETTER RIEUL-MIEUMHALFWIDTH HANGUL LETTER RIEUL-PIEUPHALFWIDTH HANGUL" +
	" LETTER RIEUL-SIOSHALFWIDTH HANGUL LETTER RIEUL-THIEUTHHALFWIDTH HANGUL " +
	"LETTER RIEUL-PHIEUPHHALFWIDTH HANGUL LETTER RIEUL-HIEUHHALFWIDTH HANGUL " +
	"LETTER MIEUMHALFWIDTH HANGUL LETTER PIEUPHALFWIDTH HANGUL LETTER SSANGPI" +
	"EUPHALFWIDTH HANGUL LETTER PIEUP-SIOSHALFWIDTH HANGUL LETTER SIOSHALFWID" +
	"TH HANGUL LETTER SSANGSIOSHALFWIDTH HANGUL LETTER IEUNGHALFWIDTH HANGUL " +
	"LETTER CIEUCHALFWIDTH HANGUL LETTER SSANGCIEUCHALFWIDTH HANGUL LETTER CH" +
	"IEUCHHALFWIDTH HANGUL LETTER KHIEUKHHALFWIDTH HANGUL LETTER THIEUTHHALFW" +
	"IDTH HANGUL LETTER PHIEUPHHALFWIDTH HANGUL LETTER HIEUHHALFWIDTH HANGUL " +
	"LETTER AHALFWIDTH HANGUL LETTER AEHALFWIDTH HANGUL LETTER YAHALFWIDTH HA" +
	"NGUL LETTER YAEHALFWIDTH HANGUL LETTER EOHALFWIDTH HANGUL LETTER EHALFWI" +
	"DTH HANGUL LETTER YEOHALFWIDTH HANGUL LETTER YEHALFWIDTH HANGUL LETTER O" +
	"HALFWIDTH HANGUL LETTER WAHALFWIDTH HANGUL LETTER WAEHALFWIDTH HANGUL LE" +
	"TTER OEHALFWIDTH HANGUL LETTER YOHALFWIDTH HANGUL LETTER UHALFWIDTH HANG" +
	"UL LETTER WEOHALFWIDTH HANGUL LETTER WEHALFWIDTH HANGUL LETTER WIHALFWID" +
	"TH HANGUL LETTER YUHALFWIDTH HANGUL LETTER EUHALFWIDTH HANGUL LETTER YIH" +
	"ALFWIDTH HANGUL LETTER IFULLWIDTH CENT SIGNFULLWIDTH POUND SIGNFULLWIDTH" +
	" NOT SIGNFULLWIDTH MACRONFULLWIDTH BROKEN BARFULLWIDTH YEN SIGNFULLWIDTH" +
	" WON SIGNHALFWIDTH FORMS LIGHT VERTICALHALFWIDTH LEFTWARDS ARROWHALFWIDT" +
	"H UPWARDS ARROWHALFWIDTH RIGHTWARDS ARROWHALFWIDTH DOWNWARDS ARROWHALFWI" +
	"DTH BLACK SQUAREHALFWIDTH WHITE CIRCLEINTERLINEAR ANNOTATION ANCHORINTER" +
	"LINEAR ANNOTATION SEPARATORINTERLINEAR ANNOTATION TERMINATOROBJECT REPLA" +
	"CEMENT CHARACTERREPLACEMENT CHARACTERLINEAR B SYLLABLE B008 ALINEAR B SY" +
	"LLABLE B038 ELINEAR B SYLLABLE B028 ILINEAR B SYLLABLE B061 OLINEAR B SY" +
	"LLABLE B010 ULINEAR B SYLLABLE B001 DALINEAR B SYLLABLE B045 DELINEAR B " +
	"SYLLABLE B007 DILINEAR B SYLLABLE B014 DOLINEAR B SYLLABLE B051 DULINEAR" +
	" B SYLLABLE B057 JALINEAR B SYLLABLE B046 JELINEAR B SYLLABLE B036 JOLIN" +
	"EAR B SYLLABLE B065 JULINEAR B SYLLABLE B077 KALINEAR B SYLLABLE B044 KE" +
	"LINEAR B SYLLABLE B067 KILINEAR B SYLLABLE B070 KOLINEAR B SYLLABLE B081" +
	" KULINEAR B SYLLABLE B080 MALINEAR B SYLLABLE B013 MELINEAR B SYLLABLE B" +
	"073 MILINEAR B SYLLABLE B015 MOLINEAR B SYLLABLE B023 MULINEAR B SYLLABL" +
	"E B006 NALINEAR B SYLLABLE B024 NELINEAR B SYLLABLE B030 NILINEAR B SYLL" +
	"ABLE B052 NOLINEAR B SYLLABLE B055 NULINEAR B SYLLABLE B003 PALINEAR B S" +
	"YLLABLE B072 PELINEAR B SYLLABLE B039 PILINEAR B SYLLABLE B011 POLINEAR " +
	"B SYLLABLE B050 PULINEAR B SYLLABLE B016 QALINEAR B SYLLABLE B078 QELINE" +
	"AR B SYLLABLE B021 QILINEAR B SYLLABLE B032 QOLINEAR B SYLLABLE B060 RAL" +
	"INEAR B SYLLABLE B027 RELINEAR B SYLLABLE B053 RILINEAR B SYLLABLE B002 " +
	"ROLINEAR B SYLLABLE B026 RULINEAR B SYLLABLE B031 SALINEAR B SYLLABLE B0" +
	"09 SELINEAR B SYLLABLE B041 SILINEAR B SYLLABLE B012 SOLINEAR B SYLLABLE" +
	" B058 SULINEAR B SYLLABLE B059 TALINEAR B SYLLABLE B004 TELINEAR B SYLLA" +
	"BLE B037 TILINEAR B SYLLABLE B005 TOLINEAR B SYLLABLE B069 TULINEAR B SY" +
	"LLABLE B054 WALINEAR B SYLLABLE B075 WELINEAR B SYLLABLE B040 WILINEAR B" +
	" SYLLABLE B042 WOLINEAR B SYLLABLE B017 ZALINEAR B SYLLABLE B074 ZELINEA" +
	"R B SYLLABLE B020 ZOLINEAR B SYLLABLE B025 A2LINEAR B SYLLABLE B043 A3LI" +
	"NEAR B SYLLABLE B085 AULINEAR B SYLLABLE B071 DWELINEAR B SYLLABLE B090 " +
	"DWOLINEAR B SYLLABLE B048 NWALINEAR B SYLLABLE B029 PU2LINEAR B SYLLABLE" +
	" B062 PTELINEAR B SYLLABLE B076 RA2LINEAR B SYLLABLE B033 RA3LINEAR B SY" +
	"LLABLE B068 RO2LINEAR B SYLLABLE B066 TA2LINEAR B SYLLABLE B087 TWELINEA" +
	"R B SYLLABLE B091 TWOLINEAR B SYMBOL B018LINEAR B SYMBOL B019LINEAR B SY" +
	"MBOL B022LINEAR B SYMBOL B034LINEAR B SYMBOL B047LINEAR B SYMBOL B049LIN" +
	"EAR B SYMBOL B056LINEAR B SYMBOL B063LINEAR B SYMBOL B064LINEAR B SYMBOL" +
	" B079LINEAR B SYMBOL B082LINEAR B SYMBOL B083LINEAR B SYMBOL B086LINEAR " +
	"B SYMBOL B089LINEAR B IDEOGRAM B100 MANLINEAR B IDEOGRAM B102 WOMANLINEA" +
	"R B IDEOGRAM B104 DEERLINEAR B IDEOGRAM B105 EQUIDLINEAR B IDEOGRAM B105" +
	"F MARELINEAR B IDEOGRAM B105M STALLIONLINEAR B IDEOGRAM B106F EWELINEAR " +
	"B IDEOGRAM B106M RAMLINEAR B IDEOGRAM B107F SHE-GOATLINEAR B IDEOGRAM B1" +
	"07M HE-GOATLINEAR B IDEOGRAM B108F SOWLINEAR B IDEOGRAM B108M BOARLINEAR" +
	" B IDEOGRAM B109F COWLINEAR B IDEOGRAM B109M BULLLINEAR B IDEOGRAM B120 ") + ("" +
	"WHEATLINEAR B IDEOGRAM B121 BARLEYLINEAR B IDEOGRAM B122 OLIVELINEAR B I" +
	"DEOGRAM B123 SPICELINEAR B IDEOGRAM B125 CYPERUSLINEAR B MONOGRAM B127 K" +
	"APOLINEAR B MONOGRAM B128 KANAKOLINEAR B IDEOGRAM B130 OILLINEAR B IDEOG" +
	"RAM B131 WINELINEAR B IDEOGRAM B132LINEAR B MONOGRAM B133 AREPALINEAR B " +
	"MONOGRAM B135 MERILINEAR B IDEOGRAM B140 BRONZELINEAR B IDEOGRAM B141 GO" +
	"LDLINEAR B IDEOGRAM B142LINEAR B IDEOGRAM B145 WOOLLINEAR B IDEOGRAM B14" +
	"6LINEAR B IDEOGRAM B150LINEAR B IDEOGRAM B151 HORNLINEAR B IDEOGRAM B152" +
	"LINEAR B IDEOGRAM B153LINEAR B IDEOGRAM B154LINEAR B MONOGRAM B156 TURO2" +
	"LINEAR B IDEOGRAM B157LINEAR B IDEOGRAM B158LINEAR B IDEOGRAM B159 CLOTH" +
	"LINEAR B IDEOGRAM B160LINEAR B IDEOGRAM B161LINEAR B IDEOGRAM B162 GARME" +
	"NTLINEAR B IDEOGRAM B163 ARMOURLINEAR B IDEOGRAM B164LINEAR B IDEOGRAM B" +
	"165LINEAR B IDEOGRAM B166LINEAR B IDEOGRAM B167LINEAR B IDEOGRAM B168LIN" +
	"EAR B IDEOGRAM B169LINEAR B IDEOGRAM B170LINEAR B IDEOGRAM B171LINEAR B " +
	"IDEOGRAM B172LINEAR B IDEOGRAM B173 MONTHLINEAR B IDEOGRAM B174LINEAR B " +
	"IDEOGRAM B176 TREELINEAR B IDEOGRAM B177LINEAR B IDEOGRAM B178LINEAR B I" +
	"DEOGRAM B179LINEAR B IDEOGRAM B180LINEAR B IDEOGRAM B181LINEAR B IDEOGRA" +
	"M B182LINEAR B IDEOGRAM B183LINEAR B IDEOGRAM B184LINEAR B IDEOGRAM B185" +
	"LINEAR B IDEOGRAM B189LINEAR B IDEOGRAM B190LINEAR B IDEOGRAM B191 HELME" +
	"TLINEAR B IDEOGRAM B220 FOOTSTOOLLINEAR B IDEOGRAM B225 BATHTUBLINEAR B " +
	"IDEOGRAM B230 SPEARLINEAR B IDEOGRAM B231 ARROWLINEAR B IDEOGRAM B232LIN" +
	"EAR B IDEOGRAM B233 SWORDLINEAR B IDEOGRAM B234LINEAR B IDEOGRAM B236LIN" +
	"EAR B IDEOGRAM B240 WHEELED CHARIOTLINEAR B IDEOGRAM B241 CHARIOTLINEAR " +
	"B IDEOGRAM B242 CHARIOT FRAMELINEAR B IDEOGRAM B243 WHEELLINEAR B IDEOGR" +
	"AM B245LINEAR B IDEOGRAM B246LINEAR B MONOGRAM B247 DIPTELINEAR B IDEOGR" +
	"AM B248LINEAR B IDEOGRAM B249LINEAR B IDEOGRAM B251LINEAR B IDEOGRAM B25" +
	"2LINEAR B IDEOGRAM B253LINEAR B IDEOGRAM B254 DARTLINEAR B IDEOGRAM B255" +
	"LINEAR B IDEOGRAM B256LINEAR B IDEOGRAM B257LINEAR B IDEOGRAM B258LINEAR" +
	" B IDEOGRAM B259LINEAR B IDEOGRAM VESSEL B155LINEAR B IDEOGRAM VESSEL B2" +
	"00LINEAR B IDEOGRAM VESSEL B201LINEAR B IDEOGRAM VESSEL B202LINEAR B IDE" +
	"OGRAM VESSEL B203LINEAR B IDEOGRAM VESSEL B204LINEAR B IDEOGRAM VESSEL B" +
	"205LINEAR B IDEOGRAM VESSEL B206LINEAR B IDEOGRAM VESSEL B207LINEAR B ID" +
	"EOGRAM VESSEL B208LINEAR B IDEOGRAM VESSEL B209LINEAR B IDEOGRAM VESSEL " +
	"B210LINEAR B IDEOGRAM VESSEL B211LINEAR B IDEOGRAM VESSEL B212LINEAR B I" +
	"DEOGRAM VESSEL B213LINEAR B IDEOGRAM VESSEL B214LINEAR B IDEOGRAM VESSEL" +
	" B215LINEAR B IDEOGRAM VESSEL B216LINEAR B IDEOGRAM VESSEL B217LINEAR B " +
	"IDEOGRAM VESSEL B218LINEAR B IDEOGRAM VESSEL B219LINEAR B IDEOGRAM VESSE" +
	"L B221LINEAR B IDEOGRAM VESSEL B222LINEAR B IDEOGRAM VESSEL B226LINEAR B" +
	" IDEOGRAM VESSEL B227LINEAR B IDEOGRAM VESSEL B228LINEAR B IDEOGRAM VESS" +
	"EL B229LINEAR B IDEOGRAM VESSEL B250LINEAR B IDEOGRAM VESSEL B305AEGEAN " +
	"WORD SEPARATOR LINEAEGEAN WORD SEPARATOR DOTAEGEAN CHECK MARKAEGEAN NUMB" +
	"ER ONEAEGEAN NUMBER TWOAEGEAN NUMBER THREEAEGEAN NUMBER FOURAEGEAN NUMBE" +
	"R FIVEAEGEAN NUMBER SIXAEGEAN NUMBER SEVENAEGEAN NUMBER EIGHTAEGEAN NUMB" +
	"ER NINEAEGEAN NUMBER TENAEGEAN NUMBER TWENTYAEGEAN NUMBER THIRTYAEGEAN N" +
	"UMBER FORTYAEGEAN NUMBER FIFTYAEGEAN NUMBER SIXTYAEGEAN NUMBER SEVENTYAE" +
	"GEAN NUMBER EIGHTYAEGEAN NUMBER NINETYAEGEAN NUMBER ONE HUNDREDAEGEAN NU" +
	"MBER TWO HUNDREDAEGEAN NUMBER THREE HUNDREDAEGEAN NUMBER FOUR HUNDREDAEG" +
	"EAN NUMBER FIVE HUNDREDAEGEAN NUMBER SIX HUNDREDAEGEAN NUMBER SEVEN HUND" +
	"REDAEGEAN NUMBER EIGHT HUNDREDAEGEAN NUMBER NINE HUNDREDAEGEAN NUMBER ON" +
	"E THOUSANDAEGEAN NUMBER TWO THOUSANDAEGEAN NUMBER THREE THOUSANDAEGEAN N" +
	"UMBER FOUR THOUSANDAEGEAN NUMBER FIVE THOUSANDAEGEAN NUMBER SIX THOUSAND" +
	"AEGEAN NUMBER SEVEN THOUSANDAEGEAN NUMBER EIGHT THOUSANDAEGEAN NUMBER NI" +
	"NE THOUSANDAEGEAN NUMBER TEN THOUSANDAEGEAN NUMBER TWENTY THOUSANDAEGEAN" +
	" NUMBER THIRTY THOUSANDAEGEAN NUMBER FORTY THOUSANDAEGEAN NUMBER FIFTY T" +
	"HOUSANDAEGEAN NUMBER SIXTY THOUSANDAEGEAN NUMBER SEVENTY THOUSANDAEGEAN " +
	"NUMBER EIGHTY THOUSANDAEGEAN NUMBER NINETY THOUSANDAEGEAN WEIGHT BASE UN" +
	"ITAEGEAN WEIGHT FIRST SUBUNITAEGEAN WEIGHT SECOND SUBUNITAEGEAN WEIGHT T" +
	"HIRD SUBUNITAEGEAN WEIGHT FOURTH SUBUNITAEGEAN DRY MEASURE FIRST SUBUNIT" +
	"AEGEAN LIQUID MEASURE FIRST SUBUNITAEGEAN MEASURE SECOND SUBUNITAEGEAN M" +
	"EASURE THIRD SUBUNITGREEK ACROPHONIC ATTIC ONE QUARTERGREEK ACROPHONIC A" +
	"TTIC ONE HALFGREEK ACROPHONIC ATTIC ONE DRACHMAGREEK ACROPHONIC ATTIC FI" +
	"VEGREEK ACROPHONIC ATTIC FIFTYGREEK ACROPHONIC ATTIC FIVE HUNDREDGREEK A" +
	"CROPHONIC ATTIC FIVE THOUSANDGREEK ACROPHONIC ATTIC FIFTY THOUSANDGREEK " +
	"ACROPHONIC ATTIC FIVE TALENTSGREEK ACROPHONIC ATTIC TEN TALENTSGREEK ACR" +
	"OPHONIC ATTIC FIFTY TALENTSGREEK ACROPHONIC ATTIC ONE HUNDRED TALENTSGRE") + ("" +
	"EK ACROPHONIC ATTIC FIVE HUNDRED TALENTSGREEK ACROPHONIC ATTIC ONE THOUS" +
	"AND TALENTSGREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTSGREEK ACROPHONIC " +
	"ATTIC FIVE STATERSGREEK ACROPHONIC ATTIC TEN STATERSGREEK ACROPHONIC ATT" +
	"IC FIFTY STATERSGREEK ACROPHONIC ATTIC ONE HUNDRED STATERSGREEK ACROPHON" +
	"IC ATTIC FIVE HUNDRED STATERSGREEK ACROPHONIC ATTIC ONE THOUSAND STATERS" +
	"GREEK ACROPHONIC ATTIC TEN THOUSAND STATERSGREEK ACROPHONIC ATTIC FIFTY " +
	"THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN MNASGREEK ACROPHONIC HERAEUM " +
	"ONE PLETHRONGREEK ACROPHONIC THESPIAN ONEGREEK ACROPHONIC HERMIONIAN ONE" +
	"GREEK ACROPHONIC EPIDAUREAN TWOGREEK ACROPHONIC THESPIAN TWOGREEK ACROPH" +
	"ONIC CYRENAIC TWO DRACHMASGREEK ACROPHONIC EPIDAUREAN TWO DRACHMASGREEK " +
	"ACROPHONIC TROEZENIAN FIVEGREEK ACROPHONIC TROEZENIAN TENGREEK ACROPHONI" +
	"C TROEZENIAN TEN ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN TENGREEK ACRO" +
	"PHONIC MESSENIAN TENGREEK ACROPHONIC THESPIAN TENGREEK ACROPHONIC THESPI" +
	"AN THIRTYGREEK ACROPHONIC TROEZENIAN FIFTYGREEK ACROPHONIC TROEZENIAN FI" +
	"FTY ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN FIFTYGREEK ACROPHONIC THES" +
	"PIAN FIFTYGREEK ACROPHONIC THESPIAN ONE HUNDREDGREEK ACROPHONIC THESPIAN" +
	" THREE HUNDREDGREEK ACROPHONIC EPIDAUREAN FIVE HUNDREDGREEK ACROPHONIC T" +
	"ROEZENIAN FIVE HUNDREDGREEK ACROPHONIC THESPIAN FIVE HUNDREDGREEK ACROPH" +
	"ONIC CARYSTIAN FIVE HUNDREDGREEK ACROPHONIC NAXIAN FIVE HUNDREDGREEK ACR" +
	"OPHONIC THESPIAN ONE THOUSANDGREEK ACROPHONIC THESPIAN FIVE THOUSANDGREE" +
	"K ACROPHONIC DELPHIC FIVE MNASGREEK ACROPHONIC STRATIAN FIFTY MNASGREEK " +
	"ONE HALF SIGNGREEK ONE HALF SIGN ALTERNATE FORMGREEK TWO THIRDS SIGNGREE" +
	"K THREE QUARTERS SIGNGREEK YEAR SIGNGREEK TALENT SIGNGREEK DRACHMA SIGNG" +
	"REEK OBOL SIGNGREEK TWO OBOLS SIGNGREEK THREE OBOLS SIGNGREEK FOUR OBOLS" +
	" SIGNGREEK FIVE OBOLS SIGNGREEK METRETES SIGNGREEK KYATHOS BASE SIGNGREE" +
	"K LITRA SIGNGREEK OUNKIA SIGNGREEK XESTES SIGNGREEK ARTABE SIGNGREEK ARO" +
	"URA SIGNGREEK GRAMMA SIGNGREEK TRYBLION BASE SIGNGREEK ZERO SIGNGREEK ON" +
	"E QUARTER SIGNGREEK SINUSOID SIGNGREEK INDICTION SIGNNOMISMA SIGNROMAN S" +
	"EXTANS SIGNROMAN UNCIA SIGNROMAN SEMUNCIA SIGNROMAN SEXTULA SIGNROMAN DI" +
	"MIDIA SEXTULA SIGNROMAN SILIQUA SIGNROMAN DENARIUS SIGNROMAN QUINARIUS S" +
	"IGNROMAN SESTERTIUS SIGNROMAN DUPONDIUS SIGNROMAN AS SIGNROMAN CENTURIAL" +
	" SIGNGREEK SYMBOL TAU RHOPHAISTOS DISC SIGN PEDESTRIANPHAISTOS DISC SIGN" +
	" PLUMED HEADPHAISTOS DISC SIGN TATTOOED HEADPHAISTOS DISC SIGN CAPTIVEPH" +
	"AISTOS DISC SIGN CHILDPHAISTOS DISC SIGN WOMANPHAISTOS DISC SIGN HELMETP" +
	"HAISTOS DISC SIGN GAUNTLETPHAISTOS DISC SIGN TIARAPHAISTOS DISC SIGN ARR" +
	"OWPHAISTOS DISC SIGN BOWPHAISTOS DISC SIGN SHIELDPHAISTOS DISC SIGN CLUB" +
	"PHAISTOS DISC SIGN MANACLESPHAISTOS DISC SIGN MATTOCKPHAISTOS DISC SIGN " +
	"SAWPHAISTOS DISC SIGN LIDPHAISTOS DISC SIGN BOOMERANGPHAISTOS DISC SIGN " +
	"CARPENTRY PLANEPHAISTOS DISC SIGN DOLIUMPHAISTOS DISC SIGN COMBPHAISTOS " +
	"DISC SIGN SLINGPHAISTOS DISC SIGN COLUMNPHAISTOS DISC SIGN BEEHIVEPHAIST" +
	"OS DISC SIGN SHIPPHAISTOS DISC SIGN HORNPHAISTOS DISC SIGN HIDEPHAISTOS " +
	"DISC SIGN BULLS LEGPHAISTOS DISC SIGN CATPHAISTOS DISC SIGN RAMPHAISTOS " +
	"DISC SIGN EAGLEPHAISTOS DISC SIGN DOVEPHAISTOS DISC SIGN TUNNYPHAISTOS D" +
	"ISC SIGN BEEPHAISTOS DISC SIGN PLANE TREEPHAISTOS DISC SIGN VINEPHAISTOS" +
	" DISC SIGN PAPYRUSPHAISTOS DISC SIGN ROSETTEPHAISTOS DISC SIGN LILYPHAIS" +
	"TOS DISC SIGN OX BACKPHAISTOS DISC SIGN FLUTEPHAISTOS DISC SIGN GRATERPH" +
	"AISTOS DISC SIGN STRAINERPHAISTOS DISC SIGN SMALL AXEPHAISTOS DISC SIGN " +
	"WAVY BANDPHAISTOS DISC SIGN COMBINING OBLIQUE STROKELYCIAN LETTER ALYCIA" +
	"N LETTER ELYCIAN LETTER BLYCIAN LETTER BHLYCIAN LETTER GLYCIAN LETTER DL" +
	"YCIAN LETTER ILYCIAN LETTER WLYCIAN LETTER ZLYCIAN LETTER THLYCIAN LETTE" +
	"R JLYCIAN LETTER KLYCIAN LETTER QLYCIAN LETTER LLYCIAN LETTER MLYCIAN LE" +
	"TTER NLYCIAN LETTER MMLYCIAN LETTER NNLYCIAN LETTER ULYCIAN LETTER PLYCI" +
	"AN LETTER KKLYCIAN LETTER RLYCIAN LETTER SLYCIAN LETTER TLYCIAN LETTER T" +
	"TLYCIAN LETTER ANLYCIAN LETTER ENLYCIAN LETTER HLYCIAN LETTER XCARIAN LE" +
	"TTER ACARIAN LETTER P2CARIAN LETTER DCARIAN LETTER LCARIAN LETTER UUUCAR" +
	"IAN LETTER RCARIAN LETTER LDCARIAN LETTER A2CARIAN LETTER QCARIAN LETTER" +
	" BCARIAN LETTER MCARIAN LETTER OCARIAN LETTER D2CARIAN LETTER TCARIAN LE" +
	"TTER SHCARIAN LETTER SH2CARIAN LETTER SCARIAN LETTER C-18CARIAN LETTER U" +
	"CARIAN LETTER NNCARIAN LETTER XCARIAN LETTER NCARIAN LETTER TT2CARIAN LE" +
	"TTER PCARIAN LETTER SSCARIAN LETTER ICARIAN LETTER ECARIAN LETTER UUUUCA" +
	"RIAN LETTER KCARIAN LETTER K2CARIAN LETTER NDCARIAN LETTER UUCARIAN LETT" +
	"ER GCARIAN LETTER G2CARIAN LETTER STCARIAN LETTER ST2CARIAN LETTER NGCAR" +
	"IAN LETTER IICARIAN LETTER C-39CARIAN LETTER TTCARIAN LETTER UUU2CARIAN " +
	"LETTER RRCARIAN LETTER MBCARIAN LETTER MB2CARIAN LETTER MB3CARIAN LETTER") + ("" +
	" MB4CARIAN LETTER LD2CARIAN LETTER E2CARIAN LETTER UUU3COPTIC EPACT THOU" +
	"SANDS MARKCOPTIC EPACT DIGIT ONECOPTIC EPACT DIGIT TWOCOPTIC EPACT DIGIT" +
	" THREECOPTIC EPACT DIGIT FOURCOPTIC EPACT DIGIT FIVECOPTIC EPACT DIGIT S" +
	"IXCOPTIC EPACT DIGIT SEVENCOPTIC EPACT DIGIT EIGHTCOPTIC EPACT DIGIT NIN" +
	"ECOPTIC EPACT NUMBER TENCOPTIC EPACT NUMBER TWENTYCOPTIC EPACT NUMBER TH" +
	"IRTYCOPTIC EPACT NUMBER FORTYCOPTIC EPACT NUMBER FIFTYCOPTIC EPACT NUMBE" +
	"R SIXTYCOPTIC EPACT NUMBER SEVENTYCOPTIC EPACT NUMBER EIGHTYCOPTIC EPACT" +
	" NUMBER NINETYCOPTIC EPACT NUMBER ONE HUNDREDCOPTIC EPACT NUMBER TWO HUN" +
	"DREDCOPTIC EPACT NUMBER THREE HUNDREDCOPTIC EPACT NUMBER FOUR HUNDREDCOP" +
	"TIC EPACT NUMBER FIVE HUNDREDCOPTIC EPACT NUMBER SIX HUNDREDCOPTIC EPACT" +
	" NUMBER SEVEN HUNDREDCOPTIC EPACT NUMBER EIGHT HUNDREDCOPTIC EPACT NUMBE" +
	"R NINE HUNDREDOLD ITALIC LETTER AOLD ITALIC LETTER BEOLD ITALIC LETTER K" +
	"EOLD ITALIC LETTER DEOLD ITALIC LETTER EOLD ITALIC LETTER VEOLD ITALIC L" +
	"ETTER ZEOLD ITALIC LETTER HEOLD ITALIC LETTER THEOLD ITALIC LETTER IOLD " +
	"ITALIC LETTER KAOLD ITALIC LETTER ELOLD ITALIC LETTER EMOLD ITALIC LETTE" +
	"R ENOLD ITALIC LETTER ESHOLD ITALIC LETTER OOLD ITALIC LETTER PEOLD ITAL" +
	"IC LETTER SHEOLD ITALIC LETTER KUOLD ITALIC LETTER EROLD ITALIC LETTER E" +
	"SOLD ITALIC LETTER TEOLD ITALIC LETTER UOLD ITALIC LETTER EKSOLD ITALIC " +
	"LETTER PHEOLD ITALIC LETTER KHEOLD ITALIC LETTER EFOLD ITALIC LETTER ERS" +
	"OLD ITALIC LETTER CHEOLD ITALIC LETTER IIOLD ITALIC LETTER UUOLD ITALIC " +
	"LETTER ESSOLD ITALIC NUMERAL ONEOLD ITALIC NUMERAL FIVEOLD ITALIC NUMERA" +
	"L TENOLD ITALIC NUMERAL FIFTYOLD ITALIC LETTER YEOLD ITALIC LETTER NORTH" +
	"ERN TSEOLD ITALIC LETTER SOUTHERN TSEGOTHIC LETTER AHSAGOTHIC LETTER BAI" +
	"RKANGOTHIC LETTER GIBAGOTHIC LETTER DAGSGOTHIC LETTER AIHVUSGOTHIC LETTE" +
	"R QAIRTHRAGOTHIC LETTER IUJAGOTHIC LETTER HAGLGOTHIC LETTER THIUTHGOTHIC" +
	" LETTER EISGOTHIC LETTER KUSMAGOTHIC LETTER LAGUSGOTHIC LETTER MANNAGOTH" +
	"IC LETTER NAUTHSGOTHIC LETTER JERGOTHIC LETTER URUSGOTHIC LETTER PAIRTHR" +
	"AGOTHIC LETTER NINETYGOTHIC LETTER RAIDAGOTHIC LETTER SAUILGOTHIC LETTER" +
	" TEIWSGOTHIC LETTER WINJAGOTHIC LETTER FAIHUGOTHIC LETTER IGGWSGOTHIC LE" +
	"TTER HWAIRGOTHIC LETTER OTHALGOTHIC LETTER NINE HUNDREDOLD PERMIC LETTER" +
	" ANOLD PERMIC LETTER BUROLD PERMIC LETTER GAIOLD PERMIC LETTER DOIOLD PE" +
	"RMIC LETTER EOLD PERMIC LETTER ZHOIOLD PERMIC LETTER DZHOIOLD PERMIC LET" +
	"TER ZATAOLD PERMIC LETTER DZITAOLD PERMIC LETTER IOLD PERMIC LETTER KOKE" +
	"OLD PERMIC LETTER LEIOLD PERMIC LETTER MENOEOLD PERMIC LETTER NENOEOLD P" +
	"ERMIC LETTER VOOIOLD PERMIC LETTER PEEIOLD PERMIC LETTER REIOLD PERMIC L" +
	"ETTER SIIOLD PERMIC LETTER TAIOLD PERMIC LETTER UOLD PERMIC LETTER CHERY" +
	"OLD PERMIC LETTER SHOOIOLD PERMIC LETTER SHCHOOIOLD PERMIC LETTER YRYOLD" +
	" PERMIC LETTER YERUOLD PERMIC LETTER OOLD PERMIC LETTER OOOLD PERMIC LET" +
	"TER EFOLD PERMIC LETTER HAOLD PERMIC LETTER TSIUOLD PERMIC LETTER VEROLD" +
	" PERMIC LETTER YEROLD PERMIC LETTER YERIOLD PERMIC LETTER YATOLD PERMIC " +
	"LETTER IEOLD PERMIC LETTER YUOLD PERMIC LETTER YAOLD PERMIC LETTER IACOM" +
	"BINING OLD PERMIC LETTER ANCOMBINING OLD PERMIC LETTER DOICOMBINING OLD " +
	"PERMIC LETTER ZATACOMBINING OLD PERMIC LETTER NENOECOMBINING OLD PERMIC " +
	"LETTER SIIUGARITIC LETTER ALPAUGARITIC LETTER BETAUGARITIC LETTER GAMLAU" +
	"GARITIC LETTER KHAUGARITIC LETTER DELTAUGARITIC LETTER HOUGARITIC LETTER" +
	" WOUGARITIC LETTER ZETAUGARITIC LETTER HOTAUGARITIC LETTER TETUGARITIC L" +
	"ETTER YODUGARITIC LETTER KAFUGARITIC LETTER SHINUGARITIC LETTER LAMDAUGA" +
	"RITIC LETTER MEMUGARITIC LETTER DHALUGARITIC LETTER NUNUGARITIC LETTER Z" +
	"UUGARITIC LETTER SAMKAUGARITIC LETTER AINUGARITIC LETTER PUUGARITIC LETT" +
	"ER SADEUGARITIC LETTER QOPAUGARITIC LETTER RASHAUGARITIC LETTER THANNAUG" +
	"ARITIC LETTER GHAINUGARITIC LETTER TOUGARITIC LETTER IUGARITIC LETTER UU" +
	"GARITIC LETTER SSUUGARITIC WORD DIVIDEROLD PERSIAN SIGN AOLD PERSIAN SIG" +
	"N IOLD PERSIAN SIGN UOLD PERSIAN SIGN KAOLD PERSIAN SIGN KUOLD PERSIAN S" +
	"IGN GAOLD PERSIAN SIGN GUOLD PERSIAN SIGN XAOLD PERSIAN SIGN CAOLD PERSI" +
	"AN SIGN JAOLD PERSIAN SIGN JIOLD PERSIAN SIGN TAOLD PERSIAN SIGN TUOLD P" +
	"ERSIAN SIGN DAOLD PERSIAN SIGN DIOLD PERSIAN SIGN DUOLD PERSIAN SIGN THA" +
	"OLD PERSIAN SIGN PAOLD PERSIAN SIGN BAOLD PERSIAN SIGN FAOLD PERSIAN SIG" +
	"N NAOLD PERSIAN SIGN NUOLD PERSIAN SIGN MAOLD PERSIAN SIGN MIOLD PERSIAN" +
	" SIGN MUOLD PERSIAN SIGN YAOLD PERSIAN SIGN VAOLD PERSIAN SIGN VIOLD PER" +
	"SIAN SIGN RAOLD PERSIAN SIGN RUOLD PERSIAN SIGN LAOLD PERSIAN SIGN SAOLD" +
	" PERSIAN SIGN ZAOLD PERSIAN SIGN SHAOLD PERSIAN SIGN SSAOLD PERSIAN SIGN" +
	" HAOLD PERSIAN SIGN AURAMAZDAAOLD PERSIAN SIGN AURAMAZDAA-2OLD PERSIAN S" +
	"IGN AURAMAZDAAHAOLD PERSIAN SIGN XSHAAYATHIYAOLD PERSIAN SIGN DAHYAAUSHO" +
	"LD PERSIAN SIGN DAHYAAUSH-2OLD PERSIAN SIGN BAGAOLD PERSIAN SIGN BUUMISH") + ("" +
	"OLD PERSIAN WORD DIVIDEROLD PERSIAN NUMBER ONEOLD PERSIAN NUMBER TWOOLD " +
	"PERSIAN NUMBER TENOLD PERSIAN NUMBER TWENTYOLD PERSIAN NUMBER HUNDREDDES" +
	"ERET CAPITAL LETTER LONG IDESERET CAPITAL LETTER LONG EDESERET CAPITAL L" +
	"ETTER LONG ADESERET CAPITAL LETTER LONG AHDESERET CAPITAL LETTER LONG OD" +
	"ESERET CAPITAL LETTER LONG OODESERET CAPITAL LETTER SHORT IDESERET CAPIT" +
	"AL LETTER SHORT EDESERET CAPITAL LETTER SHORT ADESERET CAPITAL LETTER SH" +
	"ORT AHDESERET CAPITAL LETTER SHORT ODESERET CAPITAL LETTER SHORT OODESER" +
	"ET CAPITAL LETTER AYDESERET CAPITAL LETTER OWDESERET CAPITAL LETTER WUDE" +
	"SERET CAPITAL LETTER YEEDESERET CAPITAL LETTER HDESERET CAPITAL LETTER P" +
	"EEDESERET CAPITAL LETTER BEEDESERET CAPITAL LETTER TEEDESERET CAPITAL LE" +
	"TTER DEEDESERET CAPITAL LETTER CHEEDESERET CAPITAL LETTER JEEDESERET CAP" +
	"ITAL LETTER KAYDESERET CAPITAL LETTER GAYDESERET CAPITAL LETTER EFDESERE" +
	"T CAPITAL LETTER VEEDESERET CAPITAL LETTER ETHDESERET CAPITAL LETTER THE" +
	"EDESERET CAPITAL LETTER ESDESERET CAPITAL LETTER ZEEDESERET CAPITAL LETT" +
	"ER ESHDESERET CAPITAL LETTER ZHEEDESERET CAPITAL LETTER ERDESERET CAPITA" +
	"L LETTER ELDESERET CAPITAL LETTER EMDESERET CAPITAL LETTER ENDESERET CAP" +
	"ITAL LETTER ENGDESERET CAPITAL LETTER OIDESERET CAPITAL LETTER EWDESERET" +
	" SMALL LETTER LONG IDESERET SMALL LETTER LONG EDESERET SMALL LETTER LONG" +
	" ADESERET SMALL LETTER LONG AHDESERET SMALL LETTER LONG ODESERET SMALL L" +
	"ETTER LONG OODESERET SMALL LETTER SHORT IDESERET SMALL LETTER SHORT EDES" +
	"ERET SMALL LETTER SHORT ADESERET SMALL LETTER SHORT AHDESERET SMALL LETT" +
	"ER SHORT ODESERET SMALL LETTER SHORT OODESERET SMALL LETTER AYDESERET SM" +
	"ALL LETTER OWDESERET SMALL LETTER WUDESERET SMALL LETTER YEEDESERET SMAL" +
	"L LETTER HDESERET SMALL LETTER PEEDESERET SMALL LETTER BEEDESERET SMALL " +
	"LETTER TEEDESERET SMALL LETTER DEEDESERET SMALL LETTER CHEEDESERET SMALL" +
	" LETTER JEEDESERET SMALL LETTER KAYDESERET SMALL LETTER GAYDESERET SMALL" +
	" LETTER EFDESERET SMALL LETTER VEEDESERET SMALL LETTER ETHDESERET SMALL " +
	"LETTER THEEDESERET SMALL LETTER ESDESERET SMALL LETTER ZEEDESERET SMALL " +
	"LETTER ESHDESERET SMALL LETTER ZHEEDESERET SMALL LETTER ERDESERET SMALL " +
	"LETTER ELDESERET SMALL LETTER EMDESERET SMALL LETTER ENDESERET SMALL LET" +
	"TER ENGDESERET SMALL LETTER OIDESERET SMALL LETTER EWSHAVIAN LETTER PEEP" +
	"SHAVIAN LETTER TOTSHAVIAN LETTER KICKSHAVIAN LETTER FEESHAVIAN LETTER TH" +
	"IGHSHAVIAN LETTER SOSHAVIAN LETTER SURESHAVIAN LETTER CHURCHSHAVIAN LETT" +
	"ER YEASHAVIAN LETTER HUNGSHAVIAN LETTER BIBSHAVIAN LETTER DEADSHAVIAN LE" +
	"TTER GAGSHAVIAN LETTER VOWSHAVIAN LETTER THEYSHAVIAN LETTER ZOOSHAVIAN L" +
	"ETTER MEASURESHAVIAN LETTER JUDGESHAVIAN LETTER WOESHAVIAN LETTER HA-HAS" +
	"HAVIAN LETTER LOLLSHAVIAN LETTER MIMESHAVIAN LETTER IFSHAVIAN LETTER EGG" +
	"SHAVIAN LETTER ASHSHAVIAN LETTER ADOSHAVIAN LETTER ONSHAVIAN LETTER WOOL" +
	"SHAVIAN LETTER OUTSHAVIAN LETTER AHSHAVIAN LETTER ROARSHAVIAN LETTER NUN" +
	"SHAVIAN LETTER EATSHAVIAN LETTER AGESHAVIAN LETTER ICESHAVIAN LETTER UPS" +
	"HAVIAN LETTER OAKSHAVIAN LETTER OOZESHAVIAN LETTER OILSHAVIAN LETTER AWE" +
	"SHAVIAN LETTER ARESHAVIAN LETTER ORSHAVIAN LETTER AIRSHAVIAN LETTER ERRS" +
	"HAVIAN LETTER ARRAYSHAVIAN LETTER EARSHAVIAN LETTER IANSHAVIAN LETTER YE" +
	"WOSMANYA LETTER ALEFOSMANYA LETTER BAOSMANYA LETTER TAOSMANYA LETTER JAO" +
	"SMANYA LETTER XAOSMANYA LETTER KHAOSMANYA LETTER DEELOSMANYA LETTER RAOS" +
	"MANYA LETTER SAOSMANYA LETTER SHIINOSMANYA LETTER DHAOSMANYA LETTER CAYN" +
	"OSMANYA LETTER GAOSMANYA LETTER FAOSMANYA LETTER QAAFOSMANYA LETTER KAAF" +
	"OSMANYA LETTER LAANOSMANYA LETTER MIINOSMANYA LETTER NUUNOSMANYA LETTER " +
	"WAWOSMANYA LETTER HAOSMANYA LETTER YAOSMANYA LETTER AOSMANYA LETTER EOSM" +
	"ANYA LETTER IOSMANYA LETTER OOSMANYA LETTER UOSMANYA LETTER AAOSMANYA LE" +
	"TTER EEOSMANYA LETTER OOOSMANYA DIGIT ZEROOSMANYA DIGIT ONEOSMANYA DIGIT" +
	" TWOOSMANYA DIGIT THREEOSMANYA DIGIT FOUROSMANYA DIGIT FIVEOSMANYA DIGIT" +
	" SIXOSMANYA DIGIT SEVENOSMANYA DIGIT EIGHTOSMANYA DIGIT NINEOSAGE CAPITA" +
	"L LETTER AOSAGE CAPITAL LETTER AIOSAGE CAPITAL LETTER AINOSAGE CAPITAL L" +
	"ETTER AHOSAGE CAPITAL LETTER BRAOSAGE CAPITAL LETTER CHAOSAGE CAPITAL LE" +
	"TTER EHCHAOSAGE CAPITAL LETTER EOSAGE CAPITAL LETTER EINOSAGE CAPITAL LE" +
	"TTER HAOSAGE CAPITAL LETTER HYAOSAGE CAPITAL LETTER IOSAGE CAPITAL LETTE" +
	"R KAOSAGE CAPITAL LETTER EHKAOSAGE CAPITAL LETTER KYAOSAGE CAPITAL LETTE" +
	"R LAOSAGE CAPITAL LETTER MAOSAGE CAPITAL LETTER NAOSAGE CAPITAL LETTER O" +
	"OSAGE CAPITAL LETTER OINOSAGE CAPITAL LETTER PAOSAGE CAPITAL LETTER EHPA" +
	"OSAGE CAPITAL LETTER SAOSAGE CAPITAL LETTER SHAOSAGE CAPITAL LETTER TAOS" +
	"AGE CAPITAL LETTER EHTAOSAGE CAPITAL LETTER TSAOSAGE CAPITAL LETTER EHTS" +
	"AOSAGE CAPITAL LETTER TSHAOSAGE CAPITAL LETTER DHAOSAGE CAPITAL LETTER U" +
	"OSAGE CAPITAL LETTER WAOSAGE CAPITAL LETTER KHAOSAGE CAPITAL LETTER GHAO") + ("" +
	"SAGE CAPITAL LETTER ZAOSAGE CAPITAL LETTER ZHAOSAGE SMALL LETTER AOSAGE " +
	"SMALL LETTER AIOSAGE SMALL LETTER AINOSAGE SMALL LETTER AHOSAGE SMALL LE" +
	"TTER BRAOSAGE SMALL LETTER CHAOSAGE SMALL LETTER EHCHAOSAGE SMALL LETTER" +
	" EOSAGE SMALL LETTER EINOSAGE SMALL LETTER HAOSAGE SMALL LETTER HYAOSAGE" +
	" SMALL LETTER IOSAGE SMALL LETTER KAOSAGE SMALL LETTER EHKAOSAGE SMALL L" +
	"ETTER KYAOSAGE SMALL LETTER LAOSAGE SMALL LETTER MAOSAGE SMALL LETTER NA" +
	"OSAGE SMALL LETTER OOSAGE SMALL LETTER OINOSAGE SMALL LETTER PAOSAGE SMA" +
	"LL LETTER EHPAOSAGE SMALL LETTER SAOSAGE SMALL LETTER SHAOSAGE SMALL LET" +
	"TER TAOSAGE SMALL LETTER EHTAOSAGE SMALL LETTER TSAOSAGE SMALL LETTER EH" +
	"TSAOSAGE SMALL LETTER TSHAOSAGE SMALL LETTER DHAOSAGE SMALL LETTER UOSAG" +
	"E SMALL LETTER WAOSAGE SMALL LETTER KHAOSAGE SMALL LETTER GHAOSAGE SMALL" +
	" LETTER ZAOSAGE SMALL LETTER ZHAELBASAN LETTER AELBASAN LETTER BEELBASAN" +
	" LETTER CEELBASAN LETTER CHEELBASAN LETTER DEELBASAN LETTER NDEELBASAN L" +
	"ETTER DHEELBASAN LETTER EIELBASAN LETTER EELBASAN LETTER FEELBASAN LETTE" +
	"R GEELBASAN LETTER GJEELBASAN LETTER HEELBASAN LETTER IELBASAN LETTER JE" +
	"ELBASAN LETTER KEELBASAN LETTER LEELBASAN LETTER LLEELBASAN LETTER MEELB" +
	"ASAN LETTER NEELBASAN LETTER NAELBASAN LETTER NJEELBASAN LETTER OELBASAN" +
	" LETTER PEELBASAN LETTER QEELBASAN LETTER REELBASAN LETTER RREELBASAN LE" +
	"TTER SEELBASAN LETTER SHEELBASAN LETTER TEELBASAN LETTER THEELBASAN LETT" +
	"ER UELBASAN LETTER VEELBASAN LETTER XEELBASAN LETTER YELBASAN LETTER ZEE" +
	"LBASAN LETTER ZHEELBASAN LETTER GHEELBASAN LETTER GHAMMAELBASAN LETTER K" +
	"HECAUCASIAN ALBANIAN LETTER ALTCAUCASIAN ALBANIAN LETTER BETCAUCASIAN AL" +
	"BANIAN LETTER GIMCAUCASIAN ALBANIAN LETTER DATCAUCASIAN ALBANIAN LETTER " +
	"EBCAUCASIAN ALBANIAN LETTER ZARLCAUCASIAN ALBANIAN LETTER EYNCAUCASIAN A" +
	"LBANIAN LETTER ZHILCAUCASIAN ALBANIAN LETTER TASCAUCASIAN ALBANIAN LETTE" +
	"R CHACAUCASIAN ALBANIAN LETTER YOWDCAUCASIAN ALBANIAN LETTER ZHACAUCASIA" +
	"N ALBANIAN LETTER IRBCAUCASIAN ALBANIAN LETTER SHACAUCASIAN ALBANIAN LET" +
	"TER LANCAUCASIAN ALBANIAN LETTER INYACAUCASIAN ALBANIAN LETTER XEYNCAUCA" +
	"SIAN ALBANIAN LETTER DYANCAUCASIAN ALBANIAN LETTER CARCAUCASIAN ALBANIAN" +
	" LETTER JHOXCAUCASIAN ALBANIAN LETTER KARCAUCASIAN ALBANIAN LETTER LYITC" +
	"AUCASIAN ALBANIAN LETTER HEYTCAUCASIAN ALBANIAN LETTER QAYCAUCASIAN ALBA" +
	"NIAN LETTER AORCAUCASIAN ALBANIAN LETTER CHOYCAUCASIAN ALBANIAN LETTER C" +
	"HICAUCASIAN ALBANIAN LETTER CYAYCAUCASIAN ALBANIAN LETTER MAQCAUCASIAN A" +
	"LBANIAN LETTER QARCAUCASIAN ALBANIAN LETTER NOWCCAUCASIAN ALBANIAN LETTE" +
	"R DZYAYCAUCASIAN ALBANIAN LETTER SHAKCAUCASIAN ALBANIAN LETTER JAYNCAUCA" +
	"SIAN ALBANIAN LETTER ONCAUCASIAN ALBANIAN LETTER TYAYCAUCASIAN ALBANIAN " +
	"LETTER FAMCAUCASIAN ALBANIAN LETTER DZAYCAUCASIAN ALBANIAN LETTER CHATCA" +
	"UCASIAN ALBANIAN LETTER PENCAUCASIAN ALBANIAN LETTER GHEYSCAUCASIAN ALBA" +
	"NIAN LETTER RATCAUCASIAN ALBANIAN LETTER SEYKCAUCASIAN ALBANIAN LETTER V" +
	"EYZCAUCASIAN ALBANIAN LETTER TIWRCAUCASIAN ALBANIAN LETTER SHOYCAUCASIAN" +
	" ALBANIAN LETTER IWNCAUCASIAN ALBANIAN LETTER CYAWCAUCASIAN ALBANIAN LET" +
	"TER CAYNCAUCASIAN ALBANIAN LETTER YAYDCAUCASIAN ALBANIAN LETTER PIWRCAUC" +
	"ASIAN ALBANIAN LETTER KIWCAUCASIAN ALBANIAN CITATION MARKLINEAR A SIGN A" +
	"B001LINEAR A SIGN AB002LINEAR A SIGN AB003LINEAR A SIGN AB004LINEAR A SI" +
	"GN AB005LINEAR A SIGN AB006LINEAR A SIGN AB007LINEAR A SIGN AB008LINEAR " +
	"A SIGN AB009LINEAR A SIGN AB010LINEAR A SIGN AB011LINEAR A SIGN AB013LIN" +
	"EAR A SIGN AB016LINEAR A SIGN AB017LINEAR A SIGN AB020LINEAR A SIGN AB02" +
	"1LINEAR A SIGN AB021FLINEAR A SIGN AB021MLINEAR A SIGN AB022LINEAR A SIG" +
	"N AB022FLINEAR A SIGN AB022MLINEAR A SIGN AB023LINEAR A SIGN AB023MLINEA" +
	"R A SIGN AB024LINEAR A SIGN AB026LINEAR A SIGN AB027LINEAR A SIGN AB028L" +
	"INEAR A SIGN A028BLINEAR A SIGN AB029LINEAR A SIGN AB030LINEAR A SIGN AB" +
	"031LINEAR A SIGN AB034LINEAR A SIGN AB037LINEAR A SIGN AB038LINEAR A SIG" +
	"N AB039LINEAR A SIGN AB040LINEAR A SIGN AB041LINEAR A SIGN AB044LINEAR A" +
	" SIGN AB045LINEAR A SIGN AB046LINEAR A SIGN AB047LINEAR A SIGN AB048LINE" +
	"AR A SIGN AB049LINEAR A SIGN AB050LINEAR A SIGN AB051LINEAR A SIGN AB053" +
	"LINEAR A SIGN AB054LINEAR A SIGN AB055LINEAR A SIGN AB056LINEAR A SIGN A" +
	"B057LINEAR A SIGN AB058LINEAR A SIGN AB059LINEAR A SIGN AB060LINEAR A SI" +
	"GN AB061LINEAR A SIGN AB065LINEAR A SIGN AB066LINEAR A SIGN AB067LINEAR " +
	"A SIGN AB069LINEAR A SIGN AB070LINEAR A SIGN AB073LINEAR A SIGN AB074LIN" +
	"EAR A SIGN AB076LINEAR A SIGN AB077LINEAR A SIGN AB078LINEAR A SIGN AB07" +
	"9LINEAR A SIGN AB080LINEAR A SIGN AB081LINEAR A SIGN AB082LINEAR A SIGN " +
	"AB085LINEAR A SIGN AB086LINEAR A SIGN AB087LINEAR A SIGN A100-102LINEAR " +
	"A SIGN AB118LINEAR A SIGN AB120LINEAR A SIGN A120BLINEAR A SIGN AB122LIN" +
	"EAR A SIGN AB123LINEAR A SIGN AB131ALINEAR A SIGN AB131BLINEAR A SIGN A1") + ("" +
	"31CLINEAR A SIGN AB164LINEAR A SIGN AB171LINEAR A SIGN AB180LINEAR A SIG" +
	"N AB188LINEAR A SIGN AB191LINEAR A SIGN A301LINEAR A SIGN A302LINEAR A S" +
	"IGN A303LINEAR A SIGN A304LINEAR A SIGN A305LINEAR A SIGN A306LINEAR A S" +
	"IGN A307LINEAR A SIGN A308LINEAR A SIGN A309ALINEAR A SIGN A309BLINEAR A" +
	" SIGN A309CLINEAR A SIGN A310LINEAR A SIGN A311LINEAR A SIGN A312LINEAR " +
	"A SIGN A313ALINEAR A SIGN A313BLINEAR A SIGN A313CLINEAR A SIGN A314LINE" +
	"AR A SIGN A315LINEAR A SIGN A316LINEAR A SIGN A317LINEAR A SIGN A318LINE" +
	"AR A SIGN A319LINEAR A SIGN A320LINEAR A SIGN A321LINEAR A SIGN A322LINE" +
	"AR A SIGN A323LINEAR A SIGN A324LINEAR A SIGN A325LINEAR A SIGN A326LINE" +
	"AR A SIGN A327LINEAR A SIGN A328LINEAR A SIGN A329LINEAR A SIGN A330LINE" +
	"AR A SIGN A331LINEAR A SIGN A332LINEAR A SIGN A333LINEAR A SIGN A334LINE" +
	"AR A SIGN A335LINEAR A SIGN A336LINEAR A SIGN A337LINEAR A SIGN A338LINE" +
	"AR A SIGN A339LINEAR A SIGN A340LINEAR A SIGN A341LINEAR A SIGN A342LINE" +
	"AR A SIGN A343LINEAR A SIGN A344LINEAR A SIGN A345LINEAR A SIGN A346LINE" +
	"AR A SIGN A347LINEAR A SIGN A348LINEAR A SIGN A349LINEAR A SIGN A350LINE" +
	"AR A SIGN A351LINEAR A SIGN A352LINEAR A SIGN A353LINEAR A SIGN A354LINE" +
	"AR A SIGN A355LINEAR A SIGN A356LINEAR A SIGN A357LINEAR A SIGN A358LINE" +
	"AR A SIGN A359LINEAR A SIGN A360LINEAR A SIGN A361LINEAR A SIGN A362LINE" +
	"AR A SIGN A363LINEAR A SIGN A364LINEAR A SIGN A365LINEAR A SIGN A366LINE" +
	"AR A SIGN A367LINEAR A SIGN A368LINEAR A SIGN A369LINEAR A SIGN A370LINE" +
	"AR A SIGN A371LINEAR A SIGN A400-VASLINEAR A SIGN A401-VASLINEAR A SIGN " +
	"A402-VASLINEAR A SIGN A403-VASLINEAR A SIGN A404-VASLINEAR A SIGN A405-V" +
	"ASLINEAR A SIGN A406-VASLINEAR A SIGN A407-VASLINEAR A SIGN A408-VASLINE" +
	"AR A SIGN A409-VASLINEAR A SIGN A410-VASLINEAR A SIGN A411-VASLINEAR A S" +
	"IGN A412-VASLINEAR A SIGN A413-VASLINEAR A SIGN A414-VASLINEAR A SIGN A4" +
	"15-VASLINEAR A SIGN A416-VASLINEAR A SIGN A417-VASLINEAR A SIGN A418-VAS" +
	"LINEAR A SIGN A501LINEAR A SIGN A502LINEAR A SIGN A503LINEAR A SIGN A504" +
	"LINEAR A SIGN A505LINEAR A SIGN A506LINEAR A SIGN A508LINEAR A SIGN A509" +
	"LINEAR A SIGN A510LINEAR A SIGN A511LINEAR A SIGN A512LINEAR A SIGN A513" +
	"LINEAR A SIGN A515LINEAR A SIGN A516LINEAR A SIGN A520LINEAR A SIGN A521" +
	"LINEAR A SIGN A523LINEAR A SIGN A524LINEAR A SIGN A525LINEAR A SIGN A526" +
	"LINEAR A SIGN A527LINEAR A SIGN A528LINEAR A SIGN A529LINEAR A SIGN A530" +
	"LINEAR A SIGN A531LINEAR A SIGN A532LINEAR A SIGN A534LINEAR A SIGN A535" +
	"LINEAR A SIGN A536LINEAR A SIGN A537LINEAR A SIGN A538LINEAR A SIGN A539" +
	"LINEAR A SIGN A540LINEAR A SIGN A541LINEAR A SIGN A542LINEAR A SIGN A545" +
	"LINEAR A SIGN A547LINEAR A SIGN A548LINEAR A SIGN A549LINEAR A SIGN A550" +
	"LINEAR A SIGN A551LINEAR A SIGN A552LINEAR A SIGN A553LINEAR A SIGN A554" +
	"LINEAR A SIGN A555LINEAR A SIGN A556LINEAR A SIGN A557LINEAR A SIGN A559" +
	"LINEAR A SIGN A563LINEAR A SIGN A564LINEAR A SIGN A565LINEAR A SIGN A566" +
	"LINEAR A SIGN A568LINEAR A SIGN A569LINEAR A SIGN A570LINEAR A SIGN A571" +
	"LINEAR A SIGN A572LINEAR A SIGN A573LINEAR A SIGN A574LINEAR A SIGN A575" +
	"LINEAR A SIGN A576LINEAR A SIGN A577LINEAR A SIGN A578LINEAR A SIGN A579" +
	"LINEAR A SIGN A580LINEAR A SIGN A581LINEAR A SIGN A582LINEAR A SIGN A583" +
	"LINEAR A SIGN A584LINEAR A SIGN A585LINEAR A SIGN A586LINEAR A SIGN A587" +
	"LINEAR A SIGN A588LINEAR A SIGN A589LINEAR A SIGN A591LINEAR A SIGN A592" +
	"LINEAR A SIGN A594LINEAR A SIGN A595LINEAR A SIGN A596LINEAR A SIGN A598" +
	"LINEAR A SIGN A600LINEAR A SIGN A601LINEAR A SIGN A602LINEAR A SIGN A603" +
	"LINEAR A SIGN A604LINEAR A SIGN A606LINEAR A SIGN A608LINEAR A SIGN A609" +
	"LINEAR A SIGN A610LINEAR A SIGN A611LINEAR A SIGN A612LINEAR A SIGN A613" +
	"LINEAR A SIGN A614LINEAR A SIGN A615LINEAR A SIGN A616LINEAR A SIGN A617" +
	"LINEAR A SIGN A618LINEAR A SIGN A619LINEAR A SIGN A620LINEAR A SIGN A621" +
	"LINEAR A SIGN A622LINEAR A SIGN A623LINEAR A SIGN A624LINEAR A SIGN A626" +
	"LINEAR A SIGN A627LINEAR A SIGN A628LINEAR A SIGN A629LINEAR A SIGN A634" +
	"LINEAR A SIGN A637LINEAR A SIGN A638LINEAR A SIGN A640LINEAR A SIGN A642" +
	"LINEAR A SIGN A643LINEAR A SIGN A644LINEAR A SIGN A645LINEAR A SIGN A646" +
	"LINEAR A SIGN A648LINEAR A SIGN A649LINEAR A SIGN A651LINEAR A SIGN A652" +
	"LINEAR A SIGN A653LINEAR A SIGN A654LINEAR A SIGN A655LINEAR A SIGN A656" +
	"LINEAR A SIGN A657LINEAR A SIGN A658LINEAR A SIGN A659LINEAR A SIGN A660" +
	"LINEAR A SIGN A661LINEAR A SIGN A662LINEAR A SIGN A663LINEAR A SIGN A664" +
	"LINEAR A SIGN A701 ALINEAR A SIGN A702 BLINEAR A SIGN A703 DLINEAR A SIG" +
	"N A704 ELINEAR A SIGN A705 FLINEAR A SIGN A706 HLINEAR A SIGN A707 JLINE" +
	"AR A SIGN A708 KLINEAR A SIGN A709 LLINEAR A SIGN A709-2 L2LINEAR A SIGN" +
	" A709-3 L3LINEAR A SIGN A709-4 L4LINEAR A SIGN A709-6 L6LINEAR A SIGN A7" +
	"10 WLINEAR A SIGN A711 XLINEAR A SIGN A712 YLINEAR A SIGN A713 OMEGALINE") + ("" +
	"AR A SIGN A714 ABBLINEAR A SIGN A715 BBLINEAR A SIGN A717 DDLINEAR A SIG" +
	"N A726 EYYYLINEAR A SIGN A732 JELINEAR A SIGN A800LINEAR A SIGN A801LINE" +
	"AR A SIGN A802LINEAR A SIGN A803LINEAR A SIGN A804LINEAR A SIGN A805LINE" +
	"AR A SIGN A806LINEAR A SIGN A807CYPRIOT SYLLABLE ACYPRIOT SYLLABLE ECYPR" +
	"IOT SYLLABLE ICYPRIOT SYLLABLE OCYPRIOT SYLLABLE UCYPRIOT SYLLABLE JACYP" +
	"RIOT SYLLABLE JOCYPRIOT SYLLABLE KACYPRIOT SYLLABLE KECYPRIOT SYLLABLE K" +
	"ICYPRIOT SYLLABLE KOCYPRIOT SYLLABLE KUCYPRIOT SYLLABLE LACYPRIOT SYLLAB" +
	"LE LECYPRIOT SYLLABLE LICYPRIOT SYLLABLE LOCYPRIOT SYLLABLE LUCYPRIOT SY" +
	"LLABLE MACYPRIOT SYLLABLE MECYPRIOT SYLLABLE MICYPRIOT SYLLABLE MOCYPRIO" +
	"T SYLLABLE MUCYPRIOT SYLLABLE NACYPRIOT SYLLABLE NECYPRIOT SYLLABLE NICY" +
	"PRIOT SYLLABLE NOCYPRIOT SYLLABLE NUCYPRIOT SYLLABLE PACYPRIOT SYLLABLE " +
	"PECYPRIOT SYLLABLE PICYPRIOT SYLLABLE POCYPRIOT SYLLABLE PUCYPRIOT SYLLA" +
	"BLE RACYPRIOT SYLLABLE RECYPRIOT SYLLABLE RICYPRIOT SYLLABLE ROCYPRIOT S" +
	"YLLABLE RUCYPRIOT SYLLABLE SACYPRIOT SYLLABLE SECYPRIOT SYLLABLE SICYPRI" +
	"OT SYLLABLE SOCYPRIOT SYLLABLE SUCYPRIOT SYLLABLE TACYPRIOT SYLLABLE TEC" +
	"YPRIOT SYLLABLE TICYPRIOT SYLLABLE TOCYPRIOT SYLLABLE TUCYPRIOT SYLLABLE" +
	" WACYPRIOT SYLLABLE WECYPRIOT SYLLABLE WICYPRIOT SYLLABLE WOCYPRIOT SYLL" +
	"ABLE XACYPRIOT SYLLABLE XECYPRIOT SYLLABLE ZACYPRIOT SYLLABLE ZOIMPERIAL" +
	" ARAMAIC LETTER ALEPHIMPERIAL ARAMAIC LETTER BETHIMPERIAL ARAMAIC LETTER" +
	" GIMELIMPERIAL ARAMAIC LETTER DALETHIMPERIAL ARAMAIC LETTER HEIMPERIAL A" +
	"RAMAIC LETTER WAWIMPERIAL ARAMAIC LETTER ZAYINIMPERIAL ARAMAIC LETTER HE" +
	"THIMPERIAL ARAMAIC LETTER TETHIMPERIAL ARAMAIC LETTER YODHIMPERIAL ARAMA" +
	"IC LETTER KAPHIMPERIAL ARAMAIC LETTER LAMEDHIMPERIAL ARAMAIC LETTER MEMI" +
	"MPERIAL ARAMAIC LETTER NUNIMPERIAL ARAMAIC LETTER SAMEKHIMPERIAL ARAMAIC" +
	" LETTER AYINIMPERIAL ARAMAIC LETTER PEIMPERIAL ARAMAIC LETTER SADHEIMPER" +
	"IAL ARAMAIC LETTER QOPHIMPERIAL ARAMAIC LETTER RESHIMPERIAL ARAMAIC LETT" +
	"ER SHINIMPERIAL ARAMAIC LETTER TAWIMPERIAL ARAMAIC SECTION SIGNIMPERIAL " +
	"ARAMAIC NUMBER ONEIMPERIAL ARAMAIC NUMBER TWOIMPERIAL ARAMAIC NUMBER THR" +
	"EEIMPERIAL ARAMAIC NUMBER TENIMPERIAL ARAMAIC NUMBER TWENTYIMPERIAL ARAM" +
	"AIC NUMBER ONE HUNDREDIMPERIAL ARAMAIC NUMBER ONE THOUSANDIMPERIAL ARAMA" +
	"IC NUMBER TEN THOUSANDPALMYRENE LETTER ALEPHPALMYRENE LETTER BETHPALMYRE" +
	"NE LETTER GIMELPALMYRENE LETTER DALETHPALMYRENE LETTER HEPALMYRENE LETTE" +
	"R WAWPALMYRENE LETTER ZAYINPALMYRENE LETTER HETHPALMYRENE LETTER TETHPAL" +
	"MYRENE LETTER YODHPALMYRENE LETTER KAPHPALMYRENE LETTER LAMEDHPALMYRENE " +
	"LETTER MEMPALMYRENE LETTER FINAL NUNPALMYRENE LETTER NUNPALMYRENE LETTER" +
	" SAMEKHPALMYRENE LETTER AYINPALMYRENE LETTER PEPALMYRENE LETTER SADHEPAL" +
	"MYRENE LETTER QOPHPALMYRENE LETTER RESHPALMYRENE LETTER SHINPALMYRENE LE" +
	"TTER TAWPALMYRENE LEFT-POINTING FLEURONPALMYRENE RIGHT-POINTING FLEURONP" +
	"ALMYRENE NUMBER ONEPALMYRENE NUMBER TWOPALMYRENE NUMBER THREEPALMYRENE N" +
	"UMBER FOURPALMYRENE NUMBER FIVEPALMYRENE NUMBER TENPALMYRENE NUMBER TWEN" +
	"TYNABATAEAN LETTER FINAL ALEPHNABATAEAN LETTER ALEPHNABATAEAN LETTER FIN" +
	"AL BETHNABATAEAN LETTER BETHNABATAEAN LETTER GIMELNABATAEAN LETTER DALET" +
	"HNABATAEAN LETTER FINAL HENABATAEAN LETTER HENABATAEAN LETTER WAWNABATAE" +
	"AN LETTER ZAYINNABATAEAN LETTER HETHNABATAEAN LETTER TETHNABATAEAN LETTE" +
	"R FINAL YODHNABATAEAN LETTER YODHNABATAEAN LETTER FINAL KAPHNABATAEAN LE" +
	"TTER KAPHNABATAEAN LETTER FINAL LAMEDHNABATAEAN LETTER LAMEDHNABATAEAN L" +
	"ETTER FINAL MEMNABATAEAN LETTER MEMNABATAEAN LETTER FINAL NUNNABATAEAN L" +
	"ETTER NUNNABATAEAN LETTER SAMEKHNABATAEAN LETTER AYINNABATAEAN LETTER PE" +
	"NABATAEAN LETTER SADHENABATAEAN LETTER QOPHNABATAEAN LETTER RESHNABATAEA" +
	"N LETTER FINAL SHINNABATAEAN LETTER SHINNABATAEAN LETTER TAWNABATAEAN NU" +
	"MBER ONENABATAEAN NUMBER TWONABATAEAN NUMBER THREENABATAEAN NUMBER FOURN" +
	"ABATAEAN CRUCIFORM NUMBER FOURNABATAEAN NUMBER FIVENABATAEAN NUMBER TENN" +
	"ABATAEAN NUMBER TWENTYNABATAEAN NUMBER ONE HUNDREDHATRAN LETTER ALEPHHAT" +
	"RAN LETTER BETHHATRAN LETTER GIMELHATRAN LETTER DALETH-RESHHATRAN LETTER" +
	" HEHATRAN LETTER WAWHATRAN LETTER ZAYNHATRAN LETTER HETHHATRAN LETTER TE" +
	"THHATRAN LETTER YODHHATRAN LETTER KAPHHATRAN LETTER LAMEDHHATRAN LETTER " +
	"MEMHATRAN LETTER NUNHATRAN LETTER SAMEKHHATRAN LETTER AYNHATRAN LETTER P" +
	"EHATRAN LETTER SADHEHATRAN LETTER QOPHHATRAN LETTER SHINHATRAN LETTER TA" +
	"WHATRAN NUMBER ONEHATRAN NUMBER FIVEHATRAN NUMBER TENHATRAN NUMBER TWENT" +
	"YHATRAN NUMBER ONE HUNDREDPHOENICIAN LETTER ALFPHOENICIAN LETTER BETPHOE" +
	"NICIAN LETTER GAMLPHOENICIAN LETTER DELTPHOENICIAN LETTER HEPHOENICIAN L" +
	"ETTER WAUPHOENICIAN LETTER ZAIPHOENICIAN LETTER HETPHOENICIAN LETTER TET" +
	"PHOENICIAN LETTER YODPHOENICIAN LETTER KAFPHOENICIAN LETTER LAMDPHOENICI" +
	"AN LETTER MEMPHOENICIAN LETTER NUNPHOENICIAN LETTER SEMKPHOENICIAN LETTE") + ("" +
	"R AINPHOENICIAN LETTER PEPHOENICIAN LETTER SADEPHOENICIAN LETTER QOFPHOE" +
	"NICIAN LETTER ROSHPHOENICIAN LETTER SHINPHOENICIAN LETTER TAUPHOENICIAN " +
	"NUMBER ONEPHOENICIAN NUMBER TENPHOENICIAN NUMBER TWENTYPHOENICIAN NUMBER" +
	" ONE HUNDREDPHOENICIAN NUMBER TWOPHOENICIAN NUMBER THREEPHOENICIAN WORD " +
	"SEPARATORLYDIAN LETTER ALYDIAN LETTER BLYDIAN LETTER GLYDIAN LETTER DLYD" +
	"IAN LETTER ELYDIAN LETTER VLYDIAN LETTER ILYDIAN LETTER YLYDIAN LETTER K" +
	"LYDIAN LETTER LLYDIAN LETTER MLYDIAN LETTER NLYDIAN LETTER OLYDIAN LETTE" +
	"R RLYDIAN LETTER SSLYDIAN LETTER TLYDIAN LETTER ULYDIAN LETTER FLYDIAN L" +
	"ETTER QLYDIAN LETTER SLYDIAN LETTER TTLYDIAN LETTER ANLYDIAN LETTER ENLY" +
	"DIAN LETTER LYLYDIAN LETTER NNLYDIAN LETTER CLYDIAN TRIANGULAR MARKMEROI" +
	"TIC HIEROGLYPHIC LETTER AMEROITIC HIEROGLYPHIC LETTER EMEROITIC HIEROGLY" +
	"PHIC LETTER IMEROITIC HIEROGLYPHIC LETTER OMEROITIC HIEROGLYPHIC LETTER " +
	"YAMEROITIC HIEROGLYPHIC LETTER WAMEROITIC HIEROGLYPHIC LETTER BAMEROITIC" +
	" HIEROGLYPHIC LETTER BA-2MEROITIC HIEROGLYPHIC LETTER PAMEROITIC HIEROGL" +
	"YPHIC LETTER MAMEROITIC HIEROGLYPHIC LETTER NAMEROITIC HIEROGLYPHIC LETT" +
	"ER NA-2MEROITIC HIEROGLYPHIC LETTER NEMEROITIC HIEROGLYPHIC LETTER NE-2M" +
	"EROITIC HIEROGLYPHIC LETTER RAMEROITIC HIEROGLYPHIC LETTER RA-2MEROITIC " +
	"HIEROGLYPHIC LETTER LAMEROITIC HIEROGLYPHIC LETTER KHAMEROITIC HIEROGLYP" +
	"HIC LETTER HHAMEROITIC HIEROGLYPHIC LETTER SAMEROITIC HIEROGLYPHIC LETTE" +
	"R SA-2MEROITIC HIEROGLYPHIC LETTER SEMEROITIC HIEROGLYPHIC LETTER KAMERO" +
	"ITIC HIEROGLYPHIC LETTER QAMEROITIC HIEROGLYPHIC LETTER TAMEROITIC HIERO" +
	"GLYPHIC LETTER TA-2MEROITIC HIEROGLYPHIC LETTER TEMEROITIC HIEROGLYPHIC " +
	"LETTER TE-2MEROITIC HIEROGLYPHIC LETTER TOMEROITIC HIEROGLYPHIC LETTER D" +
	"AMEROITIC HIEROGLYPHIC SYMBOL VIDJMEROITIC HIEROGLYPHIC SYMBOL VIDJ-2MER" +
	"OITIC CURSIVE LETTER AMEROITIC CURSIVE LETTER EMEROITIC CURSIVE LETTER I" +
	"MEROITIC CURSIVE LETTER OMEROITIC CURSIVE LETTER YAMEROITIC CURSIVE LETT" +
	"ER WAMEROITIC CURSIVE LETTER BAMEROITIC CURSIVE LETTER PAMEROITIC CURSIV" +
	"E LETTER MAMEROITIC CURSIVE LETTER NAMEROITIC CURSIVE LETTER NEMEROITIC " +
	"CURSIVE LETTER RAMEROITIC CURSIVE LETTER LAMEROITIC CURSIVE LETTER KHAME" +
	"ROITIC CURSIVE LETTER HHAMEROITIC CURSIVE LETTER SAMEROITIC CURSIVE LETT" +
	"ER ARCHAIC SAMEROITIC CURSIVE LETTER SEMEROITIC CURSIVE LETTER KAMEROITI" +
	"C CURSIVE LETTER QAMEROITIC CURSIVE LETTER TAMEROITIC CURSIVE LETTER TEM" +
	"EROITIC CURSIVE LETTER TOMEROITIC CURSIVE LETTER DAMEROITIC CURSIVE FRAC" +
	"TION ELEVEN TWELFTHSMEROITIC CURSIVE FRACTION ONE HALFMEROITIC CURSIVE L" +
	"OGOGRAM RMTMEROITIC CURSIVE LOGOGRAM IMNMEROITIC CURSIVE NUMBER ONEMEROI" +
	"TIC CURSIVE NUMBER TWOMEROITIC CURSIVE NUMBER THREEMEROITIC CURSIVE NUMB" +
	"ER FOURMEROITIC CURSIVE NUMBER FIVEMEROITIC CURSIVE NUMBER SIXMEROITIC C" +
	"URSIVE NUMBER SEVENMEROITIC CURSIVE NUMBER EIGHTMEROITIC CURSIVE NUMBER " +
	"NINEMEROITIC CURSIVE NUMBER TENMEROITIC CURSIVE NUMBER TWENTYMEROITIC CU" +
	"RSIVE NUMBER THIRTYMEROITIC CURSIVE NUMBER FORTYMEROITIC CURSIVE NUMBER " +
	"FIFTYMEROITIC CURSIVE NUMBER SIXTYMEROITIC CURSIVE NUMBER SEVENTYMEROITI" +
	"C CURSIVE NUMBER ONE HUNDREDMEROITIC CURSIVE NUMBER TWO HUNDREDMEROITIC " +
	"CURSIVE NUMBER THREE HUNDREDMEROITIC CURSIVE NUMBER FOUR HUNDREDMEROITIC" +
	" CURSIVE NUMBER FIVE HUNDREDMEROITIC CURSIVE NUMBER SIX HUNDREDMEROITIC " +
	"CURSIVE NUMBER SEVEN HUNDREDMEROITIC CURSIVE NUMBER EIGHT HUNDREDMEROITI" +
	"C CURSIVE NUMBER NINE HUNDREDMEROITIC CURSIVE NUMBER ONE THOUSANDMEROITI" +
	"C CURSIVE NUMBER TWO THOUSANDMEROITIC CURSIVE NUMBER THREE THOUSANDMEROI" +
	"TIC CURSIVE NUMBER FOUR THOUSANDMEROITIC CURSIVE NUMBER FIVE THOUSANDMER" +
	"OITIC CURSIVE NUMBER SIX THOUSANDMEROITIC CURSIVE NUMBER SEVEN THOUSANDM" +
	"EROITIC CURSIVE NUMBER EIGHT THOUSANDMEROITIC CURSIVE NUMBER NINE THOUSA" +
	"NDMEROITIC CURSIVE NUMBER TEN THOUSANDMEROITIC CURSIVE NUMBER TWENTY THO" +
	"USANDMEROITIC CURSIVE NUMBER THIRTY THOUSANDMEROITIC CURSIVE NUMBER FORT" +
	"Y THOUSANDMEROITIC CURSIVE NUMBER FIFTY THOUSANDMEROITIC CURSIVE NUMBER " +
	"SIXTY THOUSANDMEROITIC CURSIVE NUMBER SEVENTY THOUSANDMEROITIC CURSIVE N" +
	"UMBER EIGHTY THOUSANDMEROITIC CURSIVE NUMBER NINETY THOUSANDMEROITIC CUR" +
	"SIVE NUMBER ONE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER TWO HUNDRED THOU" +
	"SANDMEROITIC CURSIVE NUMBER THREE HUNDRED THOUSANDMEROITIC CURSIVE NUMBE" +
	"R FOUR HUNDRED THOUSANDMEROITIC CURSIVE NUMBER FIVE HUNDRED THOUSANDMERO" +
	"ITIC CURSIVE NUMBER SIX HUNDRED THOUSANDMEROITIC CURSIVE NUMBER SEVEN HU" +
	"NDRED THOUSANDMEROITIC CURSIVE NUMBER EIGHT HUNDRED THOUSANDMEROITIC CUR" +
	"SIVE NUMBER NINE HUNDRED THOUSANDMEROITIC CURSIVE FRACTION ONE TWELFTHME" +
	"ROITIC CURSIVE FRACTION TWO TWELFTHSMEROITIC CURSIVE FRACTION THREE TWEL" +
	"FTHSMEROITIC CURSIVE FRACTION FOUR TWELFTHSMEROITIC CURSIVE FRACTION FIV" +
	"E TWELFTHSMEROITIC CURSIVE FRACTION SIX TWELFTHSMEROITIC CURSIVE FRACTIO") + ("" +
	"N SEVEN TWELFTHSMEROITIC CURSIVE FRACTION EIGHT TWELFTHSMEROITIC CURSIVE" +
	" FRACTION NINE TWELFTHSMEROITIC CURSIVE FRACTION TEN TWELFTHSKHAROSHTHI " +
	"LETTER AKHAROSHTHI VOWEL SIGN IKHAROSHTHI VOWEL SIGN UKHAROSHTHI VOWEL S" +
	"IGN VOCALIC RKHAROSHTHI VOWEL SIGN EKHAROSHTHI VOWEL SIGN OKHAROSHTHI VO" +
	"WEL LENGTH MARKKHAROSHTHI SIGN DOUBLE RING BELOWKHAROSHTHI SIGN ANUSVARA" +
	"KHAROSHTHI SIGN VISARGAKHAROSHTHI LETTER KAKHAROSHTHI LETTER KHAKHAROSHT" +
	"HI LETTER GAKHAROSHTHI LETTER GHAKHAROSHTHI LETTER CAKHAROSHTHI LETTER C" +
	"HAKHAROSHTHI LETTER JAKHAROSHTHI LETTER NYAKHAROSHTHI LETTER TTAKHAROSHT" +
	"HI LETTER TTHAKHAROSHTHI LETTER DDAKHAROSHTHI LETTER DDHAKHAROSHTHI LETT" +
	"ER NNAKHAROSHTHI LETTER TAKHAROSHTHI LETTER THAKHAROSHTHI LETTER DAKHARO" +
	"SHTHI LETTER DHAKHAROSHTHI LETTER NAKHAROSHTHI LETTER PAKHAROSHTHI LETTE" +
	"R PHAKHAROSHTHI LETTER BAKHAROSHTHI LETTER BHAKHAROSHTHI LETTER MAKHAROS" +
	"HTHI LETTER YAKHAROSHTHI LETTER RAKHAROSHTHI LETTER LAKHAROSHTHI LETTER " +
	"VAKHAROSHTHI LETTER SHAKHAROSHTHI LETTER SSAKHAROSHTHI LETTER SAKHAROSHT" +
	"HI LETTER ZAKHAROSHTHI LETTER HAKHAROSHTHI LETTER KKAKHAROSHTHI LETTER T" +
	"TTHAKHAROSHTHI LETTER TTTAKHAROSHTHI LETTER VHAKHAROSHTHI SIGN BAR ABOVE" +
	"KHAROSHTHI SIGN CAUDAKHAROSHTHI SIGN DOT BELOWKHAROSHTHI VIRAMAKHAROSHTH" +
	"I DIGIT ONEKHAROSHTHI DIGIT TWOKHAROSHTHI DIGIT THREEKHAROSHTHI DIGIT FO" +
	"URKHAROSHTHI NUMBER TENKHAROSHTHI NUMBER TWENTYKHAROSHTHI NUMBER ONE HUN" +
	"DREDKHAROSHTHI NUMBER ONE THOUSANDKHAROSHTHI FRACTION ONE HALFKHAROSHTHI" +
	" PUNCTUATION DOTKHAROSHTHI PUNCTUATION SMALL CIRCLEKHAROSHTHI PUNCTUATIO" +
	"N CIRCLEKHAROSHTHI PUNCTUATION CRESCENT BARKHAROSHTHI PUNCTUATION MANGAL" +
	"AMKHAROSHTHI PUNCTUATION LOTUSKHAROSHTHI PUNCTUATION DANDAKHAROSHTHI PUN" +
	"CTUATION DOUBLE DANDAKHAROSHTHI PUNCTUATION LINESOLD SOUTH ARABIAN LETTE" +
	"R HEOLD SOUTH ARABIAN LETTER LAMEDHOLD SOUTH ARABIAN LETTER HETHOLD SOUT" +
	"H ARABIAN LETTER MEMOLD SOUTH ARABIAN LETTER QOPHOLD SOUTH ARABIAN LETTE" +
	"R WAWOLD SOUTH ARABIAN LETTER SHINOLD SOUTH ARABIAN LETTER RESHOLD SOUTH" +
	" ARABIAN LETTER BETHOLD SOUTH ARABIAN LETTER TAWOLD SOUTH ARABIAN LETTER" +
	" SATOLD SOUTH ARABIAN LETTER KAPHOLD SOUTH ARABIAN LETTER NUNOLD SOUTH A" +
	"RABIAN LETTER KHETHOLD SOUTH ARABIAN LETTER SADHEOLD SOUTH ARABIAN LETTE" +
	"R SAMEKHOLD SOUTH ARABIAN LETTER FEOLD SOUTH ARABIAN LETTER ALEFOLD SOUT" +
	"H ARABIAN LETTER AYNOLD SOUTH ARABIAN LETTER DHADHEOLD SOUTH ARABIAN LET" +
	"TER GIMELOLD SOUTH ARABIAN LETTER DALETHOLD SOUTH ARABIAN LETTER GHAYNOL" +
	"D SOUTH ARABIAN LETTER TETHOLD SOUTH ARABIAN LETTER ZAYNOLD SOUTH ARABIA" +
	"N LETTER DHALETHOLD SOUTH ARABIAN LETTER YODHOLD SOUTH ARABIAN LETTER TH" +
	"AWOLD SOUTH ARABIAN LETTER THETHOLD SOUTH ARABIAN NUMBER ONEOLD SOUTH AR" +
	"ABIAN NUMBER FIFTYOLD SOUTH ARABIAN NUMERIC INDICATOROLD NORTH ARABIAN L" +
	"ETTER HEHOLD NORTH ARABIAN LETTER LAMOLD NORTH ARABIAN LETTER HAHOLD NOR" +
	"TH ARABIAN LETTER MEEMOLD NORTH ARABIAN LETTER QAFOLD NORTH ARABIAN LETT" +
	"ER WAWOLD NORTH ARABIAN LETTER ES-2OLD NORTH ARABIAN LETTER REHOLD NORTH" +
	" ARABIAN LETTER BEHOLD NORTH ARABIAN LETTER TEHOLD NORTH ARABIAN LETTER " +
	"ES-1OLD NORTH ARABIAN LETTER KAFOLD NORTH ARABIAN LETTER NOONOLD NORTH A" +
	"RABIAN LETTER KHAHOLD NORTH ARABIAN LETTER SADOLD NORTH ARABIAN LETTER E" +
	"S-3OLD NORTH ARABIAN LETTER FEHOLD NORTH ARABIAN LETTER ALEFOLD NORTH AR" +
	"ABIAN LETTER AINOLD NORTH ARABIAN LETTER DADOLD NORTH ARABIAN LETTER GEE" +
	"MOLD NORTH ARABIAN LETTER DALOLD NORTH ARABIAN LETTER GHAINOLD NORTH ARA" +
	"BIAN LETTER TAHOLD NORTH ARABIAN LETTER ZAINOLD NORTH ARABIAN LETTER THA" +
	"LOLD NORTH ARABIAN LETTER YEHOLD NORTH ARABIAN LETTER THEHOLD NORTH ARAB" +
	"IAN LETTER ZAHOLD NORTH ARABIAN NUMBER ONEOLD NORTH ARABIAN NUMBER TENOL" +
	"D NORTH ARABIAN NUMBER TWENTYMANICHAEAN LETTER ALEPHMANICHAEAN LETTER BE" +
	"THMANICHAEAN LETTER BHETHMANICHAEAN LETTER GIMELMANICHAEAN LETTER GHIMEL" +
	"MANICHAEAN LETTER DALETHMANICHAEAN LETTER HEMANICHAEAN LETTER WAWMANICHA" +
	"EAN SIGN UDMANICHAEAN LETTER ZAYINMANICHAEAN LETTER ZHAYINMANICHAEAN LET" +
	"TER JAYINMANICHAEAN LETTER JHAYINMANICHAEAN LETTER HETHMANICHAEAN LETTER" +
	" TETHMANICHAEAN LETTER YODHMANICHAEAN LETTER KAPHMANICHAEAN LETTER XAPHM" +
	"ANICHAEAN LETTER KHAPHMANICHAEAN LETTER LAMEDHMANICHAEAN LETTER DHAMEDHM" +
	"ANICHAEAN LETTER THAMEDHMANICHAEAN LETTER MEMMANICHAEAN LETTER NUNMANICH" +
	"AEAN LETTER SAMEKHMANICHAEAN LETTER AYINMANICHAEAN LETTER AAYINMANICHAEA" +
	"N LETTER PEMANICHAEAN LETTER FEMANICHAEAN LETTER SADHEMANICHAEAN LETTER " +
	"QOPHMANICHAEAN LETTER XOPHMANICHAEAN LETTER QHOPHMANICHAEAN LETTER RESHM" +
	"ANICHAEAN LETTER SHINMANICHAEAN LETTER SSHINMANICHAEAN LETTER TAWMANICHA" +
	"EAN ABBREVIATION MARK ABOVEMANICHAEAN ABBREVIATION MARK BELOWMANICHAEAN " +
	"NUMBER ONEMANICHAEAN NUMBER FIVEMANICHAEAN NUMBER TENMANICHAEAN NUMBER T" +
	"WENTYMANICHAEAN NUMBER ONE HUNDREDMANICHAEAN PUNCTUATION STARMANICHAEAN ") + ("" +
	"PUNCTUATION FLEURONMANICHAEAN PUNCTUATION DOUBLE DOT WITHIN DOTMANICHAEA" +
	"N PUNCTUATION DOT WITHIN DOTMANICHAEAN PUNCTUATION DOTMANICHAEAN PUNCTUA" +
	"TION TWO DOTSMANICHAEAN PUNCTUATION LINE FILLERAVESTAN LETTER AAVESTAN L" +
	"ETTER AAAVESTAN LETTER AOAVESTAN LETTER AAOAVESTAN LETTER ANAVESTAN LETT" +
	"ER AANAVESTAN LETTER AEAVESTAN LETTER AEEAVESTAN LETTER EAVESTAN LETTER " +
	"EEAVESTAN LETTER OAVESTAN LETTER OOAVESTAN LETTER IAVESTAN LETTER IIAVES" +
	"TAN LETTER UAVESTAN LETTER UUAVESTAN LETTER KEAVESTAN LETTER XEAVESTAN L" +
	"ETTER XYEAVESTAN LETTER XVEAVESTAN LETTER GEAVESTAN LETTER GGEAVESTAN LE" +
	"TTER GHEAVESTAN LETTER CEAVESTAN LETTER JEAVESTAN LETTER TEAVESTAN LETTE" +
	"R THEAVESTAN LETTER DEAVESTAN LETTER DHEAVESTAN LETTER TTEAVESTAN LETTER" +
	" PEAVESTAN LETTER FEAVESTAN LETTER BEAVESTAN LETTER BHEAVESTAN LETTER NG" +
	"EAVESTAN LETTER NGYEAVESTAN LETTER NGVEAVESTAN LETTER NEAVESTAN LETTER N" +
	"YEAVESTAN LETTER NNEAVESTAN LETTER MEAVESTAN LETTER HMEAVESTAN LETTER YY" +
	"EAVESTAN LETTER YEAVESTAN LETTER VEAVESTAN LETTER REAVESTAN LETTER LEAVE" +
	"STAN LETTER SEAVESTAN LETTER ZEAVESTAN LETTER SHEAVESTAN LETTER ZHEAVEST" +
	"AN LETTER SHYEAVESTAN LETTER SSHEAVESTAN LETTER HEAVESTAN ABBREVIATION M" +
	"ARKTINY TWO DOTS OVER ONE DOT PUNCTUATIONSMALL TWO DOTS OVER ONE DOT PUN" +
	"CTUATIONLARGE TWO DOTS OVER ONE DOT PUNCTUATIONLARGE ONE DOT OVER TWO DO" +
	"TS PUNCTUATIONLARGE TWO RINGS OVER ONE RING PUNCTUATIONLARGE ONE RING OV" +
	"ER TWO RINGS PUNCTUATIONINSCRIPTIONAL PARTHIAN LETTER ALEPHINSCRIPTIONAL" +
	" PARTHIAN LETTER BETHINSCRIPTIONAL PARTHIAN LETTER GIMELINSCRIPTIONAL PA" +
	"RTHIAN LETTER DALETHINSCRIPTIONAL PARTHIAN LETTER HEINSCRIPTIONAL PARTHI" +
	"AN LETTER WAWINSCRIPTIONAL PARTHIAN LETTER ZAYININSCRIPTIONAL PARTHIAN L" +
	"ETTER HETHINSCRIPTIONAL PARTHIAN LETTER TETHINSCRIPTIONAL PARTHIAN LETTE" +
	"R YODHINSCRIPTIONAL PARTHIAN LETTER KAPHINSCRIPTIONAL PARTHIAN LETTER LA" +
	"MEDHINSCRIPTIONAL PARTHIAN LETTER MEMINSCRIPTIONAL PARTHIAN LETTER NUNIN" +
	"SCRIPTIONAL PARTHIAN LETTER SAMEKHINSCRIPTIONAL PARTHIAN LETTER AYININSC" +
	"RIPTIONAL PARTHIAN LETTER PEINSCRIPTIONAL PARTHIAN LETTER SADHEINSCRIPTI" +
	"ONAL PARTHIAN LETTER QOPHINSCRIPTIONAL PARTHIAN LETTER RESHINSCRIPTIONAL" +
	" PARTHIAN LETTER SHININSCRIPTIONAL PARTHIAN LETTER TAWINSCRIPTIONAL PART" +
	"HIAN NUMBER ONEINSCRIPTIONAL PARTHIAN NUMBER TWOINSCRIPTIONAL PARTHIAN N" +
	"UMBER THREEINSCRIPTIONAL PARTHIAN NUMBER FOURINSCRIPTIONAL PARTHIAN NUMB" +
	"ER TENINSCRIPTIONAL PARTHIAN NUMBER TWENTYINSCRIPTIONAL PARTHIAN NUMBER " +
	"ONE HUNDREDINSCRIPTIONAL PARTHIAN NUMBER ONE THOUSANDINSCRIPTIONAL PAHLA" +
	"VI LETTER ALEPHINSCRIPTIONAL PAHLAVI LETTER BETHINSCRIPTIONAL PAHLAVI LE" +
	"TTER GIMELINSCRIPTIONAL PAHLAVI LETTER DALETHINSCRIPTIONAL PAHLAVI LETTE" +
	"R HEINSCRIPTIONAL PAHLAVI LETTER WAW-AYIN-RESHINSCRIPTIONAL PAHLAVI LETT" +
	"ER ZAYININSCRIPTIONAL PAHLAVI LETTER HETHINSCRIPTIONAL PAHLAVI LETTER TE" +
	"THINSCRIPTIONAL PAHLAVI LETTER YODHINSCRIPTIONAL PAHLAVI LETTER KAPHINSC" +
	"RIPTIONAL PAHLAVI LETTER LAMEDHINSCRIPTIONAL PAHLAVI LETTER MEM-QOPHINSC" +
	"RIPTIONAL PAHLAVI LETTER NUNINSCRIPTIONAL PAHLAVI LETTER SAMEKHINSCRIPTI" +
	"ONAL PAHLAVI LETTER PEINSCRIPTIONAL PAHLAVI LETTER SADHEINSCRIPTIONAL PA" +
	"HLAVI LETTER SHININSCRIPTIONAL PAHLAVI LETTER TAWINSCRIPTIONAL PAHLAVI N" +
	"UMBER ONEINSCRIPTIONAL PAHLAVI NUMBER TWOINSCRIPTIONAL PAHLAVI NUMBER TH" +
	"REEINSCRIPTIONAL PAHLAVI NUMBER FOURINSCRIPTIONAL PAHLAVI NUMBER TENINSC" +
	"RIPTIONAL PAHLAVI NUMBER TWENTYINSCRIPTIONAL PAHLAVI NUMBER ONE HUNDREDI" +
	"NSCRIPTIONAL PAHLAVI NUMBER ONE THOUSANDPSALTER PAHLAVI LETTER ALEPHPSAL" +
	"TER PAHLAVI LETTER BETHPSALTER PAHLAVI LETTER GIMELPSALTER PAHLAVI LETTE" +
	"R DALETHPSALTER PAHLAVI LETTER HEPSALTER PAHLAVI LETTER WAW-AYIN-RESHPSA" +
	"LTER PAHLAVI LETTER ZAYINPSALTER PAHLAVI LETTER HETHPSALTER PAHLAVI LETT" +
	"ER YODHPSALTER PAHLAVI LETTER KAPHPSALTER PAHLAVI LETTER LAMEDHPSALTER P" +
	"AHLAVI LETTER MEM-QOPHPSALTER PAHLAVI LETTER NUNPSALTER PAHLAVI LETTER S" +
	"AMEKHPSALTER PAHLAVI LETTER PEPSALTER PAHLAVI LETTER SADHEPSALTER PAHLAV" +
	"I LETTER SHINPSALTER PAHLAVI LETTER TAWPSALTER PAHLAVI SECTION MARKPSALT" +
	"ER PAHLAVI TURNED SECTION MARKPSALTER PAHLAVI FOUR DOTS WITH CROSSPSALTE" +
	"R PAHLAVI FOUR DOTS WITH DOTPSALTER PAHLAVI NUMBER ONEPSALTER PAHLAVI NU" +
	"MBER TWOPSALTER PAHLAVI NUMBER THREEPSALTER PAHLAVI NUMBER FOURPSALTER P" +
	"AHLAVI NUMBER TENPSALTER PAHLAVI NUMBER TWENTYPSALTER PAHLAVI NUMBER ONE" +
	" HUNDREDOLD TURKIC LETTER ORKHON AOLD TURKIC LETTER YENISEI AOLD TURKIC " +
	"LETTER YENISEI AEOLD TURKIC LETTER ORKHON IOLD TURKIC LETTER YENISEI IOL" +
	"D TURKIC LETTER YENISEI EOLD TURKIC LETTER ORKHON OOLD TURKIC LETTER ORK" +
	"HON OEOLD TURKIC LETTER YENISEI OEOLD TURKIC LETTER ORKHON ABOLD TURKIC " +
	"LETTER YENISEI ABOLD TURKIC LETTER ORKHON AEBOLD TURKIC LETTER YENISEI A" +
	"EBOLD TURKIC LETTER ORKHON AGOLD TURKIC LETTER YENISEI AGOLD TURKIC LETT") + ("" +
	"ER ORKHON AEGOLD TURKIC LETTER YENISEI AEGOLD TURKIC LETTER ORKHON ADOLD" +
	" TURKIC LETTER YENISEI ADOLD TURKIC LETTER ORKHON AEDOLD TURKIC LETTER O" +
	"RKHON EZOLD TURKIC LETTER YENISEI EZOLD TURKIC LETTER ORKHON AYOLD TURKI" +
	"C LETTER YENISEI AYOLD TURKIC LETTER ORKHON AEYOLD TURKIC LETTER YENISEI" +
	" AEYOLD TURKIC LETTER ORKHON AEKOLD TURKIC LETTER YENISEI AEKOLD TURKIC " +
	"LETTER ORKHON OEKOLD TURKIC LETTER YENISEI OEKOLD TURKIC LETTER ORKHON A" +
	"LOLD TURKIC LETTER YENISEI ALOLD TURKIC LETTER ORKHON AELOLD TURKIC LETT" +
	"ER ORKHON ELTOLD TURKIC LETTER ORKHON EMOLD TURKIC LETTER ORKHON ANOLD T" +
	"URKIC LETTER ORKHON AENOLD TURKIC LETTER YENISEI AENOLD TURKIC LETTER OR" +
	"KHON ENTOLD TURKIC LETTER YENISEI ENTOLD TURKIC LETTER ORKHON ENCOLD TUR" +
	"KIC LETTER YENISEI ENCOLD TURKIC LETTER ORKHON ENYOLD TURKIC LETTER YENI" +
	"SEI ENYOLD TURKIC LETTER YENISEI ANGOLD TURKIC LETTER ORKHON ENGOLD TURK" +
	"IC LETTER YENISEI AENGOLD TURKIC LETTER ORKHON EPOLD TURKIC LETTER ORKHO" +
	"N OPOLD TURKIC LETTER ORKHON ICOLD TURKIC LETTER ORKHON ECOLD TURKIC LET" +
	"TER YENISEI ECOLD TURKIC LETTER ORKHON AQOLD TURKIC LETTER YENISEI AQOLD" +
	" TURKIC LETTER ORKHON IQOLD TURKIC LETTER YENISEI IQOLD TURKIC LETTER OR" +
	"KHON OQOLD TURKIC LETTER YENISEI OQOLD TURKIC LETTER ORKHON AROLD TURKIC" +
	" LETTER YENISEI AROLD TURKIC LETTER ORKHON AEROLD TURKIC LETTER ORKHON A" +
	"SOLD TURKIC LETTER ORKHON AESOLD TURKIC LETTER ORKHON ASHOLD TURKIC LETT" +
	"ER YENISEI ASHOLD TURKIC LETTER ORKHON ESHOLD TURKIC LETTER YENISEI ESHO" +
	"LD TURKIC LETTER ORKHON ATOLD TURKIC LETTER YENISEI ATOLD TURKIC LETTER " +
	"ORKHON AETOLD TURKIC LETTER YENISEI AETOLD TURKIC LETTER ORKHON OTOLD TU" +
	"RKIC LETTER ORKHON BASHOLD HUNGARIAN CAPITAL LETTER AOLD HUNGARIAN CAPIT" +
	"AL LETTER AAOLD HUNGARIAN CAPITAL LETTER EBOLD HUNGARIAN CAPITAL LETTER " +
	"AMBOLD HUNGARIAN CAPITAL LETTER ECOLD HUNGARIAN CAPITAL LETTER ENCOLD HU" +
	"NGARIAN CAPITAL LETTER ECSOLD HUNGARIAN CAPITAL LETTER EDOLD HUNGARIAN C" +
	"APITAL LETTER ANDOLD HUNGARIAN CAPITAL LETTER EOLD HUNGARIAN CAPITAL LET" +
	"TER CLOSE EOLD HUNGARIAN CAPITAL LETTER EEOLD HUNGARIAN CAPITAL LETTER E" +
	"FOLD HUNGARIAN CAPITAL LETTER EGOLD HUNGARIAN CAPITAL LETTER EGYOLD HUNG" +
	"ARIAN CAPITAL LETTER EHOLD HUNGARIAN CAPITAL LETTER IOLD HUNGARIAN CAPIT" +
	"AL LETTER IIOLD HUNGARIAN CAPITAL LETTER EJOLD HUNGARIAN CAPITAL LETTER " +
	"EKOLD HUNGARIAN CAPITAL LETTER AKOLD HUNGARIAN CAPITAL LETTER UNKOLD HUN" +
	"GARIAN CAPITAL LETTER ELOLD HUNGARIAN CAPITAL LETTER ELYOLD HUNGARIAN CA" +
	"PITAL LETTER EMOLD HUNGARIAN CAPITAL LETTER ENOLD HUNGARIAN CAPITAL LETT" +
	"ER ENYOLD HUNGARIAN CAPITAL LETTER OOLD HUNGARIAN CAPITAL LETTER OOOLD H" +
	"UNGARIAN CAPITAL LETTER NIKOLSBURG OEOLD HUNGARIAN CAPITAL LETTER RUDIME" +
	"NTA OEOLD HUNGARIAN CAPITAL LETTER OEEOLD HUNGARIAN CAPITAL LETTER EPOLD" +
	" HUNGARIAN CAPITAL LETTER EMPOLD HUNGARIAN CAPITAL LETTER EROLD HUNGARIA" +
	"N CAPITAL LETTER SHORT EROLD HUNGARIAN CAPITAL LETTER ESOLD HUNGARIAN CA" +
	"PITAL LETTER ESZOLD HUNGARIAN CAPITAL LETTER ETOLD HUNGARIAN CAPITAL LET" +
	"TER ENTOLD HUNGARIAN CAPITAL LETTER ETYOLD HUNGARIAN CAPITAL LETTER ECHO" +
	"LD HUNGARIAN CAPITAL LETTER UOLD HUNGARIAN CAPITAL LETTER UUOLD HUNGARIA" +
	"N CAPITAL LETTER NIKOLSBURG UEOLD HUNGARIAN CAPITAL LETTER RUDIMENTA UEO" +
	"LD HUNGARIAN CAPITAL LETTER EVOLD HUNGARIAN CAPITAL LETTER EZOLD HUNGARI" +
	"AN CAPITAL LETTER EZSOLD HUNGARIAN CAPITAL LETTER ENT-SHAPED SIGNOLD HUN" +
	"GARIAN CAPITAL LETTER USOLD HUNGARIAN SMALL LETTER AOLD HUNGARIAN SMALL " +
	"LETTER AAOLD HUNGARIAN SMALL LETTER EBOLD HUNGARIAN SMALL LETTER AMBOLD " +
	"HUNGARIAN SMALL LETTER ECOLD HUNGARIAN SMALL LETTER ENCOLD HUNGARIAN SMA" +
	"LL LETTER ECSOLD HUNGARIAN SMALL LETTER EDOLD HUNGARIAN SMALL LETTER AND" +
	"OLD HUNGARIAN SMALL LETTER EOLD HUNGARIAN SMALL LETTER CLOSE EOLD HUNGAR" +
	"IAN SMALL LETTER EEOLD HUNGARIAN SMALL LETTER EFOLD HUNGARIAN SMALL LETT" +
	"ER EGOLD HUNGARIAN SMALL LETTER EGYOLD HUNGARIAN SMALL LETTER EHOLD HUNG" +
	"ARIAN SMALL LETTER IOLD HUNGARIAN SMALL LETTER IIOLD HUNGARIAN SMALL LET" +
	"TER EJOLD HUNGARIAN SMALL LETTER EKOLD HUNGARIAN SMALL LETTER AKOLD HUNG" +
	"ARIAN SMALL LETTER UNKOLD HUNGARIAN SMALL LETTER ELOLD HUNGARIAN SMALL L" +
	"ETTER ELYOLD HUNGARIAN SMALL LETTER EMOLD HUNGARIAN SMALL LETTER ENOLD H" +
	"UNGARIAN SMALL LETTER ENYOLD HUNGARIAN SMALL LETTER OOLD HUNGARIAN SMALL" +
	" LETTER OOOLD HUNGARIAN SMALL LETTER NIKOLSBURG OEOLD HUNGARIAN SMALL LE" +
	"TTER RUDIMENTA OEOLD HUNGARIAN SMALL LETTER OEEOLD HUNGARIAN SMALL LETTE" +
	"R EPOLD HUNGARIAN SMALL LETTER EMPOLD HUNGARIAN SMALL LETTER EROLD HUNGA" +
	"RIAN SMALL LETTER SHORT EROLD HUNGARIAN SMALL LETTER ESOLD HUNGARIAN SMA" +
	"LL LETTER ESZOLD HUNGARIAN SMALL LETTER ETOLD HUNGARIAN SMALL LETTER ENT" +
	"OLD HUNGARIAN SMALL LETTER ETYOLD HUNGARIAN SMALL LETTER ECHOLD HUNGARIA" +
	"N SMALL LETTER UOLD HUNGARIAN SMALL LETTER UUOLD HUNGARIAN SMALL LETTER ") + ("" +
	"NIKOLSBURG UEOLD HUNGARIAN SMALL LETTER RUDIMENTA UEOLD HUNGARIAN SMALL " +
	"LETTER EVOLD HUNGARIAN SMALL LETTER EZOLD HUNGARIAN SMALL LETTER EZSOLD " +
	"HUNGARIAN SMALL LETTER ENT-SHAPED SIGNOLD HUNGARIAN SMALL LETTER USOLD H" +
	"UNGARIAN NUMBER ONEOLD HUNGARIAN NUMBER FIVEOLD HUNGARIAN NUMBER TENOLD " +
	"HUNGARIAN NUMBER FIFTYOLD HUNGARIAN NUMBER ONE HUNDREDOLD HUNGARIAN NUMB" +
	"ER ONE THOUSANDHANIFI ROHINGYA LETTER AHANIFI ROHINGYA LETTER BAHANIFI R" +
	"OHINGYA LETTER PAHANIFI ROHINGYA LETTER TAHANIFI ROHINGYA LETTER TTAHANI" +
	"FI ROHINGYA LETTER JAHANIFI ROHINGYA LETTER CAHANIFI ROHINGYA LETTER HAH" +
	"ANIFI ROHINGYA LETTER KHAHANIFI ROHINGYA LETTER FAHANIFI ROHINGYA LETTER" +
	" DAHANIFI ROHINGYA LETTER DDAHANIFI ROHINGYA LETTER RAHANIFI ROHINGYA LE" +
	"TTER RRAHANIFI ROHINGYA LETTER ZAHANIFI ROHINGYA LETTER SAHANIFI ROHINGY" +
	"A LETTER SHAHANIFI ROHINGYA LETTER KAHANIFI ROHINGYA LETTER GAHANIFI ROH" +
	"INGYA LETTER LAHANIFI ROHINGYA LETTER MAHANIFI ROHINGYA LETTER NAHANIFI " +
	"ROHINGYA LETTER WAHANIFI ROHINGYA LETTER KINNA WAHANIFI ROHINGYA LETTER " +
	"YAHANIFI ROHINGYA LETTER KINNA YAHANIFI ROHINGYA LETTER NGAHANIFI ROHING" +
	"YA LETTER NYAHANIFI ROHINGYA LETTER VAHANIFI ROHINGYA VOWEL AHANIFI ROHI" +
	"NGYA VOWEL IHANIFI ROHINGYA VOWEL UHANIFI ROHINGYA VOWEL EHANIFI ROHINGY" +
	"A VOWEL OHANIFI ROHINGYA MARK SAKINHANIFI ROHINGYA MARK NA KHONNAHANIFI " +
	"ROHINGYA SIGN HARBAHAYHANIFI ROHINGYA SIGN TAHALAHANIFI ROHINGYA SIGN TA" +
	"NAHANIFI ROHINGYA SIGN TASSIHANIFI ROHINGYA DIGIT ZEROHANIFI ROHINGYA DI" +
	"GIT ONEHANIFI ROHINGYA DIGIT TWOHANIFI ROHINGYA DIGIT THREEHANIFI ROHING" +
	"YA DIGIT FOURHANIFI ROHINGYA DIGIT FIVEHANIFI ROHINGYA DIGIT SIXHANIFI R" +
	"OHINGYA DIGIT SEVENHANIFI ROHINGYA DIGIT EIGHTHANIFI ROHINGYA DIGIT NINE" +
	"RUMI DIGIT ONERUMI DIGIT TWORUMI DIGIT THREERUMI DIGIT FOURRUMI DIGIT FI" +
	"VERUMI DIGIT SIXRUMI DIGIT SEVENRUMI DIGIT EIGHTRUMI DIGIT NINERUMI NUMB" +
	"ER TENRUMI NUMBER TWENTYRUMI NUMBER THIRTYRUMI NUMBER FORTYRUMI NUMBER F" +
	"IFTYRUMI NUMBER SIXTYRUMI NUMBER SEVENTYRUMI NUMBER EIGHTYRUMI NUMBER NI" +
	"NETYRUMI NUMBER ONE HUNDREDRUMI NUMBER TWO HUNDREDRUMI NUMBER THREE HUND" +
	"REDRUMI NUMBER FOUR HUNDREDRUMI NUMBER FIVE HUNDREDRUMI NUMBER SIX HUNDR" +
	"EDRUMI NUMBER SEVEN HUNDREDRUMI NUMBER EIGHT HUNDREDRUMI NUMBER NINE HUN" +
	"DREDRUMI FRACTION ONE HALFRUMI FRACTION ONE QUARTERRUMI FRACTION ONE THI" +
	"RDRUMI FRACTION TWO THIRDSOLD SOGDIAN LETTER ALEPHOLD SOGDIAN LETTER FIN" +
	"AL ALEPHOLD SOGDIAN LETTER BETHOLD SOGDIAN LETTER FINAL BETHOLD SOGDIAN " +
	"LETTER GIMELOLD SOGDIAN LETTER HEOLD SOGDIAN LETTER FINAL HEOLD SOGDIAN " +
	"LETTER WAWOLD SOGDIAN LETTER ZAYINOLD SOGDIAN LETTER HETHOLD SOGDIAN LET" +
	"TER YODHOLD SOGDIAN LETTER KAPHOLD SOGDIAN LETTER LAMEDHOLD SOGDIAN LETT" +
	"ER MEMOLD SOGDIAN LETTER NUNOLD SOGDIAN LETTER FINAL NUNOLD SOGDIAN LETT" +
	"ER FINAL NUN WITH VERTICAL TAILOLD SOGDIAN LETTER SAMEKHOLD SOGDIAN LETT" +
	"ER AYINOLD SOGDIAN LETTER ALTERNATE AYINOLD SOGDIAN LETTER PEOLD SOGDIAN" +
	" LETTER SADHEOLD SOGDIAN LETTER FINAL SADHEOLD SOGDIAN LETTER FINAL SADH" +
	"E WITH VERTICAL TAILOLD SOGDIAN LETTER RESH-AYIN-DALETHOLD SOGDIAN LETTE" +
	"R SHINOLD SOGDIAN LETTER TAWOLD SOGDIAN LETTER FINAL TAWOLD SOGDIAN LETT" +
	"ER FINAL TAW WITH VERTICAL TAILOLD SOGDIAN NUMBER ONEOLD SOGDIAN NUMBER " +
	"TWOOLD SOGDIAN NUMBER THREEOLD SOGDIAN NUMBER FOUROLD SOGDIAN NUMBER FIV" +
	"EOLD SOGDIAN NUMBER TENOLD SOGDIAN NUMBER TWENTYOLD SOGDIAN NUMBER THIRT" +
	"YOLD SOGDIAN NUMBER ONE HUNDREDOLD SOGDIAN FRACTION ONE HALFOLD SOGDIAN " +
	"LIGATURE AYIN-DALETHSOGDIAN LETTER ALEPHSOGDIAN LETTER BETHSOGDIAN LETTE" +
	"R GIMELSOGDIAN LETTER HESOGDIAN LETTER WAWSOGDIAN LETTER ZAYINSOGDIAN LE" +
	"TTER HETHSOGDIAN LETTER YODHSOGDIAN LETTER KAPHSOGDIAN LETTER LAMEDHSOGD" +
	"IAN LETTER MEMSOGDIAN LETTER NUNSOGDIAN LETTER SAMEKHSOGDIAN LETTER AYIN" +
	"SOGDIAN LETTER PESOGDIAN LETTER SADHESOGDIAN LETTER RESH-AYINSOGDIAN LET" +
	"TER SHINSOGDIAN LETTER TAWSOGDIAN LETTER FETHSOGDIAN LETTER LESHSOGDIAN " +
	"INDEPENDENT SHINSOGDIAN COMBINING DOT BELOWSOGDIAN COMBINING TWO DOTS BE" +
	"LOWSOGDIAN COMBINING DOT ABOVESOGDIAN COMBINING TWO DOTS ABOVESOGDIAN CO" +
	"MBINING CURVE ABOVESOGDIAN COMBINING CURVE BELOWSOGDIAN COMBINING HOOK A" +
	"BOVESOGDIAN COMBINING HOOK BELOWSOGDIAN COMBINING LONG HOOK BELOWSOGDIAN" +
	" COMBINING RESH BELOWSOGDIAN COMBINING STROKE BELOWSOGDIAN NUMBER ONESOG" +
	"DIAN NUMBER TENSOGDIAN NUMBER TWENTYSOGDIAN NUMBER ONE HUNDREDSOGDIAN PU" +
	"NCTUATION TWO VERTICAL BARSSOGDIAN PUNCTUATION TWO VERTICAL BARS WITH DO" +
	"TSSOGDIAN PUNCTUATION CIRCLE WITH DOTSOGDIAN PUNCTUATION TWO CIRCLES WIT" +
	"H DOTSSOGDIAN PUNCTUATION HALF CIRCLE WITH DOTBRAHMI SIGN CANDRABINDUBRA" +
	"HMI SIGN ANUSVARABRAHMI SIGN VISARGABRAHMI SIGN JIHVAMULIYABRAHMI SIGN U" +
	"PADHMANIYABRAHMI LETTER ABRAHMI LETTER AABRAHMI LETTER IBRAHMI LETTER II" +
	"BRAHMI LETTER UBRAHMI LETTER UUBRAHMI LETTER VOCALIC RBRAHMI LETTER VOCA") + ("" +
	"LIC RRBRAHMI LETTER VOCALIC LBRAHMI LETTER VOCALIC LLBRAHMI LETTER EBRAH" +
	"MI LETTER AIBRAHMI LETTER OBRAHMI LETTER AUBRAHMI LETTER KABRAHMI LETTER" +
	" KHABRAHMI LETTER GABRAHMI LETTER GHABRAHMI LETTER NGABRAHMI LETTER CABR" +
	"AHMI LETTER CHABRAHMI LETTER JABRAHMI LETTER JHABRAHMI LETTER NYABRAHMI " +
	"LETTER TTABRAHMI LETTER TTHABRAHMI LETTER DDABRAHMI LETTER DDHABRAHMI LE" +
	"TTER NNABRAHMI LETTER TABRAHMI LETTER THABRAHMI LETTER DABRAHMI LETTER D" +
	"HABRAHMI LETTER NABRAHMI LETTER PABRAHMI LETTER PHABRAHMI LETTER BABRAHM" +
	"I LETTER BHABRAHMI LETTER MABRAHMI LETTER YABRAHMI LETTER RABRAHMI LETTE" +
	"R LABRAHMI LETTER VABRAHMI LETTER SHABRAHMI LETTER SSABRAHMI LETTER SABR" +
	"AHMI LETTER HABRAHMI LETTER LLABRAHMI LETTER OLD TAMIL LLLABRAHMI LETTER" +
	" OLD TAMIL RRABRAHMI LETTER OLD TAMIL NNNABRAHMI VOWEL SIGN AABRAHMI VOW" +
	"EL SIGN BHATTIPROLU AABRAHMI VOWEL SIGN IBRAHMI VOWEL SIGN IIBRAHMI VOWE" +
	"L SIGN UBRAHMI VOWEL SIGN UUBRAHMI VOWEL SIGN VOCALIC RBRAHMI VOWEL SIGN" +
	" VOCALIC RRBRAHMI VOWEL SIGN VOCALIC LBRAHMI VOWEL SIGN VOCALIC LLBRAHMI" +
	" VOWEL SIGN EBRAHMI VOWEL SIGN AIBRAHMI VOWEL SIGN OBRAHMI VOWEL SIGN AU" +
	"BRAHMI VIRAMABRAHMI DANDABRAHMI DOUBLE DANDABRAHMI PUNCTUATION DOTBRAHMI" +
	" PUNCTUATION DOUBLE DOTBRAHMI PUNCTUATION LINEBRAHMI PUNCTUATION CRESCEN" +
	"T BARBRAHMI PUNCTUATION LOTUSBRAHMI NUMBER ONEBRAHMI NUMBER TWOBRAHMI NU" +
	"MBER THREEBRAHMI NUMBER FOURBRAHMI NUMBER FIVEBRAHMI NUMBER SIXBRAHMI NU" +
	"MBER SEVENBRAHMI NUMBER EIGHTBRAHMI NUMBER NINEBRAHMI NUMBER TENBRAHMI N" +
	"UMBER TWENTYBRAHMI NUMBER THIRTYBRAHMI NUMBER FORTYBRAHMI NUMBER FIFTYBR" +
	"AHMI NUMBER SIXTYBRAHMI NUMBER SEVENTYBRAHMI NUMBER EIGHTYBRAHMI NUMBER " +
	"NINETYBRAHMI NUMBER ONE HUNDREDBRAHMI NUMBER ONE THOUSANDBRAHMI DIGIT ZE" +
	"ROBRAHMI DIGIT ONEBRAHMI DIGIT TWOBRAHMI DIGIT THREEBRAHMI DIGIT FOURBRA" +
	"HMI DIGIT FIVEBRAHMI DIGIT SIXBRAHMI DIGIT SEVENBRAHMI DIGIT EIGHTBRAHMI" +
	" DIGIT NINEBRAHMI NUMBER JOINERKAITHI SIGN CANDRABINDUKAITHI SIGN ANUSVA" +
	"RAKAITHI SIGN VISARGAKAITHI LETTER AKAITHI LETTER AAKAITHI LETTER IKAITH" +
	"I LETTER IIKAITHI LETTER UKAITHI LETTER UUKAITHI LETTER EKAITHI LETTER A" +
	"IKAITHI LETTER OKAITHI LETTER AUKAITHI LETTER KAKAITHI LETTER KHAKAITHI " +
	"LETTER GAKAITHI LETTER GHAKAITHI LETTER NGAKAITHI LETTER CAKAITHI LETTER" +
	" CHAKAITHI LETTER JAKAITHI LETTER JHAKAITHI LETTER NYAKAITHI LETTER TTAK" +
	"AITHI LETTER TTHAKAITHI LETTER DDAKAITHI LETTER DDDHAKAITHI LETTER DDHAK" +
	"AITHI LETTER RHAKAITHI LETTER NNAKAITHI LETTER TAKAITHI LETTER THAKAITHI" +
	" LETTER DAKAITHI LETTER DHAKAITHI LETTER NAKAITHI LETTER PAKAITHI LETTER" +
	" PHAKAITHI LETTER BAKAITHI LETTER BHAKAITHI LETTER MAKAITHI LETTER YAKAI" +
	"THI LETTER RAKAITHI LETTER LAKAITHI LETTER VAKAITHI LETTER SHAKAITHI LET" +
	"TER SSAKAITHI LETTER SAKAITHI LETTER HAKAITHI VOWEL SIGN AAKAITHI VOWEL " +
	"SIGN IKAITHI VOWEL SIGN IIKAITHI VOWEL SIGN UKAITHI VOWEL SIGN UUKAITHI " +
	"VOWEL SIGN EKAITHI VOWEL SIGN AIKAITHI VOWEL SIGN OKAITHI VOWEL SIGN AUK" +
	"AITHI SIGN VIRAMAKAITHI SIGN NUKTAKAITHI ABBREVIATION SIGNKAITHI ENUMERA" +
	"TION SIGNKAITHI NUMBER SIGNKAITHI SECTION MARKKAITHI DOUBLE SECTION MARK" +
	"KAITHI DANDAKAITHI DOUBLE DANDAKAITHI NUMBER SIGN ABOVESORA SOMPENG LETT" +
	"ER SAHSORA SOMPENG LETTER TAHSORA SOMPENG LETTER BAHSORA SOMPENG LETTER " +
	"CAHSORA SOMPENG LETTER DAHSORA SOMPENG LETTER GAHSORA SOMPENG LETTER MAH" +
	"SORA SOMPENG LETTER NGAHSORA SOMPENG LETTER LAHSORA SOMPENG LETTER NAHSO" +
	"RA SOMPENG LETTER VAHSORA SOMPENG LETTER PAHSORA SOMPENG LETTER YAHSORA " +
	"SOMPENG LETTER RAHSORA SOMPENG LETTER HAHSORA SOMPENG LETTER KAHSORA SOM" +
	"PENG LETTER JAHSORA SOMPENG LETTER NYAHSORA SOMPENG LETTER AHSORA SOMPEN" +
	"G LETTER EEHSORA SOMPENG LETTER IHSORA SOMPENG LETTER UHSORA SOMPENG LET" +
	"TER OHSORA SOMPENG LETTER EHSORA SOMPENG LETTER MAESORA SOMPENG DIGIT ZE" +
	"ROSORA SOMPENG DIGIT ONESORA SOMPENG DIGIT TWOSORA SOMPENG DIGIT THREESO" +
	"RA SOMPENG DIGIT FOURSORA SOMPENG DIGIT FIVESORA SOMPENG DIGIT SIXSORA S" +
	"OMPENG DIGIT SEVENSORA SOMPENG DIGIT EIGHTSORA SOMPENG DIGIT NINECHAKMA " +
	"SIGN CANDRABINDUCHAKMA SIGN ANUSVARACHAKMA SIGN VISARGACHAKMA LETTER AAC" +
	"HAKMA LETTER ICHAKMA LETTER UCHAKMA LETTER ECHAKMA LETTER KAACHAKMA LETT" +
	"ER KHAACHAKMA LETTER GAACHAKMA LETTER GHAACHAKMA LETTER NGAACHAKMA LETTE" +
	"R CAACHAKMA LETTER CHAACHAKMA LETTER JAACHAKMA LETTER JHAACHAKMA LETTER " +
	"NYAACHAKMA LETTER TTAACHAKMA LETTER TTHAACHAKMA LETTER DDAACHAKMA LETTER" +
	" DDHAACHAKMA LETTER NNAACHAKMA LETTER TAACHAKMA LETTER THAACHAKMA LETTER" +
	" DAACHAKMA LETTER DHAACHAKMA LETTER NAACHAKMA LETTER PAACHAKMA LETTER PH" +
	"AACHAKMA LETTER BAACHAKMA LETTER BHAACHAKMA LETTER MAACHAKMA LETTER YYAA" +
	"CHAKMA LETTER YAACHAKMA LETTER RAACHAKMA LETTER LAACHAKMA LETTER WAACHAK" +
	"MA LETTER SAACHAKMA LETTER HAACHAKMA VOWEL SIGN ACHAKMA VOWEL SIGN ICHAK" +
	"MA VOWEL SIGN IICHAKMA VOWEL SIGN UCHAKMA VOWEL SIGN UUCHAKMA VOWEL SIGN") + ("" +
	" ECHAKMA VOWEL SIGN AICHAKMA VOWEL SIGN OCHAKMA VOWEL SIGN AUCHAKMA VOWE" +
	"L SIGN OICHAKMA O MARKCHAKMA AU MARKCHAKMA VIRAMACHAKMA MAAYYAACHAKMA DI" +
	"GIT ZEROCHAKMA DIGIT ONECHAKMA DIGIT TWOCHAKMA DIGIT THREECHAKMA DIGIT F" +
	"OURCHAKMA DIGIT FIVECHAKMA DIGIT SIXCHAKMA DIGIT SEVENCHAKMA DIGIT EIGHT" +
	"CHAKMA DIGIT NINECHAKMA SECTION MARKCHAKMA DANDACHAKMA DOUBLE DANDACHAKM" +
	"A QUESTION MARKCHAKMA LETTER LHAACHAKMA VOWEL SIGN AACHAKMA VOWEL SIGN E" +
	"IMAHAJANI LETTER AMAHAJANI LETTER IMAHAJANI LETTER UMAHAJANI LETTER EMAH" +
	"AJANI LETTER OMAHAJANI LETTER KAMAHAJANI LETTER KHAMAHAJANI LETTER GAMAH" +
	"AJANI LETTER GHAMAHAJANI LETTER CAMAHAJANI LETTER CHAMAHAJANI LETTER JAM" +
	"AHAJANI LETTER JHAMAHAJANI LETTER NYAMAHAJANI LETTER TTAMAHAJANI LETTER " +
	"TTHAMAHAJANI LETTER DDAMAHAJANI LETTER DDHAMAHAJANI LETTER NNAMAHAJANI L" +
	"ETTER TAMAHAJANI LETTER THAMAHAJANI LETTER DAMAHAJANI LETTER DHAMAHAJANI" +
	" LETTER NAMAHAJANI LETTER PAMAHAJANI LETTER PHAMAHAJANI LETTER BAMAHAJAN" +
	"I LETTER BHAMAHAJANI LETTER MAMAHAJANI LETTER RAMAHAJANI LETTER LAMAHAJA" +
	"NI LETTER VAMAHAJANI LETTER SAMAHAJANI LETTER HAMAHAJANI LETTER RRAMAHAJ" +
	"ANI SIGN NUKTAMAHAJANI ABBREVIATION SIGNMAHAJANI SECTION MARKMAHAJANI LI" +
	"GATURE SHRISHARADA SIGN CANDRABINDUSHARADA SIGN ANUSVARASHARADA SIGN VIS" +
	"ARGASHARADA LETTER ASHARADA LETTER AASHARADA LETTER ISHARADA LETTER IISH" +
	"ARADA LETTER USHARADA LETTER UUSHARADA LETTER VOCALIC RSHARADA LETTER VO" +
	"CALIC RRSHARADA LETTER VOCALIC LSHARADA LETTER VOCALIC LLSHARADA LETTER " +
	"ESHARADA LETTER AISHARADA LETTER OSHARADA LETTER AUSHARADA LETTER KASHAR" +
	"ADA LETTER KHASHARADA LETTER GASHARADA LETTER GHASHARADA LETTER NGASHARA" +
	"DA LETTER CASHARADA LETTER CHASHARADA LETTER JASHARADA LETTER JHASHARADA" +
	" LETTER NYASHARADA LETTER TTASHARADA LETTER TTHASHARADA LETTER DDASHARAD" +
	"A LETTER DDHASHARADA LETTER NNASHARADA LETTER TASHARADA LETTER THASHARAD" +
	"A LETTER DASHARADA LETTER DHASHARADA LETTER NASHARADA LETTER PASHARADA L" +
	"ETTER PHASHARADA LETTER BASHARADA LETTER BHASHARADA LETTER MASHARADA LET" +
	"TER YASHARADA LETTER RASHARADA LETTER LASHARADA LETTER LLASHARADA LETTER" +
	" VASHARADA LETTER SHASHARADA LETTER SSASHARADA LETTER SASHARADA LETTER H" +
	"ASHARADA VOWEL SIGN AASHARADA VOWEL SIGN ISHARADA VOWEL SIGN IISHARADA V" +
	"OWEL SIGN USHARADA VOWEL SIGN UUSHARADA VOWEL SIGN VOCALIC RSHARADA VOWE" +
	"L SIGN VOCALIC RRSHARADA VOWEL SIGN VOCALIC LSHARADA VOWEL SIGN VOCALIC " +
	"LLSHARADA VOWEL SIGN ESHARADA VOWEL SIGN AISHARADA VOWEL SIGN OSHARADA V" +
	"OWEL SIGN AUSHARADA SIGN VIRAMASHARADA SIGN AVAGRAHASHARADA SIGN JIHVAMU" +
	"LIYASHARADA SIGN UPADHMANIYASHARADA OMSHARADA DANDASHARADA DOUBLE DANDAS" +
	"HARADA ABBREVIATION SIGNSHARADA SEPARATORSHARADA SANDHI MARKSHARADA SIGN" +
	" NUKTASHARADA VOWEL MODIFIER MARKSHARADA EXTRA SHORT VOWEL MARKSHARADA S" +
	"UTRA MARKSHARADA DIGIT ZEROSHARADA DIGIT ONESHARADA DIGIT TWOSHARADA DIG" +
	"IT THREESHARADA DIGIT FOURSHARADA DIGIT FIVESHARADA DIGIT SIXSHARADA DIG" +
	"IT SEVENSHARADA DIGIT EIGHTSHARADA DIGIT NINESHARADA EKAMSHARADA SIGN SI" +
	"DDHAMSHARADA HEADSTROKESHARADA CONTINUATION SIGNSHARADA SECTION MARK-1SH" +
	"ARADA SECTION MARK-2SINHALA ARCHAIC DIGIT ONESINHALA ARCHAIC DIGIT TWOSI" +
	"NHALA ARCHAIC DIGIT THREESINHALA ARCHAIC DIGIT FOURSINHALA ARCHAIC DIGIT" +
	" FIVESINHALA ARCHAIC DIGIT SIXSINHALA ARCHAIC DIGIT SEVENSINHALA ARCHAIC" +
	" DIGIT EIGHTSINHALA ARCHAIC DIGIT NINESINHALA ARCHAIC NUMBER TENSINHALA " +
	"ARCHAIC NUMBER TWENTYSINHALA ARCHAIC NUMBER THIRTYSINHALA ARCHAIC NUMBER" +
	" FORTYSINHALA ARCHAIC NUMBER FIFTYSINHALA ARCHAIC NUMBER SIXTYSINHALA AR" +
	"CHAIC NUMBER SEVENTYSINHALA ARCHAIC NUMBER EIGHTYSINHALA ARCHAIC NUMBER " +
	"NINETYSINHALA ARCHAIC NUMBER ONE HUNDREDSINHALA ARCHAIC NUMBER ONE THOUS" +
	"ANDKHOJKI LETTER AKHOJKI LETTER AAKHOJKI LETTER IKHOJKI LETTER UKHOJKI L" +
	"ETTER EKHOJKI LETTER AIKHOJKI LETTER OKHOJKI LETTER AUKHOJKI LETTER KAKH" +
	"OJKI LETTER KHAKHOJKI LETTER GAKHOJKI LETTER GGAKHOJKI LETTER GHAKHOJKI " +
	"LETTER NGAKHOJKI LETTER CAKHOJKI LETTER CHAKHOJKI LETTER JAKHOJKI LETTER" +
	" JJAKHOJKI LETTER NYAKHOJKI LETTER TTAKHOJKI LETTER TTHAKHOJKI LETTER DD" +
	"AKHOJKI LETTER DDHAKHOJKI LETTER NNAKHOJKI LETTER TAKHOJKI LETTER THAKHO" +
	"JKI LETTER DAKHOJKI LETTER DDDAKHOJKI LETTER DHAKHOJKI LETTER NAKHOJKI L" +
	"ETTER PAKHOJKI LETTER PHAKHOJKI LETTER BAKHOJKI LETTER BBAKHOJKI LETTER " +
	"BHAKHOJKI LETTER MAKHOJKI LETTER YAKHOJKI LETTER RAKHOJKI LETTER LAKHOJK" +
	"I LETTER VAKHOJKI LETTER SAKHOJKI LETTER HAKHOJKI LETTER LLAKHOJKI VOWEL" +
	" SIGN AAKHOJKI VOWEL SIGN IKHOJKI VOWEL SIGN IIKHOJKI VOWEL SIGN UKHOJKI" +
	" VOWEL SIGN EKHOJKI VOWEL SIGN AIKHOJKI VOWEL SIGN OKHOJKI VOWEL SIGN AU" +
	"KHOJKI SIGN ANUSVARAKHOJKI SIGN VIRAMAKHOJKI SIGN NUKTAKHOJKI SIGN SHADD" +
	"AKHOJKI DANDAKHOJKI DOUBLE DANDAKHOJKI WORD SEPARATORKHOJKI SECTION MARK" +
	"KHOJKI DOUBLE SECTION MARKKHOJKI ABBREVIATION SIGNKHOJKI SIGN SUKUNMULTA") + ("" +
	"NI LETTER AMULTANI LETTER IMULTANI LETTER UMULTANI LETTER EMULTANI LETTE" +
	"R KAMULTANI LETTER KHAMULTANI LETTER GAMULTANI LETTER GHAMULTANI LETTER " +
	"CAMULTANI LETTER CHAMULTANI LETTER JAMULTANI LETTER JJAMULTANI LETTER NY" +
	"AMULTANI LETTER TTAMULTANI LETTER TTHAMULTANI LETTER DDAMULTANI LETTER D" +
	"DDAMULTANI LETTER DDHAMULTANI LETTER NNAMULTANI LETTER TAMULTANI LETTER " +
	"THAMULTANI LETTER DAMULTANI LETTER DHAMULTANI LETTER NAMULTANI LETTER PA" +
	"MULTANI LETTER PHAMULTANI LETTER BAMULTANI LETTER BHAMULTANI LETTER MAMU" +
	"LTANI LETTER YAMULTANI LETTER RAMULTANI LETTER LAMULTANI LETTER VAMULTAN" +
	"I LETTER SAMULTANI LETTER HAMULTANI LETTER RRAMULTANI LETTER RHAMULTANI " +
	"SECTION MARKKHUDAWADI LETTER AKHUDAWADI LETTER AAKHUDAWADI LETTER IKHUDA" +
	"WADI LETTER IIKHUDAWADI LETTER UKHUDAWADI LETTER UUKHUDAWADI LETTER EKHU" +
	"DAWADI LETTER AIKHUDAWADI LETTER OKHUDAWADI LETTER AUKHUDAWADI LETTER KA" +
	"KHUDAWADI LETTER KHAKHUDAWADI LETTER GAKHUDAWADI LETTER GGAKHUDAWADI LET" +
	"TER GHAKHUDAWADI LETTER NGAKHUDAWADI LETTER CAKHUDAWADI LETTER CHAKHUDAW" +
	"ADI LETTER JAKHUDAWADI LETTER JJAKHUDAWADI LETTER JHAKHUDAWADI LETTER NY" +
	"AKHUDAWADI LETTER TTAKHUDAWADI LETTER TTHAKHUDAWADI LETTER DDAKHUDAWADI " +
	"LETTER DDDAKHUDAWADI LETTER RRAKHUDAWADI LETTER DDHAKHUDAWADI LETTER NNA" +
	"KHUDAWADI LETTER TAKHUDAWADI LETTER THAKHUDAWADI LETTER DAKHUDAWADI LETT" +
	"ER DHAKHUDAWADI LETTER NAKHUDAWADI LETTER PAKHUDAWADI LETTER PHAKHUDAWAD" +
	"I LETTER BAKHUDAWADI LETTER BBAKHUDAWADI LETTER BHAKHUDAWADI LETTER MAKH" +
	"UDAWADI LETTER YAKHUDAWADI LETTER RAKHUDAWADI LETTER LAKHUDAWADI LETTER " +
	"VAKHUDAWADI LETTER SHAKHUDAWADI LETTER SAKHUDAWADI LETTER HAKHUDAWADI SI" +
	"GN ANUSVARAKHUDAWADI VOWEL SIGN AAKHUDAWADI VOWEL SIGN IKHUDAWADI VOWEL " +
	"SIGN IIKHUDAWADI VOWEL SIGN UKHUDAWADI VOWEL SIGN UUKHUDAWADI VOWEL SIGN" +
	" EKHUDAWADI VOWEL SIGN AIKHUDAWADI VOWEL SIGN OKHUDAWADI VOWEL SIGN AUKH" +
	"UDAWADI SIGN NUKTAKHUDAWADI SIGN VIRAMAKHUDAWADI DIGIT ZEROKHUDAWADI DIG" +
	"IT ONEKHUDAWADI DIGIT TWOKHUDAWADI DIGIT THREEKHUDAWADI DIGIT FOURKHUDAW" +
	"ADI DIGIT FIVEKHUDAWADI DIGIT SIXKHUDAWADI DIGIT SEVENKHUDAWADI DIGIT EI" +
	"GHTKHUDAWADI DIGIT NINEGRANTHA SIGN COMBINING ANUSVARA ABOVEGRANTHA SIGN" +
	" CANDRABINDUGRANTHA SIGN ANUSVARAGRANTHA SIGN VISARGAGRANTHA LETTER AGRA" +
	"NTHA LETTER AAGRANTHA LETTER IGRANTHA LETTER IIGRANTHA LETTER UGRANTHA L" +
	"ETTER UUGRANTHA LETTER VOCALIC RGRANTHA LETTER VOCALIC LGRANTHA LETTER E" +
	"EGRANTHA LETTER AIGRANTHA LETTER OOGRANTHA LETTER AUGRANTHA LETTER KAGRA" +
	"NTHA LETTER KHAGRANTHA LETTER GAGRANTHA LETTER GHAGRANTHA LETTER NGAGRAN" +
	"THA LETTER CAGRANTHA LETTER CHAGRANTHA LETTER JAGRANTHA LETTER JHAGRANTH" +
	"A LETTER NYAGRANTHA LETTER TTAGRANTHA LETTER TTHAGRANTHA LETTER DDAGRANT" +
	"HA LETTER DDHAGRANTHA LETTER NNAGRANTHA LETTER TAGRANTHA LETTER THAGRANT" +
	"HA LETTER DAGRANTHA LETTER DHAGRANTHA LETTER NAGRANTHA LETTER PAGRANTHA " +
	"LETTER PHAGRANTHA LETTER BAGRANTHA LETTER BHAGRANTHA LETTER MAGRANTHA LE" +
	"TTER YAGRANTHA LETTER RAGRANTHA LETTER LAGRANTHA LETTER LLAGRANTHA LETTE" +
	"R VAGRANTHA LETTER SHAGRANTHA LETTER SSAGRANTHA LETTER SAGRANTHA LETTER " +
	"HACOMBINING BINDU BELOWGRANTHA SIGN NUKTAGRANTHA SIGN AVAGRAHAGRANTHA VO" +
	"WEL SIGN AAGRANTHA VOWEL SIGN IGRANTHA VOWEL SIGN IIGRANTHA VOWEL SIGN U" +
	"GRANTHA VOWEL SIGN UUGRANTHA VOWEL SIGN VOCALIC RGRANTHA VOWEL SIGN VOCA" +
	"LIC RRGRANTHA VOWEL SIGN EEGRANTHA VOWEL SIGN AIGRANTHA VOWEL SIGN OOGRA" +
	"NTHA VOWEL SIGN AUGRANTHA SIGN VIRAMAGRANTHA OMGRANTHA AU LENGTH MARKGRA" +
	"NTHA SIGN PLUTAGRANTHA LETTER VEDIC ANUSVARAGRANTHA LETTER VEDIC DOUBLE " +
	"ANUSVARAGRANTHA LETTER VOCALIC RRGRANTHA LETTER VOCALIC LLGRANTHA VOWEL " +
	"SIGN VOCALIC LGRANTHA VOWEL SIGN VOCALIC LLCOMBINING GRANTHA DIGIT ZEROC" +
	"OMBINING GRANTHA DIGIT ONECOMBINING GRANTHA DIGIT TWOCOMBINING GRANTHA D" +
	"IGIT THREECOMBINING GRANTHA DIGIT FOURCOMBINING GRANTHA DIGIT FIVECOMBIN" +
	"ING GRANTHA DIGIT SIXCOMBINING GRANTHA LETTER ACOMBINING GRANTHA LETTER " +
	"KACOMBINING GRANTHA LETTER NACOMBINING GRANTHA LETTER VICOMBINING GRANTH" +
	"A LETTER PANEWA LETTER ANEWA LETTER AANEWA LETTER INEWA LETTER IINEWA LE" +
	"TTER UNEWA LETTER UUNEWA LETTER VOCALIC RNEWA LETTER VOCALIC RRNEWA LETT" +
	"ER VOCALIC LNEWA LETTER VOCALIC LLNEWA LETTER ENEWA LETTER AINEWA LETTER" +
	" ONEWA LETTER AUNEWA LETTER KANEWA LETTER KHANEWA LETTER GANEWA LETTER G" +
	"HANEWA LETTER NGANEWA LETTER NGHANEWA LETTER CANEWA LETTER CHANEWA LETTE" +
	"R JANEWA LETTER JHANEWA LETTER NYANEWA LETTER NYHANEWA LETTER TTANEWA LE" +
	"TTER TTHANEWA LETTER DDANEWA LETTER DDHANEWA LETTER NNANEWA LETTER TANEW" +
	"A LETTER THANEWA LETTER DANEWA LETTER DHANEWA LETTER NANEWA LETTER NHANE" +
	"WA LETTER PANEWA LETTER PHANEWA LETTER BANEWA LETTER BHANEWA LETTER MANE" +
	"WA LETTER MHANEWA LETTER YANEWA LETTER RANEWA LETTER RHANEWA LETTER LANE" +
	"WA LETTER LHANEWA LETTER WANEWA LETTER SHANEWA LETTER SSANEWA LETTER SAN") + ("" +
	"EWA LETTER HANEWA VOWEL SIGN AANEWA VOWEL SIGN INEWA VOWEL SIGN IINEWA V" +
	"OWEL SIGN UNEWA VOWEL SIGN UUNEWA VOWEL SIGN VOCALIC RNEWA VOWEL SIGN VO" +
	"CALIC RRNEWA VOWEL SIGN VOCALIC LNEWA VOWEL SIGN VOCALIC LLNEWA VOWEL SI" +
	"GN ENEWA VOWEL SIGN AINEWA VOWEL SIGN ONEWA VOWEL SIGN AUNEWA SIGN VIRAM" +
	"ANEWA SIGN CANDRABINDUNEWA SIGN ANUSVARANEWA SIGN VISARGANEWA SIGN NUKTA" +
	"NEWA SIGN AVAGRAHANEWA SIGN FINAL ANUSVARANEWA OMNEWA SIDDHINEWA DANDANE" +
	"WA DOUBLE DANDANEWA COMMANEWA GAP FILLERNEWA ABBREVIATION SIGNNEWA DIGIT" +
	" ZERONEWA DIGIT ONENEWA DIGIT TWONEWA DIGIT THREENEWA DIGIT FOURNEWA DIG" +
	"IT FIVENEWA DIGIT SIXNEWA DIGIT SEVENNEWA DIGIT EIGHTNEWA DIGIT NINENEWA" +
	" PLACEHOLDER MARKNEWA INSERTION SIGNNEWA SANDHI MARKTIRHUTA ANJITIRHUTA " +
	"LETTER ATIRHUTA LETTER AATIRHUTA LETTER ITIRHUTA LETTER IITIRHUTA LETTER" +
	" UTIRHUTA LETTER UUTIRHUTA LETTER VOCALIC RTIRHUTA LETTER VOCALIC RRTIRH" +
	"UTA LETTER VOCALIC LTIRHUTA LETTER VOCALIC LLTIRHUTA LETTER ETIRHUTA LET" +
	"TER AITIRHUTA LETTER OTIRHUTA LETTER AUTIRHUTA LETTER KATIRHUTA LETTER K" +
	"HATIRHUTA LETTER GATIRHUTA LETTER GHATIRHUTA LETTER NGATIRHUTA LETTER CA" +
	"TIRHUTA LETTER CHATIRHUTA LETTER JATIRHUTA LETTER JHATIRHUTA LETTER NYAT" +
	"IRHUTA LETTER TTATIRHUTA LETTER TTHATIRHUTA LETTER DDATIRHUTA LETTER DDH" +
	"ATIRHUTA LETTER NNATIRHUTA LETTER TATIRHUTA LETTER THATIRHUTA LETTER DAT" +
	"IRHUTA LETTER DHATIRHUTA LETTER NATIRHUTA LETTER PATIRHUTA LETTER PHATIR" +
	"HUTA LETTER BATIRHUTA LETTER BHATIRHUTA LETTER MATIRHUTA LETTER YATIRHUT" +
	"A LETTER RATIRHUTA LETTER LATIRHUTA LETTER VATIRHUTA LETTER SHATIRHUTA L" +
	"ETTER SSATIRHUTA LETTER SATIRHUTA LETTER HATIRHUTA VOWEL SIGN AATIRHUTA " +
	"VOWEL SIGN ITIRHUTA VOWEL SIGN IITIRHUTA VOWEL SIGN UTIRHUTA VOWEL SIGN " +
	"UUTIRHUTA VOWEL SIGN VOCALIC RTIRHUTA VOWEL SIGN VOCALIC RRTIRHUTA VOWEL" +
	" SIGN VOCALIC LTIRHUTA VOWEL SIGN VOCALIC LLTIRHUTA VOWEL SIGN ETIRHUTA " +
	"VOWEL SIGN SHORT ETIRHUTA VOWEL SIGN AITIRHUTA VOWEL SIGN OTIRHUTA VOWEL" +
	" SIGN SHORT OTIRHUTA VOWEL SIGN AUTIRHUTA SIGN CANDRABINDUTIRHUTA SIGN A" +
	"NUSVARATIRHUTA SIGN VISARGATIRHUTA SIGN VIRAMATIRHUTA SIGN NUKTATIRHUTA " +
	"SIGN AVAGRAHATIRHUTA GVANGTIRHUTA ABBREVIATION SIGNTIRHUTA OMTIRHUTA DIG" +
	"IT ZEROTIRHUTA DIGIT ONETIRHUTA DIGIT TWOTIRHUTA DIGIT THREETIRHUTA DIGI" +
	"T FOURTIRHUTA DIGIT FIVETIRHUTA DIGIT SIXTIRHUTA DIGIT SEVENTIRHUTA DIGI" +
	"T EIGHTTIRHUTA DIGIT NINESIDDHAM LETTER ASIDDHAM LETTER AASIDDHAM LETTER" +
	" ISIDDHAM LETTER IISIDDHAM LETTER USIDDHAM LETTER UUSIDDHAM LETTER VOCAL" +
	"IC RSIDDHAM LETTER VOCALIC RRSIDDHAM LETTER VOCALIC LSIDDHAM LETTER VOCA" +
	"LIC LLSIDDHAM LETTER ESIDDHAM LETTER AISIDDHAM LETTER OSIDDHAM LETTER AU" +
	"SIDDHAM LETTER KASIDDHAM LETTER KHASIDDHAM LETTER GASIDDHAM LETTER GHASI" +
	"DDHAM LETTER NGASIDDHAM LETTER CASIDDHAM LETTER CHASIDDHAM LETTER JASIDD" +
	"HAM LETTER JHASIDDHAM LETTER NYASIDDHAM LETTER TTASIDDHAM LETTER TTHASID" +
	"DHAM LETTER DDASIDDHAM LETTER DDHASIDDHAM LETTER NNASIDDHAM LETTER TASID" +
	"DHAM LETTER THASIDDHAM LETTER DASIDDHAM LETTER DHASIDDHAM LETTER NASIDDH" +
	"AM LETTER PASIDDHAM LETTER PHASIDDHAM LETTER BASIDDHAM LETTER BHASIDDHAM" +
	" LETTER MASIDDHAM LETTER YASIDDHAM LETTER RASIDDHAM LETTER LASIDDHAM LET" +
	"TER VASIDDHAM LETTER SHASIDDHAM LETTER SSASIDDHAM LETTER SASIDDHAM LETTE" +
	"R HASIDDHAM VOWEL SIGN AASIDDHAM VOWEL SIGN ISIDDHAM VOWEL SIGN IISIDDHA" +
	"M VOWEL SIGN USIDDHAM VOWEL SIGN UUSIDDHAM VOWEL SIGN VOCALIC RSIDDHAM V" +
	"OWEL SIGN VOCALIC RRSIDDHAM VOWEL SIGN ESIDDHAM VOWEL SIGN AISIDDHAM VOW" +
	"EL SIGN OSIDDHAM VOWEL SIGN AUSIDDHAM SIGN CANDRABINDUSIDDHAM SIGN ANUSV" +
	"ARASIDDHAM SIGN VISARGASIDDHAM SIGN VIRAMASIDDHAM SIGN NUKTASIDDHAM SIGN" +
	" SIDDHAMSIDDHAM DANDASIDDHAM DOUBLE DANDASIDDHAM SEPARATOR DOTSIDDHAM SE" +
	"PARATOR BARSIDDHAM REPETITION MARK-1SIDDHAM REPETITION MARK-2SIDDHAM REP" +
	"ETITION MARK-3SIDDHAM END OF TEXT MARKSIDDHAM SECTION MARK WITH TRIDENT " +
	"AND U-SHAPED ORNAMENTSSIDDHAM SECTION MARK WITH TRIDENT AND DOTTED CRESC" +
	"ENTSSIDDHAM SECTION MARK WITH RAYS AND DOTTED CRESCENTSSIDDHAM SECTION M" +
	"ARK WITH RAYS AND DOTTED DOUBLE CRESCENTSSIDDHAM SECTION MARK WITH RAYS " +
	"AND DOTTED TRIPLE CRESCENTSSIDDHAM SECTION MARK DOUBLE RINGSIDDHAM SECTI" +
	"ON MARK DOUBLE RING WITH RAYSSIDDHAM SECTION MARK WITH DOUBLE CRESCENTSS" +
	"IDDHAM SECTION MARK WITH TRIPLE CRESCENTSSIDDHAM SECTION MARK WITH QUADR" +
	"UPLE CRESCENTSSIDDHAM SECTION MARK WITH SEPTUPLE CRESCENTSSIDDHAM SECTIO" +
	"N MARK WITH CIRCLES AND RAYSSIDDHAM SECTION MARK WITH CIRCLES AND TWO EN" +
	"CLOSURESSIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURESSIDDHAM LET" +
	"TER THREE-CIRCLE ALTERNATE ISIDDHAM LETTER TWO-CIRCLE ALTERNATE ISIDDHAM" +
	" LETTER TWO-CIRCLE ALTERNATE IISIDDHAM LETTER ALTERNATE USIDDHAM VOWEL S" +
	"IGN ALTERNATE USIDDHAM VOWEL SIGN ALTERNATE UUMODI LETTER AMODI LETTER A" +
	"AMODI LETTER IMODI LETTER IIMODI LETTER UMODI LETTER UUMODI LETTER VOCAL") + ("" +
	"IC RMODI LETTER VOCALIC RRMODI LETTER VOCALIC LMODI LETTER VOCALIC LLMOD" +
	"I LETTER EMODI LETTER AIMODI LETTER OMODI LETTER AUMODI LETTER KAMODI LE" +
	"TTER KHAMODI LETTER GAMODI LETTER GHAMODI LETTER NGAMODI LETTER CAMODI L" +
	"ETTER CHAMODI LETTER JAMODI LETTER JHAMODI LETTER NYAMODI LETTER TTAMODI" +
	" LETTER TTHAMODI LETTER DDAMODI LETTER DDHAMODI LETTER NNAMODI LETTER TA" +
	"MODI LETTER THAMODI LETTER DAMODI LETTER DHAMODI LETTER NAMODI LETTER PA" +
	"MODI LETTER PHAMODI LETTER BAMODI LETTER BHAMODI LETTER MAMODI LETTER YA" +
	"MODI LETTER RAMODI LETTER LAMODI LETTER VAMODI LETTER SHAMODI LETTER SSA" +
	"MODI LETTER SAMODI LETTER HAMODI LETTER LLAMODI VOWEL SIGN AAMODI VOWEL " +
	"SIGN IMODI VOWEL SIGN IIMODI VOWEL SIGN UMODI VOWEL SIGN UUMODI VOWEL SI" +
	"GN VOCALIC RMODI VOWEL SIGN VOCALIC RRMODI VOWEL SIGN VOCALIC LMODI VOWE" +
	"L SIGN VOCALIC LLMODI VOWEL SIGN EMODI VOWEL SIGN AIMODI VOWEL SIGN OMOD" +
	"I VOWEL SIGN AUMODI SIGN ANUSVARAMODI SIGN VISARGAMODI SIGN VIRAMAMODI S" +
	"IGN ARDHACANDRAMODI DANDAMODI DOUBLE DANDAMODI ABBREVIATION SIGNMODI SIG" +
	"N HUVAMODI DIGIT ZEROMODI DIGIT ONEMODI DIGIT TWOMODI DIGIT THREEMODI DI" +
	"GIT FOURMODI DIGIT FIVEMODI DIGIT SIXMODI DIGIT SEVENMODI DIGIT EIGHTMOD" +
	"I DIGIT NINEMONGOLIAN BIRGA WITH ORNAMENTMONGOLIAN ROTATED BIRGAMONGOLIA" +
	"N DOUBLE BIRGA WITH ORNAMENTMONGOLIAN TRIPLE BIRGA WITH ORNAMENTMONGOLIA" +
	"N BIRGA WITH DOUBLE ORNAMENTMONGOLIAN ROTATED BIRGA WITH ORNAMENTMONGOLI" +
	"AN ROTATED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN INVERTED BIRGAMONGOLIAN I" +
	"NVERTED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN SWIRL BIRGAMONGOLIAN SWIRL B" +
	"IRGA WITH ORNAMENTMONGOLIAN SWIRL BIRGA WITH DOUBLE ORNAMENTMONGOLIAN TU" +
	"RNED SWIRL BIRGA WITH DOUBLE ORNAMENTTAKRI LETTER ATAKRI LETTER AATAKRI " +
	"LETTER ITAKRI LETTER IITAKRI LETTER UTAKRI LETTER UUTAKRI LETTER ETAKRI " +
	"LETTER AITAKRI LETTER OTAKRI LETTER AUTAKRI LETTER KATAKRI LETTER KHATAK" +
	"RI LETTER GATAKRI LETTER GHATAKRI LETTER NGATAKRI LETTER CATAKRI LETTER " +
	"CHATAKRI LETTER JATAKRI LETTER JHATAKRI LETTER NYATAKRI LETTER TTATAKRI " +
	"LETTER TTHATAKRI LETTER DDATAKRI LETTER DDHATAKRI LETTER NNATAKRI LETTER" +
	" TATAKRI LETTER THATAKRI LETTER DATAKRI LETTER DHATAKRI LETTER NATAKRI L" +
	"ETTER PATAKRI LETTER PHATAKRI LETTER BATAKRI LETTER BHATAKRI LETTER MATA" +
	"KRI LETTER YATAKRI LETTER RATAKRI LETTER LATAKRI LETTER VATAKRI LETTER S" +
	"HATAKRI LETTER SATAKRI LETTER HATAKRI LETTER RRATAKRI SIGN ANUSVARATAKRI" +
	" SIGN VISARGATAKRI VOWEL SIGN AATAKRI VOWEL SIGN ITAKRI VOWEL SIGN IITAK" +
	"RI VOWEL SIGN UTAKRI VOWEL SIGN UUTAKRI VOWEL SIGN ETAKRI VOWEL SIGN AIT" +
	"AKRI VOWEL SIGN OTAKRI VOWEL SIGN AUTAKRI SIGN VIRAMATAKRI SIGN NUKTATAK" +
	"RI DIGIT ZEROTAKRI DIGIT ONETAKRI DIGIT TWOTAKRI DIGIT THREETAKRI DIGIT " +
	"FOURTAKRI DIGIT FIVETAKRI DIGIT SIXTAKRI DIGIT SEVENTAKRI DIGIT EIGHTTAK" +
	"RI DIGIT NINEAHOM LETTER KAAHOM LETTER KHAAHOM LETTER NGAAHOM LETTER NAA" +
	"HOM LETTER TAAHOM LETTER ALTERNATE TAAHOM LETTER PAAHOM LETTER PHAAHOM L" +
	"ETTER BAAHOM LETTER MAAHOM LETTER JAAHOM LETTER CHAAHOM LETTER THAAHOM L" +
	"ETTER RAAHOM LETTER LAAHOM LETTER SAAHOM LETTER NYAAHOM LETTER HAAHOM LE" +
	"TTER AAHOM LETTER DAAHOM LETTER DHAAHOM LETTER GAAHOM LETTER ALTERNATE G" +
	"AAHOM LETTER GHAAHOM LETTER BHAAHOM LETTER JHAAHOM LETTER ALTERNATE BAAH" +
	"OM CONSONANT SIGN MEDIAL LAAHOM CONSONANT SIGN MEDIAL RAAHOM CONSONANT S" +
	"IGN MEDIAL LIGATING RAAHOM VOWEL SIGN AAHOM VOWEL SIGN AAAHOM VOWEL SIGN" +
	" IAHOM VOWEL SIGN IIAHOM VOWEL SIGN UAHOM VOWEL SIGN UUAHOM VOWEL SIGN E" +
	"AHOM VOWEL SIGN AWAHOM VOWEL SIGN OAHOM VOWEL SIGN AIAHOM VOWEL SIGN AMA" +
	"HOM SIGN KILLERAHOM DIGIT ZEROAHOM DIGIT ONEAHOM DIGIT TWOAHOM DIGIT THR" +
	"EEAHOM DIGIT FOURAHOM DIGIT FIVEAHOM DIGIT SIXAHOM DIGIT SEVENAHOM DIGIT" +
	" EIGHTAHOM DIGIT NINEAHOM NUMBER TENAHOM NUMBER TWENTYAHOM SIGN SMALL SE" +
	"CTIONAHOM SIGN SECTIONAHOM SIGN RULAIAHOM SYMBOL VIDOGRA LETTER ADOGRA L" +
	"ETTER AADOGRA LETTER IDOGRA LETTER IIDOGRA LETTER UDOGRA LETTER UUDOGRA " +
	"LETTER EDOGRA LETTER AIDOGRA LETTER ODOGRA LETTER AUDOGRA LETTER KADOGRA" +
	" LETTER KHADOGRA LETTER GADOGRA LETTER GHADOGRA LETTER NGADOGRA LETTER C" +
	"ADOGRA LETTER CHADOGRA LETTER JADOGRA LETTER JHADOGRA LETTER NYADOGRA LE" +
	"TTER TTADOGRA LETTER TTHADOGRA LETTER DDADOGRA LETTER DDHADOGRA LETTER N" +
	"NADOGRA LETTER TADOGRA LETTER THADOGRA LETTER DADOGRA LETTER DHADOGRA LE" +
	"TTER NADOGRA LETTER PADOGRA LETTER PHADOGRA LETTER BADOGRA LETTER BHADOG" +
	"RA LETTER MADOGRA LETTER YADOGRA LETTER RADOGRA LETTER LADOGRA LETTER VA" +
	"DOGRA LETTER SHADOGRA LETTER SSADOGRA LETTER SADOGRA LETTER HADOGRA LETT" +
	"ER RRADOGRA VOWEL SIGN AADOGRA VOWEL SIGN IDOGRA VOWEL SIGN IIDOGRA VOWE" +
	"L SIGN UDOGRA VOWEL SIGN UUDOGRA VOWEL SIGN VOCALIC RDOGRA VOWEL SIGN VO" +
	"CALIC RRDOGRA VOWEL SIGN EDOGRA VOWEL SIGN AIDOGRA VOWEL SIGN ODOGRA VOW" +
	"EL SIGN AUDOGRA SIGN ANUSVARADOGRA SIGN VISARGADOGRA SIGN VIRAMADOGRA SI") + ("" +
	"GN NUKTADOGRA ABBREVIATION SIGNWARANG CITI CAPITAL LETTER NGAAWARANG CIT" +
	"I CAPITAL LETTER AWARANG CITI CAPITAL LETTER WIWARANG CITI CAPITAL LETTE" +
	"R YUWARANG CITI CAPITAL LETTER YAWARANG CITI CAPITAL LETTER YOWARANG CIT" +
	"I CAPITAL LETTER IIWARANG CITI CAPITAL LETTER UUWARANG CITI CAPITAL LETT" +
	"ER EWARANG CITI CAPITAL LETTER OWARANG CITI CAPITAL LETTER ANGWARANG CIT" +
	"I CAPITAL LETTER GAWARANG CITI CAPITAL LETTER KOWARANG CITI CAPITAL LETT" +
	"ER ENYWARANG CITI CAPITAL LETTER YUJWARANG CITI CAPITAL LETTER UCWARANG " +
	"CITI CAPITAL LETTER ENNWARANG CITI CAPITAL LETTER ODDWARANG CITI CAPITAL" +
	" LETTER TTEWARANG CITI CAPITAL LETTER NUNGWARANG CITI CAPITAL LETTER DAW" +
	"ARANG CITI CAPITAL LETTER ATWARANG CITI CAPITAL LETTER AMWARANG CITI CAP" +
	"ITAL LETTER BUWARANG CITI CAPITAL LETTER PUWARANG CITI CAPITAL LETTER HI" +
	"YOWARANG CITI CAPITAL LETTER HOLOWARANG CITI CAPITAL LETTER HORRWARANG C" +
	"ITI CAPITAL LETTER HARWARANG CITI CAPITAL LETTER SSUUWARANG CITI CAPITAL" +
	" LETTER SIIWARANG CITI CAPITAL LETTER VIYOWARANG CITI SMALL LETTER NGAAW" +
	"ARANG CITI SMALL LETTER AWARANG CITI SMALL LETTER WIWARANG CITI SMALL LE" +
	"TTER YUWARANG CITI SMALL LETTER YAWARANG CITI SMALL LETTER YOWARANG CITI" +
	" SMALL LETTER IIWARANG CITI SMALL LETTER UUWARANG CITI SMALL LETTER EWAR" +
	"ANG CITI SMALL LETTER OWARANG CITI SMALL LETTER ANGWARANG CITI SMALL LET" +
	"TER GAWARANG CITI SMALL LETTER KOWARANG CITI SMALL LETTER ENYWARANG CITI" +
	" SMALL LETTER YUJWARANG CITI SMALL LETTER UCWARANG CITI SMALL LETTER ENN" +
	"WARANG CITI SMALL LETTER ODDWARANG CITI SMALL LETTER TTEWARANG CITI SMAL" +
	"L LETTER NUNGWARANG CITI SMALL LETTER DAWARANG CITI SMALL LETTER ATWARAN" +
	"G CITI SMALL LETTER AMWARANG CITI SMALL LETTER BUWARANG CITI SMALL LETTE" +
	"R PUWARANG CITI SMALL LETTER HIYOWARANG CITI SMALL LETTER HOLOWARANG CIT" +
	"I SMALL LETTER HORRWARANG CITI SMALL LETTER HARWARANG CITI SMALL LETTER " +
	"SSUUWARANG CITI SMALL LETTER SIIWARANG CITI SMALL LETTER VIYOWARANG CITI" +
	" DIGIT ZEROWARANG CITI DIGIT ONEWARANG CITI DIGIT TWOWARANG CITI DIGIT T" +
	"HREEWARANG CITI DIGIT FOURWARANG CITI DIGIT FIVEWARANG CITI DIGIT SIXWAR" +
	"ANG CITI DIGIT SEVENWARANG CITI DIGIT EIGHTWARANG CITI DIGIT NINEWARANG " +
	"CITI NUMBER TENWARANG CITI NUMBER TWENTYWARANG CITI NUMBER THIRTYWARANG " +
	"CITI NUMBER FORTYWARANG CITI NUMBER FIFTYWARANG CITI NUMBER SIXTYWARANG " +
	"CITI NUMBER SEVENTYWARANG CITI NUMBER EIGHTYWARANG CITI NUMBER NINETYWAR" +
	"ANG CITI OMZANABAZAR SQUARE LETTER AZANABAZAR SQUARE VOWEL SIGN IZANABAZ" +
	"AR SQUARE VOWEL SIGN UEZANABAZAR SQUARE VOWEL SIGN UZANABAZAR SQUARE VOW" +
	"EL SIGN EZANABAZAR SQUARE VOWEL SIGN OEZANABAZAR SQUARE VOWEL SIGN OZANA" +
	"BAZAR SQUARE VOWEL SIGN AIZANABAZAR SQUARE VOWEL SIGN AUZANABAZAR SQUARE" +
	" VOWEL SIGN REVERSED IZANABAZAR SQUARE VOWEL LENGTH MARKZANABAZAR SQUARE" +
	" LETTER KAZANABAZAR SQUARE LETTER KHAZANABAZAR SQUARE LETTER GAZANABAZAR" +
	" SQUARE LETTER GHAZANABAZAR SQUARE LETTER NGAZANABAZAR SQUARE LETTER CAZ" +
	"ANABAZAR SQUARE LETTER CHAZANABAZAR SQUARE LETTER JAZANABAZAR SQUARE LET" +
	"TER NYAZANABAZAR SQUARE LETTER TTAZANABAZAR SQUARE LETTER TTHAZANABAZAR " +
	"SQUARE LETTER DDAZANABAZAR SQUARE LETTER DDHAZANABAZAR SQUARE LETTER NNA" +
	"ZANABAZAR SQUARE LETTER TAZANABAZAR SQUARE LETTER THAZANABAZAR SQUARE LE" +
	"TTER DAZANABAZAR SQUARE LETTER DHAZANABAZAR SQUARE LETTER NAZANABAZAR SQ" +
	"UARE LETTER PAZANABAZAR SQUARE LETTER PHAZANABAZAR SQUARE LETTER BAZANAB" +
	"AZAR SQUARE LETTER BHAZANABAZAR SQUARE LETTER MAZANABAZAR SQUARE LETTER " +
	"TSAZANABAZAR SQUARE LETTER TSHAZANABAZAR SQUARE LETTER DZAZANABAZAR SQUA" +
	"RE LETTER DZHAZANABAZAR SQUARE LETTER ZHAZANABAZAR SQUARE LETTER ZAZANAB" +
	"AZAR SQUARE LETTER -AZANABAZAR SQUARE LETTER YAZANABAZAR SQUARE LETTER R" +
	"AZANABAZAR SQUARE LETTER LAZANABAZAR SQUARE LETTER VAZANABAZAR SQUARE LE" +
	"TTER SHAZANABAZAR SQUARE LETTER SSAZANABAZAR SQUARE LETTER SAZANABAZAR S" +
	"QUARE LETTER HAZANABAZAR SQUARE LETTER KSSAZANABAZAR SQUARE FINAL CONSON" +
	"ANT MARKZANABAZAR SQUARE SIGN VIRAMAZANABAZAR SQUARE SIGN CANDRABINDUZAN" +
	"ABAZAR SQUARE SIGN CANDRABINDU WITH ORNAMENTZANABAZAR SQUARE SIGN CANDRA" +
	" WITH ORNAMENTZANABAZAR SQUARE SIGN ANUSVARAZANABAZAR SQUARE SIGN VISARG" +
	"AZANABAZAR SQUARE CLUSTER-INITIAL LETTER RAZANABAZAR SQUARE CLUSTER-FINA" +
	"L LETTER YAZANABAZAR SQUARE CLUSTER-FINAL LETTER RAZANABAZAR SQUARE CLUS" +
	"TER-FINAL LETTER LAZANABAZAR SQUARE CLUSTER-FINAL LETTER VAZANABAZAR SQU" +
	"ARE INITIAL HEAD MARKZANABAZAR SQUARE CLOSING HEAD MARKZANABAZAR SQUARE " +
	"MARK TSHEGZANABAZAR SQUARE MARK SHADZANABAZAR SQUARE MARK DOUBLE SHADZAN" +
	"ABAZAR SQUARE MARK LONG TSHEGZANABAZAR SQUARE INITIAL DOUBLE-LINED HEAD " +
	"MARKZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD MARKZANABAZAR SQUARE SUBJ" +
	"OINERSOYOMBO LETTER ASOYOMBO VOWEL SIGN ISOYOMBO VOWEL SIGN UESOYOMBO VO" +
	"WEL SIGN USOYOMBO VOWEL SIGN ESOYOMBO VOWEL SIGN OSOYOMBO VOWEL SIGN OES") + ("" +
	"OYOMBO VOWEL SIGN AISOYOMBO VOWEL SIGN AUSOYOMBO VOWEL SIGN VOCALIC RSOY" +
	"OMBO VOWEL SIGN VOCALIC LSOYOMBO VOWEL LENGTH MARKSOYOMBO LETTER KASOYOM" +
	"BO LETTER KHASOYOMBO LETTER GASOYOMBO LETTER GHASOYOMBO LETTER NGASOYOMB" +
	"O LETTER CASOYOMBO LETTER CHASOYOMBO LETTER JASOYOMBO LETTER JHASOYOMBO " +
	"LETTER NYASOYOMBO LETTER TTASOYOMBO LETTER TTHASOYOMBO LETTER DDASOYOMBO" +
	" LETTER DDHASOYOMBO LETTER NNASOYOMBO LETTER TASOYOMBO LETTER THASOYOMBO" +
	" LETTER DASOYOMBO LETTER DHASOYOMBO LETTER NASOYOMBO LETTER PASOYOMBO LE" +
	"TTER PHASOYOMBO LETTER BASOYOMBO LETTER BHASOYOMBO LETTER MASOYOMBO LETT" +
	"ER TSASOYOMBO LETTER TSHASOYOMBO LETTER DZASOYOMBO LETTER ZHASOYOMBO LET" +
	"TER ZASOYOMBO LETTER -ASOYOMBO LETTER YASOYOMBO LETTER RASOYOMBO LETTER " +
	"LASOYOMBO LETTER VASOYOMBO LETTER SHASOYOMBO LETTER SSASOYOMBO LETTER SA" +
	"SOYOMBO LETTER HASOYOMBO LETTER KSSASOYOMBO CLUSTER-INITIAL LETTER RASOY" +
	"OMBO CLUSTER-INITIAL LETTER LASOYOMBO CLUSTER-INITIAL LETTER SHASOYOMBO " +
	"CLUSTER-INITIAL LETTER SASOYOMBO FINAL CONSONANT SIGN GSOYOMBO FINAL CON" +
	"SONANT SIGN KSOYOMBO FINAL CONSONANT SIGN NGSOYOMBO FINAL CONSONANT SIGN" +
	" DSOYOMBO FINAL CONSONANT SIGN NSOYOMBO FINAL CONSONANT SIGN BSOYOMBO FI" +
	"NAL CONSONANT SIGN MSOYOMBO FINAL CONSONANT SIGN RSOYOMBO FINAL CONSONAN" +
	"T SIGN LSOYOMBO FINAL CONSONANT SIGN SHSOYOMBO FINAL CONSONANT SIGN SSOY" +
	"OMBO FINAL CONSONANT SIGN -ASOYOMBO SIGN ANUSVARASOYOMBO SIGN VISARGASOY" +
	"OMBO GEMINATION MARKSOYOMBO SUBJOINERSOYOMBO MARK TSHEGSOYOMBO MARK SHAD" +
	"SOYOMBO MARK DOUBLE SHADSOYOMBO MARK PLUTASOYOMBO HEAD MARK WITH MOON AN" +
	"D SUN AND TRIPLE FLAMESOYOMBO HEAD MARK WITH MOON AND SUN AND FLAMESOYOM" +
	"BO HEAD MARK WITH MOON AND SUNSOYOMBO TERMINAL MARK-1SOYOMBO TERMINAL MA" +
	"RK-2PAU CIN HAU LETTER PAPAU CIN HAU LETTER KAPAU CIN HAU LETTER LAPAU C" +
	"IN HAU LETTER MAPAU CIN HAU LETTER DAPAU CIN HAU LETTER ZAPAU CIN HAU LE" +
	"TTER VAPAU CIN HAU LETTER NGAPAU CIN HAU LETTER HAPAU CIN HAU LETTER GAP" +
	"AU CIN HAU LETTER KHAPAU CIN HAU LETTER SAPAU CIN HAU LETTER BAPAU CIN H" +
	"AU LETTER CAPAU CIN HAU LETTER TAPAU CIN HAU LETTER THAPAU CIN HAU LETTE" +
	"R NAPAU CIN HAU LETTER PHAPAU CIN HAU LETTER RAPAU CIN HAU LETTER FAPAU " +
	"CIN HAU LETTER CHAPAU CIN HAU LETTER APAU CIN HAU LETTER EPAU CIN HAU LE" +
	"TTER IPAU CIN HAU LETTER OPAU CIN HAU LETTER UPAU CIN HAU LETTER UAPAU C" +
	"IN HAU LETTER IAPAU CIN HAU LETTER FINAL PPAU CIN HAU LETTER FINAL KPAU " +
	"CIN HAU LETTER FINAL TPAU CIN HAU LETTER FINAL MPAU CIN HAU LETTER FINAL" +
	" NPAU CIN HAU LETTER FINAL LPAU CIN HAU LETTER FINAL WPAU CIN HAU LETTER" +
	" FINAL NGPAU CIN HAU LETTER FINAL YPAU CIN HAU RISING TONE LONGPAU CIN H" +
	"AU RISING TONEPAU CIN HAU SANDHI GLOTTAL STOPPAU CIN HAU RISING TONE LON" +
	"G FINALPAU CIN HAU RISING TONE FINALPAU CIN HAU SANDHI GLOTTAL STOP FINA" +
	"LPAU CIN HAU SANDHI TONE LONGPAU CIN HAU SANDHI TONEPAU CIN HAU SANDHI T" +
	"ONE LONG FINALPAU CIN HAU SANDHI TONE FINALPAU CIN HAU MID-LEVEL TONEPAU" +
	" CIN HAU GLOTTAL STOP VARIANTPAU CIN HAU MID-LEVEL TONE LONG FINALPAU CI" +
	"N HAU MID-LEVEL TONE FINALPAU CIN HAU LOW-FALLING TONE LONGPAU CIN HAU L" +
	"OW-FALLING TONEPAU CIN HAU GLOTTAL STOPPAU CIN HAU LOW-FALLING TONE LONG" +
	" FINALPAU CIN HAU LOW-FALLING TONE FINALPAU CIN HAU GLOTTAL STOP FINALBH" +
	"AIKSUKI LETTER ABHAIKSUKI LETTER AABHAIKSUKI LETTER IBHAIKSUKI LETTER II" +
	"BHAIKSUKI LETTER UBHAIKSUKI LETTER UUBHAIKSUKI LETTER VOCALIC RBHAIKSUKI" +
	" LETTER VOCALIC RRBHAIKSUKI LETTER VOCALIC LBHAIKSUKI LETTER EBHAIKSUKI " +
	"LETTER AIBHAIKSUKI LETTER OBHAIKSUKI LETTER AUBHAIKSUKI LETTER KABHAIKSU" +
	"KI LETTER KHABHAIKSUKI LETTER GABHAIKSUKI LETTER GHABHAIKSUKI LETTER NGA" +
	"BHAIKSUKI LETTER CABHAIKSUKI LETTER CHABHAIKSUKI LETTER JABHAIKSUKI LETT" +
	"ER JHABHAIKSUKI LETTER NYABHAIKSUKI LETTER TTABHAIKSUKI LETTER TTHABHAIK" +
	"SUKI LETTER DDABHAIKSUKI LETTER DDHABHAIKSUKI LETTER NNABHAIKSUKI LETTER" +
	" TABHAIKSUKI LETTER THABHAIKSUKI LETTER DABHAIKSUKI LETTER DHABHAIKSUKI " +
	"LETTER NABHAIKSUKI LETTER PABHAIKSUKI LETTER PHABHAIKSUKI LETTER BABHAIK" +
	"SUKI LETTER BHABHAIKSUKI LETTER MABHAIKSUKI LETTER YABHAIKSUKI LETTER RA" +
	"BHAIKSUKI LETTER LABHAIKSUKI LETTER VABHAIKSUKI LETTER SHABHAIKSUKI LETT" +
	"ER SSABHAIKSUKI LETTER SABHAIKSUKI LETTER HABHAIKSUKI VOWEL SIGN AABHAIK" +
	"SUKI VOWEL SIGN IBHAIKSUKI VOWEL SIGN IIBHAIKSUKI VOWEL SIGN UBHAIKSUKI " +
	"VOWEL SIGN UUBHAIKSUKI VOWEL SIGN VOCALIC RBHAIKSUKI VOWEL SIGN VOCALIC " +
	"RRBHAIKSUKI VOWEL SIGN VOCALIC LBHAIKSUKI VOWEL SIGN EBHAIKSUKI VOWEL SI" +
	"GN AIBHAIKSUKI VOWEL SIGN OBHAIKSUKI VOWEL SIGN AUBHAIKSUKI SIGN CANDRAB" +
	"INDUBHAIKSUKI SIGN ANUSVARABHAIKSUKI SIGN VISARGABHAIKSUKI SIGN VIRAMABH" +
	"AIKSUKI SIGN AVAGRAHABHAIKSUKI DANDABHAIKSUKI DOUBLE DANDABHAIKSUKI WORD" +
	" SEPARATORBHAIKSUKI GAP FILLER-1BHAIKSUKI GAP FILLER-2BHAIKSUKI DIGIT ZE" +
	"ROBHAIKSUKI DIGIT ONEBHAIKSUKI DIGIT TWOBHAIKSUKI DIGIT THREEBHAIKSUKI D") + ("" +
	"IGIT FOURBHAIKSUKI DIGIT FIVEBHAIKSUKI DIGIT SIXBHAIKSUKI DIGIT SEVENBHA" +
	"IKSUKI DIGIT EIGHTBHAIKSUKI DIGIT NINEBHAIKSUKI NUMBER ONEBHAIKSUKI NUMB" +
	"ER TWOBHAIKSUKI NUMBER THREEBHAIKSUKI NUMBER FOURBHAIKSUKI NUMBER FIVEBH" +
	"AIKSUKI NUMBER SIXBHAIKSUKI NUMBER SEVENBHAIKSUKI NUMBER EIGHTBHAIKSUKI " +
	"NUMBER NINEBHAIKSUKI NUMBER TENBHAIKSUKI NUMBER TWENTYBHAIKSUKI NUMBER T" +
	"HIRTYBHAIKSUKI NUMBER FORTYBHAIKSUKI NUMBER FIFTYBHAIKSUKI NUMBER SIXTYB" +
	"HAIKSUKI NUMBER SEVENTYBHAIKSUKI NUMBER EIGHTYBHAIKSUKI NUMBER NINETYBHA" +
	"IKSUKI HUNDREDS UNIT MARKMARCHEN HEAD MARKMARCHEN MARK SHADMARCHEN LETTE" +
	"R KAMARCHEN LETTER KHAMARCHEN LETTER GAMARCHEN LETTER NGAMARCHEN LETTER " +
	"CAMARCHEN LETTER CHAMARCHEN LETTER JAMARCHEN LETTER NYAMARCHEN LETTER TA" +
	"MARCHEN LETTER THAMARCHEN LETTER DAMARCHEN LETTER NAMARCHEN LETTER PAMAR" +
	"CHEN LETTER PHAMARCHEN LETTER BAMARCHEN LETTER MAMARCHEN LETTER TSAMARCH" +
	"EN LETTER TSHAMARCHEN LETTER DZAMARCHEN LETTER WAMARCHEN LETTER ZHAMARCH" +
	"EN LETTER ZAMARCHEN LETTER -AMARCHEN LETTER YAMARCHEN LETTER RAMARCHEN L" +
	"ETTER LAMARCHEN LETTER SHAMARCHEN LETTER SAMARCHEN LETTER HAMARCHEN LETT" +
	"ER AMARCHEN SUBJOINED LETTER KAMARCHEN SUBJOINED LETTER KHAMARCHEN SUBJO" +
	"INED LETTER GAMARCHEN SUBJOINED LETTER NGAMARCHEN SUBJOINED LETTER CAMAR" +
	"CHEN SUBJOINED LETTER CHAMARCHEN SUBJOINED LETTER JAMARCHEN SUBJOINED LE" +
	"TTER NYAMARCHEN SUBJOINED LETTER TAMARCHEN SUBJOINED LETTER THAMARCHEN S" +
	"UBJOINED LETTER DAMARCHEN SUBJOINED LETTER NAMARCHEN SUBJOINED LETTER PA" +
	"MARCHEN SUBJOINED LETTER PHAMARCHEN SUBJOINED LETTER BAMARCHEN SUBJOINED" +
	" LETTER MAMARCHEN SUBJOINED LETTER TSAMARCHEN SUBJOINED LETTER TSHAMARCH" +
	"EN SUBJOINED LETTER DZAMARCHEN SUBJOINED LETTER WAMARCHEN SUBJOINED LETT" +
	"ER ZHAMARCHEN SUBJOINED LETTER ZAMARCHEN SUBJOINED LETTER YAMARCHEN SUBJ" +
	"OINED LETTER RAMARCHEN SUBJOINED LETTER LAMARCHEN SUBJOINED LETTER SHAMA" +
	"RCHEN SUBJOINED LETTER SAMARCHEN SUBJOINED LETTER HAMARCHEN SUBJOINED LE" +
	"TTER AMARCHEN VOWEL SIGN AAMARCHEN VOWEL SIGN IMARCHEN VOWEL SIGN UMARCH" +
	"EN VOWEL SIGN EMARCHEN VOWEL SIGN OMARCHEN SIGN ANUSVARAMARCHEN SIGN CAN" +
	"DRABINDUMASARAM GONDI LETTER AMASARAM GONDI LETTER AAMASARAM GONDI LETTE" +
	"R IMASARAM GONDI LETTER IIMASARAM GONDI LETTER UMASARAM GONDI LETTER UUM" +
	"ASARAM GONDI LETTER EMASARAM GONDI LETTER AIMASARAM GONDI LETTER OMASARA" +
	"M GONDI LETTER AUMASARAM GONDI LETTER KAMASARAM GONDI LETTER KHAMASARAM " +
	"GONDI LETTER GAMASARAM GONDI LETTER GHAMASARAM GONDI LETTER NGAMASARAM G" +
	"ONDI LETTER CAMASARAM GONDI LETTER CHAMASARAM GONDI LETTER JAMASARAM GON" +
	"DI LETTER JHAMASARAM GONDI LETTER NYAMASARAM GONDI LETTER TTAMASARAM GON" +
	"DI LETTER TTHAMASARAM GONDI LETTER DDAMASARAM GONDI LETTER DDHAMASARAM G" +
	"ONDI LETTER NNAMASARAM GONDI LETTER TAMASARAM GONDI LETTER THAMASARAM GO" +
	"NDI LETTER DAMASARAM GONDI LETTER DHAMASARAM GONDI LETTER NAMASARAM GOND" +
	"I LETTER PAMASARAM GONDI LETTER PHAMASARAM GONDI LETTER BAMASARAM GONDI " +
	"LETTER BHAMASARAM GONDI LETTER MAMASARAM GONDI LETTER YAMASARAM GONDI LE" +
	"TTER RAMASARAM GONDI LETTER LAMASARAM GONDI LETTER VAMASARAM GONDI LETTE" +
	"R SHAMASARAM GONDI LETTER SSAMASARAM GONDI LETTER SAMASARAM GONDI LETTER" +
	" HAMASARAM GONDI LETTER LLAMASARAM GONDI LETTER KSSAMASARAM GONDI LETTER" +
	" JNYAMASARAM GONDI LETTER TRAMASARAM GONDI VOWEL SIGN AAMASARAM GONDI VO" +
	"WEL SIGN IMASARAM GONDI VOWEL SIGN IIMASARAM GONDI VOWEL SIGN UMASARAM G" +
	"ONDI VOWEL SIGN UUMASARAM GONDI VOWEL SIGN VOCALIC RMASARAM GONDI VOWEL " +
	"SIGN EMASARAM GONDI VOWEL SIGN AIMASARAM GONDI VOWEL SIGN OMASARAM GONDI" +
	" VOWEL SIGN AUMASARAM GONDI SIGN ANUSVARAMASARAM GONDI SIGN VISARGAMASAR" +
	"AM GONDI SIGN NUKTAMASARAM GONDI SIGN CANDRAMASARAM GONDI SIGN HALANTAMA" +
	"SARAM GONDI VIRAMAMASARAM GONDI REPHAMASARAM GONDI RA-KARAMASARAM GONDI " +
	"DIGIT ZEROMASARAM GONDI DIGIT ONEMASARAM GONDI DIGIT TWOMASARAM GONDI DI" +
	"GIT THREEMASARAM GONDI DIGIT FOURMASARAM GONDI DIGIT FIVEMASARAM GONDI D" +
	"IGIT SIXMASARAM GONDI DIGIT SEVENMASARAM GONDI DIGIT EIGHTMASARAM GONDI " +
	"DIGIT NINEGUNJALA GONDI LETTER AGUNJALA GONDI LETTER AAGUNJALA GONDI LET" +
	"TER IGUNJALA GONDI LETTER IIGUNJALA GONDI LETTER UGUNJALA GONDI LETTER U" +
	"UGUNJALA GONDI LETTER EEGUNJALA GONDI LETTER AIGUNJALA GONDI LETTER OOGU" +
	"NJALA GONDI LETTER AUGUNJALA GONDI LETTER YAGUNJALA GONDI LETTER VAGUNJA" +
	"LA GONDI LETTER BAGUNJALA GONDI LETTER BHAGUNJALA GONDI LETTER MAGUNJALA" +
	" GONDI LETTER KAGUNJALA GONDI LETTER KHAGUNJALA GONDI LETTER TAGUNJALA G" +
	"ONDI LETTER THAGUNJALA GONDI LETTER LAGUNJALA GONDI LETTER GAGUNJALA GON" +
	"DI LETTER GHAGUNJALA GONDI LETTER DAGUNJALA GONDI LETTER DHAGUNJALA GOND" +
	"I LETTER NAGUNJALA GONDI LETTER CAGUNJALA GONDI LETTER CHAGUNJALA GONDI " +
	"LETTER TTAGUNJALA GONDI LETTER TTHAGUNJALA GONDI LETTER LLAGUNJALA GONDI" +
	" LETTER JAGUNJALA GONDI LETTER JHAGUNJALA GONDI LETTER DDAGUNJALA GONDI ") + ("" +
	"LETTER DDHAGUNJALA GONDI LETTER NGAGUNJALA GONDI LETTER PAGUNJALA GONDI " +
	"LETTER PHAGUNJALA GONDI LETTER HAGUNJALA GONDI LETTER RAGUNJALA GONDI LE" +
	"TTER SAGUNJALA GONDI VOWEL SIGN AAGUNJALA GONDI VOWEL SIGN IGUNJALA GOND" +
	"I VOWEL SIGN IIGUNJALA GONDI VOWEL SIGN UGUNJALA GONDI VOWEL SIGN UUGUNJ" +
	"ALA GONDI VOWEL SIGN EEGUNJALA GONDI VOWEL SIGN AIGUNJALA GONDI VOWEL SI" +
	"GN OOGUNJALA GONDI VOWEL SIGN AUGUNJALA GONDI SIGN ANUSVARAGUNJALA GONDI" +
	" SIGN VISARGAGUNJALA GONDI VIRAMAGUNJALA GONDI OMGUNJALA GONDI DIGIT ZER" +
	"OGUNJALA GONDI DIGIT ONEGUNJALA GONDI DIGIT TWOGUNJALA GONDI DIGIT THREE" +
	"GUNJALA GONDI DIGIT FOURGUNJALA GONDI DIGIT FIVEGUNJALA GONDI DIGIT SIXG" +
	"UNJALA GONDI DIGIT SEVENGUNJALA GONDI DIGIT EIGHTGUNJALA GONDI DIGIT NIN" +
	"EMAKASAR LETTER KAMAKASAR LETTER GAMAKASAR LETTER NGAMAKASAR LETTER PAMA" +
	"KASAR LETTER BAMAKASAR LETTER MAMAKASAR LETTER TAMAKASAR LETTER DAMAKASA" +
	"R LETTER NAMAKASAR LETTER CAMAKASAR LETTER JAMAKASAR LETTER NYAMAKASAR L" +
	"ETTER YAMAKASAR LETTER RAMAKASAR LETTER LAMAKASAR LETTER VAMAKASAR LETTE" +
	"R SAMAKASAR LETTER AMAKASAR ANGKAMAKASAR VOWEL SIGN IMAKASAR VOWEL SIGN " +
	"UMAKASAR VOWEL SIGN EMAKASAR VOWEL SIGN OMAKASAR PASSIMBANGMAKASAR END O" +
	"F SECTIONCUNEIFORM SIGN ACUNEIFORM SIGN A TIMES ACUNEIFORM SIGN A TIMES " +
	"BADCUNEIFORM SIGN A TIMES GAN2 TENUCUNEIFORM SIGN A TIMES HACUNEIFORM SI" +
	"GN A TIMES IGICUNEIFORM SIGN A TIMES LAGAR GUNUCUNEIFORM SIGN A TIMES MU" +
	"SHCUNEIFORM SIGN A TIMES SAGCUNEIFORM SIGN A2CUNEIFORM SIGN ABCUNEIFORM " +
	"SIGN AB TIMES ASH2CUNEIFORM SIGN AB TIMES DUN3 GUNUCUNEIFORM SIGN AB TIM" +
	"ES GALCUNEIFORM SIGN AB TIMES GAN2 TENUCUNEIFORM SIGN AB TIMES HACUNEIFO" +
	"RM SIGN AB TIMES IGI GUNUCUNEIFORM SIGN AB TIMES IMINCUNEIFORM SIGN AB T" +
	"IMES LAGABCUNEIFORM SIGN AB TIMES SHESHCUNEIFORM SIGN AB TIMES U PLUS U " +
	"PLUS UCUNEIFORM SIGN AB GUNUCUNEIFORM SIGN AB2CUNEIFORM SIGN AB2 TIMES B" +
	"ALAGCUNEIFORM SIGN AB2 TIMES GAN2 TENUCUNEIFORM SIGN AB2 TIMES ME PLUS E" +
	"NCUNEIFORM SIGN AB2 TIMES SHA3CUNEIFORM SIGN AB2 TIMES TAK4CUNEIFORM SIG" +
	"N ADCUNEIFORM SIGN AKCUNEIFORM SIGN AK TIMES ERIN2CUNEIFORM SIGN AK TIME" +
	"S SHITA PLUS GISHCUNEIFORM SIGN ALCUNEIFORM SIGN AL TIMES ALCUNEIFORM SI" +
	"GN AL TIMES DIM2CUNEIFORM SIGN AL TIMES GISHCUNEIFORM SIGN AL TIMES HACU" +
	"NEIFORM SIGN AL TIMES KAD3CUNEIFORM SIGN AL TIMES KICUNEIFORM SIGN AL TI" +
	"MES SHECUNEIFORM SIGN AL TIMES USHCUNEIFORM SIGN ALANCUNEIFORM SIGN ALEP" +
	"HCUNEIFORM SIGN AMARCUNEIFORM SIGN AMAR TIMES SHECUNEIFORM SIGN ANCUNEIF" +
	"ORM SIGN AN OVER ANCUNEIFORM SIGN AN THREE TIMESCUNEIFORM SIGN AN PLUS N" +
	"AGA OPPOSING AN PLUS NAGACUNEIFORM SIGN AN PLUS NAGA SQUAREDCUNEIFORM SI" +
	"GN ANSHECUNEIFORM SIGN APINCUNEIFORM SIGN ARADCUNEIFORM SIGN ARAD TIMES " +
	"KURCUNEIFORM SIGN ARKABCUNEIFORM SIGN ASAL2CUNEIFORM SIGN ASHCUNEIFORM S" +
	"IGN ASH ZIDA TENUCUNEIFORM SIGN ASH KABA TENUCUNEIFORM SIGN ASH OVER ASH" +
	" TUG2 OVER TUG2 TUG2 OVER TUG2 PAPCUNEIFORM SIGN ASH OVER ASH OVER ASHCU" +
	"NEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER ASH OVER ASHCUNEIFO" +
	"RM SIGN ASH2CUNEIFORM SIGN ASHGABCUNEIFORM SIGN BACUNEIFORM SIGN BADCUNE" +
	"IFORM SIGN BAG3CUNEIFORM SIGN BAHAR2CUNEIFORM SIGN BALCUNEIFORM SIGN BAL" +
	" OVER BALCUNEIFORM SIGN BALAGCUNEIFORM SIGN BARCUNEIFORM SIGN BARA2CUNEI" +
	"FORM SIGN BICUNEIFORM SIGN BI TIMES ACUNEIFORM SIGN BI TIMES GARCUNEIFOR" +
	"M SIGN BI TIMES IGI GUNUCUNEIFORM SIGN BUCUNEIFORM SIGN BU OVER BU ABCUN" +
	"EIFORM SIGN BU OVER BU UNCUNEIFORM SIGN BU CROSSING BUCUNEIFORM SIGN BUL" +
	"UGCUNEIFORM SIGN BULUG OVER BULUGCUNEIFORM SIGN BURCUNEIFORM SIGN BUR2CU" +
	"NEIFORM SIGN DACUNEIFORM SIGN DAGCUNEIFORM SIGN DAG KISIM5 TIMES A PLUS " +
	"MASHCUNEIFORM SIGN DAG KISIM5 TIMES AMARCUNEIFORM SIGN DAG KISIM5 TIMES " +
	"BALAGCUNEIFORM SIGN DAG KISIM5 TIMES BICUNEIFORM SIGN DAG KISIM5 TIMES G" +
	"ACUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASHCUNEIFORM SIGN DAG KISIM5 T" +
	"IMES GICUNEIFORM SIGN DAG KISIM5 TIMES GIR2CUNEIFORM SIGN DAG KISIM5 TIM" +
	"ES GUDCUNEIFORM SIGN DAG KISIM5 TIMES HACUNEIFORM SIGN DAG KISIM5 TIMES " +
	"IRCUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LUCUNEIFORM SIGN DAG KISIM5 TI" +
	"MES KAKCUNEIFORM SIGN DAG KISIM5 TIMES LACUNEIFORM SIGN DAG KISIM5 TIMES" +
	" LUCUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2CUNEIFORM SIGN DAG KISIM" +
	"5 TIMES LUMCUNEIFORM SIGN DAG KISIM5 TIMES NECUNEIFORM SIGN DAG KISIM5 T" +
	"IMES PAP PLUS PAPCUNEIFORM SIGN DAG KISIM5 TIMES SICUNEIFORM SIGN DAG KI" +
	"SIM5 TIMES TAK4CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS GIR2CUNEIFORM SIG" +
	"N DAG KISIM5 TIMES USHCUNEIFORM SIGN DAMCUNEIFORM SIGN DARCUNEIFORM SIGN" +
	" DARA3CUNEIFORM SIGN DARA4CUNEIFORM SIGN DICUNEIFORM SIGN DIBCUNEIFORM S" +
	"IGN DIMCUNEIFORM SIGN DIM TIMES SHECUNEIFORM SIGN DIM2CUNEIFORM SIGN DIN" +
	"CUNEIFORM SIGN DIN KASKAL U GUNU DISHCUNEIFORM SIGN DISHCUNEIFORM SIGN D" +
	"UCUNEIFORM SIGN DU OVER DUCUNEIFORM SIGN DU GUNUCUNEIFORM SIGN DU SHESHI") + ("" +
	"GCUNEIFORM SIGN DUBCUNEIFORM SIGN DUB TIMES ESH2CUNEIFORM SIGN DUB2CUNEI" +
	"FORM SIGN DUGCUNEIFORM SIGN DUGUDCUNEIFORM SIGN DUHCUNEIFORM SIGN DUNCUN" +
	"EIFORM SIGN DUN3CUNEIFORM SIGN DUN3 GUNUCUNEIFORM SIGN DUN3 GUNU GUNUCUN" +
	"EIFORM SIGN DUN4CUNEIFORM SIGN DUR2CUNEIFORM SIGN ECUNEIFORM SIGN E TIME" +
	"S PAPCUNEIFORM SIGN E OVER E NUN OVER NUNCUNEIFORM SIGN E2CUNEIFORM SIGN" +
	" E2 TIMES A PLUS HA PLUS DACUNEIFORM SIGN E2 TIMES GARCUNEIFORM SIGN E2 " +
	"TIMES MICUNEIFORM SIGN E2 TIMES SALCUNEIFORM SIGN E2 TIMES SHECUNEIFORM " +
	"SIGN E2 TIMES UCUNEIFORM SIGN EDINCUNEIFORM SIGN EGIRCUNEIFORM SIGN ELCU" +
	"NEIFORM SIGN ENCUNEIFORM SIGN EN TIMES GAN2CUNEIFORM SIGN EN TIMES GAN2 " +
	"TENUCUNEIFORM SIGN EN TIMES MECUNEIFORM SIGN EN CROSSING ENCUNEIFORM SIG" +
	"N EN OPPOSING ENCUNEIFORM SIGN EN SQUAREDCUNEIFORM SIGN ERENCUNEIFORM SI" +
	"GN ERIN2CUNEIFORM SIGN ESH2CUNEIFORM SIGN EZENCUNEIFORM SIGN EZEN TIMES " +
	"ACUNEIFORM SIGN EZEN TIMES A PLUS LALCUNEIFORM SIGN EZEN TIMES A PLUS LA" +
	"L TIMES LALCUNEIFORM SIGN EZEN TIMES ANCUNEIFORM SIGN EZEN TIMES BADCUNE" +
	"IFORM SIGN EZEN TIMES DUN3 GUNUCUNEIFORM SIGN EZEN TIMES DUN3 GUNU GUNUC" +
	"UNEIFORM SIGN EZEN TIMES HACUNEIFORM SIGN EZEN TIMES HA GUNUCUNEIFORM SI" +
	"GN EZEN TIMES IGI GUNUCUNEIFORM SIGN EZEN TIMES KASKALCUNEIFORM SIGN EZE" +
	"N TIMES KASKAL SQUAREDCUNEIFORM SIGN EZEN TIMES KU3CUNEIFORM SIGN EZEN T" +
	"IMES LACUNEIFORM SIGN EZEN TIMES LAL TIMES LALCUNEIFORM SIGN EZEN TIMES " +
	"LICUNEIFORM SIGN EZEN TIMES LUCUNEIFORM SIGN EZEN TIMES U2CUNEIFORM SIGN" +
	" EZEN TIMES UDCUNEIFORM SIGN GACUNEIFORM SIGN GA GUNUCUNEIFORM SIGN GA2C" +
	"UNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HACUNEIFORM SIGN GA2 TIMES A PLUS" +
	" HACUNEIFORM SIGN GA2 TIMES A PLUS IGICUNEIFORM SIGN GA2 TIMES AB2 TENU " +
	"PLUS TABCUNEIFORM SIGN GA2 TIMES ANCUNEIFORM SIGN GA2 TIMES ASHCUNEIFORM" +
	" SIGN GA2 TIMES ASH2 PLUS GALCUNEIFORM SIGN GA2 TIMES BADCUNEIFORM SIGN " +
	"GA2 TIMES BAR PLUS RACUNEIFORM SIGN GA2 TIMES BURCUNEIFORM SIGN GA2 TIME" +
	"S BUR PLUS RACUNEIFORM SIGN GA2 TIMES DACUNEIFORM SIGN GA2 TIMES DICUNEI" +
	"FORM SIGN GA2 TIMES DIM TIMES SHECUNEIFORM SIGN GA2 TIMES DUBCUNEIFORM S" +
	"IGN GA2 TIMES ELCUNEIFORM SIGN GA2 TIMES EL PLUS LACUNEIFORM SIGN GA2 TI" +
	"MES ENCUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENUCUNEIFORM SIGN GA2 TIME" +
	"S GAN2 TENUCUNEIFORM SIGN GA2 TIMES GARCUNEIFORM SIGN GA2 TIMES GICUNEIF" +
	"ORM SIGN GA2 TIMES GI4CUNEIFORM SIGN GA2 TIMES GI4 PLUS ACUNEIFORM SIGN " +
	"GA2 TIMES GIR2 PLUS SUCUNEIFORM SIGN GA2 TIMES HA PLUS LU PLUS ESH2CUNEI" +
	"FORM SIGN GA2 TIMES HALCUNEIFORM SIGN GA2 TIMES HAL PLUS LACUNEIFORM SIG" +
	"N GA2 TIMES HI PLUS LICUNEIFORM SIGN GA2 TIMES HUB2CUNEIFORM SIGN GA2 TI" +
	"MES IGI GUNUCUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS ASHCUNEIFORM SIGN " +
	"GA2 TIMES KAKCUNEIFORM SIGN GA2 TIMES KASKALCUNEIFORM SIGN GA2 TIMES KID" +
	"CUNEIFORM SIGN GA2 TIMES KID PLUS LALCUNEIFORM SIGN GA2 TIMES KU3 PLUS A" +
	"NCUNEIFORM SIGN GA2 TIMES LACUNEIFORM SIGN GA2 TIMES ME PLUS ENCUNEIFORM" +
	" SIGN GA2 TIMES MICUNEIFORM SIGN GA2 TIMES NUNCUNEIFORM SIGN GA2 TIMES N" +
	"UN OVER NUNCUNEIFORM SIGN GA2 TIMES PACUNEIFORM SIGN GA2 TIMES SALCUNEIF" +
	"ORM SIGN GA2 TIMES SARCUNEIFORM SIGN GA2 TIMES SHECUNEIFORM SIGN GA2 TIM" +
	"ES SHE PLUS TURCUNEIFORM SIGN GA2 TIMES SHIDCUNEIFORM SIGN GA2 TIMES SUM" +
	"CUNEIFORM SIGN GA2 TIMES TAK4CUNEIFORM SIGN GA2 TIMES UCUNEIFORM SIGN GA" +
	"2 TIMES UDCUNEIFORM SIGN GA2 TIMES UD PLUS DUCUNEIFORM SIGN GA2 OVER GA2" +
	"CUNEIFORM SIGN GABACUNEIFORM SIGN GABA CROSSING GABACUNEIFORM SIGN GADCU" +
	"NEIFORM SIGN GAD OVER GAD GAR OVER GARCUNEIFORM SIGN GALCUNEIFORM SIGN G" +
	"AL GAD OVER GAD GAR OVER GARCUNEIFORM SIGN GALAMCUNEIFORM SIGN GAMCUNEIF" +
	"ORM SIGN GANCUNEIFORM SIGN GAN2CUNEIFORM SIGN GAN2 TENUCUNEIFORM SIGN GA" +
	"N2 OVER GAN2CUNEIFORM SIGN GAN2 CROSSING GAN2CUNEIFORM SIGN GARCUNEIFORM" +
	" SIGN GAR3CUNEIFORM SIGN GASHANCUNEIFORM SIGN GESHTINCUNEIFORM SIGN GESH" +
	"TIN TIMES KURCUNEIFORM SIGN GICUNEIFORM SIGN GI TIMES ECUNEIFORM SIGN GI" +
	" TIMES UCUNEIFORM SIGN GI CROSSING GICUNEIFORM SIGN GI4CUNEIFORM SIGN GI" +
	"4 OVER GI4CUNEIFORM SIGN GI4 CROSSING GI4CUNEIFORM SIGN GIDIMCUNEIFORM S" +
	"IGN GIR2CUNEIFORM SIGN GIR2 GUNUCUNEIFORM SIGN GIR3CUNEIFORM SIGN GIR3 T" +
	"IMES A PLUS IGICUNEIFORM SIGN GIR3 TIMES GAN2 TENUCUNEIFORM SIGN GIR3 TI" +
	"MES IGICUNEIFORM SIGN GIR3 TIMES LU PLUS IGICUNEIFORM SIGN GIR3 TIMES PA" +
	"CUNEIFORM SIGN GISALCUNEIFORM SIGN GISHCUNEIFORM SIGN GISH CROSSING GISH" +
	"CUNEIFORM SIGN GISH TIMES BADCUNEIFORM SIGN GISH TIMES TAK4CUNEIFORM SIG" +
	"N GISH TENUCUNEIFORM SIGN GUCUNEIFORM SIGN GU CROSSING GUCUNEIFORM SIGN " +
	"GU2CUNEIFORM SIGN GU2 TIMES KAKCUNEIFORM SIGN GU2 TIMES KAK TIMES IGI GU" +
	"NUCUNEIFORM SIGN GU2 TIMES NUNCUNEIFORM SIGN GU2 TIMES SAL PLUS TUG2CUNE" +
	"IFORM SIGN GU2 GUNUCUNEIFORM SIGN GUDCUNEIFORM SIGN GUD TIMES A PLUS KUR" +
	"CUNEIFORM SIGN GUD TIMES KURCUNEIFORM SIGN GUD OVER GUD LUGALCUNEIFORM S") + ("" +
	"IGN GULCUNEIFORM SIGN GUMCUNEIFORM SIGN GUM TIMES SHECUNEIFORM SIGN GURC" +
	"UNEIFORM SIGN GUR7CUNEIFORM SIGN GURUNCUNEIFORM SIGN GURUSHCUNEIFORM SIG" +
	"N HACUNEIFORM SIGN HA TENUCUNEIFORM SIGN HA GUNUCUNEIFORM SIGN HALCUNEIF" +
	"ORM SIGN HICUNEIFORM SIGN HI TIMES ASHCUNEIFORM SIGN HI TIMES ASH2CUNEIF" +
	"ORM SIGN HI TIMES BADCUNEIFORM SIGN HI TIMES DISHCUNEIFORM SIGN HI TIMES" +
	" GADCUNEIFORM SIGN HI TIMES KINCUNEIFORM SIGN HI TIMES NUNCUNEIFORM SIGN" +
	" HI TIMES SHECUNEIFORM SIGN HI TIMES UCUNEIFORM SIGN HUCUNEIFORM SIGN HU" +
	"B2CUNEIFORM SIGN HUB2 TIMES ANCUNEIFORM SIGN HUB2 TIMES HALCUNEIFORM SIG" +
	"N HUB2 TIMES KASKALCUNEIFORM SIGN HUB2 TIMES LISHCUNEIFORM SIGN HUB2 TIM" +
	"ES UDCUNEIFORM SIGN HUL2CUNEIFORM SIGN ICUNEIFORM SIGN I ACUNEIFORM SIGN" +
	" IBCUNEIFORM SIGN IDIMCUNEIFORM SIGN IDIM OVER IDIM BURCUNEIFORM SIGN ID" +
	"IM OVER IDIM SQUAREDCUNEIFORM SIGN IGCUNEIFORM SIGN IGICUNEIFORM SIGN IG" +
	"I DIBCUNEIFORM SIGN IGI RICUNEIFORM SIGN IGI OVER IGI SHIR OVER SHIR UD " +
	"OVER UDCUNEIFORM SIGN IGI GUNUCUNEIFORM SIGN ILCUNEIFORM SIGN IL TIMES G" +
	"AN2 TENUCUNEIFORM SIGN IL2CUNEIFORM SIGN IMCUNEIFORM SIGN IM TIMES TAK4C" +
	"UNEIFORM SIGN IM CROSSING IMCUNEIFORM SIGN IM OPPOSING IMCUNEIFORM SIGN " +
	"IM SQUAREDCUNEIFORM SIGN IMINCUNEIFORM SIGN INCUNEIFORM SIGN IRCUNEIFORM" +
	" SIGN ISHCUNEIFORM SIGN KACUNEIFORM SIGN KA TIMES ACUNEIFORM SIGN KA TIM" +
	"ES ADCUNEIFORM SIGN KA TIMES AD PLUS KU3CUNEIFORM SIGN KA TIMES ASH2CUNE" +
	"IFORM SIGN KA TIMES BADCUNEIFORM SIGN KA TIMES BALAGCUNEIFORM SIGN KA TI" +
	"MES BARCUNEIFORM SIGN KA TIMES BICUNEIFORM SIGN KA TIMES ERIN2CUNEIFORM " +
	"SIGN KA TIMES ESH2CUNEIFORM SIGN KA TIMES GACUNEIFORM SIGN KA TIMES GALC" +
	"UNEIFORM SIGN KA TIMES GAN2 TENUCUNEIFORM SIGN KA TIMES GARCUNEIFORM SIG" +
	"N KA TIMES GAR PLUS SHA3 PLUS ACUNEIFORM SIGN KA TIMES GICUNEIFORM SIGN " +
	"KA TIMES GIR2CUNEIFORM SIGN KA TIMES GISH PLUS SARCUNEIFORM SIGN KA TIME" +
	"S GISH CROSSING GISHCUNEIFORM SIGN KA TIMES GUCUNEIFORM SIGN KA TIMES GU" +
	"R7CUNEIFORM SIGN KA TIMES IGICUNEIFORM SIGN KA TIMES IMCUNEIFORM SIGN KA" +
	" TIMES KAKCUNEIFORM SIGN KA TIMES KICUNEIFORM SIGN KA TIMES KIDCUNEIFORM" +
	" SIGN KA TIMES LICUNEIFORM SIGN KA TIMES LUCUNEIFORM SIGN KA TIMES MECUN" +
	"EIFORM SIGN KA TIMES ME PLUS DUCUNEIFORM SIGN KA TIMES ME PLUS GICUNEIFO" +
	"RM SIGN KA TIMES ME PLUS TECUNEIFORM SIGN KA TIMES MICUNEIFORM SIGN KA T" +
	"IMES MI PLUS NUNUZCUNEIFORM SIGN KA TIMES NECUNEIFORM SIGN KA TIMES NUNC" +
	"UNEIFORM SIGN KA TIMES PICUNEIFORM SIGN KA TIMES RUCUNEIFORM SIGN KA TIM" +
	"ES SACUNEIFORM SIGN KA TIMES SARCUNEIFORM SIGN KA TIMES SHACUNEIFORM SIG" +
	"N KA TIMES SHECUNEIFORM SIGN KA TIMES SHIDCUNEIFORM SIGN KA TIMES SHUCUN" +
	"EIFORM SIGN KA TIMES SIGCUNEIFORM SIGN KA TIMES SUHURCUNEIFORM SIGN KA T" +
	"IMES TARCUNEIFORM SIGN KA TIMES UCUNEIFORM SIGN KA TIMES U2CUNEIFORM SIG" +
	"N KA TIMES UDCUNEIFORM SIGN KA TIMES UMUM TIMES PACUNEIFORM SIGN KA TIME" +
	"S USHCUNEIFORM SIGN KA TIMES ZICUNEIFORM SIGN KA2CUNEIFORM SIGN KA2 CROS" +
	"SING KA2CUNEIFORM SIGN KABCUNEIFORM SIGN KAD2CUNEIFORM SIGN KAD3CUNEIFOR" +
	"M SIGN KAD4CUNEIFORM SIGN KAD5CUNEIFORM SIGN KAD5 OVER KAD5CUNEIFORM SIG" +
	"N KAKCUNEIFORM SIGN KAK TIMES IGI GUNUCUNEIFORM SIGN KALCUNEIFORM SIGN K" +
	"AL TIMES BADCUNEIFORM SIGN KAL CROSSING KALCUNEIFORM SIGN KAM2CUNEIFORM " +
	"SIGN KAM4CUNEIFORM SIGN KASKALCUNEIFORM SIGN KASKAL LAGAB TIMES U OVER L" +
	"AGAB TIMES UCUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TIMES U OVER LAGAB T" +
	"IMES UCUNEIFORM SIGN KESH2CUNEIFORM SIGN KICUNEIFORM SIGN KI TIMES BADCU" +
	"NEIFORM SIGN KI TIMES UCUNEIFORM SIGN KI TIMES UDCUNEIFORM SIGN KIDCUNEI" +
	"FORM SIGN KINCUNEIFORM SIGN KISALCUNEIFORM SIGN KISHCUNEIFORM SIGN KISIM" +
	"5CUNEIFORM SIGN KISIM5 OVER KISIM5CUNEIFORM SIGN KUCUNEIFORM SIGN KU OVE" +
	"R HI TIMES ASH2 KU OVER HI TIMES ASH2CUNEIFORM SIGN KU3CUNEIFORM SIGN KU" +
	"4CUNEIFORM SIGN KU4 VARIANT FORMCUNEIFORM SIGN KU7CUNEIFORM SIGN KULCUNE" +
	"IFORM SIGN KUL GUNUCUNEIFORM SIGN KUNCUNEIFORM SIGN KURCUNEIFORM SIGN KU" +
	"R OPPOSING KURCUNEIFORM SIGN KUSHU2CUNEIFORM SIGN KWU318CUNEIFORM SIGN L" +
	"ACUNEIFORM SIGN LAGABCUNEIFORM SIGN LAGAB TIMES ACUNEIFORM SIGN LAGAB TI" +
	"MES A PLUS DA PLUS HACUNEIFORM SIGN LAGAB TIMES A PLUS GARCUNEIFORM SIGN" +
	" LAGAB TIMES A PLUS LALCUNEIFORM SIGN LAGAB TIMES ALCUNEIFORM SIGN LAGAB" +
	" TIMES ANCUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENUCUNEIFORM SIGN LAGAB TI" +
	"MES BADCUNEIFORM SIGN LAGAB TIMES BICUNEIFORM SIGN LAGAB TIMES DARCUNEIF" +
	"ORM SIGN LAGAB TIMES ENCUNEIFORM SIGN LAGAB TIMES GACUNEIFORM SIGN LAGAB" +
	" TIMES GARCUNEIFORM SIGN LAGAB TIMES GUDCUNEIFORM SIGN LAGAB TIMES GUD P" +
	"LUS GUDCUNEIFORM SIGN LAGAB TIMES HACUNEIFORM SIGN LAGAB TIMES HALCUNEIF" +
	"ORM SIGN LAGAB TIMES HI TIMES NUNCUNEIFORM SIGN LAGAB TIMES IGI GUNUCUNE" +
	"IFORM SIGN LAGAB TIMES IMCUNEIFORM SIGN LAGAB TIMES IM PLUS HACUNEIFORM " +
	"SIGN LAGAB TIMES IM PLUS LUCUNEIFORM SIGN LAGAB TIMES KICUNEIFORM SIGN L") + ("" +
	"AGAB TIMES KINCUNEIFORM SIGN LAGAB TIMES KU3CUNEIFORM SIGN LAGAB TIMES K" +
	"ULCUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS ACUNEIFORM SIGN LAGAB TIME" +
	"S LAGABCUNEIFORM SIGN LAGAB TIMES LISHCUNEIFORM SIGN LAGAB TIMES LUCUNEI" +
	"FORM SIGN LAGAB TIMES LULCUNEIFORM SIGN LAGAB TIMES MECUNEIFORM SIGN LAG" +
	"AB TIMES ME PLUS ENCUNEIFORM SIGN LAGAB TIMES MUSHCUNEIFORM SIGN LAGAB T" +
	"IMES NECUNEIFORM SIGN LAGAB TIMES SHE PLUS SUMCUNEIFORM SIGN LAGAB TIMES" +
	" SHITA PLUS GISH PLUS ERIN2CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH TE" +
	"NUCUNEIFORM SIGN LAGAB TIMES SHU2CUNEIFORM SIGN LAGAB TIMES SHU2 PLUS SH" +
	"U2CUNEIFORM SIGN LAGAB TIMES SUMCUNEIFORM SIGN LAGAB TIMES TAGCUNEIFORM " +
	"SIGN LAGAB TIMES TAK4CUNEIFORM SIGN LAGAB TIMES TE PLUS A PLUS SU PLUS N" +
	"ACUNEIFORM SIGN LAGAB TIMES UCUNEIFORM SIGN LAGAB TIMES U PLUS ACUNEIFOR" +
	"M SIGN LAGAB TIMES U PLUS U PLUS UCUNEIFORM SIGN LAGAB TIMES U2 PLUS ASH" +
	"CUNEIFORM SIGN LAGAB TIMES UDCUNEIFORM SIGN LAGAB TIMES USHCUNEIFORM SIG" +
	"N LAGAB SQUAREDCUNEIFORM SIGN LAGARCUNEIFORM SIGN LAGAR TIMES SHECUNEIFO" +
	"RM SIGN LAGAR TIMES SHE PLUS SUMCUNEIFORM SIGN LAGAR GUNUCUNEIFORM SIGN " +
	"LAGAR GUNU OVER LAGAR GUNU SHECUNEIFORM SIGN LAHSHUCUNEIFORM SIGN LALCUN" +
	"EIFORM SIGN LAL TIMES LALCUNEIFORM SIGN LAMCUNEIFORM SIGN LAM TIMES KURC" +
	"UNEIFORM SIGN LAM TIMES KUR PLUS RUCUNEIFORM SIGN LICUNEIFORM SIGN LILCU" +
	"NEIFORM SIGN LIMMU2CUNEIFORM SIGN LISHCUNEIFORM SIGN LUCUNEIFORM SIGN LU" +
	" TIMES BADCUNEIFORM SIGN LU2CUNEIFORM SIGN LU2 TIMES ALCUNEIFORM SIGN LU" +
	"2 TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2CUNEIFORM SIGN LU2 TIMES ESH2 TE" +
	"NUCUNEIFORM SIGN LU2 TIMES GAN2 TENUCUNEIFORM SIGN LU2 TIMES HI TIMES BA" +
	"DCUNEIFORM SIGN LU2 TIMES IMCUNEIFORM SIGN LU2 TIMES KAD2CUNEIFORM SIGN " +
	"LU2 TIMES KAD3CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASHCUNEIFORM SIGN LU2 T" +
	"IMES KICUNEIFORM SIGN LU2 TIMES LA PLUS ASHCUNEIFORM SIGN LU2 TIMES LAGA" +
	"BCUNEIFORM SIGN LU2 TIMES ME PLUS ENCUNEIFORM SIGN LU2 TIMES NECUNEIFORM" +
	" SIGN LU2 TIMES NUCUNEIFORM SIGN LU2 TIMES SI PLUS ASHCUNEIFORM SIGN LU2" +
	" TIMES SIK2 PLUS BUCUNEIFORM SIGN LU2 TIMES TUG2CUNEIFORM SIGN LU2 TENUC" +
	"UNEIFORM SIGN LU2 CROSSING LU2CUNEIFORM SIGN LU2 OPPOSING LU2CUNEIFORM S" +
	"IGN LU2 SQUAREDCUNEIFORM SIGN LU2 SHESHIGCUNEIFORM SIGN LU3CUNEIFORM SIG" +
	"N LUGALCUNEIFORM SIGN LUGAL OVER LUGALCUNEIFORM SIGN LUGAL OPPOSING LUGA" +
	"LCUNEIFORM SIGN LUGAL SHESHIGCUNEIFORM SIGN LUHCUNEIFORM SIGN LULCUNEIFO" +
	"RM SIGN LUMCUNEIFORM SIGN LUM OVER LUMCUNEIFORM SIGN LUM OVER LUM GAR OV" +
	"ER GARCUNEIFORM SIGN MACUNEIFORM SIGN MA TIMES TAK4CUNEIFORM SIGN MA GUN" +
	"UCUNEIFORM SIGN MA2CUNEIFORM SIGN MAHCUNEIFORM SIGN MARCUNEIFORM SIGN MA" +
	"SHCUNEIFORM SIGN MASH2CUNEIFORM SIGN MECUNEIFORM SIGN MESCUNEIFORM SIGN " +
	"MICUNEIFORM SIGN MINCUNEIFORM SIGN MUCUNEIFORM SIGN MU OVER MUCUNEIFORM " +
	"SIGN MUGCUNEIFORM SIGN MUG GUNUCUNEIFORM SIGN MUNSUBCUNEIFORM SIGN MURGU" +
	"2CUNEIFORM SIGN MUSHCUNEIFORM SIGN MUSH TIMES ACUNEIFORM SIGN MUSH TIMES" +
	" KURCUNEIFORM SIGN MUSH TIMES ZACUNEIFORM SIGN MUSH OVER MUSHCUNEIFORM S" +
	"IGN MUSH OVER MUSH TIMES A PLUS NACUNEIFORM SIGN MUSH CROSSING MUSHCUNEI" +
	"FORM SIGN MUSH3CUNEIFORM SIGN MUSH3 TIMES ACUNEIFORM SIGN MUSH3 TIMES A " +
	"PLUS DICUNEIFORM SIGN MUSH3 TIMES DICUNEIFORM SIGN MUSH3 GUNUCUNEIFORM S" +
	"IGN NACUNEIFORM SIGN NA2CUNEIFORM SIGN NAGACUNEIFORM SIGN NAGA INVERTEDC" +
	"UNEIFORM SIGN NAGA TIMES SHU TENUCUNEIFORM SIGN NAGA OPPOSING NAGACUNEIF" +
	"ORM SIGN NAGARCUNEIFORM SIGN NAM NUTILLUCUNEIFORM SIGN NAMCUNEIFORM SIGN" +
	" NAM2CUNEIFORM SIGN NECUNEIFORM SIGN NE TIMES ACUNEIFORM SIGN NE TIMES U" +
	"DCUNEIFORM SIGN NE SHESHIGCUNEIFORM SIGN NICUNEIFORM SIGN NI TIMES ECUNE" +
	"IFORM SIGN NI2CUNEIFORM SIGN NIMCUNEIFORM SIGN NIM TIMES GAN2 TENUCUNEIF" +
	"ORM SIGN NIM TIMES GAR PLUS GAN2 TENUCUNEIFORM SIGN NINDA2CUNEIFORM SIGN" +
	" NINDA2 TIMES ANCUNEIFORM SIGN NINDA2 TIMES ASHCUNEIFORM SIGN NINDA2 TIM" +
	"ES ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES GUDCUNEIFORM SIGN NINDA2 TIME" +
	"S ME PLUS GAN2 TENUCUNEIFORM SIGN NINDA2 TIMES NECUNEIFORM SIGN NINDA2 T" +
	"IMES NUNCUNEIFORM SIGN NINDA2 TIMES SHECUNEIFORM SIGN NINDA2 TIMES SHE P" +
	"LUS A ANCUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASHCUNEIFORM SIGN NINDA2 TI" +
	"MES SHE PLUS ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES U2 PLUS ASHCUNEIFOR" +
	"M SIGN NINDA2 TIMES USHCUNEIFORM SIGN NISAGCUNEIFORM SIGN NUCUNEIFORM SI" +
	"GN NU11CUNEIFORM SIGN NUNCUNEIFORM SIGN NUN LAGAR TIMES GARCUNEIFORM SIG" +
	"N NUN LAGAR TIMES MASHCUNEIFORM SIGN NUN LAGAR TIMES SALCUNEIFORM SIGN N" +
	"UN LAGAR TIMES SAL OVER NUN LAGAR TIMES SALCUNEIFORM SIGN NUN LAGAR TIME" +
	"S USHCUNEIFORM SIGN NUN TENUCUNEIFORM SIGN NUN OVER NUNCUNEIFORM SIGN NU" +
	"N CROSSING NUNCUNEIFORM SIGN NUN CROSSING NUN LAGAR OVER LAGARCUNEIFORM " +
	"SIGN NUNUZCUNEIFORM SIGN NUNUZ AB2 TIMES ASHGABCUNEIFORM SIGN NUNUZ AB2 " +
	"TIMES BICUNEIFORM SIGN NUNUZ AB2 TIMES DUGCUNEIFORM SIGN NUNUZ AB2 TIMES") + ("" +
	" GUDCUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNUCUNEIFORM SIGN NUNUZ AB2 TIME" +
	"S KAD3CUNEIFORM SIGN NUNUZ AB2 TIMES LACUNEIFORM SIGN NUNUZ AB2 TIMES NE" +
	"CUNEIFORM SIGN NUNUZ AB2 TIMES SILA3CUNEIFORM SIGN NUNUZ AB2 TIMES U2CUN" +
	"EIFORM SIGN NUNUZ KISIM5 TIMES BICUNEIFORM SIGN NUNUZ KISIM5 TIMES BI UC" +
	"UNEIFORM SIGN PACUNEIFORM SIGN PADCUNEIFORM SIGN PANCUNEIFORM SIGN PAPCU" +
	"NEIFORM SIGN PESH2CUNEIFORM SIGN PICUNEIFORM SIGN PI TIMES ACUNEIFORM SI" +
	"GN PI TIMES ABCUNEIFORM SIGN PI TIMES BICUNEIFORM SIGN PI TIMES BUCUNEIF" +
	"ORM SIGN PI TIMES ECUNEIFORM SIGN PI TIMES ICUNEIFORM SIGN PI TIMES IBCU" +
	"NEIFORM SIGN PI TIMES UCUNEIFORM SIGN PI TIMES U2CUNEIFORM SIGN PI CROSS" +
	"ING PICUNEIFORM SIGN PIRIGCUNEIFORM SIGN PIRIG TIMES KALCUNEIFORM SIGN P" +
	"IRIG TIMES UDCUNEIFORM SIGN PIRIG TIMES ZACUNEIFORM SIGN PIRIG OPPOSING " +
	"PIRIGCUNEIFORM SIGN RACUNEIFORM SIGN RABCUNEIFORM SIGN RICUNEIFORM SIGN " +
	"RUCUNEIFORM SIGN SACUNEIFORM SIGN SAG NUTILLUCUNEIFORM SIGN SAGCUNEIFORM" +
	" SIGN SAG TIMES ACUNEIFORM SIGN SAG TIMES DUCUNEIFORM SIGN SAG TIMES DUB" +
	"CUNEIFORM SIGN SAG TIMES HACUNEIFORM SIGN SAG TIMES KAKCUNEIFORM SIGN SA" +
	"G TIMES KURCUNEIFORM SIGN SAG TIMES LUMCUNEIFORM SIGN SAG TIMES MICUNEIF" +
	"ORM SIGN SAG TIMES NUNCUNEIFORM SIGN SAG TIMES SALCUNEIFORM SIGN SAG TIM" +
	"ES SHIDCUNEIFORM SIGN SAG TIMES TABCUNEIFORM SIGN SAG TIMES U2CUNEIFORM " +
	"SIGN SAG TIMES UBCUNEIFORM SIGN SAG TIMES UMCUNEIFORM SIGN SAG TIMES URC" +
	"UNEIFORM SIGN SAG TIMES USHCUNEIFORM SIGN SAG OVER SAGCUNEIFORM SIGN SAG" +
	" GUNUCUNEIFORM SIGN SALCUNEIFORM SIGN SAL LAGAB TIMES ASH2CUNEIFORM SIGN" +
	" SANGA2CUNEIFORM SIGN SARCUNEIFORM SIGN SHACUNEIFORM SIGN SHA3CUNEIFORM " +
	"SIGN SHA3 TIMES ACUNEIFORM SIGN SHA3 TIMES BADCUNEIFORM SIGN SHA3 TIMES " +
	"GISHCUNEIFORM SIGN SHA3 TIMES NECUNEIFORM SIGN SHA3 TIMES SHU2CUNEIFORM " +
	"SIGN SHA3 TIMES TURCUNEIFORM SIGN SHA3 TIMES UCUNEIFORM SIGN SHA3 TIMES " +
	"U PLUS ACUNEIFORM SIGN SHA6CUNEIFORM SIGN SHAB6CUNEIFORM SIGN SHAR2CUNEI" +
	"FORM SIGN SHECUNEIFORM SIGN SHE HUCUNEIFORM SIGN SHE OVER SHE GAD OVER G" +
	"AD GAR OVER GARCUNEIFORM SIGN SHE OVER SHE TAB OVER TAB GAR OVER GARCUNE" +
	"IFORM SIGN SHEG9CUNEIFORM SIGN SHENCUNEIFORM SIGN SHESHCUNEIFORM SIGN SH" +
	"ESH2CUNEIFORM SIGN SHESHLAMCUNEIFORM SIGN SHIDCUNEIFORM SIGN SHID TIMES " +
	"ACUNEIFORM SIGN SHID TIMES IMCUNEIFORM SIGN SHIMCUNEIFORM SIGN SHIM TIME" +
	"S ACUNEIFORM SIGN SHIM TIMES BALCUNEIFORM SIGN SHIM TIMES BULUGCUNEIFORM" +
	" SIGN SHIM TIMES DINCUNEIFORM SIGN SHIM TIMES GARCUNEIFORM SIGN SHIM TIM" +
	"ES IGICUNEIFORM SIGN SHIM TIMES IGI GUNUCUNEIFORM SIGN SHIM TIMES KUSHU2" +
	"CUNEIFORM SIGN SHIM TIMES LULCUNEIFORM SIGN SHIM TIMES MUGCUNEIFORM SIGN" +
	" SHIM TIMES SALCUNEIFORM SIGN SHINIGCUNEIFORM SIGN SHIRCUNEIFORM SIGN SH" +
	"IR TENUCUNEIFORM SIGN SHIR OVER SHIR BUR OVER BURCUNEIFORM SIGN SHITACUN" +
	"EIFORM SIGN SHUCUNEIFORM SIGN SHU OVER INVERTED SHUCUNEIFORM SIGN SHU2CU" +
	"NEIFORM SIGN SHUBURCUNEIFORM SIGN SICUNEIFORM SIGN SI GUNUCUNEIFORM SIGN" +
	" SIGCUNEIFORM SIGN SIG4CUNEIFORM SIGN SIG4 OVER SIG4 SHU2CUNEIFORM SIGN " +
	"SIK2CUNEIFORM SIGN SILA3CUNEIFORM SIGN SUCUNEIFORM SIGN SU OVER SUCUNEIF" +
	"ORM SIGN SUDCUNEIFORM SIGN SUD2CUNEIFORM SIGN SUHURCUNEIFORM SIGN SUMCUN" +
	"EIFORM SIGN SUMASHCUNEIFORM SIGN SURCUNEIFORM SIGN SUR9CUNEIFORM SIGN TA" +
	"CUNEIFORM SIGN TA ASTERISKCUNEIFORM SIGN TA TIMES HICUNEIFORM SIGN TA TI" +
	"MES MICUNEIFORM SIGN TA GUNUCUNEIFORM SIGN TABCUNEIFORM SIGN TAB OVER TA" +
	"B NI OVER NI DISH OVER DISHCUNEIFORM SIGN TAB SQUAREDCUNEIFORM SIGN TAGC" +
	"UNEIFORM SIGN TAG TIMES BICUNEIFORM SIGN TAG TIMES GUDCUNEIFORM SIGN TAG" +
	" TIMES SHECUNEIFORM SIGN TAG TIMES SHUCUNEIFORM SIGN TAG TIMES TUG2CUNEI" +
	"FORM SIGN TAG TIMES UDCUNEIFORM SIGN TAK4CUNEIFORM SIGN TARCUNEIFORM SIG" +
	"N TECUNEIFORM SIGN TE GUNUCUNEIFORM SIGN TICUNEIFORM SIGN TI TENUCUNEIFO" +
	"RM SIGN TILCUNEIFORM SIGN TIRCUNEIFORM SIGN TIR TIMES TAK4CUNEIFORM SIGN" +
	" TIR OVER TIRCUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER GARCUNEIF" +
	"ORM SIGN TUCUNEIFORM SIGN TUG2CUNEIFORM SIGN TUKCUNEIFORM SIGN TUMCUNEIF" +
	"ORM SIGN TURCUNEIFORM SIGN TUR OVER TUR ZA OVER ZACUNEIFORM SIGN UCUNEIF" +
	"ORM SIGN U GUDCUNEIFORM SIGN U U UCUNEIFORM SIGN U OVER U PA OVER PA GAR" +
	" OVER GARCUNEIFORM SIGN U OVER U SUR OVER SURCUNEIFORM SIGN U OVER U U R" +
	"EVERSED OVER U REVERSEDCUNEIFORM SIGN U2CUNEIFORM SIGN UBCUNEIFORM SIGN " +
	"UDCUNEIFORM SIGN UD KUSHU2CUNEIFORM SIGN UD TIMES BADCUNEIFORM SIGN UD T" +
	"IMES MICUNEIFORM SIGN UD TIMES U PLUS U PLUS UCUNEIFORM SIGN UD TIMES U " +
	"PLUS U PLUS U GUNUCUNEIFORM SIGN UD GUNUCUNEIFORM SIGN UD SHESHIGCUNEIFO" +
	"RM SIGN UD SHESHIG TIMES BADCUNEIFORM SIGN UDUGCUNEIFORM SIGN UMCUNEIFOR" +
	"M SIGN UM TIMES LAGABCUNEIFORM SIGN UM TIMES ME PLUS DACUNEIFORM SIGN UM" +
	" TIMES SHA3CUNEIFORM SIGN UM TIMES UCUNEIFORM SIGN UMBINCUNEIFORM SIGN U" +
	"MUMCUNEIFORM SIGN UMUM TIMES KASKALCUNEIFORM SIGN UMUM TIMES PACUNEIFORM") + ("" +
	" SIGN UNCUNEIFORM SIGN UN GUNUCUNEIFORM SIGN URCUNEIFORM SIGN UR CROSSIN" +
	"G URCUNEIFORM SIGN UR SHESHIGCUNEIFORM SIGN UR2CUNEIFORM SIGN UR2 TIMES " +
	"A PLUS HACUNEIFORM SIGN UR2 TIMES A PLUS NACUNEIFORM SIGN UR2 TIMES ALCU" +
	"NEIFORM SIGN UR2 TIMES HACUNEIFORM SIGN UR2 TIMES NUNCUNEIFORM SIGN UR2 " +
	"TIMES U2CUNEIFORM SIGN UR2 TIMES U2 PLUS ASHCUNEIFORM SIGN UR2 TIMES U2 " +
	"PLUS BICUNEIFORM SIGN UR4CUNEIFORM SIGN URICUNEIFORM SIGN URI3CUNEIFORM " +
	"SIGN URUCUNEIFORM SIGN URU TIMES ACUNEIFORM SIGN URU TIMES ASHGABCUNEIFO" +
	"RM SIGN URU TIMES BARCUNEIFORM SIGN URU TIMES DUNCUNEIFORM SIGN URU TIME" +
	"S GACUNEIFORM SIGN URU TIMES GALCUNEIFORM SIGN URU TIMES GAN2 TENUCUNEIF" +
	"ORM SIGN URU TIMES GARCUNEIFORM SIGN URU TIMES GUCUNEIFORM SIGN URU TIME" +
	"S HACUNEIFORM SIGN URU TIMES IGICUNEIFORM SIGN URU TIMES IMCUNEIFORM SIG" +
	"N URU TIMES ISHCUNEIFORM SIGN URU TIMES KICUNEIFORM SIGN URU TIMES LUMCU" +
	"NEIFORM SIGN URU TIMES MINCUNEIFORM SIGN URU TIMES PACUNEIFORM SIGN URU " +
	"TIMES SHECUNEIFORM SIGN URU TIMES SIG4CUNEIFORM SIGN URU TIMES TUCUNEIFO" +
	"RM SIGN URU TIMES U PLUS GUDCUNEIFORM SIGN URU TIMES UDCUNEIFORM SIGN UR" +
	"U TIMES URUDACUNEIFORM SIGN URUDACUNEIFORM SIGN URUDA TIMES UCUNEIFORM S" +
	"IGN USHCUNEIFORM SIGN USH TIMES ACUNEIFORM SIGN USH TIMES KUCUNEIFORM SI" +
	"GN USH TIMES KURCUNEIFORM SIGN USH TIMES TAK4CUNEIFORM SIGN USHXCUNEIFOR" +
	"M SIGN USH2CUNEIFORM SIGN USHUMXCUNEIFORM SIGN UTUKICUNEIFORM SIGN UZ3CU" +
	"NEIFORM SIGN UZ3 TIMES KASKALCUNEIFORM SIGN UZUCUNEIFORM SIGN ZACUNEIFOR" +
	"M SIGN ZA TENUCUNEIFORM SIGN ZA SQUARED TIMES KURCUNEIFORM SIGN ZAGCUNEI" +
	"FORM SIGN ZAMXCUNEIFORM SIGN ZE2CUNEIFORM SIGN ZICUNEIFORM SIGN ZI OVER " +
	"ZICUNEIFORM SIGN ZI3CUNEIFORM SIGN ZIBCUNEIFORM SIGN ZIB KABA TENUCUNEIF" +
	"ORM SIGN ZIGCUNEIFORM SIGN ZIZ2CUNEIFORM SIGN ZUCUNEIFORM SIGN ZU5CUNEIF" +
	"ORM SIGN ZU5 TIMES ACUNEIFORM SIGN ZUBURCUNEIFORM SIGN ZUMCUNEIFORM SIGN" +
	" KAP ELAMITECUNEIFORM SIGN AB TIMES NUNCUNEIFORM SIGN AB2 TIMES ACUNEIFO" +
	"RM SIGN AMAR TIMES KUGCUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS MASHCUNEIF" +
	"ORM SIGN DAG3CUNEIFORM SIGN DISH PLUS SHUCUNEIFORM SIGN DUB TIMES SHECUN" +
	"EIFORM SIGN EZEN TIMES GUDCUNEIFORM SIGN EZEN TIMES SHECUNEIFORM SIGN GA" +
	"2 TIMES AN PLUS KAK PLUS ACUNEIFORM SIGN GA2 TIMES ASH2CUNEIFORM SIGN GE" +
	"22CUNEIFORM SIGN GIGCUNEIFORM SIGN HUSHCUNEIFORM SIGN KA TIMES ANSHECUNE" +
	"IFORM SIGN KA TIMES ASH3CUNEIFORM SIGN KA TIMES GISHCUNEIFORM SIGN KA TI" +
	"MES GUDCUNEIFORM SIGN KA TIMES HI TIMES ASH2CUNEIFORM SIGN KA TIMES LUMC" +
	"UNEIFORM SIGN KA TIMES PACUNEIFORM SIGN KA TIMES SHULCUNEIFORM SIGN KA T" +
	"IMES TUCUNEIFORM SIGN KA TIMES UR2CUNEIFORM SIGN LAGAB TIMES GICUNEIFORM" +
	" SIGN LU2 SHESHIG TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2 PLUS LALCUNEIFO" +
	"RM SIGN LU2 TIMES SHUCUNEIFORM SIGN MESHCUNEIFORM SIGN MUSH3 TIMES ZACUN" +
	"EIFORM SIGN NA4CUNEIFORM SIGN NINCUNEIFORM SIGN NIN9CUNEIFORM SIGN NINDA" +
	"2 TIMES BALCUNEIFORM SIGN NINDA2 TIMES GICUNEIFORM SIGN NU11 ROTATED NIN" +
	"ETY DEGREESCUNEIFORM SIGN PESH2 ASTERISKCUNEIFORM SIGN PIR2CUNEIFORM SIG" +
	"N SAG TIMES IGI GUNUCUNEIFORM SIGN TI2CUNEIFORM SIGN UM TIMES MECUNEIFOR" +
	"M SIGN U UCUNEIFORM NUMERIC SIGN TWO ASHCUNEIFORM NUMERIC SIGN THREE ASH" +
	"CUNEIFORM NUMERIC SIGN FOUR ASHCUNEIFORM NUMERIC SIGN FIVE ASHCUNEIFORM " +
	"NUMERIC SIGN SIX ASHCUNEIFORM NUMERIC SIGN SEVEN ASHCUNEIFORM NUMERIC SI" +
	"GN EIGHT ASHCUNEIFORM NUMERIC SIGN NINE ASHCUNEIFORM NUMERIC SIGN THREE " +
	"DISHCUNEIFORM NUMERIC SIGN FOUR DISHCUNEIFORM NUMERIC SIGN FIVE DISHCUNE" +
	"IFORM NUMERIC SIGN SIX DISHCUNEIFORM NUMERIC SIGN SEVEN DISHCUNEIFORM NU" +
	"MERIC SIGN EIGHT DISHCUNEIFORM NUMERIC SIGN NINE DISHCUNEIFORM NUMERIC S" +
	"IGN FOUR UCUNEIFORM NUMERIC SIGN FIVE UCUNEIFORM NUMERIC SIGN SIX UCUNEI" +
	"FORM NUMERIC SIGN SEVEN UCUNEIFORM NUMERIC SIGN EIGHT UCUNEIFORM NUMERIC" +
	" SIGN NINE UCUNEIFORM NUMERIC SIGN ONE GESH2CUNEIFORM NUMERIC SIGN TWO G" +
	"ESH2CUNEIFORM NUMERIC SIGN THREE GESH2CUNEIFORM NUMERIC SIGN FOUR GESH2C" +
	"UNEIFORM NUMERIC SIGN FIVE GESH2CUNEIFORM NUMERIC SIGN SIX GESH2CUNEIFOR" +
	"M NUMERIC SIGN SEVEN GESH2CUNEIFORM NUMERIC SIGN EIGHT GESH2CUNEIFORM NU" +
	"MERIC SIGN NINE GESH2CUNEIFORM NUMERIC SIGN ONE GESHUCUNEIFORM NUMERIC S" +
	"IGN TWO GESHUCUNEIFORM NUMERIC SIGN THREE GESHUCUNEIFORM NUMERIC SIGN FO" +
	"UR GESHUCUNEIFORM NUMERIC SIGN FIVE GESHUCUNEIFORM NUMERIC SIGN TWO SHAR" +
	"2CUNEIFORM NUMERIC SIGN THREE SHAR2CUNEIFORM NUMERIC SIGN THREE SHAR2 VA" +
	"RIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHAR2CUNEIFORM NUMERIC SIGN FIVE S" +
	"HAR2CUNEIFORM NUMERIC SIGN SIX SHAR2CUNEIFORM NUMERIC SIGN SEVEN SHAR2CU" +
	"NEIFORM NUMERIC SIGN EIGHT SHAR2CUNEIFORM NUMERIC SIGN NINE SHAR2CUNEIFO" +
	"RM NUMERIC SIGN ONE SHARUCUNEIFORM NUMERIC SIGN TWO SHARUCUNEIFORM NUMER" +
	"IC SIGN THREE SHARUCUNEIFORM NUMERIC SIGN THREE SHARU VARIANT FORMCUNEIF" +
	"ORM NUMERIC SIGN FOUR SHARUCUNEIFORM NUMERIC SIGN FIVE SHARUCUNEIFORM NU") + ("" +
	"MERIC SIGN SHAR2 TIMES GAL PLUS DISHCUNEIFORM NUMERIC SIGN SHAR2 TIMES G" +
	"AL PLUS MINCUNEIFORM NUMERIC SIGN ONE BURUCUNEIFORM NUMERIC SIGN TWO BUR" +
	"UCUNEIFORM NUMERIC SIGN THREE BURUCUNEIFORM NUMERIC SIGN THREE BURU VARI" +
	"ANT FORMCUNEIFORM NUMERIC SIGN FOUR BURUCUNEIFORM NUMERIC SIGN FIVE BURU" +
	"CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16CUNEIFORM NUMERIC SIGN TH" +
	"REE VARIANT FORM ESH21CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMUCUNE" +
	"IFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4CUNEIFORM NUMERIC SIGN FOUR V" +
	"ARIANT FORM LIMMU ACUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU BCUNEI" +
	"FORM NUMERIC SIGN SIX VARIANT FORM ASH9CUNEIFORM NUMERIC SIGN SEVEN VARI" +
	"ANT FORM IMIN3CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN ACUNEIFORM " +
	"NUMERIC SIGN SEVEN VARIANT FORM IMIN BCUNEIFORM NUMERIC SIGN EIGHT VARIA" +
	"NT FORM USSUCUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3CUNEIFORM NUM" +
	"ERIC SIGN NINE VARIANT FORM ILIMMUCUNEIFORM NUMERIC SIGN NINE VARIANT FO" +
	"RM ILIMMU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4CUNEIFORM NUME" +
	"RIC SIGN NINE VARIANT FORM ILIMMU ACUNEIFORM NUMERIC SIGN TWO ASH TENUCU" +
	"NEIFORM NUMERIC SIGN THREE ASH TENUCUNEIFORM NUMERIC SIGN FOUR ASH TENUC" +
	"UNEIFORM NUMERIC SIGN FIVE ASH TENUCUNEIFORM NUMERIC SIGN SIX ASH TENUCU" +
	"NEIFORM NUMERIC SIGN ONE BAN2CUNEIFORM NUMERIC SIGN TWO BAN2CUNEIFORM NU" +
	"MERIC SIGN THREE BAN2CUNEIFORM NUMERIC SIGN FOUR BAN2CUNEIFORM NUMERIC S" +
	"IGN FOUR BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE BAN2CUNEIFORM NUME" +
	"RIC SIGN FIVE BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN NIGIDAMINCUNEIFORM" +
	" NUMERIC SIGN NIGIDAESHCUNEIFORM NUMERIC SIGN ONE ESHE3CUNEIFORM NUMERIC" +
	" SIGN TWO ESHE3CUNEIFORM NUMERIC SIGN ONE THIRD DISHCUNEIFORM NUMERIC SI" +
	"GN TWO THIRDS DISHCUNEIFORM NUMERIC SIGN FIVE SIXTHS DISHCUNEIFORM NUMER" +
	"IC SIGN ONE THIRD VARIANT FORM ACUNEIFORM NUMERIC SIGN TWO THIRDS VARIAN" +
	"T FORM ACUNEIFORM NUMERIC SIGN ONE EIGHTH ASHCUNEIFORM NUMERIC SIGN ONE " +
	"QUARTER ASHCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTHCUNEIFORM NUMERI" +
	"C SIGN OLD ASSYRIAN ONE QUARTERCUNEIFORM NUMERIC SIGN ONE QUARTER GURCUN" +
	"EIFORM NUMERIC SIGN ONE HALF GURCUNEIFORM NUMERIC SIGN ELAMITE ONE THIRD" +
	"CUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDSCUNEIFORM NUMERIC SIGN ELAMITE " +
	"FORTYCUNEIFORM NUMERIC SIGN ELAMITE FIFTYCUNEIFORM NUMERIC SIGN FOUR U V" +
	"ARIANT FORMCUNEIFORM NUMERIC SIGN FIVE U VARIANT FORMCUNEIFORM NUMERIC S" +
	"IGN SIX U VARIANT FORMCUNEIFORM NUMERIC SIGN SEVEN U VARIANT FORMCUNEIFO" +
	"RM NUMERIC SIGN EIGHT U VARIANT FORMCUNEIFORM NUMERIC SIGN NINE U VARIAN" +
	"T FORMCUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDERCUNEIFORM PUNC" +
	"TUATION SIGN VERTICAL COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL COLONCUNE" +
	"IFORM PUNCTUATION SIGN DIAGONAL TRICOLONCUNEIFORM PUNCTUATION SIGN DIAGO" +
	"NAL QUADCOLONCUNEIFORM SIGN AB TIMES NUN TENUCUNEIFORM SIGN AB TIMES SHU" +
	"2CUNEIFORM SIGN AD TIMES ESH2CUNEIFORM SIGN BAD TIMES DISH TENUCUNEIFORM" +
	" SIGN BAHAR2 TIMES AB2CUNEIFORM SIGN BAHAR2 TIMES NICUNEIFORM SIGN BAHAR" +
	"2 TIMES ZACUNEIFORM SIGN BU OVER BU TIMES NA2CUNEIFORM SIGN DA TIMES TAK" +
	"4CUNEIFORM SIGN DAG TIMES KURCUNEIFORM SIGN DIM TIMES IGICUNEIFORM SIGN " +
	"DIM TIMES U U UCUNEIFORM SIGN DIM2 TIMES UDCUNEIFORM SIGN DUG TIMES ANSH" +
	"ECUNEIFORM SIGN DUG TIMES ASHCUNEIFORM SIGN DUG TIMES ASH AT LEFTCUNEIFO" +
	"RM SIGN DUG TIMES DINCUNEIFORM SIGN DUG TIMES DUNCUNEIFORM SIGN DUG TIME" +
	"S ERIN2CUNEIFORM SIGN DUG TIMES GACUNEIFORM SIGN DUG TIMES GICUNEIFORM S" +
	"IGN DUG TIMES GIR2 GUNUCUNEIFORM SIGN DUG TIMES GISHCUNEIFORM SIGN DUG T" +
	"IMES HACUNEIFORM SIGN DUG TIMES HICUNEIFORM SIGN DUG TIMES IGI GUNUCUNEI" +
	"FORM SIGN DUG TIMES KASKALCUNEIFORM SIGN DUG TIMES KURCUNEIFORM SIGN DUG" +
	" TIMES KUSHU2CUNEIFORM SIGN DUG TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN D" +
	"UG TIMES LAK-020CUNEIFORM SIGN DUG TIMES LAMCUNEIFORM SIGN DUG TIMES LAM" +
	" TIMES KURCUNEIFORM SIGN DUG TIMES LUH PLUS GISHCUNEIFORM SIGN DUG TIMES" +
	" MASHCUNEIFORM SIGN DUG TIMES MESCUNEIFORM SIGN DUG TIMES MICUNEIFORM SI" +
	"GN DUG TIMES NICUNEIFORM SIGN DUG TIMES PICUNEIFORM SIGN DUG TIMES SHECU" +
	"NEIFORM SIGN DUG TIMES SI GUNUCUNEIFORM SIGN E2 TIMES KURCUNEIFORM SIGN " +
	"E2 TIMES PAPCUNEIFORM SIGN ERIN2 XCUNEIFORM SIGN ESH2 CROSSING ESH2CUNEI" +
	"FORM SIGN EZEN SHESHIG TIMES ASHCUNEIFORM SIGN EZEN SHESHIG TIMES HICUNE" +
	"IFORM SIGN EZEN SHESHIG TIMES IGI GUNUCUNEIFORM SIGN EZEN SHESHIG TIMES " +
	"LACUNEIFORM SIGN EZEN SHESHIG TIMES LALCUNEIFORM SIGN EZEN SHESHIG TIMES" +
	" MECUNEIFORM SIGN EZEN SHESHIG TIMES MESCUNEIFORM SIGN EZEN SHESHIG TIME" +
	"S SUCUNEIFORM SIGN EZEN TIMES SUCUNEIFORM SIGN GA2 TIMES BAHAR2CUNEIFORM" +
	" SIGN GA2 TIMES DIM GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES IGI GUNUCUNEI" +
	"FORM SIGN GA2 TIMES DUG TIMES KASKALCUNEIFORM SIGN GA2 TIMES ERENCUNEIFO" +
	"RM SIGN GA2 TIMES GACUNEIFORM SIGN GA2 TIMES GAR PLUS DICUNEIFORM SIGN G") + ("" +
	"A2 TIMES GAR PLUS NECUNEIFORM SIGN GA2 TIMES HA PLUS ACUNEIFORM SIGN GA2" +
	" TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN GA2 TIMES LAMCUNEIFORM SIGN GA2 " +
	"TIMES LAM TIMES KURCUNEIFORM SIGN GA2 TIMES LUHCUNEIFORM SIGN GA2 TIMES " +
	"MUSHCUNEIFORM SIGN GA2 TIMES NECUNEIFORM SIGN GA2 TIMES NE PLUS E2CUNEIF" +
	"ORM SIGN GA2 TIMES NE PLUS GICUNEIFORM SIGN GA2 TIMES SHIMCUNEIFORM SIGN" +
	" GA2 TIMES ZIZ2CUNEIFORM SIGN GABA ROTATED NINETY DEGREESCUNEIFORM SIGN " +
	"GESHTIN TIMES UCUNEIFORM SIGN GISH TIMES GISH CROSSING GISHCUNEIFORM SIG" +
	"N GU2 TIMES IGI GUNUCUNEIFORM SIGN GUD PLUS GISH TIMES TAK4CUNEIFORM SIG" +
	"N HA TENU GUNUCUNEIFORM SIGN HI TIMES ASH OVER HI TIMES ASHCUNEIFORM SIG" +
	"N KA TIMES BUCUNEIFORM SIGN KA TIMES KACUNEIFORM SIGN KA TIMES U U UCUNE" +
	"IFORM SIGN KA TIMES URCUNEIFORM SIGN LAGAB TIMES ZU OVER ZUCUNEIFORM SIG" +
	"N LAK-003CUNEIFORM SIGN LAK-021CUNEIFORM SIGN LAK-025CUNEIFORM SIGN LAK-" +
	"030CUNEIFORM SIGN LAK-050CUNEIFORM SIGN LAK-051CUNEIFORM SIGN LAK-062CUN" +
	"EIFORM SIGN LAK-079 OVER LAK-079 GUNUCUNEIFORM SIGN LAK-080CUNEIFORM SIG" +
	"N LAK-081 OVER LAK-081CUNEIFORM SIGN LAK-092CUNEIFORM SIGN LAK-130CUNEIF" +
	"ORM SIGN LAK-142CUNEIFORM SIGN LAK-210CUNEIFORM SIGN LAK-219CUNEIFORM SI" +
	"GN LAK-220CUNEIFORM SIGN LAK-225CUNEIFORM SIGN LAK-228CUNEIFORM SIGN LAK" +
	"-238CUNEIFORM SIGN LAK-265CUNEIFORM SIGN LAK-266CUNEIFORM SIGN LAK-343CU" +
	"NEIFORM SIGN LAK-347CUNEIFORM SIGN LAK-348CUNEIFORM SIGN LAK-383CUNEIFOR" +
	"M SIGN LAK-384CUNEIFORM SIGN LAK-390CUNEIFORM SIGN LAK-441CUNEIFORM SIGN" +
	" LAK-449CUNEIFORM SIGN LAK-449 TIMES GUCUNEIFORM SIGN LAK-449 TIMES IGIC" +
	"UNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3CUNEIFORM SIGN LAK-449 TIMES PAP" +
	" PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-449 TIMES U2 PLUS BACUNEIFORM SIGN " +
	"LAK-450CUNEIFORM SIGN LAK-457CUNEIFORM SIGN LAK-470CUNEIFORM SIGN LAK-48" +
	"3CUNEIFORM SIGN LAK-490CUNEIFORM SIGN LAK-492CUNEIFORM SIGN LAK-493CUNEI" +
	"FORM SIGN LAK-495CUNEIFORM SIGN LAK-550CUNEIFORM SIGN LAK-608CUNEIFORM S" +
	"IGN LAK-617CUNEIFORM SIGN LAK-617 TIMES ASHCUNEIFORM SIGN LAK-617 TIMES " +
	"BADCUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU GUNUCUNEIFORM SIGN LAK-617 TIM" +
	"ES KU3CUNEIFORM SIGN LAK-617 TIMES LACUNEIFORM SIGN LAK-617 TIMES TARCUN" +
	"EIFORM SIGN LAK-617 TIMES TECUNEIFORM SIGN LAK-617 TIMES U2CUNEIFORM SIG" +
	"N LAK-617 TIMES UDCUNEIFORM SIGN LAK-617 TIMES URUDACUNEIFORM SIGN LAK-6" +
	"36CUNEIFORM SIGN LAK-648CUNEIFORM SIGN LAK-648 TIMES DUBCUNEIFORM SIGN L" +
	"AK-648 TIMES GACUNEIFORM SIGN LAK-648 TIMES IGICUNEIFORM SIGN LAK-648 TI" +
	"MES IGI GUNUCUNEIFORM SIGN LAK-648 TIMES NICUNEIFORM SIGN LAK-648 TIMES " +
	"PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-648 TIMES SHESH PLUS KICUNEIFORM" +
	" SIGN LAK-648 TIMES UDCUNEIFORM SIGN LAK-648 TIMES URUDACUNEIFORM SIGN L" +
	"AK-724CUNEIFORM SIGN LAK-749CUNEIFORM SIGN LU2 GUNU TIMES ASHCUNEIFORM S" +
	"IGN LU2 TIMES DISHCUNEIFORM SIGN LU2 TIMES HALCUNEIFORM SIGN LU2 TIMES P" +
	"APCUNEIFORM SIGN LU2 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LU2 TIMES" +
	" TAK4CUNEIFORM SIGN MI PLUS ZA7CUNEIFORM SIGN MUSH OVER MUSH TIMES GACUN" +
	"EIFORM SIGN MUSH OVER MUSH TIMES KAKCUNEIFORM SIGN NINDA2 TIMES DIM GUNU" +
	"CUNEIFORM SIGN NINDA2 TIMES GISHCUNEIFORM SIGN NINDA2 TIMES GULCUNEIFORM" +
	" SIGN NINDA2 TIMES HICUNEIFORM SIGN NINDA2 TIMES KESH2CUNEIFORM SIGN NIN" +
	"DA2 TIMES LAK-050CUNEIFORM SIGN NINDA2 TIMES MASHCUNEIFORM SIGN NINDA2 T" +
	"IMES PAP PLUS PAPCUNEIFORM SIGN NINDA2 TIMES UCUNEIFORM SIGN NINDA2 TIME" +
	"S U PLUS UCUNEIFORM SIGN NINDA2 TIMES URUDACUNEIFORM SIGN SAG GUNU TIMES" +
	" HACUNEIFORM SIGN SAG TIMES ENCUNEIFORM SIGN SAG TIMES SHE AT LEFTCUNEIF" +
	"ORM SIGN SAG TIMES TAK4CUNEIFORM SIGN SHA6 TENUCUNEIFORM SIGN SHE OVER S" +
	"HECUNEIFORM SIGN SHE PLUS HUB2CUNEIFORM SIGN SHE PLUS NAM2CUNEIFORM SIGN" +
	" SHE PLUS SARCUNEIFORM SIGN SHU2 PLUS DUG TIMES NICUNEIFORM SIGN SHU2 PL" +
	"US E2 TIMES ANCUNEIFORM SIGN SI TIMES TAK4CUNEIFORM SIGN TAK4 PLUS SAGCU" +
	"NEIFORM SIGN TUM TIMES GAN2 TENUCUNEIFORM SIGN TUM TIMES THREE DISHCUNEI" +
	"FORM SIGN UR2 INVERTEDCUNEIFORM SIGN UR2 TIMES UDCUNEIFORM SIGN URU TIME" +
	"S DARA3CUNEIFORM SIGN URU TIMES LAK-668CUNEIFORM SIGN URU TIMES LU3CUNEI" +
	"FORM SIGN ZA7CUNEIFORM SIGN ZU OVER ZU PLUS SARCUNEIFORM SIGN ZU5 TIMES " +
	"THREE DISH TENUEGYPTIAN HIEROGLYPH A001EGYPTIAN HIEROGLYPH A002EGYPTIAN " +
	"HIEROGLYPH A003EGYPTIAN HIEROGLYPH A004EGYPTIAN HIEROGLYPH A005EGYPTIAN " +
	"HIEROGLYPH A005AEGYPTIAN HIEROGLYPH A006EGYPTIAN HIEROGLYPH A006AEGYPTIA" +
	"N HIEROGLYPH A006BEGYPTIAN HIEROGLYPH A007EGYPTIAN HIEROGLYPH A008EGYPTI" +
	"AN HIEROGLYPH A009EGYPTIAN HIEROGLYPH A010EGYPTIAN HIEROGLYPH A011EGYPTI" +
	"AN HIEROGLYPH A012EGYPTIAN HIEROGLYPH A013EGYPTIAN HIEROGLYPH A014EGYPTI" +
	"AN HIEROGLYPH A014AEGYPTIAN HIEROGLYPH A015EGYPTIAN HIEROGLYPH A016EGYPT" +
	"IAN HIEROGLYPH A017EGYPTIAN HIEROGLYPH A017AEGYPTIAN HIEROGLYPH A018EGYP" +
	"TIAN HIEROGLYPH A019EGYPTIAN HIEROGLYPH A020EGYPTIAN HIEROGLYPH A021EGYP") + ("" +
	"TIAN HIEROGLYPH A022EGYPTIAN HIEROGLYPH A023EGYPTIAN HIEROGLYPH A024EGYP" +
	"TIAN HIEROGLYPH A025EGYPTIAN HIEROGLYPH A026EGYPTIAN HIEROGLYPH A027EGYP" +
	"TIAN HIEROGLYPH A028EGYPTIAN HIEROGLYPH A029EGYPTIAN HIEROGLYPH A030EGYP" +
	"TIAN HIEROGLYPH A031EGYPTIAN HIEROGLYPH A032EGYPTIAN HIEROGLYPH A032AEGY" +
	"PTIAN HIEROGLYPH A033EGYPTIAN HIEROGLYPH A034EGYPTIAN HIEROGLYPH A035EGY" +
	"PTIAN HIEROGLYPH A036EGYPTIAN HIEROGLYPH A037EGYPTIAN HIEROGLYPH A038EGY" +
	"PTIAN HIEROGLYPH A039EGYPTIAN HIEROGLYPH A040EGYPTIAN HIEROGLYPH A040AEG" +
	"YPTIAN HIEROGLYPH A041EGYPTIAN HIEROGLYPH A042EGYPTIAN HIEROGLYPH A042AE" +
	"GYPTIAN HIEROGLYPH A043EGYPTIAN HIEROGLYPH A043AEGYPTIAN HIEROGLYPH A044" +
	"EGYPTIAN HIEROGLYPH A045EGYPTIAN HIEROGLYPH A045AEGYPTIAN HIEROGLYPH A04" +
	"6EGYPTIAN HIEROGLYPH A047EGYPTIAN HIEROGLYPH A048EGYPTIAN HIEROGLYPH A04" +
	"9EGYPTIAN HIEROGLYPH A050EGYPTIAN HIEROGLYPH A051EGYPTIAN HIEROGLYPH A05" +
	"2EGYPTIAN HIEROGLYPH A053EGYPTIAN HIEROGLYPH A054EGYPTIAN HIEROGLYPH A05" +
	"5EGYPTIAN HIEROGLYPH A056EGYPTIAN HIEROGLYPH A057EGYPTIAN HIEROGLYPH A05" +
	"8EGYPTIAN HIEROGLYPH A059EGYPTIAN HIEROGLYPH A060EGYPTIAN HIEROGLYPH A06" +
	"1EGYPTIAN HIEROGLYPH A062EGYPTIAN HIEROGLYPH A063EGYPTIAN HIEROGLYPH A06" +
	"4EGYPTIAN HIEROGLYPH A065EGYPTIAN HIEROGLYPH A066EGYPTIAN HIEROGLYPH A06" +
	"7EGYPTIAN HIEROGLYPH A068EGYPTIAN HIEROGLYPH A069EGYPTIAN HIEROGLYPH A07" +
	"0EGYPTIAN HIEROGLYPH B001EGYPTIAN HIEROGLYPH B002EGYPTIAN HIEROGLYPH B00" +
	"3EGYPTIAN HIEROGLYPH B004EGYPTIAN HIEROGLYPH B005EGYPTIAN HIEROGLYPH B00" +
	"5AEGYPTIAN HIEROGLYPH B006EGYPTIAN HIEROGLYPH B007EGYPTIAN HIEROGLYPH B0" +
	"08EGYPTIAN HIEROGLYPH B009EGYPTIAN HIEROGLYPH C001EGYPTIAN HIEROGLYPH C0" +
	"02EGYPTIAN HIEROGLYPH C002AEGYPTIAN HIEROGLYPH C002BEGYPTIAN HIEROGLYPH " +
	"C002CEGYPTIAN HIEROGLYPH C003EGYPTIAN HIEROGLYPH C004EGYPTIAN HIEROGLYPH" +
	" C005EGYPTIAN HIEROGLYPH C006EGYPTIAN HIEROGLYPH C007EGYPTIAN HIEROGLYPH" +
	" C008EGYPTIAN HIEROGLYPH C009EGYPTIAN HIEROGLYPH C010EGYPTIAN HIEROGLYPH" +
	" C010AEGYPTIAN HIEROGLYPH C011EGYPTIAN HIEROGLYPH C012EGYPTIAN HIEROGLYP" +
	"H C013EGYPTIAN HIEROGLYPH C014EGYPTIAN HIEROGLYPH C015EGYPTIAN HIEROGLYP" +
	"H C016EGYPTIAN HIEROGLYPH C017EGYPTIAN HIEROGLYPH C018EGYPTIAN HIEROGLYP" +
	"H C019EGYPTIAN HIEROGLYPH C020EGYPTIAN HIEROGLYPH C021EGYPTIAN HIEROGLYP" +
	"H C022EGYPTIAN HIEROGLYPH C023EGYPTIAN HIEROGLYPH C024EGYPTIAN HIEROGLYP" +
	"H D001EGYPTIAN HIEROGLYPH D002EGYPTIAN HIEROGLYPH D003EGYPTIAN HIEROGLYP" +
	"H D004EGYPTIAN HIEROGLYPH D005EGYPTIAN HIEROGLYPH D006EGYPTIAN HIEROGLYP" +
	"H D007EGYPTIAN HIEROGLYPH D008EGYPTIAN HIEROGLYPH D008AEGYPTIAN HIEROGLY" +
	"PH D009EGYPTIAN HIEROGLYPH D010EGYPTIAN HIEROGLYPH D011EGYPTIAN HIEROGLY" +
	"PH D012EGYPTIAN HIEROGLYPH D013EGYPTIAN HIEROGLYPH D014EGYPTIAN HIEROGLY" +
	"PH D015EGYPTIAN HIEROGLYPH D016EGYPTIAN HIEROGLYPH D017EGYPTIAN HIEROGLY" +
	"PH D018EGYPTIAN HIEROGLYPH D019EGYPTIAN HIEROGLYPH D020EGYPTIAN HIEROGLY" +
	"PH D021EGYPTIAN HIEROGLYPH D022EGYPTIAN HIEROGLYPH D023EGYPTIAN HIEROGLY" +
	"PH D024EGYPTIAN HIEROGLYPH D025EGYPTIAN HIEROGLYPH D026EGYPTIAN HIEROGLY" +
	"PH D027EGYPTIAN HIEROGLYPH D027AEGYPTIAN HIEROGLYPH D028EGYPTIAN HIEROGL" +
	"YPH D029EGYPTIAN HIEROGLYPH D030EGYPTIAN HIEROGLYPH D031EGYPTIAN HIEROGL" +
	"YPH D031AEGYPTIAN HIEROGLYPH D032EGYPTIAN HIEROGLYPH D033EGYPTIAN HIEROG" +
	"LYPH D034EGYPTIAN HIEROGLYPH D034AEGYPTIAN HIEROGLYPH D035EGYPTIAN HIERO" +
	"GLYPH D036EGYPTIAN HIEROGLYPH D037EGYPTIAN HIEROGLYPH D038EGYPTIAN HIERO" +
	"GLYPH D039EGYPTIAN HIEROGLYPH D040EGYPTIAN HIEROGLYPH D041EGYPTIAN HIERO" +
	"GLYPH D042EGYPTIAN HIEROGLYPH D043EGYPTIAN HIEROGLYPH D044EGYPTIAN HIERO" +
	"GLYPH D045EGYPTIAN HIEROGLYPH D046EGYPTIAN HIEROGLYPH D046AEGYPTIAN HIER" +
	"OGLYPH D047EGYPTIAN HIEROGLYPH D048EGYPTIAN HIEROGLYPH D048AEGYPTIAN HIE" +
	"ROGLYPH D049EGYPTIAN HIEROGLYPH D050EGYPTIAN HIEROGLYPH D050AEGYPTIAN HI" +
	"EROGLYPH D050BEGYPTIAN HIEROGLYPH D050CEGYPTIAN HIEROGLYPH D050DEGYPTIAN" +
	" HIEROGLYPH D050EEGYPTIAN HIEROGLYPH D050FEGYPTIAN HIEROGLYPH D050GEGYPT" +
	"IAN HIEROGLYPH D050HEGYPTIAN HIEROGLYPH D050IEGYPTIAN HIEROGLYPH D051EGY" +
	"PTIAN HIEROGLYPH D052EGYPTIAN HIEROGLYPH D052AEGYPTIAN HIEROGLYPH D053EG" +
	"YPTIAN HIEROGLYPH D054EGYPTIAN HIEROGLYPH D054AEGYPTIAN HIEROGLYPH D055E" +
	"GYPTIAN HIEROGLYPH D056EGYPTIAN HIEROGLYPH D057EGYPTIAN HIEROGLYPH D058E" +
	"GYPTIAN HIEROGLYPH D059EGYPTIAN HIEROGLYPH D060EGYPTIAN HIEROGLYPH D061E" +
	"GYPTIAN HIEROGLYPH D062EGYPTIAN HIEROGLYPH D063EGYPTIAN HIEROGLYPH D064E" +
	"GYPTIAN HIEROGLYPH D065EGYPTIAN HIEROGLYPH D066EGYPTIAN HIEROGLYPH D067E" +
	"GYPTIAN HIEROGLYPH D067AEGYPTIAN HIEROGLYPH D067BEGYPTIAN HIEROGLYPH D06" +
	"7CEGYPTIAN HIEROGLYPH D067DEGYPTIAN HIEROGLYPH D067EEGYPTIAN HIEROGLYPH " +
	"D067FEGYPTIAN HIEROGLYPH D067GEGYPTIAN HIEROGLYPH D067HEGYPTIAN HIEROGLY" +
	"PH E001EGYPTIAN HIEROGLYPH E002EGYPTIAN HIEROGLYPH E003EGYPTIAN HIEROGLY" +
	"PH E004EGYPTIAN HIEROGLYPH E005EGYPTIAN HIEROGLYPH E006EGYPTIAN HIEROGLY") + ("" +
	"PH E007EGYPTIAN HIEROGLYPH E008EGYPTIAN HIEROGLYPH E008AEGYPTIAN HIEROGL" +
	"YPH E009EGYPTIAN HIEROGLYPH E009AEGYPTIAN HIEROGLYPH E010EGYPTIAN HIEROG" +
	"LYPH E011EGYPTIAN HIEROGLYPH E012EGYPTIAN HIEROGLYPH E013EGYPTIAN HIEROG" +
	"LYPH E014EGYPTIAN HIEROGLYPH E015EGYPTIAN HIEROGLYPH E016EGYPTIAN HIEROG" +
	"LYPH E016AEGYPTIAN HIEROGLYPH E017EGYPTIAN HIEROGLYPH E017AEGYPTIAN HIER" +
	"OGLYPH E018EGYPTIAN HIEROGLYPH E019EGYPTIAN HIEROGLYPH E020EGYPTIAN HIER" +
	"OGLYPH E020AEGYPTIAN HIEROGLYPH E021EGYPTIAN HIEROGLYPH E022EGYPTIAN HIE" +
	"ROGLYPH E023EGYPTIAN HIEROGLYPH E024EGYPTIAN HIEROGLYPH E025EGYPTIAN HIE" +
	"ROGLYPH E026EGYPTIAN HIEROGLYPH E027EGYPTIAN HIEROGLYPH E028EGYPTIAN HIE" +
	"ROGLYPH E028AEGYPTIAN HIEROGLYPH E029EGYPTIAN HIEROGLYPH E030EGYPTIAN HI" +
	"EROGLYPH E031EGYPTIAN HIEROGLYPH E032EGYPTIAN HIEROGLYPH E033EGYPTIAN HI" +
	"EROGLYPH E034EGYPTIAN HIEROGLYPH E034AEGYPTIAN HIEROGLYPH E036EGYPTIAN H" +
	"IEROGLYPH E037EGYPTIAN HIEROGLYPH E038EGYPTIAN HIEROGLYPH F001EGYPTIAN H" +
	"IEROGLYPH F001AEGYPTIAN HIEROGLYPH F002EGYPTIAN HIEROGLYPH F003EGYPTIAN " +
	"HIEROGLYPH F004EGYPTIAN HIEROGLYPH F005EGYPTIAN HIEROGLYPH F006EGYPTIAN " +
	"HIEROGLYPH F007EGYPTIAN HIEROGLYPH F008EGYPTIAN HIEROGLYPH F009EGYPTIAN " +
	"HIEROGLYPH F010EGYPTIAN HIEROGLYPH F011EGYPTIAN HIEROGLYPH F012EGYPTIAN " +
	"HIEROGLYPH F013EGYPTIAN HIEROGLYPH F013AEGYPTIAN HIEROGLYPH F014EGYPTIAN" +
	" HIEROGLYPH F015EGYPTIAN HIEROGLYPH F016EGYPTIAN HIEROGLYPH F017EGYPTIAN" +
	" HIEROGLYPH F018EGYPTIAN HIEROGLYPH F019EGYPTIAN HIEROGLYPH F020EGYPTIAN" +
	" HIEROGLYPH F021EGYPTIAN HIEROGLYPH F021AEGYPTIAN HIEROGLYPH F022EGYPTIA" +
	"N HIEROGLYPH F023EGYPTIAN HIEROGLYPH F024EGYPTIAN HIEROGLYPH F025EGYPTIA" +
	"N HIEROGLYPH F026EGYPTIAN HIEROGLYPH F027EGYPTIAN HIEROGLYPH F028EGYPTIA" +
	"N HIEROGLYPH F029EGYPTIAN HIEROGLYPH F030EGYPTIAN HIEROGLYPH F031EGYPTIA" +
	"N HIEROGLYPH F031AEGYPTIAN HIEROGLYPH F032EGYPTIAN HIEROGLYPH F033EGYPTI" +
	"AN HIEROGLYPH F034EGYPTIAN HIEROGLYPH F035EGYPTIAN HIEROGLYPH F036EGYPTI" +
	"AN HIEROGLYPH F037EGYPTIAN HIEROGLYPH F037AEGYPTIAN HIEROGLYPH F038EGYPT" +
	"IAN HIEROGLYPH F038AEGYPTIAN HIEROGLYPH F039EGYPTIAN HIEROGLYPH F040EGYP" +
	"TIAN HIEROGLYPH F041EGYPTIAN HIEROGLYPH F042EGYPTIAN HIEROGLYPH F043EGYP" +
	"TIAN HIEROGLYPH F044EGYPTIAN HIEROGLYPH F045EGYPTIAN HIEROGLYPH F045AEGY" +
	"PTIAN HIEROGLYPH F046EGYPTIAN HIEROGLYPH F046AEGYPTIAN HIEROGLYPH F047EG" +
	"YPTIAN HIEROGLYPH F047AEGYPTIAN HIEROGLYPH F048EGYPTIAN HIEROGLYPH F049E" +
	"GYPTIAN HIEROGLYPH F050EGYPTIAN HIEROGLYPH F051EGYPTIAN HIEROGLYPH F051A" +
	"EGYPTIAN HIEROGLYPH F051BEGYPTIAN HIEROGLYPH F051CEGYPTIAN HIEROGLYPH F0" +
	"52EGYPTIAN HIEROGLYPH F053EGYPTIAN HIEROGLYPH G001EGYPTIAN HIEROGLYPH G0" +
	"02EGYPTIAN HIEROGLYPH G003EGYPTIAN HIEROGLYPH G004EGYPTIAN HIEROGLYPH G0" +
	"05EGYPTIAN HIEROGLYPH G006EGYPTIAN HIEROGLYPH G006AEGYPTIAN HIEROGLYPH G" +
	"007EGYPTIAN HIEROGLYPH G007AEGYPTIAN HIEROGLYPH G007BEGYPTIAN HIEROGLYPH" +
	" G008EGYPTIAN HIEROGLYPH G009EGYPTIAN HIEROGLYPH G010EGYPTIAN HIEROGLYPH" +
	" G011EGYPTIAN HIEROGLYPH G011AEGYPTIAN HIEROGLYPH G012EGYPTIAN HIEROGLYP" +
	"H G013EGYPTIAN HIEROGLYPH G014EGYPTIAN HIEROGLYPH G015EGYPTIAN HIEROGLYP" +
	"H G016EGYPTIAN HIEROGLYPH G017EGYPTIAN HIEROGLYPH G018EGYPTIAN HIEROGLYP" +
	"H G019EGYPTIAN HIEROGLYPH G020EGYPTIAN HIEROGLYPH G020AEGYPTIAN HIEROGLY" +
	"PH G021EGYPTIAN HIEROGLYPH G022EGYPTIAN HIEROGLYPH G023EGYPTIAN HIEROGLY" +
	"PH G024EGYPTIAN HIEROGLYPH G025EGYPTIAN HIEROGLYPH G026EGYPTIAN HIEROGLY" +
	"PH G026AEGYPTIAN HIEROGLYPH G027EGYPTIAN HIEROGLYPH G028EGYPTIAN HIEROGL" +
	"YPH G029EGYPTIAN HIEROGLYPH G030EGYPTIAN HIEROGLYPH G031EGYPTIAN HIEROGL" +
	"YPH G032EGYPTIAN HIEROGLYPH G033EGYPTIAN HIEROGLYPH G034EGYPTIAN HIEROGL" +
	"YPH G035EGYPTIAN HIEROGLYPH G036EGYPTIAN HIEROGLYPH G036AEGYPTIAN HIEROG" +
	"LYPH G037EGYPTIAN HIEROGLYPH G037AEGYPTIAN HIEROGLYPH G038EGYPTIAN HIERO" +
	"GLYPH G039EGYPTIAN HIEROGLYPH G040EGYPTIAN HIEROGLYPH G041EGYPTIAN HIERO" +
	"GLYPH G042EGYPTIAN HIEROGLYPH G043EGYPTIAN HIEROGLYPH G043AEGYPTIAN HIER" +
	"OGLYPH G044EGYPTIAN HIEROGLYPH G045EGYPTIAN HIEROGLYPH G045AEGYPTIAN HIE" +
	"ROGLYPH G046EGYPTIAN HIEROGLYPH G047EGYPTIAN HIEROGLYPH G048EGYPTIAN HIE" +
	"ROGLYPH G049EGYPTIAN HIEROGLYPH G050EGYPTIAN HIEROGLYPH G051EGYPTIAN HIE" +
	"ROGLYPH G052EGYPTIAN HIEROGLYPH G053EGYPTIAN HIEROGLYPH G054EGYPTIAN HIE" +
	"ROGLYPH H001EGYPTIAN HIEROGLYPH H002EGYPTIAN HIEROGLYPH H003EGYPTIAN HIE" +
	"ROGLYPH H004EGYPTIAN HIEROGLYPH H005EGYPTIAN HIEROGLYPH H006EGYPTIAN HIE" +
	"ROGLYPH H006AEGYPTIAN HIEROGLYPH H007EGYPTIAN HIEROGLYPH H008EGYPTIAN HI" +
	"EROGLYPH I001EGYPTIAN HIEROGLYPH I002EGYPTIAN HIEROGLYPH I003EGYPTIAN HI" +
	"EROGLYPH I004EGYPTIAN HIEROGLYPH I005EGYPTIAN HIEROGLYPH I005AEGYPTIAN H" +
	"IEROGLYPH I006EGYPTIAN HIEROGLYPH I007EGYPTIAN HIEROGLYPH I008EGYPTIAN H" +
	"IEROGLYPH I009EGYPTIAN HIEROGLYPH I009AEGYPTIAN HIEROGLYPH I010EGYPTIAN " +
	"HIEROGLYPH I010AEGYPTIAN HIEROGLYPH I011EGYPTIAN HIEROGLYPH I011AEGYPTIA") + ("" +
	"N HIEROGLYPH I012EGYPTIAN HIEROGLYPH I013EGYPTIAN HIEROGLYPH I014EGYPTIA" +
	"N HIEROGLYPH I015EGYPTIAN HIEROGLYPH K001EGYPTIAN HIEROGLYPH K002EGYPTIA" +
	"N HIEROGLYPH K003EGYPTIAN HIEROGLYPH K004EGYPTIAN HIEROGLYPH K005EGYPTIA" +
	"N HIEROGLYPH K006EGYPTIAN HIEROGLYPH K007EGYPTIAN HIEROGLYPH K008EGYPTIA" +
	"N HIEROGLYPH L001EGYPTIAN HIEROGLYPH L002EGYPTIAN HIEROGLYPH L002AEGYPTI" +
	"AN HIEROGLYPH L003EGYPTIAN HIEROGLYPH L004EGYPTIAN HIEROGLYPH L005EGYPTI" +
	"AN HIEROGLYPH L006EGYPTIAN HIEROGLYPH L006AEGYPTIAN HIEROGLYPH L007EGYPT" +
	"IAN HIEROGLYPH L008EGYPTIAN HIEROGLYPH M001EGYPTIAN HIEROGLYPH M001AEGYP" +
	"TIAN HIEROGLYPH M001BEGYPTIAN HIEROGLYPH M002EGYPTIAN HIEROGLYPH M003EGY" +
	"PTIAN HIEROGLYPH M003AEGYPTIAN HIEROGLYPH M004EGYPTIAN HIEROGLYPH M005EG" +
	"YPTIAN HIEROGLYPH M006EGYPTIAN HIEROGLYPH M007EGYPTIAN HIEROGLYPH M008EG" +
	"YPTIAN HIEROGLYPH M009EGYPTIAN HIEROGLYPH M010EGYPTIAN HIEROGLYPH M010AE" +
	"GYPTIAN HIEROGLYPH M011EGYPTIAN HIEROGLYPH M012EGYPTIAN HIEROGLYPH M012A" +
	"EGYPTIAN HIEROGLYPH M012BEGYPTIAN HIEROGLYPH M012CEGYPTIAN HIEROGLYPH M0" +
	"12DEGYPTIAN HIEROGLYPH M012EEGYPTIAN HIEROGLYPH M012FEGYPTIAN HIEROGLYPH" +
	" M012GEGYPTIAN HIEROGLYPH M012HEGYPTIAN HIEROGLYPH M013EGYPTIAN HIEROGLY" +
	"PH M014EGYPTIAN HIEROGLYPH M015EGYPTIAN HIEROGLYPH M015AEGYPTIAN HIEROGL" +
	"YPH M016EGYPTIAN HIEROGLYPH M016AEGYPTIAN HIEROGLYPH M017EGYPTIAN HIEROG" +
	"LYPH M017AEGYPTIAN HIEROGLYPH M018EGYPTIAN HIEROGLYPH M019EGYPTIAN HIERO" +
	"GLYPH M020EGYPTIAN HIEROGLYPH M021EGYPTIAN HIEROGLYPH M022EGYPTIAN HIERO" +
	"GLYPH M022AEGYPTIAN HIEROGLYPH M023EGYPTIAN HIEROGLYPH M024EGYPTIAN HIER" +
	"OGLYPH M024AEGYPTIAN HIEROGLYPH M025EGYPTIAN HIEROGLYPH M026EGYPTIAN HIE" +
	"ROGLYPH M027EGYPTIAN HIEROGLYPH M028EGYPTIAN HIEROGLYPH M028AEGYPTIAN HI" +
	"EROGLYPH M029EGYPTIAN HIEROGLYPH M030EGYPTIAN HIEROGLYPH M031EGYPTIAN HI" +
	"EROGLYPH M031AEGYPTIAN HIEROGLYPH M032EGYPTIAN HIEROGLYPH M033EGYPTIAN H" +
	"IEROGLYPH M033AEGYPTIAN HIEROGLYPH M033BEGYPTIAN HIEROGLYPH M034EGYPTIAN" +
	" HIEROGLYPH M035EGYPTIAN HIEROGLYPH M036EGYPTIAN HIEROGLYPH M037EGYPTIAN" +
	" HIEROGLYPH M038EGYPTIAN HIEROGLYPH M039EGYPTIAN HIEROGLYPH M040EGYPTIAN" +
	" HIEROGLYPH M040AEGYPTIAN HIEROGLYPH M041EGYPTIAN HIEROGLYPH M042EGYPTIA" +
	"N HIEROGLYPH M043EGYPTIAN HIEROGLYPH M044EGYPTIAN HIEROGLYPH N001EGYPTIA" +
	"N HIEROGLYPH N002EGYPTIAN HIEROGLYPH N003EGYPTIAN HIEROGLYPH N004EGYPTIA" +
	"N HIEROGLYPH N005EGYPTIAN HIEROGLYPH N006EGYPTIAN HIEROGLYPH N007EGYPTIA" +
	"N HIEROGLYPH N008EGYPTIAN HIEROGLYPH N009EGYPTIAN HIEROGLYPH N010EGYPTIA" +
	"N HIEROGLYPH N011EGYPTIAN HIEROGLYPH N012EGYPTIAN HIEROGLYPH N013EGYPTIA" +
	"N HIEROGLYPH N014EGYPTIAN HIEROGLYPH N015EGYPTIAN HIEROGLYPH N016EGYPTIA" +
	"N HIEROGLYPH N017EGYPTIAN HIEROGLYPH N018EGYPTIAN HIEROGLYPH N018AEGYPTI" +
	"AN HIEROGLYPH N018BEGYPTIAN HIEROGLYPH N019EGYPTIAN HIEROGLYPH N020EGYPT" +
	"IAN HIEROGLYPH N021EGYPTIAN HIEROGLYPH N022EGYPTIAN HIEROGLYPH N023EGYPT" +
	"IAN HIEROGLYPH N024EGYPTIAN HIEROGLYPH N025EGYPTIAN HIEROGLYPH N025AEGYP" +
	"TIAN HIEROGLYPH N026EGYPTIAN HIEROGLYPH N027EGYPTIAN HIEROGLYPH N028EGYP" +
	"TIAN HIEROGLYPH N029EGYPTIAN HIEROGLYPH N030EGYPTIAN HIEROGLYPH N031EGYP" +
	"TIAN HIEROGLYPH N032EGYPTIAN HIEROGLYPH N033EGYPTIAN HIEROGLYPH N033AEGY" +
	"PTIAN HIEROGLYPH N034EGYPTIAN HIEROGLYPH N034AEGYPTIAN HIEROGLYPH N035EG" +
	"YPTIAN HIEROGLYPH N035AEGYPTIAN HIEROGLYPH N036EGYPTIAN HIEROGLYPH N037E" +
	"GYPTIAN HIEROGLYPH N037AEGYPTIAN HIEROGLYPH N038EGYPTIAN HIEROGLYPH N039" +
	"EGYPTIAN HIEROGLYPH N040EGYPTIAN HIEROGLYPH N041EGYPTIAN HIEROGLYPH N042" +
	"EGYPTIAN HIEROGLYPH NL001EGYPTIAN HIEROGLYPH NL002EGYPTIAN HIEROGLYPH NL" +
	"003EGYPTIAN HIEROGLYPH NL004EGYPTIAN HIEROGLYPH NL005EGYPTIAN HIEROGLYPH" +
	" NL005AEGYPTIAN HIEROGLYPH NL006EGYPTIAN HIEROGLYPH NL007EGYPTIAN HIEROG" +
	"LYPH NL008EGYPTIAN HIEROGLYPH NL009EGYPTIAN HIEROGLYPH NL010EGYPTIAN HIE" +
	"ROGLYPH NL011EGYPTIAN HIEROGLYPH NL012EGYPTIAN HIEROGLYPH NL013EGYPTIAN " +
	"HIEROGLYPH NL014EGYPTIAN HIEROGLYPH NL015EGYPTIAN HIEROGLYPH NL016EGYPTI" +
	"AN HIEROGLYPH NL017EGYPTIAN HIEROGLYPH NL017AEGYPTIAN HIEROGLYPH NL018EG" +
	"YPTIAN HIEROGLYPH NL019EGYPTIAN HIEROGLYPH NL020EGYPTIAN HIEROGLYPH NU00" +
	"1EGYPTIAN HIEROGLYPH NU002EGYPTIAN HIEROGLYPH NU003EGYPTIAN HIEROGLYPH N" +
	"U004EGYPTIAN HIEROGLYPH NU005EGYPTIAN HIEROGLYPH NU006EGYPTIAN HIEROGLYP" +
	"H NU007EGYPTIAN HIEROGLYPH NU008EGYPTIAN HIEROGLYPH NU009EGYPTIAN HIEROG" +
	"LYPH NU010EGYPTIAN HIEROGLYPH NU010AEGYPTIAN HIEROGLYPH NU011EGYPTIAN HI" +
	"EROGLYPH NU011AEGYPTIAN HIEROGLYPH NU012EGYPTIAN HIEROGLYPH NU013EGYPTIA" +
	"N HIEROGLYPH NU014EGYPTIAN HIEROGLYPH NU015EGYPTIAN HIEROGLYPH NU016EGYP" +
	"TIAN HIEROGLYPH NU017EGYPTIAN HIEROGLYPH NU018EGYPTIAN HIEROGLYPH NU018A" +
	"EGYPTIAN HIEROGLYPH NU019EGYPTIAN HIEROGLYPH NU020EGYPTIAN HIEROGLYPH NU" +
	"021EGYPTIAN HIEROGLYPH NU022EGYPTIAN HIEROGLYPH NU022AEGYPTIAN HIEROGLYP" +
	"H O001EGYPTIAN HIEROGLYPH O001AEGYPTIAN HIEROGLYPH O002EGYPTIAN HIEROGLY") + ("" +
	"PH O003EGYPTIAN HIEROGLYPH O004EGYPTIAN HIEROGLYPH O005EGYPTIAN HIEROGLY" +
	"PH O005AEGYPTIAN HIEROGLYPH O006EGYPTIAN HIEROGLYPH O006AEGYPTIAN HIEROG" +
	"LYPH O006BEGYPTIAN HIEROGLYPH O006CEGYPTIAN HIEROGLYPH O006DEGYPTIAN HIE" +
	"ROGLYPH O006EEGYPTIAN HIEROGLYPH O006FEGYPTIAN HIEROGLYPH O007EGYPTIAN H" +
	"IEROGLYPH O008EGYPTIAN HIEROGLYPH O009EGYPTIAN HIEROGLYPH O010EGYPTIAN H" +
	"IEROGLYPH O010AEGYPTIAN HIEROGLYPH O010BEGYPTIAN HIEROGLYPH O010CEGYPTIA" +
	"N HIEROGLYPH O011EGYPTIAN HIEROGLYPH O012EGYPTIAN HIEROGLYPH O013EGYPTIA" +
	"N HIEROGLYPH O014EGYPTIAN HIEROGLYPH O015EGYPTIAN HIEROGLYPH O016EGYPTIA" +
	"N HIEROGLYPH O017EGYPTIAN HIEROGLYPH O018EGYPTIAN HIEROGLYPH O019EGYPTIA" +
	"N HIEROGLYPH O019AEGYPTIAN HIEROGLYPH O020EGYPTIAN HIEROGLYPH O020AEGYPT" +
	"IAN HIEROGLYPH O021EGYPTIAN HIEROGLYPH O022EGYPTIAN HIEROGLYPH O023EGYPT" +
	"IAN HIEROGLYPH O024EGYPTIAN HIEROGLYPH O024AEGYPTIAN HIEROGLYPH O025EGYP" +
	"TIAN HIEROGLYPH O025AEGYPTIAN HIEROGLYPH O026EGYPTIAN HIEROGLYPH O027EGY" +
	"PTIAN HIEROGLYPH O028EGYPTIAN HIEROGLYPH O029EGYPTIAN HIEROGLYPH O029AEG" +
	"YPTIAN HIEROGLYPH O030EGYPTIAN HIEROGLYPH O030AEGYPTIAN HIEROGLYPH O031E" +
	"GYPTIAN HIEROGLYPH O032EGYPTIAN HIEROGLYPH O033EGYPTIAN HIEROGLYPH O033A" +
	"EGYPTIAN HIEROGLYPH O034EGYPTIAN HIEROGLYPH O035EGYPTIAN HIEROGLYPH O036" +
	"EGYPTIAN HIEROGLYPH O036AEGYPTIAN HIEROGLYPH O036BEGYPTIAN HIEROGLYPH O0" +
	"36CEGYPTIAN HIEROGLYPH O036DEGYPTIAN HIEROGLYPH O037EGYPTIAN HIEROGLYPH " +
	"O038EGYPTIAN HIEROGLYPH O039EGYPTIAN HIEROGLYPH O040EGYPTIAN HIEROGLYPH " +
	"O041EGYPTIAN HIEROGLYPH O042EGYPTIAN HIEROGLYPH O043EGYPTIAN HIEROGLYPH " +
	"O044EGYPTIAN HIEROGLYPH O045EGYPTIAN HIEROGLYPH O046EGYPTIAN HIEROGLYPH " +
	"O047EGYPTIAN HIEROGLYPH O048EGYPTIAN HIEROGLYPH O049EGYPTIAN HIEROGLYPH " +
	"O050EGYPTIAN HIEROGLYPH O050AEGYPTIAN HIEROGLYPH O050BEGYPTIAN HIEROGLYP" +
	"H O051EGYPTIAN HIEROGLYPH P001EGYPTIAN HIEROGLYPH P001AEGYPTIAN HIEROGLY" +
	"PH P002EGYPTIAN HIEROGLYPH P003EGYPTIAN HIEROGLYPH P003AEGYPTIAN HIEROGL" +
	"YPH P004EGYPTIAN HIEROGLYPH P005EGYPTIAN HIEROGLYPH P006EGYPTIAN HIEROGL" +
	"YPH P007EGYPTIAN HIEROGLYPH P008EGYPTIAN HIEROGLYPH P009EGYPTIAN HIEROGL" +
	"YPH P010EGYPTIAN HIEROGLYPH P011EGYPTIAN HIEROGLYPH Q001EGYPTIAN HIEROGL" +
	"YPH Q002EGYPTIAN HIEROGLYPH Q003EGYPTIAN HIEROGLYPH Q004EGYPTIAN HIEROGL" +
	"YPH Q005EGYPTIAN HIEROGLYPH Q006EGYPTIAN HIEROGLYPH Q007EGYPTIAN HIEROGL" +
	"YPH R001EGYPTIAN HIEROGLYPH R002EGYPTIAN HIEROGLYPH R002AEGYPTIAN HIEROG" +
	"LYPH R003EGYPTIAN HIEROGLYPH R003AEGYPTIAN HIEROGLYPH R003BEGYPTIAN HIER" +
	"OGLYPH R004EGYPTIAN HIEROGLYPH R005EGYPTIAN HIEROGLYPH R006EGYPTIAN HIER" +
	"OGLYPH R007EGYPTIAN HIEROGLYPH R008EGYPTIAN HIEROGLYPH R009EGYPTIAN HIER" +
	"OGLYPH R010EGYPTIAN HIEROGLYPH R010AEGYPTIAN HIEROGLYPH R011EGYPTIAN HIE" +
	"ROGLYPH R012EGYPTIAN HIEROGLYPH R013EGYPTIAN HIEROGLYPH R014EGYPTIAN HIE" +
	"ROGLYPH R015EGYPTIAN HIEROGLYPH R016EGYPTIAN HIEROGLYPH R016AEGYPTIAN HI" +
	"EROGLYPH R017EGYPTIAN HIEROGLYPH R018EGYPTIAN HIEROGLYPH R019EGYPTIAN HI" +
	"EROGLYPH R020EGYPTIAN HIEROGLYPH R021EGYPTIAN HIEROGLYPH R022EGYPTIAN HI" +
	"EROGLYPH R023EGYPTIAN HIEROGLYPH R024EGYPTIAN HIEROGLYPH R025EGYPTIAN HI" +
	"EROGLYPH R026EGYPTIAN HIEROGLYPH R027EGYPTIAN HIEROGLYPH R028EGYPTIAN HI" +
	"EROGLYPH R029EGYPTIAN HIEROGLYPH S001EGYPTIAN HIEROGLYPH S002EGYPTIAN HI" +
	"EROGLYPH S002AEGYPTIAN HIEROGLYPH S003EGYPTIAN HIEROGLYPH S004EGYPTIAN H" +
	"IEROGLYPH S005EGYPTIAN HIEROGLYPH S006EGYPTIAN HIEROGLYPH S006AEGYPTIAN " +
	"HIEROGLYPH S007EGYPTIAN HIEROGLYPH S008EGYPTIAN HIEROGLYPH S009EGYPTIAN " +
	"HIEROGLYPH S010EGYPTIAN HIEROGLYPH S011EGYPTIAN HIEROGLYPH S012EGYPTIAN " +
	"HIEROGLYPH S013EGYPTIAN HIEROGLYPH S014EGYPTIAN HIEROGLYPH S014AEGYPTIAN" +
	" HIEROGLYPH S014BEGYPTIAN HIEROGLYPH S015EGYPTIAN HIEROGLYPH S016EGYPTIA" +
	"N HIEROGLYPH S017EGYPTIAN HIEROGLYPH S017AEGYPTIAN HIEROGLYPH S018EGYPTI" +
	"AN HIEROGLYPH S019EGYPTIAN HIEROGLYPH S020EGYPTIAN HIEROGLYPH S021EGYPTI" +
	"AN HIEROGLYPH S022EGYPTIAN HIEROGLYPH S023EGYPTIAN HIEROGLYPH S024EGYPTI" +
	"AN HIEROGLYPH S025EGYPTIAN HIEROGLYPH S026EGYPTIAN HIEROGLYPH S026AEGYPT" +
	"IAN HIEROGLYPH S026BEGYPTIAN HIEROGLYPH S027EGYPTIAN HIEROGLYPH S028EGYP" +
	"TIAN HIEROGLYPH S029EGYPTIAN HIEROGLYPH S030EGYPTIAN HIEROGLYPH S031EGYP" +
	"TIAN HIEROGLYPH S032EGYPTIAN HIEROGLYPH S033EGYPTIAN HIEROGLYPH S034EGYP" +
	"TIAN HIEROGLYPH S035EGYPTIAN HIEROGLYPH S035AEGYPTIAN HIEROGLYPH S036EGY" +
	"PTIAN HIEROGLYPH S037EGYPTIAN HIEROGLYPH S038EGYPTIAN HIEROGLYPH S039EGY" +
	"PTIAN HIEROGLYPH S040EGYPTIAN HIEROGLYPH S041EGYPTIAN HIEROGLYPH S042EGY" +
	"PTIAN HIEROGLYPH S043EGYPTIAN HIEROGLYPH S044EGYPTIAN HIEROGLYPH S045EGY" +
	"PTIAN HIEROGLYPH S046EGYPTIAN HIEROGLYPH T001EGYPTIAN HIEROGLYPH T002EGY" +
	"PTIAN HIEROGLYPH T003EGYPTIAN HIEROGLYPH T003AEGYPTIAN HIEROGLYPH T004EG" +
	"YPTIAN HIEROGLYPH T005EGYPTIAN HIEROGLYPH T006EGYPTIAN HIEROGLYPH T007EG" +
	"YPTIAN HIEROGLYPH T007AEGYPTIAN HIEROGLYPH T008EGYPTIAN HIEROGLYPH T008A") + ("" +
	"EGYPTIAN HIEROGLYPH T009EGYPTIAN HIEROGLYPH T009AEGYPTIAN HIEROGLYPH T01" +
	"0EGYPTIAN HIEROGLYPH T011EGYPTIAN HIEROGLYPH T011AEGYPTIAN HIEROGLYPH T0" +
	"12EGYPTIAN HIEROGLYPH T013EGYPTIAN HIEROGLYPH T014EGYPTIAN HIEROGLYPH T0" +
	"15EGYPTIAN HIEROGLYPH T016EGYPTIAN HIEROGLYPH T016AEGYPTIAN HIEROGLYPH T" +
	"017EGYPTIAN HIEROGLYPH T018EGYPTIAN HIEROGLYPH T019EGYPTIAN HIEROGLYPH T" +
	"020EGYPTIAN HIEROGLYPH T021EGYPTIAN HIEROGLYPH T022EGYPTIAN HIEROGLYPH T" +
	"023EGYPTIAN HIEROGLYPH T024EGYPTIAN HIEROGLYPH T025EGYPTIAN HIEROGLYPH T" +
	"026EGYPTIAN HIEROGLYPH T027EGYPTIAN HIEROGLYPH T028EGYPTIAN HIEROGLYPH T" +
	"029EGYPTIAN HIEROGLYPH T030EGYPTIAN HIEROGLYPH T031EGYPTIAN HIEROGLYPH T" +
	"032EGYPTIAN HIEROGLYPH T032AEGYPTIAN HIEROGLYPH T033EGYPTIAN HIEROGLYPH " +
	"T033AEGYPTIAN HIEROGLYPH T034EGYPTIAN HIEROGLYPH T035EGYPTIAN HIEROGLYPH" +
	" T036EGYPTIAN HIEROGLYPH U001EGYPTIAN HIEROGLYPH U002EGYPTIAN HIEROGLYPH" +
	" U003EGYPTIAN HIEROGLYPH U004EGYPTIAN HIEROGLYPH U005EGYPTIAN HIEROGLYPH" +
	" U006EGYPTIAN HIEROGLYPH U006AEGYPTIAN HIEROGLYPH U006BEGYPTIAN HIEROGLY" +
	"PH U007EGYPTIAN HIEROGLYPH U008EGYPTIAN HIEROGLYPH U009EGYPTIAN HIEROGLY" +
	"PH U010EGYPTIAN HIEROGLYPH U011EGYPTIAN HIEROGLYPH U012EGYPTIAN HIEROGLY" +
	"PH U013EGYPTIAN HIEROGLYPH U014EGYPTIAN HIEROGLYPH U015EGYPTIAN HIEROGLY" +
	"PH U016EGYPTIAN HIEROGLYPH U017EGYPTIAN HIEROGLYPH U018EGYPTIAN HIEROGLY" +
	"PH U019EGYPTIAN HIEROGLYPH U020EGYPTIAN HIEROGLYPH U021EGYPTIAN HIEROGLY" +
	"PH U022EGYPTIAN HIEROGLYPH U023EGYPTIAN HIEROGLYPH U023AEGYPTIAN HIEROGL" +
	"YPH U024EGYPTIAN HIEROGLYPH U025EGYPTIAN HIEROGLYPH U026EGYPTIAN HIEROGL" +
	"YPH U027EGYPTIAN HIEROGLYPH U028EGYPTIAN HIEROGLYPH U029EGYPTIAN HIEROGL" +
	"YPH U029AEGYPTIAN HIEROGLYPH U030EGYPTIAN HIEROGLYPH U031EGYPTIAN HIEROG" +
	"LYPH U032EGYPTIAN HIEROGLYPH U032AEGYPTIAN HIEROGLYPH U033EGYPTIAN HIERO" +
	"GLYPH U034EGYPTIAN HIEROGLYPH U035EGYPTIAN HIEROGLYPH U036EGYPTIAN HIERO" +
	"GLYPH U037EGYPTIAN HIEROGLYPH U038EGYPTIAN HIEROGLYPH U039EGYPTIAN HIERO" +
	"GLYPH U040EGYPTIAN HIEROGLYPH U041EGYPTIAN HIEROGLYPH U042EGYPTIAN HIERO" +
	"GLYPH V001EGYPTIAN HIEROGLYPH V001AEGYPTIAN HIEROGLYPH V001BEGYPTIAN HIE" +
	"ROGLYPH V001CEGYPTIAN HIEROGLYPH V001DEGYPTIAN HIEROGLYPH V001EEGYPTIAN " +
	"HIEROGLYPH V001FEGYPTIAN HIEROGLYPH V001GEGYPTIAN HIEROGLYPH V001HEGYPTI" +
	"AN HIEROGLYPH V001IEGYPTIAN HIEROGLYPH V002EGYPTIAN HIEROGLYPH V002AEGYP" +
	"TIAN HIEROGLYPH V003EGYPTIAN HIEROGLYPH V004EGYPTIAN HIEROGLYPH V005EGYP" +
	"TIAN HIEROGLYPH V006EGYPTIAN HIEROGLYPH V007EGYPTIAN HIEROGLYPH V007AEGY" +
	"PTIAN HIEROGLYPH V007BEGYPTIAN HIEROGLYPH V008EGYPTIAN HIEROGLYPH V009EG" +
	"YPTIAN HIEROGLYPH V010EGYPTIAN HIEROGLYPH V011EGYPTIAN HIEROGLYPH V011AE" +
	"GYPTIAN HIEROGLYPH V011BEGYPTIAN HIEROGLYPH V011CEGYPTIAN HIEROGLYPH V01" +
	"2EGYPTIAN HIEROGLYPH V012AEGYPTIAN HIEROGLYPH V012BEGYPTIAN HIEROGLYPH V" +
	"013EGYPTIAN HIEROGLYPH V014EGYPTIAN HIEROGLYPH V015EGYPTIAN HIEROGLYPH V" +
	"016EGYPTIAN HIEROGLYPH V017EGYPTIAN HIEROGLYPH V018EGYPTIAN HIEROGLYPH V" +
	"019EGYPTIAN HIEROGLYPH V020EGYPTIAN HIEROGLYPH V020AEGYPTIAN HIEROGLYPH " +
	"V020BEGYPTIAN HIEROGLYPH V020CEGYPTIAN HIEROGLYPH V020DEGYPTIAN HIEROGLY" +
	"PH V020EEGYPTIAN HIEROGLYPH V020FEGYPTIAN HIEROGLYPH V020GEGYPTIAN HIERO" +
	"GLYPH V020HEGYPTIAN HIEROGLYPH V020IEGYPTIAN HIEROGLYPH V020JEGYPTIAN HI" +
	"EROGLYPH V020KEGYPTIAN HIEROGLYPH V020LEGYPTIAN HIEROGLYPH V021EGYPTIAN " +
	"HIEROGLYPH V022EGYPTIAN HIEROGLYPH V023EGYPTIAN HIEROGLYPH V023AEGYPTIAN" +
	" HIEROGLYPH V024EGYPTIAN HIEROGLYPH V025EGYPTIAN HIEROGLYPH V026EGYPTIAN" +
	" HIEROGLYPH V027EGYPTIAN HIEROGLYPH V028EGYPTIAN HIEROGLYPH V028AEGYPTIA" +
	"N HIEROGLYPH V029EGYPTIAN HIEROGLYPH V029AEGYPTIAN HIEROGLYPH V030EGYPTI" +
	"AN HIEROGLYPH V030AEGYPTIAN HIEROGLYPH V031EGYPTIAN HIEROGLYPH V031AEGYP" +
	"TIAN HIEROGLYPH V032EGYPTIAN HIEROGLYPH V033EGYPTIAN HIEROGLYPH V033AEGY" +
	"PTIAN HIEROGLYPH V034EGYPTIAN HIEROGLYPH V035EGYPTIAN HIEROGLYPH V036EGY" +
	"PTIAN HIEROGLYPH V037EGYPTIAN HIEROGLYPH V037AEGYPTIAN HIEROGLYPH V038EG" +
	"YPTIAN HIEROGLYPH V039EGYPTIAN HIEROGLYPH V040EGYPTIAN HIEROGLYPH V040AE" +
	"GYPTIAN HIEROGLYPH W001EGYPTIAN HIEROGLYPH W002EGYPTIAN HIEROGLYPH W003E" +
	"GYPTIAN HIEROGLYPH W003AEGYPTIAN HIEROGLYPH W004EGYPTIAN HIEROGLYPH W005" +
	"EGYPTIAN HIEROGLYPH W006EGYPTIAN HIEROGLYPH W007EGYPTIAN HIEROGLYPH W008" +
	"EGYPTIAN HIEROGLYPH W009EGYPTIAN HIEROGLYPH W009AEGYPTIAN HIEROGLYPH W01" +
	"0EGYPTIAN HIEROGLYPH W010AEGYPTIAN HIEROGLYPH W011EGYPTIAN HIEROGLYPH W0" +
	"12EGYPTIAN HIEROGLYPH W013EGYPTIAN HIEROGLYPH W014EGYPTIAN HIEROGLYPH W0" +
	"14AEGYPTIAN HIEROGLYPH W015EGYPTIAN HIEROGLYPH W016EGYPTIAN HIEROGLYPH W" +
	"017EGYPTIAN HIEROGLYPH W017AEGYPTIAN HIEROGLYPH W018EGYPTIAN HIEROGLYPH " +
	"W018AEGYPTIAN HIEROGLYPH W019EGYPTIAN HIEROGLYPH W020EGYPTIAN HIEROGLYPH" +
	" W021EGYPTIAN HIEROGLYPH W022EGYPTIAN HIEROGLYPH W023EGYPTIAN HIEROGLYPH" +
	" W024EGYPTIAN HIEROGLYPH W024AEGYPTIAN HIEROGLYPH W025EGYPTIAN HIEROGLYP") + ("" +
	"H X001EGYPTIAN HIEROGLYPH X002EGYPTIAN HIEROGLYPH X003EGYPTIAN HIEROGLYP" +
	"H X004EGYPTIAN HIEROGLYPH X004AEGYPTIAN HIEROGLYPH X004BEGYPTIAN HIEROGL" +
	"YPH X005EGYPTIAN HIEROGLYPH X006EGYPTIAN HIEROGLYPH X006AEGYPTIAN HIEROG" +
	"LYPH X007EGYPTIAN HIEROGLYPH X008EGYPTIAN HIEROGLYPH X008AEGYPTIAN HIERO" +
	"GLYPH Y001EGYPTIAN HIEROGLYPH Y001AEGYPTIAN HIEROGLYPH Y002EGYPTIAN HIER" +
	"OGLYPH Y003EGYPTIAN HIEROGLYPH Y004EGYPTIAN HIEROGLYPH Y005EGYPTIAN HIER" +
	"OGLYPH Y006EGYPTIAN HIEROGLYPH Y007EGYPTIAN HIEROGLYPH Y008EGYPTIAN HIER" +
	"OGLYPH Z001EGYPTIAN HIEROGLYPH Z002EGYPTIAN HIEROGLYPH Z002AEGYPTIAN HIE" +
	"ROGLYPH Z002BEGYPTIAN HIEROGLYPH Z002CEGYPTIAN HIEROGLYPH Z002DEGYPTIAN " +
	"HIEROGLYPH Z003EGYPTIAN HIEROGLYPH Z003AEGYPTIAN HIEROGLYPH Z003BEGYPTIA" +
	"N HIEROGLYPH Z004EGYPTIAN HIEROGLYPH Z004AEGYPTIAN HIEROGLYPH Z005EGYPTI" +
	"AN HIEROGLYPH Z005AEGYPTIAN HIEROGLYPH Z006EGYPTIAN HIEROGLYPH Z007EGYPT" +
	"IAN HIEROGLYPH Z008EGYPTIAN HIEROGLYPH Z009EGYPTIAN HIEROGLYPH Z010EGYPT" +
	"IAN HIEROGLYPH Z011EGYPTIAN HIEROGLYPH Z012EGYPTIAN HIEROGLYPH Z013EGYPT" +
	"IAN HIEROGLYPH Z014EGYPTIAN HIEROGLYPH Z015EGYPTIAN HIEROGLYPH Z015AEGYP" +
	"TIAN HIEROGLYPH Z015BEGYPTIAN HIEROGLYPH Z015CEGYPTIAN HIEROGLYPH Z015DE" +
	"GYPTIAN HIEROGLYPH Z015EEGYPTIAN HIEROGLYPH Z015FEGYPTIAN HIEROGLYPH Z01" +
	"5GEGYPTIAN HIEROGLYPH Z015HEGYPTIAN HIEROGLYPH Z015IEGYPTIAN HIEROGLYPH " +
	"Z016EGYPTIAN HIEROGLYPH Z016AEGYPTIAN HIEROGLYPH Z016BEGYPTIAN HIEROGLYP" +
	"H Z016CEGYPTIAN HIEROGLYPH Z016DEGYPTIAN HIEROGLYPH Z016EEGYPTIAN HIEROG" +
	"LYPH Z016FEGYPTIAN HIEROGLYPH Z016GEGYPTIAN HIEROGLYPH Z016HEGYPTIAN HIE" +
	"ROGLYPH AA001EGYPTIAN HIEROGLYPH AA002EGYPTIAN HIEROGLYPH AA003EGYPTIAN " +
	"HIEROGLYPH AA004EGYPTIAN HIEROGLYPH AA005EGYPTIAN HIEROGLYPH AA006EGYPTI" +
	"AN HIEROGLYPH AA007EGYPTIAN HIEROGLYPH AA007AEGYPTIAN HIEROGLYPH AA007BE" +
	"GYPTIAN HIEROGLYPH AA008EGYPTIAN HIEROGLYPH AA009EGYPTIAN HIEROGLYPH AA0" +
	"10EGYPTIAN HIEROGLYPH AA011EGYPTIAN HIEROGLYPH AA012EGYPTIAN HIEROGLYPH " +
	"AA013EGYPTIAN HIEROGLYPH AA014EGYPTIAN HIEROGLYPH AA015EGYPTIAN HIEROGLY" +
	"PH AA016EGYPTIAN HIEROGLYPH AA017EGYPTIAN HIEROGLYPH AA018EGYPTIAN HIERO" +
	"GLYPH AA019EGYPTIAN HIEROGLYPH AA020EGYPTIAN HIEROGLYPH AA021EGYPTIAN HI" +
	"EROGLYPH AA022EGYPTIAN HIEROGLYPH AA023EGYPTIAN HIEROGLYPH AA024EGYPTIAN" +
	" HIEROGLYPH AA025EGYPTIAN HIEROGLYPH AA026EGYPTIAN HIEROGLYPH AA027EGYPT" +
	"IAN HIEROGLYPH AA028EGYPTIAN HIEROGLYPH AA029EGYPTIAN HIEROGLYPH AA030EG" +
	"YPTIAN HIEROGLYPH AA031EGYPTIAN HIEROGLYPH AA032ANATOLIAN HIEROGLYPH A00" +
	"1ANATOLIAN HIEROGLYPH A002ANATOLIAN HIEROGLYPH A003ANATOLIAN HIEROGLYPH " +
	"A004ANATOLIAN HIEROGLYPH A005ANATOLIAN HIEROGLYPH A006ANATOLIAN HIEROGLY" +
	"PH A007ANATOLIAN HIEROGLYPH A008ANATOLIAN HIEROGLYPH A009ANATOLIAN HIERO" +
	"GLYPH A010ANATOLIAN HIEROGLYPH A010AANATOLIAN HIEROGLYPH A011ANATOLIAN H" +
	"IEROGLYPH A012ANATOLIAN HIEROGLYPH A013ANATOLIAN HIEROGLYPH A014ANATOLIA" +
	"N HIEROGLYPH A015ANATOLIAN HIEROGLYPH A016ANATOLIAN HIEROGLYPH A017ANATO" +
	"LIAN HIEROGLYPH A018ANATOLIAN HIEROGLYPH A019ANATOLIAN HIEROGLYPH A020AN" +
	"ATOLIAN HIEROGLYPH A021ANATOLIAN HIEROGLYPH A022ANATOLIAN HIEROGLYPH A02" +
	"3ANATOLIAN HIEROGLYPH A024ANATOLIAN HIEROGLYPH A025ANATOLIAN HIEROGLYPH " +
	"A026ANATOLIAN HIEROGLYPH A026AANATOLIAN HIEROGLYPH A027ANATOLIAN HIEROGL" +
	"YPH A028ANATOLIAN HIEROGLYPH A029ANATOLIAN HIEROGLYPH A030ANATOLIAN HIER" +
	"OGLYPH A031ANATOLIAN HIEROGLYPH A032ANATOLIAN HIEROGLYPH A033ANATOLIAN H" +
	"IEROGLYPH A034ANATOLIAN HIEROGLYPH A035ANATOLIAN HIEROGLYPH A036ANATOLIA" +
	"N HIEROGLYPH A037ANATOLIAN HIEROGLYPH A038ANATOLIAN HIEROGLYPH A039ANATO" +
	"LIAN HIEROGLYPH A039AANATOLIAN HIEROGLYPH A040ANATOLIAN HIEROGLYPH A041A" +
	"NATOLIAN HIEROGLYPH A041AANATOLIAN HIEROGLYPH A042ANATOLIAN HIEROGLYPH A" +
	"043ANATOLIAN HIEROGLYPH A044ANATOLIAN HIEROGLYPH A045ANATOLIAN HIEROGLYP" +
	"H A045AANATOLIAN HIEROGLYPH A046ANATOLIAN HIEROGLYPH A046AANATOLIAN HIER" +
	"OGLYPH A046BANATOLIAN HIEROGLYPH A047ANATOLIAN HIEROGLYPH A048ANATOLIAN " +
	"HIEROGLYPH A049ANATOLIAN HIEROGLYPH A050ANATOLIAN HIEROGLYPH A051ANATOLI" +
	"AN HIEROGLYPH A052ANATOLIAN HIEROGLYPH A053ANATOLIAN HIEROGLYPH A054ANAT" +
	"OLIAN HIEROGLYPH A055ANATOLIAN HIEROGLYPH A056ANATOLIAN HIEROGLYPH A057A" +
	"NATOLIAN HIEROGLYPH A058ANATOLIAN HIEROGLYPH A059ANATOLIAN HIEROGLYPH A0" +
	"60ANATOLIAN HIEROGLYPH A061ANATOLIAN HIEROGLYPH A062ANATOLIAN HIEROGLYPH" +
	" A063ANATOLIAN HIEROGLYPH A064ANATOLIAN HIEROGLYPH A065ANATOLIAN HIEROGL" +
	"YPH A066ANATOLIAN HIEROGLYPH A066AANATOLIAN HIEROGLYPH A066BANATOLIAN HI" +
	"EROGLYPH A066CANATOLIAN HIEROGLYPH A067ANATOLIAN HIEROGLYPH A068ANATOLIA" +
	"N HIEROGLYPH A069ANATOLIAN HIEROGLYPH A070ANATOLIAN HIEROGLYPH A071ANATO" +
	"LIAN HIEROGLYPH A072ANATOLIAN HIEROGLYPH A073ANATOLIAN HIEROGLYPH A074AN" +
	"ATOLIAN HIEROGLYPH A075ANATOLIAN HIEROGLYPH A076ANATOLIAN HIEROGLYPH A07" +
	"7ANATOLIAN HIEROGLYPH A078ANATOLIAN HIEROGLYPH A079ANATOLIAN HIEROGLYPH ") + ("" +
	"A080ANATOLIAN HIEROGLYPH A081ANATOLIAN HIEROGLYPH A082ANATOLIAN HIEROGLY" +
	"PH A083ANATOLIAN HIEROGLYPH A084ANATOLIAN HIEROGLYPH A085ANATOLIAN HIERO" +
	"GLYPH A086ANATOLIAN HIEROGLYPH A087ANATOLIAN HIEROGLYPH A088ANATOLIAN HI" +
	"EROGLYPH A089ANATOLIAN HIEROGLYPH A090ANATOLIAN HIEROGLYPH A091ANATOLIAN" +
	" HIEROGLYPH A092ANATOLIAN HIEROGLYPH A093ANATOLIAN HIEROGLYPH A094ANATOL" +
	"IAN HIEROGLYPH A095ANATOLIAN HIEROGLYPH A096ANATOLIAN HIEROGLYPH A097ANA" +
	"TOLIAN HIEROGLYPH A097AANATOLIAN HIEROGLYPH A098ANATOLIAN HIEROGLYPH A09" +
	"8AANATOLIAN HIEROGLYPH A099ANATOLIAN HIEROGLYPH A100ANATOLIAN HIEROGLYPH" +
	" A100AANATOLIAN HIEROGLYPH A101ANATOLIAN HIEROGLYPH A101AANATOLIAN HIERO" +
	"GLYPH A102ANATOLIAN HIEROGLYPH A102AANATOLIAN HIEROGLYPH A103ANATOLIAN H" +
	"IEROGLYPH A104ANATOLIAN HIEROGLYPH A104AANATOLIAN HIEROGLYPH A104BANATOL" +
	"IAN HIEROGLYPH A104CANATOLIAN HIEROGLYPH A105ANATOLIAN HIEROGLYPH A105AA" +
	"NATOLIAN HIEROGLYPH A105BANATOLIAN HIEROGLYPH A106ANATOLIAN HIEROGLYPH A" +
	"107ANATOLIAN HIEROGLYPH A107AANATOLIAN HIEROGLYPH A107BANATOLIAN HIEROGL" +
	"YPH A107CANATOLIAN HIEROGLYPH A108ANATOLIAN HIEROGLYPH A109ANATOLIAN HIE" +
	"ROGLYPH A110ANATOLIAN HIEROGLYPH A110AANATOLIAN HIEROGLYPH A110BANATOLIA" +
	"N HIEROGLYPH A111ANATOLIAN HIEROGLYPH A112ANATOLIAN HIEROGLYPH A113ANATO" +
	"LIAN HIEROGLYPH A114ANATOLIAN HIEROGLYPH A115ANATOLIAN HIEROGLYPH A115AA" +
	"NATOLIAN HIEROGLYPH A116ANATOLIAN HIEROGLYPH A117ANATOLIAN HIEROGLYPH A1" +
	"18ANATOLIAN HIEROGLYPH A119ANATOLIAN HIEROGLYPH A120ANATOLIAN HIEROGLYPH" +
	" A121ANATOLIAN HIEROGLYPH A122ANATOLIAN HIEROGLYPH A123ANATOLIAN HIEROGL" +
	"YPH A124ANATOLIAN HIEROGLYPH A125ANATOLIAN HIEROGLYPH A125AANATOLIAN HIE" +
	"ROGLYPH A126ANATOLIAN HIEROGLYPH A127ANATOLIAN HIEROGLYPH A128ANATOLIAN " +
	"HIEROGLYPH A129ANATOLIAN HIEROGLYPH A130ANATOLIAN HIEROGLYPH A131ANATOLI" +
	"AN HIEROGLYPH A132ANATOLIAN HIEROGLYPH A133ANATOLIAN HIEROGLYPH A134ANAT" +
	"OLIAN HIEROGLYPH A135ANATOLIAN HIEROGLYPH A135AANATOLIAN HIEROGLYPH A136" +
	"ANATOLIAN HIEROGLYPH A137ANATOLIAN HIEROGLYPH A138ANATOLIAN HIEROGLYPH A" +
	"139ANATOLIAN HIEROGLYPH A140ANATOLIAN HIEROGLYPH A141ANATOLIAN HIEROGLYP" +
	"H A142ANATOLIAN HIEROGLYPH A143ANATOLIAN HIEROGLYPH A144ANATOLIAN HIEROG" +
	"LYPH A145ANATOLIAN HIEROGLYPH A146ANATOLIAN HIEROGLYPH A147ANATOLIAN HIE" +
	"ROGLYPH A148ANATOLIAN HIEROGLYPH A149ANATOLIAN HIEROGLYPH A150ANATOLIAN " +
	"HIEROGLYPH A151ANATOLIAN HIEROGLYPH A152ANATOLIAN HIEROGLYPH A153ANATOLI" +
	"AN HIEROGLYPH A154ANATOLIAN HIEROGLYPH A155ANATOLIAN HIEROGLYPH A156ANAT" +
	"OLIAN HIEROGLYPH A157ANATOLIAN HIEROGLYPH A158ANATOLIAN HIEROGLYPH A159A" +
	"NATOLIAN HIEROGLYPH A160ANATOLIAN HIEROGLYPH A161ANATOLIAN HIEROGLYPH A1" +
	"62ANATOLIAN HIEROGLYPH A163ANATOLIAN HIEROGLYPH A164ANATOLIAN HIEROGLYPH" +
	" A165ANATOLIAN HIEROGLYPH A166ANATOLIAN HIEROGLYPH A167ANATOLIAN HIEROGL" +
	"YPH A168ANATOLIAN HIEROGLYPH A169ANATOLIAN HIEROGLYPH A170ANATOLIAN HIER" +
	"OGLYPH A171ANATOLIAN HIEROGLYPH A172ANATOLIAN HIEROGLYPH A173ANATOLIAN H" +
	"IEROGLYPH A174ANATOLIAN HIEROGLYPH A175ANATOLIAN HIEROGLYPH A176ANATOLIA" +
	"N HIEROGLYPH A177ANATOLIAN HIEROGLYPH A178ANATOLIAN HIEROGLYPH A179ANATO" +
	"LIAN HIEROGLYPH A180ANATOLIAN HIEROGLYPH A181ANATOLIAN HIEROGLYPH A182AN" +
	"ATOLIAN HIEROGLYPH A183ANATOLIAN HIEROGLYPH A184ANATOLIAN HIEROGLYPH A18" +
	"5ANATOLIAN HIEROGLYPH A186ANATOLIAN HIEROGLYPH A187ANATOLIAN HIEROGLYPH " +
	"A188ANATOLIAN HIEROGLYPH A189ANATOLIAN HIEROGLYPH A190ANATOLIAN HIEROGLY" +
	"PH A191ANATOLIAN HIEROGLYPH A192ANATOLIAN HIEROGLYPH A193ANATOLIAN HIERO" +
	"GLYPH A194ANATOLIAN HIEROGLYPH A195ANATOLIAN HIEROGLYPH A196ANATOLIAN HI" +
	"EROGLYPH A197ANATOLIAN HIEROGLYPH A198ANATOLIAN HIEROGLYPH A199ANATOLIAN" +
	" HIEROGLYPH A200ANATOLIAN HIEROGLYPH A201ANATOLIAN HIEROGLYPH A202ANATOL" +
	"IAN HIEROGLYPH A202AANATOLIAN HIEROGLYPH A202BANATOLIAN HIEROGLYPH A203A" +
	"NATOLIAN HIEROGLYPH A204ANATOLIAN HIEROGLYPH A205ANATOLIAN HIEROGLYPH A2" +
	"06ANATOLIAN HIEROGLYPH A207ANATOLIAN HIEROGLYPH A207AANATOLIAN HIEROGLYP" +
	"H A208ANATOLIAN HIEROGLYPH A209ANATOLIAN HIEROGLYPH A209AANATOLIAN HIERO" +
	"GLYPH A210ANATOLIAN HIEROGLYPH A211ANATOLIAN HIEROGLYPH A212ANATOLIAN HI" +
	"EROGLYPH A213ANATOLIAN HIEROGLYPH A214ANATOLIAN HIEROGLYPH A215ANATOLIAN" +
	" HIEROGLYPH A215AANATOLIAN HIEROGLYPH A216ANATOLIAN HIEROGLYPH A216AANAT" +
	"OLIAN HIEROGLYPH A217ANATOLIAN HIEROGLYPH A218ANATOLIAN HIEROGLYPH A219A" +
	"NATOLIAN HIEROGLYPH A220ANATOLIAN HIEROGLYPH A221ANATOLIAN HIEROGLYPH A2" +
	"22ANATOLIAN HIEROGLYPH A223ANATOLIAN HIEROGLYPH A224ANATOLIAN HIEROGLYPH" +
	" A225ANATOLIAN HIEROGLYPH A226ANATOLIAN HIEROGLYPH A227ANATOLIAN HIEROGL" +
	"YPH A227AANATOLIAN HIEROGLYPH A228ANATOLIAN HIEROGLYPH A229ANATOLIAN HIE" +
	"ROGLYPH A230ANATOLIAN HIEROGLYPH A231ANATOLIAN HIEROGLYPH A232ANATOLIAN " +
	"HIEROGLYPH A233ANATOLIAN HIEROGLYPH A234ANATOLIAN HIEROGLYPH A235ANATOLI" +
	"AN HIEROGLYPH A236ANATOLIAN HIEROGLYPH A237ANATOLIAN HIEROGLYPH A238ANAT") + ("" +
	"OLIAN HIEROGLYPH A239ANATOLIAN HIEROGLYPH A240ANATOLIAN HIEROGLYPH A241A" +
	"NATOLIAN HIEROGLYPH A242ANATOLIAN HIEROGLYPH A243ANATOLIAN HIEROGLYPH A2" +
	"44ANATOLIAN HIEROGLYPH A245ANATOLIAN HIEROGLYPH A246ANATOLIAN HIEROGLYPH" +
	" A247ANATOLIAN HIEROGLYPH A248ANATOLIAN HIEROGLYPH A249ANATOLIAN HIEROGL" +
	"YPH A250ANATOLIAN HIEROGLYPH A251ANATOLIAN HIEROGLYPH A252ANATOLIAN HIER" +
	"OGLYPH A253ANATOLIAN HIEROGLYPH A254ANATOLIAN HIEROGLYPH A255ANATOLIAN H" +
	"IEROGLYPH A256ANATOLIAN HIEROGLYPH A257ANATOLIAN HIEROGLYPH A258ANATOLIA" +
	"N HIEROGLYPH A259ANATOLIAN HIEROGLYPH A260ANATOLIAN HIEROGLYPH A261ANATO" +
	"LIAN HIEROGLYPH A262ANATOLIAN HIEROGLYPH A263ANATOLIAN HIEROGLYPH A264AN" +
	"ATOLIAN HIEROGLYPH A265ANATOLIAN HIEROGLYPH A266ANATOLIAN HIEROGLYPH A26" +
	"7ANATOLIAN HIEROGLYPH A267AANATOLIAN HIEROGLYPH A268ANATOLIAN HIEROGLYPH" +
	" A269ANATOLIAN HIEROGLYPH A270ANATOLIAN HIEROGLYPH A271ANATOLIAN HIEROGL" +
	"YPH A272ANATOLIAN HIEROGLYPH A273ANATOLIAN HIEROGLYPH A274ANATOLIAN HIER" +
	"OGLYPH A275ANATOLIAN HIEROGLYPH A276ANATOLIAN HIEROGLYPH A277ANATOLIAN H" +
	"IEROGLYPH A278ANATOLIAN HIEROGLYPH A279ANATOLIAN HIEROGLYPH A280ANATOLIA" +
	"N HIEROGLYPH A281ANATOLIAN HIEROGLYPH A282ANATOLIAN HIEROGLYPH A283ANATO" +
	"LIAN HIEROGLYPH A284ANATOLIAN HIEROGLYPH A285ANATOLIAN HIEROGLYPH A286AN" +
	"ATOLIAN HIEROGLYPH A287ANATOLIAN HIEROGLYPH A288ANATOLIAN HIEROGLYPH A28" +
	"9ANATOLIAN HIEROGLYPH A289AANATOLIAN HIEROGLYPH A290ANATOLIAN HIEROGLYPH" +
	" A291ANATOLIAN HIEROGLYPH A292ANATOLIAN HIEROGLYPH A293ANATOLIAN HIEROGL" +
	"YPH A294ANATOLIAN HIEROGLYPH A294AANATOLIAN HIEROGLYPH A295ANATOLIAN HIE" +
	"ROGLYPH A296ANATOLIAN HIEROGLYPH A297ANATOLIAN HIEROGLYPH A298ANATOLIAN " +
	"HIEROGLYPH A299ANATOLIAN HIEROGLYPH A299AANATOLIAN HIEROGLYPH A300ANATOL" +
	"IAN HIEROGLYPH A301ANATOLIAN HIEROGLYPH A302ANATOLIAN HIEROGLYPH A303ANA" +
	"TOLIAN HIEROGLYPH A304ANATOLIAN HIEROGLYPH A305ANATOLIAN HIEROGLYPH A306" +
	"ANATOLIAN HIEROGLYPH A307ANATOLIAN HIEROGLYPH A308ANATOLIAN HIEROGLYPH A" +
	"309ANATOLIAN HIEROGLYPH A309AANATOLIAN HIEROGLYPH A310ANATOLIAN HIEROGLY" +
	"PH A311ANATOLIAN HIEROGLYPH A312ANATOLIAN HIEROGLYPH A313ANATOLIAN HIERO" +
	"GLYPH A314ANATOLIAN HIEROGLYPH A315ANATOLIAN HIEROGLYPH A316ANATOLIAN HI" +
	"EROGLYPH A317ANATOLIAN HIEROGLYPH A318ANATOLIAN HIEROGLYPH A319ANATOLIAN" +
	" HIEROGLYPH A320ANATOLIAN HIEROGLYPH A321ANATOLIAN HIEROGLYPH A322ANATOL" +
	"IAN HIEROGLYPH A323ANATOLIAN HIEROGLYPH A324ANATOLIAN HIEROGLYPH A325ANA" +
	"TOLIAN HIEROGLYPH A326ANATOLIAN HIEROGLYPH A327ANATOLIAN HIEROGLYPH A328" +
	"ANATOLIAN HIEROGLYPH A329ANATOLIAN HIEROGLYPH A329AANATOLIAN HIEROGLYPH " +
	"A330ANATOLIAN HIEROGLYPH A331ANATOLIAN HIEROGLYPH A332AANATOLIAN HIEROGL" +
	"YPH A332BANATOLIAN HIEROGLYPH A332CANATOLIAN HIEROGLYPH A333ANATOLIAN HI" +
	"EROGLYPH A334ANATOLIAN HIEROGLYPH A335ANATOLIAN HIEROGLYPH A336ANATOLIAN" +
	" HIEROGLYPH A336AANATOLIAN HIEROGLYPH A336BANATOLIAN HIEROGLYPH A336CANA" +
	"TOLIAN HIEROGLYPH A337ANATOLIAN HIEROGLYPH A338ANATOLIAN HIEROGLYPH A339" +
	"ANATOLIAN HIEROGLYPH A340ANATOLIAN HIEROGLYPH A341ANATOLIAN HIEROGLYPH A" +
	"342ANATOLIAN HIEROGLYPH A343ANATOLIAN HIEROGLYPH A344ANATOLIAN HIEROGLYP" +
	"H A345ANATOLIAN HIEROGLYPH A346ANATOLIAN HIEROGLYPH A347ANATOLIAN HIEROG" +
	"LYPH A348ANATOLIAN HIEROGLYPH A349ANATOLIAN HIEROGLYPH A350ANATOLIAN HIE" +
	"ROGLYPH A351ANATOLIAN HIEROGLYPH A352ANATOLIAN HIEROGLYPH A353ANATOLIAN " +
	"HIEROGLYPH A354ANATOLIAN HIEROGLYPH A355ANATOLIAN HIEROGLYPH A356ANATOLI" +
	"AN HIEROGLYPH A357ANATOLIAN HIEROGLYPH A358ANATOLIAN HIEROGLYPH A359ANAT" +
	"OLIAN HIEROGLYPH A359AANATOLIAN HIEROGLYPH A360ANATOLIAN HIEROGLYPH A361" +
	"ANATOLIAN HIEROGLYPH A362ANATOLIAN HIEROGLYPH A363ANATOLIAN HIEROGLYPH A" +
	"364ANATOLIAN HIEROGLYPH A364AANATOLIAN HIEROGLYPH A365ANATOLIAN HIEROGLY" +
	"PH A366ANATOLIAN HIEROGLYPH A367ANATOLIAN HIEROGLYPH A368ANATOLIAN HIERO" +
	"GLYPH A368AANATOLIAN HIEROGLYPH A369ANATOLIAN HIEROGLYPH A370ANATOLIAN H" +
	"IEROGLYPH A371ANATOLIAN HIEROGLYPH A371AANATOLIAN HIEROGLYPH A372ANATOLI" +
	"AN HIEROGLYPH A373ANATOLIAN HIEROGLYPH A374ANATOLIAN HIEROGLYPH A375ANAT" +
	"OLIAN HIEROGLYPH A376ANATOLIAN HIEROGLYPH A377ANATOLIAN HIEROGLYPH A378A" +
	"NATOLIAN HIEROGLYPH A379ANATOLIAN HIEROGLYPH A380ANATOLIAN HIEROGLYPH A3" +
	"81ANATOLIAN HIEROGLYPH A381AANATOLIAN HIEROGLYPH A382ANATOLIAN HIEROGLYP" +
	"H A383 RA OR RIANATOLIAN HIEROGLYPH A383AANATOLIAN HIEROGLYPH A384ANATOL" +
	"IAN HIEROGLYPH A385ANATOLIAN HIEROGLYPH A386ANATOLIAN HIEROGLYPH A386AAN" +
	"ATOLIAN HIEROGLYPH A387ANATOLIAN HIEROGLYPH A388ANATOLIAN HIEROGLYPH A38" +
	"9ANATOLIAN HIEROGLYPH A390ANATOLIAN HIEROGLYPH A391ANATOLIAN HIEROGLYPH " +
	"A392ANATOLIAN HIEROGLYPH A393 EIGHTANATOLIAN HIEROGLYPH A394ANATOLIAN HI" +
	"EROGLYPH A395ANATOLIAN HIEROGLYPH A396ANATOLIAN HIEROGLYPH A397ANATOLIAN" +
	" HIEROGLYPH A398ANATOLIAN HIEROGLYPH A399ANATOLIAN HIEROGLYPH A400ANATOL" +
	"IAN HIEROGLYPH A401ANATOLIAN HIEROGLYPH A402ANATOLIAN HIEROGLYPH A403ANA") + ("" +
	"TOLIAN HIEROGLYPH A404ANATOLIAN HIEROGLYPH A405ANATOLIAN HIEROGLYPH A406" +
	"ANATOLIAN HIEROGLYPH A407ANATOLIAN HIEROGLYPH A408ANATOLIAN HIEROGLYPH A" +
	"409ANATOLIAN HIEROGLYPH A410 BEGIN LOGOGRAM MARKANATOLIAN HIEROGLYPH A41" +
	"0A END LOGOGRAM MARKANATOLIAN HIEROGLYPH A411ANATOLIAN HIEROGLYPH A412AN" +
	"ATOLIAN HIEROGLYPH A413ANATOLIAN HIEROGLYPH A414ANATOLIAN HIEROGLYPH A41" +
	"5ANATOLIAN HIEROGLYPH A416ANATOLIAN HIEROGLYPH A417ANATOLIAN HIEROGLYPH " +
	"A418ANATOLIAN HIEROGLYPH A419ANATOLIAN HIEROGLYPH A420ANATOLIAN HIEROGLY" +
	"PH A421ANATOLIAN HIEROGLYPH A422ANATOLIAN HIEROGLYPH A423ANATOLIAN HIERO" +
	"GLYPH A424ANATOLIAN HIEROGLYPH A425ANATOLIAN HIEROGLYPH A426ANATOLIAN HI" +
	"EROGLYPH A427ANATOLIAN HIEROGLYPH A428ANATOLIAN HIEROGLYPH A429ANATOLIAN" +
	" HIEROGLYPH A430ANATOLIAN HIEROGLYPH A431ANATOLIAN HIEROGLYPH A432ANATOL" +
	"IAN HIEROGLYPH A433ANATOLIAN HIEROGLYPH A434ANATOLIAN HIEROGLYPH A435ANA" +
	"TOLIAN HIEROGLYPH A436ANATOLIAN HIEROGLYPH A437ANATOLIAN HIEROGLYPH A438" +
	"ANATOLIAN HIEROGLYPH A439ANATOLIAN HIEROGLYPH A440ANATOLIAN HIEROGLYPH A" +
	"441ANATOLIAN HIEROGLYPH A442ANATOLIAN HIEROGLYPH A443ANATOLIAN HIEROGLYP" +
	"H A444ANATOLIAN HIEROGLYPH A445ANATOLIAN HIEROGLYPH A446ANATOLIAN HIEROG" +
	"LYPH A447ANATOLIAN HIEROGLYPH A448ANATOLIAN HIEROGLYPH A449ANATOLIAN HIE" +
	"ROGLYPH A450ANATOLIAN HIEROGLYPH A450AANATOLIAN HIEROGLYPH A451ANATOLIAN" +
	" HIEROGLYPH A452ANATOLIAN HIEROGLYPH A453ANATOLIAN HIEROGLYPH A454ANATOL" +
	"IAN HIEROGLYPH A455ANATOLIAN HIEROGLYPH A456ANATOLIAN HIEROGLYPH A457ANA" +
	"TOLIAN HIEROGLYPH A457AANATOLIAN HIEROGLYPH A458ANATOLIAN HIEROGLYPH A45" +
	"9ANATOLIAN HIEROGLYPH A460ANATOLIAN HIEROGLYPH A461ANATOLIAN HIEROGLYPH " +
	"A462ANATOLIAN HIEROGLYPH A463ANATOLIAN HIEROGLYPH A464ANATOLIAN HIEROGLY" +
	"PH A465ANATOLIAN HIEROGLYPH A466ANATOLIAN HIEROGLYPH A467ANATOLIAN HIERO" +
	"GLYPH A468ANATOLIAN HIEROGLYPH A469ANATOLIAN HIEROGLYPH A470ANATOLIAN HI" +
	"EROGLYPH A471ANATOLIAN HIEROGLYPH A472ANATOLIAN HIEROGLYPH A473ANATOLIAN" +
	" HIEROGLYPH A474ANATOLIAN HIEROGLYPH A475ANATOLIAN HIEROGLYPH A476ANATOL" +
	"IAN HIEROGLYPH A477ANATOLIAN HIEROGLYPH A478ANATOLIAN HIEROGLYPH A479ANA" +
	"TOLIAN HIEROGLYPH A480ANATOLIAN HIEROGLYPH A481ANATOLIAN HIEROGLYPH A482" +
	"ANATOLIAN HIEROGLYPH A483ANATOLIAN HIEROGLYPH A484ANATOLIAN HIEROGLYPH A" +
	"485ANATOLIAN HIEROGLYPH A486ANATOLIAN HIEROGLYPH A487ANATOLIAN HIEROGLYP" +
	"H A488ANATOLIAN HIEROGLYPH A489ANATOLIAN HIEROGLYPH A490ANATOLIAN HIEROG" +
	"LYPH A491ANATOLIAN HIEROGLYPH A492ANATOLIAN HIEROGLYPH A493ANATOLIAN HIE" +
	"ROGLYPH A494ANATOLIAN HIEROGLYPH A495ANATOLIAN HIEROGLYPH A496ANATOLIAN " +
	"HIEROGLYPH A497ANATOLIAN HIEROGLYPH A501ANATOLIAN HIEROGLYPH A502ANATOLI" +
	"AN HIEROGLYPH A503ANATOLIAN HIEROGLYPH A504ANATOLIAN HIEROGLYPH A505ANAT" +
	"OLIAN HIEROGLYPH A506ANATOLIAN HIEROGLYPH A507ANATOLIAN HIEROGLYPH A508A" +
	"NATOLIAN HIEROGLYPH A509ANATOLIAN HIEROGLYPH A510ANATOLIAN HIEROGLYPH A5" +
	"11ANATOLIAN HIEROGLYPH A512ANATOLIAN HIEROGLYPH A513ANATOLIAN HIEROGLYPH" +
	" A514ANATOLIAN HIEROGLYPH A515ANATOLIAN HIEROGLYPH A516ANATOLIAN HIEROGL" +
	"YPH A517ANATOLIAN HIEROGLYPH A518ANATOLIAN HIEROGLYPH A519ANATOLIAN HIER" +
	"OGLYPH A520ANATOLIAN HIEROGLYPH A521ANATOLIAN HIEROGLYPH A522ANATOLIAN H" +
	"IEROGLYPH A523ANATOLIAN HIEROGLYPH A524ANATOLIAN HIEROGLYPH A525ANATOLIA" +
	"N HIEROGLYPH A526ANATOLIAN HIEROGLYPH A527ANATOLIAN HIEROGLYPH A528ANATO" +
	"LIAN HIEROGLYPH A529ANATOLIAN HIEROGLYPH A530BAMUM LETTER PHASE-A NGKUE " +
	"MFONBAMUM LETTER PHASE-A GBIEE FONBAMUM LETTER PHASE-A PON MFON PIPAEMGB" +
	"IEEBAMUM LETTER PHASE-A PON MFON PIPAEMBABAMUM LETTER PHASE-A NAA MFONBA" +
	"MUM LETTER PHASE-A SHUENSHUETBAMUM LETTER PHASE-A TITA MFONBAMUM LETTER " +
	"PHASE-A NZA MFONBAMUM LETTER PHASE-A SHINDA PA NJIBAMUM LETTER PHASE-A P" +
	"ON PA NJI PIPAEMGBIEEBAMUM LETTER PHASE-A PON PA NJI PIPAEMBABAMUM LETTE" +
	"R PHASE-A MAEMBGBIEEBAMUM LETTER PHASE-A TU MAEMBABAMUM LETTER PHASE-A N" +
	"GANGUBAMUM LETTER PHASE-A MAEMVEUXBAMUM LETTER PHASE-A MANSUAEBAMUM LETT" +
	"ER PHASE-A MVEUAENGAMBAMUM LETTER PHASE-A SEUNYAMBAMUM LETTER PHASE-A NT" +
	"OQPENBAMUM LETTER PHASE-A KEUKEUTNDABAMUM LETTER PHASE-A NKINDIBAMUM LET" +
	"TER PHASE-A SUUBAMUM LETTER PHASE-A NGKUENZEUMBAMUM LETTER PHASE-A LAPAQ" +
	"BAMUM LETTER PHASE-A LET KUTBAMUM LETTER PHASE-A NTAP MFAABAMUM LETTER P" +
	"HASE-A MAEKEUPBAMUM LETTER PHASE-A PASHAEBAMUM LETTER PHASE-A GHEUAERAEB" +
	"AMUM LETTER PHASE-A PAMSHAEBAMUM LETTER PHASE-A MON NGGEUAETBAMUM LETTER" +
	" PHASE-A NZUN MEUTBAMUM LETTER PHASE-A U YUQ NAEBAMUM LETTER PHASE-A GHE" +
	"UAEGHEUAEBAMUM LETTER PHASE-A NTAP NTAABAMUM LETTER PHASE-A SISABAMUM LE" +
	"TTER PHASE-A MGBASABAMUM LETTER PHASE-A MEUNJOMNDEUQBAMUM LETTER PHASE-A" +
	" MOOMPUQBAMUM LETTER PHASE-A KAFABAMUM LETTER PHASE-A PA LEERAEWABAMUM L" +
	"ETTER PHASE-A NDA LEERAEWABAMUM LETTER PHASE-A PETBAMUM LETTER PHASE-A M" +
	"AEMKPENBAMUM LETTER PHASE-A NIKABAMUM LETTER PHASE-A PUPBAMUM LETTER PHA") + ("" +
	"SE-A TUAEPBAMUM LETTER PHASE-A LUAEPBAMUM LETTER PHASE-A SONJAMBAMUM LET" +
	"TER PHASE-A TEUTEUWENBAMUM LETTER PHASE-A MAENYIBAMUM LETTER PHASE-A KET" +
	"BAMUM LETTER PHASE-A NDAANGGEUAETBAMUM LETTER PHASE-A KUOQBAMUM LETTER P" +
	"HASE-A MOOMEUTBAMUM LETTER PHASE-A SHUMBAMUM LETTER PHASE-A LOMMAEBAMUM " +
	"LETTER PHASE-A FIRIBAMUM LETTER PHASE-A ROMBAMUM LETTER PHASE-A KPOQBAMU" +
	"M LETTER PHASE-A SOQBAMUM LETTER PHASE-A MAP PIEETBAMUM LETTER PHASE-A S" +
	"HIRAEBAMUM LETTER PHASE-A NTAPBAMUM LETTER PHASE-A SHOQ NSHUT YUMBAMUM L" +
	"ETTER PHASE-A NYIT MONGKEUAEQBAMUM LETTER PHASE-A PAARAEBAMUM LETTER PHA" +
	"SE-A NKAARAEBAMUM LETTER PHASE-A UNKNOWNBAMUM LETTER PHASE-A NGGENBAMUM " +
	"LETTER PHASE-A MAESIBAMUM LETTER PHASE-A NJAMBAMUM LETTER PHASE-A MBANYI" +
	"BAMUM LETTER PHASE-A NYETBAMUM LETTER PHASE-A TEUAENBAMUM LETTER PHASE-A" +
	" SOTBAMUM LETTER PHASE-A PAAMBAMUM LETTER PHASE-A NSHIEEBAMUM LETTER PHA" +
	"SE-A MAEMBAMUM LETTER PHASE-A NYIBAMUM LETTER PHASE-A KAQBAMUM LETTER PH" +
	"ASE-A NSHABAMUM LETTER PHASE-A VEEBAMUM LETTER PHASE-A LUBAMUM LETTER PH" +
	"ASE-A NENBAMUM LETTER PHASE-A NAQBAMUM LETTER PHASE-A MBAQBAMUM LETTER P" +
	"HASE-B NSHUETBAMUM LETTER PHASE-B TU MAEMGBIEEBAMUM LETTER PHASE-B SIEEB" +
	"AMUM LETTER PHASE-B SET TUBAMUM LETTER PHASE-B LOM NTEUMBAMUM LETTER PHA" +
	"SE-B MBA MAELEEBAMUM LETTER PHASE-B KIEEMBAMUM LETTER PHASE-B YEURAEBAMU" +
	"M LETTER PHASE-B MBAARAEBAMUM LETTER PHASE-B KAMBAMUM LETTER PHASE-B PEE" +
	"SHIBAMUM LETTER PHASE-B YAFU LEERAEWABAMUM LETTER PHASE-B LAM NSHUT NYAM" +
	"BAMUM LETTER PHASE-B NTIEE SHEUOQBAMUM LETTER PHASE-B NDU NJAABAMUM LETT" +
	"ER PHASE-B GHEUGHEUAEMBAMUM LETTER PHASE-B PITBAMUM LETTER PHASE-B TU NS" +
	"IEEBAMUM LETTER PHASE-B SHET NJAQBAMUM LETTER PHASE-B SHEUAEQTUBAMUM LET" +
	"TER PHASE-B MFON TEUAEQBAMUM LETTER PHASE-B MBIT MBAAKETBAMUM LETTER PHA" +
	"SE-B NYI NTEUMBAMUM LETTER PHASE-B KEUPUQBAMUM LETTER PHASE-B GHEUGHENBA" +
	"MUM LETTER PHASE-B KEUYEUXBAMUM LETTER PHASE-B LAANAEBAMUM LETTER PHASE-" +
	"B PARUMBAMUM LETTER PHASE-B VEUMBAMUM LETTER PHASE-B NGKINDI MVOPBAMUM L" +
	"ETTER PHASE-B NGGEU MBUBAMUM LETTER PHASE-B WUAETBAMUM LETTER PHASE-B SA" +
	"KEUAEBAMUM LETTER PHASE-B TAAMBAMUM LETTER PHASE-B MEUQBAMUM LETTER PHAS" +
	"E-B NGGUOQBAMUM LETTER PHASE-B NGGUOQ LARGEBAMUM LETTER PHASE-B MFIYAQBA" +
	"MUM LETTER PHASE-B SUEBAMUM LETTER PHASE-B MBEURIBAMUM LETTER PHASE-B MO" +
	"NTIEENBAMUM LETTER PHASE-B NYAEMAEBAMUM LETTER PHASE-B PUNGAAMBAMUM LETT" +
	"ER PHASE-B MEUT NGGEETBAMUM LETTER PHASE-B FEUXBAMUM LETTER PHASE-B MBUO" +
	"QBAMUM LETTER PHASE-B FEEBAMUM LETTER PHASE-B KEUAEMBAMUM LETTER PHASE-B" +
	" MA NJEUAENABAMUM LETTER PHASE-B MA NJUQABAMUM LETTER PHASE-B LETBAMUM L" +
	"ETTER PHASE-B NGGAAMBAMUM LETTER PHASE-B NSENBAMUM LETTER PHASE-B MABAMU" +
	"M LETTER PHASE-B KIQBAMUM LETTER PHASE-B NGOMBAMUM LETTER PHASE-C NGKUE " +
	"MAEMBABAMUM LETTER PHASE-C NZABAMUM LETTER PHASE-C YUMBAMUM LETTER PHASE" +
	"-C WANGKUOQBAMUM LETTER PHASE-C NGGENBAMUM LETTER PHASE-C NDEUAEREEBAMUM" +
	" LETTER PHASE-C NGKAQBAMUM LETTER PHASE-C GHARAEBAMUM LETTER PHASE-C MBE" +
	"EKEETBAMUM LETTER PHASE-C GBAYIBAMUM LETTER PHASE-C NYIR MKPARAQ MEUNBAM" +
	"UM LETTER PHASE-C NTU MBITBAMUM LETTER PHASE-C MBEUMBAMUM LETTER PHASE-C" +
	" PIRIEENBAMUM LETTER PHASE-C NDOMBUBAMUM LETTER PHASE-C MBAA CABBAGE-TRE" +
	"EBAMUM LETTER PHASE-C KEUSHEUAEPBAMUM LETTER PHASE-C GHAPBAMUM LETTER PH" +
	"ASE-C KEUKAQBAMUM LETTER PHASE-C YU MUOMAEBAMUM LETTER PHASE-C NZEUMBAMU" +
	"M LETTER PHASE-C MBUEBAMUM LETTER PHASE-C NSEUAENBAMUM LETTER PHASE-C MB" +
	"ITBAMUM LETTER PHASE-C YEUQBAMUM LETTER PHASE-C KPARAQBAMUM LETTER PHASE" +
	"-C KAABAMUM LETTER PHASE-C SEUXBAMUM LETTER PHASE-C NDIDABAMUM LETTER PH" +
	"ASE-C TAASHAEBAMUM LETTER PHASE-C NJUEQBAMUM LETTER PHASE-C TITA YUEBAMU" +
	"M LETTER PHASE-C SUAETBAMUM LETTER PHASE-C NGGUAEN NYAMBAMUM LETTER PHAS" +
	"E-C VEUXBAMUM LETTER PHASE-C NANSANAQBAMUM LETTER PHASE-C MA KEUAERIBAMU" +
	"M LETTER PHASE-C NTAABAMUM LETTER PHASE-C NGGUONBAMUM LETTER PHASE-C LAP" +
	"BAMUM LETTER PHASE-C MBIRIEENBAMUM LETTER PHASE-C MGBASAQBAMUM LETTER PH" +
	"ASE-C NTEUNGBABAMUM LETTER PHASE-C TEUTEUXBAMUM LETTER PHASE-C NGGUMBAMU" +
	"M LETTER PHASE-C FUEBAMUM LETTER PHASE-C NDEUTBAMUM LETTER PHASE-C NSABA" +
	"MUM LETTER PHASE-C NSHAQBAMUM LETTER PHASE-C BUNGBAMUM LETTER PHASE-C VE" +
	"UAEPENBAMUM LETTER PHASE-C MBERAEBAMUM LETTER PHASE-C RUBAMUM LETTER PHA" +
	"SE-C NJAEMBAMUM LETTER PHASE-C LAMBAMUM LETTER PHASE-C TITUAEPBAMUM LETT" +
	"ER PHASE-C NSUOT NGOMBAMUM LETTER PHASE-C NJEEEEBAMUM LETTER PHASE-C KET" +
	"BAMUM LETTER PHASE-C NGGUBAMUM LETTER PHASE-C MAESIBAMUM LETTER PHASE-C " +
	"MBUAEMBAMUM LETTER PHASE-C LUBAMUM LETTER PHASE-C KUTBAMUM LETTER PHASE-" +
	"C NJAMBAMUM LETTER PHASE-C NGOMBAMUM LETTER PHASE-C WUPBAMUM LETTER PHAS" +
	"E-C NGGUEETBAMUM LETTER PHASE-C NSOMBAMUM LETTER PHASE-C NTENBAMUM LETTE" +
	"R PHASE-C KUOP NKAARAEBAMUM LETTER PHASE-C NSUNBAMUM LETTER PHASE-C NDAM") + ("" +
	"BAMUM LETTER PHASE-C MA NSIEEBAMUM LETTER PHASE-C YAABAMUM LETTER PHASE-" +
	"C NDAPBAMUM LETTER PHASE-C SHUEQBAMUM LETTER PHASE-C SETFONBAMUM LETTER " +
	"PHASE-C MBIBAMUM LETTER PHASE-C MAEMBABAMUM LETTER PHASE-C MBANYIBAMUM L" +
	"ETTER PHASE-C KEUSEUXBAMUM LETTER PHASE-C MBEUXBAMUM LETTER PHASE-C KEUM" +
	"BAMUM LETTER PHASE-C MBAA PICKETBAMUM LETTER PHASE-C YUWOQBAMUM LETTER P" +
	"HASE-C NJEUXBAMUM LETTER PHASE-C MIEEBAMUM LETTER PHASE-C MUAEBAMUM LETT" +
	"ER PHASE-C SHIQBAMUM LETTER PHASE-C KEN LAWBAMUM LETTER PHASE-C KEN FATI" +
	"GUEBAMUM LETTER PHASE-C NGAQBAMUM LETTER PHASE-C NAQBAMUM LETTER PHASE-C" +
	" LIQBAMUM LETTER PHASE-C PINBAMUM LETTER PHASE-C PENBAMUM LETTER PHASE-C" +
	" TETBAMUM LETTER PHASE-D MBUOBAMUM LETTER PHASE-D WAPBAMUM LETTER PHASE-" +
	"D NJIBAMUM LETTER PHASE-D MFONBAMUM LETTER PHASE-D NJIEEBAMUM LETTER PHA" +
	"SE-D LIEEBAMUM LETTER PHASE-D NJEUTBAMUM LETTER PHASE-D NSHEEBAMUM LETTE" +
	"R PHASE-D NGGAAMAEBAMUM LETTER PHASE-D NYAMBAMUM LETTER PHASE-D WUAENBAM" +
	"UM LETTER PHASE-D NGKUNBAMUM LETTER PHASE-D SHEEBAMUM LETTER PHASE-D NGK" +
	"APBAMUM LETTER PHASE-D KEUAETMEUNBAMUM LETTER PHASE-D TEUTBAMUM LETTER P" +
	"HASE-D SHEUAEBAMUM LETTER PHASE-D NJAPBAMUM LETTER PHASE-D SUEBAMUM LETT" +
	"ER PHASE-D KETBAMUM LETTER PHASE-D YAEMMAEBAMUM LETTER PHASE-D KUOMBAMUM" +
	" LETTER PHASE-D SAPBAMUM LETTER PHASE-D MFEUTBAMUM LETTER PHASE-D NDEUXB" +
	"AMUM LETTER PHASE-D MALEERIBAMUM LETTER PHASE-D MEUTBAMUM LETTER PHASE-D" +
	" SEUAEQBAMUM LETTER PHASE-D YENBAMUM LETTER PHASE-D NJEUAEMBAMUM LETTER " +
	"PHASE-D KEUOT MBUAEBAMUM LETTER PHASE-D NGKEURIBAMUM LETTER PHASE-D TUBA" +
	"MUM LETTER PHASE-D GHAABAMUM LETTER PHASE-D NGKYEEBAMUM LETTER PHASE-D F" +
	"EUFEUAETBAMUM LETTER PHASE-D NDEEBAMUM LETTER PHASE-D MGBOFUMBAMUM LETTE" +
	"R PHASE-D LEUAEPBAMUM LETTER PHASE-D NDONBAMUM LETTER PHASE-D MONIBAMUM " +
	"LETTER PHASE-D MGBEUNBAMUM LETTER PHASE-D PUUTBAMUM LETTER PHASE-D MGBIE" +
	"EBAMUM LETTER PHASE-D MFOBAMUM LETTER PHASE-D LUMBAMUM LETTER PHASE-D NS" +
	"IEEPBAMUM LETTER PHASE-D MBAABAMUM LETTER PHASE-D KWAETBAMUM LETTER PHAS" +
	"E-D NYETBAMUM LETTER PHASE-D TEUAENBAMUM LETTER PHASE-D SOTBAMUM LETTER " +
	"PHASE-D YUWOQBAMUM LETTER PHASE-D KEUMBAMUM LETTER PHASE-D RAEMBAMUM LET" +
	"TER PHASE-D TEEEEBAMUM LETTER PHASE-D NGKEUAEQBAMUM LETTER PHASE-D MFEUA" +
	"EBAMUM LETTER PHASE-D NSIEETBAMUM LETTER PHASE-D KEUPBAMUM LETTER PHASE-" +
	"D PIPBAMUM LETTER PHASE-D PEUTAEBAMUM LETTER PHASE-D NYUEBAMUM LETTER PH" +
	"ASE-D LETBAMUM LETTER PHASE-D NGGAAMBAMUM LETTER PHASE-D MFIEEBAMUM LETT" +
	"ER PHASE-D NGGWAENBAMUM LETTER PHASE-D YUOMBAMUM LETTER PHASE-D PAPBAMUM" +
	" LETTER PHASE-D YUOPBAMUM LETTER PHASE-D NDAMBAMUM LETTER PHASE-D NTEUMB" +
	"AMUM LETTER PHASE-D SUAEBAMUM LETTER PHASE-D KUNBAMUM LETTER PHASE-D NGG" +
	"EUXBAMUM LETTER PHASE-D NGKIEEBAMUM LETTER PHASE-D TUOTBAMUM LETTER PHAS" +
	"E-D MEUNBAMUM LETTER PHASE-D KUQBAMUM LETTER PHASE-D NSUMBAMUM LETTER PH" +
	"ASE-D TEUNBAMUM LETTER PHASE-D MAENJETBAMUM LETTER PHASE-D NGGAPBAMUM LE" +
	"TTER PHASE-D LEUMBAMUM LETTER PHASE-D NGGUOMBAMUM LETTER PHASE-D NSHUTBA" +
	"MUM LETTER PHASE-D NJUEQBAMUM LETTER PHASE-D GHEUAEBAMUM LETTER PHASE-D " +
	"KUBAMUM LETTER PHASE-D REN OLDBAMUM LETTER PHASE-D TAEBAMUM LETTER PHASE" +
	"-D TOQBAMUM LETTER PHASE-D NYIBAMUM LETTER PHASE-D RIIBAMUM LETTER PHASE" +
	"-D LEEEEBAMUM LETTER PHASE-D MEEEEBAMUM LETTER PHASE-D MBAMUM LETTER PHA" +
	"SE-D SUUBAMUM LETTER PHASE-D MUBAMUM LETTER PHASE-D SHIIBAMUM LETTER PHA" +
	"SE-D SHEUXBAMUM LETTER PHASE-D KYEEBAMUM LETTER PHASE-D NUBAMUM LETTER P" +
	"HASE-D SHUBAMUM LETTER PHASE-D NTEEBAMUM LETTER PHASE-D PEEBAMUM LETTER " +
	"PHASE-D NIBAMUM LETTER PHASE-D SHOQBAMUM LETTER PHASE-D PUQBAMUM LETTER " +
	"PHASE-D MVOPBAMUM LETTER PHASE-D LOQBAMUM LETTER PHASE-D REN MUCHBAMUM L" +
	"ETTER PHASE-D TIBAMUM LETTER PHASE-D NTUUBAMUM LETTER PHASE-D MBAA SEVEN" +
	"BAMUM LETTER PHASE-D SAQBAMUM LETTER PHASE-D FAABAMUM LETTER PHASE-E NDA" +
	"PBAMUM LETTER PHASE-E TOONBAMUM LETTER PHASE-E MBEUMBAMUM LETTER PHASE-E" +
	" LAPBAMUM LETTER PHASE-E VOMBAMUM LETTER PHASE-E LOONBAMUM LETTER PHASE-" +
	"E PAABAMUM LETTER PHASE-E SOMBAMUM LETTER PHASE-E RAQBAMUM LETTER PHASE-" +
	"E NSHUOPBAMUM LETTER PHASE-E NDUNBAMUM LETTER PHASE-E PUAEBAMUM LETTER P" +
	"HASE-E TAMBAMUM LETTER PHASE-E NGKABAMUM LETTER PHASE-E KPEUXBAMUM LETTE" +
	"R PHASE-E WUOBAMUM LETTER PHASE-E SEEBAMUM LETTER PHASE-E NGGEUAETBAMUM " +
	"LETTER PHASE-E PAAMBAMUM LETTER PHASE-E TOOBAMUM LETTER PHASE-E KUOPBAMU" +
	"M LETTER PHASE-E LOMBAMUM LETTER PHASE-E NSHIEEBAMUM LETTER PHASE-E NGOP" +
	"BAMUM LETTER PHASE-E MAEMBAMUM LETTER PHASE-E NGKEUXBAMUM LETTER PHASE-E" +
	" NGOQBAMUM LETTER PHASE-E NSHUEBAMUM LETTER PHASE-E RIMGBABAMUM LETTER P" +
	"HASE-E NJEUXBAMUM LETTER PHASE-E PEEMBAMUM LETTER PHASE-E SAABAMUM LETTE" +
	"R PHASE-E NGGURAEBAMUM LETTER PHASE-E MGBABAMUM LETTER PHASE-E GHEUXBAMU" +
	"M LETTER PHASE-E NGKEUAEMBAMUM LETTER PHASE-E NJAEMLIBAMUM LETTER PHASE-") + ("" +
	"E MAPBAMUM LETTER PHASE-E LOOTBAMUM LETTER PHASE-E NGGEEEEBAMUM LETTER P" +
	"HASE-E NDIQBAMUM LETTER PHASE-E TAEN NTEUMBAMUM LETTER PHASE-E SETBAMUM " +
	"LETTER PHASE-E PUMBAMUM LETTER PHASE-E NDAA SOFTNESSBAMUM LETTER PHASE-E" +
	" NGGUAESHAE NYAMBAMUM LETTER PHASE-E YIEEBAMUM LETTER PHASE-E GHEUNBAMUM" +
	" LETTER PHASE-E TUAEBAMUM LETTER PHASE-E YEUAEBAMUM LETTER PHASE-E POBAM" +
	"UM LETTER PHASE-E TUMAEBAMUM LETTER PHASE-E KEUAEBAMUM LETTER PHASE-E SU" +
	"AENBAMUM LETTER PHASE-E TEUAEQBAMUM LETTER PHASE-E VEUAEBAMUM LETTER PHA" +
	"SE-E WEUXBAMUM LETTER PHASE-E LAAMBAMUM LETTER PHASE-E PUBAMUM LETTER PH" +
	"ASE-E TAAQBAMUM LETTER PHASE-E GHAAMAEBAMUM LETTER PHASE-E NGEUREUTBAMUM" +
	" LETTER PHASE-E SHEUAEQBAMUM LETTER PHASE-E MGBENBAMUM LETTER PHASE-E MB" +
	"EEBAMUM LETTER PHASE-E NZAQBAMUM LETTER PHASE-E NKOMBAMUM LETTER PHASE-E" +
	" GBETBAMUM LETTER PHASE-E TUMBAMUM LETTER PHASE-E KUETBAMUM LETTER PHASE" +
	"-E YAPBAMUM LETTER PHASE-E NYI CLEAVERBAMUM LETTER PHASE-E YITBAMUM LETT" +
	"ER PHASE-E MFEUQBAMUM LETTER PHASE-E NDIAQBAMUM LETTER PHASE-E PIEEQBAMU" +
	"M LETTER PHASE-E YUEQBAMUM LETTER PHASE-E LEUAEMBAMUM LETTER PHASE-E FUE" +
	"BAMUM LETTER PHASE-E GBEUXBAMUM LETTER PHASE-E NGKUPBAMUM LETTER PHASE-E" +
	" KETBAMUM LETTER PHASE-E MAEBAMUM LETTER PHASE-E NGKAAMIBAMUM LETTER PHA" +
	"SE-E GHETBAMUM LETTER PHASE-E FABAMUM LETTER PHASE-E NTUMBAMUM LETTER PH" +
	"ASE-E PEUTBAMUM LETTER PHASE-E YEUMBAMUM LETTER PHASE-E NGGEUAEBAMUM LET" +
	"TER PHASE-E NYI BETWEENBAMUM LETTER PHASE-E NZUQBAMUM LETTER PHASE-E POO" +
	"NBAMUM LETTER PHASE-E MIEEBAMUM LETTER PHASE-E FUETBAMUM LETTER PHASE-E " +
	"NAEBAMUM LETTER PHASE-E MUAEBAMUM LETTER PHASE-E GHEUAEBAMUM LETTER PHAS" +
	"E-E FU IBAMUM LETTER PHASE-E MVIBAMUM LETTER PHASE-E PUAQBAMUM LETTER PH" +
	"ASE-E NGKUMBAMUM LETTER PHASE-E KUTBAMUM LETTER PHASE-E PIETBAMUM LETTER" +
	" PHASE-E NTAPBAMUM LETTER PHASE-E YEUAETBAMUM LETTER PHASE-E NGGUPBAMUM " +
	"LETTER PHASE-E PA PEOPLEBAMUM LETTER PHASE-E FU CALLBAMUM LETTER PHASE-E" +
	" FOMBAMUM LETTER PHASE-E NJEEBAMUM LETTER PHASE-E ABAMUM LETTER PHASE-E " +
	"TOQBAMUM LETTER PHASE-E OBAMUM LETTER PHASE-E IBAMUM LETTER PHASE-E LAQB" +
	"AMUM LETTER PHASE-E PA PLURALBAMUM LETTER PHASE-E TAABAMUM LETTER PHASE-" +
	"E TAQBAMUM LETTER PHASE-E NDAA MY HOUSEBAMUM LETTER PHASE-E SHIQBAMUM LE" +
	"TTER PHASE-E YEUXBAMUM LETTER PHASE-E NGUAEBAMUM LETTER PHASE-E YUAENBAM" +
	"UM LETTER PHASE-E YOQ SWIMMINGBAMUM LETTER PHASE-E YOQ COVERBAMUM LETTER" +
	" PHASE-E YUQBAMUM LETTER PHASE-E YUNBAMUM LETTER PHASE-E KEUXBAMUM LETTE" +
	"R PHASE-E PEUXBAMUM LETTER PHASE-E NJEE EPOCHBAMUM LETTER PHASE-E PUEBAM" +
	"UM LETTER PHASE-E WUEBAMUM LETTER PHASE-E FEEBAMUM LETTER PHASE-E VEEBAM" +
	"UM LETTER PHASE-E LUBAMUM LETTER PHASE-E MIBAMUM LETTER PHASE-E REUXBAMU" +
	"M LETTER PHASE-E RAEBAMUM LETTER PHASE-E NGUAETBAMUM LETTER PHASE-E NGAB" +
	"AMUM LETTER PHASE-E SHOBAMUM LETTER PHASE-E SHOQBAMUM LETTER PHASE-E FU " +
	"REMEDYBAMUM LETTER PHASE-E NABAMUM LETTER PHASE-E PIBAMUM LETTER PHASE-E" +
	" LOQBAMUM LETTER PHASE-E KOBAMUM LETTER PHASE-E MENBAMUM LETTER PHASE-E " +
	"MABAMUM LETTER PHASE-E MAQBAMUM LETTER PHASE-E TEUBAMUM LETTER PHASE-E K" +
	"IBAMUM LETTER PHASE-E MONBAMUM LETTER PHASE-E TENBAMUM LETTER PHASE-E FA" +
	"QBAMUM LETTER PHASE-E GHOMBAMUM LETTER PHASE-F KABAMUM LETTER PHASE-F UB" +
	"AMUM LETTER PHASE-F KUBAMUM LETTER PHASE-F EEBAMUM LETTER PHASE-F REEBAM" +
	"UM LETTER PHASE-F TAEBAMUM LETTER PHASE-F NYIBAMUM LETTER PHASE-F LABAMU" +
	"M LETTER PHASE-F RIIBAMUM LETTER PHASE-F RIEEBAMUM LETTER PHASE-F MEEEEB" +
	"AMUM LETTER PHASE-F TAABAMUM LETTER PHASE-F NDAABAMUM LETTER PHASE-F NJA" +
	"EMBAMUM LETTER PHASE-F MBAMUM LETTER PHASE-F SUUBAMUM LETTER PHASE-F SHI" +
	"IBAMUM LETTER PHASE-F SIBAMUM LETTER PHASE-F SEUXBAMUM LETTER PHASE-F KY" +
	"EEBAMUM LETTER PHASE-F KETBAMUM LETTER PHASE-F NUAEBAMUM LETTER PHASE-F " +
	"NUBAMUM LETTER PHASE-F NJUAEBAMUM LETTER PHASE-F YOQBAMUM LETTER PHASE-F" +
	" SHUBAMUM LETTER PHASE-F YABAMUM LETTER PHASE-F NSHABAMUM LETTER PHASE-F" +
	" PEUXBAMUM LETTER PHASE-F NTEEBAMUM LETTER PHASE-F WUEBAMUM LETTER PHASE" +
	"-F PEEBAMUM LETTER PHASE-F RUBAMUM LETTER PHASE-F NIBAMUM LETTER PHASE-F" +
	" REUXBAMUM LETTER PHASE-F KENBAMUM LETTER PHASE-F NGKWAENBAMUM LETTER PH" +
	"ASE-F NGGABAMUM LETTER PHASE-F SHOBAMUM LETTER PHASE-F PUAEBAMUM LETTER " +
	"PHASE-F FOMBAMUM LETTER PHASE-F WABAMUM LETTER PHASE-F LIBAMUM LETTER PH" +
	"ASE-F LOQBAMUM LETTER PHASE-F KOBAMUM LETTER PHASE-F MBENBAMUM LETTER PH" +
	"ASE-F RENBAMUM LETTER PHASE-F MABAMUM LETTER PHASE-F MOBAMUM LETTER PHAS" +
	"E-F MBAABAMUM LETTER PHASE-F TETBAMUM LETTER PHASE-F KPABAMUM LETTER PHA" +
	"SE-F SAMBABAMUM LETTER PHASE-F VUEQMRO LETTER TAMRO LETTER NGIMRO LETTER" +
	" YOMRO LETTER MIMMRO LETTER BAMRO LETTER DAMRO LETTER AMRO LETTER PHIMRO" +
	" LETTER KHAIMRO LETTER HAOMRO LETTER DAIMRO LETTER CHUMRO LETTER KEAAEMR" +
	"O LETTER OLMRO LETTER MAEMMRO LETTER NINMRO LETTER PAMRO LETTER OOMRO LE") + ("" +
	"TTER OMRO LETTER ROMRO LETTER SHIMRO LETTER THEAMRO LETTER EAMRO LETTER " +
	"WAMRO LETTER EMRO LETTER KOMRO LETTER LANMRO LETTER LAMRO LETTER HAIMRO " +
	"LETTER RIMRO LETTER TEKMRO DIGIT ZEROMRO DIGIT ONEMRO DIGIT TWOMRO DIGIT" +
	" THREEMRO DIGIT FOURMRO DIGIT FIVEMRO DIGIT SIXMRO DIGIT SEVENMRO DIGIT " +
	"EIGHTMRO DIGIT NINEMRO DANDAMRO DOUBLE DANDABASSA VAH LETTER ENNIBASSA V" +
	"AH LETTER KABASSA VAH LETTER SEBASSA VAH LETTER FABASSA VAH LETTER MBEBA" +
	"SSA VAH LETTER YIEBASSA VAH LETTER GAHBASSA VAH LETTER DHIIBASSA VAH LET" +
	"TER KPAHBASSA VAH LETTER JOBASSA VAH LETTER HWAHBASSA VAH LETTER WABASSA" +
	" VAH LETTER ZOBASSA VAH LETTER GBUBASSA VAH LETTER DOBASSA VAH LETTER CE" +
	"BASSA VAH LETTER UWUBASSA VAH LETTER TOBASSA VAH LETTER BABASSA VAH LETT" +
	"ER VUBASSA VAH LETTER YEINBASSA VAH LETTER PABASSA VAH LETTER WADDABASSA" +
	" VAH LETTER ABASSA VAH LETTER OBASSA VAH LETTER OOBASSA VAH LETTER UBASS" +
	"A VAH LETTER EEBASSA VAH LETTER EBASSA VAH LETTER IBASSA VAH COMBINING H" +
	"IGH TONEBASSA VAH COMBINING LOW TONEBASSA VAH COMBINING MID TONEBASSA VA" +
	"H COMBINING LOW-MID TONEBASSA VAH COMBINING HIGH-LOW TONEBASSA VAH FULL " +
	"STOPPAHAWH HMONG VOWEL KEEBPAHAWH HMONG VOWEL KEEVPAHAWH HMONG VOWEL KIB" +
	"PAHAWH HMONG VOWEL KIVPAHAWH HMONG VOWEL KAUBPAHAWH HMONG VOWEL KAUVPAHA" +
	"WH HMONG VOWEL KUBPAHAWH HMONG VOWEL KUVPAHAWH HMONG VOWEL KEBPAHAWH HMO" +
	"NG VOWEL KEVPAHAWH HMONG VOWEL KAIBPAHAWH HMONG VOWEL KAIVPAHAWH HMONG V" +
	"OWEL KOOBPAHAWH HMONG VOWEL KOOVPAHAWH HMONG VOWEL KAWBPAHAWH HMONG VOWE" +
	"L KAWVPAHAWH HMONG VOWEL KUABPAHAWH HMONG VOWEL KUAVPAHAWH HMONG VOWEL K" +
	"OBPAHAWH HMONG VOWEL KOVPAHAWH HMONG VOWEL KIABPAHAWH HMONG VOWEL KIAVPA" +
	"HAWH HMONG VOWEL KABPAHAWH HMONG VOWEL KAVPAHAWH HMONG VOWEL KWBPAHAWH H" +
	"MONG VOWEL KWVPAHAWH HMONG VOWEL KAABPAHAWH HMONG VOWEL KAAVPAHAWH HMONG" +
	" CONSONANT VAUPAHAWH HMONG CONSONANT NTSAUPAHAWH HMONG CONSONANT LAUPAHA" +
	"WH HMONG CONSONANT HAUPAHAWH HMONG CONSONANT NLAUPAHAWH HMONG CONSONANT " +
	"RAUPAHAWH HMONG CONSONANT NKAUPAHAWH HMONG CONSONANT QHAUPAHAWH HMONG CO" +
	"NSONANT YAUPAHAWH HMONG CONSONANT HLAUPAHAWH HMONG CONSONANT MAUPAHAWH H" +
	"MONG CONSONANT CHAUPAHAWH HMONG CONSONANT NCHAUPAHAWH HMONG CONSONANT HN" +
	"AUPAHAWH HMONG CONSONANT PLHAUPAHAWH HMONG CONSONANT NTHAUPAHAWH HMONG C" +
	"ONSONANT NAUPAHAWH HMONG CONSONANT AUPAHAWH HMONG CONSONANT XAUPAHAWH HM" +
	"ONG CONSONANT CAUPAHAWH HMONG MARK CIM TUBPAHAWH HMONG MARK CIM SOPAHAWH" +
	" HMONG MARK CIM KESPAHAWH HMONG MARK CIM KHAVPAHAWH HMONG MARK CIM SUAMP" +
	"AHAWH HMONG MARK CIM HOMPAHAWH HMONG MARK CIM TAUMPAHAWH HMONG SIGN VOS " +
	"THOMPAHAWH HMONG SIGN VOS TSHAB CEEBPAHAWH HMONG SIGN CIM CHEEMPAHAWH HM" +
	"ONG SIGN VOS THIABPAHAWH HMONG SIGN VOS FEEMPAHAWH HMONG SIGN XYEEM NTXI" +
	"VPAHAWH HMONG SIGN XYEEM RHOPAHAWH HMONG SIGN XYEEM TOVPAHAWH HMONG SIGN" +
	" XYEEM FAIBPAHAWH HMONG SIGN VOS SEEVPAHAWH HMONG SIGN MEEJ SUABPAHAWH H" +
	"MONG SIGN VOS NRUAPAHAWH HMONG SIGN IB YAMPAHAWH HMONG SIGN XAUSPAHAWH H" +
	"MONG SIGN CIM TSOV ROGPAHAWH HMONG DIGIT ZEROPAHAWH HMONG DIGIT ONEPAHAW" +
	"H HMONG DIGIT TWOPAHAWH HMONG DIGIT THREEPAHAWH HMONG DIGIT FOURPAHAWH H" +
	"MONG DIGIT FIVEPAHAWH HMONG DIGIT SIXPAHAWH HMONG DIGIT SEVENPAHAWH HMON" +
	"G DIGIT EIGHTPAHAWH HMONG DIGIT NINEPAHAWH HMONG NUMBER TENSPAHAWH HMONG" +
	" NUMBER HUNDREDSPAHAWH HMONG NUMBER TEN THOUSANDSPAHAWH HMONG NUMBER MIL" +
	"LIONSPAHAWH HMONG NUMBER HUNDRED MILLIONSPAHAWH HMONG NUMBER TEN BILLION" +
	"SPAHAWH HMONG NUMBER TRILLIONSPAHAWH HMONG SIGN VOS LUBPAHAWH HMONG SIGN" +
	" XYOOPAHAWH HMONG SIGN HLIPAHAWH HMONG SIGN THIRD-STAGE HLIPAHAWH HMONG " +
	"SIGN ZWJ THAJPAHAWH HMONG SIGN HNUBPAHAWH HMONG SIGN NQIGPAHAWH HMONG SI" +
	"GN XIABPAHAWH HMONG SIGN NTUJPAHAWH HMONG SIGN AVPAHAWH HMONG SIGN TXHEE" +
	"J CEEVPAHAWH HMONG SIGN MEEJ TSEEBPAHAWH HMONG SIGN TAUPAHAWH HMONG SIGN" +
	" LOSPAHAWH HMONG SIGN MUSPAHAWH HMONG SIGN CIM HAIS LUS NTOG NTOGPAHAWH " +
	"HMONG SIGN CIM CUAM TSHOOJPAHAWH HMONG SIGN CIM TXWVPAHAWH HMONG SIGN CI" +
	"M TXWV CHWVPAHAWH HMONG SIGN CIM PUB DAWBPAHAWH HMONG SIGN CIM NRES TOSP" +
	"AHAWH HMONG CLAN SIGN TSHEEJPAHAWH HMONG CLAN SIGN YEEGPAHAWH HMONG CLAN" +
	" SIGN LISPAHAWH HMONG CLAN SIGN LAUJPAHAWH HMONG CLAN SIGN XYOOJPAHAWH H" +
	"MONG CLAN SIGN KOOPAHAWH HMONG CLAN SIGN HAWJPAHAWH HMONG CLAN SIGN MUAS" +
	"PAHAWH HMONG CLAN SIGN THOJPAHAWH HMONG CLAN SIGN TSABPAHAWH HMONG CLAN " +
	"SIGN PHABPAHAWH HMONG CLAN SIGN KHABPAHAWH HMONG CLAN SIGN HAMPAHAWH HMO" +
	"NG CLAN SIGN VAJPAHAWH HMONG CLAN SIGN FAJPAHAWH HMONG CLAN SIGN YAJPAHA" +
	"WH HMONG CLAN SIGN TSWBPAHAWH HMONG CLAN SIGN KWMPAHAWH HMONG CLAN SIGN " +
	"VWJMEDEFAIDRIN CAPITAL LETTER MMEDEFAIDRIN CAPITAL LETTER SMEDEFAIDRIN C" +
	"APITAL LETTER VMEDEFAIDRIN CAPITAL LETTER WMEDEFAIDRIN CAPITAL LETTER AT" +
	"IUMEDEFAIDRIN CAPITAL LETTER ZMEDEFAIDRIN CAPITAL LETTER KPMEDEFAIDRIN C" +
	"APITAL LETTER PMEDEFAIDRIN CAPITAL LETTER TMEDEFAIDRIN CAPITAL LETTER GM") + ("" +
	"EDEFAIDRIN CAPITAL LETTER FMEDEFAIDRIN CAPITAL LETTER IMEDEFAIDRIN CAPIT" +
	"AL LETTER KMEDEFAIDRIN CAPITAL LETTER AMEDEFAIDRIN CAPITAL LETTER JMEDEF" +
	"AIDRIN CAPITAL LETTER EMEDEFAIDRIN CAPITAL LETTER BMEDEFAIDRIN CAPITAL L" +
	"ETTER CMEDEFAIDRIN CAPITAL LETTER UMEDEFAIDRIN CAPITAL LETTER YUMEDEFAID" +
	"RIN CAPITAL LETTER LMEDEFAIDRIN CAPITAL LETTER QMEDEFAIDRIN CAPITAL LETT" +
	"ER HPMEDEFAIDRIN CAPITAL LETTER NYMEDEFAIDRIN CAPITAL LETTER XMEDEFAIDRI" +
	"N CAPITAL LETTER DMEDEFAIDRIN CAPITAL LETTER OEMEDEFAIDRIN CAPITAL LETTE" +
	"R NMEDEFAIDRIN CAPITAL LETTER RMEDEFAIDRIN CAPITAL LETTER OMEDEFAIDRIN C" +
	"APITAL LETTER AIMEDEFAIDRIN CAPITAL LETTER YMEDEFAIDRIN SMALL LETTER MME" +
	"DEFAIDRIN SMALL LETTER SMEDEFAIDRIN SMALL LETTER VMEDEFAIDRIN SMALL LETT" +
	"ER WMEDEFAIDRIN SMALL LETTER ATIUMEDEFAIDRIN SMALL LETTER ZMEDEFAIDRIN S" +
	"MALL LETTER KPMEDEFAIDRIN SMALL LETTER PMEDEFAIDRIN SMALL LETTER TMEDEFA" +
	"IDRIN SMALL LETTER GMEDEFAIDRIN SMALL LETTER FMEDEFAIDRIN SMALL LETTER I" +
	"MEDEFAIDRIN SMALL LETTER KMEDEFAIDRIN SMALL LETTER AMEDEFAIDRIN SMALL LE" +
	"TTER JMEDEFAIDRIN SMALL LETTER EMEDEFAIDRIN SMALL LETTER BMEDEFAIDRIN SM" +
	"ALL LETTER CMEDEFAIDRIN SMALL LETTER UMEDEFAIDRIN SMALL LETTER YUMEDEFAI" +
	"DRIN SMALL LETTER LMEDEFAIDRIN SMALL LETTER QMEDEFAIDRIN SMALL LETTER HP" +
	"MEDEFAIDRIN SMALL LETTER NYMEDEFAIDRIN SMALL LETTER XMEDEFAIDRIN SMALL L" +
	"ETTER DMEDEFAIDRIN SMALL LETTER OEMEDEFAIDRIN SMALL LETTER NMEDEFAIDRIN " +
	"SMALL LETTER RMEDEFAIDRIN SMALL LETTER OMEDEFAIDRIN SMALL LETTER AIMEDEF" +
	"AIDRIN SMALL LETTER YMEDEFAIDRIN DIGIT ZEROMEDEFAIDRIN DIGIT ONEMEDEFAID" +
	"RIN DIGIT TWOMEDEFAIDRIN DIGIT THREEMEDEFAIDRIN DIGIT FOURMEDEFAIDRIN DI" +
	"GIT FIVEMEDEFAIDRIN DIGIT SIXMEDEFAIDRIN DIGIT SEVENMEDEFAIDRIN DIGIT EI" +
	"GHTMEDEFAIDRIN DIGIT NINEMEDEFAIDRIN NUMBER TENMEDEFAIDRIN NUMBER ELEVEN" +
	"MEDEFAIDRIN NUMBER TWELVEMEDEFAIDRIN NUMBER THIRTEENMEDEFAIDRIN NUMBER F" +
	"OURTEENMEDEFAIDRIN NUMBER FIFTEENMEDEFAIDRIN NUMBER SIXTEENMEDEFAIDRIN N" +
	"UMBER SEVENTEENMEDEFAIDRIN NUMBER EIGHTEENMEDEFAIDRIN NUMBER NINETEENMED" +
	"EFAIDRIN DIGIT ONE ALTERNATE FORMMEDEFAIDRIN DIGIT TWO ALTERNATE FORMMED" +
	"EFAIDRIN DIGIT THREE ALTERNATE FORMMEDEFAIDRIN COMMAMEDEFAIDRIN FULL STO" +
	"PMEDEFAIDRIN SYMBOL AIVAMEDEFAIDRIN EXCLAMATION OHMIAO LETTER PAMIAO LET" +
	"TER BAMIAO LETTER YI PAMIAO LETTER PLAMIAO LETTER MAMIAO LETTER MHAMIAO " +
	"LETTER ARCHAIC MAMIAO LETTER FAMIAO LETTER VAMIAO LETTER VFAMIAO LETTER " +
	"TAMIAO LETTER DAMIAO LETTER YI TTAMIAO LETTER YI TAMIAO LETTER TTAMIAO L" +
	"ETTER DDAMIAO LETTER NAMIAO LETTER NHAMIAO LETTER YI NNAMIAO LETTER ARCH" +
	"AIC NAMIAO LETTER NNAMIAO LETTER NNHAMIAO LETTER LAMIAO LETTER LYAMIAO L" +
	"ETTER LHAMIAO LETTER LHYAMIAO LETTER TLHAMIAO LETTER DLHAMIAO LETTER TLH" +
	"YAMIAO LETTER DLHYAMIAO LETTER KAMIAO LETTER GAMIAO LETTER YI KAMIAO LET" +
	"TER QAMIAO LETTER QGAMIAO LETTER NGAMIAO LETTER NGHAMIAO LETTER ARCHAIC " +
	"NGAMIAO LETTER HAMIAO LETTER XAMIAO LETTER GHAMIAO LETTER GHHAMIAO LETTE" +
	"R TSSAMIAO LETTER DZZAMIAO LETTER NYAMIAO LETTER NYHAMIAO LETTER TSHAMIA" +
	"O LETTER DZHAMIAO LETTER YI TSHAMIAO LETTER YI DZHAMIAO LETTER REFORMED " +
	"TSHAMIAO LETTER SHAMIAO LETTER SSAMIAO LETTER ZHAMIAO LETTER ZSHAMIAO LE" +
	"TTER TSAMIAO LETTER DZAMIAO LETTER YI TSAMIAO LETTER SAMIAO LETTER ZAMIA" +
	"O LETTER ZSAMIAO LETTER ZZAMIAO LETTER ZZSAMIAO LETTER ARCHAIC ZZAMIAO L" +
	"ETTER ZZYAMIAO LETTER ZZSYAMIAO LETTER WAMIAO LETTER AHMIAO LETTER HHAMI" +
	"AO LETTER NASALIZATIONMIAO SIGN ASPIRATIONMIAO SIGN REFORMED VOICINGMIAO" +
	" SIGN REFORMED ASPIRATIONMIAO VOWEL SIGN AMIAO VOWEL SIGN AAMIAO VOWEL S" +
	"IGN AHHMIAO VOWEL SIGN ANMIAO VOWEL SIGN ANGMIAO VOWEL SIGN OMIAO VOWEL " +
	"SIGN OOMIAO VOWEL SIGN WOMIAO VOWEL SIGN WMIAO VOWEL SIGN EMIAO VOWEL SI" +
	"GN ENMIAO VOWEL SIGN ENGMIAO VOWEL SIGN OEYMIAO VOWEL SIGN IMIAO VOWEL S" +
	"IGN IAMIAO VOWEL SIGN IANMIAO VOWEL SIGN IANGMIAO VOWEL SIGN IOMIAO VOWE" +
	"L SIGN IEMIAO VOWEL SIGN IIMIAO VOWEL SIGN IUMIAO VOWEL SIGN INGMIAO VOW" +
	"EL SIGN UMIAO VOWEL SIGN UAMIAO VOWEL SIGN UANMIAO VOWEL SIGN UANGMIAO V" +
	"OWEL SIGN UUMIAO VOWEL SIGN UEIMIAO VOWEL SIGN UNGMIAO VOWEL SIGN YMIAO " +
	"VOWEL SIGN YIMIAO VOWEL SIGN AEMIAO VOWEL SIGN AEEMIAO VOWEL SIGN ERRMIA" +
	"O VOWEL SIGN ROUNDED ERRMIAO VOWEL SIGN ERMIAO VOWEL SIGN ROUNDED ERMIAO" +
	" VOWEL SIGN AIMIAO VOWEL SIGN EIMIAO VOWEL SIGN AUMIAO VOWEL SIGN OUMIAO" +
	" VOWEL SIGN NMIAO VOWEL SIGN NGMIAO TONE RIGHTMIAO TONE TOP RIGHTMIAO TO" +
	"NE ABOVEMIAO TONE BELOWMIAO LETTER TONE-2MIAO LETTER TONE-3MIAO LETTER T" +
	"ONE-4MIAO LETTER TONE-5MIAO LETTER TONE-6MIAO LETTER TONE-7MIAO LETTER T" +
	"ONE-8MIAO LETTER REFORMED TONE-1MIAO LETTER REFORMED TONE-2MIAO LETTER R" +
	"EFORMED TONE-4MIAO LETTER REFORMED TONE-5MIAO LETTER REFORMED TONE-6MIAO" +
	" LETTER REFORMED TONE-8TANGUT ITERATION MARKNUSHU ITERATION MARKTANGUT C" +
	"OMPONENT-001TANGUT COMPONENT-002TANGUT COMPONENT-003TANGUT COMPONENT-004") + ("" +
	"TANGUT COMPONENT-005TANGUT COMPONENT-006TANGUT COMPONENT-007TANGUT COMPO" +
	"NENT-008TANGUT COMPONENT-009TANGUT COMPONENT-010TANGUT COMPONENT-011TANG" +
	"UT COMPONENT-012TANGUT COMPONENT-013TANGUT COMPONENT-014TANGUT COMPONENT" +
	"-015TANGUT COMPONENT-016TANGUT COMPONENT-017TANGUT COMPONENT-018TANGUT C" +
	"OMPONENT-019TANGUT COMPONENT-020TANGUT COMPONENT-021TANGUT COMPONENT-022" +
	"TANGUT COMPONENT-023TANGUT COMPONENT-024TANGUT COMPONENT-025TANGUT COMPO" +
	"NENT-026TANGUT COMPONENT-027TANGUT COMPONENT-028TANGUT COMPONENT-029TANG" +
	"UT COMPONENT-030TANGUT COMPONENT-031TANGUT COMPONENT-032TANGUT COMPONENT" +
	"-033TANGUT COMPONENT-034TANGUT COMPONENT-035TANGUT COMPONENT-036TANGUT C" +
	"OMPONENT-037TANGUT COMPONENT-038TANGUT COMPONENT-039TANGUT COMPONENT-040" +
	"TANGUT COMPONENT-041TANGUT COMPONENT-042TANGUT COMPONENT-043TANGUT COMPO" +
	"NENT-044TANGUT COMPONENT-045TANGUT COMPONENT-046TANGUT COMPONENT-047TANG" +
	"UT COMPONENT-048TANGUT COMPONENT-049TANGUT COMPONENT-050TANGUT COMPONENT" +
	"-051TANGUT COMPONENT-052TANGUT COMPONENT-053TANGUT COMPONENT-054TANGUT C" +
	"OMPONENT-055TANGUT COMPONENT-056TANGUT COMPONENT-057TANGUT COMPONENT-058" +
	"TANGUT COMPONENT-059TANGUT COMPONENT-060TANGUT COMPONENT-061TANGUT COMPO" +
	"NENT-062TANGUT COMPONENT-063TANGUT COMPONENT-064TANGUT COMPONENT-065TANG" +
	"UT COMPONENT-066TANGUT COMPONENT-067TANGUT COMPONENT-068TANGUT COMPONENT" +
	"-069TANGUT COMPONENT-070TANGUT COMPONENT-071TANGUT COMPONENT-072TANGUT C" +
	"OMPONENT-073TANGUT COMPONENT-074TANGUT COMPONENT-075TANGUT COMPONENT-076" +
	"TANGUT COMPONENT-077TANGUT COMPONENT-078TANGUT COMPONENT-079TANGUT COMPO" +
	"NENT-080TANGUT COMPONENT-081TANGUT COMPONENT-082TANGUT COMPONENT-083TANG" +
	"UT COMPONENT-084TANGUT COMPONENT-085TANGUT COMPONENT-086TANGUT COMPONENT" +
	"-087TANGUT COMPONENT-088TANGUT COMPONENT-089TANGUT COMPONENT-090TANGUT C" +
	"OMPONENT-091TANGUT COMPONENT-092TANGUT COMPONENT-093TANGUT COMPONENT-094" +
	"TANGUT COMPONENT-095TANGUT COMPONENT-096TANGUT COMPONENT-097TANGUT COMPO" +
	"NENT-098TANGUT COMPONENT-099TANGUT COMPONENT-100TANGUT COMPONENT-101TANG" +
	"UT COMPONENT-102TANGUT COMPONENT-103TANGUT COMPONENT-104TANGUT COMPONENT" +
	"-105TANGUT COMPONENT-106TANGUT COMPONENT-107TANGUT COMPONENT-108TANGUT C" +
	"OMPONENT-109TANGUT COMPONENT-110TANGUT COMPONENT-111TANGUT COMPONENT-112" +
	"TANGUT COMPONENT-113TANGUT COMPONENT-114TANGUT COMPONENT-115TANGUT COMPO" +
	"NENT-116TANGUT COMPONENT-117TANGUT COMPONENT-118TANGUT COMPONENT-119TANG" +
	"UT COMPONENT-120TANGUT COMPONENT-121TANGUT COMPONENT-122TANGUT COMPONENT" +
	"-123TANGUT COMPONENT-124TANGUT COMPONENT-125TANGUT COMPONENT-126TANGUT C" +
	"OMPONENT-127TANGUT COMPONENT-128TANGUT COMPONENT-129TANGUT COMPONENT-130" +
	"TANGUT COMPONENT-131TANGUT COMPONENT-132TANGUT COMPONENT-133TANGUT COMPO" +
	"NENT-134TANGUT COMPONENT-135TANGUT COMPONENT-136TANGUT COMPONENT-137TANG" +
	"UT COMPONENT-138TANGUT COMPONENT-139TANGUT COMPONENT-140TANGUT COMPONENT" +
	"-141TANGUT COMPONENT-142TANGUT COMPONENT-143TANGUT COMPONENT-144TANGUT C" +
	"OMPONENT-145TANGUT COMPONENT-146TANGUT COMPONENT-147TANGUT COMPONENT-148" +
	"TANGUT COMPONENT-149TANGUT COMPONENT-150TANGUT COMPONENT-151TANGUT COMPO" +
	"NENT-152TANGUT COMPONENT-153TANGUT COMPONENT-154TANGUT COMPONENT-155TANG" +
	"UT COMPONENT-156TANGUT COMPONENT-157TANGUT COMPONENT-158TANGUT COMPONENT" +
	"-159TANGUT COMPONENT-160TANGUT COMPONENT-161TANGUT COMPONENT-162TANGUT C" +
	"OMPONENT-163TANGUT COMPONENT-164TANGUT COMPONENT-165TANGUT COMPONENT-166" +
	"TANGUT COMPONENT-167TANGUT COMPONENT-168TANGUT COMPONENT-169TANGUT COMPO" +
	"NENT-170TANGUT COMPONENT-171TANGUT COMPONENT-172TANGUT COMPONENT-173TANG" +
	"UT COMPONENT-174TANGUT COMPONENT-175TANGUT COMPONENT-176TANGUT COMPONENT" +
	"-177TANGUT COMPONENT-178TANGUT COMPONENT-179TANGUT COMPONENT-180TANGUT C" +
	"OMPONENT-181TANGUT COMPONENT-182TANGUT COMPONENT-183TANGUT COMPONENT-184" +
	"TANGUT COMPONENT-185TANGUT COMPONENT-186TANGUT COMPONENT-187TANGUT COMPO" +
	"NENT-188TANGUT COMPONENT-189TANGUT COMPONENT-190TANGUT COMPONENT-191TANG" +
	"UT COMPONENT-192TANGUT COMPONENT-193TANGUT COMPONENT-194TANGUT COMPONENT" +
	"-195TANGUT COMPONENT-196TANGUT COMPONENT-197TANGUT COMPONENT-198TANGUT C" +
	"OMPONENT-199TANGUT COMPONENT-200TANGUT COMPONENT-201TANGUT COMPONENT-202" +
	"TANGUT COMPONENT-203TANGUT COMPONENT-204TANGUT COMPONENT-205TANGUT COMPO" +
	"NENT-206TANGUT COMPONENT-207TANGUT COMPONENT-208TANGUT COMPONENT-209TANG" +
	"UT COMPONENT-210TANGUT COMPONENT-211TANGUT COMPONENT-212TANGUT COMPONENT" +
	"-213TANGUT COMPONENT-214TANGUT COMPONENT-215TANGUT COMPONENT-216TANGUT C" +
	"OMPONENT-217TANGUT COMPONENT-218TANGUT COMPONENT-219TANGUT COMPONENT-220" +
	"TANGUT COMPONENT-221TANGUT COMPONENT-222TANGUT COMPONENT-223TANGUT COMPO" +
	"NENT-224TANGUT COMPONENT-225TANGUT COMPONENT-226TANGUT COMPONENT-227TANG" +
	"UT COMPONENT-228TANGUT COMPONENT-229TANGUT COMPONENT-230TANGUT COMPONENT" +
	"-231TANGUT COMPONENT-232TANGUT COMPONENT-233TANGUT COMPONENT-234TANGUT C") + ("" +
	"OMPONENT-235TANGUT COMPONENT-236TANGUT COMPONENT-237TANGUT COMPONENT-238" +
	"TANGUT COMPONENT-239TANGUT COMPONENT-240TANGUT COMPONENT-241TANGUT COMPO" +
	"NENT-242TANGUT COMPONENT-243TANGUT COMPONENT-244TANGUT COMPONENT-245TANG" +
	"UT COMPONENT-246TANGUT COMPONENT-247TANGUT COMPONENT-248TANGUT COMPONENT" +
	"-249TANGUT COMPONENT-250TANGUT COMPONENT-251TANGUT COMPONENT-252TANGUT C" +
	"OMPONENT-253TANGUT COMPONENT-254TANGUT COMPONENT-255TANGUT COMPONENT-256" +
	"TANGUT COMPONENT-257TANGUT COMPONENT-258TANGUT COMPONENT-259TANGUT COMPO" +
	"NENT-260TANGUT COMPONENT-261TANGUT COMPONENT-262TANGUT COMPONENT-263TANG" +
	"UT COMPONENT-264TANGUT COMPONENT-265TANGUT COMPONENT-266TANGUT COMPONENT" +
	"-267TANGUT COMPONENT-268TANGUT COMPONENT-269TANGUT COMPONENT-270TANGUT C" +
	"OMPONENT-271TANGUT COMPONENT-272TANGUT COMPONENT-273TANGUT COMPONENT-274" +
	"TANGUT COMPONENT-275TANGUT COMPONENT-276TANGUT COMPONENT-277TANGUT COMPO" +
	"NENT-278TANGUT COMPONENT-279TANGUT COMPONENT-280TANGUT COMPONENT-281TANG" +
	"UT COMPONENT-282TANGUT COMPONENT-283TANGUT COMPONENT-284TANGUT COMPONENT" +
	"-285TANGUT COMPONENT-286TANGUT COMPONENT-287TANGUT COMPONENT-288TANGUT C" +
	"OMPONENT-289TANGUT COMPONENT-290TANGUT COMPONENT-291TANGUT COMPONENT-292" +
	"TANGUT COMPONENT-293TANGUT COMPONENT-294TANGUT COMPONENT-295TANGUT COMPO" +
	"NENT-296TANGUT COMPONENT-297TANGUT COMPONENT-298TANGUT COMPONENT-299TANG" +
	"UT COMPONENT-300TANGUT COMPONENT-301TANGUT COMPONENT-302TANGUT COMPONENT" +
	"-303TANGUT COMPONENT-304TANGUT COMPONENT-305TANGUT COMPONENT-306TANGUT C" +
	"OMPONENT-307TANGUT COMPONENT-308TANGUT COMPONENT-309TANGUT COMPONENT-310" +
	"TANGUT COMPONENT-311TANGUT COMPONENT-312TANGUT COMPONENT-313TANGUT COMPO" +
	"NENT-314TANGUT COMPONENT-315TANGUT COMPONENT-316TANGUT COMPONENT-317TANG" +
	"UT COMPONENT-318TANGUT COMPONENT-319TANGUT COMPONENT-320TANGUT COMPONENT" +
	"-321TANGUT COMPONENT-322TANGUT COMPONENT-323TANGUT COMPONENT-324TANGUT C" +
	"OMPONENT-325TANGUT COMPONENT-326TANGUT COMPONENT-327TANGUT COMPONENT-328" +
	"TANGUT COMPONENT-329TANGUT COMPONENT-330TANGUT COMPONENT-331TANGUT COMPO" +
	"NENT-332TANGUT COMPONENT-333TANGUT COMPONENT-334TANGUT COMPONENT-335TANG" +
	"UT COMPONENT-336TANGUT COMPONENT-337TANGUT COMPONENT-338TANGUT COMPONENT" +
	"-339TANGUT COMPONENT-340TANGUT COMPONENT-341TANGUT COMPONENT-342TANGUT C" +
	"OMPONENT-343TANGUT COMPONENT-344TANGUT COMPONENT-345TANGUT COMPONENT-346" +
	"TANGUT COMPONENT-347TANGUT COMPONENT-348TANGUT COMPONENT-349TANGUT COMPO" +
	"NENT-350TANGUT COMPONENT-351TANGUT COMPONENT-352TANGUT COMPONENT-353TANG" +
	"UT COMPONENT-354TANGUT COMPONENT-355TANGUT COMPONENT-356TANGUT COMPONENT" +
	"-357TANGUT COMPONENT-358TANGUT COMPONENT-359TANGUT COMPONENT-360TANGUT C" +
	"OMPONENT-361TANGUT COMPONENT-362TANGUT COMPONENT-363TANGUT COMPONENT-364" +
	"TANGUT COMPONENT-365TANGUT COMPONENT-366TANGUT COMPONENT-367TANGUT COMPO" +
	"NENT-368TANGUT COMPONENT-369TANGUT COMPONENT-370TANGUT COMPONENT-371TANG" +
	"UT COMPONENT-372TANGUT COMPONENT-373TANGUT COMPONENT-374TANGUT COMPONENT" +
	"-375TANGUT COMPONENT-376TANGUT COMPONENT-377TANGUT COMPONENT-378TANGUT C" +
	"OMPONENT-379TANGUT COMPONENT-380TANGUT COMPONENT-381TANGUT COMPONENT-382" +
	"TANGUT COMPONENT-383TANGUT COMPONENT-384TANGUT COMPONENT-385TANGUT COMPO" +
	"NENT-386TANGUT COMPONENT-387TANGUT COMPONENT-388TANGUT COMPONENT-389TANG" +
	"UT COMPONENT-390TANGUT COMPONENT-391TANGUT COMPONENT-392TANGUT COMPONENT" +
	"-393TANGUT COMPONENT-394TANGUT COMPONENT-395TANGUT COMPONENT-396TANGUT C" +
	"OMPONENT-397TANGUT COMPONENT-398TANGUT COMPONENT-399TANGUT COMPONENT-400" +
	"TANGUT COMPONENT-401TANGUT COMPONENT-402TANGUT COMPONENT-403TANGUT COMPO" +
	"NENT-404TANGUT COMPONENT-405TANGUT COMPONENT-406TANGUT COMPONENT-407TANG" +
	"UT COMPONENT-408TANGUT COMPONENT-409TANGUT COMPONENT-410TANGUT COMPONENT" +
	"-411TANGUT COMPONENT-412TANGUT COMPONENT-413TANGUT COMPONENT-414TANGUT C" +
	"OMPONENT-415TANGUT COMPONENT-416TANGUT COMPONENT-417TANGUT COMPONENT-418" +
	"TANGUT COMPONENT-419TANGUT COMPONENT-420TANGUT COMPONENT-421TANGUT COMPO" +
	"NENT-422TANGUT COMPONENT-423TANGUT COMPONENT-424TANGUT COMPONENT-425TANG" +
	"UT COMPONENT-426TANGUT COMPONENT-427TANGUT COMPONENT-428TANGUT COMPONENT" +
	"-429TANGUT COMPONENT-430TANGUT COMPONENT-431TANGUT COMPONENT-432TANGUT C" +
	"OMPONENT-433TANGUT COMPONENT-434TANGUT COMPONENT-435TANGUT COMPONENT-436" +
	"TANGUT COMPONENT-437TANGUT COMPONENT-438TANGUT COMPONENT-439TANGUT COMPO" +
	"NENT-440TANGUT COMPONENT-441TANGUT COMPONENT-442TANGUT COMPONENT-443TANG" +
	"UT COMPONENT-444TANGUT COMPONENT-445TANGUT COMPONENT-446TANGUT COMPONENT" +
	"-447TANGUT COMPONENT-448TANGUT COMPONENT-449TANGUT COMPONENT-450TANGUT C" +
	"OMPONENT-451TANGUT COMPONENT-452TANGUT COMPONENT-453TANGUT COMPONENT-454" +
	"TANGUT COMPONENT-455TANGUT COMPONENT-456TANGUT COMPONENT-457TANGUT COMPO" +
	"NENT-458TANGUT COMPONENT-459TANGUT COMPONENT-460TANGUT COMPONENT-461TANG" +
	"UT COMPONENT-462TANGUT COMPONENT-463TANGUT COMPONENT-464TANGUT COMPONENT") + ("" +
	"-465TANGUT COMPONENT-466TANGUT COMPONENT-467TANGUT COMPONENT-468TANGUT C" +
	"OMPONENT-469TANGUT COMPONENT-470TANGUT COMPONENT-471TANGUT COMPONENT-472" +
	"TANGUT COMPONENT-473TANGUT COMPONENT-474TANGUT COMPONENT-475TANGUT COMPO" +
	"NENT-476TANGUT COMPONENT-477TANGUT COMPONENT-478TANGUT COMPONENT-479TANG" +
	"UT COMPONENT-480TANGUT COMPONENT-481TANGUT COMPONENT-482TANGUT COMPONENT" +
	"-483TANGUT COMPONENT-484TANGUT COMPONENT-485TANGUT COMPONENT-486TANGUT C" +
	"OMPONENT-487TANGUT COMPONENT-488TANGUT COMPONENT-489TANGUT COMPONENT-490" +
	"TANGUT COMPONENT-491TANGUT COMPONENT-492TANGUT COMPONENT-493TANGUT COMPO" +
	"NENT-494TANGUT COMPONENT-495TANGUT COMPONENT-496TANGUT COMPONENT-497TANG" +
	"UT COMPONENT-498TANGUT COMPONENT-499TANGUT COMPONENT-500TANGUT COMPONENT" +
	"-501TANGUT COMPONENT-502TANGUT COMPONENT-503TANGUT COMPONENT-504TANGUT C" +
	"OMPONENT-505TANGUT COMPONENT-506TANGUT COMPONENT-507TANGUT COMPONENT-508" +
	"TANGUT COMPONENT-509TANGUT COMPONENT-510TANGUT COMPONENT-511TANGUT COMPO" +
	"NENT-512TANGUT COMPONENT-513TANGUT COMPONENT-514TANGUT COMPONENT-515TANG" +
	"UT COMPONENT-516TANGUT COMPONENT-517TANGUT COMPONENT-518TANGUT COMPONENT" +
	"-519TANGUT COMPONENT-520TANGUT COMPONENT-521TANGUT COMPONENT-522TANGUT C" +
	"OMPONENT-523TANGUT COMPONENT-524TANGUT COMPONENT-525TANGUT COMPONENT-526" +
	"TANGUT COMPONENT-527TANGUT COMPONENT-528TANGUT COMPONENT-529TANGUT COMPO" +
	"NENT-530TANGUT COMPONENT-531TANGUT COMPONENT-532TANGUT COMPONENT-533TANG" +
	"UT COMPONENT-534TANGUT COMPONENT-535TANGUT COMPONENT-536TANGUT COMPONENT" +
	"-537TANGUT COMPONENT-538TANGUT COMPONENT-539TANGUT COMPONENT-540TANGUT C" +
	"OMPONENT-541TANGUT COMPONENT-542TANGUT COMPONENT-543TANGUT COMPONENT-544" +
	"TANGUT COMPONENT-545TANGUT COMPONENT-546TANGUT COMPONENT-547TANGUT COMPO" +
	"NENT-548TANGUT COMPONENT-549TANGUT COMPONENT-550TANGUT COMPONENT-551TANG" +
	"UT COMPONENT-552TANGUT COMPONENT-553TANGUT COMPONENT-554TANGUT COMPONENT" +
	"-555TANGUT COMPONENT-556TANGUT COMPONENT-557TANGUT COMPONENT-558TANGUT C" +
	"OMPONENT-559TANGUT COMPONENT-560TANGUT COMPONENT-561TANGUT COMPONENT-562" +
	"TANGUT COMPONENT-563TANGUT COMPONENT-564TANGUT COMPONENT-565TANGUT COMPO" +
	"NENT-566TANGUT COMPONENT-567TANGUT COMPONENT-568TANGUT COMPONENT-569TANG" +
	"UT COMPONENT-570TANGUT COMPONENT-571TANGUT COMPONENT-572TANGUT COMPONENT" +
	"-573TANGUT COMPONENT-574TANGUT COMPONENT-575TANGUT COMPONENT-576TANGUT C" +
	"OMPONENT-577TANGUT COMPONENT-578TANGUT COMPONENT-579TANGUT COMPONENT-580" +
	"TANGUT COMPONENT-581TANGUT COMPONENT-582TANGUT COMPONENT-583TANGUT COMPO" +
	"NENT-584TANGUT COMPONENT-585TANGUT COMPONENT-586TANGUT COMPONENT-587TANG" +
	"UT COMPONENT-588TANGUT COMPONENT-589TANGUT COMPONENT-590TANGUT COMPONENT" +
	"-591TANGUT COMPONENT-592TANGUT COMPONENT-593TANGUT COMPONENT-594TANGUT C" +
	"OMPONENT-595TANGUT COMPONENT-596TANGUT COMPONENT-597TANGUT COMPONENT-598" +
	"TANGUT COMPONENT-599TANGUT COMPONENT-600TANGUT COMPONENT-601TANGUT COMPO" +
	"NENT-602TANGUT COMPONENT-603TANGUT COMPONENT-604TANGUT COMPONENT-605TANG" +
	"UT COMPONENT-606TANGUT COMPONENT-607TANGUT COMPONENT-608TANGUT COMPONENT" +
	"-609TANGUT COMPONENT-610TANGUT COMPONENT-611TANGUT COMPONENT-612TANGUT C" +
	"OMPONENT-613TANGUT COMPONENT-614TANGUT COMPONENT-615TANGUT COMPONENT-616" +
	"TANGUT COMPONENT-617TANGUT COMPONENT-618TANGUT COMPONENT-619TANGUT COMPO" +
	"NENT-620TANGUT COMPONENT-621TANGUT COMPONENT-622TANGUT COMPONENT-623TANG" +
	"UT COMPONENT-624TANGUT COMPONENT-625TANGUT COMPONENT-626TANGUT COMPONENT" +
	"-627TANGUT COMPONENT-628TANGUT COMPONENT-629TANGUT COMPONENT-630TANGUT C" +
	"OMPONENT-631TANGUT COMPONENT-632TANGUT COMPONENT-633TANGUT COMPONENT-634" +
	"TANGUT COMPONENT-635TANGUT COMPONENT-636TANGUT COMPONENT-637TANGUT COMPO" +
	"NENT-638TANGUT COMPONENT-639TANGUT COMPONENT-640TANGUT COMPONENT-641TANG" +
	"UT COMPONENT-642TANGUT COMPONENT-643TANGUT COMPONENT-644TANGUT COMPONENT" +
	"-645TANGUT COMPONENT-646TANGUT COMPONENT-647TANGUT COMPONENT-648TANGUT C" +
	"OMPONENT-649TANGUT COMPONENT-650TANGUT COMPONENT-651TANGUT COMPONENT-652" +
	"TANGUT COMPONENT-653TANGUT COMPONENT-654TANGUT COMPONENT-655TANGUT COMPO" +
	"NENT-656TANGUT COMPONENT-657TANGUT COMPONENT-658TANGUT COMPONENT-659TANG" +
	"UT COMPONENT-660TANGUT COMPONENT-661TANGUT COMPONENT-662TANGUT COMPONENT" +
	"-663TANGUT COMPONENT-664TANGUT COMPONENT-665TANGUT COMPONENT-666TANGUT C" +
	"OMPONENT-667TANGUT COMPONENT-668TANGUT COMPONENT-669TANGUT COMPONENT-670" +
	"TANGUT COMPONENT-671TANGUT COMPONENT-672TANGUT COMPONENT-673TANGUT COMPO" +
	"NENT-674TANGUT COMPONENT-675TANGUT COMPONENT-676TANGUT COMPONENT-677TANG" +
	"UT COMPONENT-678TANGUT COMPONENT-679TANGUT COMPONENT-680TANGUT COMPONENT" +
	"-681TANGUT COMPONENT-682TANGUT COMPONENT-683TANGUT COMPONENT-684TANGUT C" +
	"OMPONENT-685TANGUT COMPONENT-686TANGUT COMPONENT-687TANGUT COMPONENT-688" +
	"TANGUT COMPONENT-689TANGUT COMPONENT-690TANGUT COMPONENT-691TANGUT COMPO" +
	"NENT-692TANGUT COMPONENT-693TANGUT COMPONENT-694TANGUT COMPONENT-695TANG") + ("" +
	"UT COMPONENT-696TANGUT COMPONENT-697TANGUT COMPONENT-698TANGUT COMPONENT" +
	"-699TANGUT COMPONENT-700TANGUT COMPONENT-701TANGUT COMPONENT-702TANGUT C" +
	"OMPONENT-703TANGUT COMPONENT-704TANGUT COMPONENT-705TANGUT COMPONENT-706" +
	"TANGUT COMPONENT-707TANGUT COMPONENT-708TANGUT COMPONENT-709TANGUT COMPO" +
	"NENT-710TANGUT COMPONENT-711TANGUT COMPONENT-712TANGUT COMPONENT-713TANG" +
	"UT COMPONENT-714TANGUT COMPONENT-715TANGUT COMPONENT-716TANGUT COMPONENT" +
	"-717TANGUT COMPONENT-718TANGUT COMPONENT-719TANGUT COMPONENT-720TANGUT C" +
	"OMPONENT-721TANGUT COMPONENT-722TANGUT COMPONENT-723TANGUT COMPONENT-724" +
	"TANGUT COMPONENT-725TANGUT COMPONENT-726TANGUT COMPONENT-727TANGUT COMPO" +
	"NENT-728TANGUT COMPONENT-729TANGUT COMPONENT-730TANGUT COMPONENT-731TANG" +
	"UT COMPONENT-732TANGUT COMPONENT-733TANGUT COMPONENT-734TANGUT COMPONENT" +
	"-735TANGUT COMPONENT-736TANGUT COMPONENT-737TANGUT COMPONENT-738TANGUT C" +
	"OMPONENT-739TANGUT COMPONENT-740TANGUT COMPONENT-741TANGUT COMPONENT-742" +
	"TANGUT COMPONENT-743TANGUT COMPONENT-744TANGUT COMPONENT-745TANGUT COMPO" +
	"NENT-746TANGUT COMPONENT-747TANGUT COMPONENT-748TANGUT COMPONENT-749TANG" +
	"UT COMPONENT-750TANGUT COMPONENT-751TANGUT COMPONENT-752TANGUT COMPONENT" +
	"-753TANGUT COMPONENT-754TANGUT COMPONENT-755KATAKANA LETTER ARCHAIC EHIR" +
	"AGANA LETTER ARCHAIC YEHENTAIGANA LETTER A-1HENTAIGANA LETTER A-2HENTAIG" +
	"ANA LETTER A-3HENTAIGANA LETTER A-WOHENTAIGANA LETTER I-1HENTAIGANA LETT" +
	"ER I-2HENTAIGANA LETTER I-3HENTAIGANA LETTER I-4HENTAIGANA LETTER U-1HEN" +
	"TAIGANA LETTER U-2HENTAIGANA LETTER U-3HENTAIGANA LETTER U-4HENTAIGANA L" +
	"ETTER U-5HENTAIGANA LETTER E-2HENTAIGANA LETTER E-3HENTAIGANA LETTER E-4" +
	"HENTAIGANA LETTER E-5HENTAIGANA LETTER E-6HENTAIGANA LETTER O-1HENTAIGAN" +
	"A LETTER O-2HENTAIGANA LETTER O-3HENTAIGANA LETTER KA-1HENTAIGANA LETTER" +
	" KA-2HENTAIGANA LETTER KA-3HENTAIGANA LETTER KA-4HENTAIGANA LETTER KA-5H" +
	"ENTAIGANA LETTER KA-6HENTAIGANA LETTER KA-7HENTAIGANA LETTER KA-8HENTAIG" +
	"ANA LETTER KA-9HENTAIGANA LETTER KA-10HENTAIGANA LETTER KA-11HENTAIGANA " +
	"LETTER KA-KEHENTAIGANA LETTER KI-1HENTAIGANA LETTER KI-2HENTAIGANA LETTE" +
	"R KI-3HENTAIGANA LETTER KI-4HENTAIGANA LETTER KI-5HENTAIGANA LETTER KI-6" +
	"HENTAIGANA LETTER KI-7HENTAIGANA LETTER KI-8HENTAIGANA LETTER KU-1HENTAI" +
	"GANA LETTER KU-2HENTAIGANA LETTER KU-3HENTAIGANA LETTER KU-4HENTAIGANA L" +
	"ETTER KU-5HENTAIGANA LETTER KU-6HENTAIGANA LETTER KU-7HENTAIGANA LETTER " +
	"KE-1HENTAIGANA LETTER KE-2HENTAIGANA LETTER KE-3HENTAIGANA LETTER KE-4HE" +
	"NTAIGANA LETTER KE-5HENTAIGANA LETTER KE-6HENTAIGANA LETTER KO-1HENTAIGA" +
	"NA LETTER KO-2HENTAIGANA LETTER KO-3HENTAIGANA LETTER KO-KIHENTAIGANA LE" +
	"TTER SA-1HENTAIGANA LETTER SA-2HENTAIGANA LETTER SA-3HENTAIGANA LETTER S" +
	"A-4HENTAIGANA LETTER SA-5HENTAIGANA LETTER SA-6HENTAIGANA LETTER SA-7HEN" +
	"TAIGANA LETTER SA-8HENTAIGANA LETTER SI-1HENTAIGANA LETTER SI-2HENTAIGAN" +
	"A LETTER SI-3HENTAIGANA LETTER SI-4HENTAIGANA LETTER SI-5HENTAIGANA LETT" +
	"ER SI-6HENTAIGANA LETTER SU-1HENTAIGANA LETTER SU-2HENTAIGANA LETTER SU-" +
	"3HENTAIGANA LETTER SU-4HENTAIGANA LETTER SU-5HENTAIGANA LETTER SU-6HENTA" +
	"IGANA LETTER SU-7HENTAIGANA LETTER SU-8HENTAIGANA LETTER SE-1HENTAIGANA " +
	"LETTER SE-2HENTAIGANA LETTER SE-3HENTAIGANA LETTER SE-4HENTAIGANA LETTER" +
	" SE-5HENTAIGANA LETTER SO-1HENTAIGANA LETTER SO-2HENTAIGANA LETTER SO-3H" +
	"ENTAIGANA LETTER SO-4HENTAIGANA LETTER SO-5HENTAIGANA LETTER SO-6HENTAIG" +
	"ANA LETTER SO-7HENTAIGANA LETTER TA-1HENTAIGANA LETTER TA-2HENTAIGANA LE" +
	"TTER TA-3HENTAIGANA LETTER TA-4HENTAIGANA LETTER TI-1HENTAIGANA LETTER T" +
	"I-2HENTAIGANA LETTER TI-3HENTAIGANA LETTER TI-4HENTAIGANA LETTER TI-5HEN" +
	"TAIGANA LETTER TI-6HENTAIGANA LETTER TI-7HENTAIGANA LETTER TU-1HENTAIGAN" +
	"A LETTER TU-2HENTAIGANA LETTER TU-3HENTAIGANA LETTER TU-4HENTAIGANA LETT" +
	"ER TU-TOHENTAIGANA LETTER TE-1HENTAIGANA LETTER TE-2HENTAIGANA LETTER TE" +
	"-3HENTAIGANA LETTER TE-4HENTAIGANA LETTER TE-5HENTAIGANA LETTER TE-6HENT" +
	"AIGANA LETTER TE-7HENTAIGANA LETTER TE-8HENTAIGANA LETTER TE-9HENTAIGANA" +
	" LETTER TO-1HENTAIGANA LETTER TO-2HENTAIGANA LETTER TO-3HENTAIGANA LETTE" +
	"R TO-4HENTAIGANA LETTER TO-5HENTAIGANA LETTER TO-6HENTAIGANA LETTER TO-R" +
	"AHENTAIGANA LETTER NA-1HENTAIGANA LETTER NA-2HENTAIGANA LETTER NA-3HENTA" +
	"IGANA LETTER NA-4HENTAIGANA LETTER NA-5HENTAIGANA LETTER NA-6HENTAIGANA " +
	"LETTER NA-7HENTAIGANA LETTER NA-8HENTAIGANA LETTER NA-9HENTAIGANA LETTER" +
	" NI-1HENTAIGANA LETTER NI-2HENTAIGANA LETTER NI-3HENTAIGANA LETTER NI-4H" +
	"ENTAIGANA LETTER NI-5HENTAIGANA LETTER NI-6HENTAIGANA LETTER NI-7HENTAIG" +
	"ANA LETTER NI-TEHENTAIGANA LETTER NU-1HENTAIGANA LETTER NU-2HENTAIGANA L" +
	"ETTER NU-3HENTAIGANA LETTER NE-1HENTAIGANA LETTER NE-2HENTAIGANA LETTER " +
	"NE-3HENTAIGANA LETTER NE-4HENTAIGANA LETTER NE-5HENTAIGANA LETTER NE-6HE" +
	"NTAIGANA LETTER NE-KOHENTAIGANA LETTER NO-1HENTAIGANA LETTER NO-2HENTAIG") + ("" +
	"ANA LETTER NO-3HENTAIGANA LETTER NO-4HENTAIGANA LETTER NO-5HENTAIGANA LE" +
	"TTER HA-1HENTAIGANA LETTER HA-2HENTAIGANA LETTER HA-3HENTAIGANA LETTER H" +
	"A-4HENTAIGANA LETTER HA-5HENTAIGANA LETTER HA-6HENTAIGANA LETTER HA-7HEN" +
	"TAIGANA LETTER HA-8HENTAIGANA LETTER HA-9HENTAIGANA LETTER HA-10HENTAIGA" +
	"NA LETTER HA-11HENTAIGANA LETTER HI-1HENTAIGANA LETTER HI-2HENTAIGANA LE" +
	"TTER HI-3HENTAIGANA LETTER HI-4HENTAIGANA LETTER HI-5HENTAIGANA LETTER H" +
	"I-6HENTAIGANA LETTER HI-7HENTAIGANA LETTER HU-1HENTAIGANA LETTER HU-2HEN" +
	"TAIGANA LETTER HU-3HENTAIGANA LETTER HE-1HENTAIGANA LETTER HE-2HENTAIGAN" +
	"A LETTER HE-3HENTAIGANA LETTER HE-4HENTAIGANA LETTER HE-5HENTAIGANA LETT" +
	"ER HE-6HENTAIGANA LETTER HE-7HENTAIGANA LETTER HO-1HENTAIGANA LETTER HO-" +
	"2HENTAIGANA LETTER HO-3HENTAIGANA LETTER HO-4HENTAIGANA LETTER HO-5HENTA" +
	"IGANA LETTER HO-6HENTAIGANA LETTER HO-7HENTAIGANA LETTER HO-8HENTAIGANA " +
	"LETTER MA-1HENTAIGANA LETTER MA-2HENTAIGANA LETTER MA-3HENTAIGANA LETTER" +
	" MA-4HENTAIGANA LETTER MA-5HENTAIGANA LETTER MA-6HENTAIGANA LETTER MA-7H" +
	"ENTAIGANA LETTER MI-1HENTAIGANA LETTER MI-2HENTAIGANA LETTER MI-3HENTAIG" +
	"ANA LETTER MI-4HENTAIGANA LETTER MI-5HENTAIGANA LETTER MI-6HENTAIGANA LE" +
	"TTER MI-7HENTAIGANA LETTER MU-1HENTAIGANA LETTER MU-2HENTAIGANA LETTER M" +
	"U-3HENTAIGANA LETTER MU-4HENTAIGANA LETTER ME-1HENTAIGANA LETTER ME-2HEN" +
	"TAIGANA LETTER ME-MAHENTAIGANA LETTER MO-1HENTAIGANA LETTER MO-2HENTAIGA" +
	"NA LETTER MO-3HENTAIGANA LETTER MO-4HENTAIGANA LETTER MO-5HENTAIGANA LET" +
	"TER MO-6HENTAIGANA LETTER YA-1HENTAIGANA LETTER YA-2HENTAIGANA LETTER YA" +
	"-3HENTAIGANA LETTER YA-4HENTAIGANA LETTER YA-5HENTAIGANA LETTER YA-YOHEN" +
	"TAIGANA LETTER YU-1HENTAIGANA LETTER YU-2HENTAIGANA LETTER YU-3HENTAIGAN" +
	"A LETTER YU-4HENTAIGANA LETTER YO-1HENTAIGANA LETTER YO-2HENTAIGANA LETT" +
	"ER YO-3HENTAIGANA LETTER YO-4HENTAIGANA LETTER YO-5HENTAIGANA LETTER YO-" +
	"6HENTAIGANA LETTER RA-1HENTAIGANA LETTER RA-2HENTAIGANA LETTER RA-3HENTA" +
	"IGANA LETTER RA-4HENTAIGANA LETTER RI-1HENTAIGANA LETTER RI-2HENTAIGANA " +
	"LETTER RI-3HENTAIGANA LETTER RI-4HENTAIGANA LETTER RI-5HENTAIGANA LETTER" +
	" RI-6HENTAIGANA LETTER RI-7HENTAIGANA LETTER RU-1HENTAIGANA LETTER RU-2H" +
	"ENTAIGANA LETTER RU-3HENTAIGANA LETTER RU-4HENTAIGANA LETTER RU-5HENTAIG" +
	"ANA LETTER RU-6HENTAIGANA LETTER RE-1HENTAIGANA LETTER RE-2HENTAIGANA LE" +
	"TTER RE-3HENTAIGANA LETTER RE-4HENTAIGANA LETTER RO-1HENTAIGANA LETTER R" +
	"O-2HENTAIGANA LETTER RO-3HENTAIGANA LETTER RO-4HENTAIGANA LETTER RO-5HEN" +
	"TAIGANA LETTER RO-6HENTAIGANA LETTER WA-1HENTAIGANA LETTER WA-2HENTAIGAN" +
	"A LETTER WA-3HENTAIGANA LETTER WA-4HENTAIGANA LETTER WA-5HENTAIGANA LETT" +
	"ER WI-1HENTAIGANA LETTER WI-2HENTAIGANA LETTER WI-3HENTAIGANA LETTER WI-" +
	"4HENTAIGANA LETTER WI-5HENTAIGANA LETTER WE-1HENTAIGANA LETTER WE-2HENTA" +
	"IGANA LETTER WE-3HENTAIGANA LETTER WE-4HENTAIGANA LETTER WO-1HENTAIGANA " +
	"LETTER WO-2HENTAIGANA LETTER WO-3HENTAIGANA LETTER WO-4HENTAIGANA LETTER" +
	" WO-5HENTAIGANA LETTER WO-6HENTAIGANA LETTER WO-7HENTAIGANA LETTER N-MU-" +
	"MO-1HENTAIGANA LETTER N-MU-MO-2NUSHU CHARACTER-1B170NUSHU CHARACTER-1B17" +
	"1NUSHU CHARACTER-1B172NUSHU CHARACTER-1B173NUSHU CHARACTER-1B174NUSHU CH" +
	"ARACTER-1B175NUSHU CHARACTER-1B176NUSHU CHARACTER-1B177NUSHU CHARACTER-1" +
	"B178NUSHU CHARACTER-1B179NUSHU CHARACTER-1B17ANUSHU CHARACTER-1B17BNUSHU" +
	" CHARACTER-1B17CNUSHU CHARACTER-1B17DNUSHU CHARACTER-1B17ENUSHU CHARACTE" +
	"R-1B17FNUSHU CHARACTER-1B180NUSHU CHARACTER-1B181NUSHU CHARACTER-1B182NU" +
	"SHU CHARACTER-1B183NUSHU CHARACTER-1B184NUSHU CHARACTER-1B185NUSHU CHARA" +
	"CTER-1B186NUSHU CHARACTER-1B187NUSHU CHARACTER-1B188NUSHU CHARACTER-1B18" +
	"9NUSHU CHARACTER-1B18ANUSHU CHARACTER-1B18BNUSHU CHARACTER-1B18CNUSHU CH" +
	"ARACTER-1B18DNUSHU CHARACTER-1B18ENUSHU CHARACTER-1B18FNUSHU CHARACTER-1" +
	"B190NUSHU CHARACTER-1B191NUSHU CHARACTER-1B192NUSHU CHARACTER-1B193NUSHU" +
	" CHARACTER-1B194NUSHU CHARACTER-1B195NUSHU CHARACTER-1B196NUSHU CHARACTE" +
	"R-1B197NUSHU CHARACTER-1B198NUSHU CHARACTER-1B199NUSHU CHARACTER-1B19ANU" +
	"SHU CHARACTER-1B19BNUSHU CHARACTER-1B19CNUSHU CHARACTER-1B19DNUSHU CHARA" +
	"CTER-1B19ENUSHU CHARACTER-1B19FNUSHU CHARACTER-1B1A0NUSHU CHARACTER-1B1A" +
	"1NUSHU CHARACTER-1B1A2NUSHU CHARACTER-1B1A3NUSHU CHARACTER-1B1A4NUSHU CH" +
	"ARACTER-1B1A5NUSHU CHARACTER-1B1A6NUSHU CHARACTER-1B1A7NUSHU CHARACTER-1" +
	"B1A8NUSHU CHARACTER-1B1A9NUSHU CHARACTER-1B1AANUSHU CHARACTER-1B1ABNUSHU" +
	" CHARACTER-1B1ACNUSHU CHARACTER-1B1ADNUSHU CHARACTER-1B1AENUSHU CHARACTE" +
	"R-1B1AFNUSHU CHARACTER-1B1B0NUSHU CHARACTER-1B1B1NUSHU CHARACTER-1B1B2NU" +
	"SHU CHARACTER-1B1B3NUSHU CHARACTER-1B1B4NUSHU CHARACTER-1B1B5NUSHU CHARA" +
	"CTER-1B1B6NUSHU CHARACTER-1B1B7NUSHU CHARACTER-1B1B8NUSHU CHARACTER-1B1B" +
	"9NUSHU CHARACTER-1B1BANUSHU CHARACTER-1B1BBNUSHU CHARACTER-1B1BCNUSHU CH" +
	"ARACTER-1B1BDNUSHU CHARACTER-1B1BENUSHU CHARACTER-1B1BFNUSHU CHARACTER-1") + ("" +
	"B1C0NUSHU CHARACTER-1B1C1NUSHU CHARACTER-1B1C2NUSHU CHARACTER-1B1C3NUSHU" +
	" CHARACTER-1B1C4NUSHU CHARACTER-1B1C5NUSHU CHARACTER-1B1C6NUSHU CHARACTE" +
	"R-1B1C7NUSHU CHARACTER-1B1C8NUSHU CHARACTER-1B1C9NUSHU CHARACTER-1B1CANU" +
	"SHU CHARACTER-1B1CBNUSHU CHARACTER-1B1CCNUSHU CHARACTER-1B1CDNUSHU CHARA" +
	"CTER-1B1CENUSHU CHARACTER-1B1CFNUSHU CHARACTER-1B1D0NUSHU CHARACTER-1B1D" +
	"1NUSHU CHARACTER-1B1D2NUSHU CHARACTER-1B1D3NUSHU CHARACTER-1B1D4NUSHU CH" +
	"ARACTER-1B1D5NUSHU CHARACTER-1B1D6NUSHU CHARACTER-1B1D7NUSHU CHARACTER-1" +
	"B1D8NUSHU CHARACTER-1B1D9NUSHU CHARACTER-1B1DANUSHU CHARACTER-1B1DBNUSHU" +
	" CHARACTER-1B1DCNUSHU CHARACTER-1B1DDNUSHU CHARACTER-1B1DENUSHU CHARACTE" +
	"R-1B1DFNUSHU CHARACTER-1B1E0NUSHU CHARACTER-1B1E1NUSHU CHARACTER-1B1E2NU" +
	"SHU CHARACTER-1B1E3NUSHU CHARACTER-1B1E4NUSHU CHARACTER-1B1E5NUSHU CHARA" +
	"CTER-1B1E6NUSHU CHARACTER-1B1E7NUSHU CHARACTER-1B1E8NUSHU CHARACTER-1B1E" +
	"9NUSHU CHARACTER-1B1EANUSHU CHARACTER-1B1EBNUSHU CHARACTER-1B1ECNUSHU CH" +
	"ARACTER-1B1EDNUSHU CHARACTER-1B1EENUSHU CHARACTER-1B1EFNUSHU CHARACTER-1" +
	"B1F0NUSHU CHARACTER-1B1F1NUSHU CHARACTER-1B1F2NUSHU CHARACTER-1B1F3NUSHU" +
	" CHARACTER-1B1F4NUSHU CHARACTER-1B1F5NUSHU CHARACTER-1B1F6NUSHU CHARACTE" +
	"R-1B1F7NUSHU CHARACTER-1B1F8NUSHU CHARACTER-1B1F9NUSHU CHARACTER-1B1FANU" +
	"SHU CHARACTER-1B1FBNUSHU CHARACTER-1B1FCNUSHU CHARACTER-1B1FDNUSHU CHARA" +
	"CTER-1B1FENUSHU CHARACTER-1B1FFNUSHU CHARACTER-1B200NUSHU CHARACTER-1B20" +
	"1NUSHU CHARACTER-1B202NUSHU CHARACTER-1B203NUSHU CHARACTER-1B204NUSHU CH" +
	"ARACTER-1B205NUSHU CHARACTER-1B206NUSHU CHARACTER-1B207NUSHU CHARACTER-1" +
	"B208NUSHU CHARACTER-1B209NUSHU CHARACTER-1B20ANUSHU CHARACTER-1B20BNUSHU" +
	" CHARACTER-1B20CNUSHU CHARACTER-1B20DNUSHU CHARACTER-1B20ENUSHU CHARACTE" +
	"R-1B20FNUSHU CHARACTER-1B210NUSHU CHARACTER-1B211NUSHU CHARACTER-1B212NU" +
	"SHU CHARACTER-1B213NUSHU CHARACTER-1B214NUSHU CHARACTER-1B215NUSHU CHARA" +
	"CTER-1B216NUSHU CHARACTER-1B217NUSHU CHARACTER-1B218NUSHU CHARACTER-1B21" +
	"9NUSHU CHARACTER-1B21ANUSHU CHARACTER-1B21BNUSHU CHARACTER-1B21CNUSHU CH" +
	"ARACTER-1B21DNUSHU CHARACTER-1B21ENUSHU CHARACTER-1B21FNUSHU CHARACTER-1" +
	"B220NUSHU CHARACTER-1B221NUSHU CHARACTER-1B222NUSHU CHARACTER-1B223NUSHU" +
	" CHARACTER-1B224NUSHU CHARACTER-1B225NUSHU CHARACTER-1B226NUSHU CHARACTE" +
	"R-1B227NUSHU CHARACTER-1B228NUSHU CHARACTER-1B229NUSHU CHARACTER-1B22ANU" +
	"SHU CHARACTER-1B22BNUSHU CHARACTER-1B22CNUSHU CHARACTER-1B22DNUSHU CHARA" +
	"CTER-1B22ENUSHU CHARACTER-1B22FNUSHU CHARACTER-1B230NUSHU CHARACTER-1B23" +
	"1NUSHU CHARACTER-1B232NUSHU CHARACTER-1B233NUSHU CHARACTER-1B234NUSHU CH" +
	"ARACTER-1B235NUSHU CHARACTER-1B236NUSHU CHARACTER-1B237NUSHU CHARACTER-1" +
	"B238NUSHU CHARACTER-1B239NUSHU CHARACTER-1B23ANUSHU CHARACTER-1B23BNUSHU" +
	" CHARACTER-1B23CNUSHU CHARACTER-1B23DNUSHU CHARACTER-1B23ENUSHU CHARACTE" +
	"R-1B23FNUSHU CHARACTER-1B240NUSHU CHARACTER-1B241NUSHU CHARACTER-1B242NU" +
	"SHU CHARACTER-1B243NUSHU CHARACTER-1B244NUSHU CHARACTER-1B245NUSHU CHARA" +
	"CTER-1B246NUSHU CHARACTER-1B247NUSHU CHARACTER-1B248NUSHU CHARACTER-1B24" +
	"9NUSHU CHARACTER-1B24ANUSHU CHARACTER-1B24BNUSHU CHARACTER-1B24CNUSHU CH" +
	"ARACTER-1B24DNUSHU CHARACTER-1B24ENUSHU CHARACTER-1B24FNUSHU CHARACTER-1" +
	"B250NUSHU CHARACTER-1B251NUSHU CHARACTER-1B252NUSHU CHARACTER-1B253NUSHU" +
	" CHARACTER-1B254NUSHU CHARACTER-1B255NUSHU CHARACTER-1B256NUSHU CHARACTE" +
	"R-1B257NUSHU CHARACTER-1B258NUSHU CHARACTER-1B259NUSHU CHARACTER-1B25ANU" +
	"SHU CHARACTER-1B25BNUSHU CHARACTER-1B25CNUSHU CHARACTER-1B25DNUSHU CHARA" +
	"CTER-1B25ENUSHU CHARACTER-1B25FNUSHU CHARACTER-1B260NUSHU CHARACTER-1B26" +
	"1NUSHU CHARACTER-1B262NUSHU CHARACTER-1B263NUSHU CHARACTER-1B264NUSHU CH" +
	"ARACTER-1B265NUSHU CHARACTER-1B266NUSHU CHARACTER-1B267NUSHU CHARACTER-1" +
	"B268NUSHU CHARACTER-1B269NUSHU CHARACTER-1B26ANUSHU CHARACTER-1B26BNUSHU" +
	" CHARACTER-1B26CNUSHU CHARACTER-1B26DNUSHU CHARACTER-1B26ENUSHU CHARACTE" +
	"R-1B26FNUSHU CHARACTER-1B270NUSHU CHARACTER-1B271NUSHU CHARACTER-1B272NU" +
	"SHU CHARACTER-1B273NUSHU CHARACTER-1B274NUSHU CHARACTER-1B275NUSHU CHARA" +
	"CTER-1B276NUSHU CHARACTER-1B277NUSHU CHARACTER-1B278NUSHU CHARACTER-1B27" +
	"9NUSHU CHARACTER-1B27ANUSHU CHARACTER-1B27BNUSHU CHARACTER-1B27CNUSHU CH" +
	"ARACTER-1B27DNUSHU CHARACTER-1B27ENUSHU CHARACTER-1B27FNUSHU CHARACTER-1" +
	"B280NUSHU CHARACTER-1B281NUSHU CHARACTER-1B282NUSHU CHARACTER-1B283NUSHU" +
	" CHARACTER-1B284NUSHU CHARACTER-1B285NUSHU CHARACTER-1B286NUSHU CHARACTE" +
	"R-1B287NUSHU CHARACTER-1B288NUSHU CHARACTER-1B289NUSHU CHARACTER-1B28ANU" +
	"SHU CHARACTER-1B28BNUSHU CHARACTER-1B28CNUSHU CHARACTER-1B28DNUSHU CHARA" +
	"CTER-1B28ENUSHU CHARACTER-1B28FNUSHU CHARACTER-1B290NUSHU CHARACTER-1B29" +
	"1NUSHU CHARACTER-1B292NUSHU CHARACTER-1B293NUSHU CHARACTER-1B294NUSHU CH" +
	"ARACTER-1B295NUSHU CHARACTER-1B296NUSHU CHARACTER-1B297NUSHU CHARACTER-1" +
	"B298NUSHU CHARACTER-1B299NUSHU CHARACTER-1B29ANUSHU CHARACTER-1B29BNUSHU") + ("" +
	" CHARACTER-1B29CNUSHU CHARACTER-1B29DNUSHU CHARACTER-1B29ENUSHU CHARACTE" +
	"R-1B29FNUSHU CHARACTER-1B2A0NUSHU CHARACTER-1B2A1NUSHU CHARACTER-1B2A2NU" +
	"SHU CHARACTER-1B2A3NUSHU CHARACTER-1B2A4NUSHU CHARACTER-1B2A5NUSHU CHARA" +
	"CTER-1B2A6NUSHU CHARACTER-1B2A7NUSHU CHARACTER-1B2A8NUSHU CHARACTER-1B2A" +
	"9NUSHU CHARACTER-1B2AANUSHU CHARACTER-1B2ABNUSHU CHARACTER-1B2ACNUSHU CH" +
	"ARACTER-1B2ADNUSHU CHARACTER-1B2AENUSHU CHARACTER-1B2AFNUSHU CHARACTER-1" +
	"B2B0NUSHU CHARACTER-1B2B1NUSHU CHARACTER-1B2B2NUSHU CHARACTER-1B2B3NUSHU" +
	" CHARACTER-1B2B4NUSHU CHARACTER-1B2B5NUSHU CHARACTER-1B2B6NUSHU CHARACTE" +
	"R-1B2B7NUSHU CHARACTER-1B2B8NUSHU CHARACTER-1B2B9NUSHU CHARACTER-1B2BANU" +
	"SHU CHARACTER-1B2BBNUSHU CHARACTER-1B2BCNUSHU CHARACTER-1B2BDNUSHU CHARA" +
	"CTER-1B2BENUSHU CHARACTER-1B2BFNUSHU CHARACTER-1B2C0NUSHU CHARACTER-1B2C" +
	"1NUSHU CHARACTER-1B2C2NUSHU CHARACTER-1B2C3NUSHU CHARACTER-1B2C4NUSHU CH" +
	"ARACTER-1B2C5NUSHU CHARACTER-1B2C6NUSHU CHARACTER-1B2C7NUSHU CHARACTER-1" +
	"B2C8NUSHU CHARACTER-1B2C9NUSHU CHARACTER-1B2CANUSHU CHARACTER-1B2CBNUSHU" +
	" CHARACTER-1B2CCNUSHU CHARACTER-1B2CDNUSHU CHARACTER-1B2CENUSHU CHARACTE" +
	"R-1B2CFNUSHU CHARACTER-1B2D0NUSHU CHARACTER-1B2D1NUSHU CHARACTER-1B2D2NU" +
	"SHU CHARACTER-1B2D3NUSHU CHARACTER-1B2D4NUSHU CHARACTER-1B2D5NUSHU CHARA" +
	"CTER-1B2D6NUSHU CHARACTER-1B2D7NUSHU CHARACTER-1B2D8NUSHU CHARACTER-1B2D" +
	"9NUSHU CHARACTER-1B2DANUSHU CHARACTER-1B2DBNUSHU CHARACTER-1B2DCNUSHU CH" +
	"ARACTER-1B2DDNUSHU CHARACTER-1B2DENUSHU CHARACTER-1B2DFNUSHU CHARACTER-1" +
	"B2E0NUSHU CHARACTER-1B2E1NUSHU CHARACTER-1B2E2NUSHU CHARACTER-1B2E3NUSHU" +
	" CHARACTER-1B2E4NUSHU CHARACTER-1B2E5NUSHU CHARACTER-1B2E6NUSHU CHARACTE" +
	"R-1B2E7NUSHU CHARACTER-1B2E8NUSHU CHARACTER-1B2E9NUSHU CHARACTER-1B2EANU" +
	"SHU CHARACTER-1B2EBNUSHU CHARACTER-1B2ECNUSHU CHARACTER-1B2EDNUSHU CHARA" +
	"CTER-1B2EENUSHU CHARACTER-1B2EFNUSHU CHARACTER-1B2F0NUSHU CHARACTER-1B2F" +
	"1NUSHU CHARACTER-1B2F2NUSHU CHARACTER-1B2F3NUSHU CHARACTER-1B2F4NUSHU CH" +
	"ARACTER-1B2F5NUSHU CHARACTER-1B2F6NUSHU CHARACTER-1B2F7NUSHU CHARACTER-1" +
	"B2F8NUSHU CHARACTER-1B2F9NUSHU CHARACTER-1B2FANUSHU CHARACTER-1B2FBDUPLO" +
	"YAN LETTER HDUPLOYAN LETTER XDUPLOYAN LETTER PDUPLOYAN LETTER TDUPLOYAN " +
	"LETTER FDUPLOYAN LETTER KDUPLOYAN LETTER LDUPLOYAN LETTER BDUPLOYAN LETT" +
	"ER DDUPLOYAN LETTER VDUPLOYAN LETTER GDUPLOYAN LETTER RDUPLOYAN LETTER P" +
	" NDUPLOYAN LETTER D SDUPLOYAN LETTER F NDUPLOYAN LETTER K MDUPLOYAN LETT" +
	"ER R SDUPLOYAN LETTER THDUPLOYAN LETTER SLOAN DHDUPLOYAN LETTER DHDUPLOY" +
	"AN LETTER KKDUPLOYAN LETTER SLOAN JDUPLOYAN LETTER HLDUPLOYAN LETTER LHD" +
	"UPLOYAN LETTER RHDUPLOYAN LETTER MDUPLOYAN LETTER NDUPLOYAN LETTER JDUPL" +
	"OYAN LETTER SDUPLOYAN LETTER M NDUPLOYAN LETTER N MDUPLOYAN LETTER J MDU" +
	"PLOYAN LETTER S JDUPLOYAN LETTER M WITH DOTDUPLOYAN LETTER N WITH DOTDUP" +
	"LOYAN LETTER J WITH DOTDUPLOYAN LETTER J WITH DOTS INSIDE AND ABOVEDUPLO" +
	"YAN LETTER S WITH DOTDUPLOYAN LETTER S WITH DOT BELOWDUPLOYAN LETTER M S" +
	"DUPLOYAN LETTER N SDUPLOYAN LETTER J SDUPLOYAN LETTER S SDUPLOYAN LETTER" +
	" M N SDUPLOYAN LETTER N M SDUPLOYAN LETTER J M SDUPLOYAN LETTER S J SDUP" +
	"LOYAN LETTER J S WITH DOTDUPLOYAN LETTER J NDUPLOYAN LETTER J N SDUPLOYA" +
	"N LETTER S TDUPLOYAN LETTER S T RDUPLOYAN LETTER S PDUPLOYAN LETTER S P " +
	"RDUPLOYAN LETTER T SDUPLOYAN LETTER T R SDUPLOYAN LETTER WDUPLOYAN LETTE" +
	"R WHDUPLOYAN LETTER W RDUPLOYAN LETTER S NDUPLOYAN LETTER S MDUPLOYAN LE" +
	"TTER K R SDUPLOYAN LETTER G R SDUPLOYAN LETTER S KDUPLOYAN LETTER S K RD" +
	"UPLOYAN LETTER ADUPLOYAN LETTER SLOAN OWDUPLOYAN LETTER OADUPLOYAN LETTE" +
	"R ODUPLOYAN LETTER AOUDUPLOYAN LETTER IDUPLOYAN LETTER EDUPLOYAN LETTER " +
	"IEDUPLOYAN LETTER SHORT IDUPLOYAN LETTER UIDUPLOYAN LETTER EEDUPLOYAN LE" +
	"TTER SLOAN EHDUPLOYAN LETTER ROMANIAN IDUPLOYAN LETTER SLOAN EEDUPLOYAN " +
	"LETTER LONG IDUPLOYAN LETTER YEDUPLOYAN LETTER UDUPLOYAN LETTER EUDUPLOY" +
	"AN LETTER XWDUPLOYAN LETTER U NDUPLOYAN LETTER LONG UDUPLOYAN LETTER ROM" +
	"ANIAN UDUPLOYAN LETTER UHDUPLOYAN LETTER SLOAN UDUPLOYAN LETTER OOHDUPLO" +
	"YAN LETTER OWDUPLOYAN LETTER OUDUPLOYAN LETTER WADUPLOYAN LETTER WODUPLO" +
	"YAN LETTER WIDUPLOYAN LETTER WEIDUPLOYAN LETTER WOWDUPLOYAN LETTER NASAL" +
	" UDUPLOYAN LETTER NASAL ODUPLOYAN LETTER NASAL IDUPLOYAN LETTER NASAL AD" +
	"UPLOYAN LETTER PERNIN ANDUPLOYAN LETTER PERNIN AMDUPLOYAN LETTER SLOAN E" +
	"NDUPLOYAN LETTER SLOAN ANDUPLOYAN LETTER SLOAN ONDUPLOYAN LETTER VOCALIC" +
	" MDUPLOYAN AFFIX LEFT HORIZONTAL SECANTDUPLOYAN AFFIX MID HORIZONTAL SEC" +
	"ANTDUPLOYAN AFFIX RIGHT HORIZONTAL SECANTDUPLOYAN AFFIX LOW VERTICAL SEC" +
	"ANTDUPLOYAN AFFIX MID VERTICAL SECANTDUPLOYAN AFFIX HIGH VERTICAL SECANT" +
	"DUPLOYAN AFFIX ATTACHED SECANTDUPLOYAN AFFIX ATTACHED LEFT-TO-RIGHT SECA" +
	"NTDUPLOYAN AFFIX ATTACHED TANGENTDUPLOYAN AFFIX ATTACHED TAILDUPLOYAN AF" +
	"FIX ATTACHED E HOOKDUPLOYAN AFFIX ATTACHED I HOOKDUPLOYAN AFFIX ATTACHED") + ("" +
	" TANGENT HOOKDUPLOYAN AFFIX HIGH ACUTEDUPLOYAN AFFIX HIGH TIGHT ACUTEDUP" +
	"LOYAN AFFIX HIGH GRAVEDUPLOYAN AFFIX HIGH LONG GRAVEDUPLOYAN AFFIX HIGH " +
	"DOTDUPLOYAN AFFIX HIGH CIRCLEDUPLOYAN AFFIX HIGH LINEDUPLOYAN AFFIX HIGH" +
	" WAVEDUPLOYAN AFFIX HIGH VERTICALDUPLOYAN AFFIX LOW ACUTEDUPLOYAN AFFIX " +
	"LOW TIGHT ACUTEDUPLOYAN AFFIX LOW GRAVEDUPLOYAN AFFIX LOW LONG GRAVEDUPL" +
	"OYAN AFFIX LOW DOTDUPLOYAN AFFIX LOW CIRCLEDUPLOYAN AFFIX LOW LINEDUPLOY" +
	"AN AFFIX LOW WAVEDUPLOYAN AFFIX LOW VERTICALDUPLOYAN AFFIX LOW ARROWDUPL" +
	"OYAN SIGN O WITH CROSSDUPLOYAN THICK LETTER SELECTORDUPLOYAN DOUBLE MARK" +
	"DUPLOYAN PUNCTUATION CHINOOK FULL STOPSHORTHAND FORMAT LETTER OVERLAPSHO" +
	"RTHAND FORMAT CONTINUING OVERLAPSHORTHAND FORMAT DOWN STEPSHORTHAND FORM" +
	"AT UP STEPBYZANTINE MUSICAL SYMBOL PSILIBYZANTINE MUSICAL SYMBOL DASEIAB" +
	"YZANTINE MUSICAL SYMBOL PERISPOMENIBYZANTINE MUSICAL SYMBOL OXEIA EKFONI" +
	"TIKONBYZANTINE MUSICAL SYMBOL OXEIA DIPLIBYZANTINE MUSICAL SYMBOL VAREIA" +
	" EKFONITIKONBYZANTINE MUSICAL SYMBOL VAREIA DIPLIBYZANTINE MUSICAL SYMBO" +
	"L KATHISTIBYZANTINE MUSICAL SYMBOL SYRMATIKIBYZANTINE MUSICAL SYMBOL PAR" +
	"AKLITIKIBYZANTINE MUSICAL SYMBOL YPOKRISISBYZANTINE MUSICAL SYMBOL YPOKR" +
	"ISIS DIPLIBYZANTINE MUSICAL SYMBOL KREMASTIBYZANTINE MUSICAL SYMBOL APES" +
	"O EKFONITIKONBYZANTINE MUSICAL SYMBOL EXO EKFONITIKONBYZANTINE MUSICAL S" +
	"YMBOL TELEIABYZANTINE MUSICAL SYMBOL KENTIMATABYZANTINE MUSICAL SYMBOL A" +
	"POSTROFOSBYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLIBYZANTINE MUSICAL SYMB" +
	"OL SYNEVMABYZANTINE MUSICAL SYMBOL THITABYZANTINE MUSICAL SYMBOL OLIGON " +
	"ARCHAIONBYZANTINE MUSICAL SYMBOL GORGON ARCHAIONBYZANTINE MUSICAL SYMBOL" +
	" PSILONBYZANTINE MUSICAL SYMBOL CHAMILONBYZANTINE MUSICAL SYMBOL VATHYBY" +
	"ZANTINE MUSICAL SYMBOL ISON ARCHAIONBYZANTINE MUSICAL SYMBOL KENTIMA ARC" +
	"HAIONBYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAIONBYZANTINE MUSICAL SYMBOL" +
	" SAXIMATABYZANTINE MUSICAL SYMBOL PARICHONBYZANTINE MUSICAL SYMBOL STAVR" +
	"OS APODEXIABYZANTINE MUSICAL SYMBOL OXEIAI ARCHAIONBYZANTINE MUSICAL SYM" +
	"BOL VAREIAI ARCHAIONBYZANTINE MUSICAL SYMBOL APODERMA ARCHAIONBYZANTINE " +
	"MUSICAL SY