# _VecNode\[A: [Any](builtin-Any.md) #share\]
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L3)</span>
```pony
class val _VecNode[A: Any #share]
```

## Constructors

### empty
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L6)</span>


```pony
new val empty(
  depth: USize val)
: _VecNode[A] val^
```
#### Parameters

*   depth: [USize](builtin-USize.md) val

#### Returns

* [_VecNode](collections-persistent-_VecNode.md)\[A\] val^

---

### create
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L15)</span>


```pony
new val create(
  entries': (Array[A] val | Array[_VecNode[A] val] val))
: _VecNode[A] val^
```
#### Parameters

*   entries': ([Array](builtin-Array.md)\[A\] val | [Array](builtin-Array.md)\[[_VecNode](collections-persistent-_VecNode.md)\[A\] val\] val)

#### Returns

* [_VecNode](collections-persistent-_VecNode.md)\[A\] val^

---

## Public Functions

### grow_root
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L18)</span>


```pony
fun val grow_root()
: _VecNode[A] val
```

#### Returns

* [_VecNode](collections-persistent-_VecNode.md)\[A\] val

---

### apply
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L21)</span>


```pony
fun box apply(
  depth: USize val,
  i: USize val)
: A ?
```
#### Parameters

*   depth: [USize](builtin-USize.md) val
*   i: [USize](builtin-USize.md) val

#### Returns

* A ?

---

### push
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L28)</span>


```pony
fun val push(
  depth: USize val,
  i: USize val,
  tail: Array[A] val)
: _VecNode[A] val ?
```
#### Parameters

*   depth: [USize](builtin-USize.md) val
*   i: [USize](builtin-USize.md) val
*   tail: [Array](builtin-Array.md)\[A\] val

#### Returns

* [_VecNode](collections-persistent-_VecNode.md)\[A\] val ?

---

### pop
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L44)</span>


```pony
fun val pop(
  depth: USize val,
  i: USize val)
: (_VecNode[A] val , Array[A] val) ?
```
#### Parameters

*   depth: [USize](builtin-USize.md) val
*   i: [USize](builtin-USize.md) val

#### Returns

* ([_VecNode](collections-persistent-_VecNode.md)\[A\] val , [Array](builtin-Array.md)\[A\] val) ?

---

### update
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L58)</span>


```pony
fun val update(
  depth: USize val,
  i: USize val,
  v: A)
: _VecNode[A] val ?
```
#### Parameters

*   depth: [USize](builtin-USize.md) val
*   i: [USize](builtin-USize.md) val
*   v: A

#### Returns

* [_VecNode](collections-persistent-_VecNode.md)\[A\] val ?

---

### leaf_nodes
<span class="source-link">[[Source]](src/collections-persistent/_vec_node.md#L68)</span>


```pony
fun val leaf_nodes(
  lns: Array[Array[A] val] ref)
: Array[Array[A] val] ref^
```
#### Parameters

*   lns: [Array](builtin-Array.md)\[[Array](builtin-Array.md)\[A\] val\] ref

#### Returns

* [Array](builtin-Array.md)\[[Array](builtin-Array.md)\[A\] val\] ref^

---

