# _Option
<span class="source-link">[[Source]](src/options/options.md#L293)</span>
```pony
class ref _Option
```

## Constructors

### create
<span class="source-link">[[Source]](src/options/options.md#L317)</span>


```pony
new ref create(
  long': String val,
  short': (String val | None val),
  arg': (None val | StringArgument val | I64Argument val | 
    U64Argument val | F64Argument val),
  mode': (Required val | Optional val))
: _Option ref^
```
#### Parameters

*   long': [String](builtin-String.md) val
*   short': ([String](builtin-String.md) val | [None](builtin-None.md) val)
*   arg': ([None](builtin-None.md) val | [StringArgument](options-StringArgument.md) val | [I64Argument](options-I64Argument.md) val | 
    [U64Argument](options-U64Argument.md) val | [F64Argument](options-F64Argument.md) val)
*   mode': ([Required](options-Required.md) val | [Optional](options-Optional.md) val)

#### Returns

* [_Option](options-_Option.md) ref^

---

## Public fields

### let long: [String](builtin-String.md) val
<span class="source-link">[[Source]](src/options/options.md#L294)</span>

Long option name.

E.g. "help" for a "--help" option.




---

### let short: ([String](builtin-String.md) val | [None](builtin-None.md) val)
<span class="source-link">[[Source]](src/options/options.md#L300)</span>

Short option name (if any).

E.g. "h" for a "-h" option.




---

### let arg: ([None](builtin-None.md) val | [StringArgument](options-StringArgument.md) val | [I64Argument](options-I64Argument.md) val | 
    [U64Argument](options-U64Argument.md) val | [F64Argument](options-F64Argument.md) val)
<span class="source-link">[[Source]](src/options/options.md#L306)</span>

The type of the expected argument.

None, if this option is a flag.

E.g. "--help"




---

### let mode: ([Required](options-Required.md) val | [Optional](options-Optional.md) val)
<span class="source-link">[[Source]](src/options/options.md#L314)</span>

determining if this Option is required or optional



---

## Public Functions

### matches
<span class="source-link">[[Source]](src/options/options.md#L328)</span>


```pony
fun box matches(
  name: String box,
  shortmatch: Bool val)
: Bool val
```
#### Parameters

*   name: [String](builtin-String.md) box
*   shortmatch: [Bool](builtin-Bool.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### has_argument
<span class="source-link">[[Source]](src/options/options.md#L335)</span>


```pony
fun box has_argument()
: Bool val
```

#### Returns

* [Bool](builtin-Bool.md) val

---

### requires_argument
<span class="source-link">[[Source]](src/options/options.md#L341)</span>


```pony
fun box requires_argument()
: Bool val
```

#### Returns

* [Bool](builtin-Bool.md) val

---

### accepts
<span class="source-link">[[Source]](src/options/options.md#L349)</span>


```pony
fun box accepts(
  argument: String box)
: Bool val
```
#### Parameters

*   argument: [String](builtin-String.md) box

#### Returns

* [Bool](builtin-Bool.md) val

---

