/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.ontologies.OntologySelectionStrategy;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;

public abstract class AbstractOntologySelectionStrategyAction
extends ProtegeOWLAction {
    private JMenuItem menuItem;
    private OWLModelManagerListener l = event -> {
        if (event.getType() == EventType.ONTOLOGY_VISIBILITY_CHANGED) {
            this.setSelected(this.isCurrent());
        }
    };

    public void setMenuItem(JMenuItem menuItem) {
        this.menuItem = menuItem;
        this.setSelected(this.isCurrent());
    }

    protected boolean isCurrent() {
        return this.getOWLModelManager().getActiveOntologiesStrategy().getClass().equals(this.getStrategy().getClass());
    }

    public void actionPerformed(ActionEvent event) {
        this.getOWLModelManager().setActiveOntologiesStrategy(this.getStrategy());
    }

    public void initialise() throws Exception {
        this.getOWLModelManager().registerOntologySelectionStrategy(this.getStrategy());
        this.setSelected(this.isCurrent());
        this.getOWLModelManager().addListener(this.l);
    }

    public void setSelected(boolean selected) {
        if (this.menuItem != null) {
            this.menuItem.setSelected(selected);
        }
    }

    public void dispose() throws Exception {
        this.getOWLModelManager().removeListener(this.l);
    }

    protected abstract OntologySelectionStrategy getStrategy();
}

