# Logger\[A: A\]
<span class="source-link">[[Source]](src/logger/logger.md#L110)</span>
```pony
class val Logger[A: A]
```

## Constructors

### create
<span class="source-link">[[Source]](src/logger/logger.md#L116)</span>


```pony
new val create(
  level: (Fine val | Info val | Warn val | 
    Error val),
  out: OutStream tag,
  f: {(A): String}[A] val,
  formatter: LogFormatter val = reference)
: Logger[A] val^
```
#### Parameters

*   level: ([Fine](logger-Fine.md) val | [Info](logger-Info.md) val | [Warn](logger-Warn.md) val | 
    [Error](logger-Error.md) val)
*   out: [OutStream](builtin-OutStream.md) tag
*   f: {(A): String}[A] val
*   formatter: [LogFormatter](logger-LogFormatter.md) val = reference

#### Returns

* [Logger](logger-Logger.md)\[A\] val^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/logger/logger.md#L127)</span>


```pony
fun box apply(
  level: (Fine val | Info val | Warn val | 
    Error val))
: Bool val
```
#### Parameters

*   level: ([Fine](logger-Fine.md) val | [Info](logger-Info.md) val | [Warn](logger-Warn.md) val | 
    [Error](logger-Error.md) val)

#### Returns

* [Bool](builtin-Bool.md) val

---

### log
<span class="source-link">[[Source]](src/logger/logger.md#L130)</span>


```pony
fun box log(
  value: A,
  loc: SourceLoc val = __loc)
: Bool val
```
#### Parameters

*   value: A
*   loc: [SourceLoc](builtin-SourceLoc.md) val = __loc

#### Returns

* [Bool](builtin-Bool.md) val

---

