# InputSerialisedAuth
<span class="source-link">[[Source]](src/serialise/serialise.md#L68)</span>

This is a capability token that allows the holder to treat data arbitrary
bytes as serialised data. This is the most dangerous capability, as currently
it is possible for a malformed chunk of data to crash your program if it is
deserialised.


```pony
primitive val InputSerialisedAuth
```

## Constructors

### create
<span class="source-link">[[Source]](src/serialise/serialise.md#L75)</span>


```pony
new val create(
  auth: AmbientAuth val)
: InputSerialisedAuth val^
```
#### Parameters

*   auth: [AmbientAuth](builtin-AmbientAuth.md) val

#### Returns

* [InputSerialisedAuth](serialise-InputSerialisedAuth.md) val^

---

## Public Functions

### eq
<span class="source-link">[[Source]](src/serialise/serialise.md#L75)</span>


```pony
fun box eq(
  that: InputSerialisedAuth val)
: Bool val
```
#### Parameters

*   that: [InputSerialisedAuth](serialise-InputSerialisedAuth.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/serialise/serialise.md#L75)</span>


```pony
fun box ne(
  that: InputSerialisedAuth val)
: Bool val
```
#### Parameters

*   that: [InputSerialisedAuth](serialise-InputSerialisedAuth.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

