/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ce extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u04c0\u0430\u044c\u0440\u0431\u0438\u0439\u043d";
        final String metaValue_bo = "\u0442\u0438\u0431\u0435\u0442\u0445\u043e\u0439\u043d";
        final String metaValue_el = "\u0433\u0440\u0435\u043a\u0438\u0439\u043d";
        final String metaValue_fa = "\u0433\u04c0\u0430\u0436\u0430\u0440\u0438\u0439\u043d";
        final String metaValue_gu = "\u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_he = "\u0436\u0443\u0433\u0442\u0438\u0439\u043d";
        final String metaValue_hy = "\u044d\u0440\u043c\u0430\u043b\u043e\u0439\u043d";
        final String metaValue_ja = "\u044f\u043f\u043e\u043d\u0438\u0439\u043d";
        final String metaValue_ka = "\u0433\u0443\u044c\u0440\u0436\u0438\u0439\u043d";
        final String metaValue_km = "\u043a\u0445\u043c\u0435\u0440\u0438\u0439\u043d";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_ko = "\u043a\u043e\u0440\u0435\u0439\u043d";
        final String metaValue_la = "\u043b\u0430\u0442\u0438\u043d\u0430\u043d";
        final String metaValue_lo = "\u043b\u0430\u043e\u0441\u0441\u0438\u0439\u043d";
        final String metaValue_mn = "\u043c\u043e\u043d\u0433\u043e\u043b\u0438\u0439\u043d";
        final String metaValue_or = "\u043e\u0440\u0438";
        final String metaValue_si = "\u0441\u0438\u043d\u0433\u0430\u043b\u0445\u043e\u0439\u043d";
        final String metaValue_ta = "\u0442\u0430\u043c\u0438\u043b\u0445\u043e\u0439\u043d";
        final String metaValue_te = "\u0442\u0435\u043b\u0443\u0433\u0443";
        final String metaValue_th = "\u0442\u0430\u0439\u043d";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "ksh", "\u043a\u043e\u044c\u043b\u043d\u0438\u0439\u043d" },
            { "nyn", "\u043d\u044c\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "mwl", "\u043c\u0438\u0440\u0430\u043d\u0434\u043e\u0439\u043d" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "luo", "\u043b\u0443\u043e (\u041a\u0435\u043d\u0438 \u0430, \u0422\u0430\u043d\u0437\u0430\u043d\u0438 \u0430)" },
            { "Zsym", "\u0441\u0438\u043c\u0432\u043e\u043b\u0430\u0448" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0438\u0439\u043d" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "lus", "\u043b\u0443\u0448\u0435\u0439" },
            { "ban", "\u0431\u0430\u043b\u0438\u0439\u043d" },
            { "Zsye", "\u044d\u043c\u043e\u0434\u0437\u0438" },
            { "luy", "\u043b\u0443\u0445\u044c\u044f" },
            { "bas", "\u0431\u0430\u0441\u0430" },
            { "es_ES", "\u0435\u0432\u0440\u043e\u043f\u0430\u043d \u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "tem", "\u0442\u0435\u043c\u043d\u0435" },
            { "sco", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b\u0438\u0439\u043d" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "aa", "\u0430\u0444\u0430\u0440\u0438\u0439\u043d" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0439\u043d" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437\u0445\u043e\u0439\u043d" },
            { "AC", "\u0410\u0439\u044a\u0430\u0434\u0430\u043b\u0430\u0440\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433\u0430" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u04c0\u0430\u0440\u0431\u0438\u0439\u043d \u0426\u0445\u044c\u0430\u043d\u0430\u0442\u043e\u044c\u0445\u043d\u0430 \u042d\u043c\u0438\u0440\u0430\u0442\u0430\u0448" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0438\u0439\u043d" },
            { "AF", "\u041e\u0432\u0445\u04c0\u0430\u043d \u043c\u043e\u0445\u043a" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0430, \u0411\u0430\u0440\u0431\u0443\u0434\u0430 \u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438" },
            { "AM", "\u042d\u0440\u043c\u0430\u043b\u043e\u0439\u0447\u043e\u044c" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u043e\u0439\u043d" },
            { "Arab", metaValue_ar },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u043e\u0439\u043d" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430" },
            { "ar", metaValue_ar },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "Hrkt", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430 \u044f \u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d \u0421\u0430\u043c\u043e\u0430" },
            { "as", "\u0430\u0441\u0441\u0430\u043c\u0438\u0439\u043d" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438" },
            { "av", "\u0441\u0443\u044c\u0439\u043b\u0438\u0439\u043d" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0438\u0439\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438 \u0430, \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430 \u0430" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440\u0438\u0439\u043d" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "kum", "\u0433\u04c0\u0443\u043c\u043a\u0438\u0439\u043d" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u0439\u043d" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430- \u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440\u0438\u0439\u043d" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c\u0430" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "myv", "\u044d\u0440\u0437\u044f\u043d\u0438\u0439\u043d" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439-\u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u0438\u0439\u043d" },
            { "bo", metaValue_bo },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431" },
            { "BQ", "\u0411\u043e\u043d\u044d\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0430, \u0421\u0430\u0431\u0430 \u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u0438\u0439\u043d" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u0439\u043d" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "Mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u043d\u0438\u0439\u043d" },
            { "BY", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u0438" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "type.ca.persian", metaValue_fa },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u043e\u043d\u0438\u0439\u043d" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0435\u0440\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "ses", "\u043a\u043e\u0439\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u043d\u0438" },
            { "CD", "\u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u043d\u0433\u043e" },
            { "ce", "\u043d\u043e\u0445\u0447\u0438\u0439\u043d" },
            { "CF", "\u042e\u043a\u043a\u044a\u0435\u0440\u0447\u0443 \u0410\u0444\u0440\u0438\u043a\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0440\u043e" },
            { "CI", "\u041a\u043e\u0442-\u0414\u2019\u0438\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0426\u0438\u0439\u0447\u043e\u044c" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430\u043d\u0438\u0439\u043d" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d" },
            { "Orya", metaValue_or },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "cs", "\u0447\u0435\u0445\u0438\u0439\u043d" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "cu", "\u043a\u0438\u043b\u0441\u0441\u043b\u0430\u0432\u044f\u043d\u0438\u0439\u043d" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448\u0438\u0439\u043d" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0413\u04c0\u0430\u0439\u0440\u0435 \u04cf\u0438\u0441\u0430 \u043f\u0430\u0439\u0445\u04cf\u0430\u043c\u0430\u0440 \u0432\u0438\u043d\u0430 \u0434\u0435" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "cy", "\u0432\u0430\u043b\u043b\u0438\u0439\u043d" },
            { "CZ", "\u0427\u0435\u0445\u0438" },
            { "eka", "\u044d\u043a\u0430\u0434\u0436\u0443\u043a" },
            { "da", "\u0434\u0430\u0442\u0445\u043e\u0439\u043d" },
            { "pt_PT", "\u0435\u0432\u0440\u043e\u043f\u0430\u043d \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0445\u043e\u0439\u043d" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438" },
            { "de", "\u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "ace", "\u0430\u0447\u0435\u0445\u0438\u0439\u043d" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e-\u0413\u0430\u0440\u0441\u0438" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438" },
            { "Brai", "\u0431\u0440\u0430\u0439\u043b\u044f" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "dv", "\u043c\u0430\u043b\u044c\u0434\u0438\u0432\u0438\u0439\u043d" },
            { "zun", "\u0437\u0443\u043d\u044c\u0438" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d\u0430\u043d \u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d \u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433-\u043a\u044d" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d\u0430\u043d" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0430, \u041c\u0435\u043b\u0438\u043b\u044c\u044f \u0430" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "pap", "\u043f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u0435" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438" },
            { "ee", "\u044d\u0432\u0435" },
            { "EG", "\u041c\u0438\u0441\u0430\u0440" },
            { "EH", "\u041c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d \u0421\u0430\u044c\u0445\u044c\u0430\u0440\u0430" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432\u0438\u0439\u043d" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443" },
            { "el", metaValue_el },
            { "chk", "\u0447\u0443\u043a\u0447\u0438\u0439\u043d" },
            { "en", "\u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "chm", "\u043c\u0430\u0440\u0438\u0439\u043d" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0432\u0438\u0439\u043d" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u0439" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0438\u0439\u043d" },
            { "Hanb", "\u0445\u0430\u043d\u044c\u0431" },
            { "EU", "\u0415\u0432\u0440\u043e\u0431\u0430\u0440\u0442" },
            { "eu", "\u0431\u0430\u0441\u043a\u0438\u0439\u043d" },
            { "Hang", "\u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "type.ca.gregorian", "\u0433\u0440\u0438\u0433\u043e\u0440\u0438\u0430\u043d\u0430\u043d" },
            { "EZ", "\u0435\u0432\u0440\u043e\u0437\u043e\u043d\u0430" },
            { "chy", "\u0448\u0430\u0439\u0435\u043d\u0438\u0439\u043d" },
            { "shi", "\u0442\u0430\u0445\u0435\u043b\u0445\u0438\u0442" },
            { "hsb", "\u043b\u0430\u043a\u0445\u0430\u0440\u0430 \u0441\u0435\u0440\u0431\u0438\u0439\u043d" },
            { "Hani", "\u043a\u0438\u0442\u0430\u0439\u043d" },
            { "ady", "\u0430\u0434\u0438\u0433\u0435\u0439\u043d" },
            { "shn", "\u0448\u0430\u043d\u043e\u0439\u043d" },
            { "fa", metaValue_fa },
            { "Hans", "\u0430\u0442\u0442\u0430 \u043a\u0438\u0442\u0430\u0439\u043d" },
            { "Hant", "\u043b\u0430\u043c\u0430\u0441\u0442\u0430\u043d \u043a\u0438\u0442\u0430\u0439\u043d" },
            { "ff", "\u0444\u0443\u043b\u0430\u0445" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438" },
            { "fi", "\u0444\u0438\u043d\u043d\u0438\u0439\u043d" },
            { "FJ", "\u0424\u0438\u0434\u0436\u0438" },
            { "fj", "\u0444\u0438\u0434\u0436\u0438" },
            { "fon", "\u0444\u043e\u043d" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u043d \u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u0438 \u0448\u0442\u0430\u0442\u0430\u0448" },
            { "bgn", "\u043c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d-\u0431\u0435\u043b\u0443\u0434\u0436\u0438\u0439\u043d" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0438\u0439\u043d" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440\u0438\u0439\u043d" },
            { "Taml", metaValue_ta },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d" },
            { "fy", "\u043c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d-\u0444\u0440\u0438\u0437\u0438\u0439\u043d" },
            { "root", "\u043e\u0440\u0430\u043c\u0430\u043d \u043c\u043e\u0442\u0442" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "GB", "\u0419\u043e\u043a\u043a\u0445\u0430 \u0411\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "pcm", "\u043d\u0438\u0433\u0435\u0440\u0438\u0439\u043d-\u043a\u0440\u0435\u043e\u043b\u0438\u0439\u043d" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "gd", "\u0433\u044d\u043b\u0438\u0439\u043d" },
            { "GE", "\u0413\u0443\u044c\u0440\u0436\u0438\u0439\u0447\u043e\u044c" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u0413\u0432\u0438\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438" },
            { "gl", "\u0433\u0430\u043b\u0438\u0441\u0438\u0439\u043d" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0439" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "bho", "\u0431\u0445\u043e\u0434\u0436\u043f\u0443\u0440\u0438" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0430\u043d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "und", "\u0431\u043e\u044c\u0432\u0437\u0443\u0448 \u0431\u043e\u0446\u0443 \u043c\u043e\u0442\u0442" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438" },
            { "GS", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0414\u0436\u043e\u0440\u0434\u0436\u0438 \u0430, \u041a\u044a\u0438\u043b\u0431\u0430 \u0413\u0430\u0432\u0430\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 \u0430" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "gu", metaValue_gu },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "gv", "\u043c\u044d\u043d\u0438\u0439\u043d" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0439-\u0411\u0438\u0441\u0430\u0443" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d\u0438\u043d" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "ckb", "\u044e\u043a\u043a\u044a\u0435\u0440\u0447\u0443 \u043a\u0443\u0440\u0434\u0438\u0439\u043d" },
            { "zxx", "\u043c\u0435\u0442\u0442\u0430\u043d \u0447\u0443\u043b\u0430\u0446\u0430\u043c \u0431\u043e\u0446\u0443\u0448" },
            { "he", metaValue_he },
            { "hi", "\u0445\u04c0\u0438\u043d\u0434\u0438" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438\u043d \u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u0448\u0430-\u043a\u044a\u0430\u044c\u0441\u0442\u0438\u043d\u0430 \u043a\u04c0\u043e\u0448\u0442)" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0433\u04c0\u0430\u0439\u0440\u0435 \u0430, \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 \u0430" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442\u0438\u0439\u043d" },
            { "agq", "\u0430\u0433\u0445\u04c0\u0435\u043c" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u043d \u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "ht", "\u0433\u0430\u0438\u0442\u0438\u0439\u043d" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438" },
            { "hu", "\u0432\u0435\u043d\u0433\u0440\u0438\u0439\u043d" },
            { "hy", metaValue_hy },
            { "hz", "\u0433\u0435\u0440\u0435\u0440\u043e" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0430" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "Jamo", "\u0434\u0436\u0430\u043c\u043e" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0445\u043e\u0439\u043d" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0438\u0442\u0430\u043d\u043e\u0439\u043d" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "ii", "\u0441\u044b\u0447\u0443\u0430\u043d\u044c" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "IN", "\u0425\u04c0\u0438\u043d\u0434\u0438" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u043d \u043b\u0430\u0442\u0442\u0430 \u0418\u043d\u0434\u0438\u043d \u043e\u043a\u0435\u0430\u043d\u0435\u0445\u044c" },
            { "io", "\u0438\u0434\u043e" },
            { "IQ", "\u04c0\u0438\u0440\u0430\u043a\u044a" },
            { "IR", "\u0413\u04c0\u0430\u0436\u0430\u0440\u0438\u0439\u0447\u043e\u044c" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438" },
            { "it", "\u0438\u0442\u0430\u043b\u044c\u044f\u043d\u0438\u0439\u043d" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0430\u043d \u043c\u0430\u044c\u04c0\u043d\u0430" },
            { "ja", metaValue_ja },
            { "Mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0438\u0439\u043d" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0438" },
            { "type.ca.islamic", "\u0438\u0441\u043b\u0430\u043c\u0430\u043d" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "Beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u0445\u043e\u0439\u043d" },
            { "JO", "\u0423\u0440\u0434\u0430\u043d" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438" },
            { "sma", "\u0441\u0430\u0430\u043c\u0438\u0439\u043d (\u043a\u044a\u0438\u043b\u0431\u0430)" },
            { "ain", "\u0430\u0439\u043d\u0438\u0439\u043d" },
            { "jv", "\u044f\u0432\u0430\u043d\u0438\u0439\u043d" },
            { "guz", "\u0433\u0443\u0441\u0438\u0438" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0438\u0439\u043d" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0438" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u043d \u043b\u0438\u0442\u0435\u0440\u0430\u0442\u0443\u0440\u0438\u043d \u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "mai", "\u043c\u0430\u0439\u0442\u0445\u0438\u043b\u0438" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438-\u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "ka", metaValue_ka },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u0430" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440\u0438\u0439\u043d" },
            { "sms", "\u0441\u043a\u043e\u043b\u044c\u0442-\u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "KE", "\u041a\u0435\u043d\u0438" },
            { "419", "\u041b\u0430\u0442\u0438\u043d\u0430\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "KG", "\u041a\u0438\u0440\u0433\u0438\u0437\u0438" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "ki", "\u043a\u0438\u043a\u0443\u0439\u044e" },
            { "mas", "\u043c\u0430\u0441\u0430\u0438" },
            { "kj", "\u043a\u0443\u043d\u0430\u043c\u0430" },
            { "kk", "\u043a\u0445\u0430\u0437\u0430\u043a\u0445\u0438\u0439\u043d" },
            { "kl", "\u0433\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "km", metaValue_km },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u0430\u0448" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0430, \u041d\u0435\u0432\u0438\u0441 \u0430" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u0430\u043d \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d" },
            { "ko", metaValue_ko },
            { "KP", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u041a\u043e\u0440\u0435\u0439" },
            { "KR", "\u041a\u044a\u0438\u043b\u0431\u0430 \u041a\u043e\u0440\u0435\u0439" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0438" },
            { "ku", "\u043a\u0443\u0440\u0434\u0438\u0439\u043d" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u043d \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d" },
            { "kv", "\u043a\u043e\u043c\u0438\u0439\u043d" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "kw", "\u043a\u043e\u0440\u043d\u0443\u043e\u043b\u043b\u0438\u0439\u043d" },
            { "tpi", "\u0442\u043e\u043a-\u043f\u0438\u0441\u0438\u043d" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "ky", "\u0433\u04c0\u0438\u0440\u0433\u04c0\u0438\u0437\u043e\u0439\u043d" },
            { "KZ", "\u041a\u0445\u0430\u0437\u0430\u043a\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "la", metaValue_la },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0445\u043e\u0439\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "nds", "\u043b\u0430\u0445\u0430\u0440\u0430 \u0433\u0435\u0440\u043c\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0433\u0438\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "Tibt", metaValue_bo },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "fur", "\u0444\u0440\u0438\u0443\u043b\u0438\u0439\u043d" },
            { "lo", metaValue_lo },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430\u0445\u043e\u0439\u043d" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448\u0438\u0439\u043d" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "LY", "\u041b\u0438\u0432\u0438" },
            { "lad", "\u043b\u0430\u0434\u0438\u043d\u043e" },
            { "vun", "\u0432\u0443\u043d\u0434\u0436\u043e" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438" },
            { "Thaa", "\u0442\u0430\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u0430\u0432\u0438" },
            { "ME", "\u04c0\u0430\u044c\u0440\u0436\u0430\u043b\u0430\u043c\u0430\u043d\u0447\u043e\u044c" },
            { "MF", "\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u043d" },
            { "Thai", metaValue_th },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u043b\u0438\u0439\u043d" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442\u0438\u0439\u043d" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0445\u043e\u0439\u043d" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "ml", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430 (\u0411\u0438\u0440\u043c\u0430)" },
            { "mn", metaValue_mn },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u043e\u0439\u043d" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e (\u0448\u0430-\u043a\u044a\u0430\u044c\u0441\u0442\u0438\u043d\u0430 \u043a\u04c0\u043e\u0448\u0442)" },
            { "MP", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u041c\u0430\u0440\u0438\u0430\u043d\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439\u043d" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u043e\u0439\u043d" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438" },
            { "alt", "\u043a\u044a\u0438\u043b\u0431\u0430 \u0430\u043b\u0442\u0430\u0439\u043d" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u0430\u0448" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "type.ca.japanese", metaValue_ja },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438" },
            { "my", "\u0431\u0438\u0440\u043c\u0430\u043d\u0438\u0439\u043d" },
            { "Armn", metaValue_hy },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430\u043d\u043e\u0439\u043d" },
            { "dsb", "\u0441\u043e\u0440\u0431\u0438\u0439\u043d" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "NC", "\u041a\u0435\u0440\u043b\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438" },
            { "nd", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u043d\u0434\u0435\u0431\u0435\u043b\u0438" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u0445\u043e\u0439\u043d" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "trv", "\u0441\u0435\u0434\u0435\u043a\u043e\u0439\u043d" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0430\u0448" },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u043d\u044e\u043d\u043e\u0440\u0441\u043a" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "nr", "\u043a\u044a\u0438\u043b\u0431\u0430 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "ny", "\u043d\u044c\u044f\u043d\u0434\u0436\u0430" },
            { "NZ", "\u041a\u0435\u0440\u043b\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d\u0438\u0439\u043d" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0438\u0439\u043d" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u043e\u0439\u043d" },
            { "kaj", "\u043a\u0430\u0434\u0436\u0438" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "OM", "\u04c0\u043e\u043c\u0430\u043d" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a\u0430" },
            { "or", metaValue_or },
            { "os", "\u0445\u04c0\u0438\u0440\u0438\u0439\u043d" },
            { "crs", "\u0441\u0435\u0439\u0448\u0435\u043b\u0438\u0439\u043d \u043a\u0440\u0435\u043e\u043b\u0438\u0439\u043d" },
            { "kbd", "\u0433\u04c0\u0435\u0431\u0430\u0440\u0442\u043e\u0439\u043d" },
            { "mfe", "\u043c\u0430\u0432\u0440\u0438\u043a\u0438\u043d \u043a\u0440\u0435\u043e\u043b\u0438\u0439\u043d" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d-\u0442\u043e\u043d\u0433\u043e" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "pa", "\u043f\u0430\u043d\u0434\u0436\u0430\u0431\u0438" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u2014 \u041a\u0435\u0440\u043b\u0430 \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0430\u0448" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "pl", "\u043f\u043e\u043b\u044f\u043a\u0438\u0439\u043d" },
            { "ewo", "\u044d\u0432\u043e\u043d\u0434\u043e" },
            { "PM", "\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0430, \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0430" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u04c0\u0438\u043d\u0430\u043d \u043b\u0430\u0442\u0442\u0430\u043d\u0430\u0448" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0445\u043e\u0439\u043d" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "nia", "\u043d\u0438\u0430\u0441" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0438\u043b\u0438\u043d \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0445\u043e\u0439\u043d" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "kcg", "\u0442\u044c\u044f\u043f" },
            { "Hebr", metaValue_he },
            { "mgh", "\u043c\u0430\u043a\u0443\u0430-\u043c\u0435\u0435\u0442\u0442\u043e" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "key.ca", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "niu", "\u043d\u0438\u0443\u044d" },
            { "QO", "\u0410\u0440\u0430\u0445\u044c\u0430\u0440\u0430 \u041e\u043a\u0435\u0430\u043d\u0438" },
            { "lez", "\u043b\u0430\u044c\u0437\u0433\u0438\u0439\u043d" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "001", "\u0414\u0435\u0440\u0440\u0438\u0433\u0434\u0443\u044c\u043d\u0435\u043d\u0430\u043d" },
            { "Ethi", "\u044d\u0444\u0438\u043e\u043f\u0438\u043d" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "005", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448\u0438\u0439\u043d" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "key.cu", "\u0430\u0445\u0447\u0430" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0438" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d\u0438\u0439\u043d" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438" },
            { "RU", "\u0420\u043e\u0441\u0441\u0438" },
            { "ru", "\u043e\u044c\u0440\u0441\u0438\u0439\u043d" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "rw", "\u043a\u0438\u043d\u044c\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u044c\u044f\u043d\u0443" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "en_AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "SA", "\u0421\u0430\u04c0\u0443\u0434\u0438\u0439\u043d \u04c0\u0430\u044c\u0440\u0431\u0438\u0439\u0447\u043e\u044c" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "011", "\u041c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d\u0438\u0439\u043d" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "sd", "\u0441\u0438\u043d\u0434\u0445\u0438" },
            { "013", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438" },
            { "se", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "014", "\u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "015", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "SH", "\u0421\u0438\u0439\u043b\u0430\u0445\u044c\u0447\u0443 \u0415\u043b\u0435\u043d\u0438\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "si", metaValue_si },
            { "017", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "018", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SJ", "\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0430, \u042f\u043d-\u041c\u0430\u0439\u0435\u043d \u0430" },
            { "019", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0430, \u043a\u044a\u0438\u043b\u0431\u0430 \u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a\u0438\u0439\u043d" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430- \u041b\u0435\u043e\u043d\u0435" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0438\u0439\u043d" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430\u043d\u043e\u0439\u043d" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "arn", "\u0430\u0440\u0430\u0443\u043a\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u043e\u0439\u043d" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u043e" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "sr", "\u0441\u0435\u0440\u0431\u0438\u0439\u043d" },
            { "SS", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0421\u0443\u0434\u0430\u043d" },
            { "ss", "\u0441\u0432\u0430\u0437\u0438" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0430, \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438 \u0430" },
            { "st", "\u043a\u044a\u0438\u043b\u0431\u0430 \u0441\u043e\u0442\u043e" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "sv", "\u0448\u0432\u0435\u0434\u0438\u0439\u043d" },
            { "sw", "\u0441\u0443\u0430\u0445\u0438\u043b\u0438" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0428\u0435\u043c\u0430" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "iba", "\u0438\u0431\u0430\u043d\u0438\u0439\u043d" },
            { "ta", metaValue_ta },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d-\u0434\u0430- \u041a\u0443\u043d\u044c\u044f" },
            { "asa", "\u0430\u0441\u0443" },
            { "021", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u2013 \u0410\u0426\u0428 \u0430, \u041a\u0430\u043d\u0430\u0434\u0430 \u0430" },
            { "142", "\u0410\u0437\u0438" },
            { "TC", "\u0422\u0451\u0440\u043a\u0441 \u0430, \u041a\u0430\u0439\u043a\u043e\u0441 \u0430 \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "yav", "\u044f\u043d\u0433\u0431\u0435\u043d" },
            { "143", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435" },
            { "TD", "\u0427\u0430\u0434" },
            { "te", metaValue_te },
            { "145", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0430, \u0413\u0435\u0440\u0433\u0430\u0440\u0430 \u0430 \u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u043a\u044a\u0438\u043b\u0431\u0430 \u043b\u0430\u0442\u0442\u0430\u043d\u0430\u0448" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "tg", "\u0442\u0430\u0434\u0436\u0438\u043a\u0438\u0439\u043d" },
            { "th", metaValue_th },
            { "TH", "\u0422\u0430\u0438\u043b\u0430\u043d\u0434" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "bug", "\u0431\u0443\u0433\u0438\u0439\u043d" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "TJ", "\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u0430\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u0430\u0448" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0439\u043d" },
            { "TL", "\u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0422\u0438\u043c\u043e\u0440" },
            { "ybb", "\u0439\u0435\u043c\u0431\u0430" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "tn", "\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u043d\u0438\u0439\u043d" },
            { "dyo", "\u0434\u044c\u043e\u043b\u0430-\u0444\u043e\u043d\u044c\u0438" },
            { "TR", "\u0422\u0443\u0440\u043a\u043e\u0439\u0447\u043e\u044c" },
            { "tr", "\u0442\u0443\u0440\u043a\u043e\u0439\u043d" },
            { "ts", "\u0442\u0441\u043e\u043d\u0433\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0438\u0439\u043d" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0430, \u0422\u043e\u0431\u0430\u0433\u043e \u0430" },
            { "tt", "\u0433\u04c0\u0435\u0437\u0430\u043b\u043e\u0439\u043d" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0438\u0439\u043d" },
            { "ty", "\u0442\u0430\u0438\u0442\u044f\u043d\u043e\u0439\u043d" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438" },
            { "nmg", "\u043a\u0432\u0430\u0441\u0438\u043e" },
            { "Zzzz", "\u0434\u043e\u044c\u0432\u0437\u0443\u0448 \u0434\u043e\u0446\u0443 \u0439\u043e\u0437\u0430" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "rup", "\u0430\u0440\u0443\u043c\u0438\u043d\u0438\u0439\u043d" },
            { "030", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0410\u0437\u0438" },
            { "151", "\u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "dzg", "\u0434\u0430\u0437\u0430" },
            { "tyv", "\u0442\u0443\u0432\u0438\u043d\u0438\u0439\u043d" },
            { "sw_CD", "\u0441\u0443\u0430\u0445\u0438\u043b\u0438 (\u041a\u043e\u043d\u0433\u043e)" },
            { "034", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0410\u0437\u0438" },
            { "155", "\u041c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "035", "\u041a\u044a\u0438\u043b\u0431\u0430-\u043c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0410\u0437\u0438" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440\u0438\u0439\u043d" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u043c\u0430\u0441\u0441\u0430\u0440\u0430 \u0430 \u0442\u04c0\u0435\u044d\u0446\u043d\u0430" },
            { "039", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d\u0438\u0439\u043d" },
            { "Sinh", metaValue_si },
            { "UM", "\u0410\u0426\u0428\u043d \u0430\u0440\u0430\u0445\u044c\u0430\u0440\u0430 \u043a\u0435\u0433\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "UN", "\u0412\u043e\u0432\u0448\u0430\u0445\u043a\u0445\u0435\u0442\u0442\u0430 \u041a\u044a\u0430\u044c\u043c\u043d\u0438\u0439\u043d \u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "US", "\u0426\u0445\u044c\u0430\u043d\u0430\u0442\u043e\u044c\u0445\u043d\u0430 \u0428\u0442\u0430\u0442\u0430\u0448" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u043d" },
            { "xal", "\u0433\u04c0\u0430\u043b\u043c\u0430\u043a\u0445\u043e\u0439\u043d" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "prg", "\u043f\u0440\u0443\u0441\u0441\u0438\u0439\u043d" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a\u0438\u0439\u043d" },
            { "kha", "\u043a\u0445\u0430\u0441\u0438" },
            { "tzm", "\u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442\u0438\u0439\u043d" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u0443\u043d\u0434" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "nds_NL", "\u043b\u0430\u0445\u0430\u0440\u0430 \u0441\u0430\u043a\u0441\u043e\u043d\u0438\u0439\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0430, \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0430\u0448 \u0430" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "VG", "\u0412\u0438\u0440\u0433\u0438\u043d\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 (\u0411\u0440\u0438\u0442\u0430\u043d\u0438)" },
            { "VI", "\u0412\u0438\u0440\u0433\u0438\u043d\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 (\u0410\u0426\u0428)" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c\u0445\u043e\u0439\u043d" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u0438\u0438\u043d\u0438" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u044e\u043a" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "gaa", "\u0433\u0430" },
            { "nog", "\u043d\u043e\u0433\u04c0\u0438\u0439\u043d" },
            { "rwk", "\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "wa", "\u0432\u0430\u043b\u043b\u043e\u043d\u043e\u0439\u043d" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0437\u0438\u0439\u043d" },
            { "syr", "\u0448\u0435\u043c\u0430\u0445\u043e\u0439\u043d" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0430, \u0424\u0443\u0442\u0443\u043d\u0430 \u0430" },
            { "Grek", metaValue_el },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "wae", "\u0432\u0430\u043b\u043b\u0438\u0441\u0438\u0439\u043d" },
            { "zgh", "\u043c\u043e\u0440\u043e\u043a\u043a\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0430\u043d \u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442\u0438\u0439\u043d" },
            { "ar_001", "\u0425\u04c0\u0438\u043d\u0446\u0430 \u0431\u043e\u043b\u0443 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0430\u043d \u04c0\u0430\u044c\u0440\u0431\u0438\u0439\u043d" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "Mong", metaValue_mn },
            { "wal", "\u0432\u043e\u043b\u0430\u043c\u043e" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438\u0439\u043d" },
            { "war", "\u0432\u0430\u0440\u0430\u0439" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0438" },
            { "Latn", metaValue_la },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "xh", "\u043a\u043e\u0441\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0439\u043e\u0437\u0430 \u0434\u043e\u0446\u0443" },
            { "byn", "\u0431\u0438\u043b\u0438\u0439\u043d" },
            { "wbp", "\u0432\u0430\u0440\u043b\u043f\u0438\u0440\u0438" },
            { "moh", "\u043c\u043e\u0445\u0430\u0443\u043a" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "YE", "\u0419\u0435\u043c\u0435\u043d" },
            { "nqo", "\u043d\u043a\u043e" },
            { "yi", "\u0438\u0434\u0438\u0448" },
            { "mos", "\u043c\u043e\u0441\u0438" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d \u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "vai", "\u0432\u0430\u0438" },
            { "ZA", "\u041a\u044a\u0438\u043b\u0431\u0430-\u0410\u0444\u0440\u0438\u043a\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0434\u0436\u0438\u043d" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "zh", "\u0446\u0438\u0439\u043d" },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438" },
            { "Bopo", "\u0431\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "Geor", metaValue_ka },
            { "ZZ", "\u0419\u043e\u044c\u0432\u0437\u0443\u0448 \u0439\u043e\u0446\u0443 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "nso", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0441\u043e\u0442\u043e" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "gez", "\u0433\u0435\u044d\u0437" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0435" },
            { "zh_Hans", "\u0430\u0442\u0442\u0430 \u0446\u0438\u0439\u043d" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u044f\u043a\u0438\u0439\u043d" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "nus", "\u043d\u0443\u044d\u0440" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "dar", "\u0434\u0430\u044c\u0440\u0433\u04c0\u043e\u0439\u043d" },
            { "dav", "\u0442\u0430\u0438\u0442\u0430" },
            { "lrc", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u043b\u0443\u0440\u0438" },
            { "zh_Hant", "\u043b\u0430\u043c\u0430\u0441\u0442\u0430\u043d \u0446\u0438\u0439\u043d" },
            { "kpe", "\u043a\u043f\u0435\u043b\u043b\u0435" },
            { "ilo", "\u0438\u043b\u043e\u043a\u043e" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442\u0438\u0439\u043d" },
            { "Khmr", metaValue_km },
            { "mul", "\u0442\u0430\u0439\u043f-\u0442\u0430\u0439\u043f\u0430 \u0434\u043e\u044c\u0437\u0430\u043b\u0430\u043d \u043c\u0435\u0442\u0442\u0430\u043d\u0430\u0448" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "gil", "\u0433\u0438\u043b\u044c\u0431\u0435\u0440\u0442\u0438\u0439\u043d" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u0435" },
            { "sah", "\u044f\u043a\u0443\u0442\u0438\u0439\u043d" },
            { "krc", "\u043a\u0445\u0430\u0440\u0430\u0447\u043e\u0439\u043d-\u0431\u0430\u043b\u043a\u0445\u0430\u0440\u043e\u0439\u043d" },
            { "inh", "\u0433\u04c0\u0430\u043b\u0433\u04c0\u0430\u0439\u043d" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u0438\u0439\u043d" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "efi", "\u044d\u0444\u0438\u043a" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0439\u043d" },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0438" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0438\u0430" },
        };
        return data;
    }
}
