/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.transport.bio.util.FastQueue;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MessageDispatchInterceptor
extends ChannelInterceptorBase
implements Runnable {
    private static final Log log = LogFactory.getLog(MessageDispatchInterceptor.class);
    protected long maxQueueSize = 0x4000000L;
    protected FastQueue queue = new FastQueue();
    protected volatile boolean run = false;
    protected Thread msgDispatchThread = null;
    protected long currentSize = 0L;
    protected boolean useDeepClone = true;
    protected boolean alwaysSend = true;

    public MessageDispatchInterceptor() {
        this.setOptionFlag(8);
    }

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        boolean bl;
        boolean bl2 = bl = (channelMessage.getOptions() & 8) == 8;
        if (bl && this.run) {
            if (this.getCurrentSize() + (long)channelMessage.getMessage().getLength() > this.maxQueueSize) {
                if (this.alwaysSend) {
                    super.sendMessage(memberArray, channelMessage, interceptorPayload);
                    return;
                }
                throw new ChannelException("Asynchronous queue is full, reached its limit of " + this.maxQueueSize + " bytes, current:" + this.getCurrentSize() + " bytes.");
            }
            if (this.useDeepClone) {
                channelMessage = (ChannelMessage)channelMessage.deepclone();
            }
            if (!this.addToQueue(channelMessage, memberArray, interceptorPayload)) {
                throw new ChannelException("Unable to add the message to the async queue, queue bug?");
            }
            this.addAndGetCurrentSize(channelMessage.getMessage().getLength());
        } else {
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
        }
    }

    public boolean addToQueue(ChannelMessage channelMessage, Member[] memberArray, InterceptorPayload interceptorPayload) {
        return this.queue.add(channelMessage, memberArray, interceptorPayload);
    }

    public LinkObject removeFromQueue() {
        return this.queue.remove();
    }

    public void startQueue() {
        this.msgDispatchThread = new Thread(this);
        String string = "";
        if (this.getChannel() instanceof GroupChannel && ((GroupChannel)this.getChannel()).getName() != null) {
            string = "[" + ((GroupChannel)this.getChannel()).getName() + "]";
        }
        this.msgDispatchThread.setName("MessageDispatchInterceptor.MessageDispatchThread" + string);
        this.msgDispatchThread.setDaemon(true);
        this.msgDispatchThread.setPriority(10);
        this.queue.setEnabled(true);
        this.run = true;
        this.msgDispatchThread.start();
    }

    public void stopQueue() {
        this.run = false;
        this.msgDispatchThread.interrupt();
        this.queue.setEnabled(false);
        this.setAndGetCurrentSize(0L);
    }

    @Override
    public void setOptionFlag(int n) {
        if (n != 8) {
            log.warn((Object)"Warning, you are overriding the asynchronous option flag, this will disable the Channel.SEND_OPTIONS_ASYNCHRONOUS that other apps might use.");
        }
        super.setOptionFlag(n);
    }

    public void setMaxQueueSize(long l) {
        this.maxQueueSize = l;
    }

    public void setUseDeepClone(boolean bl) {
        this.useDeepClone = bl;
    }

    public long getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public boolean getUseDeepClone() {
        return this.useDeepClone;
    }

    public long getCurrentSize() {
        return this.currentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addAndGetCurrentSize(long l) {
        MessageDispatchInterceptor messageDispatchInterceptor = this;
        synchronized (messageDispatchInterceptor) {
            this.currentSize += l;
            return this.currentSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setAndGetCurrentSize(long l) {
        MessageDispatchInterceptor messageDispatchInterceptor = this;
        synchronized (messageDispatchInterceptor) {
            this.currentSize = l;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int n) throws ChannelException {
        if (!this.run) {
            MessageDispatchInterceptor messageDispatchInterceptor = this;
            synchronized (messageDispatchInterceptor) {
                if (!this.run && (n & 2) == 2) {
                    this.startQueue();
                }
            }
        }
        super.start(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int n) throws ChannelException {
        if (this.run) {
            MessageDispatchInterceptor messageDispatchInterceptor = this;
            synchronized (messageDispatchInterceptor) {
                if (this.run && (n & 2) == 2) {
                    this.stopQueue();
                }
            }
        }
        super.stop(n);
    }

    @Override
    public void run() {
        while (this.run) {
            LinkObject linkObject = this.removeFromQueue();
            if (linkObject == null) continue;
            while (linkObject != null && this.run) {
                linkObject = this.sendAsyncData(linkObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkObject sendAsyncData(LinkObject linkObject) {
        ChannelMessage channelMessage = linkObject.data();
        Member[] memberArray = linkObject.getDestination();
        try {
            super.sendMessage(memberArray, channelMessage, null);
            try {
                if (linkObject.getHandler() != null) {
                    linkObject.getHandler().handleCompletion(new UniqueId(channelMessage.getUniqueId()));
                }
            }
            catch (Exception exception) {
                log.error((Object)"Unable to report back completed message.", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            ChannelException channelException = null;
            channelException = exception instanceof ChannelException ? (ChannelException)exception : new ChannelException(exception);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while processing async message.", (Throwable)exception);
            }
            try {
                if (linkObject.getHandler() != null) {
                    linkObject.getHandler().handleError(channelException, new UniqueId(channelMessage.getUniqueId()));
                }
            }
            catch (Exception exception2) {
                log.error((Object)"Unable to report back error message.", (Throwable)exception2);
            }
        }
        finally {
            this.addAndGetCurrentSize(-channelMessage.getMessage().getLength());
            linkObject = linkObject.next();
        }
        return linkObject;
    }

    public boolean isAlwaysSend() {
        return this.alwaysSend;
    }

    public void setAlwaysSend(boolean bl) {
        this.alwaysSend = bl;
    }
}

