/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Set;
import org.apache.coyote.ActionCode;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Processor
extends AbstractHttp11Processor<Socket> {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    protected InternalInputBuffer inputBuffer = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected SSLSupport sslSupport;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11Processor(int n, boolean bl, JIoEndpoint jIoEndpoint, int n2, Set<String> set, int n3, int n4, String string, String string2) {
        super(jIoEndpoint);
        this.httpParser = new HttpParser(string, string2);
        this.inputBuffer = new InternalInputBuffer(this.request, n, bl, this.httpParser);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalOutputBuffer(this.response, n);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(n2, set, n3, n4);
    }

    @Override
    public void setSslSupport(SSLSupport sSLSupport) {
        this.sslSupport = sSLSupport;
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int n) {
        this.disableKeepAlivePercentage = n;
    }

    @Override
    protected boolean disableKeepAlive() {
        int n;
        int n2 = -1;
        int n3 = this.endpoint.getMaxThreadsWithExecutor();
        if (n3 > 0 && (n = this.endpoint.getCurrentThreadsBusy()) > 0) {
            n2 = n * 100 / n3;
        }
        return n2 > this.getDisableKeepAlivePercentage();
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
        if (this.inputBuffer.lastValid == 0 && this.socketWrapper.getLastAccess() > -1L) {
            long l;
            int n = this.keepAliveTimeout == -1 ? 0 : ((l = System.currentTimeMillis() - this.socketWrapper.getLastAccess()) >= (long)this.keepAliveTimeout ? 1 : this.keepAliveTimeout - (int)l);
            ((Socket)this.socketWrapper.getSocket()).setSoTimeout(n);
            if (!this.inputBuffer.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.endpoint.getSoTimeout() > 0) {
                this.setSocketTimeout(this.endpoint.getSoTimeout());
            } else {
                this.setSocketTimeout(0);
            }
        }
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        return false;
    }

    @Override
    protected void setSocketTimeout(int n) throws IOException {
        ((Socket)this.socketWrapper.getSocket()).setSoTimeout(n);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Socket> socketWrapper) {
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Socket> socketWrapper) {
        this.openSocket = this.keepAlive;
        return this.inputBuffer.lastValid == 0;
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void recycleInternal() {
        this.socketWrapper = null;
        this.sslSupport = null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus socketStatus) throws IOException {
        throw new IOException(sm.getString("http11processor.comet.notsupported"));
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case REQ_SSL_ATTRIBUTE: {
                try {
                    if (this.sslSupport == null) break;
                    Object object2 = this.sslSupport.getCipherSuite();
                    if (object2 != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", object2);
                    }
                    if ((object2 = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", object2);
                    }
                    if ((object2 = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", object2);
                    }
                    if ((object2 = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", object2);
                    }
                    if ((object2 = this.sslSupport.getProtocol()) != null) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", object2);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)exception);
                }
                break;
            }
            case REQ_HOST_ADDR_ATTRIBUTE: {
                InetAddress inetAddress;
                if (this.remoteAddr == null && this.socketWrapper != null && (inetAddress = ((Socket)this.socketWrapper.getSocket()).getInetAddress()) != null) {
                    this.remoteAddr = inetAddress.getHostAddress();
                }
                this.request.remoteAddr().setString(this.remoteAddr);
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                InetAddress inetAddress;
                if (this.localName == null && this.socketWrapper != null && (inetAddress = ((Socket)this.socketWrapper.getSocket()).getLocalAddress()) != null) {
                    this.localName = inetAddress.getHostName();
                }
                this.request.localName().setString(this.localName);
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (this.remoteHost == null && this.socketWrapper != null) {
                    InetAddress inetAddress = ((Socket)this.socketWrapper.getSocket()).getInetAddress();
                    if (inetAddress != null) {
                        this.remoteHost = inetAddress.getHostName();
                    }
                    if (this.remoteHost == null) {
                        if (this.remoteAddr != null) {
                            this.remoteHost = this.remoteAddr;
                        } else {
                            this.request.remoteHost().recycle();
                        }
                    }
                }
                this.request.remoteHost().setString(this.remoteHost);
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (this.localAddr == null) {
                    this.localAddr = ((Socket)this.socketWrapper.getSocket()).getLocalAddress().getHostAddress();
                }
                this.request.localAddr().setString(this.localAddr);
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (this.remotePort == -1 && this.socketWrapper != null) {
                    this.remotePort = ((Socket)this.socketWrapper.getSocket()).getPort();
                }
                this.request.setRemotePort(this.remotePort);
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (this.localPort == -1 && this.socketWrapper != null) {
                    this.localPort = ((Socket)this.socketWrapper.getSocket()).getLocalPort();
                }
                this.request.setLocalPort(this.localPort);
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                if (this.sslSupport == null) break;
                InputFilter[] inputFilterArray = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilterArray[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilterArray[3]);
                try {
                    Object[] objectArray = this.sslSupport.getPeerCertificateChain(true);
                    if (objectArray == null) break;
                    this.request.setAttribute("javax.servlet.request.X509Certificate", objectArray);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)exception);
                }
                break;
            }
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((JIoEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                long l = (Long)object;
                this.socketWrapper.setTimeout(l);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((JIoEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilterArray) {
        Exception exception = new Exception();
        log.error((Object)sm.getString("http11processor.neverused"), (Throwable)exception);
        return false;
    }

    @Override
    protected AbstractInputBuffer<Socket> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Socket> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSocketBuffer(int n) {
        super.setSocketBuffer(n);
        this.outputBuffer.setSocketBuffer(n);
    }
}

