/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingResultSet;
import org.apache.tomcat.util.compat.JreCompat;

public class DelegatingStatement
extends AbandonedTrace
implements Statement {
    protected Statement _stmt = null;
    protected DelegatingConnection _conn = null;
    protected boolean _closed = false;

    public DelegatingStatement(DelegatingConnection delegatingConnection, Statement statement) {
        super(delegatingConnection);
        this._stmt = statement;
        this._conn = delegatingConnection;
    }

    public Statement getDelegate() {
        return this._stmt;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        Statement statement = this.getInnermostDelegate();
        if (statement == null) {
            return false;
        }
        if (object instanceof DelegatingStatement) {
            DelegatingStatement delegatingStatement = (DelegatingStatement)object;
            return statement.equals(delegatingStatement.getInnermostDelegate());
        }
        return statement.equals(object);
    }

    public int hashCode() {
        Statement statement = this.getInnermostDelegate();
        if (statement == null) {
            return 0;
        }
        return statement.hashCode();
    }

    public Statement getInnermostDelegate() {
        Statement statement = this._stmt;
        while (statement != null && statement instanceof DelegatingStatement) {
            if (this != (statement = ((DelegatingStatement)statement).getDelegate())) continue;
            return null;
        }
        return statement;
    }

    public void setDelegate(Statement statement) {
        this._stmt = statement;
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.getClass().getName() + " with address: \"" + this.toString() + "\" is closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            try {
                List<AbandonedTrace> list;
                if (this._conn != null) {
                    this._conn.removeTrace(this);
                    this._conn = null;
                }
                if ((list = this.getTrace()) != null) {
                    ResultSet[] resultSetArray = list.toArray(new ResultSet[list.size()]);
                    for (int i = 0; i < resultSetArray.length; ++i) {
                        resultSetArray[i].close();
                    }
                    this.clearTrace();
                }
                this._stmt.close();
            }
            catch (SQLException sQLException) {
                this.handleException(sQLException);
            }
        }
        finally {
            this._closed = true;
        }
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        if (this._conn == null) {
            throw sQLException;
        }
        this._conn.handleException(sQLException);
    }

    public void activate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).activate();
        }
    }

    public void passivate() throws SQLException {
        if (this._stmt instanceof DelegatingStatement) {
            ((DelegatingStatement)this._stmt).passivate();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._conn;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.getResultSet());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMaxRows();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.cancel();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getFetchSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetType();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        try {
            this._stmt.clearBatch();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeBatch();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    public String toString() {
        return this._stmt.toString();
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getMoreResults(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this._stmt.getGeneratedKeys());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        if (this._conn != null) {
            this._conn.setLastUsed();
        }
        try {
            return this._stmt.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass()) || this._stmt.isWrapperFor(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this._stmt.getClass())) {
            return clazz.cast(this._stmt);
        }
        return this._stmt.unwrap(clazz);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this._stmt.setPoolable(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        try {
            return this._stmt.isPoolable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            JreCompat.getInstance().closeOnCompletion(this._stmt);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            return JreCompat.getInstance().isCloseOnCompletion(this._stmt);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }
}

