# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_processing_pass import ImageProcessingPass


class PanoramicProjectionPass(ImageProcessingPass):
    """
    PanoramicProjectionPass - Render pass that render the scene in a
    cubemap and project these six renderings to a single quad.
    
    Superclass: ImageProcessingPass
    
    There are currently two differents projections implemented
    (Equirectangular and Azimuthal). This pass can be used to produce
    images that can be visualize with specific devices that re-maps the
    distorted image to a panoramic view (for instance VR headsets, domes,
    panoramic screens)
    
    Note that it is often necessary to disable frustum cullers in order
    to render properly objects that are behind the camera.
    
    @sa
    RenderPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPanoramicProjectionPass, obj, update, **traits)
    
    projection_type = tvtk_base.RevPrefixMap({'equirectangular': 1, 'azimuthal': 2}, default_value='equirectangular', desc=\
        """
        Get/Set the type of projection. Equirectangular projection maps
        meridians to vertical straight lines and circles of latitude to
        horizontal straight lines. Azimuthal equidistant projection maps
        all points of the scene based on their distance to the view
        direction. This projection produces a fisheye effect. Default is
        Equirectangular.
        """
    )

    def _projection_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProjectionType,
                        self.projection_type_)

    angle = traits.Trait(180.0, traits.Range(90.0, 360.0, enter_set=True, auto_set=False), desc=\
        """
        Get/Set the vertical angle of projection. 180 degrees is a half
        sphere, 360 degrees is a full sphere, but any values in the range
        (90;360) can be set. Default is 180 degrees.
        """
    )

    def _angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAngle,
                        self.angle)

    cube_resolution = traits.Int(300, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the cubemap textures resolution used to render
        (offscreen) all directions. Default is 300.
        """
    )

    def _cube_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCubeResolution,
                        self.cube_resolution)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('projection_type', 'GetProjectionType'),
    ('angle', 'GetAngle'), ('cube_resolution', 'GetCubeResolution'),
    ('active_draw_buffers', 'GetActiveDrawBuffers'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'projection_type',
    'active_draw_buffers', 'angle', 'cube_resolution'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PanoramicProjectionPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PanoramicProjectionPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['projection_type'], ['active_draw_buffers', 'angle',
            'cube_resolution']),
            title='Edit PanoramicProjectionPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PanoramicProjectionPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

