/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.cache;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public final class JLaTeXMathCache {
    private static final AffineTransform identity = new AffineTransform();
    private static ConcurrentMap<CachedTeXFormula, SoftReference<CachedImage>> cache = new ConcurrentHashMap<CachedTeXFormula, SoftReference<CachedImage>>(128);
    private static int max = Integer.MAX_VALUE;
    private static ReferenceQueue<CachedImage> queue = new ReferenceQueue();

    private JLaTeXMathCache() {
    }

    public static void setMaxCachedObjects(int max) {
        JLaTeXMathCache.max = Math.max(max, 1);
        cache.clear();
        cache = new ConcurrentHashMap<CachedTeXFormula, SoftReference<CachedImage>>(JLaTeXMathCache.max);
    }

    public static int[] getCachedTeXFormulaDimensions(String f, int style, int type, int size, int inset, Color fgcolor) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaDimensions(new CachedTeXFormula(f, style, type, size, inset, fgcolor));
    }

    public static int[] getCachedTeXFormulaDimensions(String f, int style, int size, int inset) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaDimensions(f, style, 0, size, inset, null);
    }

    public static int[] getCachedTeXFormulaDimensions(Object o) throws ParseException {
        if (o == null || !(o instanceof CachedTeXFormula)) {
            return new int[]{0, 0, 0};
        }
        CachedTeXFormula cached = (CachedTeXFormula)o;
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        return new int[]{cached.width, cached.height, cached.depth};
    }

    public static Object getCachedTeXFormula(String f, int style, int type, int size, int inset, Color fgcolor) throws ParseException {
        CachedTeXFormula cached = new CachedTeXFormula(f, style, type, size, inset, fgcolor);
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        return cached;
    }

    public static Object getCachedTeXFormula(String f, int style, int size, int inset) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormula(f, style, 0, size, inset, null);
    }

    public static void clearCache() {
        cache.clear();
    }

    public static void removeCachedTeXFormula(String f, int style, int type, int size, int inset, Color fgcolor) throws ParseException {
        cache.remove(new CachedTeXFormula(f, style, type, size, inset, fgcolor));
    }

    public static void removeCachedTeXFormula(String f, int style, int size, int inset) throws ParseException {
        JLaTeXMathCache.removeCachedTeXFormula(f, style, 0, size, inset, null);
    }

    public static void removeCachedTeXFormula(Object o) throws ParseException {
        if (o != null && o instanceof CachedTeXFormula) {
            cache.remove((CachedTeXFormula)o);
        }
    }

    public static Object paintCachedTeXFormula(String f, int style, int type, int size, int inset, Color fgcolor, Graphics2D g) throws ParseException {
        return JLaTeXMathCache.paintCachedTeXFormula(new CachedTeXFormula(f, style, type, size, inset, fgcolor), g);
    }

    public static Object paintCachedTeXFormula(String f, int style, int size, int inset, Graphics2D g) throws ParseException {
        return JLaTeXMathCache.paintCachedTeXFormula(f, style, 0, size, inset, null, g);
    }

    public static Object paintCachedTeXFormula(Object o, Graphics2D g) throws ParseException {
        if (o == null || !(o instanceof CachedTeXFormula)) {
            return null;
        }
        CachedTeXFormula cached = (CachedTeXFormula)o;
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        g.drawImage(img.get().image, identity, null);
        return cached;
    }

    public static Image getCachedTeXFormulaImage(String f, int style, int type, int size, int inset, Color fgcolor) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaImage(new CachedTeXFormula(f, style, type, size, inset, fgcolor));
    }

    public static Image getCachedTeXFormulaImage(String f, int style, int size, int inset) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaImage(f, style, 0, size, inset, null);
    }

    public static Image getCachedTeXFormulaImage(Object o) throws ParseException {
        if (o == null || !(o instanceof CachedTeXFormula)) {
            return null;
        }
        CachedTeXFormula cached = (CachedTeXFormula)o;
        SoftReference<CachedImage> img = (SoftReference<CachedImage>)cache.get(cached);
        if (img == null || img.get() == null) {
            img = JLaTeXMathCache.makeImage(cached);
        }
        return img.get().image;
    }

    private static SoftReference<CachedImage> makeImage(CachedTeXFormula cached) throws ParseException {
        TeXFormula formula = new TeXFormula(cached.f);
        TeXIcon icon = formula.createTeXIcon(cached.style, cached.size, cached.type, cached.fgcolor);
        icon.setInsets(new Insets(cached.inset, cached.inset, cached.inset, cached.inset));
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        icon.paintIcon(null, g2, 0, 0);
        g2.dispose();
        cached.setDimensions(icon.getIconWidth(), icon.getIconHeight(), icon.getIconDepth());
        SoftReference<CachedImage> img = new SoftReference<CachedImage>(new CachedImage(image, cached), queue);
        if (cache.size() >= max) {
            Reference<CachedImage> soft;
            while ((soft = queue.poll()) != null) {
                CachedImage ci = soft.get();
                if (ci == null) continue;
                cache.remove(ci.cachedTf);
            }
            Iterator iter = cache.keySet().iterator();
            if (iter.hasNext()) {
                CachedTeXFormula c = (CachedTeXFormula)iter.next();
                SoftReference cachedImage = (SoftReference)cache.get(c);
                if (cachedImage != null) {
                    cachedImage.clear();
                }
                cache.remove(c);
            }
        }
        cache.put(cached, img);
        return img;
    }

    private static class CachedTeXFormula {
        String f;
        int style;
        int type;
        int size;
        int inset;
        int width = -1;
        int height;
        int depth;
        Color fgcolor;

        CachedTeXFormula(String f, int style, int type, int size, int inset, Color fgcolor) {
            this.f = f;
            this.style = style;
            this.type = type;
            this.size = size;
            this.inset = inset;
            this.fgcolor = fgcolor;
        }

        void setDimensions(int width, int height, int depth) {
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof CachedTeXFormula) {
                boolean b;
                CachedTeXFormula c = (CachedTeXFormula)o;
                boolean bl = b = c.f.equals(this.f) && c.style == this.style && c.type == this.type && c.size == this.size && c.inset == this.inset && c.fgcolor.equals(this.fgcolor);
                if (b) {
                    if (c.width == -1) {
                        c.width = this.width;
                        c.height = this.height;
                        c.depth = this.depth;
                    } else if (this.width == -1) {
                        this.width = c.width;
                        this.height = c.height;
                        this.depth = c.depth;
                    }
                }
                return b;
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode();
        }
    }

    private static class CachedImage {
        Image image;
        CachedTeXFormula cachedTf;

        CachedImage(Image image, CachedTeXFormula cachedTf) {
            this.image = image;
            this.cachedTf = cachedTf;
        }
    }
}

