/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BufferPool {
    private static final Log log = LogFactory.getLog(BufferPool.class);
    public static final int DEFAULT_POOL_SIZE = 0x6400000;
    protected static volatile BufferPool instance = null;
    protected BufferPoolAPI pool = null;

    private BufferPool(BufferPoolAPI bufferPoolAPI) {
        this.pool = bufferPoolAPI;
    }

    public XByteBuffer getBuffer(int n, boolean bl) {
        if (this.pool != null) {
            return this.pool.getBuffer(n, bl);
        }
        return new XByteBuffer(n, bl);
    }

    public void returnBuffer(XByteBuffer xByteBuffer) {
        if (this.pool != null) {
            this.pool.returnBuffer(xByteBuffer);
        }
    }

    public void clear() {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferPool getBufferPool() {
        if (instance != null) return instance;
        Class<BufferPool> clazz = BufferPool.class;
        synchronized (BufferPool.class) {
            Class<?> clazz2;
            BufferPoolAPI bufferPoolAPI;
            block6: {
                if (instance != null) return instance;
                bufferPoolAPI = null;
                clazz2 = null;
                try {
                    clazz2 = Class.forName("org.apache.catalina.tribes.io.BufferPool15Impl");
                    bufferPoolAPI = (BufferPoolAPI)clazz2.newInstance();
                }
                catch (Throwable throwable) {
                    log.warn((Object)("Unable to initilize BufferPool, not pooling XByteBuffer objects:" + throwable.getMessage()));
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)"Unable to initilize BufferPool, not pooling XByteBuffer objects:", throwable);
                }
            }
            if (bufferPoolAPI == null) return instance;
            bufferPoolAPI.setMaxSize(0x6400000);
            log.info((Object)("Created a buffer pool with max size:104857600 bytes of type:" + (clazz2 != null ? clazz2.getName() : "null")));
            instance = new BufferPool(bufferPoolAPI);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static interface BufferPoolAPI {
        public void setMaxSize(int var1);

        public XByteBuffer getBuffer(int var1, boolean var2);

        public void returnBuffer(XByteBuffer var1);

        public void clear();
    }
}

