/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.Localizer;

public class ELParser {
    private Token curToken;
    private Token prevToken;
    private String whiteSpace = "";
    private final ELNode.Nodes expr;
    private ELNode.Nodes ELexpr;
    private int index = 0;
    private final String expression;
    private char type;
    private final boolean isDeferredSyntaxAllowedAsLiteral;
    private static final String[] reservedWords = new String[]{"and", "div", "empty", "eq", "false", "ge", "gt", "instanceof", "le", "lt", "mod", "ne", "not", "null", "or", "true"};

    public ELParser(String string, boolean bl) {
        this.expression = string;
        this.isDeferredSyntaxAllowedAsLiteral = bl;
        this.expr = new ELNode.Nodes();
    }

    public static ELNode.Nodes parse(String string, boolean bl) {
        ELParser eLParser = new ELParser(string, bl);
        while (eLParser.hasNextChar()) {
            ELNode.Nodes nodes;
            String string2 = eLParser.skipUntilEL();
            if (string2.length() > 0) {
                eLParser.expr.add(new ELNode.Text(string2));
            }
            if ((nodes = eLParser.parseEL()).isEmpty()) continue;
            eLParser.expr.add(new ELNode.Root(nodes, eLParser.type));
        }
        return eLParser.expr;
    }

    private ELNode.Nodes parseEL() {
        StringBuilder stringBuilder = new StringBuilder();
        this.ELexpr = new ELNode.Nodes();
        this.curToken = null;
        this.prevToken = null;
        while (this.hasNext()) {
            this.curToken = this.nextToken();
            if (this.curToken instanceof Char) {
                if (this.curToken.toChar() == '}') break;
                stringBuilder.append(this.curToken.toString());
                continue;
            }
            if (stringBuilder.length() > 0) {
                this.ELexpr.add(new ELNode.ELText(stringBuilder.toString()));
                stringBuilder.setLength(0);
            }
            if (this.parseFunction()) continue;
            this.ELexpr.add(new ELNode.ELText(this.curToken.toString()));
        }
        if (this.curToken != null) {
            stringBuilder.append(this.curToken.getWhiteSpace());
        }
        if (stringBuilder.length() > 0) {
            this.ELexpr.add(new ELNode.ELText(stringBuilder.toString()));
        }
        return this.ELexpr;
    }

    private boolean parseFunction() {
        if (!(this.curToken instanceof Id) || this.isELReserved(this.curToken.toTrimmedString()) || this.prevToken instanceof Char && this.prevToken.toChar() == '.') {
            return false;
        }
        String string = null;
        String string2 = this.curToken.toTrimmedString();
        int n = this.index - this.curToken.toString().length();
        Token token = this.curToken;
        if (this.hasNext()) {
            Token token2;
            int n2 = this.getIndex() - this.whiteSpace.length();
            this.curToken = this.nextToken();
            if (this.curToken.toChar() == ':' && this.hasNext() && (token2 = this.nextToken()) instanceof Id) {
                string = string2;
                string2 = token2.toTrimmedString();
                if (this.hasNext()) {
                    this.curToken = this.nextToken();
                }
            }
            if (this.curToken.toChar() == '(') {
                this.ELexpr.add(new ELNode.Function(string, string2, this.expression.substring(n, this.index - 1)));
                return true;
            }
            this.curToken = token;
            this.setIndex(n2);
        }
        return false;
    }

    private boolean isELReserved(String string) {
        int n = 0;
        int n2 = reservedWords.length;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            int n4 = reservedWords[n3].compareTo(string);
            if (n4 == 0) {
                return true;
            }
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return false;
    }

    private String skipUntilEL() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasNextChar()) {
            char c = this.nextChar();
            if (c == '\\') {
                char c2 = this.peek(0);
                if (c2 == '$' || c2 == '#' && !this.isDeferredSyntaxAllowedAsLiteral) {
                    stringBuilder.append(this.nextChar());
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if ((c == '$' || c == '#' && !this.isDeferredSyntaxAllowedAsLiteral) && this.peek(0) == '{') {
                this.type = c;
                this.nextChar();
                break;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String escapeLiteralExpression(String string, boolean bl) {
        int n = string.length();
        int n2 = 0;
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '$' && (bl || c != '#') || i + 1 >= n || string.charAt(i + 1) != '{') continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n + 20);
            }
            stringBuilder.append(string.substring(n2, i));
            n2 = i + 1;
            stringBuilder.append('\\');
            stringBuilder.append(c);
        }
        if (stringBuilder == null) {
            return string;
        }
        stringBuilder.append(string.substring(n2, n));
        return stringBuilder.toString();
    }

    private static String escapeELText(String string) {
        int n = string.length();
        char c = '\u0000';
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        String string2 = string.trim();
        int n5 = string2.length();
        if (n5 > 1) {
            c = string2.charAt(0);
            if (c == '\'' || c == '\"') {
                if (string2.charAt(n5 - 1) != c) {
                    throw new IllegalArgumentException(Localizer.getMessage("org.apache.jasper.compiler.ELParser.invalidQuotesForStringLiteral", string));
                }
                n3 = string.indexOf(c) + 1;
                n4 = n3 + n5 - 2;
            } else {
                c = '\u0000';
            }
        }
        StringBuilder stringBuilder = null;
        for (int i = n3; i < n4; ++i) {
            char c2 = string.charAt(i);
            if (c2 != '\\' && c2 != c) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n + 20);
            }
            stringBuilder.append(string.substring(n2, i));
            n2 = i + 1;
            stringBuilder.append('\\');
            stringBuilder.append(c2);
        }
        if (stringBuilder == null) {
            return string;
        }
        stringBuilder.append(string.substring(n2, n));
        return stringBuilder.toString();
    }

    private boolean hasNext() {
        this.skipSpaces();
        return this.hasNextChar();
    }

    private String getAndResetWhiteSpace() {
        String string = this.whiteSpace;
        this.whiteSpace = "";
        return string;
    }

    private Token nextToken() {
        this.prevToken = this.curToken;
        if (this.hasNextChar()) {
            char c = this.nextChar();
            if (Character.isJavaIdentifierStart(c)) {
                int n = this.index - 1;
                while (this.index < this.expression.length() && Character.isJavaIdentifierPart(c = this.expression.charAt(this.index))) {
                    this.nextChar();
                }
                return new Id(this.getAndResetWhiteSpace(), this.expression.substring(n, this.index));
            }
            if (c == '\'' || c == '\"') {
                return this.parseQuotedChars(c);
            }
            return new Char(this.getAndResetWhiteSpace(), c);
        }
        return null;
    }

    private Token parseQuotedChars(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        while (this.hasNextChar()) {
            char c2 = this.nextChar();
            if (c2 == '\\') {
                c2 = this.nextChar();
                if (c2 == '\\' || c2 == '\'' || c2 == '\"') {
                    stringBuilder.append(c2);
                    continue;
                }
                throw new IllegalArgumentException(Localizer.getMessage("org.apache.jasper.compiler.ELParser.invalidQuoting", this.expression));
            }
            if (c2 == c) {
                stringBuilder.append(c2);
                break;
            }
            stringBuilder.append(c2);
        }
        return new QuotedString(this.getAndResetWhiteSpace(), stringBuilder.toString());
    }

    private void skipSpaces() {
        char c;
        int n = this.index;
        while (this.hasNextChar() && (c = this.expression.charAt(this.index)) <= ' ') {
            ++this.index;
        }
        this.whiteSpace = this.expression.substring(n, this.index);
    }

    private boolean hasNextChar() {
        return this.index < this.expression.length();
    }

    private char nextChar() {
        if (this.index >= this.expression.length()) {
            return '\uffff';
        }
        return this.expression.charAt(this.index++);
    }

    private char peek(int n) {
        int n2 = this.index + n;
        if (n2 >= this.expression.length()) {
            return '\uffff';
        }
        return this.expression.charAt(n2);
    }

    private int getIndex() {
        return this.index;
    }

    private void setIndex(int n) {
        this.index = n;
    }

    public char getType() {
        return this.type;
    }

    static class TextBuilder
    extends ELNode.Visitor {
        protected final boolean isDeferredSyntaxAllowedAsLiteral;
        protected final StringBuilder output = new StringBuilder();

        protected TextBuilder(boolean bl) {
            this.isDeferredSyntaxAllowedAsLiteral = bl;
        }

        public String getText() {
            return this.output.toString();
        }

        @Override
        public void visit(ELNode.Root root) throws JasperException {
            this.output.append(root.getType());
            this.output.append('{');
            root.getExpression().visit(this);
            this.output.append('}');
        }

        @Override
        public void visit(ELNode.Function function) throws JasperException {
            this.output.append(ELParser.escapeLiteralExpression(function.getOriginalText(), this.isDeferredSyntaxAllowedAsLiteral));
            this.output.append('(');
        }

        @Override
        public void visit(ELNode.Text text) throws JasperException {
            this.output.append(ELParser.escapeLiteralExpression(text.getText(), this.isDeferredSyntaxAllowedAsLiteral));
        }

        @Override
        public void visit(ELNode.ELText eLText) throws JasperException {
            this.output.append(ELParser.escapeELText(eLText.getText()));
        }
    }

    private static class QuotedString
    extends Token {
        private String value;

        QuotedString(String string, String string2) {
            super(string);
            this.value = string2;
        }

        @Override
        public String toString() {
            return this.whiteSpace + this.value;
        }

        @Override
        String toTrimmedString() {
            return this.value;
        }
    }

    private static class Char
    extends Token {
        private char ch;

        Char(String string, char c) {
            super(string);
            this.ch = c;
        }

        @Override
        char toChar() {
            return this.ch;
        }

        @Override
        public String toString() {
            return this.whiteSpace + this.ch;
        }

        @Override
        String toTrimmedString() {
            return "" + this.ch;
        }
    }

    private static class Id
    extends Token {
        String id;

        Id(String string, String string2) {
            super(string);
            this.id = string2;
        }

        @Override
        public String toString() {
            return this.whiteSpace + this.id;
        }

        @Override
        String toTrimmedString() {
            return this.id;
        }
    }

    private static class Token {
        protected final String whiteSpace;

        Token(String string) {
            this.whiteSpace = string;
        }

        char toChar() {
            return '\u0000';
        }

        public String toString() {
            return this.whiteSpace;
        }

        String toTrimmedString() {
            return "";
        }

        String getWhiteSpace() {
            return this.whiteSpace;
        }
    }
}

