/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspReader;

final class Mark {
    int cursor;
    int line;
    int col;
    String baseDir;
    char[] stream = null;
    private int fileId;
    private String fileName;
    private Stack<IncludeState> includeStack = null;
    private String encoding = null;
    private JspReader reader;
    private JspCompilationContext ctxt;

    Mark(JspReader jspReader, char[] cArray, int n, String string, String string2, String string3) {
        this.reader = jspReader;
        this.ctxt = jspReader.getJspCompilationContext();
        this.stream = cArray;
        this.cursor = 0;
        this.line = 1;
        this.col = 1;
        this.fileId = n;
        this.fileName = string;
        this.baseDir = string2;
        this.encoding = string3;
        this.includeStack = new Stack();
    }

    Mark(Mark mark) {
        this.init(mark, false);
    }

    void update(int n, int n2, int n3) {
        this.cursor = n;
        this.line = n2;
        this.col = n3;
    }

    void init(Mark mark, boolean bl) {
        this.cursor = mark.cursor;
        this.line = mark.line;
        this.col = mark.col;
        if (!bl) {
            this.reader = mark.reader;
            this.ctxt = mark.ctxt;
            this.stream = mark.stream;
            this.fileId = mark.fileId;
            this.fileName = mark.fileName;
            this.baseDir = mark.baseDir;
            this.encoding = mark.encoding;
            if (this.includeStack == null) {
                this.includeStack = new Stack();
            } else {
                this.includeStack.clear();
            }
            for (int i = 0; i < mark.includeStack.size(); ++i) {
                this.includeStack.addElement((IncludeState)mark.includeStack.elementAt(i));
            }
        }
    }

    Mark(JspCompilationContext jspCompilationContext, String string, int n, int n2) {
        this.reader = null;
        this.ctxt = jspCompilationContext;
        this.stream = null;
        this.cursor = 0;
        this.line = n;
        this.col = n2;
        this.fileId = -1;
        this.fileName = string;
        this.baseDir = "le-basedir";
        this.encoding = "le-endocing";
        this.includeStack = null;
    }

    public void pushStream(char[] cArray, int n, String string, String string2, String string3) {
        this.includeStack.push(new IncludeState(this.cursor, this.line, this.col, this.fileId, this.fileName, this.baseDir, this.encoding, this.stream));
        this.cursor = 0;
        this.line = 1;
        this.col = 1;
        this.fileId = n;
        this.fileName = string;
        this.baseDir = string2;
        this.encoding = string3;
        this.stream = cArray;
    }

    public Mark popStream() {
        if (this.includeStack.size() <= 0) {
            return null;
        }
        IncludeState includeState = this.includeStack.pop();
        this.cursor = includeState.cursor;
        this.line = includeState.line;
        this.col = includeState.col;
        this.fileId = includeState.fileId;
        this.fileName = includeState.fileName;
        this.baseDir = includeState.baseDir;
        this.stream = includeState.stream;
        return this;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.col;
    }

    public String getSystemId() {
        return this.getFile();
    }

    public String getPublicId() {
        return null;
    }

    public String toString() {
        return this.getFile() + "(" + this.line + "," + this.col + ")";
    }

    public String getFile() {
        return this.fileName;
    }

    public URL getURL() throws MalformedURLException {
        return this.ctxt.getResource(this.getFile());
    }

    public boolean equals(Object object) {
        if (object instanceof Mark) {
            Mark mark = (Mark)object;
            return this.reader == mark.reader && this.fileId == mark.fileId && this.cursor == mark.cursor && this.line == mark.line && this.col == mark.col;
        }
        return false;
    }

    class IncludeState {
        int cursor;
        int line;
        int col;
        int fileId;
        String fileName;
        String baseDir;
        char[] stream = null;

        IncludeState(int n, int n2, int n3, int n4, String string, String string2, String string3, char[] cArray) {
            this.cursor = n;
            this.line = n2;
            this.col = n3;
            this.fileId = n4;
            this.fileName = string;
            this.baseDir = string2;
            Mark.this.encoding = string3;
            this.stream = cArray;
        }
    }
}

