/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.MediaType;

public final class Response {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    int status = 200;
    String message = null;
    final MimeHeaders headers = new MimeHeaders();
    OutputBuffer outputBuffer;
    final Object[] notes = new Object[32];
    volatile boolean committed = false;
    public volatile ActionHook hook;
    String contentType = null;
    String contentLanguage = null;
    String characterEncoding = "ISO-8859-1";
    long contentLength = -1L;
    private Locale locale = DEFAULT_LOCALE;
    private long contentWritten = 0L;
    private long commitTime = -1L;
    boolean charsetSet = false;
    Exception errorException = null;
    private final AtomicInteger errorState = new AtomicInteger(0);
    Request req;

    public Request getRequest() {
        return this.req;
    }

    public void setRequest(Request request) {
        this.req = request;
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public ActionHook getHook() {
        return this.hook;
    }

    public void setHook(ActionHook actionHook) {
        this.hook = actionHook;
    }

    public final void setNote(int n, Object object) {
        this.notes[n] = object;
    }

    public final Object getNote(int n) {
        return this.notes[n];
    }

    public void action(ActionCode actionCode, Object object) {
        if (this.hook != null) {
            if (object == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, object);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean bl) {
        if (bl && !this.committed) {
            this.commitTime = System.currentTimeMillis();
        }
        this.committed = bl;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public void setErrorException(Exception exception) {
        this.errorException = exception;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isExceptionPresent() {
        return this.errorException != null;
    }

    public boolean setError() {
        return this.errorState.compareAndSet(0, 1);
    }

    public boolean isError() {
        return this.errorState.get() > 0;
    }

    public boolean isErrorReportRequired() {
        return this.errorState.get() == 1;
    }

    public boolean setErrorReported() {
        return this.errorState.compareAndSet(1, 2);
    }

    public void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.recycle();
        this.action(ActionCode.RESET, this);
    }

    public void finish() {
        this.action(ActionCode.CLOSE, this);
    }

    public void acknowledge() {
        this.action(ActionCode.ACK, this);
    }

    public boolean containsHeader(String string) {
        return this.headers.getHeader(string) != null;
    }

    public void setHeader(String string, String string2) {
        char c = string.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(string, string2)) {
            return;
        }
        this.headers.setValue(string).setString(string2);
    }

    public void addHeader(String string, String string2) {
        char c = string.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(string, string2)) {
            return;
        }
        this.headers.addValue(string).setString(string2);
    }

    private boolean checkSpecialHeader(String string, String string2) {
        if (string.equalsIgnoreCase("Content-Type")) {
            this.setContentType(string2);
            return true;
        }
        if (string.equalsIgnoreCase("Content-Length")) {
            try {
                long l = Long.parseLong(string2);
                this.setContentLength(l);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public void sendHeaders() {
        this.action(ActionCode.COMMIT, this);
        this.setCommitted(true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0) {
            String string = locale.getCountry();
            StringBuilder stringBuilder = new StringBuilder(this.contentLanguage);
            if (string != null && string.length() > 0) {
                stringBuilder.append('-');
                stringBuilder.append(string);
            }
            this.contentLanguage = stringBuilder.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setCharacterEncoding(String string) {
        if (this.isCommitted()) {
            return;
        }
        if (string == null) {
            return;
        }
        this.characterEncoding = string;
        this.charsetSet = true;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String string) {
        if (string == null) {
            this.contentType = null;
            return;
        }
        MediaType mediaType = null;
        try {
            mediaType = HttpParser.parseMediaType(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mediaType == null) {
            this.contentType = string;
            return;
        }
        this.contentType = mediaType.toStringNoCharset();
        String string2 = mediaType.getCharset();
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            this.charsetSet = true;
            this.characterEncoding = string2;
        }
    }

    public void setContentTypeNoCharset(String string) {
        this.contentType = string;
    }

    public String getContentType() {
        String string = this.contentType;
        if (string != null && this.characterEncoding != null && this.charsetSet) {
            string = string + ";charset=" + this.characterEncoding;
        }
        return string;
    }

    public void setContentLength(long l) {
        this.contentLength = l;
    }

    public int getContentLength() {
        long l = this.getContentLengthLong();
        if (l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return -1;
    }

    public long getContentLengthLong() {
        return this.contentLength;
    }

    public void doWrite(ByteChunk byteChunk) throws IOException {
        this.outputBuffer.doWrite(byteChunk, this);
        this.contentWritten += (long)byteChunk.getLength();
    }

    public void recycle() {
        this.contentType = null;
        this.contentLanguage = null;
        this.locale = DEFAULT_LOCALE;
        this.characterEncoding = "ISO-8859-1";
        this.charsetSet = false;
        this.contentLength = -1L;
        this.status = 200;
        this.message = null;
        this.committed = false;
        this.commitTime = -1L;
        this.errorException = null;
        this.errorState.set(0);
        this.headers.clear();
        this.contentWritten = 0L;
    }

    public long getContentWritten() {
        return this.contentWritten;
    }

    public long getBytesWritten(boolean bl) {
        if (bl) {
            this.action(ActionCode.CLIENT_FLUSH, this);
        }
        return this.outputBuffer.getBytesWritten();
    }
}

