/**
 * SECTION:im-details
 * @short_description: Object representing an IM address value that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_IM_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksImFieldDetails"><type>FolksImFieldDetails</type></link>.
 */
/**
 * folks_im_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, which should be a valid, non-empty IM address </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new ImFieldDetails.
 * 
 * Returns: <para>a new ImFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksImFieldDetails:
 * 
 * Object representing an IM address value that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksImFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-IM-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_IM_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FolksImDetailsError:
 * @FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS: The specified IM address could not be parsed.
 * 
 * Errors related to IM addresses and IM address handling.
 */
/**
 * folks_im_details_change_im_addresses:
 * @self: the <link linkend="FolksImDetails"><type>FolksImDetails</type></link> instance
 * @im_addresses: (in): &nbsp;.  <para>the new map of protocols to IM addresses </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s set of IM addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link> directly, as this method gives error notification and will only return once the IM addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the IM addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-im-details-change-im-addresses-finish"><function>folks_im_details_change_im_addresses_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_im_details_change_im_addresses_finish:
 * @self: the <link linkend="FolksImDetails"><type>FolksImDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s set of IM addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link> directly, as this method gives error notification and will only return once the IM addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the IM addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-im-details-change-im-addresses"><function>folks_im_details_change_im_addresses()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksImDetails:im-addresses:
 * 
 * A mapping of IM protocol to an (unordered) set of IM addresses.
 * 
 * <para>Each mapping is from an arbitrary protocol identifier to a set of IM addresses on that protocol for the contact, listed in no particular order.</para><para>There must be no duplicate IM addresses in each set, though a given IM address may be present in the sets for different protocols.</para><para>All the IM addresses must be normalised using <link linkend="folks-im-details-normalise-im-address"><function>folks_im_details_normalise_im_address()</function></link> before being added to this property.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_im_details_get_im_addresses:
 * @self: the <link linkend="FolksImDetails"><type>FolksImDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link> property.
 * 
 * A mapping of IM protocol to an (unordered) set of IM addresses.
 * 
 * <para>Each mapping is from an arbitrary protocol identifier to a set of IM addresses on that protocol for the contact, listed in no particular order.</para><para>There must be no duplicate IM addresses in each set, though a given IM address may be present in the sets for different protocols.</para><para>All the IM addresses must be normalised using <link linkend="folks-im-details-normalise-im-address"><function>folks_im_details_normalise_im_address()</function></link> before being added to this property.</para>
 * 
 * Returns: the value of the <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_im_details_set_im_addresses:
 * @self: the <link linkend="FolksImDetails"><type>FolksImDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link> property
 * 
 * Set the value of the <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link> property to @value.
 * 
 * A mapping of IM protocol to an (unordered) set of IM addresses.
 * 
 * <para>Each mapping is from an arbitrary protocol identifier to a set of IM addresses on that protocol for the contact, listed in no particular order.</para><para>There must be no duplicate IM addresses in each set, though a given IM address may be present in the sets for different protocols.</para><para>All the IM addresses must be normalised using <link linkend="folks-im-details-normalise-im-address"><function>folks_im_details_normalise_im_address()</function></link> before being added to this property.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_im_details_normalise_im_address:
 * @im_address: (in): &nbsp;.  <para>the address to normalise </para>
 * @protocol: (in): &nbsp;.  <para>the protocol of this im_address </para>
 * @error: (error-domains FolksImDetailsError): location to store the error occurring, or %NULL to ignore
 * 
 * Normalise an IM address so that it&apos;s suitable for string comparison.
 * 
 * <para>IM addresses for various protocols can be represented in different ways, only one of which is canonical. In order to allow simple string comparisons of IM addresses to work, the IM addresses must be normalised beforehand.</para><para>If the provided IM address is invalid, <link linkend="FOLKS-IM-DETAILS-ERROR-INVALID-IM-ADDRESS:CAPS"><literal>FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS</literal></link> will be thrown. Note that this isn&apos;t guaranteed to be thrown for all invalid addresses, but if it is thrown, the address is guaranteed to be invalid.</para>
 * <para><link linkend="FolksImDetailsError"><type>FolksImDetailsError</type></link> will be returned in @error <para>if the provided IM address was invalid </para></para>
 *
 * Since: 0.2.0
 */
/**
 * FolksImDetails:
 * 
 * IM addresses exposed by an object implementing <link linkend="FolksPresenceDetails"><type>FolksPresenceDetails</type></link>.
 *
 * Since: 0.1.13
 */
/**
 * FolksImDetailsIface:
 * @change_im_addresses: virtual method called by <link linkend="folks-im-details-change-im-addresses"><function>folks_im_details_change_im_addresses()</function></link>
 * @change_im_addresses_finish: asynchronous finish function for <structfield>change_im_addresses</structfield>, called by <link linkend="folks-im-details-change-im-addresses"><function>folks_im_details_change_im_addresses()</function></link>
 * @get_im_addresses: getter method for the abstract property <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link>
 * @set_im_addresses: setter method for the abstract property <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksImDetails"><type>FolksImDetails</type></link> implementations.
 */
