/**
 * SECTION:url-details
 * @short_description: Object representing a URL that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_URL_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksUrlFieldDetails"><type>FolksUrlFieldDetails</type></link>.
 */
/**
 * FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_HOME_PAGE:
 * 
 * Parameter value for URLs for the contact&apos;s home page.
 * 
 * <para>Value for a parameter with name <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link>.</para>
 *
 * Since: 0.6.3
 */
/**
 * FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_BLOG:
 * 
 * Parameter value for URLs for the contact&apos;s personal or professional blog.
 * 
 * <para>Value for a parameter with name <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link>.</para>
 *
 * Since: 0.6.3
 */
/**
 * FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_PROFILE:
 * 
 * Parameter value for URLs for the contact&apos;s social networking profile.
 * 
 * <para>Value for a parameter with name <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link>.</para>
 *
 * Since: 0.6.3
 */
/**
 * FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_FTP:
 * 
 * Parameter value for URLs for the contact&apos;s personal or professional FTP server.
 * 
 * <para>Value for a parameter with name <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link>.</para>
 *
 * Since: 0.6.3
 */
/**
 * folks_url_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, a non-empty URI </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new UrlFieldDetails.
 * 
 * Returns: <para>a new UrlFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksUrlFieldDetails:
 * 
 * Object representing a URL that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksUrlFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-URL-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_URL_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_url_details_change_urls:
 * @self: the <link linkend="FolksUrlDetails"><type>FolksUrlDetails</type></link> instance
 * @urls: (in): &nbsp;.  <para>the set of URLs </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s URLs.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link> directly, as this method gives error notification and will only return once the URLs have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the URLs failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-url-details-change-urls-finish"><function>folks_url_details_change_urls_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_url_details_change_urls_finish:
 * @self: the <link linkend="FolksUrlDetails"><type>FolksUrlDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s URLs.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link> directly, as this method gives error notification and will only return once the URLs have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the URLs failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-url-details-change-urls"><function>folks_url_details_change_urls()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksUrlDetails:urls:
 * 
 * The websites of the contact.
 * 
 * <para>A list or websites associated to the contact.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_url_details_get_urls:
 * @self: the <link linkend="FolksUrlDetails"><type>FolksUrlDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link> property.
 * 
 * The websites of the contact.
 * 
 * <para>A list or websites associated to the contact.</para>
 * 
 * Returns: the value of the <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_url_details_set_urls:
 * @self: the <link linkend="FolksUrlDetails"><type>FolksUrlDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link> property
 * 
 * Set the value of the <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link> property to @value.
 * 
 * The websites of the contact.
 * 
 * <para>A list or websites associated to the contact.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksUrlDetails:
 * 
 * Associates a list of URLs with a contact.
 *
 * Since: 0.3.5
 */
/**
 * FolksUrlDetailsIface:
 * @change_urls: virtual method called by <link linkend="folks-url-details-change-urls"><function>folks_url_details_change_urls()</function></link>
 * @change_urls_finish: asynchronous finish function for <structfield>change_urls</structfield>, called by <link linkend="folks-url-details-change-urls"><function>folks_url_details_change_urls()</function></link>
 * @get_urls: getter method for the abstract property <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link>
 * @set_urls: setter method for the abstract property <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksUrlDetails"><type>FolksUrlDetails</type></link> implementations.
 */
