/**
 * SECTION:interaction-details
 * @short_description: Interaction details of a contact.
 * 
 * <para>Interaction details are the number and date/time of calls or IM interactions with a contact, giving an idea of the recent interactions the user has had with that contact.</para>
 *
 * Since: 0.7.1
 */
/**
 * FolksInteractionDetails:im-interaction-count:
 * 
 * The IM interaction associated with a Persona
 *
 * Since: 0.7.1
 */
/**
 * folks_interaction_details_get_im_interaction_count:
 * @self: the <link linkend="FolksInteractionDetails"><type>FolksInteractionDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksInteractionDetails--im-interaction-count"><type>"im-interaction-count"</type></link> property.
 * 
 * The IM interaction associated with a Persona
 * 
 * Returns: the value of the <link linkend="FolksInteractionDetails--im-interaction-count"><type>"im-interaction-count"</type></link> property
 *
 * Since: 0.7.1
 */
/**
 * FolksInteractionDetails:last-im-interaction-datetime:
 * 
 * The latest IM interaction timestamp associated with a Persona
 *
 * Since: 0.7.1
 */
/**
 * folks_interaction_details_get_last_im_interaction_datetime:
 * @self: the <link linkend="FolksInteractionDetails"><type>FolksInteractionDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksInteractionDetails--last-im-interaction-datetime"><type>"last-im-interaction-datetime"</type></link> property.
 * 
 * The latest IM interaction timestamp associated with a Persona
 * 
 * Returns: the value of the <link linkend="FolksInteractionDetails--last-im-interaction-datetime"><type>"last-im-interaction-datetime"</type></link> property
 *
 * Since: 0.7.1
 */
/**
 * FolksInteractionDetails:call-interaction-count:
 * 
 * The call interaction associated with a Persona
 *
 * Since: 0.7.1
 */
/**
 * folks_interaction_details_get_call_interaction_count:
 * @self: the <link linkend="FolksInteractionDetails"><type>FolksInteractionDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksInteractionDetails--call-interaction-count"><type>"call-interaction-count"</type></link> property.
 * 
 * The call interaction associated with a Persona
 * 
 * Returns: the value of the <link linkend="FolksInteractionDetails--call-interaction-count"><type>"call-interaction-count"</type></link> property
 *
 * Since: 0.7.1
 */
/**
 * FolksInteractionDetails:last-call-interaction-datetime:
 * 
 * The latest call interaction timestamp associated with a Persona
 *
 * Since: 0.7.1
 */
/**
 * folks_interaction_details_get_last_call_interaction_datetime:
 * @self: the <link linkend="FolksInteractionDetails"><type>FolksInteractionDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksInteractionDetails--last-call-interaction-datetime"><type>"last-call-interaction-datetime"</type></link> property.
 * 
 * The latest call interaction timestamp associated with a Persona
 * 
 * Returns: the value of the <link linkend="FolksInteractionDetails--last-call-interaction-datetime"><type>"last-call-interaction-datetime"</type></link> property
 *
 * Since: 0.7.1
 */
/**
 * FolksInteractionDetails:
 * 
 * Interaction details of a contact.
 * 
 * <para>Interaction details are the number and date/time of calls or IM interactions with a contact, giving an idea of the recent interactions the user has had with that contact.</para>
 *
 * Since: 0.7.1
 */
/**
 * FolksInteractionDetailsIface:
 * @get_im_interaction_count: getter method for the abstract property <link linkend="FolksInteractionDetails--im-interaction-count"><type>"im-interaction-count"</type></link>
 * @get_last_im_interaction_datetime: getter method for the abstract property <link linkend="FolksInteractionDetails--last-im-interaction-datetime"><type>"last-im-interaction-datetime"</type></link>
 * @get_call_interaction_count: getter method for the abstract property <link linkend="FolksInteractionDetails--call-interaction-count"><type>"call-interaction-count"</type></link>
 * @get_last_call_interaction_datetime: getter method for the abstract property <link linkend="FolksInteractionDetails--last-call-interaction-datetime"><type>"last-call-interaction-datetime"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksInteractionDetails"><type>FolksInteractionDetails</type></link> implementations.
 */
