/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;
import org.islandoftex.texplate.exceptions.TemplateMergingException;
import org.islandoftex.texplate.model.Template;
import org.islandoftex.texplate.model.handlers.Handler;
import org.islandoftex.texplate.util.HandlerUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.helpers.NOPLoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002JB\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0007\u00a8\u0006\u000f"}, d2={"Lorg/islandoftex/texplate/util/MergingUtils;", "", "()V", "handle", "", "", "template", "Lorg/islandoftex/texplate/model/Template;", "map", "configmap", "mergeTemplate", "", "output", "Ljava/nio/file/Path;", "cmap", "texplate"})
public final class MergingUtils {
    public static final MergingUtils INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long mergeTemplate(@NotNull Template template, @NotNull Map<String, String> map, @NotNull Path output, @NotNull Map<String, ? extends Object> cmap) throws TemplateMergingException {
        Intrinsics.checkParameterIsNotNull(template, "template");
        Intrinsics.checkParameterIsNotNull(map, "map");
        Intrinsics.checkParameterIsNotNull(output, "output");
        Intrinsics.checkParameterIsNotNull(cmap, "cmap");
        Map<String, Object> context = INSTANCE.handle(template, map, cmap);
        try {
            File file = output.toFile();
            Intrinsics.checkExpressionValueIsNotNull(file, "output.toFile()");
            Object object = file;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            object2 = new FileOutputStream((File)object2);
            bl2 = false;
            object = new OutputStreamWriter((OutputStream)object2, charset);
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)object;
                boolean bl4 = false;
                String string = template.getDocument();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = string;
                boolean bl5 = false;
                StringReader reader = new StringReader(string2);
                RuntimeServices services = RuntimeSingleton.getRuntimeServices();
                services.addProperty("runtime.log.instance", new NOPLoggerFactory().getLogger(""));
                org.apache.velocity.Template reference = new org.apache.velocity.Template();
                reference.setRuntimeServices(services);
                reference.setData(services.parse(reader, reference));
                reference.initDocument();
                VelocityContext entries = new VelocityContext(context);
                reference.merge(entries, writer);
                object2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception2 instanceof IOException || exception2 instanceof MethodInvocationException || exception2 instanceof ParseErrorException || exception2 instanceof ParseException || exception2 instanceof ResourceNotFoundException || exception2 instanceof TemplateInitException) {
                throw (Throwable)new TemplateMergingException("An error occurred while trying to merge the template reference with the provided data. Make sure the template is correct and try again. The raised exception might give us some hints on what exactly happened. Typically, make sure the template strictly follows the Velocity 2.0 language syntax.", exception);
            }
            throw (Throwable)new TemplateMergingException("Fatal error occured. This error should never happen. Please make a detailed report to the developers.");
        }
        return output.toFile().length();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> handle(Template template, Map<String, String> map, Map<String, ? extends Object> configmap) {
        Map<String, Object> map2;
        if (template.getHandlers().isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            Map<String, ? extends Object> $this$mapValues$iv = configmap;
            boolean $i$f$mapValues = false;
            Map<String, ? extends Object> map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl5 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map5 = map4;
                boolean bl2 = false;
                String string = it.getValue().toString();
                map5.put(k2, string);
            }
            map2 = MapsKt.plus(destination$iv$iv, map);
        } else {
            boolean $i$f$mapValues = false;
            Map result = new LinkedHashMap();
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<String, String> map6 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator2 = map6.entrySet().iterator();
            while (iterator2.hasNext()) {
                void key;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator2.next();
                boolean bl3 = false;
                Map<String, Handler> map7 = $dstr$key$value;
                boolean bl4 = false;
                String bl5 = map7.getKey();
                map7 = $dstr$key$value;
                bl4 = false;
                String value = map7.getValue();
                if (template.getHandlers().containsKey(key)) {
                    map7 = HandlerUtils.getHandlers();
                    String string = template.getHandlers().get(key);
                    boolean bl6 = false;
                    Map<String, Handler> map8 = map7;
                    if (map8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                    }
                    if (map8.containsKey(string)) {
                        Handler handler;
                        map7 = HandlerUtils.getHandlers();
                        string = template.getHandlers().get(key);
                        void var18_35 = key;
                        Map map9 = result;
                        bl6 = false;
                        Handler handler2 = handler = map7.get(string);
                        if (handler2 == null) {
                            Intrinsics.throwNpe();
                        }
                        map9.put(var18_35, handler2.apply(value));
                        continue;
                    }
                }
                result.put(key, value);
            }
            map2 = MapsKt.plus(configmap, result);
        }
        return map2;
    }

    private MergingUtils() {
    }

    static {
        MergingUtils mergingUtils;
        INSTANCE = mergingUtils = new MergingUtils();
    }
}

