/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.apache.catalina.AccessLog;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.ExceptionUtils;

public final class JDBCAccessLogValve
extends ValveBase
implements AccessLog {
    boolean useLongContentLength = false;
    String connectionName = null;
    String connectionPassword = null;
    Driver driver = null;
    private String driverName = null;
    private String connectionURL = null;
    private String tableName = "access";
    private String remoteHostField = "remoteHost";
    private String userField = "userName";
    private String timestampField = "timestamp";
    private String virtualHostField = "virtualHost";
    private String methodField = "method";
    private String queryField = "query";
    private String statusField = "status";
    private String bytesField = "bytes";
    private String refererField = "referer";
    private String userAgentField = "userAgent";
    private String pattern = "common";
    private boolean resolveHosts = false;
    private Connection conn = null;
    private PreparedStatement ps = null;
    private long currentTimeMillis = new Date().getTime();
    boolean requestAttributesEnabled = true;

    public JDBCAccessLogValve() {
        super(true);
    }

    @Override
    public void setRequestAttributesEnabled(boolean bl) {
        this.requestAttributesEnabled = bl;
    }

    @Override
    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setRemoteHostField(String string) {
        this.remoteHostField = string;
    }

    public void setUserField(String string) {
        this.userField = string;
    }

    public void setTimestampField(String string) {
        this.timestampField = string;
    }

    public void setVirtualHostField(String string) {
        this.virtualHostField = string;
    }

    public void setMethodField(String string) {
        this.methodField = string;
    }

    public void setQueryField(String string) {
        this.queryField = string;
    }

    public void setStatusField(String string) {
        this.statusField = string;
    }

    public void setBytesField(String string) {
        this.bytesField = string;
    }

    public void setRefererField(String string) {
        this.refererField = string;
    }

    public void setUserAgentField(String string) {
        this.userAgentField = string;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setResolveHosts(String string) {
        this.resolveHosts = Boolean.parseBoolean(string);
    }

    public boolean getUseLongContentLength() {
        return this.useLongContentLength;
    }

    public void setUseLongContentLength(boolean bl) {
        this.useLongContentLength = bl;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Request request, Response response, long l) {
        Object object;
        if (!this.getState().isAvailable()) {
            return;
        }
        String string = this.resolveHosts ? (this.requestAttributesEnabled ? ((object = request.getAttribute("org.apache.catalina.AccessLog.RemoteHost")) == null ? request.getRemoteHost() : (String)object) : request.getRemoteHost()) : (this.requestAttributesEnabled ? ((object = request.getAttribute("org.apache.catalina.AccessLog.RemoteAddr")) == null ? request.getRemoteAddr() : (String)object) : request.getRemoteAddr());
        object = request.getRemoteUser();
        String string2 = request.getRequestURI();
        long l2 = response.getBytesWritten(true);
        if (l2 < 0L) {
            l2 = 0L;
        }
        int n = response.getStatus();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = this.pattern;
        if (string7.equals("combined")) {
            string3 = request.getServerName();
            string4 = request.getMethod();
            string5 = request.getHeader("referer");
            string6 = request.getHeader("user-agent");
        }
        JDBCAccessLogValve jDBCAccessLogValve = this;
        synchronized (jDBCAccessLogValve) {
            for (int i = 2; i > 0; --i) {
                try {
                    this.open();
                    this.ps.setString(1, string);
                    this.ps.setString(2, (String)object);
                    this.ps.setTimestamp(3, new Timestamp(this.getCurrentTimeMillis()));
                    this.ps.setString(4, string2);
                    this.ps.setInt(5, n);
                    if (this.useLongContentLength) {
                        this.ps.setLong(6, l2);
                    } else {
                        if (l2 > Integer.MAX_VALUE) {
                            l2 = -1L;
                        }
                        this.ps.setInt(6, (int)l2);
                    }
                    if (string7.equals("combined")) {
                        this.ps.setString(7, string3);
                        this.ps.setString(8, string4);
                        this.ps.setString(9, string5);
                        this.ps.setString(10, string6);
                    }
                    this.ps.executeUpdate();
                    return;
                }
                catch (SQLException sQLException) {
                    this.container.getLogger().error((Object)sm.getString("jdbcAccessLogValve.exception"), (Throwable)sQLException);
                    if (this.conn == null) continue;
                    this.close();
                    continue;
                }
            }
        }
    }

    protected void open() throws SQLException {
        Serializable serializable;
        if (this.conn != null) {
            return;
        }
        if (this.driver == null) {
            try {
                serializable = Class.forName(this.driverName);
                this.driver = (Driver)((Class)serializable).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                throw new SQLException(throwable.getMessage(), throwable);
            }
        }
        serializable = new Properties();
        if (this.connectionName != null) {
            ((Properties)serializable).put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            ((Properties)serializable).put("password", this.connectionPassword);
        }
        this.conn = this.driver.connect(this.connectionURL, (Properties)serializable);
        this.conn.setAutoCommit(true);
        String string = this.pattern;
        if (string.equals("common")) {
            this.ps = this.conn.prepareStatement("INSERT INTO " + this.tableName + " (" + this.remoteHostField + ", " + this.userField + ", " + this.timestampField + ", " + this.queryField + ", " + this.statusField + ", " + this.bytesField + ") VALUES(?, ?, ?, ?, ?, ?)");
        } else if (string.equals("combined")) {
            this.ps = this.conn.prepareStatement("INSERT INTO " + this.tableName + " (" + this.remoteHostField + ", " + this.userField + ", " + this.timestampField + ", " + this.queryField + ", " + this.statusField + ", " + this.bytesField + ", " + this.virtualHostField + ", " + this.methodField + ", " + this.refererField + ", " + this.userAgentField + ") VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
    }

    protected void close() {
        if (this.conn == null) {
            return;
        }
        try {
            this.ps.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.ps = null;
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            this.container.getLogger().error((Object)sm.getString("jdbcAccessLogValve.close"), (Throwable)sQLException);
        }
        finally {
            this.conn = null;
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        try {
            this.open();
        }
        catch (SQLException sQLException) {
            throw new LifecycleException(sQLException);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.close();
    }

    public long getCurrentTimeMillis() {
        long l = System.currentTimeMillis();
        if (l - this.currentTimeMillis > 1000L) {
            this.currentTimeMillis = new Date(l).getTime();
        }
        return this.currentTimeMillis;
    }
}

