/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JarScannerFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldLocation;
import org.apache.jasper.compiler.WebXml;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;

public class TldLocationsCache {
    private final Log log = LogFactory.getLog(TldLocationsCache.class);
    private static final String KEY = TldLocationsCache.class.getName();
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_INF = "/WEB-INF/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static final String JAR_EXT = ".jar";
    private static final String TLD_EXT = ".tld";
    private static Set<String> noTldJars = null;
    private static volatile boolean showTldScanWarning = true;
    private Hashtable<String, TldLocation> mappings;
    private volatile boolean initialized;
    private ServletContext ctxt;

    public static synchronized void setNoTldJars(String string) {
        if (string == null) {
            noTldJars = null;
        } else {
            if (noTldJars == null) {
                noTldJars = new HashSet<String>();
            } else {
                noTldJars.clear();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                noTldJars.add(string2);
            }
        }
    }

    public TldLocationsCache(ServletContext servletContext) {
        this.ctxt = servletContext;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public static synchronized TldLocationsCache getInstance(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException("ServletContext was null");
        }
        TldLocationsCache tldLocationsCache = (TldLocationsCache)servletContext.getAttribute(KEY);
        if (tldLocationsCache == null) {
            tldLocationsCache = new TldLocationsCache(servletContext);
            servletContext.setAttribute(KEY, (Object)tldLocationsCache);
        }
        return tldLocationsCache;
    }

    public TldLocation getLocation(String string) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return this.mappings.get(string);
    }

    public static int uriType(String string) {
        if (string.indexOf(58) != -1) {
            return 0;
        }
        if (string.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private synchronized void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.tldScanWebXml();
            this.tldScanResourcePaths(WEB_INF);
            JarScanner jarScanner = JarScannerFactory.getJarScanner(this.ctxt);
            jarScanner.scan(this.ctxt, Thread.currentThread().getContextClassLoader(), (JarScannerCallback)new TldJarScannerCallback(), noTldJars);
            this.initialized = true;
        }
        catch (Exception exception) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", exception.getMessage()), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanWebXml() throws Exception {
        WebXml webXml = null;
        try {
            webXml = new WebXml(this.ctxt);
            if (webXml.getInputSource() == null) {
                return;
            }
            boolean bl = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE"));
            String string = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
            boolean bl2 = string == null ? true : Boolean.parseBoolean(string);
            ParserUtils parserUtils = new ParserUtils(bl, bl2);
            TreeNode treeNode = null;
            treeNode = parserUtils.parseXMLDocument(webXml.getSystemId(), webXml.getInputSource());
            TreeNode treeNode2 = treeNode.findChild("jsp-config");
            if (treeNode2 != null) {
                treeNode = treeNode2;
            }
            Iterator<TreeNode> iterator = treeNode.findChildren("taglib");
            while (iterator.hasNext()) {
                TreeNode treeNode3 = iterator.next();
                String string2 = null;
                String string3 = null;
                TreeNode treeNode4 = treeNode3.findChild("taglib-uri");
                if (treeNode4 != null) {
                    string2 = treeNode4.getBody();
                }
                if ((treeNode4 = treeNode3.findChild("taglib-location")) != null) {
                    string3 = treeNode4.getBody();
                }
                if (string3 == null) continue;
                if (TldLocationsCache.uriType(string3) == 2) {
                    string3 = WEB_INF + string3;
                }
                TldLocation tldLocation = string3.endsWith(JAR_EXT) ? new TldLocation("META-INF/taglib.tld", this.ctxt.getResource(string3).toString()) : new TldLocation(string3);
                this.mappings.put(string2, tldLocation);
            }
        }
        finally {
            if (webXml != null) {
                webXml.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanResourcePaths(String string) throws Exception {
        Set set = this.ctxt.getResourcePaths(string);
        if (set != null) {
            for (String string2 : set) {
                if (!string2.endsWith(TLD_EXT) && (string2.startsWith(WEB_INF_LIB) || string2.startsWith("/WEB-INF/classes/"))) continue;
                if (string2.endsWith(TLD_EXT)) {
                    if (string2.startsWith("/WEB-INF/tags/") && !string2.endsWith("implicit.tld")) continue;
                    InputStream inputStream = this.ctxt.getResourceAsStream(string2);
                    try {
                        this.tldScanStream(string2, null, inputStream);
                        continue;
                    }
                    finally {
                        if (inputStream == null) continue;
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ExceptionUtils.handleThrowable(throwable);
                        }
                        continue;
                    }
                }
                this.tldScanResourcePaths(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanDir(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.tldScanDir(fileArray[i]);
                    continue;
                }
                if (!fileArray[i].getAbsolutePath().endsWith(TLD_EXT)) continue;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    this.tldScanStream(fileArray[i].toURI().toString(), null, fileInputStream);
                    continue;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable throwable) {
                            ExceptionUtils.handleThrowable(throwable);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanJar(JarURLConnection jarURLConnection) throws IOException {
        Jar jar = null;
        boolean bl = false;
        URL uRL = jarURLConnection.getJarFileURL();
        String string = uRL.toString();
        try {
            jar = JarFactory.newInstance((URL)jarURLConnection.getURL());
            jar.nextEntry();
            String string2 = jar.getEntryName();
            while (string2 != null) {
                if (string2.startsWith("META-INF/") && string2.endsWith(TLD_EXT)) {
                    InputStream inputStream = null;
                    try {
                        inputStream = jar.getEntryInputStream();
                        bl = true;
                        this.tldScanStream(string, string2, inputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                jar.nextEntry();
                string2 = jar.getEntryName();
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        if (!bl) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)Localizer.getMessage("jsp.tldCache.noTldInJar", string));
            } else if (showTldScanWarning) {
                showTldScanWarning = false;
                this.log.info((Object)Localizer.getMessage("jsp.tldCache.noTldSummary"));
            }
        }
    }

    private void tldScanStream(String string, String string2, InputStream inputStream) throws IOException {
        try {
            Object object;
            String string3 = null;
            boolean bl = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
            String string4 = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
            boolean bl2 = string4 == null ? true : Boolean.parseBoolean(string4);
            ParserUtils parserUtils = new ParserUtils(bl, bl2);
            TreeNode treeNode = parserUtils.parseXMLDocument(string, inputStream);
            TreeNode treeNode2 = treeNode.findChild("uri");
            if (treeNode2 != null && (object = treeNode2.getBody()) != null) {
                string3 = object;
            }
            if (string3 != null && this.mappings.get(string3) == null) {
                object = string2 == null ? new TldLocation(string) : new TldLocation(string2, string);
                this.mappings.put(string3, (TldLocation)object);
            }
        }
        catch (JasperException jasperException) {
            throw new IOException((Throwable)((Object)jasperException));
        }
    }

    static {
        StringBuilder stringBuilder = new StringBuilder(System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip", ""));
        String string = System.getProperty("org.apache.catalina.startup.TldConfig.jarsToSkip", "");
        if (string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            TldLocationsCache.setNoTldJars(stringBuilder.toString());
        }
    }

    private class TldJarScannerCallback
    implements JarScannerCallback {
        private TldJarScannerCallback() {
        }

        public void scan(JarURLConnection jarURLConnection) throws IOException {
            TldLocationsCache.this.tldScanJar(jarURLConnection);
        }

        public void scan(File file) throws IOException {
            File file2 = new File(file, "META-INF");
            if (file2.isDirectory()) {
                TldLocationsCache.this.tldScanDir(file2);
            }
        }
    }
}

