/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

class NoBodyOutputStream
extends ServletOutputStream {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    private final HttpServletResponse response;
    private boolean flushed = false;
    private int contentLength = 0;

    NoBodyOutputStream(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
    }

    int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void write(int n) throws IOException {
        ++this.contentLength;
        this.checkCommit();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException(lStrings.getString("err.io.nullArray"));
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = lStrings.getString("err.io.indexOutOfBounds");
            Object[] objectArray = new Object[]{n, n2, byArray.length};
            string = MessageFormat.format(string, objectArray);
            throw new IndexOutOfBoundsException(string);
        }
        this.contentLength += n2;
        this.checkCommit();
    }

    private void checkCommit() throws IOException {
        if (!this.flushed && this.contentLength > this.response.getBufferSize()) {
            this.response.flushBuffer();
            this.flushed = true;
        }
    }
}

