/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.lang.reflect.Constructor;
import java.nio.file.FileSystems;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.LogManager;
import org.apache.juli.logging.DirectJDKLog;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;

public class LogFactory {
    private static final LogFactory singleton = new LogFactory();
    private final Constructor<? extends Log> discoveredLogConstructor;

    private LogFactory() {
        FileSystems.getDefault();
        ServiceLoader<Log> serviceLoader = ServiceLoader.load(Log.class);
        Constructor<?> constructor = null;
        Iterator<Log> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            Log log = iterator.next();
            Class<?> clazz = log.getClass();
            try {
                constructor = clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                throw new Error(exception);
            }
        }
        this.discoveredLogConstructor = constructor;
    }

    public Log getInstance(String string) throws LogConfigurationException {
        if (this.discoveredLogConstructor == null) {
            return DirectJDKLog.getInstance(string);
        }
        try {
            return this.discoveredLogConstructor.newInstance(string);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            throw new LogConfigurationException(exception);
        }
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(string);
    }

    public static void release(ClassLoader classLoader) {
        if (!LogManager.getLogManager().getClass().getName().equals("java.util.logging.LogManager")) {
            LogManager.getLogManager().reset();
        }
    }
}

