/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.jsse.PEMFile;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.KeyStoreUtil;

public abstract class SSLUtilBase
implements SSLUtil {
    private static final Log log = LogFactory.getLog(SSLUtilBase.class);
    private static final StringManager sm = StringManager.getManager(SSLUtilBase.class);
    protected final SSLHostConfig sslHostConfig;
    protected final SSLHostConfigCertificate certificate;
    private final String[] enabledProtocols;
    private final String[] enabledCiphers;

    protected SSLUtilBase(SSLHostConfigCertificate sSLHostConfigCertificate) {
        this(sSLHostConfigCertificate, true);
    }

    protected SSLUtilBase(SSLHostConfigCertificate sSLHostConfigCertificate, boolean bl) {
        List<String> list;
        this.certificate = sSLHostConfigCertificate;
        this.sslHostConfig = sSLHostConfigCertificate.getSSLHostConfig();
        Set<String> set = this.sslHostConfig.getProtocols();
        Set<String> set2 = this.getImplementedProtocols();
        if (!set2.contains("TLSv1.3") && !this.sslHostConfig.isExplicitlyRequestedProtocol("TLSv1.3")) {
            set.remove("TLSv1.3");
        }
        if (!set2.contains("SSLv2Hello") && !this.sslHostConfig.isExplicitlyRequestedProtocol("SSLv2Hello")) {
            set.remove("SSLv2Hello");
        }
        if ((list = SSLUtilBase.getEnabled("protocols", this.getLog(), bl, set, set2)).contains("SSLv3")) {
            log.warn((Object)sm.getString("sslUtilBase.ssl3"));
        }
        this.enabledProtocols = list.toArray(new String[0]);
        if (list.contains("TLSv1.3") && this.sslHostConfig.getCertificateVerification() == SSLHostConfig.CertificateVerification.OPTIONAL && !this.isTls13RenegAuthAvailable() && bl) {
            log.warn((Object)sm.getString("sslUtilBase.tls13.auth"));
        }
        List<String> list2 = this.sslHostConfig.getJsseCipherNames();
        Set<String> set3 = this.getImplementedCiphers();
        List<String> list3 = SSLUtilBase.getEnabled("ciphers", this.getLog(), false, list2, set3);
        this.enabledCiphers = list3.toArray(new String[0]);
    }

    static <T> List<T> getEnabled(String string, Log log, boolean bl, Collection<T> collection, Collection<T> collection2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (collection2.size() == 0) {
            arrayList.addAll(collection);
        } else {
            arrayList.addAll(collection);
            arrayList.retainAll(collection2);
            if (arrayList.isEmpty()) {
                throw new IllegalArgumentException(sm.getString("sslUtilBase.noneSupported", new Object[]{string, collection}));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("sslUtilBase.active", new Object[]{string, arrayList}));
            }
            if ((log.isDebugEnabled() || bl) && arrayList.size() != collection.size()) {
                ArrayList<T> arrayList2 = new ArrayList<T>(collection);
                arrayList2.removeAll(arrayList);
                String string2 = sm.getString("sslUtilBase.skipped", new Object[]{string, arrayList2});
                if (bl) {
                    log.warn((Object)string2);
                } else {
                    log.debug((Object)string2);
                }
            }
        }
        return arrayList;
    }

    static KeyStore getStore(String string, String string2, String string3, String string4) throws IOException {
        KeyStore keyStore = null;
        InputStream inputStream = null;
        try {
            keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
            if ("DKS".equalsIgnoreCase(string)) {
                URI uRI = ConfigFileLoader.getURI((String)string3);
                keyStore.load(JreCompat.getInstance().getDomainLoadStoreParameter(uRI));
            } else {
                if (!"PKCS11".equalsIgnoreCase(string) && !string3.isEmpty() || "NONE".equalsIgnoreCase(string3)) {
                    inputStream = ConfigFileLoader.getInputStream((String)string3);
                }
                char[] cArray = null;
                if (string4 != null && (!"".equals(string4) || "JKS".equalsIgnoreCase(string) || "PKCS12".equalsIgnoreCase(string))) {
                    cArray = string4.toCharArray();
                }
                KeyStoreUtil.load((KeyStore)keyStore, (InputStream)inputStream, cArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string5 = sm.getString("sslUtilBase.keystore_load_failed", new Object[]{string, string3, exception.getMessage()});
            log.error((Object)string5, (Throwable)exception);
            throw new IOException(string5);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    @Override
    public final SSLContext createSSLContext(List<String> list) throws Exception {
        SSLContext sSLContext = this.createSSLContextInternal(list);
        sSLContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
        SSLSessionContext sSLSessionContext = sSLContext.getServerSessionContext();
        if (sSLSessionContext != null) {
            this.configureSessionContext(sSLSessionContext);
        }
        return sSLContext;
    }

    @Override
    public void configureSessionContext(SSLSessionContext sSLSessionContext) {
        if (this.sslHostConfig.getSessionCacheSize() >= 0) {
            sSLSessionContext.setSessionCacheSize(this.sslHostConfig.getSessionCacheSize());
        }
        if (this.sslHostConfig.getSessionTimeout() >= 0) {
            sSLSessionContext.setSessionTimeout(this.sslHostConfig.getSessionTimeout());
        }
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        Object object;
        Object object2;
        KeyStore keyStore;
        String string = this.certificate.getCertificateKeyAlias();
        String string2 = this.sslHostConfig.getKeyManagerAlgorithm();
        String string3 = this.certificate.getCertificateKeyPassword();
        if (string3 == null) {
            string3 = this.certificate.getCertificateKeystorePassword();
        }
        KeyStore keyStore2 = keyStore = this.certificate.getCertificateKeystore();
        char[] cArray = string3.toCharArray();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        if (keyManagerFactory.getProvider().getInfo().indexOf("FIPS") != -1) {
            if (string != null) {
                log.warn((Object)sm.getString("sslUtilBase.aliasIgnored", new Object[]{string}));
            }
            keyManagerFactory.init(keyStore2, cArray);
            return keyManagerFactory.getKeyManagers();
        }
        if (keyStore == null) {
            if (this.certificate.getCertificateFile() == null) {
                throw new IOException(sm.getString("sslUtilBase.noCertFile"));
            }
            object2 = new PEMFile(this.certificate.getCertificateKeyFile() != null ? this.certificate.getCertificateKeyFile() : this.certificate.getCertificateFile(), string3);
            object = new PEMFile(this.certificate.getCertificateFile());
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.addAll(((PEMFile)object).getCertificates());
            if (this.certificate.getCertificateChainFile() != null) {
                PEMFile pEMFile = new PEMFile(this.certificate.getCertificateChainFile());
                arrayList.addAll(pEMFile.getCertificates());
            }
            if (string == null) {
                string = "tomcat";
            }
            keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(null, null);
            keyStore2.setKeyEntry(string, object2.getPrivateKey(), string3.toCharArray(), arrayList.toArray(new Certificate[0]));
        } else {
            if (string != null && !keyStore.isKeyEntry(string)) {
                throw new IOException(sm.getString("sslUtilBase.alias_no_key_entry", new Object[]{string}));
            }
            if (string == null) {
                object2 = keyStore.aliases();
                if (!object2.hasMoreElements()) {
                    throw new IOException(sm.getString("sslUtilBase.noKeys"));
                }
                while (object2.hasMoreElements() && string == null) {
                    string = (String)object2.nextElement();
                    if (keyStore.isKeyEntry(string)) continue;
                    string = null;
                }
                if (string == null) {
                    throw new IOException(sm.getString("sslUtilBase.alias_no_key_entry", new Object[]{null}));
                }
            }
            if ((object2 = keyStore.getKey(string, cArray)) != null && !"DKS".equalsIgnoreCase(this.certificate.getCertificateKeystoreType()) && "PKCS#8".equalsIgnoreCase(object2.getFormat())) {
                object = this.certificate.getCertificateKeystoreProvider();
                keyStore2 = object == null ? KeyStore.getInstance(this.certificate.getCertificateKeystoreType()) : KeyStore.getInstance(this.certificate.getCertificateKeystoreType(), (String)object);
                keyStore2.load(null, null);
                keyStore2.setKeyEntry(string, (Key)object2, cArray, keyStore.getCertificateChain(string));
            }
        }
        keyManagerFactory.init(keyStore2, cArray);
        object2 = keyManagerFactory.getKeyManagers();
        if (object2 != null && keyStore2 == keyStore) {
            object = string;
            if ("JKS".equals(this.certificate.getCertificateKeystoreType())) {
                object = ((String)object).toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < ((KeyManager[])object2).length; ++i) {
                object2[i] = new JSSEKeyManager((X509KeyManager)object2[i], (String)object);
            }
        }
        return object2;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        String string = this.sslHostConfig.getTrustManagerClassName();
        if (string != null && string.length() > 0) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            if (!TrustManager.class.isAssignableFrom(clazz)) {
                throw new InstantiationException(sm.getString("sslUtilBase.invalidTrustManagerClassName", new Object[]{string}));
            }
            Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            TrustManager trustManager = (TrustManager)obj;
            return new TrustManager[]{trustManager};
        }
        TrustManager[] trustManagerArray = null;
        KeyStore keyStore = this.sslHostConfig.getTruststore();
        if (keyStore != null) {
            this.checkTrustStoreEntries(keyStore);
            String string2 = this.sslHostConfig.getTruststoreAlgorithm();
            String string3 = this.sslHostConfig.getCertificateRevocationListFile();
            boolean bl = this.sslHostConfig.getRevocationEnabled();
            if ("PKIX".equalsIgnoreCase(string2)) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
                CertPathParameters certPathParameters = this.getParameters(string3, keyStore, bl);
                CertPathTrustManagerParameters certPathTrustManagerParameters = new CertPathTrustManagerParameters(certPathParameters);
                trustManagerFactory.init(certPathTrustManagerParameters);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
                trustManagerFactory.init(keyStore);
                trustManagerArray = trustManagerFactory.getTrustManagers();
                if (string3 != null && string3.length() > 0) {
                    throw new CRLException(sm.getString("sslUtilBase.noCrlSupport", new Object[]{string2}));
                }
                if (this.sslHostConfig.isCertificateVerificationDepthConfigured()) {
                    log.warn((Object)sm.getString("sslUtilBase.noVerificationDepth", new Object[]{string2}));
                }
            }
        }
        return trustManagerArray;
    }

    private void checkTrustStoreEntries(KeyStore keyStore) throws Exception {
        Enumeration<String> enumeration = keyStore.aliases();
        if (enumeration != null) {
            Date date = new Date();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string)) continue;
                Certificate certificate = keyStore.getCertificate(string);
                if (certificate instanceof X509Certificate) {
                    try {
                        ((X509Certificate)certificate).checkValidity(date);
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
                        String string2 = sm.getString("sslUtilBase.trustedCertNotValid", new Object[]{string, ((X509Certificate)certificate).getSubjectDN(), certificateException.getMessage()});
                        if (log.isDebugEnabled()) {
                            log.debug((Object)string2, (Throwable)certificateException);
                            continue;
                        }
                        log.warn((Object)string2);
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("sslUtilBase.trustedCertNotChecked", new Object[]{string}));
            }
        }
    }

    protected CertPathParameters getParameters(String string, KeyStore keyStore, boolean bl) throws Exception {
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
        if (string != null && string.length() > 0) {
            Collection<? extends CRL> collection = this.getCRLs(string);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(collection);
            CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setRevocationEnabled(true);
        } else {
            pKIXBuilderParameters.setRevocationEnabled(bl);
        }
        pKIXBuilderParameters.setMaxPathLength(this.sslHostConfig.getCertificateVerificationDepth());
        return pKIXBuilderParameters;
    }

    protected Collection<? extends CRL> getCRLs(String string) throws IOException, CRLException, CertificateException {
        Collection<? extends CRL> collection = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try (InputStream inputStream = ConfigFileLoader.getInputStream((String)string);){
                collection = certificateFactory.generateCRLs(inputStream);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (CRLException cRLException) {
            throw cRLException;
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        return collection;
    }

    protected abstract Set<String> getImplementedProtocols();

    protected abstract Set<String> getImplementedCiphers();

    protected abstract Log getLog();

    protected abstract boolean isTls13RenegAuthAvailable();

    protected abstract SSLContext createSSLContextInternal(List<String> var1) throws Exception;
}

