/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ka extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CA = "\u10d9\u10d0\u10dc\u10d0\u10d3\u10d0";
        final String metaValue_FJ = "\u10e4\u10d8\u10ef\u10d8";
        final String metaValue_NR = "\u10dc\u10d0\u10e3\u10e0\u10e3";
        final String metaValue_NU = "\u10dc\u10d8\u10e3\u10d4";
        final String metaValue_TV = "\u10e2\u10e3\u10d5\u10d0\u10da\u10e3";
        final String metaValue_WS = "\u10e1\u10d0\u10db\u10dd\u10d0";
        final String metaValue_ae = "\u10d0\u10d5\u10d4\u10e1\u10e2\u10e3\u10e0\u10d8";
        final String metaValue_ar = "\u10d0\u10e0\u10d0\u10d1\u10e3\u10da\u10d8";
        final String metaValue_bn = "\u10d1\u10d4\u10dc\u10d2\u10d0\u10da\u10e3\u10e0\u10d8";
        final String metaValue_bo = "\u10e2\u10d8\u10d1\u10d4\u10e2\u10e3\u10e0\u10d8";
        final String metaValue_el = "\u10d1\u10d4\u10e0\u10eb\u10dc\u10e3\u10da\u10d8";
        final String metaValue_he = "\u10d4\u10d1\u10e0\u10d0\u10e3\u10da\u10d8";
        final String metaValue_hy = "\u10e1\u10dd\u10db\u10ee\u10e3\u10e0\u10d8";
        final String metaValue_ja = "\u10d8\u10d0\u10de\u10dd\u10dc\u10e3\u10e0\u10d8";
        final String metaValue_jv = "\u10d8\u10d0\u10d5\u10e3\u10e0\u10d8";
        final String metaValue_ka = "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8";
        final String metaValue_km = "\u10e5\u10db\u10d4\u10e0\u10e3\u10da\u10d8";
        final String metaValue_ko = "\u10d9\u10dd\u10e0\u10d4\u10e3\u10da\u10d8";
        final String metaValue_la = "\u10da\u10d0\u10d7\u10d8\u10dc\u10e3\u10e0\u10d8";
        final String metaValue_lo = "\u10da\u10d0\u10dd\u10e1\u10e3\u10e0\u10d8";
        final String metaValue_ml = "\u10db\u10d0\u10da\u10d0\u10d8\u10d0\u10da\u10d0\u10db\u10e3\u10e0\u10d8";
        final String metaValue_mn = "\u10db\u10dd\u10dc\u10e6\u10dd\u10da\u10e3\u10e0\u10d8";
        final String metaValue_or = "\u10dd\u10e0\u10d8\u10d0";
        final String metaValue_si = "\u10e1\u10d8\u10dc\u10f0\u10d0\u10da\u10e3\u10e0\u10d8";
        final String metaValue_ta = "\u10e2\u10d0\u10db\u10d8\u10da\u10e3\u10e0\u10d8";
        final String metaValue_te = "\u10e2\u10d4\u10da\u10e3\u10d2\u10e3";
        final String metaValue_th = "\u10e2\u10d0\u10d8";
        final String metaValue_ccp = "\u10e9\u10d0\u10d9\u10db\u10d0";
        final String metaValue_chr = "\u10e9\u10d4\u10e0\u10dd\u10d9\u10d8";
        final String metaValue_cop = "\u10d9\u10dd\u10de\u10e2\u10e3\u10e0\u10d8";
        final String metaValue_got = "\u10d2\u10dd\u10d7\u10e3\u10e0\u10d8";
        final String metaValue_kpe = "\u10d9\u10de\u10d4\u10da\u10d4";
        final String metaValue_men = "\u10db\u10d4\u10dc\u10d3\u10d4";
        final String metaValue_nqo = "\u10dc\u10d9\u10dd";
        final String metaValue_peo = "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e1\u10de\u10d0\u10e0\u10e1\u10e3\u10da\u10d8";
        final String metaValue_phn = "\u10e4\u10d8\u10dc\u10d8\u10d9\u10d8\u10e3\u10e0\u10d8";
        final String metaValue_syr = "\u10e1\u10d8\u10e0\u10d8\u10e3\u10da\u10d8";
        final String metaValue_uga = "\u10e3\u10d2\u10d0\u10e0\u10d8\u10d7\u10e3\u10da\u10d8";
        final String metaValue_vai = "\u10d5\u10d0\u10d8";
        final String metaValue_zbl = "\u10d1\u10da\u10d8\u10e1\u10e1\u10d8\u10db\u10d1\u10dd\u10da\u10dd\u10d4\u10d1\u10d8";
        final String metaValue_Hant = "\u10e2\u10e0\u10d0\u10d3\u10d8\u10ea\u10d8\u10e3\u10da\u10d8";
        final String metaValue_zh_Hans = "\u10d2\u10d0\u10db\u10d0\u10e0\u10e2\u10d8\u10d5\u10d4\u10d1\u10e3\u10da\u10d8 \u10e9\u10d8\u10dc\u10e3\u10e0\u10d8";
        final String metaValue_zh_Hant = "\u10e2\u10e0\u10d0\u10d3\u10d8\u10ea\u10d8\u10e3\u10da\u10d8 \u10e9\u10d8\u10dc\u10e3\u10e0\u10d8";
        final Object[][] data = new Object[][] {
            { "ksh", "\u10d9\u10d8\u10dd\u10da\u10e8\u10d8" },
            { "Ogam", "\u10dd\u10e6\u10d0\u10db\u10d8" },
            { "mwl", "\u10db\u10d8\u10e0\u10d0\u10dc\u10d3\u10e3\u10da\u10d8" },
            { "Zsym", "\u10e1\u10d8\u10db\u10d1\u10dd\u10da\u10dd\u10d4\u10d1\u10d8" },
            { "mwr", "\u10db\u10d0\u10e0\u10d5\u10d0\u10e0\u10d8" },
            { "Tagb", "\u10e2\u10d0\u10d2\u10d1\u10d0\u10dc\u10d5\u10d0" },
            { "Zsye", "Emoji" },
            { "ccp", metaValue_ccp },
            { "egy", "\u10eb\u10d5\u10d4\u10da\u10d4\u10d2\u10d5\u10d8\u10de\u10e2\u10e3\u10e0\u10d8" },
            { "raj", "\u10e0\u10d0\u10ef\u10d0\u10e1\u10d7\u10d0\u10dc\u10d8" },
            { "Phag", "\u10e4\u10d0\u10d2\u10e1\u10de\u10d0" },
            { "tem", "\u10e2\u10d8\u10dc\u10db\u10d4" },
            { "teo", "\u10e2\u10d4\u10e1\u10dd" },
            { "rap", "\u10e0\u10d0\u10de\u10d0\u10dc\u10e3\u10d8" },
            { "AC", "\u10d0\u10db\u10d0\u10e6\u10da\u10d4\u10d1\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8" },
            { "rar", "\u10e0\u10d0\u10e0\u10dd\u10e2\u10dd\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "tet", "\u10e2\u10d4\u10e2\u10e3\u10db\u10d8" },
            { "AD", "\u10d0\u10dc\u10d3\u10dd\u10e0\u10d0" },
            { "AE", "\u10d0\u10e0\u10d0\u10d1\u10d7\u10d0 \u10d2\u10d0\u10d4\u10e0\u10d7\u10d8\u10d0\u10dc\u10d4\u10d1\u10e3\u10da\u10d8 \u10e1\u10d0\u10d0\u10db\u10d8\u10e0\u10dd\u10d4\u10d1\u10d8" },
            { "nl_BE", "\u10e4\u10da\u10d0\u10db\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "AF", "\u10d0\u10d5\u10e6\u10d0\u10dc\u10d4\u10d7\u10d8" },
            { "AG", "\u10d0\u10dc\u10e2\u10d8\u10d2\u10e3\u10d0 \u10d3\u10d0 \u10d1\u10d0\u10e0\u10d1\u10e3\u10d3\u10d0" },
            { "type.ca.ethiopic", "\u10d4\u10d7\u10d8\u10dd\u10de\u10d8\u10e3\u10e0\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "AI", "\u10d0\u10dc\u10d2\u10d8\u10da\u10d8\u10d0" },
            { "AL", "\u10d0\u10da\u10d1\u10d0\u10dc\u10d4\u10d7\u10d8" },
            { "AM", "\u10e1\u10dd\u10db\u10ee\u10d4\u10d7\u10d8" },
            { "Teng", "\u10e2\u10d4\u10dc\u10d2\u10d5\u10d0\u10e0\u10d8" },
            { "AO", "\u10d0\u10dc\u10d2\u10dd\u10da\u10d0" },
            { "AQ", "\u10d0\u10dc\u10e2\u10d0\u10e0\u10e5\u10e2\u10d8\u10d9\u10d0" },
            { "AR", "\u10d0\u10e0\u10d2\u10d4\u10dc\u10e2\u10d8\u10dc\u10d0" },
            { "Prti", "\u10db\u10dd\u10dc\u10e3\u10db\u10d4\u10dc\u10e2\u10e3\u10e0\u10d8 \u10de\u10d0\u10e0\u10d7\u10e3\u10da\u10d8" },
            { "AS", "\u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d8\u10e1 \u10e1\u10d0\u10db\u10dd\u10d0" },
            { "AT", "\u10d0\u10d5\u10e1\u10e2\u10e0\u10d8\u10d0" },
            { "AU", "\u10d0\u10d5\u10e1\u10e2\u10e0\u10d0\u10da\u10d8\u10d0" },
            { "AW", "\u10d0\u10e0\u10e3\u10d1\u10d0" },
            { "en_US", "\u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10e3\u10da\u10d8 \u10d8\u10dc\u10d2\u10da\u10d8\u10e1\u10e3\u10e0\u10d8" },
            { "AX", "\u10d0\u10da\u10d0\u10dc\u10d3\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "mye", "\u10db\u10d8\u10d4\u10dc\u10d4" },
            { "AZ", "\u10d0\u10d6\u10d4\u10e0\u10d1\u10d0\u10d8\u10ef\u10d0\u10dc\u10d8" },
            { "BA", "\u10d1\u10dd\u10e1\u10dc\u10d8\u10d0 \u10d3\u10d0 \u10f0\u10d4\u10e0\u10ea\u10d4\u10d2\u10dd\u10d5\u10d8\u10dc\u10d0" },
            { "BB", "\u10d1\u10d0\u10e0\u10d1\u10d0\u10d3\u10dd\u10e1\u10d8" },
            { "ceb", "\u10e1\u10d4\u10d1\u10e3\u10d0\u10dc\u10dd" },
            { "BD", "\u10d1\u10d0\u10dc\u10d2\u10da\u10d0\u10d3\u10d4\u10e8\u10d8" },
            { "kum", "\u10e7\u10e3\u10db\u10e3\u10ee\u10e3\u10e0\u10d8" },
            { "BE", "\u10d1\u10d4\u10da\u10d2\u10d8\u10d0" },
            { "gmh", "\u10e1\u10d0\u10e8\u10e3\u10d0\u10da\u10dd \u10d6\u10d4\u10db\u10dd\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "BF", "\u10d1\u10e3\u10e0\u10d9\u10d8\u10dc\u10d0-\u10e4\u10d0\u10e1\u10dd" },
            { "BG", "\u10d1\u10e3\u10da\u10d2\u10d0\u10e0\u10d4\u10d7\u10d8" },
            { "BH", "\u10d1\u10d0\u10f0\u10e0\u10d4\u10d8\u10dc\u10d8" },
            { "BI", "\u10d1\u10e3\u10e0\u10e3\u10dc\u10d3\u10d8" },
            { "BJ", "\u10d1\u10d4\u10dc\u10d8\u10dc\u10d8" },
            { "BL", "\u10e1\u10d4\u10dc-\u10d1\u10d0\u10e0\u10d7\u10d4\u10da\u10db\u10d8" },
            { "BM", "\u10d1\u10d4\u10e0\u10db\u10e3\u10d3\u10d0" },
            { "kut", "\u10d9\u10e3\u10e2\u10d4\u10dc\u10d0\u10d8" },
            { "myv", "\u10d4\u10e0\u10d6\u10d8\u10d0" },
            { "BN", "\u10d1\u10e0\u10e3\u10dc\u10d4\u10d8" },
            { "BO", "\u10d1\u10dd\u10da\u10d8\u10d5\u10d8\u10d0" },
            { "BQ", "\u10d9\u10d0\u10e0\u10d8\u10d1\u10d8\u10e1 \u10dc\u10d8\u10d3\u10d4\u10e0\u10da\u10d0\u10dc\u10d3\u10d4\u10d1\u10d8" },
            { "BR", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10d0" },
            { "BS", "\u10d1\u10d0\u10f0\u10d0\u10db\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "xog", "\u10e1\u10dd\u10d2\u10d0" },
            { "BT", "\u10d1\u10e3\u10e2\u10d0\u10dc\u10d8" },
            { "BV", "\u10d1\u10e3\u10d5\u10d4" },
            { "BW", "\u10d1\u10dd\u10e2\u10e1\u10d5\u10d0\u10dc\u10d0" },
            { "BY", "\u10d1\u10d4\u10da\u10d0\u10e0\u10e3\u10e1\u10d8" },
            { "BZ", "\u10d1\u10d4\u10da\u10d8\u10d6\u10d8" },
            { "Visp", "\u10ee\u10d8\u10da\u10e3\u10da\u10d8 \u10db\u10d4\u10e2\u10e7\u10d5\u10d4\u10da\u10d4\u10d1\u10d0" },
            { "type.ca.persian", "\u10e1\u10de\u10d0\u10e0\u10e1\u10e3\u10da\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "type.nu.hebr", "\u10d4\u10d1\u10e0\u10d0\u10e3\u10da\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "CA", metaValue_CA },
            { "CC", "\u10e5\u10dd\u10e5\u10dd\u10e1\u10d8\u10e1 (\u10d9\u10d8\u10da\u10d8\u10dc\u10d2\u10d8\u10e1) \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "mzn", "\u10db\u10d0\u10d6\u10d0\u10dc\u10d3\u10d4\u10e0\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "CD", "\u10d9\u10dd\u10dc\u10d2\u10dd - \u10d9\u10d8\u10dc\u10e8\u10d0\u10e1\u10d0" },
            { "CF", "\u10ea\u10d4\u10dc\u10e2\u10e0\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d8\u10e1 \u10e0\u10d4\u10e1\u10de\u10e3\u10d1\u10da\u10d8\u10d9\u10d0" },
            { "CG", "\u10d9\u10dd\u10dc\u10d2\u10dd - \u10d1\u10e0\u10d0\u10d6\u10d0\u10d5\u10d8\u10da\u10d8" },
            { "CH", "\u10e8\u10d5\u10d4\u10d8\u10ea\u10d0\u10e0\u10d8\u10d0" },
            { "CI", "\u10d9\u10dd\u10e2-\u10d3\u10d8\u10d5\u10e3\u10d0\u10e0\u10d8" },
            { "CK", "\u10d9\u10e3\u10d9\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "CL", "\u10e9\u10d8\u10da\u10d4" },
            { "Kthi", "\u10d9\u10d0\u10d8\u10d7\u10d8" },
            { "CM", "\u10d9\u10d0\u10db\u10d4\u10e0\u10e3\u10dc\u10d8" },
            { "CN", "\u10e9\u10d8\u10dc\u10d4\u10d7\u10d8" },
            { "CO", "\u10d9\u10dd\u10da\u10e3\u10db\u10d1\u10d8\u10d0" },
            { "CP", "\u10d9\u10da\u10d8\u10de\u10d4\u10e0\u10e2\u10dd\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8" },
            { "CR", "\u10d9\u10dd\u10e1\u10e2\u10d0-\u10e0\u10d8\u10d9\u10d0" },
            { "CU", "\u10d9\u10e3\u10d1\u10d0" },
            { "CV", "\u10d9\u10d0\u10d1\u10dd-\u10d5\u10d4\u10e0\u10d3\u10d4" },
            { "CW", "\u10d9\u10d8\u10e3\u10e0\u10d0\u10e1\u10d0\u10dd" },
            { "CX", "\u10e8\u10dd\u10d1\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8" },
            { "CY", "\u10d9\u10d5\u10d8\u10de\u10e0\u10dd\u10e1\u10d8" },
            { "CZ", "\u10e9\u10d4\u10ee\u10d4\u10d7\u10d8" },
            { "eka", "\u10d4\u10d9\u10d0\u10ef\u10e3\u10d9\u10d8" },
            { "DE", "\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10d8\u10d0" },
            { "goh", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10d6\u10d4\u10db\u10dd\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "ace", "\u10d0\u10e9\u10d4\u10ee\u10e3\u10e0\u10d8" },
            { "cgg", "\u10e9\u10d8\u10d2\u10d0" },
            { "DG", "\u10d3\u10d8\u10d4\u10d2\u10dd-\u10d2\u10d0\u10e0\u10e1\u10d8\u10d0" },
            { "type.nu.deva", "\u10d3\u10d4\u10d5\u10d0\u10dc\u10d0\u10d2\u10d0\u10e0\u10d8\u10e1 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "DJ", "\u10ef\u10d8\u10d1\u10e3\u10e2\u10d8" },
            { "DK", "\u10d3\u10d0\u10dc\u10d8\u10d0" },
            { "ach", "\u10d0\u10e9\u10dd\u10da\u10d8" },
            { "gon", "\u10d2\u10dd\u10dc\u10d3\u10d8" },
            { "Brai", "\u10d1\u10e0\u10d0\u10d8\u10da\u10d8" },
            { "Brah", "\u10d1\u10e0\u10d0\u10f0\u10db\u10d8" },
            { "DM", "\u10d3\u10dd\u10db\u10d8\u10dc\u10d8\u10d9\u10d0" },
            { "type.nu.armnlow", "\u10e1\u10dd\u10db\u10ee\u10e3\u10e0\u10d8 \u10e5\u10d5\u10d4\u10d3\u10d0 \u10e0\u10d4\u10d2\u10d8\u10e1\u10e2\u10e0\u10d8\u10e1 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "DO", "\u10d3\u10dd\u10db\u10d8\u10dc\u10d8\u10d9\u10d4\u10da\u10d7\u10d0 \u10e0\u10d4\u10e1\u10de\u10e3\u10d1\u10da\u10d8\u10d9\u10d0" },
            { "gor", "\u10d2\u10dd\u10e0\u10dd\u10dc\u10e2\u10d0\u10da\u10dd" },
            { "got", metaValue_got },
            { "zun", "\u10d6\u10e3\u10dc\u10d8" },
            { "tig", "\u10d7\u10d8\u10d2\u10e0\u10d4" },
            { "Takr", "\u10e2\u10d0\u10d9\u10e0\u10d8" },
            { "DZ", "\u10d0\u10da\u10df\u10d8\u10e0\u10d8" },
            { "pag", "\u10de\u10d0\u10dc\u10d2\u10d0\u10e1\u10d8\u10dc\u10d0\u10dc\u10d8" },
            { "pal", "\u10e4\u10d0\u10da\u10d0\u10e3\u10e0\u10d8" },
            { "EA", "\u10e1\u10d4\u10e3\u10e2\u10d0 \u10d3\u10d0 \u10db\u10d4\u10da\u10d8\u10da\u10d0" },
            { "chb", "\u10e9\u10d8\u10d1\u10e9\u10d0" },
            { "pam", "\u10de\u10d0\u10db\u10de\u10d0\u10dc\u10d2\u10d0" },
            { "EC", "\u10d4\u10d9\u10d5\u10d0\u10d3\u10dd\u10e0\u10d8" },
            { "pap", "\u10de\u10d0\u10de\u10d8\u10d0\u10db\u10d4\u10dc\u10e2\u10dd" },
            { "ada", "\u10d0\u10d3\u10d0\u10dc\u10d2\u10db\u10d4" },
            { "EE", "\u10d4\u10e1\u10e2\u10dd\u10dc\u10d4\u10d7\u10d8" },
            { "EG", "\u10d4\u10d2\u10d5\u10d8\u10de\u10e2\u10d4" },
            { "EH", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10e1\u10d0\u10f0\u10d0\u10e0\u10d0" },
            { "pau", "\u10e4\u10d0\u10da\u10d0\u10e3\u10d0\u10dc\u10d8" },
            { "chk", "\u10e9\u10e3\u10d9\u10dd\u10e2\u10d9\u10e3\u10e0\u10d8" },
            { "chn", "\u10e9\u10d8\u10dc\u10e3\u10d9\u10d8\u10e1 \u10df\u10d0\u10e0\u10d2\u10dd\u10dc\u10d8" },
            { "chm", "\u10db\u10d0\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "chp", "\u10e9\u10d8\u10de\u10d4\u10d5\u10d8\u10d0\u10dc\u10d8" },
            { "cho", "\u10e9\u10dd\u10d9\u10e2\u10dd" },
            { "chr", metaValue_chr },
            { "ER", "\u10d4\u10e0\u10d8\u10e2\u10e0\u10d4\u10d0" },
            { "ES", "\u10d4\u10e1\u10de\u10d0\u10dc\u10d4\u10d7\u10d8" },
            { "ET", "\u10d4\u10d7\u10d8\u10dd\u10de\u10d8\u10d0" },
            { "EU", "\u10d4\u10d5\u10e0\u10dd\u10d9\u10d0\u10d5\u10e8\u10d8\u10e0\u10d8" },
            { "type.ca.gregorian", "\u10d2\u10e0\u10d8\u10d2\u10dd\u10e0\u10d8\u10d0\u10dc\u10e3\u10da\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "EZ", "\u10d4\u10d5\u10e0\u10dd\u10d6\u10dd\u10dc\u10d0" },
            { "chy", "\u10e9\u10d4\u10d8\u10d4\u10dc\u10d8" },
            { "type.nu.gujr", "\u10d2\u10e3\u10ef\u10d0\u10e0\u10d0\u10d7\u10e3\u10da\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "ady", "\u10d0\u10d3\u10d8\u10e6\u10d4\u10e3\u10e0\u10d8" },
            { "FI", "\u10e4\u10d8\u10dc\u10d4\u10d7\u10d8" },
            { "FJ", metaValue_FJ },
            { "FK", "\u10e4\u10dd\u10da\u10d9\u10da\u10d4\u10dc\u10d3\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "FM", "\u10db\u10d8\u10d9\u10e0\u10dd\u10dc\u10d4\u10d6\u10d8\u10d0" },
            { "FO", "\u10e4\u10d0\u10e0\u10d4\u10e0\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "Taml", metaValue_ta },
            { "FR", "\u10e1\u10d0\u10e4\u10e0\u10d0\u10dc\u10d2\u10d4\u10d7\u10d8" },
            { "Kpel", metaValue_kpe },
            { "root", "\u10eb\u10d8\u10e0\u10d4\u10e3\u10da\u10d8 \u10d4\u10dc\u10d0" },
            { "type.ca.indian", "\u10d8\u10dc\u10d3\u10dd\u10d4\u10d7\u10d8\u10e1 \u10d4\u10e0\u10dd\u10d5\u10dc\u10e3\u10da\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "grc", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10d1\u10d4\u10e0\u10eb\u10dc\u10e3\u10da\u10d8" },
            { "GA", "\u10d2\u10d0\u10d1\u10dd\u10dc\u10d8" },
            { "GB", "\u10d2\u10d0\u10d4\u10e0\u10d7\u10d8\u10d0\u10dc\u10d4\u10d1\u10e3\u10da\u10d8 \u10e1\u10d0\u10db\u10d4\u10e4\u10dd" },
            { "pcm", "\u10dc\u10d8\u10d2\u10d4\u10e0\u10d8\u10e3\u10da\u10d8 \u10d9\u10e0\u10d4\u10dd\u10da\u10e3\u10e0\u10d8" },
            { "GD", "\u10d2\u10e0\u10d4\u10dc\u10d0\u10d3\u10d0" },
            { "GE", "\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd" },
            { "GF", "\u10e1\u10d0\u10e4\u10e0\u10d0\u10dc\u10d2\u10d4\u10d7\u10d8\u10e1 \u10d2\u10d5\u10d8\u10d0\u10dc\u10d0" },
            { "GG", "\u10d2\u10d4\u10e0\u10dc\u10e1\u10d8" },
            { "GH", "\u10d2\u10d0\u10dc\u10d0" },
            { "Tale", "\u10e2\u10d0\u10d8 \u10da\u10d4" },
            { "GI", "\u10d2\u10d8\u10d1\u10e0\u10d0\u10da\u10e2\u10d0\u10e0\u10d8" },
            { "GL", "\u10d2\u10e0\u10d4\u10dc\u10da\u10d0\u10dc\u10d3\u10d8\u10d0" },
            { "enm", "\u10e1\u10d0\u10e8\u10e3\u10d0\u10da\u10dd \u10d8\u10dc\u10d2\u10da\u10d8\u10e1\u10e3\u10e0\u10d8" },
            { "GM", "\u10d2\u10d0\u10db\u10d1\u10d8\u10d0" },
            { "GN", "\u10d2\u10d5\u10d8\u10dc\u10d4\u10d0" },
            { "GP", "\u10d2\u10d5\u10d0\u10d3\u10d4\u10da\u10e3\u10de\u10d0" },
            { "GQ", "\u10d4\u10d9\u10d5\u10d0\u10e2\u10dd\u10e0\u10e3\u10da\u10d8 \u10d2\u10d5\u10d8\u10dc\u10d4\u10d0" },
            { "GR", "\u10e1\u10d0\u10d1\u10d4\u10e0\u10eb\u10dc\u10d4\u10d7\u10d8" },
            { "GS", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10ef\u10dd\u10e0\u10ef\u10d8\u10d0 \u10d3\u10d0 \u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10e1\u10d4\u10dc\u10d3\u10d5\u10d8\u10e9\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "GT", "\u10d2\u10d5\u10d0\u10e2\u10d4\u10db\u10d0\u10da\u10d0" },
            { "GU", "\u10d2\u10e3\u10d0\u10db\u10d8" },
            { "GW", "\u10d2\u10d5\u10d8\u10dc\u10d4\u10d0-\u10d1\u10d8\u10e1\u10d0\u10e3" },
            { "tlh", "\u10d9\u10da\u10d8\u10dc\u10d2\u10dd\u10dc\u10d8" },
            { "Talu", "\u10d0\u10ee\u10d0\u10da\u10d8 \u10e2\u10d0\u10d8 \u10da\u10d8\u10e3" },
            { "GY", "\u10d2\u10d0\u10d8\u10d0\u10dc\u10d0" },
            { "ckb", "\u10ea\u10d4\u10dc\u10e2\u10e0\u10d0\u10da\u10e3\u10e0\u10d8 \u10e5\u10e3\u10e0\u10d7\u10e3\u10da\u10d8" },
            { "zxx", "\u10da\u10d8\u10dc\u10d2\u10d5\u10d8\u10e1\u10e2\u10e3\u10e0\u10d8 \u10e8\u10d8\u10d2\u10d7\u10d0\u10d5\u10e1\u10d8 \u10d0\u10e0 \u10d0\u10e0\u10d8\u10e1" },
            { "Jurc", "\u10ef\u10e3\u10e0\u10ef\u10d4\u10dc\u10e3\u10da\u10d8" },
            { "de_AT", "\u10d0\u10d5\u10e1\u10e2\u10e0\u10d8\u10e3\u10da\u10d8 \u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "Vaii", metaValue_vai },
            { "HK", "\u10f0\u10dd\u10dc\u10d9\u10dd\u10dc\u10d2\u10d8\u10e1 \u10e1\u10de\u10d4\u10ea\u10d8\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10d3\u10db\u10d8\u10dc\u10d8\u10e1\u10e2\u10e0\u10d0\u10ea\u10d8\u10e3\u10da\u10d8 \u10e0\u10d4\u10d2\u10d8\u10dd\u10dc\u10d8, \u10e9\u10d8\u10dc\u10d4\u10d7\u10d8" },
            { "HM", "\u10f0\u10d4\u10e0\u10d3\u10d8 \u10d3\u10d0 \u10db\u10d0\u10d9\u10d3\u10dd\u10dc\u10d0\u10da\u10d3\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "HN", "\u10f0\u10dd\u10dc\u10d3\u10e3\u10e0\u10d0\u10e1\u10d8" },
            { "HR", "\u10ee\u10dd\u10e0\u10d5\u10d0\u10e2\u10d8\u10d0" },
            { "agq", "\u10d0\u10e6\u10d4\u10db\u10d8" },
            { "gsw", "\u10e8\u10d5\u10d4\u10d8\u10ea\u10d0\u10e0\u10d8\u10e3\u10da\u10d8 \u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "HT", "\u10f0\u10d0\u10d8\u10e2\u10d8" },
            { "HU", "\u10e3\u10dc\u10d2\u10e0\u10d4\u10d7\u10d8" },
            { "IC", "\u10d9\u10d0\u10dc\u10d0\u10e0\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "peo", metaValue_peo },
            { "ID", "\u10d8\u10dc\u10d3\u10dd\u10dc\u10d4\u10d6\u10d8\u10d0" },
            { "IE", "\u10d8\u10e0\u10da\u10d0\u10dc\u10d3\u10d8\u10d0" },
            { "nap", "\u10dc\u10d4\u10d0\u10de\u10dd\u10da\u10d8\u10e2\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "naq", "\u10dc\u10d0\u10db\u10d0" },
            { "zza", "\u10d6\u10d0\u10d6\u10d0\u10d9\u10d8" },
            { "Tang", "\u10e2\u10d0\u10dc\u10e6\u10e3\u10e2\u10e3\u10e0\u10d8" },
            { "IL", "\u10d8\u10e1\u10e0\u10d0\u10d4\u10da\u10d8" },
            { "Nbat", "\u10dc\u10d0\u10d1\u10d0\u10e2\u10d4\u10e3\u10e0\u10d8" },
            { "IM", "\u10db\u10d4\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8" },
            { "IN", "\u10d8\u10dc\u10d3\u10dd\u10d4\u10d7\u10d8" },
            { "IO", "\u10d1\u10e0\u10d8\u10e2\u10d0\u10dc\u10d4\u10d7\u10d8\u10e1 \u10e2\u10d4\u10e0\u10d8\u10e2\u10dd\u10e0\u10d8\u10d0 \u10d8\u10dc\u10d3\u10dd\u10d4\u10d7\u10d8\u10e1 \u10dd\u10d9\u10d4\u10d0\u10dc\u10d4\u10e8\u10d8" },
            { "IQ", "\u10d4\u10e0\u10d0\u10e7\u10d8" },
            { "IR", "\u10d8\u10e0\u10d0\u10dc\u10d8" },
            { "IS", "\u10d8\u10e1\u10da\u10d0\u10dc\u10d3\u10d8\u10d0" },
            { "IT", "\u10d8\u10e2\u10d0\u10da\u10d8\u10d0" },
            { "Zmth", "\u10db\u10d0\u10d7\u10d4\u10db\u10d0\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10dc\u10dd\u10e2\u10d0\u10ea\u10d8\u10d0" },
            { "type.nu.thai", "\u10e2\u10d0\u10d8\u10da\u10d0\u10dc\u10d3\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "type.nu.beng", "\u10d1\u10d4\u10dc\u10d2\u10d0\u10da\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "JE", "\u10ef\u10d4\u10e0\u10e1\u10d8" },
            { "type.ca.islamic", "\u10d8\u10e1\u10da\u10d0\u10db\u10e3\u10e0\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "Beng", metaValue_bn },
            { "JM", "\u10d8\u10d0\u10db\u10d0\u10d8\u10d9\u10d0" },
            { "JO", "\u10d8\u10dd\u10e0\u10d3\u10d0\u10dc\u10d8\u10d0" },
            { "JP", "\u10d8\u10d0\u10de\u10dd\u10dc\u10d8\u10d0" },
            { "ain", "\u10d0\u10d8\u10dc\u10e3\u10e3\u10e0\u10d8" },
            { "Mend", metaValue_men },
            { "guz", "\u10d2\u10e3\u10e1\u10d8\u10d8" },
            { "type.nu.knda", "\u10d9\u10d0\u10dc\u10d0\u10d3\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "Kali", "\u10d9\u10d0\u10d8\u10d0\u10f0-\u10da\u10d8" },
            { "de_CH", "\u10e8\u10d5\u10d4\u10d8\u10ea\u10d0\u10e0\u10d8\u10e3\u10da\u10d8 \u10d6\u10d4\u10db\u10dd\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "type.ca.buddhist", "\u10d1\u10e3\u10d3\u10d8\u10e1\u10e2\u10e3\u10e0\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "KE", "\u10d9\u10d4\u10dc\u10d8\u10d0" },
            { "419", "\u10da\u10d0\u10d7\u10d8\u10dc\u10e3\u10e0\u10d8 \u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d0" },
            { "KG", "\u10e7\u10d8\u10e0\u10d2\u10d8\u10d6\u10d4\u10d7\u10d8" },
            { "KH", "\u10d9\u10d0\u10db\u10d1\u10dd\u10ef\u10d0" },
            { "KI", "\u10d9\u10d8\u10e0\u10d8\u10d1\u10d0\u10e2\u10d8" },
            { "KM", "\u10d9\u10dd\u10db\u10dd\u10e0\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "Knda", metaValue_CA },
            { "KN", "\u10e1\u10d4\u10dc\u10e2-\u10d9\u10d8\u10e2\u10e1\u10d8 \u10d3\u10d0 \u10dc\u10d4\u10d5\u10d8\u10e1\u10d8" },
            { "Zinh", "\u10d2\u10d0\u10d3\u10d0\u10e6\u10d4\u10d1\u10e3\u10da\u10d8" },
            { "fr_CA", "\u10d9\u10d0\u10dc\u10d0\u10d3\u10e3\u10e0\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "KP", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10d9\u10dd\u10e0\u10d4\u10d0" },
            { "KR", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d9\u10dd\u10e0\u10d4\u10d0" },
            { "fr_CH", "\u10e8\u10d5\u10d4\u10d8\u10ea\u10d0\u10e0\u10d8\u10e3\u10da\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "KW", "\u10e5\u10e3\u10d5\u10d4\u10d8\u10d7\u10d8" },
            { "tpi", "\u10e2\u10dd\u10d9-\u10de\u10d8\u10e1\u10d8\u10dc\u10d8" },
            { "KY", "\u10d9\u10d0\u10d8\u10db\u10d0\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "KZ", "\u10e7\u10d0\u10d6\u10d0\u10ee\u10d4\u10d7\u10d8" },
            { "Cyrl", "\u10d9\u10d8\u10e0\u10d8\u10da\u10d8\u10ea\u10d0" },
            { "LA", "\u10da\u10d0\u10dd\u10e1\u10d8" },
            { "LB", "\u10da\u10d8\u10d1\u10d0\u10dc\u10d8" },
            { "phn", metaValue_phn },
            { "LC", "\u10e1\u10d4\u10dc\u10e2-\u10da\u10e3\u10e1\u10d8\u10d0" },
            { "Cyrs", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e1\u10da\u10d0\u10d5\u10e3\u10e0\u10d8 \u10d9\u10d8\u10e0\u10d8\u10da\u10d8\u10ea\u10d0" },
            { "gwi", "\u10d2\u10d5\u10d8\u10e9\u10d8\u10dc\u10d8" },
            { "nds", "\u10e5\u10d5\u10d4\u10db\u10dd\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "LI", "\u10da\u10d8\u10ee\u10e2\u10d4\u10dc\u10e8\u10e2\u10d0\u10d8\u10dc\u10d8" },
            { "LK", "\u10e8\u10e0\u10d8-\u10da\u10d0\u10dc\u10d9\u10d0" },
            { "akk", "\u10d0\u10e5\u10d0\u10d3\u10e3\u10e0\u10d8" },
            { "cop", metaValue_cop },
            { "LR", "\u10da\u10d8\u10d1\u10d4\u10e0\u10d8\u10d0" },
            { "LS", "\u10da\u10d4\u10e1\u10dd\u10d7\u10dd" },
            { "Phlv", "\u10ec\u10d8\u10d2\u10dc\u10e3\u10e0\u10d8 \u10e4\u10d0\u10da\u10d0\u10e3\u10e0\u10d8" },
            { "LT", "\u10da\u10d8\u10d4\u10e2\u10e3\u10d5\u10d0" },
            { "LU", "\u10da\u10e3\u10e5\u10e1\u10d4\u10db\u10d1\u10e3\u10e0\u10d2\u10d8" },
            { "LV", "\u10da\u10d0\u10e2\u10d5\u10d8\u10d0" },
            { "Kana", "\u10d9\u10d0\u10e2\u10d0\u10d9\u10d0\u10dc\u10d0" },
            { "Sora", "\u10e1\u10dd\u10e0\u10d0\u10dc-\u10e1\u10dd\u10db\u10de\u10d4\u10dc\u10d8" },
            { "LY", "\u10da\u10d8\u10d1\u10d8\u10d0" },
            { "lad", "\u10da\u10d0\u10d3\u10d8\u10dc\u10dd" },
            { "vun", "\u10d5\u10e3\u10dc\u10ef\u10dd" },
            { "lah", "\u10da\u10d0\u10dc\u10d3\u10d0" },
            { "lag", "\u10da\u10d0\u10dc\u10d2\u10d8" },
            { "Thaa", "\u10d7\u10d0\u10d0\u10dc\u10d0" },
            { "MA", "\u10db\u10d0\u10e0\u10dd\u10d9\u10dd" },
            { "MC", "\u10db\u10dd\u10dc\u10d0\u10d9\u10dd" },
            { "MD", "\u10db\u10dd\u10da\u10d3\u10dd\u10d5\u10d0" },
            { "Nshu", "\u10dc\u10e3\u10e8\u10e3" },
            { "ME", "\u10db\u10dd\u10dc\u10e2\u10d4\u10dc\u10d4\u10d2\u10e0\u10dd" },
            { "MF", "\u10e1\u10d4\u10dc-\u10db\u10d0\u10e0\u10e2\u10d4\u10dc\u10d8" },
            { "lam", "\u10da\u10d0\u10db\u10d1\u10d0" },
            { "MG", "\u10db\u10d0\u10d3\u10d0\u10d2\u10d0\u10e1\u10d9\u10d0\u10e0\u10d8" },
            { "Thai", metaValue_th },
            { "MH", "\u10db\u10d0\u10e0\u10e8\u10d0\u10da\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "ale", "\u10d0\u10da\u10d4\u10e3\u10e2\u10e3\u10e0\u10d8" },
            { "MK", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10db\u10d0\u10d9\u10d4\u10d3\u10dd\u10dc\u10d8\u10d0" },
            { "ML", "\u10db\u10d0\u10da\u10d8" },
            { "MM", "\u10db\u10d8\u10d0\u10dc\u10db\u10d0\u10e0\u10d8 (\u10d1\u10d8\u10e0\u10db\u10d0)" },
            { "MN", "\u10db\u10dd\u10dc\u10e6\u10dd\u10da\u10d4\u10d7\u10d8" },
            { "new", "\u10dc\u10d4\u10d5\u10d0\u10e0\u10d8" },
            { "MO", "\u10db\u10d0\u10d9\u10d0\u10dd\u10e1 \u10e1\u10de\u10d4\u10ea\u10d8\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10d3\u10db\u10d8\u10dc\u10d8\u10e1\u10e2\u10e0\u10d0\u10ea\u10d8\u10e3\u10da\u10d8 \u10e0\u10d4\u10d2\u10d8\u10dd\u10dc\u10d8, \u10e9\u10d8\u10dc\u10d4\u10d7\u10d8" },
            { "MP", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10db\u10d0\u10e0\u10d8\u10d0\u10dc\u10d0\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "MQ", "\u10db\u10d0\u10e0\u10e2\u10d8\u10dc\u10d8\u10d9\u10d0" },
            { "MR", "\u10db\u10d0\u10d5\u10e0\u10d8\u10e2\u10d0\u10dc\u10d8\u10d0" },
            { "MS", "\u10db\u10dd\u10dc\u10e1\u10d4\u10e0\u10d0\u10e2\u10d8" },
            { "MT", "\u10db\u10d0\u10da\u10e2\u10d0" },
            { "MU", "\u10db\u10d0\u10d5\u10e0\u10d8\u10d9\u10d8" },
            { "alt", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d0\u10da\u10d7\u10d0\u10e3\u10e0\u10d8" },
            { "MV", "\u10db\u10d0\u10da\u10d3\u10d8\u10d5\u10d4\u10d1\u10d8" },
            { "MW", "\u10db\u10d0\u10da\u10d0\u10d5\u10d8" },
            { "MX", "\u10db\u10d4\u10e5\u10e1\u10d8\u10d9\u10d0" },
            { "type.ca.japanese", "\u10d8\u10d0\u10de\u10dd\u10dc\u10e3\u10e0\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "MY", "\u10db\u10d0\u10da\u10d0\u10d8\u10d6\u10d8\u10d0" },
            { "MZ", "\u10db\u10dd\u10d6\u10d0\u10db\u10d1\u10d8\u10d9\u10d8" },
            { "Phli", "\u10db\u10dd\u10dc\u10e3\u10db\u10d4\u10dc\u10e2\u10e3\u10e0\u10d8 \u10e4\u10d0\u10da\u10d0\u10e3\u10e0\u10d8" },
            { "NA", "\u10dc\u10d0\u10db\u10d8\u10d1\u10d8\u10d0" },
            { "202", "\u10e1\u10e3\u10d1\u10e1\u10d0\u10f0\u10d0\u10e0\u10e3\u10da\u10d8 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d0" },
            { "type.ca.hebrew", "\u10d4\u10d1\u10e0\u10d0\u10e3\u10da\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "NC", "\u10d0\u10ee\u10d0\u10da\u10d8 \u10d9\u10d0\u10da\u10d4\u10d3\u10dd\u10dc\u10d8\u10d0" },
            { "NE", "\u10dc\u10d8\u10d2\u10d4\u10e0\u10d8" },
            { "NF", "\u10dc\u10dd\u10e0\u10e4\u10dd\u10da\u10d9\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8" },
            { "NG", "\u10dc\u10d8\u10d2\u10d4\u10e0\u10d8\u10d0" },
            { "trv", "\u10e2\u10d0\u10e0\u10dd\u10d9\u10dd" },
            { "Phlp", "\u10e4\u10e1\u10d0\u10da\u10db\u10e3\u10dc\u10e3\u10e0\u10d8 \u10e4\u10d0\u10da\u10d0\u10e3\u10e0\u10d8" },
            { "NI", "\u10dc\u10d8\u10d9\u10d0\u10e0\u10d0\u10d2\u10e3\u10d0" },
            { "Hmng", "\u10e4\u10d0\u10f0\u10d0\u10e3-\u10db\u10dd\u10dc\u10d8" },
            { "NL", "\u10dc\u10d8\u10d3\u10d4\u10e0\u10da\u10d0\u10dc\u10d3\u10d4\u10d1\u10d8" },
            { "NO", "\u10dc\u10dd\u10e0\u10d5\u10d4\u10d2\u10d8\u10d0" },
            { "NP", "\u10dc\u10d4\u10de\u10d0\u10da\u10d8" },
            { "NR", metaValue_NR },
            { "NU", metaValue_NU },
            { "Phnx", metaValue_phn },
            { "rof", "\u10e0\u10dd\u10db\u10d1\u10dd" },
            { "NZ", "\u10d0\u10ee\u10d0\u10da\u10d8 \u10d6\u10d4\u10da\u10d0\u10dc\u10d3\u10d8\u10d0" },
            { "Merc", "\u10db\u10d4\u10e0\u10dd\u10d8\u10e2\u10e3\u10da\u10d8 \u10d9\u10e3\u10e0\u10e1\u10d8\u10d5\u10d8" },
            { "rom", "\u10d1\u10dd\u10e8\u10e3\u10e0\u10d8" },
            { "Mero", "\u10db\u10d4\u10e0\u10dd\u10d8\u10e2\u10e3\u10da\u10d8" },
            { "crh", "\u10e7\u10d8\u10e0\u10d8\u10db\u10e3\u10da-\u10d7\u10e3\u10e0\u10e5\u10e3\u10da\u10d8" },
            { "ang", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10d8\u10dc\u10d2\u10da\u10d8\u10e1\u10e3\u10e0\u10d8" },
            { "OM", "\u10dd\u10db\u10d0\u10dc\u10d8" },
            { "anp", "\u10d0\u10dc\u10d2\u10d8\u10d9\u10d0" },
            { "crs", "\u10e1\u10d4\u10e1\u10d4\u10da\u10d5\u10d0-\u10d9\u10e0\u10d4\u10dd\u10da\u10e3\u10e0\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u10de\u10d0\u10dc\u10d0\u10db\u10d0" },
            { "type.ca.islamic-civil", "\u10d8\u10e1\u10da\u10d0\u10db\u10e3\u10e0\u10d8 \u10e1\u10d0\u10db\u10dd\u10e5\u10d0\u10da\u10d0\u10e5\u10dd \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "csb", "\u10d9\u10d0\u10e8\u10e3\u10d1\u10e3\u10e0\u10d8" },
            { "en_GB", "\u10d1\u10e0\u10d8\u10e2\u10d0\u10dc\u10e3\u10da\u10d8 \u10d8\u10dc\u10d2\u10da\u10d8\u10e1\u10e3\u10e0\u10d8" },
            { "PE", "\u10de\u10d4\u10e0\u10e3" },
            { "PF", "\u10e1\u10d0\u10e4\u10e0\u10d0\u10dc\u10d2\u10d4\u10d7\u10d8\u10e1 \u10de\u10dd\u10da\u10d8\u10dc\u10d4\u10d6\u10d8\u10d0" },
            { "PG", "\u10de\u10d0\u10de\u10e3\u10d0-\u10d0\u10ee\u10d0\u10da\u10d8 \u10d2\u10d5\u10d8\u10dc\u10d4\u10d0" },
            { "PH", "\u10e4\u10d8\u10da\u10d8\u10de\u10d8\u10dc\u10d4\u10d1\u10d8" },
            { "PK", "\u10de\u10d0\u10d9\u10d8\u10e1\u10e2\u10d0\u10dc\u10d8" },
            { "PL", "\u10de\u10dd\u10da\u10dd\u10dc\u10d4\u10d7\u10d8" },
            { "ewo", "\u10d4\u10d5\u10dd\u10dc\u10d3\u10dd" },
            { "PM", "\u10e1\u10d4\u10dc-\u10de\u10d8\u10d4\u10e0\u10d8 \u10d3\u10d0 \u10db\u10d8\u10d9\u10d4\u10da\u10dd\u10dc\u10d8" },
            { "PN", "\u10de\u10d8\u10e2\u10d9\u10d4\u10e0\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "PR", "\u10de\u10e3\u10d4\u10e0\u10e2\u10dd-\u10e0\u10d8\u10d9\u10dd" },
            { "PS", "\u10de\u10d0\u10da\u10d4\u10e1\u10e2\u10d8\u10dc\u10d8\u10e1 \u10e2\u10d4\u10e0\u10d8\u10e2\u10dd\u10e0\u10d8\u10d4\u10d1\u10d8" },
            { "Bali", "\u10d1\u10d0\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "PT", "\u10de\u10dd\u10e0\u10e2\u10e3\u10d2\u10d0\u10da\u10d8\u10d0" },
            { "PW", "\u10de\u10d0\u10da\u10d0\u10e3" },
            { "nia", "\u10dc\u10d8\u10d0\u10e1\u10d8" },
            { "type.nu.greklow", "\u10d1\u10d4\u10e0\u10eb\u10dc\u10e3\u10da\u10d8 \u10e5\u10d5\u10d4\u10d3\u10d0 \u10e0\u10d4\u10d2\u10d8\u10e1\u10e2\u10e0\u10d8\u10e1 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "PY", "\u10de\u10d0\u10e0\u10d0\u10d2\u10d5\u10d0\u10d8" },
            { "tum", "\u10e2\u10e3\u10db\u10d1\u10e3\u10d9\u10d0" },
            { "Hebr", metaValue_he },
            { "QA", "\u10d9\u10d0\u10e2\u10d0\u10e0\u10d8" },
            { "niu", metaValue_NU },
            { "QO", "\u10e8\u10dd\u10e0\u10d4\u10e3\u10da\u10d8 \u10dd\u10d9\u10d4\u10d0\u10dc\u10d4\u10d7\u10d8" },
            { "lez", "\u10da\u10d4\u10d6\u10d2\u10d8\u10e3\u10e0\u10d8" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u10e2\u10d0\u10d8-\u10d5\u10d8\u10d4\u10e2\u10d8" },
            { "001", "\u10db\u10e1\u10dd\u10e4\u10da\u10d8\u10dd" },
            { "002", "\u10d0\u10e4\u10e0\u10d8\u10d9\u10d0" },
            { "003", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d0" },
            { "RE", "\u10e0\u10d4\u10e3\u10dc\u10d8\u10dd\u10dc\u10d8" },
            { "005", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d0" },
            { "jbo", "\u10da\u10dd\u10df\u10d1\u10d0\u10dc\u10d8" },
            { "Rjng", "\u10e0\u10d4\u10ef\u10d0\u10dc\u10d2\u10d8" },
            { "009", "\u10dd\u10d9\u10d4\u10d0\u10dc\u10d4\u10d7\u10d8" },
            { "RO", "\u10e0\u10e3\u10db\u10d8\u10dc\u10d4\u10d7\u10d8" },
            { "RS", "\u10e1\u10d4\u10e0\u10d1\u10d4\u10d7\u10d8" },
            { "Mroo", "\u10db\u10e0\u10dd" },
            { "RU", "\u10e0\u10e3\u10e1\u10d4\u10d7\u10d8" },
            { "RW", "\u10e0\u10e3\u10d0\u10dc\u10d3\u10d0" },
            { "type.nu.talu", "\u10d0\u10ee\u10d0\u10da\u10d8 \u10e2\u10d0\u10d8 \u10da\u10d8\u10e3\u10e1\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "Ugar", metaValue_uga },
            { "Mani", "\u10db\u10d0\u10dc\u10d8\u10e5\u10d4\u10e3\u10e0\u10d8" },
            { "Khar", "\u10e5\u10d0\u10e0\u10dd\u10e8\u10d7\u10d8" },
            { "SA", "\u10e1\u10d0\u10e3\u10d3\u10d8\u10e1 \u10d0\u10e0\u10d0\u10d1\u10d4\u10d7\u10d8" },
            { "Mand", "\u10db\u10d0\u10dc\u10d3\u10d4\u10e3\u10e0\u10d8" },
            { "SB", "\u10e1\u10dd\u10da\u10dd\u10db\u10dd\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "twq", "\u10e2\u10d0\u10e1\u10d0\u10d5\u10d0\u10e5\u10d8" },
            { "011", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d0" },
            { "SC", "\u10e1\u10d4\u10d8\u10e8\u10d4\u10da\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "SD", "\u10e1\u10e3\u10d3\u10d0\u10dc\u10d8" },
            { "013", "\u10ea\u10d4\u10dc\u10e2\u10e0\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d0" },
            { "SE", "\u10e8\u10d5\u10d4\u10d3\u10d4\u10d7\u10d8" },
            { "014", "\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d0" },
            { "arc", "\u10d0\u10e0\u10d0\u10db\u10d4\u10e3\u10da\u10d8" },
            { "Loma", "\u10da\u10dd\u10db\u10d0" },
            { "015", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d0" },
            { "SG", "\u10e1\u10d8\u10dc\u10d2\u10d0\u10de\u10e3\u10e0\u10d8" },
            { "SH", "\u10ec\u10db\u10d8\u10dc\u10d3\u10d0 \u10d4\u10da\u10d4\u10dc\u10d4\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8" },
            { "type.lb.strict", "\u10e1\u10e2\u10e0\u10d8\u10e5\u10dd\u10dc\u10d8\u10e1 \u10d6\u10d4\u10d3\u10db\u10d8\u10ec\u10d4\u10d5\u10dc\u10d8\u10d7\u10d8 \u10ec\u10e7\u10d5\u10d4\u10e2\u10d8\u10e1 \u10e1\u10e2\u10d8\u10da\u10d8" },
            { "017", "\u10e8\u10e3\u10d0 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d0" },
            { "SI", "\u10e1\u10da\u10dd\u10d5\u10d4\u10dc\u10d8\u10d0" },
            { "018", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d0" },
            { "SJ", "\u10e8\u10de\u10d8\u10ea\u10d1\u10d4\u10e0\u10d2\u10d4\u10dc\u10d8 \u10d3\u10d0 \u10d8\u10d0\u10dc-\u10db\u10d0\u10d8\u10d4\u10dc\u10d8" },
            { "019", "\u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d4\u10d1\u10d8" },
            { "SK", "\u10e1\u10da\u10dd\u10d5\u10d0\u10d9\u10d4\u10d7\u10d8" },
            { "Bamu", "\u10d1\u10d0\u10db\u10e3\u10db\u10d8" },
            { "Wole", "\u10d5\u10dd\u10da\u10d4\u10d0\u10d8" },
            { "SL", "\u10e1\u10d8\u10d4\u10e0\u10d0-\u10da\u10d4\u10dd\u10dc\u10d4" },
            { "SM", "\u10e1\u10d0\u10dc-\u10db\u10d0\u10e0\u10d8\u10dc\u10dd" },
            { "SN", "\u10e1\u10d4\u10dc\u10d4\u10d2\u10d0\u10da\u10d8" },
            { "SO", "\u10e1\u10dd\u10db\u10d0\u10da\u10d8" },
            { "arn", "\u10db\u10d0\u10de\u10e3\u10d3\u10e3\u10dc\u10d2\u10e3\u10dc\u10d8" },
            { "arp", "\u10d0\u10e0\u10d0\u10de\u10d0\u10f0\u10dd" },
            { "type.nu.taml", "\u10e2\u10e0\u10d0\u10d3\u10d8\u10ea\u10d8\u10e3\u10da\u10d8 \u10e2\u10d0\u10db\u10d8\u10da\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "SR", "\u10e1\u10e3\u10e0\u10d8\u10dc\u10d0\u10db\u10d8" },
            { "SS", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10e1\u10e3\u10d3\u10d0\u10dc\u10d8" },
            { "ST", "\u10e1\u10d0\u10dc-\u10e2\u10dd\u10db\u10d4 \u10d3\u10d0 \u10de\u10e0\u10d8\u10dc\u10e1\u10d8\u10de\u10d8" },
            { "SV", "\u10e1\u10d0\u10da\u10d5\u10d0\u10d3\u10dd\u10e0\u10d8" },
            { "SX", "\u10e1\u10d8\u10dc\u10e2-\u10db\u10d0\u10e0\u10e2\u10d4\u10dc\u10d8" },
            { "SY", "\u10e1\u10d8\u10e0\u10d8\u10d0" },
            { "SZ", "\u10e1\u10d5\u10d0\u10d6\u10d8\u10da\u10d4\u10dc\u10d3\u10d8" },
            { "arw", "\u10d0\u10e0\u10d0\u10d5\u10d0\u10d9\u10d8" },
            { "TA", "\u10e2\u10e0\u10d8\u10e1\u10e2\u10d0\u10dc-\u10d3\u10d0-\u10d9\u10e3\u10dc\u10d8\u10d0" },
            { "asa", "\u10d0\u10e1\u10e3" },
            { "type.ms.ussystem", "\u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10e3\u10da\u10d8 \u10e1\u10d0\u10d6\u10dd\u10db\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0" },
            { "021", "\u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d8\u10e1 \u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7\u10d8" },
            { "TC", "\u10d7\u10d4\u10e0\u10e5\u10e1-\u10e5\u10d0\u10d8\u10e5\u10dd\u10e1\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "yav", "\u10d8\u10d0\u10dc\u10d2\u10d1\u10d4\u10dc\u10d8" },
            { "TD", "\u10e9\u10d0\u10d3\u10d8" },
            { "TF", "\u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8 \u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7\u10d8\u10e1 \u10e2\u10d4\u10e0\u10d8\u10e2\u10dd\u10e0\u10d8\u10d4\u10d1\u10d8" },
            { "TG", "\u10e2\u10dd\u10d2\u10dd" },
            { "TH", "\u10e2\u10d0\u10d8\u10da\u10d0\u10dc\u10d3\u10d8" },
            { "TJ", "\u10e2\u10d0\u10ef\u10d8\u10d9\u10d4\u10d7\u10d8" },
            { "029", "\u10d9\u10d0\u10e0\u10d8\u10d1\u10d8\u10e1 \u10d6\u10e6\u10d5\u10d0" },
            { "TK", "\u10e2\u10dd\u10d9\u10d4\u10da\u10d0\u10e3" },
            { "TL", "\u10e2\u10d8\u10db\u10dd\u10e0-\u10da\u10d4\u10e1\u10e2\u10d4" },
            { "ybb", "\u10d8\u10d4\u10db\u10d1\u10d0" },
            { "TM", "\u10d7\u10e3\u10e0\u10e5\u10db\u10d4\u10dc\u10d4\u10d7\u10d8" },
            { "TN", "\u10e2\u10e3\u10dc\u10d8\u10e1\u10d8" },
            { "TO", "\u10e2\u10dd\u10dc\u10d2\u10d0" },
            { "TR", "\u10d7\u10e3\u10e0\u10e5\u10d4\u10d7\u10d8" },
            { "TT", "\u10e2\u10e0\u10d8\u10dc\u10d8\u10d3\u10d0\u10d3\u10d8 \u10d3\u10d0 \u10e2\u10dd\u10d1\u10d0\u10d2\u10dd" },
            { "TV", metaValue_TV },
            { "TW", "\u10e2\u10d0\u10d8\u10d5\u10d0\u10dc\u10d8" },
            { "ast", "\u10d0\u10e1\u10e2\u10e3\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "Orkh", "\u10dd\u10e0\u10ee\u10dd\u10dc\u10e3\u10da\u10d8" },
            { "TZ", "\u10e2\u10d0\u10dc\u10d6\u10d0\u10dc\u10d8\u10d0" },
            { "nmg", "\u10d9\u10d5\u10d0\u10e1\u10d8\u10dd" },
            { "Zzzz", "\u10e3\u10ea\u10dc\u10dd\u10d1\u10d8 \u10d3\u10d0\u10db\u10ec\u10d4\u10e0\u10da\u10dd\u10d1\u10d0" },
            { "Sind", "\u10e5\u10e3\u10d3\u10d0\u10d5\u10d0\u10d3\u10d8" },
            { "UA", "\u10e3\u10d9\u10e0\u10d0\u10d8\u10dc\u10d0" },
            { "rup", "\u10d0\u10e0\u10dd\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "030", "\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d0\u10d6\u10d8\u10d0" },
            { "tyv", "\u10e2\u10e3\u10d5\u10d0" },
            { "sw_CD", "\u10d9\u10dd\u10dc\u10d2\u10dd\u10e1 \u10e1\u10e3\u10d0\u10f0\u10d8\u10da\u10d8" },
            { "034", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d0\u10d6\u10d8\u10d0" },
            { "035", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7-\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d0\u10d6\u10d8\u10d0" },
            { "UG", "\u10e3\u10d2\u10d0\u10dc\u10d3\u10d0" },
            { "039", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d4\u10d5\u10e0\u10dd\u10de\u10d0" },
            { "Sinh", metaValue_si },
            { "UM", "\u10d0\u10e8\u10e8-\u10d8\u10e1 \u10e8\u10dd\u10e0\u10d4\u10e3\u10da\u10d8 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "UN", "\u10d2\u10d0\u10d4\u10e0\u10dd" },
            { "US", "\u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10d8\u10e1 \u10e8\u10d4\u10d4\u10e0\u10d7\u10d4\u10d1\u10e3\u10da\u10d8 \u10e8\u10e2\u10d0\u10e2\u10d4\u10d1\u10d8" },
            { "haw", "\u10f0\u10d0\u10d5\u10d0\u10d8\u10e3\u10e0\u10d8" },
            { "type.co.gb2312han", metaValue_zh_Hans },
            { "UY", "\u10e3\u10e0\u10e3\u10d2\u10d5\u10d0\u10d8" },
            { "prg", "\u10de\u10e0\u10e3\u10e1\u10d8\u10e3\u10da\u10d8" },
            { "UZ", "\u10e3\u10d6\u10d1\u10d4\u10d9\u10d4\u10d7\u10d8" },
            { "tzm", "\u10ea\u10d4\u10dc\u10e2\u10e0\u10d0\u10da\u10e3\u10e0\u10d8 \u10db\u10dd\u10e0\u10dd\u10d9\u10dd\u10e1 \u10e2\u10d0\u10db\u10d0\u10d6\u10d8\u10d2\u10ee\u10e2\u10d8" },
            { "nnh", "\u10dc\u10d2\u10d8\u10db\u10d1\u10e3\u10dc\u10d8" },
            { "VA", "\u10e5\u10d0\u10da\u10d0\u10e5\u10d8 \u10d5\u10d0\u10e2\u10d8\u10d9\u10d0\u10dc\u10d8" },
            { "pro", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10de\u10e0\u10dd\u10d5\u10d0\u10dc\u10e1\u10e3\u10da\u10d8" },
            { "VC", "\u10e1\u10d4\u10dc\u10e2-\u10d5\u10d8\u10dc\u10e1\u10d4\u10dc\u10e2\u10d8 \u10d3\u10d0 \u10d2\u10e0\u10d4\u10dc\u10d0\u10d3\u10d8\u10dc\u10d4\u10d1\u10d8" },
            { "VE", "\u10d5\u10d4\u10dc\u10d4\u10e1\u10e3\u10d4\u10da\u10d0" },
            { "VG", "\u10d1\u10e0\u10d8\u10e2\u10d0\u10dc\u10d4\u10d7\u10d8\u10e1 \u10d5\u10d8\u10e0\u10ef\u10d8\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "VI", "\u10d0\u10e8\u10e8-\u10d8\u10e1 \u10d5\u10d8\u10e0\u10ef\u10d8\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8" },
            { "VN", "\u10d5\u10d8\u10d4\u10e2\u10dc\u10d0\u10db\u10d8" },
            { "VU", "\u10d5\u10d0\u10dc\u10e3\u10d0\u10e2\u10e3" },
            { "nog", "\u10dc\u10dd\u10e6\u10d0\u10e3\u10e0\u10d8" },
            { "rwk", "\u10e0\u10e3\u10d0" },
            { "non", "\u10eb\u10d5\u10d4\u10da\u10e1\u10d9\u10d0\u10dc\u10d3\u10d8\u10dc\u10d0\u10d5\u10d8\u10e3\u10e0\u10d8" },
            { "053", "\u10d0\u10d5\u10e1\u10e2\u10e0\u10d0\u10da\u10d0\u10d6\u10d8\u10d0" },
            { "054", "\u10db\u10d4\u10da\u10d0\u10dc\u10d4\u10d6\u10d8\u10d0" },
            { "WF", "\u10e3\u10dd\u10da\u10d8\u10e1\u10d8 \u10d3\u10d0 \u10e4\u10e3\u10e2\u10e3\u10dc\u10d0" },
            { "type.co.traditional", metaValue_Hant },
            { "057", "\u10db\u10d8\u10d9\u10e0\u10dd\u10dc\u10d4\u10d6\u10d8\u10d8\u10e1 \u10e0\u10d4\u10d2\u10d8\u10dd\u10dc\u10d8" },
            { "jgo", "\u10dc\u10d2\u10dd\u10db\u10d1\u10d0" },
            { "lkt", "\u10da\u10d0\u10d9\u10dd\u10e2\u10d0" },
            { "wae", "\u10d5\u10d0\u10da\u10e1\u10d4\u10e0\u10d8" },
            { "WS", metaValue_WS },
            { "Bass", "\u10d1\u10d0\u10e1\u10d0 \u10d5\u10d0\u10f0\u10d8" },
            { "wal", "\u10d5\u10d4\u10da\u10d0\u10d8\u10d7\u10d0" },
            { "XA", "\u10e4\u10e1\u10d4\u10d5\u10d3\u10dd-\u10d0\u10e5\u10ea\u10d4\u10dc\u10e2\u10d4\u10d1\u10d8" },
            { "war", "\u10d5\u10d0\u10e0\u10d0\u10d8" },
            { "XB", "\u10e4\u10e1\u10d4\u10d5\u10d3\u10dd-\u10dd\u10e0\u10db\u10d8\u10db\u10d0\u10e0\u10d7\u10e3\u10da\u10d4\u10d1\u10d8\u10d0\u10dc\u10d8" },
            { "awa", "\u10d0\u10d5\u10d0\u10d3\u10d8" },
            { "061", "\u10de\u10dd\u10da\u10d8\u10dc\u10d4\u10d6\u10d8\u10d0" },
            { "XK", "\u10d9\u10dd\u10e1\u10dd\u10d5\u10dd" },
            { "Gujr", "\u10d2\u10e3\u10ef\u10d0\u10e0\u10d0\u10d7\u10e3\u10da\u10d8" },
            { "Zxxx", "\u10e3\u10db\u10ec\u10d4\u10e0\u10da\u10dd\u10d1\u10dd" },
            { "Olck", "\u10dd\u10da-\u10e9\u10d8\u10d9\u10d8" },
            { "wbp", "\u10d5\u10d0\u10da\u10de\u10d8\u10e0\u10d8" },
            { "Batk", "\u10d1\u10d0\u10e2\u10d0\u10d9\u10d8" },
            { "Blis", metaValue_zbl },
            { "YE", "\u10d8\u10d4\u10db\u10d4\u10dc\u10d8" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u10e1\u10e2\u10d0\u10dc\u10d3\u10d0\u10e0\u10e2\u10e3\u10da\u10d8 \u10d3\u10d0\u10ee\u10d0\u10e0\u10d8\u10e1\u10ee\u10d4\u10d1\u10d8\u10e1 \u10d7\u10d0\u10dc\u10db\u10d8\u10db\u10d3\u10d4\u10d5\u10e0\u10dd\u10d1\u10d0" },
            { "Sgnw", "\u10df\u10d4\u10e1\u10e2\u10d7\u10d0" },
            { "YT", "\u10db\u10d0\u10d8\u10dd\u10e2\u10d0" },
            { "ZA", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d0\u10e4\u10e0\u10d8\u10d9\u10d8\u10e1 \u10e0\u10d4\u10e1\u10de\u10e3\u10d1\u10da\u10d8\u10d9\u10d0" },
            { "type.nu.sund", "\u10e1\u10e3\u10dc\u10d3\u10d0\u10dc\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "type.lb.loose", "\u10e1\u10e2\u10e0\u10d8\u10e5\u10dd\u10dc\u10d8\u10e1 \u10e0\u10d1\u10d8\u10da\u10d8 \u10ec\u10e7\u10d5\u10d4\u10e2\u10d8\u10e1 \u10e1\u10e2\u10d8\u10da\u10d8" },
            { "Deva", "\u10d3\u10d4\u10d5\u10d0\u10dc\u10d0\u10d2\u10d0\u10e0\u10d8" },
            { "type.nu.geor", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "Hira", "\u10f0\u10d8\u10e0\u10d0\u10d2\u10d0\u10dc\u10d0" },
            { "ZM", "\u10d6\u10d0\u10db\u10d1\u10d8\u10d0" },
            { "ZW", "\u10d6\u10d8\u10db\u10d1\u10d0\u10d1\u10d5\u10d4" },
            { "ZZ", "\u10e3\u10ea\u10dc\u10dd\u10d1\u10d8 \u10e0\u10d4\u10d2\u10d8\u10dd\u10dc\u10d8" },
            { "Runr", "\u10e0\u10e3\u10dc\u10e3\u10da\u10d8" },
            { "type.ms.metric", "\u10db\u10d4\u10e2\u10e0\u10e3\u10da\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0" },
            { "type.ca.iso8601", "ISO-8601 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "lol", "\u10db\u10dd\u10dc\u10d2\u10dd" },
            { "nso", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10e1\u10dd\u10d7\u10dd" },
            { "type.nu.telu", "\u10e2\u10d4\u10da\u10e3\u10d2\u10e3\u10e1 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "loz", "\u10da\u10dd\u10d6\u10d8" },
            { "jmc", "\u10d9\u10d8\u10db\u10d0\u10e8\u10d0\u10db\u10d8" },
            { "type.nu.hansfin", "\u10d2\u10d0\u10db\u10d0\u10e0\u10e2\u10d8\u10d5\u10d4\u10d1\u10e3\u10da\u10d8 \u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10e4\u10d8\u10dc\u10d0\u10dc\u10e1\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "hil", "\u10f0\u10d8\u10da\u10d8\u10d2\u10d0\u10d8\u10dc\u10dd\u10dc\u10d8" },
            { "type.nu.arabext", "\u10d2\u10d0\u10e4\u10d0\u10e0\u10d7\u10dd\u10d4\u10d1\u10e3\u10da\u10d8 \u10d0\u10e0\u10d0\u10d1\u10e3\u10da-\u10d8\u10dc\u10d3\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "nus", "\u10dc\u10e3\u10d4\u10e0\u10d8" },
            { "dak", "\u10d3\u10d0\u10d9\u10dd\u10e2\u10e3\u10e0\u10d8" },
            { "type.nu.fullwide", "\u10e1\u10e0\u10e3\u10da\u10e1\u10d8\u10d2\u10d0\u10dc\u10d8\u10d0\u10dc\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "hit", "\u10ee\u10d4\u10d7\u10e3\u10e0\u10d8" },
            { "dar", "\u10d3\u10d0\u10e0\u10d2\u10e3\u10e3\u10da\u10d8" },
            { "dav", "\u10e2\u10d0\u10d8\u10e2\u10d0" },
            { "Maya", "\u10db\u10d0\u10d8\u10d0\u10e1 \u10d8\u10d4\u10e0\u10dd\u10d2\u10da\u10d8\u10e4\u10d4\u10d1\u10d8" },
            { "lrc", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10da\u10e3\u10e0\u10d8" },
            { "Copt", metaValue_cop },
            { "nwc", "\u10d9\u10da\u10d0\u10e1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10dc\u10d4\u10d5\u10d0\u10e0\u10e3\u10da\u10d8" },
            { "udm", "\u10e3\u10d3\u10db\u10e3\u10e0\u10e2\u10e3\u10da\u10d8" },
            { "Khmr", metaValue_km },
            { "Limb", "\u10da\u10d8\u10db\u10d1\u10e3" },
            { "sad", "\u10e1\u10d0\u10dc\u10d3\u10d0\u10d5\u10d4" },
            { "type.nu.roman", "\u10e0\u10dd\u10db\u10d0\u10e3\u10da\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "sah", "\u10d8\u10d0\u10d9\u10e3\u10e2\u10e3\u10e0\u10d8" },
            { "sam", "\u10e1\u10d0\u10db\u10d0\u10e0\u10d8\u10e3\u10da-\u10d0\u10e0\u10d0\u10db\u10d4\u10e3\u10da\u10d8" },
            { "saq", "\u10e1\u10d0\u10db\u10d1\u10e3\u10e0\u10e3" },
            { "sat", "\u10e1\u10d0\u10dc\u10e2\u10d0\u10da\u10d8" },
            { "Tfng", "\u10e2\u10d8\u10e4\u10d8\u10dc\u10d0\u10e6\u10d8" },
            { "jpr", "\u10d8\u10e3\u10d3\u10d4\u10dd-\u10e1\u10de\u10d0\u10e0\u10e1\u10e3\u10da\u10d8" },
            { "sba", "\u10dc\u10d2\u10d0\u10db\u10d1\u10d0\u10d8" },
            { "Guru", "\u10d2\u10e3\u10e0\u10db\u10e3\u10ee\u10d8" },
            { "lua", "\u10da\u10e3\u10d1\u10d0-\u10da\u10e3\u10da\u10e3\u10d0" },
            { "sbp", "\u10e1\u10d0\u10dc\u10d2\u10e3" },
            { "lui", "\u10da\u10e3\u10d8\u10e1\u10d4\u10dc\u10d8\u10dd" },
            { "nyn", "\u10dc\u10d8\u10d0\u10dc\u10d9\u10dd\u10da\u10d4" },
            { "nym", "\u10dc\u10d8\u10d0\u10db\u10d5\u10d4\u10d6\u10d8" },
            { "lun", "\u10da\u10e3\u10dc\u10d3\u10d0" },
            { "nyo", "\u10dc\u10d8\u10dd\u10e0\u10dd" },
            { "luo", "\u10da\u10e3\u10dd" },
            { "fil", "\u10e4\u10d8\u10da\u10d8\u10de\u10d8\u10dc\u10e3\u10e0\u10d8" },
            { "hmn", "\u10f0\u10db\u10dd\u10dc\u10d2\u10d8" },
            { "del", "\u10d3\u10d4\u10da\u10d0\u10d5\u10d4\u10e0\u10e3\u10da\u10d8" },
            { "lus", "\u10db\u10d8\u10d6\u10dd" },
            { "bal", "\u10d1\u10d4\u10da\u10e3\u10ef\u10d8" },
            { "den", "\u10e1\u10da\u10d4\u10d8\u10d5\u10d8" },
            { "uga", metaValue_uga },
            { "ban", "\u10d1\u10d0\u10da\u10d8\u10dc\u10e3\u10e0\u10d8" },
            { "luy", "\u10da\u10e3\u10f0\u10d8\u10d0" },
            { "bas", "\u10d1\u10d0\u10e1\u10d0" },
            { "bax", "\u10d1\u10d0\u10db\u10e3\u10dc\u10d8" },
            { "jrb", "\u10d8\u10e3\u10d3\u10d4\u10dd-\u10d0\u10e0\u10d0\u10d1\u10e3\u10da\u10d8" },
            { "es_ES", "\u10d4\u10d5\u10e0\u10dd\u10de\u10e3\u10da\u10d8 \u10d4\u10e1\u10de\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "nzi", "\u10dc\u10d6\u10d8\u10db\u10d0" },
            { "sco", "\u10e8\u10dd\u10e2\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "scn", "\u10e1\u10d8\u10ea\u10d8\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "aa", "\u10d0\u10e4\u10d0\u10e0\u10d8" },
            { "ab", "\u10d0\u10e4\u10ee\u10d0\u10d6\u10e3\u10e0\u10d8" },
            { "ae", metaValue_ae },
            { "af", "\u10d0\u10e4\u10e0\u10d8\u10d9\u10d0\u10d0\u10dc\u10e1\u10d8" },
            { "ak", "\u10d0\u10d9\u10d0\u10dc\u10d8" },
            { "am", "\u10d0\u10db\u10f0\u10d0\u10e0\u10e3\u10da\u10d8" },
            { "Arab", metaValue_ar },
            { "an", "\u10d0\u10e0\u10d0\u10d2\u10dd\u10dc\u10e3\u10da\u10d8" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u10d8\u10d0\u10de\u10dd\u10dc\u10e3\u10e0\u10d8 \u10d9\u10d0\u10dc\u10d0" },
            { "as", "\u10d0\u10e1\u10d0\u10db\u10e3\u10e0\u10d8" },
            { "Lina", "A-\u10ee\u10d0\u10d6\u10dd\u10d5\u10d0\u10dc\u10d8" },
            { "av", "\u10ee\u10e3\u10dc\u10eb\u10e3\u10e0\u10d8" },
            { "Linb", "B-\u10ee\u10d0\u10d6\u10dd\u10d5\u10d0\u10dc\u10d8" },
            { "sdh", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7\u10e5\u10e3\u10e0\u10d7\u10e3\u10da\u10d8" },
            { "ay", "\u10d0\u10d8\u10db\u10d0\u10e0\u10d0" },
            { "az", "\u10d0\u10d6\u10d4\u10e0\u10d1\u10d0\u10d8\u10ef\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "Khoj", "\u10e5\u10dd\u10ef\u10d9\u10d8" },
            { "ba", "\u10d1\u10d0\u10e8\u10d9\u10d8\u10e0\u10e3\u10da\u10d8" },
            { "be", "\u10d1\u10d4\u10da\u10dd\u10e0\u10e3\u10e1\u10e3\u10da\u10d8" },
            { "bg", "\u10d1\u10e3\u10da\u10d2\u10d0\u10e0\u10e3\u10da\u10d8" },
            { "bi", "\u10d1\u10d8\u10e1\u10da\u10d0\u10db\u10d0" },
            { "bm", "\u10d1\u10d0\u10db\u10d1\u10d0\u10e0\u10d0" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u10d3\u10dd\u10d2\u10e0\u10d8\u10d1\u10d8" },
            { "br", "\u10d1\u10e0\u10d4\u10e2\u10dd\u10dc\u10e3\u10da\u10d8" },
            { "bs", "\u10d1\u10dd\u10e1\u10dc\u10d8\u10e3\u10e0\u10d8" },
            { "see", "\u10e1\u10d4\u10dc\u10d4\u10d9\u10d0" },
            { "Mymr", "\u10db\u10d8\u10d0\u10dc\u10db\u10e3\u10e0\u10d8" },
            { "type.nu.laoo", "\u10da\u10d0\u10dd\u10e1\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "seh", "\u10e1\u10d4\u10dc\u10d0" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u10e1\u10d4\u10da\u10d9\u10e3\u10de\u10e3\u10e0\u10d8" },
            { "ca", "\u10d9\u10d0\u10e2\u10d0\u10da\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "ses", "\u10d9\u10dd\u10d8\u10e0\u10d0\u10d1\u10dd\u10e0\u10dd-\u10e1\u10d4\u10dc\u10d8" },
            { "ce", "\u10e9\u10d4\u10e9\u10dc\u10e3\u10e0\u10d8" },
            { "ch", "\u10e9\u10d0\u10db\u10dd\u10e0\u10dd" },
            { "co", "\u10d9\u10dd\u10e0\u10e1\u10d8\u10d9\u10e3\u10da\u10d8" },
            { "Orya", metaValue_or },
            { "cr", "\u10d9\u10e0\u10d8" },
            { "cs", "\u10e9\u10d4\u10ee\u10e3\u10e0\u10d8" },
            { "cu", "\u10e1\u10d0\u10d4\u10d9\u10da\u10d4\u10e1\u10d8\u10dd \u10e1\u10da\u10d0\u10d5\u10e3\u10e0\u10d8" },
            { "cv", "\u10e9\u10e3\u10d5\u10d0\u10e8\u10e3\u10e0\u10d8" },
            { "cy", "\u10e3\u10d4\u10da\u10e1\u10e3\u10e0\u10d8" },
            { "type.nu.ethi", "\u10d4\u10d7\u10d8\u10dd\u10de\u10d8\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "da", "\u10d3\u10d0\u10dc\u10d8\u10e3\u10e0\u10d8" },
            { "pt_PT", "\u10d4\u10d5\u10e0\u10dd\u10de\u10e3\u10da\u10d8 \u10de\u10dd\u10e0\u10e2\u10e3\u10d2\u10d0\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "de", "\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "type.cf.standard", "\u10d5\u10d0\u10da\u10e3\u10e2\u10d8\u10e1 \u10e1\u10e2\u10d0\u10dc\u10d3\u10d0\u10e0\u10e2\u10e3\u10da\u10d8 \u10e4\u10dd\u10e0\u10db\u10d0\u10e2\u10d8" },
            { "bej", "\u10d1\u10d4\u10ef\u10d0" },
            { "din", "\u10d3\u10d8\u10dc\u10d9\u10d0" },
            { "bem", "\u10d1\u10d4\u10db\u10d1\u10d0" },
            { "sga", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10d8\u10e0\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "type.nu.mong", "\u10db\u10dd\u10dc\u10e6\u10dd\u10da\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "dv", "\u10d3\u10d8\u10d5\u10d4\u10f0\u10d8" },
            { "es_419", "\u10da\u10d0\u10d7\u10d8\u10dc\u10e3\u10e0 \u10d0\u10db\u10d4\u10e0\u10d8\u10d9\u10e3\u10da\u10d8 \u10d4\u10e1\u10de\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "dz", "\u10eb\u10dd\u10dc\u10d2\u10d9\u10ee\u10d0" },
            { "bez", "\u10d1\u10d4\u10dc\u10d0" },
            { "type.ca.chinese", "\u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "dje", "\u10d6\u10d0\u10e0\u10db\u10d0" },
            { "type.nu.grek", "\u10d1\u10d4\u10e0\u10eb\u10dc\u10e3\u10da\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "ee", "\u10d4\u10d5\u10d4" },
            { "type.lb.normal", "\u10e1\u10e2\u10e0\u10d8\u10e5\u10dd\u10dc\u10d8\u10e1 \u10e9\u10d5\u10d4\u10e3\u10da\u10d4\u10d1\u10e0\u10d8\u10d5\u10d8 \u10ec\u10e7\u10d5\u10d4\u10e2\u10d8\u10e1 \u10e1\u10e2\u10d8\u10da\u10d8" },
            { "ro_MD", "\u10db\u10dd\u10da\u10d3\u10d0\u10d5\u10e3\u10e0\u10d8" },
            { "el", metaValue_el },
            { "en", "\u10d8\u10dc\u10d2\u10da\u10d8\u10e1\u10e3\u10e0\u10d8" },
            { "eo", "\u10d4\u10e1\u10de\u10d4\u10e0\u10d0\u10dc\u10e2\u10dd" },
            { "type.co.big5han", metaValue_zh_Hant },
            { "es", "\u10d4\u10e1\u10de\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "et", "\u10d4\u10e1\u10e2\u10dd\u10dc\u10e3\u10e0\u10d8" },
            { "Hanb", "\u10f0\u10d0\u10dc\u10d1\u10d8" },
            { "eu", "\u10d1\u10d0\u10e1\u10d9\u10e3\u10e0\u10d8" },
            { "Buhd", "\u10d1\u10e3\u10f0\u10d8\u10d3\u10d8" },
            { "Hang", "\u10f0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "Samr", "\u10e1\u10d0\u10db\u10d0\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "shi", "\u10e8\u10d8\u10da\u10f0\u10d0" },
            { "hsb", "\u10d6\u10d4\u10db\u10dd\u10e1\u10dd\u10e0\u10d1\u10e3\u10da\u10d8" },
            { "Hani", "\u10f0\u10d0\u10dc\u10d8" },
            { "shn", "\u10e8\u10d0\u10dc\u10d8" },
            { "Hano", "\u10f0\u10d0\u10dc\u10e3\u10dc\u10dd\u10dd" },
            { "fa", "\u10e1\u10de\u10d0\u10e0\u10e1\u10e3\u10da\u10d8" },
            { "Hans", "\u10d2\u10d0\u10db\u10d0\u10e0\u10e2\u10d8\u10d5\u10d4\u10d1\u10e3\u10da\u10d8" },
            { "type.nu.latn", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "Hant", metaValue_Hant },
            { "ff", "\u10e4\u10e3\u10da\u10d0" },
            { "shu", "\u10e9\u10d0\u10d3\u10e3\u10e0\u10d8 \u10d0\u10e0\u10d0\u10d1\u10e3\u10da\u10d8" },
            { "fi", "\u10e4\u10d8\u10dc\u10e3\u10e0\u10d8" },
            { "fj", metaValue_FJ },
            { "fon", "\u10e4\u10dd\u10dc\u10d8" },
            { "bgn", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d1\u10d4\u10da\u10e3\u10ef\u10d8" },
            { "yue", "\u10d9\u10d0\u10dc\u10e2\u10dd\u10dc\u10e3\u10e0\u10d8" },
            { "fo", "\u10e4\u10d0\u10e0\u10d4\u10e0\u10e3\u10da\u10d8" },
            { "umb", "\u10e3\u10db\u10d1\u10e3\u10dc\u10d3\u10e3" },
            { "fr", "\u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "fy", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7\u10e4\u10e0\u10d8\u10d6\u10d8\u10e3\u10da\u10d8" },
            { "ga", "\u10d8\u10e0\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "gd", "\u10e8\u10dd\u10e2\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8 \u10d2\u10d4\u10da\u10e3\u10e0\u10d8" },
            { "gl", "\u10d2\u10d0\u10da\u10d8\u10e1\u10d8\u10e3\u10e0\u10d8" },
            { "gn", "\u10d2\u10e3\u10d0\u10e0\u10d0\u10dc\u10d8" },
            { "bho", "\u10d1\u10dd\u10ef\u10de\u10e3\u10e0\u10d8" },
            { "und", "\u10e3\u10ea\u10dc\u10dd\u10d1\u10d8 \u10d4\u10dc\u10d0" },
            { "gu", "\u10d2\u10e3\u10ef\u10d0\u10e0\u10d0\u10d7\u10d8" },
            { "gv", "\u10db\u10d4\u10dc\u10e3\u10e0\u10d8" },
            { "ha", "\u10f0\u10d0\u10e3\u10e1\u10d0" },
            { "he", metaValue_he },
            { "hi", "\u10f0\u10d8\u10dc\u10d3\u10d8" },
            { "hup", "\u10f0\u10e3\u10de\u10d0" },
            { "bin", "\u10d1\u10d8\u10dc\u10d8" },
            { "hr", "\u10ee\u10dd\u10e0\u10d5\u10d0\u10e2\u10e3\u10da\u10d8" },
            { "ht", "\u10f0\u10d0\u10d8\u10e2\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10d4\u10dd\u10da\u10d8" },
            { "hu", "\u10e3\u10dc\u10d2\u10e0\u10e3\u10da\u10d8" },
            { "hy", metaValue_hy },
            { "hz", "\u10f0\u10d4\u10e0\u10d4\u10e0\u10dd" },
            { "ia", "\u10d8\u10dc\u10e2\u10d4\u10e0\u10da\u10d8\u10dc\u10d2\u10e3\u10d0\u10da\u10e3\u10e0\u10d8" },
            { "Jamo", "\u10ef\u10d0\u10db\u10dd" },
            { "id", "\u10d8\u10dc\u10d3\u10dd\u10dc\u10d4\u10d6\u10d8\u10e3\u10e0\u10d8" },
            { "type.nu.tibt", "\u10e2\u10d8\u10d1\u10d4\u10e2\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "ie", "\u10d8\u10dc\u10e2\u10d4\u10e0\u10da\u10d8\u10dc\u10d2\u10d8" },
            { "ig", "\u10d8\u10d2\u10d1\u10dd" },
            { "ii", "\u10e1\u10d8\u10e9\u10e3\u10d0\u10dc\u10d8\u10e1 \u10d8" },
            { "frm", "\u10e1\u10d0\u10e8\u10e3\u10d0\u10da\u10dd \u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "fro", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8" },
            { "io", "\u10d8\u10d3\u10dd" },
            { "frs", "\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7\u10e4\u10e0\u10d8\u10d6\u10d8\u10e3\u10da\u10d8" },
            { "frr", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10e4\u10e0\u10d8\u10d6\u10d8\u10e3\u10da\u10d8" },
            { "is", "\u10d8\u10e1\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "it", "\u10d8\u10e2\u10d0\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "iu", "\u10d8\u10dc\u10e3\u10d9\u10e2\u10d8\u10e2\u10e3\u10e2\u10d8" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7-\u10d0\u10e0\u10d0\u10d1\u10e3\u10da\u10d8" },
            { "Sara", "\u10e1\u10d0\u10e0\u10d0\u10e2\u10d8" },
            { "doi", "\u10d3\u10dd\u10d2\u10e0\u10d8" },
            { "sma", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7\u10e1\u10d0\u10db\u10e3\u10e0\u10d8" },
            { "jv", metaValue_jv },
            { "mad", "\u10db\u10d0\u10d3\u10e3\u10e0\u10e3\u10da\u10d8" },
            { "smj", "\u10da\u10e3\u10da\u10d4-\u10e1\u10d0\u10d0\u10db\u10e3\u10e0\u10d8" },
            { "mag", "\u10db\u10d0\u10d2\u10d0\u10f0\u10d8" },
            { "maf", "\u10db\u10d0\u10e4\u10d0" },
            { "mai", "\u10db\u10d0\u10d8\u10d7\u10d8\u10da\u10d8" },
            { "smn", "\u10d8\u10dc\u10d0\u10e0\u10d8-\u10e1\u10d0\u10d0\u10db\u10e3\u10e0\u10d8" },
            { "ka", metaValue_ka },
            { "bla", "\u10e1\u10d8\u10d9\u10e1\u10d8\u10d9\u10d0" },
            { "mak", "\u10db\u10d0\u10d9\u10d0\u10e1\u10d0\u10e0\u10d8" },
            { "sms", "\u10e1\u10d9\u10dd\u10da\u10e2-\u10e1\u10d0\u10d0\u10db\u10e3\u10e0\u10d8" },
            { "kg", "\u10d9\u10dd\u10dc\u10d2\u10dd" },
            { "Goth", metaValue_got },
            { "ki", "\u10d9\u10d8\u10d9\u10e3\u10d8\u10e3" },
            { "mas", "\u10db\u10d0\u10e1\u10d0\u10d8" },
            { "kj", "\u10d9\u10e3\u10dc\u10d0\u10db\u10d0" },
            { "kk", "\u10e7\u10d0\u10d6\u10d0\u10ee\u10e3\u10e0\u10d8" },
            { "kl", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d2\u10e0\u10d4\u10dc\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "km", metaValue_km },
            { "kn", metaValue_CA },
            { "ko", metaValue_ko },
            { "kr", "\u10d9\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "ks", "\u10e5\u10d0\u10e8\u10db\u10d8\u10e0\u10e3\u10da\u10d8" },
            { "Cirt", "\u10d9\u10d8\u10e0\u10d7\u10d8" },
            { "Avst", metaValue_ae },
            { "ku", "\u10e5\u10e3\u10e0\u10d7\u10e3\u10da\u10d8" },
            { "kv", "\u10d9\u10dd\u10db\u10d8" },
            { "kw", "\u10d9\u10dd\u10e0\u10dc\u10e3\u10da\u10d8" },
            { "ky", "\u10e7\u10d8\u10e0\u10d2\u10d8\u10d6\u10e3\u10da\u10d8" },
            { "snk", "\u10e1\u10dd\u10dc\u10d8\u10dc\u10d9\u10d4" },
            { "la", metaValue_la },
            { "lb", "\u10da\u10e3\u10e5\u10e1\u10d4\u10db\u10d1\u10e3\u10e0\u10d2\u10e3\u10da\u10d8" },
            { "type.nu.mlym", "\u10db\u10d0\u10da\u10d0\u10d8\u10d0\u10da\u10d0\u10db\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "lg", "\u10d2\u10d0\u10dc\u10d3\u10d0" },
            { "Roro", "\u10e0\u10dd\u10dc\u10d2\u10dd\u10e0\u10dd\u10dc\u10d2\u10dd" },
            { "li", "\u10da\u10d8\u10db\u10d1\u10e3\u10e0\u10d2\u10e3\u10da\u10d8" },
            { "Tibt", metaValue_bo },
            { "ln", "\u10da\u10d8\u10dc\u10d2\u10d0\u10da\u10d0" },
            { "fur", "\u10e4\u10e0\u10d8\u10e3\u10da\u10e3\u10e0\u10d8" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u10d1\u10e0\u10d8\u10e2\u10d0\u10dc\u10e3\u10da\u10d8 \u10e1\u10d0\u10d6\u10dd\u10db\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0" },
            { "lt", "\u10da\u10d8\u10d4\u10e2\u10e3\u10d5\u10e3\u10e0\u10d8" },
            { "lu", "\u10da\u10e3\u10d1\u10d0-\u10d9\u10d0\u10e2\u10d0\u10dc\u10d2\u10d0" },
            { "lv", "\u10da\u10d0\u10e2\u10d5\u10d8\u10e3\u10e0\u10d8" },
            { "mg", "\u10db\u10d0\u10da\u10d0\u10d2\u10d0\u10e1\u10d8\u10e3\u10e0\u10d8" },
            { "mh", "\u10db\u10d0\u10e0\u10e8\u10d0\u10da\u10e3\u10e0\u10d8" },
            { "type.co.ducet", "\u10e3\u10dc\u10d8\u10d9\u10dd\u10d3\u10d8\u10e1 \u10dc\u10d0\u10d2\u10e3\u10da\u10d8\u10e1\u10ee\u10db\u10d4\u10d5\u10d8 \u10d3\u10d0\u10ee\u10d0\u10e0\u10d8\u10e1\u10ee\u10d4\u10d1\u10d8\u10e1 \u10d7\u10d0\u10dc\u10db\u10d8\u10db\u10d3\u10d4\u10d5\u10e0\u10dd\u10d1\u10d0" },
            { "mi", "\u10db\u10d0\u10dd\u10e0\u10d8" },
            { "mk", "\u10db\u10d0\u10d9\u10d4\u10d3\u10dd\u10dc\u10e3\u10e0\u10d8" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u10db\u10d0\u10e0\u10d0\u10d7\u10f0\u10d8" },
            { "ms", "\u10db\u10d0\u10da\u10d0\u10d8\u10e3\u10e0\u10d8" },
            { "mt", "\u10db\u10d0\u10da\u10e2\u10e3\u10e0\u10d8" },
            { "my", "\u10d1\u10d8\u10e0\u10db\u10e3\u10da\u10d8" },
            { "Saur", "\u10e1\u10d0\u10e3\u10e0\u10d0\u10e8\u10e2\u10e0\u10d0" },
            { "Armn", metaValue_hy },
            { "mdf", "\u10db\u10dd\u10e5\u10e8\u10d0" },
            { "mde", "\u10db\u10d0\u10d1\u10d0" },
            { "dsb", "\u10e5\u10d5\u10d4\u10db\u10dd\u10e1\u10dd\u10e0\u10d1\u10e3\u10da\u10d8" },
            { "Armi", "\u10d8\u10db\u10de\u10d4\u10e0\u10d8\u10e3\u10da\u10d8 \u10d0\u10e0\u10d0\u10db\u10d4\u10e3\u10da\u10d8" },
            { "na", metaValue_NR },
            { "type.co.search", "\u10d6\u10dd\u10d2\u10d0\u10d3\u10d8 \u10d3\u10d0\u10dc\u10d8\u10e8\u10dc\u10e3\u10da\u10d4\u10d1\u10d8\u10e1 \u10eb\u10d8\u10d4\u10d1\u10d0" },
            { "nb", "\u10dc\u10dd\u10e0\u10d5\u10d4\u10d2\u10d8\u10e3\u10da\u10d8 \u10d1\u10e3\u10d9\u10db\u10dd\u10da\u10d8" },
            { "nd", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10dc\u10d3\u10d4\u10d1\u10d4\u10da\u10d4" },
            { "ne", "\u10dc\u10d4\u10de\u10d0\u10da\u10e3\u10e0\u10d8" },
            { "ng", "\u10dc\u10d3\u10dd\u10dc\u10d2\u10d0" },
            { "nl", "\u10dc\u10d8\u10d3\u10d4\u10e0\u10da\u10d0\u10dc\u10d3\u10e3\u10e0\u10d8" },
            { "nn", "\u10dc\u10dd\u10e0\u10d5\u10d4\u10d2\u10d8\u10e3\u10da\u10d8 \u10dc\u10d8\u10e3\u10dc\u10dd\u10e0\u10e1\u10d9\u10d8" },
            { "no", "\u10dc\u10dd\u10e0\u10d5\u10d4\u10d2\u10d8\u10e3\u10da\u10d8" },
            { "nr", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10dc\u10d3\u10d4\u10d1\u10d4\u10da\u10e3\u10e0\u10d8" },
            { "nv", "\u10dc\u10d0\u10d5\u10d0\u10ee\u10dd" },
            { "kaa", "\u10e7\u10d0\u10e0\u10d0\u10e7\u10d0\u10da\u10e4\u10d0\u10ee\u10e3\u10e0\u10d8" },
            { "ny", "\u10dc\u10d8\u10d0\u10dc\u10ef\u10d0" },
            { "kac", "\u10d9\u10d0\u10e9\u10d8\u10dc\u10d8" },
            { "kab", "\u10d9\u10d0\u10d1\u10d8\u10da\u10e3\u10e0\u10d8" },
            { "oc", "\u10dd\u10e5\u10e1\u10d8\u10e2\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "kaj", "\u10d9\u10d0\u10ef\u10d8" },
            { "kam", "\u10d9\u10d0\u10db\u10d1\u10d0" },
            { "men", metaValue_men },
            { "oj", "\u10dd\u10ef\u10d8\u10d1\u10d5\u10d4" },
            { "mer", "\u10db\u10d4\u10e0\u10e3" },
            { "type.nu.armn", "\u10e1\u10dd\u10db\u10ee\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "om", "\u10dd\u10e0\u10dd\u10db\u10dd" },
            { "or", metaValue_or },
            { "os", "\u10dd\u10e1\u10e3\u10e0\u10d8" },
            { "kbd", "\u10e7\u10d0\u10d1\u10d0\u10e0\u10d3\u10dd\u10e3\u10da\u10d8" },
            { "mfe", "\u10db\u10dd\u10e0\u10d8\u10e1\u10d8\u10d4\u10dc\u10d8" },
            { "srn", "\u10e1\u10e0\u10d0\u10dc\u10d0\u10dc \u10e2\u10dd\u10dc\u10d2\u10dd" },
            { "pa", "\u10de\u10d4\u10dc\u10ef\u10d0\u10d1\u10e3\u10e0\u10d8" },
            { "dua", "\u10d3\u10e3\u10d0\u10da\u10d0" },
            { "pi", "\u10de\u10d0\u10da\u10d8" },
            { "pl", "\u10de\u10dd\u10da\u10dd\u10dc\u10e3\u10e0\u10d8" },
            { "dum", "\u10e1\u10d0\u10e8\u10e3\u10d0\u10da\u10dd \u10f0\u10dd\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "type.nu.saur", "\u10e1\u10d0\u10e3\u10e0\u10d0\u10e8\u10e2\u10e0\u10e3\u10da\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "type.ca.dangi", "\u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8 \u10d3\u10d0\u10dc\u10d2\u10d8" },
            { "ps", "\u10de\u10e3\u10e8\u10e2\u10e3" },
            { "pt", "\u10de\u10dd\u10e0\u10e2\u10e3\u10d2\u10d0\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "mga", "\u10e1\u10d0\u10e8\u10e3\u10d0\u10da\u10dd \u10d8\u10e0\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "key.co", "\u10d3\u10d0\u10ee\u10d0\u10e0\u10d8\u10e1\u10ee\u10d4\u10d1\u10d8\u10e1 \u10d7\u10d0\u10dc\u10db\u10d8\u10db\u10d3\u10d4\u10d5\u10e0\u10dd\u10d1\u10d0" },
            { "pt_BR", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10e3\u10e0\u10d8 \u10de\u10dd\u10e0\u10e2\u10e3\u10d2\u10d0\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "kcg", "\u10e2\u10d8\u10d0\u10de\u10d8" },
            { "mgh", "\u10db\u10d0\u10e5\u10e3\u10d5\u10d0-\u10db\u10d4\u10d4\u10e2\u10dd" },
            { "key.cf", "\u10d5\u10d0\u10da\u10e3\u10e2\u10d8\u10e1 \u10e4\u10dd\u10e0\u10db\u10d0\u10e2\u10d8" },
            { "bra", "\u10d1\u10e0\u10d0\u10ef\u10d8" },
            { "key.ca", "\u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u10db\u10d4\u10e2\u10d0-\u10d4\u10dc\u10d0" },
            { "type.hc.h23", "24-\u10e1\u10d0\u10d0\u10d7\u10d8\u10d0\u10dc\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0 (0-23)" },
            { "type.hc.h24", "24-\u10e1\u10d0\u10d0\u10d7\u10d8\u10d0\u10dc\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0 (1-24)" },
            { "ssy", "\u10e1\u10d0\u10f0\u10dd" },
            { "type.nu.mymr", "\u10db\u10d8\u10d0\u10dc\u10db\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "qu", "\u10d9\u10d4\u10e9\u10e3\u10d0" },
            { "brx", "\u10d1\u10dd\u10d3\u10dd" },
            { "kde", "\u10db\u10d0\u10d9\u10dd\u10dc\u10d3\u10d4" },
            { "Ethi", "\u10d4\u10d7\u10d8\u10dd\u10de\u10d8\u10e3\u10e0\u10d8" },
            { "type.hc.h12", "12-\u10e1\u10d0\u10d0\u10d7\u10d8\u10d0\u10dc\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0 (1-12)" },
            { "type.hc.h11", "12-\u10e1\u10d0\u10d0\u10d7\u10d8\u10d0\u10dc\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0 (0-11)" },
            { "rm", "\u10e0\u10d4\u10e2\u10dd\u10e0\u10dd\u10db\u10d0\u10dc\u10e3\u10da\u10d8" },
            { "rn", "\u10e0\u10e3\u10dc\u10d3\u10d8" },
            { "key.cu", "\u10d5\u10d0\u10da\u10e3\u10e2\u10d0" },
            { "ro", "\u10e0\u10e3\u10db\u10d8\u10dc\u10e3\u10da\u10d8" },
            { "type.nu.orya", "\u10dd\u10e0\u10d8\u10e3\u10da\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "type.nu.hanidec", "\u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10d0\u10d7\u10dd\u10d1\u10d8\u10d7\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "ru", "\u10e0\u10e3\u10e1\u10e3\u10da\u10d8" },
            { "zbl", metaValue_zbl },
            { "rw", "\u10d9\u10d8\u10dc\u10d8\u10d0\u10e0\u10e3\u10d0\u10dc\u10d3\u10d0" },
            { "kea", "\u10d9\u10d0\u10d1\u10e3\u10d5\u10d4\u10e0\u10d3\u10d8\u10d0\u10dc\u10e3" },
            { "mic", "\u10db\u10d8\u10d9\u10db\u10d0\u10d9\u10d8" },
            { "suk", "\u10e1\u10e3\u10d9\u10e3\u10db\u10d0" },
            { "en_AU", "\u10d0\u10d5\u10e1\u10e2\u10e0\u10d0\u10da\u10d8\u10e3\u10e0\u10d8 \u10d8\u10dc\u10d2\u10da\u10d8\u10e1\u10e3\u10e0\u10d8" },
            { "Dupl", "\u10d3\u10e3\u10de\u10da\u10dd\u10d8\u10e1 \u10e1\u10e2\u10d4\u10dc\u10dd\u10d2\u10e0\u10d0\u10e4\u10d8\u10d0" },
            { "sa", "\u10e1\u10d0\u10dc\u10e1\u10d9\u10e0\u10d8\u10e2\u10d8" },
            { "sc", "\u10e1\u10d0\u10e0\u10d3\u10d8\u10dc\u10d8\u10e3\u10da\u10d8" },
            { "sd", "\u10e1\u10d8\u10dc\u10d3\u10f0\u10e3\u10e0\u10d8" },
            { "se", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10e1\u10d0\u10d0\u10db\u10e3\u10e0\u10d8" },
            { "min", "\u10db\u10d8\u10dc\u10d0\u10dc\u10d2\u10d9\u10d0\u10d1\u10d0\u10e3" },
            { "sg", "\u10e1\u10d0\u10dc\u10d2\u10dd" },
            { "sh", "\u10e1\u10d4\u10e0\u10d1\u10e3\u10da-\u10ee\u10dd\u10e0\u10d5\u10d0\u10e2\u10e3\u10da\u10d8" },
            { "si", metaValue_si },
            { "sux", "\u10e8\u10e3\u10db\u10d4\u10e0\u10e3\u10da\u10d8" },
            { "sk", "\u10e1\u10da\u10dd\u10d5\u10d0\u10d9\u10e3\u10e0\u10d8" },
            { "sl", "\u10e1\u10da\u10dd\u10d5\u10d4\u10dc\u10e3\u10e0\u10d8" },
            { "Gran", "\u10d2\u10e0\u10d0\u10dc\u10d7\u10d0" },
            { "sm", metaValue_WS },
            { "sn", "\u10e8\u10dd\u10dc\u10d0" },
            { "so", "\u10e1\u10dd\u10db\u10d0\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "type.nu.arab", "\u10d0\u10e0\u10d0\u10d1\u10e3\u10da-\u10d8\u10dc\u10d3\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "sq", "\u10d0\u10da\u10d1\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "sr", "\u10e1\u10d4\u10e0\u10d1\u10e3\u10da\u10d8" },
            { "ss", "\u10e1\u10e3\u10d0\u10e2\u10d8" },
            { "type.cf.account", "\u10d5\u10d0\u10da\u10e3\u10e2\u10d8\u10e1 \u10d1\u10e3\u10e6\u10d0\u10da\u10e2\u10e0\u10e3\u10da\u10d8 \u10e4\u10dd\u10e0\u10db\u10d0\u10e2\u10d8" },
            { "Java", metaValue_jv },
            { "st", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10e1\u10dd\u10d7\u10dd\u10e1 \u10d4\u10dc\u10d0" },
            { "su", "\u10e1\u10e3\u10dc\u10d3\u10e3\u10e0\u10d8" },
            { "sv", "\u10e8\u10d5\u10d4\u10d3\u10e3\u10e0\u10d8" },
            { "sw", "\u10e1\u10e3\u10d0\u10f0\u10d8\u10da\u10d8" },
            { "type.nu.hantfin", "\u10e2\u10e0\u10d0\u10d3\u10d8\u10ea\u10d8\u10e3\u10da\u10d8 \u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10e4\u10d8\u10dc\u10d0\u10dc\u10e1\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "ibb", "\u10d8\u10d1\u10d8\u10d1\u10d8\u10dd" },
            { "iba", "\u10d8\u10d1\u10d0\u10dc\u10d8" },
            { "ta", metaValue_ta },
            { "142", "\u10d0\u10d6\u10d8\u10d0" },
            { "bua", "\u10d1\u10e3\u10e0\u10d8\u10d0\u10e2\u10e3\u10da\u10d8" },
            { "143", "\u10ea\u10d4\u10dc\u10e2\u10e0\u10d0\u10da\u10e3\u10e0\u10d8 \u10d0\u10d6\u10d8\u10d0" },
            { "te", metaValue_te },
            { "145", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d0\u10d6\u10d8\u10d0" },
            { "tg", "\u10e2\u10d0\u10ef\u10d8\u10d9\u10e3\u10e0\u10d8" },
            { "th", metaValue_th },
            { "ti", "\u10e2\u10d8\u10d2\u10e0\u10d8\u10dc\u10d8\u10d0" },
            { "bug", "\u10d1\u10e3\u10d2\u10d8\u10dc\u10e3\u10e0\u10d8" },
            { "kfo", "\u10d9\u10dd\u10e0\u10dd" },
            { "en_CA", "\u10d9\u10d0\u10dc\u10d0\u10d3\u10e3\u10e0\u10d8 \u10d8\u10dc\u10d2\u10da\u10d8\u10e1\u10e3\u10e0\u10d8" },
            { "tk", "\u10d7\u10e3\u10e0\u10e5\u10db\u10d4\u10dc\u10e3\u10da\u10d8" },
            { "tn", "\u10e2\u10e1\u10d5\u10d0\u10dc\u10d0" },
            { "to", "\u10e2\u10dd\u10dc\u10d2\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "dyo", "\u10d3\u10d8\u10dd\u10da\u10d0" },
            { "type.nu.jpan", "\u10d8\u10d0\u10de\u10dd\u10dc\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "tr", "\u10d7\u10e3\u10e0\u10e5\u10e3\u10da\u10d8" },
            { "Cakm", metaValue_ccp },
            { "ts", "\u10e2\u10e1\u10dd\u10dc\u10d2\u10d0" },
            { "swb", "\u10d9\u10dd\u10db\u10dd\u10e0\u10e3\u10da\u10d8" },
            { "tt", "\u10d7\u10d0\u10d7\u10e0\u10e3\u10da\u10d8" },
            { "dyu", "\u10d3\u10d8\u10e3\u10da\u10d0" },
            { "tw", "\u10d7\u10e3\u10d8" },
            { "ty", "\u10e2\u10d0\u10d8\u10e2\u10e3\u10e0\u10d8" },
            { "150", "\u10d4\u10d5\u10e0\u10dd\u10de\u10d0" },
            { "151", "\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d4\u10d5\u10e0\u10dd\u10de\u10d0" },
            { "154", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10d4\u10d5\u10e0\u10dd\u10de\u10d0" },
            { "dzg", "\u10d3\u10d0\u10d6\u10d0\u10d2\u10d0" },
            { "155", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d4\u10d5\u10e0\u10dd\u10de\u10d0" },
            { "ug", "\u10e3\u10d8\u10e6\u10e3\u10e0\u10e3\u10da\u10d8" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u10d6\u10dd\u10d2\u10d0\u10d3\u10d8" },
            { "uk", "\u10e3\u10d9\u10e0\u10d0\u10d8\u10dc\u10e3\u10da\u10d8" },
            { "ur", "\u10e3\u10e0\u10d3\u10e3" },
            { "xal", "\u10e7\u10d0\u10da\u10db\u10e3\u10ee\u10e3\u10e0\u10d8" },
            { "zen", "\u10d6\u10d4\u10dc\u10d0\u10d2\u10d0" },
            { "uz", "\u10e3\u10d6\u10d1\u10d4\u10d9\u10e3\u10e0\u10d8" },
            { "kha", "\u10ee\u10d0\u10e1\u10d8" },
            { "nds_NL", "\u10e5\u10d5\u10d4\u10db\u10dd\u10e1\u10d0\u10e5\u10e1\u10dd\u10dc\u10e3\u10e0\u10d8" },
            { "Sylo", "\u10e1\u10d8\u10da\u10dd\u10e2\u10d8 \u10dc\u10d0\u10d2\u10e0\u10d8" },
            { "ve", "\u10d5\u10d4\u10dc\u10d3\u10d0" },
            { "Wara", "\u10d5\u10d0\u10e0\u10d0\u10dc\u10d2-\u10d9\u10e8\u10d8\u10e2\u10d8" },
            { "type.ca.roc", "\u10e9\u10d8\u10dc\u10d4\u10d7\u10d8\u10e1 \u10e0\u10d4\u10e1\u10de\u10e3\u10d1\u10da\u10d8\u10d9\u10d8\u10e1 \u10d9\u10d0\u10da\u10d4\u10dc\u10d3\u10d0\u10e0\u10d8" },
            { "vi", "\u10d5\u10d8\u10d4\u10e2\u10dc\u10d0\u10db\u10e3\u10e0\u10d8" },
            { "khq", "\u10d9\u10dd\u10d8\u10e0\u10d0-\u10e9\u10d8\u10d8\u10dc\u10d8" },
            { "key.hc", "\u10d3\u10e0\u10dd\u10d8\u10e1 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0 (12 \u10d0\u10dc 24)" },
            { "vo", "\u10d5\u10dd\u10da\u10d0\u10de\u10e3\u10d9\u10d8" },
            { "syc", "\u10d9\u10da\u10d0\u10e1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10e1\u10d8\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "Osma", "\u10dd\u10e1\u10db\u10d0\u10dc\u10d8\u10d0" },
            { "quc", "\u10d9\u10d8\u10e9\u10d4" },
            { "gaa", "\u10d2\u10d0" },
            { "wa", "\u10d5\u10d0\u10da\u10dd\u10dc\u10e3\u10e0\u10d8" },
            { "gag", "\u10d2\u10d0\u10d2\u10d0\u10e3\u10d6\u10e3\u10e0\u10d8" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "\u10da\u10d8\u10d3\u10d8\u10e3\u10e0\u10d8" },
            { "Xsux", "\u10e8\u10e3\u10db\u10d4\u10e0\u10e3\u10da-\u10d0\u10e5\u10d0\u10d3\u10e3\u10e0\u10d8 \u10da\u10e3\u10e0\u10e1\u10db\u10dc\u10e3\u10da\u10d8" },
            { "wo", "\u10d5\u10dd\u10da\u10dd\u10e4\u10e3\u10e0\u10d8" },
            { "zgh", "\u10e1\u10e2\u10d0\u10dc\u10d3\u10d0\u10e0\u10e2\u10e3\u10da\u10d8 \u10db\u10d0\u10e0\u10dd\u10d9\u10dd\u10e3\u10da\u10d8 \u10e2\u10d0\u10db\u10d0\u10d6\u10d8\u10d2\u10ee\u10e2\u10d8" },
            { "ar_001", "\u10d7\u10d0\u10dc\u10d0\u10db\u10d4\u10d3\u10e0\u10dd\u10d5\u10d4 \u10e1\u10e2\u10d0\u10dc\u10d3\u10d0\u10e0\u10e2\u10e3\u10da\u10d8 \u10d0\u10e0\u10d0\u10d1\u10e3\u10da\u10d8" },
            { "Mong", metaValue_mn },
            { "mnc", "\u10db\u10d0\u10dc\u10ef\u10e3\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "Hluw", "\u10d0\u10dc\u10d0\u10e2\u10dd\u10da\u10d8\u10e3\u10e0\u10d8 \u10d8\u10d4\u10e0\u10dd\u10d2\u10da\u10d8\u10e4\u10e3\u10e0\u10d8" },
            { "gba", "\u10d2\u10d1\u10d0\u10d8\u10d0" },
            { "mni", "\u10db\u10d0\u10dc\u10d8\u10de\u10e3\u10e0\u10d8" },
            { "Latn", metaValue_la },
            { "Latg", "\u10d2\u10d4\u10da\u10e3\u10e0\u10d8 \u10da\u10d0\u10d7\u10d8\u10dc\u10e3\u10e0\u10d8" },
            { "type.nu.hans", "\u10d2\u10d0\u10db\u10d0\u10e0\u10e2\u10d8\u10d5\u10d4\u10d1\u10e3\u10da\u10d8 \u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "type.nu.hant", "\u10e2\u10e0\u10d0\u10d3\u10d8\u10ea\u10d8\u10e3\u10da\u10d8 \u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "xh", "\u10e5\u10f0\u10dd\u10e1\u10d0" },
            { "type.nu.romanlow", "\u10e0\u10dd\u10db\u10d0\u10e3\u10da\u10d8 \u10e5\u10d5\u10d4\u10d3\u10d0 \u10e0\u10d4\u10d2\u10d8\u10e1\u10e2\u10e0\u10d8\u10e1 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "byn", "\u10d1\u10d8\u10da\u10d8\u10dc\u10d8" },
            { "Lyci", "\u10da\u10d8\u10d9\u10d8\u10e3\u10e0\u10d8" },
            { "moh", "\u10db\u10dd\u10f0\u10d0\u10e3\u10d9\u10e3\u10e0\u10d8" },
            { "kkj", "\u10d9\u10d0\u10d9\u10dd" },
            { "Syrc", metaValue_syr },
            { "yi", "\u10d8\u10d3\u10d8\u10e8\u10d8" },
            { "mos", "\u10db\u10dd\u10e1\u10d8" },
            { "Dsrt", "\u10d3\u10d4\u10d6\u10d4\u10e0\u10d4\u10e2\u10d8\u10e1" },
            { "yo", "\u10d8\u10dd\u10e0\u10e3\u10d1\u10d0" },
            { "es_MX", "\u10db\u10d4\u10e5\u10e1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d4\u10e1\u10de\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "Syrj", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7\u10d8 \u10e1\u10d8\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "Syre", "\u10e1\u10d8\u10e0\u10d8\u10e3\u10da\u10d8 \u10d4\u10e1\u10e2\u10e0\u10d0\u10dc\u10d2\u10d4\u10da\u10dd" },
            { "vai", metaValue_vai },
            { "Cari", "\u10d9\u10d0\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "kln", "\u10d9\u10d0\u10da\u10d4\u10dc\u10ef\u10d8\u10dc\u10d8" },
            { "zh", "\u10e9\u10d8\u10dc\u10e3\u10e0\u10d8" },
            { "Afak", "\u10d0\u10e4\u10d0\u10d9\u10d0" },
            { "Bopo", "\u10d1\u10dd\u10de\u10dd\u10db\u10dd\u10e4\u10dd" },
            { "Perm", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10de\u10d4\u10e0\u10db\u10e3\u10da\u10d8" },
            { "key.lb", "\u10e1\u10e2\u10e0\u10d8\u10e5\u10dd\u10dc\u10d8\u10e1 \u10ec\u10e7\u10d5\u10d4\u10e2\u10d8\u10e1 \u10e1\u10e2\u10d8\u10da\u10d8" },
            { "zu", "\u10d6\u10e3\u10da\u10e3" },
            { "Geor", metaValue_ka },
            { "Shrd", "\u10e8\u10d0\u10e0\u10d0\u10d3\u10d0" },
            { "kmb", "\u10d9\u10d8\u10db\u10d1\u10e3\u10dc\u10d3\u10e3" },
            { "type.nu.jpanfin", "\u10d8\u10d0\u10de\u10dd\u10dc\u10e3\u10e0\u10d8 \u10e4\u10d8\u10dc\u10d0\u10dc\u10e1\u10e3\u10e0\u10d8 \u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "Cham", "\u10e9\u10d0\u10db\u10d8" },
            { "gez", "\u10d2\u10d4\u10d4\u10d6\u10d8" },
            { "Syrn", "\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7\u10d8 \u10e1\u10d8\u10e0\u10d8\u10e3\u10da\u10d8" },
            { "Narb", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7-\u10d0\u10e0\u10d0\u10d1\u10e3\u10da\u10d8" },
            { "Egyd", "\u10d4\u10d2\u10d5\u10d8\u10de\u10e2\u10e3\u10e0\u10d8 \u10d3\u10d4\u10db\u10dd\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8" },
            { "Egyh", "\u10d4\u10d2\u10d5\u10d8\u10de\u10e2\u10e3\u10e0\u10d8 \u10d8\u10d4\u10e0\u10d0\u10e2\u10d8\u10d9\u10e3\u10da\u10d8" },
            { "Palm", "\u10de\u10d0\u10da\u10db\u10d8\u10e0\u10e3\u10da\u10d8" },
            { "ebu", "\u10d4\u10db\u10d1\u10e3" },
            { "Egyp", "\u10d4\u10d2\u10d5\u10d8\u10de\u10e2\u10e3\u10e0\u10d8 \u10d8\u10d4\u10e0\u10dd\u10d2\u10da\u10d8\u10e4\u10e3\u10e0\u10d8" },
            { "Geok", "\u10ee\u10e3\u10ea\u10e3\u10e0\u10d8" },
            { "zh_Hans", metaValue_zh_Hans },
            { "koi", "\u10d9\u10dd\u10db\u10d8-\u10de\u10d4\u10e0\u10db\u10d8\u10d0\u10d9\u10e3\u10da\u10d8" },
            { "Hung", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e3\u10dc\u10d2\u10e0\u10e3\u10da\u10d8" },
            { "kok", "\u10d9\u10dd\u10dc\u10d9\u10d0\u10dc\u10d8" },
            { "kos", "\u10d9\u10e3\u10e1\u10d0\u10d8\u10d4" },
            { "type.nu.limb", "\u10da\u10d8\u10db\u10d1\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "zh_Hant", metaValue_zh_Hant },
            { "Sund", "\u10e1\u10e3\u10dc\u10d3\u10d0\u10dc\u10e3\u10e0\u10d8" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "\u10e5\u10ee\u10db\u10d4\u10e0\u10e3\u10da\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "Tirh", "\u10e2\u10d8\u10e0\u10f0\u10e3\u10e2\u10d0" },
            { "ilo", "\u10d8\u10da\u10dd\u10d9\u10dd" },
            { "Cprt", "\u10d9\u10d5\u10d8\u10de\u10e0\u10dd\u10e1\u10e3\u10da\u10d8" },
            { "mua", "\u10db\u10e3\u10dc\u10d3\u10d0\u10dc\u10d2\u10d8" },
            { "type.nu.guru", "\u10d2\u10e3\u10e0\u10db\u10e3\u10ee\u10e3\u10da\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "mul", "\u10e1\u10ee\u10d5\u10d0\u10d3\u10d0\u10e1\u10ee\u10d5\u10d0 \u10d4\u10dc\u10d0" },
            { "key.ms", "\u10e1\u10d0\u10d6\u10dd\u10db\u10d8 \u10e1\u10d8\u10e1\u10e2\u10d4\u10db\u10d0" },
            { "mus", "\u10d9\u10e0\u10d8\u10d9\u10d8" },
            { "Glag", "\u10d2\u10da\u10d0\u10d2\u10dd\u10da\u10d8\u10ea\u10d0" },
            { "gil", "\u10d2\u10d8\u10da\u10d1\u10d4\u10e0\u10e2\u10e3\u10da\u10d8" },
            { "Cher", metaValue_chr },
            { "cay", "\u10d9\u10d0\u10d8\u10e3\u10d2\u10d0" },
            { "type.nu.tamldec", "\u10e2\u10d0\u10db\u10d8\u10da\u10e3\u10e0\u10d8 \u10ea\u10d8\u10e4\u10e0\u10d4\u10d1\u10d8" },
            { "krc", "\u10e7\u10d0\u10e0\u10d0\u10e9\u10d0\u10e3\u10da-\u10d1\u10d0\u10da\u10e7\u10d0\u10e0\u10e3\u10da\u10d8" },
            { "inh", "\u10d8\u10dc\u10d2\u10e3\u10e8\u10e3\u10e0\u10d8" },
            { "fa_AF", "\u10d3\u10d0\u10e0\u10d8" },
            { "krl", "\u10d9\u10d0\u10e0\u10d4\u10da\u10d8\u10e3\u10e0\u10d8" },
            { "efi", "\u10d4\u10e4\u10d8\u10d9\u10d8" },
            { "key.nu", "\u10e0\u10d8\u10ea\u10ee\u10d5\u10d4\u10d1\u10d8" },
            { "kru", "\u10d9\u10e3\u10e0\u10e3\u10e5\u10d8" },
            { "ksb", "\u10e8\u10d0\u10db\u10d1\u10d0\u10da\u10d0" },
            { "Telu", metaValue_te },
            { "ksf", "\u10d1\u10d0\u10e4\u10d8\u10d0" },
        };
        return data;
    }
}
