/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juli.logging.Log;

class DirectJDKLog
implements Log {
    public Logger logger;
    private static final String SIMPLE_FMT = "java.util.logging.SimpleFormatter";
    private static final String FORMATTER = "org.apache.juli.formatter";

    public DirectJDKLog(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public final boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public final boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public final boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public final boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public final void debug(Object object) {
        this.log(Level.FINE, String.valueOf(object), null);
    }

    @Override
    public final void debug(Object object, Throwable throwable) {
        this.log(Level.FINE, String.valueOf(object), throwable);
    }

    @Override
    public final void trace(Object object) {
        this.log(Level.FINER, String.valueOf(object), null);
    }

    @Override
    public final void trace(Object object, Throwable throwable) {
        this.log(Level.FINER, String.valueOf(object), throwable);
    }

    @Override
    public final void info(Object object) {
        this.log(Level.INFO, String.valueOf(object), null);
    }

    @Override
    public final void info(Object object, Throwable throwable) {
        this.log(Level.INFO, String.valueOf(object), throwable);
    }

    @Override
    public final void warn(Object object) {
        this.log(Level.WARNING, String.valueOf(object), null);
    }

    @Override
    public final void warn(Object object, Throwable throwable) {
        this.log(Level.WARNING, String.valueOf(object), throwable);
    }

    @Override
    public final void error(Object object) {
        this.log(Level.SEVERE, String.valueOf(object), null);
    }

    @Override
    public final void error(Object object, Throwable throwable) {
        this.log(Level.SEVERE, String.valueOf(object), throwable);
    }

    @Override
    public final void fatal(Object object) {
        this.log(Level.SEVERE, String.valueOf(object), null);
    }

    @Override
    public final void fatal(Object object, Throwable throwable) {
        this.log(Level.SEVERE, String.valueOf(object), throwable);
    }

    private void log(Level level, String string, Throwable throwable) {
        if (this.logger.isLoggable(level)) {
            Throwable throwable2 = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            String string2 = "unknown";
            String string3 = "unknown";
            if (stackTraceElementArray != null && stackTraceElementArray.length > 2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[2];
                string2 = stackTraceElement.getClassName();
                string3 = stackTraceElement.getMethodName();
            }
            if (throwable == null) {
                this.logger.logp(level, string2, string3, string);
            } else {
                this.logger.logp(level, string2, string3, string, throwable);
            }
        }
    }

    static void release() {
    }

    static Log getInstance(String string) {
        return new DirectJDKLog(string);
    }

    static {
        if (System.getProperty("java.util.logging.config.class") == null && System.getProperty("java.util.logging.config.file") == null) {
            try {
                Formatter formatter = (Formatter)Class.forName(System.getProperty(FORMATTER, SIMPLE_FMT)).getConstructor(new Class[0]).newInstance(new Object[0]);
                Logger logger = Logger.getLogger("");
                for (Handler handler : logger.getHandlers()) {
                    if (!(handler instanceof ConsoleHandler)) continue;
                    handler.setFormatter(formatter);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

