/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre7Compat;
import org.apache.tomcat.util.res.StringManager;

class Jre8Compat
extends Jre7Compat {
    private static final Log log = LogFactory.getLog(Jre8Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre8Compat.class);
    private static final int RUNTIME_MAJOR_VERSION = 8;
    private static final Method getSSLParametersMethod;
    private static final Method setUseCipherSuitesOrderMethod;
    private static final Method setSSLParametersMethod;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLServerSocket sSLServerSocket, boolean bl) {
        try {
            Object object = getSSLParametersMethod.invoke((Object)sSLServerSocket, new Object[0]);
            setUseCipherSuitesOrderMethod.invoke(object, bl);
            setSSLParametersMethod.invoke((Object)sSLServerSocket, object);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLEngine sSLEngine, boolean bl) {
        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
        try {
            setUseCipherSuitesOrderMethod.invoke((Object)sSLParameters, bl);
            sSLEngine.setSSLParameters(sSLParameters);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 8;
    }

    static {
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        try {
            Class<?> clazz = Class.forName("javax.net.ssl.SSLParameters");
            method = clazz.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            method2 = SSLServerSocket.class.getMethod("getSSLParameters", new Class[0]);
            method3 = SSLServerSocket.class.getMethod("setSSLParameters", clazz);
        }
        catch (SecurityException securityException) {
            log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (method == null) {
                log.debug((Object)sm.getString("jre8Compat.javaPre8"), (Throwable)noSuchMethodException);
            } else {
                log.error((Object)sm.getString("jre8Compat.unexpected"), (Throwable)noSuchMethodException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug((Object)sm.getString("jre8Compat.javaPre7"), (Throwable)classNotFoundException);
        }
        setUseCipherSuitesOrderMethod = method;
        getSSLParametersMethod = method2;
        setSSLParametersMethod = method3;
    }
}

