/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.PooledSender;
import org.apache.catalina.tribes.transport.nio.ParallelNioSender;

public class PooledParallelSender
extends PooledSender {
    protected boolean connected = true;

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage) throws ChannelException {
        if (!this.connected) {
            throw new ChannelException("Sender not connected.");
        }
        ParallelNioSender parallelNioSender = (ParallelNioSender)this.getSender();
        if (parallelNioSender == null) {
            ChannelException channelException = new ChannelException("Unable to retrieve a data sender, time out(" + this.getMaxWait() + " ms) error.");
            for (Member member : memberArray) {
                channelException.addFaultyMember(member, new NullPointerException("Unable to retrieve a sender from the sender pool"));
            }
            throw channelException;
        }
        try {
            if (!parallelNioSender.isConnected()) {
                parallelNioSender.connect();
            }
            parallelNioSender.sendMessage(memberArray, channelMessage);
            parallelNioSender.keepalive();
        }
        catch (ChannelException channelException) {
            parallelNioSender.disconnect();
            throw channelException;
        }
        finally {
            this.returnSender(parallelNioSender);
            if (!this.connected) {
                this.disconnect();
            }
        }
    }

    @Override
    public DataSender getNewDataSender() {
        try {
            ParallelNioSender parallelNioSender = new ParallelNioSender();
            AbstractSender.transferProperties(this, parallelNioSender);
            return parallelNioSender;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to open NIO selector.", iOException);
        }
    }

    @Override
    public synchronized void disconnect() {
        this.connected = false;
        super.disconnect();
    }

    @Override
    public synchronized void connect() throws IOException {
        this.connected = true;
        super.connect();
    }
}

