/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometFilter;
import org.apache.catalina.comet.CometFilterChain;
import org.apache.catalina.comet.CometProcessor;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.InstanceSupport;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

final class ApplicationFilterChain
implements FilterChain,
CometFilterChain {
    private static final ThreadLocal<ServletRequest> lastServicedRequest;
    private static final ThreadLocal<ServletResponse> lastServicedResponse;
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private static final StringManager sm;
    private InstanceSupport support = null;
    private static Class<?>[] classType;
    private static Class<?>[] classTypeUsedInService;
    private static Class<?>[] cometClassType;
    private static Class<?>[] classTypeUsedInEvent;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final ServletRequest servletRequest2 = servletRequest;
            final ServletResponse servletResponse2 = servletResponse;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(servletRequest2, servletResponse2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new ServletException(exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.internalDoFilter(servletRequest, servletResponse);
        }
    }

    private void internalDoFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig applicationFilterConfig = this.filters[this.pos++];
            Filter filter = null;
            try {
                filter = applicationFilterConfig.getFilter();
                this.support.fireInstanceEvent("beforeFilter", filter, servletRequest, servletResponse);
                if (servletRequest.isAsyncSupported() && "false".equalsIgnoreCase(applicationFilterConfig.getFilterDef().getAsyncSupported())) {
                    servletRequest.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)Boolean.FALSE);
                }
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest servletRequest2 = servletRequest;
                    ServletResponse servletResponse2 = servletResponse;
                    Principal principal = ((HttpServletRequest)servletRequest2).getUserPrincipal();
                    Object[] objectArray = new Object[]{servletRequest2, servletResponse2, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, classType, objectArray, principal);
                } else {
                    filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
                }
                this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse);
            }
            catch (IOException iOException) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, (Throwable)iOException);
                }
                throw iOException;
            }
            catch (ServletException servletException) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, (Throwable)servletException);
                }
                throw servletException;
            }
            catch (RuntimeException runtimeException) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, (Throwable)runtimeException);
                }
                throw runtimeException;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, servletRequest, servletResponse, throwable2);
                }
                throw new ServletException(sm.getString("filterChain.filter"), throwable2);
            }
            return;
        }
        try {
            if (ApplicationDispatcher.WRAP_SAME_OBJECT) {
                lastServicedRequest.set(servletRequest);
                lastServicedResponse.set(servletResponse);
            }
            this.support.fireInstanceEvent("beforeService", this.servlet, servletRequest, servletResponse);
            if (servletRequest.isAsyncSupported() && !this.support.getWrapper().isAsyncSupported()) {
                servletRequest.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)Boolean.FALSE);
            }
            if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
                if (Globals.IS_SECURITY_ENABLED) {
                    ServletRequest servletRequest3 = servletRequest;
                    ServletResponse servletResponse3 = servletResponse;
                    Principal principal = ((HttpServletRequest)servletRequest3).getUserPrincipal();
                    Object[] objectArray = new Object[]{servletRequest3, servletResponse3};
                    SecurityUtil.doAsPrivilege("service", this.servlet, classTypeUsedInService, objectArray, principal);
                } else {
                    this.servlet.service(servletRequest, servletResponse);
                }
            } else {
                this.servlet.service(servletRequest, servletResponse);
            }
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse);
        }
        catch (IOException iOException) {
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, (Throwable)iOException);
            throw iOException;
        }
        catch (ServletException servletException) {
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, (Throwable)servletException);
            throw servletException;
        }
        catch (RuntimeException runtimeException) {
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.support.fireInstanceEvent("afterService", this.servlet, servletRequest, servletResponse, throwable);
            throw new ServletException(sm.getString("filterChain.servlet"), throwable);
        }
        finally {
            if (ApplicationDispatcher.WRAP_SAME_OBJECT) {
                lastServicedRequest.set(null);
                lastServicedResponse.set(null);
            }
        }
    }

    @Override
    public void doFilterEvent(CometEvent cometEvent) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final CometEvent cometEvent2 = cometEvent;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilterEvent(cometEvent2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new ServletException(exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.internalDoFilterEvent(cometEvent);
        }
    }

    public static ServletRequest getLastServicedRequest() {
        return lastServicedRequest.get();
    }

    public static ServletResponse getLastServicedResponse() {
        return lastServicedResponse.get();
    }

    private void internalDoFilterEvent(CometEvent cometEvent) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig applicationFilterConfig = this.filters[this.pos++];
            CometFilter cometFilter = null;
            try {
                cometFilter = (CometFilter)applicationFilterConfig.getFilter();
                if (Globals.IS_SECURITY_ENABLED) {
                    CometEvent cometEvent2 = cometEvent;
                    Principal principal = cometEvent2.getHttpServletRequest().getUserPrincipal();
                    Object[] objectArray = new Object[]{cometEvent2, this};
                    SecurityUtil.doAsPrivilege("doFilterEvent", cometFilter, cometClassType, objectArray, principal);
                } else {
                    cometFilter.doFilterEvent(cometEvent, this);
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (ServletException servletException) {
                throw servletException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                throw new ServletException(sm.getString("filterChain.filter"), throwable2);
            }
            return;
        }
        try {
            if (Globals.IS_SECURITY_ENABLED) {
                CometEvent cometEvent3 = cometEvent;
                Principal principal = cometEvent3.getHttpServletRequest().getUserPrincipal();
                Object[] objectArray = new Object[]{cometEvent3};
                SecurityUtil.doAsPrivilege("event", this.servlet, classTypeUsedInEvent, objectArray, principal);
            } else {
                ((CometProcessor)this.servlet).event(cometEvent);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            throw new ServletException(sm.getString("filterChain.servlet"), throwable);
        }
    }

    void addFilter(ApplicationFilterConfig applicationFilterConfig) {
        for (ApplicationFilterConfig applicationFilterConfig2 : this.filters) {
            if (applicationFilterConfig2 != applicationFilterConfig) continue;
            return;
        }
        if (this.n == this.filters.length) {
            ApplicationFilterConfig[] applicationFilterConfigArray = new ApplicationFilterConfig[this.n + 10];
            System.arraycopy(this.filters, 0, applicationFilterConfigArray, 0, this.n);
            this.filters = applicationFilterConfigArray;
        }
        this.filters[this.n++] = applicationFilterConfig;
    }

    void release() {
        for (int i = 0; i < this.n; ++i) {
            this.filters[i] = null;
        }
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.support = null;
    }

    void reuse() {
        this.pos = 0;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setSupport(InstanceSupport instanceSupport) {
        this.support = instanceSupport;
    }

    static {
        if (ApplicationDispatcher.WRAP_SAME_OBJECT) {
            lastServicedRequest = new ThreadLocal();
            lastServicedResponse = new ThreadLocal();
        } else {
            lastServicedRequest = null;
            lastServicedResponse = null;
        }
        sm = StringManager.getManager((String)"org.apache.catalina.core");
        classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
        classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};
        cometClassType = new Class[]{CometEvent.class, CometFilterChain.class};
        classTypeUsedInEvent = new Class[]{CometEvent.class};
    }
}

