/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.StringTokenizer;

public final class Extension {
    private String extensionName = null;
    private String implementationURL = null;
    private String implementationVendor = null;
    private String implementationVendorId = null;
    private String implementationVersion = null;
    private String specificationVendor = null;
    private String specificationVersion = null;
    private boolean fulfilled = false;

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String string) {
        this.extensionName = string;
    }

    public String getImplementationURL() {
        return this.implementationURL;
    }

    public void setImplementationURL(String string) {
        this.implementationURL = string;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public void setImplementationVendor(String string) {
        this.implementationVendor = string;
    }

    public String getImplementationVendorId() {
        return this.implementationVendorId;
    }

    public void setImplementationVendorId(String string) {
        this.implementationVendorId = string;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public void setImplementationVersion(String string) {
        this.implementationVersion = string;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public void setSpecificationVendor(String string) {
        this.specificationVendor = string;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public void setSpecificationVersion(String string) {
        this.specificationVersion = string;
    }

    public void setFulfilled(boolean bl) {
        this.fulfilled = bl;
    }

    public boolean isFulfilled() {
        return this.fulfilled;
    }

    public boolean isCompatibleWith(Extension extension) {
        if (this.extensionName == null) {
            return false;
        }
        if (!this.extensionName.equals(extension.getExtensionName())) {
            return false;
        }
        if (extension.getSpecificationVersion() != null && !this.isNewer(this.specificationVersion, extension.getSpecificationVersion())) {
            return false;
        }
        if (extension.getImplementationVendorId() != null) {
            if (this.implementationVendorId == null) {
                return false;
            }
            if (!this.implementationVendorId.equals(extension.getImplementationVendorId())) {
                return false;
            }
        }
        return extension.getImplementationVersion() == null || this.isNewer(this.implementationVersion, extension.getImplementationVersion());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Extension[");
        stringBuilder.append(this.extensionName);
        if (this.implementationURL != null) {
            stringBuilder.append(", implementationURL=");
            stringBuilder.append(this.implementationURL);
        }
        if (this.implementationVendor != null) {
            stringBuilder.append(", implementationVendor=");
            stringBuilder.append(this.implementationVendor);
        }
        if (this.implementationVendorId != null) {
            stringBuilder.append(", implementationVendorId=");
            stringBuilder.append(this.implementationVendorId);
        }
        if (this.implementationVersion != null) {
            stringBuilder.append(", implementationVersion=");
            stringBuilder.append(this.implementationVersion);
        }
        if (this.specificationVendor != null) {
            stringBuilder.append(", specificationVendor=");
            stringBuilder.append(this.specificationVendor);
        }
        if (this.specificationVersion != null) {
            stringBuilder.append(", specificationVersion=");
            stringBuilder.append(this.specificationVersion);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private boolean isNewer(String string, String string2) throws NumberFormatException {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".", true);
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            if (n < (n2 = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0)) {
                return false;
            }
            if (n > n2) {
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            stringTokenizer2.nextToken();
        }
        return true;
    }
}

