/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp.DelegatingDatabaseMetaData;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.DelegatingStatement;
import org.apache.tomcat.util.compat.JreCompat;

public class DelegatingConnection
extends AbandonedTrace
implements Connection {
    private static final Map<String, ClientInfoStatus> EMPTY_FAILED_PROPERTIES = Collections.emptyMap();
    protected Connection _conn = null;
    protected boolean _closed = false;

    public DelegatingConnection(Connection connection) {
        this._conn = connection;
    }

    public DelegatingConnection(Connection connection, AbandonedConfig abandonedConfig) {
        super(abandonedConfig);
        this._conn = connection;
    }

    public String toString() {
        String string = null;
        Connection connection = this.getInnermostDelegateInternal();
        if (connection != null) {
            try {
                if (connection.isClosed()) {
                    string = "connection is closed";
                } else {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    if (databaseMetaData != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(databaseMetaData.getURL());
                        stringBuffer.append(", UserName=");
                        stringBuffer.append(databaseMetaData.getUserName());
                        stringBuffer.append(", ");
                        stringBuffer.append(databaseMetaData.getDriverName());
                        string = stringBuffer.toString();
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = super.toString();
        }
        return string;
    }

    public Connection getDelegate() {
        return this.getDelegateInternal();
    }

    protected Connection getDelegateInternal() {
        return this._conn;
    }

    public boolean innermostDelegateEquals(Connection connection) {
        Connection connection2 = this.getInnermostDelegateInternal();
        if (connection2 == null) {
            return connection == null;
        }
        return connection2.equals(connection);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Connection connection = this.getInnermostDelegateInternal();
        if (connection == null) {
            return false;
        }
        if (object instanceof DelegatingConnection) {
            DelegatingConnection delegatingConnection = (DelegatingConnection)object;
            return delegatingConnection.innermostDelegateEquals(connection);
        }
        return connection.equals(object);
    }

    public int hashCode() {
        Connection connection = this.getInnermostDelegateInternal();
        if (connection == null) {
            return 0;
        }
        return connection.hashCode();
    }

    public Connection getInnermostDelegate() {
        return this.getInnermostDelegateInternal();
    }

    protected final Connection getInnermostDelegateInternal() {
        Connection connection = this._conn;
        while (connection != null && connection instanceof DelegatingConnection) {
            if (this != (connection = ((DelegatingConnection)connection).getDelegateInternal())) continue;
            return null;
        }
        return connection;
    }

    public void setDelegate(Connection connection) {
        this._conn = connection;
    }

    @Override
    public void close() throws SQLException {
        this.passivate();
        this._conn.close();
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        throw sQLException;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement(n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this._conn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        try {
            this._conn.commit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingDatabaseMetaData(this, this._conn.getMetaData());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return -1;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        try {
            this._conn.rollback();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed || this._conn.isClosed();
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            if (null != this._conn) {
                String string = "";
                try {
                    string = this._conn.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SQLException("Connection " + string + " is closed.");
            }
            throw new SQLException("Connection is null.");
        }
    }

    protected void activate() {
        this._closed = false;
        this.setLastUsed();
        if (this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivate() throws SQLException {
        try {
            List<AbandonedTrace> list = this.getTrace();
            if (list != null) {
                for (AbandonedTrace abandonedTrace : list) {
                    if (abandonedTrace instanceof Statement) {
                        ((Statement)((Object)abandonedTrace)).close();
                        continue;
                    }
                    if (!(abandonedTrace instanceof ResultSet)) continue;
                    ((ResultSet)((Object)abandonedTrace)).close();
                }
                this.clearTrace();
            }
            this.setLastUsed(0L);
            if (this._conn instanceof DelegatingConnection) {
                ((DelegatingConnection)this._conn).passivate();
            }
        }
        finally {
            this._closed = true;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this._conn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this._conn.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement(n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, n));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, nArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, stringArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass()) || this._conn.isWrapperFor(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this._conn.getClass())) {
            return clazz.cast(this._conn);
        }
        return this._conn.unwrap(clazz);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.createBlob();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.createClob();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.createNClob();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.createSQLXML();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.isValid(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.checkOpen();
            this._conn.setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException("Connection is closed.", EMPTY_FAILED_PROPERTIES, (Throwable)sQLException);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkOpen();
            this._conn.setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException("Connection is closed.", EMPTY_FAILED_PROPERTIES, (Throwable)sQLException);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getClientInfo();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkOpen();
        try {
            JreCompat.getInstance().setSchema(this._conn, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        try {
            return JreCompat.getInstance().getSchema(this._conn);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkOpen();
        try {
            JreCompat.getInstance().abort(this._conn, executor);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        try {
            JreCompat.getInstance().setNetworkTimeout(this._conn, executor, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return JreCompat.getInstance().getNetworkTimeout(this._conn);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }
}

