/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp.datasources.UserPassKey;

public abstract class InstanceKeyDataSource
implements DataSource,
Referenceable,
Serializable {
    private static final long serialVersionUID = -4243533936955098795L;
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static final String BAD_TRANSACTION_ISOLATION = "The requested TransactionIsolation level is invalid.";
    protected static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    private volatile boolean getConnectionCalled = false;
    private ConnectionPoolDataSource dataSource = null;
    private String dataSourceName = null;
    private boolean defaultAutoCommit = true;
    private int defaultTransactionIsolation = -1;
    private boolean defaultReadOnly = false;
    private String description = null;
    Properties jndiEnvironment = null;
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    private boolean _testOnBorrow = false;
    private boolean _testOnReturn = false;
    private int _timeBetweenEvictionRunsMillis = (int)Math.min(Integer.MAX_VALUE, -1L);
    private int _numTestsPerEvictionRun = 3;
    private int _minEvictableIdleTimeMillis = (int)Math.min(Integer.MAX_VALUE, 1800000L);
    private boolean _testWhileIdle = false;
    private String validationQuery = null;
    private boolean rollbackAfterValidation = false;
    private boolean testPositionSet = false;
    protected String instanceKey = null;

    protected void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    public abstract void close() throws Exception;

    protected abstract PooledConnectionManager getConnectionManager(UserPassKey var1);

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("InstanceKeyDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.dataSource;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        if (this.dataSource != null) {
            throw new IllegalStateException("The CPDS has already been set. It cannot be altered.");
        }
        this.dataSource = connectionPoolDataSource;
        this.instanceKey = InstanceKeyObjectFactory.registerNewInstance(this);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.assertInitializationAllowed();
        if (this.dataSource != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.dataSourceName != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.dataSourceName = string;
        this.instanceKey = InstanceKeyObjectFactory.registerNewInstance(this);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = bl;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = bl;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.assertInitializationAllowed();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_TRANSACTION_ISOLATION);
            }
        }
        this.defaultTransactionIsolation = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getJndiEnvironment(String string) {
        String string2 = null;
        if (this.jndiEnvironment != null) {
            string2 = this.jndiEnvironment.getProperty(string);
        }
        return string2;
    }

    public void setJndiEnvironment(String string, String string2) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(string, string2);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    @Override
    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(System.out);
        }
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public final boolean isTestOnBorrow() {
        return this.getTestOnBorrow();
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this.assertInitializationAllowed();
        this._testOnBorrow = bl;
        this.testPositionSet = true;
    }

    public final boolean isTestOnReturn() {
        return this.getTestOnReturn();
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this.assertInitializationAllowed();
        this._testOnReturn = bl;
        this.testPositionSet = true;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int n) {
        this.assertInitializationAllowed();
        this._timeBetweenEvictionRunsMillis = n;
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.assertInitializationAllowed();
        this._numTestsPerEvictionRun = n;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int n) {
        this.assertInitializationAllowed();
        this._minEvictableIdleTimeMillis = n;
    }

    public final boolean isTestWhileIdle() {
        return this.getTestWhileIdle();
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public void setTestWhileIdle(boolean bl) {
        this.assertInitializationAllowed();
        this._testWhileIdle = bl;
        this.testPositionSet = true;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.assertInitializationAllowed();
        this.validationQuery = string;
        if (!this.testPositionSet) {
            this.setTestOnBorrow(true);
        }
    }

    public boolean isRollbackAfterValidation() {
        return this.rollbackAfterValidation;
    }

    public void setRollbackAfterValidation(boolean bl) {
        this.assertInitializationAllowed();
        this.rollbackAfterValidation = bl;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Object object;
        if (this.instanceKey == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        try {
            pooledConnectionAndInfo = this.getPooledConnectionAndInfo(string, string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw new SQLException("Cannot borrow connection from pool", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw runtimeException;
        }
        catch (SQLException sQLException) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw sQLException;
        }
        catch (Exception exception) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw new SQLException("Cannot borrow connection from pool", exception);
        }
        if (!(null != string2 ? string2.equals(pooledConnectionAndInfo.getPassword()) : null == pooledConnectionAndInfo.getPassword())) {
            try {
                this.testCPDS(string, string2);
            }
            catch (SQLException sQLException) {
                this.closeDueToException(pooledConnectionAndInfo);
                throw new SQLException("Given password did not match password used to create the PooledConnection.");
            }
            catch (NamingException namingException) {
                throw new SQLException("NamingException encountered connecting to database", namingException);
            }
            object = pooledConnectionAndInfo.getUserPassKey();
            PooledConnectionManager pooledConnectionManager = this.getConnectionManager((UserPassKey)object);
            pooledConnectionManager.invalidate(pooledConnectionAndInfo.getPooledConnection());
            pooledConnectionManager.setPassword(((UserPassKey)object).getPassword());
            pooledConnectionAndInfo = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    pooledConnectionAndInfo = this.getPooledConnectionAndInfo(string, string2);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw new SQLException("Cannot borrow connection from pool", noSuchElementException);
                }
                catch (RuntimeException runtimeException) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw runtimeException;
                }
                catch (SQLException sQLException) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw sQLException;
                }
                catch (Exception exception) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw new SQLException("Cannot borrow connection from pool", exception);
                }
                if (pooledConnectionAndInfo != null && string2 != null && string2.equals(pooledConnectionAndInfo.getPassword())) break;
                if (pooledConnectionAndInfo != null) {
                    pooledConnectionManager.invalidate(pooledConnectionAndInfo.getPooledConnection());
                }
                pooledConnectionAndInfo = null;
            }
            if (pooledConnectionAndInfo == null) {
                throw new SQLException("Cannot borrow connection from pool - password change failure.");
            }
        }
        object = pooledConnectionAndInfo.getPooledConnection().getConnection();
        try {
            this.setupDefaults((Connection)object, string);
            object.clearWarnings();
            return object;
        }
        catch (SQLException sQLException) {
            try {
                object.close();
            }
            catch (Exception exception) {
                this.getLogWriter().println("ignoring exception during close: " + exception);
            }
            throw sQLException;
        }
    }

    protected abstract PooledConnectionAndInfo getPooledConnectionAndInfo(String var1, String var2) throws SQLException;

    protected abstract void setupDefaults(Connection var1, String var2) throws SQLException;

    private void closeDueToException(PooledConnectionAndInfo pooledConnectionAndInfo) {
        if (pooledConnectionAndInfo != null) {
            try {
                pooledConnectionAndInfo.getPooledConnection().getConnection().close();
            }
            catch (Exception exception) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionPoolDataSource testCPDS(String string, String string2) throws NamingException, SQLException {
        Object object;
        ConnectionPoolDataSource connectionPoolDataSource = this.dataSource;
        if (connectionPoolDataSource == null) {
            object = null;
            object = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
            Object object2 = object.lookup(this.dataSourceName);
            if (object2 instanceof ConnectionPoolDataSource) {
                connectionPoolDataSource = (ConnectionPoolDataSource)object2;
            } else {
                throw new SQLException("Illegal configuration: DataSource " + this.dataSourceName + " (" + object2.getClass().getName() + ") doesn't implement javax.sql.ConnectionPoolDataSource");
            }
        }
        object = null;
        try {
            object = string != null ? connectionPoolDataSource.getPooledConnection(string, string2) : connectionPoolDataSource.getPooledConnection();
            if (object == null) {
                throw new SQLException("Cannot connect using the supplied username/password");
            }
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return connectionPoolDataSource;
    }

    protected byte whenExhaustedAction(int n, int n2) {
        byte by = 1;
        if (n <= 0) {
            by = 2;
        } else if (n2 == 0) {
            by = 0;
        }
        return by;
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = this.getClass().getName();
        String string2 = string + "Factory";
        Reference reference = new Reference(string, string2, null);
        reference.add(new StringRefAddr("instanceKey", this.instanceKey));
        return reference;
    }
}

