/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.LimitLatch;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public abstract class AbstractEndpoint<S> {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.net.res");
    private static final int INITIAL_ERROR_DELAY = 50;
    private static final int MAX_ERROR_DELAY = 1600;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected volatile boolean internalExecutor = true;
    private volatile LimitLatch connectionLimitLatch = null;
    protected SocketProperties socketProperties = new SocketProperties();
    protected Acceptor[] acceptors;
    private long executorTerminationTimeoutMillis = 5000L;
    protected int acceptorThreadCount = 0;
    protected int acceptorThreadPriority = 5;
    private int maxConnections = 10000;
    private Executor executor = null;
    private int port;
    private InetAddress address;
    private int backlog = 100;
    private boolean bindOnInit = true;
    private BindState bindState = BindState.UNBOUND;
    private Integer keepAliveTimeout = null;
    private boolean SSLEnabled = false;
    private int minSpareThreads = 10;
    private int maxThreads = 200;
    protected int threadPriority = 5;
    private int maxKeepAliveRequests = 100;
    private int maxHeaderCount = 100;
    private String name = "TP";
    private boolean daemon = true;
    protected HashMap<String, Object> attributes = new HashMap();
    private String algorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String clientAuth = "false";
    private String keystoreFile = System.getProperty("user.home") + "/.keystore";
    private String keystorePass = null;
    private String keystoreType = "JKS";
    private String keystoreProvider = null;
    private String sslProtocol = "TLS";
    private String ciphers = null;
    private String useServerCipherSuitesOrder = "";
    private String keyAlias = null;
    private String keyPass = null;
    private String truststoreFile = System.getProperty("javax.net.ssl.trustStore");
    private String truststorePass = System.getProperty("javax.net.ssl.trustStorePassword");
    private String truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
    private String truststoreProvider = null;
    private String truststoreAlgorithm = null;
    private String trustManagerClassName = null;
    private String crlFile = null;
    private String trustMaxCertLength = null;
    private String sessionCacheSize = null;
    private String sessionTimeout = "86400";
    private String allowUnsafeLegacyRenegotiation = null;
    private String[] sslEnabledProtocolsarr = new String[0];

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public long getExecutorTerminationTimeoutMillis() {
        return this.executorTerminationTimeoutMillis;
    }

    public void setExecutorTerminationTimeoutMillis(long l) {
        this.executorTerminationTimeoutMillis = l;
    }

    public void setAcceptorThreadCount(int n) {
        this.acceptorThreadCount = n;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setAcceptorThreadPriority(int n) {
        this.acceptorThreadPriority = n;
    }

    public int getAcceptorThreadPriority() {
        return this.acceptorThreadPriority;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            if (n == -1) {
                this.releaseConnectionLatch();
            } else {
                limitLatch.setLimit(n);
            }
        } else if (n > 0) {
            this.initializeConnectionLatch();
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getConnectionCount() {
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            return limitLatch.getCount();
        }
        return -1L;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.internalExecutor = executor == null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public abstract int getLocalPort();

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setBacklog(int n) {
        if (n > 0) {
            this.backlog = n;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getBindOnInit() {
        return this.bindOnInit;
    }

    public void setBindOnInit(boolean bl) {
        this.bindOnInit = bl;
    }

    public int getKeepAliveTimeout() {
        if (this.keepAliveTimeout == null) {
            return this.getSoTimeout();
        }
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean bl) {
        this.socketProperties.setTcpNoDelay(bl);
    }

    public int getSoLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setSoLinger(int n) {
        this.socketProperties.setSoLingerTime(n);
        this.socketProperties.setSoLingerOn(n >= 0);
    }

    public int getSoTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setSoTimeout(int n) {
        this.socketProperties.setSoTimeout(n);
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean bl) {
        this.SSLEnabled = bl;
    }

    public void setMinSpareThreads(int n) {
        this.minSpareThreads = n;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            ((java.util.concurrent.ThreadPoolExecutor)executor).setCorePoolSize(n);
        }
    }

    public int getMinSpareThreads() {
        return Math.min(this.getMinSpareThreadsInternal(), this.getMaxThreads());
    }

    private int getMinSpareThreadsInternal() {
        if (this.internalExecutor) {
            return this.minSpareThreads;
        }
        return -1;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            ((java.util.concurrent.ThreadPoolExecutor)executor).setMaximumPoolSize(n);
        }
    }

    public int getMaxThreads() {
        if (this.internalExecutor) {
            return this.maxThreads;
        }
        return -1;
    }

    protected int getMaxThreadsInternal() {
        return this.maxThreads;
    }

    public int getMaxThreadsWithExecutor() {
        Executor executor = this.executor;
        if (this.internalExecutor) {
            return this.maxThreads;
        }
        if (executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            return ((java.util.concurrent.ThreadPoolExecutor)executor).getMaximumPoolSize();
        }
        if (executor instanceof ResizableExecutor) {
            return ((ResizableExecutor)executor).getMaxThreads();
        }
        return -1;
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    public int getThreadPriority() {
        if (this.internalExecutor) {
            return this.threadPriority;
        }
        return -1;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int n) {
        this.maxKeepAliveRequests = n;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int n) {
        this.maxHeaderCount = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    protected abstract boolean getDeferAccept();

    public void setAttribute(String string, Object object) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("abstractProtocolHandler.setAttribute", new Object[]{string, object}));
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        Object object = this.attributes.get(string);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("abstractProtocolHandler.getAttribute", new Object[]{string, object}));
        }
        return object;
    }

    public boolean setProperty(String string, String string2) {
        this.setAttribute(string, string2);
        try {
            if (string.startsWith("socket.")) {
                return IntrospectionUtils.setProperty(this.socketProperties, string.substring("socket.".length()), string2);
            }
            return IntrospectionUtils.setProperty(this, string, string2, false);
        }
        catch (Exception exception) {
            this.getLog().error((Object)("Unable to set attribute \"" + string + "\" to \"" + string2 + "\""), (Throwable)exception);
            return false;
        }
    }

    public String getProperty(String string) {
        return (String)this.getAttribute(string);
    }

    public int getCurrentThreadCount() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getPoolSize();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getPoolSize();
            }
            return -1;
        }
        return -2;
    }

    public int getCurrentThreadsBusy() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getActiveCount();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getActiveCount();
            }
            return -1;
        }
        return -2;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void createExecutor() {
        this.internalExecutor = true;
        TaskQueue taskQueue = new TaskQueue();
        TaskThreadFactory taskThreadFactory = new TaskThreadFactory(this.getName() + "-exec-", this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskQueue, taskThreadFactory);
        taskQueue.setParent((ThreadPoolExecutor)this.executor);
    }

    public void shutdownExecutor() {
        Executor executor = this.executor;
        if (executor != null && this.internalExecutor) {
            this.executor = null;
            if (executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                threadPoolExecutor.shutdownNow();
                long l = this.getExecutorTerminationTimeoutMillis();
                if (l > 0L) {
                    try {
                        threadPoolExecutor.awaitTermination(l, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (threadPoolExecutor.isTerminating()) {
                        this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}));
                    }
                }
                TaskQueue taskQueue = (TaskQueue)threadPoolExecutor.getQueue();
                taskQueue.setParent(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAccept() {
        boolean bl = false;
        for (Acceptor acceptor : this.acceptors) {
            if (acceptor.getState() != Acceptor.AcceptorState.RUNNING) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        Object object = null;
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = this.address == null ? new InetSocketAddress("localhost", this.getLocalPort()) : (this.address.isAnyLocalAddress() ? new InetSocketAddress(AbstractEndpoint.getUnlockAddress(this.address), this.getLocalPort()) : new InetSocketAddress(this.address, this.getLocalPort()));
            object = new Socket();
            int n = 2000;
            int n2 = 2000;
            if (this.getSocketProperties().getSoTimeout() > n) {
                n = this.getSocketProperties().getSoTimeout();
            }
            if (this.getSocketProperties().getUnlockTimeout() > n2) {
                n2 = this.getSocketProperties().getUnlockTimeout();
            }
            ((Socket)object).setSoTimeout(n);
            ((Socket)object).setSoLinger(this.getSocketProperties().getSoLingerOn(), this.getSocketProperties().getSoLingerTime());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("About to unlock socket for:" + inetSocketAddress));
            }
            ((Socket)object).connect(inetSocketAddress, n2);
            if (this.getDeferAccept()) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(((Socket)object).getOutputStream(), "ISO-8859-1");
                outputStreamWriter.write("OPTIONS * HTTP/1.0\r\nUser-Agent: Tomcat wakeup connection\r\n\r\n");
                outputStreamWriter.flush();
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Socket unlock completed for:" + inetSocketAddress));
            }
            long l = 1000L;
            for (Acceptor acceptor : this.acceptors) {
                while (l > 0L && acceptor.getState() == Acceptor.AcceptorState.RUNNING) {
                    Thread.sleep(5L);
                    l -= 5L;
                }
            }
        }
        catch (Exception exception) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("endpoint.debug.unlock", new Object[]{"" + this.getPort()}), (Throwable)exception);
            }
        }
        finally {
            if (object != null) {
                try {
                    ((Socket)object).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static InetAddress getUnlockAddress(InetAddress inetAddress) throws SocketException, UnknownHostException {
        InetAddress inetAddress2 = null;
        InetAddress inetAddress3 = null;
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress4 = enumeration2.nextElement();
                if (!inetAddress.getAddress().getClass().isAssignableFrom(inetAddress4.getClass())) continue;
                if (inetAddress4.isLoopbackAddress()) {
                    if (inetAddress2 != null) continue;
                    inetAddress2 = inetAddress4;
                    continue;
                }
                if (inetAddress4.isLinkLocalAddress()) {
                    if (inetAddress3 != null) continue;
                    inetAddress3 = inetAddress4;
                    continue;
                }
                return inetAddress4;
            }
        }
        if (inetAddress2 != null) {
            return inetAddress2;
        }
        if (inetAddress3 != null) {
            return inetAddress3;
        }
        return InetAddress.getByName("localhost");
    }

    public abstract void processSocketAsync(SocketWrapper<S> var1, SocketStatus var2);

    public abstract void removeWaitingRequest(SocketWrapper<S> var1);

    public abstract void bind() throws Exception;

    public abstract void unbind() throws Exception;

    public abstract void startInternal() throws Exception;

    public abstract void stopInternal() throws Exception;

    public final void init() throws Exception {
        this.testServerCipherSuitesOrderSupport();
        if (this.bindOnInit) {
            this.bind();
            this.bindState = BindState.BOUND_ON_INIT;
        }
    }

    private void testServerCipherSuitesOrderSupport() {
        if (!"".equals(this.getUseServerCipherSuitesOrder().trim()) && !JreCompat.isJre8Available()) {
            throw new UnsupportedOperationException(sm.getString("endpoint.jsse.cannotHonorServerCipherOrder"));
        }
    }

    public final void start() throws Exception {
        if (this.bindState == BindState.UNBOUND) {
            this.bind();
            this.bindState = BindState.BOUND_ON_START;
        }
        this.startInternal();
    }

    protected final void startAcceptorThreads() {
        int n = this.getAcceptorThreadCount();
        this.acceptors = new Acceptor[n];
        for (int i = 0; i < n; ++i) {
            this.acceptors[i] = this.createAcceptor();
            String string = this.getName() + "-Acceptor-" + i;
            this.acceptors[i].setThreadName(string);
            Thread thread = new Thread((Runnable)this.acceptors[i], string);
            thread.setPriority(this.getAcceptorThreadPriority());
            thread.setDaemon(this.getDaemon());
            thread.start();
        }
    }

    protected abstract Acceptor createAcceptor();

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public final void stop() throws Exception {
        this.stopInternal();
        if (this.bindState == BindState.BOUND_ON_START) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public final void destroy() throws Exception {
        if (this.bindState == BindState.BOUND_ON_INIT) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    protected abstract Log getLog();

    public abstract boolean getUseSendfile();

    public abstract boolean getUseComet();

    public abstract boolean getUseCometTimeout();

    public abstract boolean getUsePolling();

    protected LimitLatch initializeConnectionLatch() {
        if (this.maxConnections == -1) {
            return null;
        }
        if (this.connectionLimitLatch == null) {
            this.connectionLimitLatch = new LimitLatch(this.getMaxConnections());
        }
        return this.connectionLimitLatch;
    }

    protected void releaseConnectionLatch() {
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            limitLatch.releaseAll();
        }
        this.connectionLimitLatch = null;
    }

    protected void countUpOrAwaitConnection() throws InterruptedException {
        if (this.maxConnections == -1) {
            return;
        }
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            limitLatch.countUpOrAwait();
        }
    }

    protected long countDownConnection() {
        if (this.maxConnections == -1) {
            return -1L;
        }
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            long l = limitLatch.countDown();
            if (l < 0L) {
                this.getLog().warn((Object)"Incorrect connection count, multiple socket.close called on the same socket.");
            }
            return l;
        }
        return -1L;
    }

    protected int handleExceptionWithDelay(int n) {
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n == 0) {
            return 50;
        }
        if (n < 1600) {
            return n * 2;
        }
        return 1600;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String string) {
        this.clientAuth = string;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String string) {
        this.keystoreFile = string;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String string) {
        this.keystorePass = string;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String string) {
        this.keystoreType = string;
    }

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public void setKeystoreProvider(String string) {
        this.keystoreProvider = string;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String string) {
        this.sslProtocol = string;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String string) {
        this.ciphers = string;
    }

    public String getUseServerCipherSuitesOrder() {
        return this.useServerCipherSuitesOrder;
    }

    public void setUseServerCipherSuitesOrder(String string) {
        this.useServerCipherSuitesOrder = string;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String string) {
        this.keyAlias = string;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String string) {
        this.keyPass = string;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststoreFile(String string) {
        this.truststoreFile = string;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststorePass(String string) {
        this.truststorePass = string;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String string) {
        this.truststoreType = string;
    }

    public String getTruststoreProvider() {
        return this.truststoreProvider;
    }

    public void setTruststoreProvider(String string) {
        this.truststoreProvider = string;
    }

    public String getTruststoreAlgorithm() {
        return this.truststoreAlgorithm;
    }

    public void setTruststoreAlgorithm(String string) {
        this.truststoreAlgorithm = string;
    }

    public String getTrustManagerClassName() {
        return this.trustManagerClassName;
    }

    public void setTrustManagerClassName(String string) {
        this.trustManagerClassName = string;
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String string) {
        this.crlFile = string;
    }

    public String getTrustMaxCertLength() {
        return this.trustMaxCertLength;
    }

    public void setTrustMaxCertLength(String string) {
        this.trustMaxCertLength = string;
    }

    public String getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setSessionCacheSize(String string) {
        this.sessionCacheSize = string;
    }

    public String getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(String string) {
        this.sessionTimeout = string;
    }

    public String getAllowUnsafeLegacyRenegotiation() {
        return this.allowUnsafeLegacyRenegotiation;
    }

    public void setAllowUnsafeLegacyRenegotiation(String string) {
        this.allowUnsafeLegacyRenegotiation = string;
    }

    public String[] getSslEnabledProtocolsArray() {
        return this.sslEnabledProtocolsarr;
    }

    public void setSslEnabledProtocols(String string) {
        if (string == null) {
            this.sslEnabledProtocolsarr = new String[0];
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
            this.sslEnabledProtocolsarr = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    protected void configureUseServerCipherSuitesOrder(SSLEngine sSLEngine) {
        String string = this.getUseServerCipherSuitesOrder().trim();
        if (!"".equals(string)) {
            boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
            JreCompat jreCompat = JreCompat.getInstance();
            jreCompat.setUseServerCipherSuitesOrder(sSLEngine, bl);
        }
    }

    public static abstract class Acceptor
    implements Runnable {
        protected volatile AcceptorState state = AcceptorState.NEW;
        private String threadName;

        public final AcceptorState getState() {
            return this.state;
        }

        protected final void setThreadName(String string) {
            this.threadName = string;
        }

        protected final String getThreadName() {
            return this.threadName;
        }

        public static enum AcceptorState {
            NEW,
            RUNNING,
            PAUSED,
            ENDED;

        }
    }

    protected static enum BindState {
        UNBOUND,
        BOUND_ON_INIT,
        BOUND_ON_START;

    }

    public static interface Handler {
        public Object getGlobal();

        public void recycle();

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG,
            ASYNC_END,
            SENDFILE,
            UPGRADING_TOMCAT,
            UPGRADING,
            UPGRADED;

        }
    }
}

