"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var universe = require("./universe");
/////////////////////// properties
function isDocumentationProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.Api.properties.documentation.name ||
        p.nameId() === universe.Universe08.Api.properties.documentation.name;
}
exports.isDocumentationProperty = isDocumentationProperty;
function isUsagePropertyName(name) {
    return name === universe.Universe10.Trait.properties.usage.name ||
        name === universe.Universe08.Trait.properties.usage.name ||
        name === universe.Universe10.ResourceType.properties.usage.name ||
        name === universe.Universe08.ResourceType.properties.usage.name ||
        name === universe.Universe10.Library.properties.usage.name ||
        name === universe.Universe10.Overlay.properties.usage.name ||
        name === universe.Universe10.Extension.properties.usage.name;
}
exports.isUsagePropertyName = isUsagePropertyName;
function isUsageProperty(p) {
    if (!p) {
        return false;
    }
    return isUsagePropertyName(p.nameId());
}
exports.isUsageProperty = isUsageProperty;
function isMasterRefProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() == universe.Universe10.Overlay.properties.extends.name ||
        p.nameId() == universe.Universe10.Extension.properties.extends.name;
}
exports.isMasterRefProperty = isMasterRefProperty;
function isDescriptionPropertyName(name) {
    return name === universe.Universe10.TypeDeclaration.properties.description.name ||
        name === "description";
    //TODO too long to actually list every element having a description, so a couple of checks to cause compile error, and a simple equals check. Also we do not want to affect performance that much.
}
exports.isDescriptionPropertyName = isDescriptionPropertyName;
function isDescriptionProperty(p) {
    if (!p) {
        return false;
    }
    return isDescriptionPropertyName(p.nameId());
}
exports.isDescriptionProperty = isDescriptionProperty;
function isRequiredPropertyName(name) {
    return name === universe.Universe10.TypeDeclaration.properties.required.name ||
        name === universe.Universe08.Parameter.properties.required.name ||
        name === "required";
    //TODO too long to actually list every element having displayname, so a couple of checks to cause compile error, and a simple equals check. Also we do not want to affect performance that much.
}
exports.isRequiredPropertyName = isRequiredPropertyName;
function isDisplayNamePropertyName(name) {
    return name === universe.Universe10.TypeDeclaration.properties.displayName.name ||
        name === "displayName";
    //TODO too long to actually list every element having displayname, so a couple of checks to cause compile error, and a simple equals check. Also we do not want to affect performance that much.
}
exports.isDisplayNamePropertyName = isDisplayNamePropertyName;
function isDisplayNameProperty(p) {
    if (!p) {
        return false;
    }
    return isDisplayNamePropertyName(p.nameId());
}
exports.isDisplayNameProperty = isDisplayNameProperty;
function isRequiredProperty(p) {
    if (!p) {
        return false;
    }
    return isRequiredPropertyName(p.nameId());
}
exports.isRequiredProperty = isRequiredProperty;
function isTitlePropertyName(name) {
    return name === universe.Universe10.Api.properties.title.name ||
        name === universe.Universe08.Api.properties.title.name ||
        name === universe.Universe10.DocumentationItem.properties.title.name ||
        name === universe.Universe08.DocumentationItem.properties.title.name ||
        name === universe.Universe10.Overlay.properties.title.name ||
        name === universe.Universe10.Extension.properties.title.name;
}
exports.isTitlePropertyName = isTitlePropertyName;
function isTitleProperty(p) {
    if (!p) {
        return false;
    }
    return isTitlePropertyName(p.nameId());
}
exports.isTitleProperty = isTitleProperty;
function isHeadersProperty(p) {
    if (!p) {
        return false;
    }
    return isHeadersPropertyName(p.nameId());
}
exports.isHeadersProperty = isHeadersProperty;
function isHeadersPropertyName(name) {
    return name === universe.Universe08.MethodBase.properties.headers.name ||
        name === universe.Universe08.Response.properties.headers.name ||
        name === universe.Universe08.SecuritySchemePart.properties.headers.name ||
        name === universe.Universe10.MethodBase.properties.headers.name ||
        name === universe.Universe10.Response.properties.headers.name;
}
exports.isHeadersPropertyName = isHeadersPropertyName;
function isFormParametersProperty(p) {
    if (!p) {
        return false;
    }
    return isFormParametersPropertyName(p.nameId());
}
exports.isFormParametersProperty = isFormParametersProperty;
function isFormParametersPropertyName(name) {
    return name === universe.Universe08.BodyLike.properties.formParameters.name;
}
exports.isFormParametersPropertyName = isFormParametersPropertyName;
function isQueryParametersProperty(p) {
    if (!p) {
        return false;
    }
    return isQueryParametersPropertyName(p.nameId());
}
exports.isQueryParametersProperty = isQueryParametersProperty;
function isQueryParametersPropertyName(name) {
    return name === universe.Universe08.MethodBase.properties.queryParameters.name ||
        name === universe.Universe08.SecuritySchemePart.properties.queryParameters.name ||
        name === universe.Universe10.MethodBase.properties.queryParameters.name;
}
exports.isQueryParametersPropertyName = isQueryParametersPropertyName;
function isAnnotationsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.Api.properties.annotations.name ||
        //p.nameId() === universe.Universe10.AbstractSecurityScheme.properties.annotations.name ||
        p.nameId() === universe.Universe10.TypeDeclaration.properties.annotations.name ||
        p.nameId() === universe.Universe10.Response.properties.annotations.name;
}
exports.isAnnotationsProperty = isAnnotationsProperty;
function isAnnotationProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.AnnotationRef.properties.annotation.name;
}
exports.isAnnotationProperty = isAnnotationProperty;
function isIsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.MethodBase.properties.is.name ||
        p.nameId() === universe.Universe08.Method.properties.is.name ||
        p.nameId() === universe.Universe10.ResourceBase.properties.is.name ||
        p.nameId() === universe.Universe08.ResourceType.properties.is.name ||
        p.nameId() === universe.Universe08.Resource.properties.is.name;
}
exports.isIsProperty = isIsProperty;
function isSecuredByProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.Api.properties.securedBy.name ||
        p.nameId() === universe.Universe08.Api.properties.securedBy.name ||
        p.nameId() === universe.Universe10.MethodBase.properties.securedBy.name ||
        p.nameId() === universe.Universe08.MethodBase.properties.securedBy.name ||
        p.nameId() === universe.Universe08.ResourceType.properties.securedBy.name ||
        p.nameId() === universe.Universe08.Resource.properties.securedBy.name ||
        p.nameId() === universe.Universe10.ResourceBase.properties.securedBy.name;
}
exports.isSecuredByProperty = isSecuredByProperty;
function isSecuritySchemesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.LibraryBase.properties.securitySchemes.name ||
        p.nameId() === universe.Universe08.Api.properties.securitySchemes.name;
}
exports.isSecuritySchemesProperty = isSecuritySchemesProperty;
function isSecuritySchemeProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.SecuritySchemeRef.properties.securityScheme.name ||
        p.nameId() === universe.Universe08.SecuritySchemeRef.properties.securityScheme.name;
}
exports.isSecuritySchemeProperty = isSecuritySchemeProperty;
function isTypeOrSchemaProperty(p) {
    return isTypeProperty(p) || isSchemaProperty(p);
}
exports.isTypeOrSchemaProperty = isTypeOrSchemaProperty;
function isTypeProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.AbstractSecurityScheme.properties.type.name ||
        p.nameId() === universe.Universe08.AbstractSecurityScheme.properties.type.name ||
        p.nameId() === universe.Universe08.ResourceType.properties.type.name ||
        p.nameId() === universe.Universe08.Resource.properties.type.name ||
        p.nameId() === universe.Universe08.Parameter.properties.type.name ||
        p.nameId() === universe.Universe10.ResourceBase.properties.type.name ||
        p.nameId() === universe.Universe10.TypeDeclaration.properties.type.name;
}
exports.isTypeProperty = isTypeProperty;
function isItemsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.ArrayTypeDeclaration.properties.items.name;
}
exports.isItemsProperty = isItemsProperty;
function isStructuredItemsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.ArrayTypeDeclaration.properties.structuredItems.name;
}
exports.isStructuredItemsProperty = isStructuredItemsProperty;
function isPropertiesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.ObjectTypeDeclaration.properties.properties.name;
}
exports.isPropertiesProperty = isPropertiesProperty;
function isResponsesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.MethodBase.properties.responses.name ||
        p.nameId() === universe.Universe08.MethodBase.properties.responses.name;
}
exports.isResponsesProperty = isResponsesProperty;
function isProtocolsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.Api.properties.protocols.name ||
        p.nameId() === universe.Universe08.Api.properties.protocols.name ||
        p.nameId() === universe.Universe10.MethodBase.properties.protocols.name;
}
exports.isProtocolsProperty = isProtocolsProperty;
function isNameProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.TypeDeclaration.properties.name.name ||
        p.nameId() === universe.Universe10.TypeDeclaration.properties.name.name ||
        p.nameId() === universe.Universe08.AbstractSecurityScheme.properties.name.name ||
        p.nameId() === universe.Universe10.AbstractSecurityScheme.properties.name.name ||
        p.nameId() === universe.Universe08.Trait.properties.name.name ||
        p.nameId() === universe.Universe10.Trait.properties.name.name ||
        p.nameId() === "name";
    //TODO too long to actually list every element having a name, so a couple of checks to cause compile error, and a simple equals check. Also we do not want to affect performance that much.
}
exports.isNameProperty = isNameProperty;
function isBodyProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.MethodBase.properties.body.name ||
        p.nameId() === universe.Universe08.MethodBase.properties.body.name ||
        p.nameId() === universe.Universe10.Response.properties.body.name ||
        p.nameId() === universe.Universe08.Response.properties.body.name;
}
exports.isBodyProperty = isBodyProperty;
function isDefaultValue(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.TypeDeclaration.properties.default.name ||
        p.nameId() === universe.Universe08.Parameter.properties.default.name;
}
exports.isDefaultValue = isDefaultValue;
function isSchemaProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.BodyLike.properties.schema.name ||
        p.nameId() === universe.Universe08.XMLBody.properties.schema.name ||
        p.nameId() === universe.Universe08.JSONBody.properties.schema.name ||
        p.nameId() === universe.Universe10.TypeDeclaration.properties.schema.name;
}
exports.isSchemaProperty = isSchemaProperty;
function isTraitsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.Api.properties.traits.name ||
        p.nameId() === universe.Universe10.LibraryBase.properties.traits.name;
}
exports.isTraitsProperty = isTraitsProperty;
function isTraitProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.TraitRef.properties.trait.name ||
        p.nameId() === universe.Universe10.TraitRef.properties.trait.name;
}
exports.isTraitProperty = isTraitProperty;
function isResourceTypesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.Api.properties.resourceTypes.name ||
        p.nameId() === universe.Universe10.LibraryBase.properties.resourceTypes.name;
}
exports.isResourceTypesProperty = isResourceTypesProperty;
function isResourceTypeProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.ResourceTypeRef.properties.resourceType.name ||
        p.nameId() === universe.Universe10.ResourceTypeRef.properties.resourceType.name;
}
exports.isResourceTypeProperty = isResourceTypeProperty;
function isFacetsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.TypeDeclaration.properties.facets.name;
}
exports.isFacetsProperty = isFacetsProperty;
function isSchemasProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.Api.properties.schemas.name ||
        p.nameId() === universe.Universe10.LibraryBase.properties.schemas.name;
}
exports.isSchemasProperty = isSchemasProperty;
//export function isSignatureProperty(p:hl.IProperty) : boolean {
//    return p.nameId() === universe.Universe10.Method.properties.signature.name ||
//    p.nameId() === universe.Universe10.Resource.properties.signature.name;
//}
function isResourcesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.Api.properties.resources.name ||
        p.nameId() === universe.Universe08.Api.properties.resources.name ||
        p.nameId() === universe.Universe10.Resource.properties.resources.name ||
        p.nameId() === universe.Universe08.Resource.properties.resources.name;
}
exports.isResourcesProperty = isResourcesProperty;
function isMethodsProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.ResourceBase.properties.methods.name ||
        p.nameId() === universe.Universe08.Resource.properties.methods.name ||
        p.nameId() === universe.Universe08.ResourceType.properties.methods.name;
}
exports.isMethodsProperty = isMethodsProperty;
function isTypesProperty(p) {
    return p && p.nameId() === universe.Universe10.LibraryBase.properties.types.name;
}
exports.isTypesProperty = isTypesProperty;
function isExampleProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.TypeDeclaration.properties.example.name ||
        p.nameId() === "example";
    //TODO too long to actually list every element having an example, so a couple of checks to cause compile error, and a simple equals check. Also we do not want to affect performance that much.
}
exports.isExampleProperty = isExampleProperty;
function isEnumProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.StringTypeDeclaration.properties.enum.name
        || p.nameId() === universe.Universe10.NumberTypeDeclaration.properties.enum.name
        || p.nameId() === universe.Universe08.StringTypeDeclaration.properties.enum.name;
}
exports.isEnumProperty = isEnumProperty;
function isExamplesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.TypeDeclaration.properties.example.name || p.nameId() === universe.Universe10.TypeDeclaration.properties.examples.name;
}
exports.isExamplesProperty = isExamplesProperty;
function isValueProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.GlobalSchema.properties.value.name;
}
exports.isValueProperty = isValueProperty;
function isUriParametersProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.Api.properties.uriParameters.name ||
        p.nameId() === universe.Universe08.ResourceType.properties.uriParameters.name ||
        p.nameId() === universe.Universe08.Resource.properties.uriParameters.name ||
        p.nameId() === universe.Universe10.ResourceBase.properties.uriParameters.name;
}
exports.isUriParametersProperty = isUriParametersProperty;
function isBaseUriParametersProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.Resource.properties.baseUriParameters.name ||
        p.nameId() === universe.Universe08.Api.properties.baseUriParameters.name ||
        p.nameId() === universe.Universe10.Api.properties.baseUriParameters.name;
}
exports.isBaseUriParametersProperty = isBaseUriParametersProperty;
function isRAMLVersionProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe08.Api.properties.RAMLVersion.name ||
        p.nameId() === universe.Universe10.Api.properties.RAMLVersion.name;
}
exports.isRAMLVersionProperty = isRAMLVersionProperty;
function isUsesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.FragmentDeclaration.properties.uses.name;
}
exports.isUsesProperty = isUsesProperty;
function isAnnotationTypesProperty(p) {
    if (!p) {
        return false;
    }
    return p.nameId() === universe.Universe10.LibraryBase.properties.annotationTypes.name;
}
exports.isAnnotationTypesProperty = isAnnotationTypesProperty;
/////////////////////// types
function isMethodType(type) {
    return type.key() == universe.Universe10.Method ||
        type.key() == universe.Universe08.Method;
}
exports.isMethodType = isMethodType;
function isApiType(type) {
    return type.key() == universe.Universe10.Api ||
        type.key() == universe.Universe08.Api;
}
exports.isApiType = isApiType;
function isBooleanTypeType(type) {
    return type.key() == universe.Universe10.BooleanType ||
        type.key() == universe.Universe08.BooleanType;
}
exports.isBooleanTypeType = isBooleanTypeType;
function isMarkdownStringType(type) {
    return type.key() == universe.Universe10.MarkdownString ||
        type.key() == universe.Universe08.MarkdownString;
}
exports.isMarkdownStringType = isMarkdownStringType;
function isResourceType(type) {
    return type.key() == universe.Universe10.Resource ||
        type.key() == universe.Universe08.Resource;
}
exports.isResourceType = isResourceType;
function isTraitType(type) {
    return type.key() == universe.Universe10.Trait ||
        type.key() == universe.Universe08.Trait;
}
exports.isTraitType = isTraitType;
function isTraitRefType(type) {
    return type.key() == universe.Universe10.TraitRef ||
        type.key() == universe.Universe08.TraitRef;
}
exports.isTraitRefType = isTraitRefType;
function isResourceTypeRefType(type) {
    return type.key() == universe.Universe10.ResourceTypeRef ||
        type.key() == universe.Universe08.ResourceTypeRef;
}
exports.isResourceTypeRefType = isResourceTypeRefType;
function isGlobalSchemaType(type) {
    return type.key() == universe.Universe08.GlobalSchema;
}
exports.isGlobalSchemaType = isGlobalSchemaType;
function isSecuritySchemaType(type) {
    return type.key() == universe.Universe10.AbstractSecurityScheme ||
        type.key() == universe.Universe08.AbstractSecurityScheme;
}
exports.isSecuritySchemaType = isSecuritySchemaType;
function isSecuritySchemaTypeDescendant(type) {
    return type.isAssignableFrom(universe.Universe10.AbstractSecurityScheme.name);
}
exports.isSecuritySchemaTypeDescendant = isSecuritySchemaTypeDescendant;
function isSecuritySchemeRefType(type) {
    return type.key() == universe.Universe10.SecuritySchemeRef ||
        type.key() == universe.Universe08.SecuritySchemeRef;
}
exports.isSecuritySchemeRefType = isSecuritySchemeRefType;
function isTypeDeclarationType(type) {
    return type.key() == universe.Universe10.TypeDeclaration;
}
exports.isTypeDeclarationType = isTypeDeclarationType;
function isResponseType(type) {
    return type.key() == universe.Universe10.Response ||
        type.key() == universe.Universe08.Response;
}
exports.isResponseType = isResponseType;
function isBodyLikeType(type) {
    return type.key() == universe.Universe08.BodyLike;
}
exports.isBodyLikeType = isBodyLikeType;
function isOverlayType(type) {
    return type.key() == universe.Universe10.Overlay;
}
exports.isOverlayType = isOverlayType;
function isAnnotationTypeType(type) {
    return false;
}
exports.isAnnotationTypeType = isAnnotationTypeType;
function isResourceTypeType(type) {
    return type.key() == universe.Universe10.ResourceType ||
        type.key() == universe.Universe08.ResourceType;
}
exports.isResourceTypeType = isResourceTypeType;
function isSchemaStringType(type) {
    return type.key() == universe.Universe10.SchemaString ||
        type.key() == universe.Universe08.SchemaString;
}
exports.isSchemaStringType = isSchemaStringType;
function isMethodBaseType(type) {
    return type.key() == universe.Universe10.MethodBase ||
        type.key() == universe.Universe08.MethodBase;
}
exports.isMethodBaseType = isMethodBaseType;
function isLibraryType(type) {
    return type.key() == universe.Universe10.Library;
}
exports.isLibraryType = isLibraryType;
function isStringTypeType(type) {
    return type.key() == universe.Universe10.StringType ||
        type.key() == universe.Universe08.StringType;
}
exports.isStringTypeType = isStringTypeType;
function isAnyTypeType(type) {
    return type.key() == universe.Universe10.AnyType ||
        type.key() == universe.Universe08.AnyType;
}
exports.isAnyTypeType = isAnyTypeType;
function isExampleSpecType(type) {
    return type.key() == universe.Universe10.ExampleSpec;
}
exports.isExampleSpecType = isExampleSpecType;
function isExtensionType(type) {
    return type.key() == universe.Universe10.Extension;
}
exports.isExtensionType = isExtensionType;
function isTypeDeclarationTypeOrDescendant(type) {
    return type.isAssignableFrom(universe.Universe10.TypeDeclaration.name);
}
exports.isTypeDeclarationTypeOrDescendant = isTypeDeclarationTypeOrDescendant;
function isDocumentationType(type) {
    return type.key() == universe.Universe10.DocumentationItem ||
        type.key() == universe.Universe08.DocumentationItem;
}
exports.isDocumentationType = isDocumentationType;
function isAnnotationRefTypeOrDescendant(type) {
    return type.isAssignableFrom(universe.Universe10.AnnotationRef.name);
}
exports.isAnnotationRefTypeOrDescendant = isAnnotationRefTypeOrDescendant;
function isApiSibling(type) {
    return type.isAssignableFrom(universe.Universe10.Api.name) || type.isAssignableFrom(universe.Universe08.Api.name);
}
exports.isApiSibling = isApiSibling;
function isLibraryBaseSibling(type) {
    return type.isAssignableFrom(universe.Universe10.LibraryBase.name);
}
exports.isLibraryBaseSibling = isLibraryBaseSibling;
function isResourceBaseSibling(type) {
    return type.isAssignableFrom(universe.Universe10.ResourceBase.name) || type.isAssignableFrom(universe.Universe08.Resource.name);
}
exports.isResourceBaseSibling = isResourceBaseSibling;
function isObjectTypeDeclarationSibling(type) {
    return type.isAssignableFrom(universe.Universe10.ObjectTypeDeclaration.name);
}
exports.isObjectTypeDeclarationSibling = isObjectTypeDeclarationSibling;
function isArrayTypeDeclarationSibling(type) {
    return type.isAssignableFrom(universe.Universe10.ArrayTypeDeclaration.name);
}
exports.isArrayTypeDeclarationSibling = isArrayTypeDeclarationSibling;
function isTypeDeclarationDescendant(type) {
    return type.isAssignableFrom(universe.Universe10.TypeDeclaration.name);
}
exports.isTypeDeclarationDescendant = isTypeDeclarationDescendant;
function isParameterDescendant(type) {
    return type.isAssignableFrom(universe.Universe08.Parameter.name);
}
exports.isParameterDescendant = isParameterDescendant;
function isStringTypeDeclarationDescendant(type) {
    return type.isAssignableFrom(universe.Universe10.StringTypeDeclaration.name);
}
exports.isStringTypeDeclarationDescendant = isStringTypeDeclarationDescendant;
function isStringTypeDescendant(type) {
    return type.isAssignableFrom(universe.Universe10.StringType.name);
}
exports.isStringTypeDescendant = isStringTypeDescendant;
/**
 * @deprecated use 'isTypeDeclarationDescendant'
 */
function isTypeDeclarationSibling(type) {
    return type.isAssignableFrom(universe.Universe10.TypeDeclaration.name);
}
exports.isTypeDeclarationSibling = isTypeDeclarationSibling;
function isMethodBaseSibling(type) {
    return type.isAssignableFrom(universe.Universe10.MethodBase.name) ||
        type.isAssignableFrom(universe.Universe08.MethodBase.name);
}
exports.isMethodBaseSibling = isMethodBaseSibling;
function isSecuritySchemePartType(type) {
    return type.key() == universe.Universe10.SecuritySchemePart ||
        type.key() == universe.Universe08.SecuritySchemePart;
}
exports.isSecuritySchemePartType = isSecuritySchemePartType;
function isMediaTypeProperty(p) {
    return p.nameId() === universe.Universe08.Api.properties.mediaType.name ||
        p.nameId() === universe.Universe10.Api.properties.mediaType.name;
}
exports.isMediaTypeProperty = isMediaTypeProperty;
function isRAML08Type(type) {
    return type.universe().version() == "RAML08";
}
exports.isRAML08Type = isRAML08Type;
function isRAML10Type(type) {
    return type.universe().version() == "RAML10";
}
exports.isRAML10Type = isRAML10Type;
function isRAML08Node(node) {
    return isRAML08Type(node.definition());
}
exports.isRAML08Node = isRAML08Node;
function isRAML08Attribute(node) {
    return isRAML08Type(node.definition());
}
exports.isRAML08Attribute = isRAML08Attribute;
function isRAML10Node(node) {
    return isRAML10Type(node.definition());
}
exports.isRAML10Node = isRAML10Node;
function isRAML10Attribute(node) {
    return isRAML10Type(node.definition());
}
exports.isRAML10Attribute = isRAML10Attribute;
function isParametersProperty(p) {
    return isQueryParametersProperty(p) || isHeadersProperty(p) || isUriParametersProperty(p) || isBaseUriParametersProperty(p);
}
exports.isParametersProperty = isParametersProperty;
function canBeFragment(type) {
    return isResourceTypeType(type) || isTraitType(type) || isExampleSpecType(type) || isSecuritySchemaType(type) || isTypeDeclarationDescendant(type);
}
exports.canBeFragment = canBeFragment;
//# sourceMappingURL=universeHelpers.js.map