/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.History;
import esmska.data.SMS;
import esmska.data.event.ValuedEventSupport;
import esmska.data.event.ValuedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class Queue {
    public static final int TIMER_TICK = 250;
    private static final Queue instance = new Queue();
    private static final Logger logger = Logger.getLogger(Queue.class.getName());
    private static final History history = History.getInstance();
    private final SortedMap<String, List<SMS>> queue = Collections.synchronizedSortedMap(new TreeMap());
    private final AtomicBoolean paused = new AtomicBoolean();
    private final Map<String, Long> gatewayDelay = Collections.synchronizedMap(new HashMap());
    private final Timer timer = new Timer(250, new TimerListener());
    private ValuedEventSupport<Events, SMS> valuedSupport = new ValuedEventSupport(this);

    public void addValuedListener(ValuedListener<Events, SMS> valuedListener) {
        this.valuedSupport.addValuedListener(valuedListener);
    }

    public void removeValuedListener(ValuedListener<Events, SMS> valuedListener) {
        this.valuedSupport.removeValuedListener(valuedListener);
    }

    private Queue() {
    }

    public static Queue getInstance() {
        return instance;
    }

    public List<SMS> getAll() {
        return this.getAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SMS> getAll(String gatewayName) {
        List list = new ArrayList();
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            if (gatewayName == null) {
                for (Collection collection : this.queue.values()) {
                    list.addAll(collection);
                }
            } else if (this.queue.containsKey(gatewayName)) {
                list = (List)this.queue.get(gatewayName);
            }
        }
        return Collections.unmodifiableList(list);
    }

    public List<SMS> getAllWithStatus(SMS.Status status) {
        return this.getAllWithStatus(status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SMS> getAllWithStatus(SMS.Status status, String gatewayName) {
        Validate.notNull((Object)status, "status is null");
        ArrayList<SMS> list = new ArrayList<SMS>();
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            if (gatewayName == null) {
                for (Collection collection : this.queue.values()) {
                    for (SMS sms : collection) {
                        if (sms.getStatus() != status) continue;
                        list.add(sms);
                    }
                }
            } else if (this.queue.containsKey(gatewayName)) {
                for (SMS sMS : (List)this.queue.get(gatewayName)) {
                    if (sMS.getStatus() != status) continue;
                    list.add(sMS);
                }
            }
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SMS> getAllWithId(String id) {
        Validate.notEmpty(id);
        ArrayList<SMS> list = new ArrayList<SMS>();
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            for (Collection collection : this.queue.values()) {
                for (SMS sms : collection) {
                    if (!StringUtils.equals(sms.getId(), id)) continue;
                    list.add(sms);
                }
            }
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(SMS sms) {
        Validate.notNull(sms);
        sms.setStatus(SMS.Status.WAITING);
        String gateway = sms.getGateway();
        boolean added = false;
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            if (this.queue.containsKey(gateway)) {
                if (!((List)this.queue.get(gateway)).contains(sms)) {
                    added = ((List)this.queue.get(gateway)).add(sms);
                }
            } else {
                ArrayList<SMS> list = new ArrayList<SMS>();
                list.add(sms);
                this.queue.put(gateway, list);
                added = true;
            }
        }
        if (added) {
            logger.log(Level.FINE, "Added new SMS to queue: {0}", sms);
            this.valuedSupport.fireEventOccured(Events.SMS_ADDED, sms);
            this.markIfReady(sms);
            this.timer.start();
        }
        return added;
    }

    public boolean addAll(Collection<SMS> collection) {
        Validate.notNull(collection, "collection is null");
        Validate.noNullElements(collection);
        logger.log(Level.FINE, "Adding {0} new SMS to the queue", collection.size());
        boolean added = false;
        for (SMS sms : collection) {
            if (!this.add(sms)) continue;
            added = true;
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(SMS sms) {
        Validate.notNull(sms);
        String gateway = sms.getGateway();
        boolean removed = false;
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            if (this.queue.containsKey(gateway)) {
                removed = ((List)this.queue.get(gateway)).remove(sms);
            }
            if (removed && ((List)this.queue.get(gateway)).isEmpty()) {
                this.queue.remove(gateway);
                this.gatewayDelay.remove(gateway);
            }
        }
        if (removed) {
            logger.log(Level.FINE, "Removed SMS from queue: {0}", sms);
            this.valuedSupport.fireEventOccured(Events.SMS_REMOVED, sms);
            this.markAllIfReady();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        Validate.notEmpty(id);
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            for (SMS sms : this.getAllWithId(id)) {
                this.remove(sms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        logger.fine("Clearing the queue.");
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            this.queue.clear();
            this.gatewayDelay.clear();
        }
        this.valuedSupport.fireEventOccured(Events.QUEUE_CLEARED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(SMS sms) {
        Validate.notNull(sms);
        String gateway = sms.getGateway();
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            if (this.queue.containsKey(gateway)) {
                return ((List)this.queue.get(gateway)).contains(sms);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            for (Collection collection : this.queue.values()) {
                size += collection.size();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            for (Collection collection : this.queue.values()) {
                if (collection.size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
        if (paused) {
            logger.fine("Queue is now paused");
            this.valuedSupport.fireEventOccured(Events.QUEUE_PAUSED, null);
        } else {
            logger.fine("Queue is now resumed");
            this.valuedSupport.fireEventOccured(Events.QUEUE_RESUMED, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePosition(SMS sms, int positionDelta) {
        Validate.notNull(sms, "sms is null");
        String gateway = sms.getGateway();
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            if (positionDelta == 0 || !this.queue.containsKey(gateway) || !((List)this.queue.get(gateway)).contains(sms)) {
                return;
            }
            logger.log(Level.FINE, "Moving sms {0} with delta {1}", new Object[]{sms, positionDelta});
            List list = (List)this.queue.get(gateway);
            int currentPos = list.indexOf(sms);
            int newPos = currentPos + positionDelta;
            if (newPos < 0) {
                newPos = 0;
            }
            if (newPos > list.size() - 1) {
                newPos = list.size() - 1;
            }
            if (currentPos == newPos) {
                return;
            }
            list.remove(currentPos);
            list.add(newPos, sms);
        }
        this.valuedSupport.fireEventOccured(Events.SMS_POSITION_CHANGED, sms);
        List<SMS> messages = this.getAll(sms.getGateway());
        for (SMS message : messages) {
            if (message.getStatus() != SMS.Status.READY) continue;
            message.setStatus(SMS.Status.WAITING);
        }
        this.markAllIfReady();
    }

    public long getGatewayDelay(String gatewayName) {
        long difference;
        History.Record record;
        Long del = this.gatewayDelay.get(gatewayName);
        if (del != null) {
            return del;
        }
        Gateway gateway = Gateways.getInstance().get(gatewayName);
        long delay = 0L;
        delay = gateway == null ? 0L : (gateway.getDelayBetweenMessages() <= 0 ? 0L : ((record = history.findLastRecord(gatewayName)) == null ? 0L : ((difference = new Date().getTime() - record.getDate().getTime()) < 0L ? 0L : Math.max((long)(gateway.getDelayBetweenMessages() * 1000) - difference, 0L))));
        this.gatewayDelay.put(gatewayName, delay);
        return delay;
    }

    public long getSMSDelay(SMS sms) {
        int opDelay;
        Validate.notNull(sms);
        String gatewayName = sms.getGateway();
        long delay = this.getGatewayDelay(gatewayName);
        List list = (List)this.queue.get(gatewayName);
        if (list == null) {
            return delay;
        }
        int index = list.indexOf(sms);
        Gateway gateway = Gateways.getInstance().get(gatewayName);
        int n = opDelay = gateway != null ? gateway.getDelayBetweenMessages() * 1000 : 0;
        delay = index >= 0 ? (delay += (long)(index * opDelay)) : (delay += (long)(list.size() * opDelay));
        return delay;
    }

    public void setSMSSent(SMS sms) {
        Validate.notNull(sms);
        logger.log(Level.FINE, "Marking sms as successfully sent: {0}", sms);
        sms.setStatus(SMS.Status.SENT);
        this.valuedSupport.fireEventOccured(Events.SMS_SENT, sms);
        this.updateGatewayDelay(sms.getGateway());
        this.remove(sms);
        this.timer.start();
    }

    public void setSMSSending(SMS sms) {
        Validate.notNull(sms);
        logger.log(Level.FINE, "Marking SMS as currently being sent: {0}", sms);
        sms.setStatus(SMS.Status.SENDING);
        this.valuedSupport.fireEventOccured(Events.SENDING_SMS, sms);
    }

    public void setSMSFailed(SMS sms) {
        Validate.notNull(sms);
        logger.log(Level.FINE, "Marking SMS as failed during sending: {0}", sms);
        this.setPaused(true);
        sms.setStatus(SMS.Status.WAITING);
        this.valuedSupport.fireEventOccured(Events.SMS_SENDING_FAILED, sms);
        this.updateGatewayDelay(sms.getGateway());
        this.timer.start();
        this.markIfReady(sms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMS extractSMS(String id, boolean remove) {
        SMS sms;
        Validate.notEmpty(id);
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            List<SMS> fragments = this.getAllWithId(id);
            if (fragments.isEmpty()) {
                return null;
            }
            SMS head = fragments.get(0);
            sms = new SMS(head.getNumber(), "", head.getGateway(), head.getName(), null);
            for (SMS fragment : fragments) {
                sms.setText(sms.getText() + fragment.getText());
            }
            if (remove) {
                this.remove(id);
            }
        }
        return sms;
    }

    private void markIfReady(SMS sms) {
        Validate.notNull(sms);
        long delay = this.getSMSDelay(sms);
        if (sms.getStatus() == SMS.Status.WAITING && delay <= 0L) {
            logger.log(Level.FINER, "Marking SMS as ready: {0}", sms);
            sms.setStatus(SMS.Status.READY);
            this.valuedSupport.fireEventOccured(Events.NEW_SMS_READY, sms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAllIfReady() {
        ArrayList<SMS> ready = new ArrayList<SMS>();
        SortedMap<String, List<SMS>> sortedMap = this.queue;
        synchronized (sortedMap) {
            for (String gateway : this.queue.keySet()) {
                SMS sms;
                long smsDelay;
                long delay = this.getGatewayDelay(gateway);
                if (delay > 0L) continue;
                Iterator iterator = ((List)this.queue.get(gateway)).iterator();
                while (iterator.hasNext() && (smsDelay = this.getSMSDelay(sms = (SMS)iterator.next())) <= 0L) {
                    if (sms.getStatus() != SMS.Status.WAITING) continue;
                    logger.log(Level.FINER, "Marking SMS as ready: {0}", sms);
                    sms.setStatus(SMS.Status.READY);
                    ready.add(sms);
                }
            }
        }
        for (SMS sms : ready) {
            this.valuedSupport.fireEventOccured(Events.NEW_SMS_READY, sms);
        }
    }

    private void updateGatewayDelay(String gatewayName) {
        Validate.notEmpty(gatewayName);
        this.gatewayDelay.remove(gatewayName);
        this.getGatewayDelay(gatewayName);
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean timerNeeded = false;
            boolean checkSMSReady = false;
            Map map = Queue.this.gatewayDelay;
            synchronized (map) {
                Iterator iter = Queue.this.gatewayDelay.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry delay = iter.next();
                    if (!Queue.this.queue.containsKey(delay.getKey())) {
                        iter.remove();
                        continue;
                    }
                    if ((Long)delay.getValue() <= 0L) continue;
                    long newDelay = Math.max((Long)delay.getValue() - 250L, 0L);
                    delay.setValue(newDelay);
                    timerNeeded = true;
                    if ((Long)delay.getValue() > 0L) continue;
                    checkSMSReady = true;
                }
            }
            if (!timerNeeded) {
                Queue.this.timer.stop();
            }
            if (checkSMSReady) {
                Queue.this.markAllIfReady();
            }
        }
    }

    public static enum Events {
        SMS_ADDED,
        SMS_REMOVED,
        QUEUE_CLEARED,
        SMS_POSITION_CHANGED,
        NEW_SMS_READY,
        SENDING_SMS,
        SMS_SENT,
        SMS_SENDING_FAILED,
        QUEUE_PAUSED,
        QUEUE_RESUMED;

    }
}

