/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Contact;
import esmska.data.Contacts;
import esmska.data.History;
import esmska.data.Icons;
import esmska.data.Log;
import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.gui.AboutFrame;
import esmska.gui.ConfigFrame;
import esmska.gui.GatewayComboBox;
import esmska.gui.HistoryFrame;
import esmska.gui.ImportFrame;
import esmska.gui.LogFrame;
import esmska.persistence.ExportManager;
import esmska.utils.ConfirmingFileChooser;
import esmska.utils.L10N;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class Actions {
    private static final Logger logger = Logger.getLogger(Actions.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static Action aboutAction;
    private static ConfigAction configAction;
    private static Action quitAction;
    private static Action historyAction;
    private static Action importAction;
    private static Action exportAction;
    private static Action logAction;

    public static Action getAboutAction() {
        if (aboutAction == null) {
            aboutAction = new AboutAction();
        }
        return aboutAction;
    }

    public static Action getConfigAction() {
        if (configAction == null) {
            configAction = new ConfigAction();
        }
        return configAction;
    }

    public static Action getQuitAction() {
        if (quitAction == null) {
            quitAction = new QuitAction();
        }
        return quitAction;
    }

    public static Action getHistoryAction() {
        if (historyAction == null) {
            historyAction = new HistoryAction();
        }
        return historyAction;
    }

    public static Action getImportAction() {
        if (importAction == null) {
            importAction = new ImportAction();
        }
        return importAction;
    }

    public static Action getExportAction() {
        if (exportAction == null) {
            exportAction = new ExportAction();
        }
        return exportAction;
    }

    public static Action getLogAction() {
        if (logAction == null) {
            logAction = new LogAction();
        }
        return logAction;
    }

    public static Action getQueuePauseAction(boolean showName) {
        return new QueuePauseAction(showName);
    }

    public static Action getSuggestGatewayAction(GatewayComboBox gatewayComboBox, JTextComponent numberComponent) {
        return new SuggestGatewayAction(gatewayComboBox, numberComponent);
    }

    public static Action getBrowseAction(String url) {
        return new BrowseAction(url);
    }

    private static class QueuePauseAction
    extends AbstractAction {
        private final String nameRunning = Actions.access$100().getString("Pause");
        private final String nameRunningLong = Actions.access$100().getString("Pause_queue");
        private final String nameStopped = Actions.access$100().getString("Unpause");
        private final String nameStoppedLong = Actions.access$100().getString("Unpause_queue");
        private final String descRunning = Actions.access$100().getString("QueuePanel.Pause_sending_of_sms_in_the_queue");
        private final String descStopped = Actions.access$100().getString("QueuePanel.Unpause_sending_of_sms_in_the_queue");
        private final ImageIcon pauseIcon = Icons.get("pause-22.png");
        private final ImageIcon pauseIconSmall = Icons.get("pause-16.png");
        private final ImageIcon startIcon = Icons.get("start-22.png");
        private final ImageIcon startIconSmall = Icons.get("start-16.png");
        private static final Queue queue = Queue.getInstance();
        private boolean longName;

        public QueuePauseAction() {
            this(true);
        }

        public QueuePauseAction(boolean longName) {
            this.longName = longName;
            this.setPaused(queue.isPaused());
            this.putValue("MnemonicKey", 80);
            queue.addValuedListener(new ValuedListener<Queue.Events, SMS>(){

                @Override
                public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
                    switch (e.getEvent()) {
                        case QUEUE_PAUSED: {
                            QueuePauseAction.this.setPaused(true);
                            break;
                        }
                        case QUEUE_RESUMED: {
                            QueuePauseAction.this.setPaused(false);
                        }
                    }
                }
            });
            Context.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!StringUtils.equals(evt.getPropertyName(), "everythingLoaded")) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QueuePauseAction.this.updateStatus();
                        }
                    });
                }
            });
            this.updateStatus();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            queue.setPaused(!queue.isPaused());
        }

        private void setPaused(boolean paused) {
            if (paused) {
                if (this.longName) {
                    this.putValue("Name", this.nameStoppedLong);
                } else {
                    this.putValue("Name", this.nameStopped);
                }
                this.putValue("SmallIcon", this.startIconSmall);
                this.putValue("SwingLargeIconKey", this.startIcon);
                this.putValue("ShortDescription", this.descStopped);
                this.putValue("SwingSelectedKey", true);
            } else {
                if (this.longName) {
                    this.putValue("Name", this.nameRunningLong);
                } else {
                    this.putValue("Name", this.nameRunning);
                }
                this.putValue("SmallIcon", this.pauseIconSmall);
                this.putValue("SwingLargeIconKey", this.pauseIcon);
                this.putValue("ShortDescription", this.descRunning);
                this.putValue("SwingSelectedKey", false);
            }
        }

        private void updateStatus() {
            this.setEnabled(Context.everythingLoaded());
        }
    }

    private static class LogAction
    extends AbstractAction {
        private LogFrame logFrame;

        public LogAction() {
            L10N.setLocalizedText(this, l10n.getString("Log_"));
            this.putValue("SwingLargeIconKey", Icons.get("log-48.png"));
            this.putValue("ShortDescription", l10n.getString("Show_application_log"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.fine("Showing Log frame...");
            if (this.logFrame != null) {
                this.logFrame.setVisible(true);
                this.logFrame.requestFocus();
                this.logFrame.toFront();
            } else {
                this.logFrame = new LogFrame();
                this.logFrame.setLocationRelativeTo(Context.mainFrame);
                this.logFrame.setVisible(true);
            }
        }
    }

    public static class SuggestGatewayAction
    extends AbstractAction {
        private GatewayComboBox gatewayComboBox;
        private JTextComponent numberComponent;

        public SuggestGatewayAction(GatewayComboBox gatewayComboBox, JTextComponent numberComponent) {
            L10N.setLocalizedText(this, l10n.getString("Suggest_"));
            this.putValue("ShortDescription", l10n.getString("GatewayComboBox.Choose_suitable_gateway_for_provided_number"));
            if (gatewayComboBox == null || numberComponent == null) {
                throw new IllegalArgumentException("Arguments cant be null");
            }
            this.gatewayComboBox = gatewayComboBox;
            this.numberComponent = numberComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String number = this.numberComponent.getText();
            this.gatewayComboBox.selectNextSuggestedGateway(number);
        }
    }

    private static class ExportAction
    extends AbstractAction {
        private static final FileFilter csvFileFilter = new FileNameExtensionFilter(Actions.access$100().getString("ExportManager.csv_filter"), "csv");
        private static final FileFilter vCardFileFilter = new FileNameExtensionFilter(Actions.access$100().getString("ExportManager.vcard_filter"), "vcf", "vcard");
        private static ConfirmingFileChooser chooser;

        public ExportAction() {
            L10N.setLocalizedText(this, l10n.getString("Contact_export_"));
            this.putValue("ShortDescription", l10n.getString("MainFrame.export_contacts_to_file"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SortedSet<Contact> contacts = Contacts.getInstance().getAll();
            logger.fine("Showing export contacts dialog...");
            String message = l10n.getString("ExportManager.export_info");
            JOptionPane.showMessageDialog(Context.mainFrame, new JLabel(message), l10n.getString("ExportManager.contact_export"), 1, Icons.get("contact-48.png"));
            if (chooser == null) {
                chooser = new ConfirmingFileChooser();
                chooser.setDialogTitle(l10n.getString("ExportManager.choose_export_file"));
                chooser.setDialogType(1);
                chooser.setApproveButtonText(l10n.getString("Save"));
                chooser.addChoosableFileFilter(csvFileFilter);
                chooser.addChoosableFileFilter(vCardFileFilter);
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter(csvFileFilter);
            }
            if (chooser.showSaveDialog(Context.mainFrame) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            logger.finer("File chosen for contacts export: " + file.getAbsolutePath());
            if (file.exists() && !file.canWrite()) {
                logger.info("File '" + file.getAbsolutePath() + "' can't be written");
                JOptionPane.showMessageDialog(Context.mainFrame, MessageFormat.format(l10n.getString("ExportManager.cant_write"), file.getAbsolutePath()), null, 0);
                return;
            }
            logger.finer("About to export " + contacts.size() + " contacts");
            try {
                FileOutputStream out = new FileOutputStream(file);
                if (chooser.getFileFilter() == vCardFileFilter) {
                    ExportManager.exportContactsToVCard(contacts, out);
                } else {
                    ExportManager.exportContacts(contacts, out);
                }
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Could not export contacts to file", ex);
                Log.getInstance().addRecord(new Log.Record(l10n.getString("ExportManager.export_failed"), null, Icons.STATUS_ERROR));
                JOptionPane.showMessageDialog(Context.mainFrame, l10n.getString("ExportManager.export_failed"), null, 0);
                return;
            }
            Log.getInstance().addRecord(new Log.Record(l10n.getString("ExportManager.export_ok"), null, Icons.STATUS_INFO));
            JOptionPane.showMessageDialog(Context.mainFrame, l10n.getString("ExportManager.export_ok!"), null, 1);
        }
    }

    private static class ImportAction
    extends AbstractAction {
        private ImportFrame importFrame;

        public ImportAction() {
            L10N.setLocalizedText(this, l10n.getString("Contact_import_"));
            this.putValue("ShortDescription", l10n.getString("MainFrame.import_contacts_from_other_applications"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.fine("Showing import contacts dialog...");
            if (this.importFrame != null && this.importFrame.isVisible()) {
                this.importFrame.requestFocus();
                this.importFrame.toFront();
            } else {
                this.importFrame = new ImportFrame();
                this.importFrame.setLocationRelativeTo(Context.mainFrame);
                this.importFrame.setVisible(true);
            }
        }
    }

    private static class HistoryListener
    implements ValuedListener<HistoryFrame.Events, History.Record> {
        private HistoryListener() {
        }

        @Override
        public void eventOccured(ValuedEvent<HistoryFrame.Events, History.Record> e) {
            switch (e.getEvent()) {
                case RESEND_SMS: {
                    History.Record record = e.getValue();
                    if (record == null) {
                        return;
                    }
                    SMS sms = new SMS(record.getNumber(), record.getText(), record.getGateway(), record.getName(), null);
                    Context.mainFrame.getContactPanel().clearSelection();
                    Context.mainFrame.getSMSPanel().setSMS(sms);
                }
            }
        }
    }

    private static class HistoryAction
    extends AbstractAction {
        private HistoryFrame historyFrame;

        public HistoryAction() {
            L10N.setLocalizedText(this, l10n.getString("Message_history_"));
            this.putValue("SmallIcon", Icons.get("history-16.png"));
            this.putValue("SwingLargeIconKey", Icons.get("history-32.png"));
            this.putValue("ShortDescription", l10n.getString("MainFrame.show_history_of_sent_messages"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.fine("Showing history frame...");
            if (this.historyFrame != null) {
                this.historyFrame.setVisible(true);
                this.historyFrame.requestFocus();
                this.historyFrame.toFront();
            } else {
                this.historyFrame = new HistoryFrame();
                this.historyFrame.setLocationRelativeTo(Context.mainFrame);
                this.historyFrame.addValuedListener(new HistoryListener());
                this.historyFrame.setVisible(true);
            }
        }
    }

    private static class QuitAction
    extends AbstractAction {
        public QuitAction() {
            L10N.setLocalizedText(this, l10n.getString("Quit_"));
            this.putValue("SmallIcon", Icons.get("exit-16.png"));
            this.putValue("SwingLargeIconKey", Icons.get("exit-32.png"));
            this.putValue("ShortDescription", l10n.getString("MainFrame.Quit_program"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.fine("Quitting application...");
            Context.mainFrame.exit();
        }
    }

    private static class ConfigAction
    extends AbstractAction {
        private ConfigFrame configFrame;

        public ConfigAction() {
            L10N.setLocalizedText(this, l10n.getString("Preferences_"));
            this.putValue("SmallIcon", Icons.get("config-16.png"));
            this.putValue("SwingLargeIconKey", Icons.get("config-32.png"));
            this.putValue("ShortDescription", l10n.getString("MainFrame.configure_program_behaviour"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.fine("Showing config frame...");
            if (this.configFrame != null) {
                this.configFrame.setVisible(true);
                this.configFrame.requestFocus();
                this.configFrame.toFront();
            } else {
                this.configFrame = new ConfigFrame();
                this.configFrame.setLocationRelativeTo(Context.mainFrame);
                this.configFrame.setVisible(true);
            }
        }

        public void showTab(ConfigFrame.Tabs tab) {
            this.actionPerformed(null);
            this.configFrame.switchToTab(tab);
        }
    }

    private static class AboutAction
    extends AbstractAction {
        AboutFrame aboutFrame;

        public AboutAction() {
            L10N.setLocalizedText(this, l10n.getString("About_"));
            this.putValue("ShortDescription", l10n.getString("MainFrame.show_information_about_program"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.fine("Showing About frame...");
            if (this.aboutFrame != null && this.aboutFrame.isVisible()) {
                this.aboutFrame.requestFocus();
                this.aboutFrame.toFront();
            } else {
                this.aboutFrame = new AboutFrame();
                this.aboutFrame.setLocationRelativeTo(Context.mainFrame);
                this.aboutFrame.setVisible(true);
            }
        }
    }

    private static class BrowseAction
    extends AbstractAction {
        private final String url;

        public BrowseAction(String URL2) {
            this.url = URL2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.startsWith(this.url, "esmska://")) {
                if ("esmska://config-gateways".equals(this.url)) {
                    ((ConfigAction)Actions.getConfigAction()).showTab(ConfigFrame.Tabs.GATEWAYS);
                } else {
                    assert (false) : "Unknown internal action link: " + this.url;
                    logger.warning("Unknown internal action link: " + this.url);
                }
                return;
            }
            if (!Desktop.isDesktopSupported()) {
                logger.warning("Running browser not supported, can't browse URL: " + this.url);
                return;
            }
            Desktop desktop = Desktop.getDesktop();
            try {
                logger.fine("Browsing URL: " + this.url);
                desktop.browse(new URL(this.url).toURI());
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Could not browse URL: " + this.url, ex);
            }
        }
    }
}

