/*
 * Decompiled with CFR 0.152.
 */
package esmska.update;

import esmska.Context;
import esmska.data.Icons;
import esmska.data.Log;
import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.Tuple3;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.update.GatewayUpdateInfo;
import esmska.update.HttpDownloader;
import esmska.update.UpdateChecker;
import esmska.utils.L10N;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class UpdateInstaller {
    private static UpdateInstaller instance;
    private static final Logger logger;
    private static final ResourceBundle l10n;
    private static final Log log;
    private final QueueListener queueListener = new QueueListener();
    private ArrayList<Tuple3<GatewayUpdateInfo, String, byte[]>> updateFiles = new ArrayList();

    private UpdateInstaller() {
    }

    public static UpdateInstaller getInstance() {
        if (instance == null) {
            instance = new UpdateInstaller();
        }
        return instance;
    }

    public void installNewGateways() {
        logger.fine("Starting up update installation process...");
        Set<GatewayUpdateInfo> updates = UpdateChecker.getInstance().getGatewayUpdates(true);
        final Downloader dl = new Downloader(updates);
        dl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    assert (dl.isDone()) : "Downloader should have finished";
                    boolean dlOk = dl.isFinishedOk();
                    try {
                        if (dl.get() != null) {
                            UpdateInstaller.this.updateFiles = (ArrayList)dl.get();
                        } else {
                            dlOk = false;
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Could not retrieve downloaded gateway information", ex);
                        dlOk = false;
                    }
                    if (!dlOk) {
                        log.addRecord(new Log.Record(l10n.getString("Update.downloadFailed"), null, Icons.STATUS_ERROR));
                    }
                    if (!UpdateInstaller.this.updateFiles.isEmpty()) {
                        Queue.getInstance().addValuedListener(UpdateInstaller.this.queueListener);
                        UpdateInstaller.this.queueListener.eventOccured((ValuedEvent<Queue.Events, SMS>)null);
                    }
                }
            }
        });
        dl.execute();
    }

    private void doInstallation() {
        boolean installOk = true;
        logger.log(Level.FINER, "Saving {0} updates to disk", this.updateFiles.size());
        for (Tuple3<GatewayUpdateInfo, String, byte[]> script : this.updateFiles) {
            try {
                Context.persistenceManager.saveGateway(script.get1().getFileName(), script.get2(), script.get3());
                logger.log(Level.INFO, "Gateway updated: {0} ({1})", new Object[]{script.get1().getName(), script.get1().getVersion()});
                log.addRecord(new Log.Record(MessageFormat.format(l10n.getString("Update.gwUpdated"), script.get1().getName()), null, Icons.STATUS_UPDATE));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Could not save gateway", ex);
                installOk = false;
            }
        }
        logger.finer("Reloading gateways...");
        try {
            Context.persistenceManager.loadGateways();
            Context.persistenceManager.loadGatewayProperties();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not reload gateways", ex);
            installOk = false;
        }
        if (!installOk) {
            log.addRecord(new Log.Record(l10n.getString("Update.installFailed"), null, Icons.STATUS_ERROR));
        }
    }

    static {
        logger = Logger.getLogger(UpdateInstaller.class.getName());
        l10n = L10N.l10nBundle;
        log = Log.getInstance();
    }

    private class QueueListener
    implements ValuedListener<Queue.Events, SMS> {
        private QueueListener() {
        }

        @Override
        public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
            Queue queue = Queue.getInstance();
            if (!queue.getAllWithStatus(SMS.Status.SENDING).isEmpty()) {
                logger.finer("Messages are still being sent, postponing gateway update");
                return;
            }
            UpdateInstaller.this.doInstallation();
            queue.removeValuedListener(this);
        }
    }

    private class Downloader
    extends SwingWorker<ArrayList<Tuple3<GatewayUpdateInfo, String, byte[]>>, Integer> {
        private boolean finishedOk;
        private Collection<GatewayUpdateInfo> infos;
        private ArrayList<Tuple3<GatewayUpdateInfo, String, byte[]>> scripts = new ArrayList();
        int downloaded = 0;

        public Downloader(Collection<GatewayUpdateInfo> infos) {
            this.infos = infos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ArrayList<Tuple3<GatewayUpdateInfo, String, byte[]>> doInBackground() throws Exception {
            logger.log(Level.FINER, "Downloading {0} updates", this.infos.size());
            for (GatewayUpdateInfo info : this.infos) {
                byte[] icon;
                String script;
                block7: {
                    HttpDownloader dl;
                    block6: {
                        try {
                            logger.log(Level.FINER, "Downloading gateway update: {0} {1}", new Object[]{info.getName(), info.getVersion()});
                            dl = new HttpDownloader(info.getDownloadUrl().toString(), false);
                            dl.execute();
                            script = (String)dl.get();
                            if (dl.isFinishedOk()) break block6;
                        }
                        catch (Throwable throwable) {
                            this.publish(++this.downloaded);
                            throw throwable;
                        }
                        this.publish(++this.downloaded);
                        continue;
                    }
                    icon = null;
                    if (info.getIconUrl() == null) break block7;
                    dl = new HttpDownloader(info.getIconUrl().toString(), true);
                    dl.execute();
                    icon = (byte[])dl.get();
                    if (dl.isFinishedOk()) break block7;
                    this.publish(++this.downloaded);
                    continue;
                }
                Tuple3<GatewayUpdateInfo, String, Object> tuple = new Tuple3<GatewayUpdateInfo, String, Object>(info, script, icon);
                this.scripts.add(tuple);
                this.publish(++this.downloaded);
                if (!this.isCancelled()) continue;
                logger.fine("Updates downloading cancelled");
                this.finishedOk = false;
                return null;
            }
            boolean bl = this.finishedOk = this.infos.size() == this.scripts.size();
            if (!this.finishedOk) {
                logger.warning("Could not download all gateway updates");
            }
            return this.scripts;
        }

        public boolean isFinishedOk() {
            return this.finishedOk;
        }
    }
}

