/*
 * Decompiled with CFR 0.152.
 */
package esmska.update;

import esmska.Context;
import esmska.data.Config;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.persistence.PersistenceManager;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionFile {
    public static final String TAG_ROOT = "esmska";
    public static final String TAG_LAST_VERSION = "latestStableVersion";
    public static final String TAG_LAST_UNSTABLE_VERSION = "latestUnstableVersion";
    public static final String TAG_GATEWAY = "gateway";
    public static final String TAG_NAME = "name";
    public static final String TAG_FILENAME = "fileName";
    public static final String TAG_VERSION = "version";
    public static final String TAG_MIN_VERSION = "minProgramVersion";
    public static final String TAG_DOWNLOAD = "downloadURL";
    public static final String TAG_ICON = "iconURL";
    public static final String TAG_DEPRECATED_GATEWAY = "deprecatedGateway";
    public static final String TAG_REASON = "reason";
    private static final String downloadProtocol = "http";
    private static final String downloadHost = "ripper.profitux.cz";
    private static final String downloadPath = "/esmska/gateways/";
    private static String stableProgramVersion;
    private static String unstableProgramVersion;

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            stableProgramVersion = args[0];
        }
        if (args.length > 1) {
            unstableProgramVersion = args[1];
        }
        Config.setSharedInstance(new Config());
        PersistenceManager.instantiate();
        Context.persistenceManager.loadGateways();
        Gateways gateways = Gateways.getInstance();
        HashSet<Gateway> fakeGateways = new HashSet<Gateway>();
        for (Gateway gateway : gateways.getAll()) {
            if (!Gateways.isFakeGateway(gateway.getName())) continue;
            fakeGateways.add(gateway);
        }
        gateways.removeAll(fakeGateways);
        VersionFile.create(System.out, null, null);
    }

    public static void create(OutputStream out, String stableProgramVersion, String unstableProgramVersion) throws Exception {
        Validate.notNull(out);
        if (stableProgramVersion != null) {
            VersionFile.stableProgramVersion = stableProgramVersion;
        }
        if (unstableProgramVersion != null) {
            VersionFile.unstableProgramVersion = unstableProgramVersion;
        }
        Document doc = VersionFile.createDocument();
        VersionFile.serializetoXML(doc, out);
        out.flush();
    }

    private static Document createDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement(TAG_ROOT);
        doc.appendChild(root);
        Element lastVersion = doc.createElement(TAG_LAST_VERSION);
        lastVersion.setTextContent(stableProgramVersion);
        root.appendChild(lastVersion);
        Element lastUnstableVersion = doc.createElement(TAG_LAST_UNSTABLE_VERSION);
        lastUnstableVersion.setTextContent(unstableProgramVersion);
        root.appendChild(lastUnstableVersion);
        for (Gateway op : Gateways.getInstance().getAll()) {
            Element gateway = doc.createElement(TAG_GATEWAY);
            Element name = doc.createElement(TAG_NAME);
            name.setTextContent(op.getName());
            String opFileName = new File(op.getScript().toURI()).getName().replaceFirst("\\.gateway$", "");
            Element fileName = doc.createElement(TAG_FILENAME);
            fileName.setTextContent(opFileName);
            Element version = doc.createElement(TAG_VERSION);
            version.setTextContent(op.getVersion());
            Element minVersion = doc.createElement(TAG_MIN_VERSION);
            minVersion.setTextContent(op.getMinProgramVersion());
            Element download = doc.createElement(TAG_DOWNLOAD);
            URI dlUri = new URI(downloadProtocol, downloadHost, downloadPath + opFileName + ".gateway", null);
            download.setTextContent(dlUri.toASCIIString());
            Element icon = doc.createElement(TAG_ICON);
            if (op.getIcon() != Icons.GATEWAY_DEFAULT) {
                URI iconUri = new URI(downloadProtocol, downloadHost, downloadPath + opFileName + ".png", null);
                icon.setTextContent(iconUri.toASCIIString());
            }
            gateway.appendChild(name);
            gateway.appendChild(fileName);
            gateway.appendChild(version);
            gateway.appendChild(minVersion);
            gateway.appendChild(download);
            gateway.appendChild(icon);
            root.appendChild(gateway);
        }
        return doc;
    }

    private static void serializetoXML(Document doc, OutputStream output) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
    }

    static {
        unstableProgramVersion = stableProgramVersion = Config.getLatestVersion();
    }
}

