/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.watermarkpack.flamefractal;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.watermarkpack.flamefractal.IteratedFunctionSystem;

public class FractalFlameFactory {
    public static BufferedImage getFractalFlameImage(SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, int width, int height, int iterations, IteratedFunctionSystem ifs) {
        int pos;
        int y;
        int x;
        Color c1_1 = SubstanceColorUtilities.getInterpolatedColor((Color)colorScheme1.getMidColor(), (Color)colorScheme1.getLightColor(), (double)0.6);
        Color c2_1 = colorScheme1.getLightColor();
        Color c3_1 = colorScheme1.getUltraLightColor();
        Color c1_2 = SubstanceColorUtilities.getInterpolatedColor((Color)colorScheme2.getMidColor(), (Color)colorScheme2.getLightColor(), (double)0.6);
        Color c2_2 = colorScheme2.getLightColor();
        Color c3_2 = colorScheme2.getUltraLightColor();
        Color c1 = SubstanceColorUtilities.getInterpolatedColor((Color)c1_1, (Color)c1_2, (double)0.1);
        Color c2 = SubstanceColorUtilities.getInterpolatedColor((Color)c2_1, (Color)c2_2, (double)0.5);
        Color c3 = SubstanceColorUtilities.getInterpolatedColor((Color)c3_1, (Color)c3_2, (double)0.9);
        BufferedImage dst = new BufferedImage(width, height, 2);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        long[] vals = new long[width * height];
        long valMax = 0L;
        int count = 0;
        Point2D.Double bc = new Point2D.Double(Math.random(), Math.random());
        do {
            ifs.apply(bc);
            if (++count <= 20) continue;
            x = (int)((double)width * (1.0 + ((Point2D)bc).getX()) / 2.0);
            y = (int)((double)height * (1.0 + ((Point2D)bc).getY()) / 2.0);
            if (x < 0 || x >= width || y < 0 || y >= height) continue;
            int n = pos = y * width + x;
            vals[n] = vals[n] + 1L;
            valMax = Math.max(valMax, vals[pos]);
        } while (count != iterations);
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                pos = y * width + x;
                double a = (double)vals[pos] / (0.9 * (double)valMax);
                double ai = Math.sqrt(Math.sqrt(a));
                if (ai > 1.0) {
                    ai = 1.0;
                }
                dstBuffer[pos++] = ai < 0.5 ? SubstanceColorUtilities.getInterpolatedRGB((Color)c2, (Color)c1, (double)(2.0 * ai)) : SubstanceColorUtilities.getInterpolatedRGB((Color)c3, (Color)c2, (double)(2.0 * (ai - 0.5)));
            }
        }
        return dst;
    }

    public static BufferedImage getFractalFlameImage(SubstanceColorScheme colorScheme, int width, int height, int iterations, IteratedFunctionSystem ifs) {
        int y;
        int x;
        Color c2 = colorScheme.getLightColor();
        Color c3 = colorScheme.getMidColor();
        BufferedImage dst = new BufferedImage(width, height, 2);
        dst.getGraphics().setColor(Color.black);
        dst.getGraphics().fillRect(0, 0, width, height);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        double[] vals = new double[width * height];
        double valMax = 0.0;
        int count = 0;
        Point2D.Double bc = new Point2D.Double(Math.random(), Math.random());
        do {
            int pos;
            ifs.apply(bc);
            if (++count <= 20) continue;
            x = (int)((double)width * (1.0 + ((Point2D)bc).getX()) / 2.0);
            y = (int)((double)height * (1.0 + ((Point2D)bc).getY()) / 2.0);
            double xc = (double)width * (1.0 + ((Point2D)bc).getX()) / 2.0;
            double yc = (double)height * (1.0 + ((Point2D)bc).getY()) / 2.0;
            double xOver = xc - Math.floor(xc);
            double yOver = yc - Math.floor(yc);
            int xr = (int)Math.ceil(xc);
            int xl = (int)Math.floor(xc);
            int yt = (int)Math.ceil(yc);
            int yb = (int)Math.floor(yc);
            if (xr >= 0 && xr < width && yt >= 0 && yt < height) {
                int n = pos = yt * width + xr;
                vals[n] = vals[n] + xOver * yOver;
                valMax = Math.max(valMax, vals[pos]);
            }
            if (xl >= 0 && xl < width && yt >= 0 && yt < height) {
                int n = pos = yt * width + xl;
                vals[n] = vals[n] + (1.0 - xOver) * yOver;
                valMax = Math.max(valMax, vals[pos]);
            }
            if (xr >= 0 && xr < width && yb >= 0 && yb < height) {
                int n = pos = yb * width + xr;
                vals[n] = vals[n] + xOver * (1.0 - yOver);
                valMax = Math.max(valMax, vals[pos]);
            }
            if (xl < 0 || xl >= width || yb < 0 || yb >= height) continue;
            int n = pos = yb * width + xl;
            vals[n] = vals[n] + (1.0 - xOver) * (1.0 - yOver);
            valMax = Math.max(valMax, vals[pos]);
        } while (count != iterations);
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                int pos = y * width + x;
                double a = vals[pos] / (0.9 * valMax);
                double ai = Math.sqrt(Math.sqrt(a));
                if (ai > 1.0) {
                    ai = 1.0;
                }
                dstBuffer[pos++] = ai < 0.5 ? SubstanceColorUtilities.getInterpolatedRGB((Color)c2, (Color)Color.black, (double)(2.0 * ai)) : SubstanceColorUtilities.getInterpolatedRGB((Color)c3, (Color)c2, (double)(2.0 * (ai - 0.5)));
            }
        }
        return dst;
    }

    public static BufferedImage getFractalFlameImage(int width, int height, int iterations, IteratedFunctionSystem ifs) {
        int y;
        int x;
        Color[] colors = new Color[]{Color.black, Color.blue.darker().darker(), Color.blue.darker(), Color.blue, Color.green, Color.orange, Color.orange, Color.yellow, Color.red};
        BufferedImage dst = new BufferedImage(width, height, 2);
        dst.getGraphics().setColor(Color.black);
        dst.getGraphics().fillRect(0, 0, width, height);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        double[] vals = new double[width * height];
        double valMax = 0.0;
        int count = 0;
        Point2D.Double bc = new Point2D.Double(Math.random(), Math.random());
        do {
            int pos;
            ifs.apply(bc);
            if (++count <= 20) continue;
            x = (int)((double)width * (1.0 + ((Point2D)bc).getX()) / 2.0);
            y = (int)((double)height * (1.0 + ((Point2D)bc).getY()) / 2.0);
            double xc = (double)width * (1.0 + ((Point2D)bc).getX()) / 2.0;
            double yc = (double)height * (1.0 + ((Point2D)bc).getY()) / 2.0;
            double xOver = xc - Math.floor(xc);
            double yOver = yc - Math.floor(yc);
            int xr = (int)Math.ceil(xc);
            int xl = (int)Math.floor(xc);
            int yt = (int)Math.ceil(yc);
            int yb = (int)Math.floor(yc);
            if (xr >= 0 && xr < width && yt >= 0 && yt < height) {
                int n = pos = yt * width + xr;
                vals[n] = vals[n] + xOver * yOver;
                valMax = Math.max(valMax, vals[pos]);
            }
            if (xl >= 0 && xl < width && yt >= 0 && yt < height) {
                int n = pos = yt * width + xl;
                vals[n] = vals[n] + (1.0 - xOver) * yOver;
                valMax = Math.max(valMax, vals[pos]);
            }
            if (xr >= 0 && xr < width && yb >= 0 && yb < height) {
                int n = pos = yb * width + xr;
                vals[n] = vals[n] + xOver * (1.0 - yOver);
                valMax = Math.max(valMax, vals[pos]);
            }
            if (xl < 0 || xl >= width || yb < 0 || yb >= height) continue;
            int n = pos = yb * width + xl;
            vals[n] = vals[n] + (1.0 - xOver) * (1.0 - yOver);
            valMax = Math.max(valMax, vals[pos]);
        } while (count != iterations);
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                int pos = y * width + x;
                double a = vals[pos] / valMax;
                double ai = a > 0.0 ? Math.log(a) / Math.log(20.0) : 1.0;
                if ((ai = -ai) >= 1.0) {
                    ai = 0.9999999999;
                }
                if (ai < 0.0) {
                    ai = 0.0;
                }
                int range = (int)(ai * (double)(colors.length - 1));
                double coef = ai * (double)(colors.length - 1) - (double)range;
                int colorRange = (int)(ai * (double)(colors.length - 1));
                dstBuffer[pos++] = SubstanceColorUtilities.getInterpolatedRGB((Color)colors[colorRange], (Color)colors[colorRange + 1], (double)(1.0 - coef));
            }
        }
        return dst;
    }
}

