/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.AutoDetection;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class BufferLoadRequest
extends BufferIORequest {
    private final boolean untitled;

    public BufferLoadRequest(View view, Buffer buffer, Object object, VFS vFS, String string, boolean bl) {
        super(view, buffer, object, vFS, string);
        this.untitled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _run() {
        block14: {
            try {
                Object object;
                block15: {
                    this.setCancellable(true);
                    if (!this.buffer.isTemporary()) {
                        object = new String[]{this.vfs.getFileName(this.path)};
                        this.setStatus(jEdit.getProperty("vfs.status.load", object));
                        this.setValue(0L);
                    }
                    this.path = this.vfs._canonPath(this.session, this.path, this.view);
                    this.readContents();
                    this.buffer.setNewFile(this.untitled);
                    if (!jEdit.getBooleanProperty("persistentMarkers") || !this.vfs.isMarkersFileSupported()) break block14;
                    object = null;
                    try {
                        Object[] objectArray = new String[]{this.vfs.getFileName(this.path)};
                        if (!this.buffer.isTemporary()) {
                            this.setStatus(jEdit.getProperty("vfs.status.load-markers", objectArray));
                        }
                        this.setCancellable(true);
                        object = this.vfs._createInputStream(this.session, this.markersPath, true, this.view);
                        if (object == null) break block15;
                        BufferLoadRequest.readMarkers(this.buffer, (InputStream)object);
                    }
                    catch (Exception exception) {
                        IOUtilities.closeQuietly((Closeable)object);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        IOUtilities.closeQuietly((Closeable)object);
                        throw throwable;
                    }
                }
                IOUtilities.closeQuietly((Closeable)object);
            }
            catch (InterruptedException interruptedException) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                Object[] objectArray = new Object[]{exception.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", objectArray);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.log(9, this, outOfMemoryError);
                VFSManager.error(this.view, this.path, "out-of-memory-error", null);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
            }
            finally {
                this.endSessionQuietly();
            }
        }
    }

    private InputStream getNakedStream() throws IOException {
        InputStream inputStream = this.vfs._createInputStream(this.session, this.path, false, this.view);
        if (inputStream != null) {
            return inputStream;
        }
        throw new IOException("Unable to get a Stream for " + this.path);
    }

    private long getContentLength() throws IOException {
        VFSFile vFSFile = this.vfs._getFile(this.session, this.path, this.view);
        if (vFSFile != null) {
            return vFSFile.getLength();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedInputStream rewindContentsStream(BufferedInputStream bufferedInputStream, boolean bl) throws IOException {
        try {
            bufferedInputStream.reset();
            return bufferedInputStream;
        }
        catch (IOException iOException) {
            Log.log(5, this, this.path + ": Reopening to rewind the stream");
            bufferedInputStream.close();
            InputStream inputStream = this.getNakedStream();
            try {
                if (bl) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                BufferedInputStream bufferedInputStream2 = AutoDetection.getMarkedStream(inputStream);
                inputStream = null;
                BufferedInputStream bufferedInputStream3 = bufferedInputStream2;
                return bufferedInputStream3;
            }
            finally {
                IOUtilities.closeQuietly(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readContents() throws IOException, InterruptedException {
        block18: {
            Object object;
            boolean bl;
            long l = this.getContentLength();
            BufferedInputStream bufferedInputStream = AutoDetection.getMarkedStream(this.getNakedStream());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl2 = this.buffer.getBooleanProperty("encodingAutodetect");
            if (bl2) {
                bl = AutoDetection.isGzipped(bufferedInputStream);
                bufferedInputStream.reset();
                arrayList.addAll(AutoDetection.getEncodingDetectors());
                arrayList.add(this.buffer.getStringProperty("encoding"));
                object = jEdit.getProperty("fallbackEncodings");
                if (object != null && !((String)object).isEmpty()) {
                    Collections.addAll(arrayList, ((String)object).split("\\s+"));
                }
            } else {
                bl = this.buffer.getBooleanProperty("gzipped");
                arrayList.add(this.buffer.getStringProperty("encoding"));
            }
            if (bl) {
                Log.log(1, this, this.path + ": Stream is gzipped.");
                bufferedInputStream = AutoDetection.getMarkedStream(new GZIPInputStream(bufferedInputStream));
            }
            object = new HashSet();
            Throwable throwable = null;
            for (Object e : arrayList) {
                String string = null;
                if (e instanceof String) {
                    string = (String)e;
                } else if (e instanceof EncodingDetector) {
                    bufferedInputStream = this.rewindContentsStream(bufferedInputStream, bl);
                    string = ((EncodingDetector)e).detectEncoding(new BufferedInputStream(bufferedInputStream));
                } else {
                    Log.log(1, this, "Strange encodingProvider: " + e);
                }
                if (string == null || string.length() <= 0 || object.contains(string)) continue;
                bufferedInputStream = this.rewindContentsStream(bufferedInputStream, bl);
                try {
                    this.read(EncodingServer.getTextReader(bufferedInputStream, string), l, false);
                    if (bl2) {
                        if (bl) {
                            this.buffer.setBooleanProperty("gzipped", true);
                        }
                        this.buffer.setProperty("encoding", string);
                    }
                    return;
                }
                catch (CharConversionException | UnsupportedEncodingException | CharacterCodingException | UnsupportedCharsetException exception) {
                    throwable = exception;
                    Log.log(5, this, this.path + ": " + string + ": " + (Exception)throwable);
                    object.add(string);
                }
            }
            Object[] objectArray = new Object[]{String.join((CharSequence)",", (Iterable<? extends CharSequence>)object), ""};
            objectArray[1] = object.size() < 2 ? throwable.toString() : "See details in Activity Log";
            VFSManager.error(this.view, this.path, "ioerror.encoding-error", objectArray, 5);
            bufferedInputStream = this.rewindContentsStream(bufferedInputStream, bl);
            this.read(EncodingServer.getEncoding(this.buffer.getStringProperty("encoding")).getPermissiveTextReader(bufferedInputStream), l, false);
            if (bl2 && bl) {
                this.buffer.setBooleanProperty("gzipped", true);
            }
            break block18;
            finally {
                bufferedInputStream.close();
            }
        }
    }

    private static void readMarkers(Buffer buffer, InputStream inputStream) throws IOException, InterruptedException {
        buffer.removeAllMarkers();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (string.isEmpty() || string.charAt(0) != '!') continue;
                char c = string.charAt(1);
                int n = string.indexOf(59);
                int n2 = string.indexOf(59, n + 1);
                int n3 = Integer.parseInt(string.substring(n + 1, n2));
                buffer.addMarker(c, n3);
            }
            buffer.setMarkersChanged(false);
        }
    }
}

