/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class MemoryStatusWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        MemoryStatusWidget memoryStatusWidget = new MemoryStatusWidget(view);
        return memoryStatusWidget;
    }

    private static class MemoryStatus
    extends JComponent
    implements ActionListener {
        private final View view;
        private static final String memoryTestStr = "9999/9999MB";
        private final LineMetrics lm;
        private final Color progressForeground;
        private final Color progressBackground;
        private final Integer[] args = new Integer[2];
        private Timer timer;

        MemoryStatus(View view) {
            this.view = view;
            Font font = new JLabel().getFont();
            this.setFont(font);
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            Rectangle2D rectangle2D = font.getStringBounds(memoryTestStr, fontRenderContext);
            Dimension dimension = new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
            this.lm = font.getLineMetrics(memoryTestStr, fontRenderContext);
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.progressForeground = jEdit.getColorProperty("view.status.memory.foreground");
            this.progressBackground = jEdit.getColorProperty("view.status.memory.background");
            this.addMouseListener(new MouseHandler());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.timer = new Timer(2000, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        @Override
        public String getToolTipText() {
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.freeMemory();
            long l2 = runtime.totalMemory();
            long l3 = l2 - l;
            this.args[0] = (int)(l3 / 1024L);
            this.args[1] = (int)(l2 / 1024L);
            return jEdit.getProperty("view.status.memory-tooltip", this.args);
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX(), -20);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Insets insets = new Insets(0, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.freeMemory();
            long l2 = runtime.totalMemory();
            long l3 = l2 - l;
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom - 1;
            float f = (float)l3 / (float)l2;
            graphics.setColor(this.progressBackground);
            graphics.fillRect(insets.left, insets.top, (int)((float)n * f), n2);
            String string = l3 / 1024L / 1024L + "/" + l2 / 1024L / 1024L + "MB";
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            Rectangle2D rectangle2D = graphics.getFont().getStringBounds(string, fontRenderContext);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setClip(insets.left, insets.top, (int)((float)n * f), n2);
            graphics2D.setColor(this.progressForeground);
            graphics2D.drawString(string, insets.left + (int)((double)n - rectangle2D.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
            graphics2D.setClip(insets.left + (int)((float)n * f), insets.top, this.getWidth() - insets.left - (int)((float)n * f), n2);
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(string, insets.left + ((int)((double)n - rectangle2D.getWidth()) >> 1), (int)((float)insets.top + this.lm.getAscent()));
            graphics2D.dispose();
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    jEdit.showMemoryDialog(MemoryStatus.this.view);
                    MemoryStatus.this.repaint();
                }
            }
        }
    }

    private static class MemoryStatusWidget
    implements Widget {
        private final MemoryStatus memoryStatus;

        MemoryStatusWidget(View view) {
            this.memoryStatus = new MemoryStatus(view);
        }

        @Override
        public JComponent getComponent() {
            return this.memoryStatus;
        }
    }
}

