/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;

class CachePluginList {
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    private final String id;

    CachePluginList(String string) {
        this.id = string;
    }

    @Nullable
    String getPluginList() {
        if (!this.id.equals(jEdit.getProperty("plugin-manager.mirror.cached-id"))) {
            return null;
        }
        String string = this.getCacheFile().filter(Files::isReadable).filter(CachePluginList::isAcceptableCache).map(this::readCache).orElse(null);
        return string;
    }

    void saveCache(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        this.getCacheFile().ifPresent(path -> {
            try {
                Files.writeString(path, charSequence, new OpenOption[0]);
            }
            catch (IOException iOException) {
                Log.log(9, this, "Error saving cache data", iOException);
            }
        });
    }

    private Optional<Path> getCacheFile() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return Optional.empty();
        }
        return Optional.of(Path.of(string, "pluginMgr-Cached.xml"));
    }

    private static boolean isAcceptableCache(Path path) {
        try {
            FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            Instant instant = fileTime.toInstant();
            long l = (long)jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 5) * 60000L;
            Instant instant2 = Instant.now().minusMillis(l);
            return instant.isAfter(instant2);
        }
        catch (IOException iOException) {
            Log.log(9, PluginList.class, "Unable to get last modified time for " + path, iOException);
            return false;
        }
    }

    void deleteCache() {
        this.getCacheFile().ifPresent(path -> {
            Log.log(1, PluginList.class, "Unable to read plugin list, deleting cached file and try again");
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                Log.log(7, PluginList.class, "Error while deleting cache file" + path, iOException);
            }
        });
    }

    private String readCache(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException iOException) {
            Log.log(9, PluginList.class, "Unable to read stream", iOException);
            this.deleteCache();
            return null;
        }
    }
}

