/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.NavigationPage;
import net.sf.juife.NavigationPane;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.DbDirectoryTreeNode;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.classic.DbSearchPage;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ToolbarButton;
import org.jsampler.view.std.JSInstrumentsDbColumnPreferencesDlg;
import org.jsampler.view.std.JSInstrumentsDbTable;
import org.jsampler.view.std.JSInstrumentsDbTree;
import org.jsampler.view.std.JSLostFilesDlg;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;

public class InstrumentsDbFrame
extends JFrame {
    private final ToolBar toolbar;
    private final JMenuBar menuBar = new JMenuBar();
    private final JSInstrumentsDbTree instrumentsDbTree;
    private final SidePane sidePane;
    private final JSplitPane splitPane;
    private final MainPane mainPane;
    private JMenu loadInstrumentMenu;
    private JMenu addToMidiMapMenu;
    private JMenu addToOrchestraMenu;
    private final EventHandler eventHandler = new EventHandler();

    public InstrumentsDbFrame() {
        this.setTitle(ClassicI18n.i18n.getLabel("InstrumentsDbFrame.title"));
        if (Res.appIcon != null) {
            this.setIconImage(Res.appIcon.getImage());
        }
        this.instrumentsDbTree = new JSInstrumentsDbTree(CC.getInstrumentsDbTreeModel());
        this.sidePane = new SidePane();
        this.mainPane = new MainPane();
        this.instrumentsDbTree.setSelectedDirectory("/");
        this.toolbar = new ToolBar();
        this.getContentPane().add((Component)this.toolbar, "North");
        this.splitPane = new JSplitPane(1, true, this.sidePane, this.mainPane);
        this.splitPane.setDividerSize(3);
        this.splitPane.setDividerLocation(200);
        this.addMenu();
        this.pack();
        this.setSavedSize();
        this.getContentPane().add(this.splitPane);
        this.mainPane.getInstrumentsTable().loadColumnWidths();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InstrumentsDbFrame.this.onWindowClose();
            }
        });
        this.installKeyboardListeners();
    }

    private void addMenu() {
        this.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("instrumentsdb.actions"));
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().createDirectoryAction);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().deleteAction);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu(ClassicI18n.i18n.getMenuLabel("instrumentsdb.actions.addInstruments"));
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().addInstrumentsFromFileAction);
        jMenuItem.setIcon(null);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().addInstrumentsFromDirAction);
        jMenuItem.setIcon(null);
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(ClassicI18n.i18n.getMenuLabel("instrumentsdb.actions.format"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ClassicI18n.i18n.getMessage("InstrumentsDbFrame.formatDatabase?");
                if (!HF.showYesNoDialog(InstrumentsDbFrame.this, string)) {
                    return;
                }
                CC.getTaskQueue().add(new InstrumentsDb.Format());
            }
        });
        jMenuItem = new JMenuItem(ClassicI18n.i18n.getMenuLabel("instrumentsdb.actions.checkForLostFiles"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new JSLostFilesDlg(InstrumentsDbFrame.this).setVisible(true);
            }
        });
        jMenu.addSeparator();
        this.loadInstrumentMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("instrumentsdb.actions.loadInstrument"));
        jMenu.add(this.loadInstrumentMenu);
        this.mainPane.getInstrumentsTable().registerLoadInstrumentMenus(this.loadInstrumentMenu);
        this.addToMidiMapMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("instrumentsdb.actions.addToMidiMap"));
        jMenu.add(this.addToMidiMapMenu);
        this.mainPane.getInstrumentsTable().registerAddToMidiMapMenu(this.addToMidiMapMenu);
        this.addToOrchestraMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("instrumentsdb.actions.addToOrchestra"));
        jMenu.add(this.addToOrchestraMenu);
        this.mainPane.getInstrumentsTable().registerAddToOrchestraMenu(this.addToOrchestraMenu);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().reloadAction);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().propertiesAction);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 8));
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("instrumentsdb.edit"));
        this.menuBar.add(jMenu);
        int n = CC.getViewConfig().getDefaultModKey();
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().cutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, n));
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().copyAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().pasteAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, n));
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(ClassicI18n.i18n.getMenuLabel("instrumentsdb.edit.find"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, n));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InstrumentsDbFrame.this.toolbar.btnFind.isSelected()) {
                    return;
                }
                String string = InstrumentsDbFrame.this.instrumentsDbTree.getSelectedDirectoryPath();
                if (string != null) {
                    InstrumentsDbFrame.this.sidePane.searchPage.setSearchPath(string);
                }
                InstrumentsDbFrame.this.toolbar.btnFind.doClick(0);
            }
        });
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().renameAction);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.mainPane.getInstrumentsTable().changeDescriptionAction);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("instrumentsdb.go"));
        this.menuBar.add(jMenu);
        this.instrumentsDbTree.actionGoUp.putValue("SmallIcon", Res.iconGoUp22);
        jMenuItem = new JMenuItem(this.instrumentsDbTree.actionGoUp);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, 8));
        jMenu.add(jMenuItem);
        this.instrumentsDbTree.actionGoBack.putValue("SmallIcon", Res.iconGoBack22);
        jMenuItem = new JMenuItem(this.instrumentsDbTree.actionGoBack);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 8));
        jMenu.add(jMenuItem);
        this.instrumentsDbTree.actionGoForward.putValue("SmallIcon", Res.iconGoForward22);
        jMenuItem = new JMenuItem(this.instrumentsDbTree.actionGoForward);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 8));
        jMenu.add(jMenuItem);
    }

    private void installKeyboardListeners() {
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(8, 0), "goUp");
        this.getRootPane().getActionMap().put("goUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!((InstrumentsDbFrame)InstrumentsDbFrame.this).instrumentsDbTree.actionGoUp.isEnabled()) {
                    return;
                }
                ((InstrumentsDbFrame)InstrumentsDbFrame.this).instrumentsDbTree.actionGoUp.actionPerformed(null);
            }
        });
    }

    private void onWindowClose() {
        boolean bl = (this.getExtendedState() & 6) == 6;
        ClassicPrefs.setWindowMaximized("InstrumentsDbFrame", bl);
        if (bl) {
            return;
        }
        StdUtils.saveWindowBounds("InstrumentsDbFrame", this.getBounds());
        int n = this.splitPane.getDividerLocation();
        ClassicPrefs.preferences().setIntProperty("InstrumentsDbFrame.dividerLocation", n);
        this.mainPane.getInstrumentsTable().saveColumnsVisibleState();
        this.mainPane.getInstrumentsTable().saveColumnWidths();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        super.setVisible(bl);
        if (ClassicPrefs.getWindowMaximized("InstrumentsDbFrame")) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    private void setDefaultSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        this.setBounds(100, 100, (int)d - 200, (int)d2 - 200);
    }

    private void setSavedSize() {
        Rectangle rectangle = StdUtils.getWindowBounds("InstrumentsDbFrame");
        if (rectangle == null) {
            this.setDefaultSize();
            return;
        }
        this.setBounds(rectangle);
        if (ClassicPrefs.getWindowMaximized("InstrumentsDbFrame")) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    private void addSidePane() {
        this.getContentPane().remove(this.mainPane);
        this.splitPane.setRightComponent(this.mainPane);
        this.getContentPane().add(this.splitPane);
        int n = ClassicPrefs.preferences().getIntProperty("InstrumentsDbFrame.dividerLocation");
        if (n != 0) {
            this.splitPane.setDividerLocation(n);
        }
    }

    private void removeSidePane() {
        int n = this.splitPane.getDividerLocation();
        ClassicPrefs.preferences().setIntProperty("InstrumentsDbFrame.dividerLocation", n);
        this.getContentPane().remove(this.splitPane);
        this.getContentPane().add(this.mainPane);
    }

    public JSInstrumentsDbTree getInstrumentsDbTree() {
        return this.instrumentsDbTree;
    }

    public void setSearchResults(DbDirectoryInfo[] dbDirectoryInfoArray) {
        this.setSearchResults(dbDirectoryInfoArray, null);
    }

    public void setSearchResults(DbInstrumentInfo[] dbInstrumentInfoArray) {
        this.setSearchResults(null, dbInstrumentInfoArray);
    }

    public void setSearchResults(DbDirectoryInfo[] dbDirectoryInfoArray, DbInstrumentInfo[] dbInstrumentInfoArray) {
        DbDirectoryTreeNode dbDirectoryTreeNode = this.mainPane.getSearchResultsNode();
        dbDirectoryTreeNode.removeAllDirectories();
        dbDirectoryTreeNode.removeAllInstruments();
        if (dbInstrumentInfoArray != null) {
            for (DbInstrumentInfo dbInstrumentInfo : dbInstrumentInfoArray) {
                dbInstrumentInfo.setShowAbsolutePath(true);
            }
            dbDirectoryTreeNode.addInstruments(dbInstrumentInfoArray);
        }
        if (dbDirectoryInfoArray != null) {
            Object[] objectArray = new DbDirectoryTreeNode[dbDirectoryInfoArray.length];
            for (int i = 0; i < dbDirectoryInfoArray.length; ++i) {
                DbDirectoryInfo dbDirectoryInfo = dbDirectoryInfoArray[i];
                dbDirectoryInfo.setShowAbsolutePath(true);
                objectArray[i] = new DbDirectoryTreeNode(dbDirectoryInfo);
            }
            dbDirectoryTreeNode.addDirectories((DbDirectoryTreeNode[])objectArray);
        }
        this.mainPane.showSearchResultsNode();
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    class PreferencesDlg
    extends JSInstrumentsDbColumnPreferencesDlg {
        PreferencesDlg() {
            super((Frame)InstrumentsDbFrame.this, InstrumentsDbFrame.this.mainPane.instrumentsTable);
        }
    }

    private class EventHandler
    implements ListSelectionListener {
        private EventHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class SidePane
    extends NavigationPane {
        private final NavigationPage foldersPage = new NavigationPage();
        private final DbSearchPage searchPage = new DbSearchPage(InstrumentsDbFrame.this);

        SidePane() {
            this.setTitlebarVisiblie(false);
            this.foldersPage.setTitle(ClassicI18n.i18n.getLabel("InstrumentsDbFrame.folders"));
            this.foldersPage.setLayout(new BorderLayout());
            this.foldersPage.add(new JScrollPane(InstrumentsDbFrame.this.instrumentsDbTree));
            NavigationPage[] navigationPageArray = new NavigationPage[]{this.foldersPage, this.searchPage};
            this.setPages(navigationPageArray);
            this.showFoldersPage();
        }

        public void showFoldersPage() {
            this.getModel().addPage(this.foldersPage);
        }

        public void showSearchPage() {
            this.getModel().addPage(this.searchPage);
        }
    }

    class MainPane
    extends JPanel {
        private final JSInstrumentsDbTable instrumentsTable;
        private final DbDirectoryTreeNode searchResultsNode;

        MainPane() {
            this.instrumentsTable = new JSInstrumentsDbTable(InstrumentsDbFrame.this.instrumentsDbTree, "InstrumentsDbFrame.");
            this.searchResultsNode = new DbDirectoryTreeNode(null);
            this.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.instrumentsTable);
            this.add(jScrollPane);
            this.instrumentsTable.reloadAction.putValue("SmallIcon", Res.iconReload22);
            this.instrumentsTable.createDirectoryAction.putValue("SmallIcon", Res.iconNew16);
            this.instrumentsTable.getParent().setBackground(this.instrumentsTable.getBackground());
            this.searchResultsNode.setDetached(true);
        }

        public JSInstrumentsDbTable getInstrumentsTable() {
            return this.instrumentsTable;
        }

        public DbDirectoryTreeNode getSearchResultsNode() {
            return this.searchResultsNode;
        }

        public void showSearchResultsNode() {
            InstrumentsDbFrame.this.instrumentsDbTree.clearSelection();
            this.instrumentsTable.setParentDirectoryNode(this.searchResultsNode);
        }
    }

    class ToggleButton
    extends JToggleButton {
        ToggleButton() {
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ToggleButton.this.setBorderPainted(ToggleButton.this.isSelected());
                }
            });
        }
    }

    class ToolBar
    extends JToolBar {
        private final ToggleButton btnFolders;
        private final ToggleButton btnFind;
        private final ToolbarButton btnGoUp;
        private final ToolbarButton btnGoBack;
        private final ToolbarButton btnGoForward;
        private final ToolbarButton btnReload;
        private final ToolbarButton btnPreferences;

        public ToolBar() {
            super(ClassicI18n.i18n.getLabel("InstrumentsDbFrame.ToolbarBar.name"));
            this.btnFolders = new ToggleButton();
            this.btnFind = new ToggleButton();
            this.btnGoUp = new ToolbarButton(((InstrumentsDbFrame)InstrumentsDbFrame.this).instrumentsDbTree.actionGoUp);
            this.btnGoBack = new ToolbarButton(((InstrumentsDbFrame)InstrumentsDbFrame.this).instrumentsDbTree.actionGoBack);
            this.btnGoForward = new ToolbarButton(((InstrumentsDbFrame)InstrumentsDbFrame.this).instrumentsDbTree.actionGoForward);
            this.btnReload = new ToolbarButton(((InstrumentsDbFrame)InstrumentsDbFrame.this).mainPane.getInstrumentsTable().reloadAction);
            this.btnPreferences = new ToolbarButton();
            this.setFloatable(false);
            this.btnFolders.setIcon(Res.iconFolderOpen22);
            this.btnFolders.doClick(0);
            this.btnFind.setIcon(Res.iconFind22);
            this.btnPreferences.setIcon(Res.iconPreferences22);
            this.add(this.btnFolders);
            this.add(this.btnFind);
            this.addSeparator();
            this.add(this.btnGoBack);
            this.add(this.btnGoForward);
            this.add(this.btnGoUp);
            this.add(this.btnReload);
            this.addSeparator();
            this.add(this.btnPreferences);
            this.btnFolders.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ToolBar.this.btnFolders.isSelected() && !ToolBar.this.btnFind.isSelected()) {
                        InstrumentsDbFrame.this.removeSidePane();
                    }
                    if (!ToolBar.this.btnFolders.isSelected()) {
                        return;
                    }
                    if (ToolBar.this.btnFind.isSelected()) {
                        ToolBar.this.btnFind.doClick(0);
                    } else {
                        InstrumentsDbFrame.this.addSidePane();
                    }
                    InstrumentsDbFrame.this.sidePane.showFoldersPage();
                }
            });
            this.btnFind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ToolBar.this.btnFolders.isSelected() && !ToolBar.this.btnFind.isSelected()) {
                        InstrumentsDbFrame.this.removeSidePane();
                    }
                    if (!ToolBar.this.btnFind.isSelected()) {
                        return;
                    }
                    if (ToolBar.this.btnFolders.isSelected()) {
                        ToolBar.this.btnFolders.doClick(0);
                    } else {
                        InstrumentsDbFrame.this.addSidePane();
                    }
                    InstrumentsDbFrame.this.sidePane.showSearchPage();
                }
            });
            this.btnPreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new PreferencesDlg().setVisible(true);
                }
            });
        }
    }
}

