/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jsampler.event.MidiInstrumentEvent;
import org.jsampler.event.MidiInstrumentListener;
import org.linuxsampler.lscp.MidiInstrumentInfo;

public class MidiInstrument {
    private MidiInstrumentInfo info;
    private final Vector<MidiInstrumentListener> listeners = new Vector();
    private static int firstProgramNumber = 0;

    public MidiInstrument() {
    }

    public MidiInstrument(MidiInstrumentInfo midiInstrumentInfo) {
        this.info = midiInstrumentInfo;
    }

    public void addMidiInstrumentListener(MidiInstrumentListener midiInstrumentListener) {
        this.listeners.add(midiInstrumentListener);
    }

    public void removeMidiInstrumentListener(MidiInstrumentListener midiInstrumentListener) {
        this.listeners.remove(midiInstrumentListener);
    }

    public String getName() {
        return this.info.getName();
    }

    public void setName(String string) {
        this.info.setName(string);
        this.fireInfoChanged();
    }

    public MidiInstrumentInfo getInfo() {
        return this.info;
    }

    public void setInfo(MidiInstrumentInfo midiInstrumentInfo) {
        this.info = midiInstrumentInfo;
        this.fireInfoChanged();
    }

    public static int getFirstProgramNumber() {
        return firstProgramNumber;
    }

    public static void setFirstProgramNumber(int n) {
        firstProgramNumber = n;
    }

    public boolean equals(Object object) {
        if (object == null || this.getInfo() == null) {
            return false;
        }
        if (!(object instanceof MidiInstrument)) {
            return false;
        }
        MidiInstrument midiInstrument = (MidiInstrument)object;
        return this.getInfo().equals(midiInstrument.getInfo());
    }

    public String toString() {
        int n = MidiInstrument.getFirstProgramNumber() + this.getInfo().getMidiProgram();
        return String.valueOf(n) + ". " + this.getName();
    }

    private void fireInfoChanged() {
        final MidiInstrumentEvent midiInstrumentEvent = new MidiInstrumentEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MidiInstrument.this.fireInfoChanged(midiInstrumentEvent);
            }
        });
    }

    private void fireInfoChanged(MidiInstrumentEvent midiInstrumentEvent) {
        for (MidiInstrumentListener midiInstrumentListener : this.listeners) {
            midiInstrumentListener.instrumentInfoChanged(midiInstrumentEvent);
        }
    }
}

